# Generated by Django 4.2.11 on 2024-03-227 12:15

from django.db import migrations
from django.db.migrations import RunPython
from edc_utils import get_utcnow
from edc_utils.get_uuid import get_uuid
from tqdm import tqdm


def gen_safe_save_id(apps, schema_editor):
    model_cls = apps.get_model("effect_screening.subjectscreening")
    qs = model_cls.objects.all()
    total = qs.count()
    update_count = 0

    print(f"\nAdding `safe_save_id` to {total} Subject Screening instances ...")
    for obj in tqdm(qs, total=total):
        if not obj.safe_save_id:
            obj.safe_save_id = get_uuid()
            obj.modified = get_utcnow()
            obj.user_modified = __name__ if len(__name__) <= 50 else f"{__name__[:46]}..."
            obj.save(update_fields=["safe_save_id", "modified", "user_modified"])
            update_count += 1
    print(
        f"{update_count}/{total} Subject Screening instances updated to include `safe_save_id`."
    )
    print("Done.")


class Migration(migrations.Migration):

    dependencies = [
        ("effect_screening", "0037_historicalsubjectscreening_safe_save_id_and_more"),
    ]

    operations = [RunPython(gen_safe_save_id)]
