# Generated by Django 3.2.13 on 2022-06-14 11:23

from django.db import migrations, models
import edc_model.models.fields.date_estimated
import edc_model.validators.date


class Migration(migrations.Migration):
    dependencies = [
        ("effect_subject", "0069_auto_20220527_1351"),
    ]

    operations = [
        migrations.AddField(
            model_name="arvhistory",
            name="hiv_dx_date",
            field=models.DateField(
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date HIV diagnosis first known",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="hiv_dx_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedField(
                choices=[
                    ("-", "No"),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="-",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is this date estimated?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="hiv_dx_date",
            field=models.DateField(
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date HIV diagnosis first known",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="hiv_dx_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedField(
                choices=[
                    ("-", "No"),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="-",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is this date estimated?",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="initial_art_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="When did the patient <u>start</u> ART for the first time?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="initial_art_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="When did the patient <u>start</u> ART for the first time?",
            ),
        ),
    ]
