"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClass = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
exports.StorageClass = StorageClass;
_a = JSII_RTTI_SYMBOL_1;
StorageClass[_a] = { fqn: "@aws-cdk/aws-s3.StorageClass", version: "1.157.0" };
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.INFREQUENT_ACCESS = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.ONE_ZONE_INFREQUENT_ACCESS = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.GLACIER = new StorageClass('GLACIER');
/**
 * Storage class for long-term archival that can be accessed in a few milliseconds.
 *
 * It is ideal for data that is accessed once or twice per quarter, and
 * that requires immediate access. Data stored in the GLACIER_IR storage class
 * has a minimum storage duration period of 90 days and can be accessed in
 * as milliseconds. If you delete an object before the 90-day minimum,
 * you are charged for 90 days.
 */
StorageClass.GLACIER_INSTANT_RETRIEVAL = new StorageClass('GLACIER_IR');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DEEP_ARCHIVE = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.INTELLIGENT_TIERING = new StorageClass('INTELLIGENT_TIERING');
//# sourceMappingURL=data:application/json;base64,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