# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.demand_type import DemandType
from vrt_lss_studio.models.possible_event import PossibleEvent
from typing import Optional, Set
from typing_extensions import Self

class Demand(BaseModel):
    """
    Request for a single action with a cargo (pickup / drop) or work at a location.
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Demand key, unique identifier.")
    demand_type: DemandType
    target_cargos: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="The list of cargo keys depends on the type of order in which the cargoes are located:   * `PICKUP` - list of keys   * `DROP` - one key   * `WORK` - empty list   * `PICKUP_TO_BOX` - one key   * `DROP_FROM_BOX` - one key ")
    precedence_in_trip: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="Precedence within a trip, 0 - the precedence is not taken into account.")
    precedence_in_order: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="Precedence within an order, 0 - the precedence is not taken into account.")
    possible_events: Annotated[List[PossibleEvent], Field(min_length=1, max_length=25)] = Field(description="List of possible time windows and location keys to fulfil an order.")
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=128)]] = Field(default='', description="Name, information field.")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=250)]] = Field(default=None, description="Attributes. Used to add service information.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["key", "demand_type", "target_cargos", "precedence_in_trip", "precedence_in_order", "possible_events", "name", "attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Demand from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in possible_events (list)
        _items = []
        if self.possible_events:
            for _item_possible_events in self.possible_events:
                if _item_possible_events:
                    _items.append(_item_possible_events.to_dict())
            _dict['possible_events'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['attributes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Demand from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "demand_type": obj.get("demand_type"),
            "target_cargos": obj.get("target_cargos"),
            "precedence_in_trip": obj.get("precedence_in_trip") if obj.get("precedence_in_trip") is not None else 0,
            "precedence_in_order": obj.get("precedence_in_order") if obj.get("precedence_in_order") is not None else 0,
            "possible_events": [PossibleEvent.from_dict(_item) for _item in obj["possible_events"]] if obj.get("possible_events") is not None else None,
            "name": obj.get("name") if obj.get("name") is not None else '',
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


