# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.folder_counters import FolderCounters
from vrt_lss_studio.models.folder_type import FolderType
from typing import Optional, Set
from typing_extensions import Self

class Folder(BaseModel):
    """
    Folder is an element of a virtual file system. 
    """ # noqa: E501
    key: StrictStr = Field(description="Key, unique identifier.")
    type: FolderType
    parent_key: Optional[StrictStr] = Field(default=None, description="Key, unique identifier.")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=100)] = Field(description="Folder name.")
    owner_company_key: Annotated[str, Field(min_length=3, strict=True, max_length=256)] = Field(description="Unique company key.")
    owner_username: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Unique username for login.")
    comment: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=10000)]] = Field(default=None, description="Folder comment.")
    creation_date: Optional[datetime] = Field(default=None, description="Creation date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. ")
    counters: FolderCounters
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["key", "type", "parent_key", "name", "owner_company_key", "owner_username", "comment", "creation_date", "counters"]

    @field_validator('owner_company_key')
    def owner_company_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @field_validator('owner_username')
    def owner_username_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Folder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of counters
        if self.counters:
            _dict['counters'] = self.counters.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if parent_key (nullable) is None
        # and model_fields_set contains the field
        if self.parent_key is None and "parent_key" in self.model_fields_set:
            _dict['parent_key'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if creation_date (nullable) is None
        # and model_fields_set contains the field
        if self.creation_date is None and "creation_date" in self.model_fields_set:
            _dict['creation_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Folder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "type": obj.get("type"),
            "parent_key": obj.get("parent_key"),
            "name": obj.get("name"),
            "owner_company_key": obj.get("owner_company_key"),
            "owner_username": obj.get("owner_username"),
            "comment": obj.get("comment"),
            "creation_date": obj.get("creation_date"),
            "counters": FolderCounters.from_dict(obj["counters"]) if obj.get("counters") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


