# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from vrt_lss_studio.models.time_window import TimeWindow
from typing import Optional, Set
from typing_extensions import Self

class PossibleEvent(BaseModel):
    """
    Possible event.  Combines the geographical location and the time window, when a demand can be completed. 
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Event key, unique identifier.")
    location_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Location key, where this event is possible.")
    duration: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    reward: Optional[Union[Annotated[float, Field(le=2000000000, strict=True, ge=0)], Annotated[int, Field(le=2000000000, strict=True, ge=0)]]] = Field(default=1000.1, description="Reward for completing this event.")
    hard_time_window: Optional[TimeWindow]
    soft_time_window: Optional[TimeWindow] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["key", "location_key", "duration", "reward", "hard_time_window", "soft_time_window"]

    @field_validator('duration')
    def duration_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PossibleEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of hard_time_window
        if self.hard_time_window:
            _dict['hard_time_window'] = self.hard_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of soft_time_window
        if self.soft_time_window:
            _dict['soft_time_window'] = self.soft_time_window.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if hard_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.hard_time_window is None and "hard_time_window" in self.model_fields_set:
            _dict['hard_time_window'] = None

        # set to None if soft_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.soft_time_window is None and "soft_time_window" in self.model_fields_set:
            _dict['soft_time_window'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PossibleEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "location_key": obj.get("location_key"),
            "duration": obj.get("duration") if obj.get("duration") is not None else 'PT0S',
            "reward": obj.get("reward") if obj.get("reward") is not None else 1000.1,
            "hard_time_window": TimeWindow.from_dict(obj["hard_time_window"]) if obj.get("hard_time_window") is not None else None,
            "soft_time_window": TimeWindow.from_dict(obj["soft_time_window"]) if obj.get("soft_time_window") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


