# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.measurements import Measurements
from vrt_lss_studio.models.stop_demand import StopDemand
from vrt_lss_studio.models.time_window import TimeWindow
from vrt_lss_studio.models.transport_load import TransportLoad
from typing import Optional, Set
from typing_extensions import Self

class StopStatistics(BaseModel):
    """
    Statistics for a specific stop during a trip. 
    """ # noqa: E501
    location_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Location key for stop.")
    stop_demands: Annotated[List[StopDemand], Field(min_length=0, max_length=15001)] = Field(description="List of orders completed at this stop.")
    stop_time_window: Optional[TimeWindow]
    measurements: Measurements
    upload: TransportLoad
    download: TransportLoad
    max_load: TransportLoad
    arrival_load: TransportLoad
    departure_load: TransportLoad
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=250)]] = Field(default=None, description="Attributes. Used to add service information.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["location_key", "stop_demands", "stop_time_window", "measurements", "upload", "download", "max_load", "arrival_load", "departure_load", "attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StopStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in stop_demands (list)
        _items = []
        if self.stop_demands:
            for _item_stop_demands in self.stop_demands:
                if _item_stop_demands:
                    _items.append(_item_stop_demands.to_dict())
            _dict['stop_demands'] = _items
        # override the default output from pydantic by calling `to_dict()` of stop_time_window
        if self.stop_time_window:
            _dict['stop_time_window'] = self.stop_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of measurements
        if self.measurements:
            _dict['measurements'] = self.measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of upload
        if self.upload:
            _dict['upload'] = self.upload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of download
        if self.download:
            _dict['download'] = self.download.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max_load
        if self.max_load:
            _dict['max_load'] = self.max_load.to_dict()
        # override the default output from pydantic by calling `to_dict()` of arrival_load
        if self.arrival_load:
            _dict['arrival_load'] = self.arrival_load.to_dict()
        # override the default output from pydantic by calling `to_dict()` of departure_load
        if self.departure_load:
            _dict['departure_load'] = self.departure_load.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['attributes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if stop_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.stop_time_window is None and "stop_time_window" in self.model_fields_set:
            _dict['stop_time_window'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StopStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "location_key": obj.get("location_key"),
            "stop_demands": [StopDemand.from_dict(_item) for _item in obj["stop_demands"]] if obj.get("stop_demands") is not None else None,
            "stop_time_window": TimeWindow.from_dict(obj["stop_time_window"]) if obj.get("stop_time_window") is not None else None,
            "measurements": Measurements.from_dict(obj["measurements"]) if obj.get("measurements") is not None else None,
            "upload": TransportLoad.from_dict(obj["upload"]) if obj.get("upload") is not None else None,
            "download": TransportLoad.from_dict(obj["download"]) if obj.get("download") is not None else None,
            "max_load": TransportLoad.from_dict(obj["max_load"]) if obj.get("max_load") is not None else None,
            "arrival_load": TransportLoad.from_dict(obj["arrival_load"]) if obj.get("arrival_load") is not None else None,
            "departure_load": TransportLoad.from_dict(obj["departure_load"]) if obj.get("departure_load") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


