# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class TableCustomfields(BaseModel):
    """
    Custom fields for table.
    """ # noqa: E501
    datetime_1: Optional[datetime] = Field(default=None, description="A custom field containing date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. Supported filter type is `DATETIME_RANGE`. ")
    datetime_2: Optional[datetime] = Field(default=None, description="A custom field containing date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. Supported filter type is `DATETIME_RANGE`. ")
    datetime_3: Optional[datetime] = Field(default=None, description="A custom field containing date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. Supported filter type is `DATETIME_RANGE`. ")
    datetime_4: Optional[datetime] = Field(default=None, description="A custom field containing date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. Supported filter type is `DATETIME_RANGE`. ")
    datetime_5: Optional[datetime] = Field(default=None, description="A custom field containing date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. Supported filter type is `DATETIME_RANGE`. ")
    int_1: Optional[Annotated[int, Field(le=1000000000000, strict=True, ge=-1000000000000)]] = Field(default=None, description="A custom field containing an integer value. Supported filter type is `INT_RANGE`. ")
    int_2: Optional[Annotated[int, Field(le=1000000000000, strict=True, ge=-1000000000000)]] = Field(default=None, description="A custom field containing an integer value. Supported filter type is `INT_RANGE`. ")
    int_3: Optional[Annotated[int, Field(le=1000000000000, strict=True, ge=-1000000000000)]] = Field(default=None, description="A custom field containing an integer value. Supported filter type is `INT_RANGE`. ")
    int_4: Optional[Annotated[int, Field(le=1000000000000, strict=True, ge=-1000000000000)]] = Field(default=None, description="A custom field containing an integer value. Supported filter type is `INT_RANGE`. ")
    int_5: Optional[Annotated[int, Field(le=1000000000000, strict=True, ge=-1000000000000)]] = Field(default=None, description="A custom field containing an integer value. Supported filter type is `INT_RANGE`. ")
    float_1: Optional[Union[Annotated[float, Field(le=1000000000000, strict=True, ge=-1000000000000)], Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = Field(default=None, description="A custom field containing a floating point value. Supported filter type is `FLOAT_RANGE`. ")
    float_2: Optional[Union[Annotated[float, Field(le=1000000000000, strict=True, ge=-1000000000000)], Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = Field(default=None, description="A custom field containing a floating point value. Supported filter type is `FLOAT_RANGE`. ")
    float_3: Optional[Union[Annotated[float, Field(le=1000000000000, strict=True, ge=-1000000000000)], Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = Field(default=None, description="A custom field containing a floating point value. Supported filter type is `FLOAT_RANGE`. ")
    float_4: Optional[Union[Annotated[float, Field(le=1000000000000, strict=True, ge=-1000000000000)], Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = Field(default=None, description="A custom field containing a floating point value. Supported filter type is `FLOAT_RANGE`. ")
    float_5: Optional[Union[Annotated[float, Field(le=1000000000000, strict=True, ge=-1000000000000)], Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = Field(default=None, description="A custom field containing a floating point value. Supported filter type is `FLOAT_RANGE`. ")
    duration_1: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default=None, description="A custom field containing the duration of the time period. Supported filter type is `DURATION_RANGE`. ")
    duration_2: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default=None, description="A custom field containing the duration of the time period. Supported filter type is `DURATION_RANGE`. ")
    duration_3: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default=None, description="A custom field containing the duration of the time period. Supported filter type is `DURATION_RANGE`. ")
    duration_4: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default=None, description="A custom field containing the duration of the time period. Supported filter type is `DURATION_RANGE`. ")
    duration_5: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default=None, description="A custom field containing the duration of the time period. Supported filter type is `DURATION_RANGE`. ")
    bool_1: Optional[StrictBool] = Field(default=None, description="A custom field containing a boolean value. Supported filter type is `BOOL_LIST`. ")
    bool_2: Optional[StrictBool] = Field(default=None, description="A custom field containing a boolean value. Supported filter type is `BOOL_LIST`. ")
    bool_3: Optional[StrictBool] = Field(default=None, description="A custom field containing a boolean value. Supported filter type is `BOOL_LIST`. ")
    bool_4: Optional[StrictBool] = Field(default=None, description="A custom field containing a boolean value. Supported filter type is `BOOL_LIST`. ")
    bool_5: Optional[StrictBool] = Field(default=None, description="A custom field containing a boolean value. Supported filter type is `BOOL_LIST`. ")
    string_1: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2000)]] = Field(default=None, description="A custom field containing an string value. Supported filter type is `STRING_SEARCH`. ")
    string_2: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2000)]] = Field(default=None, description="A custom field containing an string value. Supported filter type is `STRING_SEARCH`. ")
    string_3: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2000)]] = Field(default=None, description="A custom field containing an string value. Supported filter type is `STRING_SEARCH`. ")
    string_4: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2000)]] = Field(default=None, description="A custom field containing an string value. Supported filter type is `STRING_SEARCH`. ")
    string_5: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2000)]] = Field(default=None, description="A custom field containing an string value. Supported filter type is `STRING_SEARCH`. ")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["datetime_1", "datetime_2", "datetime_3", "datetime_4", "datetime_5", "int_1", "int_2", "int_3", "int_4", "int_5", "float_1", "float_2", "float_3", "float_4", "float_5", "duration_1", "duration_2", "duration_3", "duration_4", "duration_5", "bool_1", "bool_2", "bool_3", "bool_4", "bool_5", "string_1", "string_2", "string_3", "string_4", "string_5"]

    @field_validator('duration_1')
    def duration_1_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @field_validator('duration_2')
    def duration_2_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @field_validator('duration_3')
    def duration_3_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @field_validator('duration_4')
    def duration_4_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @field_validator('duration_5')
    def duration_5_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableCustomfields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if datetime_1 (nullable) is None
        # and model_fields_set contains the field
        if self.datetime_1 is None and "datetime_1" in self.model_fields_set:
            _dict['datetime_1'] = None

        # set to None if datetime_2 (nullable) is None
        # and model_fields_set contains the field
        if self.datetime_2 is None and "datetime_2" in self.model_fields_set:
            _dict['datetime_2'] = None

        # set to None if datetime_3 (nullable) is None
        # and model_fields_set contains the field
        if self.datetime_3 is None and "datetime_3" in self.model_fields_set:
            _dict['datetime_3'] = None

        # set to None if datetime_4 (nullable) is None
        # and model_fields_set contains the field
        if self.datetime_4 is None and "datetime_4" in self.model_fields_set:
            _dict['datetime_4'] = None

        # set to None if datetime_5 (nullable) is None
        # and model_fields_set contains the field
        if self.datetime_5 is None and "datetime_5" in self.model_fields_set:
            _dict['datetime_5'] = None

        # set to None if int_1 (nullable) is None
        # and model_fields_set contains the field
        if self.int_1 is None and "int_1" in self.model_fields_set:
            _dict['int_1'] = None

        # set to None if int_2 (nullable) is None
        # and model_fields_set contains the field
        if self.int_2 is None and "int_2" in self.model_fields_set:
            _dict['int_2'] = None

        # set to None if int_3 (nullable) is None
        # and model_fields_set contains the field
        if self.int_3 is None and "int_3" in self.model_fields_set:
            _dict['int_3'] = None

        # set to None if int_4 (nullable) is None
        # and model_fields_set contains the field
        if self.int_4 is None and "int_4" in self.model_fields_set:
            _dict['int_4'] = None

        # set to None if int_5 (nullable) is None
        # and model_fields_set contains the field
        if self.int_5 is None and "int_5" in self.model_fields_set:
            _dict['int_5'] = None

        # set to None if float_1 (nullable) is None
        # and model_fields_set contains the field
        if self.float_1 is None and "float_1" in self.model_fields_set:
            _dict['float_1'] = None

        # set to None if float_2 (nullable) is None
        # and model_fields_set contains the field
        if self.float_2 is None and "float_2" in self.model_fields_set:
            _dict['float_2'] = None

        # set to None if float_3 (nullable) is None
        # and model_fields_set contains the field
        if self.float_3 is None and "float_3" in self.model_fields_set:
            _dict['float_3'] = None

        # set to None if float_4 (nullable) is None
        # and model_fields_set contains the field
        if self.float_4 is None and "float_4" in self.model_fields_set:
            _dict['float_4'] = None

        # set to None if float_5 (nullable) is None
        # and model_fields_set contains the field
        if self.float_5 is None and "float_5" in self.model_fields_set:
            _dict['float_5'] = None

        # set to None if duration_1 (nullable) is None
        # and model_fields_set contains the field
        if self.duration_1 is None and "duration_1" in self.model_fields_set:
            _dict['duration_1'] = None

        # set to None if duration_2 (nullable) is None
        # and model_fields_set contains the field
        if self.duration_2 is None and "duration_2" in self.model_fields_set:
            _dict['duration_2'] = None

        # set to None if duration_3 (nullable) is None
        # and model_fields_set contains the field
        if self.duration_3 is None and "duration_3" in self.model_fields_set:
            _dict['duration_3'] = None

        # set to None if duration_4 (nullable) is None
        # and model_fields_set contains the field
        if self.duration_4 is None and "duration_4" in self.model_fields_set:
            _dict['duration_4'] = None

        # set to None if duration_5 (nullable) is None
        # and model_fields_set contains the field
        if self.duration_5 is None and "duration_5" in self.model_fields_set:
            _dict['duration_5'] = None

        # set to None if bool_1 (nullable) is None
        # and model_fields_set contains the field
        if self.bool_1 is None and "bool_1" in self.model_fields_set:
            _dict['bool_1'] = None

        # set to None if bool_2 (nullable) is None
        # and model_fields_set contains the field
        if self.bool_2 is None and "bool_2" in self.model_fields_set:
            _dict['bool_2'] = None

        # set to None if bool_3 (nullable) is None
        # and model_fields_set contains the field
        if self.bool_3 is None and "bool_3" in self.model_fields_set:
            _dict['bool_3'] = None

        # set to None if bool_4 (nullable) is None
        # and model_fields_set contains the field
        if self.bool_4 is None and "bool_4" in self.model_fields_set:
            _dict['bool_4'] = None

        # set to None if bool_5 (nullable) is None
        # and model_fields_set contains the field
        if self.bool_5 is None and "bool_5" in self.model_fields_set:
            _dict['bool_5'] = None

        # set to None if string_1 (nullable) is None
        # and model_fields_set contains the field
        if self.string_1 is None and "string_1" in self.model_fields_set:
            _dict['string_1'] = None

        # set to None if string_2 (nullable) is None
        # and model_fields_set contains the field
        if self.string_2 is None and "string_2" in self.model_fields_set:
            _dict['string_2'] = None

        # set to None if string_3 (nullable) is None
        # and model_fields_set contains the field
        if self.string_3 is None and "string_3" in self.model_fields_set:
            _dict['string_3'] = None

        # set to None if string_4 (nullable) is None
        # and model_fields_set contains the field
        if self.string_4 is None and "string_4" in self.model_fields_set:
            _dict['string_4'] = None

        # set to None if string_5 (nullable) is None
        # and model_fields_set contains the field
        if self.string_5 is None and "string_5" in self.model_fields_set:
            _dict['string_5'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableCustomfields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datetime_1": obj.get("datetime_1"),
            "datetime_2": obj.get("datetime_2"),
            "datetime_3": obj.get("datetime_3"),
            "datetime_4": obj.get("datetime_4"),
            "datetime_5": obj.get("datetime_5"),
            "int_1": obj.get("int_1"),
            "int_2": obj.get("int_2"),
            "int_3": obj.get("int_3"),
            "int_4": obj.get("int_4"),
            "int_5": obj.get("int_5"),
            "float_1": obj.get("float_1"),
            "float_2": obj.get("float_2"),
            "float_3": obj.get("float_3"),
            "float_4": obj.get("float_4"),
            "float_5": obj.get("float_5"),
            "duration_1": obj.get("duration_1"),
            "duration_2": obj.get("duration_2"),
            "duration_3": obj.get("duration_3"),
            "duration_4": obj.get("duration_4"),
            "duration_5": obj.get("duration_5"),
            "bool_1": obj.get("bool_1"),
            "bool_2": obj.get("bool_2"),
            "bool_3": obj.get("bool_3"),
            "bool_4": obj.get("bool_4"),
            "bool_5": obj.get("bool_5"),
            "string_1": obj.get("string_1"),
            "string_2": obj.get("string_2"),
            "string_3": obj.get("string_3"),
            "string_4": obj.get("string_4"),
            "string_5": obj.get("string_5")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


