# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.basic_time_window import BasicTimeWindow
from vrt_lss_studio.models.table_customfields import TableCustomfields
from typing import Optional, Set
from typing_extensions import Self

class TableLocationFields(BaseModel):
    """
    Location fields for table.
    """ # noqa: E501
    essence_type: Optional[StrictStr] = Field(default='LOCATION', description="Essence type.")
    essence_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Essence key, unique identifier, may be `null`.")
    enabled: Optional[StrictBool] = Field(default=True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(default=True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    working_time: Optional[BasicTimeWindow] = None
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=128)]] = Field(default='', description="Name, information field.")
    attributes: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1000000)]] = Field(default='', description="Attributes.")
    customfields: Optional[TableCustomfields] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["essence_type", "essence_key", "enabled", "pristine", "working_time", "name", "attributes", "customfields"]

    @field_validator('essence_type')
    def essence_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LOCATION', 'WORK_WINDOW']):
            raise ValueError("must be one of enum values ('LOCATION', 'WORK_WINDOW')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableLocationFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "pristine",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of working_time
        if self.working_time:
            _dict['working_time'] = self.working_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customfields
        if self.customfields:
            _dict['customfields'] = self.customfields.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if essence_key (nullable) is None
        # and model_fields_set contains the field
        if self.essence_key is None and "essence_key" in self.model_fields_set:
            _dict['essence_key'] = None

        # set to None if working_time (nullable) is None
        # and model_fields_set contains the field
        if self.working_time is None and "working_time" in self.model_fields_set:
            _dict['working_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableLocationFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'LOCATION',
            "essence_key": obj.get("essence_key"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "working_time": BasicTimeWindow.from_dict(obj["working_time"]) if obj.get("working_time") is not None else None,
            "name": obj.get("name") if obj.get("name") is not None else '',
            "attributes": obj.get("attributes") if obj.get("attributes") is not None else '',
            "customfields": TableCustomfields.from_dict(obj["customfields"]) if obj.get("customfields") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


