# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.feature_lifetime import FeatureLifetime
from typing import Optional, Set
from typing_extensions import Self

class TransportCompatibilities(BaseModel):
    """
    Transport [compatibilities](#section/Description/Compatibilities). 
    """ # noqa: E501
    transport_features: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    transport_features_lifetimes: Optional[Annotated[List[FeatureLifetime], Field(min_length=0, max_length=100)]] = Field(default=None, description="List of feature tag lifetime. ")
    performer_restrictions: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["transport_features", "transport_features_lifetimes", "performer_restrictions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransportCompatibilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in transport_features_lifetimes (list)
        _items = []
        if self.transport_features_lifetimes:
            for _item_transport_features_lifetimes in self.transport_features_lifetimes:
                if _item_transport_features_lifetimes:
                    _items.append(_item_transport_features_lifetimes.to_dict())
            _dict['transport_features_lifetimes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransportCompatibilities from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transport_features": obj.get("transport_features"),
            "transport_features_lifetimes": [FeatureLifetime.from_dict(_item) for _item in obj["transport_features_lifetimes"]] if obj.get("transport_features_lifetimes") is not None else None,
            "performer_restrictions": obj.get("performer_restrictions")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


