# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.time_window import TimeWindow
from vrt_lss_studio.models.transport_tariff import TransportTariff
from typing import Optional, Set
from typing_extensions import Self

class TransportShift(BaseModel):
    """
    Working shift of transport. Specifies the availability of transport for scheduling. The end of the shift resets the cargo remaining in the body after the execution of demands of the `DROP_FROM_BOX` and `PICKUP_TO_BOX` types. 
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Shift key, unique identifier.")
    availability_time: Optional[TimeWindow]
    start_location_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Start location key.  If the key is not set, then the transport path starts on the first order. ")
    finish_location_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Finish location key.  If the key is not set, then the transport path ends at the last order. ")
    tariff: Optional[TransportTariff] = None
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=128)]] = Field(default='', description="Name, information field.")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=250)]] = Field(default=None, description="Attributes. Used to add service information.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["key", "availability_time", "start_location_key", "finish_location_key", "tariff", "name", "attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransportShift from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of availability_time
        if self.availability_time:
            _dict['availability_time'] = self.availability_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tariff
        if self.tariff:
            _dict['tariff'] = self.tariff.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['attributes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if availability_time (nullable) is None
        # and model_fields_set contains the field
        if self.availability_time is None and "availability_time" in self.model_fields_set:
            _dict['availability_time'] = None

        # set to None if start_location_key (nullable) is None
        # and model_fields_set contains the field
        if self.start_location_key is None and "start_location_key" in self.model_fields_set:
            _dict['start_location_key'] = None

        # set to None if finish_location_key (nullable) is None
        # and model_fields_set contains the field
        if self.finish_location_key is None and "finish_location_key" in self.model_fields_set:
            _dict['finish_location_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransportShift from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "availability_time": TimeWindow.from_dict(obj["availability_time"]) if obj.get("availability_time") is not None else None,
            "start_location_key": obj.get("start_location_key"),
            "finish_location_key": obj.get("finish_location_key"),
            "tariff": TransportTariff.from_dict(obj["tariff"]) if obj.get("tariff") is not None else None,
            "name": obj.get("name") if obj.get("name") is not None else '',
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


