# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.18.2755
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.actualize_settings import ActualizeSettings
from vrt_lss_studio.models.fact import Fact
from vrt_lss_studio.models.hardlink import Hardlink
from vrt_lss_studio.models.location import Location
from vrt_lss_studio.models.order import Order
from vrt_lss_studio.models.performer import Performer
from vrt_lss_studio.models.plan_settings import PlanSettings
from vrt_lss_studio.models.plan_statistics import PlanStatistics
from vrt_lss_studio.models.replan_settings import ReplanSettings
from vrt_lss_studio.models.routing_transport_matrix import RoutingTransportMatrix
from vrt_lss_studio.models.transport import Transport
from vrt_lss_studio.models.trip import Trip
from typing import Optional, Set
from typing_extensions import Self

class UniversalData(BaseModel):
    """
    VRt.Universal JSON format. A general list of data and settings that combines all data for planning, replaning and actualization. 
    """ # noqa: E501
    locations: Optional[Annotated[List[Location], Field(min_length=0, max_length=15001)]] = Field(default=None, description="List of locations used for orders and shifts.")
    orders: Optional[Annotated[List[Order], Field(min_length=0, max_length=15001)]] = Field(default=None, description="List of orders that need to be completed.")
    performers: Optional[Annotated[List[Performer], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Available performers list. The performer fulfills orders using transport. ")
    transports: Optional[Annotated[List[Transport], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Available transports list. Transport is used by the trip performer to fulfill orders. ")
    hardlinks: Optional[Annotated[List[Hardlink], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Assignments list.")
    trips: Optional[Annotated[List[Trip], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Trip list. A trip is a set of works planned to be performed by a specific performer on a specific transport, expressed through a [change in the states](#section/Description/Trip-model) of the performer. ")
    facts: Optional[Annotated[List[Fact], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Trip list. A fact is an event that has occurred that affects further trip operations. ")
    statistics: Optional[PlanStatistics] = None
    external_routing: Optional[Annotated[List[RoutingTransportMatrix], Field(min_length=0, max_length=16)]] = Field(default=None, description="List of matrices of times and distances for each type of transport that are indicated in the data. The matrix should describe all locations for each type of transport from the data. When specifying an external routing matrix `external_routing`, the `plan_settings.geo_settings` parameters are not taken into account. ")
    plan_settings: Optional[PlanSettings] = None
    replan_settings: Optional[ReplanSettings] = None
    actualize_settings: Optional[ActualizeSettings] = None
    dataset_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=512)]] = Field(default='', description="The name of the dataset. A technical field that does not affect calculation. ")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["locations", "orders", "performers", "transports", "hardlinks", "trips", "facts", "statistics", "external_routing", "plan_settings", "replan_settings", "actualize_settings", "dataset_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UniversalData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in locations (list)
        _items = []
        if self.locations:
            for _item_locations in self.locations:
                if _item_locations:
                    _items.append(_item_locations.to_dict())
            _dict['locations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in orders (list)
        _items = []
        if self.orders:
            for _item_orders in self.orders:
                if _item_orders:
                    _items.append(_item_orders.to_dict())
            _dict['orders'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in performers (list)
        _items = []
        if self.performers:
            for _item_performers in self.performers:
                if _item_performers:
                    _items.append(_item_performers.to_dict())
            _dict['performers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transports (list)
        _items = []
        if self.transports:
            for _item_transports in self.transports:
                if _item_transports:
                    _items.append(_item_transports.to_dict())
            _dict['transports'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in hardlinks (list)
        _items = []
        if self.hardlinks:
            for _item_hardlinks in self.hardlinks:
                if _item_hardlinks:
                    _items.append(_item_hardlinks.to_dict())
            _dict['hardlinks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in trips (list)
        _items = []
        if self.trips:
            for _item_trips in self.trips:
                if _item_trips:
                    _items.append(_item_trips.to_dict())
            _dict['trips'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in facts (list)
        _items = []
        if self.facts:
            for _item_facts in self.facts:
                if _item_facts:
                    _items.append(_item_facts.to_dict())
            _dict['facts'] = _items
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in external_routing (list)
        _items = []
        if self.external_routing:
            for _item_external_routing in self.external_routing:
                if _item_external_routing:
                    _items.append(_item_external_routing.to_dict())
            _dict['external_routing'] = _items
        # override the default output from pydantic by calling `to_dict()` of plan_settings
        if self.plan_settings:
            _dict['plan_settings'] = self.plan_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of replan_settings
        if self.replan_settings:
            _dict['replan_settings'] = self.replan_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of actualize_settings
        if self.actualize_settings:
            _dict['actualize_settings'] = self.actualize_settings.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if statistics (nullable) is None
        # and model_fields_set contains the field
        if self.statistics is None and "statistics" in self.model_fields_set:
            _dict['statistics'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UniversalData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "locations": [Location.from_dict(_item) for _item in obj["locations"]] if obj.get("locations") is not None else None,
            "orders": [Order.from_dict(_item) for _item in obj["orders"]] if obj.get("orders") is not None else None,
            "performers": [Performer.from_dict(_item) for _item in obj["performers"]] if obj.get("performers") is not None else None,
            "transports": [Transport.from_dict(_item) for _item in obj["transports"]] if obj.get("transports") is not None else None,
            "hardlinks": [Hardlink.from_dict(_item) for _item in obj["hardlinks"]] if obj.get("hardlinks") is not None else None,
            "trips": [Trip.from_dict(_item) for _item in obj["trips"]] if obj.get("trips") is not None else None,
            "facts": [Fact.from_dict(_item) for _item in obj["facts"]] if obj.get("facts") is not None else None,
            "statistics": PlanStatistics.from_dict(obj["statistics"]) if obj.get("statistics") is not None else None,
            "external_routing": [RoutingTransportMatrix.from_dict(_item) for _item in obj["external_routing"]] if obj.get("external_routing") is not None else None,
            "plan_settings": PlanSettings.from_dict(obj["plan_settings"]) if obj.get("plan_settings") is not None else None,
            "replan_settings": ReplanSettings.from_dict(obj["replan_settings"]) if obj.get("replan_settings") is not None else None,
            "actualize_settings": ActualizeSettings.from_dict(obj["actualize_settings"]) if obj.get("actualize_settings") is not None else None,
            "dataset_name": obj.get("dataset_name") if obj.get("dataset_name") is not None else ''
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


