"""
Symbols extracted from extern/unimathsymbols.txt.

extern/unimathsymbols.txt is under Copyright 2011 by Günter Milde and licensed under the
LaTeX Project Public License (LPPL).

As a Derived Work, this file is licensed under LaTeX Project Public License (LPPL).
"""

COMMANDS = {
    "-": "−",
    ":": "∶",
    "A": "𝐴",
    "B": "𝐵",
    "C": "𝐶",
    "D": "𝐷",
    "E": "𝐸",
    "F": "𝐹",
    "G": "𝐺",
    "H": "𝐻",
    "I": "𝐼",
    "J": "𝐽",
    "K": "𝐾",
    "L": "𝐿",
    "M": "𝑀",
    "N": "𝑁",
    "O": "𝑂",
    "P": "𝑃",
    "Q": "𝑄",
    "R": "𝑅",
    "S": "𝑆",
    "T": "𝑇",
    "U": "𝑈",
    "V": "𝑉",
    "W": "𝑊",
    "X": "𝑋",
    "Y": "𝑌",
    "Z": "𝑍",
    "\\#": "#",
    "\\$": "$",
    "\\%": "%",
    "\\&": "&",
    "\\,": "\u2009",
    "\\:": "\u205f",
    "\\AC": "∿",
    "\\APLboxquestion": "⍰",
    "\\APLboxupcaret": "⍓",
    "\\APLcomment": "⍝",
    "\\APLdownarrowbox": "⍗",
    "\\APLinput": "⍞",
    "\\APLinv": "⌹",
    "\\APLleftarrowbox": "⍇",
    "\\APLlog": "⍟",
    "\\APLrightarrowbox": "⍈",
    "\\APLuparrowbox": "⍐",
    "\\Angstroem": "Å",
    "\\Barv": "⫧",
    "\\Bot": "⫫",
    "\\Bumpeq": "≎",
    "\\CIRCLE": "●",
    "\\Cap": "⋒",
    "\\CapitalDifferentialD": "ⅅ",
    "\\CheckedBox": "☑",
    "\\Circle": "○",
    "\\Coloneqq": "⩴",
    "\\ComplexI": "ⅈ",
    "\\ComplexJ": "ⅉ",
    "\\Cup": "⋓",
    "\\DDownarrow": "⟱",
    "\\DashV": "⫥",
    "\\DashVDash": "⟚",
    "\\Dashv": "⫤",
    "\\Ddownarrow": "⤋",
    "\\Delta": "𝛥",
    "\\Diamond": "◇",
    "\\Diamondblack": "◆",
    "\\Diamonddot": "⟐",
    "\\DifferentialD": "ⅆ",
    "\\Digamma": "Ϝ",
    "\\Doteq": "≑",
    "\\DownArrowBar": "⤓",
    "\\DownLeftTeeVector": "⥞",
    "\\DownLeftVectorBar": "⥖",
    "\\DownRightTeeVector": "⥟",
    "\\DownRightVectorBar": "⥗",
    "\\Downarrow": "⇓",
    "\\Equal": "⩵",
    "\\Equiv": "≣",
    "\\Euler": "ℇ",
    "\\Exclam": "‼",
    "\\ExponetialE": "ⅇ",
    "\\Finv": "Ⅎ",
    "\\Game": "⅁",
    "\\Gamma": "𝛤",
    "\\Hermaphrodite": "⚥",
    "\\Im": "ℑ",
    "\\Join": "⨝",
    "\\Koppa": "Ϟ",
    "\\LEFTCIRCLE": "◖",
    "\\LEFTcircle": "◐",
    "\\LHD": "◀",
    "\\LLeftarrow": "⭅",
    "\\LVec": "⃖",
    "\\Lambda": "𝛬",
    "\\Lbag": "⟅",
    "\\Lbrbrak": "〘",
    "\\LeftArrowBar": "⇤",
    "\\LeftDownTeeVector": "⥡",
    "\\LeftDownVectorBar": "⥙",
    "\\LeftTeeVector": "⥚",
    "\\LeftTriangleBar": "⧏",
    "\\LeftUpTeeVector": "⥠",
    "\\LeftUpVectorBar": "⥘",
    "\\LeftVectorBar": "⥒",
    "\\Leftarrow": "⇐",
    "\\Leftrightarrow": "⇔",
    "\\Lleftarrow": "⇚",
    "\\Longleftarrow": "⟸",
    "\\Longleftrightarrow": "⟺",
    "\\Longmapsfrom": "⟽",
    "\\Longmapsto": "⟾",
    "\\Longrightarrow": "⟹",
    "\\Lparen": "⦅",
    "\\Lparengtr": "⦕",
    "\\Lsh": "↰",
    "\\Lvzigzag": "⧚",
    "\\MapsDown": "↧",
    "\\MapsUp": "↥",
    "\\Mapsfrom": "⤆",
    "\\Mapsto": "⤇",
    "\\Micro": "µ",
    "\\Nearrow": "⇗",
    "\\NestedGreaterGreater": "⪢",
    "\\NestedLessLess": "⪡",
    "\\Not": "⫬",
    "\\NotGreaterLess": "≹",
    "\\NotGreaterTilde": "≵",
    "\\NotLessTilde": "≴",
    "\\Nwarrow": "⇖",
    "\\Omega": "𝛺",
    "\\Otimes": "⨷",
    "\\Phi": "𝛷",
    "\\Pi": "𝛱",
    "\\Planckconst": "ℎ",
    "\\PropertyLine": "⅊",
    "\\Proportion": "∷",
    "\\Psi": "𝛹",
    "\\QED": "∎",
    "\\Qoppa": "Ϙ",
    "\\Question": "⁇",
    "\\RHD": "▶",
    "\\RIGHTCIRCLE": "◗",
    "\\RIGHTcircle": "◑",
    "\\RRightarrow": "⭆",
    "\\Rbag": "⟆",
    "\\Rbrbrak": "〙",
    "\\Re": "ℜ",
    "\\RightArrowBar": "⇥",
    "\\RightDownTeeVector": "⥝",
    "\\RightDownVectorBar": "⥕",
    "\\RightTeeVector": "⥛",
    "\\RightTriangleBar": "⧐",
    "\\RightUpTeeVector": "⥜",
    "\\RightUpVectorBar": "⥔",
    "\\RightVectorBar": "⥓",
    "\\Rightarrow": "⇒",
    "\\Rparen": "⦆",
    "\\Rparenless": "⦖",
    "\\Rrightarrow": "⇛",
    "\\Rsh": "↱",
    "\\Rvzigzag": "⧛",
    "\\Same": "⩶",
    "\\Sampi": "Ϡ",
    "\\Searrow": "⇘",
    "\\Sigma": "𝛴",
    "\\Sqcap": "⩎",
    "\\Sqcup": "⩏",
    "\\Square": "☐",
    "\\Stigma": "Ϛ",
    "\\Subset": "⋐",
    "\\Sun": "☉",
    "\\Supset": "⋑",
    "\\Swarrow": "⇙",
    "\\Theta": "𝛩",
    "\\Top": "⫪",
    "\\UUparrow": "⟰",
    "\\UpArrowBar": "⤒",
    "\\Uparrow": "⇑",
    "\\Updownarrow": "⇕",
    "\\Upsilon": "𝛶",
    "\\Uuparrow": "⤊",
    "\\VDash": "⊫",
    "\\VERT": "⦀",
    "\\Vdash": "⊩",
    "\\Vee": "⩔",
    "\\Vvdash": "⊪",
    "\\Wedge": "⩓",
    "\\XBox": "☒",
    "\\Xi": "𝛯",
    "\\Yup": "⅄",
    "\\Zbar": "Ƶ",
    "\\_": "_",
    "\\accurrent": "⏦",
    "\\acidfree": "♾",
    "\\acute": "́",
    "\\acwcirclearrow": "⥀",
    "\\acwgapcirclearrow": "⟲",
    "\\acwleftarcarrow": "⤹",
    "\\acwoverarcarrow": "⤺",
    "\\acwunderarcarrow": "⤻",
    "\\aleph": "ℵ",
    "\\alpha": "𝛼",
    "\\amalg": "⨿",
    "\\anchor": "⚓",
    "\\angdnr": "⦟",
    "\\angle": "∠",
    "\\angles": "⦞",
    "\\angleubar": "⦤",
    "\\annuity": "⃧",
    "\\approx": "≈",
    "\\approxeq": "≊",
    "\\approxeqq": "⩰",
    "\\approxident": "≋",
    "\\aquarius": "♒",
    "\\arceq": "≘",
    "\\aries": "♈",
    "\\arrowbullet": "➢",
    "\\assert": "⊦",
    "\\ast": "∗",
    "\\asteq": "⩮",
    "\\asteraccent": "⃰",
    "\\asymp": "≍",
    "\\awint": "⨑",
    "\\bNot": "⫭",
    "\\backcong": "≌",
    "\\backdprime": "‶",
    "\\backepsilon": "϶",
    "\\backprime": "‵",
    "\\backsim": "∽",
    "\\backsimeq": "⋍",
    "\\backslash": "\\",
    "\\backtrprime": "‷",
    "\\bagmember": "⋿",
    "\\ballotx": "✗",
    "\\bar": "̄",
    "\\barcap": "⩃",
    "\\barcup": "⩂",
    "\\barin": "⋶",
    "\\barleftarrowrightarrowba": "↹",
    "\\barleftharpoon": "⥫",
    "\\barovernorthwestarrow": "↸",
    "\\barrightarrowdiamond": "⤠",
    "\\barrightharpoon": "⥭",
    "\\barvee": "⊽",
    "\\barwedge": "⊼",
    "\\bbrktbrk": "⎶",
    "\\bdtriplevdash": "┆",
    "\\because": "∵",
    "\\benzenr": "⏣",
    "\\beta": "𝛽",
    "\\beth": "ℶ",
    "\\between": "≬",
    "\\bigblacktriangledown": "▼",
    "\\bigblacktriangleup": "▲",
    "\\bigbot": "⟘",
    "\\bigcap": "⋂",
    "\\bigcup": "⋃",
    "\\bigcupdot": "⨃",
    "\\biginterleave": "⫼",
    "\\bigodot": "⨀",
    "\\bigoplus": "⨁",
    "\\bigotimes": "⨂",
    "\\bigslopedvee": "⩗",
    "\\bigslopedwedge": "⩘",
    "\\bigsqcap": "⨅",
    "\\bigsqcup": "⨆",
    "\\bigstar": "★",
    "\\bigtalloblong": "⫿",
    "\\bigtop": "⟙",
    "\\bigtriangledown": "▽",
    "\\bigtriangleleft": "⨞",
    "\\bigtriangleup": "△",
    "\\biguplus": "⨄",
    "\\bigvee": "⋁",
    "\\bigwedge": "⋀",
    "\\bigwhitestar": "☆",
    "\\bij": "⤖",
    "\\biohazard": "☣",
    "\\blackcircledownarrow": "⧭",
    "\\blackcircledrightdot": "⚈",
    "\\blackcircledtwodots": "⚉",
    "\\blackcircleulquadwhite": "◕",
    "\\blackdiamonddownarrow": "⧪",
    "\\blackhourglass": "⧗",
    "\\blackinwhitediamond": "◈",
    "\\blackinwhitesquare": "▣",
    "\\blacklozenge": "⧫",
    "\\blackpointerleft": "◄",
    "\\blackpointerright": "►",
    "\\blacksmiley": "☻",
    "\\blacksquare": "⬛",
    "\\blacktriangledown": "▾",
    "\\blacktriangleleft": "◂",
    "\\blacktriangleright": "▸",
    "\\blacktriangleup": "▴",
    "\\blkhorzoval": "⬬",
    "\\blkvertoval": "⬮",
    "\\blockfull": "█",
    "\\blockhalfshaded": "▒",
    "\\blocklefthalf": "▌",
    "\\blocklowhalf": "▄",
    "\\blockqtrshaded": "░",
    "\\blockrighthalf": "▐",
    "\\blockthreeqtrshaded": "▓",
    "\\blockuphalf": "▀",
    "\\bot": "⊥",
    "\\botsemicircle": "◡",
    "\\bowtie": "⋈",
    "\\boxast": "⧆",
    "\\boxbar": "◫",
    "\\boxbox": "⧈",
    "\\boxbslash": "⧅",
    "\\boxcircle": "⧇",
    "\\boxdot": "⊡",
    "\\boxminus": "⊟",
    "\\boxonbox": "⧉",
    "\\boxplus": "⊞",
    "\\boxslash": "⧄",
    "\\boxtimes": "⊠",
    "\\breve": "̆",
    "\\bsimilarleftarrow": "⭁",
    "\\bsimilarrightarrow": "⭇",
    "\\bsolhsub": "⟈",
    "\\btimes": "⨲",
    "\\bullet": "∙",
    "\\bullseye": "◎",
    "\\bumpeq": "≏",
    "\\bumpeqq": "⪮",
    "\\cancer": "♋",
    "\\candra": "̐",
    "\\cap": "∩",
    "\\capbarcup": "⩉",
    "\\capdot": "⩀",
    "\\capovercup": "⩇",
    "\\capricornus": "♑",
    "\\capwedge": "⩄",
    "\\caretinsert": "‸",
    "\\carriagereturn": "↵",
    "\\cat": "⁀",
    "\\ccwundercurvearrow": "⤿",
    "\\cdot": "⋅",
    "\\cdotp": "·",
    "\\cdots": "⋯",
    "\\cent": "¢",
    "\\check": "̌",
    "\\checkmark": "✓",
    "\\chi": "𝜒",
    "\\cirE": "⧃",
    "\\cirbot": "⟟",
    "\\circ": "∘",
    "\\circeq": "≗",
    "\\circlearrowleft": "↺",
    "\\circlearrowright": "↻",
    "\\circlebottomhalfblack": "◒",
    "\\circledR": "®",
    "\\circledast": "⊛",
    "\\circledbslash": "⦸",
    "\\circledbullet": "⦿",
    "\\circledcirc": "⊚",
    "\\circleddash": "⊝",
    "\\circledequal": "⊜",
    "\\circledgtr": "⧁",
    "\\circledless": "⧀",
    "\\circledownarrow": "⧬",
    "\\circledparallel": "⦷",
    "\\circledrightdot": "⚆",
    "\\circledstar": "✪",
    "\\circledtwodots": "⚇",
    "\\circledvert": "⦶",
    "\\circledwhitebullet": "⦾",
    "\\circlehbar": "⦵",
    "\\circlellquad": "◵",
    "\\circlelrquad": "◶",
    "\\circleonleftarrow": "⬰",
    "\\circleonrightarrow": "⇴",
    "\\circletophalfblack": "◓",
    "\\circleulquad": "◴",
    "\\circleurquad": "◷",
    "\\circleurquadblack": "◔",
    "\\circlevertfill": "◍",
    "\\cirfnint": "⨐",
    "\\cirmid": "⫯",
    "\\cirscir": "⧂",
    "\\closedvarcap": "⩍",
    "\\closedvarcup": "⩌",
    "\\closedvarcupsmashprod": "⩐",
    "\\closure": "⁐",
    "\\clubsuit": "♣",
    "\\coloneq": "≔",
    "\\commaminus": "⨩",
    "\\complement": "∁",
    "\\concavediamond": "⟡",
    "\\concavediamondtickleft": "⟢",
    "\\concavediamondtickright": "⟣",
    "\\cong": "≅",
    "\\congdot": "⩭",
    "\\conictaper": "⌲",
    "\\conjquant": "⨇",
    "\\coprod": "∐",
    "\\corresponds": "≙",
    "\\csub": "⫏",
    "\\csube": "⫑",
    "\\csup": "⫐",
    "\\csupe": "⫒",
    "\\cup": "∪",
    "\\cupbarcap": "⩈",
    "\\cupdot": "⊍",
    "\\cupleftarrow": "⊌",
    "\\cupovercap": "⩆",
    "\\cupvee": "⩅",
    "\\curlyeqprec": "⋞",
    "\\curlyeqsucc": "⋟",
    "\\curlyvee": "⋎",
    "\\curlywedge": "⋏",
    "\\curvearrowleft": "↶",
    "\\curvearrowleftplus": "⤽",
    "\\curvearrowright": "↷",
    "\\curvearrowrightminus": "⤼",
    "\\cwcirclearrow": "⥁",
    "\\cwgapcirclearrow": "⟳",
    "\\cwrightarcarrow": "⤸",
    "\\cwundercurvearrow": "⤾",
    "\\dagger": "†",
    "\\daleth": "ℸ",
    "\\danger": "☡",
    "\\dashV": "⫣",
    "\\dashVdash": "⟛",
    "\\dashleftarrow": "⇠",
    "\\dashrightarrow": "⇢",
    "\\dashv": "⊣",
    "\\dbkarow": "⤏",
    "\\ddagger": "‡",
    "\\ddddot": "⃜",
    "\\dddot": "⃛",
    "\\ddot": "̈",
    "\\ddots": "⋱",
    "\\ddotseq": "⩷",
    "\\delta": "𝛿",
    "\\diameter": "⌀",
    "\\diamond": "⋄",
    "\\diamondbotblack": "⬙",
    "\\diamondleftarrow": "⤝",
    "\\diamondleftarrowbar": "⤟",
    "\\diamondleftblack": "⬖",
    "\\diamondrightblack": "⬗",
    "\\diamondsuit": "♢",
    "\\diamondtopblack": "⬘",
    "\\dicei": "⚀",
    "\\diceii": "⚁",
    "\\diceiii": "⚂",
    "\\diceiv": "⚃",
    "\\dicev": "⚄",
    "\\dicevi": "⚅",
    "\\digamma": "ϝ",
    "\\dingasterisk": "✽",
    "\\disin": "⋲",
    "\\disjquant": "⨈",
    "\\div": "÷",
    "\\divideontimes": "⋇",
    "\\dlsh": "↲",
    "\\dot": "̇",
    "\\doteq": "≐",
    "\\dotequiv": "⩧",
    "\\dotminus": "∸",
    "\\dotplus": "∔",
    "\\dotsim": "⩪",
    "\\dotsminusdots": "∺",
    "\\dottedcircle": "◌",
    "\\dottedsquare": "⬚",
    "\\dottimes": "⨰",
    "\\doublebarvee": "⩢",
    "\\doublebarwedge": "⩞",
    "\\doubleplus": "⧺",
    "\\downarrow": "↓",
    "\\downarrowbarred": "⤈",
    "\\downdasharrow": "⇣",
    "\\downdownarrows": "⇊",
    "\\downdownharpoons": "⥥",
    "\\downfishtail": "⥿",
    "\\downharpoonleft": "⇃",
    "\\downharpoonright": "⇂",
    "\\downrightcurvedarrow": "⤵",
    "\\downtriangleleftblack": "⧨",
    "\\downtrianglerightblack": "⧩",
    "\\downuparrows": "⇵",
    "\\downupharpoons": "⥯",
    "\\downwhitearrow": "⇩",
    "\\draftingarrow": "➛",
    "\\drbkarow": "⤐",
    "\\droang": "̚",
    "\\drsh": "↳",
    "\\dsol": "⧶",
    "\\dsub": "⩤",
    "\\earth": "♁",
    "\\egsdot": "⪘",
    "\\eighthnote": "♪",
    "\\elinters": "⏧",
    "\\ell": "ℓ",
    "\\elsdot": "⪗",
    "\\emptysetoarr": "⦳",
    "\\emptysetoarrl": "⦴",
    "\\emptysetobar": "⦱",
    "\\emptysetocirc": "⦲",
    "\\enclosecircle": "⃝",
    "\\enclosediamond": "⃟",
    "\\enclosesquare": "⃞",
    "\\enclosetriangle": "⃤",
    "\\enleadertwodots": "‥",
    "\\eparsl": "⧣",
    "\\epsilon": "𝜖",
    "\\eqcirc": "≖",
    "\\eqcolon": "≕",
    "\\eqdef": "≝",
    "\\eqdot": "⩦",
    "\\eqgtr": "⋝",
    "\\eqless": "⋜",
    "\\eqqgtr": "⪚",
    "\\eqqless": "⪙",
    "\\eqqplus": "⩱",
    "\\eqqsim": "⩳",
    "\\eqqslantgtr": "⪜",
    "\\eqqslantless": "⪛",
    "\\eqsim": "≂",
    "\\eqslantgtr": "⪖",
    "\\eqslantless": "⪕",
    "\\equalleftarrow": "⭀",
    "\\equalrightarrow": "⥱",
    "\\equiv": "≡",
    "\\equivDD": "⩸",
    "\\equivVert": "⩨",
    "\\equivVvert": "⩩",
    "\\eqvparsl": "⧥",
    "\\errbarblackcircle": "⧳",
    "\\errbarblackdiamond": "⧱",
    "\\errbarblacksquare": "⧯",
    "\\errbarcircle": "⧲",
    "\\errbardiamond": "⧰",
    "\\errbarsquare": "⧮",
    "\\eta": "𝜂",
    "\\eth": "ð",
    "\\euro": "€",
    "\\exists": "∃",
    "\\fallingdotseq": "≒",
    "\\fbowtie": "⧓",
    "\\fcmp": "⨾",
    "\\fdiagovnearrow": "⤯",
    "\\fdiagovrdiag": "⤬",
    "\\female": "♀",
    "\\ffun": "⇻",
    "\\finj": "⤕",
    "\\fint": "⨏",
    "\\fisheye": "◉",
    "\\flat": "♭",
    "\\fltns": "⏥",
    "\\forall": "∀",
    "\\forks": "⫝̸",
    "\\forksnot": "⫝",
    "\\forkv": "⫙",
    "\\fourth": "⁗",
    "\\fourvdots": "⦙",
    "\\fracslash": "⁄",
    "\\frown": "⌢",
    "\\frownie": "☹",
    "\\fullouterjoin": "⟗",
    "\\gamma": "𝛾",
    "\\gemini": "♊",
    "\\geq": "≥",
    "\\geqq": "≧",
    "\\geqqslant": "⫺",
    "\\geqslant": "⩾",
    "\\gescc": "⪩",
    "\\gesdot": "⪀",
    "\\gesdoto": "⪂",
    "\\gesdotol": "⪄",
    "\\gesles": "⪔",
    "\\gg": "≫",
    "\\ggcurly": "⪼",
    "\\ggg": "⋙",
    "\\gggnest": "⫸",
    "\\gimel": "ℷ",
    "\\glE": "⪒",
    "\\gla": "⪥",
    "\\gleichstark": "⧦",
    "\\glj": "⪤",
    "\\gnapprox": "⪊",
    "\\gneq": "⪈",
    "\\gneqq": "≩",
    "\\gnsim": "⋧",
    "\\grave": "̀",
    "\\gsime": "⪎",
    "\\gsiml": "⪐",
    "\\gtcir": "⩺",
    "\\gtlpar": "⦠",
    "\\gtquest": "⩼",
    "\\gtrapprox": "⪆",
    "\\gtrarr": "⥸",
    "\\gtrdot": "⋗",
    "\\gtreqless": "⋛",
    "\\gtreqqless": "⪌",
    "\\gtrless": "≷",
    "\\gtrsim": "≳",
    "\\harrowextender": "⎯",
    "\\hash": "⋕",
    "\\hat": "̂",
    "\\hatapprox": "⩯",
    "\\hbar": "ℏ",
    "\\heartsuit": "♡",
    "\\hermitmatrix": "⊹",
    "\\hexagon": "⎔",
    "\\hexagonblack": "⬣",
    "\\hknearrow": "⤤",
    "\\hknwarrow": "⤣",
    "\\hksearow": "⤥",
    "\\hkswarow": "⤦",
    "\\hookleftarrow": "↩",
    "\\hookrightarrow": "↪",
    "\\horizbar": "―",
    "\\hourglass": "⧖",
    "\\house": "⌂",
    "\\hrectangle": "▭",
    "\\hrectangleblack": "▬",
    "\\hslash": "ℏ",
    "\\hyphenbullet": "⁃",
    "\\hzigzag": "〰",
    "\\iddots": "⋰",
    "\\iiiint": "⨌",
    "\\iiint": "∭",
    "\\iinfin": "⧜",
    "\\iint": "∬",
    "\\imath": "𝚤",
    "\\in": "∈",
    "\\increment": "∆",
    "\\infty": "∞",
    "\\int": "∫",
    "\\intBar": "⨎",
    "\\intbar": "⨍",
    "\\intbottom": "⌡",
    "\\intcap": "⨙",
    "\\intclockwise": "∱",
    "\\intcup": "⨚",
    "\\intercal": "⊺",
    "\\interleave": "⫴",
    "\\intextender": "⎮",
    "\\intlarhk": "⨗",
    "\\intprod": "⨼",
    "\\intprodr": "⨽",
    "\\inttop": "⌠",
    "\\intx": "⨘",
    "\\invamp": "⅋",
    "\\invdiameter": "⍉",
    "\\inversebullet": "◘",
    "\\inversewhitecircle": "◙",
    "\\invlazys": "∾",
    "\\invneg": "⌐",
    "\\invwhitelowerhalfcircle": "◛",
    "\\invwhiteupperhalfcircle": "◚",
    "\\iota": "𝜄",
    "\\isinE": "⋹",
    "\\isindot": "⋵",
    "\\isinobar": "⋷",
    "\\isins": "⋴",
    "\\isinvb": "⋸",
    "\\jmath": "𝚥",
    "\\jupiter": "♃",
    "\\kappa": "𝜅",
    "\\kernelcontraction": "∻",
    "\\koppa": "ϟ",
    "\\lBrace": "⦃",
    "\\lambda": "𝜆",
    "\\lang": "⟪",
    "\\langle": "⟨",
    "\\langledot": "⦑",
    "\\laplac": "⧠",
    "\\lat": "⪫",
    "\\late": "⪭",
    "\\lblkbrbrak": "⦗",
    "\\lblot": "⦉",
    "\\lbracelend": "⎩",
    "\\lbracemid": "⎨",
    "\\lbraceuend": "⎧",
    "\\lbrack": "[",
    "\\lbrackextender": "⎢",
    "\\lbracklend": "⎣",
    "\\lbracklltick": "⦏",
    "\\lbrackubar": "⦋",
    "\\lbrackuend": "⎡",
    "\\lbrackultick": "⦍",
    "\\lbrbrak": "〔",
    "\\lceil": "⌈",
    "\\lcurvyangle": "⧼",
    "\\ldots": "…",
    "\\leadsto": "⤳",
    "\\leftarrow": "←",
    "\\leftarrowapprox": "⭊",
    "\\leftarrowbackapprox": "⭂",
    "\\leftarrowbsimilar": "⭋",
    "\\leftarrowless": "⥷",
    "\\leftarrowonoplus": "⬲",
    "\\leftarrowplus": "⥆",
    "\\leftarrowshortrightarrow": "⥃",
    "\\leftarrowsimilar": "⥳",
    "\\leftarrowsubset": "⥺",
    "\\leftarrowtail": "↢",
    "\\leftarrowtriangle": "⇽",
    "\\leftarrowx": "⬾",
    "\\leftbarharpoon": "⥪",
    "\\leftbkarrow": "⤌",
    "\\leftcurvedarrow": "⬿",
    "\\leftdbkarrow": "⤎",
    "\\leftdbltail": "⤛",
    "\\leftdotarrow": "⬸",
    "\\leftdowncurvedarrow": "⤶",
    "\\leftharpoondown": "↽",
    "\\leftharpoonup": "↼",
    "\\leftleftarrows": "⇇",
    "\\leftleftharpoons": "⥢",
    "\\leftmoon": "☾",
    "\\leftouterjoin": "⟕",
    "\\leftrightarrow": "↔",
    "\\leftrightarrowcircle": "⥈",
    "\\leftrightarrows": "⇆",
    "\\leftrightarrowtriangle": "⇿",
    "\\leftrightharpoon": "⥊",
    "\\leftrightharpoondown": "⥐",
    "\\leftrightharpoons": "⇋",
    "\\leftrightharpoonsdown": "⥧",
    "\\leftrightharpoonsup": "⥦",
    "\\leftrightharpoonup": "⥎",
    "\\leftrightsquigarrow": "↭",
    "\\leftslice": "⪦",
    "\\leftsquigarrow": "⇜",
    "\\lefttail": "⤙",
    "\\leftthreearrows": "⬱",
    "\\leftthreetimes": "⋋",
    "\\leftupdownharpoon": "⥑",
    "\\leftwavearrow": "↜",
    "\\leftwhitearrow": "⇦",
    "\\leo": "♌",
    "\\leq": "≤",
    "\\leqq": "≦",
    "\\leqqslant": "⫹",
    "\\leqslant": "⩽",
    "\\lescc": "⪨",
    "\\lesdot": "⩿",
    "\\lesdoto": "⪁",
    "\\lesdotor": "⪃",
    "\\lesges": "⪓",
    "\\lessapprox": "⪅",
    "\\lessdot": "⋖",
    "\\lesseqgtr": "⋚",
    "\\lesseqqgtr": "⪋",
    "\\lessgtr": "≶",
    "\\lesssim": "≲",
    "\\lfbowtie": "⧑",
    "\\lfloor": "⌊",
    "\\lftimes": "⧔",
    "\\lgE": "⪑",
    "\\lgblkcircle": "⬤",
    "\\lgroup": "⟮",
    "\\lgwhtcircle": "◯",
    "\\lhd": "◁",
    "\\libra": "♎",
    "\\lightning": "↯",
    "\\limg": "⦇",
    "\\linefeed": "↴",
    "\\ll": "≪",
    "\\llarc": "◟",
    "\\llblacktriangle": "◣",
    "\\llbracket": "⟦",
    "\\llcorner": "⌞",
    "\\llcurly": "⪻",
    "\\lll": "⋘",
    "\\lllnest": "⫷",
    "\\lltriangle": "◺",
    "\\lmoustache": "⎰",
    "\\lnapprox": "⪉",
    "\\lneq": "⪇",
    "\\lneqq": "≨",
    "\\lnsim": "⋦",
    "\\longdashv": "⟞",
    "\\longdivision": "⟌",
    "\\longleftarrow": "⟵",
    "\\longleftrightarrow": "⟷",
    "\\longleftsquigarrow": "⬳",
    "\\longmapsfrom": "⟻",
    "\\longmapsto": "⟼",
    "\\longrightarrow": "⟶",
    "\\longrightsquigarrow": "⟿",
    "\\looparrowleft": "↫",
    "\\looparrowright": "↬",
    "\\lowint": "⨜",
    "\\lozenge": "◊",
    "\\lozengeminus": "⟠",
    "\\lparenextender": "⎜",
    "\\lparenlend": "⎝",
    "\\lparenless": "⦓",
    "\\lparenuend": "⎛",
    "\\lrarc": "◞",
    "\\lrblacktriangle": "◢",
    "\\lrcorner": "⌟",
    "\\lrtriangle": "◿",
    "\\lrtriangleeq": "⧡",
    "\\lsime": "⪍",
    "\\lsimg": "⪏",
    "\\lsqhook": "⫍",
    "\\ltcir": "⩹",
    "\\ltimes": "⋉",
    "\\ltlarr": "⥶",
    "\\ltquest": "⩻",
    "\\lvboxline": "⎸",
    "\\lvec": "⃐",
    "\\lvzigzag": "⧘",
    "\\male": "♂",
    "\\maltese": "✠",
    "\\mapsfrom": "↤",
    "\\mapsto": "↦",
    "\\mathbb{0}": "𝟘",
    "\\mathbb{1}": "𝟙",
    "\\mathbb{2}": "𝟚",
    "\\mathbb{3}": "𝟛",
    "\\mathbb{4}": "𝟜",
    "\\mathbb{5}": "𝟝",
    "\\mathbb{6}": "𝟞",
    "\\mathbb{7}": "𝟟",
    "\\mathbb{8}": "𝟠",
    "\\mathbb{9}": "𝟡",
    "\\mathbb{A}": "𝔸",
    "\\mathbb{B}": "𝔹",
    "\\mathbb{C}": "ℂ",
    "\\mathbb{D}": "𝔻",
    "\\mathbb{E}": "𝔼",
    "\\mathbb{F}": "𝔽",
    "\\mathbb{G}": "𝔾",
    "\\mathbb{H}": "ℍ",
    "\\mathbb{I}": "𝕀",
    "\\mathbb{J}": "𝕁",
    "\\mathbb{K}": "𝕂",
    "\\mathbb{L}": "𝕃",
    "\\mathbb{M}": "𝕄",
    "\\mathbb{N}": "ℕ",
    "\\mathbb{O}": "𝕆",
    "\\mathbb{P}": "ℙ",
    "\\mathbb{Q}": "ℚ",
    "\\mathbb{R}": "ℝ",
    "\\mathbb{S}": "𝕊",
    "\\mathbb{T}": "𝕋",
    "\\mathbb{U}": "𝕌",
    "\\mathbb{V}": "𝕍",
    "\\mathbb{W}": "𝕎",
    "\\mathbb{X}": "𝕏",
    "\\mathbb{Y}": "𝕐",
    "\\mathbb{Z}": "ℤ",
    "\\mathbb{\\Gamma}": "ℾ",
    "\\mathbb{\\Pi}": "ℿ",
    "\\mathbb{\\Sigma}": "⅀",
    "\\mathbb{\\gamma}": "ℽ",
    "\\mathbb{\\pi}": "ℼ",
    "\\mathbb{a}": "𝕒",
    "\\mathbb{b}": "𝕓",
    "\\mathbb{c}": "𝕔",
    "\\mathbb{d}": "𝕕",
    "\\mathbb{e}": "𝕖",
    "\\mathbb{f}": "𝕗",
    "\\mathbb{g}": "𝕘",
    "\\mathbb{h}": "𝕙",
    "\\mathbb{i}": "𝕚",
    "\\mathbb{j}": "𝕛",
    "\\mathbb{k}": "𝕜",
    "\\mathbb{l}": "𝕝",
    "\\mathbb{m}": "𝕞",
    "\\mathbb{n}": "𝕟",
    "\\mathbb{o}": "𝕠",
    "\\mathbb{p}": "𝕡",
    "\\mathbb{q}": "𝕢",
    "\\mathbb{r}": "𝕣",
    "\\mathbb{s}": "𝕤",
    "\\mathbb{t}": "𝕥",
    "\\mathbb{u}": "𝕦",
    "\\mathbb{v}": "𝕧",
    "\\mathbb{w}": "𝕨",
    "\\mathbb{x}": "𝕩",
    "\\mathbb{y}": "𝕪",
    "\\mathbb{z}": "𝕫",
    "\\mathbfit{A}": "𝑨",
    "\\mathbfit{B}": "𝑩",
    "\\mathbfit{C}": "𝑪",
    "\\mathbfit{D}": "𝑫",
    "\\mathbfit{E}": "𝑬",
    "\\mathbfit{F}": "𝑭",
    "\\mathbfit{G}": "𝑮",
    "\\mathbfit{H}": "𝑯",
    "\\mathbfit{I}": "𝑰",
    "\\mathbfit{J}": "𝑱",
    "\\mathbfit{K}": "𝑲",
    "\\mathbfit{L}": "𝑳",
    "\\mathbfit{M}": "𝑴",
    "\\mathbfit{N}": "𝑵",
    "\\mathbfit{O}": "𝑶",
    "\\mathbfit{P}": "𝑷",
    "\\mathbfit{Q}": "𝑸",
    "\\mathbfit{R}": "𝑹",
    "\\mathbfit{S}": "𝑺",
    "\\mathbfit{T}": "𝑻",
    "\\mathbfit{U}": "𝑼",
    "\\mathbfit{V}": "𝑽",
    "\\mathbfit{W}": "𝑾",
    "\\mathbfit{X}": "𝑿",
    "\\mathbfit{Y}": "𝒀",
    "\\mathbfit{Z}": "𝒁",
    "\\mathbfit{\\Delta}": "𝜟",
    "\\mathbfit{\\Gamma}": "𝜞",
    "\\mathbfit{\\Lambda}": "𝜦",
    "\\mathbfit{\\Omega}": "𝜴",
    "\\mathbfit{\\Phi}": "𝜱",
    "\\mathbfit{\\Pi}": "𝜫",
    "\\mathbfit{\\Psi}": "𝜳",
    "\\mathbfit{\\Sigma}": "𝜮",
    "\\mathbfit{\\Theta}": "𝜣",
    "\\mathbfit{\\Upsilon}": "𝜰",
    "\\mathbfit{\\Xi}": "𝜩",
    "\\mathbfit{\\alpha}": "𝜶",
    "\\mathbfit{\\beta}": "𝜷",
    "\\mathbfit{\\chi}": "𝝌",
    "\\mathbfit{\\delta}": "𝜹",
    "\\mathbfit{\\epsilon}": "𝝐",
    "\\mathbfit{\\eta}": "𝜼",
    "\\mathbfit{\\gamma}": "𝜸",
    "\\mathbfit{\\iota}": "𝜾",
    "\\mathbfit{\\kappa}": "𝜿",
    "\\mathbfit{\\lambda}": "𝝀",
    "\\mathbfit{\\mu}": "𝝁",
    "\\mathbfit{\\nu}": "𝝂",
    "\\mathbfit{\\omega}": "𝝎",
    "\\mathbfit{\\phi}": "𝝓",
    "\\mathbfit{\\pi}": "𝝅",
    "\\mathbfit{\\psi}": "𝝍",
    "\\mathbfit{\\rho}": "𝝆",
    "\\mathbfit{\\sigma}": "𝝈",
    "\\mathbfit{\\tau}": "𝝉",
    "\\mathbfit{\\theta}": "𝜽",
    "\\mathbfit{\\upsilon}": "𝝊",
    "\\mathbfit{\\varepsilon}": "𝜺",
    "\\mathbfit{\\varphi}": "𝝋",
    "\\mathbfit{\\varpi}": "𝝕",
    "\\mathbfit{\\varrho}": "𝝔",
    "\\mathbfit{\\varsigma}": "𝝇",
    "\\mathbfit{\\vartheta}": "𝝑",
    "\\mathbfit{\\xi}": "𝝃",
    "\\mathbfit{\\zeta}": "𝜻",
    "\\mathbfit{a}": "𝒂",
    "\\mathbfit{b}": "𝒃",
    "\\mathbfit{c}": "𝒄",
    "\\mathbfit{d}": "𝒅",
    "\\mathbfit{e}": "𝒆",
    "\\mathbfit{f}": "𝒇",
    "\\mathbfit{g}": "𝒈",
    "\\mathbfit{h}": "𝒉",
    "\\mathbfit{i}": "𝒊",
    "\\mathbfit{j}": "𝒋",
    "\\mathbfit{k}": "𝒌",
    "\\mathbfit{l}": "𝒍",
    "\\mathbfit{m}": "𝒎",
    "\\mathbfit{n}": "𝒏",
    "\\mathbfit{o}": "𝒐",
    "\\mathbfit{p}": "𝒑",
    "\\mathbfit{q}": "𝒒",
    "\\mathbfit{r}": "𝒓",
    "\\mathbfit{s}": "𝒔",
    "\\mathbfit{t}": "𝒕",
    "\\mathbfit{u}": "𝒖",
    "\\mathbfit{v}": "𝒗",
    "\\mathbfit{w}": "𝒘",
    "\\mathbfit{x}": "𝒙",
    "\\mathbfit{y}": "𝒚",
    "\\mathbfit{z}": "𝒛",
    "\\mathbf{0}": "𝟎",
    "\\mathbf{1}": "𝟏",
    "\\mathbf{2}": "𝟐",
    "\\mathbf{3}": "𝟑",
    "\\mathbf{4}": "𝟒",
    "\\mathbf{5}": "𝟓",
    "\\mathbf{6}": "𝟔",
    "\\mathbf{7}": "𝟕",
    "\\mathbf{8}": "𝟖",
    "\\mathbf{9}": "𝟗",
    "\\mathbf{A}": "𝐀",
    "\\mathbf{B}": "𝐁",
    "\\mathbf{C}": "𝐂",
    "\\mathbf{D}": "𝐃",
    "\\mathbf{E}": "𝐄",
    "\\mathbf{F}": "𝐅",
    "\\mathbf{G}": "𝐆",
    "\\mathbf{H}": "𝐇",
    "\\mathbf{I}": "𝐈",
    "\\mathbf{J}": "𝐉",
    "\\mathbf{K}": "𝐊",
    "\\mathbf{L}": "𝐋",
    "\\mathbf{M}": "𝐌",
    "\\mathbf{N}": "𝐍",
    "\\mathbf{O}": "𝐎",
    "\\mathbf{P}": "𝐏",
    "\\mathbf{Q}": "𝐐",
    "\\mathbf{R}": "𝐑",
    "\\mathbf{S}": "𝐒",
    "\\mathbf{T}": "𝐓",
    "\\mathbf{U}": "𝐔",
    "\\mathbf{V}": "𝐕",
    "\\mathbf{W}": "𝐖",
    "\\mathbf{X}": "𝐗",
    "\\mathbf{Y}": "𝐘",
    "\\mathbf{Z}": "𝐙",
    "\\mathbf{\\Delta}": "𝚫",
    "\\mathbf{\\Gamma}": "𝚪",
    "\\mathbf{\\Lambda}": "𝚲",
    "\\mathbf{\\Omega}": "𝛀",
    "\\mathbf{\\Phi}": "𝚽",
    "\\mathbf{\\Pi}": "𝚷",
    "\\mathbf{\\Psi}": "𝚿",
    "\\mathbf{\\Sigma}": "𝚺",
    "\\mathbf{\\Theta}": "𝚯",
    "\\mathbf{\\Upsilon}": "𝚼",
    "\\mathbf{\\Xi}": "𝚵",
    "\\mathbf{\\alpha}": "𝛂",
    "\\mathbf{\\beta}": "𝛃",
    "\\mathbf{\\chi}": "𝛘",
    "\\mathbf{\\delta}": "𝛅",
    "\\mathbf{\\epsilon}": "𝛜",
    "\\mathbf{\\eta}": "𝛈",
    "\\mathbf{\\gamma}": "𝛄",
    "\\mathbf{\\iota}": "𝛊",
    "\\mathbf{\\kappa}": "𝛋",
    "\\mathbf{\\lambda}": "𝛌",
    "\\mathbf{\\mu}": "𝛍",
    "\\mathbf{\\nu}": "𝛎",
    "\\mathbf{\\omega}": "𝛚",
    "\\mathbf{\\phi}": "𝛟",
    "\\mathbf{\\pi}": "𝛑",
    "\\mathbf{\\psi}": "𝛙",
    "\\mathbf{\\rho}": "𝛒",
    "\\mathbf{\\sigma}": "𝛔",
    "\\mathbf{\\tau}": "𝛕",
    "\\mathbf{\\theta}": "𝛉",
    "\\mathbf{\\upsilon}": "𝛖",
    "\\mathbf{\\varepsilon}": "𝛆",
    "\\mathbf{\\varphi}": "𝛗",
    "\\mathbf{\\varpi}": "𝛡",
    "\\mathbf{\\varrho}": "𝛠",
    "\\mathbf{\\varsigma}": "𝛓",
    "\\mathbf{\\vartheta}": "𝛝",
    "\\mathbf{\\xi}": "𝛏",
    "\\mathbf{\\zeta}": "𝛇",
    "\\mathbf{a}": "𝐚",
    "\\mathbf{b}": "𝐛",
    "\\mathbf{c}": "𝐜",
    "\\mathbf{d}": "𝐝",
    "\\mathbf{e}": "𝐞",
    "\\mathbf{f}": "𝐟",
    "\\mathbf{g}": "𝐠",
    "\\mathbf{h}": "𝐡",
    "\\mathbf{i}": "𝐢",
    "\\mathbf{j}": "𝐣",
    "\\mathbf{k}": "𝐤",
    "\\mathbf{l}": "𝐥",
    "\\mathbf{m}": "𝐦",
    "\\mathbf{n}": "𝐧",
    "\\mathbf{o}": "𝐨",
    "\\mathbf{p}": "𝐩",
    "\\mathbf{q}": "𝐪",
    "\\mathbf{r}": "𝐫",
    "\\mathbf{s}": "𝐬",
    "\\mathbf{t}": "𝐭",
    "\\mathbf{u}": "𝐮",
    "\\mathbf{v}": "𝐯",
    "\\mathbf{w}": "𝐰",
    "\\mathbf{x}": "𝐱",
    "\\mathbf{y}": "𝐲",
    "\\mathbf{z}": "𝐳",
    "\\mathcal{A}": "𝒜",
    "\\mathcal{B}": "ℬ",
    "\\mathcal{C}": "𝒞",
    "\\mathcal{D}": "𝒟",
    "\\mathcal{E}": "ℰ",
    "\\mathcal{F}": "ℱ",
    "\\mathcal{G}": "𝒢",
    "\\mathcal{H}": "ℋ",
    "\\mathcal{I}": "ℐ",
    "\\mathcal{J}": "𝒥",
    "\\mathcal{K}": "𝒦",
    "\\mathcal{L}": "ℒ",
    "\\mathcal{M}": "ℳ",
    "\\mathcal{N}": "𝒩",
    "\\mathcal{O}": "𝒪",
    "\\mathcal{P}": "𝒫",
    "\\mathcal{Q}": "𝒬",
    "\\mathcal{R}": "ℛ",
    "\\mathcal{S}": "𝒮",
    "\\mathcal{T}": "𝒯",
    "\\mathcal{U}": "𝒰",
    "\\mathcal{V}": "𝒱",
    "\\mathcal{W}": "𝒲",
    "\\mathcal{X}": "𝒳",
    "\\mathcal{Y}": "𝒴",
    "\\mathcal{Z}": "𝒵",
    "\\mathcal{a}": "𝒶",
    "\\mathcal{b}": "𝒷",
    "\\mathcal{c}": "𝒸",
    "\\mathcal{d}": "𝒹",
    "\\mathcal{e}": "ℯ",
    "\\mathcal{f}": "𝒻",
    "\\mathcal{g}": "ℊ",
    "\\mathcal{h}": "𝒽",
    "\\mathcal{i}": "𝒾",
    "\\mathcal{j}": "𝒿",
    "\\mathcal{k}": "𝓀",
    "\\mathcal{l}": "𝓁",
    "\\mathcal{m}": "𝓂",
    "\\mathcal{n}": "𝓃",
    "\\mathcal{o}": "ℴ",
    "\\mathcal{p}": "𝓅",
    "\\mathcal{q}": "𝓆",
    "\\mathcal{r}": "𝓇",
    "\\mathcal{s}": "𝓈",
    "\\mathcal{t}": "𝓉",
    "\\mathcal{u}": "𝓊",
    "\\mathcal{v}": "𝓋",
    "\\mathcal{w}": "𝓌",
    "\\mathcal{x}": "𝓍",
    "\\mathcal{y}": "𝓎",
    "\\mathcal{z}": "𝓏",
    "\\mathfrak{A}": "𝔄",
    "\\mathfrak{B}": "𝔅",
    "\\mathfrak{C}": "ℭ",
    "\\mathfrak{D}": "𝔇",
    "\\mathfrak{E}": "𝔈",
    "\\mathfrak{F}": "𝔉",
    "\\mathfrak{G}": "𝔊",
    "\\mathfrak{H}": "ℌ",
    "\\mathfrak{J}": "𝔍",
    "\\mathfrak{K}": "𝔎",
    "\\mathfrak{L}": "𝔏",
    "\\mathfrak{M}": "𝔐",
    "\\mathfrak{N}": "𝔑",
    "\\mathfrak{O}": "𝔒",
    "\\mathfrak{P}": "𝔓",
    "\\mathfrak{Q}": "𝔔",
    "\\mathfrak{S}": "𝔖",
    "\\mathfrak{T}": "𝔗",
    "\\mathfrak{U}": "𝔘",
    "\\mathfrak{V}": "𝔙",
    "\\mathfrak{W}": "𝔚",
    "\\mathfrak{X}": "𝔛",
    "\\mathfrak{Y}": "𝔜",
    "\\mathfrak{Z}": "ℨ",
    "\\mathfrak{a}": "𝔞",
    "\\mathfrak{b}": "𝔟",
    "\\mathfrak{c}": "𝔠",
    "\\mathfrak{d}": "𝔡",
    "\\mathfrak{e}": "𝔢",
    "\\mathfrak{f}": "𝔣",
    "\\mathfrak{g}": "𝔤",
    "\\mathfrak{h}": "𝔥",
    "\\mathfrak{i}": "𝔦",
    "\\mathfrak{j}": "𝔧",
    "\\mathfrak{k}": "𝔨",
    "\\mathfrak{l}": "𝔩",
    "\\mathfrak{m}": "𝔪",
    "\\mathfrak{n}": "𝔫",
    "\\mathfrak{o}": "𝔬",
    "\\mathfrak{p}": "𝔭",
    "\\mathfrak{q}": "𝔮",
    "\\mathfrak{r}": "𝔯",
    "\\mathfrak{s}": "𝔰",
    "\\mathfrak{t}": "𝔱",
    "\\mathfrak{u}": "𝔲",
    "\\mathfrak{v}": "𝔳",
    "\\mathfrak{w}": "𝔴",
    "\\mathfrak{x}": "𝔵",
    "\\mathfrak{y}": "𝔶",
    "\\mathfrak{z}": "𝔷",
    "\\mathring": "̊",
    "\\mathsfbfit{A}": "𝘼",
    "\\mathsfbfit{B}": "𝘽",
    "\\mathsfbfit{C}": "𝘾",
    "\\mathsfbfit{D}": "𝘿",
    "\\mathsfbfit{E}": "𝙀",
    "\\mathsfbfit{F}": "𝙁",
    "\\mathsfbfit{G}": "𝙂",
    "\\mathsfbfit{H}": "𝙃",
    "\\mathsfbfit{I}": "𝙄",
    "\\mathsfbfit{J}": "𝙅",
    "\\mathsfbfit{K}": "𝙆",
    "\\mathsfbfit{L}": "𝙇",
    "\\mathsfbfit{M}": "𝙈",
    "\\mathsfbfit{N}": "𝙉",
    "\\mathsfbfit{O}": "𝙊",
    "\\mathsfbfit{P}": "𝙋",
    "\\mathsfbfit{Q}": "𝙌",
    "\\mathsfbfit{R}": "𝙍",
    "\\mathsfbfit{S}": "𝙎",
    "\\mathsfbfit{T}": "𝙏",
    "\\mathsfbfit{U}": "𝙐",
    "\\mathsfbfit{V}": "𝙑",
    "\\mathsfbfit{W}": "𝙒",
    "\\mathsfbfit{X}": "𝙓",
    "\\mathsfbfit{Y}": "𝙔",
    "\\mathsfbfit{Z}": "𝙕",
    "\\mathsfbfit{\\Delta}": "𝞓",
    "\\mathsfbfit{\\Gamma}": "𝞒",
    "\\mathsfbfit{\\Lambda}": "𝞚",
    "\\mathsfbfit{\\Omega}": "𝞨",
    "\\mathsfbfit{\\Phi}": "𝞥",
    "\\mathsfbfit{\\Pi}": "𝞟",
    "\\mathsfbfit{\\Psi}": "𝞧",
    "\\mathsfbfit{\\Sigma}": "𝞢",
    "\\mathsfbfit{\\Theta}": "𝞗",
    "\\mathsfbfit{\\Upsilon}": "𝞤",
    "\\mathsfbfit{\\Xi}": "𝞝",
    "\\mathsfbfit{\\alpha}": "𝞪",
    "\\mathsfbfit{\\beta}": "𝞫",
    "\\mathsfbfit{\\chi}": "𝟀",
    "\\mathsfbfit{\\delta}": "𝞭",
    "\\mathsfbfit{\\epsilon}": "𝟄",
    "\\mathsfbfit{\\eta}": "𝞰",
    "\\mathsfbfit{\\gamma}": "𝞬",
    "\\mathsfbfit{\\iota}": "𝞲",
    "\\mathsfbfit{\\kappa}": "𝞳",
    "\\mathsfbfit{\\lambda}": "𝞴",
    "\\mathsfbfit{\\mu}": "𝞵",
    "\\mathsfbfit{\\nu}": "𝞶",
    "\\mathsfbfit{\\omega}": "𝟂",
    "\\mathsfbfit{\\phi}": "𝟇",
    "\\mathsfbfit{\\pi}": "𝞹",
    "\\mathsfbfit{\\psi}": "𝟁",
    "\\mathsfbfit{\\rho}": "𝞺",
    "\\mathsfbfit{\\sigma}": "𝞼",
    "\\mathsfbfit{\\tau}": "𝞽",
    "\\mathsfbfit{\\theta}": "𝞱",
    "\\mathsfbfit{\\upsilon}": "𝞾",
    "\\mathsfbfit{\\varepsilon}": "𝞮",
    "\\mathsfbfit{\\varphi}": "𝞿",
    "\\mathsfbfit{\\varpi}": "𝟉",
    "\\mathsfbfit{\\varrho}": "𝟈",
    "\\mathsfbfit{\\varsigma}": "𝞻",
    "\\mathsfbfit{\\vartheta}": "𝟅",
    "\\mathsfbfit{\\xi}": "𝞷",
    "\\mathsfbfit{\\zeta}": "𝞯",
    "\\mathsfbfit{a}": "𝙖",
    "\\mathsfbfit{b}": "𝙗",
    "\\mathsfbfit{c}": "𝙘",
    "\\mathsfbfit{d}": "𝙙",
    "\\mathsfbfit{e}": "𝙚",
    "\\mathsfbfit{f}": "𝙛",
    "\\mathsfbfit{g}": "𝙜",
    "\\mathsfbfit{h}": "𝙝",
    "\\mathsfbfit{i}": "𝙞",
    "\\mathsfbfit{j}": "𝙟",
    "\\mathsfbfit{k}": "𝙠",
    "\\mathsfbfit{l}": "𝙡",
    "\\mathsfbfit{m}": "𝙢",
    "\\mathsfbfit{n}": "𝙣",
    "\\mathsfbfit{o}": "𝙤",
    "\\mathsfbfit{p}": "𝙥",
    "\\mathsfbfit{q}": "𝙦",
    "\\mathsfbfit{r}": "𝙧",
    "\\mathsfbfit{s}": "𝙨",
    "\\mathsfbfit{t}": "𝙩",
    "\\mathsfbfit{u}": "𝙪",
    "\\mathsfbfit{v}": "𝙫",
    "\\mathsfbfit{w}": "𝙬",
    "\\mathsfbfit{x}": "𝙭",
    "\\mathsfbfit{y}": "𝙮",
    "\\mathsfbfit{z}": "𝙯",
    "\\mathsfbf{0}": "𝟬",
    "\\mathsfbf{1}": "𝟭",
    "\\mathsfbf{2}": "𝟮",
    "\\mathsfbf{3}": "𝟯",
    "\\mathsfbf{4}": "𝟰",
    "\\mathsfbf{5}": "𝟱",
    "\\mathsfbf{6}": "𝟲",
    "\\mathsfbf{7}": "𝟳",
    "\\mathsfbf{8}": "𝟴",
    "\\mathsfbf{9}": "𝟵",
    "\\mathsfbf{A}": "𝗔",
    "\\mathsfbf{B}": "𝗕",
    "\\mathsfbf{C}": "𝗖",
    "\\mathsfbf{D}": "𝗗",
    "\\mathsfbf{E}": "𝗘",
    "\\mathsfbf{F}": "𝗙",
    "\\mathsfbf{G}": "𝗚",
    "\\mathsfbf{H}": "𝗛",
    "\\mathsfbf{I}": "𝗜",
    "\\mathsfbf{J}": "𝗝",
    "\\mathsfbf{K}": "𝗞",
    "\\mathsfbf{L}": "𝗟",
    "\\mathsfbf{M}": "𝗠",
    "\\mathsfbf{N}": "𝗡",
    "\\mathsfbf{O}": "𝗢",
    "\\mathsfbf{P}": "𝗣",
    "\\mathsfbf{Q}": "𝗤",
    "\\mathsfbf{R}": "𝗥",
    "\\mathsfbf{S}": "𝗦",
    "\\mathsfbf{T}": "𝗧",
    "\\mathsfbf{U}": "𝗨",
    "\\mathsfbf{V}": "𝗩",
    "\\mathsfbf{W}": "𝗪",
    "\\mathsfbf{X}": "𝗫",
    "\\mathsfbf{Y}": "𝗬",
    "\\mathsfbf{Z}": "𝗭",
    "\\mathsfbf{\\Delta}": "𝝙",
    "\\mathsfbf{\\Gamma}": "𝝘",
    "\\mathsfbf{\\Lambda}": "𝝠",
    "\\mathsfbf{\\Omega}": "𝝮",
    "\\mathsfbf{\\Phi}": "𝝫",
    "\\mathsfbf{\\Pi}": "𝝥",
    "\\mathsfbf{\\Psi}": "𝝭",
    "\\mathsfbf{\\Sigma}": "𝝨",
    "\\mathsfbf{\\Theta}": "𝝝",
    "\\mathsfbf{\\Upsilon}": "𝝪",
    "\\mathsfbf{\\Xi}": "𝝣",
    "\\mathsfbf{\\alpha}": "𝝰",
    "\\mathsfbf{\\beta}": "𝝱",
    "\\mathsfbf{\\chi}": "𝞆",
    "\\mathsfbf{\\delta}": "𝝳",
    "\\mathsfbf{\\epsilon}": "𝞊",
    "\\mathsfbf{\\eta}": "𝝶",
    "\\mathsfbf{\\gamma}": "𝝲",
    "\\mathsfbf{\\iota}": "𝝸",
    "\\mathsfbf{\\kappa}": "𝝹",
    "\\mathsfbf{\\lambda}": "𝝺",
    "\\mathsfbf{\\mu}": "𝝻",
    "\\mathsfbf{\\nu}": "𝝼",
    "\\mathsfbf{\\omega}": "𝞈",
    "\\mathsfbf{\\phi}": "𝞍",
    "\\mathsfbf{\\pi}": "𝝿",
    "\\mathsfbf{\\psi}": "𝞇",
    "\\mathsfbf{\\rho}": "𝞀",
    "\\mathsfbf{\\sigma}": "𝞂",
    "\\mathsfbf{\\tau}": "𝞃",
    "\\mathsfbf{\\theta}": "𝝷",
    "\\mathsfbf{\\upsilon}": "𝞄",
    "\\mathsfbf{\\varepsilon}": "𝝴",
    "\\mathsfbf{\\varphi}": "𝞅",
    "\\mathsfbf{\\varpi}": "𝞏",
    "\\mathsfbf{\\varrho}": "𝞎",
    "\\mathsfbf{\\varsigma}": "𝞁",
    "\\mathsfbf{\\vartheta}": "𝞋",
    "\\mathsfbf{\\xi}": "𝝽",
    "\\mathsfbf{\\zeta}": "𝝵",
    "\\mathsfbf{a}": "𝗮",
    "\\mathsfbf{b}": "𝗯",
    "\\mathsfbf{c}": "𝗰",
    "\\mathsfbf{d}": "𝗱",
    "\\mathsfbf{e}": "𝗲",
    "\\mathsfbf{f}": "𝗳",
    "\\mathsfbf{g}": "𝗴",
    "\\mathsfbf{h}": "𝗵",
    "\\mathsfbf{i}": "𝗶",
    "\\mathsfbf{j}": "𝗷",
    "\\mathsfbf{k}": "𝗸",
    "\\mathsfbf{l}": "𝗹",
    "\\mathsfbf{m}": "𝗺",
    "\\mathsfbf{n}": "𝗻",
    "\\mathsfbf{o}": "𝗼",
    "\\mathsfbf{p}": "𝗽",
    "\\mathsfbf{q}": "𝗾",
    "\\mathsfbf{r}": "𝗿",
    "\\mathsfbf{s}": "𝘀",
    "\\mathsfbf{t}": "𝘁",
    "\\mathsfbf{u}": "𝘂",
    "\\mathsfbf{v}": "𝘃",
    "\\mathsfbf{w}": "𝘄",
    "\\mathsfbf{x}": "𝘅",
    "\\mathsfbf{y}": "𝘆",
    "\\mathsfbf{z}": "𝘇",
    "\\mathsfit{A}": "𝘈",
    "\\mathsfit{B}": "𝘉",
    "\\mathsfit{C}": "𝘊",
    "\\mathsfit{D}": "𝘋",
    "\\mathsfit{E}": "𝘌",
    "\\mathsfit{F}": "𝘍",
    "\\mathsfit{G}": "𝘎",
    "\\mathsfit{H}": "𝘏",
    "\\mathsfit{I}": "𝘐",
    "\\mathsfit{J}": "𝘑",
    "\\mathsfit{K}": "𝘒",
    "\\mathsfit{L}": "𝘓",
    "\\mathsfit{M}": "𝘔",
    "\\mathsfit{N}": "𝘕",
    "\\mathsfit{O}": "𝘖",
    "\\mathsfit{P}": "𝘗",
    "\\mathsfit{Q}": "𝘘",
    "\\mathsfit{R}": "𝘙",
    "\\mathsfit{S}": "𝘚",
    "\\mathsfit{T}": "𝘛",
    "\\mathsfit{U}": "𝘜",
    "\\mathsfit{V}": "𝘝",
    "\\mathsfit{W}": "𝘞",
    "\\mathsfit{X}": "𝘟",
    "\\mathsfit{Y}": "𝘠",
    "\\mathsfit{Z}": "𝘡",
    "\\mathsfit{a}": "𝘢",
    "\\mathsfit{b}": "𝘣",
    "\\mathsfit{c}": "𝘤",
    "\\mathsfit{d}": "𝘥",
    "\\mathsfit{e}": "𝘦",
    "\\mathsfit{f}": "𝘧",
    "\\mathsfit{g}": "𝘨",
    "\\mathsfit{h}": "𝘩",
    "\\mathsfit{i}": "𝘪",
    "\\mathsfit{j}": "𝘫",
    "\\mathsfit{k}": "𝘬",
    "\\mathsfit{l}": "𝘭",
    "\\mathsfit{m}": "𝘮",
    "\\mathsfit{n}": "𝘯",
    "\\mathsfit{o}": "𝘰",
    "\\mathsfit{p}": "𝘱",
    "\\mathsfit{q}": "𝘲",
    "\\mathsfit{r}": "𝘳",
    "\\mathsfit{s}": "𝘴",
    "\\mathsfit{t}": "𝘵",
    "\\mathsfit{u}": "𝘶",
    "\\mathsfit{v}": "𝘷",
    "\\mathsfit{w}": "𝘸",
    "\\mathsfit{x}": "𝘹",
    "\\mathsfit{y}": "𝘺",
    "\\mathsfit{z}": "𝘻",
    "\\mathsf{0}": "𝟢",
    "\\mathsf{1}": "𝟣",
    "\\mathsf{2}": "𝟤",
    "\\mathsf{3}": "𝟥",
    "\\mathsf{4}": "𝟦",
    "\\mathsf{5}": "𝟧",
    "\\mathsf{6}": "𝟨",
    "\\mathsf{7}": "𝟩",
    "\\mathsf{8}": "𝟪",
    "\\mathsf{9}": "𝟫",
    "\\mathsf{A}": "𝖠",
    "\\mathsf{B}": "𝖡",
    "\\mathsf{C}": "𝖢",
    "\\mathsf{D}": "𝖣",
    "\\mathsf{E}": "𝖤",
    "\\mathsf{F}": "𝖥",
    "\\mathsf{G}": "𝖦",
    "\\mathsf{H}": "𝖧",
    "\\mathsf{I}": "𝖨",
    "\\mathsf{J}": "𝖩",
    "\\mathsf{K}": "𝖪",
    "\\mathsf{L}": "𝖫",
    "\\mathsf{M}": "𝖬",
    "\\mathsf{N}": "𝖭",
    "\\mathsf{O}": "𝖮",
    "\\mathsf{P}": "𝖯",
    "\\mathsf{Q}": "𝖰",
    "\\mathsf{R}": "𝖱",
    "\\mathsf{S}": "𝖲",
    "\\mathsf{T}": "𝖳",
    "\\mathsf{U}": "𝖴",
    "\\mathsf{V}": "𝖵",
    "\\mathsf{W}": "𝖶",
    "\\mathsf{X}": "𝖷",
    "\\mathsf{Y}": "𝖸",
    "\\mathsf{Z}": "𝖹",
    "\\mathsf{a}": "𝖺",
    "\\mathsf{b}": "𝖻",
    "\\mathsf{c}": "𝖼",
    "\\mathsf{d}": "𝖽",
    "\\mathsf{e}": "𝖾",
    "\\mathsf{f}": "𝖿",
    "\\mathsf{g}": "𝗀",
    "\\mathsf{h}": "𝗁",
    "\\mathsf{i}": "𝗂",
    "\\mathsf{j}": "𝗃",
    "\\mathsf{k}": "𝗄",
    "\\mathsf{l}": "𝗅",
    "\\mathsf{m}": "𝗆",
    "\\mathsf{n}": "𝗇",
    "\\mathsf{o}": "𝗈",
    "\\mathsf{p}": "𝗉",
    "\\mathsf{q}": "𝗊",
    "\\mathsf{r}": "𝗋",
    "\\mathsf{s}": "𝗌",
    "\\mathsf{t}": "𝗍",
    "\\mathsf{u}": "𝗎",
    "\\mathsf{v}": "𝗏",
    "\\mathsf{w}": "𝗐",
    "\\mathsf{x}": "𝗑",
    "\\mathsf{y}": "𝗒",
    "\\mathsf{z}": "𝗓",
    "\\mathtt{0}": "𝟶",
    "\\mathtt{1}": "𝟷",
    "\\mathtt{2}": "𝟸",
    "\\mathtt{3}": "𝟹",
    "\\mathtt{4}": "𝟺",
    "\\mathtt{5}": "𝟻",
    "\\mathtt{6}": "𝟼",
    "\\mathtt{7}": "𝟽",
    "\\mathtt{8}": "𝟾",
    "\\mathtt{9}": "𝟿",
    "\\mathtt{A}": "𝙰",
    "\\mathtt{B}": "𝙱",
    "\\mathtt{C}": "𝙲",
    "\\mathtt{D}": "𝙳",
    "\\mathtt{E}": "𝙴",
    "\\mathtt{F}": "𝙵",
    "\\mathtt{G}": "𝙶",
    "\\mathtt{H}": "𝙷",
    "\\mathtt{I}": "𝙸",
    "\\mathtt{J}": "𝙹",
    "\\mathtt{K}": "𝙺",
    "\\mathtt{L}": "𝙻",
    "\\mathtt{M}": "𝙼",
    "\\mathtt{N}": "𝙽",
    "\\mathtt{O}": "𝙾",
    "\\mathtt{P}": "𝙿",
    "\\mathtt{Q}": "𝚀",
    "\\mathtt{R}": "𝚁",
    "\\mathtt{S}": "𝚂",
    "\\mathtt{T}": "𝚃",
    "\\mathtt{U}": "𝚄",
    "\\mathtt{V}": "𝚅",
    "\\mathtt{W}": "𝚆",
    "\\mathtt{X}": "𝚇",
    "\\mathtt{Y}": "𝚈",
    "\\mathtt{Z}": "𝚉",
    "\\mathtt{a}": "𝚊",
    "\\mathtt{b}": "𝚋",
    "\\mathtt{c}": "𝚌",
    "\\mathtt{d}": "𝚍",
    "\\mathtt{e}": "𝚎",
    "\\mathtt{f}": "𝚏",
    "\\mathtt{g}": "𝚐",
    "\\mathtt{h}": "𝚑",
    "\\mathtt{i}": "𝚒",
    "\\mathtt{j}": "𝚓",
    "\\mathtt{k}": "𝚔",
    "\\mathtt{l}": "𝚕",
    "\\mathtt{m}": "𝚖",
    "\\mathtt{n}": "𝚗",
    "\\mathtt{o}": "𝚘",
    "\\mathtt{p}": "𝚙",
    "\\mathtt{q}": "𝚚",
    "\\mathtt{r}": "𝚛",
    "\\mathtt{s}": "𝚜",
    "\\mathtt{t}": "𝚝",
    "\\mathtt{u}": "𝚞",
    "\\mathtt{v}": "𝚟",
    "\\mathtt{w}": "𝚠",
    "\\mathtt{x}": "𝚡",
    "\\mathtt{y}": "𝚢",
    "\\mathtt{z}": "𝚣",
    "\\mbfAlpha": "𝚨",
    "\\mbfBeta": "𝚩",
    "\\mbfChi": "𝚾",
    "\\mbfDigamma": "𝟊",
    "\\mbfEpsilon": "𝚬",
    "\\mbfEta": "𝚮",
    "\\mbfIota": "𝚰",
    "\\mbfKappa": "𝚱",
    "\\mbfMu": "𝚳",
    "\\mbfNu": "𝚴",
    "\\mbfOmicron": "𝚶",
    "\\mbfRho": "𝚸",
    "\\mbfTau": "𝚻",
    "\\mbfZeta": "𝚭",
    "\\mbfdigamma": "𝟋",
    "\\mbffrakA": "𝕬",
    "\\mbffrakB": "𝕭",
    "\\mbffrakC": "𝕮",
    "\\mbffrakD": "𝕯",
    "\\mbffrakE": "𝕰",
    "\\mbffrakF": "𝕱",
    "\\mbffrakG": "𝕲",
    "\\mbffrakH": "𝕳",
    "\\mbffrakI": "𝕴",
    "\\mbffrakJ": "𝕵",
    "\\mbffrakK": "𝕶",
    "\\mbffrakL": "𝕷",
    "\\mbffrakM": "𝕸",
    "\\mbffrakN": "𝕹",
    "\\mbffrakO": "𝕺",
    "\\mbffrakP": "𝕻",
    "\\mbffrakQ": "𝕼",
    "\\mbffrakR": "𝕽",
    "\\mbffrakS": "𝕾",
    "\\mbffrakT": "𝕿",
    "\\mbffrakU": "𝖀",
    "\\mbffrakV": "𝖁",
    "\\mbffrakW": "𝖂",
    "\\mbffrakX": "𝖃",
    "\\mbffrakY": "𝖄",
    "\\mbffrakZ": "𝖅",
    "\\mbffraka": "𝖆",
    "\\mbffrakb": "𝖇",
    "\\mbffrakc": "𝖈",
    "\\mbffrakd": "𝖉",
    "\\mbffrake": "𝖊",
    "\\mbffrakf": "𝖋",
    "\\mbffrakg": "𝖌",
    "\\mbffrakh": "𝖍",
    "\\mbffraki": "𝖎",
    "\\mbffrakj": "𝖏",
    "\\mbffrakk": "𝖐",
    "\\mbffrakl": "𝖑",
    "\\mbffrakm": "𝖒",
    "\\mbffrakn": "𝖓",
    "\\mbffrako": "𝖔",
    "\\mbffrakp": "𝖕",
    "\\mbffrakq": "𝖖",
    "\\mbffrakr": "𝖗",
    "\\mbffraks": "𝖘",
    "\\mbffrakt": "𝖙",
    "\\mbffraku": "𝖚",
    "\\mbffrakv": "𝖛",
    "\\mbffrakw": "𝖜",
    "\\mbffrakx": "𝖝",
    "\\mbffraky": "𝖞",
    "\\mbffrakz": "𝖟",
    "\\mbfitAlpha": "𝜜",
    "\\mbfitBeta": "𝜝",
    "\\mbfitChi": "𝜲",
    "\\mbfitEpsilon": "𝜠",
    "\\mbfitEta": "𝜢",
    "\\mbfitIota": "𝜤",
    "\\mbfitKappa": "𝜥",
    "\\mbfitMu": "𝜧",
    "\\mbfitNu": "𝜨",
    "\\mbfitOmicron": "𝜪",
    "\\mbfitRho": "𝜬",
    "\\mbfitTau": "𝜯",
    "\\mbfitZeta": "𝜡",
    "\\mbfitnabla": "𝜵",
    "\\mbfitomicron": "𝝄",
    "\\mbfitpartial": "𝝏",
    "\\mbfitsansAlpha": "𝞐",
    "\\mbfitsansBeta": "𝞑",
    "\\mbfitsansChi": "𝞦",
    "\\mbfitsansEpsilon": "𝞔",
    "\\mbfitsansEta": "𝞖",
    "\\mbfitsansIota": "𝞘",
    "\\mbfitsansKappa": "𝞙",
    "\\mbfitsansMu": "𝞛",
    "\\mbfitsansNu": "𝞜",
    "\\mbfitsansOmicron": "𝞞",
    "\\mbfitsansRho": "𝞠",
    "\\mbfitsansTau": "𝞣",
    "\\mbfitsansZeta": "𝞕",
    "\\mbfitsansnabla": "𝞩",
    "\\mbfitsansomicron": "𝞸",
    "\\mbfitsanspartial": "𝟃",
    "\\mbfitsansvarTheta": "𝞡",
    "\\mbfitsansvarkappa": "𝟆",
    "\\mbfitvarTheta": "𝜭",
    "\\mbfitvarkappa": "𝝒",
    "\\mbfnabla": "𝛁",
    "\\mbfomicron": "𝛐",
    "\\mbfpartial": "𝛛",
    "\\mbfsansAlpha": "𝝖",
    "\\mbfsansBeta": "𝝗",
    "\\mbfsansChi": "𝝬",
    "\\mbfsansEpsilon": "𝝚",
    "\\mbfsansEta": "𝝜",
    "\\mbfsansIota": "𝝞",
    "\\mbfsansKappa": "𝝟",
    "\\mbfsansMu": "𝝡",
    "\\mbfsansNu": "𝝢",
    "\\mbfsansOmicron": "𝝤",
    "\\mbfsansRho": "𝝦",
    "\\mbfsansTau": "𝝩",
    "\\mbfsansZeta": "𝝛",
    "\\mbfsansnabla": "𝝯",
    "\\mbfsansomicron": "𝝾",
    "\\mbfsanspartial": "𝞉",
    "\\mbfsansvarTheta": "𝝧",
    "\\mbfsansvarkappa": "𝞌",
    "\\mbfscrA": "𝓐",
    "\\mbfscrB": "𝓑",
    "\\mbfscrC": "𝓒",
    "\\mbfscrD": "𝓓",
    "\\mbfscrE": "𝓔",
    "\\mbfscrF": "𝓕",
    "\\mbfscrG": "𝓖",
    "\\mbfscrH": "𝓗",
    "\\mbfscrI": "𝓘",
    "\\mbfscrJ": "𝓙",
    "\\mbfscrK": "𝓚",
    "\\mbfscrL": "𝓛",
    "\\mbfscrM": "𝓜",
    "\\mbfscrN": "𝓝",
    "\\mbfscrO": "𝓞",
    "\\mbfscrP": "𝓟",
    "\\mbfscrQ": "𝓠",
    "\\mbfscrR": "𝓡",
    "\\mbfscrS": "𝓢",
    "\\mbfscrT": "𝓣",
    "\\mbfscrU": "𝓤",
    "\\mbfscrV": "𝓥",
    "\\mbfscrW": "𝓦",
    "\\mbfscrX": "𝓧",
    "\\mbfscrY": "𝓨",
    "\\mbfscrZ": "𝓩",
    "\\mbfscra": "𝓪",
    "\\mbfscrb": "𝓫",
    "\\mbfscrc": "𝓬",
    "\\mbfscrd": "𝓭",
    "\\mbfscre": "𝓮",
    "\\mbfscrf": "𝓯",
    "\\mbfscrg": "𝓰",
    "\\mbfscrh": "𝓱",
    "\\mbfscri": "𝓲",
    "\\mbfscrj": "𝓳",
    "\\mbfscrk": "𝓴",
    "\\mbfscrl": "𝓵",
    "\\mbfscrm": "𝓶",
    "\\mbfscrn": "𝓷",
    "\\mbfscro": "𝓸",
    "\\mbfscrp": "𝓹",
    "\\mbfscrq": "𝓺",
    "\\mbfscrr": "𝓻",
    "\\mbfscrs": "𝓼",
    "\\mbfscrt": "𝓽",
    "\\mbfscru": "𝓾",
    "\\mbfscrv": "𝓿",
    "\\mbfscrw": "𝔀",
    "\\mbfscrx": "𝔁",
    "\\mbfscry": "𝔂",
    "\\mbfscrz": "𝔃",
    "\\mbfvarTheta": "𝚹",
    "\\mbfvarkappa": "𝛞",
    "\\mdblkdiamond": "⬥",
    "\\mdblklozenge": "⬧",
    "\\mdlgblksquare": "■",
    "\\mdlgwhtsquare": "□",
    "\\mdsmblksquare": "◾",
    "\\mdsmwhtcircle": "⚬",
    "\\mdsmwhtsquare": "◽",
    "\\mdwhtdiamond": "⬦",
    "\\mdwhtlozenge": "⬨",
    "\\measangledltosw": "⦯",
    "\\measangledrtose": "⦮",
    "\\measangleldtosw": "⦫",
    "\\measanglelutonw": "⦩",
    "\\measanglerdtose": "⦪",
    "\\measanglerutone": "⦨",
    "\\measangleultonw": "⦭",
    "\\measangleurtone": "⦬",
    "\\measeq": "≞",
    "\\measuredangle": "∡",
    "\\measuredangleleft": "⦛",
    "\\measuredrightangle": "⊾",
    "\\medblackstar": "⭑",
    "\\medbullet": "⚫",
    "\\medcirc": "⚪",
    "\\medwhitestar": "⭐",
    "\\mercury": "☿",
    "\\mho": "℧",
    "\\mid": "∣",
    "\\midbarvee": "⩝",
    "\\midbarwedge": "⩜",
    "\\midcir": "⫰",
    "\\minusdot": "⨪",
    "\\minusfdots": "⨫",
    "\\minusrdots": "⨬",
    "\\mitAlpha": "𝛢",
    "\\mitBeta": "𝛣",
    "\\mitChi": "𝛸",
    "\\mitEpsilon": "𝛦",
    "\\mitEta": "𝛨",
    "\\mitIota": "𝛪",
    "\\mitKappa": "𝛫",
    "\\mitMu": "𝛭",
    "\\mitNu": "𝛮",
    "\\mitOmicron": "𝛰",
    "\\mitRho": "𝛲",
    "\\mitTau": "𝛵",
    "\\mitZeta": "𝛧",
    "\\mitnabla": "𝛻",
    "\\mitomicron": "𝜊",
    "\\mitvarTheta": "𝛳",
    "\\mlcp": "⫛",
    "\\models": "⊧",
    "\\modtwosum": "⨊",
    "\\mp": "∓",
    "\\mu": "𝜇",
    "\\multimap": "⊸",
    "\\multimapboth": "⧟",
    "\\multimapdotbothA": "⊶",
    "\\multimapdotbothB": "⊷",
    "\\multimapinv": "⟜",
    "\\nHdownarrow": "⇟",
    "\\nHuparrow": "⇞",
    "\\nLeftarrow": "⇍",
    "\\nLeftrightarrow": "⇎",
    "\\nRightarrow": "⇏",
    "\\nVDash": "⊯",
    "\\nVdash": "⊮",
    "\\nVleftarrow": "⇺",
    "\\nVleftarrowtail": "⬺",
    "\\nVleftrightarrow": "⇼",
    "\\nVtwoheadleftarrow": "⬵",
    "\\nVtwoheadleftarrowtail": "⬽",
    "\\nVtwoheadrightarrow": "⤁",
    "\\nVtwoheadrightarrowtail": "⤘",
    "\\nabla": "∇",
    "\\napprox": "≉",
    "\\natural": "♮",
    "\\ncong": "≇",
    "\\nearrow": "↗",
    "\\neg": "¬",
    "\\neovnwarrow": "⤱",
    "\\neovsearrow": "⤮",
    "\\neptune": "♆",
    "\\neq": "≠",
    "\\nequiv": "≢",
    "\\neswarrow": "⤢",
    "\\neuter": "⚲",
    "\\nexists": "∄",
    "\\ngeq": "≱",
    "\\ngtr": "≯",
    "\\nhVvert": "⫵",
    "\\nhpar": "⫲",
    "\\ni": "∋",
    "\\niobar": "⋾",
    "\\nis": "⋼",
    "\\nisd": "⋺",
    "\\nleftarrow": "↚",
    "\\nleftrightarrow": "↮",
    "\\nleq": "≰",
    "\\nless": "≮",
    "\\nlessgtr": "≸",
    "\\nmid": "∤",
    "\\nni": "∌",
    "\\not": "̸",
    "\\notasymp": "≭",
    "\\notbackslash": "⍀",
    "\\notin": "∉",
    "\\notslash": "⌿",
    "\\nparallel": "∦",
    "\\npolint": "⨔",
    "\\nprec": "⊀",
    "\\npreceq": "⋠",
    "\\nrightarrow": "↛",
    "\\nsim": "≁",
    "\\nsimeq": "≄",
    "\\nsqsubseteq": "⋢",
    "\\nsqsupseteq": "⋣",
    "\\nsubset": "⊄",
    "\\nsubseteq": "⊈",
    "\\nsucc": "⊁",
    "\\nsucceq": "⋡",
    "\\nsupset": "⊅",
    "\\nsupseteq": "⊉",
    "\\ntriangleleft": "⋪",
    "\\ntrianglelefteq": "⋬",
    "\\ntriangleright": "⋫",
    "\\ntrianglerighteq": "⋭",
    "\\nu": "𝜈",
    "\\nvDash": "⊭",
    "\\nvLeftarrow": "⤂",
    "\\nvLeftrightarrow": "⤄",
    "\\nvRightarrow": "⤃",
    "\\nvdash": "⊬",
    "\\nvinfty": "⧞",
    "\\nvleftarrow": "⇷",
    "\\nvleftarrowtail": "⬹",
    "\\nvleftrightarrow": "⇹",
    "\\nvtwoheadleftarrow": "⬴",
    "\\nvtwoheadleftarrowtail": "⬼",
    "\\nvtwoheadrightarrowtail": "⤗",
    "\\nwarrow": "↖",
    "\\nwovnearrow": "⤲",
    "\\nwsearrow": "⤡",
    "\\obar": "⌽",
    "\\obot": "⦺",
    "\\obrbrak": "⏠",
    "\\ocommatopright": "̕",
    "\\odiv": "⨸",
    "\\odot": "⊙",
    "\\odotslashdot": "⦼",
    "\\oiiint": "∰",
    "\\oiint": "∯",
    "\\oint": "∮",
    "\\ointctrclockwise": "∳",
    "\\olcross": "⦻",
    "\\omega": "𝜔",
    "\\ominus": "⊖",
    "\\operp": "⦹",
    "\\oplus": "⊕",
    "\\opluslhrim": "⨭",
    "\\oplusrhrim": "⨮",
    "\\oslash": "⊘",
    "\\otimes": "⊗",
    "\\otimeshat": "⨶",
    "\\otimeslhrim": "⨴",
    "\\otimesrhrim": "⨵",
    "\\oturnedcomma": "̒",
    "\\overbrace": "⏞",
    "\\overbracket": "⎴",
    "\\overleftrightarrow": "⃡",
    "\\overline": "̅",
    "\\overparen": "⏜",
    "\\ovhook": "̉",
    "\\parallel": "∥",
    "\\parallelogram": "▱",
    "\\parallelogramblack": "▰",
    "\\parsim": "⫳",
    "\\partial": "∂",
    "\\partialmeetcontraction": "⪣",
    "\\pencil": "✎",
    "\\pentagon": "⬠",
    "\\pentagonblack": "⬟",
    "\\perp": "⟂",
    "\\perps": "⫡",
    "\\pfun": "⇸",
    "\\phi": "𝜙",
    "\\phone": "☎",
    "\\pi": "𝜋",
    "\\pinj": "⤔",
    "\\pisces": "♓",
    "\\pitchfork": "⋔",
    "\\plusdot": "⨥",
    "\\pluseqq": "⩲",
    "\\plushat": "⨣",
    "\\plussim": "⨦",
    "\\plussubtwo": "⨧",
    "\\plustrif": "⨨",
    "\\pluto": "♇",
    "\\pm": "±",
    "\\pointint": "⨕",
    "\\pointright": "☞",
    "\\postalmark": "〒",
    "\\pounds": "£",
    "\\prec": "≺",
    "\\precapprox": "⪷",
    "\\preccurlyeq": "≼",
    "\\preceq": "⪯",
    "\\preceqq": "⪳",
    "\\precnapprox": "⪹",
    "\\precneq": "⪱",
    "\\precneqq": "⪵",
    "\\precnsim": "⋨",
    "\\precsim": "≾",
    "\\prime": "′",
    "\\prod": "∏",
    "\\profline": "⌒",
    "\\profsurf": "⌓",
    "\\propto": "∝",
    "\\prurel": "⊰",
    "\\psi": "𝜓",
    "\\psur": "⤀",
    "\\pullback": "⟓",
    "\\pushout": "⟔",
    "\\qoppa": "ϙ",
    "\\quad": "\u2001",
    "\\quarternote": "♩",
    "\\questeq": "≟",
    "\\rBrace": "⦄",
    "\\radiation": "☢",
    "\\rang": "⟫",
    "\\rangle": "⟩",
    "\\rangledot": "⦒",
    "\\rangledownzigzagarrow": "⍼",
    "\\rblkbrbrak": "⦘",
    "\\rblot": "⦊",
    "\\rbracelend": "⎭",
    "\\rbracemid": "⎬",
    "\\rbraceuend": "⎫",
    "\\rbrack": "]",
    "\\rbrackextender": "⎥",
    "\\rbracklend": "⎦",
    "\\rbracklrtick": "⦎",
    "\\rbrackubar": "⦌",
    "\\rbrackuend": "⎤",
    "\\rbrackurtick": "⦐",
    "\\rbrbrak": "〕",
    "\\rceil": "⌉",
    "\\rcurvyangle": "⧽",
    "\\rdiagovfdiag": "⤫",
    "\\rdiagovsearrow": "⤰",
    "\\recycle": "♻",
    "\\revangle": "⦣",
    "\\revangleubar": "⦥",
    "\\revemptyset": "⦰",
    "\\revnmid": "⫮",
    "\\rfbowtie": "⧒",
    "\\rfloor": "⌋",
    "\\rftimes": "⧕",
    "\\rgroup": "⟯",
    "\\rhd": "▷",
    "\\rho": "𝜌",
    "\\rightangle": "∟",
    "\\rightanglemdot": "⦝",
    "\\rightanglesqr": "⦜",
    "\\rightarrow": "→",
    "\\rightarrowapprox": "⥵",
    "\\rightarrowbackapprox": "⭈",
    "\\rightarrowbsimilar": "⭌",
    "\\rightarrowdiamond": "⤞",
    "\\rightarrowgtr": "⭃",
    "\\rightarrowonoplus": "⟴",
    "\\rightarrowplus": "⥅",
    "\\rightarrowshortleftarrow": "⥂",
    "\\rightarrowsimilar": "⥴",
    "\\rightarrowsupset": "⭄",
    "\\rightarrowtail": "↣",
    "\\rightarrowtriangle": "⇾",
    "\\rightarrowx": "⥇",
    "\\rightbarharpoon": "⥬",
    "\\rightbkarrow": "⤍",
    "\\rightdbltail": "⤜",
    "\\rightdotarrow": "⤑",
    "\\rightdowncurvedarrow": "⤷",
    "\\rightharpoondown": "⇁",
    "\\rightharpoonup": "⇀",
    "\\rightimply": "⥰",
    "\\rightleftarrows": "⇄",
    "\\rightleftharpoon": "⥋",
    "\\rightleftharpoons": "⇌",
    "\\rightleftharpoonsdown": "⥩",
    "\\rightleftharpoonsup": "⥨",
    "\\rightmoon": "☽",
    "\\rightouterjoin": "⟖",
    "\\rightpentagon": "⭔",
    "\\rightpentagonblack": "⭓",
    "\\rightrightarrows": "⇉",
    "\\rightrightharpoons": "⥤",
    "\\rightslice": "⪧",
    "\\rightsquigarrow": "⇝",
    "\\righttail": "⤚",
    "\\rightthreearrows": "⇶",
    "\\rightthreetimes": "⋌",
    "\\rightupdownharpoon": "⥏",
    "\\rightwavearrow": "↝",
    "\\rightwhitearrow": "⇨",
    "\\rimg": "⦈",
    "\\ringplus": "⨢",
    "\\risingdotseq": "≓",
    "\\rmoustache": "⎱",
    "\\rparenextender": "⎟",
    "\\rparengtr": "⦔",
    "\\rparenlend": "⎠",
    "\\rparenuend": "⎞",
    "\\rppolint": "⨒",
    "\\rrbracket": "⟧",
    "\\rsolbar": "⧷",
    "\\rsqhook": "⫎",
    "\\rsub": "⩥",
    "\\rtimes": "⋊",
    "\\rtriltri": "⧎",
    "\\ruledelayed": "⧴",
    "\\rvboxline": "⎹",
    "\\rvzigzag": "⧙",
    "\\sagittarius": "♐",
    "\\sampi": "ϡ",
    "\\sansLmirrored": "⅃",
    "\\sansLturned": "⅂",
    "\\saturn": "♄",
    "\\scorpio": "♏",
    "\\scpolint": "⨓",
    "\\scurel": "⊱",
    "\\searrow": "↘",
    "\\second": "″",
    "\\seovnearrow": "⤭",
    "\\setminus": "⧵",
    "\\sharp": "♯",
    "\\shortdowntack": "⫟",
    "\\shortlefttack": "⫞",
    "\\shortrightarrowleftarrow": "⥄",
    "\\shortuptack": "⫠",
    "\\shuffle": "⧢",
    "\\sigma": "𝜎",
    "\\sim": "∼",
    "\\simeq": "≃",
    "\\simgE": "⪠",
    "\\simgtr": "⪞",
    "\\similarleftarrow": "⭉",
    "\\similarrightarrow": "⥲",
    "\\simlE": "⪟",
    "\\simless": "⪝",
    "\\simminussim": "⩬",
    "\\simneqq": "≆",
    "\\simplus": "⨤",
    "\\simrdots": "⩫",
    "\\sixteenthnote": "♬",
    "\\skull": "☠",
    "\\slash": "̸",
    "\\smallin": "∊",
    "\\smallni": "∍",
    "\\smallsetminus": "∖",
    "\\smalltriangledown": "▿",
    "\\smalltriangleleft": "◃",
    "\\smalltriangleright": "▹",
    "\\smalltriangleup": "▵",
    "\\smashtimes": "⨳",
    "\\smblkdiamond": "⬩",
    "\\smblklozenge": "⬪",
    "\\smblksquare": "▪",
    "\\smeparsl": "⧤",
    "\\smile": "⌣",
    "\\smiley": "☺",
    "\\smt": "⪪",
    "\\smte": "⪬",
    "\\smwhitestar": "⭒",
    "\\smwhtcircle": "◦",
    "\\smwhtlozenge": "⬫",
    "\\smwhtsquare": "▫",
    "\\spadesuit": "♠",
    "\\spddot": "¨",
    "\\sphat": "",
    "\\sphericalangle": "∢",
    "\\sphericalangleup": "⦡",
    "\\spot": "⦁",
    "\\sptilde": "~",
    "\\sqcap": "⊓",
    "\\sqcup": "⊔",
    "\\sqint": "⨖",
    "\\sqrt": "√",
    "\\sqrt[3]": "∛",
    "\\sqrt[4]": "∜",
    "\\sqrtbottom": "⎷",
    "\\sqsubset": "⊏",
    "\\sqsubseteq": "⊑",
    "\\sqsubsetneq": "⋤",
    "\\sqsupset": "⊐",
    "\\sqsupseteq": "⊒",
    "\\sqsupsetneq": "⋥",
    "\\square": "⬜",
    "\\squarebotblack": "⬓",
    "\\squarecrossfill": "▩",
    "\\squarehfill": "▤",
    "\\squarehvfill": "▦",
    "\\squareleftblack": "◧",
    "\\squarellblack": "⬕",
    "\\squarellquad": "◱",
    "\\squarelrblack": "◪",
    "\\squarelrquad": "◲",
    "\\squareneswfill": "▨",
    "\\squarenwsefill": "▧",
    "\\squarerightblack": "◨",
    "\\squaretopblack": "⬒",
    "\\squareulblack": "◩",
    "\\squareulquad": "◰",
    "\\squareurblack": "⬔",
    "\\squareurquad": "◳",
    "\\squarevfill": "▥",
    "\\squoval": "▢",
    "\\sslash": "⫽",
    "\\star": "⋆",
    "\\stareq": "≛",
    "\\steaming": "☕",
    "\\stigma": "ϛ",
    "\\strictfi": "⥼",
    "\\strictif": "⥽",
    "\\strns": "⏤",
    "\\subedot": "⫃",
    "\\submult": "⫁",
    "\\subrarr": "⥹",
    "\\subset": "⊂",
    "\\subsetapprox": "⫉",
    "\\subsetcirc": "⟃",
    "\\subsetdot": "⪽",
    "\\subseteq": "⊆",
    "\\subseteqq": "⫅",
    "\\subsetneq": "⊊",
    "\\subsetneqq": "⫋",
    "\\subsetplus": "⪿",
    "\\subsim": "⫇",
    "\\subsub": "⫕",
    "\\subsup": "⫓",
    "\\succ": "≻",
    "\\succapprox": "⪸",
    "\\succcurlyeq": "≽",
    "\\succeq": "⪰",
    "\\succeqq": "⪴",
    "\\succnapprox": "⪺",
    "\\succneq": "⪲",
    "\\succneqq": "⪶",
    "\\succnsim": "⋩",
    "\\succsim": "≿",
    "\\sum": "∑",
    "\\sumbottom": "⎳",
    "\\sumint": "⨋",
    "\\sumtop": "⎲",
    "\\sun": "☼",
    "\\supdsub": "⫘",
    "\\supedot": "⫄",
    "\\suphsol": "⟉",
    "\\suphsub": "⫗",
    "\\suplarr": "⥻",
    "\\supmult": "⫂",
    "\\supset": "⊃",
    "\\supsetapprox": "⫊",
    "\\supsetcirc": "⟄",
    "\\supsetdot": "⪾",
    "\\supseteq": "⊇",
    "\\supseteqq": "⫆",
    "\\supsetneq": "⊋",
    "\\supsetneqq": "⫌",
    "\\supsetplus": "⫀",
    "\\supsim": "⫈",
    "\\supsub": "⫔",
    "\\supsup": "⫖",
    "\\swarrow": "↙",
    "\\swords": "⚔",
    "\\talloblong": "⫾",
    "\\tau": "𝜏",
    "\\taurus": "♉",
    "\\tcohm": "Ω",
    "\\therefore": "∴",
    "\\thermod": "⧧",
    "\\theta": "𝜃",
    "\\thinspace": "\u2009",
    "\\third": "‴",
    "\\threedangle": "⟀",
    "\\threedotcolon": "⫶",
    "\\threeunderdot": "⃨",
    "\\tieinfty": "⧝",
    "\\tilde": "̃",
    "\\times": "×",
    "\\timesbar": "⨱",
    "\\tminus": "⧿",
    "\\to": "→",
    "\\toea": "⤨",
    "\\tona": "⤧",
    "\\top": "⊤",
    "\\topbot": "⌶",
    "\\topcir": "⫱",
    "\\topfork": "⫚",
    "\\topsemicircle": "◠",
    "\\tosa": "⤩",
    "\\towa": "⤪",
    "\\tplus": "⧾",
    "\\trapezium": "⏢",
    "\\trianglecdot": "◬",
    "\\triangleleftblack": "◭",
    "\\trianglelefteq": "⊴",
    "\\triangleminus": "⨺",
    "\\triangleodot": "⧊",
    "\\triangleplus": "⨹",
    "\\triangleq": "≜",
    "\\trianglerightblack": "◮",
    "\\trianglerighteq": "⊵",
    "\\triangles": "⧌",
    "\\triangleserifs": "⧍",
    "\\triangletimes": "⨻",
    "\\triangleubar": "⧋",
    "\\tripleplus": "⧻",
    "\\trslash": "⫻",
    "\\turnangle": "⦢",
    "\\turnediota": "℩",
    "\\turnednot": "⌙",
    "\\twocaps": "⩋",
    "\\twocups": "⩊",
    "\\twoheaddownarrow": "↡",
    "\\twoheadleftarrow": "↞",
    "\\twoheadleftarrowtail": "⬻",
    "\\twoheadleftdbkarrow": "⬷",
    "\\twoheadmapsfrom": "⬶",
    "\\twoheadmapsto": "⤅",
    "\\twoheadrightarrow": "↠",
    "\\twoheaduparrow": "↟",
    "\\twoheaduparrowcircle": "⥉",
    "\\twolowline": "‗",
    "\\twonotes": "♫",
    "\\typecolon": "⦂",
    "\\ubrbrak": "⏡",
    "\\ularc": "◜",
    "\\ulblacktriangle": "◤",
    "\\ulcorner": "⌜",
    "\\ultriangle": "◸",
    "\\uminus": "⩁",
    "\\underbar": "̱",
    "\\underbrace": "⏟",
    "\\underbracket": "⎵",
    "\\underleftarrow": "⃮",
    "\\underleftharpoondown": "⃭",
    "\\underline": "̲",
    "\\underparen": "⏝",
    "\\underrightarrow": "⃯",
    "\\underrightharpoondown": "⃬",
    "\\upAlpha": "Α",
    "\\upBeta": "Β",
    "\\upChi": "Χ",
    "\\upEpsilon": "Ε",
    "\\upEta": "Η",
    "\\upIota": "Ι",
    "\\upKappa": "Κ",
    "\\upMu": "Μ",
    "\\upNu": "Ν",
    "\\upOmicron": "Ο",
    "\\upRho": "Ρ",
    "\\upTau": "Τ",
    "\\upUpsilon": "ϒ",
    "\\upZeta": "Ζ",
    "\\uparrow": "↑",
    "\\uparrowbarred": "⤉",
    "\\uparrowoncircle": "⦽",
    "\\updasharrow": "⇡",
    "\\updownarrow": "↕",
    "\\updownarrowbar": "↨",
    "\\updownarrows": "⇅",
    "\\updownharpoonleftright": "⥍",
    "\\updownharpoonrightleft": "⥌",
    "\\updownharpoons": "⥮",
    "\\upfishtail": "⥾",
    "\\upharpoonleft": "↿",
    "\\upharpoonright": "↾",
    "\\upin": "⟒",
    "\\upint": "⨛",
    "\\uplus": "⊎",
    "\\upomicron": "ο",
    "\\uprightcurvearrow": "⤴",
    "\\upsilon": "𝜐",
    "\\upuparrows": "⇈",
    "\\upupharpoons": "⥣",
    "\\upvarTheta": "ϴ",
    "\\upwhitearrow": "⇧",
    "\\uranus": "♅",
    "\\urarc": "◝",
    "\\urblacktriangle": "◥",
    "\\urcorner": "⌝",
    "\\urtriangle": "◹",
    "\\utilde": "̰",
    "\\vBar": "⫨",
    "\\vBarv": "⫩",
    "\\vDash": "⊨",
    "\\vDdash": "⫢",
    "\\varVdash": "⫦",
    "\\varbarwedge": "⌅",
    "\\varbeta": "ϐ",
    "\\varcarriagereturn": "⏎",
    "\\varclubsuit": "♧",
    "\\vardiamondsuit": "♦",
    "\\vardoublebarwedge": "⌆",
    "\\varepsilon": "𝜀",
    "\\varheartsuit": "♥",
    "\\varhexagon": "⬡",
    "\\varhexagonblack": "⬢",
    "\\varhexagonlrbonds": "⌬",
    "\\varisins": "⋳",
    "\\varkappa": "𝜘",
    "\\varlrtriangle": "⊿",
    "\\varniobar": "⋽",
    "\\varnis": "⋻",
    "\\varnothing": "∅",
    "\\varointclockwise": "∲",
    "\\varphi": "𝜑",
    "\\varpi": "𝜛",
    "\\varprod": "⨉",
    "\\varrho": "𝜚",
    "\\varsigma": "𝜍",
    "\\varspadesuit": "♤",
    "\\varstar": "✶",
    "\\vartheta": "𝜗",
    "\\vartriangleleft": "⊲",
    "\\vartriangleright": "⊳",
    "\\varveebar": "⩡",
    "\\vbraceextender": "⎪",
    "\\vdash": "⊢",
    "\\vdots": "⋮",
    "\\vec": "⃗",
    "\\vectimes": "⨯",
    "\\vee": "∨",
    "\\veebar": "⊻",
    "\\veedot": "⟇",
    "\\veedoublebar": "⩣",
    "\\veeeq": "≚",
    "\\veemidvert": "⩛",
    "\\veeodot": "⩒",
    "\\veeonvee": "⩖",
    "\\veeonwedge": "⩙",
    "\\vertoverlay": "⃒",
    "\\viewdata": "⌗",
    "\\virgo": "♍",
    "\\vlongdash": "⟝",
    "\\vrectangle": "▯",
    "\\vrectangleblack": "▮",
    "\\vysmblksquare": "⬝",
    "\\vysmwhtsquare": "⬞",
    "\\vzigzag": "⦚",
    "\\warning": "⚠",
    "\\wasylozenge": "⌑",
    "\\wedge": "∧",
    "\\wedgebar": "⩟",
    "\\wedgedot": "⟑",
    "\\wedgedoublebar": "⩠",
    "\\wedgemidvert": "⩚",
    "\\wedgeodot": "⩑",
    "\\wedgeonwedge": "⩕",
    "\\whitearrowupfrombar": "⇪",
    "\\whiteinwhitetriangle": "⟁",
    "\\whitepointerleft": "◅",
    "\\whitepointerright": "▻",
    "\\whitesquaretickleft": "⟤",
    "\\whitesquaretickright": "⟥",
    "\\whthorzoval": "⬭",
    "\\whtvertoval": "⬯",
    "\\wideangledown": "⦦",
    "\\wideangleup": "⦧",
    "\\widebridgeabove": "⃩",
    "\\wp": "℘",
    "\\wr": "≀",
    "\\xi": "𝜉",
    "\\xsol": "⧸",
    "\\yen": "¥",
    "\\yinyang": "☯",
    "\\zcmp": "⨟",
    "\\zeta": "𝜁",
    "\\zhide": "⧹",
    "\\zpipe": "⨠",
    "\\zproject": "⨡",
    "\\{": "{",
    "\\|": "‖",
    "\\}": "}",
    "^{(}": "⁽",
    "^{)}": "⁾",
    "^{+}": "⁺",
    "^{-}": "⁻",
    "^{0}": "⁰",
    "^{1}": "¹",
    "^{2}": "²",
    "^{3}": "³",
    "^{4}": "⁴",
    "^{5}": "⁵",
    "^{6}": "⁶",
    "^{7}": "⁷",
    "^{8}": "⁸",
    "^{9}": "⁹",
    "^{=}": "⁼",
    "^{A}": "ᴬ",
    "^{B}": "ᴮ",
    "^{C}": "\ua7f2",
    "^{D}": "ᴰ",
    "^{E}": "ᴱ",
    "^{F}": "\ua7f3",
    "^{G}": "ᴳ",
    "^{H}": "ᴴ",
    "^{I}": "ᴵ",
    "^{J}": "ᴶ",
    "^{K}": "ᴷ",
    "^{L}": "ᴸ",
    "^{M}": "ᴹ",
    "^{N}": "ᴺ",
    "^{O}": "ᴼ",
    "^{P}": "ᴾ",
    "^{Q}": "\ua7f4",
    "^{R}": "ᴿ",
    "^{T}": "ᵀ",
    "^{U}": "ᵁ",
    "^{V}": "ⱽ",
    "^{W}": "ᵂ",
    "^{\\ast}": "*",
    "^{\\beta}": "ᵝ",
    "^{\\chi}": "ᵡ",
    "^{\\delta}": "ᵟ",
    "^{\\epsilon}": "ᵋ",
    "^{\\gamma}": "ᵞ",
    "^{\\iota}": "ᶥ",
    "^{\\phi}": "ᵠ",
    "^{\\theta}": "ᶿ",
    "^{\\upsilon}": "ᶹ",
    "^{a}": "ᵃ",
    "^{b}": "ᵇ",
    "^{c}": "ᶜ",
    "^{d}": "ᵈ",
    "^{e}": "ᵉ",
    "^{f}": "ᶠ",
    "^{g}": "ᵍ",
    "^{h}": "ʰ",
    "^{i}": "ⁱ",
    "^{j}": "ʲ",
    "^{k}": "ᵏ",
    "^{l}": "ˡ",
    "^{m}": "ᵐ",
    "^{n}": "ⁿ",
    "^{o}": "ᵒ",
    "^{p}": "ᵖ",
    "^{q}": "\U000107a5",
    "^{r}": "ʳ",
    "^{s}": "ˢ",
    "^{t}": "ᵗ",
    "^{u}": "ᵘ",
    "^{v}": "ᵛ",
    "^{w}": "ʷ",
    "^{x}": "ˣ",
    "^{y}": "ʸ",
    "^{z}": "ᶻ",
    "_{(}": "₍",
    "_{)}": "₎",
    "_{+}": "₊",
    "_{-}": "₋",
    "_{0}": "₀",
    "_{1}": "₁",
    "_{2}": "₂",
    "_{3}": "₃",
    "_{4}": "₄",
    "_{5}": "₅",
    "_{6}": "₆",
    "_{7}": "₇",
    "_{8}": "₈",
    "_{9}": "₉",
    "_{=}": "₌",
    "_{A}": "ₐ",
    "_{E}": "ₑ",
    "_{H}": "ₕ",
    "_{I}": "ᵢ",
    "_{J}": "ⱼ",
    "_{K}": "ₖ",
    "_{L}": "ₗ",
    "_{M}": "ₘ",
    "_{N}": "ₙ",
    "_{O}": "ₒ",
    "_{P}": "ₚ",
    "_{R}": "ᵣ",
    "_{S}": "ₛ",
    "_{T}": "ₜ",
    "_{U}": "ᵤ",
    "_{V}": "ᵥ",
    "_{X}": "ₓ",
    "_{\\beta}": "ᵦ",
    "_{\\chi}": "ᵪ",
    "_{\\gamma}": "ᵧ",
    "_{\\phi}": "ᵩ",
    "_{\\rho}": "ᵨ",
    "_{a}": "ₐ",
    "_{e}": "ₑ",
    "_{h}": "ₕ",
    "_{i}": "ᵢ",
    "_{j}": "ⱼ",
    "_{k}": "ₖ",
    "_{l}": "ₗ",
    "_{m}": "ₘ",
    "_{n}": "ₙ",
    "_{o}": "ₒ",
    "_{p}": "ₚ",
    "_{r}": "ᵣ",
    "_{s}": "ₛ",
    "_{t}": "ₜ",
    "_{u}": "ᵤ",
    "_{v}": "ᵥ",
    "_{x}": "ₓ",
    "a": "𝑎",
    "b": "𝑏",
    "c": "𝑐",
    "d": "𝑑",
    "e": "𝑒",
    "f": "𝑓",
    "g": "𝑔",
    "h": "ℎ",
    "i": "𝑖",
    "j": "𝑗",
    "k": "𝑘",
    "l": "𝑙",
    "m": "𝑚",
    "n": "𝑛",
    "o": "𝑜",
    "p": "𝑝",
    "q": "𝑞",
    "r": "𝑟",
    "s": "𝑠",
    "t": "𝑡",
    "u": "𝑢",
    "v": "𝑣",
    "w": "𝑤",
    "x": "𝑥",
    "y": "𝑦",
    "z": "𝑧",
}


HAS_ARG = {
    "\\Big",
    "\\Bigg",
    "\\LVec",
    "\\acute",
    "\\bar",
    "\\big",
    "\\breve",
    "\\check",
    "\\ddddot",
    "\\dddot",
    "\\ddot",
    "\\dot",
    "\\grave",
    "\\hat",
    "\\left",
    "\\lvec",
    "\\mathbb",
    "\\mathbf",
    "\\mathbfit",
    "\\mathcal",
    "\\mathfrak",
    "\\mathring",
    "\\mathrm",
    "\\mathsf",
    "\\mathsfbf",
    "\\mathsfbfit",
    "\\mathsfit",
    "\\mathtt",
    "\\not",
    "\\overleftrightarrow",
    "\\overline",
    "\\right",
    "\\slash",
    "\\spddot",
    "\\sqrt",
    "\\text",
    "\\tilde",
    "\\underbar",
    "\\underleftarrow",
    "\\underline",
    "\\underrightarrow",
    "\\utilde",
    "\\vec",
    "^",
    "_",
}
