import pymsteams

def post_to_teams(webhook:str,message:str) -> str:
    """
    Posts a simple message to a Teams Channel via webhook.
    Pass the webhook and message to the function and the message will be posted to the channel.

    :param webhook: a unique link generated by Microsoft Teams that allows posts to a channel via api.
    :type host: str

    :param message: The message that will be posted to said Teams channel.
    :type host: str

    :return: On success nothing is returned.
    :rtype: None
    
    :return: Upon an exception, the exception message is returned. 
    :rtype: str

    To generate a webhook:
    * Navigate to the channel where you want to add the webhook
        * select (•••) Connectors from the top navigation bar.
        * Search for Incoming Webhook, and add it.
        * Click Configure and provide a name for your webhook.
        * Copy the URL which appears and click "OK".
    """
    try:
        
        # Define connector to MS Teams - using provided webhook
        myTeamsMessage = pymsteams.connectorcard(webhook)
        # Define the message to post
        myTeamsMessage.text(message)
        # Method to post message to channel
        myTeamsMessage.send()
    except Exception as E:
        # Return any caught exceptions
        return E
    