'''Configuration for pytest.'''

import pytest

class TestDict:
    @pytest.fixture(autouse=True)
    def _test_dict(self):
    # test_dict = {'0' : {'grid_ids' : ['L0.000000', 'L0.000481', 'L0.000482','L0.000963',
        self._test_dict =  {
            0 : {
                'grid_ids' : [
                    'L0.000000', 'L0.000481', 'L0.000482','L0.000963',
                    'L0.202000','L0.202481', 'L0.202482', 'L0.202963',
                    'L0.203000', 'L0.203481', 'L0.203482', 'L0.203963',
                    'L0.405000', 'L0.405481', 'L0.405482', 'L0.405963'
                ],

            # 'centroids' : [(-17349514.33474138, 7296524.72000947), (-18016.11042, 7296524.72000947), (18016.11042, 7296524.72000947), (17349514.33474138, 7296524.72000947),
            #                 (-17349514.33474138, 18016.11042), (-18016.11042, 18016.11042), (18016.11042, 18016.11042), (17349514.33474138, 18016.11042),
            #                 (-17349514.33474138, -18016.11042), (-18016.11042, -18016.11042), (18016.11042, -18016.11042), (17349514.33474138, -18016.11042),
            #                 (-17349514.33474138, -7296524.72000947), (-18016.11042, -7296524.72000947), (18016.11042, -7296524.72000947), (17349514.33474138, -7296524.72000947)],

                'centroids' : [
                    (-17349514.33474108, 7296524.72021821), (-18016.11042, 7296524.72021821),
                    (18016.11042, 7296524.72021821), (17349514.33474138, 7296524.72021821),
                    (-17349514.33474108, 18016.11042), (-18016.11042, 18016.11042),
                    (18016.11042, 18016.11042), (17349514.33474138, 18016.11042),
                    (-17349514.33474108, -18016.11042), (-18016.11042, -18016.11042),
                    (18016.11042, -18016.11042), (17349514.33474138, -18016.11042),
                    (-17349514.33474108, -7296524.72021821), (-18016.11042, -7296524.72021821),
                    (18016.11042, -7296524.72021821), (17349514.33474138, -7296524.72021821)
                ],

                'geos' : [
                    (-179.81327800830186, 83.63197526437092),
                    (-0.18672199169821974, 83.63197526437092),
                    (0.18672199169821974, 83.63197526437092),
                    (179.81327800830186, 83.63197526437092),
                    (-179.81327800830186, 0.14122178981717845),
                    (-0.18672199169821974, 0.14122178981717845),
                    (0.18672199169821974, 0.14122178981717845),
                    (179.81327800830186, 0.14122178981717845),
                    (-179.81327800830186, -0.14122178981717845),
                    (-0.18672199169821974, -0.14122178981717845),
                    (0.18672199169821974, -0.14122178981717845),
                    (179.81327800830186, -0.14122178981717845),
                    (-179.81327800830186, -83.63197526437092),
                    (-0.18672199169821974, -83.63197526437092),
                    (0.18672199169821974, -83.63197526437092),
                    (179.81327800830186, -83.63197526437092)
                ],
            },
            1 : {
                'grid_ids' : [
                    'L1.000000.00', 'L1.000481.03', 'L1.000482.00','L1.000963.03',
                    'L1.202000.30', 'L1.202481.33', 'L1.202482.30', 'L1.202963.33',
                    'L1.203000.00', 'L1.203481.03', 'L1.203482.00', 'L1.203963.03',
                    'L1.405000.30', 'L1.405481.33', 'L1.405482.30', 'L1.405963.33'
                ],

                'centroids' : [
                    (-17363026.41755638, 7310036.80282447), (-4504.027605, 7310036.80282447),
                    (4504.027605, 7310036.80282447), (17363026.41755638, 7310036.80282447),
                    (-17363026.41755638, 4504.027605), (-4504.027605, 4504.027605),
                    (4504.027605, 4504.027605), (17363026.41755638, 4504.027605),
                    (-17363026.41755638, -4504.027605), (-4504.027605, -4504.027605),
                    (4504.027605, -4504.027605), (17363026.41755638, -4504.027605),
                    (-17363026.41755638, -7310036.80282447), (-4504.027605, -7310036.80282447),
                    (4504.027605, -7310036.80282447), (17363026.41755638, -7310036.80282447)
                ],

                'geos' : [
                    (-179.9533195020755, 84.65641877976137),
                    (-0.046680497924554934, 84.65641877976137),
                    (0.046680497924554934, 84.65641877976137),
                    (179.9533195020755, 84.65641877976137),
                    (-179.9533195020755, 0.03530541483819519),
                    (-0.046680497924554934, 0.03530541483819519),
                    (0.046680497924554934, 0.03530541483819519),
                    (179.9533195020755, 0.03530541483819519),
                    (-179.9533195020755, -0.03530541483819519),
                    (-0.046680497924554934, -0.03530541483819519),
                    (0.046680497924554934, -0.03530541483819519),
                    (179.9533195020755, -0.03530541483819519),
                    (-179.9533195020755, -84.65641877976137),
                    (-0.046680497924554934, -84.65641877976137),
                    (0.046680497924554934, -84.65641877976137),
                    (179.9533195020755, -84.65641877976137)
                ],
            },
            2 : {
                'grid_ids' :  [
                    'L2.000000.00.00', 'L2.000481.03.02', 'L2.000482.00.00', 'L2.000963.03.02',
                    'L2.202000.30.20', 'L2.202481.33.22', 'L2.202482.30.20', 'L2.202963.33.22',
                    'L2.203000.00.00', 'L2.203481.03.02', 'L2.203482.00.00', 'L2.203963.03.02',
                    'L2.405000.30.20', 'L2.405481.33.22', 'L2.405482.30.20', 'L2.405963.33.22'
                ],

                'centroids' : [
                    (-17366029.10262638, 7313039.48789447), (-1501.342535, 7313039.48789447),
                    (1501.342535, 7313039.48789447), (17366029.10262638, 7313039.48789447),
                    (-17366029.10262638, 1501.342535), (-1501.342535, 1501.342535),
                    (1501.342535, 1501.342535), (17366029.10262638, 1501.342535),
                    (-17366029.10262638, -1501.342535), (-1501.342535, -1501.342535),
                    (1501.342535, -1501.342535), (17366029.10262638, -1501.342535),
                    (-17366029.10262638, -7313039.48789447), (-1501.342535, -7313039.48789447),
                    (1501.342535, -7313039.48789447), (17366029.10262638, -7313039.48789447)
                ],

                'geos' : [
                    (-179.9844398340252, 84.91190236986583),
                    (-0.015560165974851641, 84.91190236986583),
                    (0.015560165974851641, 84.91190236986583),
                    (179.9844398340252, 84.91190236986583),
                    (-179.9844398340252, 0.011768470968464844),
                    (-0.015560165974851641, 0.011768470968464844),
                    (0.015560165974851641, 0.011768470968464844),
                    (179.9844398340252, 0.011768470968464844),
                    (-179.9844398340252, -0.011768470968464844),
                    (-0.015560165974851641, -0.011768470968464844),
                    (0.015560165974851641, -0.011768470968464844),
                    (179.9844398340252, -0.011768470968464844),
                    (-179.9844398340252, -84.91190236986583),
                    (-0.015560165974851641, -84.91190236986583),
                    (0.015560165974851641, -84.91190236986583),
                    (179.9844398340252, -84.91190236986583)
                ],
            },
            3 : {
                'grid_ids' : [
                    'L3.000000.00.00.00', 'L3.000481.03.02.02',
                    'L3.000482.00.00.00', 'L3.000963.03.02.02',
                    'L3.202000.30.20.20', 'L3.202481.33.22.22',
                    'L3.202482.30.20.20', 'L3.202963.33.22.22',
                    'L3.203000.00.00.00', 'L3.203481.03.02.02',
                    'L3.203482.00.00.00', 'L3.203963.03.02.02',
                    'L3.405000.30.20.20', 'L3.405481.33.22.22',
                    'L3.405482.30.20.20', 'L3.405963.33.22.22'
                ],
                'centroids' : [
                    (-17367029.99765138, 7314040.38291947),
                    (-500.44751, 7314040.38291947),
                    (500.44751, 7314040.38291947),
                    (17367029.99765138, 7314040.38291947),
                    (-17367029.99765138, 500.44751),
                    (-500.44751, 500.44751),
                    (500.44751, 500.44751),
                    (17367029.99765138, 500.44751),
                    (-17367029.99765138, -500.44751),
                    (-500.44751, -500.44751),
                    (500.44751, -500.44751),
                    (17367029.99765138, -500.44751),
                    (-17367029.99765138, -7314040.38291947),
                    (-500.44751, -7314040.38291947),
                    (500.44751, -7314040.38291947),
                    (17367029.99765138, -7314040.38291947)
                ],
                'geos' : [
                    (-179.99481327802573, 84.99995501468176),
                    (-0.005186721974343601, 84.99995501468176),
                    (0.005186721974343601, 84.99995501468176),
                    (179.99481327802573, 84.99995501468176),
                    (-179.99481327802573, 0.003922823619228829),
                    (-0.005186721974343601, 0.003922823619228829),
                    (0.005186721974343601, 0.003922823619228829),
                    (179.99481327802573, 0.003922823619228829),
                    (-179.99481327802573, -0.003922823619228829),
                    (-0.005186721974343601, -0.003922823619228829),
                    (0.005186721974343601, -0.003922823619228829),
                    (179.99481327802573, -0.003922823619228829),
                    (-179.99481327802573, -84.99995501468176),
                    (-0.005186721974343601, -84.99995501468176),
                    (0.005186721974343601, -84.99995501468176),
                    (179.99481327802573, -84.99995501468176)
                ],
            },
            4 : {
                'grid_ids' : [
                    'L4.000000.00.00.00.00', 'L4.000481.03.02.02.09', 'L4.000482.00.00.00.00', 'L4.000963.03.02.02.09',
                    'L4.202000.30.20.20.90', 'L4.202481.33.22.22.99', 'L4.202482.30.20.20.90', 'L4.202963.33.22.22.99',
                    'L4.203000.00.00.00.00', 'L4.203481.03.02.02.09', 'L4.203482.00.00.00.00', 'L4.203963.03.02.02.09',
                    'L4.405000.30.20.20.90', 'L4.405481.33.22.22.99', 'L4.405482.30.20.20.90', 'L4.405963.33.22.22.99'
                ],

                'centroids' : [
                    (-17367480.40041138, 7314490.78567947), (-50.04475, 7314490.78567947),
                    (50.04475, 7314490.78567947), (17367480.40041138, 7314490.78567947),
                    (-17367480.40041138, 50.04475), (-50.04475, 50.04475),
                    (50.04475, 50.04475), (17367480.40041138, 50.04475),
                    (-17367480.40041138, -50.04475), (-50.04475, -50.04475),
                    (50.04475, -50.04475), (17367480.40041138, -50.04475),
                    (-17367480.40041138, -7314490.78567947), (-50.04475, -7314490.78567947),
                    (50.04475, -7314490.78567947), (17367480.40041138, -7314490.78567947)
                ],

                'geos' : [
                    (-179.999481327813, 85.04008724408246), (-0.0005186721870701923, 85.04008724408246),
                    (0.0005186721870701923, 85.04008724408246), (179.999481327813, 85.04008724408246),
                    (-179.999481327813, 0.00039228235378896257), (-0.0005186721870701923, 0.00039228235378896257),
                    (0.0005186721870701923, 0.00039228235378896257), (179.999481327813, 0.00039228235378896257),
                    (-179.999481327813, -0.00039228235378896257), (-0.0005186721870701923, -0.00039228235378896257),
                    (0.0005186721870701923, -0.00039228235378896257), (179.999481327813, -0.00039228235378896257),
                    (-179.999481327813, -85.04008724408246), (-0.0005186721870701923, -85.04008724408246),
                    (0.0005186721870701923, -85.04008724408246), (179.999481327813, -85.04008724408246)
                ],
            },
            5 : {
                'grid_ids' : [
                    'L5.000000.00.00.00.00.00', 'L5.000481.03.02.02.09.09', 'L5.000482.00.00.00.00.00', 'L5.000963.03.02.02.09.09',
                    'L5.202000.30.20.20.90.90', 'L5.202481.33.22.22.99.99', 'L5.202482.30.20.20.90.90', 'L5.202963.33.22.22.99.99',
                    'L5.203000.00.00.00.00.00', 'L5.203481.03.02.02.09.09', 'L5.203482.00.00.00.00.00', 'L5.203963.03.02.02.09.09',
                    'L5.405000.30.20.20.90.90', 'L5.405481.33.22.22.99.99', 'L5.405482.30.20.20.90.90', 'L5.405963.33.22.22.99.99'
                ],


                'centroids' : [
                    (-17367525.44068638, 7314535.82595447), (-5.004475, 7314535.82595447),
                    (5.004475, 7314535.82595447), (17367525.44068638, 7314535.82595447),
                    (-17367525.44068638, 5.004475), (-5.004475, 5.004475),
                    (5.004475, 5.004475), (17367525.44068638, 5.004475),
                    (-17367525.44068638, -5.004475), (-5.004475, -5.004475),
                    (5.004475, -5.004475), (17367525.44068638, -5.004475),
                    (-17367525.44068638, -7314535.82595447), (-5.004475, -7314535.82595447),
                    (5.004475, -7314535.82595447), (17367525.44068638, -7314535.82595447)
                ],

                'geos' : [
                    (-179.99994813278136, 85.04411829251681),
                    (-5.1867218707019234e-05, 85.04411829251681),
                    (5.1867218707019234e-05, 85.04411829251681),
                    (179.99994813278136, 85.04411829251681),
                    (-179.99994813278136, 3.922823537860097e-05),
                    (-5.1867218707019234e-05, 3.922823537860097e-05),
                    (5.1867218707019234e-05, 3.922823537860097e-05),
                    (179.99994813278136, 3.922823537860097e-05),
                    (-179.99994813278136, -3.922823537860097e-05),
                    (-5.1867218707019234e-05, -3.922823537860097e-05),
                    (5.1867218707019234e-05, -3.922823537860097e-05),
                    (179.99994813278136, -3.922823537860097e-05),
                    (-179.99994813278136, -85.04411829251681),
                    (-5.1867218707019234e-05, -85.04411829251681),
                    (5.1867218707019234e-05, -85.04411829251681),
                    (179.99994813278136, -85.04411829251681)
                ],

            },
            6 : {
                'grid_ids' : [
                    'L6.000000.00.00.00.00.00.00',
                    'L6.000481.03.02.02.09.09.09',
                    'L6.000482.00.00.00.00.00.00',
                    'L6.000963.03.02.02.09.09.09',
                    'L6.202000.30.20.20.90.90.90',
                    'L6.202481.33.22.22.99.99.99',
                    'L6.202482.30.20.20.90.90.90',
                    'L6.202963.33.22.22.99.99.99',
                    'L6.203000.00.00.00.00.00.00',
                    'L6.203481.03.02.02.09.09.09',
                    'L6.203482.00.00.00.00.00.00',
                    'L6.203963.03.02.02.09.09.09',
                    'L6.405000.30.20.20.90.90.90',
                    'L6.405481.33.22.22.99.99.99',
                    'L6.405482.30.20.20.90.90.90',
                    'L6.405963.33.22.22.99.99.99'
                ],

                'centroids' : [
                    (-17367529.94471388, 7314540.329981971), (-0.5004475, 7314540.329981971),
                    (0.5004475, 7314540.329981971), (17367529.94471388, 7314540.329981971),
                    (-17367529.94471388, 0.5004475), (-0.5004475, 0.5004475),
                    (0.5004475, 0.5004475), (17367529.94471388, 0.5004475),
                    (-17367529.94471388, -0.5004475), (-0.5004475, -0.5004475),
                    (0.5004475, -0.5004475), (17367529.94471388, -0.5004475),
                    (-17367529.94471388, -7314540.329981971), (-0.5004475, -7314540.329981971),
                    (0.5004475, -7314540.329981971), (17367529.94471388, -7314540.329981971)
                ],
                'geos' : [
                    (-179.9999948132782, 85.0445215772224),
                    (-5.186721870701923e-06, 85.0445215772224),
                    (5.186721870701923e-06, 85.0445215772224),
                    (179.9999948132782, 85.0445215772224),
                    (-179.9999948132782, 3.922823537859802e-06),
                    (-5.186721870701923e-06, 3.922823537859802e-06),
                    (5.186721870701923e-06, 3.922823537859802e-06),
                    (179.9999948132782, 3.922823537859802e-06),
                    (-179.9999948132782, -3.922823537859802e-06),
                    (-5.186721870701923e-06, -3.922823537859802e-06),
                    (5.186721870701923e-06, -3.922823537859802e-06),
                    (179.9999948132782, -3.922823537859802e-06),
                    (-179.9999948132782, -85.0445215772224),
                    (-5.186721870701923e-06, -85.0445215772224),
                    (5.186721870701923e-06, -85.0445215772224),
                    (179.9999948132782, -85.0445215772224)
                ],
            },
        }

# the EASE-DGGS coords are easy to derived from the EASE-DGGS id
#   basically, it's equivalent of coordinate shifting origin to the
#   upper left quadrant

class ValidGems():
    @pytest.fixture(autouse=True)
    def _valid_easedggs(self):
        self._valid_easedggs = [(0.5, 0.5), (481.5, 0.5), (482.5, 0.5), (963.5, 0.5),
                            (0.5 ,202.5), (481.5, 202.5), (482.5, 202.5), (963.5, 202.5),
                            (0.5, 203.5), (481.5, 203.5), (482.5, 203.5), (963.5, 203.5),
                            (0.5, 405.5), (481.5, 405.5), (482.5, 405.5), (963.5, 405.5)]
