# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc

import bot_pb2 as bot__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2
import structs_pb2 as structs__pb2


class AuthorizationServiceStub(object):
  """*
  The methods for authorization management.

  All methods are executed on behalf of a main Voximplant developer account,
  i.e., with all possible permissions. 
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.Login = channel.unary_unary(
        '/com.voximplant.im.AuthorizationService/Login',
        request_serializer=structs__pb2.LoginRequest.SerializeToString,
        response_deserializer=structs__pb2.LoginResponse.FromString,
        )


class AuthorizationServiceServicer(object):
  """*
  The methods for authorization management.

  All methods are executed on behalf of a main Voximplant developer account,
  i.e., with all possible permissions. 
  """

  def Login(self, request, context):
    """* `Login` performs login with the specified credentials.
    See the possible authorization options [in the HTTP API reference.](https://voximplant.com/docs/references/httpapi/auth_parameters).
    Response contains a token required for using all other API methods.

    Note that a token expires in 30 seconds. Bot uses a separate token, see
    the __BotManagementService__ method.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_AuthorizationServiceServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'Login': grpc.unary_unary_rpc_method_handler(
          servicer.Login,
          request_deserializer=structs__pb2.LoginRequest.FromString,
          response_serializer=structs__pb2.LoginResponse.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'com.voximplant.im.AuthorizationService', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))


class ConversationServiceStub(object):
  """*
  The methods for conversation management. 

  All methods are executed on behalf of a main Voximplant developer account,
  i.e., with all possible permissions. 
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.CreateConversation = channel.unary_unary(
        '/com.voximplant.im.ConversationService/CreateConversation',
        request_serializer=structs__pb2.CreateConversationRequest.SerializeToString,
        response_deserializer=structs__pb2.CreateConversationResponse.FromString,
        )
    self.EditConversation = channel.unary_unary(
        '/com.voximplant.im.ConversationService/EditConversation',
        request_serializer=structs__pb2.EditConversationRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )
    self.GetConversations = channel.unary_unary(
        '/com.voximplant.im.ConversationService/GetConversations',
        request_serializer=structs__pb2.GetConversationsRequest.SerializeToString,
        response_deserializer=structs__pb2.GetConversationsResponse.FromString,
        )
    self.RemoveConversations = channel.unary_unary(
        '/com.voximplant.im.ConversationService/RemoveConversations',
        request_serializer=structs__pb2.RemoveConversationsRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )
    self.GetParticipants = channel.unary_unary(
        '/com.voximplant.im.ConversationService/GetParticipants',
        request_serializer=structs__pb2.GetParticipantsRequest.SerializeToString,
        response_deserializer=structs__pb2.GetParticipantsResponse.FromString,
        )
    self.AddParticipants = channel.unary_unary(
        '/com.voximplant.im.ConversationService/AddParticipants',
        request_serializer=structs__pb2.AddParticipantsRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )
    self.RemoveParticipants = channel.unary_unary(
        '/com.voximplant.im.ConversationService/RemoveParticipants',
        request_serializer=structs__pb2.RemoveParticipantsRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )
    self.ManagePermissions = channel.unary_unary(
        '/com.voximplant.im.ConversationService/ManagePermissions',
        request_serializer=structs__pb2.ManagePermissionsRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )


class ConversationServiceServicer(object):
  """*
  The methods for conversation management. 

  All methods are executed on behalf of a main Voximplant developer account,
  i.e., with all possible permissions. 
  """

  def CreateConversation(self, request, context):
    """* `CreateConversation` creates a new conversation with the extended configuration.

    Returns UUID for a new conversation.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def EditConversation(self, request, context):
    """`EditConversation` updates the specified conversation. 
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetConversations(self, request, context):
    """`GetConversations` searches for the specified conversation(s). The search results are filtered according to the specified parameters only.

    If parameters are not specified, the method returns the last 20 conversations that were created in the account.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def RemoveConversations(self, request, context):
    """`RemoveConversations` removes all the specified conversations.

    Note that all specified conversations should exist. The method returns an exception if:
    * at least one of the specified conversations doesn't exist (or already deleted) 
    * no conversations are passed
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetParticipants(self, request, context):
    """`GetParticipants` gets participants of the specified conversation.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def AddParticipants(self, request, context):
    """
    `AddParticipants` allows to add participants to the specified conversation.

    Duplicated users are ignored. The methods returns an exception if:
    * at least one user doesn't exist or already belongs to the conversation
    * conversation UUID is invalid (deleted or doesn't exist)
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def RemoveParticipants(self, request, context):
    """
    `RemoveParticipants` allows to remove participants from the specified conversation.

    Duplicated users are ignored. The methods returns an exception if:
    * at least one user doesn't exist or already removed from the conversation
    * conversation UUID is invalid (deleted or doesn't exist)
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def ManagePermissions(self, request, context):
    """`ManagePermissions` allows to manage permissions for the specified participants. The `can_write`, `can_edit` and `can_remove` permissions are given by default to all users. 

    See the available permissions in the [Participant] structure.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_ConversationServiceServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'CreateConversation': grpc.unary_unary_rpc_method_handler(
          servicer.CreateConversation,
          request_deserializer=structs__pb2.CreateConversationRequest.FromString,
          response_serializer=structs__pb2.CreateConversationResponse.SerializeToString,
      ),
      'EditConversation': grpc.unary_unary_rpc_method_handler(
          servicer.EditConversation,
          request_deserializer=structs__pb2.EditConversationRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
      'GetConversations': grpc.unary_unary_rpc_method_handler(
          servicer.GetConversations,
          request_deserializer=structs__pb2.GetConversationsRequest.FromString,
          response_serializer=structs__pb2.GetConversationsResponse.SerializeToString,
      ),
      'RemoveConversations': grpc.unary_unary_rpc_method_handler(
          servicer.RemoveConversations,
          request_deserializer=structs__pb2.RemoveConversationsRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
      'GetParticipants': grpc.unary_unary_rpc_method_handler(
          servicer.GetParticipants,
          request_deserializer=structs__pb2.GetParticipantsRequest.FromString,
          response_serializer=structs__pb2.GetParticipantsResponse.SerializeToString,
      ),
      'AddParticipants': grpc.unary_unary_rpc_method_handler(
          servicer.AddParticipants,
          request_deserializer=structs__pb2.AddParticipantsRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
      'RemoveParticipants': grpc.unary_unary_rpc_method_handler(
          servicer.RemoveParticipants,
          request_deserializer=structs__pb2.RemoveParticipantsRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
      'ManagePermissions': grpc.unary_unary_rpc_method_handler(
          servicer.ManagePermissions,
          request_deserializer=structs__pb2.ManagePermissionsRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'com.voximplant.im.ConversationService', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))


class UserDataServiceStub(object):
  """*
  The methods for user management.
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.GetUserData = channel.unary_unary(
        '/com.voximplant.im.UserDataService/GetUserData',
        request_serializer=structs__pb2.GetUserDataRequest.SerializeToString,
        response_deserializer=structs__pb2.GetUserDataResponse.FromString,
        )
    self.EditUserData = channel.unary_unary(
        '/com.voximplant.im.UserDataService/EditUserData',
        request_serializer=structs__pb2.EditUserDataRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )


class UserDataServiceServicer(object):
  """*
  The methods for user management.
  """

  def GetUserData(self, request, context):
    """
    `GetUserData` allows to get information about the specified users.

    It's possible to get any users of the main Voximplant developer account or its child accounts. Each user can be specified either by ID or user name.

    The methods returns an exception if:
    * at least one user doesn't exist
    * at least one user belongs to another Voximplant developer account
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def EditUserData(self, request, context):
    """
    `EditUserData` allows to edit the specified user.

    It's possible to edit only one user which belongs directly to the current Voximplant developer account.

    The methods returns an exception if:
    * a user doesn't exist
    * a user belongs to another Voximplant developer account
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_UserDataServiceServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'GetUserData': grpc.unary_unary_rpc_method_handler(
          servicer.GetUserData,
          request_deserializer=structs__pb2.GetUserDataRequest.FromString,
          response_serializer=structs__pb2.GetUserDataResponse.SerializeToString,
      ),
      'EditUserData': grpc.unary_unary_rpc_method_handler(
          servicer.EditUserData,
          request_deserializer=structs__pb2.EditUserDataRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'com.voximplant.im.UserDataService', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))


class BotManagementServiceStub(object):
  """*
  The methods for bot management.

  Bot is an entity for integrating with other platforms, sending service messages to conversations, etc. 
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.CreateBot = channel.unary_unary(
        '/com.voximplant.im.BotManagementService/CreateBot',
        request_serializer=bot__pb2.CreateBotRequest.SerializeToString,
        response_deserializer=bot__pb2.CreateBotResponse.FromString,
        )
    self.RemoveBot = channel.unary_unary(
        '/com.voximplant.im.BotManagementService/RemoveBot',
        request_serializer=bot__pb2.RemoveBotRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )


class BotManagementServiceServicer(object):
  """*
  The methods for bot management.

  Bot is an entity for integrating with other platforms, sending service messages to conversations, etc. 
  """

  def CreateBot(self, request, context):
    """`CreateBot` allows to create a new bot with the specified parameters. 

    The method generates new credentials for a bot and returns an
    exception if the specified bot name is the name of already existing bot.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def RemoveBot(self, request, context):
    """`RemoveBot` deletes the bot by its ID.

    Only a bots creator and a main Voximplant developer account are able 
    to delete bots.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_BotManagementServiceServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'CreateBot': grpc.unary_unary_rpc_method_handler(
          servicer.CreateBot,
          request_deserializer=bot__pb2.CreateBotRequest.FromString,
          response_serializer=bot__pb2.CreateBotResponse.SerializeToString,
      ),
      'RemoveBot': grpc.unary_unary_rpc_method_handler(
          servicer.RemoveBot,
          request_deserializer=bot__pb2.RemoveBotRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'com.voximplant.im.BotManagementService', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))


class BotServiceStub(object):
  """*
  The methods for available bot actions.

  All methods are executed on behalf of an already existing bot.
  TODO: add more bot feature
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.Connect = channel.stream_stream(
        '/com.voximplant.im.BotService/Connect',
        request_serializer=bot__pb2.BotCommand.SerializeToString,
        response_deserializer=bot__pb2.BotEvent.FromString,
        )
    self.RegisterWebHook = channel.unary_unary(
        '/com.voximplant.im.BotService/RegisterWebHook',
        request_serializer=bot__pb2.RegisterWebHookRequest.SerializeToString,
        response_deserializer=bot__pb2.RegisterWebHookResponse.FromString,
        )
    self.UnregisterWebHook = channel.unary_unary(
        '/com.voximplant.im.BotService/UnregisterWebHook',
        request_serializer=bot__pb2.UnregisterWebHookRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )
    self.SendMessage = channel.unary_unary(
        '/com.voximplant.im.BotService/SendMessage',
        request_serializer=bot__pb2.SendMessageRequest.SerializeToString,
        response_deserializer=bot__pb2.MessageReceivedEvent.FromString,
        )
    self.EditMessage = channel.unary_unary(
        '/com.voximplant.im.BotService/EditMessage',
        request_serializer=bot__pb2.EditMessageRequest.SerializeToString,
        response_deserializer=bot__pb2.MessageEditedEvent.FromString,
        )
    self.RemoveMessage = channel.unary_unary(
        '/com.voximplant.im.BotService/RemoveMessage',
        request_serializer=bot__pb2.RemoveMessageRequest.SerializeToString,
        response_deserializer=bot__pb2.MessageRemovedEvent.FromString,
        )


class BotServiceServicer(object):
  """*
  The methods for available bot actions.

  All methods are executed on behalf of an already existing bot.
  TODO: add more bot feature
  """

  def Connect(self, request_iterator, context):
    """`Connect` opens a bidirectional stream via GRPC. Such a stream allows
    bots to send commands and receive appropriate events. 

    Available commands are SendMessage, EditMessage and RemoveMessage.

    Available events are: 
    * MessageReceived
    * MessageEdited 
    * MessageDeleted
    * ConversationEdited
    * ErrorOccurred
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def RegisterWebHook(self, request, context):
    """
    The method registers a URL as a webhook in order to use regular
    HTTP POST requests instead of a GRPS stream.

    The registered webhook is able to receive the following events that
    are triggered by all conversation participants except the current bot:
    * MessageReceived
    * MessageEdited 
    * MessageDeleted
    * ConversationEdited

    There could be only one registered webhook for a bot; attempting to 
    register a new webhook will replace the current one.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def UnregisterWebHook(self, request, context):
    """
    The method unregisters the specified webhook. 

    The method returns an exception if the specified webhook doesn't
    exist or already unregistered.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SendMessage(self, request, context):
    """
    Send a message to the specified conversation.

    Sending messages is available only for participants
    that have the `can_write` permission.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def EditMessage(self, request, context):
    """
    Edit the specified message in the conversation.

    Editing messages is available only for participants
    that have the `can_edit` and/or `can_edit_all` permissions.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def RemoveMessage(self, request, context):
    """
    Remove the specified message in the conversation.

    Removing messages is available only for participants
    that have the `can_remove` and/or `an_remove_all` permissions.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_BotServiceServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'Connect': grpc.stream_stream_rpc_method_handler(
          servicer.Connect,
          request_deserializer=bot__pb2.BotCommand.FromString,
          response_serializer=bot__pb2.BotEvent.SerializeToString,
      ),
      'RegisterWebHook': grpc.unary_unary_rpc_method_handler(
          servicer.RegisterWebHook,
          request_deserializer=bot__pb2.RegisterWebHookRequest.FromString,
          response_serializer=bot__pb2.RegisterWebHookResponse.SerializeToString,
      ),
      'UnregisterWebHook': grpc.unary_unary_rpc_method_handler(
          servicer.UnregisterWebHook,
          request_deserializer=bot__pb2.UnregisterWebHookRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
      'SendMessage': grpc.unary_unary_rpc_method_handler(
          servicer.SendMessage,
          request_deserializer=bot__pb2.SendMessageRequest.FromString,
          response_serializer=bot__pb2.MessageReceivedEvent.SerializeToString,
      ),
      'EditMessage': grpc.unary_unary_rpc_method_handler(
          servicer.EditMessage,
          request_deserializer=bot__pb2.EditMessageRequest.FromString,
          response_serializer=bot__pb2.MessageEditedEvent.SerializeToString,
      ),
      'RemoveMessage': grpc.unary_unary_rpc_method_handler(
          servicer.RemoveMessage,
          request_deserializer=bot__pb2.RemoveMessageRequest.FromString,
          response_serializer=bot__pb2.MessageRemovedEvent.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'com.voximplant.im.BotService', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))
