/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public class FilterCalcMergeRule
extends RelOptRule
implements TransformationRule {
    public static final FilterCalcMergeRule INSTANCE = new FilterCalcMergeRule(RelFactories.LOGICAL_BUILDER);

    public FilterCalcMergeRule(RelBuilderFactory relBuilderFactory) {
        super(FilterCalcMergeRule.operand(Filter.class, FilterCalcMergeRule.operand(LogicalCalc.class, FilterCalcMergeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        LogicalCalc calc = (LogicalCalc)call.rel(1);
        if (calc.getProgram().containsAggs()) {
            return;
        }
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexProgramBuilder progBuilder = new RexProgramBuilder(calc.getRowType(), rexBuilder);
        progBuilder.addIdentity();
        progBuilder.addCondition(filter.getCondition());
        RexProgram topProgram = progBuilder.getProgram();
        RexProgram bottomProgram = calc.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        LogicalCalc newCalc = LogicalCalc.create(calc.getInput(), mergedProgram);
        call.transformTo(newCalc);
    }
}

