/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.tools.RelBuilderFactory;

public class ProjectSetOpTransposeRule
extends RelOptRule
implements TransformationRule {
    public static final ProjectSetOpTransposeRule INSTANCE = new ProjectSetOpTransposeRule(expr -> !(expr instanceof RexOver), RelFactories.LOGICAL_BUILDER);
    private PushProjector.ExprCondition preserveExprCondition;

    public ProjectSetOpTransposeRule(PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relBuilderFactory) {
        super(ProjectSetOpTransposeRule.operand(LogicalProject.class, ProjectSetOpTransposeRule.operand(SetOp.class, ProjectSetOpTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode node;
        LogicalProject origProj = (LogicalProject)call.rel(0);
        SetOp setOp = (SetOp)call.rel(1);
        if (!setOp.all) {
            return;
        }
        PushProjector pushProject = new PushProjector(origProj, null, setOp, this.preserveExprCondition, call.builder());
        pushProject.locateAllRefs();
        ArrayList<Project> newSetOpInputs = new ArrayList<Project>();
        int[] adjustments = pushProject.getAdjustments();
        if (RexOver.containsOver(origProj.getProjects(), null)) {
            for (RelNode input2 : setOp.getInputs()) {
                Project p = pushProject.createProjectRefsAndExprs(input2, true, false);
                if (p.getRowType().equals(input2.getRowType())) {
                    return;
                }
                newSetOpInputs.add(p);
            }
            RelNode newSetOp = setOp.copy(setOp.getTraitSet(), newSetOpInputs);
            node = pushProject.createNewProject(newSetOp, adjustments);
        } else {
            setOp.getInputs().forEach(input -> newSetOpInputs.add((Project)pushProject.createNewProject(pushProject.createProjectRefsAndExprs((RelNode)input, true, false), adjustments)));
            node = setOp.copy(setOp.getTraitSet(), newSetOpInputs);
        }
        call.transformTo(node);
    }
}

