/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.cpdsadapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.Jdbc41Bridge;
import org.apache.commons.dbcp2.PStmtKey;
import org.apache.commons.dbcp2.PoolableCallableStatement;
import org.apache.commons.dbcp2.PoolablePreparedStatement;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.dbcp2.cpdsadapter.ConnectionImpl;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

class PooledConnectionImpl
implements PooledConnection,
KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private static final String CLOSED = "Attempted to use PooledConnection after closed() was called.";
    private Connection connection;
    private final DelegatingConnection<?> delegatingConnection;
    private Connection logicalConnection;
    private final Vector<ConnectionEventListener> eventListeners;
    private final Vector<StatementEventListener> statementEventListeners = new Vector();
    private boolean closed;
    private KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pStmtPool;
    private boolean accessToUnderlyingConnectionAllowed;

    PooledConnectionImpl(Connection connection) {
        this.connection = connection;
        this.delegatingConnection = connection instanceof DelegatingConnection ? (DelegatingConnection<Object>)connection : new DelegatingConnection<Connection>(connection);
        this.eventListeners = new Vector();
        this.closed = false;
    }

    @Override
    public void activateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        pooledObject.getObject().activate();
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (!this.statementEventListeners.contains(listener)) {
            this.statementEventListeners.add(listener);
        }
    }

    private void assertOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block14: {
            this.assertOpen();
            this.closed = true;
            try {
                if (this.pStmtPool == null) break block14;
                try {
                    this.pStmtPool.close();
                }
                finally {
                    this.pStmtPool = null;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close connection (return to pool failed)", e);
            }
            finally {
                try {
                    this.connection.close();
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    protected PStmtKey createKey(String sql) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected PStmtKey createKey(String sql, int autoGeneratedKeys) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), autoGeneratedKeys);
    }

    protected PStmtKey createKey(String sql, int[] columnIndexes) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), columnIndexes);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, PoolingConnection.StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability, statementType);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, PoolingConnection.StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, statementType);
    }

    protected PStmtKey createKey(String sql, PoolingConnection.StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), statementType);
    }

    protected PStmtKey createKey(String sql, String[] columnNames) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), columnNames);
    }

    @Override
    public void destroyObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        pooledObject.getObject().getInnermostDelegate().close();
    }

    protected void finalize() throws Throwable {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was gc'ed, without its last Connection being closed.");
        }
    }

    private String getCatalogOrNull() {
        try {
            return this.connection == null ? null : this.connection.getCatalog();
        }
        catch (SQLException e) {
            return null;
        }
    }

    private String getSchemaOrNull() {
        try {
            return this.connection == null ? null : Jdbc41Bridge.getSchema(this.connection);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.assertOpen();
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was reused, without its previous Connection being closed.");
        }
        this.logicalConnection = new ConnectionImpl(this, this.connection, this.isAccessToUnderlyingConnectionAllowed());
        return this.logicalConnection;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public PooledObject<DelegatingPreparedStatement> makeObject(PStmtKey key) throws Exception {
        if (null == key) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        if (key.getStmtType() == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            PreparedStatement statement = (PreparedStatement)key.createStatement(this.connection);
            PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(statement, key, this.pStmtPool, this.delegatingConnection);
            return new DefaultPooledObject<DelegatingPreparedStatement>(pps);
        }
        CallableStatement statement = (CallableStatement)key.createStatement(this.connection);
        PoolableCallableStatement pcs = new PoolableCallableStatement(statement, key, this.pStmtPool, this.delegatingConnection);
        return new DefaultPooledObject<DelegatingPreparedStatement>(pcs);
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    void notifyListeners() {
        Object[] listeners;
        ConnectionEvent event = new ConnectionEvent(this);
        for (Object listener : listeners = this.eventListeners.toArray()) {
            ((ConnectionEventListener)listener).connectionClosed(event);
        }
    }

    @Override
    public void passivateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        DelegatingPreparedStatement dps = pooledObject.getObject();
        dps.clearParameters();
        dps.passivate();
    }

    CallableStatement prepareCall(String sql) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareCall(sql);
        }
        try {
            return (CallableStatement)((Object)this.pStmtPool.borrowObject(this.createKey(sql, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareCall from pool failed", e);
        }
    }

    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        try {
            return (CallableStatement)((Object)this.pStmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareCall from pool failed", e);
        }
    }

    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        try {
            return (CallableStatement)((Object)this.pStmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareCall from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareStatement(sql);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(sql));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareStatement(sql, autoGeneratedKeys);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(sql, autoGeneratedKeys));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareStatement(sql, columnIndexes);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(sql, columnIndexes));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.pStmtPool == null) {
            return this.connection.prepareStatement(sql, columnNames);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(sql, columnNames));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }

    public void setStatementPool(KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> statementPool) {
        this.pStmtPool = statementPool;
    }

    @Override
    public boolean validateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) {
        return true;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[connection=");
        builder.append(this.connection);
        builder.append(", delegatingConnection=");
        builder.append(this.delegatingConnection);
        builder.append(", logicalConnection=");
        builder.append(this.logicalConnection);
        builder.append(", eventListeners=");
        builder.append(this.eventListeners);
        builder.append(", statementEventListeners=");
        builder.append(this.statementEventListeners);
        builder.append(", closed=");
        builder.append(this.closed);
        builder.append(", pStmtPool=");
        builder.append(this.pStmtPool);
        builder.append(", accessToUnderlyingConnectionAllowed=");
        builder.append(this.accessToUnderlyingConnectionAllowed);
        builder.append("]");
        return builder.toString();
    }
}

