import { CopyOptions } from './copy-options';
export interface FingerprintOptions extends CopyOptions {
    /**
     * Extra information to encode into the fingerprint (e.g. build instructions
     * and other inputs)
     */
    extra?: string;
}
/**
 * Produces fingerprint based on the contents of a single file or an entire directory tree.
 *
 * The fingerprint will also include:
 * 1. An extra string if defined in `options.extra`.
 * 2. The set of exclude patterns, if defined in `options.exclude`
 * 3. The symlink follow mode value.
 *
 * @param fileOrDirectory The directory or file to fingerprint
 * @param options Fingerprinting options
 */
export declare function fingerprint(fileOrDirectory: string, options?: FingerprintOptions): string;
