"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const path = require("path");
const assets = require("../lib");
class TestStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // The template must contain at least one resource, so there is this...
        new iam.User(this, 'DummyResource');
        // Check that the same asset added multiple times is
        // uploaded and copied.
        new assets.FileAsset(this, 'SampleAsset1', {
            path: path.join(__dirname, 'file-asset.txt')
        });
        new assets.FileAsset(this, 'SampleAsset2', {
            path: path.join(__dirname, 'file-asset.txt')
        });
    }
}
const app = new cdk.App();
new TestStack(app, 'aws-cdk-multi-assets');
app.run();
//# sourceMappingURL=data:application/json;base64,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