"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

import requests as requests_http
from .apiendpoints import APIEndpoints
from .apis import Apis
from .auth import Auth
from .embeds import Embeds
from .events import Events
from .metadata import Metadata
from .organizations import Organizations
from .requests import Requests
from .schemas import Schemas
from .sdkconfiguration import SDKConfiguration
from speakeasy import utils
from speakeasy._hooks import SDKHooks
from speakeasy.models import shared
from typing import Callable, Dict, Optional, Union

class Speakeasy:
    r"""Speakeasy API: The Speakeasy API allows teams to manage common operations with their APIs
    /docs - The Speakeasy Platform Documentation
    """
    apis: Apis
    r"""REST APIs for managing Api entities"""
    api_endpoints: APIEndpoints
    r"""REST APIs for managing ApiEndpoint entities"""
    metadata: Metadata
    r"""REST APIs for managing Version Metadata entities"""
    schemas: Schemas
    r"""REST APIs for managing Schema entities"""
    auth: Auth
    r"""REST APIs for managing Authentication"""
    requests: Requests
    r"""REST APIs for retrieving request information"""
    organizations: Organizations
    embeds: Embeds
    r"""REST APIs for managing embeds"""
    events: Events
    r"""REST APIs for capturing event data"""

    sdk_configuration: SDKConfiguration

    def __init__(self,
                 security: Union[shared.Security,Callable[[], shared.Security]] = None,
                 workspace_id: str = None,
                 server: Optional[str] = None,
                 server_url: Optional[str] = None,
                 url_params: Optional[Dict[str, str]] = None,
                 client: Optional[requests_http.Session] = None,
                 retry_config: Optional[utils.RetryConfig] = None
                 ) -> None:
        """Instantiates the SDK configuring it with the provided parameters.

        :param security: The security details required for authentication
        :type security: Union[shared.Security,Callable[[], shared.Security]]
        :param workspace_id: Configures the workspace_id parameter for all supported operations
        :type workspace_id: str
        :param server: The server by name to use for all operations
        :type server: str
        :param server_url: The server URL to use for all operations
        :type server_url: str
        :param url_params: Parameters to optionally template the server URL with
        :type url_params: Dict[str, str]
        :param client: The requests.Session HTTP client to use for all operations
        :type client: requests_http.Session
        :param retry_config: The utils.RetryConfig to use globally
        :type retry_config: utils.RetryConfig
        """
        if client is None:
            client = requests_http.Session()

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)
        global_params = {
            'parameters': {
                'queryParam': {
                },
                'pathParam': {
                    'workspace_id': workspace_id,
                },
                'header': {
                },
            },
        }

        self.sdk_configuration = SDKConfiguration(
            client,
            security,
            server_url,
            server,
            global_params,
            retry_config=retry_config
        )

        hooks = SDKHooks()

        current_server_url, *_ = self.sdk_configuration.get_server_details()
        server_url, self.sdk_configuration.client = hooks.sdk_init(current_server_url, self.sdk_configuration.client)
        if current_server_url != server_url:
            self.sdk_configuration.server_url = server_url

        # pylint: disable=protected-access
        self.sdk_configuration._hooks = hooks

        self._init_sdks()


    def _init_sdks(self):
        self.apis = Apis(self.sdk_configuration)
        self.api_endpoints = APIEndpoints(self.sdk_configuration)
        self.metadata = Metadata(self.sdk_configuration)
        self.schemas = Schemas(self.sdk_configuration)
        self.auth = Auth(self.sdk_configuration)
        self.requests = Requests(self.sdk_configuration)
        self.organizations = Organizations(self.sdk_configuration)
        self.embeds = Embeds(self.sdk_configuration)
        self.events = Events(self.sdk_configuration)
