
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:36:11 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32i.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the add instruction of the RISC-V I extension for the add covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",add)

RVTEST_SIGBASE( x3,signature_x3_1)

inst_0:
// rs2 == rd != rs1, rs1==x4, rs2==x24, rd==x24, rs1_val > 0 and rs2_val > 0, rs2_val == 1, rs1_val == (2**(xlen-1)-1), rs1_val != rs2_val, rs1_val == 2147483647
// opcode: add ; op1:x4; op2:x24; dest:x24; op1val:0x7fffffff;  op2val:0x1
TEST_RR_OP(add, x24, x4, x24, 0x80000000, 0x7fffffff, 0x1, x3, 0, x18)

inst_1:
// rs1 == rs2 != rd, rs1==x10, rs2==x10, rd==x28, rs1_val > 0 and rs2_val < 0, rs2_val == -257, rs1_val == 131072
// opcode: add ; op1:x10; op2:x10; dest:x28; op1val:0x20000;  op2val:0x20000
TEST_RR_OP(add, x28, x10, x10, 0x40000, 0x20000, 0x20000, x3, 4, x18)

inst_2:
// rs1 == rs2 == rd, rs1==x21, rs2==x21, rd==x21, rs1_val < 0 and rs2_val < 0, rs1_val == -16777217
// opcode: add ; op1:x21; op2:x21; dest:x21; op1val:-0x1000001;  op2val:-0x1000001
TEST_RR_OP(add, x21, x21, x21, 0xfdfffffe, -0x1000001, -0x1000001, x3, 8, x18)

inst_3:
// rs1 == rd != rs2, rs1==x22, rs2==x31, rd==x22, rs1_val < 0 and rs2_val > 0, rs1_val == -2, rs2_val == 262144
// opcode: add ; op1:x22; op2:x31; dest:x22; op1val:-0x2;  op2val:0x40000
TEST_RR_OP(add, x22, x22, x31, 0x3fffe, -0x2, 0x40000, x3, 12, x18)

inst_4:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x12, rs2==x6, rd==x11, rs1_val == rs2_val, rs1_val==1431655766 and rs2_val==1431655766
// opcode: add ; op1:x12; op2:x6; dest:x11; op1val:0x55555556;  op2val:0x55555556
TEST_RR_OP(add, x11, x12, x6, 0xaaaaaaac, 0x55555556, 0x55555556, x3, 16, x18)

inst_5:
// rs1==x29, rs2==x13, rd==x10, rs2_val == (-2**(xlen-1)), rs2_val == -2147483648, rs1_val == 2
// opcode: add ; op1:x29; op2:x13; dest:x10; op1val:0x2;  op2val:-0x80000000
TEST_RR_OP(add, x10, x29, x13, 0x80000002, 0x2, -0x80000000, x3, 20, x18)

inst_6:
// rs1==x31, rs2==x5, rd==x26, rs2_val == 0, rs1_val == -17
// opcode: add ; op1:x31; op2:x5; dest:x26; op1val:-0x11;  op2val:0x0
TEST_RR_OP(add, x26, x31, x5, 0xffffffef, -0x11, 0x0, x3, 24, x18)

inst_7:
// rs1==x2, rs2==x1, rd==x7, rs2_val == (2**(xlen-1)-1), rs2_val == 2147483647
// opcode: add ; op1:x2; op2:x1; dest:x7; op1val:0x66666666;  op2val:0x7fffffff
TEST_RR_OP(add, x7, x2, x1, 0xe6666665, 0x66666666, 0x7fffffff, x3, 28, x18)

inst_8:
// rs1==x8, rs2==x25, rd==x14, rs1_val == (-2**(xlen-1)), rs1_val == -2147483648, rs2_val == -1431655766
// opcode: add ; op1:x8; op2:x25; dest:x14; op1val:-0x80000000;  op2val:-0x55555556
TEST_RR_OP(add, x14, x8, x25, 0x2aaaaaaa, -0x80000000, -0x55555556, x3, 32, x18)

inst_9:
// rs1==x13, rs2==x8, rd==x1, rs1_val == 0, rs2_val == -33554433
// opcode: add ; op1:x13; op2:x8; dest:x1; op1val:0x0;  op2val:-0x2000001
TEST_RR_OP(add, x1, x13, x8, 0xfdffffff, 0x0, -0x2000001, x3, 36, x18)

inst_10:
// rs1==x28, rs2==x9, rd==x0, rs1_val == 1, rs2_val == 8388608
// opcode: add ; op1:x28; op2:x9; dest:x0; op1val:0x1;  op2val:0x800000
TEST_RR_OP(add, x0, x28, x9, 0, 0x1, 0x800000, x3, 40, x18)

inst_11:
// rs1==x14, rs2==x4, rd==x20, rs2_val == 2, 
// opcode: add ; op1:x14; op2:x4; dest:x20; op1val:0x7;  op2val:0x2
TEST_RR_OP(add, x20, x14, x4, 0x9, 0x7, 0x2, x3, 44, x18)

inst_12:
// rs1==x7, rs2==x19, rd==x16, rs2_val == 4, rs1_val == 8
// opcode: add ; op1:x7; op2:x19; dest:x16; op1val:0x8;  op2val:0x4
TEST_RR_OP(add, x16, x7, x19, 0xc, 0x8, 0x4, x3, 48, x18)

inst_13:
// rs1==x23, rs2==x29, rd==x8, rs2_val == 8, rs1_val == 2048
// opcode: add ; op1:x23; op2:x29; dest:x8; op1val:0x800;  op2val:0x8
TEST_RR_OP(add, x8, x23, x29, 0x808, 0x800, 0x8, x3, 52, x18)

inst_14:
// rs1==x5, rs2==x27, rd==x13, rs2_val == 16, 
// opcode: add ; op1:x5; op2:x27; dest:x13; op1val:0x0;  op2val:0x10
TEST_RR_OP(add, x13, x5, x27, 0x10, 0x0, 0x10, x3, 56, x18)

inst_15:
// rs1==x25, rs2==x20, rd==x27, rs2_val == 32, 
// opcode: add ; op1:x25; op2:x20; dest:x27; op1val:0x55555556;  op2val:0x20
TEST_RR_OP(add, x27, x25, x20, 0x55555576, 0x55555556, 0x20, x3, 60, x18)

inst_16:
// rs1==x15, rs2==x26, rd==x17, rs2_val == 64, 
// opcode: add ; op1:x15; op2:x26; dest:x17; op1val:-0x11;  op2val:0x40
TEST_RR_OP(add, x17, x15, x26, 0x2f, -0x11, 0x40, x3, 64, x18)
RVTEST_SIGBASE( x8,signature_x8_0)

inst_17:
// rs1==x17, rs2==x2, rd==x29, rs2_val == 128, rs1_val == -5
// opcode: add ; op1:x17; op2:x2; dest:x29; op1val:-0x5;  op2val:0x80
TEST_RR_OP(add, x29, x17, x2, 0x7b, -0x5, 0x80, x8, 0, x10)

inst_18:
// rs1==x24, rs2==x17, rd==x4, rs2_val == 256, rs1_val == 32
// opcode: add ; op1:x24; op2:x17; dest:x4; op1val:0x20;  op2val:0x100
TEST_RR_OP(add, x4, x24, x17, 0x120, 0x20, 0x100, x8, 4, x10)

inst_19:
// rs1==x16, rs2==x11, rd==x2, rs2_val == 512, rs1_val == 1073741824
// opcode: add ; op1:x16; op2:x11; dest:x2; op1val:0x40000000;  op2val:0x200
TEST_RR_OP(add, x2, x16, x11, 0x40000200, 0x40000000, 0x200, x8, 8, x10)

inst_20:
// rs1==x0, rs2==x16, rd==x6, rs2_val == 1024, 
// opcode: add ; op1:x0; op2:x16; dest:x6; op1val:0x0;  op2val:0x400
TEST_RR_OP(add, x6, x0, x16, 0x400, 0x0, 0x400, x8, 12, x10)

inst_21:
// rs1==x11, rs2==x3, rd==x31, rs2_val == 2048, 
// opcode: add ; op1:x11; op2:x3; dest:x31; op1val:-0x55555555;  op2val:0x800
TEST_RR_OP(add, x31, x11, x3, 0xaaaab2ab, -0x55555555, 0x800, x8, 16, x10)

inst_22:
// rs1==x18, rs2==x0, rd==x12, rs2_val == 4096, rs1_val == 4
// opcode: add ; op1:x18; op2:x0; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(add, x12, x18, x0, 0x4, 0x4, 0x0, x8, 20, x10)

inst_23:
// rs1==x30, rs2==x7, rd==x9, rs2_val == 8192, rs1_val == -33554433
// opcode: add ; op1:x30; op2:x7; dest:x9; op1val:-0x2000001;  op2val:0x2000
TEST_RR_OP(add, x9, x30, x7, 0xfe001fff, -0x2000001, 0x2000, x8, 24, x10)

inst_24:
// rs1==x3, rs2==x30, rd==x5, rs2_val == 16384, 
// opcode: add ; op1:x3; op2:x30; dest:x5; op1val:0xb503;  op2val:0x4000
TEST_RR_OP(add, x5, x3, x30, 0xf503, 0xb503, 0x4000, x8, 28, x10)

inst_25:
// rs1==x27, rs2==x28, rd==x18, rs2_val == 32768, 
// opcode: add ; op1:x27; op2:x28; dest:x18; op1val:-0xb503;  op2val:0x8000
TEST_RR_OP(add, x18, x27, x28, 0xffffcafd, -0xb503, 0x8000, x8, 32, x10)

inst_26:
// rs1==x9, rs2==x14, rd==x15, rs2_val == 65536, rs1_val == -513
// opcode: add ; op1:x9; op2:x14; dest:x15; op1val:-0x201;  op2val:0x10000
TEST_RR_OP(add, x15, x9, x14, 0xfdff, -0x201, 0x10000, x8, 36, x10)

inst_27:
// rs1==x26, rs2==x15, rd==x3, rs2_val == 131072, rs1_val == 64
// opcode: add ; op1:x26; op2:x15; dest:x3; op1val:0x40;  op2val:0x20000
TEST_RR_OP(add, x3, x26, x15, 0x20040, 0x40, 0x20000, x8, 40, x10)

inst_28:
// rs1==x1, rs2==x18, rd==x23, rs2_val == 524288, 
// opcode: add ; op1:x1; op2:x18; dest:x23; op1val:0x3;  op2val:0x80000
TEST_RR_OP(add, x23, x1, x18, 0x80003, 0x3, 0x80000, x8, 44, x10)

inst_29:
// rs1==x6, rs2==x12, rd==x30, rs2_val == 1048576, rs1_val == -65537
// opcode: add ; op1:x6; op2:x12; dest:x30; op1val:-0x10001;  op2val:0x100000
TEST_RR_OP(add, x30, x6, x12, 0xeffff, -0x10001, 0x100000, x8, 48, x10)

inst_30:
// rs1==x20, rs2==x22, rd==x19, rs2_val == 2097152, rs1_val == -4194305
// opcode: add ; op1:x20; op2:x22; dest:x19; op1val:-0x400001;  op2val:0x200000
TEST_RR_OP(add, x19, x20, x22, 0xffdfffff, -0x400001, 0x200000, x8, 52, x10)

inst_31:
// rs1==x19, rs2==x23, rd==x25, rs2_val == 4194304, rs1_val == 4194304
// opcode: add ; op1:x19; op2:x23; dest:x25; op1val:0x400000;  op2val:0x400000
TEST_RR_OP(add, x25, x19, x23, 0x800000, 0x400000, 0x400000, x8, 56, x10)

inst_32:
// rs2_val == 16777216, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x1000000
TEST_RR_OP(add, x12, x10, x11, 0xff4afd, -0xb503, 0x1000000, x8, 60, x2)
RVTEST_SIGBASE( x1,signature_x1_0)

inst_33:
// rs2_val == 33554432, rs1_val == -131073
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:0x2000000
TEST_RR_OP(add, x12, x10, x11, 0x1fdffff, -0x20001, 0x2000000, x1, 0, x2)

inst_34:
// rs2_val == 67108864, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4000000
TEST_RR_OP(add, x12, x10, x11, 0x4000000, 0x0, 0x4000000, x1, 4, x2)

inst_35:
// rs2_val == 134217728, rs1_val == -32769
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:0x8000000
TEST_RR_OP(add, x12, x10, x11, 0x7ff7fff, -0x8001, 0x8000000, x1, 8, x2)

inst_36:
// rs2_val == 268435456, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0x10000000
TEST_RR_OP(add, x12, x10, x11, 0x50000000, 0x40000000, 0x10000000, x1, 12, x2)

inst_37:
// rs2_val == 536870912, rs1_val == -16385
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:0x20000000
TEST_RR_OP(add, x12, x10, x11, 0x1fffbfff, -0x4001, 0x20000000, x1, 16, x2)

inst_38:
// rs2_val == 1073741824, rs1_val == 65536
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:0x40000000
TEST_RR_OP(add, x12, x10, x11, 0x40010000, 0x10000, 0x40000000, x1, 20, x2)

inst_39:
// rs2_val == -2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x2
TEST_RR_OP(add, x12, x10, x11, 0x2, 0x4, -0x2, x1, 24, x2)

inst_40:
// rs2_val == -3, rs1_val == -33
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:-0x3
TEST_RR_OP(add, x12, x10, x11, 0xffffffdc, -0x21, -0x3, x1, 28, x2)

inst_41:
// rs2_val == -5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:-0x5
TEST_RR_OP(add, x12, x10, x11, 0xffffffda, -0x21, -0x5, x1, 32, x2)

inst_42:
// rs2_val == -9, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:-0x9
TEST_RR_OP(add, x12, x10, x11, 0xfffdfff6, -0x20001, -0x9, x1, 36, x2)

inst_43:
// rs2_val == -17, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:-0x11
TEST_RR_OP(add, x12, x10, x11, 0x7ef, 0x800, -0x11, x1, 40, x2)

inst_44:
// rs2_val == -33, rs1_val == 536870912
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:-0x21
TEST_RR_OP(add, x12, x10, x11, 0x1fffffdf, 0x20000000, -0x21, x1, 44, x2)

inst_45:
// rs2_val == -65, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffff;  op2val:-0x41
TEST_RR_OP(add, x12, x10, x11, 0x7fffffbe, 0x7fffffff, -0x41, x1, 48, x2)

inst_46:
// rs2_val == -129, rs1_val == -8388609
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:-0x81
TEST_RR_OP(add, x12, x10, x11, 0xff7fff7e, -0x800001, -0x81, x1, 52, x2)

inst_47:
// rs2_val == -513, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0x201
TEST_RR_OP(add, x12, x10, x11, 0xffff48fb, -0xb504, -0x201, x1, 56, x2)

inst_48:
// rs2_val == -1025, rs1_val == -4097
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:-0x401
TEST_RR_OP(add, x12, x10, x11, 0xffffebfe, -0x1001, -0x401, x1, 60, x2)

inst_49:
// rs2_val == -2049, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x801
TEST_RR_OP(add, x12, x10, x11, 0xfffff803, 0x4, -0x801, x1, 64, x2)

inst_50:
// rs2_val == -4097, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0x1001
TEST_RR_OP(add, x12, x10, x11, 0xffff3afc, -0xb503, -0x1001, x1, 68, x2)

inst_51:
// rs2_val == -8193, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0x2001
TEST_RR_OP(add, x12, x10, x11, 0x9503, 0xb504, -0x2001, x1, 72, x2)

inst_52:
// rs2_val == -16385, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffff;  op2val:-0x4001
TEST_RR_OP(add, x12, x10, x11, 0x7fffbffe, 0x7fffffff, -0x4001, x1, 76, x2)

inst_53:
// rs2_val == -32769, rs1_val == -3
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:-0x8001
TEST_RR_OP(add, x12, x10, x11, 0xffff7ffc, -0x3, -0x8001, x1, 80, x2)

inst_54:
// rs2_val == -65537, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0x10001
TEST_RR_OP(add, x12, x10, x11, 0xffffb502, 0xb503, -0x10001, x1, 84, x2)

inst_55:
// rs2_val == -131073, rs1_val == -1431655766
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0x20001
TEST_RR_OP(add, x12, x10, x11, 0xaaa8aaa9, -0x55555556, -0x20001, x1, 88, x2)

inst_56:
// rs2_val == -262145, rs1_val == 16777216
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:-0x40001
TEST_RR_OP(add, x12, x10, x11, 0xfbffff, 0x1000000, -0x40001, x1, 92, x2)

inst_57:
// rs2_val == -524289, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffff;  op2val:-0x80001
TEST_RR_OP(add, x12, x10, x11, 0x7ff7fffe, 0x7fffffff, -0x80001, x1, 96, x2)

inst_58:
// rs2_val == -1048577, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:-0x100001
TEST_RR_OP(add, x12, x10, x11, 0xfff007ff, 0x800, -0x100001, x1, 100, x2)

inst_59:
// rs2_val == -2097153, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:-0x200001
TEST_RR_OP(add, x12, x10, x11, 0xffe00007, 0x8, -0x200001, x1, 104, x2)

inst_60:
// rs2_val == -4194305, rs1_val == 8192
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:-0x400001
TEST_RR_OP(add, x12, x10, x11, 0xffc01fff, 0x2000, -0x400001, x1, 108, x2)

inst_61:
// rs2_val == -8388609, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:-0x800001
TEST_RR_OP(add, x12, x10, x11, 0xff7fffde, -0x21, -0x800001, x1, 112, x2)

inst_62:
// rs2_val == -16777217, rs1_val == -2097153
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:-0x1000001
TEST_RR_OP(add, x12, x10, x11, 0xfedffffe, -0x200001, -0x1000001, x1, 116, x2)

inst_63:
// rs2_val == -67108865, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x4000001
TEST_RR_OP(add, x12, x10, x11, 0xfc000001, 0x2, -0x4000001, x1, 120, x2)

inst_64:
// rs2_val == -134217729, rs1_val == 1431655765
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0x8000001
TEST_RR_OP(add, x12, x10, x11, 0x4d555554, 0x55555555, -0x8000001, x1, 124, x2)

inst_65:
// rs2_val == -268435457, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:-0x10000001
TEST_RR_OP(add, x12, x10, x11, 0xf001ffff, 0x20000, -0x10000001, x1, 128, x2)

inst_66:
// rs2_val == -536870913, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:-0x20000001
TEST_RR_OP(add, x12, x10, x11, 0xe001ffff, 0x20000, -0x20000001, x1, 132, x2)

inst_67:
// rs2_val == -1073741825, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x7;  op2val:-0x40000001
TEST_RR_OP(add, x12, x10, x11, 0xc0000006, 0x7, -0x40000001, x1, 136, x2)

inst_68:
// rs2_val == 1431655765, rs1_val == 1048576
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55655555, 0x100000, 0x55555555, x1, 140, x2)

inst_69:
// rs1_val == 16, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33333343, 0x10, 0x33333333, x1, 144, x2)

inst_70:
// rs1_val == 128, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x333333b2, 0x80, 0x33333332, x1, 148, x2)

inst_71:
// rs1_val == 256, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:-0xa
TEST_RR_OP(add, x12, x10, x11, 0xf6, 0x100, -0xa, x1, 152, x2)

inst_72:
// rs1_val == 512, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xffff4cfd, 0x200, -0xb503, x1, 156, x2)

inst_73:
// rs1_val == 1024, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55555955, 0x400, 0x55555555, x1, 160, x2)

inst_74:
// rs1_val == 4096, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x1005, 0x1000, 0x5, x1, 164, x2)

inst_75:
// rs1_val == 16384, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:-0x801
TEST_RR_OP(add, x12, x10, x11, 0x37ff, 0x4000, -0x801, x1, 168, x2)

inst_76:
// rs1_val == 32768, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:-0x1000001
TEST_RR_OP(add, x12, x10, x11, 0xff007fff, 0x8000, -0x1000001, x1, 172, x2)

inst_77:
// rs1_val == 262144, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:0x1000000
TEST_RR_OP(add, x12, x10, x11, 0x1040000, 0x40000, 0x1000000, x1, 176, x2)

inst_78:
// rs1_val == 524288, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0x8000
TEST_RR_OP(add, x12, x10, x11, 0x88000, 0x80000, 0x8000, x1, 180, x2)

inst_79:
// rs1_val == 2097152, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:0x10000000
TEST_RR_OP(add, x12, x10, x11, 0x10200000, 0x200000, 0x10000000, x1, 184, x2)

inst_80:
// rs1_val == 8388608, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:-0x401
TEST_RR_OP(add, x12, x10, x11, 0x7ffbff, 0x800000, -0x401, x1, 188, x2)

inst_81:
// rs1_val == 33554432, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x57555555, 0x2000000, 0x55555555, x1, 192, x2)

inst_82:
// rs1_val == 67108864, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x8000
TEST_RR_OP(add, x12, x10, x11, 0x4008000, 0x4000000, 0x8000, x1, 196, x2)

inst_83:
// rs1_val == 134217728, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x3b333332, 0x8000000, 0x33333332, x1, 200, x2)

inst_84:
// rs1_val == 268435456, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:-0x40000000
TEST_RR_OP(add, x12, x10, x11, 0xd0000000, 0x10000000, -0x40000000, x1, 204, x2)

inst_85:
// rs1_val == -9, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:-0x80001
TEST_RR_OP(add, x12, x10, x11, 0xfff7fff6, -0x9, -0x80001, x1, 208, x2)

inst_86:
// rs1_val == -65, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:-0x80000000
TEST_RR_OP(add, x12, x10, x11, 0x7fffffbf, -0x41, -0x80000000, x1, 212, x2)

inst_87:
// rs1_val == -129, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaa29, -0x81, -0x55555556, x1, 216, x2)

inst_88:
// rs1_val == -257, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xffffff02, -0x101, 0x3, x1, 220, x2)

inst_89:
// rs1_val == -1025, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:-0x8
TEST_RR_OP(add, x12, x10, x11, 0xfffffbf7, -0x401, -0x8, x1, 224, x2)

inst_90:
// rs1_val == -2049, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xfffff802, -0x801, 0x3, x1, 228, x2)

inst_91:
// rs1_val == -8193, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xffffe001, -0x2001, 0x2, x1, 232, x2)

inst_92:
// rs1_val == -262145, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:-0x800001
TEST_RR_OP(add, x12, x10, x11, 0xff7bfffe, -0x40001, -0x800001, x1, 236, x2)

inst_93:
// rs1_val == -524289, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xfff8b503, -0x80001, 0xb504, x1, 240, x2)

inst_94:
// rs1_val == -1048577, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:-0x40000000
TEST_RR_OP(add, x12, x10, x11, 0xbfefffff, -0x100001, -0x40000000, x1, 244, x2)

inst_95:
// rs1_val == -67108865, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x62666664, -0x4000001, 0x66666665, x1, 248, x2)

inst_96:
// rs1_val == -134217729, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:-0x10000001
TEST_RR_OP(add, x12, x10, x11, 0xe7fffffe, -0x8000001, -0x10000001, x1, 252, x2)

inst_97:
// rs1_val == -268435457, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:0x800
TEST_RR_OP(add, x12, x10, x11, 0xf00007ff, -0x10000001, 0x800, x1, 256, x2)

inst_98:
// rs1_val == -536870913, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:0x20000
TEST_RR_OP(add, x12, x10, x11, 0xe001ffff, -0x20000001, 0x20000, x1, 260, x2)

inst_99:
// rs1_val == -1073741825, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:-0x81
TEST_RR_OP(add, x12, x10, x11, 0xbfffff7e, -0x40000001, -0x81, x1, 264, x2)

inst_100:
// rs1_val==3 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x3, 0x3, x1, 268, x2)

inst_101:
// rs1_val==3 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55555558, 0x3, 0x55555555, x1, 272, x2)

inst_102:
// rs1_val==3 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaad, 0x3, -0x55555556, x1, 276, x2)

inst_103:
// rs1_val==3 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x3, 0x5, x1, 280, x2)

inst_104:
// rs1_val==3 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33333336, 0x3, 0x33333333, x1, 284, x2)

inst_105:
// rs1_val==3 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x66666669, 0x3, 0x66666666, x1, 288, x2)

inst_106:
// rs1_val==3 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xffff4aff, 0x3, -0xb504, x1, 292, x2)

inst_107:
// rs1_val==3 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xb507, 0x3, 0xb504, x1, 296, x2)

inst_108:
// rs1_val==3 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x5, 0x3, 0x2, x1, 300, x2)

inst_109:
// rs1_val==3 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x55555557, 0x3, 0x55555554, x1, 304, x2)

inst_110:
// rs1_val==3 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x3, 0x3, 0x0, x1, 308, x2)

inst_111:
// rs1_val==3 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x7, 0x3, 0x4, x1, 312, x2)

inst_112:
// rs1_val==3 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x33333335, 0x3, 0x33333332, x1, 316, x2)

inst_113:
// rs1_val==3 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x66666668, 0x3, 0x66666665, x1, 320, x2)

inst_114:
// rs1_val==3 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xb506, 0x3, 0xb503, x1, 324, x2)

inst_115:
// rs1_val==3 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x55555559, 0x3, 0x55555556, x1, 328, x2)

inst_116:
// rs1_val==3 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaae, 0x3, -0x55555555, x1, 332, x2)

inst_117:
// rs1_val==3 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x9, 0x3, 0x6, x1, 336, x2)

inst_118:
// rs1_val==3 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x33333337, 0x3, 0x33333334, x1, 340, x2)

inst_119:
// rs1_val==3 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x6666666a, 0x3, 0x66666667, x1, 344, x2)

inst_120:
// rs1_val==3 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xffff4b00, 0x3, -0xb503, x1, 348, x2)

inst_121:
// rs1_val==3 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0xb508, 0x3, 0xb505, x1, 352, x2)

inst_122:
// rs1_val==1431655765 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x55555558, 0x55555555, 0x3, x1, 356, x2)

inst_123:
// rs1_val==1431655765 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaa, 0x55555555, 0x55555555, x1, 360, x2)

inst_124:
// rs1_val==1431655765 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xffffffff, 0x55555555, -0x55555556, x1, 364, x2)

inst_125:
// rs1_val==1431655765 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x5555555a, 0x55555555, 0x5, x1, 368, x2)

inst_126:
// rs1_val==1431655765 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x88888888, 0x55555555, 0x33333333, x1, 372, x2)

inst_127:
// rs1_val==1431655765 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbb, 0x55555555, 0x66666666, x1, 376, x2)

inst_128:
// rs1_val==1431655765 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x5554a051, 0x55555555, -0xb504, x1, 380, x2)

inst_129:
// rs1_val==1431655765 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x55560a59, 0x55555555, 0xb504, x1, 384, x2)

inst_130:
// rs1_val==1431655765 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x55555557, 0x55555555, 0x2, x1, 388, x2)

inst_131:
// rs1_val==1431655765 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9, 0x55555555, 0x55555554, x1, 392, x2)

inst_132:
// rs1_val==1431655765 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x55555555, 0x55555555, 0x0, x1, 396, x2)

inst_133:
// rs1_val==1431655765 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x55555559, 0x55555555, 0x4, x1, 400, x2)

inst_134:
// rs1_val==1431655765 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x88888887, 0x55555555, 0x33333332, x1, 404, x2)

inst_135:
// rs1_val==1431655765 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbba, 0x55555555, 0x66666665, x1, 408, x2)

inst_136:
// rs1_val==1431655765 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x55560a58, 0x55555555, 0xb503, x1, 412, x2)

inst_137:
// rs1_val==1431655765 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab, 0x55555555, 0x55555556, x1, 416, x2)

inst_138:
// rs1_val==1431655765 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x0, 0x55555555, -0x55555555, x1, 420, x2)

inst_139:
// rs1_val==1431655765 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x5555555b, 0x55555555, 0x6, x1, 424, x2)

inst_140:
// rs1_val==1431655765 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x88888889, 0x55555555, 0x33333334, x1, 428, x2)

inst_141:
// rs1_val==1431655765 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbc, 0x55555555, 0x66666667, x1, 432, x2)

inst_142:
// rs1_val==1431655765 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x5554a052, 0x55555555, -0xb503, x1, 436, x2)

inst_143:
// rs1_val==1431655765 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x55560a5a, 0x55555555, 0xb505, x1, 440, x2)

inst_144:
// rs1_val==-1431655766 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaad, -0x55555556, 0x3, x1, 444, x2)

inst_145:
// rs1_val==-1431655766 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xffffffff, -0x55555556, 0x55555555, x1, 448, x2)

inst_146:
// rs1_val==-1431655766 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x55555554, -0x55555556, -0x55555556, x1, 452, x2)

inst_147:
// rs1_val==-1431655766 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaf, -0x55555556, 0x5, x1, 456, x2)

inst_148:
// rs1_val==-1431655766 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0xdddddddd, -0x55555556, 0x33333333, x1, 460, x2)

inst_149:
// rs1_val==-1431655766 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x11111110, -0x55555556, 0x66666666, x1, 464, x2)

inst_150:
// rs1_val==-1431655766 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xaaa9f5a6, -0x55555556, -0xb504, x1, 468, x2)

inst_151:
// rs1_val==-1431655766 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xaaab5fae, -0x55555556, 0xb504, x1, 472, x2)

inst_152:
// rs1_val==-1431655766 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaac, -0x55555556, 0x2, x1, 476, x2)

inst_153:
// rs1_val==-1431655766 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0xfffffffe, -0x55555556, 0x55555554, x1, 480, x2)

inst_154:
// rs1_val==-1431655766 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaa, -0x55555556, 0x0, x1, 484, x2)

inst_155:
// rs1_val==-1431655766 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaae, -0x55555556, 0x4, x1, 488, x2)

inst_156:
// rs1_val==-1431655766 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0xdddddddc, -0x55555556, 0x33333332, x1, 492, x2)

inst_157:
// rs1_val==-1431655766 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x1111110f, -0x55555556, 0x66666665, x1, 496, x2)

inst_158:
// rs1_val==-1431655766 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xaaab5fad, -0x55555556, 0xb503, x1, 500, x2)

inst_159:
// rs1_val==-1431655766 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x0, -0x55555556, 0x55555556, x1, 504, x2)

inst_160:
// rs1_val==-1431655766 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55555555, -0x55555556, -0x55555555, x1, 508, x2)

inst_161:
// rs1_val==-1431655766 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaab0, -0x55555556, 0x6, x1, 512, x2)

inst_162:
// rs1_val==-1431655766 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0xddddddde, -0x55555556, 0x33333334, x1, 516, x2)

inst_163:
// rs1_val==-1431655766 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x11111111, -0x55555556, 0x66666667, x1, 520, x2)

inst_164:
// rs1_val==-1431655766 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xaaa9f5a7, -0x55555556, -0xb503, x1, 524, x2)

inst_165:
// rs1_val==-1431655766 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0xaaab5faf, -0x55555556, 0xb505, x1, 528, x2)

inst_166:
// rs1_val==5 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x5, 0x3, x1, 532, x2)

inst_167:
// rs1_val==5 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x5555555a, 0x5, 0x55555555, x1, 536, x2)

inst_168:
// rs1_val==5 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaf, 0x5, -0x55555556, x1, 540, x2)

inst_169:
// rs1_val==5 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xa, 0x5, 0x5, x1, 544, x2)

inst_170:
// rs1_val==5 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33333338, 0x5, 0x33333333, x1, 548, x2)

inst_171:
// rs1_val==5 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x6666666b, 0x5, 0x66666666, x1, 552, x2)

inst_172:
// rs1_val==5 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xffff4b01, 0x5, -0xb504, x1, 556, x2)

inst_173:
// rs1_val==5 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xb509, 0x5, 0xb504, x1, 560, x2)

inst_174:
// rs1_val==5 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x7, 0x5, 0x2, x1, 564, x2)

inst_175:
// rs1_val==5 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x55555559, 0x5, 0x55555554, x1, 568, x2)

inst_176:
// rs1_val==5 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x5, 0x5, 0x0, x1, 572, x2)

inst_177:
// rs1_val==5 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x9, 0x5, 0x4, x1, 576, x2)

inst_178:
// rs1_val==5 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x33333337, 0x5, 0x33333332, x1, 580, x2)

inst_179:
// rs1_val==5 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x6666666a, 0x5, 0x66666665, x1, 584, x2)

inst_180:
// rs1_val==5 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xb508, 0x5, 0xb503, x1, 588, x2)

inst_181:
// rs1_val==5 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x5555555b, 0x5, 0x55555556, x1, 592, x2)

inst_182:
// rs1_val==5 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaab0, 0x5, -0x55555555, x1, 596, x2)

inst_183:
// rs1_val==5 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xb, 0x5, 0x6, x1, 600, x2)

inst_184:
// rs1_val==5 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x33333339, 0x5, 0x33333334, x1, 604, x2)

inst_185:
// rs1_val==5 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x6666666c, 0x5, 0x66666667, x1, 608, x2)

inst_186:
// rs1_val==5 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xffff4b02, 0x5, -0xb503, x1, 612, x2)

inst_187:
// rs1_val==5 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0xb50a, 0x5, 0xb505, x1, 616, x2)

inst_188:
// rs1_val==858993459 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x33333336, 0x33333333, 0x3, x1, 620, x2)

inst_189:
// rs1_val==858993459 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x88888888, 0x33333333, 0x55555555, x1, 624, x2)

inst_190:
// rs1_val==858993459 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xdddddddd, 0x33333333, -0x55555556, x1, 628, x2)

inst_191:
// rs1_val==858993459 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x33333338, 0x33333333, 0x5, x1, 632, x2)

inst_192:
// rs1_val==858993459 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x66666666, 0x33333333, 0x33333333, x1, 636, x2)

inst_193:
// rs1_val==858993459 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x99999999, 0x33333333, 0x66666666, x1, 640, x2)

inst_194:
// rs1_val==858993459 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x33327e2f, 0x33333333, -0xb504, x1, 644, x2)

inst_195:
// rs1_val==858993459 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x3333e837, 0x33333333, 0xb504, x1, 648, x2)

inst_196:
// rs1_val==858993459 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x33333335, 0x33333333, 0x2, x1, 652, x2)

inst_197:
// rs1_val==858993459 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x88888887, 0x33333333, 0x55555554, x1, 656, x2)

inst_198:
// rs1_val==858993459 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x33333333, 0x33333333, 0x0, x1, 660, x2)

inst_199:
// rs1_val==858993459 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x33333337, 0x33333333, 0x4, x1, 664, x2)

inst_200:
// rs1_val==858993459 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x66666665, 0x33333333, 0x33333332, x1, 668, x2)

inst_201:
// rs1_val==858993459 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x99999998, 0x33333333, 0x66666665, x1, 672, x2)

inst_202:
// rs1_val==858993459 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x3333e836, 0x33333333, 0xb503, x1, 676, x2)

inst_203:
// rs1_val==858993459 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x88888889, 0x33333333, 0x55555556, x1, 680, x2)

inst_204:
// rs1_val==858993459 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xddddddde, 0x33333333, -0x55555555, x1, 684, x2)

inst_205:
// rs1_val==858993459 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x33333339, 0x33333333, 0x6, x1, 688, x2)

inst_206:
// rs1_val==858993459 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x66666667, 0x33333333, 0x33333334, x1, 692, x2)

inst_207:
// rs1_val==858993459 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x9999999a, 0x33333333, 0x66666667, x1, 696, x2)

inst_208:
// rs1_val==858993459 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x33327e30, 0x33333333, -0xb503, x1, 700, x2)

inst_209:
// rs1_val==858993459 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x3333e838, 0x33333333, 0xb505, x1, 704, x2)

inst_210:
// rs1_val==1717986918 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x66666669, 0x66666666, 0x3, x1, 708, x2)

inst_211:
// rs1_val==1717986918 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbb, 0x66666666, 0x55555555, x1, 712, x2)

inst_212:
// rs1_val==1717986918 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x11111110, 0x66666666, -0x55555556, x1, 716, x2)

inst_213:
// rs1_val==1717986918 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x6666666b, 0x66666666, 0x5, x1, 720, x2)

inst_214:
// rs1_val==1717986918 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x99999999, 0x66666666, 0x33333333, x1, 724, x2)

inst_215:
// rs1_val==1717986918 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0xcccccccc, 0x66666666, 0x66666666, x1, 728, x2)

inst_216:
// rs1_val==1717986918 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x6665b162, 0x66666666, -0xb504, x1, 732, x2)

inst_217:
// rs1_val==1717986918 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x66671b6a, 0x66666666, 0xb504, x1, 736, x2)

inst_218:
// rs1_val==1717986918 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x66666668, 0x66666666, 0x2, x1, 740, x2)

inst_219:
// rs1_val==1717986918 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbba, 0x66666666, 0x55555554, x1, 744, x2)

inst_220:
// rs1_val==1717986918 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x66666666, 0x66666666, 0x0, x1, 748, x2)

inst_221:
// rs1_val==1717986918 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x6666666a, 0x66666666, 0x4, x1, 752, x2)

inst_222:
// rs1_val==1717986918 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x99999998, 0x66666666, 0x33333332, x1, 756, x2)

inst_223:
// rs1_val==1717986918 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0xcccccccb, 0x66666666, 0x66666665, x1, 760, x2)

inst_224:
// rs1_val==1717986918 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x66671b69, 0x66666666, 0xb503, x1, 764, x2)

inst_225:
// rs1_val==1717986918 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbc, 0x66666666, 0x55555556, x1, 768, x2)

inst_226:
// rs1_val==1717986918 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x11111111, 0x66666666, -0x55555555, x1, 772, x2)

inst_227:
// rs1_val==1717986918 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x6666666c, 0x66666666, 0x6, x1, 776, x2)

inst_228:
// rs1_val==1717986918 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x9999999a, 0x66666666, 0x33333334, x1, 780, x2)

inst_229:
// rs1_val==1717986918 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0xcccccccd, 0x66666666, 0x66666667, x1, 784, x2)

inst_230:
// rs1_val==1717986918 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x6665b163, 0x66666666, -0xb503, x1, 788, x2)

inst_231:
// rs1_val==1717986918 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x66671b6b, 0x66666666, 0xb505, x1, 792, x2)

inst_232:
// rs1_val==-46340 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xffff4aff, -0xb504, 0x3, x1, 796, x2)

inst_233:
// rs1_val==-46340 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x5554a051, -0xb504, 0x55555555, x1, 800, x2)

inst_234:
// rs1_val==-46340 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaa9f5a6, -0xb504, -0x55555556, x1, 804, x2)

inst_235:
// rs1_val==-46340 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xffff4b01, -0xb504, 0x5, x1, 808, x2)

inst_236:
// rs1_val==-46340 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33327e2f, -0xb504, 0x33333333, x1, 812, x2)

inst_237:
// rs1_val==-46340 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x6665b162, -0xb504, 0x66666666, x1, 816, x2)

inst_238:
// rs1_val==-46340 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xfffe95f8, -0xb504, -0xb504, x1, 820, x2)

inst_239:
// rs1_val==-46340 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x0, -0xb504, 0xb504, x1, 824, x2)

inst_240:
// rs1_val==-46340 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xffff4afe, -0xb504, 0x2, x1, 828, x2)

inst_241:
// rs1_val==-46340 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x5554a050, -0xb504, 0x55555554, x1, 832, x2)

inst_242:
// rs1_val==-46340 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xffff4afc, -0xb504, 0x0, x1, 836, x2)

inst_243:
// rs1_val==-46340 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xffff4b00, -0xb504, 0x4, x1, 840, x2)

inst_244:
// rs1_val==-46340 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x33327e2e, -0xb504, 0x33333332, x1, 844, x2)

inst_245:
// rs1_val==-46340 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x6665b161, -0xb504, 0x66666665, x1, 848, x2)

inst_246:
// rs1_val==-46340 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xffffffff, -0xb504, 0xb503, x1, 852, x2)

inst_247:
// rs1_val==-46340 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x5554a052, -0xb504, 0x55555556, x1, 856, x2)

inst_248:
// rs1_val==-46340 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaa9f5a7, -0xb504, -0x55555555, x1, 860, x2)

inst_249:
// rs1_val==-46340 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xffff4b02, -0xb504, 0x6, x1, 864, x2)

inst_250:
// rs1_val==-46340 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x33327e30, -0xb504, 0x33333334, x1, 868, x2)

inst_251:
// rs1_val==-46340 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x6665b163, -0xb504, 0x66666667, x1, 872, x2)

inst_252:
// rs1_val==-46340 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xfffe95f9, -0xb504, -0xb503, x1, 876, x2)

inst_253:
// rs1_val==-46340 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x1, -0xb504, 0xb505, x1, 880, x2)

inst_254:
// rs1_val==46340 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xb507, 0xb504, 0x3, x1, 884, x2)

inst_255:
// rs1_val==46340 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55560a59, 0xb504, 0x55555555, x1, 888, x2)

inst_256:
// rs1_val==46340 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaab5fae, 0xb504, -0x55555556, x1, 892, x2)

inst_257:
// rs1_val==46340 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xb509, 0xb504, 0x5, x1, 896, x2)

inst_258:
// rs1_val==46340 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x3333e837, 0xb504, 0x33333333, x1, 900, x2)

inst_259:
// rs1_val==46340 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x66671b6a, 0xb504, 0x66666666, x1, 904, x2)

inst_260:
// rs1_val==46340 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x0, 0xb504, -0xb504, x1, 908, x2)

inst_261:
// rs1_val==46340 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x16a08, 0xb504, 0xb504, x1, 912, x2)

inst_262:
// rs1_val==46340 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xb506, 0xb504, 0x2, x1, 916, x2)

inst_263:
// rs1_val==46340 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x55560a58, 0xb504, 0x55555554, x1, 920, x2)

inst_264:
// rs1_val==46340 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xb504, 0xb504, 0x0, x1, 924, x2)

inst_265:
// rs1_val==46340 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xb508, 0xb504, 0x4, x1, 928, x2)

inst_266:
// rs1_val==46340 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x3333e836, 0xb504, 0x33333332, x1, 932, x2)

inst_267:
// rs1_val==46340 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x66671b69, 0xb504, 0x66666665, x1, 936, x2)

inst_268:
// rs1_val==46340 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x16a07, 0xb504, 0xb503, x1, 940, x2)

inst_269:
// rs1_val==46340 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x55560a5a, 0xb504, 0x55555556, x1, 944, x2)

inst_270:
// rs1_val==46340 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaab5faf, 0xb504, -0x55555555, x1, 948, x2)

inst_271:
// rs1_val==46340 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xb50a, 0xb504, 0x6, x1, 952, x2)

inst_272:
// rs1_val==46340 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x3333e838, 0xb504, 0x33333334, x1, 956, x2)

inst_273:
// rs1_val==46340 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x66671b6b, 0xb504, 0x66666667, x1, 960, x2)

inst_274:
// rs1_val==46340 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x1, 0xb504, -0xb503, x1, 964, x2)

inst_275:
// rs1_val==46340 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x16a09, 0xb504, 0xb505, x1, 968, x2)

inst_276:
// rs1_val==2 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x5, 0x2, 0x3, x1, 972, x2)

inst_277:
// rs1_val==2 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55555557, 0x2, 0x55555555, x1, 976, x2)

inst_278:
// rs1_val==2 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaac, 0x2, -0x55555556, x1, 980, x2)

inst_279:
// rs1_val==2 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x7, 0x2, 0x5, x1, 984, x2)

inst_280:
// rs1_val==2 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33333335, 0x2, 0x33333333, x1, 988, x2)

inst_281:
// rs1_val==2 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x66666668, 0x2, 0x66666666, x1, 992, x2)

inst_282:
// rs1_val==2 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xffff4afe, 0x2, -0xb504, x1, 996, x2)

inst_283:
// rs1_val==2 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xb506, 0x2, 0xb504, x1, 1000, x2)

inst_284:
// rs1_val==2 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x4, 0x2, 0x2, x1, 1004, x2)

inst_285:
// rs1_val==2 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x55555556, 0x2, 0x55555554, x1, 1008, x2)

inst_286:
// rs1_val==2 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x2, 0x2, 0x0, x1, 1012, x2)

inst_287:
// rs1_val==2 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x2, 0x4, x1, 1016, x2)

inst_288:
// rs1_val==2 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x33333334, 0x2, 0x33333332, x1, 1020, x2)

inst_289:
// rs1_val==2 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x66666667, 0x2, 0x66666665, x1, 1024, x2)

inst_290:
// rs1_val==2 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xb505, 0x2, 0xb503, x1, 1028, x2)

inst_291:
// rs1_val==2 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x55555558, 0x2, 0x55555556, x1, 1032, x2)

inst_292:
// rs1_val==2 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaad, 0x2, -0x55555555, x1, 1036, x2)

inst_293:
// rs1_val==2 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x2, 0x6, x1, 1040, x2)

inst_294:
// rs1_val==2 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x33333336, 0x2, 0x33333334, x1, 1044, x2)

inst_295:
// rs1_val==2 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x66666669, 0x2, 0x66666667, x1, 1048, x2)

inst_296:
// rs1_val==2 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xffff4aff, 0x2, -0xb503, x1, 1052, x2)

inst_297:
// rs1_val==2 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0xb507, 0x2, 0xb505, x1, 1056, x2)

inst_298:
// rs1_val==1431655764 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x55555557, 0x55555554, 0x3, x1, 1060, x2)

inst_299:
// rs1_val==1431655764 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9, 0x55555554, 0x55555555, x1, 1064, x2)

inst_300:
// rs1_val==1431655764 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xfffffffe, 0x55555554, -0x55555556, x1, 1068, x2)

inst_301:
// rs1_val==1431655764 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x55555559, 0x55555554, 0x5, x1, 1072, x2)

inst_302:
// rs1_val==1431655764 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x88888887, 0x55555554, 0x33333333, x1, 1076, x2)

inst_303:
// rs1_val==1431655764 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbba, 0x55555554, 0x66666666, x1, 1080, x2)

inst_304:
// rs1_val==1431655764 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x5554a050, 0x55555554, -0xb504, x1, 1084, x2)

inst_305:
// rs1_val==1431655764 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x55560a58, 0x55555554, 0xb504, x1, 1088, x2)

inst_306:
// rs1_val==1431655764 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x55555556, 0x55555554, 0x2, x1, 1092, x2)

inst_307:
// rs1_val==1431655764 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa8, 0x55555554, 0x55555554, x1, 1096, x2)

inst_308:
// rs1_val==1431655764 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x55555554, 0x55555554, 0x0, x1, 1100, x2)

inst_309:
// rs1_val==1431655764 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x55555558, 0x55555554, 0x4, x1, 1104, x2)

inst_310:
// rs1_val==1431655764 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x88888886, 0x55555554, 0x33333332, x1, 1108, x2)

inst_311:
// rs1_val==1431655764 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbb9, 0x55555554, 0x66666665, x1, 1112, x2)

inst_312:
// rs1_val==1431655764 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x55560a57, 0x55555554, 0xb503, x1, 1116, x2)

inst_313:
// rs1_val==1431655764 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaa, 0x55555554, 0x55555556, x1, 1120, x2)

inst_314:
// rs1_val==1431655764 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xffffffff, 0x55555554, -0x55555555, x1, 1124, x2)

inst_315:
// rs1_val==1431655764 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x5555555a, 0x55555554, 0x6, x1, 1128, x2)

inst_316:
// rs1_val==1431655764 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x88888888, 0x55555554, 0x33333334, x1, 1132, x2)

inst_317:
// rs1_val==1431655764 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbb, 0x55555554, 0x66666667, x1, 1136, x2)

inst_318:
// rs1_val==1431655764 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x5554a051, 0x55555554, -0xb503, x1, 1140, x2)

inst_319:
// rs1_val==1431655764 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x55560a59, 0x55555554, 0xb505, x1, 1144, x2)

inst_320:
// rs1_val==0 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x3, 0x0, 0x3, x1, 1148, x2)

inst_321:
// rs1_val==0 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55555555, 0x0, 0x55555555, x1, 1152, x2)

inst_322:
// rs1_val==0 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaa, 0x0, -0x55555556, x1, 1156, x2)

inst_323:
// rs1_val==0 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x5, 0x0, 0x5, x1, 1160, x2)

inst_324:
// rs1_val==0 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33333333, 0x0, 0x33333333, x1, 1164, x2)

inst_325:
// rs1_val==0 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x66666666, 0x0, 0x66666666, x1, 1168, x2)

inst_326:
// rs1_val==0 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xffff4afc, 0x0, -0xb504, x1, 1172, x2)

inst_327:
// rs1_val==0 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xb504, 0x0, 0xb504, x1, 1176, x2)

inst_328:
// rs1_val==-1431655765 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55555556, -0x55555555, -0x55555555, x1, 1180, x2)

inst_329:
// rs1_val==-1431655765 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaab1, -0x55555555, 0x6, x1, 1184, x2)

inst_330:
// rs1_val==-1431655765 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0xdddddddf, -0x55555555, 0x33333334, x1, 1188, x2)

inst_331:
// rs1_val==-1431655765 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x11111112, -0x55555555, 0x66666667, x1, 1192, x2)

inst_332:
// rs1_val==-1431655765 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xaaa9f5a8, -0x55555555, -0xb503, x1, 1196, x2)

inst_333:
// rs1_val==-1431655765 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0xaaab5fb0, -0x55555555, 0xb505, x1, 1200, x2)

inst_334:
// rs1_val==6 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x9, 0x6, 0x3, x1, 1204, x2)

inst_335:
// rs1_val==6 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x5555555b, 0x6, 0x55555555, x1, 1208, x2)

inst_336:
// rs1_val==6 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaab0, 0x6, -0x55555556, x1, 1212, x2)

inst_337:
// rs1_val==6 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xb, 0x6, 0x5, x1, 1216, x2)

inst_338:
// rs1_val==6 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33333339, 0x6, 0x33333333, x1, 1220, x2)

inst_339:
// rs1_val==6 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x6666666c, 0x6, 0x66666666, x1, 1224, x2)

inst_340:
// rs1_val==6 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xffff4b02, 0x6, -0xb504, x1, 1228, x2)

inst_341:
// rs1_val==6 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xb50a, 0x6, 0xb504, x1, 1232, x2)

inst_342:
// rs1_val==6 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x6, 0x2, x1, 1236, x2)

inst_343:
// rs1_val==6 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x5555555a, 0x6, 0x55555554, x1, 1240, x2)

inst_344:
// rs1_val==6 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x6, 0x0, x1, 1244, x2)

inst_345:
// rs1_val==6 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xa, 0x6, 0x4, x1, 1248, x2)

inst_346:
// rs1_val==6 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x33333338, 0x6, 0x33333332, x1, 1252, x2)

inst_347:
// rs1_val==6 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x6666666b, 0x6, 0x66666665, x1, 1256, x2)

inst_348:
// rs1_val==6 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xb509, 0x6, 0xb503, x1, 1260, x2)

inst_349:
// rs1_val==6 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x5555555c, 0x6, 0x55555556, x1, 1264, x2)

inst_350:
// rs1_val==6 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaab1, 0x6, -0x55555555, x1, 1268, x2)

inst_351:
// rs1_val==6 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xc, 0x6, 0x6, x1, 1272, x2)

inst_352:
// rs1_val==6 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x3333333a, 0x6, 0x33333334, x1, 1276, x2)

inst_353:
// rs1_val==6 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x6666666d, 0x6, 0x66666667, x1, 1280, x2)

inst_354:
// rs1_val==6 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xffff4b03, 0x6, -0xb503, x1, 1284, x2)

inst_355:
// rs1_val==6 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0xb50b, 0x6, 0xb505, x1, 1288, x2)

inst_356:
// rs1_val==858993460 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x33333337, 0x33333334, 0x3, x1, 1292, x2)

inst_357:
// rs1_val==858993460 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x88888889, 0x33333334, 0x55555555, x1, 1296, x2)

inst_358:
// rs1_val==858993460 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xddddddde, 0x33333334, -0x55555556, x1, 1300, x2)

inst_359:
// rs1_val==858993460 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x33333339, 0x33333334, 0x5, x1, 1304, x2)

inst_360:
// rs1_val==858993460 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x66666667, 0x33333334, 0x33333333, x1, 1308, x2)

inst_361:
// rs1_val==858993460 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x9999999a, 0x33333334, 0x66666666, x1, 1312, x2)

inst_362:
// rs1_val==858993460 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x33327e30, 0x33333334, -0xb504, x1, 1316, x2)

inst_363:
// rs1_val==858993460 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x3333e838, 0x33333334, 0xb504, x1, 1320, x2)

inst_364:
// rs1_val==858993460 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x33333336, 0x33333334, 0x2, x1, 1324, x2)

inst_365:
// rs1_val==858993460 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x88888888, 0x33333334, 0x55555554, x1, 1328, x2)

inst_366:
// rs1_val==858993460 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x33333334, 0x33333334, 0x0, x1, 1332, x2)

inst_367:
// rs1_val==858993460 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x33333338, 0x33333334, 0x4, x1, 1336, x2)

inst_368:
// rs1_val==858993460 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x66666666, 0x33333334, 0x33333332, x1, 1340, x2)

inst_369:
// rs1_val==858993460 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x99999999, 0x33333334, 0x66666665, x1, 1344, x2)

inst_370:
// rs1_val==858993460 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x3333e837, 0x33333334, 0xb503, x1, 1348, x2)

inst_371:
// rs1_val==858993460 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x8888888a, 0x33333334, 0x55555556, x1, 1352, x2)

inst_372:
// rs1_val==858993460 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xdddddddf, 0x33333334, -0x55555555, x1, 1356, x2)

inst_373:
// rs1_val==858993460 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x3333333a, 0x33333334, 0x6, x1, 1360, x2)

inst_374:
// rs1_val==858993460 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x66666668, 0x33333334, 0x33333334, x1, 1364, x2)

inst_375:
// rs1_val==858993460 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x9999999b, 0x33333334, 0x66666667, x1, 1368, x2)

inst_376:
// rs1_val==858993460 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x33327e31, 0x33333334, -0xb503, x1, 1372, x2)

inst_377:
// rs1_val==858993460 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x3333e839, 0x33333334, 0xb505, x1, 1376, x2)

inst_378:
// rs1_val==1717986919 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x6666666a, 0x66666667, 0x3, x1, 1380, x2)

inst_379:
// rs1_val==1717986919 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbc, 0x66666667, 0x55555555, x1, 1384, x2)

inst_380:
// rs1_val==1717986919 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x11111111, 0x66666667, -0x55555556, x1, 1388, x2)

inst_381:
// rs1_val==1717986919 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x6666666c, 0x66666667, 0x5, x1, 1392, x2)

inst_382:
// rs1_val==1717986919 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x9999999a, 0x66666667, 0x33333333, x1, 1396, x2)

inst_383:
// rs1_val==1717986919 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0xcccccccd, 0x66666667, 0x66666666, x1, 1400, x2)

inst_384:
// rs1_val==1717986919 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x6665b163, 0x66666667, -0xb504, x1, 1404, x2)

inst_385:
// rs1_val==1717986919 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x66671b6b, 0x66666667, 0xb504, x1, 1408, x2)

inst_386:
// rs1_val==1717986919 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x66666669, 0x66666667, 0x2, x1, 1412, x2)

inst_387:
// rs1_val==1717986919 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbb, 0x66666667, 0x55555554, x1, 1416, x2)

inst_388:
// rs1_val==1717986919 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x66666667, 0x66666667, 0x0, x1, 1420, x2)

inst_389:
// rs1_val==1717986919 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x6666666b, 0x66666667, 0x4, x1, 1424, x2)

inst_390:
// rs1_val==1717986919 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x99999999, 0x66666667, 0x33333332, x1, 1428, x2)

inst_391:
// rs1_val==1717986919 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0xcccccccc, 0x66666667, 0x66666665, x1, 1432, x2)

inst_392:
// rs1_val==1717986919 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x66671b6a, 0x66666667, 0xb503, x1, 1436, x2)

inst_393:
// rs1_val==1717986919 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbd, 0x66666667, 0x55555556, x1, 1440, x2)

inst_394:
// rs1_val==1717986919 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x11111112, 0x66666667, -0x55555555, x1, 1444, x2)

inst_395:
// rs1_val==1717986919 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x6666666d, 0x66666667, 0x6, x1, 1448, x2)

inst_396:
// rs1_val==1717986919 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x9999999b, 0x66666667, 0x33333334, x1, 1452, x2)

inst_397:
// rs1_val==1717986919 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0xccccccce, 0x66666667, 0x66666667, x1, 1456, x2)

inst_398:
// rs1_val==1717986919 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x6665b164, 0x66666667, -0xb503, x1, 1460, x2)

inst_399:
// rs1_val==1717986919 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x66671b6c, 0x66666667, 0xb505, x1, 1464, x2)

inst_400:
// rs1_val==-46339 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xffff4b00, -0xb503, 0x3, x1, 1468, x2)

inst_401:
// rs1_val==-46339 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x5554a052, -0xb503, 0x55555555, x1, 1472, x2)

inst_402:
// rs1_val==-46339 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaa9f5a7, -0xb503, -0x55555556, x1, 1476, x2)

inst_403:
// rs1_val==-46339 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xffff4b02, -0xb503, 0x5, x1, 1480, x2)

inst_404:
// rs1_val==-46339 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33327e30, -0xb503, 0x33333333, x1, 1484, x2)

inst_405:
// rs1_val==-46339 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x6665b163, -0xb503, 0x66666666, x1, 1488, x2)

inst_406:
// rs1_val==-46339 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xfffe95f9, -0xb503, -0xb504, x1, 1492, x2)

inst_407:
// rs1_val==-46339 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x1, -0xb503, 0xb504, x1, 1496, x2)

inst_408:
// rs1_val==-46339 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xffff4aff, -0xb503, 0x2, x1, 1500, x2)

inst_409:
// rs1_val==-46339 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x5554a051, -0xb503, 0x55555554, x1, 1504, x2)

inst_410:
// rs1_val==-46339 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xffff4afd, -0xb503, 0x0, x1, 1508, x2)

inst_411:
// rs1_val==-46339 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xffff4b01, -0xb503, 0x4, x1, 1512, x2)

inst_412:
// rs1_val==-46339 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x33327e2f, -0xb503, 0x33333332, x1, 1516, x2)

inst_413:
// rs1_val==-46339 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x6665b162, -0xb503, 0x66666665, x1, 1520, x2)

inst_414:
// rs1_val==-46339 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x0, -0xb503, 0xb503, x1, 1524, x2)

inst_415:
// rs1_val==-46339 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x5554a053, -0xb503, 0x55555556, x1, 1528, x2)

inst_416:
// rs1_val==-46339 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaa9f5a8, -0xb503, -0x55555555, x1, 1532, x2)

inst_417:
// rs1_val==-46339 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xffff4b03, -0xb503, 0x6, x1, 1536, x2)

inst_418:
// rs1_val==-46339 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x33327e31, -0xb503, 0x33333334, x1, 1540, x2)

inst_419:
// rs1_val==-46339 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x6665b164, -0xb503, 0x66666667, x1, 1544, x2)

inst_420:
// rs1_val==-46339 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xfffe95fa, -0xb503, -0xb503, x1, 1548, x2)

inst_421:
// rs1_val==-46339 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x2, -0xb503, 0xb505, x1, 1552, x2)

inst_422:
// rs1_val==46341 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xb508, 0xb505, 0x3, x1, 1556, x2)

inst_423:
// rs1_val==46341 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55560a5a, 0xb505, 0x55555555, x1, 1560, x2)

inst_424:
// rs1_val==46341 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaab5faf, 0xb505, -0x55555556, x1, 1564, x2)

inst_425:
// rs1_val==46341 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xb50a, 0xb505, 0x5, x1, 1568, x2)

inst_426:
// rs1_val==46341 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x3333e838, 0xb505, 0x33333333, x1, 1572, x2)

inst_427:
// rs1_val==46341 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x66671b6b, 0xb505, 0x66666666, x1, 1576, x2)

inst_428:
// rs1_val==46341 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x1, 0xb505, -0xb504, x1, 1580, x2)

inst_429:
// rs1_val==46341 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x16a09, 0xb505, 0xb504, x1, 1584, x2)

inst_430:
// rs1_val==46341 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xb507, 0xb505, 0x2, x1, 1588, x2)

inst_431:
// rs1_val==46341 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x55560a59, 0xb505, 0x55555554, x1, 1592, x2)

inst_432:
// rs1_val==46341 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xb505, 0xb505, 0x0, x1, 1596, x2)

inst_433:
// rs1_val==46341 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xb509, 0xb505, 0x4, x1, 1600, x2)

inst_434:
// rs1_val==46341 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x3333e837, 0xb505, 0x33333332, x1, 1604, x2)

inst_435:
// rs1_val==46341 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x66671b6a, 0xb505, 0x66666665, x1, 1608, x2)

inst_436:
// rs1_val==46341 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x16a08, 0xb505, 0xb503, x1, 1612, x2)

inst_437:
// rs1_val==46341 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x55560a5b, 0xb505, 0x55555556, x1, 1616, x2)

inst_438:
// rs1_val==46341 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaab5fb0, 0xb505, -0x55555555, x1, 1620, x2)

inst_439:
// rs1_val==46341 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xb50b, 0xb505, 0x6, x1, 1624, x2)

inst_440:
// rs1_val==46341 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x3333e839, 0xb505, 0x33333334, x1, 1628, x2)

inst_441:
// rs1_val==46341 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x66671b6c, 0xb505, 0x66666667, x1, 1632, x2)

inst_442:
// rs1_val==46341 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x2, 0xb505, -0xb503, x1, 1636, x2)

inst_443:
// rs1_val==46341 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x16a0a, 0xb505, 0xb505, x1, 1640, x2)

inst_444:
// rs1_val==0 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x2, 0x0, 0x2, x1, 1644, x2)

inst_445:
// rs1_val==0 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x55555554, 0x0, 0x55555554, x1, 1648, x2)

inst_446:
// rs1_val==0 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x0, 0x0, 0x0, x1, 1652, x2)

inst_447:
// rs1_val==0 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x4, 0x0, 0x4, x1, 1656, x2)

inst_448:
// rs1_val==0 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x33333332, 0x0, 0x33333332, x1, 1660, x2)

inst_449:
// rs1_val==0 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x66666665, 0x0, 0x66666665, x1, 1664, x2)

inst_450:
// rs1_val==0 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xb503, 0x0, 0xb503, x1, 1668, x2)

inst_451:
// rs1_val==0 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x55555556, 0x0, 0x55555556, x1, 1672, x2)

inst_452:
// rs1_val==0 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab, 0x0, -0x55555555, x1, 1676, x2)

inst_453:
// rs1_val==0 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x0, 0x6, x1, 1680, x2)

inst_454:
// rs1_val==0 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x33333334, 0x0, 0x33333334, x1, 1684, x2)

inst_455:
// rs1_val==0 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x66666667, 0x0, 0x66666667, x1, 1688, x2)

inst_456:
// rs1_val==0 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xffff4afd, 0x0, -0xb503, x1, 1692, x2)

inst_457:
// rs1_val==0 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0xb505, 0x0, 0xb505, x1, 1696, x2)

inst_458:
// rs1_val==4 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x7, 0x4, 0x3, x1, 1700, x2)

inst_459:
// rs1_val==4 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55555559, 0x4, 0x55555555, x1, 1704, x2)

inst_460:
// rs1_val==4 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaae, 0x4, -0x55555556, x1, 1708, x2)

inst_461:
// rs1_val==4 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x9, 0x4, 0x5, x1, 1712, x2)

inst_462:
// rs1_val==4 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x33333337, 0x4, 0x33333333, x1, 1716, x2)

inst_463:
// rs1_val==4 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x6666666a, 0x4, 0x66666666, x1, 1720, x2)

inst_464:
// rs1_val==4 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xffff4b00, 0x4, -0xb504, x1, 1724, x2)

inst_465:
// rs1_val==4 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xb508, 0x4, 0xb504, x1, 1728, x2)

inst_466:
// rs1_val==4 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x4, 0x2, x1, 1732, x2)

inst_467:
// rs1_val==4 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x55555558, 0x4, 0x55555554, x1, 1736, x2)

inst_468:
// rs1_val==4 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x4, 0x4, 0x0, x1, 1740, x2)

inst_469:
// rs1_val==4 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x4, 0x4, x1, 1744, x2)

inst_470:
// rs1_val==4 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x33333336, 0x4, 0x33333332, x1, 1748, x2)

inst_471:
// rs1_val==4 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x66666669, 0x4, 0x66666665, x1, 1752, x2)

inst_472:
// rs1_val==4 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xb507, 0x4, 0xb503, x1, 1756, x2)

inst_473:
// rs1_val==4 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x5555555a, 0x4, 0x55555556, x1, 1760, x2)

inst_474:
// rs1_val==4 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaf, 0x4, -0x55555555, x1, 1764, x2)

inst_475:
// rs1_val==4 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xa, 0x4, 0x6, x1, 1768, x2)

inst_476:
// rs1_val==4 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x33333338, 0x4, 0x33333334, x1, 1772, x2)

inst_477:
// rs1_val==4 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x6666666b, 0x4, 0x66666667, x1, 1776, x2)

inst_478:
// rs1_val==4 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0xffff4b01, 0x4, -0xb503, x1, 1780, x2)

inst_479:
// rs1_val==4 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0xb509, 0x4, 0xb505, x1, 1784, x2)

inst_480:
// rs1_val==858993458 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x33333335, 0x33333332, 0x3, x1, 1788, x2)

inst_481:
// rs1_val==858993458 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x88888887, 0x33333332, 0x55555555, x1, 1792, x2)

inst_482:
// rs1_val==858993458 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xdddddddc, 0x33333332, -0x55555556, x1, 1796, x2)

inst_483:
// rs1_val==858993458 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x33333337, 0x33333332, 0x5, x1, 1800, x2)

inst_484:
// rs1_val==858993458 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x66666665, 0x33333332, 0x33333333, x1, 1804, x2)

inst_485:
// rs1_val==858993458 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x99999998, 0x33333332, 0x66666666, x1, 1808, x2)

inst_486:
// rs1_val==858993458 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x33327e2e, 0x33333332, -0xb504, x1, 1812, x2)

inst_487:
// rs1_val==858993458 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x3333e836, 0x33333332, 0xb504, x1, 1816, x2)

inst_488:
// rs1_val==858993458 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x33333334, 0x33333332, 0x2, x1, 1820, x2)

inst_489:
// rs1_val==858993458 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x88888886, 0x33333332, 0x55555554, x1, 1824, x2)

inst_490:
// rs1_val==858993458 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x33333332, 0x33333332, 0x0, x1, 1828, x2)

inst_491:
// rs1_val==858993458 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x33333336, 0x33333332, 0x4, x1, 1832, x2)

inst_492:
// rs1_val==858993458 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x66666664, 0x33333332, 0x33333332, x1, 1836, x2)

inst_493:
// rs1_val==858993458 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x99999997, 0x33333332, 0x66666665, x1, 1840, x2)

inst_494:
// rs1_val==858993458 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x3333e835, 0x33333332, 0xb503, x1, 1844, x2)

inst_495:
// rs1_val==858993458 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x88888888, 0x33333332, 0x55555556, x1, 1848, x2)

inst_496:
// rs1_val==858993458 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xdddddddd, 0x33333332, -0x55555555, x1, 1852, x2)

inst_497:
// rs1_val==858993458 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x33333338, 0x33333332, 0x6, x1, 1856, x2)

inst_498:
// rs1_val==858993458 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x66666666, 0x33333332, 0x33333334, x1, 1860, x2)

inst_499:
// rs1_val==858993458 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x99999999, 0x33333332, 0x66666667, x1, 1864, x2)

inst_500:
// rs1_val==858993458 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x33327e2f, 0x33333332, -0xb503, x1, 1868, x2)

inst_501:
// rs1_val==858993458 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x3333e837, 0x33333332, 0xb505, x1, 1872, x2)

inst_502:
// rs1_val==1717986917 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x66666668, 0x66666665, 0x3, x1, 1876, x2)

inst_503:
// rs1_val==1717986917 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbba, 0x66666665, 0x55555555, x1, 1880, x2)

inst_504:
// rs1_val==1717986917 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x1111110f, 0x66666665, -0x55555556, x1, 1884, x2)

inst_505:
// rs1_val==1717986917 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x6666666a, 0x66666665, 0x5, x1, 1888, x2)

inst_506:
// rs1_val==1717986917 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x99999998, 0x66666665, 0x33333333, x1, 1892, x2)

inst_507:
// rs1_val==1717986917 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0xcccccccb, 0x66666665, 0x66666666, x1, 1896, x2)

inst_508:
// rs1_val==1717986917 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x6665b161, 0x66666665, -0xb504, x1, 1900, x2)

inst_509:
// rs1_val==1717986917 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x66671b69, 0x66666665, 0xb504, x1, 1904, x2)

inst_510:
// rs1_val==1717986917 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x66666667, 0x66666665, 0x2, x1, 1908, x2)

inst_511:
// rs1_val==1717986917 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbb9, 0x66666665, 0x55555554, x1, 1912, x2)

inst_512:
// rs1_val==1717986917 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x66666665, 0x66666665, 0x0, x1, 1916, x2)

inst_513:
// rs1_val==1717986917 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x66666669, 0x66666665, 0x4, x1, 1920, x2)

inst_514:
// rs1_val==1717986917 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x99999997, 0x66666665, 0x33333332, x1, 1924, x2)

inst_515:
// rs1_val==1717986917 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0xccccccca, 0x66666665, 0x66666665, x1, 1928, x2)

inst_516:
// rs1_val==1717986917 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x66671b68, 0x66666665, 0xb503, x1, 1932, x2)

inst_517:
// rs1_val==1717986917 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbb, 0x66666665, 0x55555556, x1, 1936, x2)

inst_518:
// rs1_val==1717986917 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x11111110, 0x66666665, -0x55555555, x1, 1940, x2)

inst_519:
// rs1_val==1717986917 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x6666666b, 0x66666665, 0x6, x1, 1944, x2)

inst_520:
// rs1_val==1717986917 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x99999999, 0x66666665, 0x33333334, x1, 1948, x2)

inst_521:
// rs1_val==1717986917 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0xcccccccc, 0x66666665, 0x66666667, x1, 1952, x2)

inst_522:
// rs1_val==1717986917 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x6665b162, 0x66666665, -0xb503, x1, 1956, x2)

inst_523:
// rs1_val==1717986917 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x66671b6a, 0x66666665, 0xb505, x1, 1960, x2)

inst_524:
// rs1_val==46339 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xb506, 0xb503, 0x3, x1, 1964, x2)

inst_525:
// rs1_val==46339 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x55560a58, 0xb503, 0x55555555, x1, 1968, x2)

inst_526:
// rs1_val==46339 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0xaaab5fad, 0xb503, -0x55555556, x1, 1972, x2)

inst_527:
// rs1_val==46339 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xb508, 0xb503, 0x5, x1, 1976, x2)

inst_528:
// rs1_val==46339 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x3333e836, 0xb503, 0x33333333, x1, 1980, x2)

inst_529:
// rs1_val==46339 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x66671b69, 0xb503, 0x66666666, x1, 1984, x2)

inst_530:
// rs1_val==46339 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xffffffff, 0xb503, -0xb504, x1, 1988, x2)

inst_531:
// rs1_val==46339 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x16a07, 0xb503, 0xb504, x1, 1992, x2)

inst_532:
// rs1_val==46339 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xb505, 0xb503, 0x2, x1, 1996, x2)

inst_533:
// rs1_val==46339 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0x55560a57, 0xb503, 0x55555554, x1, 2000, x2)

inst_534:
// rs1_val==46339 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xb503, 0xb503, 0x0, x1, 2004, x2)

inst_535:
// rs1_val==46339 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xb507, 0xb503, 0x4, x1, 2008, x2)

inst_536:
// rs1_val==46339 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x3333e835, 0xb503, 0x33333332, x1, 2012, x2)

inst_537:
// rs1_val==46339 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x66671b68, 0xb503, 0x66666665, x1, 2016, x2)

inst_538:
// rs1_val==46339 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x16a06, 0xb503, 0xb503, x1, 2020, x2)

inst_539:
// rs1_val==46339 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x55560a59, 0xb503, 0x55555556, x1, 2024, x2)

inst_540:
// rs1_val==46339 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaab5fae, 0xb503, -0x55555555, x1, 2028, x2)

inst_541:
// rs1_val==46339 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xb509, 0xb503, 0x6, x1, 2032, x2)

inst_542:
// rs1_val==46339 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x3333e837, 0xb503, 0x33333334, x1, 2036, x2)

inst_543:
// rs1_val==46339 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0x66671b6a, 0xb503, 0x66666667, x1, 2040, x2)

inst_544:
// rs1_val==46339 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x0, 0xb503, -0xb503, x1, 2044, x2)
RVTEST_SIGBASE( x1,signature_x1_1)

inst_545:
// rs1_val==46339 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x16a08, 0xb503, 0xb505, x1, 0, x2)

inst_546:
// rs1_val==1431655766 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x55555559, 0x55555556, 0x3, x1, 4, x2)

inst_547:
// rs1_val==1431655766 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab, 0x55555556, 0x55555555, x1, 8, x2)

inst_548:
// rs1_val==1431655766 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x0, 0x55555556, -0x55555556, x1, 12, x2)

inst_549:
// rs1_val==1431655766 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x5555555b, 0x55555556, 0x5, x1, 16, x2)

inst_550:
// rs1_val==1431655766 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0x88888889, 0x55555556, 0x33333333, x1, 20, x2)

inst_551:
// rs1_val==1431655766 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbc, 0x55555556, 0x66666666, x1, 24, x2)

inst_552:
// rs1_val==1431655766 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0x5554a052, 0x55555556, -0xb504, x1, 28, x2)

inst_553:
// rs1_val==1431655766 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0x55560a5a, 0x55555556, 0xb504, x1, 32, x2)

inst_554:
// rs1_val==1431655766 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x55555558, 0x55555556, 0x2, x1, 36, x2)

inst_555:
// rs1_val==1431655766 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaa, 0x55555556, 0x55555554, x1, 40, x2)

inst_556:
// rs1_val==1431655766 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x55555556, 0x55555556, 0x0, x1, 44, x2)

inst_557:
// rs1_val==1431655766 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x5555555a, 0x55555556, 0x4, x1, 48, x2)

inst_558:
// rs1_val==1431655766 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0x88888888, 0x55555556, 0x33333332, x1, 52, x2)

inst_559:
// rs1_val==1431655766 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbb, 0x55555556, 0x66666665, x1, 56, x2)

inst_560:
// rs1_val==1431655766 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0x55560a59, 0x55555556, 0xb503, x1, 60, x2)

inst_561:
// rs1_val==1431655766 and rs2_val==-1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:-0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x1, 0x55555556, -0x55555555, x1, 64, x2)

inst_562:
// rs1_val==1431655766 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x5555555c, 0x55555556, 0x6, x1, 68, x2)

inst_563:
// rs1_val==1431655766 and rs2_val==858993460, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333334
TEST_RR_OP(add, x12, x10, x11, 0x8888888a, 0x55555556, 0x33333334, x1, 72, x2)

inst_564:
// rs1_val==1431655766 and rs2_val==1717986919, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666667
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbd, 0x55555556, 0x66666667, x1, 76, x2)

inst_565:
// rs1_val==1431655766 and rs2_val==-46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:-0xb503
TEST_RR_OP(add, x12, x10, x11, 0x5554a053, 0x55555556, -0xb503, x1, 80, x2)

inst_566:
// rs1_val==1431655766 and rs2_val==46341, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb505
TEST_RR_OP(add, x12, x10, x11, 0x55560a5b, 0x55555556, 0xb505, x1, 84, x2)

inst_567:
// rs1_val==-1431655765 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaae, -0x55555555, 0x3, x1, 88, x2)

inst_568:
// rs1_val==-1431655765 and rs2_val==1431655765, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555555
TEST_RR_OP(add, x12, x10, x11, 0x0, -0x55555555, 0x55555555, x1, 92, x2)

inst_569:
// rs1_val==-1431655765 and rs2_val==-1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:-0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x55555555, -0x55555555, -0x55555556, x1, 96, x2)

inst_570:
// rs1_val==-1431655765 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaab0, -0x55555555, 0x5, x1, 100, x2)

inst_571:
// rs1_val==-1431655765 and rs2_val==858993459, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333333
TEST_RR_OP(add, x12, x10, x11, 0xddddddde, -0x55555555, 0x33333333, x1, 104, x2)

inst_572:
// rs1_val==-1431655765 and rs2_val==1717986918, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666666
TEST_RR_OP(add, x12, x10, x11, 0x11111111, -0x55555555, 0x66666666, x1, 108, x2)

inst_573:
// rs1_val==-1431655765 and rs2_val==-46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:-0xb504
TEST_RR_OP(add, x12, x10, x11, 0xaaa9f5a7, -0x55555555, -0xb504, x1, 112, x2)

inst_574:
// rs1_val==-1431655765 and rs2_val==46340, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb504
TEST_RR_OP(add, x12, x10, x11, 0xaaab5faf, -0x55555555, 0xb504, x1, 116, x2)

inst_575:
// rs1_val==-1431655765 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaad, -0x55555555, 0x2, x1, 120, x2)

inst_576:
// rs1_val==-1431655765 and rs2_val==1431655764, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555554
TEST_RR_OP(add, x12, x10, x11, 0xffffffff, -0x55555555, 0x55555554, x1, 124, x2)

inst_577:
// rs1_val==-1431655765 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab, -0x55555555, 0x0, x1, 128, x2)

inst_578:
// rs1_val==-1431655765 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaf, -0x55555555, 0x4, x1, 132, x2)

inst_579:
// rs1_val==-1431655765 and rs2_val==858993458, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333332
TEST_RR_OP(add, x12, x10, x11, 0xdddddddd, -0x55555555, 0x33333332, x1, 136, x2)

inst_580:
// rs1_val==-1431655765 and rs2_val==1717986917, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666665
TEST_RR_OP(add, x12, x10, x11, 0x11111110, -0x55555555, 0x66666665, x1, 140, x2)

inst_581:
// rs1_val==-1431655765 and rs2_val==46339, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb503
TEST_RR_OP(add, x12, x10, x11, 0xaaab5fae, -0x55555555, 0xb503, x1, 144, x2)

inst_582:
// rs1_val==-1431655765 and rs2_val==1431655766, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555556
TEST_RR_OP(add, x12, x10, x11, 0x1, -0x55555555, 0x55555556, x1, 148, x2)

inst_583:
// rs1_val > 0 and rs2_val < 0, rs2_val == -257, rs1_val == 131072
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:-0x101
TEST_RR_OP(add, x12, x10, x11, 0x1feff, 0x20000, -0x101, x1, 152, x2)

inst_584:
// rs1_val < 0 and rs2_val < 0, rs1_val == -16777217
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:-0x7
TEST_RR_OP(add, x12, x10, x11, 0xfefffff8, -0x1000001, -0x7, x1, 156, x2)

inst_585:
// rs1_val == 1, rs2_val == 8388608
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x800000
TEST_RR_OP(add, x12, x10, x11, 0x800001, 0x1, 0x800000, x1, 160, x2)

inst_586:
// rs2_val == 1024, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x400
TEST_RR_OP(add, x12, x10, x11, 0xffff4efc, -0xb504, 0x400, x1, 164, x2)

inst_587:
// rs2_val == 4096, rs1_val == 4
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x1000
TEST_RR_OP(add, x12, x10, x11, 0x1004, 0x4, 0x1000, x1, 168, x2)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x3_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x3_1:
    .fill 17*(XLEN/32),4,0xdeadbeef


signature_x8_0:
    .fill 16*(XLEN/32),4,0xdeadbeef


signature_x1_0:
    .fill 512*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 43*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
