
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:36:11 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32i.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the addi instruction of the RISC-V I extension for the addi covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",addi)

RVTEST_SIGBASE( x14,signature_x14_1)

inst_0:
// rs1 != rd, rs1==x20, rd==x7, imm_val == (-2**(12-1)), imm_val == -2048, rs1_val != imm_val, rs1_val == 536870912, rs1_val > 0 and imm_val < 0
// opcode: addi ; op1:x20; dest:x7; op1val:0x20000000;  immval:-0x800
TEST_IMM_OP( addi, x7, x20, 0x1ffff800, 0x20000000, -0x800, x14, 0, x1)

inst_1:
// rs1 == rd, rs1==x3, rd==x3, imm_val == 0, rs1_val == 1024
// opcode: addi ; op1:x3; dest:x3; op1val:0x400;  immval:0x0
TEST_IMM_OP( addi, x3, x3, 0x400, 0x400, 0x0, x14, 4, x1)

inst_2:
// rs1==x4, rd==x22, imm_val == (2**(12-1)-1), rs1_val < 0 and imm_val > 0, imm_val == 2047, rs1_val == -513
// opcode: addi ; op1:x4; dest:x22; op1val:-0x201;  immval:0x7ff
TEST_IMM_OP( addi, x22, x4, 0x5fe, -0x201, 0x7ff, x14, 8, x1)

inst_3:
// rs1==x30, rd==x11, imm_val == 1, rs1_val == 0
// opcode: addi ; op1:x30; dest:x11; op1val:0x0;  immval:0x1
TEST_IMM_OP( addi, x11, x30, 0x1, 0x0, 0x1, x14, 12, x1)

inst_4:
// rs1==x27, rd==x31, rs1_val == (-2**(xlen-1)), imm_val == 16, rs1_val == -2147483648
// opcode: addi ; op1:x27; dest:x31; op1val:-0x80000000;  immval:0x10
TEST_IMM_OP( addi, x31, x27, 0x80000010, -0x80000000, 0x10, x14, 16, x1)

inst_5:
// rs1==x17, rd==x30, rs1_val == (2**(xlen-1)-1), rs1_val > 0 and imm_val > 0, rs1_val == 2147483647
// opcode: addi ; op1:x17; dest:x30; op1val:0x7fffffff;  immval:0x6
TEST_IMM_OP( addi, x30, x17, 0x80000005, 0x7fffffff, 0x6, x14, 20, x1)

inst_6:
// rs1==x18, rd==x28, rs1_val == 1, imm_val == 4
// opcode: addi ; op1:x18; dest:x28; op1val:0x1;  immval:0x4
TEST_IMM_OP( addi, x28, x18, 0x5, 0x1, 0x4, x14, 24, x1)

inst_7:
// rs1==x13, rd==x6, rs1_val == imm_val, rs1_val==5 and imm_val==5
// opcode: addi ; op1:x13; dest:x6; op1val:0x5;  immval:0x5
TEST_IMM_OP( addi, x6, x13, 0xa, 0x5, 0x5, x14, 28, x1)

inst_8:
// rs1==x10, rd==x16, rs1_val < 0 and imm_val < 0, imm_val == -33
// opcode: addi ; op1:x10; dest:x16; op1val:-0x55555555;  immval:-0x21
TEST_IMM_OP( addi, x16, x10, 0xaaaaaa8a, -0x55555555, -0x21, x14, 32, x1)

inst_9:
// rs1==x9, rd==x21, imm_val == 2, rs1_val == -17
// opcode: addi ; op1:x9; dest:x21; op1val:-0x11;  immval:0x2
TEST_IMM_OP( addi, x21, x9, 0xfffffff1, -0x11, 0x2, x14, 36, x1)

inst_10:
// rs1==x7, rd==x2, imm_val == 8, 
// opcode: addi ; op1:x7; dest:x2; op1val:0xb505;  immval:0x8
TEST_IMM_OP( addi, x2, x7, 0xb50d, 0xb505, 0x8, x14, 40, x1)

inst_11:
// rs1==x22, rd==x18, imm_val == 32, 
// opcode: addi ; op1:x22; dest:x18; op1val:-0xb504;  immval:0x20
TEST_IMM_OP( addi, x18, x22, 0xffff4b1c, -0xb504, 0x20, x14, 44, x1)

inst_12:
// rs1==x29, rd==x0, imm_val == 64, rs1_val == -2097153
// opcode: addi ; op1:x29; dest:x0; op1val:-0x200001;  immval:0x40
TEST_IMM_OP( addi, x0, x29, 0, -0x200001, 0x40, x14, 48, x1)

inst_13:
// rs1==x25, rd==x13, imm_val == 128, 
// opcode: addi ; op1:x25; dest:x13; op1val:0x5;  immval:0x80
TEST_IMM_OP( addi, x13, x25, 0x85, 0x5, 0x80, x14, 52, x1)

inst_14:
// rs1==x11, rd==x29, imm_val == 256, rs1_val == -33554433
// opcode: addi ; op1:x11; dest:x29; op1val:-0x2000001;  immval:0x100
TEST_IMM_OP( addi, x29, x11, 0xfe0000ff, -0x2000001, 0x100, x14, 56, x1)

inst_15:
// rs1==x6, rd==x8, imm_val == 512, rs1_val == 16
// opcode: addi ; op1:x6; dest:x8; op1val:0x10;  immval:0x200
TEST_IMM_OP( addi, x8, x6, 0x210, 0x10, 0x200, x14, 60, x1)

inst_16:
// rs1==x19, rd==x4, imm_val == 1024, rs1_val == 2
// opcode: addi ; op1:x19; dest:x4; op1val:0x2;  immval:0x400
TEST_IMM_OP( addi, x4, x19, 0x402, 0x2, 0x400, x14, 64, x1)

inst_17:
// rs1==x12, rd==x10, imm_val == -2, 
// opcode: addi ; op1:x12; dest:x10; op1val:0x55555554;  immval:-0x2
TEST_IMM_OP( addi, x10, x12, 0x55555552, 0x55555554, -0x2, x14, 68, x1)

inst_18:
// rs1==x31, rd==x26, imm_val == -3, rs1_val == 1431655765
// opcode: addi ; op1:x31; dest:x26; op1val:0x55555555;  immval:-0x3
TEST_IMM_OP( addi, x26, x31, 0x55555552, 0x55555555, -0x3, x14, 72, x1)

inst_19:
// rs1==x26, rd==x15, imm_val == -5, 
// opcode: addi ; op1:x26; dest:x15; op1val:0x55555554;  immval:-0x5
TEST_IMM_OP( addi, x15, x26, 0x5555554f, 0x55555554, -0x5, x14, 76, x1)

inst_20:
// rs1==x5, rd==x19, imm_val == -9, 
// opcode: addi ; op1:x5; dest:x19; op1val:0x3;  immval:-0x9
TEST_IMM_OP( addi, x19, x5, 0xfffffffa, 0x3, -0x9, x14, 80, x1)

inst_21:
// rs1==x0, rd==x1, imm_val == -17, 
// opcode: addi ; op1:x0; dest:x1; op1val:0x0;  immval:-0x11
TEST_IMM_OP( addi, x1, x0, 0xffffffef, 0x0, -0x11, x14, 84, x4)
RVTEST_SIGBASE( x3,signature_x3_0)

inst_22:
// rs1==x24, rd==x23, imm_val == -65, rs1_val == 8388608
// opcode: addi ; op1:x24; dest:x23; op1val:0x800000;  immval:-0x41
TEST_IMM_OP( addi, x23, x24, 0x7fffbf, 0x800000, -0x41, x3, 0, x4)

inst_23:
// rs1==x15, rd==x27, imm_val == -129, 
// opcode: addi ; op1:x15; dest:x27; op1val:-0x11;  immval:-0x81
TEST_IMM_OP( addi, x27, x15, 0xffffff6e, -0x11, -0x81, x3, 4, x4)

inst_24:
// rs1==x14, rd==x17, imm_val == -257, 
// opcode: addi ; op1:x14; dest:x17; op1val:0x55555555;  immval:-0x101
TEST_IMM_OP( addi, x17, x14, 0x55555454, 0x55555555, -0x101, x3, 8, x4)

inst_25:
// rs1==x21, rd==x25, imm_val == -513, 
// opcode: addi ; op1:x21; dest:x25; op1val:0x55555556;  immval:-0x201
TEST_IMM_OP( addi, x25, x21, 0x55555355, 0x55555556, -0x201, x3, 12, x4)

inst_26:
// rs1==x1, rd==x24, imm_val == -1025, rs1_val == 8192
// opcode: addi ; op1:x1; dest:x24; op1val:0x2000;  immval:-0x401
TEST_IMM_OP( addi, x24, x1, 0x1bff, 0x2000, -0x401, x3, 16, x4)

inst_27:
// rs1==x16, rd==x12, imm_val == 1365, rs1_val==-1431655766 and imm_val==1365, rs1_val == -1431655766
// opcode: addi ; op1:x16; dest:x12; op1val:-0x55555556;  immval:0x555
TEST_IMM_OP( addi, x12, x16, 0xaaaaafff, -0x55555556, 0x555, x3, 20, x4)

inst_28:
// rs1==x2, rd==x14, imm_val == -1366, rs1_val==0 and imm_val==-1366
// opcode: addi ; op1:x2; dest:x14; op1val:0x0;  immval:-0x556
TEST_IMM_OP( addi, x14, x2, 0xfffffaaa, 0x0, -0x556, x3, 24, x4)

inst_29:
// rs1==x23, rd==x20, rs1_val == 4, rs1_val==4 and imm_val==4
// opcode: addi ; op1:x23; dest:x20; op1val:0x4;  immval:0x4
TEST_IMM_OP( addi, x20, x23, 0x8, 0x4, 0x4, x3, 28, x4)

inst_30:
// rs1==x28, rd==x5, rs1_val == 8, 
// opcode: addi ; op1:x28; dest:x5; op1val:0x8;  immval:0x10
TEST_IMM_OP( addi, x5, x28, 0x18, 0x8, 0x10, x3, 32, x4)

inst_31:
// rs1==x8, rd==x9, rs1_val == 32, 
// opcode: addi ; op1:x8; dest:x9; op1val:0x20;  immval:-0x2c
TEST_IMM_OP( addi, x9, x8, 0xfffffff4, 0x20, -0x2c, x3, 36, x4)

inst_32:
// rs1_val == 64, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x40;  immval:-0x41
TEST_IMM_OP( addi, x11, x10, 0xffffffff, 0x40, -0x41, x3, 40, x4)

inst_33:
// rs1_val == 128, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x80;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x85, 0x80, 0x5, x3, 44, x4)

inst_34:
// rs1_val == 256, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x100;  immval:-0x400
TEST_IMM_OP( addi, x11, x10, 0xfffffd00, 0x100, -0x400, x3, 48, x4)

inst_35:
// rs1_val == 512, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x200;  immval:0x100
TEST_IMM_OP( addi, x11, x10, 0x300, 0x200, 0x100, x3, 52, x4)

inst_36:
// rs1_val == 2048, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x800;  immval:-0xa
TEST_IMM_OP( addi, x11, x10, 0x7f6, 0x800, -0xa, x3, 56, x4)

inst_37:
// rs1_val == 4096, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x1000;  immval:0x40
TEST_IMM_OP( addi, x11, x10, 0x1040, 0x1000, 0x40, x3, 60, x4)

inst_38:
// rs1_val == 16384, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4000;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x4332, 0x4000, 0x332, x3, 64, x4)

inst_39:
// rs1_val == 32768, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x8000;  immval:-0x400
TEST_IMM_OP( addi, x11, x10, 0x7c00, 0x8000, -0x400, x3, 68, x4)

inst_40:
// rs1_val == 65536, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x10000;  immval:-0x101
TEST_IMM_OP( addi, x11, x10, 0xfeff, 0x10000, -0x101, x3, 72, x4)

inst_41:
// rs1_val == 131072, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x20000;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x20004, 0x20000, 0x4, x3, 76, x4)

inst_42:
// rs1_val == 262144, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x40000;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x40000, 0x40000, 0x0, x3, 80, x4)

inst_43:
// rs1_val == 524288, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x80000;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x80005, 0x80000, 0x5, x3, 84, x4)

inst_44:
// rs1_val == 1048576, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x100000;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x10002c, 0x100000, 0x2c, x3, 88, x4)

inst_45:
// rs1_val == 2097152, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x200000;  immval:-0x4
TEST_IMM_OP( addi, x11, x10, 0x1ffffc, 0x200000, -0x4, x3, 92, x4)

inst_46:
// rs1_val == 4194304, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x400000;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x40002e, 0x400000, 0x2e, x3, 96, x4)

inst_47:
// rs1_val == 16777216, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x1000000;  immval:-0x400
TEST_IMM_OP( addi, x11, x10, 0xfffc00, 0x1000000, -0x400, x3, 100, x4)

inst_48:
// rs1_val == 33554432, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2000000;  immval:-0x11
TEST_IMM_OP( addi, x11, x10, 0x1ffffef, 0x2000000, -0x11, x3, 104, x4)

inst_49:
// rs1_val == 67108864, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4000000;  immval:-0x2
TEST_IMM_OP( addi, x11, x10, 0x3fffffe, 0x4000000, -0x2, x3, 108, x4)

inst_50:
// rs1_val == 134217728, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x8000003, 0x8000000, 0x3, x3, 112, x4)

inst_51:
// rs1_val == 268435456, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x10000000;  immval:-0x81
TEST_IMM_OP( addi, x11, x10, 0xfffff7f, 0x10000000, -0x81, x3, 116, x4)

inst_52:
// rs1_val == 1073741824, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x40000000;  immval:-0x2
TEST_IMM_OP( addi, x11, x10, 0x3ffffffe, 0x40000000, -0x2, x3, 120, x4)

inst_53:
// rs1_val == -2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x2;  immval:-0x201
TEST_IMM_OP( addi, x11, x10, 0xfffffdfd, -0x2, -0x201, x3, 124, x4)

inst_54:
// rs1_val == -3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x3;  immval:-0x9
TEST_IMM_OP( addi, x11, x10, 0xfffffff4, -0x3, -0x9, x3, 128, x4)

inst_55:
// rs1_val == -5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffce, -0x5, -0x2d, x3, 132, x4)

inst_56:
// rs1_val == -9, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x9;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x32b, -0x9, 0x334, x3, 136, x4)

inst_57:
// rs1_val == -33, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x21;  immval:-0x5
TEST_IMM_OP( addi, x11, x10, 0xffffffda, -0x21, -0x5, x3, 140, x4)

inst_58:
// rs1_val == -65, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x41;  immval:-0x9
TEST_IMM_OP( addi, x11, x10, 0xffffffb6, -0x41, -0x9, x3, 144, x4)

inst_59:
// rs1_val == -129, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x81;  immval:-0x11
TEST_IMM_OP( addi, x11, x10, 0xffffff6e, -0x81, -0x11, x3, 148, x4)

inst_60:
// rs1_val == -257, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x101;  immval:0x200
TEST_IMM_OP( addi, x11, x10, 0xff, -0x101, 0x200, x3, 152, x4)

inst_61:
// rs1_val == -1025, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x401;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xfffffbd3, -0x401, -0x2c, x3, 156, x4)

inst_62:
// rs1_val == -2049, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x801;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xfffff803, -0x801, 0x4, x3, 160, x4)

inst_63:
// rs1_val == -4097, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x1001;  immval:0x8
TEST_IMM_OP( addi, x11, x10, 0xfffff007, -0x1001, 0x8, x3, 164, x4)

inst_64:
// rs1_val == -8193, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x2001;  immval:-0x201
TEST_IMM_OP( addi, x11, x10, 0xffffddfe, -0x2001, -0x201, x3, 168, x4)

inst_65:
// rs1_val == -16385, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x400
TEST_IMM_OP( addi, x11, x10, 0xffffc3ff, -0x4001, 0x400, x3, 172, x4)

inst_66:
// rs1_val == -32769, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x8001;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xffff7aa9, -0x8001, -0x556, x3, 176, x4)

inst_67:
// rs1_val == -65537, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x10001;  immval:0x7
TEST_IMM_OP( addi, x11, x10, 0xffff0006, -0x10001, 0x7, x3, 180, x4)

inst_68:
// rs1_val == -131073, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x20001;  immval:0x80
TEST_IMM_OP( addi, x11, x10, 0xfffe007f, -0x20001, 0x80, x3, 184, x4)

inst_69:
// rs1_val == -262145, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x8
TEST_IMM_OP( addi, x11, x10, 0xfffc0007, -0x40001, 0x8, x3, 188, x4)

inst_70:
// rs1_val == -524289, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x80001;  immval:-0x800
TEST_IMM_OP( addi, x11, x10, 0xfff7f7ff, -0x80001, -0x800, x3, 192, x4)

inst_71:
// rs1_val == -1048577, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x100001;  immval:-0x21
TEST_IMM_OP( addi, x11, x10, 0xffefffde, -0x100001, -0x21, x3, 196, x4)

inst_72:
// rs1_val == -4194305, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xffc00553, -0x400001, 0x554, x3, 200, x4)

inst_73:
// rs1_val == -8388609, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x800001;  immval:-0xa
TEST_IMM_OP( addi, x11, x10, 0xff7ffff5, -0x800001, -0xa, x3, 204, x4)

inst_74:
// rs1_val == -16777217, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x1000001;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xff00002b, -0x1000001, 0x2c, x3, 208, x4)

inst_75:
// rs1_val == -67108865, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xfc000005, -0x4000001, 0x6, x3, 212, x4)

inst_76:
// rs1_val == -134217729, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xf8000665, -0x8000001, 0x666, x3, 216, x4)

inst_77:
// rs1_val == -268435457, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xf000002d, -0x10000001, 0x2e, x3, 220, x4)

inst_78:
// rs1_val == -536870913, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x20000001;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xe0000002, -0x20000001, 0x3, x3, 224, x4)

inst_79:
// rs1_val == -1073741825, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xc0000665, -0x40000001, 0x666, x3, 228, x4)

inst_80:
// rs1_val==3 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x6, 0x3, 0x3, x3, 232, x4)

inst_81:
// rs1_val==3 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x558, 0x3, 0x555, x3, 236, x4)

inst_82:
// rs1_val==3 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffaad, 0x3, -0x556, x3, 240, x4)

inst_83:
// rs1_val==3 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x8, 0x3, 0x5, x3, 244, x4)

inst_84:
// rs1_val==3 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x336, 0x3, 0x333, x3, 248, x4)

inst_85:
// rs1_val==3 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x669, 0x3, 0x666, x3, 252, x4)

inst_86:
// rs1_val==3 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffd6, 0x3, -0x2d, x3, 256, x4)

inst_87:
// rs1_val==3 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x30, 0x3, 0x2d, x3, 260, x4)

inst_88:
// rs1_val==3 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x5, 0x3, 0x2, x3, 264, x4)

inst_89:
// rs1_val==3 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x557, 0x3, 0x554, x3, 268, x4)

inst_90:
// rs1_val==3 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x3, 0x3, 0x0, x3, 272, x4)

inst_91:
// rs1_val==3 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x7, 0x3, 0x4, x3, 276, x4)

inst_92:
// rs1_val==3 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x335, 0x3, 0x332, x3, 280, x4)

inst_93:
// rs1_val==3 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x668, 0x3, 0x665, x3, 284, x4)

inst_94:
// rs1_val==3 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x2f, 0x3, 0x2c, x3, 288, x4)

inst_95:
// rs1_val==3 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x559, 0x3, 0x556, x3, 292, x4)

inst_96:
// rs1_val==3 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffaae, 0x3, -0x555, x3, 296, x4)

inst_97:
// rs1_val==3 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x9, 0x3, 0x6, x3, 300, x4)

inst_98:
// rs1_val==3 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x337, 0x3, 0x334, x3, 304, x4)

inst_99:
// rs1_val==3 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66a, 0x3, 0x667, x3, 308, x4)

inst_100:
// rs1_val==3 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffd7, 0x3, -0x2c, x3, 312, x4)

inst_101:
// rs1_val==3 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x31, 0x3, 0x2e, x3, 316, x4)

inst_102:
// rs1_val==1431655765 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x55555558, 0x55555555, 0x3, x3, 320, x4)

inst_103:
// rs1_val==1431655765 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x55555aaa, 0x55555555, 0x555, x3, 324, x4)

inst_104:
// rs1_val==1431655765 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x55554fff, 0x55555555, -0x556, x3, 328, x4)

inst_105:
// rs1_val==1431655765 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x5555555a, 0x55555555, 0x5, x3, 332, x4)

inst_106:
// rs1_val==1431655765 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x55555888, 0x55555555, 0x333, x3, 336, x4)

inst_107:
// rs1_val==1431655765 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x55555bbb, 0x55555555, 0x666, x3, 340, x4)

inst_108:
// rs1_val==1431655765 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x55555528, 0x55555555, -0x2d, x3, 344, x4)

inst_109:
// rs1_val==1431655765 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x55555582, 0x55555555, 0x2d, x3, 348, x4)

inst_110:
// rs1_val==1431655765 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x55555557, 0x55555555, 0x2, x3, 352, x4)

inst_111:
// rs1_val==1431655765 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x55555aa9, 0x55555555, 0x554, x3, 356, x4)

inst_112:
// rs1_val==1431655765 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x55555555, 0x55555555, 0x0, x3, 360, x4)

inst_113:
// rs1_val==1431655765 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x55555559, 0x55555555, 0x4, x3, 364, x4)

inst_114:
// rs1_val==1431655765 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x55555887, 0x55555555, 0x332, x3, 368, x4)

inst_115:
// rs1_val==1431655765 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x55555bba, 0x55555555, 0x665, x3, 372, x4)

inst_116:
// rs1_val==1431655765 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x55555581, 0x55555555, 0x2c, x3, 376, x4)

inst_117:
// rs1_val==1431655765 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55555aab, 0x55555555, 0x556, x3, 380, x4)

inst_118:
// rs1_val==1431655765 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x55555000, 0x55555555, -0x555, x3, 384, x4)

inst_119:
// rs1_val==1431655765 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x5555555b, 0x55555555, 0x6, x3, 388, x4)

inst_120:
// rs1_val==1431655765 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x55555889, 0x55555555, 0x334, x3, 392, x4)

inst_121:
// rs1_val==1431655765 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x55555bbc, 0x55555555, 0x667, x3, 396, x4)

inst_122:
// rs1_val==1431655765 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x55555529, 0x55555555, -0x2c, x3, 400, x4)

inst_123:
// rs1_val==1431655765 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x55555583, 0x55555555, 0x2e, x3, 404, x4)

inst_124:
// rs1_val==-1431655766 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaad, -0x55555556, 0x3, x3, 408, x4)

inst_125:
// rs1_val==-1431655766 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xaaaaa554, -0x55555556, -0x556, x3, 412, x4)

inst_126:
// rs1_val==-1431655766 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaf, -0x55555556, 0x5, x3, 416, x4)

inst_127:
// rs1_val==-1431655766 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xaaaaaddd, -0x55555556, 0x333, x3, 420, x4)

inst_128:
// rs1_val==-1431655766 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xaaaab110, -0x55555556, 0x666, x3, 424, x4)

inst_129:
// rs1_val==-1431655766 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xaaaaaa7d, -0x55555556, -0x2d, x3, 428, x4)

inst_130:
// rs1_val==-1431655766 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xaaaaaad7, -0x55555556, 0x2d, x3, 432, x4)

inst_131:
// rs1_val==-1431655766 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaac, -0x55555556, 0x2, x3, 436, x4)

inst_132:
// rs1_val==-1431655766 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xaaaaaffe, -0x55555556, 0x554, x3, 440, x4)

inst_133:
// rs1_val==-1431655766 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaa, -0x55555556, 0x0, x3, 444, x4)

inst_134:
// rs1_val==-1431655766 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaae, -0x55555556, 0x4, x3, 448, x4)

inst_135:
// rs1_val==-1431655766 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xaaaaaddc, -0x55555556, 0x332, x3, 452, x4)

inst_136:
// rs1_val==-1431655766 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xaaaab10f, -0x55555556, 0x665, x3, 456, x4)

inst_137:
// rs1_val==-1431655766 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xaaaaaad6, -0x55555556, 0x2c, x3, 460, x4)

inst_138:
// rs1_val==-1431655766 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xaaaab000, -0x55555556, 0x556, x3, 464, x4)

inst_139:
// rs1_val==-1431655766 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xaaaaa555, -0x55555556, -0x555, x3, 468, x4)

inst_140:
// rs1_val==-1431655766 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xaaaaaab0, -0x55555556, 0x6, x3, 472, x4)

inst_141:
// rs1_val==-1431655766 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xaaaaadde, -0x55555556, 0x334, x3, 476, x4)

inst_142:
// rs1_val==-1431655766 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xaaaab111, -0x55555556, 0x667, x3, 480, x4)

inst_143:
// rs1_val==-1431655766 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xaaaaaa7e, -0x55555556, -0x2c, x3, 484, x4)

inst_144:
// rs1_val==-1431655766 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xaaaaaad8, -0x55555556, 0x2e, x3, 488, x4)

inst_145:
// rs1_val==5 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x8, 0x5, 0x3, x3, 492, x4)

inst_146:
// rs1_val==5 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x55a, 0x5, 0x555, x3, 496, x4)

inst_147:
// rs1_val==5 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffaaf, 0x5, -0x556, x3, 500, x4)

inst_148:
// rs1_val==5 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x338, 0x5, 0x333, x3, 504, x4)

inst_149:
// rs1_val==5 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66b, 0x5, 0x666, x3, 508, x4)

inst_150:
// rs1_val==5 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffd8, 0x5, -0x2d, x3, 512, x4)

inst_151:
// rs1_val==5 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x32, 0x5, 0x2d, x3, 516, x4)

inst_152:
// rs1_val==5 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x7, 0x5, 0x2, x3, 520, x4)

inst_153:
// rs1_val==5 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x559, 0x5, 0x554, x3, 524, x4)

inst_154:
// rs1_val==5 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x5, 0x5, 0x0, x3, 528, x4)

inst_155:
// rs1_val==5 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x9, 0x5, 0x4, x3, 532, x4)

inst_156:
// rs1_val==5 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x337, 0x5, 0x332, x3, 536, x4)

inst_157:
// rs1_val==5 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x66a, 0x5, 0x665, x3, 540, x4)

inst_158:
// rs1_val==5 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x31, 0x5, 0x2c, x3, 544, x4)

inst_159:
// rs1_val==5 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55b, 0x5, 0x556, x3, 548, x4)

inst_160:
// rs1_val==5 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffab0, 0x5, -0x555, x3, 552, x4)

inst_161:
// rs1_val==5 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xb, 0x5, 0x6, x3, 556, x4)

inst_162:
// rs1_val==5 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x339, 0x5, 0x334, x3, 560, x4)

inst_163:
// rs1_val==5 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66c, 0x5, 0x667, x3, 564, x4)

inst_164:
// rs1_val==5 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffd9, 0x5, -0x2c, x3, 568, x4)

inst_165:
// rs1_val==5 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x33, 0x5, 0x2e, x3, 572, x4)

inst_166:
// rs1_val==858993459 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x33333336, 0x33333333, 0x3, x3, 576, x4)

inst_167:
// rs1_val==858993459 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x33333888, 0x33333333, 0x555, x3, 580, x4)

inst_168:
// rs1_val==858993459 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x33332ddd, 0x33333333, -0x556, x3, 584, x4)

inst_169:
// rs1_val==858993459 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x33333338, 0x33333333, 0x5, x3, 588, x4)

inst_170:
// rs1_val==858993459 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x33333666, 0x33333333, 0x333, x3, 592, x4)

inst_171:
// rs1_val==858993459 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x33333999, 0x33333333, 0x666, x3, 596, x4)

inst_172:
// rs1_val==858993459 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x33333306, 0x33333333, -0x2d, x3, 600, x4)

inst_173:
// rs1_val==858993459 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x33333360, 0x33333333, 0x2d, x3, 604, x4)

inst_174:
// rs1_val==858993459 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x33333335, 0x33333333, 0x2, x3, 608, x4)

inst_175:
// rs1_val==858993459 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x33333887, 0x33333333, 0x554, x3, 612, x4)

inst_176:
// rs1_val==858993459 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x33333333, 0x33333333, 0x0, x3, 616, x4)

inst_177:
// rs1_val==858993459 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x33333337, 0x33333333, 0x4, x3, 620, x4)

inst_178:
// rs1_val==858993459 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x33333665, 0x33333333, 0x332, x3, 624, x4)

inst_179:
// rs1_val==858993459 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x33333998, 0x33333333, 0x665, x3, 628, x4)

inst_180:
// rs1_val==858993459 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x3333335f, 0x33333333, 0x2c, x3, 632, x4)

inst_181:
// rs1_val==858993459 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x33333889, 0x33333333, 0x556, x3, 636, x4)

inst_182:
// rs1_val==858993459 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x33332dde, 0x33333333, -0x555, x3, 640, x4)

inst_183:
// rs1_val==858993459 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x33333339, 0x33333333, 0x6, x3, 644, x4)

inst_184:
// rs1_val==858993459 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x33333667, 0x33333333, 0x334, x3, 648, x4)

inst_185:
// rs1_val==858993459 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x3333399a, 0x33333333, 0x667, x3, 652, x4)

inst_186:
// rs1_val==858993459 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x33333307, 0x33333333, -0x2c, x3, 656, x4)

inst_187:
// rs1_val==858993459 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x33333361, 0x33333333, 0x2e, x3, 660, x4)

inst_188:
// rs1_val==1717986918 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x66666669, 0x66666666, 0x3, x3, 664, x4)

inst_189:
// rs1_val==1717986918 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x66666bbb, 0x66666666, 0x555, x3, 668, x4)

inst_190:
// rs1_val==1717986918 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x66666110, 0x66666666, -0x556, x3, 672, x4)

inst_191:
// rs1_val==1717986918 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x6666666b, 0x66666666, 0x5, x3, 676, x4)

inst_192:
// rs1_val==1717986918 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x66666999, 0x66666666, 0x333, x3, 680, x4)

inst_193:
// rs1_val==1717986918 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66666ccc, 0x66666666, 0x666, x3, 684, x4)

inst_194:
// rs1_val==1717986918 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x66666639, 0x66666666, -0x2d, x3, 688, x4)

inst_195:
// rs1_val==1717986918 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x66666693, 0x66666666, 0x2d, x3, 692, x4)

inst_196:
// rs1_val==1717986918 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x66666668, 0x66666666, 0x2, x3, 696, x4)

inst_197:
// rs1_val==1717986918 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x66666bba, 0x66666666, 0x554, x3, 700, x4)

inst_198:
// rs1_val==1717986918 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x66666666, 0x66666666, 0x0, x3, 704, x4)

inst_199:
// rs1_val==1717986918 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x6666666a, 0x66666666, 0x4, x3, 708, x4)

inst_200:
// rs1_val==1717986918 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x66666998, 0x66666666, 0x332, x3, 712, x4)

inst_201:
// rs1_val==1717986918 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x66666ccb, 0x66666666, 0x665, x3, 716, x4)

inst_202:
// rs1_val==1717986918 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x66666692, 0x66666666, 0x2c, x3, 720, x4)

inst_203:
// rs1_val==1717986918 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x66666bbc, 0x66666666, 0x556, x3, 724, x4)

inst_204:
// rs1_val==1717986918 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x66666111, 0x66666666, -0x555, x3, 728, x4)

inst_205:
// rs1_val==1717986918 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x6666666c, 0x66666666, 0x6, x3, 732, x4)

inst_206:
// rs1_val==1717986918 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x6666699a, 0x66666666, 0x334, x3, 736, x4)

inst_207:
// rs1_val==1717986918 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66666ccd, 0x66666666, 0x667, x3, 740, x4)

inst_208:
// rs1_val==1717986918 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x6666663a, 0x66666666, -0x2c, x3, 744, x4)

inst_209:
// rs1_val==1717986918 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x66666694, 0x66666666, 0x2e, x3, 748, x4)

inst_210:
// rs1_val==-46340 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xffff4aff, -0xb504, 0x3, x3, 752, x4)

inst_211:
// rs1_val==-46340 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xffff5051, -0xb504, 0x555, x3, 756, x4)

inst_212:
// rs1_val==-46340 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xffff45a6, -0xb504, -0x556, x3, 760, x4)

inst_213:
// rs1_val==-46340 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xffff4b01, -0xb504, 0x5, x3, 764, x4)

inst_214:
// rs1_val==-46340 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xffff4e2f, -0xb504, 0x333, x3, 768, x4)

inst_215:
// rs1_val==-46340 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xffff5162, -0xb504, 0x666, x3, 772, x4)

inst_216:
// rs1_val==-46340 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffff4acf, -0xb504, -0x2d, x3, 776, x4)

inst_217:
// rs1_val==-46340 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xffff4b29, -0xb504, 0x2d, x3, 780, x4)

inst_218:
// rs1_val==-46340 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xffff4afe, -0xb504, 0x2, x3, 784, x4)

inst_219:
// rs1_val==-46340 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xffff5050, -0xb504, 0x554, x3, 788, x4)

inst_220:
// rs1_val==-46340 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xffff4afc, -0xb504, 0x0, x3, 792, x4)

inst_221:
// rs1_val==-46340 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xffff4b00, -0xb504, 0x4, x3, 796, x4)

inst_222:
// rs1_val==-46340 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xffff4e2e, -0xb504, 0x332, x3, 800, x4)

inst_223:
// rs1_val==-46340 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xffff5161, -0xb504, 0x665, x3, 804, x4)

inst_224:
// rs1_val==-46340 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xffff4b28, -0xb504, 0x2c, x3, 808, x4)

inst_225:
// rs1_val==-46340 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xffff5052, -0xb504, 0x556, x3, 812, x4)

inst_226:
// rs1_val==-46340 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xffff45a7, -0xb504, -0x555, x3, 816, x4)

inst_227:
// rs1_val==-46340 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xffff4b02, -0xb504, 0x6, x3, 820, x4)

inst_228:
// rs1_val==-46340 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xffff4e30, -0xb504, 0x334, x3, 824, x4)

inst_229:
// rs1_val==-46340 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xffff5163, -0xb504, 0x667, x3, 828, x4)

inst_230:
// rs1_val==-46340 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffff4ad0, -0xb504, -0x2c, x3, 832, x4)

inst_231:
// rs1_val==-46340 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xffff4b2a, -0xb504, 0x2e, x3, 836, x4)

inst_232:
// rs1_val==46340 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xb507, 0xb504, 0x3, x3, 840, x4)

inst_233:
// rs1_val==46340 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xba59, 0xb504, 0x555, x3, 844, x4)

inst_234:
// rs1_val==46340 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xafae, 0xb504, -0x556, x3, 848, x4)

inst_235:
// rs1_val==46340 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xb509, 0xb504, 0x5, x3, 852, x4)

inst_236:
// rs1_val==46340 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xb837, 0xb504, 0x333, x3, 856, x4)

inst_237:
// rs1_val==46340 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xbb6a, 0xb504, 0x666, x3, 860, x4)

inst_238:
// rs1_val==46340 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xb4d7, 0xb504, -0x2d, x3, 864, x4)

inst_239:
// rs1_val==46340 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xb531, 0xb504, 0x2d, x3, 868, x4)

inst_240:
// rs1_val==46340 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xb506, 0xb504, 0x2, x3, 872, x4)

inst_241:
// rs1_val==46340 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xba58, 0xb504, 0x554, x3, 876, x4)

inst_242:
// rs1_val==46340 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xb504, 0xb504, 0x0, x3, 880, x4)

inst_243:
// rs1_val==46340 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xb508, 0xb504, 0x4, x3, 884, x4)

inst_244:
// rs1_val==46340 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xb836, 0xb504, 0x332, x3, 888, x4)

inst_245:
// rs1_val==46340 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xbb69, 0xb504, 0x665, x3, 892, x4)

inst_246:
// rs1_val==46340 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xb530, 0xb504, 0x2c, x3, 896, x4)

inst_247:
// rs1_val==46340 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xba5a, 0xb504, 0x556, x3, 900, x4)

inst_248:
// rs1_val==46340 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xafaf, 0xb504, -0x555, x3, 904, x4)

inst_249:
// rs1_val==46340 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xb50a, 0xb504, 0x6, x3, 908, x4)

inst_250:
// rs1_val==46340 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xb838, 0xb504, 0x334, x3, 912, x4)

inst_251:
// rs1_val==46340 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xbb6b, 0xb504, 0x667, x3, 916, x4)

inst_252:
// rs1_val==46340 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xb4d8, 0xb504, -0x2c, x3, 920, x4)

inst_253:
// rs1_val==46340 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xb532, 0xb504, 0x2e, x3, 924, x4)

inst_254:
// rs1_val==2 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x5, 0x2, 0x3, x3, 928, x4)

inst_255:
// rs1_val==2 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x557, 0x2, 0x555, x3, 932, x4)

inst_256:
// rs1_val==2 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffaac, 0x2, -0x556, x3, 936, x4)

inst_257:
// rs1_val==2 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x7, 0x2, 0x5, x3, 940, x4)

inst_258:
// rs1_val==2 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x335, 0x2, 0x333, x3, 944, x4)

inst_259:
// rs1_val==2 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x668, 0x2, 0x666, x3, 948, x4)

inst_260:
// rs1_val==2 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffd5, 0x2, -0x2d, x3, 952, x4)

inst_261:
// rs1_val==2 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x2f, 0x2, 0x2d, x3, 956, x4)

inst_262:
// rs1_val==2 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x4, 0x2, 0x2, x3, 960, x4)

inst_263:
// rs1_val==2 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x556, 0x2, 0x554, x3, 964, x4)

inst_264:
// rs1_val==2 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x2, 0x2, 0x0, x3, 968, x4)

inst_265:
// rs1_val==2 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x6, 0x2, 0x4, x3, 972, x4)

inst_266:
// rs1_val==2 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x334, 0x2, 0x332, x3, 976, x4)

inst_267:
// rs1_val==2 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x667, 0x2, 0x665, x3, 980, x4)

inst_268:
// rs1_val==2 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x2e, 0x2, 0x2c, x3, 984, x4)

inst_269:
// rs1_val==2 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x558, 0x2, 0x556, x3, 988, x4)

inst_270:
// rs1_val==2 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffaad, 0x2, -0x555, x3, 992, x4)

inst_271:
// rs1_val==2 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x8, 0x2, 0x6, x3, 996, x4)

inst_272:
// rs1_val==2 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x336, 0x2, 0x334, x3, 1000, x4)

inst_273:
// rs1_val==2 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x669, 0x2, 0x667, x3, 1004, x4)

inst_274:
// rs1_val==2 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffd6, 0x2, -0x2c, x3, 1008, x4)

inst_275:
// rs1_val==2 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x30, 0x2, 0x2e, x3, 1012, x4)

inst_276:
// rs1_val==1431655764 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x55555557, 0x55555554, 0x3, x3, 1016, x4)

inst_277:
// rs1_val==1431655764 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x55555aa9, 0x55555554, 0x555, x3, 1020, x4)

inst_278:
// rs1_val==1431655764 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x55554ffe, 0x55555554, -0x556, x3, 1024, x4)

inst_279:
// rs1_val==1431655764 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x55555559, 0x55555554, 0x5, x3, 1028, x4)

inst_280:
// rs1_val==1431655764 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x55555887, 0x55555554, 0x333, x3, 1032, x4)

inst_281:
// rs1_val==1431655764 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x55555bba, 0x55555554, 0x666, x3, 1036, x4)

inst_282:
// rs1_val==1431655764 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x55555527, 0x55555554, -0x2d, x3, 1040, x4)

inst_283:
// rs1_val==1431655764 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x55555581, 0x55555554, 0x2d, x3, 1044, x4)

inst_284:
// rs1_val==1431655764 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x55555556, 0x55555554, 0x2, x3, 1048, x4)

inst_285:
// rs1_val==1431655764 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x55555aa8, 0x55555554, 0x554, x3, 1052, x4)

inst_286:
// rs1_val==1431655764 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x55555554, 0x55555554, 0x0, x3, 1056, x4)

inst_287:
// rs1_val==1431655764 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x55555558, 0x55555554, 0x4, x3, 1060, x4)

inst_288:
// rs1_val==1431655764 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x55555886, 0x55555554, 0x332, x3, 1064, x4)

inst_289:
// rs1_val==1431655764 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x55555bb9, 0x55555554, 0x665, x3, 1068, x4)

inst_290:
// rs1_val==1431655764 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x55555580, 0x55555554, 0x2c, x3, 1072, x4)

inst_291:
// rs1_val==1431655764 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55555aaa, 0x55555554, 0x556, x3, 1076, x4)

inst_292:
// rs1_val==1431655764 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x55554fff, 0x55555554, -0x555, x3, 1080, x4)

inst_293:
// rs1_val==1431655764 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x5555555a, 0x55555554, 0x6, x3, 1084, x4)

inst_294:
// rs1_val==1431655764 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x55555888, 0x55555554, 0x334, x3, 1088, x4)

inst_295:
// rs1_val==1431655764 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x55555bbb, 0x55555554, 0x667, x3, 1092, x4)

inst_296:
// rs1_val==1431655764 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x55555528, 0x55555554, -0x2c, x3, 1096, x4)

inst_297:
// rs1_val==1431655764 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x55555582, 0x55555554, 0x2e, x3, 1100, x4)

inst_298:
// rs1_val==0 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x3, 0x0, 0x3, x3, 1104, x4)

inst_299:
// rs1_val==0 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x555, 0x0, 0x555, x3, 1108, x4)

inst_300:
// rs1_val==0 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x5, 0x0, 0x5, x3, 1112, x4)

inst_301:
// rs1_val==0 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x333, 0x0, 0x333, x3, 1116, x4)

inst_302:
// rs1_val==0 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x666, 0x0, 0x666, x3, 1120, x4)

inst_303:
// rs1_val==0 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffd3, 0x0, -0x2d, x3, 1124, x4)

inst_304:
// rs1_val==0 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x2d, 0x0, 0x2d, x3, 1128, x4)

inst_305:
// rs1_val==858993460 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x33333666, 0x33333334, 0x332, x3, 1132, x4)

inst_306:
// rs1_val==858993460 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x33333999, 0x33333334, 0x665, x3, 1136, x4)

inst_307:
// rs1_val==858993460 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x33333360, 0x33333334, 0x2c, x3, 1140, x4)

inst_308:
// rs1_val==858993460 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x3333388a, 0x33333334, 0x556, x3, 1144, x4)

inst_309:
// rs1_val==858993460 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x33332ddf, 0x33333334, -0x555, x3, 1148, x4)

inst_310:
// rs1_val==858993460 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x3333333a, 0x33333334, 0x6, x3, 1152, x4)

inst_311:
// rs1_val==858993460 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x33333668, 0x33333334, 0x334, x3, 1156, x4)

inst_312:
// rs1_val==858993460 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x3333399b, 0x33333334, 0x667, x3, 1160, x4)

inst_313:
// rs1_val==858993460 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x33333308, 0x33333334, -0x2c, x3, 1164, x4)

inst_314:
// rs1_val==858993460 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x33333362, 0x33333334, 0x2e, x3, 1168, x4)

inst_315:
// rs1_val==1717986919 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x6666666a, 0x66666667, 0x3, x3, 1172, x4)

inst_316:
// rs1_val==1717986919 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x66666bbc, 0x66666667, 0x555, x3, 1176, x4)

inst_317:
// rs1_val==1717986919 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x66666111, 0x66666667, -0x556, x3, 1180, x4)

inst_318:
// rs1_val==1717986919 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x6666666c, 0x66666667, 0x5, x3, 1184, x4)

inst_319:
// rs1_val==1717986919 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x6666699a, 0x66666667, 0x333, x3, 1188, x4)

inst_320:
// rs1_val==1717986919 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66666ccd, 0x66666667, 0x666, x3, 1192, x4)

inst_321:
// rs1_val==1717986919 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x6666663a, 0x66666667, -0x2d, x3, 1196, x4)

inst_322:
// rs1_val==1717986919 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x66666694, 0x66666667, 0x2d, x3, 1200, x4)

inst_323:
// rs1_val==1717986919 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x66666669, 0x66666667, 0x2, x3, 1204, x4)

inst_324:
// rs1_val==1717986919 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x66666bbb, 0x66666667, 0x554, x3, 1208, x4)

inst_325:
// rs1_val==1717986919 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x66666667, 0x66666667, 0x0, x3, 1212, x4)

inst_326:
// rs1_val==1717986919 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x6666666b, 0x66666667, 0x4, x3, 1216, x4)

inst_327:
// rs1_val==1717986919 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x66666999, 0x66666667, 0x332, x3, 1220, x4)

inst_328:
// rs1_val==1717986919 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x66666ccc, 0x66666667, 0x665, x3, 1224, x4)

inst_329:
// rs1_val==1717986919 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x66666693, 0x66666667, 0x2c, x3, 1228, x4)

inst_330:
// rs1_val==1717986919 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x66666bbd, 0x66666667, 0x556, x3, 1232, x4)

inst_331:
// rs1_val==1717986919 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x66666112, 0x66666667, -0x555, x3, 1236, x4)

inst_332:
// rs1_val==1717986919 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x6666666d, 0x66666667, 0x6, x3, 1240, x4)

inst_333:
// rs1_val==1717986919 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x6666699b, 0x66666667, 0x334, x3, 1244, x4)

inst_334:
// rs1_val==1717986919 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66666cce, 0x66666667, 0x667, x3, 1248, x4)

inst_335:
// rs1_val==1717986919 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x6666663b, 0x66666667, -0x2c, x3, 1252, x4)

inst_336:
// rs1_val==1717986919 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x66666695, 0x66666667, 0x2e, x3, 1256, x4)

inst_337:
// rs1_val==-46339 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xffff4b00, -0xb503, 0x3, x3, 1260, x4)

inst_338:
// rs1_val==-46339 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xffff5052, -0xb503, 0x555, x3, 1264, x4)

inst_339:
// rs1_val==-46339 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xffff45a7, -0xb503, -0x556, x3, 1268, x4)

inst_340:
// rs1_val==-46339 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xffff4b02, -0xb503, 0x5, x3, 1272, x4)

inst_341:
// rs1_val==-46339 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xffff4e30, -0xb503, 0x333, x3, 1276, x4)

inst_342:
// rs1_val==-46339 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xffff5163, -0xb503, 0x666, x3, 1280, x4)

inst_343:
// rs1_val==-46339 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffff4ad0, -0xb503, -0x2d, x3, 1284, x4)

inst_344:
// rs1_val==-46339 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xffff4b2a, -0xb503, 0x2d, x3, 1288, x4)

inst_345:
// rs1_val==-46339 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xffff4aff, -0xb503, 0x2, x3, 1292, x4)

inst_346:
// rs1_val==-46339 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xffff5051, -0xb503, 0x554, x3, 1296, x4)

inst_347:
// rs1_val==-46339 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xffff4afd, -0xb503, 0x0, x3, 1300, x4)

inst_348:
// rs1_val==-46339 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xffff4b01, -0xb503, 0x4, x3, 1304, x4)

inst_349:
// rs1_val==-46339 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xffff4e2f, -0xb503, 0x332, x3, 1308, x4)

inst_350:
// rs1_val==-46339 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xffff5162, -0xb503, 0x665, x3, 1312, x4)

inst_351:
// rs1_val==-46339 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xffff4b29, -0xb503, 0x2c, x3, 1316, x4)

inst_352:
// rs1_val==-46339 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xffff5053, -0xb503, 0x556, x3, 1320, x4)

inst_353:
// rs1_val==-46339 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xffff45a8, -0xb503, -0x555, x3, 1324, x4)

inst_354:
// rs1_val==-46339 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xffff4b03, -0xb503, 0x6, x3, 1328, x4)

inst_355:
// rs1_val==-46339 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xffff4e31, -0xb503, 0x334, x3, 1332, x4)

inst_356:
// rs1_val==-46339 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xffff5164, -0xb503, 0x667, x3, 1336, x4)

inst_357:
// rs1_val==-46339 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffff4ad1, -0xb503, -0x2c, x3, 1340, x4)

inst_358:
// rs1_val==-46339 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xffff4b2b, -0xb503, 0x2e, x3, 1344, x4)

inst_359:
// rs1_val==46341 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xb508, 0xb505, 0x3, x3, 1348, x4)

inst_360:
// rs1_val==46341 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xba5a, 0xb505, 0x555, x3, 1352, x4)

inst_361:
// rs1_val==46341 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xafaf, 0xb505, -0x556, x3, 1356, x4)

inst_362:
// rs1_val==46341 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xb50a, 0xb505, 0x5, x3, 1360, x4)

inst_363:
// rs1_val==46341 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xb838, 0xb505, 0x333, x3, 1364, x4)

inst_364:
// rs1_val==46341 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xbb6b, 0xb505, 0x666, x3, 1368, x4)

inst_365:
// rs1_val==46341 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xb4d8, 0xb505, -0x2d, x3, 1372, x4)

inst_366:
// rs1_val==46341 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xb532, 0xb505, 0x2d, x3, 1376, x4)

inst_367:
// rs1_val==46341 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xb507, 0xb505, 0x2, x3, 1380, x4)

inst_368:
// rs1_val==46341 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xba59, 0xb505, 0x554, x3, 1384, x4)

inst_369:
// rs1_val==46341 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xb505, 0xb505, 0x0, x3, 1388, x4)

inst_370:
// rs1_val==46341 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xb509, 0xb505, 0x4, x3, 1392, x4)

inst_371:
// rs1_val==46341 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xb837, 0xb505, 0x332, x3, 1396, x4)

inst_372:
// rs1_val==46341 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xbb6a, 0xb505, 0x665, x3, 1400, x4)

inst_373:
// rs1_val==46341 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xb531, 0xb505, 0x2c, x3, 1404, x4)

inst_374:
// rs1_val==46341 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xba5b, 0xb505, 0x556, x3, 1408, x4)

inst_375:
// rs1_val==46341 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xafb0, 0xb505, -0x555, x3, 1412, x4)

inst_376:
// rs1_val==46341 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xb50b, 0xb505, 0x6, x3, 1416, x4)

inst_377:
// rs1_val==46341 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xb839, 0xb505, 0x334, x3, 1420, x4)

inst_378:
// rs1_val==46341 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xbb6c, 0xb505, 0x667, x3, 1424, x4)

inst_379:
// rs1_val==46341 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xb4d9, 0xb505, -0x2c, x3, 1428, x4)

inst_380:
// rs1_val==46341 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xb533, 0xb505, 0x2e, x3, 1432, x4)

inst_381:
// rs1_val==0 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x2, 0x0, 0x2, x3, 1436, x4)

inst_382:
// rs1_val==0 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x554, 0x0, 0x554, x3, 1440, x4)

inst_383:
// rs1_val==0 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x0, 0x0, 0x0, x3, 1444, x4)

inst_384:
// rs1_val==0 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x4, 0x0, 0x4, x3, 1448, x4)

inst_385:
// rs1_val==0 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x332, 0x0, 0x332, x3, 1452, x4)

inst_386:
// rs1_val==0 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x665, 0x0, 0x665, x3, 1456, x4)

inst_387:
// rs1_val==0 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x2c, 0x0, 0x2c, x3, 1460, x4)

inst_388:
// rs1_val==0 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x556, 0x0, 0x556, x3, 1464, x4)

inst_389:
// rs1_val==0 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffaab, 0x0, -0x555, x3, 1468, x4)

inst_390:
// rs1_val==0 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x6, 0x0, 0x6, x3, 1472, x4)

inst_391:
// rs1_val==0 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x334, 0x0, 0x334, x3, 1476, x4)

inst_392:
// rs1_val==0 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x667, 0x0, 0x667, x3, 1480, x4)

inst_393:
// rs1_val==0 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffd4, 0x0, -0x2c, x3, 1484, x4)

inst_394:
// rs1_val==0 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x2e, 0x0, 0x2e, x3, 1488, x4)

inst_395:
// rs1_val==4 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x7, 0x4, 0x3, x3, 1492, x4)

inst_396:
// rs1_val==4 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x559, 0x4, 0x555, x3, 1496, x4)

inst_397:
// rs1_val==4 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffaae, 0x4, -0x556, x3, 1500, x4)

inst_398:
// rs1_val==4 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x9, 0x4, 0x5, x3, 1504, x4)

inst_399:
// rs1_val==4 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x337, 0x4, 0x333, x3, 1508, x4)

inst_400:
// rs1_val==4 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66a, 0x4, 0x666, x3, 1512, x4)

inst_401:
// rs1_val==4 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffd7, 0x4, -0x2d, x3, 1516, x4)

inst_402:
// rs1_val==4 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x31, 0x4, 0x2d, x3, 1520, x4)

inst_403:
// rs1_val==4 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x6, 0x4, 0x2, x3, 1524, x4)

inst_404:
// rs1_val==4 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x558, 0x4, 0x554, x3, 1528, x4)

inst_405:
// rs1_val==4 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x4, 0x4, 0x0, x3, 1532, x4)

inst_406:
// rs1_val==4 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x336, 0x4, 0x332, x3, 1536, x4)

inst_407:
// rs1_val==4 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x669, 0x4, 0x665, x3, 1540, x4)

inst_408:
// rs1_val==4 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x30, 0x4, 0x2c, x3, 1544, x4)

inst_409:
// rs1_val==4 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55a, 0x4, 0x556, x3, 1548, x4)

inst_410:
// rs1_val==4 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffaaf, 0x4, -0x555, x3, 1552, x4)

inst_411:
// rs1_val==4 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xa, 0x4, 0x6, x3, 1556, x4)

inst_412:
// rs1_val==4 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x338, 0x4, 0x334, x3, 1560, x4)

inst_413:
// rs1_val==4 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66b, 0x4, 0x667, x3, 1564, x4)

inst_414:
// rs1_val==4 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffd8, 0x4, -0x2c, x3, 1568, x4)

inst_415:
// rs1_val==4 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x32, 0x4, 0x2e, x3, 1572, x4)

inst_416:
// rs1_val==858993458 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x33333335, 0x33333332, 0x3, x3, 1576, x4)

inst_417:
// rs1_val==858993458 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x33333887, 0x33333332, 0x555, x3, 1580, x4)

inst_418:
// rs1_val==858993458 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x33332ddc, 0x33333332, -0x556, x3, 1584, x4)

inst_419:
// rs1_val==858993458 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x33333337, 0x33333332, 0x5, x3, 1588, x4)

inst_420:
// rs1_val==858993458 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x33333665, 0x33333332, 0x333, x3, 1592, x4)

inst_421:
// rs1_val==858993458 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x33333998, 0x33333332, 0x666, x3, 1596, x4)

inst_422:
// rs1_val==858993458 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x33333305, 0x33333332, -0x2d, x3, 1600, x4)

inst_423:
// rs1_val==858993458 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x3333335f, 0x33333332, 0x2d, x3, 1604, x4)

inst_424:
// rs1_val==858993458 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x33333334, 0x33333332, 0x2, x3, 1608, x4)

inst_425:
// rs1_val==858993458 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x33333886, 0x33333332, 0x554, x3, 1612, x4)

inst_426:
// rs1_val==858993458 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x33333332, 0x33333332, 0x0, x3, 1616, x4)

inst_427:
// rs1_val==858993458 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x33333336, 0x33333332, 0x4, x3, 1620, x4)

inst_428:
// rs1_val==858993458 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x33333664, 0x33333332, 0x332, x3, 1624, x4)

inst_429:
// rs1_val==858993458 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x33333997, 0x33333332, 0x665, x3, 1628, x4)

inst_430:
// rs1_val==858993458 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x3333335e, 0x33333332, 0x2c, x3, 1632, x4)

inst_431:
// rs1_val==858993458 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x33333888, 0x33333332, 0x556, x3, 1636, x4)

inst_432:
// rs1_val==858993458 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x33332ddd, 0x33333332, -0x555, x3, 1640, x4)

inst_433:
// rs1_val==858993458 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x33333338, 0x33333332, 0x6, x3, 1644, x4)

inst_434:
// rs1_val==858993458 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x33333666, 0x33333332, 0x334, x3, 1648, x4)

inst_435:
// rs1_val==858993458 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x33333999, 0x33333332, 0x667, x3, 1652, x4)

inst_436:
// rs1_val==858993458 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x33333306, 0x33333332, -0x2c, x3, 1656, x4)

inst_437:
// rs1_val==858993458 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x33333360, 0x33333332, 0x2e, x3, 1660, x4)

inst_438:
// rs1_val==1717986917 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x66666668, 0x66666665, 0x3, x3, 1664, x4)

inst_439:
// rs1_val==1717986917 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x66666bba, 0x66666665, 0x555, x3, 1668, x4)

inst_440:
// rs1_val==1717986917 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x6666610f, 0x66666665, -0x556, x3, 1672, x4)

inst_441:
// rs1_val==1717986917 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x6666666a, 0x66666665, 0x5, x3, 1676, x4)

inst_442:
// rs1_val==1717986917 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x66666998, 0x66666665, 0x333, x3, 1680, x4)

inst_443:
// rs1_val==1717986917 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66666ccb, 0x66666665, 0x666, x3, 1684, x4)

inst_444:
// rs1_val==1717986917 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x66666638, 0x66666665, -0x2d, x3, 1688, x4)

inst_445:
// rs1_val==1717986917 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x66666692, 0x66666665, 0x2d, x3, 1692, x4)

inst_446:
// rs1_val==1717986917 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x66666667, 0x66666665, 0x2, x3, 1696, x4)

inst_447:
// rs1_val==1717986917 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x66666bb9, 0x66666665, 0x554, x3, 1700, x4)

inst_448:
// rs1_val==1717986917 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x66666665, 0x66666665, 0x0, x3, 1704, x4)

inst_449:
// rs1_val==1717986917 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x66666669, 0x66666665, 0x4, x3, 1708, x4)

inst_450:
// rs1_val==1717986917 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x66666997, 0x66666665, 0x332, x3, 1712, x4)

inst_451:
// rs1_val==1717986917 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x66666cca, 0x66666665, 0x665, x3, 1716, x4)

inst_452:
// rs1_val==1717986917 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x66666691, 0x66666665, 0x2c, x3, 1720, x4)

inst_453:
// rs1_val==1717986917 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x66666bbb, 0x66666665, 0x556, x3, 1724, x4)

inst_454:
// rs1_val==1717986917 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x66666110, 0x66666665, -0x555, x3, 1728, x4)

inst_455:
// rs1_val==1717986917 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x6666666b, 0x66666665, 0x6, x3, 1732, x4)

inst_456:
// rs1_val==1717986917 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x66666999, 0x66666665, 0x334, x3, 1736, x4)

inst_457:
// rs1_val==1717986917 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66666ccc, 0x66666665, 0x667, x3, 1740, x4)

inst_458:
// rs1_val==1717986917 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x66666639, 0x66666665, -0x2c, x3, 1744, x4)

inst_459:
// rs1_val==1717986917 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x66666693, 0x66666665, 0x2e, x3, 1748, x4)

inst_460:
// rs1_val==46339 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xb506, 0xb503, 0x3, x3, 1752, x4)

inst_461:
// rs1_val==46339 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xba58, 0xb503, 0x555, x3, 1756, x4)

inst_462:
// rs1_val==46339 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xafad, 0xb503, -0x556, x3, 1760, x4)

inst_463:
// rs1_val==46339 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xb508, 0xb503, 0x5, x3, 1764, x4)

inst_464:
// rs1_val==46339 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xb836, 0xb503, 0x333, x3, 1768, x4)

inst_465:
// rs1_val==46339 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xbb69, 0xb503, 0x666, x3, 1772, x4)

inst_466:
// rs1_val==46339 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xb4d6, 0xb503, -0x2d, x3, 1776, x4)

inst_467:
// rs1_val==46339 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xb530, 0xb503, 0x2d, x3, 1780, x4)

inst_468:
// rs1_val==46339 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xb505, 0xb503, 0x2, x3, 1784, x4)

inst_469:
// rs1_val==46339 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xba57, 0xb503, 0x554, x3, 1788, x4)

inst_470:
// rs1_val==46339 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xb503, 0xb503, 0x0, x3, 1792, x4)

inst_471:
// rs1_val==46339 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xb507, 0xb503, 0x4, x3, 1796, x4)

inst_472:
// rs1_val==46339 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xb835, 0xb503, 0x332, x3, 1800, x4)

inst_473:
// rs1_val==46339 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xbb68, 0xb503, 0x665, x3, 1804, x4)

inst_474:
// rs1_val==46339 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xb52f, 0xb503, 0x2c, x3, 1808, x4)

inst_475:
// rs1_val==46339 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xba59, 0xb503, 0x556, x3, 1812, x4)

inst_476:
// rs1_val==46339 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xafae, 0xb503, -0x555, x3, 1816, x4)

inst_477:
// rs1_val==46339 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xb509, 0xb503, 0x6, x3, 1820, x4)

inst_478:
// rs1_val==46339 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xb837, 0xb503, 0x334, x3, 1824, x4)

inst_479:
// rs1_val==46339 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xbb6a, 0xb503, 0x667, x3, 1828, x4)

inst_480:
// rs1_val==46339 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xb4d7, 0xb503, -0x2c, x3, 1832, x4)

inst_481:
// rs1_val==46339 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xb531, 0xb503, 0x2e, x3, 1836, x4)

inst_482:
// rs1_val==1431655766 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x55555559, 0x55555556, 0x3, x3, 1840, x4)

inst_483:
// rs1_val==1431655766 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x55555aab, 0x55555556, 0x555, x3, 1844, x4)

inst_484:
// rs1_val==1431655766 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x55555000, 0x55555556, -0x556, x3, 1848, x4)

inst_485:
// rs1_val==1431655766 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x5555555b, 0x55555556, 0x5, x3, 1852, x4)

inst_486:
// rs1_val==1431655766 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x55555889, 0x55555556, 0x333, x3, 1856, x4)

inst_487:
// rs1_val==1431655766 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x55555bbc, 0x55555556, 0x666, x3, 1860, x4)

inst_488:
// rs1_val==1431655766 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x55555529, 0x55555556, -0x2d, x3, 1864, x4)

inst_489:
// rs1_val==1431655766 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x55555583, 0x55555556, 0x2d, x3, 1868, x4)

inst_490:
// rs1_val==1431655766 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x55555558, 0x55555556, 0x2, x3, 1872, x4)

inst_491:
// rs1_val==1431655766 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x55555aaa, 0x55555556, 0x554, x3, 1876, x4)

inst_492:
// rs1_val==1431655766 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x55555556, 0x55555556, 0x0, x3, 1880, x4)

inst_493:
// rs1_val==1431655766 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x5555555a, 0x55555556, 0x4, x3, 1884, x4)

inst_494:
// rs1_val==1431655766 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x55555888, 0x55555556, 0x332, x3, 1888, x4)

inst_495:
// rs1_val==1431655766 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x55555bbb, 0x55555556, 0x665, x3, 1892, x4)

inst_496:
// rs1_val==1431655766 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x55555582, 0x55555556, 0x2c, x3, 1896, x4)

inst_497:
// rs1_val==1431655766 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55555aac, 0x55555556, 0x556, x3, 1900, x4)

inst_498:
// rs1_val==1431655766 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x55555001, 0x55555556, -0x555, x3, 1904, x4)

inst_499:
// rs1_val==1431655766 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x5555555c, 0x55555556, 0x6, x3, 1908, x4)

inst_500:
// rs1_val==1431655766 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x5555588a, 0x55555556, 0x334, x3, 1912, x4)

inst_501:
// rs1_val==1431655766 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x55555bbd, 0x55555556, 0x667, x3, 1916, x4)

inst_502:
// rs1_val==1431655766 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x5555552a, 0x55555556, -0x2c, x3, 1920, x4)

inst_503:
// rs1_val==1431655766 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x55555584, 0x55555556, 0x2e, x3, 1924, x4)

inst_504:
// rs1_val==-1431655765 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaae, -0x55555555, 0x3, x3, 1928, x4)

inst_505:
// rs1_val==-1431655765 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xaaaab000, -0x55555555, 0x555, x3, 1932, x4)

inst_506:
// rs1_val==-1431655765 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xaaaaa555, -0x55555555, -0x556, x3, 1936, x4)

inst_507:
// rs1_val==-1431655765 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xaaaaaab0, -0x55555555, 0x5, x3, 1940, x4)

inst_508:
// rs1_val==-1431655765 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xaaaaadde, -0x55555555, 0x333, x3, 1944, x4)

inst_509:
// rs1_val==-1431655765 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xaaaab111, -0x55555555, 0x666, x3, 1948, x4)

inst_510:
// rs1_val==-1431655765 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xaaaaaa7e, -0x55555555, -0x2d, x3, 1952, x4)

inst_511:
// rs1_val==-1431655765 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xaaaaaad8, -0x55555555, 0x2d, x3, 1956, x4)

inst_512:
// rs1_val==-1431655765 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaad, -0x55555555, 0x2, x3, 1960, x4)

inst_513:
// rs1_val==-1431655765 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xaaaaafff, -0x55555555, 0x554, x3, 1964, x4)

inst_514:
// rs1_val==-1431655765 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaab, -0x55555555, 0x0, x3, 1968, x4)

inst_515:
// rs1_val==-1431655765 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaf, -0x55555555, 0x4, x3, 1972, x4)

inst_516:
// rs1_val==-1431655765 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xaaaaaddd, -0x55555555, 0x332, x3, 1976, x4)

inst_517:
// rs1_val==-1431655765 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xaaaab110, -0x55555555, 0x665, x3, 1980, x4)

inst_518:
// rs1_val==-1431655765 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xaaaaaad7, -0x55555555, 0x2c, x3, 1984, x4)

inst_519:
// rs1_val==-1431655765 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xaaaab001, -0x55555555, 0x556, x3, 1988, x4)

inst_520:
// rs1_val==-1431655765 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xaaaaa556, -0x55555555, -0x555, x3, 1992, x4)

inst_521:
// rs1_val==-1431655765 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xaaaaaab1, -0x55555555, 0x6, x3, 1996, x4)

inst_522:
// rs1_val==-1431655765 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xaaaaaddf, -0x55555555, 0x334, x3, 2000, x4)

inst_523:
// rs1_val==-1431655765 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xaaaab112, -0x55555555, 0x667, x3, 2004, x4)

inst_524:
// rs1_val==-1431655765 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xaaaaaa7f, -0x55555555, -0x2c, x3, 2008, x4)

inst_525:
// rs1_val==-1431655765 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xaaaaaad9, -0x55555555, 0x2e, x3, 2012, x4)

inst_526:
// rs1_val==6 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x9, 0x6, 0x3, x3, 2016, x4)

inst_527:
// rs1_val==6 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x55b, 0x6, 0x555, x3, 2020, x4)

inst_528:
// rs1_val==6 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffab0, 0x6, -0x556, x3, 2024, x4)

inst_529:
// rs1_val==6 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xb, 0x6, 0x5, x3, 2028, x4)

inst_530:
// rs1_val==6 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x339, 0x6, 0x333, x3, 2032, x4)

inst_531:
// rs1_val==6 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66c, 0x6, 0x666, x3, 2036, x4)

inst_532:
// rs1_val==6 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffd9, 0x6, -0x2d, x3, 2040, x4)

inst_533:
// rs1_val==6 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x33, 0x6, 0x2d, x3, 2044, x4)
RVTEST_SIGBASE( x3,signature_x3_1)

inst_534:
// rs1_val==6 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x8, 0x6, 0x2, x3, 0, x4)

inst_535:
// rs1_val==6 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x55a, 0x6, 0x554, x3, 4, x4)

inst_536:
// rs1_val==6 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x6, 0x6, 0x0, x3, 8, x4)

inst_537:
// rs1_val==6 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xa, 0x6, 0x4, x3, 12, x4)

inst_538:
// rs1_val==6 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x338, 0x6, 0x332, x3, 16, x4)

inst_539:
// rs1_val==6 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x66b, 0x6, 0x665, x3, 20, x4)

inst_540:
// rs1_val==6 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x32, 0x6, 0x2c, x3, 24, x4)

inst_541:
// rs1_val==6 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55c, 0x6, 0x556, x3, 28, x4)

inst_542:
// rs1_val==6 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffab1, 0x6, -0x555, x3, 32, x4)

inst_543:
// rs1_val==6 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xc, 0x6, 0x6, x3, 36, x4)

inst_544:
// rs1_val==6 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x33a, 0x6, 0x334, x3, 40, x4)

inst_545:
// rs1_val==6 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66d, 0x6, 0x667, x3, 44, x4)

inst_546:
// rs1_val==6 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffda, 0x6, -0x2c, x3, 48, x4)

inst_547:
// rs1_val==6 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x34, 0x6, 0x2e, x3, 52, x4)

inst_548:
// rs1_val==858993460 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x33333337, 0x33333334, 0x3, x3, 56, x4)

inst_549:
// rs1_val==858993460 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x33333889, 0x33333334, 0x555, x3, 60, x4)

inst_550:
// rs1_val==858993460 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x33332dde, 0x33333334, -0x556, x3, 64, x4)

inst_551:
// rs1_val==858993460 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x33333339, 0x33333334, 0x5, x3, 68, x4)

inst_552:
// rs1_val==858993460 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x33333667, 0x33333334, 0x333, x3, 72, x4)

inst_553:
// rs1_val==858993460 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x3333399a, 0x33333334, 0x666, x3, 76, x4)

inst_554:
// rs1_val==858993460 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x33333307, 0x33333334, -0x2d, x3, 80, x4)

inst_555:
// rs1_val==858993460 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x33333361, 0x33333334, 0x2d, x3, 84, x4)

inst_556:
// rs1_val==858993460 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x33333336, 0x33333334, 0x2, x3, 88, x4)

inst_557:
// rs1_val==858993460 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x33333888, 0x33333334, 0x554, x3, 92, x4)

inst_558:
// rs1_val==858993460 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x33333334, 0x33333334, 0x0, x3, 96, x4)

inst_559:
// rs1_val==858993460 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x33333338, 0x33333334, 0x4, x3, 100, x4)

inst_560:
// imm_val == 64, rs1_val == -2097153
// opcode: addi ; op1:x10; dest:x11; op1val:-0x200001;  immval:0x40
TEST_IMM_OP( addi, x11, x10, 0xffe0003f, -0x200001, 0x40, x3, 104, x4)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x14_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x14_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x3_0:
    .fill 512*(XLEN/32),4,0xdeadbeef


signature_x3_1:
    .fill 27*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
