
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:36:11 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32i.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the andi instruction of the RISC-V I extension for the andi covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",andi)

RVTEST_SIGBASE( x18,signature_x18_1)

inst_0:
// rs1 != rd, rs1==x22, rd==x10, imm_val == (-2**(12-1)), imm_val == -2048, rs1_val != imm_val, rs1_val < 0 and imm_val < 0, rs1_val == -2
// opcode: andi ; op1:x22; dest:x10; op1val:-0x2;  immval:-0x800
TEST_IMM_OP( andi, x10, x22, 0xfffff800, -0x2, -0x800, x18, 0, x24)

inst_1:
// rs1 == rd, rs1==x25, rd==x25, imm_val == 0, rs1_val == -4097
// opcode: andi ; op1:x25; dest:x25; op1val:-0x1001;  immval:0x0
TEST_IMM_OP( andi, x25, x25, 0x0, -0x1001, 0x0, x18, 4, x24)

inst_2:
// rs1==x16, rd==x17, imm_val == (2**(12-1)-1), rs1_val < 0 and imm_val > 0, imm_val == 2047, rs1_val == -33554433
// opcode: andi ; op1:x16; dest:x17; op1val:-0x2000001;  immval:0x7ff
TEST_IMM_OP( andi, x17, x16, 0x7ff, -0x2000001, 0x7ff, x18, 8, x24)

inst_3:
// rs1==x2, rd==x8, imm_val == 1, rs1_val == -131073
// opcode: andi ; op1:x2; dest:x8; op1val:-0x20001;  immval:0x1
TEST_IMM_OP( andi, x8, x2, 0x1, -0x20001, 0x1, x18, 12, x24)

inst_4:
// rs1==x28, rd==x30, rs1_val == (-2**(xlen-1)), rs1_val == -2147483648, imm_val == 4
// opcode: andi ; op1:x28; dest:x30; op1val:-0x80000000;  immval:0x4
TEST_IMM_OP( andi, x30, x28, 0x0, -0x80000000, 0x4, x18, 16, x24)

inst_5:
// rs1==x4, rd==x19, rs1_val == 0, 
// opcode: andi ; op1:x4; dest:x19; op1val:0x0;  immval:-0x800
TEST_IMM_OP( andi, x19, x4, 0x0, 0x0, -0x800, x18, 20, x24)

inst_6:
// rs1==x10, rd==x2, rs1_val == (2**(xlen-1)-1), rs1_val > 0 and imm_val > 0, rs1_val == 2147483647
// opcode: andi ; op1:x10; dest:x2; op1val:0x7fffffff;  immval:0x6
TEST_IMM_OP( andi, x2, x10, 0x6, 0x7fffffff, 0x6, x18, 24, x24)

inst_7:
// rs1==x7, rd==x13, rs1_val == 1, 
// opcode: andi ; op1:x7; dest:x13; op1val:0x1;  immval:0x554
TEST_IMM_OP( andi, x13, x7, 0x0, 0x1, 0x554, x18, 28, x24)

inst_8:
// rs1==x27, rd==x9, rs1_val == imm_val, imm_val == 128, rs1_val == 128
// opcode: andi ; op1:x27; dest:x9; op1val:0x80;  immval:0x80
TEST_IMM_OP( andi, x9, x27, 0x80, 0x80, 0x80, x18, 32, x24)

inst_9:
// rs1==x17, rd==x3, rs1_val > 0 and imm_val < 0, 
// opcode: andi ; op1:x17; dest:x3; op1val:0x7fffffff;  immval:-0x2c
TEST_IMM_OP( andi, x3, x17, 0x7fffffd4, 0x7fffffff, -0x2c, x18, 36, x24)

inst_10:
// rs1==x0, rd==x26, imm_val == 2, rs1_val == 16777216
// opcode: andi ; op1:x0; dest:x26; op1val:0x0;  immval:0x2
TEST_IMM_OP( andi, x26, x0, 0x0, 0x0, 0x2, x18, 40, x24)

inst_11:
// rs1==x23, rd==x21, imm_val == 8, 
// opcode: andi ; op1:x23; dest:x21; op1val:0x66666666;  immval:0x8
TEST_IMM_OP( andi, x21, x23, 0x0, 0x66666666, 0x8, x18, 44, x24)

inst_12:
// rs1==x6, rd==x14, imm_val == 16, 
// opcode: andi ; op1:x6; dest:x14; op1val:0x0;  immval:0x10
TEST_IMM_OP( andi, x14, x6, 0x0, 0x0, 0x10, x18, 48, x24)

inst_13:
// rs1==x5, rd==x22, imm_val == 32, rs1_val == 256
// opcode: andi ; op1:x5; dest:x22; op1val:0x100;  immval:0x20
TEST_IMM_OP( andi, x22, x5, 0x0, 0x100, 0x20, x18, 52, x24)

inst_14:
// rs1==x8, rd==x29, imm_val == 64, rs1_val == -5
// opcode: andi ; op1:x8; dest:x29; op1val:-0x5;  immval:0x40
TEST_IMM_OP( andi, x29, x8, 0x40, -0x5, 0x40, x18, 56, x24)

inst_15:
// rs1==x12, rd==x23, imm_val == 256, 
// opcode: andi ; op1:x12; dest:x23; op1val:0x1;  immval:0x100
TEST_IMM_OP( andi, x23, x12, 0x0, 0x1, 0x100, x18, 60, x24)

inst_16:
// rs1==x15, rd==x6, imm_val == 512, 
// opcode: andi ; op1:x15; dest:x6; op1val:-0x55555555;  immval:0x200
TEST_IMM_OP( andi, x6, x15, 0x200, -0x55555555, 0x200, x18, 64, x24)

inst_17:
// rs1==x29, rd==x11, imm_val == 1024, 
// opcode: andi ; op1:x29; dest:x11; op1val:0x0;  immval:0x400
TEST_IMM_OP( andi, x11, x29, 0x0, 0x0, 0x400, x18, 68, x24)

inst_18:
// rs1==x20, rd==x1, imm_val == -2, 
// opcode: andi ; op1:x20; dest:x1; op1val:0x66666667;  immval:-0x2
TEST_IMM_OP( andi, x1, x20, 0x66666666, 0x66666667, -0x2, x18, 72, x24)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_19:
// rs1==x31, rd==x5, imm_val == -3, rs1_val == -1048577
// opcode: andi ; op1:x31; dest:x5; op1val:-0x100001;  immval:-0x3
TEST_IMM_OP( andi, x5, x31, 0xffeffffd, -0x100001, -0x3, x2, 0, x6)

inst_20:
// rs1==x3, rd==x20, imm_val == -5, rs1_val == 512
// opcode: andi ; op1:x3; dest:x20; op1val:0x200;  immval:-0x5
TEST_IMM_OP( andi, x20, x3, 0x200, 0x200, -0x5, x2, 4, x6)

inst_21:
// rs1==x9, rd==x7, imm_val == -9, rs1_val == 16384
// opcode: andi ; op1:x9; dest:x7; op1val:0x4000;  immval:-0x9
TEST_IMM_OP( andi, x7, x9, 0x4000, 0x4000, -0x9, x2, 8, x6)

inst_22:
// rs1==x13, rd==x16, imm_val == -17, rs1_val == 2097152
// opcode: andi ; op1:x13; dest:x16; op1val:0x200000;  immval:-0x11
TEST_IMM_OP( andi, x16, x13, 0x200000, 0x200000, -0x11, x2, 12, x6)

inst_23:
// rs1==x18, rd==x24, imm_val == -33, rs1_val == -3
// opcode: andi ; op1:x18; dest:x24; op1val:-0x3;  immval:-0x21
TEST_IMM_OP( andi, x24, x18, 0xffffffdd, -0x3, -0x21, x2, 16, x6)

inst_24:
// rs1==x26, rd==x4, imm_val == -65, 
// opcode: andi ; op1:x26; dest:x4; op1val:-0x6;  immval:-0x41
TEST_IMM_OP( andi, x4, x26, 0xffffffba, -0x6, -0x41, x2, 20, x6)

inst_25:
// rs1==x30, rd==x28, imm_val == -129, rs1_val == 64
// opcode: andi ; op1:x30; dest:x28; op1val:0x40;  immval:-0x81
TEST_IMM_OP( andi, x28, x30, 0x40, 0x40, -0x81, x2, 24, x6)

inst_26:
// rs1==x19, rd==x0, imm_val == -257, 
// opcode: andi ; op1:x19; dest:x0; op1val:-0xb504;  immval:-0x101
TEST_IMM_OP( andi, x0, x19, 0, -0xb504, -0x101, x2, 28, x6)

inst_27:
// rs1==x21, rd==x18, imm_val == -513, rs1_val == -32769
// opcode: andi ; op1:x21; dest:x18; op1val:-0x8001;  immval:-0x201
TEST_IMM_OP( andi, x18, x21, 0xffff7dff, -0x8001, -0x201, x2, 32, x6)

inst_28:
// rs1==x1, rd==x12, imm_val == -1025, 
// opcode: andi ; op1:x1; dest:x12; op1val:0x40;  immval:-0x401
TEST_IMM_OP( andi, x12, x1, 0x40, 0x40, -0x401, x2, 36, x6)

inst_29:
// rs1==x24, rd==x27, imm_val == 1365, rs1_val == -16385
// opcode: andi ; op1:x24; dest:x27; op1val:-0x4001;  immval:0x555
TEST_IMM_OP( andi, x27, x24, 0x555, -0x4001, 0x555, x2, 40, x6)

inst_30:
// rs1==x11, rd==x31, imm_val == -1366, rs1_val == 1073741824
// opcode: andi ; op1:x11; dest:x31; op1val:0x40000000;  immval:-0x556
TEST_IMM_OP( andi, x31, x11, 0x40000000, 0x40000000, -0x556, x2, 44, x6)

inst_31:
// rs1==x14, rd==x15, rs1_val == 2, 
// opcode: andi ; op1:x14; dest:x15; op1val:0x2;  immval:0x8
TEST_IMM_OP( andi, x15, x14, 0x0, 0x2, 0x8, x2, 48, x6)

inst_32:
// rs1_val == 4, rs1_val==4 and imm_val==1639
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x667, x2, 52, x6)

inst_33:
// rs1_val == 8, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x8;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x0, 0x8, 0x334, x2, 56, x6)

inst_34:
// rs1_val == 16, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x10;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x0, 0x10, 0x2e, x2, 60, x6)

inst_35:
// rs1_val == 32, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x20;  immval:0x10
TEST_IMM_OP( andi, x11, x10, 0x0, 0x20, 0x10, x2, 64, x6)

inst_36:
// rs1_val == 1024, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x400;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x400, 0x400, -0x2c, x2, 68, x6)

inst_37:
// rs1_val == 2048, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x800;  immval:-0x41
TEST_IMM_OP( andi, x11, x10, 0x800, 0x800, -0x41, x2, 72, x6)

inst_38:
// rs1_val == 4096, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x1000;  immval:0x40
TEST_IMM_OP( andi, x11, x10, 0x0, 0x1000, 0x40, x2, 76, x6)

inst_39:
// rs1_val == 8192, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2000;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x2000, 0x2000, -0x2d, x2, 80, x6)

inst_40:
// rs1_val == 32768, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x8000;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x8000, 0x8000, -0x556, x2, 84, x6)

inst_41:
// rs1_val == 65536, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x10000;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x0, 0x10000, 0x333, x2, 88, x6)

inst_42:
// rs1_val == 131072, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x20000;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x0, 0x20000, 0x332, x2, 92, x6)

inst_43:
// rs1_val == 262144, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x40000;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x40000, 0x556, x2, 96, x6)

inst_44:
// rs1_val == 524288, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x80000;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x80000, 0x4, x2, 100, x6)

inst_45:
// rs1_val == 1048576, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x100000;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0x100000, 0x5, x2, 104, x6)

inst_46:
// rs1_val == 4194304, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x400000;  immval:-0x1
TEST_IMM_OP( andi, x11, x10, 0x400000, 0x400000, -0x1, x2, 108, x6)

inst_47:
// rs1_val == 8388608, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x800000;  immval:-0x6
TEST_IMM_OP( andi, x11, x10, 0x800000, 0x800000, -0x6, x2, 112, x6)

inst_48:
// rs1_val == 33554432, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2000000;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x2000000, 0x2000000, -0x2c, x2, 116, x6)

inst_49:
// rs1_val == 67108864, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4000000;  immval:-0x81
TEST_IMM_OP( andi, x11, x10, 0x4000000, 0x4000000, -0x81, x2, 120, x6)

inst_50:
// rs1_val == 134217728, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x8000000, 0x0, x2, 124, x6)

inst_51:
// rs1_val == 268435456, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x10000000, 0x0, x2, 128, x6)

inst_52:
// rs1_val == 536870912, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x20000000, 0x4, x2, 132, x6)

inst_53:
// rs1_val == -9, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x9;  immval:-0x3
TEST_IMM_OP( andi, x11, x10, 0xfffffff5, -0x9, -0x3, x2, 136, x6)

inst_54:
// rs1_val == -17, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x11;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x546, -0x11, 0x556, x2, 140, x6)

inst_55:
// rs1_val == -33, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x21;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, -0x21, 0x4, x2, 144, x6)

inst_56:
// rs1_val == -65, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x41;  immval:0x9
TEST_IMM_OP( andi, x11, x10, 0x9, -0x41, 0x9, x2, 148, x6)

inst_57:
// rs1_val == -129, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x81;  immval:-0x3
TEST_IMM_OP( andi, x11, x10, 0xffffff7d, -0x81, -0x3, x2, 152, x6)

inst_58:
// rs1_val == -257, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x101;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x234, -0x101, 0x334, x2, 156, x6)

inst_59:
// rs1_val == -513, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x201;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x201, 0x0, x2, 160, x6)

inst_60:
// rs1_val == -1025, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x401;  immval:0x40
TEST_IMM_OP( andi, x11, x10, 0x40, -0x401, 0x40, x2, 164, x6)

inst_61:
// rs1_val == -2049, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x801;  immval:0x9
TEST_IMM_OP( andi, x11, x10, 0x9, -0x801, 0x9, x2, 168, x6)

inst_62:
// rs1_val == -8193, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x2001;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x667, -0x2001, 0x667, x2, 172, x6)

inst_63:
// rs1_val == -65537, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x10001;  immval:0x7ff
TEST_IMM_OP( andi, x11, x10, 0x7ff, -0x10001, 0x7ff, x2, 176, x6)

inst_64:
// rs1_val == -262145, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x40001;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xfffbffd3, -0x40001, -0x2d, x2, 180, x6)

inst_65:
// rs1_val == -524289, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x80001;  immval:0x200
TEST_IMM_OP( andi, x11, x10, 0x200, -0x80001, 0x200, x2, 184, x6)

inst_66:
// rs1_val == -2097153, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x200001;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xffdfffd4, -0x200001, -0x2c, x2, 188, x6)

inst_67:
// rs1_val == -4194305, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, -0x400001, 0x5, x2, 192, x6)

inst_68:
// rs1_val == -8388609, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x800001;  immval:0x7
TEST_IMM_OP( andi, x11, x10, 0x7, -0x800001, 0x7, x2, 196, x6)

inst_69:
// rs1_val == -16777217, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x1000001;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, -0x1000001, 0x6, x2, 200, x6)

inst_70:
// rs1_val == -67108865, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x8
TEST_IMM_OP( andi, x11, x10, 0x8, -0x4000001, 0x8, x2, 204, x6)

inst_71:
// rs1_val == -134217729, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2e, -0x8000001, 0x2e, x2, 208, x6)

inst_72:
// rs1_val == -268435457, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0x1
TEST_IMM_OP( andi, x11, x10, 0x1, -0x10000001, 0x1, x2, 212, x6)

inst_73:
// rs1_val == -536870913, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x20000001;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xdfffffd4, -0x20000001, -0x2c, x2, 216, x6)

inst_74:
// rs1_val == -1073741825, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x556, -0x40000001, 0x556, x2, 220, x6)

inst_75:
// rs1_val == 1431655765, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x5
TEST_IMM_OP( andi, x11, x10, 0x55555551, 0x55555555, -0x5, x2, 224, x6)

inst_76:
// rs1_val == -1431655766, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x80
TEST_IMM_OP( andi, x11, x10, 0x80, -0x55555556, 0x80, x2, 228, x6)

inst_77:
// rs1_val==3 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, 0x3, x2, 232, x6)

inst_78:
// rs1_val==3 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3, 0x555, x2, 236, x6)

inst_79:
// rs1_val==3 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, -0x556, x2, 240, x6)

inst_80:
// rs1_val==3 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3, 0x5, x2, 244, x6)

inst_81:
// rs1_val==3 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, 0x333, x2, 248, x6)

inst_82:
// rs1_val==3 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x666, x2, 252, x6)

inst_83:
// rs1_val==3 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, -0x2d, x2, 256, x6)

inst_84:
// rs1_val==3 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3, 0x2d, x2, 260, x6)

inst_85:
// rs1_val==3 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x2, x2, 264, x6)

inst_86:
// rs1_val==3 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x554, x2, 268, x6)

inst_87:
// rs1_val==3 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x0, x2, 272, x6)

inst_88:
// rs1_val==3 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x4, x2, 276, x6)

inst_89:
// rs1_val==3 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x332, x2, 280, x6)

inst_90:
// rs1_val==3 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3, 0x665, x2, 284, x6)

inst_91:
// rs1_val==3 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x2c, x2, 288, x6)

inst_92:
// rs1_val==3 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x556, x2, 292, x6)

inst_93:
// rs1_val==3 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, -0x555, x2, 296, x6)

inst_94:
// rs1_val==3 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x6, x2, 300, x6)

inst_95:
// rs1_val==3 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x334, x2, 304, x6)

inst_96:
// rs1_val==3 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, 0x667, x2, 308, x6)

inst_97:
// rs1_val==3 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, -0x2c, x2, 312, x6)

inst_98:
// rs1_val==3 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x2e, x2, 316, x6)

inst_99:
// rs1_val==1431655765 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, 0x55555555, 0x3, x2, 320, x6)

inst_100:
// rs1_val==1431655765 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x555, 0x55555555, 0x555, x2, 324, x6)

inst_101:
// rs1_val==1431655765 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x55555000, 0x55555555, -0x556, x2, 328, x6)

inst_102:
// rs1_val==1431655765 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0x55555555, 0x5, x2, 332, x6)

inst_103:
// rs1_val==1431655765 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x111, 0x55555555, 0x333, x2, 336, x6)

inst_104:
// rs1_val==1431655765 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x444, 0x55555555, 0x666, x2, 340, x6)

inst_105:
// rs1_val==1431655765 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x55555551, 0x55555555, -0x2d, x2, 344, x6)

inst_106:
// rs1_val==1431655765 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x5, 0x55555555, 0x2d, x2, 348, x6)

inst_107:
// rs1_val==1431655765 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x55555555, 0x2, x2, 352, x6)

inst_108:
// rs1_val==1431655765 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x554, 0x55555555, 0x554, x2, 356, x6)

inst_109:
// rs1_val==1431655765 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x55555555, 0x0, x2, 360, x6)

inst_110:
// rs1_val==1431655765 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555555, 0x4, x2, 364, x6)

inst_111:
// rs1_val==1431655765 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x110, 0x55555555, 0x332, x2, 368, x6)

inst_112:
// rs1_val==1431655765 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x445, 0x55555555, 0x665, x2, 372, x6)

inst_113:
// rs1_val==1431655765 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555555, 0x2c, x2, 376, x6)

inst_114:
// rs1_val==1431655765 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x554, 0x55555555, 0x556, x2, 380, x6)

inst_115:
// rs1_val==1431655765 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x55555001, 0x55555555, -0x555, x2, 384, x6)

inst_116:
// rs1_val==1431655765 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555555, 0x6, x2, 388, x6)

inst_117:
// rs1_val==1431655765 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x114, 0x55555555, 0x334, x2, 392, x6)

inst_118:
// rs1_val==1431655765 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x445, 0x55555555, 0x667, x2, 396, x6)

inst_119:
// rs1_val==1431655765 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x55555554, 0x55555555, -0x2c, x2, 400, x6)

inst_120:
// rs1_val==1431655765 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555555, 0x2e, x2, 404, x6)

inst_121:
// rs1_val==-1431655766 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, -0x55555556, 0x3, x2, 408, x6)

inst_122:
// rs1_val==-1431655766 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, -0x55555556, 0x555, x2, 412, x6)

inst_123:
// rs1_val==-1431655766 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaa, -0x55555556, -0x556, x2, 416, x6)

inst_124:
// rs1_val==-1431655766 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, -0x55555556, 0x5, x2, 420, x6)

inst_125:
// rs1_val==-1431655766 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x222, -0x55555556, 0x333, x2, 424, x6)

inst_126:
// rs1_val==-1431655766 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, -0x55555556, 0x666, x2, 428, x6)

inst_127:
// rs1_val==-1431655766 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xaaaaaa82, -0x55555556, -0x2d, x2, 432, x6)

inst_128:
// rs1_val==-1431655766 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x28, -0x55555556, 0x2d, x2, 436, x6)

inst_129:
// rs1_val==-1431655766 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, -0x55555556, 0x2, x2, 440, x6)

inst_130:
// rs1_val==-1431655766 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, -0x55555556, 0x554, x2, 444, x6)

inst_131:
// rs1_val==-1431655766 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x55555556, 0x0, x2, 448, x6)

inst_132:
// rs1_val==-1431655766 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, -0x55555556, 0x4, x2, 452, x6)

inst_133:
// rs1_val==-1431655766 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x222, -0x55555556, 0x332, x2, 456, x6)

inst_134:
// rs1_val==-1431655766 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x220, -0x55555556, 0x665, x2, 460, x6)

inst_135:
// rs1_val==-1431655766 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x28, -0x55555556, 0x2c, x2, 464, x6)

inst_136:
// rs1_val==-1431655766 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x2, -0x55555556, 0x556, x2, 468, x6)

inst_137:
// rs1_val==-1431655766 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaa, -0x55555556, -0x555, x2, 472, x6)

inst_138:
// rs1_val==-1431655766 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, -0x55555556, 0x6, x2, 476, x6)

inst_139:
// rs1_val==-1431655766 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x220, -0x55555556, 0x334, x2, 480, x6)

inst_140:
// rs1_val==-1431655766 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x222, -0x55555556, 0x667, x2, 484, x6)

inst_141:
// rs1_val==-1431655766 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xaaaaaa80, -0x55555556, -0x2c, x2, 488, x6)

inst_142:
// rs1_val==-1431655766 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2a, -0x55555556, 0x2e, x2, 492, x6)

inst_143:
// rs1_val==5 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5, 0x3, x2, 496, x6)

inst_144:
// rs1_val==5 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x555, x2, 500, x6)

inst_145:
// rs1_val==5 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5, -0x556, x2, 504, x6)

inst_146:
// rs1_val==5 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x5, x2, 508, x6)

inst_147:
// rs1_val==5 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5, 0x333, x2, 512, x6)

inst_148:
// rs1_val==5 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x666, x2, 516, x6)

inst_149:
// rs1_val==5 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5, -0x2d, x2, 520, x6)

inst_150:
// rs1_val==5 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x2d, x2, 524, x6)

inst_151:
// rs1_val==5 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5, 0x2, x2, 528, x6)

inst_152:
// rs1_val==5 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x554, x2, 532, x6)

inst_153:
// rs1_val==5 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5, 0x0, x2, 536, x6)

inst_154:
// rs1_val==5 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x4, x2, 540, x6)

inst_155:
// rs1_val==5 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5, 0x332, x2, 544, x6)

inst_156:
// rs1_val==5 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x665, x2, 548, x6)

inst_157:
// rs1_val==5 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x2c, x2, 552, x6)

inst_158:
// rs1_val==5 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x556, x2, 556, x6)

inst_159:
// rs1_val==5 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5, -0x555, x2, 560, x6)

inst_160:
// rs1_val==5 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x6, x2, 564, x6)

inst_161:
// rs1_val==5 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x334, x2, 568, x6)

inst_162:
// rs1_val==5 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x667, x2, 572, x6)

inst_163:
// rs1_val==5 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, -0x2c, x2, 576, x6)

inst_164:
// rs1_val==5 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x2e, x2, 580, x6)

inst_165:
// rs1_val==858993459 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, 0x33333333, 0x3, x2, 584, x6)

inst_166:
// rs1_val==858993459 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x111, 0x33333333, 0x555, x2, 588, x6)

inst_167:
// rs1_val==858993459 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x33333222, 0x33333333, -0x556, x2, 592, x6)

inst_168:
// rs1_val==858993459 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x1, 0x33333333, 0x5, x2, 596, x6)

inst_169:
// rs1_val==858993459 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x333, 0x33333333, 0x333, x2, 600, x6)

inst_170:
// rs1_val==858993459 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, 0x33333333, 0x666, x2, 604, x6)

inst_171:
// rs1_val==858993459 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x33333313, 0x33333333, -0x2d, x2, 608, x6)

inst_172:
// rs1_val==858993459 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x21, 0x33333333, 0x2d, x2, 612, x6)

inst_173:
// rs1_val==858993459 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x33333333, 0x2, x2, 616, x6)

inst_174:
// rs1_val==858993459 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x110, 0x33333333, 0x554, x2, 620, x6)

inst_175:
// rs1_val==858993459 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x33333333, 0x0, x2, 624, x6)

inst_176:
// rs1_val==858993459 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x33333333, 0x4, x2, 628, x6)

inst_177:
// rs1_val==858993459 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x332, 0x33333333, 0x332, x2, 632, x6)

inst_178:
// rs1_val==858993459 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x221, 0x33333333, 0x665, x2, 636, x6)

inst_179:
// rs1_val==858993459 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x20, 0x33333333, 0x2c, x2, 640, x6)

inst_180:
// rs1_val==858993459 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x112, 0x33333333, 0x556, x2, 644, x6)

inst_181:
// rs1_val==858993459 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x33333223, 0x33333333, -0x555, x2, 648, x6)

inst_182:
// rs1_val==858993459 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0x33333333, 0x6, x2, 652, x6)

inst_183:
// rs1_val==858993459 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x330, 0x33333333, 0x334, x2, 656, x6)

inst_184:
// rs1_val==858993459 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x223, 0x33333333, 0x667, x2, 660, x6)

inst_185:
// rs1_val==858993459 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x33333310, 0x33333333, -0x2c, x2, 664, x6)

inst_186:
// rs1_val==858993459 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x22, 0x33333333, 0x2e, x2, 668, x6)

inst_187:
// rs1_val==1717986918 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x66666666, 0x3, x2, 672, x6)

inst_188:
// rs1_val==1717986918 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x444, 0x66666666, 0x555, x2, 676, x6)

inst_189:
// rs1_val==1717986918 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x66666222, 0x66666666, -0x556, x2, 680, x6)

inst_190:
// rs1_val==1717986918 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x66666666, 0x5, x2, 684, x6)

inst_191:
// rs1_val==1717986918 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x222, 0x66666666, 0x333, x2, 688, x6)

inst_192:
// rs1_val==1717986918 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x666, 0x66666666, 0x666, x2, 692, x6)

inst_193:
// rs1_val==1717986918 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x66666642, 0x66666666, -0x2d, x2, 696, x6)

inst_194:
// rs1_val==1717986918 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x24, 0x66666666, 0x2d, x2, 700, x6)

inst_195:
// rs1_val==1717986918 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x66666666, 0x2, x2, 704, x6)

inst_196:
// rs1_val==1717986918 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x444, 0x66666666, 0x554, x2, 708, x6)

inst_197:
// rs1_val==1717986918 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x66666666, 0x0, x2, 712, x6)

inst_198:
// rs1_val==1717986918 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x66666666, 0x4, x2, 716, x6)

inst_199:
// rs1_val==1717986918 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x222, 0x66666666, 0x332, x2, 720, x6)

inst_200:
// rs1_val==1717986918 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x664, 0x66666666, 0x665, x2, 724, x6)

inst_201:
// rs1_val==1717986918 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0x66666666, 0x2c, x2, 728, x6)

inst_202:
// rs1_val==1717986918 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x446, 0x66666666, 0x556, x2, 732, x6)

inst_203:
// rs1_val==1717986918 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x66666222, 0x66666666, -0x555, x2, 736, x6)

inst_204:
// rs1_val==1717986918 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, 0x66666666, 0x6, x2, 740, x6)

inst_205:
// rs1_val==1717986918 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x224, 0x66666666, 0x334, x2, 744, x6)

inst_206:
// rs1_val==1717986918 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x666, 0x66666666, 0x667, x2, 748, x6)

inst_207:
// rs1_val==1717986918 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x66666644, 0x66666666, -0x2c, x2, 752, x6)

inst_208:
// rs1_val==1717986918 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x26, 0x66666666, 0x2e, x2, 756, x6)

inst_209:
// rs1_val==-46340 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb504, 0x3, x2, 760, x6)

inst_210:
// rs1_val==-46340 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x54, -0xb504, 0x555, x2, 764, x6)

inst_211:
// rs1_val==-46340 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xffff4aa8, -0xb504, -0x556, x2, 768, x6)

inst_212:
// rs1_val==-46340 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504, 0x5, x2, 772, x6)

inst_213:
// rs1_val==-46340 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x230, -0xb504, 0x333, x2, 776, x6)

inst_214:
// rs1_val==-46340 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x264, -0xb504, 0x666, x2, 780, x6)

inst_215:
// rs1_val==-46340 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xffff4ad0, -0xb504, -0x2d, x2, 784, x6)

inst_216:
// rs1_val==-46340 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x2c, -0xb504, 0x2d, x2, 788, x6)

inst_217:
// rs1_val==-46340 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb504, 0x2, x2, 792, x6)

inst_218:
// rs1_val==-46340 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x54, -0xb504, 0x554, x2, 796, x6)

inst_219:
// rs1_val==-46340 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb504, 0x0, x2, 800, x6)

inst_220:
// rs1_val==-46340 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504, 0x4, x2, 804, x6)

inst_221:
// rs1_val==-46340 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x230, -0xb504, 0x332, x2, 808, x6)

inst_222:
// rs1_val==-46340 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x264, -0xb504, 0x665, x2, 812, x6)

inst_223:
// rs1_val==-46340 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x2c, -0xb504, 0x2c, x2, 816, x6)

inst_224:
// rs1_val==-46340 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x54, -0xb504, 0x556, x2, 820, x6)

inst_225:
// rs1_val==-46340 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xffff4aa8, -0xb504, -0x555, x2, 824, x6)

inst_226:
// rs1_val==-46340 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504, 0x6, x2, 828, x6)

inst_227:
// rs1_val==-46340 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x234, -0xb504, 0x334, x2, 832, x6)

inst_228:
// rs1_val==-46340 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x264, -0xb504, 0x667, x2, 836, x6)

inst_229:
// rs1_val==-46340 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xffff4ad4, -0xb504, -0x2c, x2, 840, x6)

inst_230:
// rs1_val==-46340 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2c, -0xb504, 0x2e, x2, 844, x6)

inst_231:
// rs1_val==46340 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504, 0x3, x2, 848, x6)

inst_232:
// rs1_val==46340 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x504, 0xb504, 0x555, x2, 852, x6)

inst_233:
// rs1_val==46340 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xb000, 0xb504, -0x556, x2, 856, x6)

inst_234:
// rs1_val==46340 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504, 0x5, x2, 860, x6)

inst_235:
// rs1_val==46340 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x100, 0xb504, 0x333, x2, 864, x6)

inst_236:
// rs1_val==46340 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x404, 0xb504, 0x666, x2, 868, x6)

inst_237:
// rs1_val==46340 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xb500, 0xb504, -0x2d, x2, 872, x6)

inst_238:
// rs1_val==46340 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504, 0x2d, x2, 876, x6)

inst_239:
// rs1_val==46340 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504, 0x2, x2, 880, x6)

inst_240:
// rs1_val==46340 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x504, 0xb504, 0x554, x2, 884, x6)

inst_241:
// rs1_val==46340 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504, 0x0, x2, 888, x6)

inst_242:
// rs1_val==46340 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504, 0x4, x2, 892, x6)

inst_243:
// rs1_val==46340 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x100, 0xb504, 0x332, x2, 896, x6)

inst_244:
// rs1_val==46340 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x404, 0xb504, 0x665, x2, 900, x6)

inst_245:
// rs1_val==46340 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504, 0x2c, x2, 904, x6)

inst_246:
// rs1_val==46340 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x504, 0xb504, 0x556, x2, 908, x6)

inst_247:
// rs1_val==46340 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xb000, 0xb504, -0x555, x2, 912, x6)

inst_248:
// rs1_val==46340 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504, 0x6, x2, 916, x6)

inst_249:
// rs1_val==46340 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x104, 0xb504, 0x334, x2, 920, x6)

inst_250:
// rs1_val==46340 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x404, 0xb504, 0x667, x2, 924, x6)

inst_251:
// rs1_val==46340 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xb504, 0xb504, -0x2c, x2, 928, x6)

inst_252:
// rs1_val==46340 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504, 0x2e, x2, 932, x6)

inst_253:
// rs1_val==2 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x3, x2, 936, x6)

inst_254:
// rs1_val==2 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x555, x2, 940, x6)

inst_255:
// rs1_val==2 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, -0x556, x2, 944, x6)

inst_256:
// rs1_val==2 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x5, x2, 948, x6)

inst_257:
// rs1_val==2 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x333, x2, 952, x6)

inst_258:
// rs1_val==2 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x666, x2, 956, x6)

inst_259:
// rs1_val==2 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, -0x2d, x2, 960, x6)

inst_260:
// rs1_val==2 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x2d, x2, 964, x6)

inst_261:
// rs1_val==2 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x2, x2, 968, x6)

inst_262:
// rs1_val==2 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x554, x2, 972, x6)

inst_263:
// rs1_val==2 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x0, x2, 976, x6)

inst_264:
// rs1_val==2 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x4, x2, 980, x6)

inst_265:
// rs1_val==2 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x332, x2, 984, x6)

inst_266:
// rs1_val==2 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x665, x2, 988, x6)

inst_267:
// rs1_val==2 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x2c, x2, 992, x6)

inst_268:
// rs1_val==2 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x556, x2, 996, x6)

inst_269:
// rs1_val==2 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, -0x555, x2, 1000, x6)

inst_270:
// rs1_val==2 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x6, x2, 1004, x6)

inst_271:
// rs1_val==2 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x334, x2, 1008, x6)

inst_272:
// rs1_val==2 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x667, x2, 1012, x6)

inst_273:
// rs1_val==2 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, -0x2c, x2, 1016, x6)

inst_274:
// rs1_val==2 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x2e, x2, 1020, x6)

inst_275:
// rs1_val==1431655764 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x55555554, 0x3, x2, 1024, x6)

inst_276:
// rs1_val==1431655764 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x554, 0x55555554, 0x555, x2, 1028, x6)

inst_277:
// rs1_val==1431655764 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x55555000, 0x55555554, -0x556, x2, 1032, x6)

inst_278:
// rs1_val==1431655764 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555554, 0x5, x2, 1036, x6)

inst_279:
// rs1_val==1431655764 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x110, 0x55555554, 0x333, x2, 1040, x6)

inst_280:
// rs1_val==1431655764 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x444, 0x55555554, 0x666, x2, 1044, x6)

inst_281:
// rs1_val==1431655764 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x55555550, 0x55555554, -0x2d, x2, 1048, x6)

inst_282:
// rs1_val==1431655764 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555554, 0x2d, x2, 1052, x6)

inst_283:
// rs1_val==1431655764 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x55555554, 0x2, x2, 1056, x6)

inst_284:
// rs1_val==1431655764 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x554, 0x55555554, 0x554, x2, 1060, x6)

inst_285:
// rs1_val==1431655764 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x55555554, 0x0, x2, 1064, x6)

inst_286:
// rs1_val==1431655764 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555554, 0x4, x2, 1068, x6)

inst_287:
// rs1_val==1431655764 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x110, 0x55555554, 0x332, x2, 1072, x6)

inst_288:
// rs1_val==1431655764 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x444, 0x55555554, 0x665, x2, 1076, x6)

inst_289:
// rs1_val==1431655764 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555554, 0x2c, x2, 1080, x6)

inst_290:
// rs1_val==1431655764 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x554, 0x55555554, 0x556, x2, 1084, x6)

inst_291:
// rs1_val==1431655764 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x55555000, 0x55555554, -0x555, x2, 1088, x6)

inst_292:
// rs1_val==1431655764 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555554, 0x6, x2, 1092, x6)

inst_293:
// rs1_val==1431655764 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x114, 0x55555554, 0x334, x2, 1096, x6)

inst_294:
// rs1_val==1431655764 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x444, 0x55555554, 0x667, x2, 1100, x6)

inst_295:
// rs1_val==1431655764 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x55555554, 0x55555554, -0x2c, x2, 1104, x6)

inst_296:
// rs1_val==1431655764 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555554, 0x2e, x2, 1108, x6)

inst_297:
// rs1_val==0 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x3, x2, 1112, x6)

inst_298:
// rs1_val==0 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x555, x2, 1116, x6)

inst_299:
// rs1_val==0 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, -0x556, x2, 1120, x6)

inst_300:
// rs1_val==0 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x5, x2, 1124, x6)

inst_301:
// rs1_val==0 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x333, x2, 1128, x6)

inst_302:
// rs1_val==0 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x666, x2, 1132, x6)

inst_303:
// rs1_val==0 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, -0x2d, x2, 1136, x6)

inst_304:
// rs1_val==0 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x2d, x2, 1140, x6)

inst_305:
// rs1_val==858993460 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x330, 0x33333334, 0x332, x2, 1144, x6)

inst_306:
// rs1_val==858993460 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x224, 0x33333334, 0x665, x2, 1148, x6)

inst_307:
// rs1_val==858993460 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0x33333334, 0x2c, x2, 1152, x6)

inst_308:
// rs1_val==858993460 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x114, 0x33333334, 0x556, x2, 1156, x6)

inst_309:
// rs1_val==858993460 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x33333220, 0x33333334, -0x555, x2, 1160, x6)

inst_310:
// rs1_val==858993460 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x33333334, 0x6, x2, 1164, x6)

inst_311:
// rs1_val==858993460 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x334, 0x33333334, 0x334, x2, 1168, x6)

inst_312:
// rs1_val==858993460 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x224, 0x33333334, 0x667, x2, 1172, x6)

inst_313:
// rs1_val==858993460 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x33333314, 0x33333334, -0x2c, x2, 1176, x6)

inst_314:
// rs1_val==858993460 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x24, 0x33333334, 0x2e, x2, 1180, x6)

inst_315:
// rs1_val==1717986919 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, 0x66666667, 0x3, x2, 1184, x6)

inst_316:
// rs1_val==1717986919 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x445, 0x66666667, 0x555, x2, 1188, x6)

inst_317:
// rs1_val==1717986919 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x66666222, 0x66666667, -0x556, x2, 1192, x6)

inst_318:
// rs1_val==1717986919 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0x66666667, 0x5, x2, 1196, x6)

inst_319:
// rs1_val==1717986919 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x223, 0x66666667, 0x333, x2, 1200, x6)

inst_320:
// rs1_val==1717986919 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x666, 0x66666667, 0x666, x2, 1204, x6)

inst_321:
// rs1_val==1717986919 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x66666643, 0x66666667, -0x2d, x2, 1208, x6)

inst_322:
// rs1_val==1717986919 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x25, 0x66666667, 0x2d, x2, 1212, x6)

inst_323:
// rs1_val==1717986919 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x66666667, 0x2, x2, 1216, x6)

inst_324:
// rs1_val==1717986919 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x444, 0x66666667, 0x554, x2, 1220, x6)

inst_325:
// rs1_val==1717986919 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x66666667, 0x0, x2, 1224, x6)

inst_326:
// rs1_val==1717986919 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x66666667, 0x4, x2, 1228, x6)

inst_327:
// rs1_val==1717986919 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x222, 0x66666667, 0x332, x2, 1232, x6)

inst_328:
// rs1_val==1717986919 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x665, 0x66666667, 0x665, x2, 1236, x6)

inst_329:
// rs1_val==1717986919 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0x66666667, 0x2c, x2, 1240, x6)

inst_330:
// rs1_val==1717986919 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x446, 0x66666667, 0x556, x2, 1244, x6)

inst_331:
// rs1_val==1717986919 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x66666223, 0x66666667, -0x555, x2, 1248, x6)

inst_332:
// rs1_val==1717986919 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, 0x66666667, 0x6, x2, 1252, x6)

inst_333:
// rs1_val==1717986919 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x224, 0x66666667, 0x334, x2, 1256, x6)

inst_334:
// rs1_val==1717986919 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x667, 0x66666667, 0x667, x2, 1260, x6)

inst_335:
// rs1_val==1717986919 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x66666644, 0x66666667, -0x2c, x2, 1264, x6)

inst_336:
// rs1_val==1717986919 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x26, 0x66666667, 0x2e, x2, 1268, x6)

inst_337:
// rs1_val==-46339 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, -0xb503, 0x3, x2, 1272, x6)

inst_338:
// rs1_val==-46339 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x55, -0xb503, 0x555, x2, 1276, x6)

inst_339:
// rs1_val==-46339 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xffff4aa8, -0xb503, -0x556, x2, 1280, x6)

inst_340:
// rs1_val==-46339 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, -0xb503, 0x5, x2, 1284, x6)

inst_341:
// rs1_val==-46339 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x231, -0xb503, 0x333, x2, 1288, x6)

inst_342:
// rs1_val==-46339 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x264, -0xb503, 0x666, x2, 1292, x6)

inst_343:
// rs1_val==-46339 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xffff4ad1, -0xb503, -0x2d, x2, 1296, x6)

inst_344:
// rs1_val==-46339 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x2d, -0xb503, 0x2d, x2, 1300, x6)

inst_345:
// rs1_val==-46339 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb503, 0x2, x2, 1304, x6)

inst_346:
// rs1_val==-46339 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x54, -0xb503, 0x554, x2, 1308, x6)

inst_347:
// rs1_val==-46339 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb503, 0x0, x2, 1312, x6)

inst_348:
// rs1_val==-46339 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb503, 0x4, x2, 1316, x6)

inst_349:
// rs1_val==-46339 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x230, -0xb503, 0x332, x2, 1320, x6)

inst_350:
// rs1_val==-46339 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x265, -0xb503, 0x665, x2, 1324, x6)

inst_351:
// rs1_val==-46339 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x2c, -0xb503, 0x2c, x2, 1328, x6)

inst_352:
// rs1_val==-46339 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x54, -0xb503, 0x556, x2, 1332, x6)

inst_353:
// rs1_val==-46339 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xffff4aa9, -0xb503, -0x555, x2, 1336, x6)

inst_354:
// rs1_val==-46339 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb503, 0x6, x2, 1340, x6)

inst_355:
// rs1_val==-46339 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x234, -0xb503, 0x334, x2, 1344, x6)

inst_356:
// rs1_val==-46339 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x265, -0xb503, 0x667, x2, 1348, x6)

inst_357:
// rs1_val==-46339 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xffff4ad4, -0xb503, -0x2c, x2, 1352, x6)

inst_358:
// rs1_val==-46339 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2c, -0xb503, 0x2e, x2, 1356, x6)

inst_359:
// rs1_val==46341 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, 0xb505, 0x3, x2, 1360, x6)

inst_360:
// rs1_val==46341 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x505, 0xb505, 0x555, x2, 1364, x6)

inst_361:
// rs1_val==46341 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xb000, 0xb505, -0x556, x2, 1368, x6)

inst_362:
// rs1_val==46341 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0xb505, 0x5, x2, 1372, x6)

inst_363:
// rs1_val==46341 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x101, 0xb505, 0x333, x2, 1376, x6)

inst_364:
// rs1_val==46341 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x404, 0xb505, 0x666, x2, 1380, x6)

inst_365:
// rs1_val==46341 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xb501, 0xb505, -0x2d, x2, 1384, x6)

inst_366:
// rs1_val==46341 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x5, 0xb505, 0x2d, x2, 1388, x6)

inst_367:
// rs1_val==46341 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb505, 0x2, x2, 1392, x6)

inst_368:
// rs1_val==46341 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x504, 0xb505, 0x554, x2, 1396, x6)

inst_369:
// rs1_val==46341 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb505, 0x0, x2, 1400, x6)

inst_370:
// rs1_val==46341 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb505, 0x4, x2, 1404, x6)

inst_371:
// rs1_val==46341 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x100, 0xb505, 0x332, x2, 1408, x6)

inst_372:
// rs1_val==46341 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x405, 0xb505, 0x665, x2, 1412, x6)

inst_373:
// rs1_val==46341 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb505, 0x2c, x2, 1416, x6)

inst_374:
// rs1_val==46341 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x504, 0xb505, 0x556, x2, 1420, x6)

inst_375:
// rs1_val==46341 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xb001, 0xb505, -0x555, x2, 1424, x6)

inst_376:
// rs1_val==46341 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb505, 0x6, x2, 1428, x6)

inst_377:
// rs1_val==46341 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x104, 0xb505, 0x334, x2, 1432, x6)

inst_378:
// rs1_val==46341 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x405, 0xb505, 0x667, x2, 1436, x6)

inst_379:
// rs1_val==46341 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xb504, 0xb505, -0x2c, x2, 1440, x6)

inst_380:
// rs1_val==46341 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb505, 0x2e, x2, 1444, x6)

inst_381:
// rs1_val==0 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x2, x2, 1448, x6)

inst_382:
// rs1_val==0 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x554, x2, 1452, x6)

inst_383:
// rs1_val==0 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x0, x2, 1456, x6)

inst_384:
// rs1_val==0 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x4, x2, 1460, x6)

inst_385:
// rs1_val==0 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x332, x2, 1464, x6)

inst_386:
// rs1_val==0 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x665, x2, 1468, x6)

inst_387:
// rs1_val==0 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x2c, x2, 1472, x6)

inst_388:
// rs1_val==0 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x556, x2, 1476, x6)

inst_389:
// rs1_val==0 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, -0x555, x2, 1480, x6)

inst_390:
// rs1_val==0 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x6, x2, 1484, x6)

inst_391:
// rs1_val==0 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x334, x2, 1488, x6)

inst_392:
// rs1_val==0 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x667, x2, 1492, x6)

inst_393:
// rs1_val==0 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, -0x2c, x2, 1496, x6)

inst_394:
// rs1_val==0 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x2e, x2, 1500, x6)

inst_395:
// rs1_val==4 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x3, x2, 1504, x6)

inst_396:
// rs1_val==4 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x555, x2, 1508, x6)

inst_397:
// rs1_val==4 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, -0x556, x2, 1512, x6)

inst_398:
// rs1_val==4 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x5, x2, 1516, x6)

inst_399:
// rs1_val==4 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x333, x2, 1520, x6)

inst_400:
// rs1_val==4 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x666, x2, 1524, x6)

inst_401:
// rs1_val==4 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, -0x2d, x2, 1528, x6)

inst_402:
// rs1_val==4 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x2d, x2, 1532, x6)

inst_403:
// rs1_val==4 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x2, x2, 1536, x6)

inst_404:
// rs1_val==4 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x554, x2, 1540, x6)

inst_405:
// rs1_val==4 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x0, x2, 1544, x6)

inst_406:
// rs1_val==4 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x4, x2, 1548, x6)

inst_407:
// rs1_val==4 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x332, x2, 1552, x6)

inst_408:
// rs1_val==4 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x665, x2, 1556, x6)

inst_409:
// rs1_val==4 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x2c, x2, 1560, x6)

inst_410:
// rs1_val==4 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x556, x2, 1564, x6)

inst_411:
// rs1_val==4 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, -0x555, x2, 1568, x6)

inst_412:
// rs1_val==4 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x6, x2, 1572, x6)

inst_413:
// rs1_val==4 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x334, x2, 1576, x6)

inst_414:
// rs1_val==4 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, -0x2c, x2, 1580, x6)

inst_415:
// rs1_val==4 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x2e, x2, 1584, x6)

inst_416:
// rs1_val==858993458 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x33333332, 0x3, x2, 1588, x6)

inst_417:
// rs1_val==858993458 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x110, 0x33333332, 0x555, x2, 1592, x6)

inst_418:
// rs1_val==858993458 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x33333222, 0x33333332, -0x556, x2, 1596, x6)

inst_419:
// rs1_val==858993458 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0x33333332, 0x5, x2, 1600, x6)

inst_420:
// rs1_val==858993458 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x332, 0x33333332, 0x333, x2, 1604, x6)

inst_421:
// rs1_val==858993458 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, 0x33333332, 0x666, x2, 1608, x6)

inst_422:
// rs1_val==858993458 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x33333312, 0x33333332, -0x2d, x2, 1612, x6)

inst_423:
// rs1_val==858993458 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x20, 0x33333332, 0x2d, x2, 1616, x6)

inst_424:
// rs1_val==858993458 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x33333332, 0x2, x2, 1620, x6)

inst_425:
// rs1_val==858993458 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x110, 0x33333332, 0x554, x2, 1624, x6)

inst_426:
// rs1_val==858993458 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x33333332, 0x0, x2, 1628, x6)

inst_427:
// rs1_val==858993458 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x33333332, 0x4, x2, 1632, x6)

inst_428:
// rs1_val==858993458 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x332, 0x33333332, 0x332, x2, 1636, x6)

inst_429:
// rs1_val==858993458 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x220, 0x33333332, 0x665, x2, 1640, x6)

inst_430:
// rs1_val==858993458 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x20, 0x33333332, 0x2c, x2, 1644, x6)

inst_431:
// rs1_val==858993458 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x112, 0x33333332, 0x556, x2, 1648, x6)

inst_432:
// rs1_val==858993458 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x33333222, 0x33333332, -0x555, x2, 1652, x6)

inst_433:
// rs1_val==858993458 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0x33333332, 0x6, x2, 1656, x6)

inst_434:
// rs1_val==858993458 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x330, 0x33333332, 0x334, x2, 1660, x6)

inst_435:
// rs1_val==858993458 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x222, 0x33333332, 0x667, x2, 1664, x6)

inst_436:
// rs1_val==858993458 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x33333310, 0x33333332, -0x2c, x2, 1668, x6)

inst_437:
// rs1_val==858993458 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x22, 0x33333332, 0x2e, x2, 1672, x6)

inst_438:
// rs1_val==1717986917 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, 0x66666665, 0x3, x2, 1676, x6)

inst_439:
// rs1_val==1717986917 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x445, 0x66666665, 0x555, x2, 1680, x6)

inst_440:
// rs1_val==1717986917 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x66666220, 0x66666665, -0x556, x2, 1684, x6)

inst_441:
// rs1_val==1717986917 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0x66666665, 0x5, x2, 1688, x6)

inst_442:
// rs1_val==1717986917 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x221, 0x66666665, 0x333, x2, 1692, x6)

inst_443:
// rs1_val==1717986917 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x664, 0x66666665, 0x666, x2, 1696, x6)

inst_444:
// rs1_val==1717986917 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x66666641, 0x66666665, -0x2d, x2, 1700, x6)

inst_445:
// rs1_val==1717986917 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x25, 0x66666665, 0x2d, x2, 1704, x6)

inst_446:
// rs1_val==1717986917 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x66666665, 0x2, x2, 1708, x6)

inst_447:
// rs1_val==1717986917 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x444, 0x66666665, 0x554, x2, 1712, x6)

inst_448:
// rs1_val==1717986917 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x66666665, 0x0, x2, 1716, x6)

inst_449:
// rs1_val==1717986917 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x66666665, 0x4, x2, 1720, x6)

inst_450:
// rs1_val==1717986917 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x220, 0x66666665, 0x332, x2, 1724, x6)

inst_451:
// rs1_val==1717986917 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x665, 0x66666665, 0x665, x2, 1728, x6)

inst_452:
// rs1_val==1717986917 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0x66666665, 0x2c, x2, 1732, x6)

inst_453:
// rs1_val==1717986917 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x444, 0x66666665, 0x556, x2, 1736, x6)

inst_454:
// rs1_val==1717986917 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x66666221, 0x66666665, -0x555, x2, 1740, x6)

inst_455:
// rs1_val==1717986917 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x66666665, 0x6, x2, 1744, x6)

inst_456:
// rs1_val==1717986917 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x224, 0x66666665, 0x334, x2, 1748, x6)

inst_457:
// rs1_val==1717986917 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x665, 0x66666665, 0x667, x2, 1752, x6)

inst_458:
// rs1_val==1717986917 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x66666644, 0x66666665, -0x2c, x2, 1756, x6)

inst_459:
// rs1_val==1717986917 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x24, 0x66666665, 0x2e, x2, 1760, x6)

inst_460:
// rs1_val==46339 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, 0xb503, 0x3, x2, 1764, x6)

inst_461:
// rs1_val==46339 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x501, 0xb503, 0x555, x2, 1768, x6)

inst_462:
// rs1_val==46339 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xb002, 0xb503, -0x556, x2, 1772, x6)

inst_463:
// rs1_val==46339 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x1, 0xb503, 0x5, x2, 1776, x6)

inst_464:
// rs1_val==46339 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x103, 0xb503, 0x333, x2, 1780, x6)

inst_465:
// rs1_val==46339 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x402, 0xb503, 0x666, x2, 1784, x6)

inst_466:
// rs1_val==46339 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xb503, 0xb503, -0x2d, x2, 1788, x6)

inst_467:
// rs1_val==46339 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x1, 0xb503, 0x2d, x2, 1792, x6)

inst_468:
// rs1_val==46339 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0xb503, 0x2, x2, 1796, x6)

inst_469:
// rs1_val==46339 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x500, 0xb503, 0x554, x2, 1800, x6)

inst_470:
// rs1_val==46339 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb503, 0x0, x2, 1804, x6)

inst_471:
// rs1_val==46339 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb503, 0x4, x2, 1808, x6)

inst_472:
// rs1_val==46339 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x102, 0xb503, 0x332, x2, 1812, x6)

inst_473:
// rs1_val==46339 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x401, 0xb503, 0x665, x2, 1816, x6)

inst_474:
// rs1_val==46339 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb503, 0x2c, x2, 1820, x6)

inst_475:
// rs1_val==46339 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x502, 0xb503, 0x556, x2, 1824, x6)

inst_476:
// rs1_val==46339 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xb003, 0xb503, -0x555, x2, 1828, x6)

inst_477:
// rs1_val==46339 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0xb503, 0x6, x2, 1832, x6)

inst_478:
// rs1_val==46339 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x100, 0xb503, 0x334, x2, 1836, x6)

inst_479:
// rs1_val==46339 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x403, 0xb503, 0x667, x2, 1840, x6)

inst_480:
// rs1_val==46339 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xb500, 0xb503, -0x2c, x2, 1844, x6)

inst_481:
// rs1_val==46339 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2, 0xb503, 0x2e, x2, 1848, x6)

inst_482:
// rs1_val==1431655766 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x55555556, 0x3, x2, 1852, x6)

inst_483:
// rs1_val==1431655766 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x554, 0x55555556, 0x555, x2, 1856, x6)

inst_484:
// rs1_val==1431655766 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x55555002, 0x55555556, -0x556, x2, 1860, x6)

inst_485:
// rs1_val==1431655766 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555556, 0x5, x2, 1864, x6)

inst_486:
// rs1_val==1431655766 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x112, 0x55555556, 0x333, x2, 1868, x6)

inst_487:
// rs1_val==1431655766 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x446, 0x55555556, 0x666, x2, 1872, x6)

inst_488:
// rs1_val==1431655766 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x55555552, 0x55555556, -0x2d, x2, 1876, x6)

inst_489:
// rs1_val==1431655766 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555556, 0x2d, x2, 1880, x6)

inst_490:
// rs1_val==1431655766 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x55555556, 0x2, x2, 1884, x6)

inst_491:
// rs1_val==1431655766 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x554, 0x55555556, 0x554, x2, 1888, x6)

inst_492:
// rs1_val==1431655766 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x55555556, 0x0, x2, 1892, x6)

inst_493:
// rs1_val==1431655766 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555556, 0x4, x2, 1896, x6)

inst_494:
// rs1_val==1431655766 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x112, 0x55555556, 0x332, x2, 1900, x6)

inst_495:
// rs1_val==1431655766 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x444, 0x55555556, 0x665, x2, 1904, x6)

inst_496:
// rs1_val==1431655766 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x55555556, 0x2c, x2, 1908, x6)

inst_497:
// rs1_val==1431655766 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x556, 0x55555556, 0x556, x2, 1912, x6)

inst_498:
// rs1_val==1431655766 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x55555002, 0x55555556, -0x555, x2, 1916, x6)

inst_499:
// rs1_val==1431655766 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, 0x55555556, 0x6, x2, 1920, x6)

inst_500:
// rs1_val==1431655766 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x114, 0x55555556, 0x334, x2, 1924, x6)

inst_501:
// rs1_val==1431655766 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x446, 0x55555556, 0x667, x2, 1928, x6)

inst_502:
// rs1_val==1431655766 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x55555554, 0x55555556, -0x2c, x2, 1932, x6)

inst_503:
// rs1_val==1431655766 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x6, 0x55555556, 0x2e, x2, 1936, x6)

inst_504:
// rs1_val==-1431655765 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, -0x55555555, 0x3, x2, 1940, x6)

inst_505:
// rs1_val==-1431655765 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x1, -0x55555555, 0x555, x2, 1944, x6)

inst_506:
// rs1_val==-1431655765 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaa, -0x55555555, -0x556, x2, 1948, x6)

inst_507:
// rs1_val==-1431655765 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x1, -0x55555555, 0x5, x2, 1952, x6)

inst_508:
// rs1_val==-1431655765 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x223, -0x55555555, 0x333, x2, 1956, x6)

inst_509:
// rs1_val==-1431655765 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, -0x55555555, 0x666, x2, 1960, x6)

inst_510:
// rs1_val==-1431655765 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xaaaaaa83, -0x55555555, -0x2d, x2, 1964, x6)

inst_511:
// rs1_val==-1431655765 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x29, -0x55555555, 0x2d, x2, 1968, x6)

inst_512:
// rs1_val==-1431655765 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, -0x55555555, 0x2, x2, 1972, x6)

inst_513:
// rs1_val==-1431655765 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, -0x55555555, 0x554, x2, 1976, x6)

inst_514:
// rs1_val==-1431655765 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x55555555, 0x0, x2, 1980, x6)

inst_515:
// rs1_val==-1431655765 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, -0x55555555, 0x4, x2, 1984, x6)

inst_516:
// rs1_val==-1431655765 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x222, -0x55555555, 0x332, x2, 1988, x6)

inst_517:
// rs1_val==-1431655765 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x221, -0x55555555, 0x665, x2, 1992, x6)

inst_518:
// rs1_val==-1431655765 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x28, -0x55555555, 0x2c, x2, 1996, x6)

inst_519:
// rs1_val==-1431655765 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x2, -0x55555555, 0x556, x2, 2000, x6)

inst_520:
// rs1_val==-1431655765 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaab, -0x55555555, -0x555, x2, 2004, x6)

inst_521:
// rs1_val==-1431655765 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, -0x55555555, 0x6, x2, 2008, x6)

inst_522:
// rs1_val==-1431655765 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x220, -0x55555555, 0x334, x2, 2012, x6)

inst_523:
// rs1_val==-1431655765 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x223, -0x55555555, 0x667, x2, 2016, x6)

inst_524:
// rs1_val==-1431655765 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xaaaaaa80, -0x55555555, -0x2c, x2, 2020, x6)

inst_525:
// rs1_val==-1431655765 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2a, -0x55555555, 0x2e, x2, 2024, x6)

inst_526:
// rs1_val==6 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, 0x3, x2, 2028, x6)

inst_527:
// rs1_val==6 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x555, x2, 2032, x6)

inst_528:
// rs1_val==6 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, -0x556, x2, 2036, x6)

inst_529:
// rs1_val==6 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x5, x2, 2040, x6)

inst_530:
// rs1_val==6 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, 0x333, x2, 2044, x6)
RVTEST_SIGBASE( x2,signature_x2_1)

inst_531:
// rs1_val==6 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x666, x2, 0, x6)

inst_532:
// rs1_val==6 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, -0x2d, x2, 4, x6)

inst_533:
// rs1_val==6 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x2d, x2, 8, x6)

inst_534:
// rs1_val==6 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, 0x2, x2, 12, x6)

inst_535:
// rs1_val==6 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x554, x2, 16, x6)

inst_536:
// rs1_val==6 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x6, 0x0, x2, 20, x6)

inst_537:
// rs1_val==6 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x4, x2, 24, x6)

inst_538:
// rs1_val==6 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, 0x332, x2, 28, x6)

inst_539:
// rs1_val==6 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x665, x2, 32, x6)

inst_540:
// rs1_val==6 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x2c, x2, 36, x6)

inst_541:
// rs1_val==6 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x556, x2, 40, x6)

inst_542:
// rs1_val==6 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, -0x555, x2, 44, x6)

inst_543:
// rs1_val==6 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x6, x2, 48, x6)

inst_544:
// rs1_val==6 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x334, x2, 52, x6)

inst_545:
// rs1_val==6 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x667, x2, 56, x6)

inst_546:
// rs1_val==6 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, -0x2c, x2, 60, x6)

inst_547:
// rs1_val==6 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x2e, x2, 64, x6)

inst_548:
// rs1_val==858993460 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x33333334, 0x3, x2, 68, x6)

inst_549:
// rs1_val==858993460 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x114, 0x33333334, 0x555, x2, 72, x6)

inst_550:
// rs1_val==858993460 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x33333220, 0x33333334, -0x556, x2, 76, x6)

inst_551:
// rs1_val==858993460 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x33333334, 0x5, x2, 80, x6)

inst_552:
// rs1_val==858993460 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x330, 0x33333334, 0x333, x2, 84, x6)

inst_553:
// rs1_val==858993460 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x224, 0x33333334, 0x666, x2, 88, x6)

inst_554:
// rs1_val==858993460 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x33333310, 0x33333334, -0x2d, x2, 92, x6)

inst_555:
// rs1_val==858993460 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x24, 0x33333334, 0x2d, x2, 96, x6)

inst_556:
// rs1_val==858993460 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x33333334, 0x2, x2, 100, x6)

inst_557:
// rs1_val==858993460 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x114, 0x33333334, 0x554, x2, 104, x6)

inst_558:
// rs1_val==858993460 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x33333334, 0x0, x2, 108, x6)

inst_559:
// rs1_val==858993460 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x33333334, 0x4, x2, 112, x6)

inst_560:
// imm_val == 2, rs1_val == 16777216
// opcode: andi ; op1:x10; dest:x11; op1val:0x1000000;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x1000000, 0x2, x2, 116, x6)

inst_561:
// imm_val == -257, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504;  immval:-0x101
TEST_IMM_OP( andi, x11, x10, 0xffff4afc, -0xb504, -0x101, x2, 120, x6)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x18_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x18_1:
    .fill 19*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 512*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 31*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
