
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:36:11 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32i.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the bgeu instruction of the RISC-V I extension for the bgeu covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",bgeu)

RVTEST_SIGBASE( x9,signature_x9_1)

inst_0:
// rs1 == rs2, rs1==x2, rs2==x2, rs1_val > 0 and rs2_val > 0, rs2_val == 4294966271, rs1_val == 8, rs1_val > 0 and rs2_val > 0 and rs1_val < rs2_val and imm_val < 0 
// opcode: bgeu, op1:x2; op2:x2; op1val:0x8; op2val:0x8; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x5, x2, x2, 0x8, 0x8, 0x0, 1b, x9, 0,0)

inst_1:
// rs1 != rs2, rs1==x31, rs2==x3, rs1_val > 0 and rs2_val > 0 and rs1_val == rs2_val and imm_val > 0, rs2_val == 4294967231, rs1_val == 4294967231
// opcode: bgeu, op1:x31; op2:x3; op1val:0xffffffbf; op2val:0xffffffbf; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x5, x31, x3, 0xffffffbf, 0xffffffbf, 0x200, 3f, x9, 4,0)

inst_2:
// rs1==x21, rs2==x25, rs1_val > 0 and rs2_val > 0 and rs1_val == rs2_val and imm_val < 0, rs1_val==65535 and rs2_val==65535
// opcode: bgeu, op1:x21; op2:x25; op1val:0xffff; op2val:0xffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x5, x21, x25, 0xffff, 0xffff, 0x0, 1b, x9, 8,0)

inst_3:
// rs1==x27, rs2==x13, rs1_val > 0 and rs2_val > 0 and rs1_val > rs2_val and imm_val > 0 , rs1_val == 4294705151, rs2_val == 4293918719
// opcode: bgeu, op1:x27; op2:x13; op1val:0xfffbffff; op2val:0xffefffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x5, x27, x13, 0xfffbffff, 0xffefffff, 0x8, 3f, x9, 12,0)

inst_4:
// rs1==x14, rs2==x29, rs1_val > 0 and rs2_val > 0 and rs1_val > rs2_val and imm_val < 0 , rs1_val==2863311531 and rs2_val==4, rs2_val == 4
// opcode: bgeu, op1:x14; op2:x29; op1val:0xaaaaaaab; op2val:0x4; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x5, x14, x29, 0xaaaaaaab, 0x4, 0x6, 1b, x9, 16,0)

inst_5:
// rs1==x7, rs2==x16, rs1_val > 0 and rs2_val > 0 and rs1_val < rs2_val and imm_val > 0 , 
// opcode: bgeu, op1:x7; op2:x16; op1val:0x7; op2val:0xb504; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x5, x7, x16, 0x7, 0xb504, 0x400, 3f, x9, 20,0)

inst_6:
// rs1==x11, rs2==x19, rs2_val == 1, rs1_val==2863311529 and rs2_val==1
// opcode: bgeu, op1:x11; op2:x19; op1val:0xaaaaaaa9; op2val:0x1; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x5, x11, x19, 0xaaaaaaa9, 0x1, 0x40, 3f, x9, 24,0)

inst_7:
// rs1==x10, rs2==x21, rs2_val == 2, rs1_val == 2863311530, rs1_val==2863311530 and rs2_val==2
// opcode: bgeu, op1:x10; op2:x21; op1val:0xaaaaaaaa; op2val:0x2; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x5, x10, x21, 0xaaaaaaaa, 0x2, 0x40, 3f, x9, 28,0)

inst_8:
// rs1==x0, rs2==x20, rs2_val == 8, rs1_val == 4294967294
// opcode: bgeu, op1:x0; op2:x20; op1val:0x0; op2val:0x8; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x5, x0, x20, 0x0, 0x8, 0x400, 1b, x9, 32,0)

inst_9:
// rs1==x3, rs2==x27, rs2_val == 16, 
// opcode: bgeu, op1:x3; op2:x27; op1val:0xffff; op2val:0x10; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x5, x3, x27, 0xffff, 0x10, 0x2, 1b, x9, 36,0)

inst_10:
// rs1==x25, rs2==x28, rs2_val == 32, 
// opcode: bgeu, op1:x25; op2:x28; op1val:0x6; op2val:0x20; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x5, x25, x28, 0x6, 0x20, 0x8, 1b, x9, 40,0)

inst_11:
// rs1==x30, rs2==x0, rs2_val == 64, rs1_val == 4294965247
// opcode: bgeu, op1:x30; op2:x0; op1val:0xfffff7ff; op2val:0x0; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x5, x30, x0, 0xfffff7ff, 0x0, 0x8, 1b, x9, 44,0)

inst_12:
// rs1==x29, rs2==x23, rs2_val == 128, 
// opcode: bgeu, op1:x29; op2:x23; op1val:0xd; op2val:0x80; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x5, x29, x23, 0xd, 0x80, 0x200, 3f, x9, 48,0)

inst_13:
// rs1==x12, rs2==x8, rs2_val == 256, rs1_val == 4294967167
// opcode: bgeu, op1:x12; op2:x8; op1val:0xffffff7f; op2val:0x100; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x5, x12, x8, 0xffffff7f, 0x100, 0x200, 3f, x9, 52,0)

inst_14:
// rs1==x22, rs2==x7, rs2_val == 512, 
// opcode: bgeu, op1:x22; op2:x7; op1val:0xb504; op2val:0x200; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x5, x22, x7, 0xb504, 0x200, 0x4, 3f, x9, 56,0)

inst_15:
// rs1==x24, rs2==x26, rs2_val == 1024, rs1_val == 16384
// opcode: bgeu, op1:x24; op2:x26; op1val:0x4000; op2val:0x400; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x5, x24, x26, 0x4000, 0x400, 0x40, 3f, x9, 60,0)

inst_16:
// rs1==x6, rs2==x22, rs2_val == 2048, rs1_val == 524288
// opcode: bgeu, op1:x6; op2:x22; op1val:0x80000; op2val:0x800; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x5, x6, x22, 0x80000, 0x800, 0x40, 3f, x9, 64,0)

inst_17:
// rs1==x4, rs2==x18, rs2_val == 4096, 
// opcode: bgeu, op1:x4; op2:x18; op1val:0x8; op2val:0x1000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x5, x4, x18, 0x8, 0x1000, 0x0, 1b, x9, 68,0)

inst_18:
// rs1==x1, rs2==x30, rs2_val == 8192, 
// opcode: bgeu, op1:x1; op2:x30; op1val:0xb505; op2val:0x2000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x5, x1, x30, 0xb505, 0x2000, 0x2, 1b, x9, 72,0)

inst_19:
// rs1==x5, rs2==x12, rs2_val == 16384, 
// opcode: bgeu, op1:x5; op2:x12; op1val:0xaaaaaaaa; op2val:0x4000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x5, x12, 0xaaaaaaaa, 0x4000, 0x6, 1b, x9, 76,0)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_20:
// rs1==x16, rs2==x1, rs2_val == 32768, rs1_val == 33554432
// opcode: bgeu, op1:x16; op2:x1; op1val:0x2000000; op2val:0x8000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x16, x1, 0x2000000, 0x8000, 0x2, 1b, x2, 0,0)

inst_21:
// rs1==x26, rs2==x31, rs2_val == 65536, 
// opcode: bgeu, op1:x26; op2:x31; op1val:0xfffff7ff; op2val:0x10000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x26, x31, 0xfffff7ff, 0x10000, 0x6, 3f, x2, 4,0)

inst_22:
// rs1==x28, rs2==x10, rs2_val == 131072, rs1_val == 3221225471
// opcode: bgeu, op1:x28; op2:x10; op1val:0xbfffffff; op2val:0x20000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x28, x10, 0xbfffffff, 0x20000, 0x6, 1b, x2, 8,0)

inst_23:
// rs1==x9, rs2==x24, rs2_val == 262144, rs1_val == 4261412863
// opcode: bgeu, op1:x9; op2:x24; op1val:0xfdffffff; op2val:0x40000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x9, x24, 0xfdffffff, 0x40000, 0x200, 3f, x2, 12,0)

inst_24:
// rs1==x15, rs2==x5, rs2_val == 524288, 
// opcode: bgeu, op1:x15; op2:x5; op1val:0x0; op2val:0x80000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x15, x5, 0x0, 0x80000, 0x400, 1b, x2, 16,0)

inst_25:
// rs1==x18, rs2==x14, rs2_val == 1048576, 
// opcode: bgeu, op1:x18; op2:x14; op1val:0x55555556; op2val:0x100000; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x18, x14, 0x55555556, 0x100000, 0x20, 3f, x2, 20,0)

inst_26:
// rs1==x17, rs2==x15, rs2_val == 2097152, rs1_val == 1
// opcode: bgeu, op1:x17; op2:x15; op1val:0x1; op2val:0x200000; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x17, x15, 0x1, 0x200000, 0x40, 3f, x2, 24,0)

inst_27:
// rs1==x20, rs2==x17, rs2_val == 4194304, 
// opcode: bgeu, op1:x20; op2:x17; op1val:0xfffff7ff; op2val:0x400000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x20, x17, 0xfffff7ff, 0x400000, 0x400, 1b, x2, 28,0)

inst_28:
// rs1==x23, rs2==x11, rs2_val == 8388608, 
// opcode: bgeu, op1:x23; op2:x11; op1val:0x4000; op2val:0x800000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x23, x11, 0x4000, 0x800000, 0x200, 3f, x2, 32,0)

inst_29:
// rs1==x13, rs2==x4, rs2_val == 16777216, rs1_val == 4294966271
// opcode: bgeu, op1:x13; op2:x4; op1val:0xfffffbff; op2val:0x1000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x13, x4, 0xfffffbff, 0x1000000, 0x6, 3f, x2, 36,0)

inst_30:
// rs1==x19, rs2==x6, rs2_val == 33554432, rs1_val == 128
// opcode: bgeu, op1:x19; op2:x6; op1val:0x80; op2val:0x2000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x19, x6, 0x80, 0x2000000, 0x400, 1b, x2, 40,0)

inst_31:
// rs1==x8, rs2==x9, rs2_val == 67108864, 
// opcode: bgeu, op1:x8; op2:x9; op1val:0x3; op2val:0x4000000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x8, x9, 0x3, 0x4000000, 0x2, 1b, x2, 44,0)

inst_32:
// rs2_val == 134217728, rs1_val == 4294934527
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff7fff; op2val:0x8000000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff7fff, 0x8000000, 0x0, 1b, x2, 48,0)

inst_33:
// rs2_val == 268435456, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x10000000; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x10000000, 0x40, 3f, x2, 52,0)

inst_34:
// rs2_val == 536870912, rs1_val == 3758096383
// opcode: bgeu, op1:x10; op2:x11; op1val:0xdfffffff; op2val:0x20000000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xdfffffff, 0x20000000, 0x4, 1b, x2, 56,0)

inst_35:
// rs2_val == 1073741824, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x40000000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x40000000, 0x2, 1b, x2, 60,0)

inst_36:
// rs2_val == 2147483648, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x80000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x80000000, 0x200, 3f, x2, 64,0)

inst_37:
// rs2_val == 4294967294, rs1_val == 8388608
// opcode: bgeu, op1:x10; op2:x11; op1val:0x800000; op2val:0xfffffffe; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x800000, 0xfffffffe, 0x4, 3f, x2, 68,0)

inst_38:
// rs2_val == 4294967293, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffff7ff; op2val:0xfffffffd; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffff7ff, 0xfffffffd, 0x6, 3f, x2, 72,0)

inst_39:
// rs2_val == 4294967291, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xfffffffb; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xfffffffb, 0x2, 1b, x2, 76,0)

inst_40:
// rs2_val == 4294967287, rs1_val == 134217728
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8000000; op2val:0xfffffff7; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x8000000, 0xfffffff7, 0x2, 3f, x2, 80,0)

inst_41:
// rs2_val == 4294967279, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xffffffef; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xffffffef, 0x40, 3f, x2, 84,0)

inst_42:
// rs2_val == 4294967263, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xffffffdf; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xffffffdf, 0x8, 3f, x2, 88,0)

inst_43:
// rs2_val == 4294967167, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x12; op2val:0xffffff7f; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x12, 0xffffff7f, 0x100, 3f, x2, 92,0)

inst_44:
// rs2_val == 4294967039, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xfffffeff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xfffffeff, 0x6, 1b, x2, 96,0)

inst_45:
// rs2_val == 4294966783, rs1_val == 67108864
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000000; op2val:0xfffffdff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4000000, 0xfffffdff, 0x0, 1b, x2, 100,0)

inst_46:
// rs2_val == 4294965247, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xfffff7ff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xfffff7ff, 0x8, 3f, x2, 104,0)

inst_47:
// rs2_val == 4294963199, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xbfffffff; op2val:0xffffefff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xbfffffff, 0xffffefff, 0x8, 3f, x2, 108,0)

inst_48:
// rs2_val == 4294959103, rs1_val == 4294966783
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffdff; op2val:0xffffdfff; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffffdff, 0xffffdfff, 0x200, 3f, x2, 112,0)

inst_49:
// rs2_val == 4294950911, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8; op2val:0xffffbfff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x8, 0xffffbfff, 0x10, 3f, x2, 116,0)

inst_50:
// rs2_val == 4294934527, rs1_val == 4294967039
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffeff; op2val:0xffff7fff; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffffeff, 0xffff7fff, 0x20, 3f, x2, 120,0)

inst_51:
// rs2_val == 4294901759, rs1_val == 2
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xfffeffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xfffeffff, 0x400, 3f, x2, 124,0)

inst_52:
// rs2_val == 4294836223, rs1_val == 4294959103
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffdfff; op2val:0xfffdffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffffdfff, 0xfffdffff, 0x556, 1b, x2, 128,0)

inst_53:
// rs2_val == 4294705151, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000000; op2val:0xfffbffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2000000, 0xfffbffff, 0x556, 1b, x2, 132,0)

inst_54:
// rs2_val == 4294443007, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffbffff; op2val:0xfff7ffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffbffff, 0xfff7ffff, 0x556, 1b, x2, 136,0)

inst_55:
// rs2_val == 4292870143, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000000; op2val:0xffdfffff; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4000000, 0xffdfffff, 0x80, 3f, x2, 140,0)

inst_56:
// rs2_val == 4290772991, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffdfff; op2val:0xffbfffff; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffffdfff, 0xffbfffff, 0xa, 1b, x2, 144,0)

inst_57:
// rs2_val == 4286578687, rs1_val == 16777216
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1000000; op2val:0xff7fffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1000000, 0xff7fffff, 0x0, 1b, x2, 148,0)

inst_58:
// rs2_val == 4278190079, rs1_val == 4294963199
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffefff; op2val:0xfeffffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffffefff, 0xfeffffff, 0x8, 1b, x2, 152,0)

inst_59:
// rs2_val == 4261412863, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xfdffffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xfdffffff, 0x4, 3f, x2, 156,0)

inst_60:
// rs2_val == 4227858431, rs1_val == 1431655765
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xfbffffff; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xfbffffff, 0x200, 3f, x2, 160,0)

inst_61:
// rs2_val == 4160749567, rs1_val == 4294950911
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffbfff; op2val:0xf7ffffff; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffffbfff, 0xf7ffffff, 0x100, 3f, x2, 164,0)

inst_62:
// rs2_val == 4026531839, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000; op2val:0xefffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4000, 0xefffffff, 0x0, 3f, x2, 168,0)

inst_63:
// rs2_val == 3758096383, rs1_val == 4
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xdfffffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xdfffffff, 0x4, 1b, x2, 172,0)

inst_64:
// rs2_val == 3221225471, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xbfffffff; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xbfffffff, 0x40, 3f, x2, 176,0)

inst_65:
// rs2_val == 2147483647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8000000; op2val:0x7fffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x8000000, 0x7fffffff, 0x2, 1b, x2, 180,0)

inst_66:
// rs2_val == 1431655765, rs1_val == 2097152
// opcode: bgeu, op1:x10; op2:x11; op1val:0x200000; op2val:0x55555555; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x200000, 0x55555555, 0x4, 3f, x2, 184,0)

inst_67:
// rs2_val == 2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffbff; op2val:0xaaaaaaaa; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffffbff, 0xaaaaaaaa, 0x0, 3f, x2, 188,0)

inst_68:
// rs1_val == 16, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10; op2val:0x20; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10, 0x20, 0x40, 3f, x2, 192,0)

inst_69:
// rs1_val == 32, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x20; op2val:0xfffffeff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x20, 0xfffffeff, 0x556, 1b, x2, 196,0)

inst_70:
// rs1_val == 64, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x40; op2val:0xf7ffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x40, 0xf7ffffff, 0x0, 3f, x2, 200,0)

inst_71:
// rs1_val == 256, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100; op2val:0xfffffff7; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x100, 0xfffffff7, 0x400, 3f, x2, 204,0)

inst_72:
// rs1_val == 512, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x200; op2val:0x400000; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x200, 0x400000, 0x100, 3f, x2, 208,0)

inst_73:
// rs1_val == 1024, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400; op2val:0xffffbfff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x400, 0xffffbfff, 0x2, 1b, x2, 212,0)

inst_74:
// rs1_val == 2048, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x800; op2val:0xaaaaaaaa; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x800, 0xaaaaaaaa, 0x400, 3f, x2, 216,0)

inst_75:
// rs1_val == 4096, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1000; op2val:0x1000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1000, 0x1000, 0x4, 3f, x2, 220,0)

inst_76:
// rs1_val == 8192, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000; op2val:0x1; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2000, 0x1, 0x556, 1b, x2, 224,0)

inst_77:
// rs1_val == 32768, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8000; op2val:0xfffff7ff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x8000, 0xfffff7ff, 0x6, 1b, x2, 228,0)

inst_78:
// rs1_val == 65536, rs1_val==65536 and rs2_val==1431655765
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x55555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x55555555, 0x2, 3f, x2, 232,0)

inst_79:
// rs1_val == 131072, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x20000; op2val:0x20000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x20000, 0x20000, 0x2, 3f, x2, 236,0)

inst_80:
// rs1_val == 262144, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x40000; op2val:0x8000000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x40000, 0x8000000, 0x10, 3f, x2, 240,0)

inst_81:
// rs1_val == 1048576, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000; op2val:0x9; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x100000, 0x9, 0x10, 3f, x2, 244,0)

inst_82:
// rs1_val == 4194304, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400000; op2val:0x8000; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x400000, 0x8000, 0x100, 3f, x2, 248,0)

inst_83:
// rs1_val == 268435456, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000000; op2val:0x55555555; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000000, 0x55555555, 0x0, 1b, x2, 252,0)

inst_84:
// rs1_val == 536870912, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x20000000; op2val:0x80; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x20000000, 0x80, 0x556, 1b, x2, 256,0)

inst_85:
// rs1_val == 1073741824, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x40000000; op2val:0xffffffbf; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x40000000, 0xffffffbf, 0xa, 1b, x2, 260,0)

inst_86:
// rs1_val == 2147483648, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x80000000; op2val:0x4000000; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x80000000, 0x4000000, 0x100, 3f, x2, 264,0)

inst_87:
// rs1_val == 4294967293, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffd; op2val:0xfffffffd; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffffffd, 0xfffffffd, 0x40, 3f, x2, 268,0)

inst_88:
// rs1_val == 4294967291, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffb; op2val:0x40; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffffffb, 0x40, 0x40, 3f, x2, 272,0)

inst_89:
// rs1_val == 4294967287, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffff7; op2val:0xaaaaaaaa; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffffff7, 0xaaaaaaaa, 0x6, 1b, x2, 276,0)

inst_90:
// rs1_val == 4294967279, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffef; op2val:0x0; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffffffef, 0x0, 0x200, 3f, x2, 280,0)

inst_91:
// rs1_val == 4294967263, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffdf; op2val:0x1; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffffffdf, 0x1, 0x6, 1b, x2, 284,0)

inst_92:
// rs1_val == 4294901759, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffeffff; op2val:0xffffbfff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffeffff, 0xffffbfff, 0x10, 3f, x2, 288,0)

inst_93:
// rs1_val == 4294836223, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffdffff; op2val:0xfffe; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffdffff, 0xfffe, 0x100, 3f, x2, 292,0)

inst_94:
// rs1_val == 4294443007, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfff7ffff; op2val:0xfffbffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfff7ffff, 0xfffbffff, 0x556, 1b, x2, 296,0)

inst_95:
// rs1_val == 4293918719, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffefffff; op2val:0x2; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffefffff, 0x2, 0x6, 3f, x2, 300,0)

inst_96:
// rs1_val == 4292870143, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffdfffff; op2val:0xfffdffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffdfffff, 0xfffdffff, 0x8, 3f, x2, 304,0)

inst_97:
// rs1_val == 4290772991, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffbfffff; op2val:0xa; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffbfffff, 0xa, 0x200, 3f, x2, 308,0)

inst_98:
// rs1_val == 4286578687, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xff7fffff; op2val:0xffffffef; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xff7fffff, 0xffffffef, 0xa, 1b, x2, 312,0)

inst_99:
// rs1_val == 4278190079, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfeffffff; op2val:0x100; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfeffffff, 0x100, 0x0, 3f, x2, 316,0)

inst_100:
// rs1_val == 4227858431, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfbffffff; op2val:0xffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfbffffff, 0xffff, 0x2, 3f, x2, 320,0)

inst_101:
// rs1_val == 4160749567, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xf7ffffff; op2val:0xaaaaaaaa; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xf7ffffff, 0xaaaaaaaa, 0x4, 1b, x2, 324,0)

inst_102:
// rs1_val == 4026531839, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xefffffff; op2val:0x12; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xefffffff, 0x12, 0xa, 1b, x2, 328,0)

inst_103:
// rs1_val == 2147483647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x7fffffff; op2val:0x6; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x7fffffff, 0x6, 0x100, 3f, x2, 332,0)

inst_104:
// rs1_val==3 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x3; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x3, 0x4, 1b, x2, 336,0)

inst_105:
// rs1_val==3 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x55555555; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x55555555, 0xa, 1b, x2, 340,0)

inst_106:
// rs1_val==3 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xaaaaaaaa; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xaaaaaaaa, 0x556, 1b, x2, 344,0)

inst_107:
// rs1_val==3 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x5; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x5, 0x4, 1b, x2, 348,0)

inst_108:
// rs1_val==3 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x33333333; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x33333333, 0x2, 1b, x2, 352,0)

inst_109:
// rs1_val==3 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x66666666; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x66666666, 0x6, 3f, x2, 356,0)

inst_110:
// rs1_val==3 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xb504; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xb504, 0x200, 3f, x2, 360,0)

inst_111:
// rs1_val==3 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x0, 0x4, 3f, x2, 364,0)

inst_112:
// rs1_val==3 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xffff, 0x0, 3f, x2, 368,0)

inst_113:
// rs1_val==3 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x2; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x2, 0x40, 3f, x2, 372,0)

inst_114:
// rs1_val==3 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x55555554; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x55555554, 0x100, 3f, x2, 376,0)

inst_115:
// rs1_val==3 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xaaaaaaa9; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xaaaaaaa9, 0x10, 3f, x2, 380,0)

inst_116:
// rs1_val==3 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x4; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x4, 0x10, 3f, x2, 384,0)

inst_117:
// rs1_val==3 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x33333332; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x33333332, 0x2, 3f, x2, 388,0)

inst_118:
// rs1_val==3 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x66666665; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x66666665, 0x100, 3f, x2, 392,0)

inst_119:
// rs1_val==3 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xb503; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xb503, 0xa, 1b, x2, 396,0)

inst_120:
// rs1_val==3 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xfffe; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xfffe, 0x4, 1b, x2, 400,0)

inst_121:
// rs1_val==3 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x55555556; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x55555556, 0x6, 1b, x2, 404,0)

inst_122:
// rs1_val==3 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xaaaaaaab, 0x4, 3f, x2, 408,0)

inst_123:
// rs1_val==3 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x6; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x6, 0x400, 1b, x2, 412,0)

inst_124:
// rs1_val==3 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x33333334; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x33333334, 0xa, 1b, x2, 416,0)

inst_125:
// rs1_val==3 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x66666667; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x66666667, 0x40, 3f, x2, 420,0)

inst_126:
// rs1_val==3 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xb505; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0xb505, 0x400, 3f, x2, 424,0)

inst_127:
// rs1_val==3 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x1; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x1, 0x6, 1b, x2, 428,0)

inst_128:
// rs1_val==3 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x10000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x3, 0x10000, 0x8, 1b, x2, 432,0)

inst_129:
// rs1_val==1431655765 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x3; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x3, 0x10, 3f, x2, 436,0)

inst_130:
// rs1_val==1431655765 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x55555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x55555555, 0x2, 3f, x2, 440,0)

inst_131:
// rs1_val==1431655765 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xaaaaaaaa; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xaaaaaaaa, 0x400, 1b, x2, 444,0)

inst_132:
// rs1_val==1431655765 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x5; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x5, 0x8, 1b, x2, 448,0)

inst_133:
// rs1_val==1431655765 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x33333333; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x33333333, 0x0, 1b, x2, 452,0)

inst_134:
// rs1_val==1431655765 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x66666666; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x66666666, 0x20, 3f, x2, 456,0)

inst_135:
// rs1_val==1431655765 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xb504; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xb504, 0x4, 1b, x2, 460,0)

inst_136:
// rs1_val==1431655765 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x0, 0x4, 1b, x2, 464,0)

inst_137:
// rs1_val==1431655765 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xffff; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xffff, 0x40, 3f, x2, 468,0)

inst_138:
// rs1_val==1431655765 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x2; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x2, 0x8, 3f, x2, 472,0)

inst_139:
// rs1_val==1431655765 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x55555554; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x55555554, 0x0, 1b, x2, 476,0)

inst_140:
// rs1_val==1431655765 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xaaaaaaa9; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xaaaaaaa9, 0x8, 3f, x2, 480,0)

inst_141:
// rs1_val==1431655765 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x4; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x4, 0x20, 3f, x2, 484,0)

inst_142:
// rs1_val==1431655765 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x33333332; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x33333332, 0x10, 3f, x2, 488,0)

inst_143:
// rs1_val==1431655765 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x66666665; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x66666665, 0x10, 3f, x2, 492,0)

inst_144:
// rs1_val==1431655765 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xb503; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xb503, 0x4, 3f, x2, 496,0)

inst_145:
// rs1_val==1431655765 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xfffe; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xfffe, 0x2, 3f, x2, 500,0)

inst_146:
// rs1_val==1431655765 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x55555556; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x55555556, 0x2, 3f, x2, 504,0)

inst_147:
// rs1_val==1431655765 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xaaaaaaab; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xaaaaaaab, 0x400, 1b, x2, 508,0)

inst_148:
// rs1_val==1431655765 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x6; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x6, 0x400, 3f, x2, 512,0)

inst_149:
// rs1_val==1431655765 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x33333334; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x33333334, 0x40, 3f, x2, 516,0)

inst_150:
// rs1_val==1431655765 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x66666667; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x66666667, 0x20, 3f, x2, 520,0)

inst_151:
// rs1_val==1431655765 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0xb505; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0xb505, 0x556, 1b, x2, 524,0)

inst_152:
// rs1_val==1431655765 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x1; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x1, 0x200, 3f, x2, 528,0)

inst_153:
// rs1_val==1431655765 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555555; op2val:0x10000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555555, 0x10000, 0x6, 1b, x2, 532,0)

inst_154:
// rs1_val==2863311530 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x3, 0x8, 1b, x2, 536,0)

inst_155:
// rs1_val==2863311530 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x55555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x55555555, 0x2, 1b, x2, 540,0)

inst_156:
// rs1_val==2863311530 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0xaaaaaaaa; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0xaaaaaaaa, 0x2, 3f, x2, 544,0)

inst_157:
// rs1_val==2863311530 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x5; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x5, 0x556, 1b, x2, 548,0)

inst_158:
// rs1_val==2863311530 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x33333333; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x33333333, 0x200, 3f, x2, 552,0)

inst_159:
// rs1_val==2863311530 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x66666666; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x66666666, 0x400, 3f, x2, 556,0)

inst_160:
// rs1_val==2863311530 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0xb504; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0xb504, 0x200, 3f, x2, 560,0)

inst_161:
// rs1_val==2863311530 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x0; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x0, 0x100, 3f, x2, 564,0)

inst_162:
// rs1_val==2863311530 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0xffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0xffff, 0x10, 3f, x2, 568,0)

inst_163:
// rs1_val==2863311530 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x55555554; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x55555554, 0x2, 1b, x2, 572,0)

inst_164:
// rs1_val==2863311530 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0xaaaaaaa9; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0xaaaaaaa9, 0x400, 1b, x2, 576,0)

inst_165:
// rs1_val==2863311530 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x4; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x4, 0x0, 3f, x2, 580,0)

inst_166:
// rs1_val==2863311530 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x33333332; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x33333332, 0x556, 1b, x2, 584,0)

inst_167:
// rs1_val==2863311530 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x66666665; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x66666665, 0x20, 3f, x2, 588,0)

inst_168:
// rs1_val==2863311530 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0xb503; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0xb503, 0x556, 1b, x2, 592,0)

inst_169:
// rs1_val==2863311530 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0xfffe; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0xfffe, 0x40, 3f, x2, 596,0)

inst_170:
// rs1_val==2863311530 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x55555556; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x55555556, 0x556, 1b, x2, 600,0)

inst_171:
// rs1_val==2863311530 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0xaaaaaaab; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0xaaaaaaab, 0x200, 3f, x2, 604,0)

inst_172:
// rs1_val==2863311530 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x6; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x6, 0x80, 3f, x2, 608,0)

inst_173:
// rs1_val==2863311530 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x33333334; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x33333334, 0xa, 1b, x2, 612,0)

inst_174:
// rs1_val==2863311530 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x66666667; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x66666667, 0x8, 3f, x2, 616,0)

inst_175:
// rs1_val==2863311530 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0xb505; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0xb505, 0x200, 3f, x2, 620,0)

inst_176:
// rs1_val==2863311530 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x1; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x1, 0x2, 3f, x2, 624,0)

inst_177:
// rs1_val==2863311530 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaa; op2val:0x10000; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaaa, 0x10000, 0x20, 3f, x2, 628,0)

inst_178:
// rs1_val==5 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x3, 0x8, 3f, x2, 632,0)

inst_179:
// rs1_val==5 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x55555555; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x55555555, 0x100, 3f, x2, 636,0)

inst_180:
// rs1_val==5 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xaaaaaaaa; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xaaaaaaaa, 0x0, 3f, x2, 640,0)

inst_181:
// rs1_val==5 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x5; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x5, 0x6, 3f, x2, 644,0)

inst_182:
// rs1_val==5 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x33333333; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x33333333, 0x100, 3f, x2, 648,0)

inst_183:
// rs1_val==5 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x66666666; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x66666666, 0x8, 1b, x2, 652,0)

inst_184:
// rs1_val==5 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xb504; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xb504, 0x10, 3f, x2, 656,0)

inst_185:
// rs1_val==5 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x0; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x0, 0x0, 1b, x2, 660,0)

inst_186:
// rs1_val==5 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xffff, 0x556, 1b, x2, 664,0)

inst_187:
// rs1_val==5 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x2; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x2, 0x80, 3f, x2, 668,0)

inst_188:
// rs1_val==5 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x55555554; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x55555554, 0x556, 1b, x2, 672,0)

inst_189:
// rs1_val==5 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xaaaaaaa9; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xaaaaaaa9, 0x6, 1b, x2, 676,0)

inst_190:
// rs1_val==5 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x4; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x4, 0x0, 1b, x2, 680,0)

inst_191:
// rs1_val==5 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x33333332; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x33333332, 0x6, 3f, x2, 684,0)

inst_192:
// rs1_val==5 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x66666665; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x66666665, 0x400, 3f, x2, 688,0)

inst_193:
// rs1_val==5 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xb503; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xb503, 0x80, 3f, x2, 692,0)

inst_194:
// rs1_val==5 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xfffe; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xfffe, 0x2, 1b, x2, 696,0)

inst_195:
// rs1_val==5 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x55555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x55555556, 0x400, 3f, x2, 700,0)

inst_196:
// rs1_val==5 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xaaaaaaab, 0x4, 3f, x2, 704,0)

inst_197:
// rs1_val==5 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x6, 0x4, 3f, x2, 708,0)

inst_198:
// rs1_val==5 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x33333334; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x33333334, 0x8, 3f, x2, 712,0)

inst_199:
// rs1_val==5 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x66666667; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x66666667, 0x40, 3f, x2, 716,0)

inst_200:
// rs1_val==5 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xb505; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0xb505, 0x20, 3f, x2, 720,0)

inst_201:
// rs1_val==5 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x1; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x1, 0x100, 3f, x2, 724,0)

inst_202:
// rs1_val==5 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x10000; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x5, 0x10000, 0x80, 3f, x2, 728,0)

inst_203:
// rs1_val==858993459 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x3; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x3, 0x400, 1b, x2, 732,0)

inst_204:
// rs1_val==858993459 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x55555555; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x55555555, 0x100, 3f, x2, 736,0)

inst_205:
// rs1_val==858993459 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0xaaaaaaaa; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0xaaaaaaaa, 0x6, 3f, x2, 740,0)

inst_206:
// rs1_val==858993459 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x5; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x5, 0x100, 3f, x2, 744,0)

inst_207:
// rs1_val==858993459 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x33333333; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x33333333, 0x2, 3f, x2, 748,0)

inst_208:
// rs1_val==858993459 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x66666666; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x66666666, 0x20, 3f, x2, 752,0)

inst_209:
// rs1_val==858993459 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0xb504; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0xb504, 0x100, 3f, x2, 756,0)

inst_210:
// rs1_val==858993459 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x0; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x0, 0x400, 3f, x2, 760,0)

inst_211:
// rs1_val==858993459 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0xffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0xffff, 0x400, 1b, x2, 764,0)

inst_212:
// rs1_val==858993459 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x2; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x2, 0x10, 3f, x2, 768,0)

inst_213:
// rs1_val==858993459 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x55555554; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x55555554, 0x2, 3f, x2, 772,0)

inst_214:
// rs1_val==858993459 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0xaaaaaaa9; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0xaaaaaaa9, 0x400, 3f, x2, 776,0)

inst_215:
// rs1_val==858993459 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x4; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x4, 0x2, 1b, x2, 780,0)

inst_216:
// rs1_val==858993459 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x33333332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x33333332, 0x8, 3f, x2, 784,0)

inst_217:
// rs1_val==858993459 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x66666665; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x66666665, 0x556, 1b, x2, 788,0)

inst_218:
// rs1_val==858993459 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0xb503; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0xb503, 0x0, 3f, x2, 792,0)

inst_219:
// rs1_val==858993459 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0xfffe; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0xfffe, 0x8, 3f, x2, 796,0)

inst_220:
// rs1_val==858993459 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x55555556; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x55555556, 0x20, 3f, x2, 800,0)

inst_221:
// rs1_val==858993459 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0xaaaaaaab; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0xaaaaaaab, 0x400, 1b, x2, 804,0)

inst_222:
// rs1_val==858993459 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x6; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x6, 0x8, 3f, x2, 808,0)

inst_223:
// rs1_val==858993459 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x33333334; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x33333334, 0x10, 3f, x2, 812,0)

inst_224:
// rs1_val==858993459 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x66666667; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x66666667, 0x40, 3f, x2, 816,0)

inst_225:
// rs1_val==858993459 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0xb505; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0xb505, 0x40, 3f, x2, 820,0)

inst_226:
// rs1_val==858993459 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x1; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x1, 0x10, 3f, x2, 824,0)

inst_227:
// rs1_val==858993459 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333333; op2val:0x10000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333333, 0x10000, 0x6, 1b, x2, 828,0)

inst_228:
// rs1_val==1717986918 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x3; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x3, 0x6, 1b, x2, 832,0)

inst_229:
// rs1_val==1717986918 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x55555555; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x55555555, 0x4, 3f, x2, 836,0)

inst_230:
// rs1_val==1717986918 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0xaaaaaaaa; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0xaaaaaaaa, 0x0, 3f, x2, 840,0)

inst_231:
// rs1_val==1717986918 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x5; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x5, 0x10, 3f, x2, 844,0)

inst_232:
// rs1_val==1717986918 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x33333333; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x33333333, 0x40, 3f, x2, 848,0)

inst_233:
// rs1_val==1717986918 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x66666666; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x66666666, 0x8, 1b, x2, 852,0)

inst_234:
// rs1_val==1717986918 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0xb504; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0xb504, 0x556, 1b, x2, 856,0)

inst_235:
// rs1_val==1717986918 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x0, 0x4, 3f, x2, 860,0)

inst_236:
// rs1_val==1717986918 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0xffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0xffff, 0x4, 3f, x2, 864,0)

inst_237:
// rs1_val==1717986918 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x2; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x2, 0x8, 1b, x2, 868,0)

inst_238:
// rs1_val==1717986918 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x55555554; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x55555554, 0x4, 1b, x2, 872,0)

inst_239:
// rs1_val==1717986918 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0xaaaaaaa9; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0xaaaaaaa9, 0x400, 3f, x2, 876,0)

inst_240:
// rs1_val==1717986918 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x4; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x4, 0x8, 1b, x2, 880,0)

inst_241:
// rs1_val==1717986918 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x33333332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x33333332, 0x8, 3f, x2, 884,0)

inst_242:
// rs1_val==1717986918 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x66666665; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x66666665, 0x2, 3f, x2, 888,0)

inst_243:
// rs1_val==1717986918 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0xb503; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0xb503, 0x200, 3f, x2, 892,0)

inst_244:
// rs1_val==1717986918 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0xfffe; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0xfffe, 0x4, 3f, x2, 896,0)

inst_245:
// rs1_val==1717986918 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x55555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x55555556, 0x400, 1b, x2, 900,0)

inst_246:
// rs1_val==1717986918 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0xaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0xaaaaaaab, 0x4, 3f, x2, 904,0)

inst_247:
// rs1_val==1717986918 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x6; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x6, 0x200, 3f, x2, 908,0)

inst_248:
// rs1_val==1717986918 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x33333334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x33333334, 0x4, 1b, x2, 912,0)

inst_249:
// rs1_val==1717986918 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x66666667; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x66666667, 0x10, 3f, x2, 916,0)

inst_250:
// rs1_val==1717986918 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0xb505; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0xb505, 0xa, 1b, x2, 920,0)

inst_251:
// rs1_val==1717986918 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x1, 0x8, 1b, x2, 924,0)

inst_252:
// rs1_val==1717986918 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666666; op2val:0x10000; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666666, 0x10000, 0x100, 3f, x2, 928,0)

inst_253:
// rs1_val==46340 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x3; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x3, 0x2, 3f, x2, 932,0)

inst_254:
// rs1_val==46340 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x55555555; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x55555555, 0x40, 3f, x2, 936,0)

inst_255:
// rs1_val==46340 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0xaaaaaaaa; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0xaaaaaaaa, 0x2, 3f, x2, 940,0)

inst_256:
// rs1_val==46340 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x5; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x5, 0x20, 3f, x2, 944,0)

inst_257:
// rs1_val==46340 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x33333333; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x33333333, 0x200, 3f, x2, 948,0)

inst_258:
// rs1_val==46340 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x66666666; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x66666666, 0x6, 3f, x2, 952,0)

inst_259:
// rs1_val==46340 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0xb504; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0xb504, 0x0, 3f, x2, 956,0)

inst_260:
// rs1_val==46340 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x0; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x0, 0x0, 1b, x2, 960,0)

inst_261:
// rs1_val==46340 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0xffff; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0xffff, 0x20, 3f, x2, 964,0)

inst_262:
// rs1_val==46340 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x2; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x2, 0x4, 3f, x2, 968,0)

inst_263:
// rs1_val==46340 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x55555554; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x55555554, 0x400, 3f, x2, 972,0)

inst_264:
// rs1_val==46340 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0xaaaaaaa9; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0xaaaaaaa9, 0x400, 3f, x2, 976,0)

inst_265:
// rs1_val==46340 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x4; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x4, 0x0, 1b, x2, 980,0)

inst_266:
// rs1_val==46340 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x33333332; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x33333332, 0x556, 1b, x2, 984,0)

inst_267:
// rs1_val==46340 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x66666665; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x66666665, 0x6, 1b, x2, 988,0)

inst_268:
// rs1_val==46340 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0xb503; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0xb503, 0x2, 1b, x2, 992,0)

inst_269:
// rs1_val==46340 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0xfffe; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0xfffe, 0x6, 3f, x2, 996,0)

inst_270:
// rs1_val==46340 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x55555556; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x55555556, 0x80, 3f, x2, 1000,0)

inst_271:
// rs1_val==46340 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0xaaaaaaab; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0xaaaaaaab, 0x6, 1b, x2, 1004,0)

inst_272:
// rs1_val==46340 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x6; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x6, 0x8, 1b, x2, 1008,0)

inst_273:
// rs1_val==46340 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x33333334; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x33333334, 0x0, 1b, x2, 1012,0)

inst_274:
// rs1_val==46340 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x66666667; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x66666667, 0x4, 1b, x2, 1016,0)

inst_275:
// rs1_val==46340 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0xb505; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0xb505, 0x6, 3f, x2, 1020,0)

inst_276:
// rs1_val==46340 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x1; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x1, 0x10, 3f, x2, 1024,0)

inst_277:
// rs1_val==46340 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504; op2val:0x10000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb504, 0x10000, 0x2, 1b, x2, 1028,0)

inst_278:
// rs1_val==0 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x3; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x3, 0x2, 1b, x2, 1032,0)

inst_279:
// rs1_val==0 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x55555555; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x55555555, 0xa, 1b, x2, 1036,0)

inst_280:
// rs1_val==0 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xaaaaaaaa; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0xaaaaaaaa, 0x4, 3f, x2, 1040,0)

inst_281:
// rs1_val==0 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x5; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x5, 0x4, 3f, x2, 1044,0)

inst_282:
// rs1_val==0 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x33333333; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x33333333, 0xa, 1b, x2, 1048,0)

inst_283:
// rs1_val==0 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x66666666; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x66666666, 0x556, 1b, x2, 1052,0)

inst_284:
// rs1_val==0 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xb504; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0xb504, 0x8, 3f, x2, 1056,0)

inst_285:
// rs1_val==0 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x0; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x0, 0x80, 3f, x2, 1060,0)

inst_286:
// rs1_val==0 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0xffff, 0x2, 1b, x2, 1064,0)

inst_287:
// rs1_val==0 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x2; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x2, 0x8, 1b, x2, 1068,0)

inst_288:
// rs1_val==0 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x55555554; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x55555554, 0x100, 3f, x2, 1072,0)

inst_289:
// rs1_val==0 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xaaaaaaa9; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0xaaaaaaa9, 0x2, 3f, x2, 1076,0)

inst_290:
// rs1_val==0 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x4; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x4, 0x20, 3f, x2, 1080,0)

inst_291:
// rs1_val==0 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x33333332; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x33333332, 0x400, 1b, x2, 1084,0)

inst_292:
// rs1_val==0 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x66666665; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x66666665, 0x80, 3f, x2, 1088,0)

inst_293:
// rs1_val==0 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xb503; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0xb503, 0x10, 3f, x2, 1092,0)

inst_294:
// rs1_val==0 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xfffe; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0xfffe, 0xa, 1b, x2, 1096,0)

inst_295:
// rs1_val==0 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x55555556; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x55555556, 0x80, 3f, x2, 1100,0)

inst_296:
// rs1_val==0 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0xaaaaaaab, 0x4, 1b, x2, 1104,0)

inst_297:
// rs1_val==0 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x6; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x6, 0x2, 3f, x2, 1108,0)

inst_298:
// rs1_val==0 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x33333334; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x33333334, 0x556, 1b, x2, 1112,0)

inst_299:
// rs1_val==0 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x66666667; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x66666667, 0x0, 1b, x2, 1116,0)

inst_300:
// rs1_val==0 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xb505; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0xb505, 0x6, 1b, x2, 1120,0)

inst_301:
// rs1_val==0 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x1; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x1, 0x400, 1b, x2, 1124,0)

inst_302:
// rs1_val==0 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x10000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x0, 0x10000, 0x6, 3f, x2, 1128,0)

inst_303:
// rs1_val==65535 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x3; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x3, 0x2, 3f, x2, 1132,0)

inst_304:
// rs1_val==65535 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x55555555; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x55555555, 0x40, 3f, x2, 1136,0)

inst_305:
// rs1_val==65535 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0xaaaaaaaa; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0xaaaaaaaa, 0x2, 1b, x2, 1140,0)

inst_306:
// rs1_val==65535 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x5; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x5, 0x6, 1b, x2, 1144,0)

inst_307:
// rs1_val==65535 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x33333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x33333333, 0x6, 1b, x2, 1148,0)

inst_308:
// rs1_val==65535 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x66666666; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x66666666, 0x40, 3f, x2, 1152,0)

inst_309:
// rs1_val==65535 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0xb504; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0xb504, 0x400, 3f, x2, 1156,0)

inst_310:
// rs1_val==65535 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x0; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x0, 0x556, 1b, x2, 1160,0)

inst_311:
// rs1_val==65535 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x2, 0x400, 3f, x2, 1164,0)

inst_312:
// rs1_val==65535 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x55555554; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x55555554, 0x4, 1b, x2, 1168,0)

inst_313:
// rs1_val==65535 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0xaaaaaaa9; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0xaaaaaaa9, 0x100, 3f, x2, 1172,0)

inst_314:
// rs1_val==65535 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x4; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x4, 0x400, 1b, x2, 1176,0)

inst_315:
// rs1_val==65535 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x33333332; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x33333332, 0x556, 1b, x2, 1180,0)

inst_316:
// rs1_val==65535 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x66666665; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x66666665, 0x2, 1b, x2, 1184,0)

inst_317:
// rs1_val==65535 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0xb503; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0xb503, 0x556, 1b, x2, 1188,0)

inst_318:
// rs1_val==65535 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0xfffe; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0xfffe, 0x80, 3f, x2, 1192,0)

inst_319:
// rs1_val==65535 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x55555556; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x55555556, 0x200, 3f, x2, 1196,0)

inst_320:
// rs1_val==65535 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0xaaaaaaab; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0xaaaaaaab, 0x2, 1b, x2, 1200,0)

inst_321:
// rs1_val==65535 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x6; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x6, 0x200, 3f, x2, 1204,0)

inst_322:
// rs1_val==65535 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x33333334; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x33333334, 0x8, 3f, x2, 1208,0)

inst_323:
// rs1_val==65535 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x66666667; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x66666667, 0x6, 3f, x2, 1212,0)

inst_324:
// rs1_val==65535 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0xb505; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0xb505, 0x8, 1b, x2, 1216,0)

inst_325:
// rs1_val==65535 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x1, 0x8, 1b, x2, 1220,0)

inst_326:
// rs1_val==65535 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff; op2val:0x10000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xffff, 0x10000, 0x0, 3f, x2, 1224,0)

inst_327:
// rs1_val==2 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x3, 0x8, 3f, x2, 1228,0)

inst_328:
// rs1_val==2 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x55555555; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x55555555, 0x8, 1b, x2, 1232,0)

inst_329:
// rs1_val==2 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xaaaaaaaa; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xaaaaaaaa, 0x400, 1b, x2, 1236,0)

inst_330:
// rs1_val==2 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x5; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x5, 0x10, 3f, x2, 1240,0)

inst_331:
// rs1_val==2 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x33333333; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x33333333, 0x556, 1b, x2, 1244,0)

inst_332:
// rs1_val==2 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x66666666; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x66666666, 0x8, 1b, x2, 1248,0)

inst_333:
// rs1_val==2 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xb504; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xb504, 0x400, 1b, x2, 1252,0)

inst_334:
// rs1_val==2 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x0; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x0, 0x6, 3f, x2, 1256,0)

inst_335:
// rs1_val==2 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xffff, 0x2, 3f, x2, 1260,0)

inst_336:
// rs1_val==2 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x2, 0x400, 1b, x2, 1264,0)

inst_337:
// rs1_val==2 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x55555554; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x55555554, 0x80, 3f, x2, 1268,0)

inst_338:
// rs1_val==2 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xaaaaaaa9; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xaaaaaaa9, 0x200, 3f, x2, 1272,0)

inst_339:
// rs1_val==2 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x4; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x4, 0x40, 3f, x2, 1276,0)

inst_340:
// rs1_val==2 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x33333332; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x33333332, 0x0, 3f, x2, 1280,0)

inst_341:
// rs1_val==2 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x66666665; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x66666665, 0x40, 3f, x2, 1284,0)

inst_342:
// rs1_val==2 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xb503; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xb503, 0x8, 3f, x2, 1288,0)

inst_343:
// rs1_val==2 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xfffe; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xfffe, 0x80, 3f, x2, 1292,0)

inst_344:
// rs1_val==2 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x55555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x55555556, 0x400, 1b, x2, 1296,0)

inst_345:
// rs1_val==2 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xaaaaaaab; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xaaaaaaab, 0x2, 1b, x2, 1300,0)

inst_346:
// rs1_val==2 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x6; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x6, 0x0, 1b, x2, 1304,0)

inst_347:
// rs1_val==2 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x33333334; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x33333334, 0x0, 3f, x2, 1308,0)

inst_348:
// rs1_val==2 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x66666667; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x66666667, 0x8, 1b, x2, 1312,0)

inst_349:
// rs1_val==2 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xb505; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0xb505, 0x8, 1b, x2, 1316,0)

inst_350:
// rs1_val==2 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x1; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x1, 0x10, 3f, x2, 1320,0)

inst_351:
// rs1_val==2 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x10000; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x2, 0x10000, 0x100, 3f, x2, 1324,0)

inst_352:
// rs1_val==1431655764 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x3; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x3, 0x10, 3f, x2, 1328,0)

inst_353:
// rs1_val==1431655764 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x55555555; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x55555555, 0x20, 3f, x2, 1332,0)

inst_354:
// rs1_val==1431655764 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0xaaaaaaaa; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0xaaaaaaaa, 0x2, 3f, x2, 1336,0)

inst_355:
// rs1_val==1431655764 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x5; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x5, 0xa, 1b, x2, 1340,0)

inst_356:
// rs1_val==1431655764 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x33333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x33333333, 0x6, 3f, x2, 1344,0)

inst_357:
// rs1_val==1431655764 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x66666666; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x66666666, 0x100, 3f, x2, 1348,0)

inst_358:
// rs1_val==1431655764 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0xb504; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0xb504, 0x20, 3f, x2, 1352,0)

inst_359:
// rs1_val==1431655764 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x0; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x0, 0x400, 3f, x2, 1356,0)

inst_360:
// rs1_val==1431655764 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0xffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0xffff, 0x8, 3f, x2, 1360,0)

inst_361:
// rs1_val==1431655764 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x2; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x2, 0x20, 3f, x2, 1364,0)

inst_362:
// rs1_val==1431655764 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x55555554; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x55555554, 0x6, 3f, x2, 1368,0)

inst_363:
// rs1_val==1431655764 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0xaaaaaaa9; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0xaaaaaaa9, 0x8, 1b, x2, 1372,0)

inst_364:
// rs1_val==1431655764 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x4; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x4, 0x400, 3f, x2, 1376,0)

inst_365:
// rs1_val==1431655764 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x33333332; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x33333332, 0x400, 1b, x2, 1380,0)

inst_366:
// rs1_val==1431655764 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x66666665; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x66666665, 0x2, 1b, x2, 1384,0)

inst_367:
// rs1_val==1431655764 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0xb503; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0xb503, 0x20, 3f, x2, 1388,0)

inst_368:
// rs1_val==1431655764 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0xfffe; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0xfffe, 0x40, 3f, x2, 1392,0)

inst_369:
// rs1_val==1431655764 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x55555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x55555556, 0x400, 3f, x2, 1396,0)

inst_370:
// rs1_val==1431655764 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0xaaaaaaab; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0xaaaaaaab, 0x200, 3f, x2, 1400,0)

inst_371:
// rs1_val==1431655764 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x6; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x6, 0x8, 1b, x2, 1404,0)

inst_372:
// rs1_val==1431655764 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x33333334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x33333334, 0x4, 3f, x2, 1408,0)

inst_373:
// rs1_val==1431655764 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x66666667; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x66666667, 0x2, 3f, x2, 1412,0)

inst_374:
// rs1_val==1431655764 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0xb505; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0xb505, 0x80, 3f, x2, 1416,0)

inst_375:
// rs1_val==1431655764 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x1; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x1, 0x0, 3f, x2, 1420,0)

inst_376:
// rs1_val==1431655764 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555554; op2val:0x10000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555554, 0x10000, 0x8, 1b, x2, 1424,0)

inst_377:
// rs1_val==2863311529 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x3; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x3, 0xa, 1b, x2, 1428,0)

inst_378:
// rs1_val==2863311529 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x55555555; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x55555555, 0x10, 3f, x2, 1432,0)

inst_379:
// rs1_val==2863311529 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xaaaaaaaa; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xaaaaaaaa, 0x8, 1b, x2, 1436,0)

inst_380:
// rs1_val==2863311529 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x5; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x5, 0x0, 1b, x2, 1440,0)

inst_381:
// rs1_val==2863311529 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x33333333; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x33333333, 0x200, 3f, x2, 1444,0)

inst_382:
// rs1_val==2863311529 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x66666666; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x66666666, 0x6, 3f, x2, 1448,0)

inst_383:
// rs1_val==2863311529 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xb504; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xb504, 0x400, 3f, x2, 1452,0)

inst_384:
// rs1_val==2863311529 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x0; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x0, 0x6, 1b, x2, 1456,0)

inst_385:
// rs1_val==2863311529 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xffff, 0x2, 3f, x2, 1460,0)

inst_386:
// rs1_val==2863311529 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x2; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x2, 0x556, 1b, x2, 1464,0)

inst_387:
// rs1_val==2863311529 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x55555554; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x55555554, 0x0, 3f, x2, 1468,0)

inst_388:
// rs1_val==2863311529 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xaaaaaaa9; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xaaaaaaa9, 0x4, 1b, x2, 1472,0)

inst_389:
// rs1_val==2863311529 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x4; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x4, 0x200, 3f, x2, 1476,0)

inst_390:
// rs1_val==2863311529 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x33333332; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x33333332, 0x40, 3f, x2, 1480,0)

inst_391:
// rs1_val==2863311529 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x66666665; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x66666665, 0x556, 1b, x2, 1484,0)

inst_392:
// rs1_val==2863311529 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xb503; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xb503, 0x80, 3f, x2, 1488,0)

inst_393:
// rs1_val==2863311529 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xfffe; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xfffe, 0x20, 3f, x2, 1492,0)

inst_394:
// rs1_val==2863311529 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x55555556; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x55555556, 0x20, 3f, x2, 1496,0)

inst_395:
// rs1_val==2863311529 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xaaaaaaab; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xaaaaaaab, 0x10, 3f, x2, 1500,0)

inst_396:
// rs1_val==2863311529 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x6; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x6, 0x6, 1b, x2, 1504,0)

inst_397:
// rs1_val==2863311529 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x33333334; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x33333334, 0x20, 3f, x2, 1508,0)

inst_398:
// rs1_val==2863311529 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x66666667; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x66666667, 0x400, 3f, x2, 1512,0)

inst_399:
// rs1_val==2863311529 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0xb505; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0xb505, 0x400, 3f, x2, 1516,0)

inst_400:
// rs1_val==2863311529 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaa9; op2val:0x10000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaa9, 0x10000, 0x556, 1b, x2, 1520,0)

inst_401:
// rs1_val==4 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x3; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x3, 0x0, 1b, x2, 1524,0)

inst_402:
// rs1_val==4 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x55555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x55555555, 0x2, 3f, x2, 1528,0)

inst_403:
// rs1_val==4 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xaaaaaaaa; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xaaaaaaaa, 0x80, 3f, x2, 1532,0)

inst_404:
// rs1_val==4 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x5; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x5, 0x400, 1b, x2, 1536,0)

inst_405:
// rs1_val==4 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x33333333; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x33333333, 0x100, 3f, x2, 1540,0)

inst_406:
// rs1_val==4 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x66666666; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x66666666, 0x200, 3f, x2, 1544,0)

inst_407:
// rs1_val==4 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xb504; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xb504, 0x0, 1b, x2, 1548,0)

inst_408:
// rs1_val==4 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x0; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x0, 0x200, 3f, x2, 1552,0)

inst_409:
// rs1_val==4 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xffff; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xffff, 0x20, 3f, x2, 1556,0)

inst_410:
// rs1_val==4 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x2; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x2, 0x4, 3f, x2, 1560,0)

inst_411:
// rs1_val==4 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x55555554; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x55555554, 0x6, 3f, x2, 1564,0)

inst_412:
// rs1_val==4 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xaaaaaaa9; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xaaaaaaa9, 0x80, 3f, x2, 1568,0)

inst_413:
// rs1_val==4 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x4; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x4, 0x556, 1b, x2, 1572,0)

inst_414:
// rs1_val==4 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x33333332; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x33333332, 0x6, 3f, x2, 1576,0)

inst_415:
// rs1_val==4 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x66666665; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x66666665, 0x0, 3f, x2, 1580,0)

inst_416:
// rs1_val==4 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xb503; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xb503, 0xa, 1b, x2, 1584,0)

inst_417:
// rs1_val==4 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xfffe; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xfffe, 0x200, 3f, x2, 1588,0)

inst_418:
// rs1_val==4 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x55555556; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x55555556, 0x4, 1b, x2, 1592,0)

inst_419:
// rs1_val==4 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xaaaaaaab; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xaaaaaaab, 0x10, 3f, x2, 1596,0)

inst_420:
// rs1_val==4 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x6; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x6, 0x6, 3f, x2, 1600,0)

inst_421:
// rs1_val==4 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x33333334; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x33333334, 0x6, 1b, x2, 1604,0)

inst_422:
// rs1_val==4 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x66666667; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x66666667, 0x200, 3f, x2, 1608,0)

inst_423:
// rs1_val==4 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xb505; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0xb505, 0x0, 3f, x2, 1612,0)

inst_424:
// rs1_val==4 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x1; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x1, 0x6, 1b, x2, 1616,0)

inst_425:
// rs1_val==4 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x10000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x4, 0x10000, 0x200, 3f, x2, 1620,0)

inst_426:
// rs1_val==858993458 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x3; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x3, 0x4, 1b, x2, 1624,0)

inst_427:
// rs1_val==858993458 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x55555555; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x55555555, 0x6, 1b, x2, 1628,0)

inst_428:
// rs1_val==858993458 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0xaaaaaaaa; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0xaaaaaaaa, 0x8, 3f, x2, 1632,0)

inst_429:
// rs1_val==858993458 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x5; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x5, 0x8, 1b, x2, 1636,0)

inst_430:
// rs1_val==858993458 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x33333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x33333333, 0x6, 1b, x2, 1640,0)

inst_431:
// rs1_val==858993458 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x66666666; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x66666666, 0x4, 3f, x2, 1644,0)

inst_432:
// rs1_val==858993458 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0xb504; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0xb504, 0x40, 3f, x2, 1648,0)

inst_433:
// rs1_val==858993458 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x0, 0x4, 1b, x2, 1652,0)

inst_434:
// rs1_val==858993458 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0xffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0xffff, 0x2, 3f, x2, 1656,0)

inst_435:
// rs1_val==858993458 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x2, 0x400, 1b, x2, 1660,0)

inst_436:
// rs1_val==858993458 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x55555554; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x55555554, 0x4, 1b, x2, 1664,0)

inst_437:
// rs1_val==858993458 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0xaaaaaaa9; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0xaaaaaaa9, 0x0, 1b, x2, 1668,0)

inst_438:
// rs1_val==858993458 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x4; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x4, 0x0, 1b, x2, 1672,0)

inst_439:
// rs1_val==858993458 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x33333332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x33333332, 0x8, 3f, x2, 1676,0)

inst_440:
// rs1_val==858993458 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x66666665; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x66666665, 0x0, 1b, x2, 1680,0)

inst_441:
// rs1_val==858993458 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0xb503; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0xb503, 0x400, 3f, x2, 1684,0)

inst_442:
// rs1_val==858993458 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0xfffe; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0xfffe, 0x40, 3f, x2, 1688,0)

inst_443:
// rs1_val==858993458 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x55555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x55555556, 0x400, 1b, x2, 1692,0)

inst_444:
// rs1_val==858993458 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0xaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0xaaaaaaab, 0x4, 3f, x2, 1696,0)

inst_445:
// rs1_val==858993458 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x6, 0x4, 1b, x2, 1700,0)

inst_446:
// rs1_val==858993458 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x33333334; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x33333334, 0x20, 3f, x2, 1704,0)

inst_447:
// rs1_val==858993458 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x66666667; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x66666667, 0x6, 3f, x2, 1708,0)

inst_448:
// rs1_val==858993458 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0xb505; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0xb505, 0x20, 3f, x2, 1712,0)

inst_449:
// rs1_val==858993458 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x1; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x1, 0x100, 3f, x2, 1716,0)

inst_450:
// rs1_val==858993458 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333332; op2val:0x10000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333332, 0x10000, 0x556, 1b, x2, 1720,0)

inst_451:
// rs1_val==1717986917 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x3; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x3, 0x400, 3f, x2, 1724,0)

inst_452:
// rs1_val==1717986917 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x55555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x55555555, 0x2, 1b, x2, 1728,0)

inst_453:
// rs1_val==1717986917 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0xaaaaaaaa; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0xaaaaaaaa, 0x556, 1b, x2, 1732,0)

inst_454:
// rs1_val==1717986917 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x5; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x5, 0x6, 1b, x2, 1736,0)

inst_455:
// rs1_val==1717986917 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x33333333; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x33333333, 0x200, 3f, x2, 1740,0)

inst_456:
// rs1_val==1717986917 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x66666666; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x66666666, 0x556, 1b, x2, 1744,0)

inst_457:
// rs1_val==1717986917 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0xb504; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0xb504, 0x0, 1b, x2, 1748,0)

inst_458:
// rs1_val==1717986917 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x0; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x0, 0x400, 1b, x2, 1752,0)

inst_459:
// rs1_val==1717986917 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0xffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0xffff, 0x556, 1b, x2, 1756,0)

inst_460:
// rs1_val==1717986917 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x2; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x2, 0x556, 1b, x2, 1760,0)

inst_461:
// rs1_val==1717986917 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x55555554; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x55555554, 0x2, 1b, x2, 1764,0)

inst_462:
// rs1_val==1717986917 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0xaaaaaaa9; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0xaaaaaaa9, 0x0, 1b, x2, 1768,0)

inst_463:
// rs1_val==1717986917 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x4; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x4, 0x6, 3f, x2, 1772,0)

inst_464:
// rs1_val==1717986917 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x33333332; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x33333332, 0x200, 3f, x2, 1776,0)

inst_465:
// rs1_val==1717986917 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x66666665; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x66666665, 0x0, 3f, x2, 1780,0)

inst_466:
// rs1_val==1717986917 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0xb503; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0xb503, 0x6, 3f, x2, 1784,0)

inst_467:
// rs1_val==1717986917 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0xfffe; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0xfffe, 0x400, 3f, x2, 1788,0)

inst_468:
// rs1_val==1717986917 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x55555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x55555556, 0x400, 1b, x2, 1792,0)

inst_469:
// rs1_val==1717986917 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x1; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x1, 0x6, 3f, x2, 1796,0)

inst_470:
// rs1_val==1717986917 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x10000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x10000, 0x0, 3f, x2, 1800,0)

inst_471:
// rs1_val==46339 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x3; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x3, 0x200, 3f, x2, 1804,0)

inst_472:
// rs1_val==46339 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x55555555; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x55555555, 0x80, 3f, x2, 1808,0)

inst_473:
// rs1_val==46339 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xaaaaaaaa; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xaaaaaaaa, 0x10, 3f, x2, 1812,0)

inst_474:
// rs1_val==46339 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x5; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x5, 0x0, 3f, x2, 1816,0)

inst_475:
// rs1_val==46339 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x33333333; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x33333333, 0x556, 1b, x2, 1820,0)

inst_476:
// rs1_val==46339 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x66666666; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x66666666, 0x200, 3f, x2, 1824,0)

inst_477:
// rs1_val==46339 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xb504; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xb504, 0x6, 3f, x2, 1828,0)

inst_478:
// rs1_val==46339 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x0; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x0, 0x2, 1b, x2, 1832,0)

inst_479:
// rs1_val==46339 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xffff; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xffff, 0x80, 3f, x2, 1836,0)

inst_480:
// rs1_val==46339 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x2; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x2, 0x8, 3f, x2, 1840,0)

inst_481:
// rs1_val==46339 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x55555554; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x55555554, 0x100, 3f, x2, 1844,0)

inst_482:
// rs1_val==46339 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xaaaaaaa9; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xaaaaaaa9, 0x400, 3f, x2, 1848,0)

inst_483:
// rs1_val==46339 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x4; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x4, 0x100, 3f, x2, 1852,0)

inst_484:
// rs1_val==46339 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x33333332; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x33333332, 0x40, 3f, x2, 1856,0)

inst_485:
// rs1_val==46339 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x66666665; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x66666665, 0x0, 1b, x2, 1860,0)

inst_486:
// rs1_val==46339 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xb503; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xb503, 0x2, 3f, x2, 1864,0)

inst_487:
// rs1_val==46339 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xfffe; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xfffe, 0x4, 1b, x2, 1868,0)

inst_488:
// rs1_val==46339 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x55555556; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x55555556, 0x6, 3f, x2, 1872,0)

inst_489:
// rs1_val==46339 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xaaaaaaab; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xaaaaaaab, 0x2, 3f, x2, 1876,0)

inst_490:
// rs1_val==46339 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x6, 0x4, 1b, x2, 1880,0)

inst_491:
// rs1_val==46339 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x33333334; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x33333334, 0x40, 3f, x2, 1884,0)

inst_492:
// rs1_val==46339 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x66666667; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x66666667, 0x80, 3f, x2, 1888,0)

inst_493:
// rs1_val==46339 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0xb505; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0xb505, 0x6, 3f, x2, 1892,0)

inst_494:
// rs1_val==46339 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x1, 0x8, 1b, x2, 1896,0)

inst_495:
// rs1_val==46339 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb503; op2val:0x10000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb503, 0x10000, 0x0, 1b, x2, 1900,0)

inst_496:
// rs1_val==65534 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x3; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x3, 0x4, 1b, x2, 1904,0)

inst_497:
// rs1_val==65534 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x55555555; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x55555555, 0x10, 3f, x2, 1908,0)

inst_498:
// rs1_val==65534 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0xaaaaaaaa; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0xaaaaaaaa, 0x10, 3f, x2, 1912,0)

inst_499:
// rs1_val==65534 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x5; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x5, 0x0, 3f, x2, 1916,0)

inst_500:
// rs1_val==65534 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x33333333; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x33333333, 0x4, 1b, x2, 1920,0)

inst_501:
// rs1_val==65534 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x66666666; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x66666666, 0x4, 1b, x2, 1924,0)

inst_502:
// rs1_val==65534 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0xb504; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0xb504, 0x100, 3f, x2, 1928,0)

inst_503:
// rs1_val==65534 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x0; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x0, 0x100, 3f, x2, 1932,0)

inst_504:
// rs1_val==65534 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0xffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0xffff, 0x6, 3f, x2, 1936,0)

inst_505:
// rs1_val==65534 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x2; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x2, 0xa, 1b, x2, 1940,0)

inst_506:
// rs1_val==65534 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x55555554; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x55555554, 0x2, 1b, x2, 1944,0)

inst_507:
// rs1_val==65534 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0xaaaaaaa9; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0xaaaaaaa9, 0x80, 3f, x2, 1948,0)

inst_508:
// rs1_val==65534 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x4; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x4, 0x80, 3f, x2, 1952,0)

inst_509:
// rs1_val==65534 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x33333332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x33333332, 0x4, 1b, x2, 1956,0)

inst_510:
// rs1_val==65534 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x66666665; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x66666665, 0x8, 1b, x2, 1960,0)

inst_511:
// rs1_val==65534 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0xb503; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0xb503, 0x20, 3f, x2, 1964,0)

inst_512:
// rs1_val==65534 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0xfffe; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0xfffe, 0x400, 3f, x2, 1968,0)

inst_513:
// rs1_val==65534 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x55555556; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x55555556, 0x0, 1b, x2, 1972,0)

inst_514:
// rs1_val==65534 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0xaaaaaaab; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0xaaaaaaab, 0x80, 3f, x2, 1976,0)

inst_515:
// rs1_val==65534 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x6; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x6, 0x2, 1b, x2, 1980,0)

inst_516:
// rs1_val==65534 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x33333334; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x33333334, 0x100, 3f, x2, 1984,0)

inst_517:
// rs1_val==65534 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x66666667; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x66666667, 0x2, 1b, x2, 1988,0)

inst_518:
// rs1_val==65534 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0xb505; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0xb505, 0x0, 1b, x2, 1992,0)

inst_519:
// rs1_val==65534 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x1; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x1, 0x40, 3f, x2, 1996,0)

inst_520:
// rs1_val==65534 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffe; op2val:0x10000; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffe, 0x10000, 0x20, 3f, x2, 2000,0)

inst_521:
// rs1_val==1431655766 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x3, 0x8, 3f, x2, 2004,0)

inst_522:
// rs1_val==1431655766 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x55555555; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x55555555, 0x100, 3f, x2, 2008,0)

inst_523:
// rs1_val==1431655766 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0xaaaaaaaa; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0xaaaaaaaa, 0x6, 3f, x2, 2012,0)

inst_524:
// rs1_val==1431655766 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x5; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x5, 0x2, 1b, x2, 2016,0)

inst_525:
// rs1_val==1431655766 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x33333333; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x33333333, 0x20, 3f, x2, 2020,0)

inst_526:
// rs1_val==1431655766 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x66666666; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x66666666, 0x2, 3f, x2, 2024,0)

inst_527:
// rs1_val==1431655766 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0xb504; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0xb504, 0x6, 1b, x2, 2028,0)

inst_528:
// rs1_val==1431655766 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x0; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x0, 0x200, 3f, x2, 2032,0)

inst_529:
// rs1_val==1431655766 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0xffff; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0xffff, 0xa, 1b, x2, 2036,0)

inst_530:
// rs1_val==1431655766 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x2; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x2, 0x40, 3f, x2, 2040,0)

inst_531:
// rs1_val==1431655766 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x55555554; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x55555554, 0x20, 3f, x2, 2044,0)
RVTEST_SIGBASE( x2,signature_x2_1)

inst_532:
// rs1_val==1431655766 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0xaaaaaaa9; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0xaaaaaaa9, 0x40, 3f, x2, 0,0)

inst_533:
// rs1_val==1431655766 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x4; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x4, 0xa, 1b, x2, 4,0)

inst_534:
// rs1_val==1431655766 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x33333332; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x33333332, 0x80, 3f, x2, 8,0)

inst_535:
// rs1_val==1431655766 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x66666665; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x66666665, 0x200, 3f, x2, 12,0)

inst_536:
// rs1_val==1431655766 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0xb503; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0xb503, 0x8, 1b, x2, 16,0)

inst_537:
// rs1_val==1431655766 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0xfffe; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0xfffe, 0x10, 3f, x2, 20,0)

inst_538:
// rs1_val==1431655766 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x55555556; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x55555556, 0x0, 3f, x2, 24,0)

inst_539:
// rs1_val==1431655766 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0xaaaaaaab; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0xaaaaaaab, 0x556, 1b, x2, 28,0)

inst_540:
// rs1_val==1431655766 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x6; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x6, 0x6, 1b, x2, 32,0)

inst_541:
// rs1_val==1431655766 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x33333334; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x33333334, 0x200, 3f, x2, 36,0)

inst_542:
// rs1_val==1431655766 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x66666667; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x66666667, 0x2, 3f, x2, 40,0)

inst_543:
// rs1_val==1431655766 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0xb505; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0xb505, 0x0, 1b, x2, 44,0)

inst_544:
// rs1_val==1431655766 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x1; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x1, 0x0, 1b, x2, 48,0)

inst_545:
// rs1_val==1431655766 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x55555556; op2val:0x10000; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x55555556, 0x10000, 0x20, 3f, x2, 52,0)

inst_546:
// rs1_val==2863311531 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x3; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x3, 0x80, 3f, x2, 56,0)

inst_547:
// rs1_val==2863311531 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x55555555; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x55555555, 0x100, 3f, x2, 60,0)

inst_548:
// rs1_val==2863311531 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0xaaaaaaaa; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0xaaaaaaaa, 0x4, 3f, x2, 64,0)

inst_549:
// rs1_val==2863311531 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x5; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x5, 0x40, 3f, x2, 68,0)

inst_550:
// rs1_val==2863311531 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x33333333; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x33333333, 0x40, 3f, x2, 72,0)

inst_551:
// rs1_val==2863311531 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x66666666; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x66666666, 0x0, 3f, x2, 76,0)

inst_552:
// rs1_val==2863311531 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0xb504; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0xb504, 0x200, 3f, x2, 80,0)

inst_553:
// rs1_val==2863311531 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x0; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x0, 0x400, 1b, x2, 84,0)

inst_554:
// rs1_val==2863311531 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0xffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0xffff, 0x2, 1b, x2, 88,0)

inst_555:
// rs1_val==2863311531 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x2, 0x400, 3f, x2, 92,0)

inst_556:
// rs1_val==2863311531 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x55555554; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x55555554, 0x2, 1b, x2, 96,0)

inst_557:
// rs1_val==2863311531 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0xaaaaaaa9; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0xaaaaaaa9, 0x80, 3f, x2, 100,0)

inst_558:
// rs1_val==2863311531 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x33333332; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x33333332, 0x6, 3f, x2, 104,0)

inst_559:
// rs1_val==2863311531 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x66666665; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x66666665, 0x80, 3f, x2, 108,0)

inst_560:
// rs1_val==2863311531 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0xb503; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0xb503, 0x6, 1b, x2, 112,0)

inst_561:
// rs1_val==2863311531 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0xfffe; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0xfffe, 0x0, 1b, x2, 116,0)

inst_562:
// rs1_val==2863311531 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x55555556; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x55555556, 0xa, 1b, x2, 120,0)

inst_563:
// rs1_val==2863311531 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0xaaaaaaab; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0xaaaaaaab, 0x100, 3f, x2, 124,0)

inst_564:
// rs1_val==2863311531 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x6; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x6, 0xa, 1b, x2, 128,0)

inst_565:
// rs1_val==2863311531 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x33333334; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x33333334, 0x400, 3f, x2, 132,0)

inst_566:
// rs1_val==2863311531 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x66666667; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x66666667, 0x40, 3f, x2, 136,0)

inst_567:
// rs1_val==2863311531 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0xb505; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0xb505, 0xa, 1b, x2, 140,0)

inst_568:
// rs1_val==2863311531 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x1; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x1, 0x100, 3f, x2, 144,0)

inst_569:
// rs1_val==2863311531 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaab; op2val:0x10000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xaaaaaaab, 0x10000, 0x4, 3f, x2, 148,0)

inst_570:
// rs1_val==6 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x3, 0x8, 3f, x2, 152,0)

inst_571:
// rs1_val==6 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x55555555; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x55555555, 0x200, 3f, x2, 156,0)

inst_572:
// rs1_val==6 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xaaaaaaaa; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xaaaaaaaa, 0x4, 1b, x2, 160,0)

inst_573:
// rs1_val==6 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x5; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x5, 0x6, 3f, x2, 164,0)

inst_574:
// rs1_val==6 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x33333333; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x33333333, 0x8, 3f, x2, 168,0)

inst_575:
// rs1_val==6 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x66666666; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x66666666, 0x100, 3f, x2, 172,0)

inst_576:
// rs1_val==6 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xb504; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xb504, 0x6, 3f, x2, 176,0)

inst_577:
// rs1_val==6 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x0; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x0, 0x556, 1b, x2, 180,0)

inst_578:
// rs1_val==6 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xffff, 0x6, 3f, x2, 184,0)

inst_579:
// rs1_val==6 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x2; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x2, 0x6, 3f, x2, 188,0)

inst_580:
// rs1_val==6 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x55555554; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x55555554, 0x200, 3f, x2, 192,0)

inst_581:
// rs1_val==6 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xaaaaaaa9; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xaaaaaaa9, 0x4, 1b, x2, 196,0)

inst_582:
// rs1_val==6 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x4; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x4, 0xa, 1b, x2, 200,0)

inst_583:
// rs1_val==6 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x33333332; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x33333332, 0xa, 1b, x2, 204,0)

inst_584:
// rs1_val==6 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x66666665; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x66666665, 0x4, 1b, x2, 208,0)

inst_585:
// rs1_val==6 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xb503; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xb503, 0xa, 1b, x2, 212,0)

inst_586:
// rs1_val==6 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xfffe; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xfffe, 0x4, 1b, x2, 216,0)

inst_587:
// rs1_val==6 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x55555556; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x55555556, 0x4, 3f, x2, 220,0)

inst_588:
// rs1_val==6 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xaaaaaaab; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xaaaaaaab, 0x6, 3f, x2, 224,0)

inst_589:
// rs1_val==6 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x6, 0x4, 1b, x2, 228,0)

inst_590:
// rs1_val==6 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x33333334; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x33333334, 0x8, 3f, x2, 232,0)

inst_591:
// rs1_val==6 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x66666667; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x66666667, 0x0, 1b, x2, 236,0)

inst_592:
// rs1_val==6 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xb505; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0xb505, 0x6, 1b, x2, 240,0)

inst_593:
// rs1_val==6 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x1; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x1, 0x100, 3f, x2, 244,0)

inst_594:
// rs1_val==6 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x10000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x6, 0x10000, 0x6, 1b, x2, 248,0)

inst_595:
// rs1_val==858993460 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x3; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x3, 0x20, 3f, x2, 252,0)

inst_596:
// rs1_val==858993460 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x55555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x55555555, 0x2, 3f, x2, 256,0)

inst_597:
// rs1_val==1717986917 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0xaaaaaaab; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0xaaaaaaab, 0x2, 3f, x2, 260,0)

inst_598:
// rs1_val==858993460 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0xaaaaaaaa; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0xaaaaaaaa, 0x2, 1b, x2, 264,0)

inst_599:
// rs1_val==858993460 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x5; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x5, 0x400, 1b, x2, 268,0)

inst_600:
// rs1_val==858993460 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x33333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x33333333, 0x6, 1b, x2, 272,0)

inst_601:
// rs1_val==858993460 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x66666666; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x66666666, 0x40, 3f, x2, 276,0)

inst_602:
// rs1_val==858993460 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0xb504; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0xb504, 0x400, 1b, x2, 280,0)

inst_603:
// rs1_val==858993460 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x0; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x0, 0x200, 3f, x2, 284,0)

inst_604:
// rs1_val==858993460 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0xffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0xffff, 0x8, 3f, x2, 288,0)

inst_605:
// rs1_val==858993460 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x2; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x2, 0x6, 1b, x2, 292,0)

inst_606:
// rs1_val==858993460 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x55555554; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x55555554, 0x400, 3f, x2, 296,0)

inst_607:
// rs1_val==858993460 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0xaaaaaaa9; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0xaaaaaaa9, 0x400, 1b, x2, 300,0)

inst_608:
// rs1_val==858993460 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x4; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x4, 0x400, 3f, x2, 304,0)

inst_609:
// rs1_val==858993460 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x33333332; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x33333332, 0x2, 1b, x2, 308,0)

inst_610:
// rs1_val==858993460 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x66666665; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x66666665, 0x20, 3f, x2, 312,0)

inst_611:
// rs1_val==858993460 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0xb503; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0xb503, 0x200, 3f, x2, 316,0)

inst_612:
// rs1_val==858993460 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0xfffe; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0xfffe, 0xa, 1b, x2, 320,0)

inst_613:
// rs1_val==858993460 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x55555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x55555556, 0x400, 3f, x2, 324,0)

inst_614:
// rs1_val==858993460 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0xaaaaaaab; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0xaaaaaaab, 0x80, 3f, x2, 328,0)

inst_615:
// rs1_val==858993460 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x6; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x6, 0xa, 1b, x2, 332,0)

inst_616:
// rs1_val==858993460 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x33333334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x33333334, 0x4, 3f, x2, 336,0)

inst_617:
// rs1_val==858993460 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x66666667; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x66666667, 0x0, 1b, x2, 340,0)

inst_618:
// rs1_val==858993460 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0xb505; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0xb505, 0x0, 1b, x2, 344,0)

inst_619:
// rs1_val==858993460 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x1; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x1, 0x2, 3f, x2, 348,0)

inst_620:
// rs1_val==858993460 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x33333334; op2val:0x10000; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x33333334, 0x10000, 0xa, 1b, x2, 352,0)

inst_621:
// rs1_val==1717986919 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x3; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x3, 0x2, 3f, x2, 356,0)

inst_622:
// rs1_val==1717986919 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x55555555; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x55555555, 0x8, 3f, x2, 360,0)

inst_623:
// rs1_val==1717986919 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0xaaaaaaaa; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0xaaaaaaaa, 0xa, 1b, x2, 364,0)

inst_624:
// rs1_val==1717986919 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x5; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x5, 0x6, 3f, x2, 368,0)

inst_625:
// rs1_val==1717986919 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x33333333; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x33333333, 0x400, 1b, x2, 372,0)

inst_626:
// rs1_val==1717986919 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x66666666; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x66666666, 0x40, 3f, x2, 376,0)

inst_627:
// rs1_val==1717986919 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0xb504; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0xb504, 0x200, 3f, x2, 380,0)

inst_628:
// rs1_val==1717986919 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x0, 0x4, 3f, x2, 384,0)

inst_629:
// rs1_val==1717986919 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0xffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0xffff, 0x8, 3f, x2, 388,0)

inst_630:
// rs1_val==1717986919 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x2; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x2, 0x40, 3f, x2, 392,0)

inst_631:
// rs1_val==1717986919 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x55555554; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x55555554, 0x2, 3f, x2, 396,0)

inst_632:
// rs1_val==1717986919 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0xaaaaaaa9; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0xaaaaaaa9, 0x40, 3f, x2, 400,0)

inst_633:
// rs1_val==1717986919 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x4; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x4, 0x200, 3f, x2, 404,0)

inst_634:
// rs1_val==1717986919 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x33333332; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x33333332, 0x400, 1b, x2, 408,0)

inst_635:
// rs1_val==1717986919 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x66666665; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x66666665, 0x10, 3f, x2, 412,0)

inst_636:
// rs1_val==1717986919 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0xb503; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0xb503, 0x0, 3f, x2, 416,0)

inst_637:
// rs1_val==1717986919 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0xfffe; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0xfffe, 0x400, 3f, x2, 420,0)

inst_638:
// rs1_val==1717986919 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x55555556; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x55555556, 0x556, 1b, x2, 424,0)

inst_639:
// rs1_val==1717986919 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0xaaaaaaab; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0xaaaaaaab, 0x8, 3f, x2, 428,0)

inst_640:
// rs1_val==1717986919 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x6; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x6, 0x80, 3f, x2, 432,0)

inst_641:
// rs1_val==1717986919 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x33333334; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x33333334, 0x8, 1b, x2, 436,0)

inst_642:
// rs1_val==1717986919 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x66666667; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x66666667, 0x4, 1b, x2, 440,0)

inst_643:
// rs1_val==1717986919 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0xb505; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0xb505, 0x40, 3f, x2, 444,0)

inst_644:
// rs1_val==1717986919 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x1; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x1, 0x2, 3f, x2, 448,0)

inst_645:
// rs1_val==1717986919 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666667; op2val:0x10000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666667, 0x10000, 0x0, 1b, x2, 452,0)

inst_646:
// rs1_val==46341 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x3, 0x8, 3f, x2, 456,0)

inst_647:
// rs1_val==46341 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x55555555; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x55555555, 0x0, 1b, x2, 460,0)

inst_648:
// rs1_val==46341 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0xaaaaaaaa; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0xaaaaaaaa, 0x0, 1b, x2, 464,0)

inst_649:
// rs1_val==46341 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x5; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x5, 0x80, 3f, x2, 468,0)

inst_650:
// rs1_val==46341 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x33333333; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x33333333, 0x2, 3f, x2, 472,0)

inst_651:
// rs1_val==46341 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x66666666; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x66666666, 0x8, 1b, x2, 476,0)

inst_652:
// rs1_val==46341 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0xb504; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0xb504, 0x8, 3f, x2, 480,0)

inst_653:
// rs1_val==46341 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x0; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x0, 0x8, 3f, x2, 484,0)

inst_654:
// rs1_val==46341 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0xffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0xffff, 0x8, 1b, x2, 488,0)

inst_655:
// rs1_val==46341 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x2; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x2, 0x0, 1b, x2, 492,0)

inst_656:
// rs1_val==46341 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x55555554; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x55555554, 0x40, 3f, x2, 496,0)

inst_657:
// rs1_val==46341 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0xaaaaaaa9; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0xaaaaaaa9, 0x2, 3f, x2, 500,0)

inst_658:
// rs1_val==46341 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x4; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x4, 0x10, 3f, x2, 504,0)

inst_659:
// rs1_val==46341 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x33333332; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x33333332, 0x2, 1b, x2, 508,0)

inst_660:
// rs1_val==46341 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x66666665; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x66666665, 0x400, 1b, x2, 512,0)

inst_661:
// rs1_val==46341 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0xb503; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0xb503, 0x400, 1b, x2, 516,0)

inst_662:
// rs1_val==46341 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0xfffe; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0xfffe, 0x20, 3f, x2, 520,0)

inst_663:
// rs1_val==46341 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x55555556; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x55555556, 0x20, 3f, x2, 524,0)

inst_664:
// rs1_val==46341 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0xaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0xaaaaaaab, 0x4, 1b, x2, 528,0)

inst_665:
// rs1_val==46341 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x6; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x6, 0x0, 1b, x2, 532,0)

inst_666:
// rs1_val==46341 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x33333334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x33333334, 0x4, 3f, x2, 536,0)

inst_667:
// rs1_val==46341 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x66666667; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x66666667, 0x40, 3f, x2, 540,0)

inst_668:
// rs1_val==46341 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0xb505; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0xb505, 0x80, 3f, x2, 544,0)

inst_669:
// rs1_val==46341 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x1; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x1, 0x2, 3f, x2, 548,0)

inst_670:
// rs1_val==46341 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb505; op2val:0x10000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xb505, 0x10000, 0x8, 1b, x2, 552,0)

inst_671:
// rs1_val==1 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x3; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x3, 0x0, 1b, x2, 556,0)

inst_672:
// rs1_val==1 and rs2_val==1431655765, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x55555555; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x55555555, 0xa, 1b, x2, 560,0)

inst_673:
// rs1_val==1 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xaaaaaaaa; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0xaaaaaaaa, 0x20, 3f, x2, 564,0)

inst_674:
// rs1_val==1 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x5; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x5, 0x40, 3f, x2, 568,0)

inst_675:
// rs1_val==1 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x33333333; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x33333333, 0x2, 3f, x2, 572,0)

inst_676:
// rs1_val==1 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x66666666; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x66666666, 0x0, 1b, x2, 576,0)

inst_677:
// rs1_val==1 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xb504; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0xb504, 0x100, 3f, x2, 580,0)

inst_678:
// rs1_val==1 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x0; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x0, 0x556, 1b, x2, 584,0)

inst_679:
// rs1_val==1 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0xffff, 0x4, 3f, x2, 588,0)

inst_680:
// rs1_val==1 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x2; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x2, 0x100, 3f, x2, 592,0)

inst_681:
// rs1_val==1 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x55555554; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x55555554, 0x4, 3f, x2, 596,0)

inst_682:
// rs1_val==1 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xaaaaaaa9; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0xaaaaaaa9, 0x400, 1b, x2, 600,0)

inst_683:
// rs1_val==1 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x4; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x4, 0x80, 3f, x2, 604,0)

inst_684:
// rs1_val==1 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x33333332; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x33333332, 0x400, 3f, x2, 608,0)

inst_685:
// rs1_val==1 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x66666665; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x66666665, 0x100, 3f, x2, 612,0)

inst_686:
// rs1_val==1 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xb503; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0xb503, 0x200, 3f, x2, 616,0)

inst_687:
// rs1_val==1 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xfffe; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0xfffe, 0x8, 1b, x2, 620,0)

inst_688:
// rs1_val==1 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x55555556; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x55555556, 0x80, 3f, x2, 624,0)

inst_689:
// rs1_val==1 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xaaaaaaab; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0xaaaaaaab, 0x8, 3f, x2, 628,0)

inst_690:
// rs1_val==1 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x6; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x6, 0x20, 3f, x2, 632,0)

inst_691:
// rs1_val==1 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x33333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x33333334, 0x2, 3f, x2, 636,0)

inst_692:
// rs1_val==1 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x66666667; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x66666667, 0x6, 3f, x2, 640,0)

inst_693:
// rs1_val==1 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xb505; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0xb505, 0x4, 3f, x2, 644,0)

inst_694:
// rs1_val==1 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x1; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x1, 0x2, 3f, x2, 648,0)

inst_695:
// rs1_val==1 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x10000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x1, 0x10000, 0x0, 1b, x2, 652,0)

inst_696:
// rs1_val==65536 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x3; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x3, 0x20, 3f, x2, 656,0)

inst_697:
// rs1_val==65536 and rs2_val==2863311530, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xaaaaaaaa; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0xaaaaaaaa, 0x100, 3f, x2, 660,0)

inst_698:
// rs1_val==65536 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x5; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x5, 0x400, 3f, x2, 664,0)

inst_699:
// rs1_val==65536 and rs2_val==858993459, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x33333333; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x33333333, 0x10, 3f, x2, 668,0)

inst_700:
// rs1_val==65536 and rs2_val==1717986918, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x66666666; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x66666666, 0x556, 1b, x2, 672,0)

inst_701:
// rs1_val==65536 and rs2_val==46340, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xb504; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0xb504, 0x40, 3f, x2, 676,0)

inst_702:
// rs1_val==65536 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x0; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x0, 0x0, 3f, x2, 680,0)

inst_703:
// rs1_val==65536 and rs2_val==65535, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0xffff, 0x10, 3f, x2, 684,0)

inst_704:
// rs1_val==65536 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x2; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x2, 0x20, 3f, x2, 688,0)

inst_705:
// rs1_val==65536 and rs2_val==1431655764, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x55555554; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x55555554, 0x10, 3f, x2, 692,0)

inst_706:
// rs1_val==65536 and rs2_val==2863311529, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xaaaaaaa9; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0xaaaaaaa9, 0x6, 3f, x2, 696,0)

inst_707:
// rs1_val==65536 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x4; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x4, 0x2, 1b, x2, 700,0)

inst_708:
// rs1_val==65536 and rs2_val==858993458, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x33333332; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x33333332, 0x0, 1b, x2, 704,0)

inst_709:
// rs1_val==65536 and rs2_val==1717986917, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x66666665; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x66666665, 0x80, 3f, x2, 708,0)

inst_710:
// rs1_val==65536 and rs2_val==46339, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xb503; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0xb503, 0x4, 1b, x2, 712,0)

inst_711:
// rs1_val==65536 and rs2_val==65534, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xfffe; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0xfffe, 0x100, 3f, x2, 716,0)

inst_712:
// rs1_val==65536 and rs2_val==1431655766, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x55555556; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x55555556, 0x556, 1b, x2, 720,0)

inst_713:
// rs1_val==65536 and rs2_val==2863311531, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xaaaaaaab; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0xaaaaaaab, 0x0, 1b, x2, 724,0)

inst_714:
// rs1_val==65536 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x6; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x6, 0x10, 3f, x2, 728,0)

inst_715:
// rs1_val==65536 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x33333334; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x33333334, 0x0, 1b, x2, 732,0)

inst_716:
// rs1_val==65536 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x66666667; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x66666667, 0x8, 3f, x2, 736,0)

inst_717:
// rs1_val==65536 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xb505; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0xb505, 0x6, 1b, x2, 740,0)

inst_718:
// rs1_val==65536 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x1; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x1, 0x400, 1b, x2, 744,0)

inst_719:
// rs1_val==65536 and rs2_val==65536, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0x10000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x10000, 0x10000, 0x0, 3f, x2, 748,0)

inst_720:
// rs1_val==1717986917 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x6; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x6, 0x400, 3f, x2, 752,0)

inst_721:
// rs1_val==1717986917 and rs2_val==858993460, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x33333334; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x33333334, 0x6, 3f, x2, 756,0)

inst_722:
// rs1_val==1717986917 and rs2_val==1717986919, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0x66666667; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0x66666667, 0xa, 1b, x2, 760,0)

inst_723:
// rs1_val==1717986917 and rs2_val==46341, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x66666665; op2val:0xb505; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x66666665, 0xb505, 0x8, 3f, x2, 764,0)

inst_724:
// rs1_val > 0 and rs2_val > 0, rs2_val == 4294966271, rs1_val == 8, rs1_val > 0 and rs2_val > 0 and rs1_val < rs2_val and imm_val < 0 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8; op2val:0xfffffbff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0x8, 0xfffffbff, 0x0, 1b, x2, 768,0)

inst_725:
// rs2_val == 8, rs1_val == 4294967294
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffe; op2val:0x8; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x3, x10, x11, 0xfffffffe, 0x8, 0x400, 1b, x2, 772,0)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x9_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x9_1:
    .fill 20*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 512*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 194*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
