
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:36:11 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32i.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the sll instruction of the RISC-V i extension for the sll covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32i")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",sll)

RVTEST_SIGBASE( x2,signature_x2_1)

inst_0:
// rs2 == rd != rs1, rs1==x16, rs2==x28, rd==x28, rs1_val < 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == -129, rs2_val == 10
// opcode: sll ; op1:x16; op2:x28; dest:x28; op1val:-0x81;  op2val:0xa
TEST_RR_OP(sll, x28, x16, x28, 0xfffdfc00, -0x81, 0xa, x2, 0, x9)

inst_1:
// rs1 == rs2 != rd, rs1==x21, rs2==x21, rd==x0, rs1_val > 0 and rs2_val > 0 and rs2_val < xlen, rs1_val==5
// opcode: sll ; op1:x21; op2:x21; dest:x0; op1val:0x5;  op2val:0x5
TEST_RR_OP(sll, x0, x21, x21, 0, 0x5, 0x5, x2, 4, x9)

inst_2:
// rs1 == rs2 == rd, rs1==x18, rs2==x18, rd==x18, rs1_val < 0 and rs2_val == 0, rs1_val == -32769
// opcode: sll ; op1:x18; op2:x18; dest:x18; op1val:-0x8001;  op2val:-0x8001
TEST_RR_OP(sll, x18, x18, x18, 0x80000000, -0x8001, -0x8001, x2, 8, x9)

inst_3:
// rs1 == rd != rs2, rs1==x5, rs2==x13, rd==x5, rs1_val > 0 and rs2_val == 0, 
// opcode: sll ; op1:x5; op2:x13; dest:x5; op1val:0x7;  op2val:0x0
TEST_RR_OP(sll, x5, x5, x13, 0x7, 0x7, 0x0, x2, 12, x9)

inst_4:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x22, rs2==x12, rd==x23, rs1_val == rs2_val and rs2_val > 0 and rs2_val < xlen, rs1_val==6
// opcode: sll ; op1:x22; op2:x12; dest:x23; op1val:0x6;  op2val:0x6
TEST_RR_OP(sll, x23, x22, x12, 0x180, 0x6, 0x6, x2, 16, x9)

inst_5:
// rs1==x19, rs2==x0, rd==x6, rs1_val == (-2**(xlen-1)) and rs2_val >= 0 and rs2_val < xlen, rs1_val == -2147483648, rs2_val == 16
// opcode: sll ; op1:x19; op2:x0; dest:x6; op1val:-0x80000000;  op2val:0x0
TEST_RR_OP(sll, x6, x19, x0, 0x80000000, -0x80000000, 0x0, x2, 20, x9)

inst_6:
// rs1==x25, rs2==x24, rd==x13, rs1_val == 0 and rs2_val >= 0 and rs2_val < xlen, rs2_val == 4, rs1_val==0
// opcode: sll ; op1:x25; op2:x24; dest:x13; op1val:0x0;  op2val:0x4
TEST_RR_OP(sll, x13, x25, x24, 0x0, 0x0, 0x4, x2, 24, x9)

inst_7:
// rs1==x12, rs2==x26, rd==x16, rs1_val == (2**(xlen-1)-1) and rs2_val >= 0 and rs2_val < xlen, rs1_val == 2147483647, rs2_val == 21
// opcode: sll ; op1:x12; op2:x26; dest:x16; op1val:0x7fffffff;  op2val:0x15
TEST_RR_OP(sll, x16, x12, x26, 0xffe00000, 0x7fffffff, 0x15, x2, 28, x9)

inst_8:
// rs1==x6, rs2==x14, rd==x20, rs1_val == 1 and rs2_val >= 0 and rs2_val < xlen, rs1_val == 1
// opcode: sll ; op1:x6; op2:x14; dest:x20; op1val:0x1;  op2val:0x4
TEST_RR_OP(sll, x20, x6, x14, 0x10, 0x1, 0x4, x2, 32, x9)

inst_9:
// rs1==x14, rs2==x1, rd==x22, rs1_val == 2, rs1_val==2
// opcode: sll ; op1:x14; op2:x1; dest:x22; op1val:0x2;  op2val:0x1f
TEST_RR_OP(sll, x22, x14, x1, 0x0, 0x2, 0x1f, x2, 36, x9)

inst_10:
// rs1==x29, rs2==x7, rd==x21, rs1_val == 4, rs2_val == 2, rs1_val==4
// opcode: sll ; op1:x29; op2:x7; dest:x21; op1val:0x4;  op2val:0x2
TEST_RR_OP(sll, x21, x29, x7, 0x10, 0x4, 0x2, x2, 40, x9)

inst_11:
// rs1==x31, rs2==x10, rd==x4, rs1_val == 8, 
// opcode: sll ; op1:x31; op2:x10; dest:x4; op1val:0x8;  op2val:0x1f
TEST_RR_OP(sll, x4, x31, x10, 0x0, 0x8, 0x1f, x2, 44, x9)

inst_12:
// rs1==x17, rs2==x20, rd==x7, rs1_val == 16, 
// opcode: sll ; op1:x17; op2:x20; dest:x7; op1val:0x10;  op2val:0x1f
TEST_RR_OP(sll, x7, x17, x20, 0x0, 0x10, 0x1f, x2, 48, x9)

inst_13:
// rs1==x20, rs2==x11, rd==x12, rs1_val == 32, rs2_val == 23
// opcode: sll ; op1:x20; op2:x11; dest:x12; op1val:0x20;  op2val:0x17
TEST_RR_OP(sll, x12, x20, x11, 0x10000000, 0x20, 0x17, x2, 52, x9)

inst_14:
// rs1==x11, rs2==x22, rd==x3, rs1_val == 64, 
// opcode: sll ; op1:x11; op2:x22; dest:x3; op1val:0x40;  op2val:0x11
TEST_RR_OP(sll, x3, x11, x22, 0x800000, 0x40, 0x11, x2, 56, x9)

inst_15:
// rs1==x0, rs2==x30, rd==x24, rs1_val == 128, 
// opcode: sll ; op1:x0; op2:x30; dest:x24; op1val:0x0;  op2val:0x10
TEST_RR_OP(sll, x24, x0, x30, 0x0, 0x0, 0x10, x2, 60, x9)

inst_16:
// rs1==x3, rs2==x31, rd==x8, rs1_val == 256, rs2_val == 27
// opcode: sll ; op1:x3; op2:x31; dest:x8; op1val:0x100;  op2val:0x1b
TEST_RR_OP(sll, x8, x3, x31, 0x0, 0x100, 0x1b, x2, 64, x9)

inst_17:
// rs1==x27, rs2==x17, rd==x10, rs1_val == 512, 
// opcode: sll ; op1:x27; op2:x17; dest:x10; op1val:0x200;  op2val:0x0
TEST_RR_OP(sll, x10, x27, x17, 0x200, 0x200, 0x0, x2, 68, x20)
RVTEST_SIGBASE( x18,signature_x18_0)

inst_18:
// rs1==x10, rs2==x19, rd==x11, rs1_val == 1024, 
// opcode: sll ; op1:x10; op2:x19; dest:x11; op1val:0x400;  op2val:0x1b
TEST_RR_OP(sll, x11, x10, x19, 0x0, 0x400, 0x1b, x18, 0, x20)

inst_19:
// rs1==x8, rs2==x27, rd==x1, rs1_val == 2048, 
// opcode: sll ; op1:x8; op2:x27; dest:x1; op1val:0x800;  op2val:0x6
TEST_RR_OP(sll, x1, x8, x27, 0x20000, 0x800, 0x6, x18, 4, x20)

inst_20:
// rs1==x28, rs2==x9, rd==x25, rs1_val == 4096, 
// opcode: sll ; op1:x28; op2:x9; dest:x25; op1val:0x1000;  op2val:0x10
TEST_RR_OP(sll, x25, x28, x9, 0x10000000, 0x1000, 0x10, x18, 8, x20)

inst_21:
// rs1==x2, rs2==x15, rd==x27, rs1_val == 8192, 
// opcode: sll ; op1:x2; op2:x15; dest:x27; op1val:0x2000;  op2val:0xd
TEST_RR_OP(sll, x27, x2, x15, 0x4000000, 0x2000, 0xd, x18, 12, x20)

inst_22:
// rs1==x24, rs2==x29, rd==x26, rs1_val == 16384, 
// opcode: sll ; op1:x24; op2:x29; dest:x26; op1val:0x4000;  op2val:0x12
TEST_RR_OP(sll, x26, x24, x29, 0x0, 0x4000, 0x12, x18, 16, x20)

inst_23:
// rs1==x1, rs2==x23, rd==x9, rs1_val == 32768, 
// opcode: sll ; op1:x1; op2:x23; dest:x9; op1val:0x8000;  op2val:0x11
TEST_RR_OP(sll, x9, x1, x23, 0x0, 0x8000, 0x11, x18, 20, x20)

inst_24:
// rs1==x23, rs2==x16, rd==x14, rs1_val == 65536, 
// opcode: sll ; op1:x23; op2:x16; dest:x14; op1val:0x10000;  op2val:0x1f
TEST_RR_OP(sll, x14, x23, x16, 0x0, 0x10000, 0x1f, x18, 24, x20)

inst_25:
// rs1==x4, rs2==x3, rd==x17, rs1_val == 131072, 
// opcode: sll ; op1:x4; op2:x3; dest:x17; op1val:0x20000;  op2val:0x13
TEST_RR_OP(sll, x17, x4, x3, 0x0, 0x20000, 0x13, x18, 28, x20)

inst_26:
// rs1==x7, rs2==x4, rd==x15, rs1_val == 262144, 
// opcode: sll ; op1:x7; op2:x4; dest:x15; op1val:0x40000;  op2val:0x17
TEST_RR_OP(sll, x15, x7, x4, 0x0, 0x40000, 0x17, x18, 32, x20)

inst_27:
// rs1==x9, rs2==x2, rd==x29, rs1_val == 524288, 
// opcode: sll ; op1:x9; op2:x2; dest:x29; op1val:0x80000;  op2val:0x13
TEST_RR_OP(sll, x29, x9, x2, 0x0, 0x80000, 0x13, x18, 36, x20)

inst_28:
// rs1==x15, rs2==x8, rd==x31, rs1_val == 1048576, 
// opcode: sll ; op1:x15; op2:x8; dest:x31; op1val:0x100000;  op2val:0xb
TEST_RR_OP(sll, x31, x15, x8, 0x80000000, 0x100000, 0xb, x18, 40, x20)

inst_29:
// rs1==x26, rs2==x6, rd==x30, rs1_val == 2097152, 
// opcode: sll ; op1:x26; op2:x6; dest:x30; op1val:0x200000;  op2val:0x1f
TEST_RR_OP(sll, x30, x26, x6, 0x0, 0x200000, 0x1f, x18, 44, x20)

inst_30:
// rs1==x30, rs2==x5, rd==x19, rs1_val == 4194304, 
// opcode: sll ; op1:x30; op2:x5; dest:x19; op1val:0x400000;  op2val:0x9
TEST_RR_OP(sll, x19, x30, x5, 0x80000000, 0x400000, 0x9, x18, 48, x20)

inst_31:
// rs1==x13, rs2==x25, rd==x2, rs1_val == 8388608, 
// opcode: sll ; op1:x13; op2:x25; dest:x2; op1val:0x800000;  op2val:0x4
TEST_RR_OP(sll, x2, x13, x25, 0x8000000, 0x800000, 0x4, x18, 52, x20)

inst_32:
// rs1_val == 16777216, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x4000000, 0x1000000, 0x2, x18, 56, x20)

inst_33:
// rs1_val == 33554432, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0x20000000, 0x2000000, 0x4, x18, 60, x1)

inst_34:
// rs1_val == 67108864, rs2_val == 8
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x8
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x4000000, 0x8, x18, 64, x1)

inst_35:
// rs1_val == 134217728, rs2_val == 29
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x1d
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x8000000, 0x1d, x18, 68, x1)

inst_36:
// rs1_val == 268435456, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0x12
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x10000000, 0x12, x18, 72, x1)

inst_37:
// rs1_val == 536870912, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0xd
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x20000000, 0xd, x18, 76, x1)

inst_38:
// rs1_val == 1073741824, rs2_val == 15
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0xf
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x40000000, 0xf, x18, 80, x1)

inst_39:
// rs1_val == -2, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:0x1d
TEST_RR_OP(sll, x12, x10, x11, 0xc0000000, -0x2, 0x1d, x18, 84, x1)

inst_40:
// rs1_val == -3, rs2_val == 30
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:0x1e
TEST_RR_OP(sll, x12, x10, x11, 0x40000000, -0x3, 0x1e, x18, 88, x1)

inst_41:
// rs1_val == -5, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:0x15
TEST_RR_OP(sll, x12, x10, x11, 0xff600000, -0x5, 0x15, x18, 92, x1)

inst_42:
// rs1_val == -9, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:0x13
TEST_RR_OP(sll, x12, x10, x11, 0xffb80000, -0x9, 0x13, x18, 96, x1)

inst_43:
// rs1_val == -17, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:0xa
TEST_RR_OP(sll, x12, x10, x11, 0xffffbc00, -0x11, 0xa, x18, 100, x1)

inst_44:
// rs1_val == -33, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x8
TEST_RR_OP(sll, x12, x10, x11, 0xffffdf00, -0x21, 0x8, x18, 104, x1)

inst_45:
// rs1_val == -65, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:0x6
TEST_RR_OP(sll, x12, x10, x11, 0xffffefc0, -0x41, 0x6, x18, 108, x1)

inst_46:
// rs1_val == -257, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0xfffff7f8, -0x101, 0x3, x18, 112, x1)

inst_47:
// rs1_val == -513, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:0x8
TEST_RR_OP(sll, x12, x10, x11, 0xfffdff00, -0x201, 0x8, x18, 116, x1)

inst_48:
// rs1_val == -1025, rs2_val == 1
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0x1
TEST_RR_OP(sll, x12, x10, x11, 0xfffff7fe, -0x401, 0x1, x18, 120, x1)

inst_49:
// rs1_val == -2049, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:0x1e
TEST_RR_OP(sll, x12, x10, x11, 0xc0000000, -0x801, 0x1e, x18, 124, x1)

inst_50:
// rs1_val == -4097, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:0xa
TEST_RR_OP(sll, x12, x10, x11, 0xffbffc00, -0x1001, 0xa, x18, 128, x1)

inst_51:
// rs1_val == -8193, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0xf
TEST_RR_OP(sll, x12, x10, x11, 0xefff8000, -0x2001, 0xf, x18, 132, x1)

inst_52:
// rs1_val == -16385, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:0x15
TEST_RR_OP(sll, x12, x10, x11, 0xffe00000, -0x4001, 0x15, x18, 136, x1)

inst_53:
// rs1_val == -65537, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0xffeffff0, -0x10001, 0x4, x18, 140, x1)

inst_54:
// rs1_val == -131073, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:0x11
TEST_RR_OP(sll, x12, x10, x11, 0xfffe0000, -0x20001, 0x11, x18, 144, x1)

inst_55:
// rs1_val == -262145, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0x0
TEST_RR_OP(sll, x12, x10, x11, 0xfffbffff, -0x40001, 0x0, x18, 148, x1)

inst_56:
// rs1_val == -8388609, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0xfbfffff8, -0x800001, 0x3, x18, 152, x1)

inst_57:
// rs1_val == -16777217, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0x0
TEST_RR_OP(sll, x12, x10, x11, 0xfeffffff, -0x1000001, 0x0, x18, 156, x1)

inst_58:
// rs1_val == -33554433, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0x1
TEST_RR_OP(sll, x12, x10, x11, 0xfbfffffe, -0x2000001, 0x1, x18, 160, x1)

inst_59:
// rs1_val == -67108865, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:0x13
TEST_RR_OP(sll, x12, x10, x11, 0xfff80000, -0x4000001, 0x13, x18, 164, x1)

inst_60:
// rs1_val == -134217729, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:0x1e
TEST_RR_OP(sll, x12, x10, x11, 0xc0000000, -0x8000001, 0x1e, x18, 168, x1)

inst_61:
// rs1_val == -268435457, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:0x13
TEST_RR_OP(sll, x12, x10, x11, 0xfff80000, -0x10000001, 0x13, x18, 172, x1)

inst_62:
// rs1_val == -536870913, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:0x12
TEST_RR_OP(sll, x12, x10, x11, 0xfffc0000, -0x20000001, 0x12, x18, 176, x1)

inst_63:
// rs1_val == -1073741825, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0x5
TEST_RR_OP(sll, x12, x10, x11, 0xffffffe0, -0x40000001, 0x5, x18, 180, x1)

inst_64:
// rs1_val == 1431655765, rs1_val==1431655765
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xc
TEST_RR_OP(sll, x12, x10, x11, 0x55555000, 0x55555555, 0xc, x18, 184, x1)

inst_65:
// rs1_val == -1431655766, rs1_val==-1431655766
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0xaaaaaaa0, -0x55555556, 0x4, x18, 188, x1)

inst_66:
// rs1_val==3, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x1b
TEST_RR_OP(sll, x12, x10, x11, 0x18000000, 0x3, 0x1b, x18, 192, x1)

inst_67:
// rs1_val==858993459, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x0
TEST_RR_OP(sll, x12, x10, x11, 0x33333333, 0x33333333, 0x0, x18, 196, x1)

inst_68:
// rs1_val==1717986918, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb
TEST_RR_OP(sll, x12, x10, x11, 0x33333000, 0x66666666, 0xb, x18, 200, x1)

inst_69:
// rs1_val==-46340, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x5
TEST_RR_OP(sll, x12, x10, x11, 0xffe95f80, -0xb504, 0x5, x18, 204, x1)

inst_70:
// rs1_val==46341, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x1b
TEST_RR_OP(sll, x12, x10, x11, 0x28000000, 0xb505, 0x1b, x18, 208, x1)

inst_71:
// rs1_val==-46339, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x1b
TEST_RR_OP(sll, x12, x10, x11, 0xe8000000, -0xb503, 0x1b, x18, 212, x1)

inst_72:
// rs1_val==46340, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x10
TEST_RR_OP(sll, x12, x10, x11, 0xb5040000, 0xb504, 0x10, x18, 216, x1)

inst_73:
// rs1_val==1431655764, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x1
TEST_RR_OP(sll, x12, x10, x11, 0xaaaaaaa8, 0x55555554, 0x1, x18, 220, x1)

inst_74:
// rs1_val == -1048577, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0xff7ffff8, -0x100001, 0x3, x18, 224, x1)

inst_75:
// rs1_val==1717986919, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x1d
TEST_RR_OP(sll, x12, x10, x11, 0xe0000000, 0x66666667, 0x1d, x18, 228, x1)

inst_76:
// rs1_val==858993458, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0xccccccc8, 0x33333332, 0x2, x18, 232, x1)

inst_77:
// rs1_val==1717986917, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x99999994, 0x66666665, 0x2, x18, 236, x1)

inst_78:
// rs1_val==46339, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb
TEST_RR_OP(sll, x12, x10, x11, 0x5a81800, 0xb503, 0xb, x18, 240, x1)

inst_79:
// rs1_val==1431655766, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x1
TEST_RR_OP(sll, x12, x10, x11, 0xaaaaaaac, 0x55555556, 0x1, x18, 244, x1)

inst_80:
// rs1_val==-1431655765, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb
TEST_RR_OP(sll, x12, x10, x11, 0x55555800, -0x55555555, 0xb, x18, 248, x1)

inst_81:
// rs1_val == -524289, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x11
TEST_RR_OP(sll, x12, x10, x11, 0xfffe0000, -0x80001, 0x11, x18, 252, x1)

inst_82:
// rs1_val==858993460, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0x33333340, 0x33333334, 0x4, x18, 256, x1)

inst_83:
// rs1_val == -2097153, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0xfefffff8, -0x200001, 0x3, x18, 260, x1)

inst_84:
// rs1_val == -4194305, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:0x15
TEST_RR_OP(sll, x12, x10, x11, 0xffe00000, -0x400001, 0x15, x18, 264, x1)

inst_85:
// rs1_val > 0 and rs2_val > 0 and rs2_val < xlen, rs1_val==5
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xd
TEST_RR_OP(sll, x12, x10, x11, 0xa000, 0x5, 0xd, x18, 268, x1)

inst_86:
// rs1_val < 0 and rs2_val == 0, rs1_val == -32769
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:0x0
TEST_RR_OP(sll, x12, x10, x11, 0xffff7fff, -0x8001, 0x0, x18, 272, x1)

inst_87:
// rs1_val == (-2**(xlen-1)) and rs2_val >= 0 and rs2_val < xlen, rs1_val == -2147483648, rs2_val == 16
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000;  op2val:0x10
TEST_RR_OP(sll, x12, x10, x11, 0x0, -0x80000000, 0x10, x18, 276, x1)

inst_88:
// rs1_val == 128, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:0x10
TEST_RR_OP(sll, x12, x10, x11, 0x800000, 0x80, 0x10, x18, 280, x1)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x2_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 18*(XLEN/32),4,0xdeadbeef


signature_x18_0:
    .fill 71*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
