
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:36:11 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32i.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the sltiu instruction of the RISC-V I extension for the sltiu covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",sltiu)

RVTEST_SIGBASE( x7,signature_x7_1)

inst_0:
// rs1 != rd, rs1==x23, rd==x28, imm_val == 0, rs1_val == 1024
// opcode: sltiu ; op1:x23; dest:x28; op1val:0x400;  immval:0x0
TEST_IMM_OP( sltiu, x28, x23, 0x0, 0x400, 0x0, x7, 0, x18)

inst_1:
// rs1 == rd, rs1==x2, rd==x2, imm_val == (2**(12)-1), rs1_val == 2048, rs1_val != imm_val and rs1_val > 0 and imm_val > 0
// opcode: sltiu ; op1:x2; dest:x2; op1val:0x800;  immval:0xfff
TEST_IMM_OP( sltiu, x2, x2, 0x1, 0x800, 0xfff, x7, 4, x18)

inst_2:
// rs1==x3, rd==x25, imm_val == 1, rs1_val == 4, rs1_val==4 and imm_val==1
// opcode: sltiu ; op1:x3; dest:x25; op1val:0x4;  immval:0x1
TEST_IMM_OP( sltiu, x25, x3, 0x0, 0x4, 0x1, x7, 8, x18)

inst_3:
// rs1==x19, rd==x11, rs1_val == 0, rs1_val==0 and imm_val==6
// opcode: sltiu ; op1:x19; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( sltiu, x11, x19, 0x1, 0x0, 0x6, x7, 12, x18)

inst_4:
// rs1==x14, rd==x15, rs1_val == (2**(xlen)-1), 
// opcode: sltiu ; op1:x14; dest:x15; op1val:0xffffffff;  immval:0x2c
TEST_IMM_OP( sltiu, x15, x14, 0x0, 0xffffffff, 0x2c, x7, 16, x18)

inst_5:
// rs1==x13, rd==x4, rs1_val == 1, rs1_val==1 and imm_val==0
// opcode: sltiu ; op1:x13; dest:x4; op1val:0x1;  immval:0x0
TEST_IMM_OP( sltiu, x4, x13, 0x0, 0x1, 0x0, x7, 20, x18)

inst_6:
// rs1==x26, rd==x3, rs1_val == imm_val and rs1_val > 0 and imm_val > 0, 
// opcode: sltiu ; op1:x26; dest:x3; op1val:0xd;  immval:0xd
TEST_IMM_OP( sltiu, x3, x26, 0x0, 0xd, 0xd, x7, 24, x18)

inst_7:
// rs1==x20, rd==x29, imm_val == 2, rs1_val == 2863311530, rs1_val==2863311530 and imm_val==2
// opcode: sltiu ; op1:x20; dest:x29; op1val:0xaaaaaaaa;  immval:0x2
TEST_IMM_OP( sltiu, x29, x20, 0x0, 0xaaaaaaaa, 0x2, x7, 28, x18)

inst_8:
// rs1==x27, rd==x16, imm_val == 4, rs1_val == 2147483647
// opcode: sltiu ; op1:x27; dest:x16; op1val:0x7fffffff;  immval:0x4
TEST_IMM_OP( sltiu, x16, x27, 0x0, 0x7fffffff, 0x4, x7, 32, x18)

inst_9:
// rs1==x17, rd==x20, imm_val == 8, rs1_val == 4278190079
// opcode: sltiu ; op1:x17; dest:x20; op1val:0xfeffffff;  immval:0x8
TEST_IMM_OP( sltiu, x20, x17, 0x0, 0xfeffffff, 0x8, x7, 36, x18)

inst_10:
// rs1==x31, rd==x8, imm_val == 16, 
// opcode: sltiu ; op1:x31; dest:x8; op1val:0x800;  immval:0x10
TEST_IMM_OP( sltiu, x8, x31, 0x0, 0x800, 0x10, x7, 40, x18)

inst_11:
// rs1==x24, rd==x23, imm_val == 32, 
// opcode: sltiu ; op1:x24; dest:x23; op1val:0xc;  immval:0x20
TEST_IMM_OP( sltiu, x23, x24, 0x1, 0xc, 0x20, x7, 44, x18)

inst_12:
// rs1==x25, rd==x26, imm_val == 64, rs1_val == 1431655765, rs1_val==1431655765 and imm_val==64
// opcode: sltiu ; op1:x25; dest:x26; op1val:0x55555555;  immval:0x40
TEST_IMM_OP( sltiu, x26, x25, 0x0, 0x55555555, 0x40, x7, 48, x18)

inst_13:
// rs1==x22, rd==x6, imm_val == 128, rs1_val == 524288
// opcode: sltiu ; op1:x22; dest:x6; op1val:0x80000;  immval:0x80
TEST_IMM_OP( sltiu, x6, x22, 0x0, 0x80000, 0x80, x7, 52, x18)

inst_14:
// rs1==x12, rd==x5, imm_val == 256, rs1_val == 4294967287
// opcode: sltiu ; op1:x12; dest:x5; op1val:0xfffffff7;  immval:0x100
TEST_IMM_OP( sltiu, x5, x12, 0x0, 0xfffffff7, 0x100, x7, 56, x18)

inst_15:
// rs1==x9, rd==x1, imm_val == 512, rs1_val == 2147483648
// opcode: sltiu ; op1:x9; dest:x1; op1val:0x80000000;  immval:0x200
TEST_IMM_OP( sltiu, x1, x9, 0x0, 0x80000000, 0x200, x7, 60, x18)

inst_16:
// rs1==x28, rd==x10, imm_val == 1024, rs1_val == 4294705151
// opcode: sltiu ; op1:x28; dest:x10; op1val:0xfffbffff;  immval:0x400
TEST_IMM_OP( sltiu, x10, x28, 0x0, 0xfffbffff, 0x400, x7, 64, x18)

inst_17:
// rs1==x21, rd==x31, imm_val == 2048, 
// opcode: sltiu ; op1:x21; dest:x31; op1val:0x0;  immval:0x800
TEST_IMM_OP( sltiu, x31, x21, 0x1, 0x0, 0x800, x7, 68, x3)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_18:
// rs1==x0, rd==x21, imm_val == 4094, rs1_val == 16
// opcode: sltiu ; op1:x0; dest:x21; op1val:0x0;  immval:0xffe
TEST_IMM_OP( sltiu, x21, x0, 0x1, 0x0, 0xffe, x2, 0, x3)

inst_19:
// rs1==x11, rd==x14, imm_val == 4093, 
// opcode: sltiu ; op1:x11; dest:x14; op1val:0x12;  immval:0xffd
TEST_IMM_OP( sltiu, x14, x11, 0x1, 0x12, 0xffd, x2, 4, x3)

inst_20:
// rs1==x30, rd==x13, imm_val == 4091, 
// opcode: sltiu ; op1:x30; dest:x13; op1val:0x6;  immval:0xffb
TEST_IMM_OP( sltiu, x13, x30, 0x1, 0x6, 0xffb, x2, 8, x3)

inst_21:
// rs1==x29, rd==x17, imm_val == 4087, rs1_val == 1073741824
// opcode: sltiu ; op1:x29; dest:x17; op1val:0x40000000;  immval:0xff7
TEST_IMM_OP( sltiu, x17, x29, 0x1, 0x40000000, 0xff7, x2, 12, x3)

inst_22:
// rs1==x8, rd==x24, imm_val == 4079, rs1_val == 4294967231
// opcode: sltiu ; op1:x8; dest:x24; op1val:0xffffffbf;  immval:0xfef
TEST_IMM_OP( sltiu, x24, x8, 0x1, 0xffffffbf, 0xfef, x2, 16, x3)

inst_23:
// rs1==x1, rd==x27, imm_val == 4063, 
// opcode: sltiu ; op1:x1; dest:x27; op1val:0x5;  immval:0xfdf
TEST_IMM_OP( sltiu, x27, x1, 0x1, 0x5, 0xfdf, x2, 20, x3)

inst_24:
// rs1==x7, rd==x30, imm_val == 4031, 
// opcode: sltiu ; op1:x7; dest:x30; op1val:0x3;  immval:0xfbf
TEST_IMM_OP( sltiu, x30, x7, 0x1, 0x3, 0xfbf, x2, 24, x3)

inst_25:
// rs1==x5, rd==x22, imm_val == 3967, rs1_val == 262144
// opcode: sltiu ; op1:x5; dest:x22; op1val:0x40000;  immval:0xf7f
TEST_IMM_OP( sltiu, x22, x5, 0x1, 0x40000, 0xf7f, x2, 28, x3)

inst_26:
// rs1==x15, rd==x0, imm_val == 3839, 
// opcode: sltiu ; op1:x15; dest:x0; op1val:0xe;  immval:0xeff
TEST_IMM_OP( sltiu, x0, x15, 0, 0xe, 0xeff, x2, 32, x3)

inst_27:
// rs1==x6, rd==x7, imm_val == 3583, 
// opcode: sltiu ; op1:x6; dest:x7; op1val:0x3;  immval:0xdff
TEST_IMM_OP( sltiu, x7, x6, 0x1, 0x3, 0xdff, x2, 36, x3)

inst_28:
// rs1==x18, rd==x12, imm_val == 3071, 
// opcode: sltiu ; op1:x18; dest:x12; op1val:0x7fffffff;  immval:0xbff
TEST_IMM_OP( sltiu, x12, x18, 0x1, 0x7fffffff, 0xbff, x2, 40, x3)

inst_29:
// rs1==x16, rd==x18, imm_val == 2047, rs1_val == 16777216
// opcode: sltiu ; op1:x16; dest:x18; op1val:0x1000000;  immval:0x7ff
TEST_IMM_OP( sltiu, x18, x16, 0x0, 0x1000000, 0x7ff, x2, 44, x3)

inst_30:
// rs1==x4, rd==x9, imm_val == 1365, rs1_val == 4227858431
// opcode: sltiu ; op1:x4; dest:x9; op1val:0xfbffffff;  immval:0x555
TEST_IMM_OP( sltiu, x9, x4, 0x0, 0xfbffffff, 0x555, x2, 48, x3)

inst_31:
// rs1==x10, rd==x19, imm_val == 2730, rs1_val == 4294965247
// opcode: sltiu ; op1:x10; dest:x19; op1val:0xfffff7ff;  immval:0xaaa
TEST_IMM_OP( sltiu, x19, x10, 0x1, 0xfffff7ff, 0xaaa, x2, 52, x3)

inst_32:
// rs1_val == 2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x20
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x20, x2, 56, x3)

inst_33:
// rs1_val == 8, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x8;  immval:0x80
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x8, 0x80, x2, 60, x3)

inst_34:
// rs1_val == 32, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x20;  immval:0x800
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x20, 0x800, x2, 64, x3)

inst_35:
// rs1_val == 64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x40;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x40, 0x2, x2, 68, x3)

inst_36:
// rs1_val == 128, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x80;  immval:0xff7
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x80, 0xff7, x2, 72, x3)

inst_37:
// rs1_val == 256, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100;  immval:0xfdf
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x100, 0xfdf, x2, 76, x3)

inst_38:
// rs1_val == 512, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x200;  immval:0xff7
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x200, 0xff7, x2, 80, x3)

inst_39:
// rs1_val == 4096, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1000;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x1000, 0x2e, x2, 84, x3)

inst_40:
// rs1_val == 8192, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2000;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2000, 0x2e, x2, 88, x3)

inst_41:
// rs1_val == 16384, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4000;  immval:0x7
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4000, 0x7, x2, 92, x3)

inst_42:
// rs1_val == 32768, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x8000;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x8000, 0x2, x2, 96, x3)

inst_43:
// rs1_val == 65536, rs1_val==65536 and imm_val==5
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x5, x2, 100, x3)

inst_44:
// rs1_val == 131072, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x20000;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x20000, 0x2e, x2, 104, x3)

inst_45:
// rs1_val == 1048576, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000;  immval:0x10
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000, 0x10, x2, 108, x3)

inst_46:
// rs1_val == 2097152, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x200000;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x200000, 0x5, x2, 112, x3)

inst_47:
// rs1_val == 4194304, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x400000;  immval:0xfdf
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x400000, 0xfdf, x2, 116, x3)

inst_48:
// rs1_val == 8388608, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x800000;  immval:0x800
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x800000, 0x800, x2, 120, x3)

inst_49:
// rs1_val == 33554432, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2000000;  immval:0x8
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2000000, 0x8, x2, 124, x3)

inst_50:
// rs1_val == 67108864, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x800
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4000000, 0x800, x2, 128, x3)

inst_51:
// rs1_val == 134217728, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x8000000;  immval:0xc
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x8000000, 0xc, x2, 132, x3)

inst_52:
// rs1_val == 268435456, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000000;  immval:0xfbf
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x10000000, 0xfbf, x2, 136, x3)

inst_53:
// rs1_val == 536870912, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x10
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x20000000, 0x10, x2, 140, x3)

inst_54:
// rs1_val == 4294967294, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffe;  immval:0xfef
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffe, 0xfef, x2, 144, x3)

inst_55:
// rs1_val == 4294967293, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffd;  immval:0xfff
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffffffd, 0xfff, x2, 148, x3)

inst_56:
// rs1_val == 4294967291, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffb;  immval:0x20
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffb, 0x20, x2, 152, x3)

inst_57:
// rs1_val == 4294967279, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffef;  immval:0xfff
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffffffef, 0xfff, x2, 156, x3)

inst_58:
// rs1_val == 4294967263, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffdf;  immval:0xeff
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffdf, 0xeff, x2, 160, x3)

inst_59:
// rs1_val == 4294967167, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffff7f;  immval:0x10
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffff7f, 0x10, x2, 164, x3)

inst_60:
// rs1_val == 4294967039, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffeff;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffeff, 0x4, x2, 168, x3)

inst_61:
// rs1_val == 4294966783, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffdff;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffdff, 0x2d, x2, 172, x3)

inst_62:
// rs1_val == 4294966271, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffbff;  immval:0xf
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffbff, 0xf, x2, 176, x3)

inst_63:
// rs1_val == 4294963199, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffefff;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffefff, 0x2e, x2, 180, x3)

inst_64:
// rs1_val == 4294959103, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffdfff;  immval:0xd
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffdfff, 0xd, x2, 184, x3)

inst_65:
// rs1_val == 4294950911, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffbfff;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffbfff, 0x333, x2, 188, x3)

inst_66:
// rs1_val == 4294934527, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff7fff;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff7fff, 0x1, x2, 192, x3)

inst_67:
// rs1_val == 4294901759, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffeffff;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffeffff, 0x40, x2, 196, x3)

inst_68:
// rs1_val == 4294836223, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffdffff;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffdffff, 0x5, x2, 200, x3)

inst_69:
// rs1_val == 4294443007, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfff7ffff;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfff7ffff, 0x4, x2, 204, x3)

inst_70:
// rs1_val == 4293918719, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffefffff;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffefffff, 0x555, x2, 208, x3)

inst_71:
// rs1_val == 4292870143, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffdfffff;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffdfffff, 0x2, x2, 212, x3)

inst_72:
// rs1_val == 4290772991, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffbfffff;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffbfffff, 0x556, x2, 216, x3)

inst_73:
// rs1_val == 4286578687, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xff7fffff;  immval:0xffe
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xff7fffff, 0xffe, x2, 220, x3)

inst_74:
// rs1_val == 4261412863, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfdffffff;  immval:0xd
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfdffffff, 0xd, x2, 224, x3)

inst_75:
// rs1_val == 4160749567, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xf7ffffff;  immval:0x800
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xf7ffffff, 0x800, x2, 228, x3)

inst_76:
// rs1_val == 4026531839, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xefffffff;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xefffffff, 0x6, x2, 232, x3)

inst_77:
// rs1_val == 3758096383, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xdfffffff;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xdfffffff, 0x40, x2, 236, x3)

inst_78:
// rs1_val == 3221225471, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xbfffffff;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xbfffffff, 0x6, x2, 240, x3)

inst_79:
// rs1_val==3 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3, 0x3, x2, 244, x3)

inst_80:
// rs1_val==3 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x555, x2, 248, x3)

inst_81:
// rs1_val==3 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0xaaa, x2, 252, x3)

inst_82:
// rs1_val==3 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x5, x2, 256, x3)

inst_83:
// rs1_val==3 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x333, x2, 260, x3)

inst_84:
// rs1_val==3 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x666, x2, 264, x3)

inst_85:
// rs1_val==3 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x2d, x2, 268, x3)

inst_86:
// rs1_val==3 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3, 0x0, x2, 272, x3)

inst_87:
// rs1_val==3 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x3f, x2, 276, x3)

inst_88:
// rs1_val==3 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3, 0x2, x2, 280, x3)

inst_89:
// rs1_val==3 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x554, x2, 284, x3)

inst_90:
// rs1_val==3 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0xaa9, x2, 288, x3)

inst_91:
// rs1_val==3 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x4, x2, 292, x3)

inst_92:
// rs1_val==3 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x332, x2, 296, x3)

inst_93:
// rs1_val==3 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x665, x2, 300, x3)

inst_94:
// rs1_val==3 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x2c, x2, 304, x3)

inst_95:
// rs1_val==3 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x3e, x2, 308, x3)

inst_96:
// rs1_val==3 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x556, x2, 312, x3)

inst_97:
// rs1_val==3 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0xaab, x2, 316, x3)

inst_98:
// rs1_val==3 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x6, x2, 320, x3)

inst_99:
// rs1_val==3 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x334, x2, 324, x3)

inst_100:
// rs1_val==3 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x667, x2, 328, x3)

inst_101:
// rs1_val==3 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x2e, x2, 332, x3)

inst_102:
// rs1_val==3 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3, 0x1, x2, 336, x3)

inst_103:
// rs1_val==3 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x40, x2, 340, x3)

inst_104:
// rs1_val==1431655765 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x3, x2, 344, x3)

inst_105:
// rs1_val==1431655765 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x555, x2, 348, x3)

inst_106:
// rs1_val==1431655765 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555555, 0xaaa, x2, 352, x3)

inst_107:
// rs1_val==1431655765 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x5, x2, 356, x3)

inst_108:
// rs1_val==1431655765 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x333, x2, 360, x3)

inst_109:
// rs1_val==1431655765 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x666, x2, 364, x3)

inst_110:
// rs1_val==1431655765 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x2d, x2, 368, x3)

inst_111:
// rs1_val==1431655765 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x0, x2, 372, x3)

inst_112:
// rs1_val==1431655765 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x3f, x2, 376, x3)

inst_113:
// rs1_val==1431655765 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x2, x2, 380, x3)

inst_114:
// rs1_val==1431655765 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x554, x2, 384, x3)

inst_115:
// rs1_val==1431655765 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555555, 0xaa9, x2, 388, x3)

inst_116:
// rs1_val==1431655765 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x4, x2, 392, x3)

inst_117:
// rs1_val==1431655765 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x332, x2, 396, x3)

inst_118:
// rs1_val==1431655765 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x665, x2, 400, x3)

inst_119:
// rs1_val==1431655765 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x2c, x2, 404, x3)

inst_120:
// rs1_val==1431655765 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x3e, x2, 408, x3)

inst_121:
// rs1_val==1431655765 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x556, x2, 412, x3)

inst_122:
// rs1_val==1431655765 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555555, 0xaab, x2, 416, x3)

inst_123:
// rs1_val==1431655765 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x6, x2, 420, x3)

inst_124:
// rs1_val==1431655765 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x334, x2, 424, x3)

inst_125:
// rs1_val==1431655765 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x667, x2, 428, x3)

inst_126:
// rs1_val==1431655765 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x2e, x2, 432, x3)

inst_127:
// rs1_val==1431655765 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555555, 0x1, x2, 436, x3)

inst_128:
// rs1_val==2863311530 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x3, x2, 440, x3)

inst_129:
// rs1_val==2863311530 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x555, x2, 444, x3)

inst_130:
// rs1_val==2863311530 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaa, 0xaaa, x2, 448, x3)

inst_131:
// rs1_val==2863311530 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x5, x2, 452, x3)

inst_132:
// rs1_val==2863311530 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x333, x2, 456, x3)

inst_133:
// rs1_val==2863311530 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x666, x2, 460, x3)

inst_134:
// rs1_val==2863311530 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x2d, x2, 464, x3)

inst_135:
// rs1_val==2863311530 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x0, x2, 468, x3)

inst_136:
// rs1_val==2863311530 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x3f, x2, 472, x3)

inst_137:
// rs1_val==2863311530 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x554, x2, 476, x3)

inst_138:
// rs1_val==2863311530 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaa, 0xaa9, x2, 480, x3)

inst_139:
// rs1_val==2863311530 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x4, x2, 484, x3)

inst_140:
// rs1_val==2863311530 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x332, x2, 488, x3)

inst_141:
// rs1_val==2863311530 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x665, x2, 492, x3)

inst_142:
// rs1_val==2863311530 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x2c, x2, 496, x3)

inst_143:
// rs1_val==2863311530 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x3e, x2, 500, x3)

inst_144:
// rs1_val==2863311530 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x556, x2, 504, x3)

inst_145:
// rs1_val==2863311530 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaa, 0xaab, x2, 508, x3)

inst_146:
// rs1_val==2863311530 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x6, x2, 512, x3)

inst_147:
// rs1_val==2863311530 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x334, x2, 516, x3)

inst_148:
// rs1_val==2863311530 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x667, x2, 520, x3)

inst_149:
// rs1_val==2863311530 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x2e, x2, 524, x3)

inst_150:
// rs1_val==2863311530 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x1, x2, 528, x3)

inst_151:
// rs1_val==2863311530 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaa;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaa, 0x40, x2, 532, x3)

inst_152:
// rs1_val==5 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x3, x2, 536, x3)

inst_153:
// rs1_val==5 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x555, x2, 540, x3)

inst_154:
// rs1_val==5 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0xaaa, x2, 544, x3)

inst_155:
// rs1_val==5 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x5, x2, 548, x3)

inst_156:
// rs1_val==5 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x333, x2, 552, x3)

inst_157:
// rs1_val==5 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x666, x2, 556, x3)

inst_158:
// rs1_val==5 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x2d, x2, 560, x3)

inst_159:
// rs1_val==5 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x0, x2, 564, x3)

inst_160:
// rs1_val==5 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x3f, x2, 568, x3)

inst_161:
// rs1_val==5 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x2, x2, 572, x3)

inst_162:
// rs1_val==5 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x554, x2, 576, x3)

inst_163:
// rs1_val==5 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0xaa9, x2, 580, x3)

inst_164:
// rs1_val==5 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x4, x2, 584, x3)

inst_165:
// rs1_val==5 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x332, x2, 588, x3)

inst_166:
// rs1_val==5 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x665, x2, 592, x3)

inst_167:
// rs1_val==5 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x2c, x2, 596, x3)

inst_168:
// rs1_val==5 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x3e, x2, 600, x3)

inst_169:
// rs1_val==5 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x556, x2, 604, x3)

inst_170:
// rs1_val==5 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0xaab, x2, 608, x3)

inst_171:
// rs1_val==5 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x6, x2, 612, x3)

inst_172:
// rs1_val==5 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x334, x2, 616, x3)

inst_173:
// rs1_val==5 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x667, x2, 620, x3)

inst_174:
// rs1_val==5 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x2e, x2, 624, x3)

inst_175:
// rs1_val==5 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x1, x2, 628, x3)

inst_176:
// rs1_val==5 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x40, x2, 632, x3)

inst_177:
// rs1_val==858993459 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x3, x2, 636, x3)

inst_178:
// rs1_val==858993459 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x555, x2, 640, x3)

inst_179:
// rs1_val==858993459 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333333, 0xaaa, x2, 644, x3)

inst_180:
// rs1_val==858993459 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x5, x2, 648, x3)

inst_181:
// rs1_val==858993459 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x333, x2, 652, x3)

inst_182:
// rs1_val==858993459 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x666, x2, 656, x3)

inst_183:
// rs1_val==858993459 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x2d, x2, 660, x3)

inst_184:
// rs1_val==858993459 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x0, x2, 664, x3)

inst_185:
// rs1_val==858993459 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x3f, x2, 668, x3)

inst_186:
// rs1_val==858993459 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x2, x2, 672, x3)

inst_187:
// rs1_val==858993459 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x554, x2, 676, x3)

inst_188:
// rs1_val==858993459 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333333, 0xaa9, x2, 680, x3)

inst_189:
// rs1_val==858993459 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x4, x2, 684, x3)

inst_190:
// rs1_val==858993459 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x332, x2, 688, x3)

inst_191:
// rs1_val==858993459 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x665, x2, 692, x3)

inst_192:
// rs1_val==858993459 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x2c, x2, 696, x3)

inst_193:
// rs1_val==858993459 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x3e, x2, 700, x3)

inst_194:
// rs1_val==858993459 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x556, x2, 704, x3)

inst_195:
// rs1_val==858993459 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333333, 0xaab, x2, 708, x3)

inst_196:
// rs1_val==858993459 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x6, x2, 712, x3)

inst_197:
// rs1_val==858993459 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x334, x2, 716, x3)

inst_198:
// rs1_val==858993459 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x667, x2, 720, x3)

inst_199:
// rs1_val==858993459 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x2e, x2, 724, x3)

inst_200:
// rs1_val==858993459 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x1, x2, 728, x3)

inst_201:
// rs1_val==858993459 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333333, 0x40, x2, 732, x3)

inst_202:
// rs1_val==1717986918 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x3, x2, 736, x3)

inst_203:
// rs1_val==1717986918 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x555, x2, 740, x3)

inst_204:
// rs1_val==1717986918 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666666, 0xaaa, x2, 744, x3)

inst_205:
// rs1_val==1717986918 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x5, x2, 748, x3)

inst_206:
// rs1_val==1717986918 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x333, x2, 752, x3)

inst_207:
// rs1_val==1717986918 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x666, x2, 756, x3)

inst_208:
// rs1_val==1717986918 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x2d, x2, 760, x3)

inst_209:
// rs1_val==1717986918 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x0, x2, 764, x3)

inst_210:
// rs1_val==1717986918 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x3f, x2, 768, x3)

inst_211:
// rs1_val==1717986918 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x2, x2, 772, x3)

inst_212:
// rs1_val==1717986918 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x554, x2, 776, x3)

inst_213:
// rs1_val==1717986918 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666666, 0xaa9, x2, 780, x3)

inst_214:
// rs1_val==1717986918 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x4, x2, 784, x3)

inst_215:
// rs1_val==1717986918 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x332, x2, 788, x3)

inst_216:
// rs1_val==1717986918 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x665, x2, 792, x3)

inst_217:
// rs1_val==1717986918 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x2c, x2, 796, x3)

inst_218:
// rs1_val==1717986918 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x3e, x2, 800, x3)

inst_219:
// rs1_val==1717986918 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x556, x2, 804, x3)

inst_220:
// rs1_val==1717986918 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666666, 0xaab, x2, 808, x3)

inst_221:
// rs1_val==1717986918 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x6, x2, 812, x3)

inst_222:
// rs1_val==1717986918 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x334, x2, 816, x3)

inst_223:
// rs1_val==1717986918 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x667, x2, 820, x3)

inst_224:
// rs1_val==1717986918 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x2e, x2, 824, x3)

inst_225:
// rs1_val==1717986918 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x1, x2, 828, x3)

inst_226:
// rs1_val==1717986918 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666666, 0x40, x2, 832, x3)

inst_227:
// rs1_val==46340 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x3, x2, 836, x3)

inst_228:
// rs1_val==46340 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x555, x2, 840, x3)

inst_229:
// rs1_val==46340 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504, 0xaaa, x2, 844, x3)

inst_230:
// rs1_val==46340 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x5, x2, 848, x3)

inst_231:
// rs1_val==46340 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x333, x2, 852, x3)

inst_232:
// rs1_val==46340 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x666, x2, 856, x3)

inst_233:
// rs1_val==46340 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x2d, x2, 860, x3)

inst_234:
// rs1_val==46340 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x0, x2, 864, x3)

inst_235:
// rs1_val==46340 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x3f, x2, 868, x3)

inst_236:
// rs1_val==46340 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x2, x2, 872, x3)

inst_237:
// rs1_val==46340 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x554, x2, 876, x3)

inst_238:
// rs1_val==46340 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504, 0xaa9, x2, 880, x3)

inst_239:
// rs1_val==46340 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x4, x2, 884, x3)

inst_240:
// rs1_val==46340 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x332, x2, 888, x3)

inst_241:
// rs1_val==46340 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x665, x2, 892, x3)

inst_242:
// rs1_val==46340 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x2c, x2, 896, x3)

inst_243:
// rs1_val==46340 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x3e, x2, 900, x3)

inst_244:
// rs1_val==46340 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x556, x2, 904, x3)

inst_245:
// rs1_val==46340 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504, 0xaab, x2, 908, x3)

inst_246:
// rs1_val==46340 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x6, x2, 912, x3)

inst_247:
// rs1_val==46340 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x334, x2, 916, x3)

inst_248:
// rs1_val==46340 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x667, x2, 920, x3)

inst_249:
// rs1_val==46340 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x2e, x2, 924, x3)

inst_250:
// rs1_val==46340 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x1, x2, 928, x3)

inst_251:
// rs1_val==46340 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504, 0x40, x2, 932, x3)

inst_252:
// rs1_val==0 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x3, x2, 936, x3)

inst_253:
// rs1_val==0 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x555, x2, 940, x3)

inst_254:
// rs1_val==0 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0xaaa, x2, 944, x3)

inst_255:
// rs1_val==0 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x5, x2, 948, x3)

inst_256:
// rs1_val==0 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x333, x2, 952, x3)

inst_257:
// rs1_val==0 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x666, x2, 956, x3)

inst_258:
// rs1_val==0 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x2d, x2, 960, x3)

inst_259:
// rs1_val==0 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x0, 0x0, x2, 964, x3)

inst_260:
// rs1_val==0 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x3f, x2, 968, x3)

inst_261:
// rs1_val==0 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x2, x2, 972, x3)

inst_262:
// rs1_val==0 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x554, x2, 976, x3)

inst_263:
// rs1_val==0 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0xaa9, x2, 980, x3)

inst_264:
// rs1_val==0 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x4, x2, 984, x3)

inst_265:
// rs1_val==0 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x332, x2, 988, x3)

inst_266:
// rs1_val==0 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x665, x2, 992, x3)

inst_267:
// rs1_val==0 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x2c, x2, 996, x3)

inst_268:
// rs1_val==0 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x3e, x2, 1000, x3)

inst_269:
// rs1_val==0 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x556, x2, 1004, x3)

inst_270:
// rs1_val==0 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0xaab, x2, 1008, x3)

inst_271:
// rs1_val==0 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x334, x2, 1012, x3)

inst_272:
// rs1_val==0 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x667, x2, 1016, x3)

inst_273:
// rs1_val==0 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x2e, x2, 1020, x3)

inst_274:
// rs1_val==0 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x1, x2, 1024, x3)

inst_275:
// rs1_val==0 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x40, x2, 1028, x3)

inst_276:
// rs1_val==65535 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x3, x2, 1032, x3)

inst_277:
// rs1_val==65535 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x555, x2, 1036, x3)

inst_278:
// rs1_val==65535 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffff, 0xaaa, x2, 1040, x3)

inst_279:
// rs1_val==65535 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x5, x2, 1044, x3)

inst_280:
// rs1_val==65535 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x333, x2, 1048, x3)

inst_281:
// rs1_val==65535 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x666, x2, 1052, x3)

inst_282:
// rs1_val==65535 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x2d, x2, 1056, x3)

inst_283:
// rs1_val==65535 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x0, x2, 1060, x3)

inst_284:
// rs1_val==65535 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x3f, x2, 1064, x3)

inst_285:
// rs1_val==65535 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x2, x2, 1068, x3)

inst_286:
// rs1_val==65535 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x554, x2, 1072, x3)

inst_287:
// rs1_val==65535 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffff, 0xaa9, x2, 1076, x3)

inst_288:
// rs1_val==65535 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x4, x2, 1080, x3)

inst_289:
// rs1_val==65535 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x332, x2, 1084, x3)

inst_290:
// rs1_val==65535 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x665, x2, 1088, x3)

inst_291:
// rs1_val==65535 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x2c, x2, 1092, x3)

inst_292:
// rs1_val==65535 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x3e, x2, 1096, x3)

inst_293:
// rs1_val==65535 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x556, x2, 1100, x3)

inst_294:
// rs1_val==65535 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffff, 0xaab, x2, 1104, x3)

inst_295:
// rs1_val==65535 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x6, x2, 1108, x3)

inst_296:
// rs1_val==65535 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x334, x2, 1112, x3)

inst_297:
// rs1_val==65535 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x667, x2, 1116, x3)

inst_298:
// rs1_val==65535 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x2e, x2, 1120, x3)

inst_299:
// rs1_val==65535 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x1, x2, 1124, x3)

inst_300:
// rs1_val==65535 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffff, 0x40, x2, 1128, x3)

inst_301:
// rs1_val==2 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x3, x2, 1132, x3)

inst_302:
// rs1_val==2 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x555, x2, 1136, x3)

inst_303:
// rs1_val==2 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0xaaa, x2, 1140, x3)

inst_304:
// rs1_val==2 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x5, x2, 1144, x3)

inst_305:
// rs1_val==2 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x333, x2, 1148, x3)

inst_306:
// rs1_val==2 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x666, x2, 1152, x3)

inst_307:
// rs1_val==2 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x2d, x2, 1156, x3)

inst_308:
// rs1_val==2 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2, 0x0, x2, 1160, x3)

inst_309:
// rs1_val==2 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x3f, x2, 1164, x3)

inst_310:
// rs1_val==2 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2, 0x2, x2, 1168, x3)

inst_311:
// rs1_val==2 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x554, x2, 1172, x3)

inst_312:
// rs1_val==2 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0xaa9, x2, 1176, x3)

inst_313:
// rs1_val==2 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x4, x2, 1180, x3)

inst_314:
// rs1_val==2 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x332, x2, 1184, x3)

inst_315:
// rs1_val==2 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x665, x2, 1188, x3)

inst_316:
// rs1_val==2 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x2c, x2, 1192, x3)

inst_317:
// rs1_val==2 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x3e, x2, 1196, x3)

inst_318:
// rs1_val==2 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x556, x2, 1200, x3)

inst_319:
// rs1_val==2 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0xaab, x2, 1204, x3)

inst_320:
// rs1_val==2 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x6, x2, 1208, x3)

inst_321:
// rs1_val==2 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x334, x2, 1212, x3)

inst_322:
// rs1_val==2 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x667, x2, 1216, x3)

inst_323:
// rs1_val==2 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x2e, x2, 1220, x3)

inst_324:
// rs1_val==2 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2, 0x1, x2, 1224, x3)

inst_325:
// rs1_val==2 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x40, x2, 1228, x3)

inst_326:
// rs1_val==1431655764 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x3, x2, 1232, x3)

inst_327:
// rs1_val==1431655764 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x555, x2, 1236, x3)

inst_328:
// rs1_val==1431655764 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555554, 0xaaa, x2, 1240, x3)

inst_329:
// rs1_val==1431655764 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x5, x2, 1244, x3)

inst_330:
// rs1_val==1431655764 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x333, x2, 1248, x3)

inst_331:
// rs1_val==1431655764 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x666, x2, 1252, x3)

inst_332:
// rs1_val==1431655764 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x2d, x2, 1256, x3)

inst_333:
// rs1_val==1431655764 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x0, x2, 1260, x3)

inst_334:
// rs1_val==1431655764 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x3f, x2, 1264, x3)

inst_335:
// rs1_val==1431655764 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x2, x2, 1268, x3)

inst_336:
// rs1_val==1431655764 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x554, x2, 1272, x3)

inst_337:
// rs1_val==1431655764 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555554, 0xaa9, x2, 1276, x3)

inst_338:
// rs1_val==1431655764 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x4, x2, 1280, x3)

inst_339:
// rs1_val==1431655764 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x332, x2, 1284, x3)

inst_340:
// rs1_val==1431655764 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x665, x2, 1288, x3)

inst_341:
// rs1_val==1431655764 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x2c, x2, 1292, x3)

inst_342:
// rs1_val==1431655764 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x3e, x2, 1296, x3)

inst_343:
// rs1_val==1431655764 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x556, x2, 1300, x3)

inst_344:
// rs1_val==1431655764 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555554, 0xaab, x2, 1304, x3)

inst_345:
// rs1_val==1431655764 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x6, x2, 1308, x3)

inst_346:
// rs1_val==1431655764 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x334, x2, 1312, x3)

inst_347:
// rs1_val==1431655764 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x667, x2, 1316, x3)

inst_348:
// rs1_val==1431655764 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x2e, x2, 1320, x3)

inst_349:
// rs1_val==1431655764 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x1, x2, 1324, x3)

inst_350:
// rs1_val==1431655764 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555554, 0x40, x2, 1328, x3)

inst_351:
// rs1_val==2863311529 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x3, x2, 1332, x3)

inst_352:
// rs1_val==2863311529 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x555, x2, 1336, x3)

inst_353:
// rs1_val==2863311529 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaa9, 0xaaa, x2, 1340, x3)

inst_354:
// rs1_val==2863311529 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x5, x2, 1344, x3)

inst_355:
// rs1_val==2863311529 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x333, x2, 1348, x3)

inst_356:
// rs1_val==2863311529 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x666, x2, 1352, x3)

inst_357:
// rs1_val==2863311529 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x2d, x2, 1356, x3)

inst_358:
// rs1_val==2863311529 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x0, x2, 1360, x3)

inst_359:
// rs1_val==2863311529 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x3f, x2, 1364, x3)

inst_360:
// rs1_val==2863311529 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x2, x2, 1368, x3)

inst_361:
// rs1_val==2863311529 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x554, x2, 1372, x3)

inst_362:
// rs1_val==2863311529 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaa9, 0xaa9, x2, 1376, x3)

inst_363:
// rs1_val==2863311529 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x4, x2, 1380, x3)

inst_364:
// rs1_val==2863311529 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x332, x2, 1384, x3)

inst_365:
// rs1_val==2863311529 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x665, x2, 1388, x3)

inst_366:
// rs1_val==2863311529 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x2c, x2, 1392, x3)

inst_367:
// rs1_val==2863311529 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x3e, x2, 1396, x3)

inst_368:
// rs1_val==2863311529 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x556, x2, 1400, x3)

inst_369:
// rs1_val==2863311529 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaa9, 0xaab, x2, 1404, x3)

inst_370:
// rs1_val==2863311529 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x6, x2, 1408, x3)

inst_371:
// rs1_val==2863311529 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x334, x2, 1412, x3)

inst_372:
// rs1_val==2863311529 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x667, x2, 1416, x3)

inst_373:
// rs1_val==2863311529 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x2e, x2, 1420, x3)

inst_374:
// rs1_val==2863311529 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x1, x2, 1424, x3)

inst_375:
// rs1_val==2863311529 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaa9;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaa9, 0x40, x2, 1428, x3)

inst_376:
// rs1_val==4 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x3, x2, 1432, x3)

inst_377:
// rs1_val==4 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x555, x2, 1436, x3)

inst_378:
// rs1_val==4 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0xaaa, x2, 1440, x3)

inst_379:
// rs1_val==4 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x5, x2, 1444, x3)

inst_380:
// rs1_val==4 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x333, x2, 1448, x3)

inst_381:
// rs1_val==4 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x666, x2, 1452, x3)

inst_382:
// rs1_val==4 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x2d, x2, 1456, x3)

inst_383:
// rs1_val==4 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x0, x2, 1460, x3)

inst_384:
// rs1_val==4 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x3f, x2, 1464, x3)

inst_385:
// rs1_val==4 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x2, x2, 1468, x3)

inst_386:
// rs1_val==4 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x554, x2, 1472, x3)

inst_387:
// rs1_val==4 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0xaa9, x2, 1476, x3)

inst_388:
// rs1_val==4 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x4, x2, 1480, x3)

inst_389:
// rs1_val==4 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x332, x2, 1484, x3)

inst_390:
// rs1_val==4 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x665, x2, 1488, x3)

inst_391:
// rs1_val==4 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x2c, x2, 1492, x3)

inst_392:
// rs1_val==4 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x3e, x2, 1496, x3)

inst_393:
// rs1_val==4 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x556, x2, 1500, x3)

inst_394:
// rs1_val==4 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0xaab, x2, 1504, x3)

inst_395:
// rs1_val==4 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x6, x2, 1508, x3)

inst_396:
// rs1_val==4 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x334, x2, 1512, x3)

inst_397:
// rs1_val==4 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x667, x2, 1516, x3)

inst_398:
// rs1_val==4 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x2e, x2, 1520, x3)

inst_399:
// rs1_val==4 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x40, x2, 1524, x3)

inst_400:
// rs1_val==858993458 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x3, x2, 1528, x3)

inst_401:
// rs1_val==858993458 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x555, x2, 1532, x3)

inst_402:
// rs1_val==858993458 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333332, 0xaaa, x2, 1536, x3)

inst_403:
// rs1_val==858993458 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x5, x2, 1540, x3)

inst_404:
// rs1_val==858993458 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x333, x2, 1544, x3)

inst_405:
// rs1_val==858993458 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x666, x2, 1548, x3)

inst_406:
// rs1_val==858993458 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x2d, x2, 1552, x3)

inst_407:
// rs1_val==858993458 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x0, x2, 1556, x3)

inst_408:
// rs1_val==858993458 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x3f, x2, 1560, x3)

inst_409:
// rs1_val==858993458 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x2, x2, 1564, x3)

inst_410:
// rs1_val==858993458 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x554, x2, 1568, x3)

inst_411:
// rs1_val==858993458 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333332, 0xaa9, x2, 1572, x3)

inst_412:
// rs1_val==858993458 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x4, x2, 1576, x3)

inst_413:
// rs1_val==858993458 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x332, x2, 1580, x3)

inst_414:
// rs1_val==858993458 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x665, x2, 1584, x3)

inst_415:
// rs1_val==858993458 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x2c, x2, 1588, x3)

inst_416:
// rs1_val==858993458 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x3e, x2, 1592, x3)

inst_417:
// rs1_val==858993458 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x556, x2, 1596, x3)

inst_418:
// rs1_val==858993458 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333332, 0xaab, x2, 1600, x3)

inst_419:
// rs1_val==858993458 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x6, x2, 1604, x3)

inst_420:
// rs1_val==858993458 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x334, x2, 1608, x3)

inst_421:
// rs1_val==858993458 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x667, x2, 1612, x3)

inst_422:
// rs1_val==858993458 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x2e, x2, 1616, x3)

inst_423:
// rs1_val==858993458 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x1, x2, 1620, x3)

inst_424:
// rs1_val==858993458 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333332, 0x40, x2, 1624, x3)

inst_425:
// rs1_val==1717986917 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x3, x2, 1628, x3)

inst_426:
// rs1_val==1717986917 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x555, x2, 1632, x3)

inst_427:
// rs1_val==1717986917 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666665, 0xaaa, x2, 1636, x3)

inst_428:
// rs1_val==1717986917 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x5, x2, 1640, x3)

inst_429:
// rs1_val==1717986917 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x333, x2, 1644, x3)

inst_430:
// rs1_val==1717986917 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x666, x2, 1648, x3)

inst_431:
// rs1_val==1717986917 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x2d, x2, 1652, x3)

inst_432:
// rs1_val==1717986917 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x0, x2, 1656, x3)

inst_433:
// rs1_val==1717986917 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x3f, x2, 1660, x3)

inst_434:
// rs1_val==1717986917 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x2, x2, 1664, x3)

inst_435:
// rs1_val==1717986917 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x554, x2, 1668, x3)

inst_436:
// rs1_val==1717986917 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666665, 0xaa9, x2, 1672, x3)

inst_437:
// rs1_val==1717986917 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x4, x2, 1676, x3)

inst_438:
// rs1_val==1717986917 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x332, x2, 1680, x3)

inst_439:
// rs1_val==1717986917 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x665, x2, 1684, x3)

inst_440:
// rs1_val==1717986917 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x2c, x2, 1688, x3)

inst_441:
// rs1_val==1717986917 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x3e, x2, 1692, x3)

inst_442:
// rs1_val==1717986917 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x556, x2, 1696, x3)

inst_443:
// rs1_val==65534 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x665, x2, 1700, x3)

inst_444:
// rs1_val==65534 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x2c, x2, 1704, x3)

inst_445:
// rs1_val==65534 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x3e, x2, 1708, x3)

inst_446:
// rs1_val==65534 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x556, x2, 1712, x3)

inst_447:
// rs1_val==65534 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffe, 0xaab, x2, 1716, x3)

inst_448:
// rs1_val==65534 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x6, x2, 1720, x3)

inst_449:
// rs1_val==65534 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x334, x2, 1724, x3)

inst_450:
// rs1_val==65534 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x667, x2, 1728, x3)

inst_451:
// rs1_val==65534 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x2e, x2, 1732, x3)

inst_452:
// rs1_val==65534 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x1, x2, 1736, x3)

inst_453:
// rs1_val==65534 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x40, x2, 1740, x3)

inst_454:
// rs1_val==1431655766 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x3, x2, 1744, x3)

inst_455:
// rs1_val==1431655766 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x555, x2, 1748, x3)

inst_456:
// rs1_val==1431655766 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555556, 0xaaa, x2, 1752, x3)

inst_457:
// rs1_val==1431655766 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x5, x2, 1756, x3)

inst_458:
// rs1_val==1431655766 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x333, x2, 1760, x3)

inst_459:
// rs1_val==1431655766 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x666, x2, 1764, x3)

inst_460:
// rs1_val==1431655766 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x2d, x2, 1768, x3)

inst_461:
// rs1_val==1431655766 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x0, x2, 1772, x3)

inst_462:
// rs1_val==1431655766 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x3f, x2, 1776, x3)

inst_463:
// rs1_val==1431655766 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x2, x2, 1780, x3)

inst_464:
// rs1_val==1431655766 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x554, x2, 1784, x3)

inst_465:
// rs1_val==1431655766 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555556, 0xaa9, x2, 1788, x3)

inst_466:
// rs1_val==1431655766 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x4, x2, 1792, x3)

inst_467:
// rs1_val==1431655766 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x332, x2, 1796, x3)

inst_468:
// rs1_val==1431655766 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x665, x2, 1800, x3)

inst_469:
// rs1_val==1431655766 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x2c, x2, 1804, x3)

inst_470:
// rs1_val==1431655766 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x3e, x2, 1808, x3)

inst_471:
// rs1_val==1431655766 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x556, x2, 1812, x3)

inst_472:
// rs1_val==1431655766 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x55555556, 0xaab, x2, 1816, x3)

inst_473:
// rs1_val==1431655766 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x6, x2, 1820, x3)

inst_474:
// rs1_val==1431655766 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x334, x2, 1824, x3)

inst_475:
// rs1_val==1431655766 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x667, x2, 1828, x3)

inst_476:
// rs1_val==1431655766 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x2e, x2, 1832, x3)

inst_477:
// rs1_val==1431655766 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x1, x2, 1836, x3)

inst_478:
// rs1_val==1431655766 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x55555556, 0x40, x2, 1840, x3)

inst_479:
// rs1_val==2863311531 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x3, x2, 1844, x3)

inst_480:
// rs1_val==2863311531 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x555, x2, 1848, x3)

inst_481:
// rs1_val==2863311531 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaab, 0xaaa, x2, 1852, x3)

inst_482:
// rs1_val==2863311531 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x5, x2, 1856, x3)

inst_483:
// rs1_val==2863311531 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x333, x2, 1860, x3)

inst_484:
// rs1_val==2863311531 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x666, x2, 1864, x3)

inst_485:
// rs1_val==2863311531 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x2d, x2, 1868, x3)

inst_486:
// rs1_val==2863311531 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x0, x2, 1872, x3)

inst_487:
// rs1_val==2863311531 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x3f, x2, 1876, x3)

inst_488:
// rs1_val==2863311531 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x2, x2, 1880, x3)

inst_489:
// rs1_val==2863311531 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x554, x2, 1884, x3)

inst_490:
// rs1_val==2863311531 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaab, 0xaa9, x2, 1888, x3)

inst_491:
// rs1_val==2863311531 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x4, x2, 1892, x3)

inst_492:
// rs1_val==2863311531 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x332, x2, 1896, x3)

inst_493:
// rs1_val==2863311531 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x665, x2, 1900, x3)

inst_494:
// rs1_val==2863311531 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x2c, x2, 1904, x3)

inst_495:
// rs1_val==2863311531 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x3e, x2, 1908, x3)

inst_496:
// rs1_val==2863311531 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x556, x2, 1912, x3)

inst_497:
// rs1_val==2863311531 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaab, 0xaab, x2, 1916, x3)

inst_498:
// rs1_val==2863311531 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x6, x2, 1920, x3)

inst_499:
// rs1_val==2863311531 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x334, x2, 1924, x3)

inst_500:
// rs1_val==2863311531 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x667, x2, 1928, x3)

inst_501:
// rs1_val==2863311531 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x2e, x2, 1932, x3)

inst_502:
// rs1_val==2863311531 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x1, x2, 1936, x3)

inst_503:
// rs1_val==2863311531 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaab;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaab, 0x40, x2, 1940, x3)

inst_504:
// rs1_val==6 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x3, x2, 1944, x3)

inst_505:
// rs1_val==6 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x555, x2, 1948, x3)

inst_506:
// rs1_val==6 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0xaaa, x2, 1952, x3)

inst_507:
// rs1_val==6 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x5, x2, 1956, x3)

inst_508:
// rs1_val==6 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x333, x2, 1960, x3)

inst_509:
// rs1_val==6 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x666, x2, 1964, x3)

inst_510:
// rs1_val==6 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x2d, x2, 1968, x3)

inst_511:
// rs1_val==6 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x0, x2, 1972, x3)

inst_512:
// rs1_val==6 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x3f, x2, 1976, x3)

inst_513:
// rs1_val==6 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x2, x2, 1980, x3)

inst_514:
// rs1_val==6 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x554, x2, 1984, x3)

inst_515:
// rs1_val==6 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0xaa9, x2, 1988, x3)

inst_516:
// rs1_val==6 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x4, x2, 1992, x3)

inst_517:
// rs1_val==6 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x332, x2, 1996, x3)

inst_518:
// rs1_val==6 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x665, x2, 2000, x3)

inst_519:
// rs1_val==6 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x2c, x2, 2004, x3)

inst_520:
// rs1_val==6 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x3e, x2, 2008, x3)

inst_521:
// rs1_val==6 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x556, x2, 2012, x3)

inst_522:
// rs1_val==6 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0xaab, x2, 2016, x3)

inst_523:
// rs1_val==6 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x6, x2, 2020, x3)

inst_524:
// rs1_val==6 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x334, x2, 2024, x3)

inst_525:
// rs1_val==6 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x667, x2, 2028, x3)

inst_526:
// rs1_val==6 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x2e, x2, 2032, x3)

inst_527:
// rs1_val==6 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x1, x2, 2036, x3)

inst_528:
// rs1_val==6 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x40, x2, 2040, x3)

inst_529:
// rs1_val==858993460 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x3, x2, 2044, x3)
RVTEST_SIGBASE( x2,signature_x2_1)

inst_530:
// rs1_val==858993460 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x555, x2, 0, x3)

inst_531:
// rs1_val==858993460 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333334, 0xaaa, x2, 4, x3)

inst_532:
// rs1_val==858993460 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x5, x2, 8, x3)

inst_533:
// rs1_val==858993460 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x333, x2, 12, x3)

inst_534:
// rs1_val==858993460 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x666, x2, 16, x3)

inst_535:
// rs1_val==858993460 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x2d, x2, 20, x3)

inst_536:
// rs1_val==858993460 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x0, x2, 24, x3)

inst_537:
// rs1_val==858993460 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x3f, x2, 28, x3)

inst_538:
// rs1_val==858993460 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x2, x2, 32, x3)

inst_539:
// rs1_val==858993460 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x554, x2, 36, x3)

inst_540:
// rs1_val==858993460 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333334, 0xaa9, x2, 40, x3)

inst_541:
// rs1_val==858993460 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x4, x2, 44, x3)

inst_542:
// rs1_val==858993460 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x332, x2, 48, x3)

inst_543:
// rs1_val==858993460 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x665, x2, 52, x3)

inst_544:
// rs1_val==858993460 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x2c, x2, 56, x3)

inst_545:
// rs1_val==858993460 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x3e, x2, 60, x3)

inst_546:
// rs1_val==858993460 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x556, x2, 64, x3)

inst_547:
// rs1_val==858993460 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x33333334, 0xaab, x2, 68, x3)

inst_548:
// rs1_val==858993460 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x6, x2, 72, x3)

inst_549:
// rs1_val==858993460 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x334, x2, 76, x3)

inst_550:
// rs1_val==858993460 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x667, x2, 80, x3)

inst_551:
// rs1_val==858993460 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x2e, x2, 84, x3)

inst_552:
// rs1_val==858993460 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x1, x2, 88, x3)

inst_553:
// rs1_val==858993460 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x33333334, 0x40, x2, 92, x3)

inst_554:
// rs1_val==1717986919 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x3, x2, 96, x3)

inst_555:
// rs1_val==1717986919 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x555, x2, 100, x3)

inst_556:
// rs1_val==1717986919 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666667, 0xaaa, x2, 104, x3)

inst_557:
// rs1_val==1717986919 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x5, x2, 108, x3)

inst_558:
// rs1_val==1717986919 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x333, x2, 112, x3)

inst_559:
// rs1_val==1717986919 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x666, x2, 116, x3)

inst_560:
// rs1_val==1717986919 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x2d, x2, 120, x3)

inst_561:
// rs1_val==1717986919 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x0, x2, 124, x3)

inst_562:
// rs1_val==1717986919 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x3f, x2, 128, x3)

inst_563:
// rs1_val==1717986919 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x2, x2, 132, x3)

inst_564:
// rs1_val==1717986919 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x554, x2, 136, x3)

inst_565:
// rs1_val==1717986919 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666667, 0xaa9, x2, 140, x3)

inst_566:
// rs1_val==1717986919 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x4, x2, 144, x3)

inst_567:
// rs1_val==1717986919 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x332, x2, 148, x3)

inst_568:
// rs1_val==1717986919 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x665, x2, 152, x3)

inst_569:
// rs1_val==1717986919 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x2c, x2, 156, x3)

inst_570:
// rs1_val==1717986919 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x3e, x2, 160, x3)

inst_571:
// rs1_val==65534 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x666, x2, 164, x3)

inst_572:
// rs1_val==1717986919 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x556, x2, 168, x3)

inst_573:
// rs1_val==1717986919 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666667, 0xaab, x2, 172, x3)

inst_574:
// rs1_val==1717986919 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x6, x2, 176, x3)

inst_575:
// rs1_val==1717986919 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x334, x2, 180, x3)

inst_576:
// rs1_val==1717986919 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x667, x2, 184, x3)

inst_577:
// rs1_val==1717986919 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x2e, x2, 188, x3)

inst_578:
// rs1_val==1717986919 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x1, x2, 192, x3)

inst_579:
// rs1_val==1717986919 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666667, 0x40, x2, 196, x3)

inst_580:
// rs1_val==46341 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x3, x2, 200, x3)

inst_581:
// rs1_val==46341 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x555, x2, 204, x3)

inst_582:
// rs1_val==46341 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb505, 0xaaa, x2, 208, x3)

inst_583:
// rs1_val==46341 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x5, x2, 212, x3)

inst_584:
// rs1_val==46341 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x333, x2, 216, x3)

inst_585:
// rs1_val==46341 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x666, x2, 220, x3)

inst_586:
// rs1_val==46341 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x2d, x2, 224, x3)

inst_587:
// rs1_val==46341 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x0, x2, 228, x3)

inst_588:
// rs1_val==46341 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x3f, x2, 232, x3)

inst_589:
// rs1_val==46341 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x2, x2, 236, x3)

inst_590:
// rs1_val==46341 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x554, x2, 240, x3)

inst_591:
// rs1_val==46341 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb505, 0xaa9, x2, 244, x3)

inst_592:
// rs1_val==46341 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x4, x2, 248, x3)

inst_593:
// rs1_val==46341 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x332, x2, 252, x3)

inst_594:
// rs1_val==46341 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x665, x2, 256, x3)

inst_595:
// rs1_val==46341 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x2c, x2, 260, x3)

inst_596:
// rs1_val==46341 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x3e, x2, 264, x3)

inst_597:
// rs1_val==46341 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x556, x2, 268, x3)

inst_598:
// rs1_val==46341 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb505, 0xaab, x2, 272, x3)

inst_599:
// rs1_val==46341 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x6, x2, 276, x3)

inst_600:
// rs1_val==46341 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x334, x2, 280, x3)

inst_601:
// rs1_val==46341 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x667, x2, 284, x3)

inst_602:
// rs1_val==46341 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x2e, x2, 288, x3)

inst_603:
// rs1_val==46341 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x1, x2, 292, x3)

inst_604:
// rs1_val==46341 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb505;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb505, 0x40, x2, 296, x3)

inst_605:
// rs1_val==1 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x3, x2, 300, x3)

inst_606:
// rs1_val==1 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x555, x2, 304, x3)

inst_607:
// rs1_val==1 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0xaaa, x2, 308, x3)

inst_608:
// rs1_val==1 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x5, x2, 312, x3)

inst_609:
// rs1_val==1 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x333, x2, 316, x3)

inst_610:
// rs1_val==1 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x666, x2, 320, x3)

inst_611:
// rs1_val==1 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x2d, x2, 324, x3)

inst_612:
// rs1_val==1 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x3f, x2, 328, x3)

inst_613:
// rs1_val==1 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x2, x2, 332, x3)

inst_614:
// rs1_val==1 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x554, x2, 336, x3)

inst_615:
// rs1_val==1 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0xaa9, x2, 340, x3)

inst_616:
// rs1_val==1 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x4, x2, 344, x3)

inst_617:
// rs1_val==1 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x332, x2, 348, x3)

inst_618:
// rs1_val==1 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x665, x2, 352, x3)

inst_619:
// rs1_val==1 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x2c, x2, 356, x3)

inst_620:
// rs1_val==1 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x3e, x2, 360, x3)

inst_621:
// rs1_val==1 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x556, x2, 364, x3)

inst_622:
// rs1_val==1 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0xaab, x2, 368, x3)

inst_623:
// rs1_val==1 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x6, x2, 372, x3)

inst_624:
// rs1_val==1 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x334, x2, 376, x3)

inst_625:
// rs1_val==1 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x667, x2, 380, x3)

inst_626:
// rs1_val==1 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x2e, x2, 384, x3)

inst_627:
// rs1_val==1 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x1, 0x1, x2, 388, x3)

inst_628:
// rs1_val==1 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x40, x2, 392, x3)

inst_629:
// rs1_val==65536 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x3, x2, 396, x3)

inst_630:
// rs1_val==65536 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x555, x2, 400, x3)

inst_631:
// rs1_val==65536 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x10000, 0xaaa, x2, 404, x3)

inst_632:
// rs1_val==65536 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x333, x2, 408, x3)

inst_633:
// rs1_val==65536 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x666, x2, 412, x3)

inst_634:
// rs1_val==65536 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x2d, x2, 416, x3)

inst_635:
// rs1_val==65536 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x0, x2, 420, x3)

inst_636:
// rs1_val==65536 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x3f, x2, 424, x3)

inst_637:
// rs1_val==65536 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x2, x2, 428, x3)

inst_638:
// rs1_val==65536 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x554, x2, 432, x3)

inst_639:
// rs1_val==65536 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x10000, 0xaa9, x2, 436, x3)

inst_640:
// rs1_val==65536 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x4, x2, 440, x3)

inst_641:
// rs1_val==65536 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x332, x2, 444, x3)

inst_642:
// rs1_val==65536 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x665, x2, 448, x3)

inst_643:
// rs1_val==65536 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x2c, x2, 452, x3)

inst_644:
// rs1_val==65536 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x3e, x2, 456, x3)

inst_645:
// rs1_val==65536 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x556, x2, 460, x3)

inst_646:
// rs1_val==65536 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x10000, 0xaab, x2, 464, x3)

inst_647:
// rs1_val==65536 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x6, x2, 468, x3)

inst_648:
// rs1_val==65536 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x334, x2, 472, x3)

inst_649:
// rs1_val==65536 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x667, x2, 476, x3)

inst_650:
// rs1_val==65536 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x2e, x2, 480, x3)

inst_651:
// rs1_val==65536 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x1, x2, 484, x3)

inst_652:
// rs1_val==65536 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x40, x2, 488, x3)

inst_653:
// rs1_val==1717986917 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x66666665, 0xaab, x2, 492, x3)

inst_654:
// rs1_val==1717986917 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x6, x2, 496, x3)

inst_655:
// rs1_val==1717986917 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x334, x2, 500, x3)

inst_656:
// rs1_val==1717986917 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x667, x2, 504, x3)

inst_657:
// rs1_val==1717986917 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x2e, x2, 508, x3)

inst_658:
// rs1_val==1717986917 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x1, x2, 512, x3)

inst_659:
// rs1_val==1717986917 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x66666665, 0x40, x2, 516, x3)

inst_660:
// rs1_val==46339 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x3, x2, 520, x3)

inst_661:
// rs1_val==46339 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x555, x2, 524, x3)

inst_662:
// rs1_val==46339 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb503, 0xaaa, x2, 528, x3)

inst_663:
// rs1_val==46339 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x5, x2, 532, x3)

inst_664:
// rs1_val==46339 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x333, x2, 536, x3)

inst_665:
// rs1_val==46339 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x666, x2, 540, x3)

inst_666:
// rs1_val==46339 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x2d, x2, 544, x3)

inst_667:
// rs1_val==46339 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x0, x2, 548, x3)

inst_668:
// rs1_val==46339 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x3f, x2, 552, x3)

inst_669:
// rs1_val==46339 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x2, x2, 556, x3)

inst_670:
// rs1_val==46339 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x554, x2, 560, x3)

inst_671:
// rs1_val==46339 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb503, 0xaa9, x2, 564, x3)

inst_672:
// rs1_val==46339 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x4, x2, 568, x3)

inst_673:
// rs1_val==46339 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x332, x2, 572, x3)

inst_674:
// rs1_val==46339 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x665, x2, 576, x3)

inst_675:
// rs1_val==46339 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x2c, x2, 580, x3)

inst_676:
// rs1_val==46339 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x3e, x2, 584, x3)

inst_677:
// rs1_val==46339 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x556, x2, 588, x3)

inst_678:
// rs1_val==46339 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb503, 0xaab, x2, 592, x3)

inst_679:
// rs1_val==46339 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x6, x2, 596, x3)

inst_680:
// rs1_val==46339 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x334, x2, 600, x3)

inst_681:
// rs1_val==46339 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x667, x2, 604, x3)

inst_682:
// rs1_val==46339 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x2e, x2, 608, x3)

inst_683:
// rs1_val==46339 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x1, x2, 612, x3)

inst_684:
// rs1_val==46339 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb503;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb503, 0x40, x2, 616, x3)

inst_685:
// rs1_val==65534 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x3, x2, 620, x3)

inst_686:
// rs1_val==65534 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x555, x2, 624, x3)

inst_687:
// rs1_val==65534 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffe, 0xaaa, x2, 628, x3)

inst_688:
// rs1_val==65534 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x5, x2, 632, x3)

inst_689:
// rs1_val==65534 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x333, x2, 636, x3)

inst_690:
// rs1_val==65534 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x2d, x2, 640, x3)

inst_691:
// rs1_val==65534 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x0, x2, 644, x3)

inst_692:
// rs1_val==65534 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x3f, x2, 648, x3)

inst_693:
// rs1_val==65534 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x2, x2, 652, x3)

inst_694:
// rs1_val==65534 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x554, x2, 656, x3)

inst_695:
// rs1_val==65534 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffe, 0xaa9, x2, 660, x3)

inst_696:
// rs1_val==65534 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x4, x2, 664, x3)

inst_697:
// rs1_val==65534 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffe;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffe, 0x332, x2, 668, x3)

inst_698:
// imm_val == 4094, rs1_val == 16
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10;  immval:0xffe
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x10, 0xffe, x2, 672, x3)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x7_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x7_1:
    .fill 18*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 512*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 169*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
