
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:36:11 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32i.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the srai instruction of the RISC-V I extension for the srai covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",srai)

RVTEST_SIGBASE( x4,signature_x4_1)

inst_0:
// rs1 != rd, rs1==x31, rd==x25, rs1_val < 0 and imm_val > 0 and imm_val < xlen, rs1_val == -9
// opcode: srai ; op1:x31; dest:x25; op1val:-0x9;  immval:0x9
TEST_IMM_OP( srai, x25, x31, -0x1, -0x9, 0x9, x4, 0, x6)

inst_1:
// rs1 == rd, rs1==x10, rd==x10, rs1_val > 0 and imm_val > 0 and imm_val < xlen, rs1_val==5, imm_val == 1
// opcode: srai ; op1:x10; dest:x10; op1val:0x5;  immval:0x1
TEST_IMM_OP( srai, x10, x10, 0x2, 0x5, 0x1, x4, 4, x6)

inst_2:
// rs1==x8, rd==x28, rs1_val < 0 and imm_val == 0, rs1_val == -16777217
// opcode: srai ; op1:x8; dest:x28; op1val:-0x1000001;  immval:0x0
TEST_IMM_OP( srai, x28, x8, -0x1000001, -0x1000001, 0x0, x4, 8, x6)

inst_3:
// rs1==x17, rd==x5, rs1_val > 0 and imm_val == 0, rs1_val == 1048576
// opcode: srai ; op1:x17; dest:x5; op1val:0x100000;  immval:0x0
TEST_IMM_OP( srai, x5, x17, 0x100000, 0x100000, 0x0, x4, 12, x6)

inst_4:
// rs1==x23, rd==x27, rs1_val < 0 and imm_val == (xlen-1), rs1_val == -131073
// opcode: srai ; op1:x23; dest:x27; op1val:-0x20001;  immval:0x1f
TEST_IMM_OP( srai, x27, x23, -0x1, -0x20001, 0x1f, x4, 16, x6)

inst_5:
// rs1==x13, rd==x20, rs1_val > 0 and imm_val == (xlen-1), rs1_val == 1 and imm_val >= 0 and imm_val < xlen, rs1_val == 1
// opcode: srai ; op1:x13; dest:x20; op1val:0x1;  immval:0x1f
TEST_IMM_OP( srai, x20, x13, 0x0, 0x1, 0x1f, x4, 20, x6)

inst_6:
// rs1==x22, rd==x11, rs1_val == imm_val and imm_val > 0 and imm_val < xlen, rs1_val==4, imm_val == 4, rs1_val == 4
// opcode: srai ; op1:x22; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( srai, x11, x22, 0x0, 0x4, 0x4, x4, 24, x6)

inst_7:
// rs1==x7, rd==x30, rs1_val == (-2**(xlen-1)) and imm_val >= 0 and imm_val < xlen, rs1_val == -2147483648
// opcode: srai ; op1:x7; dest:x30; op1val:-0x80000000;  immval:0x0
TEST_IMM_OP( srai, x30, x7, -0x80000000, -0x80000000, 0x0, x4, 28, x6)

inst_8:
// rs1==x18, rd==x14, rs1_val == 0 and imm_val >= 0 and imm_val < xlen, rs1_val==0
// opcode: srai ; op1:x18; dest:x14; op1val:0x0;  immval:0xe
TEST_IMM_OP( srai, x14, x18, 0x0, 0x0, 0xe, x4, 32, x6)

inst_9:
// rs1==x3, rd==x19, rs1_val == (2**(xlen-1)-1) and imm_val >= 0 and imm_val < xlen, rs1_val == 2147483647
// opcode: srai ; op1:x3; dest:x19; op1val:0x7fffffff;  immval:0x1f
TEST_IMM_OP( srai, x19, x3, 0x0, 0x7fffffff, 0x1f, x4, 36, x6)

inst_10:
// rs1==x25, rd==x29, rs1_val == 2, rs1_val==2
// opcode: srai ; op1:x25; dest:x29; op1val:0x2;  immval:0x11
TEST_IMM_OP( srai, x29, x25, 0x0, 0x2, 0x11, x4, 40, x6)

inst_11:
// rs1==x30, rd==x3, rs1_val == 8, 
// opcode: srai ; op1:x30; dest:x3; op1val:0x8;  immval:0x11
TEST_IMM_OP( srai, x3, x30, 0x0, 0x8, 0x11, x4, 44, x6)

inst_12:
// rs1==x2, rd==x22, rs1_val == 16, 
// opcode: srai ; op1:x2; dest:x22; op1val:0x10;  immval:0x12
TEST_IMM_OP( srai, x22, x2, 0x0, 0x10, 0x12, x4, 48, x6)

inst_13:
// rs1==x12, rd==x2, rs1_val == 32, 
// opcode: srai ; op1:x12; dest:x2; op1val:0x20;  immval:0xd
TEST_IMM_OP( srai, x2, x12, 0x0, 0x20, 0xd, x4, 52, x6)

inst_14:
// rs1==x1, rd==x12, rs1_val == 64, imm_val == 23
// opcode: srai ; op1:x1; dest:x12; op1val:0x40;  immval:0x17
TEST_IMM_OP( srai, x12, x1, 0x0, 0x40, 0x17, x4, 56, x6)

inst_15:
// rs1==x20, rd==x24, rs1_val == 128, 
// opcode: srai ; op1:x20; dest:x24; op1val:0x80;  immval:0x9
TEST_IMM_OP( srai, x24, x20, 0x0, 0x80, 0x9, x4, 60, x6)

inst_16:
// rs1==x11, rd==x0, rs1_val == 256, imm_val == 16
// opcode: srai ; op1:x11; dest:x0; op1val:0x100;  immval:0x10
TEST_IMM_OP( srai, x0, x11, 0, 0x100, 0x10, x4, 64, x6)

inst_17:
// rs1==x26, rd==x8, rs1_val == 512, 
// opcode: srai ; op1:x26; dest:x8; op1val:0x200;  immval:0x9
TEST_IMM_OP( srai, x8, x26, 0x1, 0x200, 0x9, x4, 68, x6)

inst_18:
// rs1==x9, rd==x17, rs1_val == 1024, 
// opcode: srai ; op1:x9; dest:x17; op1val:0x400;  immval:0x11
TEST_IMM_OP( srai, x17, x9, 0x0, 0x400, 0x11, x4, 72, x6)

inst_19:
// rs1==x16, rd==x23, rs1_val == 2048, imm_val == 27
// opcode: srai ; op1:x16; dest:x23; op1val:0x800;  immval:0x1b
TEST_IMM_OP( srai, x23, x16, 0x0, 0x800, 0x1b, x4, 76, x6)

inst_20:
// rs1==x14, rd==x13, rs1_val == 4096, 
// opcode: srai ; op1:x14; dest:x13; op1val:0x1000;  immval:0x5
TEST_IMM_OP( srai, x13, x14, 0x80, 0x1000, 0x5, x4, 80, x3)

inst_21:
// rs1==x21, rd==x7, rs1_val == 8192, 
// opcode: srai ; op1:x21; dest:x7; op1val:0x2000;  immval:0x1
TEST_IMM_OP( srai, x7, x21, 0x1000, 0x2000, 0x1, x4, 84, x3)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_22:
// rs1==x5, rd==x18, rs1_val == 16384, 
// opcode: srai ; op1:x5; dest:x18; op1val:0x4000;  immval:0x5
TEST_IMM_OP( srai, x18, x5, 0x200, 0x4000, 0x5, x2, 0, x3)

inst_23:
// rs1==x0, rd==x26, rs1_val == 32768, 
// opcode: srai ; op1:x0; dest:x26; op1val:0x0;  immval:0x11
TEST_IMM_OP( srai, x26, x0, 0x0, 0x0, 0x11, x2, 4, x3)

inst_24:
// rs1==x24, rd==x4, rs1_val == 65536, 
// opcode: srai ; op1:x24; dest:x4; op1val:0x10000;  immval:0xd
TEST_IMM_OP( srai, x4, x24, 0x8, 0x10000, 0xd, x2, 8, x3)

inst_25:
// rs1==x15, rd==x9, rs1_val == 131072, 
// opcode: srai ; op1:x15; dest:x9; op1val:0x20000;  immval:0x12
TEST_IMM_OP( srai, x9, x15, 0x0, 0x20000, 0x12, x2, 12, x3)

inst_26:
// rs1==x19, rd==x6, rs1_val == 262144, 
// opcode: srai ; op1:x19; dest:x6; op1val:0x40000;  immval:0x1f
TEST_IMM_OP( srai, x6, x19, 0x0, 0x40000, 0x1f, x2, 16, x3)

inst_27:
// rs1==x28, rd==x21, rs1_val == 524288, imm_val == 21
// opcode: srai ; op1:x28; dest:x21; op1val:0x80000;  immval:0x15
TEST_IMM_OP( srai, x21, x28, 0x0, 0x80000, 0x15, x2, 20, x3)

inst_28:
// rs1==x27, rd==x31, rs1_val == 2097152, 
// opcode: srai ; op1:x27; dest:x31; op1val:0x200000;  immval:0x17
TEST_IMM_OP( srai, x31, x27, 0x0, 0x200000, 0x17, x2, 24, x3)

inst_29:
// rs1==x6, rd==x1, rs1_val == 4194304, 
// opcode: srai ; op1:x6; dest:x1; op1val:0x400000;  immval:0x12
TEST_IMM_OP( srai, x1, x6, 0x10, 0x400000, 0x12, x2, 28, x3)

inst_30:
// rs1==x4, rd==x15, rs1_val == 8388608, 
// opcode: srai ; op1:x4; dest:x15; op1val:0x800000;  immval:0xb
TEST_IMM_OP( srai, x15, x4, 0x1000, 0x800000, 0xb, x2, 32, x3)

inst_31:
// rs1==x29, rd==x16, rs1_val == 16777216, 
// opcode: srai ; op1:x29; dest:x16; op1val:0x1000000;  immval:0x1f
TEST_IMM_OP( srai, x16, x29, 0x0, 0x1000000, 0x1f, x2, 36, x3)

inst_32:
// rs1_val == 33554432, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x2000000;  immval:0x0
TEST_IMM_OP( srai, x11, x10, 0x2000000, 0x2000000, 0x0, x2, 40, x3)

inst_33:
// rs1_val == 67108864, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x6
TEST_IMM_OP( srai, x11, x10, 0x100000, 0x4000000, 0x6, x2, 44, x3)

inst_34:
// rs1_val == 134217728, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x7
TEST_IMM_OP( srai, x11, x10, 0x100000, 0x8000000, 0x7, x2, 48, x3)

inst_35:
// rs1_val == 268435456, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x0
TEST_IMM_OP( srai, x11, x10, 0x10000000, 0x10000000, 0x0, x2, 52, x3)

inst_36:
// rs1_val == 536870912, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x20000000;  immval:0xc
TEST_IMM_OP( srai, x11, x10, 0x20000, 0x20000000, 0xc, x2, 56, x3)

inst_37:
// rs1_val == 1073741824, imm_val == 8
// opcode: srai ; op1:x10; dest:x11; op1val:0x40000000;  immval:0x8
TEST_IMM_OP( srai, x11, x10, 0x400000, 0x40000000, 0x8, x2, 60, x3)

inst_38:
// rs1_val == -2, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x2;  immval:0x1
TEST_IMM_OP( srai, x11, x10, -0x1, -0x2, 0x1, x2, 64, x3)

inst_39:
// rs1_val == -3, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x3;  immval:0x10
TEST_IMM_OP( srai, x11, x10, -0x1, -0x3, 0x10, x2, 68, x3)

inst_40:
// rs1_val == -5, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x5;  immval:0x12
TEST_IMM_OP( srai, x11, x10, -0x1, -0x5, 0x12, x2, 72, x3)

inst_41:
// rs1_val == -17, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x11;  immval:0x0
TEST_IMM_OP( srai, x11, x10, -0x11, -0x11, 0x0, x2, 76, x3)

inst_42:
// rs1_val == -33, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x21;  immval:0x8
TEST_IMM_OP( srai, x11, x10, -0x1, -0x21, 0x8, x2, 80, x3)

inst_43:
// rs1_val == -65, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x41;  immval:0x4
TEST_IMM_OP( srai, x11, x10, -0x5, -0x41, 0x4, x2, 84, x3)

inst_44:
// rs1_val == -129, imm_val == 15
// opcode: srai ; op1:x10; dest:x11; op1val:-0x81;  immval:0xf
TEST_IMM_OP( srai, x11, x10, -0x1, -0x81, 0xf, x2, 88, x3)

inst_45:
// rs1_val == -257, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x101;  immval:0xb
TEST_IMM_OP( srai, x11, x10, -0x1, -0x101, 0xb, x2, 92, x3)

inst_46:
// rs1_val == -513, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x201;  immval:0xd
TEST_IMM_OP( srai, x11, x10, -0x1, -0x201, 0xd, x2, 96, x3)

inst_47:
// rs1_val == -1025, imm_val == 30
// opcode: srai ; op1:x10; dest:x11; op1val:-0x401;  immval:0x1e
TEST_IMM_OP( srai, x11, x10, -0x1, -0x401, 0x1e, x2, 100, x3)

inst_48:
// rs1_val == -2049, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x801;  immval:0xd
TEST_IMM_OP( srai, x11, x10, -0x1, -0x801, 0xd, x2, 104, x3)

inst_49:
// rs1_val == -4097, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x1001;  immval:0xf
TEST_IMM_OP( srai, x11, x10, -0x1, -0x1001, 0xf, x2, 108, x3)

inst_50:
// rs1_val == -8193, imm_val == 29
// opcode: srai ; op1:x10; dest:x11; op1val:-0x2001;  immval:0x1d
TEST_IMM_OP( srai, x11, x10, -0x1, -0x2001, 0x1d, x2, 112, x3)

inst_51:
// rs1_val == -16385, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x3
TEST_IMM_OP( srai, x11, x10, -0x801, -0x4001, 0x3, x2, 116, x3)

inst_52:
// rs1_val == -32769, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x0
TEST_IMM_OP( srai, x11, x10, -0x8001, -0x8001, 0x0, x2, 120, x3)

inst_53:
// rs1_val == -65537, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x10001;  immval:0xd
TEST_IMM_OP( srai, x11, x10, -0x9, -0x10001, 0xd, x2, 124, x3)

inst_54:
// rs1_val == -262145, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x11
TEST_IMM_OP( srai, x11, x10, -0x3, -0x40001, 0x11, x2, 128, x3)

inst_55:
// rs1_val == -524289, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x80001;  immval:0x9
TEST_IMM_OP( srai, x11, x10, -0x401, -0x80001, 0x9, x2, 132, x3)

inst_56:
// rs1_val == -1048577, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x100001;  immval:0x1
TEST_IMM_OP( srai, x11, x10, -0x80001, -0x100001, 0x1, x2, 136, x3)

inst_57:
// rs1_val == -2097153, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x200001;  immval:0x11
TEST_IMM_OP( srai, x11, x10, -0x11, -0x200001, 0x11, x2, 140, x3)

inst_58:
// rs1_val == -4194305, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x11
TEST_IMM_OP( srai, x11, x10, -0x21, -0x400001, 0x11, x2, 144, x3)

inst_59:
// rs1_val == -8388609, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x800001;  immval:0xe
TEST_IMM_OP( srai, x11, x10, -0x201, -0x800001, 0xe, x2, 148, x3)

inst_60:
// rs1_val == -33554433, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x2000001;  immval:0x4
TEST_IMM_OP( srai, x11, x10, -0x200001, -0x2000001, 0x4, x2, 152, x3)

inst_61:
// rs1_val == -67108865, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x12
TEST_IMM_OP( srai, x11, x10, -0x101, -0x4000001, 0x12, x2, 156, x3)

inst_62:
// rs1_val == -134217729, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0xd
TEST_IMM_OP( srai, x11, x10, -0x4001, -0x8000001, 0xd, x2, 160, x3)

inst_63:
// rs1_val == -268435457, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0x3
TEST_IMM_OP( srai, x11, x10, -0x2000001, -0x10000001, 0x3, x2, 164, x3)

inst_64:
// rs1_val == -536870913, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x20000001;  immval:0x7
TEST_IMM_OP( srai, x11, x10, -0x400001, -0x20000001, 0x7, x2, 168, x3)

inst_65:
// rs1_val == -1073741825, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x13
TEST_IMM_OP( srai, x11, x10, -0x801, -0x40000001, 0x13, x2, 172, x3)

inst_66:
// rs1_val == 1431655765, rs1_val==1431655765
// opcode: srai ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x15
TEST_IMM_OP( srai, x11, x10, 0x2aa, 0x55555555, 0x15, x2, 176, x3)

inst_67:
// rs1_val == -1431655766, rs1_val==-1431655766
// opcode: srai ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0xf
TEST_IMM_OP( srai, x11, x10, -0xaaab, -0x55555556, 0xf, x2, 180, x3)

inst_68:
// rs1_val==3, imm_val == 10
// opcode: srai ; op1:x10; dest:x11; op1val:0x3;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x0, 0x3, 0xa, x2, 184, x3)

inst_69:
// rs1_val==858993459, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x33333333;  immval:0x0
TEST_IMM_OP( srai, x11, x10, 0x33333333, 0x33333333, 0x0, x2, 188, x3)

inst_70:
// rs1_val==1717986919, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x66666667;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x199999, 0x66666667, 0xa, x2, 192, x3)

inst_71:
// rs1_val==-46339, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0xb503;  immval:0x1
TEST_IMM_OP( srai, x11, x10, -0x5a82, -0xb503, 0x1, x2, 196, x3)

inst_72:
// rs1_val==46341, 
// opcode: srai ; op1:x10; dest:x11; op1val:0xb505;  immval:0x0
TEST_IMM_OP( srai, x11, x10, 0xb505, 0xb505, 0x0, x2, 200, x3)

inst_73:
// imm_val == 2, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x2
TEST_IMM_OP( srai, x11, x10, 0x15555555, 0x55555555, 0x2, x2, 204, x3)

inst_74:
// rs1_val==1717986918, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x1b
TEST_IMM_OP( srai, x11, x10, 0xc, 0x66666666, 0x1b, x2, 208, x3)

inst_75:
// rs1_val==-46340, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0xb504;  immval:0xc
TEST_IMM_OP( srai, x11, x10, -0xc, -0xb504, 0xc, x2, 212, x3)

inst_76:
// rs1_val==46340, 
// opcode: srai ; op1:x10; dest:x11; op1val:0xb504;  immval:0x0
TEST_IMM_OP( srai, x11, x10, 0xb504, 0xb504, 0x0, x2, 216, x3)

inst_77:
// rs1_val==1431655764, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x6
TEST_IMM_OP( srai, x11, x10, 0x1555555, 0x55555554, 0x6, x2, 220, x3)

inst_78:
// rs1_val==858993458, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x1e
TEST_IMM_OP( srai, x11, x10, 0x0, 0x33333332, 0x1e, x2, 224, x3)

inst_79:
// rs1_val==1717986917, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x1f
TEST_IMM_OP( srai, x11, x10, 0x0, 0x66666665, 0x1f, x2, 228, x3)

inst_80:
// rs1_val==46339, 
// opcode: srai ; op1:x10; dest:x11; op1val:0xb503;  immval:0x17
TEST_IMM_OP( srai, x11, x10, 0x0, 0xb503, 0x17, x2, 232, x3)

inst_81:
// rs1_val==1431655766, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x55555556;  immval:0x1b
TEST_IMM_OP( srai, x11, x10, 0xa, 0x55555556, 0x1b, x2, 236, x3)

inst_82:
// rs1_val==-1431655765, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0xa
TEST_IMM_OP( srai, x11, x10, -0x155556, -0x55555555, 0xa, x2, 240, x3)

inst_83:
// rs1_val==6, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( srai, x11, x10, 0x0, 0x6, 0x6, x2, 244, x3)

inst_84:
// rs1_val==858993460, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x33333334;  immval:0xc
TEST_IMM_OP( srai, x11, x10, 0x33333, 0x33333334, 0xc, x2, 248, x3)

inst_85:
// rs1_val == 256, imm_val == 16
// opcode: srai ; op1:x10; dest:x11; op1val:0x100;  immval:0x10
TEST_IMM_OP( srai, x11, x10, 0x0, 0x100, 0x10, x2, 252, x3)

inst_86:
// rs1_val == 32768, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x8000;  immval:0x11
TEST_IMM_OP( srai, x11, x10, 0x0, 0x8000, 0x11, x2, 256, x3)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x4_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x4_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 65*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
