
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:36:11 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32i.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the srli instruction of the RISC-V I extension for the srli covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",srli)

RVTEST_SIGBASE( x5,signature_x5_1)

inst_0:
// rs1 != rd, rs1==x30, rd==x8, rs1_val < 0 and imm_val > 0 and imm_val < xlen, rs1_val==-46340, imm_val == 2
// opcode: srli ; op1:x30; dest:x8; op1val:-0xb504;  immval:0x2
TEST_IMM_OP( srli, x8, x30, 0x3fffd2bf, -0xb504, 0x2, x5, 0, x6)

inst_1:
// rs1 == rd, rs1==x17, rd==x17, rs1_val > 0 and imm_val > 0 and imm_val < xlen, 
// opcode: srli ; op1:x17; dest:x17; op1val:0x7;  immval:0x13
TEST_IMM_OP( srli, x17, x17, 0x0, 0x7, 0x13, x5, 4, x6)

inst_2:
// rs1==x27, rd==x19, rs1_val < 0 and imm_val == 0, 
// opcode: srli ; op1:x27; dest:x19; op1val:-0xb504;  immval:0x0
TEST_IMM_OP( srli, x19, x27, 0xffff4afc, -0xb504, 0x0, x5, 8, x6)

inst_3:
// rs1==x29, rd==x9, rs1_val > 0 and imm_val == 0, 
// opcode: srli ; op1:x29; dest:x9; op1val:0x3fffffff;  immval:0x0
TEST_IMM_OP( srli, x9, x29, 0x3fffffff, 0x3fffffff, 0x0, x5, 12, x6)

inst_4:
// rs1==x25, rd==x22, rs1_val < 0 and imm_val == (xlen-1), 
// opcode: srli ; op1:x25; dest:x22; op1val:-0xa;  immval:0x1f
TEST_IMM_OP( srli, x22, x25, 0x1, -0xa, 0x1f, x5, 16, x6)

inst_5:
// rs1==x1, rd==x13, rs1_val > 0 and imm_val == (xlen-1), rs1_val == 512
// opcode: srli ; op1:x1; dest:x13; op1val:0x200;  immval:0x1f
TEST_IMM_OP( srli, x13, x1, 0x0, 0x200, 0x1f, x5, 20, x6)

inst_6:
// rs1==x21, rd==x0, rs1_val == imm_val and imm_val > 0 and imm_val < xlen, rs1_val==3
// opcode: srli ; op1:x21; dest:x0; op1val:0x3;  immval:0x3
TEST_IMM_OP( srli, x0, x21, 0, 0x3, 0x3, x5, 24, x6)

inst_7:
// rs1==x0, rd==x29, rs1_val == (-2**(xlen-1)) and imm_val >= 0 and imm_val < xlen, rs1_val == -2147483648
// opcode: srli ; op1:x0; dest:x29; op1val:0x0;  immval:0x9
TEST_IMM_OP( srli, x29, x0, 0x0, 0x0, 0x9, x5, 28, x6)

inst_8:
// rs1==x16, rd==x18, rs1_val == 0 and imm_val >= 0 and imm_val < xlen, imm_val == 1, rs1_val==0
// opcode: srli ; op1:x16; dest:x18; op1val:0x0;  immval:0x1
TEST_IMM_OP( srli, x18, x16, 0x0, 0x0, 0x1, x5, 32, x6)

inst_9:
// rs1==x20, rd==x27, rs1_val == (2**(xlen-1)-1) and imm_val >= 0 and imm_val < xlen, rs1_val == 2147483647
// opcode: srli ; op1:x20; dest:x27; op1val:0x7fffffff;  immval:0x11
TEST_IMM_OP( srli, x27, x20, 0x3fff, 0x7fffffff, 0x11, x5, 36, x6)

inst_10:
// rs1==x31, rd==x2, rs1_val == 1 and imm_val >= 0 and imm_val < xlen, rs1_val == 1
// opcode: srli ; op1:x31; dest:x2; op1val:0x1;  immval:0x12
TEST_IMM_OP( srli, x2, x31, 0x0, 0x1, 0x12, x5, 40, x6)

inst_11:
// rs1==x7, rd==x31, rs1_val == 2, imm_val == 29, rs1_val==2
// opcode: srli ; op1:x7; dest:x31; op1val:0x2;  immval:0x1d
TEST_IMM_OP( srli, x31, x7, 0x0, 0x2, 0x1d, x5, 44, x6)

inst_12:
// rs1==x14, rd==x16, rs1_val == 4, rs1_val==4, imm_val == 15
// opcode: srli ; op1:x14; dest:x16; op1val:0x4;  immval:0xf
TEST_IMM_OP( srli, x16, x14, 0x0, 0x4, 0xf, x5, 48, x6)

inst_13:
// rs1==x12, rd==x25, rs1_val == 8, imm_val == 27
// opcode: srli ; op1:x12; dest:x25; op1val:0x8;  immval:0x1b
TEST_IMM_OP( srli, x25, x12, 0x0, 0x8, 0x1b, x5, 52, x6)

inst_14:
// rs1==x4, rd==x11, rs1_val == 16, 
// opcode: srli ; op1:x4; dest:x11; op1val:0x10;  immval:0xf
TEST_IMM_OP( srli, x11, x4, 0x0, 0x10, 0xf, x5, 56, x6)

inst_15:
// rs1==x24, rd==x23, rs1_val == 32, imm_val == 23
// opcode: srli ; op1:x24; dest:x23; op1val:0x20;  immval:0x17
TEST_IMM_OP( srli, x23, x24, 0x0, 0x20, 0x17, x5, 60, x6)

inst_16:
// rs1==x8, rd==x28, rs1_val == 64, 
// opcode: srli ; op1:x8; dest:x28; op1val:0x40;  immval:0xd
TEST_IMM_OP( srli, x28, x8, 0x0, 0x40, 0xd, x5, 64, x6)

inst_17:
// rs1==x15, rd==x30, rs1_val == 128, imm_val == 30
// opcode: srli ; op1:x15; dest:x30; op1val:0x80;  immval:0x1e
TEST_IMM_OP( srli, x30, x15, 0x0, 0x80, 0x1e, x5, 68, x6)

inst_18:
// rs1==x18, rd==x20, rs1_val == 256, 
// opcode: srli ; op1:x18; dest:x20; op1val:0x100;  immval:0x1f
TEST_IMM_OP( srli, x20, x18, 0x0, 0x100, 0x1f, x5, 72, x6)

inst_19:
// rs1==x13, rd==x14, rs1_val == 1024, 
// opcode: srli ; op1:x13; dest:x14; op1val:0x400;  immval:0x12
TEST_IMM_OP( srli, x14, x13, 0x0, 0x400, 0x12, x5, 76, x6)

inst_20:
// rs1==x11, rd==x3, rs1_val == 2048, 
// opcode: srli ; op1:x11; dest:x3; op1val:0x800;  immval:0xf
TEST_IMM_OP( srli, x3, x11, 0x0, 0x800, 0xf, x5, 80, x6)

inst_21:
// rs1==x23, rd==x26, rs1_val == 4096, 
// opcode: srli ; op1:x23; dest:x26; op1val:0x1000;  immval:0xf
TEST_IMM_OP( srli, x26, x23, 0x0, 0x1000, 0xf, x5, 84, x13)
RVTEST_SIGBASE( x8,signature_x8_0)

inst_22:
// rs1==x19, rd==x10, rs1_val == 8192, 
// opcode: srli ; op1:x19; dest:x10; op1val:0x2000;  immval:0x2
TEST_IMM_OP( srli, x10, x19, 0x800, 0x2000, 0x2, x8, 0, x13)

inst_23:
// rs1==x10, rd==x21, rs1_val == 16384, 
// opcode: srli ; op1:x10; dest:x21; op1val:0x4000;  immval:0xe
TEST_IMM_OP( srli, x21, x10, 0x1, 0x4000, 0xe, x8, 4, x13)

inst_24:
// rs1==x5, rd==x7, rs1_val == 32768, 
// opcode: srli ; op1:x5; dest:x7; op1val:0x8000;  immval:0x3
TEST_IMM_OP( srli, x7, x5, 0x1000, 0x8000, 0x3, x8, 8, x13)

inst_25:
// rs1==x2, rd==x5, rs1_val == 65536, 
// opcode: srli ; op1:x2; dest:x5; op1val:0x10000;  immval:0x17
TEST_IMM_OP( srli, x5, x2, 0x0, 0x10000, 0x17, x8, 12, x13)

inst_26:
// rs1==x28, rd==x6, rs1_val == 131072, 
// opcode: srli ; op1:x28; dest:x6; op1val:0x20000;  immval:0x11
TEST_IMM_OP( srli, x6, x28, 0x1, 0x20000, 0x11, x8, 16, x13)

inst_27:
// rs1==x3, rd==x12, rs1_val == 262144, 
// opcode: srli ; op1:x3; dest:x12; op1val:0x40000;  immval:0x7
TEST_IMM_OP( srli, x12, x3, 0x800, 0x40000, 0x7, x8, 20, x13)

inst_28:
// rs1==x26, rd==x4, rs1_val == 524288, 
// opcode: srli ; op1:x26; dest:x4; op1val:0x80000;  immval:0x1d
TEST_IMM_OP( srli, x4, x26, 0x0, 0x80000, 0x1d, x8, 24, x13)

inst_29:
// rs1==x9, rd==x24, rs1_val == 1048576, 
// opcode: srli ; op1:x9; dest:x24; op1val:0x100000;  immval:0x2
TEST_IMM_OP( srli, x24, x9, 0x40000, 0x100000, 0x2, x8, 28, x13)

inst_30:
// rs1==x6, rd==x15, rs1_val == 2097152, 
// opcode: srli ; op1:x6; dest:x15; op1val:0x200000;  immval:0x5
TEST_IMM_OP( srli, x15, x6, 0x10000, 0x200000, 0x5, x8, 32, x13)

inst_31:
// rs1==x22, rd==x1, rs1_val == 4194304, 
// opcode: srli ; op1:x22; dest:x1; op1val:0x400000;  immval:0xc
TEST_IMM_OP( srli, x1, x22, 0x400, 0x400000, 0xc, x8, 36, x13)

inst_32:
// rs1_val == 8388608, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x800000;  immval:0x9
TEST_IMM_OP( srli, x11, x10, 0x4000, 0x800000, 0x9, x8, 40, x13)

inst_33:
// rs1_val == 16777216, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x1000000;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0x400, 0x1000000, 0xe, x8, 44, x13)

inst_34:
// rs1_val == 33554432, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x2000000;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x400000, 0x2000000, 0x3, x8, 48, x13)

inst_35:
// rs1_val == 67108864, imm_val == 4
// opcode: srli ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x4
TEST_IMM_OP( srli, x11, x10, 0x400000, 0x4000000, 0x4, x8, 52, x13)

inst_36:
// rs1_val == 134217728, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x7
TEST_IMM_OP( srli, x11, x10, 0x100000, 0x8000000, 0x7, x8, 56, x13)

inst_37:
// rs1_val == 268435456, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x7
TEST_IMM_OP( srli, x11, x10, 0x200000, 0x10000000, 0x7, x8, 60, x13)

inst_38:
// rs1_val == 536870912, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x0
TEST_IMM_OP( srli, x11, x10, 0x20000000, 0x20000000, 0x0, x8, 64, x13)

inst_39:
// rs1_val == 1073741824, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x40000000;  immval:0x1e
TEST_IMM_OP( srli, x11, x10, 0x1, 0x40000000, 0x1e, x8, 68, x13)

inst_40:
// rs1_val == -2, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x2;  immval:0x1d
TEST_IMM_OP( srli, x11, x10, 0x7, -0x2, 0x1d, x8, 72, x13)

inst_41:
// rs1_val == -3, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x3;  immval:0xb
TEST_IMM_OP( srli, x11, x10, 0x1fffff, -0x3, 0xb, x8, 76, x13)

inst_42:
// rs1_val == -5, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x5;  immval:0x5
TEST_IMM_OP( srli, x11, x10, 0x7ffffff, -0x5, 0x5, x8, 80, x13)

inst_43:
// rs1_val == -9, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x9;  immval:0x1
TEST_IMM_OP( srli, x11, x10, 0x7ffffffb, -0x9, 0x1, x8, 84, x13)

inst_44:
// rs1_val == -17, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x11;  immval:0x1d
TEST_IMM_OP( srli, x11, x10, 0x7, -0x11, 0x1d, x8, 88, x13)

inst_45:
// rs1_val == -33, imm_val == 16
// opcode: srli ; op1:x10; dest:x11; op1val:-0x21;  immval:0x10
TEST_IMM_OP( srli, x11, x10, 0xffff, -0x21, 0x10, x8, 92, x13)

inst_46:
// rs1_val == -65, imm_val == 8
// opcode: srli ; op1:x10; dest:x11; op1val:-0x41;  immval:0x8
TEST_IMM_OP( srli, x11, x10, 0xffffff, -0x41, 0x8, x8, 96, x13)

inst_47:
// rs1_val == -129, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x81;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x3fff, -0x81, 0x12, x8, 100, x13)

inst_48:
// rs1_val == -257, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x101;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x1fffffdf, -0x101, 0x3, x8, 104, x13)

inst_49:
// rs1_val == -513, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x201;  immval:0x13
TEST_IMM_OP( srli, x11, x10, 0x1fff, -0x201, 0x13, x8, 108, x13)

inst_50:
// rs1_val == -1025, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x401;  immval:0x9
TEST_IMM_OP( srli, x11, x10, 0x7ffffd, -0x401, 0x9, x8, 112, x13)

inst_51:
// rs1_val == -2049, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x801;  immval:0x7
TEST_IMM_OP( srli, x11, x10, 0x1ffffef, -0x801, 0x7, x8, 116, x13)

inst_52:
// rs1_val == -4097, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x1001;  immval:0x0
TEST_IMM_OP( srli, x11, x10, 0xffffefff, -0x1001, 0x0, x8, 120, x13)

inst_53:
// rs1_val == -8193, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x2001;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0x3ffff, -0x2001, 0xe, x8, 124, x13)

inst_54:
// rs1_val == -16385, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x1
TEST_IMM_OP( srli, x11, x10, 0x7fffdfff, -0x4001, 0x1, x8, 128, x13)

inst_55:
// rs1_val == -32769, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x1d
TEST_IMM_OP( srli, x11, x10, 0x7, -0x8001, 0x1d, x8, 132, x13)

inst_56:
// rs1_val == -65537, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x10001;  immval:0x9
TEST_IMM_OP( srli, x11, x10, 0x7fff7f, -0x10001, 0x9, x8, 136, x13)

inst_57:
// rs1_val == -131073, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x20001;  immval:0x7
TEST_IMM_OP( srli, x11, x10, 0x1fffbff, -0x20001, 0x7, x8, 140, x13)

inst_58:
// rs1_val == -262145, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x13
TEST_IMM_OP( srli, x11, x10, 0x1fff, -0x40001, 0x13, x8, 144, x13)

inst_59:
// rs1_val == -524289, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x80001;  immval:0xf
TEST_IMM_OP( srli, x11, x10, 0x1ffef, -0x80001, 0xf, x8, 148, x13)

inst_60:
// rs1_val == -1048577, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x100001;  immval:0x10
TEST_IMM_OP( srli, x11, x10, 0xffef, -0x100001, 0x10, x8, 152, x13)

inst_61:
// rs1_val == -2097153, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x200001;  immval:0x6
TEST_IMM_OP( srli, x11, x10, 0x3ff7fff, -0x200001, 0x6, x8, 156, x13)

inst_62:
// rs1_val == -4194305, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x8
TEST_IMM_OP( srli, x11, x10, 0xffbfff, -0x400001, 0x8, x8, 160, x13)

inst_63:
// rs1_val == -8388609, imm_val == 10
// opcode: srli ; op1:x10; dest:x11; op1val:-0x800001;  immval:0xa
TEST_IMM_OP( srli, x11, x10, 0x3fdfff, -0x800001, 0xa, x8, 164, x13)

inst_64:
// rs1_val == -16777217, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x1000001;  immval:0xb
TEST_IMM_OP( srli, x11, x10, 0x1fdfff, -0x1000001, 0xb, x8, 168, x13)

inst_65:
// rs1_val == -33554433, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x2000001;  immval:0x1
TEST_IMM_OP( srli, x11, x10, 0x7effffff, -0x2000001, 0x1, x8, 172, x13)

inst_66:
// rs1_val == -67108865, imm_val == 21
// opcode: srli ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x7df, -0x4000001, 0x15, x8, 176, x13)

inst_67:
// rs1_val == -134217729, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x7bf, -0x8000001, 0x15, x8, 180, x13)

inst_68:
// rs1_val == -268435457, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0x3bfff, -0x10000001, 0xe, x8, 184, x13)

inst_69:
// rs1_val == -536870913, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x20000001;  immval:0x2
TEST_IMM_OP( srli, x11, x10, 0x37ffffff, -0x20000001, 0x2, x8, 188, x13)

inst_70:
// rs1_val == -1073741825, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x2fff, -0x40000001, 0x12, x8, 192, x13)

inst_71:
// rs1_val == 1431655765, rs1_val==1431655765
// opcode: srli ; op1:x10; dest:x11; op1val:0x55555555;  immval:0x13
TEST_IMM_OP( srli, x11, x10, 0xaaa, 0x55555555, 0x13, x8, 196, x13)

inst_72:
// rs1_val == -1431655766, rs1_val==-1431655766
// opcode: srli ; op1:x10; dest:x11; op1val:-0x55555556;  immval:0xc
TEST_IMM_OP( srli, x11, x10, 0xaaaaa, -0x55555556, 0xc, x8, 200, x13)

inst_73:
// rs1_val==5, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x0, 0x5, 0x3, x8, 204, x13)

inst_74:
// rs1_val==1717986919, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x66666667;  immval:0x17
TEST_IMM_OP( srli, x11, x10, 0xcc, 0x66666667, 0x17, x8, 208, x13)

inst_75:
// rs1_val==-46339, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0xb503;  immval:0xa
TEST_IMM_OP( srli, x11, x10, 0x3fffd2, -0xb503, 0xa, x8, 212, x13)

inst_76:
// rs1_val==46341, 
// opcode: srli ; op1:x10; dest:x11; op1val:0xb505;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x5, 0xb505, 0xd, x8, 216, x13)

inst_77:
// rs1_val==858993459, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x33333333;  immval:0xc
TEST_IMM_OP( srli, x11, x10, 0x33333, 0x33333333, 0xc, x8, 220, x13)

inst_78:
// rs1_val==1717986918, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x66666666;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x333, 0x66666666, 0x15, x8, 224, x13)

inst_79:
// rs1_val==46340, 
// opcode: srli ; op1:x10; dest:x11; op1val:0xb504;  immval:0xf
TEST_IMM_OP( srli, x11, x10, 0x1, 0xb504, 0xf, x8, 228, x13)

inst_80:
// rs1_val==1431655764, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x55555554;  immval:0x1d
TEST_IMM_OP( srli, x11, x10, 0x2, 0x55555554, 0x1d, x8, 232, x13)

inst_81:
// rs1_val==858993458, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x33333332;  immval:0x1b
TEST_IMM_OP( srli, x11, x10, 0x6, 0x33333332, 0x1b, x8, 236, x13)

inst_82:
// rs1_val==1717986917, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x66666665;  immval:0x9
TEST_IMM_OP( srli, x11, x10, 0x333333, 0x66666665, 0x9, x8, 240, x13)

inst_83:
// rs1_val==46339, 
// opcode: srli ; op1:x10; dest:x11; op1val:0xb503;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x0, 0xb503, 0x12, x8, 244, x13)

inst_84:
// rs1_val==1431655766, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x55555556;  immval:0xf
TEST_IMM_OP( srli, x11, x10, 0xaaaa, 0x55555556, 0xf, x8, 248, x13)

inst_85:
// rs1_val==-1431655765, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x55555555;  immval:0x1d
TEST_IMM_OP( srli, x11, x10, 0x5, -0x55555555, 0x1d, x8, 252, x13)

inst_86:
// rs1_val==6, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x6;  immval:0x1f
TEST_IMM_OP( srli, x11, x10, 0x0, 0x6, 0x1f, x8, 256, x13)

inst_87:
// rs1_val==858993460, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x33333334;  immval:0x6
TEST_IMM_OP( srli, x11, x10, 0xcccccc, 0x33333334, 0x6, x8, 260, x13)

inst_88:
// rs1_val == imm_val and imm_val > 0 and imm_val < xlen, rs1_val==3
// opcode: srli ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x0, 0x3, 0x3, x8, 264, x13)

inst_89:
// rs1_val == (-2**(xlen-1)) and imm_val >= 0 and imm_val < xlen, rs1_val == -2147483648
// opcode: srli ; op1:x10; dest:x11; op1val:-0x80000000;  immval:0x9
TEST_IMM_OP( srli, x11, x10, 0x400000, -0x80000000, 0x9, x8, 268, x13)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x5_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x5_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x8_0:
    .fill 68*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
