
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:41:59 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32im.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the mul instruction of the RISC-V M extension for the mul covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32IM")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*M.*);def TEST_CASE_1=True;",mul)

RVTEST_SIGBASE( x4,signature_x4_1)

inst_0:
// rs1 == rd != rs2, rs1==x31, rs2==x5, rd==x31, rs1_val > 0 and rs2_val > 0, rs2_val == 65536, rs1_val != rs2_val
// opcode: mul ; op1:x31; op2:x5; dest:x31; op1val:0x9;  op2val:0x10000
TEST_RR_OP(mul, x31, x31, x5, 0x90000, 0x9, 0x10000, x4, 0, x18)

inst_1:
// rs1 == rs2 != rd, rs1==x21, rs2==x21, rd==x8, rs1_val > 0 and rs2_val < 0, rs1_val == 32, rs2_val == -16385
// opcode: mul ; op1:x21; op2:x21; dest:x8; op1val:0x20;  op2val:0x20
TEST_RR_OP(mul, x8, x21, x21, 0x400, 0x20, 0x20, x4, 4, x18)

inst_2:
// rs2 == rd != rs1, rs1==x11, rs2==x23, rd==x23, rs1_val < 0 and rs2_val < 0, rs2_val == -134217729
// opcode: mul ; op1:x11; op2:x23; dest:x23; op1val:-0x55555555;  op2val:-0x8000001
TEST_RR_OP(mul, x23, x11, x23, 0xfd555555, -0x55555555, -0x8000001, x4, 8, x18)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x14, rs2==x20, rd==x7, rs1_val < 0 and rs2_val > 0, rs1_val == -513
// opcode: mul ; op1:x14; op2:x20; dest:x7; op1val:-0x201;  op2val:0x3
TEST_RR_OP(mul, x7, x14, x20, 0xfffff9fd, -0x201, 0x3, x4, 12, x18)

inst_4:
// rs1 == rs2 == rd, rs1==x15, rs2==x15, rd==x15, rs1_val == rs2_val, 
// opcode: mul ; op1:x15; op2:x15; dest:x15; op1val:-0x1;  op2val:-0x1
TEST_RR_OP(mul, x15, x15, x15, 0x1, -0x1, -0x1, x4, 16, x18)

inst_5:
// rs1==x25, rs2==x29, rd==x16, rs2_val == (-2**(xlen-1)), rs1_val == -262145, rs2_val == -2147483648
// opcode: mul ; op1:x25; op2:x29; dest:x16; op1val:-0x40001;  op2val:-0x80000000
TEST_RR_OP(mul, x16, x25, x29, 0x80000000, -0x40001, -0x80000000, x4, 20, x18)

inst_6:
// rs1==x29, rs2==x25, rd==x3, rs2_val == 0, rs1_val==1717986917 and rs2_val==0
// opcode: mul ; op1:x29; op2:x25; dest:x3; op1val:0x66666665;  op2val:0x0
TEST_RR_OP(mul, x3, x29, x25, 0x0, 0x66666665, 0x0, x4, 24, x18)

inst_7:
// rs1==x23, rs2==x28, rd==x17, rs2_val == (2**(xlen-1)-1), rs2_val == 2147483647
// opcode: mul ; op1:x23; op2:x28; dest:x17; op1val:0xb504;  op2val:0x7fffffff
TEST_RR_OP(mul, x17, x23, x28, 0xffff4afc, 0xb504, 0x7fffffff, x4, 28, x18)

inst_8:
// rs1==x2, rs2==x19, rd==x22, rs2_val == 1, rs1_val == 2
// opcode: mul ; op1:x2; op2:x19; dest:x22; op1val:0x2;  op2val:0x1
TEST_RR_OP(mul, x22, x2, x19, 0x2, 0x2, 0x1, x4, 32, x18)

inst_9:
// rs1==x20, rs2==x22, rd==x28, rs1_val == (-2**(xlen-1)), rs2_val == -65, rs1_val == -2147483648
// opcode: mul ; op1:x20; op2:x22; dest:x28; op1val:-0x80000000;  op2val:-0x41
TEST_RR_OP(mul, x28, x20, x22, 0x80000000, -0x80000000, -0x41, x4, 36, x18)

inst_10:
// rs1==x3, rs2==x6, rd==x2, rs1_val == 0, rs1_val==0 and rs2_val==0
// opcode: mul ; op1:x3; op2:x6; dest:x2; op1val:0x0;  op2val:0x0
TEST_RR_OP(mul, x2, x3, x6, 0x0, 0x0, 0x0, x4, 40, x18)

inst_11:
// rs1==x22, rs2==x11, rd==x5, rs1_val == (2**(xlen-1)-1), rs2_val == -129, rs1_val == 2147483647
// opcode: mul ; op1:x22; op2:x11; dest:x5; op1val:0x7fffffff;  op2val:-0x81
TEST_RR_OP(mul, x5, x22, x11, 0x80000081, 0x7fffffff, -0x81, x4, 44, x18)

inst_12:
// rs1==x7, rs2==x9, rd==x13, rs1_val == 1, rs2_val == -268435457
// opcode: mul ; op1:x7; op2:x9; dest:x13; op1val:0x1;  op2val:-0x10000001
TEST_RR_OP(mul, x13, x7, x9, 0xefffffff, 0x1, -0x10000001, x4, 48, x18)

inst_13:
// rs1==x10, rs2==x17, rd==x6, rs2_val == 2, rs1_val == 128
// opcode: mul ; op1:x10; op2:x17; dest:x6; op1val:0x80;  op2val:0x2
TEST_RR_OP(mul, x6, x10, x17, 0x100, 0x80, 0x2, x4, 52, x18)

inst_14:
// rs1==x1, rs2==x2, rd==x30, rs2_val == 4, rs1_val==-46339 and rs2_val==4
// opcode: mul ; op1:x1; op2:x2; dest:x30; op1val:-0xb503;  op2val:0x4
TEST_RR_OP(mul, x30, x1, x2, 0xfffd2bf4, -0xb503, 0x4, x4, 56, x18)

inst_15:
// rs1==x13, rs2==x1, rd==x25, rs2_val == 8, rs1_val == -536870913
// opcode: mul ; op1:x13; op2:x1; dest:x25; op1val:-0x20000001;  op2val:0x8
TEST_RR_OP(mul, x25, x13, x1, 0xfffffff8, -0x20000001, 0x8, x4, 60, x18)

inst_16:
// rs1==x16, rs2==x12, rd==x29, rs2_val == 16, rs1_val == -2049
// opcode: mul ; op1:x16; op2:x12; dest:x29; op1val:-0x801;  op2val:0x10
TEST_RR_OP(mul, x29, x16, x12, 0xffff7ff0, -0x801, 0x10, x4, 64, x18)

inst_17:
// rs1==x27, rs2==x24, rd==x21, rs2_val == 32, rs1_val == 16384
// opcode: mul ; op1:x27; op2:x24; dest:x21; op1val:0x4000;  op2val:0x20
TEST_RR_OP(mul, x21, x27, x24, 0x80000, 0x4000, 0x20, x4, 68, x18)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_18:
// rs1==x19, rs2==x10, rd==x14, rs2_val == 64, 
// opcode: mul ; op1:x19; op2:x10; dest:x14; op1val:0xb504;  op2val:0x40
TEST_RR_OP(mul, x14, x19, x10, 0x2d4100, 0xb504, 0x40, x2, 0, x15)

inst_19:
// rs1==x6, rs2==x14, rd==x26, rs2_val == 128, rs1_val == -5
// opcode: mul ; op1:x6; op2:x14; dest:x26; op1val:-0x5;  op2val:0x80
TEST_RR_OP(mul, x26, x6, x14, 0xfffffd80, -0x5, 0x80, x2, 4, x15)

inst_20:
// rs1==x8, rs2==x18, rd==x12, rs2_val == 256, 
// opcode: mul ; op1:x8; op2:x18; dest:x12; op1val:0x5;  op2val:0x100
TEST_RR_OP(mul, x12, x8, x18, 0x500, 0x5, 0x100, x2, 8, x15)

inst_21:
// rs1==x30, rs2==x4, rd==x9, rs2_val == 512, rs1_val == -67108865
// opcode: mul ; op1:x30; op2:x4; dest:x9; op1val:-0x4000001;  op2val:0x200
TEST_RR_OP(mul, x9, x30, x4, 0xfffffe00, -0x4000001, 0x200, x2, 12, x15)

inst_22:
// rs1==x5, rs2==x26, rd==x19, rs2_val == 1024, rs1_val == 8388608
// opcode: mul ; op1:x5; op2:x26; dest:x19; op1val:0x800000;  op2val:0x400
TEST_RR_OP(mul, x19, x5, x26, 0x0, 0x800000, 0x400, x2, 16, x15)

inst_23:
// rs1==x12, rs2==x13, rd==x18, rs2_val == 2048, rs1_val == -17
// opcode: mul ; op1:x12; op2:x13; dest:x18; op1val:-0x11;  op2val:0x800
TEST_RR_OP(mul, x18, x12, x13, 0xffff7800, -0x11, 0x800, x2, 20, x15)

inst_24:
// rs1==x18, rs2==x31, rd==x24, rs2_val == 4096, 
// opcode: mul ; op1:x18; op2:x31; dest:x24; op1val:0x33333332;  op2val:0x1000
TEST_RR_OP(mul, x24, x18, x31, 0x33332000, 0x33333332, 0x1000, x2, 24, x15)

inst_25:
// rs1==x9, rs2==x27, rd==x0, rs2_val == 8192, 
// opcode: mul ; op1:x9; op2:x27; dest:x0; op1val:0x9;  op2val:0x2000
TEST_RR_OP(mul, x0, x9, x27, 0, 0x9, 0x2000, x2, 28, x15)

inst_26:
// rs1==x17, rs2==x8, rd==x11, rs2_val == 16384, rs1_val == -2
// opcode: mul ; op1:x17; op2:x8; dest:x11; op1val:-0x2;  op2val:0x4000
TEST_RR_OP(mul, x11, x17, x8, 0xffff8000, -0x2, 0x4000, x2, 32, x15)

inst_27:
// rs1==x0, rs2==x16, rd==x10, rs2_val == 32768, 
// opcode: mul ; op1:x0; op2:x16; dest:x10; op1val:0x0;  op2val:0x8000
TEST_RR_OP(mul, x10, x0, x16, 0x0, 0x0, 0x8000, x2, 36, x15)

inst_28:
// rs1==x26, rs2==x30, rd==x1, rs2_val == 131072, rs1_val == -1431655766
// opcode: mul ; op1:x26; op2:x30; dest:x1; op1val:-0x55555556;  op2val:0x20000
TEST_RR_OP(mul, x1, x26, x30, 0x55540000, -0x55555556, 0x20000, x2, 40, x15)

inst_29:
// rs1==x4, rs2==x0, rd==x27, rs2_val == 262144, 
// opcode: mul ; op1:x4; op2:x0; dest:x27; op1val:0x33333334;  op2val:0x0
TEST_RR_OP(mul, x27, x4, x0, 0x0, 0x33333334, 0x0, x2, 44, x15)

inst_30:
// rs1==x24, rs2==x7, rd==x20, rs2_val == 524288, 
// opcode: mul ; op1:x24; op2:x7; dest:x20; op1val:-0x1;  op2val:0x80000
TEST_RR_OP(mul, x20, x24, x7, 0xfff80000, -0x1, 0x80000, x2, 48, x15)

inst_31:
// rs1==x28, rs2==x3, rd==x4, rs2_val == 1048576, rs1_val == -4194305
// opcode: mul ; op1:x28; op2:x3; dest:x4; op1val:-0x400001;  op2val:0x100000
TEST_RR_OP(mul, x4, x28, x3, 0xfff00000, -0x400001, 0x100000, x2, 52, x15)

inst_32:
// rs2_val == 2097152, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x4;  op2val:0x200000
TEST_RR_OP(mul, x12, x10, x11, 0xff800000, -0x4, 0x200000, x2, 56, x15)

inst_33:
// rs2_val == 4194304, rs1_val == -2097153
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:0x400000
TEST_RR_OP(mul, x12, x10, x11, 0xffc00000, -0x200001, 0x400000, x2, 60, x15)

inst_34:
// rs2_val == 8388608, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x800000
TEST_RR_OP(mul, x12, x10, x11, 0x1800000, 0x3, 0x800000, x2, 64, x15)

inst_35:
// rs2_val == 16777216, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x8;  op2val:0x1000000
TEST_RR_OP(mul, x12, x10, x11, 0xf8000000, -0x8, 0x1000000, x2, 68, x15)

inst_36:
// rs2_val == 33554432, rs1_val == -9
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:0x2000000
TEST_RR_OP(mul, x12, x10, x11, 0xee000000, -0x9, 0x2000000, x2, 72, x15)

inst_37:
// rs2_val == 67108864, rs1_val == 1048576
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0x4000000
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x100000, 0x4000000, x2, 76, x15)

inst_38:
// rs2_val == 134217728, rs1_val == -524289
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x8000000
TEST_RR_OP(mul, x12, x10, x11, 0xf8000000, -0x80001, 0x8000000, x2, 80, x15)

inst_39:
// rs2_val == 268435456, rs1_val == -8193
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x10000000
TEST_RR_OP(mul, x12, x10, x11, 0xf0000000, -0x2001, 0x10000000, x2, 84, x15)

inst_40:
// rs2_val == 536870912, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x20000000
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x20000000, x2, 88, x15)

inst_41:
// rs2_val == 1073741824, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:0x40000000
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x800000, 0x40000000, x2, 92, x15)

inst_42:
// rs2_val == -2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:-0x2
TEST_RR_OP(mul, x12, x10, x11, 0xffffffc0, 0x20, -0x2, x2, 96, x15)

inst_43:
// rs2_val == -3, rs1_val == 256
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:-0x3
TEST_RR_OP(mul, x12, x10, x11, 0xfffffd00, 0x100, -0x3, x2, 100, x15)

inst_44:
// rs2_val == -5, rs1_val == 524288
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:-0x5
TEST_RR_OP(mul, x12, x10, x11, 0xffd80000, 0x80000, -0x5, x2, 104, x15)

inst_45:
// rs2_val == -9, rs1_val == 8
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:-0x9
TEST_RR_OP(mul, x12, x10, x11, 0xffffffb8, 0x8, -0x9, x2, 108, x15)

inst_46:
// rs2_val == -17, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:-0x11
TEST_RR_OP(mul, x12, x10, x11, 0xff780000, 0x80000, -0x11, x2, 112, x15)

inst_47:
// rs2_val == -33, rs1_val == -3
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:-0x21
TEST_RR_OP(mul, x12, x10, x11, 0x63, -0x3, -0x21, x2, 116, x15)

inst_48:
// rs2_val == -257, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x101
TEST_RR_OP(mul, x12, x10, x11, 0xfffffcfd, 0x3, -0x101, x2, 120, x15)

inst_49:
// rs2_val == -513, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0x201
TEST_RR_OP(mul, x12, x10, x11, 0x156, -0x55555556, -0x201, x2, 124, x15)

inst_50:
// rs2_val == -1025, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x401
TEST_RR_OP(mul, x12, x10, x11, 0xffffebfb, 0x5, -0x401, x2, 128, x15)

inst_51:
// rs2_val == -2049, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:-0x801
TEST_RR_OP(mul, x12, x10, x11, 0x1002, -0x2, -0x801, x2, 132, x15)

inst_52:
// rs2_val == -4097, rs1_val == -134217729
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:-0x1001
TEST_RR_OP(mul, x12, x10, x11, 0x8001001, -0x8000001, -0x1001, x2, 136, x15)

inst_53:
// rs2_val == -8193, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0x2001
TEST_RR_OP(mul, x12, x10, x11, 0x66668cce, 0x33333332, -0x2001, x2, 140, x15)

inst_54:
// rs2_val == -32769, rs1_val == 512
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:-0x8001
TEST_RR_OP(mul, x12, x10, x11, 0xfefffe00, 0x200, -0x8001, x2, 144, x15)

inst_55:
// rs2_val == -65537, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0x10001
TEST_RR_OP(mul, x12, x10, x11, 0xb503b503, -0xb503, -0x10001, x2, 148, x15)

inst_56:
// rs2_val == -131073, rs1_val == 1431655765
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0x20001
TEST_RR_OP(mul, x12, x10, x11, 0xaaab, 0x55555555, -0x20001, x2, 152, x15)

inst_57:
// rs2_val == -262145, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:-0x40001
TEST_RR_OP(mul, x12, x10, x11, 0xc0003, -0x3, -0x40001, x2, 156, x15)

inst_58:
// rs2_val == -524289, rs1_val == -16385
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:-0x80001
TEST_RR_OP(mul, x12, x10, x11, 0x84001, -0x4001, -0x80001, x2, 160, x15)

inst_59:
// rs2_val == -1048577, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:-0x100001
TEST_RR_OP(mul, x12, x10, x11, 0x300001, -0x200001, -0x100001, x2, 164, x15)

inst_60:
// rs2_val == -2097153, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:-0x200001
TEST_RR_OP(mul, x12, x10, x11, 0xffffc000, 0x4000, -0x200001, x2, 168, x15)

inst_61:
// rs2_val == -4194305, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0x400001
TEST_RR_OP(mul, x12, x10, x11, 0xbebf4afb, 0xb505, -0x400001, x2, 172, x15)

inst_62:
// rs2_val == -8388609, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0x800001
TEST_RR_OP(mul, x12, x10, x11, 0x8200b504, -0xb504, -0x800001, x2, 176, x15)

inst_63:
// rs2_val == -16777217, rs1_val == -4097
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:-0x1000001
TEST_RR_OP(mul, x12, x10, x11, 0x1001001, -0x1001, -0x1000001, x2, 180, x15)

inst_64:
// rs2_val == -33554433, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x2000001
TEST_RR_OP(mul, x12, x10, x11, 0xf5fffffb, 0x5, -0x2000001, x2, 184, x15)

inst_65:
// rs2_val == -67108865, rs1_val == -33
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:-0x4000001
TEST_RR_OP(mul, x12, x10, x11, 0x84000021, -0x21, -0x4000001, x2, 188, x15)

inst_66:
// rs2_val == -536870913, rs1_val == -131073
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:-0x20000001
TEST_RR_OP(mul, x12, x10, x11, 0x20020001, -0x20001, -0x20000001, x2, 192, x15)

inst_67:
// rs2_val == -1073741825, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0x40000001
TEST_RR_OP(mul, x12, x10, x11, 0xb504, -0xb504, -0x40000001, x2, 196, x15)

inst_68:
// rs2_val == 1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x2aaaaab, -0x8000001, 0x55555555, x2, 200, x15)

inst_69:
// rs2_val == -1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x55000000, 0x800000, -0x55555556, x2, 204, x15)

inst_70:
// rs1_val == 4, rs1_val==4 and rs2_val==1431655764
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x55555550, 0x4, 0x55555554, x2, 208, x15)

inst_71:
// rs1_val == 16, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x9
TEST_RR_OP(mul, x12, x10, x11, 0x90, 0x10, 0x9, x2, 212, x15)

inst_72:
// rs1_val == 64, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x40, 0x0, x2, 216, x15)

inst_73:
// rs1_val == 1024, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:-0x101
TEST_RR_OP(mul, x12, x10, x11, 0xfffbfc00, 0x400, -0x101, x2, 220, x15)

inst_74:
// rs1_val == 2048, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x5a82000, 0x800, 0xb504, x2, 224, x15)

inst_75:
// rs1_val == 4096, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:-0x801
TEST_RR_OP(mul, x12, x10, x11, 0xff7ff000, 0x1000, -0x801, x2, 228, x15)

inst_76:
// rs1_val == 8192, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x6000, 0x2000, 0x3, x2, 232, x15)

inst_77:
// rs1_val == 32768, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x28000, 0x8000, 0x5, x2, 236, x15)

inst_78:
// rs1_val == 65536, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:-0xa
TEST_RR_OP(mul, x12, x10, x11, 0xfff60000, 0x10000, -0xa, x2, 240, x15)

inst_79:
// rs1_val == 131072, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x6a060000, 0x20000, 0xb503, x2, 244, x15)

inst_80:
// rs1_val == 262144, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x180000, 0x40000, 0x6, x2, 248, x15)

inst_81:
// rs1_val == 2097152, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:0x4000
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x200000, 0x4000, x2, 252, x15)

inst_82:
// rs1_val == 4194304, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:-0x800001
TEST_RR_OP(mul, x12, x10, x11, 0xffc00000, 0x400000, -0x800001, x2, 256, x15)

inst_83:
// rs1_val == 16777216, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x32000000, 0x1000000, 0x33333332, x2, 260, x15)

inst_84:
// rs1_val == 33554432, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0x40
TEST_RR_OP(mul, x12, x10, x11, 0x80000000, 0x2000000, 0x40, x2, 264, x15)

inst_85:
// rs1_val == 67108864, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:-0x20001
TEST_RR_OP(mul, x12, x10, x11, 0xfc000000, 0x4000000, -0x20001, x2, 268, x15)

inst_86:
// rs1_val == 134217728, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xa8000000, 0x8000000, 0x55555555, x2, 272, x15)

inst_87:
// rs1_val == 268435456, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0x40000000
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x10000000, 0x40000000, x2, 276, x15)

inst_88:
// rs1_val == 536870912, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x40
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x20000000, 0x40, x2, 280, x15)

inst_89:
// rs1_val == 1073741824, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0x40
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x40000000, 0x40, x2, 284, x15)

inst_90:
// rs1_val == -65, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:-0x8001
TEST_RR_OP(mul, x12, x10, x11, 0x208041, -0x41, -0x8001, x2, 288, x15)

inst_91:
// rs1_val == -129, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:-0x4
TEST_RR_OP(mul, x12, x10, x11, 0x204, -0x81, -0x4, x2, 292, x15)

inst_92:
// rs1_val == -257, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:-0x100001
TEST_RR_OP(mul, x12, x10, x11, 0x10100101, -0x101, -0x100001, x2, 296, x15)

inst_93:
// rs1_val == -1025, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, -0x401, 0x0, x2, 300, x15)

inst_94:
// rs1_val == -32769, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:-0x9
TEST_RR_OP(mul, x12, x10, x11, 0x48009, -0x8001, -0x9, x2, 304, x15)

inst_95:
// rs1_val == -65537, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:0x4000
TEST_RR_OP(mul, x12, x10, x11, 0xbfffc000, -0x10001, 0x4000, x2, 308, x15)

inst_96:
// rs1_val == -1048577, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:-0x200001
TEST_RR_OP(mul, x12, x10, x11, 0x300001, -0x100001, -0x200001, x2, 312, x15)

inst_97:
// rs1_val == -8388609, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:-0x3
TEST_RR_OP(mul, x12, x10, x11, 0x1800003, -0x800001, -0x3, x2, 316, x15)

inst_98:
// rs1_val == -16777217, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, -0x1000001, 0x0, x2, 320, x15)

inst_99:
// rs1_val == -33554433, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:-0x801
TEST_RR_OP(mul, x12, x10, x11, 0x2000801, -0x2000001, -0x801, x2, 324, x15)

inst_100:
// rs1_val == -268435457, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:-0x3
TEST_RR_OP(mul, x12, x10, x11, 0x30000003, -0x10000001, -0x3, x2, 328, x15)

inst_101:
// rs1_val == -1073741825, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0x2000000
TEST_RR_OP(mul, x12, x10, x11, 0xfe000000, -0x40000001, 0x2000000, x2, 332, x15)

inst_102:
// rs1_val==3 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x9, 0x3, 0x3, x2, 336, x15)

inst_103:
// rs1_val==3 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xffffffff, 0x3, 0x55555555, x2, 340, x15)

inst_104:
// rs1_val==3 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffe, 0x3, -0x55555556, x2, 344, x15)

inst_105:
// rs1_val==3 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xf, 0x3, 0x5, x2, 348, x15)

inst_106:
// rs1_val==3 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x99999999, 0x3, 0x33333333, x2, 352, x15)

inst_107:
// rs1_val==3 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x33333332, 0x3, 0x66666666, x2, 356, x15)

inst_108:
// rs1_val==3 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xfffde0f4, 0x3, -0xb504, x2, 360, x15)

inst_109:
// rs1_val==3 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x21f0c, 0x3, 0xb504, x2, 364, x15)

inst_110:
// rs1_val==3 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x6, 0x3, 0x2, x2, 368, x15)

inst_111:
// rs1_val==3 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffc, 0x3, 0x55555554, x2, 372, x15)

inst_112:
// rs1_val==3 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x3, 0x0, x2, 376, x15)

inst_113:
// rs1_val==3 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0xc, 0x3, 0x4, x2, 380, x15)

inst_114:
// rs1_val==3 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x99999996, 0x3, 0x33333332, x2, 384, x15)

inst_115:
// rs1_val==3 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x3333332f, 0x3, 0x66666665, x2, 388, x15)

inst_116:
// rs1_val==3 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x21f09, 0x3, 0xb503, x2, 392, x15)

inst_117:
// rs1_val==3 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x2, 0x3, 0x55555556, x2, 396, x15)

inst_118:
// rs1_val==3 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x1, 0x3, -0x55555555, x2, 400, x15)

inst_119:
// rs1_val==3 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x12, 0x3, 0x6, x2, 404, x15)

inst_120:
// rs1_val==3 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x9999999c, 0x3, 0x33333334, x2, 408, x15)

inst_121:
// rs1_val==3 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x33333335, 0x3, 0x66666667, x2, 412, x15)

inst_122:
// rs1_val==3 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xfffde0f7, 0x3, -0xb503, x2, 416, x15)

inst_123:
// rs1_val==3 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x21f0f, 0x3, 0xb505, x2, 420, x15)

inst_124:
// rs1_val==1431655765 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0xffffffff, 0x55555555, 0x3, x2, 424, x15)

inst_125:
// rs1_val==1431655765 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x38e38e39, 0x55555555, 0x55555555, x2, 428, x15)

inst_126:
// rs1_val==1431655765 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x71c71c72, 0x55555555, -0x55555556, x2, 432, x15)

inst_127:
// rs1_val==1431655765 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaa9, 0x55555555, 0x5, x2, 436, x15)

inst_128:
// rs1_val==1431655765 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xeeeeeeef, 0x55555555, 0x33333333, x2, 440, x15)

inst_129:
// rs1_val==1431655765 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0xddddddde, 0x55555555, 0x66666666, x2, 444, x15)

inst_130:
// rs1_val==1431655765 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x555591ac, 0x55555555, -0xb504, x2, 448, x15)

inst_131:
// rs1_val==1431655765 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xaaaa6e54, 0x55555555, 0xb504, x2, 452, x15)

inst_132:
// rs1_val==1431655765 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaaa, 0x55555555, 0x2, x2, 456, x15)

inst_133:
// rs1_val==1431655765 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xe38e38e4, 0x55555555, 0x55555554, x2, 460, x15)

inst_134:
// rs1_val==1431655765 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x55555555, 0x0, x2, 464, x15)

inst_135:
// rs1_val==1431655765 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x55555554, 0x55555555, 0x4, x2, 468, x15)

inst_136:
// rs1_val==1431655765 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x9999999a, 0x55555555, 0x33333332, x2, 472, x15)

inst_137:
// rs1_val==1431655765 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x88888889, 0x55555555, 0x66666665, x2, 476, x15)

inst_138:
// rs1_val==1431655765 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x555518ff, 0x55555555, 0xb503, x2, 480, x15)

inst_139:
// rs1_val==1431655765 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x8e38e38e, 0x55555555, 0x55555556, x2, 484, x15)

inst_140:
// rs1_val==1431655765 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xc71c71c7, 0x55555555, -0x55555555, x2, 488, x15)

inst_141:
// rs1_val==1431655765 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffe, 0x55555555, 0x6, x2, 492, x15)

inst_142:
// rs1_val==1431655765 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x44444444, 0x55555555, 0x33333334, x2, 496, x15)

inst_143:
// rs1_val==1431655765 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x33333333, 0x55555555, 0x66666667, x2, 500, x15)

inst_144:
// rs1_val==1431655765 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xaaaae701, 0x55555555, -0xb503, x2, 504, x15)

inst_145:
// rs1_val==1431655765 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0xffffc3a9, 0x55555555, 0xb505, x2, 508, x15)

inst_146:
// rs1_val==-1431655766 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffe, -0x55555556, 0x3, x2, 512, x15)

inst_147:
// rs1_val==-1431655766 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x71c71c72, -0x55555556, 0x55555555, x2, 516, x15)

inst_148:
// rs1_val==-1431655766 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xe38e38e4, -0x55555556, -0x55555556, x2, 520, x15)

inst_149:
// rs1_val==-1431655766 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x55555552, -0x55555556, 0x5, x2, 524, x15)

inst_150:
// rs1_val==-1431655766 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xddddddde, -0x55555556, 0x33333333, x2, 528, x15)

inst_151:
// rs1_val==-1431655766 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0xbbbbbbbc, -0x55555556, 0x66666666, x2, 532, x15)

inst_152:
// rs1_val==-1431655766 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xaaab2358, -0x55555556, -0xb504, x2, 536, x15)

inst_153:
// rs1_val==-1431655766 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x5554dca8, -0x55555556, 0xb504, x2, 540, x15)

inst_154:
// rs1_val==-1431655766 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x55555554, -0x55555556, 0x2, x2, 544, x15)

inst_155:
// rs1_val==-1431655766 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xc71c71c8, -0x55555556, 0x55555554, x2, 548, x15)

inst_156:
// rs1_val==-1431655766 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, -0x55555556, 0x0, x2, 552, x15)

inst_157:
// rs1_val==-1431655766 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaa8, -0x55555556, 0x4, x2, 556, x15)

inst_158:
// rs1_val==-1431655766 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x33333334, -0x55555556, 0x33333332, x2, 560, x15)

inst_159:
// rs1_val==-1431655766 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x11111112, -0x55555556, 0x66666665, x2, 564, x15)

inst_160:
// rs1_val==-1431655766 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xaaaa31fe, -0x55555556, 0xb503, x2, 568, x15)

inst_161:
// rs1_val==-1431655766 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x1c71c71c, -0x55555556, 0x55555556, x2, 572, x15)

inst_162:
// rs1_val==-1431655766 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x8e38e38e, -0x55555556, -0x55555555, x2, 576, x15)

inst_163:
// rs1_val==-1431655766 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffc, -0x55555556, 0x6, x2, 580, x15)

inst_164:
// rs1_val==-1431655766 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x88888888, -0x55555556, 0x33333334, x2, 584, x15)

inst_165:
// rs1_val==-1431655766 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x66666666, -0x55555556, 0x66666667, x2, 588, x15)

inst_166:
// rs1_val==-1431655766 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x5555ce02, -0x55555556, -0xb503, x2, 592, x15)

inst_167:
// rs1_val==-1431655766 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0xffff8752, -0x55555556, 0xb505, x2, 596, x15)

inst_168:
// rs1_val==5 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0xf, 0x5, 0x3, x2, 600, x15)

inst_169:
// rs1_val==5 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaa9, 0x5, 0x55555555, x2, 604, x15)

inst_170:
// rs1_val==5 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x55555552, 0x5, -0x55555556, x2, 608, x15)

inst_171:
// rs1_val==5 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x19, 0x5, 0x5, x2, 612, x15)

inst_172:
// rs1_val==5 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xffffffff, 0x5, 0x33333333, x2, 616, x15)

inst_173:
// rs1_val==5 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffe, 0x5, 0x66666666, x2, 620, x15)

inst_174:
// rs1_val==5 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xfffc76ec, 0x5, -0xb504, x2, 624, x15)

inst_175:
// rs1_val==5 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x38914, 0x5, 0xb504, x2, 628, x15)

inst_176:
// rs1_val==5 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xa, 0x5, 0x2, x2, 632, x15)

inst_177:
// rs1_val==5 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaa4, 0x5, 0x55555554, x2, 636, x15)

inst_178:
// rs1_val==5 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x5, 0x0, x2, 640, x15)

inst_179:
// rs1_val==5 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x14, 0x5, 0x4, x2, 644, x15)

inst_180:
// rs1_val==5 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffa, 0x5, 0x33333332, x2, 648, x15)

inst_181:
// rs1_val==5 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xfffffff9, 0x5, 0x66666665, x2, 652, x15)

inst_182:
// rs1_val==5 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x3890f, 0x5, 0xb503, x2, 656, x15)

inst_183:
// rs1_val==5 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaae, 0x5, 0x55555556, x2, 660, x15)

inst_184:
// rs1_val==5 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x55555557, 0x5, -0x55555555, x2, 664, x15)

inst_185:
// rs1_val==5 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x1e, 0x5, 0x6, x2, 668, x15)

inst_186:
// rs1_val==5 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x4, 0x5, 0x33333334, x2, 672, x15)

inst_187:
// rs1_val==5 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x3, 0x5, 0x66666667, x2, 676, x15)

inst_188:
// rs1_val==5 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xfffc76f1, 0x5, -0xb503, x2, 680, x15)

inst_189:
// rs1_val==5 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x38919, 0x5, 0xb505, x2, 684, x15)

inst_190:
// rs1_val==858993459 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x99999999, 0x33333333, 0x3, x2, 688, x15)

inst_191:
// rs1_val==858993459 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xeeeeeeef, 0x33333333, 0x55555555, x2, 692, x15)

inst_192:
// rs1_val==858993459 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xddddddde, 0x33333333, -0x55555556, x2, 696, x15)

inst_193:
// rs1_val==858993459 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xffffffff, 0x33333333, 0x5, x2, 700, x15)

inst_194:
// rs1_val==858993459 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xc28f5c29, 0x33333333, 0x33333333, x2, 704, x15)

inst_195:
// rs1_val==858993459 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x851eb852, 0x33333333, 0x66666666, x2, 708, x15)

inst_196:
// rs1_val==858993459 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x2434, 0x33333333, -0xb504, x2, 712, x15)

inst_197:
// rs1_val==858993459 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xffffdbcc, 0x33333333, 0xb504, x2, 716, x15)

inst_198:
// rs1_val==858993459 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x66666666, 0x33333333, 0x2, x2, 720, x15)

inst_199:
// rs1_val==858993459 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xbbbbbbbc, 0x33333333, 0x55555554, x2, 724, x15)

inst_200:
// rs1_val==858993459 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x33333333, 0x0, x2, 728, x15)

inst_201:
// rs1_val==858993459 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccc, 0x33333333, 0x4, x2, 732, x15)

inst_202:
// rs1_val==858993459 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x8f5c28f6, 0x33333333, 0x33333332, x2, 736, x15)

inst_203:
// rs1_val==858993459 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x51eb851f, 0x33333333, 0x66666665, x2, 740, x15)

inst_204:
// rs1_val==858993459 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xcccca899, 0x33333333, 0xb503, x2, 744, x15)

inst_205:
// rs1_val==858993459 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x22222222, 0x33333333, 0x55555556, x2, 748, x15)

inst_206:
// rs1_val==858993459 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x11111111, 0x33333333, -0x55555555, x2, 752, x15)

inst_207:
// rs1_val==858993459 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x33333332, 0x33333333, 0x6, x2, 756, x15)

inst_208:
// rs1_val==858993459 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0xf5c28f5c, 0x33333333, 0x33333334, x2, 760, x15)

inst_209:
// rs1_val==858993459 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0xb851eb85, 0x33333333, 0x66666667, x2, 764, x15)

inst_210:
// rs1_val==858993459 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x33335767, 0x33333333, -0xb503, x2, 768, x15)

inst_211:
// rs1_val==858993459 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x33330eff, 0x33333333, 0xb505, x2, 772, x15)

inst_212:
// rs1_val==1717986918 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x33333332, 0x66666666, 0x3, x2, 776, x15)

inst_213:
// rs1_val==1717986918 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xddddddde, 0x66666666, 0x55555555, x2, 780, x15)

inst_214:
// rs1_val==1717986918 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xbbbbbbbc, 0x66666666, -0x55555556, x2, 784, x15)

inst_215:
// rs1_val==1717986918 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffe, 0x66666666, 0x5, x2, 788, x15)

inst_216:
// rs1_val==1717986918 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x851eb852, 0x66666666, 0x33333333, x2, 792, x15)

inst_217:
// rs1_val==1717986918 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0xa3d70a4, 0x66666666, 0x66666666, x2, 796, x15)

inst_218:
// rs1_val==1717986918 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x4868, 0x66666666, -0xb504, x2, 800, x15)

inst_219:
// rs1_val==1717986918 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xffffb798, 0x66666666, 0xb504, x2, 804, x15)

inst_220:
// rs1_val==1717986918 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccc, 0x66666666, 0x2, x2, 808, x15)

inst_221:
// rs1_val==1717986918 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x77777778, 0x66666666, 0x55555554, x2, 812, x15)

inst_222:
// rs1_val==1717986918 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x66666666, 0x0, x2, 816, x15)

inst_223:
// rs1_val==1717986918 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x99999998, 0x66666666, 0x4, x2, 820, x15)

inst_224:
// rs1_val==1717986918 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x1eb851ec, 0x66666666, 0x33333332, x2, 824, x15)

inst_225:
// rs1_val==1717986918 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xa3d70a3e, 0x66666666, 0x66666665, x2, 828, x15)

inst_226:
// rs1_val==1717986918 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x99995132, 0x66666666, 0xb503, x2, 832, x15)

inst_227:
// rs1_val==1717986918 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x44444444, 0x66666666, 0x55555556, x2, 836, x15)

inst_228:
// rs1_val==1717986918 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x22222222, 0x66666666, -0x55555555, x2, 840, x15)

inst_229:
// rs1_val==1717986918 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x66666664, 0x66666666, 0x6, x2, 844, x15)

inst_230:
// rs1_val==1717986918 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0xeb851eb8, 0x66666666, 0x33333334, x2, 848, x15)

inst_231:
// rs1_val==1717986918 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x70a3d70a, 0x66666666, 0x66666667, x2, 852, x15)

inst_232:
// rs1_val==1717986918 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x6666aece, 0x66666666, -0xb503, x2, 856, x15)

inst_233:
// rs1_val==1717986918 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x66661dfe, 0x66666666, 0xb505, x2, 860, x15)

inst_234:
// rs1_val==-46340 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0xfffde0f4, -0xb504, 0x3, x2, 864, x15)

inst_235:
// rs1_val==-46340 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x555591ac, -0xb504, 0x55555555, x2, 868, x15)

inst_236:
// rs1_val==-46340 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xaaab2358, -0xb504, -0x55555556, x2, 872, x15)

inst_237:
// rs1_val==-46340 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xfffc76ec, -0xb504, 0x5, x2, 876, x15)

inst_238:
// rs1_val==-46340 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x2434, -0xb504, 0x33333333, x2, 880, x15)

inst_239:
// rs1_val==-46340 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x4868, -0xb504, 0x66666666, x2, 884, x15)

inst_240:
// rs1_val==-46340 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x7ffea810, -0xb504, -0xb504, x2, 888, x15)

inst_241:
// rs1_val==-46340 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x800157f0, -0xb504, 0xb504, x2, 892, x15)

inst_242:
// rs1_val==-46340 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xfffe95f8, -0xb504, 0x2, x2, 896, x15)

inst_243:
// rs1_val==-46340 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x555646b0, -0xb504, 0x55555554, x2, 900, x15)

inst_244:
// rs1_val==-46340 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, -0xb504, 0x0, x2, 904, x15)

inst_245:
// rs1_val==-46340 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0xfffd2bf0, -0xb504, 0x4, x2, 908, x15)

inst_246:
// rs1_val==-46340 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0xd938, -0xb504, 0x33333332, x2, 912, x15)

inst_247:
// rs1_val==-46340 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xfd6c, -0xb504, 0x66666665, x2, 916, x15)

inst_248:
// rs1_val==-46340 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x80020cf4, -0xb504, 0xb503, x2, 920, x15)

inst_249:
// rs1_val==-46340 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x5554dca8, -0xb504, 0x55555556, x2, 924, x15)

inst_250:
// rs1_val==-46340 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xaaaa6e54, -0xb504, -0x55555555, x2, 928, x15)

inst_251:
// rs1_val==-46340 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0xfffbc1e8, -0xb504, 0x6, x2, 932, x15)

inst_252:
// rs1_val==-46340 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0xffff6f30, -0xb504, 0x33333334, x2, 936, x15)

inst_253:
// rs1_val==-46340 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0xffff9364, -0xb504, 0x66666667, x2, 940, x15)

inst_254:
// rs1_val==-46340 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x7ffdf30c, -0xb504, -0xb503, x2, 944, x15)

inst_255:
// rs1_val==-46340 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x8000a2ec, -0xb504, 0xb505, x2, 948, x15)

inst_256:
// rs1_val==46340 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x21f0c, 0xb504, 0x3, x2, 952, x15)

inst_257:
// rs1_val==46340 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xaaaa6e54, 0xb504, 0x55555555, x2, 956, x15)

inst_258:
// rs1_val==46340 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x5554dca8, 0xb504, -0x55555556, x2, 960, x15)

inst_259:
// rs1_val==46340 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x38914, 0xb504, 0x5, x2, 964, x15)

inst_260:
// rs1_val==46340 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xffffdbcc, 0xb504, 0x33333333, x2, 968, x15)

inst_261:
// rs1_val==46340 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0xffffb798, 0xb504, 0x66666666, x2, 972, x15)

inst_262:
// rs1_val==46340 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x800157f0, 0xb504, -0xb504, x2, 976, x15)

inst_263:
// rs1_val==46340 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x7ffea810, 0xb504, 0xb504, x2, 980, x15)

inst_264:
// rs1_val==46340 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x16a08, 0xb504, 0x2, x2, 984, x15)

inst_265:
// rs1_val==46340 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xaaa9b950, 0xb504, 0x55555554, x2, 988, x15)

inst_266:
// rs1_val==46340 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0xb504, 0x0, x2, 992, x15)

inst_267:
// rs1_val==46340 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x2d410, 0xb504, 0x4, x2, 996, x15)

inst_268:
// rs1_val==46340 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0xffff26c8, 0xb504, 0x33333332, x2, 1000, x15)

inst_269:
// rs1_val==46340 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xffff0294, 0xb504, 0x66666665, x2, 1004, x15)

inst_270:
// rs1_val==46340 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x7ffdf30c, 0xb504, 0xb503, x2, 1008, x15)

inst_271:
// rs1_val==46340 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xaaab2358, 0xb504, 0x55555556, x2, 1012, x15)

inst_272:
// rs1_val==46340 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x555591ac, 0xb504, -0x55555555, x2, 1016, x15)

inst_273:
// rs1_val==46340 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x43e18, 0xb504, 0x6, x2, 1020, x15)

inst_274:
// rs1_val==46340 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x90d0, 0xb504, 0x33333334, x2, 1024, x15)

inst_275:
// rs1_val==46340 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x6c9c, 0xb504, 0x66666667, x2, 1028, x15)

inst_276:
// rs1_val==46340 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x80020cf4, 0xb504, -0xb503, x2, 1032, x15)

inst_277:
// rs1_val==46340 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x7fff5d14, 0xb504, 0xb505, x2, 1036, x15)

inst_278:
// rs1_val==2 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x6, 0x2, 0x3, x2, 1040, x15)

inst_279:
// rs1_val==2 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaaa, 0x2, 0x55555555, x2, 1044, x15)

inst_280:
// rs1_val==2 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x55555554, 0x2, -0x55555556, x2, 1048, x15)

inst_281:
// rs1_val==2 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xa, 0x2, 0x5, x2, 1052, x15)

inst_282:
// rs1_val==2 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x66666666, 0x2, 0x33333333, x2, 1056, x15)

inst_283:
// rs1_val==2 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccc, 0x2, 0x66666666, x2, 1060, x15)

inst_284:
// rs1_val==2 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xfffe95f8, 0x2, -0xb504, x2, 1064, x15)

inst_285:
// rs1_val==2 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x16a08, 0x2, 0xb504, x2, 1068, x15)

inst_286:
// rs1_val==2 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x4, 0x2, 0x2, x2, 1072, x15)

inst_287:
// rs1_val==2 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaa8, 0x2, 0x55555554, x2, 1076, x15)

inst_288:
// rs1_val==2 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x2, 0x0, x2, 1080, x15)

inst_289:
// rs1_val==2 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x8, 0x2, 0x4, x2, 1084, x15)

inst_290:
// rs1_val==2 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x66666664, 0x2, 0x33333332, x2, 1088, x15)

inst_291:
// rs1_val==2 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xccccccca, 0x2, 0x66666665, x2, 1092, x15)

inst_292:
// rs1_val==2 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x16a06, 0x2, 0xb503, x2, 1096, x15)

inst_293:
// rs1_val==2 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaac, 0x2, 0x55555556, x2, 1100, x15)

inst_294:
// rs1_val==2 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x55555556, 0x2, -0x55555555, x2, 1104, x15)

inst_295:
// rs1_val==2 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0xc, 0x2, 0x6, x2, 1108, x15)

inst_296:
// rs1_val==2 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x66666668, 0x2, 0x33333334, x2, 1112, x15)

inst_297:
// rs1_val==2 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0xccccccce, 0x2, 0x66666667, x2, 1116, x15)

inst_298:
// rs1_val==2 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xfffe95fa, 0x2, -0xb503, x2, 1120, x15)

inst_299:
// rs1_val==2 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x16a0a, 0x2, 0xb505, x2, 1124, x15)

inst_300:
// rs1_val==1431655764 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffc, 0x55555554, 0x3, x2, 1128, x15)

inst_301:
// rs1_val==1431655764 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xe38e38e4, 0x55555554, 0x55555555, x2, 1132, x15)

inst_302:
// rs1_val==1431655764 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xc71c71c8, 0x55555554, -0x55555556, x2, 1136, x15)

inst_303:
// rs1_val==1431655764 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaa4, 0x55555554, 0x5, x2, 1140, x15)

inst_304:
// rs1_val==1431655764 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xbbbbbbbc, 0x55555554, 0x33333333, x2, 1144, x15)

inst_305:
// rs1_val==1431655764 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x77777778, 0x55555554, 0x66666666, x2, 1148, x15)

inst_306:
// rs1_val==1431655764 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x555646b0, 0x55555554, -0xb504, x2, 1152, x15)

inst_307:
// rs1_val==1431655764 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xaaa9b950, 0x55555554, 0xb504, x2, 1156, x15)

inst_308:
// rs1_val==1431655764 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaa8, 0x55555554, 0x2, x2, 1160, x15)

inst_309:
// rs1_val==1431655764 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x8e38e390, 0x55555554, 0x55555554, x2, 1164, x15)

inst_310:
// rs1_val==1431655764 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x55555554, 0x0, x2, 1168, x15)

inst_311:
// rs1_val==1431655764 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x55555550, 0x55555554, 0x4, x2, 1172, x15)

inst_312:
// rs1_val==1431655764 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x66666668, 0x55555554, 0x33333332, x2, 1176, x15)

inst_313:
// rs1_val==1431655764 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x22222224, 0x55555554, 0x66666665, x2, 1180, x15)

inst_314:
// rs1_val==1431655764 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x555463fc, 0x55555554, 0xb503, x2, 1184, x15)

inst_315:
// rs1_val==1431655764 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x38e38e38, 0x55555554, 0x55555556, x2, 1188, x15)

inst_316:
// rs1_val==1431655764 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x1c71c71c, 0x55555554, -0x55555555, x2, 1192, x15)

inst_317:
// rs1_val==1431655764 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0xfffffff8, 0x55555554, 0x6, x2, 1196, x15)

inst_318:
// rs1_val==1431655764 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x11111110, 0x55555554, 0x33333334, x2, 1200, x15)

inst_319:
// rs1_val==1431655764 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccc, 0x55555554, 0x66666667, x2, 1204, x15)

inst_320:
// rs1_val==1431655764 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xaaab9c04, 0x55555554, -0xb503, x2, 1208, x15)

inst_321:
// rs1_val==1431655764 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0xffff0ea4, 0x55555554, 0xb505, x2, 1212, x15)

inst_322:
// rs1_val==0 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x3, x2, 1216, x15)

inst_323:
// rs1_val==0 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x55555555, x2, 1220, x15)

inst_324:
// rs1_val==0 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, -0x55555556, x2, 1224, x15)

inst_325:
// rs1_val==0 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x5, x2, 1228, x15)

inst_326:
// rs1_val==0 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x33333333, x2, 1232, x15)

inst_327:
// rs1_val==-1431655765 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x38e38e39, -0x55555555, -0x55555555, x2, 1236, x15)

inst_328:
// rs1_val==-1431655765 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x2, -0x55555555, 0x6, x2, 1240, x15)

inst_329:
// rs1_val==-1431655765 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0xbbbbbbbc, -0x55555555, 0x33333334, x2, 1244, x15)

inst_330:
// rs1_val==-1431655765 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccd, -0x55555555, 0x66666667, x2, 1248, x15)

inst_331:
// rs1_val==-1431655765 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x555518ff, -0x55555555, -0xb503, x2, 1252, x15)

inst_332:
// rs1_val==-1431655765 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x3c57, -0x55555555, 0xb505, x2, 1256, x15)

inst_333:
// rs1_val==6 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x12, 0x6, 0x3, x2, 1260, x15)

inst_334:
// rs1_val==6 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffe, 0x6, 0x55555555, x2, 1264, x15)

inst_335:
// rs1_val==6 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffc, 0x6, -0x55555556, x2, 1268, x15)

inst_336:
// rs1_val==6 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x1e, 0x6, 0x5, x2, 1272, x15)

inst_337:
// rs1_val==6 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x33333332, 0x6, 0x33333333, x2, 1276, x15)

inst_338:
// rs1_val==6 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x66666664, 0x6, 0x66666666, x2, 1280, x15)

inst_339:
// rs1_val==6 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xfffbc1e8, 0x6, -0xb504, x2, 1284, x15)

inst_340:
// rs1_val==6 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x43e18, 0x6, 0xb504, x2, 1288, x15)

inst_341:
// rs1_val==6 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xc, 0x6, 0x2, x2, 1292, x15)

inst_342:
// rs1_val==6 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xfffffff8, 0x6, 0x55555554, x2, 1296, x15)

inst_343:
// rs1_val==6 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x6, 0x0, x2, 1300, x15)

inst_344:
// rs1_val==6 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x18, 0x6, 0x4, x2, 1304, x15)

inst_345:
// rs1_val==6 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x3333332c, 0x6, 0x33333332, x2, 1308, x15)

inst_346:
// rs1_val==6 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x6666665e, 0x6, 0x66666665, x2, 1312, x15)

inst_347:
// rs1_val==6 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x43e12, 0x6, 0xb503, x2, 1316, x15)

inst_348:
// rs1_val==6 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x4, 0x6, 0x55555556, x2, 1320, x15)

inst_349:
// rs1_val==6 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x2, 0x6, -0x55555555, x2, 1324, x15)

inst_350:
// rs1_val==6 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x24, 0x6, 0x6, x2, 1328, x15)

inst_351:
// rs1_val==6 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x33333338, 0x6, 0x33333334, x2, 1332, x15)

inst_352:
// rs1_val==6 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x6666666a, 0x6, 0x66666667, x2, 1336, x15)

inst_353:
// rs1_val==6 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xfffbc1ee, 0x6, -0xb503, x2, 1340, x15)

inst_354:
// rs1_val==6 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x43e1e, 0x6, 0xb505, x2, 1344, x15)

inst_355:
// rs1_val==858993460 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x9999999c, 0x33333334, 0x3, x2, 1348, x15)

inst_356:
// rs1_val==858993460 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x44444444, 0x33333334, 0x55555555, x2, 1352, x15)

inst_357:
// rs1_val==858993460 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x88888888, 0x33333334, -0x55555556, x2, 1356, x15)

inst_358:
// rs1_val==858993460 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x4, 0x33333334, 0x5, x2, 1360, x15)

inst_359:
// rs1_val==858993460 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xf5c28f5c, 0x33333334, 0x33333333, x2, 1364, x15)

inst_360:
// rs1_val==858993460 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0xeb851eb8, 0x33333334, 0x66666666, x2, 1368, x15)

inst_361:
// rs1_val==858993460 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xffff6f30, 0x33333334, -0xb504, x2, 1372, x15)

inst_362:
// rs1_val==858993460 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x90d0, 0x33333334, 0xb504, x2, 1376, x15)

inst_363:
// rs1_val==858993460 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x66666668, 0x33333334, 0x2, x2, 1380, x15)

inst_364:
// rs1_val==858993460 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x11111110, 0x33333334, 0x55555554, x2, 1384, x15)

inst_365:
// rs1_val==858993460 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x33333334, 0x0, x2, 1388, x15)

inst_366:
// rs1_val==858993460 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0xccccccd0, 0x33333334, 0x4, x2, 1392, x15)

inst_367:
// rs1_val==858993460 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0xc28f5c28, 0x33333334, 0x33333332, x2, 1396, x15)

inst_368:
// rs1_val==858993460 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xb851eb84, 0x33333334, 0x66666665, x2, 1400, x15)

inst_369:
// rs1_val==858993460 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xcccd5d9c, 0x33333334, 0xb503, x2, 1404, x15)

inst_370:
// rs1_val==858993460 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x77777778, 0x33333334, 0x55555556, x2, 1408, x15)

inst_371:
// rs1_val==858993460 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xbbbbbbbc, 0x33333334, -0x55555555, x2, 1412, x15)

inst_372:
// rs1_val==858993460 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x33333338, 0x33333334, 0x6, x2, 1416, x15)

inst_373:
// rs1_val==858993460 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x28f5c290, 0x33333334, 0x33333334, x2, 1420, x15)

inst_374:
// rs1_val==858993460 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x1eb851ec, 0x33333334, 0x66666667, x2, 1424, x15)

inst_375:
// rs1_val==858993460 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x3332a264, 0x33333334, -0xb503, x2, 1428, x15)

inst_376:
// rs1_val==858993460 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x3333c404, 0x33333334, 0xb505, x2, 1432, x15)

inst_377:
// rs1_val==1717986919 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x33333335, 0x66666667, 0x3, x2, 1436, x15)

inst_378:
// rs1_val==1717986919 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x33333333, 0x66666667, 0x55555555, x2, 1440, x15)

inst_379:
// rs1_val==1717986919 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x66666666, 0x66666667, -0x55555556, x2, 1444, x15)

inst_380:
// rs1_val==1717986919 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x3, 0x66666667, 0x5, x2, 1448, x15)

inst_381:
// rs1_val==1717986919 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xb851eb85, 0x66666667, 0x33333333, x2, 1452, x15)

inst_382:
// rs1_val==1717986919 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x70a3d70a, 0x66666667, 0x66666666, x2, 1456, x15)

inst_383:
// rs1_val==1717986919 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xffff9364, 0x66666667, -0xb504, x2, 1460, x15)

inst_384:
// rs1_val==1717986919 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x6c9c, 0x66666667, 0xb504, x2, 1464, x15)

inst_385:
// rs1_val==1717986919 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xccccccce, 0x66666667, 0x2, x2, 1468, x15)

inst_386:
// rs1_val==1717986919 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccc, 0x66666667, 0x55555554, x2, 1472, x15)

inst_387:
// rs1_val==1717986919 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x66666667, 0x0, x2, 1476, x15)

inst_388:
// rs1_val==1717986919 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x9999999c, 0x66666667, 0x4, x2, 1480, x15)

inst_389:
// rs1_val==1717986919 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x51eb851e, 0x66666667, 0x33333332, x2, 1484, x15)

inst_390:
// rs1_val==1717986919 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xa3d70a3, 0x66666667, 0x66666665, x2, 1488, x15)

inst_391:
// rs1_val==1717986919 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x999a0635, 0x66666667, 0xb503, x2, 1492, x15)

inst_392:
// rs1_val==1717986919 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x9999999a, 0x66666667, 0x55555556, x2, 1496, x15)

inst_393:
// rs1_val==1717986919 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccd, 0x66666667, -0x55555555, x2, 1500, x15)

inst_394:
// rs1_val==1717986919 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x6666666a, 0x66666667, 0x6, x2, 1504, x15)

inst_395:
// rs1_val==1717986919 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x1eb851ec, 0x66666667, 0x33333334, x2, 1508, x15)

inst_396:
// rs1_val==1717986919 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0xd70a3d71, 0x66666667, 0x66666667, x2, 1512, x15)

inst_397:
// rs1_val==1717986919 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x6665f9cb, 0x66666667, -0xb503, x2, 1516, x15)

inst_398:
// rs1_val==1717986919 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x6666d303, 0x66666667, 0xb505, x2, 1520, x15)

inst_399:
// rs1_val==-46339 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0xfffde0f7, -0xb503, 0x3, x2, 1524, x15)

inst_400:
// rs1_val==-46339 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xaaaae701, -0xb503, 0x55555555, x2, 1528, x15)

inst_401:
// rs1_val==-46339 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x5555ce02, -0xb503, -0x55555556, x2, 1532, x15)

inst_402:
// rs1_val==-46339 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xfffc76f1, -0xb503, 0x5, x2, 1536, x15)

inst_403:
// rs1_val==-46339 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x33335767, -0xb503, 0x33333333, x2, 1540, x15)

inst_404:
// rs1_val==-46339 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x6666aece, -0xb503, 0x66666666, x2, 1544, x15)

inst_405:
// rs1_val==-46339 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x7ffdf30c, -0xb503, -0xb504, x2, 1548, x15)

inst_406:
// rs1_val==-46339 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x80020cf4, -0xb503, 0xb504, x2, 1552, x15)

inst_407:
// rs1_val==-46339 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xfffe95fa, -0xb503, 0x2, x2, 1556, x15)

inst_408:
// rs1_val==-46339 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xaaab9c04, -0xb503, 0x55555554, x2, 1560, x15)

inst_409:
// rs1_val==-46339 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, -0xb503, 0x0, x2, 1564, x15)

inst_410:
// rs1_val==-46339 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x33340c6a, -0xb503, 0x33333332, x2, 1568, x15)

inst_411:
// rs1_val==-46339 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x666763d1, -0xb503, 0x66666665, x2, 1572, x15)

inst_412:
// rs1_val==-46339 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x8002c1f7, -0xb503, 0xb503, x2, 1576, x15)

inst_413:
// rs1_val==-46339 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xaaaa31fe, -0xb503, 0x55555556, x2, 1580, x15)

inst_414:
// rs1_val==-46339 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x555518ff, -0xb503, -0x55555555, x2, 1584, x15)

inst_415:
// rs1_val==-46339 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0xfffbc1ee, -0xb503, 0x6, x2, 1588, x15)

inst_416:
// rs1_val==-46339 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x3332a264, -0xb503, 0x33333334, x2, 1592, x15)

inst_417:
// rs1_val==-46339 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x6665f9cb, -0xb503, 0x66666667, x2, 1596, x15)

inst_418:
// rs1_val==-46339 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x7ffd3e09, -0xb503, -0xb503, x2, 1600, x15)

inst_419:
// rs1_val==-46339 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x800157f1, -0xb503, 0xb505, x2, 1604, x15)

inst_420:
// rs1_val==46341 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x21f0f, 0xb505, 0x3, x2, 1608, x15)

inst_421:
// rs1_val==46341 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xffffc3a9, 0xb505, 0x55555555, x2, 1612, x15)

inst_422:
// rs1_val==46341 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xffff8752, 0xb505, -0x55555556, x2, 1616, x15)

inst_423:
// rs1_val==46341 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x38919, 0xb505, 0x5, x2, 1620, x15)

inst_424:
// rs1_val==46341 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x33330eff, 0xb505, 0x33333333, x2, 1624, x15)

inst_425:
// rs1_val==46341 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x66661dfe, 0xb505, 0x66666666, x2, 1628, x15)

inst_426:
// rs1_val==46341 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x8000a2ec, 0xb505, -0xb504, x2, 1632, x15)

inst_427:
// rs1_val==46341 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x7fff5d14, 0xb505, 0xb504, x2, 1636, x15)

inst_428:
// rs1_val==46341 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x16a0a, 0xb505, 0x2, x2, 1640, x15)

inst_429:
// rs1_val==46341 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0xffff0ea4, 0xb505, 0x55555554, x2, 1644, x15)

inst_430:
// rs1_val==46341 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0xb505, 0x0, x2, 1648, x15)

inst_431:
// rs1_val==46341 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x2d414, 0xb505, 0x4, x2, 1652, x15)

inst_432:
// rs1_val==46341 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x333259fa, 0xb505, 0x33333332, x2, 1656, x15)

inst_433:
// rs1_val==46341 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x666568f9, 0xb505, 0x66666665, x2, 1660, x15)

inst_434:
// rs1_val==46341 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x7ffea80f, 0xb505, 0xb503, x2, 1664, x15)

inst_435:
// rs1_val==46341 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x78ae, 0xb505, 0x55555556, x2, 1668, x15)

inst_436:
// rs1_val==46341 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x3c57, 0xb505, -0x55555555, x2, 1672, x15)

inst_437:
// rs1_val==46341 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x43e1e, 0xb505, 0x6, x2, 1676, x15)

inst_438:
// rs1_val==46341 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x3333c404, 0xb505, 0x33333334, x2, 1680, x15)

inst_439:
// rs1_val==46341 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x6666d303, 0xb505, 0x66666667, x2, 1684, x15)

inst_440:
// rs1_val==46341 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x800157f1, 0xb505, -0xb503, x2, 1688, x15)

inst_441:
// rs1_val==46341 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x80001219, 0xb505, 0xb505, x2, 1692, x15)

inst_442:
// rs1_val==0 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x66666666, x2, 1696, x15)

inst_443:
// rs1_val==0 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, -0xb504, x2, 1700, x15)

inst_444:
// rs1_val==0 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0xb504, x2, 1704, x15)

inst_445:
// rs1_val==0 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x2, x2, 1708, x15)

inst_446:
// rs1_val==0 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x55555554, x2, 1712, x15)

inst_447:
// rs1_val==0 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x4, x2, 1716, x15)

inst_448:
// rs1_val==0 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x33333332, x2, 1720, x15)

inst_449:
// rs1_val==0 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x66666665, x2, 1724, x15)

inst_450:
// rs1_val==0 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0xb503, x2, 1728, x15)

inst_451:
// rs1_val==0 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x55555556, x2, 1732, x15)

inst_452:
// rs1_val==0 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, -0x55555555, x2, 1736, x15)

inst_453:
// rs1_val==0 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x6, x2, 1740, x15)

inst_454:
// rs1_val==0 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x33333334, x2, 1744, x15)

inst_455:
// rs1_val==0 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0x66666667, x2, 1748, x15)

inst_456:
// rs1_val==0 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, -0xb503, x2, 1752, x15)

inst_457:
// rs1_val==0 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x0, 0xb505, x2, 1756, x15)

inst_458:
// rs1_val==4 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0xc, 0x4, 0x3, x2, 1760, x15)

inst_459:
// rs1_val==4 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x55555554, 0x4, 0x55555555, x2, 1764, x15)

inst_460:
// rs1_val==4 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaa8, 0x4, -0x55555556, x2, 1768, x15)

inst_461:
// rs1_val==4 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x14, 0x4, 0x5, x2, 1772, x15)

inst_462:
// rs1_val==4 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccc, 0x4, 0x33333333, x2, 1776, x15)

inst_463:
// rs1_val==4 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x99999998, 0x4, 0x66666666, x2, 1780, x15)

inst_464:
// rs1_val==4 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xfffd2bf0, 0x4, -0xb504, x2, 1784, x15)

inst_465:
// rs1_val==4 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x2d410, 0x4, 0xb504, x2, 1788, x15)

inst_466:
// rs1_val==4 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x8, 0x4, 0x2, x2, 1792, x15)

inst_467:
// rs1_val==4 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x4, 0x0, x2, 1796, x15)

inst_468:
// rs1_val==4 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x10, 0x4, 0x4, x2, 1800, x15)

inst_469:
// rs1_val==4 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0xccccccc8, 0x4, 0x33333332, x2, 1804, x15)

inst_470:
// rs1_val==4 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x99999994, 0x4, 0x66666665, x2, 1808, x15)

inst_471:
// rs1_val==4 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x2d40c, 0x4, 0xb503, x2, 1812, x15)

inst_472:
// rs1_val==4 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x55555558, 0x4, 0x55555556, x2, 1816, x15)

inst_473:
// rs1_val==4 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaac, 0x4, -0x55555555, x2, 1820, x15)

inst_474:
// rs1_val==4 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x18, 0x4, 0x6, x2, 1824, x15)

inst_475:
// rs1_val==4 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0xccccccd0, 0x4, 0x33333334, x2, 1828, x15)

inst_476:
// rs1_val==4 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x9999999c, 0x4, 0x66666667, x2, 1832, x15)

inst_477:
// rs1_val==4 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xfffd2bf4, 0x4, -0xb503, x2, 1836, x15)

inst_478:
// rs1_val==4 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x2d414, 0x4, 0xb505, x2, 1840, x15)

inst_479:
// rs1_val==858993458 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x99999996, 0x33333332, 0x3, x2, 1844, x15)

inst_480:
// rs1_val==858993458 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x9999999a, 0x33333332, 0x55555555, x2, 1848, x15)

inst_481:
// rs1_val==858993458 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x33333334, 0x33333332, -0x55555556, x2, 1852, x15)

inst_482:
// rs1_val==858993458 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xfffffffa, 0x33333332, 0x5, x2, 1856, x15)

inst_483:
// rs1_val==858993458 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x8f5c28f6, 0x33333332, 0x33333333, x2, 1860, x15)

inst_484:
// rs1_val==858993458 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x1eb851ec, 0x33333332, 0x66666666, x2, 1864, x15)

inst_485:
// rs1_val==858993458 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xd938, 0x33333332, -0xb504, x2, 1868, x15)

inst_486:
// rs1_val==858993458 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xffff26c8, 0x33333332, 0xb504, x2, 1872, x15)

inst_487:
// rs1_val==858993458 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x66666664, 0x33333332, 0x2, x2, 1876, x15)

inst_488:
// rs1_val==858993458 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x66666668, 0x33333332, 0x55555554, x2, 1880, x15)

inst_489:
// rs1_val==858993458 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x33333332, 0x0, x2, 1884, x15)

inst_490:
// rs1_val==858993458 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0xccccccc8, 0x33333332, 0x4, x2, 1888, x15)

inst_491:
// rs1_val==858993458 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x5c28f5c4, 0x33333332, 0x33333332, x2, 1892, x15)

inst_492:
// rs1_val==858993458 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xeb851eba, 0x33333332, 0x66666665, x2, 1896, x15)

inst_493:
// rs1_val==858993458 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xcccbf396, 0x33333332, 0xb503, x2, 1900, x15)

inst_494:
// rs1_val==858993458 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccc, 0x33333332, 0x55555556, x2, 1904, x15)

inst_495:
// rs1_val==858993458 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x66666666, 0x33333332, -0x55555555, x2, 1908, x15)

inst_496:
// rs1_val==858993458 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x3333332c, 0x33333332, 0x6, x2, 1912, x15)

inst_497:
// rs1_val==858993458 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0xc28f5c28, 0x33333332, 0x33333334, x2, 1916, x15)

inst_498:
// rs1_val==858993458 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x51eb851e, 0x33333332, 0x66666667, x2, 1920, x15)

inst_499:
// rs1_val==858993458 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x33340c6a, 0x33333332, -0xb503, x2, 1924, x15)

inst_500:
// rs1_val==858993458 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x333259fa, 0x33333332, 0xb505, x2, 1928, x15)

inst_501:
// rs1_val==1717986917 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x3333332f, 0x66666665, 0x3, x2, 1932, x15)

inst_502:
// rs1_val==1717986917 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x88888889, 0x66666665, 0x55555555, x2, 1936, x15)

inst_503:
// rs1_val==1717986917 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x11111112, 0x66666665, -0x55555556, x2, 1940, x15)

inst_504:
// rs1_val==1717986917 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xfffffff9, 0x66666665, 0x5, x2, 1944, x15)

inst_505:
// rs1_val==1717986917 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x51eb851f, 0x66666665, 0x33333333, x2, 1948, x15)

inst_506:
// rs1_val==1717986917 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0xa3d70a3e, 0x66666665, 0x66666666, x2, 1952, x15)

inst_507:
// rs1_val==1717986917 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xfd6c, 0x66666665, -0xb504, x2, 1956, x15)

inst_508:
// rs1_val==1717986917 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xffff0294, 0x66666665, 0xb504, x2, 1960, x15)

inst_509:
// rs1_val==1717986917 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xccccccca, 0x66666665, 0x2, x2, 1964, x15)

inst_510:
// rs1_val==1717986917 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x22222224, 0x66666665, 0x55555554, x2, 1968, x15)

inst_511:
// rs1_val==1717986917 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x99999994, 0x66666665, 0x4, x2, 1972, x15)

inst_512:
// rs1_val==1717986917 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0xeb851eba, 0x66666665, 0x33333332, x2, 1976, x15)

inst_513:
// rs1_val==1717986917 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x3d70a3d9, 0x66666665, 0x66666665, x2, 1980, x15)

inst_514:
// rs1_val==1717986917 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x99989c2f, 0x66666665, 0xb503, x2, 1984, x15)

inst_515:
// rs1_val==1717986917 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xeeeeeeee, 0x66666665, 0x55555556, x2, 1988, x15)

inst_516:
// rs1_val==1717986917 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x77777777, 0x66666665, -0x55555555, x2, 1992, x15)

inst_517:
// rs1_val==1717986917 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x6666665e, 0x66666665, 0x6, x2, 1996, x15)

inst_518:
// rs1_val==1717986917 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0xb851eb84, 0x66666665, 0x33333334, x2, 2000, x15)

inst_519:
// rs1_val==1717986917 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0xa3d70a3, 0x66666665, 0x66666667, x2, 2004, x15)

inst_520:
// rs1_val==1717986917 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x666763d1, 0x66666665, -0xb503, x2, 2008, x15)

inst_521:
// rs1_val==1717986917 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x666568f9, 0x66666665, 0xb505, x2, 2012, x15)

inst_522:
// rs1_val==46339 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x21f09, 0xb503, 0x3, x2, 2016, x15)

inst_523:
// rs1_val==46339 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x555518ff, 0xb503, 0x55555555, x2, 2020, x15)

inst_524:
// rs1_val==46339 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xaaaa31fe, 0xb503, -0x55555556, x2, 2024, x15)

inst_525:
// rs1_val==46339 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x3890f, 0xb503, 0x5, x2, 2028, x15)

inst_526:
// rs1_val==46339 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0xcccca899, 0xb503, 0x33333333, x2, 2032, x15)

inst_527:
// rs1_val==46339 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x99995132, 0xb503, 0x66666666, x2, 2036, x15)

inst_528:
// rs1_val==46339 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x80020cf4, 0xb503, -0xb504, x2, 2040, x15)

inst_529:
// rs1_val==46339 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x7ffdf30c, 0xb503, 0xb504, x2, 2044, x15)
RVTEST_SIGBASE( x2,signature_x2_1)

inst_530:
// rs1_val==46339 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x16a06, 0xb503, 0x2, x2, 0, x15)

inst_531:
// rs1_val==46339 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x555463fc, 0xb503, 0x55555554, x2, 4, x15)

inst_532:
// rs1_val==46339 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0xb503, 0x0, x2, 8, x15)

inst_533:
// rs1_val==46339 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x2d40c, 0xb503, 0x4, x2, 12, x15)

inst_534:
// rs1_val==46339 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0xcccbf396, 0xb503, 0x33333332, x2, 16, x15)

inst_535:
// rs1_val==46339 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x99989c2f, 0xb503, 0x66666665, x2, 20, x15)

inst_536:
// rs1_val==46339 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x7ffd3e09, 0xb503, 0xb503, x2, 24, x15)

inst_537:
// rs1_val==46339 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x5555ce02, 0xb503, 0x55555556, x2, 28, x15)

inst_538:
// rs1_val==46339 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xaaaae701, 0xb503, -0x55555555, x2, 32, x15)

inst_539:
// rs1_val==46339 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x43e12, 0xb503, 0x6, x2, 36, x15)

inst_540:
// rs1_val==46339 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0xcccd5d9c, 0xb503, 0x33333334, x2, 40, x15)

inst_541:
// rs1_val==46339 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x999a0635, 0xb503, 0x66666667, x2, 44, x15)

inst_542:
// rs1_val==46339 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x8002c1f7, 0xb503, -0xb503, x2, 48, x15)

inst_543:
// rs1_val==46339 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x7ffea80f, 0xb503, 0xb505, x2, 52, x15)

inst_544:
// rs1_val==1431655766 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x2, 0x55555556, 0x3, x2, 56, x15)

inst_545:
// rs1_val==1431655766 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x8e38e38e, 0x55555556, 0x55555555, x2, 60, x15)

inst_546:
// rs1_val==1431655766 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x1c71c71c, 0x55555556, -0x55555556, x2, 64, x15)

inst_547:
// rs1_val==1431655766 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaae, 0x55555556, 0x5, x2, 68, x15)

inst_548:
// rs1_val==1431655766 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x22222222, 0x55555556, 0x33333333, x2, 72, x15)

inst_549:
// rs1_val==1431655766 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x44444444, 0x55555556, 0x66666666, x2, 76, x15)

inst_550:
// rs1_val==1431655766 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x5554dca8, 0x55555556, -0xb504, x2, 80, x15)

inst_551:
// rs1_val==1431655766 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xaaab2358, 0x55555556, 0xb504, x2, 84, x15)

inst_552:
// rs1_val==1431655766 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaac, 0x55555556, 0x2, x2, 88, x15)

inst_553:
// rs1_val==1431655766 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x38e38e38, 0x55555556, 0x55555554, x2, 92, x15)

inst_554:
// rs1_val==1431655766 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, 0x55555556, 0x0, x2, 96, x15)

inst_555:
// rs1_val==1431655766 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0x55555558, 0x55555556, 0x4, x2, 100, x15)

inst_556:
// rs1_val==1431655766 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0xcccccccc, 0x55555556, 0x33333332, x2, 104, x15)

inst_557:
// rs1_val==1431655766 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0xeeeeeeee, 0x55555556, 0x66666665, x2, 108, x15)

inst_558:
// rs1_val==1431655766 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0x5555ce02, 0x55555556, 0xb503, x2, 112, x15)

inst_559:
// rs1_val==1431655766 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0xe38e38e4, 0x55555556, 0x55555556, x2, 116, x15)

inst_560:
// rs1_val==1431655766 and rs2_val==-1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:-0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0x71c71c72, 0x55555556, -0x55555555, x2, 120, x15)

inst_561:
// rs1_val==1431655766 and rs2_val==6, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x6
TEST_RR_OP(mul, x12, x10, x11, 0x4, 0x55555556, 0x6, x2, 124, x15)

inst_562:
// rs1_val==1431655766 and rs2_val==858993460, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333334
TEST_RR_OP(mul, x12, x10, x11, 0x77777778, 0x55555556, 0x33333334, x2, 128, x15)

inst_563:
// rs1_val==1431655766 and rs2_val==1717986919, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666667
TEST_RR_OP(mul, x12, x10, x11, 0x9999999a, 0x55555556, 0x66666667, x2, 132, x15)

inst_564:
// rs1_val==1431655766 and rs2_val==-46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:-0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xaaaa31fe, 0x55555556, -0xb503, x2, 136, x15)

inst_565:
// rs1_val==1431655766 and rs2_val==46341, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb505
TEST_RR_OP(mul, x12, x10, x11, 0x78ae, 0x55555556, 0xb505, x2, 140, x15)

inst_566:
// rs1_val==-1431655765 and rs2_val==3, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x3
TEST_RR_OP(mul, x12, x10, x11, 0x1, -0x55555555, 0x3, x2, 144, x15)

inst_567:
// rs1_val==-1431655765 and rs2_val==1431655765, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555555
TEST_RR_OP(mul, x12, x10, x11, 0xc71c71c7, -0x55555555, 0x55555555, x2, 148, x15)

inst_568:
// rs1_val==-1431655765 and rs2_val==-1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:-0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x8e38e38e, -0x55555555, -0x55555556, x2, 152, x15)

inst_569:
// rs1_val==-1431655765 and rs2_val==5, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x5
TEST_RR_OP(mul, x12, x10, x11, 0x55555557, -0x55555555, 0x5, x2, 156, x15)

inst_570:
// rs1_val==-1431655765 and rs2_val==858993459, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333333
TEST_RR_OP(mul, x12, x10, x11, 0x11111111, -0x55555555, 0x33333333, x2, 160, x15)

inst_571:
// rs1_val==-1431655765 and rs2_val==1717986918, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666666
TEST_RR_OP(mul, x12, x10, x11, 0x22222222, -0x55555555, 0x66666666, x2, 164, x15)

inst_572:
// rs1_val==-1431655765 and rs2_val==-46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:-0xb504
TEST_RR_OP(mul, x12, x10, x11, 0xaaaa6e54, -0x55555555, -0xb504, x2, 168, x15)

inst_573:
// rs1_val==-1431655765 and rs2_val==46340, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb504
TEST_RR_OP(mul, x12, x10, x11, 0x555591ac, -0x55555555, 0xb504, x2, 172, x15)

inst_574:
// rs1_val==-1431655765 and rs2_val==2, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x2
TEST_RR_OP(mul, x12, x10, x11, 0x55555556, -0x55555555, 0x2, x2, 176, x15)

inst_575:
// rs1_val==-1431655765 and rs2_val==1431655764, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555554
TEST_RR_OP(mul, x12, x10, x11, 0x1c71c71c, -0x55555555, 0x55555554, x2, 180, x15)

inst_576:
// rs1_val==-1431655765 and rs2_val==0, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x0
TEST_RR_OP(mul, x12, x10, x11, 0x0, -0x55555555, 0x0, x2, 184, x15)

inst_577:
// rs1_val==-1431655765 and rs2_val==4, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x4
TEST_RR_OP(mul, x12, x10, x11, 0xaaaaaaac, -0x55555555, 0x4, x2, 188, x15)

inst_578:
// rs1_val==-1431655765 and rs2_val==858993458, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333332
TEST_RR_OP(mul, x12, x10, x11, 0x66666666, -0x55555555, 0x33333332, x2, 192, x15)

inst_579:
// rs1_val==-1431655765 and rs2_val==1717986917, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666665
TEST_RR_OP(mul, x12, x10, x11, 0x77777777, -0x55555555, 0x66666665, x2, 196, x15)

inst_580:
// rs1_val==-1431655765 and rs2_val==46339, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb503
TEST_RR_OP(mul, x12, x10, x11, 0xaaaae701, -0x55555555, 0xb503, x2, 200, x15)

inst_581:
// rs1_val==-1431655765 and rs2_val==1431655766, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555556
TEST_RR_OP(mul, x12, x10, x11, 0x71c71c72, -0x55555555, 0x55555556, x2, 204, x15)

inst_582:
// rs1_val > 0 and rs2_val < 0, rs1_val == 32, rs2_val == -16385
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:-0x4001
TEST_RR_OP(mul, x12, x10, x11, 0xfff7ffe0, 0x20, -0x4001, x2, 208, x15)

inst_583:
// rs2_val == 8192, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x9;  op2val:0x2000
TEST_RR_OP(mul, x12, x10, x11, 0x12000, 0x9, 0x2000, x2, 212, x15)

inst_584:
// rs2_val == 32768, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:-0x4;  op2val:0x8000
TEST_RR_OP(mul, x12, x10, x11, 0xfffe0000, -0x4, 0x8000, x2, 216, x15)

inst_585:
// rs2_val == 262144, 
// opcode: mul ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x40000
TEST_RR_OP(mul, x12, x10, x11, 0xccd00000, 0x33333334, 0x40000, x2, 220, x15)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x4_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x4_1:
    .fill 18*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 512*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 56*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
