
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Tue Dec 15 15:41:59 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv32im.cgf') \
//                  -- xlen 32 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the mulhsu instruction of the RISC-V M extension for the mulhsu covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV32IM")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*32.*);check ISA:=regex(.*I.*M.*);def TEST_CASE_1=True;",mulhsu)

RVTEST_SIGBASE( x17,signature_x17_1)

inst_0:
// rs1 == rd != rs2, rs1==x22, rs2==x10, rd==x22, rs1_val > 0 and rs2_val > 0, rs1_val != rs2_val and rs1_val > 0 and rs2_val > 0, rs1_val == 4, rs1_val==4 and rs2_val==3
// opcode: mulhsu ; op1:x22; op2:x10; dest:x22; op1val:0x4;  op2val:0x3
TEST_RR_OP(mulhsu, x22, x22, x10, 0x0, 0x4, 0x3, x17, 0, x20)

inst_1:
// rs1 == rs2 != rd, rs1==x23, rs2==x23, rd==x2, rs1_val == rs2_val and rs1_val > 0 and rs2_val > 0, rs2_val == 128, rs1_val == 128
// opcode: mulhsu ; op1:x23; op2:x23; dest:x2; op1val:0x80;  op2val:0x80
TEST_RR_OP(mulhsu, x2, x23, x23, 0x0, 0x80, 0x80, x17, 4, x20)

inst_2:
// rs2 == rd != rs1, rs1==x2, rs2==x19, rd==x19, rs2_val == 0, rs1_val==46339 and rs2_val==0
// opcode: mulhsu ; op1:x2; op2:x19; dest:x19; op1val:0xb503;  op2val:0x0
TEST_RR_OP(mulhsu, x19, x2, x19, 0x0, 0xb503, 0x0, x17, 8, x20)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x25, rs2==x9, rd==x7, rs2_val == (2**(xlen)-1), 
// opcode: mulhsu ; op1:x25; op2:x9; dest:x7; op1val:0x4;  op2val:0xffffffff
TEST_RR_OP(mulhsu, x7, x25, x9, 0x3, 0x4, 0xffffffff, x17, 12, x20)

inst_4:
// rs1 == rs2 == rd, rs1==x28, rs2==x28, rd==x28, rs2_val == 1, rs1_val == -536870913
// opcode: mulhsu ; op1:x28; op2:x28; dest:x28; op1val:-0x20000001;  op2val:-0x20000001
TEST_RR_OP(mulhsu, x28, x28, x28, 0xe3ffffff, -0x20000001, -0x20000001, x17, 16, x20)

inst_5:
// rs1==x0, rs2==x18, rd==x8, rs1_val == (-2**(xlen-1)), rs1_val == -2147483648, rs2_val == 4294967263
// opcode: mulhsu ; op1:x0; op2:x18; dest:x8; op1val:0x0;  op2val:0xffffffdf
TEST_RR_OP(mulhsu, x8, x0, x18, 0x0, 0x0, 0xffffffdf, x17, 20, x20)

inst_6:
// rs1==x14, rs2==x15, rd==x12, rs1_val == 0, 
// opcode: mulhsu ; op1:x14; op2:x15; dest:x12; op1val:0x0;  op2val:0x12
TEST_RR_OP(mulhsu, x12, x14, x15, 0x0, 0x0, 0x12, x17, 24, x20)

inst_7:
// rs1==x13, rs2==x3, rd==x4, rs1_val == (2**(xlen-1)-1), rs1_val == 2147483647, rs2_val == 4026531839
// opcode: mulhsu ; op1:x13; op2:x3; dest:x4; op1val:0x7fffffff;  op2val:0xefffffff
TEST_RR_OP(mulhsu, x4, x13, x3, 0x77fffffe, 0x7fffffff, 0xefffffff, x17, 28, x20)

inst_8:
// rs1==x6, rs2==x16, rd==x30, rs1_val == 1, rs2_val == 1024
// opcode: mulhsu ; op1:x6; op2:x16; dest:x30; op1val:0x1;  op2val:0x400
TEST_RR_OP(mulhsu, x30, x6, x16, 0x0, 0x1, 0x400, x17, 32, x20)

inst_9:
// rs1==x8, rs2==x5, rd==x1, rs2_val == 2, rs1_val==3 and rs2_val==2
// opcode: mulhsu ; op1:x8; op2:x5; dest:x1; op1val:0x3;  op2val:0x2
TEST_RR_OP(mulhsu, x1, x8, x5, 0x0, 0x3, 0x2, x17, 36, x20)

inst_10:
// rs1==x11, rs2==x27, rd==x9, rs2_val == 4, rs1_val==6 and rs2_val==4
// opcode: mulhsu ; op1:x11; op2:x27; dest:x9; op1val:0x6;  op2val:0x4
TEST_RR_OP(mulhsu, x9, x11, x27, 0x0, 0x6, 0x4, x17, 40, x20)

inst_11:
// rs1==x27, rs2==x25, rd==x13, rs2_val == 8, 
// opcode: mulhsu ; op1:x27; op2:x25; dest:x13; op1val:-0x40000000;  op2val:0x8
TEST_RR_OP(mulhsu, x13, x27, x25, 0xfffffffe, -0x40000000, 0x8, x17, 44, x20)

inst_12:
// rs1==x30, rs2==x14, rd==x16, rs2_val == 16, rs1_val == -65
// opcode: mulhsu ; op1:x30; op2:x14; dest:x16; op1val:-0x41;  op2val:0x10
TEST_RR_OP(mulhsu, x16, x30, x14, 0xffffffff, -0x41, 0x10, x17, 48, x20)

inst_13:
// rs1==x15, rs2==x22, rd==x11, rs2_val == 32, rs1_val == -5
// opcode: mulhsu ; op1:x15; op2:x22; dest:x11; op1val:-0x5;  op2val:0x20
TEST_RR_OP(mulhsu, x11, x15, x22, 0xffffffff, -0x5, 0x20, x17, 52, x20)

inst_14:
// rs1==x16, rs2==x4, rd==x29, rs2_val == 64, 
// opcode: mulhsu ; op1:x16; op2:x4; dest:x29; op1val:-0x41;  op2val:0x40
TEST_RR_OP(mulhsu, x29, x16, x4, 0xffffffff, -0x41, 0x40, x17, 56, x20)

inst_15:
// rs1==x24, rs2==x13, rd==x21, rs2_val == 256, rs1_val == 134217728
// opcode: mulhsu ; op1:x24; op2:x13; dest:x21; op1val:0x8000000;  op2val:0x100
TEST_RR_OP(mulhsu, x21, x24, x13, 0x8, 0x8000000, 0x100, x17, 60, x20)

inst_16:
// rs1==x19, rs2==x6, rd==x26, rs2_val == 512, rs1_val == -257
// opcode: mulhsu ; op1:x19; op2:x6; dest:x26; op1val:-0x101;  op2val:0x200
TEST_RR_OP(mulhsu, x26, x19, x6, 0xffffffff, -0x101, 0x200, x17, 64, x16)
RVTEST_SIGBASE( x13,signature_x13_0)

inst_17:
// rs1==x9, rs2==x31, rd==x18, rs2_val == 2048, 
// opcode: mulhsu ; op1:x9; op2:x31; dest:x18; op1val:0x33333334;  op2val:0x800
TEST_RR_OP(mulhsu, x18, x9, x31, 0x199, 0x33333334, 0x800, x13, 0, x16)

inst_18:
// rs1==x5, rs2==x7, rd==x25, rs2_val == 4096, 
// opcode: mulhsu ; op1:x5; op2:x7; dest:x25; op1val:0xb504;  op2val:0x1000
TEST_RR_OP(mulhsu, x25, x5, x7, 0x0, 0xb504, 0x1000, x13, 4, x16)

inst_19:
// rs1==x26, rs2==x17, rd==x0, rs2_val == 8192, rs1_val == 4194304
// opcode: mulhsu ; op1:x26; op2:x17; dest:x0; op1val:0x400000;  op2val:0x2000
TEST_RR_OP(mulhsu, x0, x26, x17, 0, 0x400000, 0x2000, x13, 8, x16)

inst_20:
// rs1==x1, rs2==x26, rd==x23, rs2_val == 16384, rs1_val == 32
// opcode: mulhsu ; op1:x1; op2:x26; dest:x23; op1val:0x20;  op2val:0x4000
TEST_RR_OP(mulhsu, x23, x1, x26, 0x0, 0x20, 0x4000, x13, 12, x16)

inst_21:
// rs1==x21, rs2==x8, rd==x15, rs2_val == 32768, 
// opcode: mulhsu ; op1:x21; op2:x8; dest:x15; op1val:0x0;  op2val:0x8000
TEST_RR_OP(mulhsu, x15, x21, x8, 0x0, 0x0, 0x8000, x13, 16, x16)

inst_22:
// rs1==x31, rs2==x0, rd==x20, rs2_val == 65536, rs1_val == 8
// opcode: mulhsu ; op1:x31; op2:x0; dest:x20; op1val:0x8;  op2val:0x0
TEST_RR_OP(mulhsu, x20, x31, x0, 0x0, 0x8, 0x0, x13, 20, x16)

inst_23:
// rs1==x17, rs2==x24, rd==x14, rs2_val == 131072, rs1_val == -17
// opcode: mulhsu ; op1:x17; op2:x24; dest:x14; op1val:-0x11;  op2val:0x20000
TEST_RR_OP(mulhsu, x14, x17, x24, 0xffffffff, -0x11, 0x20000, x13, 24, x16)

inst_24:
// rs1==x4, rs2==x21, rd==x24, rs2_val == 262144, rs1_val == 67108864
// opcode: mulhsu ; op1:x4; op2:x21; dest:x24; op1val:0x4000000;  op2val:0x40000
TEST_RR_OP(mulhsu, x24, x4, x21, 0x1000, 0x4000000, 0x40000, x13, 28, x16)

inst_25:
// rs1==x12, rs2==x30, rd==x5, rs2_val == 524288, 
// opcode: mulhsu ; op1:x12; op2:x30; dest:x5; op1val:0x66666666;  op2val:0x80000
TEST_RR_OP(mulhsu, x5, x12, x30, 0x33333, 0x66666666, 0x80000, x13, 32, x16)

inst_26:
// rs1==x7, rs2==x20, rd==x6, rs2_val == 1048576, rs1_val == 4096
// opcode: mulhsu ; op1:x7; op2:x20; dest:x6; op1val:0x1000;  op2val:0x100000
TEST_RR_OP(mulhsu, x6, x7, x20, 0x1, 0x1000, 0x100000, x13, 36, x16)

inst_27:
// rs1==x18, rs2==x1, rd==x31, rs2_val == 2097152, 
// opcode: mulhsu ; op1:x18; op2:x1; dest:x31; op1val:0x5;  op2val:0x200000
TEST_RR_OP(mulhsu, x31, x18, x1, 0x0, 0x5, 0x200000, x13, 40, x16)

inst_28:
// rs1==x29, rs2==x2, rd==x10, rs2_val == 4194304, rs1_val == -1073741825
// opcode: mulhsu ; op1:x29; op2:x2; dest:x10; op1val:-0x40000001;  op2val:0x400000
TEST_RR_OP(mulhsu, x10, x29, x2, 0xffefffff, -0x40000001, 0x400000, x13, 44, x16)

inst_29:
// rs1==x3, rs2==x12, rd==x17, rs2_val == 8388608, rs1_val == 512
// opcode: mulhsu ; op1:x3; op2:x12; dest:x17; op1val:0x200;  op2val:0x800000
TEST_RR_OP(mulhsu, x17, x3, x12, 0x1, 0x200, 0x800000, x13, 48, x16)

inst_30:
// rs1==x10, rs2==x11, rd==x27, rs2_val == 16777216, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x27; op1val:0x3;  op2val:0x1000000
TEST_RR_OP(mulhsu, x27, x10, x11, 0x0, 0x3, 0x1000000, x13, 52, x16)

inst_31:
// rs1==x20, rs2==x29, rd==x3, rs2_val == 33554432, 
// opcode: mulhsu ; op1:x20; op2:x29; dest:x3; op1val:-0x6;  op2val:0x2000000
TEST_RR_OP(mulhsu, x3, x20, x29, 0xffffffff, -0x6, 0x2000000, x13, 56, x1)

inst_32:
// rs2_val == 67108864, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0x4000000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x10000, 0x400000, 0x4000000, x13, 60, x1)

inst_33:
// rs2_val == 134217728, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x8000000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0x8000000, x13, 64, x1)

inst_34:
// rs2_val == 268435456, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x9;  op2val:0x10000000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x9, 0x10000000, x13, 68, x1)

inst_35:
// rs2_val == 536870912, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:0x20000000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x10, 0x80, 0x20000000, x13, 72, x1)

inst_36:
// rs2_val == 1073741824, rs1_val == 8388608
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:0x40000000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x200000, 0x800000, 0x40000000, x13, 76, x1)

inst_37:
// rs2_val == 2147483648, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0x80000000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x800, 0x1000, 0x80000000, x13, 80, x1)

inst_38:
// rs2_val == 4294967294, rs1_val == -2
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:0xfffffffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffe, -0x2, 0xfffffffe, x13, 84, x1)

inst_39:
// rs2_val == 4294967293, rs1_val == -1025
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0xfffffffd
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffbff, -0x401, 0xfffffffd, x13, 88, x1)

inst_40:
// rs2_val == 4294967291, rs1_val == 262144
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:0xfffffffb
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3ffff, 0x40000, 0xfffffffb, x13, 92, x1)

inst_41:
// rs2_val == 4294967287, rs1_val == 65536
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:0xfffffff7
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffff, 0x10000, 0xfffffff7, x13, 96, x1)

inst_42:
// rs2_val == 4294967279, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xffffffef
TEST_RR_OP(mulhsu, x12, x10, x11, 0xb503, 0xb504, 0xffffffef, x13, 100, x1)

inst_43:
// rs2_val == 4294967231, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xffffffbf
TEST_RR_OP(mulhsu, x12, x10, x11, 0x33333325, 0x33333332, 0xffffffbf, x13, 104, x1)

inst_44:
// rs2_val == 4294967167, rs1_val == 1073741824
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0xffffff7f
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3fffffdf, 0x40000000, 0xffffff7f, x13, 108, x1)

inst_45:
// rs2_val == 4294967039, rs1_val == 32768
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:0xfffffeff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x7fff, 0x8000, 0xfffffeff, x13, 112, x1)

inst_46:
// rs2_val == 4294966783, rs1_val == -3
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:0xfffffdff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffd, -0x3, 0xfffffdff, x13, 116, x1)

inst_47:
// rs2_val == 4294966271, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:0xfffffbff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1f, 0x20, 0xfffffbff, x13, 120, x1)

inst_48:
// rs2_val == 4294965247, rs1_val == 1048576
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0xfffff7ff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffff, 0x100000, 0xfffff7ff, x13, 124, x1)

inst_49:
// rs2_val == 4294963199, rs1_val == -1431655766
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xffffefff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xaaaaafff, -0x55555556, 0xffffefff, x13, 128, x1)

inst_50:
// rs2_val == 4294959103, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xffffdfff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3, 0x4, 0xffffdfff, x13, 132, x1)

inst_51:
// rs2_val == 4294950911, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xffffbfff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xaaaabfff, -0x55555556, 0xffffbfff, x13, 136, x1)

inst_52:
// rs2_val == 4294934527, rs1_val == 2048
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:0xffff7fff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x7ff, 0x800, 0xffff7fff, x13, 140, x1)

inst_53:
// rs2_val == 4294901759, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0xfffeffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3fffbff, 0x4000000, 0xfffeffff, x13, 144, x1)

inst_54:
// rs2_val == 4294836223, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0xfffdffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xc0007fff, -0x40000001, 0xfffdffff, x13, 148, x1)

inst_55:
// rs2_val == 4294705151, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xfffbffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3, 0x4, 0xfffbffff, x13, 152, x1)

inst_56:
// rs2_val == 4294443007, rs1_val == -16777217
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0xfff7ffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xff0007ff, -0x1000001, 0xfff7ffff, x13, 156, x1)

inst_57:
// rs2_val == 4293918719, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xffefffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xffefffff, x13, 160, x1)

inst_58:
// rs2_val == 4292870143, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:0xffdfffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffd, -0x3, 0xffdfffff, x13, 164, x1)

inst_59:
// rs2_val == 4290772991, rs1_val == 64
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0xffbfffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3f, 0x40, 0xffbfffff, x13, 168, x1)

inst_60:
// rs2_val == 4286578687, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x8;  op2val:0xff7fffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffff8, -0x8, 0xff7fffff, x13, 172, x1)

inst_61:
// rs2_val == 4278190079, rs1_val == -4097
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:0xfeffffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffff00f, -0x1001, 0xfeffffff, x13, 176, x1)

inst_62:
// rs2_val == 4261412863, rs1_val == 2097152
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:0xfdffffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1fbfff, 0x200000, 0xfdffffff, x13, 180, x1)

inst_63:
// rs2_val == 4227858431, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xfbffffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x32666666, 0x33333334, 0xfbffffff, x13, 184, x1)

inst_64:
// rs2_val == 4160749567, rs1_val == -1048577
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0xf7ffffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfff07fff, -0x100001, 0xf7ffffff, x13, 188, x1)

inst_65:
// rs2_val == 3758096383, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:0xdfffffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6, 0x8, 0xdfffffff, x13, 192, x1)

inst_66:
// rs2_val == 3221225471, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0xbfffffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffcff, -0x401, 0xbfffffff, x13, 196, x1)

inst_67:
// rs2_val == 2147483647, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x7fffffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x7fffffff, x13, 200, x1)

inst_68:
// rs2_val == 1431655765, rs1_val==-1431655765 and rs2_val==1431655765
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0xe38e38e3, -0x55555555, 0x55555555, x13, 204, x1)

inst_69:
// rs2_val == 2863311530, rs1_val==5 and rs2_val==2863311530
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3, 0x5, 0xaaaaaaaa, x13, 208, x1)

inst_70:
// rs1_val == 2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x13
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x13, x13, 212, x1)

inst_71:
// rs1_val == 16, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa, 0x10, 0xaaaaaaa9, x13, 216, x1)

inst_72:
// rs1_val == 256, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:0x80
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x100, 0x80, x13, 220, x1)

inst_73:
// rs1_val == 1024, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:0xffffff7f
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3ff, 0x400, 0xffffff7f, x13, 224, x1)

inst_74:
// rs1_val == 8192, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0xd
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2000, 0xd, x13, 228, x1)

inst_75:
// rs1_val == 16384, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4000, 0xb503, x13, 232, x1)

inst_76:
// rs1_val == 131072, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0xffbfffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1ff7f, 0x20000, 0xffbfffff, x13, 236, x1)

inst_77:
// rs1_val == 524288, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5, 0x80000, 0xb504, x13, 240, x1)

inst_78:
// rs1_val == 16777216, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x400
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4, 0x1000000, 0x400, x13, 244, x1)

inst_79:
// rs1_val == 33554432, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0xaaaaaa, 0x2000000, 0x55555556, x13, 248, x1)

inst_80:
// rs1_val == 268435456, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0x11
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x10000000, 0x11, x13, 252, x1)

inst_81:
// rs1_val == 536870912, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0xc
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x20000000, 0xc, x13, 256, x1)

inst_82:
// rs1_val == -9, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:0xff7fffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffff7, -0x9, 0xff7fffff, x13, 260, x1)

inst_83:
// rs1_val == -33, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x200
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x21, 0x200, x13, 264, x1)

inst_84:
// rs1_val == -129, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0xffdfffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffff7f, -0x81, 0xffdfffff, x13, 268, x1)

inst_85:
// rs1_val == -513, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffff32, -0x201, 0x66666665, x13, 272, x1)

inst_86:
// rs1_val == -2049, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x801, 0x4, x13, 276, x1)

inst_87:
// rs1_val == -8193, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffeaaa, -0x2001, 0xaaaaaaaa, x13, 280, x1)

inst_88:
// rs1_val == -16385, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:0xffffffdf
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffbfff, -0x4001, 0xffffffdf, x13, 284, x1)

inst_89:
// rs1_val == -32769, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffe666, -0x8001, 0x33333332, x13, 288, x1)

inst_90:
// rs1_val == -65537, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:0xfffffffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffeffff, -0x10001, 0xfffffffe, x13, 292, x1)

inst_91:
// rs1_val == -131073, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x20001, 0x4, x13, 296, x1)

inst_92:
// rs1_val == -262145, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0xffffffef
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffbffff, -0x40001, 0xffffffef, x13, 300, x1)

inst_93:
// rs1_val == -524289, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0xffffffef
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfff7ffff, -0x80001, 0xffffffef, x13, 304, x1)

inst_94:
// rs1_val == -2097153, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:0x7
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x200001, 0x7, x13, 308, x1)

inst_95:
// rs1_val == -4194305, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:0x8000000
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffdffff, -0x400001, 0x8000000, x13, 312, x1)

inst_96:
// rs1_val == -8388609, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0x10000000
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfff7ffff, -0x800001, 0x10000000, x13, 316, x1)

inst_97:
// rs1_val == -33554433, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0xff555554, -0x2000001, 0x55555556, x13, 320, x1)

inst_98:
// rs1_val == -67108865, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0xff333332, -0x4000001, 0x33333334, x13, 324, x1)

inst_99:
// rs1_val == -134217729, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:0xfbffffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xf81fffff, -0x8000001, 0xfbffffff, x13, 328, x1)

inst_100:
// rs1_val == -268435457, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:0x400
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffbf, -0x10000001, 0x400, x13, 332, x1)

inst_101:
// rs1_val == 1431655765, rs1_val==1431655765 and rs2_val==1431655765
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71c, 0x55555555, 0x55555555, x13, 336, x1)

inst_102:
// rs1_val==3 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x3, x13, 340, x1)

inst_103:
// rs1_val==3 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x55555555, x13, 344, x1)

inst_104:
// rs1_val==3 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x3, 0xaaaaaaaa, x13, 348, x1)

inst_105:
// rs1_val==3 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x5, x13, 352, x1)

inst_106:
// rs1_val==3 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x33333333, x13, 356, x1)

inst_107:
// rs1_val==3 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x3, 0x66666666, x13, 360, x1)

inst_108:
// rs1_val==3 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0xb504, x13, 364, x1)

inst_109:
// rs1_val==3 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x0, x13, 368, x1)

inst_110:
// rs1_val==3 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0xffff, x13, 372, x1)

inst_111:
// rs1_val==3 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x55555554, x13, 376, x1)

inst_112:
// rs1_val==3 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x3, 0xaaaaaaa9, x13, 380, x1)

inst_113:
// rs1_val==3 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x4, x13, 384, x1)

inst_114:
// rs1_val==3 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x33333332, x13, 388, x1)

inst_115:
// rs1_val==3 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x3, 0x66666665, x13, 392, x1)

inst_116:
// rs1_val==3 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0xb503, x13, 396, x1)

inst_117:
// rs1_val==3 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0xfffe, x13, 400, x1)

inst_118:
// rs1_val==3 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x3, 0x55555556, x13, 404, x1)

inst_119:
// rs1_val==3 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x3, 0xaaaaaaab, x13, 408, x1)

inst_120:
// rs1_val==3 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x6, x13, 412, x1)

inst_121:
// rs1_val==3 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x33333334, x13, 416, x1)

inst_122:
// rs1_val==3 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x3, 0x66666667, x13, 420, x1)

inst_123:
// rs1_val==3 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0xb505, x13, 424, x1)

inst_124:
// rs1_val==3 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x1, x13, 428, x1)

inst_125:
// rs1_val==3 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x3, 0x10000, x13, 432, x1)

inst_126:
// rs1_val==1431655765 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555555, 0x3, x13, 436, x1)

inst_127:
// rs1_val==1431655765 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e38, 0x55555555, 0xaaaaaaaa, x13, 440, x1)

inst_128:
// rs1_val==1431655765 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555555, 0x5, x13, 444, x1)

inst_129:
// rs1_val==1431655765 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x55555555, 0x33333333, x13, 448, x1)

inst_130:
// rs1_val==1431655765 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x55555555, 0x66666666, x13, 452, x1)

inst_131:
// rs1_val==1431655765 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0x55555555, 0xb504, x13, 456, x1)

inst_132:
// rs1_val==1431655765 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555555, 0x0, x13, 460, x1)

inst_133:
// rs1_val==1431655765 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5554, 0x55555555, 0xffff, x13, 464, x1)

inst_134:
// rs1_val==1431655765 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555555, 0x2, x13, 468, x1)

inst_135:
// rs1_val==1431655765 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71b, 0x55555555, 0x55555554, x13, 472, x1)

inst_136:
// rs1_val==1431655765 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e38, 0x55555555, 0xaaaaaaa9, x13, 476, x1)

inst_137:
// rs1_val==1431655765 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555555, 0x4, x13, 480, x1)

inst_138:
// rs1_val==1431655765 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x55555555, 0x33333332, x13, 484, x1)

inst_139:
// rs1_val==1431655765 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x55555555, 0x66666665, x13, 488, x1)

inst_140:
// rs1_val==1431655765 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0x55555555, 0xb503, x13, 492, x1)

inst_141:
// rs1_val==1431655765 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5554, 0x55555555, 0xfffe, x13, 496, x1)

inst_142:
// rs1_val==1431655765 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71c, 0x55555555, 0x55555556, x13, 500, x1)

inst_143:
// rs1_val==1431655765 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e38, 0x55555555, 0xaaaaaaab, x13, 504, x1)

inst_144:
// rs1_val==1431655765 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555555, 0x6, x13, 508, x1)

inst_145:
// rs1_val==1431655765 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111111, 0x55555555, 0x33333334, x13, 512, x1)

inst_146:
// rs1_val==1431655765 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x55555555, 0x66666667, x13, 516, x1)

inst_147:
// rs1_val==1431655765 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0x55555555, 0xb505, x13, 520, x1)

inst_148:
// rs1_val==1431655765 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555555, 0x1, x13, 524, x1)

inst_149:
// rs1_val==1431655765 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555555;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5555, 0x55555555, 0x10000, x13, 528, x1)

inst_150:
// rs1_val==-1431655766 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffe, -0x55555556, 0x3, x13, 532, x1)

inst_151:
// rs1_val==-1431655766 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0xe38e38e3, -0x55555556, 0x55555555, x13, 536, x1)

inst_152:
// rs1_val==-1431655766 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0xc71c71c6, -0x55555556, 0xaaaaaaaa, x13, 540, x1)

inst_153:
// rs1_val==-1431655766 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffe, -0x55555556, 0x5, x13, 544, x1)

inst_154:
// rs1_val==-1431655766 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0xeeeeeeee, -0x55555556, 0x33333333, x13, 548, x1)

inst_155:
// rs1_val==-1431655766 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0xdddddddd, -0x55555556, 0x66666666, x13, 552, x1)

inst_156:
// rs1_val==-1431655766 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0x55555556, 0xb504, x13, 556, x1)

inst_157:
// rs1_val==-1431655766 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, -0x55555556, 0x0, x13, 560, x1)

inst_158:
// rs1_val==-1431655766 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffaaaa, -0x55555556, 0xffff, x13, 564, x1)

inst_159:
// rs1_val==-1431655766 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x55555556, 0x2, x13, 568, x1)

inst_160:
// rs1_val==-1431655766 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0xe38e38e3, -0x55555556, 0x55555554, x13, 572, x1)

inst_161:
// rs1_val==-1431655766 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0xc71c71c7, -0x55555556, 0xaaaaaaa9, x13, 576, x1)

inst_162:
// rs1_val==-1431655766 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffe, -0x55555556, 0x4, x13, 580, x1)

inst_163:
// rs1_val==-1431655766 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0xeeeeeeef, -0x55555556, 0x33333332, x13, 584, x1)

inst_164:
// rs1_val==-1431655766 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0xddddddde, -0x55555556, 0x66666665, x13, 588, x1)

inst_165:
// rs1_val==-1431655766 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0x55555556, 0xb503, x13, 592, x1)

inst_166:
// rs1_val==-1431655766 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffaaab, -0x55555556, 0xfffe, x13, 596, x1)

inst_167:
// rs1_val==-1431655766 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0xe38e38e3, -0x55555556, 0x55555556, x13, 600, x1)

inst_168:
// rs1_val==-1431655766 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0xc71c71c6, -0x55555556, 0xaaaaaaab, x13, 604, x1)

inst_169:
// rs1_val==-1431655766 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffd, -0x55555556, 0x6, x13, 608, x1)

inst_170:
// rs1_val==-1431655766 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0xeeeeeeee, -0x55555556, 0x33333334, x13, 612, x1)

inst_171:
// rs1_val==-1431655766 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0xdddddddd, -0x55555556, 0x66666667, x13, 616, x1)

inst_172:
// rs1_val==-1431655766 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a8, -0x55555556, 0xb505, x13, 620, x1)

inst_173:
// rs1_val==-1431655766 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x55555556, 0x1, x13, 624, x1)

inst_174:
// rs1_val==-1431655766 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555556;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffaaaa, -0x55555556, 0x10000, x13, 628, x1)

inst_175:
// rs1_val==5 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x3, x13, 632, x1)

inst_176:
// rs1_val==5 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x5, 0x55555555, x13, 636, x1)

inst_177:
// rs1_val==5 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x5, x13, 640, x1)

inst_178:
// rs1_val==5 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x33333333, x13, 644, x1)

inst_179:
// rs1_val==5 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x5, 0x66666666, x13, 648, x1)

inst_180:
// rs1_val==5 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0xb504, x13, 652, x1)

inst_181:
// rs1_val==5 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x0, x13, 656, x1)

inst_182:
// rs1_val==5 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0xffff, x13, 660, x1)

inst_183:
// rs1_val==5 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x2, x13, 664, x1)

inst_184:
// rs1_val==5 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x5, 0x55555554, x13, 668, x1)

inst_185:
// rs1_val==5 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3, 0x5, 0xaaaaaaa9, x13, 672, x1)

inst_186:
// rs1_val==5 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x4, x13, 676, x1)

inst_187:
// rs1_val==5 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x33333332, x13, 680, x1)

inst_188:
// rs1_val==5 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x5, 0x66666665, x13, 684, x1)

inst_189:
// rs1_val==5 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0xb503, x13, 688, x1)

inst_190:
// rs1_val==5 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0xfffe, x13, 692, x1)

inst_191:
// rs1_val==5 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x5, 0x55555556, x13, 696, x1)

inst_192:
// rs1_val==5 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3, 0x5, 0xaaaaaaab, x13, 700, x1)

inst_193:
// rs1_val==5 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x6, x13, 704, x1)

inst_194:
// rs1_val==5 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x5, 0x33333334, x13, 708, x1)

inst_195:
// rs1_val==5 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x5, 0x66666667, x13, 712, x1)

inst_196:
// rs1_val==5 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0xb505, x13, 716, x1)

inst_197:
// rs1_val==5 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x1, x13, 720, x1)

inst_198:
// rs1_val==5 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x5, 0x10000, x13, 724, x1)

inst_199:
// rs1_val==858993459 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333333, 0x3, x13, 728, x1)

inst_200:
// rs1_val==858993459 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x33333333, 0x55555555, x13, 732, x1)

inst_201:
// rs1_val==858993459 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x33333333, 0xaaaaaaaa, x13, 736, x1)

inst_202:
// rs1_val==858993459 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333333, 0x5, x13, 740, x1)

inst_203:
// rs1_val==858993459 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a3, 0x33333333, 0x33333333, x13, 744, x1)

inst_204:
// rs1_val==858993459 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x33333333, 0x66666666, x13, 748, x1)

inst_205:
// rs1_val==858993459 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0x33333333, 0xb504, x13, 752, x1)

inst_206:
// rs1_val==858993459 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333333, 0x0, x13, 756, x1)

inst_207:
// rs1_val==858993459 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3332, 0x33333333, 0xffff, x13, 760, x1)

inst_208:
// rs1_val==858993459 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333333, 0x2, x13, 764, x1)

inst_209:
// rs1_val==858993459 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x33333333, 0x55555554, x13, 768, x1)

inst_210:
// rs1_val==858993459 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x33333333, 0xaaaaaaa9, x13, 772, x1)

inst_211:
// rs1_val==858993459 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333333, 0x4, x13, 776, x1)

inst_212:
// rs1_val==858993459 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a3, 0x33333333, 0x33333332, x13, 780, x1)

inst_213:
// rs1_val==858993459 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x33333333, 0x66666665, x13, 784, x1)

inst_214:
// rs1_val==858993459 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0x33333333, 0xb503, x13, 788, x1)

inst_215:
// rs1_val==858993459 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3332, 0x33333333, 0xfffe, x13, 792, x1)

inst_216:
// rs1_val==858993459 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111111, 0x33333333, 0x55555556, x13, 796, x1)

inst_217:
// rs1_val==858993459 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x33333333, 0xaaaaaaab, x13, 800, x1)

inst_218:
// rs1_val==858993459 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x33333333, 0x6, x13, 804, x1)

inst_219:
// rs1_val==858993459 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a3, 0x33333333, 0x33333334, x13, 808, x1)

inst_220:
// rs1_val==858993459 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x33333333, 0x66666667, x13, 812, x1)

inst_221:
// rs1_val==858993459 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2434, 0x33333333, 0xb505, x13, 816, x1)

inst_222:
// rs1_val==858993459 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333333, 0x1, x13, 820, x1)

inst_223:
// rs1_val==858993459 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333333;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3333, 0x33333333, 0x10000, x13, 824, x1)

inst_224:
// rs1_val==1717986918 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x66666666, 0x3, x13, 828, x1)

inst_225:
// rs1_val==1717986918 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x66666666, 0x55555555, x13, 832, x1)

inst_226:
// rs1_val==1717986918 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444443, 0x66666666, 0xaaaaaaaa, x13, 836, x1)

inst_227:
// rs1_val==1717986918 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x66666666, 0x5, x13, 840, x1)

inst_228:
// rs1_val==1717986918 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x66666666, 0x33333333, x13, 844, x1)

inst_229:
// rs1_val==1717986918 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28f, 0x66666666, 0x66666666, x13, 848, x1)

inst_230:
// rs1_val==1717986918 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0x66666666, 0xb504, x13, 852, x1)

inst_231:
// rs1_val==1717986918 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666666, 0x0, x13, 856, x1)

inst_232:
// rs1_val==1717986918 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6665, 0x66666666, 0xffff, x13, 860, x1)

inst_233:
// rs1_val==1717986918 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666666, 0x2, x13, 864, x1)

inst_234:
// rs1_val==1717986918 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x66666666, 0x55555554, x13, 868, x1)

inst_235:
// rs1_val==1717986918 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444443, 0x66666666, 0xaaaaaaa9, x13, 872, x1)

inst_236:
// rs1_val==1717986918 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x66666666, 0x4, x13, 876, x1)

inst_237:
// rs1_val==1717986918 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x66666666, 0x33333332, x13, 880, x1)

inst_238:
// rs1_val==1717986918 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28e, 0x66666666, 0x66666665, x13, 884, x1)

inst_239:
// rs1_val==1717986918 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0x66666666, 0xb503, x13, 888, x1)

inst_240:
// rs1_val==1717986918 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6665, 0x66666666, 0xfffe, x13, 892, x1)

inst_241:
// rs1_val==1717986918 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x66666666, 0x55555556, x13, 896, x1)

inst_242:
// rs1_val==1717986918 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444444, 0x66666666, 0xaaaaaaab, x13, 900, x1)

inst_243:
// rs1_val==1717986918 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x66666666, 0x6, x13, 904, x1)

inst_244:
// rs1_val==1717986918 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x66666666, 0x33333334, x13, 908, x1)

inst_245:
// rs1_val==1717986918 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28f, 0x66666666, 0x66666667, x13, 912, x1)

inst_246:
// rs1_val==1717986918 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4868, 0x66666666, 0xb505, x13, 916, x1)

inst_247:
// rs1_val==1717986918 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666666, 0x1, x13, 920, x1)

inst_248:
// rs1_val==1717986918 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666666;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6666, 0x66666666, 0x10000, x13, 924, x1)

inst_249:
// rs1_val==-46340 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0x3, x13, 928, x1)

inst_250:
// rs1_val==-46340 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0xb504, 0x55555555, x13, 932, x1)

inst_251:
// rs1_val==-46340 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffff8752, -0xb504, 0xaaaaaaaa, x13, 936, x1)

inst_252:
// rs1_val==-46340 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0x5, x13, 940, x1)

inst_253:
// rs1_val==-46340 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffdbcc, -0xb504, 0x33333333, x13, 944, x1)

inst_254:
// rs1_val==-46340 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffb798, -0xb504, 0x66666666, x13, 948, x1)

inst_255:
// rs1_val==-46340 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0xb504, x13, 952, x1)

inst_256:
// rs1_val==-46340 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, -0xb504, 0x0, x13, 956, x1)

inst_257:
// rs1_val==-46340 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0xffff, x13, 960, x1)

inst_258:
// rs1_val==-46340 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0x2, x13, 964, x1)

inst_259:
// rs1_val==-46340 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0xb504, 0x55555554, x13, 968, x1)

inst_260:
// rs1_val==-46340 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffff8752, -0xb504, 0xaaaaaaa9, x13, 972, x1)

inst_261:
// rs1_val==-46340 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0x4, x13, 976, x1)

inst_262:
// rs1_val==-46340 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffdbcc, -0xb504, 0x33333332, x13, 980, x1)

inst_263:
// rs1_val==-46340 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffb798, -0xb504, 0x66666665, x13, 984, x1)

inst_264:
// rs1_val==-46340 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0xb503, x13, 988, x1)

inst_265:
// rs1_val==-46340 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0xfffe, x13, 992, x1)

inst_266:
// rs1_val==-46340 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0xb504, 0x55555556, x13, 996, x1)

inst_267:
// rs1_val==-46340 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffff8752, -0xb504, 0xaaaaaaab, x13, 1000, x1)

inst_268:
// rs1_val==-46340 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0x6, x13, 1004, x1)

inst_269:
// rs1_val==-46340 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffdbcb, -0xb504, 0x33333334, x13, 1008, x1)

inst_270:
// rs1_val==-46340 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffb797, -0xb504, 0x66666667, x13, 1012, x1)

inst_271:
// rs1_val==-46340 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0xb505, x13, 1016, x1)

inst_272:
// rs1_val==-46340 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0x1, x13, 1020, x1)

inst_273:
// rs1_val==-46340 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb504;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb504, 0x10000, x13, 1024, x1)

inst_274:
// rs1_val==46340 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0x3, x13, 1028, x1)

inst_275:
// rs1_val==46340 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0xb504, 0x55555555, x13, 1032, x1)

inst_276:
// rs1_val==46340 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ad, 0xb504, 0xaaaaaaaa, x13, 1036, x1)

inst_277:
// rs1_val==46340 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0x5, x13, 1040, x1)

inst_278:
// rs1_val==46340 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0xb504, 0x33333333, x13, 1044, x1)

inst_279:
// rs1_val==46340 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0xb504, 0x66666666, x13, 1048, x1)

inst_280:
// rs1_val==46340 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0xb504, x13, 1052, x1)

inst_281:
// rs1_val==46340 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0x0, x13, 1056, x1)

inst_282:
// rs1_val==46340 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0xffff, x13, 1060, x1)

inst_283:
// rs1_val==46340 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0x2, x13, 1064, x1)

inst_284:
// rs1_val==46340 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0xb504, 0x55555554, x13, 1068, x1)

inst_285:
// rs1_val==46340 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ad, 0xb504, 0xaaaaaaa9, x13, 1072, x1)

inst_286:
// rs1_val==46340 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0x4, x13, 1076, x1)

inst_287:
// rs1_val==46340 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0xb504, 0x33333332, x13, 1080, x1)

inst_288:
// rs1_val==46340 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0xb504, 0x66666665, x13, 1084, x1)

inst_289:
// rs1_val==46340 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0xb503, x13, 1088, x1)

inst_290:
// rs1_val==46340 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0xfffe, x13, 1092, x1)

inst_291:
// rs1_val==46340 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0xb504, 0x55555556, x13, 1096, x1)

inst_292:
// rs1_val==46340 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ad, 0xb504, 0xaaaaaaab, x13, 1100, x1)

inst_293:
// rs1_val==46340 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0x6, x13, 1104, x1)

inst_294:
// rs1_val==46340 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2434, 0xb504, 0x33333334, x13, 1108, x1)

inst_295:
// rs1_val==46340 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4868, 0xb504, 0x66666667, x13, 1112, x1)

inst_296:
// rs1_val==46340 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0xb505, x13, 1116, x1)

inst_297:
// rs1_val==46340 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0x1, x13, 1120, x1)

inst_298:
// rs1_val==46340 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb504;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb504, 0x10000, x13, 1124, x1)

inst_299:
// rs1_val==2 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x3, x13, 1128, x1)

inst_300:
// rs1_val==2 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x55555555, x13, 1132, x1)

inst_301:
// rs1_val==2 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x2, 0xaaaaaaaa, x13, 1136, x1)

inst_302:
// rs1_val==2 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x5, x13, 1140, x1)

inst_303:
// rs1_val==2 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x33333333, x13, 1144, x1)

inst_304:
// rs1_val==2 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x66666666, x13, 1148, x1)

inst_305:
// rs1_val==2 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0xb504, x13, 1152, x1)

inst_306:
// rs1_val==2 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x0, x13, 1156, x1)

inst_307:
// rs1_val==2 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0xffff, x13, 1160, x1)

inst_308:
// rs1_val==2 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x2, x13, 1164, x1)

inst_309:
// rs1_val==2 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x55555554, x13, 1168, x1)

inst_310:
// rs1_val==2 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x2, 0xaaaaaaa9, x13, 1172, x1)

inst_311:
// rs1_val==2 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x4, x13, 1176, x1)

inst_312:
// rs1_val==2 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x33333332, x13, 1180, x1)

inst_313:
// rs1_val==2 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x66666665, x13, 1184, x1)

inst_314:
// rs1_val==2 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0xb503, x13, 1188, x1)

inst_315:
// rs1_val==2 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0xfffe, x13, 1192, x1)

inst_316:
// rs1_val==2 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x55555556, x13, 1196, x1)

inst_317:
// rs1_val==2 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x2, 0xaaaaaaab, x13, 1200, x1)

inst_318:
// rs1_val==2 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x6, x13, 1204, x1)

inst_319:
// rs1_val==2 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x33333334, x13, 1208, x1)

inst_320:
// rs1_val==2 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x66666667, x13, 1212, x1)

inst_321:
// rs1_val==2 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0xb505, x13, 1216, x1)

inst_322:
// rs1_val==2 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x1, x13, 1220, x1)

inst_323:
// rs1_val==2 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x2, 0x10000, x13, 1224, x1)

inst_324:
// rs1_val==1431655764 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555554, 0x3, x13, 1228, x1)

inst_325:
// rs1_val==1431655764 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71b, 0x55555554, 0x55555555, x13, 1232, x1)

inst_326:
// rs1_val==1431655764 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e37, 0x55555554, 0xaaaaaaaa, x13, 1236, x1)

inst_327:
// rs1_val==1431655764 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555554, 0x5, x13, 1240, x1)

inst_328:
// rs1_val==1431655764 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x55555554, 0x33333333, x13, 1244, x1)

inst_329:
// rs1_val==1431655764 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x55555554, 0x66666666, x13, 1248, x1)

inst_330:
// rs1_val==1431655764 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0x55555554, 0xb504, x13, 1252, x1)

inst_331:
// rs1_val==1431655764 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555554, 0x0, x13, 1256, x1)

inst_332:
// rs1_val==1431655764 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5554, 0x55555554, 0xffff, x13, 1260, x1)

inst_333:
// rs1_val==1431655764 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555554, 0x2, x13, 1264, x1)

inst_334:
// rs1_val==1431655764 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71b, 0x55555554, 0x55555554, x13, 1268, x1)

inst_335:
// rs1_val==1431655764 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e37, 0x55555554, 0xaaaaaaa9, x13, 1272, x1)

inst_336:
// rs1_val==1431655764 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555554, 0x4, x13, 1276, x1)

inst_337:
// rs1_val==1431655764 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x55555554, 0x33333332, x13, 1280, x1)

inst_338:
// rs1_val==1431655764 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x55555554, 0x66666665, x13, 1284, x1)

inst_339:
// rs1_val==1431655764 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0x55555554, 0xb503, x13, 1288, x1)

inst_340:
// rs1_val==1431655764 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5554, 0x55555554, 0xfffe, x13, 1292, x1)

inst_341:
// rs1_val==1431655764 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71c, 0x55555554, 0x55555556, x13, 1296, x1)

inst_342:
// rs1_val==1431655764 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e38, 0x55555554, 0xaaaaaaab, x13, 1300, x1)

inst_343:
// rs1_val==1431655764 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555554, 0x6, x13, 1304, x1)

inst_344:
// rs1_val==1431655764 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111111, 0x55555554, 0x33333334, x13, 1308, x1)

inst_345:
// rs1_val==1431655764 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x55555554, 0x66666667, x13, 1312, x1)

inst_346:
// rs1_val==1431655764 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0x55555554, 0xb505, x13, 1316, x1)

inst_347:
// rs1_val==1431655764 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555554, 0x1, x13, 1320, x1)

inst_348:
// rs1_val==1431655764 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555554;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5555, 0x55555554, 0x10000, x13, 1324, x1)

inst_349:
// rs1_val==0 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x3, x13, 1328, x1)

inst_350:
// rs1_val==0 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x55555555, x13, 1332, x1)

inst_351:
// rs1_val==0 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xaaaaaaaa, x13, 1336, x1)

inst_352:
// rs1_val==0 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x5, x13, 1340, x1)

inst_353:
// rs1_val==0 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x33333333, x13, 1344, x1)

inst_354:
// rs1_val==0 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x66666666, x13, 1348, x1)

inst_355:
// rs1_val==0 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xb504, x13, 1352, x1)

inst_356:
// rs1_val==0 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x0, x13, 1356, x1)

inst_357:
// rs1_val==0 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xffff, x13, 1360, x1)

inst_358:
// rs1_val==0 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x2, x13, 1364, x1)

inst_359:
// rs1_val==0 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x55555554, x13, 1368, x1)

inst_360:
// rs1_val==0 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xaaaaaaa9, x13, 1372, x1)

inst_361:
// rs1_val==0 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x4, x13, 1376, x1)

inst_362:
// rs1_val==0 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x33333332, x13, 1380, x1)

inst_363:
// rs1_val==0 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x66666665, x13, 1384, x1)

inst_364:
// rs1_val==0 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xb503, x13, 1388, x1)

inst_365:
// rs1_val==0 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xfffe, x13, 1392, x1)

inst_366:
// rs1_val==0 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x55555556, x13, 1396, x1)

inst_367:
// rs1_val==0 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xaaaaaaab, x13, 1400, x1)

inst_368:
// rs1_val==0 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x6, x13, 1404, x1)

inst_369:
// rs1_val==0 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x33333334, x13, 1408, x1)

inst_370:
// rs1_val==0 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x66666667, x13, 1412, x1)

inst_371:
// rs1_val==0 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0xb505, x13, 1416, x1)

inst_372:
// rs1_val==0 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x1, x13, 1420, x1)

inst_373:
// rs1_val==0 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x0, 0x10000, x13, 1424, x1)

inst_374:
// rs1_val==4 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x4, 0x55555555, x13, 1428, x1)

inst_375:
// rs1_val==4 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x4, 0xaaaaaaaa, x13, 1432, x1)

inst_376:
// rs1_val==4 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x5, x13, 1436, x1)

inst_377:
// rs1_val==4 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x33333333, x13, 1440, x1)

inst_378:
// rs1_val==4 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x4, 0x66666666, x13, 1444, x1)

inst_379:
// rs1_val==4 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0xb504, x13, 1448, x1)

inst_380:
// rs1_val==4 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x0, x13, 1452, x1)

inst_381:
// rs1_val==4 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0xffff, x13, 1456, x1)

inst_382:
// rs1_val==4 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x2, x13, 1460, x1)

inst_383:
// rs1_val==4 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x4, 0x55555554, x13, 1464, x1)

inst_384:
// rs1_val==4 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x4, 0xaaaaaaa9, x13, 1468, x1)

inst_385:
// rs1_val==4 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x4, x13, 1472, x1)

inst_386:
// rs1_val==4 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x33333332, x13, 1476, x1)

inst_387:
// rs1_val==4 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x4, 0x66666665, x13, 1480, x1)

inst_388:
// rs1_val==4 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0xb503, x13, 1484, x1)

inst_389:
// rs1_val==4 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0xfffe, x13, 1488, x1)

inst_390:
// rs1_val==46339 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0xb505, x13, 1492, x1)

inst_391:
// rs1_val==46339 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0x1, x13, 1496, x1)

inst_392:
// rs1_val==46339 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0x10000, x13, 1500, x1)

inst_393:
// rs1_val==1431655766 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555556, 0x3, x13, 1504, x1)

inst_394:
// rs1_val==1431655766 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71c, 0x55555556, 0x55555555, x13, 1508, x1)

inst_395:
// rs1_val==1431655766 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e39, 0x55555556, 0xaaaaaaaa, x13, 1512, x1)

inst_396:
// rs1_val==1431655766 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555556, 0x5, x13, 1516, x1)

inst_397:
// rs1_val==1431655766 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111111, 0x55555556, 0x33333333, x13, 1520, x1)

inst_398:
// rs1_val==1431655766 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x55555556, 0x66666666, x13, 1524, x1)

inst_399:
// rs1_val==1431655766 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0x55555556, 0xb504, x13, 1528, x1)

inst_400:
// rs1_val==1431655766 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555556, 0x0, x13, 1532, x1)

inst_401:
// rs1_val==1431655766 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5555, 0x55555556, 0xffff, x13, 1536, x1)

inst_402:
// rs1_val==1431655766 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555556, 0x2, x13, 1540, x1)

inst_403:
// rs1_val==1431655766 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71c, 0x55555556, 0x55555554, x13, 1544, x1)

inst_404:
// rs1_val==1431655766 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e38, 0x55555556, 0xaaaaaaa9, x13, 1548, x1)

inst_405:
// rs1_val==1431655766 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x55555556, 0x4, x13, 1552, x1)

inst_406:
// rs1_val==1431655766 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x55555556, 0x33333332, x13, 1556, x1)

inst_407:
// rs1_val==1431655766 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x55555556, 0x66666665, x13, 1560, x1)

inst_408:
// rs1_val==1431655766 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0x55555556, 0xb503, x13, 1564, x1)

inst_409:
// rs1_val==1431655766 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5554, 0x55555556, 0xfffe, x13, 1568, x1)

inst_410:
// rs1_val==1431655766 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1c71c71c, 0x55555556, 0x55555556, x13, 1572, x1)

inst_411:
// rs1_val==1431655766 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x38e38e39, 0x55555556, 0xaaaaaaab, x13, 1576, x1)

inst_412:
// rs1_val==1431655766 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x55555556, 0x6, x13, 1580, x1)

inst_413:
// rs1_val==1431655766 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111111, 0x55555556, 0x33333334, x13, 1584, x1)

inst_414:
// rs1_val==1431655766 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x55555556, 0x66666667, x13, 1588, x1)

inst_415:
// rs1_val==1431655766 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c57, 0x55555556, 0xb505, x13, 1592, x1)

inst_416:
// rs1_val==1431655766 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x55555556, 0x1, x13, 1596, x1)

inst_417:
// rs1_val==1431655766 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x55555556;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x5555, 0x55555556, 0x10000, x13, 1600, x1)

inst_418:
// rs1_val==-1431655765 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x55555555, 0x3, x13, 1604, x1)

inst_419:
// rs1_val==-1431655765 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0xc71c71c7, -0x55555555, 0xaaaaaaaa, x13, 1608, x1)

inst_420:
// rs1_val==-1431655765 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffe, -0x55555555, 0x5, x13, 1612, x1)

inst_421:
// rs1_val==-1431655765 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0xeeeeeeef, -0x55555555, 0x33333333, x13, 1616, x1)

inst_422:
// rs1_val==-1431655765 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0xddddddde, -0x55555555, 0x66666666, x13, 1620, x1)

inst_423:
// rs1_val==-1431655765 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0x55555555, 0xb504, x13, 1624, x1)

inst_424:
// rs1_val==-1431655765 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, -0x55555555, 0x0, x13, 1628, x1)

inst_425:
// rs1_val==-1431655765 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffaaab, -0x55555555, 0xffff, x13, 1632, x1)

inst_426:
// rs1_val==-1431655765 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x55555555, 0x2, x13, 1636, x1)

inst_427:
// rs1_val==-1431655765 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0xe38e38e4, -0x55555555, 0x55555554, x13, 1640, x1)

inst_428:
// rs1_val==-1431655765 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0xc71c71c7, -0x55555555, 0xaaaaaaa9, x13, 1644, x1)

inst_429:
// rs1_val==-1431655765 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffe, -0x55555555, 0x4, x13, 1648, x1)

inst_430:
// rs1_val==-1431655765 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0xeeeeeeef, -0x55555555, 0x33333332, x13, 1652, x1)

inst_431:
// rs1_val==-1431655765 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0xddddddde, -0x55555555, 0x66666665, x13, 1656, x1)

inst_432:
// rs1_val==-1431655765 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0x55555555, 0xb503, x13, 1660, x1)

inst_433:
// rs1_val==-1431655765 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffaaab, -0x55555555, 0xfffe, x13, 1664, x1)

inst_434:
// rs1_val==-1431655765 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0xe38e38e3, -0x55555555, 0x55555556, x13, 1668, x1)

inst_435:
// rs1_val==-1431655765 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0xc71c71c7, -0x55555555, 0xaaaaaaab, x13, 1672, x1)

inst_436:
// rs1_val==-1431655765 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0xfffffffe, -0x55555555, 0x6, x13, 1676, x1)

inst_437:
// rs1_val==-1431655765 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0xeeeeeeee, -0x55555555, 0x33333334, x13, 1680, x1)

inst_438:
// rs1_val==-1431655765 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0xdddddddd, -0x55555555, 0x66666667, x13, 1684, x1)

inst_439:
// rs1_val==-1431655765 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0x55555555, 0xb505, x13, 1688, x1)

inst_440:
// rs1_val==-1431655765 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x55555555, 0x1, x13, 1692, x1)

inst_441:
// rs1_val==-1431655765 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x55555555;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffaaaa, -0x55555555, 0x10000, x13, 1696, x1)

inst_442:
// rs1_val==6 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0x3, x13, 1700, x1)

inst_443:
// rs1_val==6 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x6, 0x55555555, x13, 1704, x1)

inst_444:
// rs1_val==6 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3, 0x6, 0xaaaaaaaa, x13, 1708, x1)

inst_445:
// rs1_val==6 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0x5, x13, 1712, x1)

inst_446:
// rs1_val==6 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x6, 0x33333333, x13, 1716, x1)

inst_447:
// rs1_val==6 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x6, 0x66666666, x13, 1720, x1)

inst_448:
// rs1_val==6 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0xb504, x13, 1724, x1)

inst_449:
// rs1_val==6 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0x0, x13, 1728, x1)

inst_450:
// rs1_val==6 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0xffff, x13, 1732, x1)

inst_451:
// rs1_val==6 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0x2, x13, 1736, x1)

inst_452:
// rs1_val==6 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x6, 0x55555554, x13, 1740, x1)

inst_453:
// rs1_val==6 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3, 0x6, 0xaaaaaaa9, x13, 1744, x1)

inst_454:
// rs1_val==6 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x6, 0x33333332, x13, 1748, x1)

inst_455:
// rs1_val==6 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x6, 0x66666665, x13, 1752, x1)

inst_456:
// rs1_val==6 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0xb503, x13, 1756, x1)

inst_457:
// rs1_val==6 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0xfffe, x13, 1760, x1)

inst_458:
// rs1_val==6 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x6, 0x55555556, x13, 1764, x1)

inst_459:
// rs1_val==6 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4, 0x6, 0xaaaaaaab, x13, 1768, x1)

inst_460:
// rs1_val==6 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0x6, x13, 1772, x1)

inst_461:
// rs1_val==6 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x6, 0x33333334, x13, 1776, x1)

inst_462:
// rs1_val==6 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x6, 0x66666667, x13, 1780, x1)

inst_463:
// rs1_val==6 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0xb505, x13, 1784, x1)

inst_464:
// rs1_val==6 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0x1, x13, 1788, x1)

inst_465:
// rs1_val==6 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x6, 0x10000, x13, 1792, x1)

inst_466:
// rs1_val==858993460 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333334, 0x3, x13, 1796, x1)

inst_467:
// rs1_val==858993460 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111111, 0x33333334, 0x55555555, x13, 1800, x1)

inst_468:
// rs1_val==858993460 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x33333334, 0xaaaaaaaa, x13, 1804, x1)

inst_469:
// rs1_val==858993460 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x33333334, 0x5, x13, 1808, x1)

inst_470:
// rs1_val==858993460 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a3, 0x33333334, 0x33333333, x13, 1812, x1)

inst_471:
// rs1_val==858993460 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x33333334, 0x66666666, x13, 1816, x1)

inst_472:
// rs1_val==858993460 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2434, 0x33333334, 0xb504, x13, 1820, x1)

inst_473:
// rs1_val==858993460 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333334, 0x0, x13, 1824, x1)

inst_474:
// rs1_val==858993460 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3333, 0x33333334, 0xffff, x13, 1828, x1)

inst_475:
// rs1_val==858993460 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333334, 0x2, x13, 1832, x1)

inst_476:
// rs1_val==858993460 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111111, 0x33333334, 0x55555554, x13, 1836, x1)

inst_477:
// rs1_val==858993460 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x33333334, 0xaaaaaaa9, x13, 1840, x1)

inst_478:
// rs1_val==858993460 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333334, 0x4, x13, 1844, x1)

inst_479:
// rs1_val==858993460 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a3, 0x33333334, 0x33333332, x13, 1848, x1)

inst_480:
// rs1_val==858993460 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x33333334, 0x66666665, x13, 1852, x1)

inst_481:
// rs1_val==858993460 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0x33333334, 0xb503, x13, 1856, x1)

inst_482:
// rs1_val==858993460 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3332, 0x33333334, 0xfffe, x13, 1860, x1)

inst_483:
// rs1_val==858993460 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111111, 0x33333334, 0x55555556, x13, 1864, x1)

inst_484:
// rs1_val==858993460 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x33333334, 0xaaaaaaab, x13, 1868, x1)

inst_485:
// rs1_val==858993460 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x33333334, 0x6, x13, 1872, x1)

inst_486:
// rs1_val==858993460 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a4, 0x33333334, 0x33333334, x13, 1876, x1)

inst_487:
// rs1_val==858993460 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae148, 0x33333334, 0x66666667, x13, 1880, x1)

inst_488:
// rs1_val==858993460 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2434, 0x33333334, 0xb505, x13, 1884, x1)

inst_489:
// rs1_val==858993460 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333334, 0x1, x13, 1888, x1)

inst_490:
// rs1_val==858993460 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333334;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3333, 0x33333334, 0x10000, x13, 1892, x1)

inst_491:
// rs1_val==1717986919 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x66666667, 0x3, x13, 1896, x1)

inst_492:
// rs1_val==1717986919 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x66666667, 0x55555555, x13, 1900, x1)

inst_493:
// rs1_val==1717986919 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444444, 0x66666667, 0xaaaaaaaa, x13, 1904, x1)

inst_494:
// rs1_val==1717986919 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x66666667, 0x5, x13, 1908, x1)

inst_495:
// rs1_val==1717986919 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x66666667, 0x33333333, x13, 1912, x1)

inst_496:
// rs1_val==1717986919 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28f, 0x66666667, 0x66666666, x13, 1916, x1)

inst_497:
// rs1_val==1717986919 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4868, 0x66666667, 0xb504, x13, 1920, x1)

inst_498:
// rs1_val==1717986919 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666667, 0x0, x13, 1924, x1)

inst_499:
// rs1_val==1717986919 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6666, 0x66666667, 0xffff, x13, 1928, x1)

inst_500:
// rs1_val==1717986919 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666667, 0x2, x13, 1932, x1)

inst_501:
// rs1_val==1717986919 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x66666667, 0x55555554, x13, 1936, x1)

inst_502:
// rs1_val==1717986919 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444443, 0x66666667, 0xaaaaaaa9, x13, 1940, x1)

inst_503:
// rs1_val==1717986919 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x66666667, 0x4, x13, 1944, x1)

inst_504:
// rs1_val==1717986919 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x66666667, 0x33333332, x13, 1948, x1)

inst_505:
// rs1_val==1717986919 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28f, 0x66666667, 0x66666665, x13, 1952, x1)

inst_506:
// rs1_val==1717986919 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0x66666667, 0xb503, x13, 1956, x1)

inst_507:
// rs1_val==1717986919 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6665, 0x66666667, 0xfffe, x13, 1960, x1)

inst_508:
// rs1_val==1717986919 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222222, 0x66666667, 0x55555556, x13, 1964, x1)

inst_509:
// rs1_val==1717986919 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444444, 0x66666667, 0xaaaaaaab, x13, 1968, x1)

inst_510:
// rs1_val==1717986919 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x66666667, 0x6, x13, 1972, x1)

inst_511:
// rs1_val==1717986919 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae148, 0x66666667, 0x33333334, x13, 1976, x1)

inst_512:
// rs1_val==1717986919 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28f, 0x66666667, 0x66666667, x13, 1980, x1)

inst_513:
// rs1_val==1717986919 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4868, 0x66666667, 0xb505, x13, 1984, x1)

inst_514:
// rs1_val==1717986919 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666667, 0x1, x13, 1988, x1)

inst_515:
// rs1_val==1717986919 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666667;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6666, 0x66666667, 0x10000, x13, 1992, x1)

inst_516:
// rs1_val==-46339 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0x3, x13, 1996, x1)

inst_517:
// rs1_val==-46339 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0xb503, 0x55555555, x13, 2000, x1)

inst_518:
// rs1_val==46339 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0xb503, 0x33333332, x13, 2004, x1)

inst_519:
// rs1_val==-46339 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffff8753, -0xb503, 0xaaaaaaaa, x13, 2008, x1)

inst_520:
// rs1_val==-46339 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0x5, x13, 2012, x1)

inst_521:
// rs1_val==-46339 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffdbcc, -0xb503, 0x33333333, x13, 2016, x1)

inst_522:
// rs1_val==-46339 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffb798, -0xb503, 0x66666666, x13, 2020, x1)

inst_523:
// rs1_val==-46339 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0xb504, x13, 2024, x1)

inst_524:
// rs1_val==-46339 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, -0xb503, 0x0, x13, 2028, x1)

inst_525:
// rs1_val==-46339 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0xffff, x13, 2032, x1)

inst_526:
// rs1_val==-46339 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0x2, x13, 2036, x1)

inst_527:
// rs1_val==-46339 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0xb503, 0x55555554, x13, 2040, x1)

inst_528:
// rs1_val==-46339 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffff8753, -0xb503, 0xaaaaaaa9, x13, 2044, x1)
RVTEST_SIGBASE( x13,signature_x13_1)

inst_529:
// rs1_val==-46339 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0x4, x13, 0, x1)

inst_530:
// rs1_val==-46339 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffdbcc, -0xb503, 0x33333332, x13, 4, x1)

inst_531:
// rs1_val==-46339 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffb798, -0xb503, 0x66666665, x13, 8, x1)

inst_532:
// rs1_val==-46339 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0xb503, x13, 12, x1)

inst_533:
// rs1_val==-46339 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0xfffe, x13, 16, x1)

inst_534:
// rs1_val==-46339 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffc3a9, -0xb503, 0x55555556, x13, 20, x1)

inst_535:
// rs1_val==-46339 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffff8753, -0xb503, 0xaaaaaaab, x13, 24, x1)

inst_536:
// rs1_val==-46339 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0x6, x13, 28, x1)

inst_537:
// rs1_val==-46339 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffdbcc, -0xb503, 0x33333334, x13, 32, x1)

inst_538:
// rs1_val==-46339 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffb798, -0xb503, 0x66666667, x13, 36, x1)

inst_539:
// rs1_val==-46339 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0xb505, x13, 40, x1)

inst_540:
// rs1_val==-46339 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0x1, x13, 44, x1)

inst_541:
// rs1_val==-46339 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0xb503;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0xb503, 0x10000, x13, 48, x1)

inst_542:
// rs1_val==46341 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0x3, x13, 52, x1)

inst_543:
// rs1_val==46341 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0xb505, 0x55555555, x13, 56, x1)

inst_544:
// rs1_val==46341 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ad, 0xb505, 0xaaaaaaaa, x13, 60, x1)

inst_545:
// rs1_val==46341 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0x5, x13, 64, x1)

inst_546:
// rs1_val==46341 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2434, 0xb505, 0x33333333, x13, 68, x1)

inst_547:
// rs1_val==46341 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4868, 0xb505, 0x66666666, x13, 72, x1)

inst_548:
// rs1_val==46341 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0xb504, x13, 76, x1)

inst_549:
// rs1_val==46341 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0x0, x13, 80, x1)

inst_550:
// rs1_val==46341 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0xffff, x13, 84, x1)

inst_551:
// rs1_val==46341 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0x2, x13, 88, x1)

inst_552:
// rs1_val==46341 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0xb505, 0x55555554, x13, 92, x1)

inst_553:
// rs1_val==46341 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ad, 0xb505, 0xaaaaaaa9, x13, 96, x1)

inst_554:
// rs1_val==46341 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0x4, x13, 100, x1)

inst_555:
// rs1_val==46341 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2434, 0xb505, 0x33333332, x13, 104, x1)

inst_556:
// rs1_val==46341 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4868, 0xb505, 0x66666665, x13, 108, x1)

inst_557:
// rs1_val==46341 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0xb503, x13, 112, x1)

inst_558:
// rs1_val==46341 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0xfffe, x13, 116, x1)

inst_559:
// rs1_val==46341 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c57, 0xb505, 0x55555556, x13, 120, x1)

inst_560:
// rs1_val==46341 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ae, 0xb505, 0xaaaaaaab, x13, 124, x1)

inst_561:
// rs1_val==46341 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0x6, x13, 128, x1)

inst_562:
// rs1_val==46341 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2434, 0xb505, 0x33333334, x13, 132, x1)

inst_563:
// rs1_val==46341 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4868, 0xb505, 0x66666667, x13, 136, x1)

inst_564:
// rs1_val==46341 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0xb505, x13, 140, x1)

inst_565:
// rs1_val==46341 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0x1, x13, 144, x1)

inst_566:
// rs1_val==4 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x4, 0x55555556, x13, 148, x1)

inst_567:
// rs1_val==46341 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb505;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb505, 0x10000, x13, 152, x1)

inst_568:
// rs1_val==4 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x4, 0xaaaaaaab, x13, 156, x1)

inst_569:
// rs1_val==4 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x6, x13, 160, x1)

inst_570:
// rs1_val==4 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x33333334, x13, 164, x1)

inst_571:
// rs1_val==4 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x4, 0x66666667, x13, 168, x1)

inst_572:
// rs1_val==4 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0xb505, x13, 172, x1)

inst_573:
// rs1_val==4 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x1, x13, 176, x1)

inst_574:
// rs1_val==4 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x4, 0x10000, x13, 180, x1)

inst_575:
// rs1_val==858993458 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333332, 0x3, x13, 184, x1)

inst_576:
// rs1_val==858993458 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x33333332, 0x55555555, x13, 188, x1)

inst_577:
// rs1_val==858993458 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x33333332, 0xaaaaaaaa, x13, 192, x1)

inst_578:
// rs1_val==858993458 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333332, 0x5, x13, 196, x1)

inst_579:
// rs1_val==858993458 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a3, 0x33333332, 0x33333333, x13, 200, x1)

inst_580:
// rs1_val==858993458 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x33333332, 0x66666666, x13, 204, x1)

inst_581:
// rs1_val==858993458 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0x33333332, 0xb504, x13, 208, x1)

inst_582:
// rs1_val==858993458 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333332, 0x0, x13, 212, x1)

inst_583:
// rs1_val==858993458 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3332, 0x33333332, 0xffff, x13, 216, x1)

inst_584:
// rs1_val==858993458 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333332, 0x2, x13, 220, x1)

inst_585:
// rs1_val==858993458 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x33333332, 0x55555554, x13, 224, x1)

inst_586:
// rs1_val==858993458 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x33333332, 0xaaaaaaa9, x13, 228, x1)

inst_587:
// rs1_val==858993458 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333332, 0x4, x13, 232, x1)

inst_588:
// rs1_val==858993458 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a3, 0x33333332, 0x33333332, x13, 236, x1)

inst_589:
// rs1_val==858993458 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae146, 0x33333332, 0x66666665, x13, 240, x1)

inst_590:
// rs1_val==858993458 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0x33333332, 0xb503, x13, 244, x1)

inst_591:
// rs1_val==858993458 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3332, 0x33333332, 0xfffe, x13, 248, x1)

inst_592:
// rs1_val==858993458 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x11111110, 0x33333332, 0x55555556, x13, 252, x1)

inst_593:
// rs1_val==858993458 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x33333332, 0xaaaaaaab, x13, 256, x1)

inst_594:
// rs1_val==858993458 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x33333332, 0x6, x13, 260, x1)

inst_595:
// rs1_val==858993458 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0xa3d70a3, 0x33333332, 0x33333334, x13, 264, x1)

inst_596:
// rs1_val==858993458 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x33333332, 0x66666667, x13, 268, x1)

inst_597:
// rs1_val==858993458 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2434, 0x33333332, 0xb505, x13, 272, x1)

inst_598:
// rs1_val==858993458 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x33333332, 0x1, x13, 276, x1)

inst_599:
// rs1_val==858993458 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x33333332;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3333, 0x33333332, 0x10000, x13, 280, x1)

inst_600:
// rs1_val==1717986917 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x66666665, 0x3, x13, 284, x1)

inst_601:
// rs1_val==1717986917 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x66666665, 0x55555555, x13, 288, x1)

inst_602:
// rs1_val==1717986917 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444443, 0x66666665, 0xaaaaaaaa, x13, 292, x1)

inst_603:
// rs1_val==1717986917 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x66666665, 0x5, x13, 296, x1)

inst_604:
// rs1_val==1717986917 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x66666665, 0x33333333, x13, 300, x1)

inst_605:
// rs1_val==1717986917 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28e, 0x66666665, 0x66666666, x13, 304, x1)

inst_606:
// rs1_val==1717986917 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0x66666665, 0xb504, x13, 308, x1)

inst_607:
// rs1_val==1717986917 and rs2_val==0, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x0
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666665, 0x0, x13, 312, x1)

inst_608:
// rs1_val==1717986917 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6665, 0x66666665, 0xffff, x13, 316, x1)

inst_609:
// rs1_val==1717986917 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666665, 0x2, x13, 320, x1)

inst_610:
// rs1_val==1717986917 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x66666665, 0x55555554, x13, 324, x1)

inst_611:
// rs1_val==1717986917 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444442, 0x66666665, 0xaaaaaaa9, x13, 328, x1)

inst_612:
// rs1_val==1717986917 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x1, 0x66666665, 0x4, x13, 332, x1)

inst_613:
// rs1_val==1717986917 and rs2_val==858993458, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333332
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae146, 0x66666665, 0x33333332, x13, 336, x1)

inst_614:
// rs1_val==1717986917 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28e, 0x66666665, 0x66666665, x13, 340, x1)

inst_615:
// rs1_val==1717986917 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0x66666665, 0xb503, x13, 344, x1)

inst_616:
// rs1_val==1717986917 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6665, 0x66666665, 0xfffe, x13, 348, x1)

inst_617:
// rs1_val==1717986917 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x22222221, 0x66666665, 0x55555556, x13, 352, x1)

inst_618:
// rs1_val==1717986917 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x44444443, 0x66666665, 0xaaaaaaab, x13, 356, x1)

inst_619:
// rs1_val==1717986917 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2, 0x66666665, 0x6, x13, 360, x1)

inst_620:
// rs1_val==1717986917 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x147ae147, 0x66666665, 0x33333334, x13, 364, x1)

inst_621:
// rs1_val==1717986917 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x28f5c28f, 0x66666665, 0x66666667, x13, 368, x1)

inst_622:
// rs1_val==1717986917 and rs2_val==46341, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0xb505
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4868, 0x66666665, 0xb505, x13, 372, x1)

inst_623:
// rs1_val==1717986917 and rs2_val==1, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0x66666665, 0x1, x13, 376, x1)

inst_624:
// rs1_val==1717986917 and rs2_val==65536, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x66666665;  op2val:0x10000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x6666, 0x66666665, 0x10000, x13, 380, x1)

inst_625:
// rs1_val==46339 and rs2_val==3, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x3
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0x3, x13, 384, x1)

inst_626:
// rs1_val==46339 and rs2_val==1431655765, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555555
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0xb503, 0x55555555, x13, 388, x1)

inst_627:
// rs1_val==46339 and rs2_val==2863311530, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xaaaaaaaa
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ac, 0xb503, 0xaaaaaaaa, x13, 392, x1)

inst_628:
// rs1_val==46339 and rs2_val==5, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x5
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0x5, x13, 396, x1)

inst_629:
// rs1_val==46339 and rs2_val==858993459, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333333
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0xb503, 0x33333333, x13, 400, x1)

inst_630:
// rs1_val==46339 and rs2_val==1717986918, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666666
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0xb503, 0x66666666, x13, 404, x1)

inst_631:
// rs1_val==46339 and rs2_val==46340, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb504
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0xb504, x13, 408, x1)

inst_632:
// rs1_val==46339 and rs2_val==65535, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xffff
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0xffff, x13, 412, x1)

inst_633:
// rs1_val==46339 and rs2_val==2, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x2
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0x2, x13, 416, x1)

inst_634:
// rs1_val==46339 and rs2_val==1431655764, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555554
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0xb503, 0x55555554, x13, 420, x1)

inst_635:
// rs1_val==46339 and rs2_val==2863311529, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xaaaaaaa9
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ac, 0xb503, 0xaaaaaaa9, x13, 424, x1)

inst_636:
// rs1_val==46339 and rs2_val==4, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x4
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0x4, x13, 428, x1)

inst_637:
// rs1_val==46339 and rs2_val==1717986917, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666665
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0xb503, 0x66666665, x13, 432, x1)

inst_638:
// rs1_val==46339 and rs2_val==46339, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xb503
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0xb503, x13, 436, x1)

inst_639:
// rs1_val==46339 and rs2_val==65534, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xfffe
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0xfffe, x13, 440, x1)

inst_640:
// rs1_val==46339 and rs2_val==1431655766, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x55555556
TEST_RR_OP(mulhsu, x12, x10, x11, 0x3c56, 0xb503, 0x55555556, x13, 444, x1)

inst_641:
// rs1_val==46339 and rs2_val==2863311531, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0xaaaaaaab
TEST_RR_OP(mulhsu, x12, x10, x11, 0x78ac, 0xb503, 0xaaaaaaab, x13, 448, x1)

inst_642:
// rs1_val==46339 and rs2_val==6, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x6
TEST_RR_OP(mulhsu, x12, x10, x11, 0x0, 0xb503, 0x6, x13, 452, x1)

inst_643:
// rs1_val==46339 and rs2_val==858993460, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x33333334
TEST_RR_OP(mulhsu, x12, x10, x11, 0x2433, 0xb503, 0x33333334, x13, 456, x1)

inst_644:
// rs1_val==46339 and rs2_val==1717986919, 
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0xb503;  op2val:0x66666667
TEST_RR_OP(mulhsu, x12, x10, x11, 0x4867, 0xb503, 0x66666667, x13, 460, x1)

inst_645:
// rs2_val == 1, rs1_val == -536870913
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:0x1
TEST_RR_OP(mulhsu, x12, x10, x11, 0xffffffff, -0x20000001, 0x1, x13, 464, x1)

inst_646:
// rs1_val == (-2**(xlen-1)), rs1_val == -2147483648, rs2_val == 4294967263
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000;  op2val:0xffffffdf
TEST_RR_OP(mulhsu, x12, x10, x11, 0x80000010, -0x80000000, 0xffffffdf, x13, 468, x1)

inst_647:
// rs2_val == 8192, rs1_val == 4194304
// opcode: mulhsu ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0x2000
TEST_RR_OP(mulhsu, x12, x10, x11, 0x8, 0x400000, 0x2000, x13, 472, x1)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x17_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x17_1:
    .fill 17*(XLEN/32),4,0xdeadbeef


signature_x13_0:
    .fill 512*(XLEN/32),4,0xdeadbeef


signature_x13_1:
    .fill 119*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
