
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 04:49:48 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64ic.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the c.add instruction of the RISC-V C extension for the cadd covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IC")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*C.*);def TEST_CASE_1=True;",cadd)

RVTEST_SIGBASE( x6,signature_x6_1)

inst_0:
// rs1 != rs2, rs1==x4, rs2==x1, rs2_val == (-2**(xlen-1)), rs2_val == -9223372036854775808, rs2_val < 0, rs1_val == 524288
// opcode: c.add; op1:x4; op2:x1; op1val:0x80000; op2val:-0x8000000000000000
TEST_CR_OP( c.add, x4, x1, 0x8000000000080000, 0x80000, -0x8000000000000000, x6, 0, x17)

inst_1:
// rs1 == rs2, rs1==x5, rs2==x5, rs2_val == 0, rs1_val == -1073741825
// opcode: c.add; op1:x5; op2:x5; op1val:-0x40000001; op2val:-0x40000001
TEST_CR_OP( c.add, x5, x5, 0xffffffff7ffffffe, -0x40000001, -0x40000001, x6, 8, x17)

inst_2:
// rs1==x20, rs2==x19, rs2_val == (2**(xlen-1)-1), rs2_val > 0, rs2_val == 9223372036854775807
// opcode: c.add; op1:x20; op2:x19; op1val:0x6666666666666665; op2val:0x7fffffffffffffff
TEST_CR_OP( c.add, x20, x19, 0xe666666666666664, 0x6666666666666665, 0x7fffffffffffffff, x6, 16, x17)

inst_3:
// rs1==x26, rs2==x24, rs2_val == 1, rs1_val == -536870913
// opcode: c.add; op1:x26; op2:x24; op1val:-0x20000001; op2val:0x1
TEST_CR_OP( c.add, x26, x24, 0xffffffffe0000000, -0x20000001, 0x1, x6, 24, x17)

inst_4:
// rs1==x12, rs2==x20, rs1_val == (-2**(xlen-1)), rs2_val == 549755813888, rs1_val == -9223372036854775808
// opcode: c.add; op1:x12; op2:x20; op1val:-0x8000000000000000; op2val:0x8000000000
TEST_CR_OP( c.add, x12, x20, 0x8000008000000000, -0x8000000000000000, 0x8000000000, x6, 32, x17)

inst_5:
// rs1==x2, rs2==x9, rs1_val == 0, rs2_val == 140737488355328
// opcode: c.add; op1:x2; op2:x9; op1val:0x0; op2val:0x800000000000
TEST_CR_OP( c.add, x2, x9, 0x800000000000, 0x0, 0x800000000000, x6, 40, x17)

inst_6:
// rs1==x29, rs2==x3, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807
// opcode: c.add; op1:x29; op2:x3; op1val:0x7fffffffffffffff; op2val:0x3333333333333334
TEST_CR_OP( c.add, x29, x3, 0xb333333333333333, 0x7fffffffffffffff, 0x3333333333333334, x6, 48, x17)

inst_7:
// rs1==x0, rs2==x7, rs1_val == 1, rs2_val == 68719476736
// opcode: c.add; op1:x0; op2:x7; op1val:0x0; op2val:0x1000000000
TEST_CR_OP( c.add, x0, x7, 0, 0x0, 0x1000000000, x6, 56, x17)

inst_8:
// rs1==x28, rs2==x10, rs2_val == 2, rs1_val == 4611686018427387904
// opcode: c.add; op1:x28; op2:x10; op1val:0x4000000000000000; op2val:0x2
TEST_CR_OP( c.add, x28, x10, 0x4000000000000002, 0x4000000000000000, 0x2, x6, 64, x17)

inst_9:
// rs1==x14, rs2==x12, rs2_val == 4, rs1_val == -4611686018427387905
// opcode: c.add; op1:x14; op2:x12; op1val:-0x4000000000000001; op2val:0x4
TEST_CR_OP( c.add, x14, x12, 0xc000000000000003, -0x4000000000000001, 0x4, x6, 72, x17)

inst_10:
// rs1==x18, rs2==x13, rs2_val == 8, rs1_val == -4097
// opcode: c.add; op1:x18; op2:x13; op1val:-0x1001; op2val:0x8
TEST_CR_OP( c.add, x18, x13, 0xfffffffffffff007, -0x1001, 0x8, x6, 80, x17)

inst_11:
// rs1==x25, rs2==x28, rs2_val == 16, rs1_val == 4
// opcode: c.add; op1:x25; op2:x28; op1val:0x4; op2val:0x10
TEST_CR_OP( c.add, x25, x28, 0x14, 0x4, 0x10, x6, 88, x17)

inst_12:
// rs1==x15, rs2==x31, rs2_val == 32, rs1_val == -134217729
// opcode: c.add; op1:x15; op2:x31; op1val:-0x8000001; op2val:0x20
TEST_CR_OP( c.add, x15, x31, 0xfffffffff800001f, -0x8000001, 0x20, x6, 96, x17)

inst_13:
// rs1==x8, rs2==x29, rs2_val == 64, rs1_val == -70368744177665
// opcode: c.add; op1:x8; op2:x29; op1val:-0x400000000001; op2val:0x40
TEST_CR_OP( c.add, x8, x29, 0xffffc0000000003f, -0x400000000001, 0x40, x6, 104, x17)

inst_14:
// rs1==x27, rs2==x30, rs2_val == 128, rs1_val == 2251799813685248
// opcode: c.add; op1:x27; op2:x30; op1val:0x8000000000000; op2val:0x80
TEST_CR_OP( c.add, x27, x30, 0x8000000000080, 0x8000000000000, 0x80, x6, 112, x17)

inst_15:
// rs1==x24, rs2==x27, rs2_val == 256, 
// opcode: c.add; op1:x24; op2:x27; op1val:0x6666666666666666; op2val:0x100
TEST_CR_OP( c.add, x24, x27, 0x6666666666666766, 0x6666666666666666, 0x100, x6, 120, x17)

inst_16:
// rs1==x10, rs2==x11, rs2_val == 512, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x9; op2val:0x200
TEST_CR_OP( c.add, x10, x11, 0x209, 0x9, 0x200, x6, 128, x17)

inst_17:
// rs1==x16, rs2==x4, rs2_val == 1024, 
// opcode: c.add; op1:x16; op2:x4; op1val:0x6666666666666665; op2val:0x400
TEST_CR_OP( c.add, x16, x4, 0x6666666666666a65, 0x6666666666666665, 0x400, x6, 136, x17)

inst_18:
// rs1==x19, rs2==x18, rs2_val == 2048, rs1_val == -16385
// opcode: c.add; op1:x19; op2:x18; op1val:-0x4001; op2val:0x800
TEST_CR_OP( c.add, x19, x18, 0xffffffffffffc7ff, -0x4001, 0x800, x6, 144, x17)

inst_19:
// rs1==x9, rs2==x22, rs2_val == 4096, rs1_val == 36028797018963968
// opcode: c.add; op1:x9; op2:x22; op1val:0x80000000000000; op2val:0x1000
TEST_CR_OP( c.add, x9, x22, 0x80000000001000, 0x80000000000000, 0x1000, x6, 152, x17)

inst_20:
// rs1==x23, rs2==x16, rs2_val == 8192, 
// opcode: c.add; op1:x23; op2:x16; op1val:0x5555555555555554; op2val:0x2000
TEST_CR_OP( c.add, x23, x16, 0x5555555555557554, 0x5555555555555554, 0x2000, x6, 160, x5)
RVTEST_SIGBASE( x4,signature_x4_0)

inst_21:
// rs1==x31, rs2==x25, rs2_val == 16384, 
// opcode: c.add; op1:x31; op2:x25; op1val:0xb504f333; op2val:0x4000
TEST_CR_OP( c.add, x31, x25, 0xb5053333, 0xb504f333, 0x4000, x4, 0, x5)

inst_22:
// rs1==x30, rs2==x26, rs2_val == 32768, 
// opcode: c.add; op1:x30; op2:x26; op1val:-0x8; op2val:0x8000
TEST_CR_OP( c.add, x30, x26, 0x7ff8, -0x8, 0x8000, x4, 8, x5)

inst_23:
// rs1==x17, rs2==x21, rs2_val == 65536, rs1_val == -576460752303423489
// opcode: c.add; op1:x17; op2:x21; op1val:-0x800000000000001; op2val:0x10000
TEST_CR_OP( c.add, x17, x21, 0xf80000000000ffff, -0x800000000000001, 0x10000, x4, 16, x5)

inst_24:
// rs1==x13, rs2==x14, rs2_val == 131072, rs1_val == -2251799813685249
// opcode: c.add; op1:x13; op2:x14; op1val:-0x8000000000001; op2val:0x20000
TEST_CR_OP( c.add, x13, x14, 0xfff800000001ffff, -0x8000000000001, 0x20000, x4, 24, x5)

inst_25:
// rs1==x7, rs2==x17, rs2_val == 262144, rs1_val == 262144
// opcode: c.add; op1:x7; op2:x17; op1val:0x40000; op2val:0x40000
TEST_CR_OP( c.add, x7, x17, 0x80000, 0x40000, 0x40000, x4, 32, x5)

inst_26:
// rs1==x3, rs2==x23, rs2_val == 524288, 
// opcode: c.add; op1:x3; op2:x23; op1val:0x80000000000000; op2val:0x80000
TEST_CR_OP( c.add, x3, x23, 0x80000000080000, 0x80000000000000, 0x80000, x4, 40, x5)

inst_27:
// rs1==x21, rs2==x8, rs2_val == 1048576, 
// opcode: c.add; op1:x21; op2:x8; op1val:0x40000; op2val:0x100000
TEST_CR_OP( c.add, x21, x8, 0x140000, 0x40000, 0x100000, x4, 48, x5)

inst_28:
// rs1==x11, rs2==x15, rs2_val == 2097152, rs1_val == -72057594037927937
// opcode: c.add; op1:x11; op2:x15; op1val:-0x100000000000001; op2val:0x200000
TEST_CR_OP( c.add, x11, x15, 0xff000000001fffff, -0x100000000000001, 0x200000, x4, 56, x5)

inst_29:
// rs1==x1, rs2==x6, rs2_val == 4194304, rs1_val == 17592186044416
// opcode: c.add; op1:x1; op2:x6; op1val:0x100000000000; op2val:0x400000
TEST_CR_OP( c.add, x1, x6, 0x100000400000, 0x100000000000, 0x400000, x4, 64, x5)

inst_30:
// rs1==x22, rs2==x2, rs2_val == 8388608, rs1_val == 2305843009213693952
// opcode: c.add; op1:x22; op2:x2; op1val:0x2000000000000000; op2val:0x800000
TEST_CR_OP( c.add, x22, x2, 0x2000000000800000, 0x2000000000000000, 0x800000, x4, 72, x5)

inst_31:
// rs1==x6, rs2_val == 16777216, rs1_val == -2
// opcode: c.add; op1:x6; op2:x11; op1val:-0x2; op2val:0x1000000
TEST_CR_OP( c.add, x6, x11, 0xfffffe, -0x2, 0x1000000, x4, 80, x5)

inst_32:
// rs2_val == 33554432, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x1; op2val:0x2000000
TEST_CR_OP( c.add, x10, x11, 0x1ffffff, -0x1, 0x2000000, x4, 88, x5)

inst_33:
// rs2_val == 67108864, rs1_val == -2049
// opcode: c.add; op1:x10; op2:x11; op1val:-0x801; op2val:0x4000000
TEST_CR_OP( c.add, x10, x11, 0x3fff7ff, -0x801, 0x4000000, x4, 96, x5)

inst_34:
// rs2_val == 134217728, rs1_val == 8796093022208
// opcode: c.add; op1:x10; op2:x11; op1val:0x80000000000; op2val:0x8000000
TEST_CR_OP( c.add, x10, x11, 0x80008000000, 0x80000000000, 0x8000000, x4, 104, x5)

inst_35:
// rs2_val == 268435456, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x7fffffffffffffff; op2val:0x10000000
TEST_CR_OP( c.add, x10, x11, 0x800000000fffffff, 0x7fffffffffffffff, 0x10000000, x4, 112, x5)

inst_36:
// rs2_val == 536870912, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x7; op2val:0x20000000
TEST_CR_OP( c.add, x10, x11, 0x20000007, 0x7, 0x20000000, x4, 120, x5)

inst_37:
// rs2_val == 1073741824, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x4; op2val:0x40000000
TEST_CR_OP( c.add, x10, x11, 0x3ffffffc, -0x4, 0x40000000, x4, 128, x5)

inst_38:
// rs2_val == 2147483648, rs1_val == 6148914691236517205
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x80000000
TEST_CR_OP( c.add, x10, x11, 0x55555555d5555555, 0x5555555555555555, 0x80000000, x4, 136, x5)

inst_39:
// rs2_val == 4294967296, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x80000; op2val:0x100000000
TEST_CR_OP( c.add, x10, x11, 0x100080000, 0x80000, 0x100000000, x4, 144, x5)

inst_40:
// rs2_val == 8589934592, rs1_val == 68719476736
// opcode: c.add; op1:x10; op2:x11; op1val:0x1000000000; op2val:0x200000000
TEST_CR_OP( c.add, x10, x11, 0x1200000000, 0x1000000000, 0x200000000, x4, 152, x5)

inst_41:
// rs2_val == 17179869184, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x4000000000000000; op2val:0x400000000
TEST_CR_OP( c.add, x10, x11, 0xc000000400000000, -0x4000000000000000, 0x400000000, x4, 160, x5)

inst_42:
// rs2_val == 34359738368, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x800000000
TEST_CR_OP( c.add, x10, x11, 0x8b504f334, 0xb504f334, 0x800000000, x4, 168, x5)

inst_43:
// rs2_val == 137438953472, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x2000000000
TEST_CR_OP( c.add, x10, x11, 0x2000000006, 0x6, 0x2000000000, x4, 176, x5)

inst_44:
// rs2_val == 274877906944, rs1_val == -35184372088833
// opcode: c.add; op1:x10; op2:x11; op1val:-0x200000000001; op2val:0x4000000000
TEST_CR_OP( c.add, x10, x11, 0xffffe03fffffffff, -0x200000000001, 0x4000000000, x4, 184, x5)

inst_45:
// rs2_val == 1099511627776, rs1_val == -8796093022209
// opcode: c.add; op1:x10; op2:x11; op1val:-0x80000000001; op2val:0x10000000000
TEST_CR_OP( c.add, x10, x11, 0xfffff8ffffffffff, -0x80000000001, 0x10000000000, x4, 192, x5)

inst_46:
// rs2_val == 2199023255552, rs1_val == -3
// opcode: c.add; op1:x10; op2:x11; op1val:-0x3; op2val:0x20000000000
TEST_CR_OP( c.add, x10, x11, 0x1fffffffffd, -0x3, 0x20000000000, x4, 200, x5)

inst_47:
// rs2_val == 4398046511104, rs1_val == 4503599627370496
// opcode: c.add; op1:x10; op2:x11; op1val:0x10000000000000; op2val:0x40000000000
TEST_CR_OP( c.add, x10, x11, 0x10040000000000, 0x10000000000000, 0x40000000000, x4, 208, x5)

inst_48:
// rs2_val == 8796093022208, rs1_val == -17
// opcode: c.add; op1:x10; op2:x11; op1val:-0x11; op2val:0x80000000000
TEST_CR_OP( c.add, x10, x11, 0x7ffffffffef, -0x11, 0x80000000000, x4, 216, x5)

inst_49:
// rs2_val == 17592186044416, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x100000000000
TEST_CR_OP( c.add, x10, x11, 0x100000000006, 0x6, 0x100000000000, x4, 224, x5)

inst_50:
// rs2_val == 35184372088832, rs1_val == -513
// opcode: c.add; op1:x10; op2:x11; op1val:-0x201; op2val:0x200000000000
TEST_CR_OP( c.add, x10, x11, 0x1ffffffffdff, -0x201, 0x200000000000, x4, 232, x5)

inst_51:
// rs2_val == 70368744177664, rs1_val == -5
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5; op2val:0x400000000000
TEST_CR_OP( c.add, x10, x11, 0x3ffffffffffb, -0x5, 0x400000000000, x4, 240, x5)

inst_52:
// rs2_val == 281474976710656, rs1_val == 8192
// opcode: c.add; op1:x10; op2:x11; op1val:0x2000; op2val:0x1000000000000
TEST_CR_OP( c.add, x10, x11, 0x1000000002000, 0x2000, 0x1000000000000, x4, 248, x5)

inst_53:
// rs2_val == 562949953421312, rs1_val == 4194304
// opcode: c.add; op1:x10; op2:x11; op1val:0x400000; op2val:0x2000000000000
TEST_CR_OP( c.add, x10, x11, 0x2000000400000, 0x400000, 0x2000000000000, x4, 256, x5)

inst_54:
// rs2_val == 1125899906842624, rs1_val == -2097153
// opcode: c.add; op1:x10; op2:x11; op1val:-0x200001; op2val:0x4000000000000
TEST_CR_OP( c.add, x10, x11, 0x3ffffffdfffff, -0x200001, 0x4000000000000, x4, 264, x5)

inst_55:
// rs2_val == 2251799813685248, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x8000000000000
TEST_CR_OP( c.add, x10, x11, 0x555d555555555555, 0x5555555555555555, 0x8000000000000, x4, 272, x5)

inst_56:
// rs2_val == 4503599627370496, rs1_val == -8589934593
// opcode: c.add; op1:x10; op2:x11; op1val:-0x200000001; op2val:0x10000000000000
TEST_CR_OP( c.add, x10, x11, 0xffffdffffffff, -0x200000001, 0x10000000000000, x4, 280, x5)

inst_57:
// rs2_val == 9007199254740992, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x200001; op2val:0x20000000000000
TEST_CR_OP( c.add, x10, x11, 0x1fffffffdfffff, -0x200001, 0x20000000000000, x4, 288, x5)

inst_58:
// rs2_val == 18014398509481984, rs1_val == 536870912
// opcode: c.add; op1:x10; op2:x11; op1val:0x20000000; op2val:0x40000000000000
TEST_CR_OP( c.add, x10, x11, 0x40000020000000, 0x20000000, 0x40000000000000, x4, 296, x5)

inst_59:
// rs2_val == 36028797018963968, rs1_val == 1125899906842624
// opcode: c.add; op1:x10; op2:x11; op1val:0x4000000000000; op2val:0x80000000000000
TEST_CR_OP( c.add, x10, x11, 0x84000000000000, 0x4000000000000, 0x80000000000000, x4, 304, x5)

inst_60:
// rs2_val == 72057594037927936, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x100000000000000
TEST_CR_OP( c.add, x10, x11, 0x5655555555555555, 0x5555555555555555, 0x100000000000000, x4, 312, x5)

inst_61:
// rs2_val == 144115188075855872, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x400000; op2val:0x200000000000000
TEST_CR_OP( c.add, x10, x11, 0x200000000400000, 0x400000, 0x200000000000000, x4, 320, x5)

inst_62:
// rs2_val == 288230376151711744, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x400000000000000
TEST_CR_OP( c.add, x10, x11, 0x400000000000005, 0x5, 0x400000000000000, x4, 328, x5)

inst_63:
// rs2_val == 576460752303423488, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x3; op2val:0x800000000000000
TEST_CR_OP( c.add, x10, x11, 0x7fffffffffffffd, -0x3, 0x800000000000000, x4, 336, x5)

inst_64:
// rs2_val == 1152921504606846976, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x6; op2val:0x1000000000000000
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffa, -0x6, 0x1000000000000000, x4, 344, x5)

inst_65:
// rs2_val == 2305843009213693952, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x4000000000000000; op2val:0x2000000000000000
TEST_CR_OP( c.add, x10, x11, 0xe000000000000000, -0x4000000000000000, 0x2000000000000000, x4, 352, x5)

inst_66:
// rs2_val == 4611686018427387904, rs1_val == -129
// opcode: c.add; op1:x10; op2:x11; op1val:-0x81; op2val:0x4000000000000000
TEST_CR_OP( c.add, x10, x11, 0x3fffffffffffff7f, -0x81, 0x4000000000000000, x4, 360, x5)

inst_67:
// rs2_val == -2, rs1_val == 4096
// opcode: c.add; op1:x10; op2:x11; op1val:0x1000; op2val:-0x2
TEST_CR_OP( c.add, x10, x11, 0xffe, 0x1000, -0x2, x4, 368, x5)

inst_68:
// rs2_val == -3, rs1_val == -1048577
// opcode: c.add; op1:x10; op2:x11; op1val:-0x100001; op2val:-0x3
TEST_CR_OP( c.add, x10, x11, 0xffffffffffeffffc, -0x100001, -0x3, x4, 376, x5)

inst_69:
// rs2_val == -5, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x8000001; op2val:-0x5
TEST_CR_OP( c.add, x10, x11, 0xfffffffff7fffffa, -0x8000001, -0x5, x4, 384, x5)

inst_70:
// rs2_val == -9, rs1_val == -2305843009213693953
// opcode: c.add; op1:x10; op2:x11; op1val:-0x2000000000000001; op2val:-0x9
TEST_CR_OP( c.add, x10, x11, 0xdffffffffffffff6, -0x2000000000000001, -0x9, x4, 392, x5)

inst_71:
// rs2_val == -17, rs1_val == -17179869185
// opcode: c.add; op1:x10; op2:x11; op1val:-0x400000001; op2val:-0x11
TEST_CR_OP( c.add, x10, x11, 0xfffffffbffffffee, -0x400000001, -0x11, x4, 400, x5)

inst_72:
// rs2_val == -33, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0x21
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffe3, 0x4, -0x21, x4, 408, x5)

inst_73:
// rs2_val == -65, rs1_val == 1099511627776
// opcode: c.add; op1:x10; op2:x11; op1val:0x10000000000; op2val:-0x41
TEST_CR_OP( c.add, x10, x11, 0xffffffffbf, 0x10000000000, -0x41, x4, 416, x5)

inst_74:
// rs2_val == -129, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0x81
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffff83, 0x4, -0x81, x4, 424, x5)

inst_75:
// rs2_val == -257, rs1_val == -562949953421313
// opcode: c.add; op1:x10; op2:x11; op1val:-0x2000000000001; op2val:-0x101
TEST_CR_OP( c.add, x10, x11, 0xfffdfffffffffefe, -0x2000000000001, -0x101, x4, 432, x5)

inst_76:
// rs2_val == -513, rs1_val == 32
// opcode: c.add; op1:x10; op2:x11; op1val:0x20; op2val:-0x201
TEST_CR_OP( c.add, x10, x11, 0xfffffffffffffe1f, 0x20, -0x201, x4, 440, x5)

inst_77:
// rs2_val == -1025, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:-0x401
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb08cc, -0xb504f333, -0x401, x4, 448, x5)

inst_78:
// rs2_val == -2049, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x8000000000000000; op2val:-0x801
TEST_CR_OP( c.add, x10, x11, 0x7ffffffffffff7ff, -0x8000000000000000, -0x801, x4, 456, x5)

inst_79:
// rs2_val == -4097, rs1_val == 72057594037927936
// opcode: c.add; op1:x10; op2:x11; op1val:0x100000000000000; op2val:-0x1001
TEST_CR_OP( c.add, x10, x11, 0xffffffffffefff, 0x100000000000000, -0x1001, x4, 464, x5)

inst_80:
// rs2_val == -8193, rs1_val == -2199023255553
// opcode: c.add; op1:x10; op2:x11; op1val:-0x20000000001; op2val:-0x2001
TEST_CR_OP( c.add, x10, x11, 0xfffffdffffffdffe, -0x20000000001, -0x2001, x4, 472, x5)

inst_81:
// rs2_val == -16385, rs1_val == -33
// opcode: c.add; op1:x10; op2:x11; op1val:-0x21; op2val:-0x4001
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffbfde, -0x21, -0x4001, x4, 480, x5)

inst_82:
// rs2_val == -32769, rs1_val == -257
// opcode: c.add; op1:x10; op2:x11; op1val:-0x101; op2val:-0x8001
TEST_CR_OP( c.add, x10, x11, 0xffffffffffff7efe, -0x101, -0x8001, x4, 488, x5)

inst_83:
// rs2_val == -65537, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x2000000000001; op2val:-0x10001
TEST_CR_OP( c.add, x10, x11, 0xfffdfffffffefffe, -0x2000000000001, -0x10001, x4, 496, x5)

inst_84:
// rs2_val == -131073, rs1_val == -32769
// opcode: c.add; op1:x10; op2:x11; op1val:-0x8001; op2val:-0x20001
TEST_CR_OP( c.add, x10, x11, 0xfffffffffffd7ffe, -0x8001, -0x20001, x4, 504, x5)

inst_85:
// rs2_val == -262145, rs1_val == 16
// opcode: c.add; op1:x10; op2:x11; op1val:0x10; op2val:-0x40001
TEST_CR_OP( c.add, x10, x11, 0xfffffffffffc000f, 0x10, -0x40001, x4, 512, x5)

inst_86:
// rs2_val == -524289, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0x80001
TEST_CR_OP( c.add, x10, x11, 0xfffffffffff80003, 0x4, -0x80001, x4, 520, x5)

inst_87:
// rs2_val == -1048577, rs1_val == -262145
// opcode: c.add; op1:x10; op2:x11; op1val:-0x40001; op2val:-0x100001
TEST_CR_OP( c.add, x10, x11, 0xffffffffffebfffe, -0x40001, -0x100001, x4, 528, x5)

inst_88:
// rs2_val == -2097153, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x100000000000000; op2val:-0x200001
TEST_CR_OP( c.add, x10, x11, 0xffffffffdfffff, 0x100000000000000, -0x200001, x4, 536, x5)

inst_89:
// rs2_val == -4194305, rs1_val == -524289
// opcode: c.add; op1:x10; op2:x11; op1val:-0x80001; op2val:-0x400001
TEST_CR_OP( c.add, x10, x11, 0xffffffffffb7fffe, -0x80001, -0x400001, x4, 544, x5)

inst_90:
// rs2_val == -8388609, rs1_val == 2
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:-0x800001
TEST_CR_OP( c.add, x10, x11, 0xffffffffff800001, 0x2, -0x800001, x4, 552, x5)

inst_91:
// rs2_val == -16777217, rs1_val == 65536
// opcode: c.add; op1:x10; op2:x11; op1val:0x10000; op2val:-0x1000001
TEST_CR_OP( c.add, x10, x11, 0xffffffffff00ffff, 0x10000, -0x1000001, x4, 560, x5)

inst_92:
// rs2_val == -33554433, rs1_val == 576460752303423488
// opcode: c.add; op1:x10; op2:x11; op1val:0x800000000000000; op2val:-0x2000001
TEST_CR_OP( c.add, x10, x11, 0x7fffffffdffffff, 0x800000000000000, -0x2000001, x4, 568, x5)

inst_93:
// rs2_val == -67108865, rs1_val == 64
// opcode: c.add; op1:x10; op2:x11; op1val:0x40; op2val:-0x4000001
TEST_CR_OP( c.add, x10, x11, 0xfffffffffc00003f, 0x40, -0x4000001, x4, 576, x5)

inst_94:
// rs2_val == -134217729, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5; op2val:-0x8000001
TEST_CR_OP( c.add, x10, x11, 0xfffffffff7fffffa, -0x5, -0x8000001, x4, 584, x5)

inst_95:
// rs2_val == -268435457, rs1_val == 1048576
// opcode: c.add; op1:x10; op2:x11; op1val:0x100000; op2val:-0x10000001
TEST_CR_OP( c.add, x10, x11, 0xfffffffff00fffff, 0x100000, -0x10000001, x4, 592, x5)

inst_96:
// rs2_val == -536870913, rs1_val == 288230376151711744
// opcode: c.add; op1:x10; op2:x11; op1val:0x400000000000000; op2val:-0x20000001
TEST_CR_OP( c.add, x10, x11, 0x3ffffffdfffffff, 0x400000000000000, -0x20000001, x4, 600, x5)

inst_97:
// rs2_val == -1073741825, rs1_val == 18014398509481984
// opcode: c.add; op1:x10; op2:x11; op1val:0x40000000000000; op2val:-0x40000001
TEST_CR_OP( c.add, x10, x11, 0x3fffffbfffffff, 0x40000000000000, -0x40000001, x4, 608, x5)

inst_98:
// rs2_val == -2147483649, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x8000001; op2val:-0x80000001
TEST_CR_OP( c.add, x10, x11, 0xffffffff77fffffe, -0x8000001, -0x80000001, x4, 616, x5)

inst_99:
// rs2_val == -4294967297, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x20000000001; op2val:-0x100000001
TEST_CR_OP( c.add, x10, x11, 0xfffffdfefffffffe, -0x20000000001, -0x100000001, x4, 624, x5)

inst_100:
// rs2_val == -8589934593, rs1_val == 70368744177664
// opcode: c.add; op1:x10; op2:x11; op1val:0x400000000000; op2val:-0x200000001
TEST_CR_OP( c.add, x10, x11, 0x3ffdffffffff, 0x400000000000, -0x200000001, x4, 632, x5)

inst_101:
// rs2_val == -17179869185, rs1_val == -33554433
// opcode: c.add; op1:x10; op2:x11; op1val:-0x2000001; op2val:-0x400000001
TEST_CR_OP( c.add, x10, x11, 0xfffffffbfdfffffe, -0x2000001, -0x400000001, x4, 640, x5)

inst_102:
// rs2_val == -34359738369, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0x800000001
TEST_CR_OP( c.add, x10, x11, 0xfffffff800000003, 0x4, -0x800000001, x4, 648, x5)

inst_103:
// rs2_val == -68719476737, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x100000000000; op2val:-0x1000000001
TEST_CR_OP( c.add, x10, x11, 0xfefffffffff, 0x100000000000, -0x1000000001, x4, 656, x5)

inst_104:
// rs2_val == -137438953473, rs1_val == -34359738369
// opcode: c.add; op1:x10; op2:x11; op1val:-0x800000001; op2val:-0x2000000001
TEST_CR_OP( c.add, x10, x11, 0xffffffd7fffffffe, -0x800000001, -0x2000000001, x4, 664, x5)

inst_105:
// rs2_val == -274877906945, rs1_val == -9
// opcode: c.add; op1:x10; op2:x11; op1val:-0x9; op2val:-0x4000000001
TEST_CR_OP( c.add, x10, x11, 0xffffffbffffffff6, -0x9, -0x4000000001, x4, 672, x5)

inst_106:
// rs2_val == -549755813889, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x10000; op2val:-0x8000000001
TEST_CR_OP( c.add, x10, x11, 0xffffff800000ffff, 0x10000, -0x8000000001, x4, 680, x5)

inst_107:
// rs2_val == -1099511627777, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:-0x10000000001
TEST_CR_OP( c.add, x10, x11, 0xfffffeff4afb0ccc, -0xb504f333, -0x10000000001, x4, 688, x5)

inst_108:
// rs2_val == -2199023255553, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x7fffffffffffffff; op2val:-0x20000000001
TEST_CR_OP( c.add, x10, x11, 0x7ffffdfffffffffe, 0x7fffffffffffffff, -0x20000000001, x4, 696, x5)

inst_109:
// rs2_val == -4398046511105, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0x40000000001
TEST_CR_OP( c.add, x10, x11, 0xfffffc0000000003, 0x4, -0x40000000001, x4, 704, x5)

inst_110:
// rs2_val == -8796093022209, rs1_val == -65
// opcode: c.add; op1:x10; op2:x11; op1val:-0x41; op2val:-0x80000000001
TEST_CR_OP( c.add, x10, x11, 0xfffff7ffffffffbe, -0x41, -0x80000000001, x4, 712, x5)

inst_111:
// rs2_val == -17592186044417, rs1_val == -9007199254740993
// opcode: c.add; op1:x10; op2:x11; op1val:-0x20000000000001; op2val:-0x100000000001
TEST_CR_OP( c.add, x10, x11, 0xffdfeffffffffffe, -0x20000000000001, -0x100000000001, x4, 720, x5)

inst_112:
// rs2_val == -35184372088833, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x2000001; op2val:-0x200000000001
TEST_CR_OP( c.add, x10, x11, 0xffffdffffdfffffe, -0x2000001, -0x200000000001, x4, 728, x5)

inst_113:
// rs2_val == -70368744177665, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x400000; op2val:-0x400000000001
TEST_CR_OP( c.add, x10, x11, 0xffffc000003fffff, 0x400000, -0x400000000001, x4, 736, x5)

inst_114:
// rs2_val == -140737488355329, rs1_val == 140737488355328
// opcode: c.add; op1:x10; op2:x11; op1val:0x800000000000; op2val:-0x800000000001
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffff, 0x800000000000, -0x800000000001, x4, 744, x5)

inst_115:
// rs2_val == -281474976710657, rs1_val == 2147483648
// opcode: c.add; op1:x10; op2:x11; op1val:0x80000000; op2val:-0x1000000000001
TEST_CR_OP( c.add, x10, x11, 0xffff00007fffffff, 0x80000000, -0x1000000000001, x4, 752, x5)

inst_116:
// rs2_val == -562949953421313, rs1_val == 281474976710656
// opcode: c.add; op1:x10; op2:x11; op1val:0x1000000000000; op2val:-0x2000000000001
TEST_CR_OP( c.add, x10, x11, 0xfffeffffffffffff, 0x1000000000000, -0x2000000000001, x4, 760, x5)

inst_117:
// rs2_val == -1125899906842625, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x40001; op2val:-0x4000000000001
TEST_CR_OP( c.add, x10, x11, 0xfffbfffffffbfffe, -0x40001, -0x4000000000001, x4, 768, x5)

inst_118:
// rs2_val == -2251799813685249, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x20000000000001; op2val:-0x8000000000001
TEST_CR_OP( c.add, x10, x11, 0xffd7fffffffffffe, -0x20000000000001, -0x8000000000001, x4, 776, x5)

inst_119:
// rs2_val == -4503599627370497, rs1_val == -18014398509481985
// opcode: c.add; op1:x10; op2:x11; op1val:-0x40000000000001; op2val:-0x10000000000001
TEST_CR_OP( c.add, x10, x11, 0xffaffffffffffffe, -0x40000000000001, -0x10000000000001, x4, 784, x5)

inst_120:
// rs2_val == -9007199254740993, rs1_val == -4294967297
// opcode: c.add; op1:x10; op2:x11; op1val:-0x100000001; op2val:-0x20000000000001
TEST_CR_OP( c.add, x10, x11, 0xffdffffefffffffe, -0x100000001, -0x20000000000001, x4, 792, x5)

inst_121:
// rs2_val == -18014398509481985, rs1_val == 137438953472
// opcode: c.add; op1:x10; op2:x11; op1val:0x2000000000; op2val:-0x40000000000001
TEST_CR_OP( c.add, x10, x11, 0xffc0001fffffffff, 0x2000000000, -0x40000000000001, x4, 800, x5)

inst_122:
// rs2_val == -36028797018963969, rs1_val == 512
// opcode: c.add; op1:x10; op2:x11; op1val:0x200; op2val:-0x80000000000001
TEST_CR_OP( c.add, x10, x11, 0xff800000000001ff, 0x200, -0x80000000000001, x4, 808, x5)

inst_123:
// rs2_val == -72057594037927937, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:-0x100000000000001
TEST_CR_OP( c.add, x10, x11, 0xff00000000000005, 0x6, -0x100000000000001, x4, 816, x5)

inst_124:
// rs2_val == -144115188075855873, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x80000000; op2val:-0x200000000000001
TEST_CR_OP( c.add, x10, x11, 0xfe0000007fffffff, 0x80000000, -0x200000000000001, x4, 824, x5)

inst_125:
// rs2_val == -288230376151711745, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x20000000; op2val:-0x400000000000001
TEST_CR_OP( c.add, x10, x11, 0xfc0000001fffffff, 0x20000000, -0x400000000000001, x4, 832, x5)

inst_126:
// rs2_val == -576460752303423489, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:-0x800000000000001
TEST_CR_OP( c.add, x10, x11, 0x4d55555555555555, 0x5555555555555556, -0x800000000000001, x4, 840, x5)

inst_127:
// rs2_val == -1152921504606846977, rs1_val == 562949953421312
// opcode: c.add; op1:x10; op2:x11; op1val:0x2000000000000; op2val:-0x1000000000000001
TEST_CR_OP( c.add, x10, x11, 0xf001ffffffffffff, 0x2000000000000, -0x1000000000000001, x4, 848, x5)

inst_128:
// rs2_val == -2305843009213693953, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:-0x2000000000000001
TEST_CR_OP( c.add, x10, x11, 0x3555555555555555, 0x5555555555555556, -0x2000000000000001, x4, 856, x5)

inst_129:
// rs2_val == -4611686018427387905, rs1_val == -67108865
// opcode: c.add; op1:x10; op2:x11; op1val:-0x4000001; op2val:-0x4000000000000001
TEST_CR_OP( c.add, x10, x11, 0xbffffffffbfffffe, -0x4000001, -0x4000000000000001, x4, 864, x5)

inst_130:
// rs2_val == 6148914691236517205, rs1_val == 8
// opcode: c.add; op1:x10; op2:x11; op1val:0x8; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x555555555555555d, 0x8, 0x5555555555555555, x4, 872, x5)

inst_131:
// rs2_val == -6148914691236517206, rs1_val==-3037000498 and rs2_val==-6148914691236517206
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaa9f5a5b778, -0xb504f332, -0x5555555555555556, x4, 880, x5)

inst_132:
// rs1_val == 128, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x80; op2val:-0x400000000000001
TEST_CR_OP( c.add, x10, x11, 0xfc0000000000007f, 0x80, -0x400000000000001, x4, 888, x5)

inst_133:
// rs1_val == 256, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x100; op2val:0x1000000000000000
TEST_CR_OP( c.add, x10, x11, 0x1000000000000100, 0x100, 0x1000000000000000, x4, 896, x5)

inst_134:
// rs1_val == 1024, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x400; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb10ce, 0x400, -0xb504f332, x4, 904, x5)

inst_135:
// rs1_val == 2048, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x800; op2val:-0x11
TEST_CR_OP( c.add, x10, x11, 0x7ef, 0x800, -0x11, x4, 912, x5)

inst_136:
// rs1_val == 16384, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4000; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaeaab, 0x4000, -0x5555555555555555, x4, 920, x5)

inst_137:
// rs1_val == 32768, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x8000; op2val:-0x40000001
TEST_CR_OP( c.add, x10, x11, 0xffffffffc0007fff, 0x8000, -0x40000001, x4, 928, x5)

inst_138:
// rs1_val == 131072, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x20000; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x20002, 0x20000, 0x2, x4, 936, x5)

inst_139:
// rs1_val == 2097152, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x200000; op2val:-0x10000000000001
TEST_CR_OP( c.add, x10, x11, 0xfff00000001fffff, 0x200000, -0x10000000000001, x4, 944, x5)

inst_140:
// rs1_val == 8388608, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x800000; op2val:-0x200001
TEST_CR_OP( c.add, x10, x11, 0x5fffff, 0x800000, -0x200001, x4, 952, x5)

inst_141:
// rs1_val == 16777216, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x1000000; op2val:0x4000000
TEST_CR_OP( c.add, x10, x11, 0x5000000, 0x1000000, 0x4000000, x4, 960, x5)

inst_142:
// rs1_val == 33554432, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2000000; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x3333333335333332, 0x2000000, 0x3333333333333332, x4, 968, x5)

inst_143:
// rs1_val == 67108864, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4000000; op2val:0x8000000000000
TEST_CR_OP( c.add, x10, x11, 0x8000004000000, 0x4000000, 0x8000000000000, x4, 976, x5)

inst_144:
// rs1_val == 134217728, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x8000000; op2val:0x800000000
TEST_CR_OP( c.add, x10, x11, 0x808000000, 0x8000000, 0x800000000, x4, 984, x5)

inst_145:
// rs1_val == 268435456, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x10000000; op2val:-0x41
TEST_CR_OP( c.add, x10, x11, 0xfffffbf, 0x10000000, -0x41, x4, 992, x5)

inst_146:
// rs1_val == 1073741824, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x40000000; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x40000000, 0x40000000, 0x0, x4, 1000, x5)

inst_147:
// rs1_val == 4294967296, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x100000000; op2val:0x80
TEST_CR_OP( c.add, x10, x11, 0x100000080, 0x100000000, 0x80, x4, 1008, x5)

inst_148:
// rs1_val == 8589934592, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x200000000; op2val:-0x2
TEST_CR_OP( c.add, x10, x11, 0x1fffffffe, 0x200000000, -0x2, x4, 1016, x5)

inst_149:
// rs1_val == 17179869184, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x400000000; op2val:-0x2000001
TEST_CR_OP( c.add, x10, x11, 0x3fdffffff, 0x400000000, -0x2000001, x4, 1024, x5)

inst_150:
// rs1_val == 34359738368, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x800000000; op2val:0x80000000
TEST_CR_OP( c.add, x10, x11, 0x880000000, 0x800000000, 0x80000000, x4, 1032, x5)

inst_151:
// rs1_val == 274877906944, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4000000000; op2val:-0x400001
TEST_CR_OP( c.add, x10, x11, 0x3fffbfffff, 0x4000000000, -0x400001, x4, 1040, x5)

inst_152:
// rs1_val == 549755813888, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x8000000000; op2val:-0x800000000001
TEST_CR_OP( c.add, x10, x11, 0xffff807fffffffff, 0x8000000000, -0x800000000001, x4, 1048, x5)

inst_153:
// rs1_val == 2199023255552, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x20000000000; op2val:0x80
TEST_CR_OP( c.add, x10, x11, 0x20000000080, 0x20000000000, 0x80, x4, 1056, x5)

inst_154:
// rs1_val == 4398046511104, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x40000000000; op2val:-0x81
TEST_CR_OP( c.add, x10, x11, 0x3ffffffff7f, 0x40000000000, -0x81, x4, 1064, x5)

inst_155:
// rs1_val == 35184372088832, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x200000000000; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaacaaaaaaaaaaa, 0x200000000000, -0x5555555555555556, x4, 1072, x5)

inst_156:
// rs1_val == 9007199254740992, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x20000000000000; op2val:0x4000000000000
TEST_CR_OP( c.add, x10, x11, 0x24000000000000, 0x20000000000000, 0x4000000000000, x4, 1080, x5)

inst_157:
// rs1_val == 144115188075855872, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x200000000000000; op2val:0x2000000
TEST_CR_OP( c.add, x10, x11, 0x200000002000000, 0x200000000000000, 0x2000000, x4, 1088, x5)

inst_158:
// rs1_val == 1152921504606846976, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x1000000000000000; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xbaaaaaaaaaaaaaaa, 0x1000000000000000, -0x5555555555555556, x4, 1096, x5)

inst_159:
// rs1_val == -1025, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x401; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xb504ef33, -0x401, 0xb504f334, x4, 1104, x5)

inst_160:
// rs1_val == -8193, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x2001; op2val:-0x800000000000001
TEST_CR_OP( c.add, x10, x11, 0xf7ffffffffffdffe, -0x2001, -0x800000000000001, x4, 1112, x5)

inst_161:
// rs1_val == -65537, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x10001; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xfffffffffffeffff, -0x10001, 0x0, x4, 1120, x5)

inst_162:
// rs1_val == -131073, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x20001; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x5555555555535554, -0x20001, 0x5555555555555555, x4, 1128, x5)

inst_163:
// rs1_val == -4194305, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x400001; op2val:0x4000
TEST_CR_OP( c.add, x10, x11, 0xffffffffffc03fff, -0x400001, 0x4000, x4, 1136, x5)

inst_164:
// rs1_val == -8388609, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x800001; op2val:0x10000000000000
TEST_CR_OP( c.add, x10, x11, 0xfffffff7fffff, -0x800001, 0x10000000000000, x4, 1144, x5)

inst_165:
// rs1_val == -16777217, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x1000001; op2val:0x8000000000
TEST_CR_OP( c.add, x10, x11, 0x7ffeffffff, -0x1000001, 0x8000000000, x4, 1152, x5)

inst_166:
// rs1_val == -268435457, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x10000001; op2val:0x20000000000000
TEST_CR_OP( c.add, x10, x11, 0x1fffffefffffff, -0x10000001, 0x20000000000000, x4, 1160, x5)

inst_167:
// rs1_val == -2147483649, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x80000001; op2val:0x8
TEST_CR_OP( c.add, x10, x11, 0xffffffff80000007, -0x80000001, 0x8, x4, 1168, x5)

inst_168:
// rs1_val == -68719476737, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x1000000001; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xffffffefffffffff, -0x1000000001, 0x0, x4, 1176, x5)

inst_169:
// rs1_val == -137438953473, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x2000000001; op2val:0x400000000000
TEST_CR_OP( c.add, x10, x11, 0x3fdfffffffff, -0x2000000001, 0x400000000000, x4, 1184, x5)

inst_170:
// rs1_val == -274877906945, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x4000000001; op2val:-0x4000000001
TEST_CR_OP( c.add, x10, x11, 0xffffff7ffffffffe, -0x4000000001, -0x4000000001, x4, 1192, x5)

inst_171:
// rs1_val == -549755813889, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x8000000001; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xffffff8000000005, -0x8000000001, 0x6, x4, 1200, x5)

inst_172:
// rs1_val == -1099511627777, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x10000000001; op2val:-0x4000000000000000
TEST_CR_OP( c.add, x10, x11, 0xbffffeffffffffff, -0x10000000001, -0x4000000000000000, x4, 1208, x5)

inst_173:
// rs1_val == -4398046511105, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x40000000001; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x5555515555555554, -0x40000000001, 0x5555555555555555, x4, 1216, x5)

inst_174:
// rs1_val == -17592186044417, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x100000000001; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xfffff00000000004, -0x100000000001, 0x5, x4, 1224, x5)

inst_175:
// rs1_val == -140737488355329, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x800000000001; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xffff800000000005, -0x800000000001, 0x6, x4, 1232, x5)

inst_176:
// rs1_val == -281474976710657, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x1000000000001; op2val:0x8000000
TEST_CR_OP( c.add, x10, x11, 0xffff000007ffffff, -0x1000000000001, 0x8000000, x4, 1240, x5)

inst_177:
// rs1_val == -1125899906842625, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x4000000000001; op2val:-0x40000001
TEST_CR_OP( c.add, x10, x11, 0xfffbffffbffffffe, -0x4000000000001, -0x40000001, x4, 1248, x5)

inst_178:
// rs1_val == -4503599627370497, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x10000000000001; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xffefffffffffffff, -0x10000000000001, 0x0, x4, 1256, x5)

inst_179:
// rs1_val == -36028797018963969, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x80000000000001; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xff7fffffffffffff, -0x80000000000001, 0x0, x4, 1264, x5)

inst_180:
// rs1_val == -144115188075855873, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x200000000000001; op2val:0x4000000000000000
TEST_CR_OP( c.add, x10, x11, 0x3dffffffffffffff, -0x200000000000001, 0x4000000000000000, x4, 1272, x5)

inst_181:
// rs1_val == -288230376151711745, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x400000000000001; op2val:0x800000
TEST_CR_OP( c.add, x10, x11, 0xfc000000007fffff, -0x400000000000001, 0x800000, x4, 1280, x5)

inst_182:
// rs1_val == -1152921504606846977, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x1000000000000001; op2val:-0x401
TEST_CR_OP( c.add, x10, x11, 0xeffffffffffffbfe, -0x1000000000000001, -0x401, x4, 1288, x5)

inst_183:
// rs1_val == -6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:-0x20000000001
TEST_CR_OP( c.add, x10, x11, 0xaaaaa8aaaaaaaaa9, -0x5555555555555556, -0x20000000001, x4, 1296, x5)

inst_184:
// rs1_val==3 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x6, 0x3, 0x3, x4, 1304, x5)

inst_185:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x5555555555555558, 0x3, 0x5555555555555555, x4, 1312, x5)

inst_186:
// rs1_val==3 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaad, 0x3, -0x5555555555555556, x4, 1320, x5)

inst_187:
// rs1_val==3 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x8, 0x3, 0x5, x4, 1328, x5)

inst_188:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x3333333333333336, 0x3, 0x3333333333333333, x4, 1336, x5)

inst_189:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x6666666666666669, 0x3, 0x6666666666666666, x4, 1344, x5)

inst_190:
// rs1_val==3 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd0, 0x3, -0xb504f333, x4, 1352, x5)

inst_191:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xb504f336, 0x3, 0xb504f333, x4, 1360, x5)

inst_192:
// rs1_val==3 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x5, 0x3, 0x2, x4, 1368, x5)

inst_193:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x5555555555555557, 0x3, 0x5555555555555554, x4, 1376, x5)

inst_194:
// rs1_val==3 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x3, 0x3, 0x0, x4, 1384, x5)

inst_195:
// rs1_val==3 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x7, 0x3, 0x4, x4, 1392, x5)

inst_196:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x3333333333333335, 0x3, 0x3333333333333332, x4, 1400, x5)

inst_197:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x6666666666666668, 0x3, 0x6666666666666665, x4, 1408, x5)

inst_198:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xb504f335, 0x3, 0xb504f332, x4, 1416, x5)

inst_199:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x5555555555555559, 0x3, 0x5555555555555556, x4, 1424, x5)

inst_200:
// rs1_val==3 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaae, 0x3, -0x5555555555555555, x4, 1432, x5)

inst_201:
// rs1_val==3 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x9, 0x3, 0x6, x4, 1440, x5)

inst_202:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x3333333333333337, 0x3, 0x3333333333333334, x4, 1448, x5)

inst_203:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x666666666666666a, 0x3, 0x6666666666666667, x4, 1456, x5)

inst_204:
// rs1_val==3 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd1, 0x3, -0xb504f332, x4, 1464, x5)

inst_205:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xb504f337, 0x3, 0xb504f334, x4, 1472, x5)

inst_206:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x5555555555555558, 0x5555555555555555, 0x3, x4, 1480, x5)

inst_207:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555555, 0x5555555555555555, x4, 1488, x5)

inst_208:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffff, 0x5555555555555555, -0x5555555555555556, x4, 1496, x5)

inst_209:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x555555555555555a, 0x5555555555555555, 0x5, x4, 1504, x5)

inst_210:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x8888888888888888, 0x5555555555555555, 0x3333333333333333, x4, 1512, x5)

inst_211:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x5555555555555555, 0x6666666666666666, x4, 1520, x5)

inst_212:
// rs1_val==6148914691236517205 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506222, 0x5555555555555555, -0xb504f333, x4, 1528, x5)

inst_213:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4888, 0x5555555555555555, 0xb504f333, x4, 1536, x5)

inst_214:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x5555555555555557, 0x5555555555555555, 0x2, x4, 1544, x5)

inst_215:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x5555555555555555, 0x5555555555555554, x4, 1552, x5)

inst_216:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x0, x4, 1560, x5)

inst_217:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x5555555555555559, 0x5555555555555555, 0x4, x4, 1568, x5)

inst_218:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x8888888888888887, 0x5555555555555555, 0x3333333333333332, x4, 1576, x5)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbba, 0x5555555555555555, 0x6666666666666665, x4, 1584, x5)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4887, 0x5555555555555555, 0xb504f332, x4, 1592, x5)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaab, 0x5555555555555555, 0x5555555555555556, x4, 1600, x5)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x0, 0x5555555555555555, -0x5555555555555555, x4, 1608, x5)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x555555555555555b, 0x5555555555555555, 0x6, x4, 1616, x5)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x8888888888888889, 0x5555555555555555, 0x3333333333333334, x4, 1624, x5)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbc, 0x5555555555555555, 0x6666666666666667, x4, 1632, x5)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506223, 0x5555555555555555, -0xb504f332, x4, 1640, x5)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4889, 0x5555555555555555, 0xb504f334, x4, 1648, x5)

inst_228:
// rs1_val==-6148914691236517206 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaad, -0x5555555555555556, 0x3, x4, 1656, x5)

inst_229:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffff, -0x5555555555555556, 0x5555555555555555, x4, 1664, x5)

inst_230:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x5555555555555554, -0x5555555555555556, -0x5555555555555556, x4, 1672, x5)

inst_231:
// rs1_val==-6148914691236517206 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaf, -0x5555555555555556, 0x5, x4, 1680, x5)

inst_232:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0xdddddddddddddddd, -0x5555555555555556, 0x3333333333333333, x4, 1688, x5)

inst_233:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x1111111111111110, -0x5555555555555556, 0x6666666666666666, x4, 1696, x5)

inst_234:
// rs1_val==-6148914691236517206 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaa9f5a5b777, -0x5555555555555556, -0xb504f333, x4, 1704, x5)

inst_235:
// rs1_val==-6148914691236517206 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9ddd, -0x5555555555555556, 0xb504f333, x4, 1712, x5)

inst_236:
// rs1_val==-6148914691236517206 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaac, -0x5555555555555556, 0x2, x4, 1720, x5)

inst_237:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0xfffffffffffffffe, -0x5555555555555556, 0x5555555555555554, x4, 1728, x5)

inst_238:
// rs1_val==-6148914691236517206 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, 0x0, x4, 1736, x5)

inst_239:
// rs1_val==-6148914691236517206 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x4, x4, 1744, x5)

inst_240:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0xdddddddddddddddc, -0x5555555555555556, 0x3333333333333332, x4, 1752, x5)

inst_241:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x111111111111110f, -0x5555555555555556, 0x6666666666666665, x4, 1760, x5)

inst_242:
// rs1_val==-6148914691236517206 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9ddc, -0x5555555555555556, 0xb504f332, x4, 1768, x5)

inst_243:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x0, -0x5555555555555556, 0x5555555555555556, x4, 1776, x5)

inst_244:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x5555555555555555, -0x5555555555555556, -0x5555555555555555, x4, 1784, x5)

inst_245:
// rs1_val==-6148914691236517206 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaab0, -0x5555555555555556, 0x6, x4, 1792, x5)

inst_246:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0xddddddddddddddde, -0x5555555555555556, 0x3333333333333334, x4, 1800, x5)

inst_247:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x1111111111111111, -0x5555555555555556, 0x6666666666666667, x4, 1808, x5)

inst_248:
// rs1_val==-6148914691236517206 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaa9f5a5b778, -0x5555555555555556, -0xb504f332, x4, 1816, x5)

inst_249:
// rs1_val==-6148914691236517206 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555556; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9dde, -0x5555555555555556, 0xb504f334, x4, 1824, x5)

inst_250:
// rs1_val==5 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x8, 0x5, 0x3, x4, 1832, x5)

inst_251:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x555555555555555a, 0x5, 0x5555555555555555, x4, 1840, x5)

inst_252:
// rs1_val==5 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaf, 0x5, -0x5555555555555556, x4, 1848, x5)

inst_253:
// rs1_val==5 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xa, 0x5, 0x5, x4, 1856, x5)

inst_254:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x3333333333333338, 0x5, 0x3333333333333333, x4, 1864, x5)

inst_255:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x666666666666666b, 0x5, 0x6666666666666666, x4, 1872, x5)

inst_256:
// rs1_val==5 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd2, 0x5, -0xb504f333, x4, 1880, x5)

inst_257:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xb504f338, 0x5, 0xb504f333, x4, 1888, x5)

inst_258:
// rs1_val==5 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x7, 0x5, 0x2, x4, 1896, x5)

inst_259:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x5555555555555559, 0x5, 0x5555555555555554, x4, 1904, x5)

inst_260:
// rs1_val==5 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x5, 0x5, 0x0, x4, 1912, x5)

inst_261:
// rs1_val==5 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x9, 0x5, 0x4, x4, 1920, x5)

inst_262:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x3333333333333337, 0x5, 0x3333333333333332, x4, 1928, x5)

inst_263:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x666666666666666a, 0x5, 0x6666666666666665, x4, 1936, x5)

inst_264:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xb504f337, 0x5, 0xb504f332, x4, 1944, x5)

inst_265:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x555555555555555b, 0x5, 0x5555555555555556, x4, 1952, x5)

inst_266:
// rs1_val==5 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaab0, 0x5, -0x5555555555555555, x4, 1960, x5)

inst_267:
// rs1_val==5 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xb, 0x5, 0x6, x4, 1968, x5)

inst_268:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x3333333333333339, 0x5, 0x3333333333333334, x4, 1976, x5)

inst_269:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x666666666666666c, 0x5, 0x6666666666666667, x4, 1984, x5)

inst_270:
// rs1_val==5 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd3, 0x5, -0xb504f332, x4, 1992, x5)

inst_271:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xb504f339, 0x5, 0xb504f334, x4, 2000, x5)

inst_272:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x3333333333333336, 0x3333333333333333, 0x3, x4, 2008, x5)

inst_273:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x8888888888888888, 0x3333333333333333, 0x5555555555555555, x4, 2016, x5)

inst_274:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xdddddddddddddddd, 0x3333333333333333, -0x5555555555555556, x4, 2024, x5)

inst_275:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x3333333333333338, 0x3333333333333333, 0x5, x4, 2032, x5)

inst_276:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x6666666666666666, 0x3333333333333333, 0x3333333333333333, x4, 2040, x5)
RVTEST_SIGBASE( x4,signature_x4_1)

inst_277:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x9999999999999999, 0x3333333333333333, 0x6666666666666666, x4, 0, x5)

inst_278:
// rs1_val==3689348814741910323 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4000, 0x3333333333333333, -0xb504f333, x4, 8, x5)

inst_279:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382666, 0x3333333333333333, 0xb504f333, x4, 16, x5)

inst_280:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x3333333333333335, 0x3333333333333333, 0x2, x4, 24, x5)

inst_281:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x8888888888888887, 0x3333333333333333, 0x5555555555555554, x4, 32, x5)

inst_282:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x0, x4, 40, x5)

inst_283:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x3333333333333337, 0x3333333333333333, 0x4, x4, 48, x5)

inst_284:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x6666666666666665, 0x3333333333333333, 0x3333333333333332, x4, 56, x5)

inst_285:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x9999999999999998, 0x3333333333333333, 0x6666666666666665, x4, 64, x5)

inst_286:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382665, 0x3333333333333333, 0xb504f332, x4, 72, x5)

inst_287:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x8888888888888889, 0x3333333333333333, 0x5555555555555556, x4, 80, x5)

inst_288:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xddddddddddddddde, 0x3333333333333333, -0x5555555555555555, x4, 88, x5)

inst_289:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x3333333333333339, 0x3333333333333333, 0x6, x4, 96, x5)

inst_290:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x6666666666666667, 0x3333333333333333, 0x3333333333333334, x4, 104, x5)

inst_291:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x999999999999999a, 0x3333333333333333, 0x6666666666666667, x4, 112, x5)

inst_292:
// rs1_val==3689348814741910323 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4001, 0x3333333333333333, -0xb504f332, x4, 120, x5)

inst_293:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382667, 0x3333333333333333, 0xb504f334, x4, 128, x5)

inst_294:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x6666666666666669, 0x6666666666666666, 0x3, x4, 136, x5)

inst_295:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x6666666666666666, 0x5555555555555555, x4, 144, x5)

inst_296:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x1111111111111110, 0x6666666666666666, -0x5555555555555556, x4, 152, x5)

inst_297:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x666666666666666b, 0x6666666666666666, 0x5, x4, 160, x5)

inst_298:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x9999999999999999, 0x6666666666666666, 0x3333333333333333, x4, 168, x5)

inst_299:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0xcccccccccccccccc, 0x6666666666666666, 0x6666666666666666, x4, 176, x5)

inst_300:
// rs1_val==7378697629483820646 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617333, 0x6666666666666666, -0xb504f333, x4, 184, x5)

inst_301:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5999, 0x6666666666666666, 0xb504f333, x4, 192, x5)

inst_302:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x6666666666666668, 0x6666666666666666, 0x2, x4, 200, x5)

inst_303:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbba, 0x6666666666666666, 0x5555555555555554, x4, 208, x5)

inst_304:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x6666666666666666, 0x6666666666666666, 0x0, x4, 216, x5)

inst_305:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x666666666666666a, 0x6666666666666666, 0x4, x4, 224, x5)

inst_306:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x9999999999999998, 0x6666666666666666, 0x3333333333333332, x4, 232, x5)

inst_307:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0xcccccccccccccccb, 0x6666666666666666, 0x6666666666666665, x4, 240, x5)

inst_308:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5998, 0x6666666666666666, 0xb504f332, x4, 248, x5)

inst_309:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbc, 0x6666666666666666, 0x5555555555555556, x4, 256, x5)

inst_310:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x1111111111111111, 0x6666666666666666, -0x5555555555555555, x4, 264, x5)

inst_311:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x666666666666666c, 0x6666666666666666, 0x6, x4, 272, x5)

inst_312:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x999999999999999a, 0x6666666666666666, 0x3333333333333334, x4, 280, x5)

inst_313:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0xcccccccccccccccd, 0x6666666666666666, 0x6666666666666667, x4, 288, x5)

inst_314:
// rs1_val==7378697629483820646 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617334, 0x6666666666666666, -0xb504f332, x4, 296, x5)

inst_315:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b599a, 0x6666666666666666, 0xb504f334, x4, 304, x5)

inst_316:
// rs1_val==-3037000499 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd0, -0xb504f333, 0x3, x4, 312, x5)

inst_317:
// rs1_val==-3037000499 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506222, -0xb504f333, 0x5555555555555555, x4, 320, x5)

inst_318:
// rs1_val==-3037000499 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaa9f5a5b777, -0xb504f333, -0x5555555555555556, x4, 328, x5)

inst_319:
// rs1_val==-3037000499 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd2, -0xb504f333, 0x5, x4, 336, x5)

inst_320:
// rs1_val==-3037000499 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4000, -0xb504f333, 0x3333333333333333, x4, 344, x5)

inst_321:
// rs1_val==-3037000499 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617333, -0xb504f333, 0x6666666666666666, x4, 352, x5)

inst_322:
// rs1_val==-3037000499 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xfffffffe95f6199a, -0xb504f333, -0xb504f333, x4, 360, x5)

inst_323:
// rs1_val==-3037000499 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x0, -0xb504f333, 0xb504f333, x4, 368, x5)

inst_324:
// rs1_val==-3037000499 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0ccf, -0xb504f333, 0x2, x4, 376, x5)

inst_325:
// rs1_val==-3037000499 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506221, -0xb504f333, 0x5555555555555554, x4, 384, x5)

inst_326:
// rs1_val==-3037000499 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0ccd, -0xb504f333, 0x0, x4, 392, x5)

inst_327:
// rs1_val==-3037000499 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd1, -0xb504f333, 0x4, x4, 400, x5)

inst_328:
// rs1_val==-3037000499 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e3fff, -0xb504f333, 0x3333333333333332, x4, 408, x5)

inst_329:
// rs1_val==-3037000499 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617332, -0xb504f333, 0x6666666666666665, x4, 416, x5)

inst_330:
// rs1_val==-3037000499 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffff, -0xb504f333, 0xb504f332, x4, 424, x5)

inst_331:
// rs1_val==-3037000499 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506223, -0xb504f333, 0x5555555555555556, x4, 432, x5)

inst_332:
// rs1_val==-3037000499 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaa9f5a5b778, -0xb504f333, -0x5555555555555555, x4, 440, x5)

inst_333:
// rs1_val==-3037000499 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd3, -0xb504f333, 0x6, x4, 448, x5)

inst_334:
// rs1_val==-3037000499 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4001, -0xb504f333, 0x3333333333333334, x4, 456, x5)

inst_335:
// rs1_val==-3037000499 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617334, -0xb504f333, 0x6666666666666667, x4, 464, x5)

inst_336:
// rs1_val==-3037000499 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xfffffffe95f6199b, -0xb504f333, -0xb504f332, x4, 472, x5)

inst_337:
// rs1_val==-3037000499 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f333; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x1, -0xb504f333, 0xb504f334, x4, 480, x5)

inst_338:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0xb504f336, 0xb504f333, 0x3, x4, 488, x5)

inst_339:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4888, 0xb504f333, 0x5555555555555555, x4, 496, x5)

inst_340:
// rs1_val==3037000499 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9ddd, 0xb504f333, -0x5555555555555556, x4, 504, x5)

inst_341:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xb504f338, 0xb504f333, 0x5, x4, 512, x5)

inst_342:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382666, 0xb504f333, 0x3333333333333333, x4, 520, x5)

inst_343:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5999, 0xb504f333, 0x6666666666666666, x4, 528, x5)

inst_344:
// rs1_val==3037000499 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x0, 0xb504f333, -0xb504f333, x4, 536, x5)

inst_345:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x16a09e666, 0xb504f333, 0xb504f333, x4, 544, x5)

inst_346:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0xb504f335, 0xb504f333, 0x2, x4, 552, x5)

inst_347:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4887, 0xb504f333, 0x5555555555555554, x4, 560, x5)

inst_348:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xb504f333, 0xb504f333, 0x0, x4, 568, x5)

inst_349:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0xb504f337, 0xb504f333, 0x4, x4, 576, x5)

inst_350:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382665, 0xb504f333, 0x3333333333333332, x4, 584, x5)

inst_351:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5998, 0xb504f333, 0x6666666666666665, x4, 592, x5)

inst_352:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x16a09e665, 0xb504f333, 0xb504f332, x4, 600, x5)

inst_353:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4889, 0xb504f333, 0x5555555555555556, x4, 608, x5)

inst_354:
// rs1_val==3037000499 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9dde, 0xb504f333, -0x5555555555555555, x4, 616, x5)

inst_355:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xb504f339, 0xb504f333, 0x6, x4, 624, x5)

inst_356:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382667, 0xb504f333, 0x3333333333333334, x4, 632, x5)

inst_357:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b599a, 0xb504f333, 0x6666666666666667, x4, 640, x5)

inst_358:
// rs1_val==3037000499 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x1, 0xb504f333, -0xb504f332, x4, 648, x5)

inst_359:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f333; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x16a09e667, 0xb504f333, 0xb504f334, x4, 656, x5)

inst_360:
// rs1_val==2 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x5, 0x2, 0x3, x4, 664, x5)

inst_361:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x5555555555555557, 0x2, 0x5555555555555555, x4, 672, x5)

inst_362:
// rs1_val==2 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaac, 0x2, -0x5555555555555556, x4, 680, x5)

inst_363:
// rs1_val==2 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x7, 0x2, 0x5, x4, 688, x5)

inst_364:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x3333333333333335, 0x2, 0x3333333333333333, x4, 696, x5)

inst_365:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x6666666666666668, 0x2, 0x6666666666666666, x4, 704, x5)

inst_366:
// rs1_val==2 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0ccf, 0x2, -0xb504f333, x4, 712, x5)

inst_367:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xb504f335, 0x2, 0xb504f333, x4, 720, x5)

inst_368:
// rs1_val==2 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x4, 0x2, 0x2, x4, 728, x5)

inst_369:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x5555555555555556, 0x2, 0x5555555555555554, x4, 736, x5)

inst_370:
// rs1_val==2 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x2, 0x2, 0x0, x4, 744, x5)

inst_371:
// rs1_val==2 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x6, 0x2, 0x4, x4, 752, x5)

inst_372:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x3333333333333334, 0x2, 0x3333333333333332, x4, 760, x5)

inst_373:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x6666666666666667, 0x2, 0x6666666666666665, x4, 768, x5)

inst_374:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xb504f334, 0x2, 0xb504f332, x4, 776, x5)

inst_375:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x5555555555555558, 0x2, 0x5555555555555556, x4, 784, x5)

inst_376:
// rs1_val==2 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaad, 0x2, -0x5555555555555555, x4, 792, x5)

inst_377:
// rs1_val==2 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x8, 0x2, 0x6, x4, 800, x5)

inst_378:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x3333333333333336, 0x2, 0x3333333333333334, x4, 808, x5)

inst_379:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x6666666666666669, 0x2, 0x6666666666666667, x4, 816, x5)

inst_380:
// rs1_val==2 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd0, 0x2, -0xb504f332, x4, 824, x5)

inst_381:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x2; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xb504f336, 0x2, 0xb504f334, x4, 832, x5)

inst_382:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x5555555555555557, 0x5555555555555554, 0x3, x4, 840, x5)

inst_383:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x5555555555555554, 0x5555555555555555, x4, 848, x5)

inst_384:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xfffffffffffffffe, 0x5555555555555554, -0x5555555555555556, x4, 856, x5)

inst_385:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x5555555555555559, 0x5555555555555554, 0x5, x4, 864, x5)

inst_386:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x8888888888888887, 0x5555555555555554, 0x3333333333333333, x4, 872, x5)

inst_387:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbba, 0x5555555555555554, 0x6666666666666666, x4, 880, x5)

inst_388:
// rs1_val==6148914691236517204 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506221, 0x5555555555555554, -0xb504f333, x4, 888, x5)

inst_389:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4887, 0x5555555555555554, 0xb504f333, x4, 896, x5)

inst_390:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x5555555555555556, 0x5555555555555554, 0x2, x4, 904, x5)

inst_391:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaa8, 0x5555555555555554, 0x5555555555555554, x4, 912, x5)

inst_392:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x0, x4, 920, x5)

inst_393:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x5555555555555558, 0x5555555555555554, 0x4, x4, 928, x5)

inst_394:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x8888888888888886, 0x5555555555555554, 0x3333333333333332, x4, 936, x5)

inst_395:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbb9, 0x5555555555555554, 0x6666666666666665, x4, 944, x5)

inst_396:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4886, 0x5555555555555554, 0xb504f332, x4, 952, x5)

inst_397:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555554, 0x5555555555555556, x4, 960, x5)

inst_398:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffff, 0x5555555555555554, -0x5555555555555555, x4, 968, x5)

inst_399:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x555555555555555a, 0x5555555555555554, 0x6, x4, 976, x5)

inst_400:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x8888888888888888, 0x5555555555555554, 0x3333333333333334, x4, 984, x5)

inst_401:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x5555555555555554, 0x6666666666666667, x4, 992, x5)

inst_402:
// rs1_val==6148914691236517204 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506222, 0x5555555555555554, -0xb504f332, x4, 1000, x5)

inst_403:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4888, 0x5555555555555554, 0xb504f334, x4, 1008, x5)

inst_404:
// rs1_val==0 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x3, 0x0, 0x3, x4, 1016, x5)

inst_405:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x5555555555555555, 0x0, 0x5555555555555555, x4, 1024, x5)

inst_406:
// rs1_val==0 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x0, -0x5555555555555556, x4, 1032, x5)

inst_407:
// rs1_val==0 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x5, 0x0, 0x5, x4, 1040, x5)

inst_408:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x3333333333333333, 0x0, 0x3333333333333333, x4, 1048, x5)

inst_409:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x6666666666666666, 0x0, 0x6666666666666666, x4, 1056, x5)

inst_410:
// rs1_val==0 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0ccd, 0x0, -0xb504f333, x4, 1064, x5)

inst_411:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xb504f333, 0x0, 0xb504f333, x4, 1072, x5)

inst_412:
// rs1_val==4 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaae, 0x4, -0x5555555555555556, x4, 1080, x5)

inst_413:
// rs1_val==4 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x9, 0x4, 0x5, x4, 1088, x5)

inst_414:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x3333333333333337, 0x4, 0x3333333333333333, x4, 1096, x5)

inst_415:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x666666666666666a, 0x4, 0x6666666666666666, x4, 1104, x5)

inst_416:
// rs1_val==4 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd1, 0x4, -0xb504f333, x4, 1112, x5)

inst_417:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xb504f337, 0x4, 0xb504f333, x4, 1120, x5)

inst_418:
// rs1_val==4 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x6, 0x4, 0x2, x4, 1128, x5)

inst_419:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x5555555555555558, 0x4, 0x5555555555555554, x4, 1136, x5)

inst_420:
// rs1_val==4 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x4, 0x4, 0x0, x4, 1144, x5)

inst_421:
// rs1_val==4 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x8, 0x4, 0x4, x4, 1152, x5)

inst_422:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x3333333333333336, 0x4, 0x3333333333333332, x4, 1160, x5)

inst_423:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x6666666666666669, 0x4, 0x6666666666666665, x4, 1168, x5)

inst_424:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xb504f336, 0x4, 0xb504f332, x4, 1176, x5)

inst_425:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x555555555555555a, 0x4, 0x5555555555555556, x4, 1184, x5)

inst_426:
// rs1_val==4 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaf, 0x4, -0x5555555555555555, x4, 1192, x5)

inst_427:
// rs1_val==4 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xa, 0x4, 0x6, x4, 1200, x5)

inst_428:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x3333333333333338, 0x4, 0x3333333333333334, x4, 1208, x5)

inst_429:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x666666666666666b, 0x4, 0x6666666666666667, x4, 1216, x5)

inst_430:
// rs1_val==4 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd2, 0x4, -0xb504f332, x4, 1224, x5)

inst_431:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xb504f338, 0x4, 0xb504f334, x4, 1232, x5)

inst_432:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x3333333333333335, 0x3333333333333332, 0x3, x4, 1240, x5)

inst_433:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x8888888888888887, 0x3333333333333332, 0x5555555555555555, x4, 1248, x5)

inst_434:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xdddddddddddddddc, 0x3333333333333332, -0x5555555555555556, x4, 1256, x5)

inst_435:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x3333333333333337, 0x3333333333333332, 0x5, x4, 1264, x5)

inst_436:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x6666666666666665, 0x3333333333333332, 0x3333333333333333, x4, 1272, x5)

inst_437:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x9999999999999998, 0x3333333333333332, 0x6666666666666666, x4, 1280, x5)

inst_438:
// rs1_val==3689348814741910322 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e3fff, 0x3333333333333332, -0xb504f333, x4, 1288, x5)

inst_439:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382665, 0x3333333333333332, 0xb504f333, x4, 1296, x5)

inst_440:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x3333333333333334, 0x3333333333333332, 0x2, x4, 1304, x5)

inst_441:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x8888888888888886, 0x3333333333333332, 0x5555555555555554, x4, 1312, x5)

inst_442:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x0, x4, 1320, x5)

inst_443:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x3333333333333336, 0x3333333333333332, 0x4, x4, 1328, x5)

inst_444:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x6666666666666664, 0x3333333333333332, 0x3333333333333332, x4, 1336, x5)

inst_445:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x9999999999999997, 0x3333333333333332, 0x6666666666666665, x4, 1344, x5)

inst_446:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382664, 0x3333333333333332, 0xb504f332, x4, 1352, x5)

inst_447:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x8888888888888888, 0x3333333333333332, 0x5555555555555556, x4, 1360, x5)

inst_448:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xdddddddddddddddd, 0x3333333333333332, -0x5555555555555555, x4, 1368, x5)

inst_449:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x3333333333333338, 0x3333333333333332, 0x6, x4, 1376, x5)

inst_450:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x6666666666666666, 0x3333333333333332, 0x3333333333333334, x4, 1384, x5)

inst_451:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x9999999999999999, 0x3333333333333332, 0x6666666666666667, x4, 1392, x5)

inst_452:
// rs1_val==3689348814741910322 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4000, 0x3333333333333332, -0xb504f332, x4, 1400, x5)

inst_453:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382666, 0x3333333333333332, 0xb504f334, x4, 1408, x5)

inst_454:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x6666666666666668, 0x6666666666666665, 0x3, x4, 1416, x5)

inst_455:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbba, 0x6666666666666665, 0x5555555555555555, x4, 1424, x5)

inst_456:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x111111111111110f, 0x6666666666666665, -0x5555555555555556, x4, 1432, x5)

inst_457:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x666666666666666a, 0x6666666666666665, 0x5, x4, 1440, x5)

inst_458:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x9999999999999998, 0x6666666666666665, 0x3333333333333333, x4, 1448, x5)

inst_459:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0xcccccccccccccccb, 0x6666666666666665, 0x6666666666666666, x4, 1456, x5)

inst_460:
// rs1_val==7378697629483820645 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617332, 0x6666666666666665, -0xb504f333, x4, 1464, x5)

inst_461:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5998, 0x6666666666666665, 0xb504f333, x4, 1472, x5)

inst_462:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x6666666666666667, 0x6666666666666665, 0x2, x4, 1480, x5)

inst_463:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbb9, 0x6666666666666665, 0x5555555555555554, x4, 1488, x5)

inst_464:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x6666666666666665, 0x6666666666666665, 0x0, x4, 1496, x5)

inst_465:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x6666666666666669, 0x6666666666666665, 0x4, x4, 1504, x5)

inst_466:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x9999999999999997, 0x6666666666666665, 0x3333333333333332, x4, 1512, x5)

inst_467:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0xccccccccccccccca, 0x6666666666666665, 0x6666666666666665, x4, 1520, x5)

inst_468:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5997, 0x6666666666666665, 0xb504f332, x4, 1528, x5)

inst_469:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x6666666666666665, 0x5555555555555556, x4, 1536, x5)

inst_470:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x1111111111111110, 0x6666666666666665, -0x5555555555555555, x4, 1544, x5)

inst_471:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x666666666666666b, 0x6666666666666665, 0x6, x4, 1552, x5)

inst_472:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x9999999999999999, 0x6666666666666665, 0x3333333333333334, x4, 1560, x5)

inst_473:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0xcccccccccccccccc, 0x6666666666666665, 0x6666666666666667, x4, 1568, x5)

inst_474:
// rs1_val==7378697629483820645 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617333, 0x6666666666666665, -0xb504f332, x4, 1576, x5)

inst_475:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5999, 0x6666666666666665, 0xb504f334, x4, 1584, x5)

inst_476:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0xb504f335, 0xb504f332, 0x3, x4, 1592, x5)

inst_477:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4887, 0xb504f332, 0x5555555555555555, x4, 1600, x5)

inst_478:
// rs1_val==3037000498 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9ddc, 0xb504f332, -0x5555555555555556, x4, 1608, x5)

inst_479:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xb504f337, 0xb504f332, 0x5, x4, 1616, x5)

inst_480:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382665, 0xb504f332, 0x3333333333333333, x4, 1624, x5)

inst_481:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5998, 0xb504f332, 0x6666666666666666, x4, 1632, x5)

inst_482:
// rs1_val==3037000498 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffff, 0xb504f332, -0xb504f333, x4, 1640, x5)

inst_483:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x16a09e665, 0xb504f332, 0xb504f333, x4, 1648, x5)

inst_484:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0xb504f334, 0xb504f332, 0x2, x4, 1656, x5)

inst_485:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4886, 0xb504f332, 0x5555555555555554, x4, 1664, x5)

inst_486:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xb504f332, 0xb504f332, 0x0, x4, 1672, x5)

inst_487:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0xb504f336, 0xb504f332, 0x4, x4, 1680, x5)

inst_488:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382664, 0xb504f332, 0x3333333333333332, x4, 1688, x5)

inst_489:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5997, 0xb504f332, 0x6666666666666665, x4, 1696, x5)

inst_490:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x16a09e664, 0xb504f332, 0xb504f332, x4, 1704, x5)

inst_491:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4888, 0xb504f332, 0x5555555555555556, x4, 1712, x5)

inst_492:
// rs1_val==3037000498 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9ddd, 0xb504f332, -0x5555555555555555, x4, 1720, x5)

inst_493:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xb504f338, 0xb504f332, 0x6, x4, 1728, x5)

inst_494:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382666, 0xb504f332, 0x3333333333333334, x4, 1736, x5)

inst_495:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5999, 0xb504f332, 0x6666666666666667, x4, 1744, x5)

inst_496:
// rs1_val==3037000498 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x0, 0xb504f332, -0xb504f332, x4, 1752, x5)

inst_497:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f332; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x16a09e666, 0xb504f332, 0xb504f334, x4, 1760, x5)

inst_498:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x5555555555555559, 0x5555555555555556, 0x3, x4, 1768, x5)

inst_499:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaab, 0x5555555555555556, 0x5555555555555555, x4, 1776, x5)

inst_500:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x0, 0x5555555555555556, -0x5555555555555556, x4, 1784, x5)

inst_501:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x555555555555555b, 0x5555555555555556, 0x5, x4, 1792, x5)

inst_502:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x8888888888888889, 0x5555555555555556, 0x3333333333333333, x4, 1800, x5)

inst_503:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbc, 0x5555555555555556, 0x6666666666666666, x4, 1808, x5)

inst_504:
// rs1_val==6148914691236517206 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506223, 0x5555555555555556, -0xb504f333, x4, 1816, x5)

inst_505:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4889, 0x5555555555555556, 0xb504f333, x4, 1824, x5)

inst_506:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x5555555555555558, 0x5555555555555556, 0x2, x4, 1832, x5)

inst_507:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555556, 0x5555555555555554, x4, 1840, x5)

inst_508:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x5555555555555556, 0x5555555555555556, 0x0, x4, 1848, x5)

inst_509:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x555555555555555a, 0x5555555555555556, 0x4, x4, 1856, x5)

inst_510:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x8888888888888888, 0x5555555555555556, 0x3333333333333332, x4, 1864, x5)

inst_511:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x5555555555555556, 0x6666666666666665, x4, 1872, x5)

inst_512:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4888, 0x5555555555555556, 0xb504f332, x4, 1880, x5)

inst_513:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaac, 0x5555555555555556, 0x5555555555555556, x4, 1888, x5)

inst_514:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x1, 0x5555555555555556, -0x5555555555555555, x4, 1896, x5)

inst_515:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x555555555555555c, 0x5555555555555556, 0x6, x4, 1904, x5)

inst_516:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x888888888888888a, 0x5555555555555556, 0x3333333333333334, x4, 1912, x5)

inst_517:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbd, 0x5555555555555556, 0x6666666666666667, x4, 1920, x5)

inst_518:
// rs1_val==6148914691236517206 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506224, 0x5555555555555556, -0xb504f332, x4, 1928, x5)

inst_519:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a488a, 0x5555555555555556, 0xb504f334, x4, 1936, x5)

inst_520:
// rs1_val==-6148914691236517205 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaae, -0x5555555555555555, 0x3, x4, 1944, x5)

inst_521:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x0, -0x5555555555555555, 0x5555555555555555, x4, 1952, x5)

inst_522:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x5555555555555555, -0x5555555555555555, -0x5555555555555556, x4, 1960, x5)

inst_523:
// rs1_val==-6148914691236517205 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaab0, -0x5555555555555555, 0x5, x4, 1968, x5)

inst_524:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0xddddddddddddddde, -0x5555555555555555, 0x3333333333333333, x4, 1976, x5)

inst_525:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x1111111111111111, -0x5555555555555555, 0x6666666666666666, x4, 1984, x5)

inst_526:
// rs1_val==-6148914691236517205 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaa9f5a5b778, -0x5555555555555555, -0xb504f333, x4, 1992, x5)

inst_527:
// rs1_val==-6148914691236517205 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9dde, -0x5555555555555555, 0xb504f333, x4, 2000, x5)

inst_528:
// rs1_val==-6148914691236517205 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaad, -0x5555555555555555, 0x2, x4, 2008, x5)

inst_529:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0xffffffffffffffff, -0x5555555555555555, 0x5555555555555554, x4, 2016, x5)

inst_530:
// rs1_val==-6148914691236517205 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, 0x0, x4, 2024, x5)

inst_531:
// rs1_val==-6148914691236517205 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x4, x4, 2032, x5)

inst_532:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0xdddddddddddddddd, -0x5555555555555555, 0x3333333333333332, x4, 2040, x5)
RVTEST_SIGBASE( x4,signature_x4_2)

inst_533:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x1111111111111110, -0x5555555555555555, 0x6666666666666665, x4, 0, x5)

inst_534:
// rs1_val==-6148914691236517205 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9ddd, -0x5555555555555555, 0xb504f332, x4, 8, x5)

inst_535:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x1, -0x5555555555555555, 0x5555555555555556, x4, 16, x5)

inst_536:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x5555555555555556, -0x5555555555555555, -0x5555555555555555, x4, 24, x5)

inst_537:
// rs1_val==-6148914691236517205 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaab1, -0x5555555555555555, 0x6, x4, 32, x5)

inst_538:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0xdddddddddddddddf, -0x5555555555555555, 0x3333333333333334, x4, 40, x5)

inst_539:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x1111111111111112, -0x5555555555555555, 0x6666666666666667, x4, 48, x5)

inst_540:
// rs1_val==-6148914691236517205 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaa9f5a5b779, -0x5555555555555555, -0xb504f332, x4, 56, x5)

inst_541:
// rs1_val==-6148914691236517205 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0x5555555555555555; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9ddf, -0x5555555555555555, 0xb504f334, x4, 64, x5)

inst_542:
// rs1_val==6 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x9, 0x6, 0x3, x4, 72, x5)

inst_543:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x555555555555555b, 0x6, 0x5555555555555555, x4, 80, x5)

inst_544:
// rs1_val==6 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaab0, 0x6, -0x5555555555555556, x4, 88, x5)

inst_545:
// rs1_val==6 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xb, 0x6, 0x5, x4, 96, x5)

inst_546:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x3333333333333339, 0x6, 0x3333333333333333, x4, 104, x5)

inst_547:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x666666666666666c, 0x6, 0x6666666666666666, x4, 112, x5)

inst_548:
// rs1_val==6 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd3, 0x6, -0xb504f333, x4, 120, x5)

inst_549:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xb504f339, 0x6, 0xb504f333, x4, 128, x5)

inst_550:
// rs1_val==6 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x8, 0x6, 0x2, x4, 136, x5)

inst_551:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x555555555555555a, 0x6, 0x5555555555555554, x4, 144, x5)

inst_552:
// rs1_val==6 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x6, 0x6, 0x0, x4, 152, x5)

inst_553:
// rs1_val==6 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0xa, 0x6, 0x4, x4, 160, x5)

inst_554:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x3333333333333338, 0x6, 0x3333333333333332, x4, 168, x5)

inst_555:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x666666666666666b, 0x6, 0x6666666666666665, x4, 176, x5)

inst_556:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xb504f338, 0x6, 0xb504f332, x4, 184, x5)

inst_557:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x555555555555555c, 0x6, 0x5555555555555556, x4, 192, x5)

inst_558:
// rs1_val==6 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaab1, 0x6, -0x5555555555555555, x4, 200, x5)

inst_559:
// rs1_val==6 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xc, 0x6, 0x6, x4, 208, x5)

inst_560:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x333333333333333a, 0x6, 0x3333333333333334, x4, 216, x5)

inst_561:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x666666666666666d, 0x6, 0x6666666666666667, x4, 224, x5)

inst_562:
// rs1_val==6 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd4, 0x6, -0xb504f332, x4, 232, x5)

inst_563:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xb504f33a, 0x6, 0xb504f334, x4, 240, x5)

inst_564:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x3333333333333337, 0x3333333333333334, 0x3, x4, 248, x5)

inst_565:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x8888888888888889, 0x3333333333333334, 0x5555555555555555, x4, 256, x5)

inst_566:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xddddddddddddddde, 0x3333333333333334, -0x5555555555555556, x4, 264, x5)

inst_567:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x3333333333333339, 0x3333333333333334, 0x5, x4, 272, x5)

inst_568:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x6666666666666667, 0x3333333333333334, 0x3333333333333333, x4, 280, x5)

inst_569:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x999999999999999a, 0x3333333333333334, 0x6666666666666666, x4, 288, x5)

inst_570:
// rs1_val==3689348814741910324 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4001, 0x3333333333333334, -0xb504f333, x4, 296, x5)

inst_571:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382667, 0x3333333333333334, 0xb504f333, x4, 304, x5)

inst_572:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x3333333333333336, 0x3333333333333334, 0x2, x4, 312, x5)

inst_573:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x8888888888888888, 0x3333333333333334, 0x5555555555555554, x4, 320, x5)

inst_574:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x0, x4, 328, x5)

inst_575:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x3333333333333338, 0x3333333333333334, 0x4, x4, 336, x5)

inst_576:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x6666666666666666, 0x3333333333333334, 0x3333333333333332, x4, 344, x5)

inst_577:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x9999999999999999, 0x3333333333333334, 0x6666666666666665, x4, 352, x5)

inst_578:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382666, 0x3333333333333334, 0xb504f332, x4, 360, x5)

inst_579:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x888888888888888a, 0x3333333333333334, 0x5555555555555556, x4, 368, x5)

inst_580:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xdddddddddddddddf, 0x3333333333333334, -0x5555555555555555, x4, 376, x5)

inst_581:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x333333333333333a, 0x3333333333333334, 0x6, x4, 384, x5)

inst_582:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x6666666666666668, 0x3333333333333334, 0x3333333333333334, x4, 392, x5)

inst_583:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x999999999999999b, 0x3333333333333334, 0x6666666666666667, x4, 400, x5)

inst_584:
// rs1_val==3689348814741910324 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4002, 0x3333333333333334, -0xb504f332, x4, 408, x5)

inst_585:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382668, 0x3333333333333334, 0xb504f334, x4, 416, x5)

inst_586:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x666666666666666a, 0x6666666666666667, 0x3, x4, 424, x5)

inst_587:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbc, 0x6666666666666667, 0x5555555555555555, x4, 432, x5)

inst_588:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x1111111111111111, 0x6666666666666667, -0x5555555555555556, x4, 440, x5)

inst_589:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0x666666666666666c, 0x6666666666666667, 0x5, x4, 448, x5)

inst_590:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x999999999999999a, 0x6666666666666667, 0x3333333333333333, x4, 456, x5)

inst_591:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0xcccccccccccccccd, 0x6666666666666667, 0x6666666666666666, x4, 464, x5)

inst_592:
// rs1_val==7378697629483820647 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617334, 0x6666666666666667, -0xb504f333, x4, 472, x5)

inst_593:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b599a, 0x6666666666666667, 0xb504f333, x4, 480, x5)

inst_594:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x6666666666666669, 0x6666666666666667, 0x2, x4, 488, x5)

inst_595:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x6666666666666667, 0x5555555555555554, x4, 496, x5)

inst_596:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x6666666666666667, 0x6666666666666667, 0x0, x4, 504, x5)

inst_597:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x666666666666666b, 0x6666666666666667, 0x4, x4, 512, x5)

inst_598:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x9999999999999999, 0x6666666666666667, 0x3333333333333332, x4, 520, x5)

inst_599:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0xcccccccccccccccc, 0x6666666666666667, 0x6666666666666665, x4, 528, x5)

inst_600:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5999, 0x6666666666666667, 0xb504f332, x4, 536, x5)

inst_601:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xbbbbbbbbbbbbbbbd, 0x6666666666666667, 0x5555555555555556, x4, 544, x5)

inst_602:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x1111111111111112, 0x6666666666666667, -0x5555555555555555, x4, 552, x5)

inst_603:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x666666666666666d, 0x6666666666666667, 0x6, x4, 560, x5)

inst_604:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x999999999999999b, 0x6666666666666667, 0x3333333333333334, x4, 568, x5)

inst_605:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0xccccccccccccccce, 0x6666666666666667, 0x6666666666666667, x4, 576, x5)

inst_606:
// rs1_val==7378697629483820647 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617335, 0x6666666666666667, -0xb504f332, x4, 584, x5)

inst_607:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b599b, 0x6666666666666667, 0xb504f334, x4, 592, x5)

inst_608:
// rs1_val==-3037000498 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd1, -0xb504f332, 0x3, x4, 600, x5)

inst_609:
// rs1_val==-3037000498 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506223, -0xb504f332, 0x5555555555555555, x4, 608, x5)

inst_610:
// rs1_val==-3037000498 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd3, -0xb504f332, 0x5, x4, 616, x5)

inst_611:
// rs1_val==-3037000498 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4001, -0xb504f332, 0x3333333333333333, x4, 624, x5)

inst_612:
// rs1_val==-3037000498 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617334, -0xb504f332, 0x6666666666666666, x4, 632, x5)

inst_613:
// rs1_val==-3037000498 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0xfffffffe95f6199b, -0xb504f332, -0xb504f333, x4, 640, x5)

inst_614:
// rs1_val==-3037000498 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x1, -0xb504f332, 0xb504f333, x4, 648, x5)

inst_615:
// rs1_val==-3037000498 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd0, -0xb504f332, 0x2, x4, 656, x5)

inst_616:
// rs1_val==-3037000498 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506222, -0xb504f332, 0x5555555555555554, x4, 664, x5)

inst_617:
// rs1_val==-3037000498 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cce, -0xb504f332, 0x0, x4, 672, x5)

inst_618:
// rs1_val==-3037000498 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd2, -0xb504f332, 0x4, x4, 680, x5)

inst_619:
// rs1_val==-3037000498 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4000, -0xb504f332, 0x3333333333333332, x4, 688, x5)

inst_620:
// rs1_val==-3037000498 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617333, -0xb504f332, 0x6666666666666665, x4, 696, x5)

inst_621:
// rs1_val==-3037000498 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x0, -0xb504f332, 0xb504f332, x4, 704, x5)

inst_622:
// rs1_val==-3037000498 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x55555554a0506224, -0xb504f332, 0x5555555555555556, x4, 712, x5)

inst_623:
// rs1_val==-3037000498 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaa9f5a5b779, -0xb504f332, -0x5555555555555555, x4, 720, x5)

inst_624:
// rs1_val==-3037000498 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cd4, -0xb504f332, 0x6, x4, 728, x5)

inst_625:
// rs1_val==-3037000498 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x333333327e2e4002, -0xb504f332, 0x3333333333333334, x4, 736, x5)

inst_626:
// rs1_val==-3037000498 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x66666665b1617335, -0xb504f332, 0x6666666666666667, x4, 744, x5)

inst_627:
// rs1_val==-3037000498 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xfffffffe95f6199c, -0xb504f332, -0xb504f332, x4, 752, x5)

inst_628:
// rs1_val==-3037000498 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:-0xb504f332; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x2, -0xb504f332, 0xb504f334, x4, 760, x5)

inst_629:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0xb504f337, 0xb504f334, 0x3, x4, 768, x5)

inst_630:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4889, 0xb504f334, 0x5555555555555555, x4, 776, x5)

inst_631:
// rs1_val==3037000500 and rs2_val==-6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:-0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9dde, 0xb504f334, -0x5555555555555556, x4, 784, x5)

inst_632:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x5
TEST_CR_OP( c.add, x10, x11, 0xb504f339, 0xb504f334, 0x5, x4, 792, x5)

inst_633:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x3333333333333333
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382667, 0xb504f334, 0x3333333333333333, x4, 800, x5)

inst_634:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x6666666666666666
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b599a, 0xb504f334, 0x6666666666666666, x4, 808, x5)

inst_635:
// rs1_val==3037000500 and rs2_val==-3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:-0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x1, 0xb504f334, -0xb504f333, x4, 816, x5)

inst_636:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0xb504f333
TEST_CR_OP( c.add, x10, x11, 0x16a09e667, 0xb504f334, 0xb504f333, x4, 824, x5)

inst_637:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0xb504f336, 0xb504f334, 0x2, x4, 832, x5)

inst_638:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a4888, 0xb504f334, 0x5555555555555554, x4, 840, x5)

inst_639:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xb504f334, 0xb504f334, 0x0, x4, 848, x5)

inst_640:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0xb504f338, 0xb504f334, 0x4, x4, 856, x5)

inst_641:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382666, 0xb504f334, 0x3333333333333332, x4, 864, x5)

inst_642:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b5999, 0xb504f334, 0x6666666666666665, x4, 872, x5)

inst_643:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x16a09e666, 0xb504f334, 0xb504f332, x4, 880, x5)

inst_644:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x555555560a5a488a, 0xb504f334, 0x5555555555555556, x4, 888, x5)

inst_645:
// rs1_val==3037000500 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaab5faf9ddf, 0xb504f334, -0x5555555555555555, x4, 896, x5)

inst_646:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0xb504f33a, 0xb504f334, 0x6, x4, 904, x5)

inst_647:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x33333333e8382668, 0xb504f334, 0x3333333333333334, x4, 912, x5)

inst_648:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x666666671b6b599b, 0xb504f334, 0x6666666666666667, x4, 920, x5)

inst_649:
// rs1_val==3037000500 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0x2, 0xb504f334, -0xb504f332, x4, 928, x5)

inst_650:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0xb504f334; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0x16a09e668, 0xb504f334, 0xb504f334, x4, 936, x5)

inst_651:
// rs1_val==0 and rs2_val==2, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x2
TEST_CR_OP( c.add, x10, x11, 0x2, 0x0, 0x2, x4, 944, x5)

inst_652:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x5555555555555554
TEST_CR_OP( c.add, x10, x11, 0x5555555555555554, 0x0, 0x5555555555555554, x4, 952, x5)

inst_653:
// rs1_val==0 and rs2_val==0, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0x0, 0x0, 0x0, x4, 960, x5)

inst_654:
// rs1_val==0 and rs2_val==4, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x4
TEST_CR_OP( c.add, x10, x11, 0x4, 0x0, 0x4, x4, 968, x5)

inst_655:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x3333333333333332
TEST_CR_OP( c.add, x10, x11, 0x3333333333333332, 0x0, 0x3333333333333332, x4, 976, x5)

inst_656:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x6666666666666665
TEST_CR_OP( c.add, x10, x11, 0x6666666666666665, 0x0, 0x6666666666666665, x4, 984, x5)

inst_657:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xb504f332, 0x0, 0xb504f332, x4, 992, x5)

inst_658:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x5555555555555556
TEST_CR_OP( c.add, x10, x11, 0x5555555555555556, 0x0, 0x5555555555555556, x4, 1000, x5)

inst_659:
// rs1_val==0 and rs2_val==-6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:-0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0xaaaaaaaaaaaaaaab, 0x0, -0x5555555555555555, x4, 1008, x5)

inst_660:
// rs1_val==0 and rs2_val==6, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x6
TEST_CR_OP( c.add, x10, x11, 0x6, 0x0, 0x6, x4, 1016, x5)

inst_661:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x3333333333333334
TEST_CR_OP( c.add, x10, x11, 0x3333333333333334, 0x0, 0x3333333333333334, x4, 1024, x5)

inst_662:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0x6666666666666667
TEST_CR_OP( c.add, x10, x11, 0x6666666666666667, 0x0, 0x6666666666666667, x4, 1032, x5)

inst_663:
// rs1_val==0 and rs2_val==-3037000498, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:-0xb504f332
TEST_CR_OP( c.add, x10, x11, 0xffffffff4afb0cce, 0x0, -0xb504f332, x4, 1040, x5)

inst_664:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x0; op2val:0xb504f334
TEST_CR_OP( c.add, x10, x11, 0xb504f334, 0x0, 0xb504f334, x4, 1048, x5)

inst_665:
// rs1_val==4 and rs2_val==3, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x3
TEST_CR_OP( c.add, x10, x11, 0x7, 0x4, 0x3, x4, 1056, x5)

inst_666:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: c.add; op1:x10; op2:x11; op1val:0x4; op2val:0x5555555555555555
TEST_CR_OP( c.add, x10, x11, 0x5555555555555559, 0x4, 0x5555555555555555, x4, 1064, x5)

inst_667:
// rs2_val == 0, rs1_val == -1073741825
// opcode: c.add; op1:x10; op2:x11; op1val:-0x40000001; op2val:0x0
TEST_CR_OP( c.add, x10, x11, 0xffffffffbfffffff, -0x40000001, 0x0, x4, 1072, x5)

inst_668:
// rs1_val == 1, rs2_val == 68719476736
// opcode: c.add; op1:x10; op2:x11; op1val:0x1; op2val:0x1000000000
TEST_CR_OP( c.add, x10, x11, 0x1000000001, 0x1, 0x1000000000, x4, 1080, x5)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x6_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x6_1:
    .fill 21*(XLEN/32),4,0xdeadbeef


signature_x4_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_2:
    .fill 136*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
