
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 04:49:48 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64ic.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the c.addi16sp instruction of the RISC-V C extension for the caddi16sp covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IC")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*C.*);def TEST_CASE_1=True;",caddi16sp)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rd==x2, rs1_val == imm_val, imm_val == 256, rs1_val > 0 and imm_val > 0, rs1_val == 256
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x100; immval:0x100
TEST_CI_OP( c.addi16sp, x2, 0x200, 0x100, 0x100, x1, 0, x3)

inst_1:
// rs1_val != imm_val, rs1_val == 2097152, rs1_val > 0 and imm_val < 0, imm_val == -144
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x200000; immval:-0x90
TEST_CI_OP( c.addi16sp, x2, 0x1fff70, 0x200000, -0x90, x1, 8, x3)

inst_2:
// rs1_val < 0 and imm_val > 0, rs1_val == -274877906945
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x4000000001; immval:0x90
TEST_CI_OP( c.addi16sp, x2, 0xffffffc00000008f, -0x4000000001, 0x90, x1, 16, x3)

inst_3:
// rs1_val < 0 and imm_val < 0, imm_val == -512, rs1_val == -2
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x2; immval:-0x200
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffffdfe, -0x2, -0x200, x1, 24, x3)

inst_4:
// rs1_val == (-2**(xlen-1)), rs1_val == -9223372036854775808, imm_val == 16
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x8000000000000000; immval:0x10
TEST_CI_OP( c.addi16sp, x2, 0x8000000000000010, -0x8000000000000000, 0x10, x1, 32, x3)

inst_5:
// rs1_val == 0, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x0; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0x30, 0x0, 0x30, x1, 40, x3)

inst_6:
// rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x7fffffffffffffff; immval:0x90
TEST_CI_OP( c.addi16sp, x2, 0x800000000000008f, 0x7fffffffffffffff, 0x90, x1, 48, x3)

inst_7:
// rs1_val == 1, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x1; immval:0xf0
TEST_CI_OP( c.addi16sp, x2, 0xf1, 0x1, 0xf0, x1, 56, x3)

inst_8:
// imm_val == 496, rs1_val == -65537
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x10001; immval:0x1f0
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffff01ef, -0x10001, 0x1f0, x1, 64, x3)

inst_9:
// rs1_val == 2, imm_val == 336
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x2; immval:0x150
TEST_CI_OP( c.addi16sp, x2, 0x152, 0x2, 0x150, x1, 72, x3)

inst_10:
// rs1_val == 4, imm_val == -48
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x4; immval:-0x30
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffffffd4, 0x4, -0x30, x1, 80, x3)

inst_11:
// rs1_val == 8, imm_val == 128
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x8; immval:0x80
TEST_CI_OP( c.addi16sp, x2, 0x88, 0x8, 0x80, x1, 88, x3)

inst_12:
// rs1_val == 16, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x10; immval:0x150
TEST_CI_OP( c.addi16sp, x2, 0x160, 0x10, 0x150, x1, 96, x3)

inst_13:
// rs1_val == 32, imm_val == -80
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x20; immval:-0x50
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffffffd0, 0x20, -0x50, x1, 104, x3)

inst_14:
// rs1_val == 64, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x40; immval:0x1f0
TEST_CI_OP( c.addi16sp, x2, 0x230, 0x40, 0x1f0, x1, 112, x3)

inst_15:
// rs1_val == 128, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x80; immval:0x1f0
TEST_CI_OP( c.addi16sp, x2, 0x270, 0x80, 0x1f0, x1, 120, x3)

inst_16:
// rs1_val == 512, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x200; immval:0x50
TEST_CI_OP( c.addi16sp, x2, 0x250, 0x200, 0x50, x1, 128, x3)

inst_17:
// rs1_val == 1024, imm_val == 64
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x400; immval:0x40
TEST_CI_OP( c.addi16sp, x2, 0x440, 0x400, 0x40, x1, 136, x3)

inst_18:
// rs1_val == 2048, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x800; immval:-0x50
TEST_CI_OP( c.addi16sp, x2, 0x7b0, 0x800, -0x50, x1, 144, x3)

inst_19:
// rs1_val == 4096, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x1000; immval:-0x50
TEST_CI_OP( c.addi16sp, x2, 0xfb0, 0x1000, -0x50, x1, 152, x3)

inst_20:
// rs1_val == 8192, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x2000; immval:0x80
TEST_CI_OP( c.addi16sp, x2, 0x2080, 0x2000, 0x80, x1, 160, x3)

inst_21:
// rs1_val == 16384, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x4000; immval:0xf0
TEST_CI_OP( c.addi16sp, x2, 0x40f0, 0x4000, 0xf0, x1, 168, x3)

inst_22:
// rs1_val == 32768, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x8000; immval:0x10
TEST_CI_OP( c.addi16sp, x2, 0x8010, 0x8000, 0x10, x1, 176, x3)

inst_23:
// rs1_val == 65536, imm_val == 32
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x10000; immval:0x20
TEST_CI_OP( c.addi16sp, x2, 0x10020, 0x10000, 0x20, x1, 184, x3)

inst_24:
// rs1_val == 131072, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x20000; immval:0x100
TEST_CI_OP( c.addi16sp, x2, 0x20100, 0x20000, 0x100, x1, 192, x3)

inst_25:
// rs1_val == 262144, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x40000; immval:0x60
TEST_CI_OP( c.addi16sp, x2, 0x40060, 0x40000, 0x60, x1, 200, x3)

inst_26:
// rs1_val == 524288, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x80000; immval:0x50
TEST_CI_OP( c.addi16sp, x2, 0x80050, 0x80000, 0x50, x1, 208, x3)

inst_27:
// rs1_val == 1048576, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x100000; immval:0x40
TEST_CI_OP( c.addi16sp, x2, 0x100040, 0x100000, 0x40, x1, 216, x3)

inst_28:
// rs1_val == 4194304, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x400000; immval:0x60
TEST_CI_OP( c.addi16sp, x2, 0x400060, 0x400000, 0x60, x1, 224, x3)

inst_29:
// rs1_val == 8388608, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x800000; immval:-0x90
TEST_CI_OP( c.addi16sp, x2, 0x7fff70, 0x800000, -0x90, x1, 232, x3)

inst_30:
// rs1_val == 16777216, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x1000000; immval:-0x60
TEST_CI_OP( c.addi16sp, x2, 0xffffa0, 0x1000000, -0x60, x1, 240, x3)

inst_31:
// rs1_val == 33554432, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x2000000; immval:-0x30
TEST_CI_OP( c.addi16sp, x2, 0x1ffffd0, 0x2000000, -0x30, x1, 248, x3)

inst_32:
// rs1_val == 67108864, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x4000000; immval:0x70
TEST_CI_OP( c.addi16sp, x2, 0x4000070, 0x4000000, 0x70, x1, 256, x3)

inst_33:
// rs1_val == 134217728, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x8000000; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0x8000030, 0x8000000, 0x30, x1, 264, x3)

inst_34:
// rs1_val == 268435456, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x10000000; immval:-0xa0
TEST_CI_OP( c.addi16sp, x2, 0xfffff60, 0x10000000, -0xa0, x1, 272, x3)

inst_35:
// rs1_val == 536870912, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x20000000; immval:-0x50
TEST_CI_OP( c.addi16sp, x2, 0x1fffffb0, 0x20000000, -0x50, x1, 280, x3)

inst_36:
// rs1_val == 1073741824, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x40000000; immval:-0x200
TEST_CI_OP( c.addi16sp, x2, 0x3ffffe00, 0x40000000, -0x200, x1, 288, x3)

inst_37:
// rs1_val == 2147483648, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x80000000; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0x7fffffc0, 0x80000000, -0x40, x1, 296, x3)

inst_38:
// rs1_val == 4294967296, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x100000000; immval:0x20
TEST_CI_OP( c.addi16sp, x2, 0x100000020, 0x100000000, 0x20, x1, 304, x3)

inst_39:
// rs1_val == 8589934592, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x200000000; immval:0x60
TEST_CI_OP( c.addi16sp, x2, 0x200000060, 0x200000000, 0x60, x1, 312, x3)

inst_40:
// rs1_val == 17179869184, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x400000000; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0x3ffffffc0, 0x400000000, -0x40, x1, 320, x3)

inst_41:
// rs1_val == 34359738368, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x800000000; immval:0x50
TEST_CI_OP( c.addi16sp, x2, 0x800000050, 0x800000000, 0x50, x1, 328, x3)

inst_42:
// rs1_val == 68719476736, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x1000000000; immval:0x80
TEST_CI_OP( c.addi16sp, x2, 0x1000000080, 0x1000000000, 0x80, x1, 336, x3)

inst_43:
// rs1_val == 137438953472, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x2000000000; immval:-0x50
TEST_CI_OP( c.addi16sp, x2, 0x1fffffffb0, 0x2000000000, -0x50, x1, 344, x3)

inst_44:
// rs1_val == 274877906944, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x4000000000; immval:-0xa0
TEST_CI_OP( c.addi16sp, x2, 0x3fffffff60, 0x4000000000, -0xa0, x1, 352, x3)

inst_45:
// rs1_val == 549755813888, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x8000000000; immval:-0x70
TEST_CI_OP( c.addi16sp, x2, 0x7fffffff90, 0x8000000000, -0x70, x1, 360, x3)

inst_46:
// rs1_val == 1099511627776, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x10000000000; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0xffffffffc0, 0x10000000000, -0x40, x1, 368, x3)

inst_47:
// rs1_val == 2199023255552, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x20000000000; immval:0x70
TEST_CI_OP( c.addi16sp, x2, 0x20000000070, 0x20000000000, 0x70, x1, 376, x3)

inst_48:
// rs1_val == 4398046511104, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x40000000000; immval:0x10
TEST_CI_OP( c.addi16sp, x2, 0x40000000010, 0x40000000000, 0x10, x1, 384, x3)

inst_49:
// rs1_val == 8796093022208, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x80000000000; immval:-0x30
TEST_CI_OP( c.addi16sp, x2, 0x7ffffffffd0, 0x80000000000, -0x30, x1, 392, x3)

inst_50:
// rs1_val == 17592186044416, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x100000000000; immval:0x1f0
TEST_CI_OP( c.addi16sp, x2, 0x1000000001f0, 0x100000000000, 0x1f0, x1, 400, x3)

inst_51:
// rs1_val == 35184372088832, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x200000000000; immval:0xf0
TEST_CI_OP( c.addi16sp, x2, 0x2000000000f0, 0x200000000000, 0xf0, x1, 408, x3)

inst_52:
// rs1_val == 70368744177664, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x400000000000; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0x400000000030, 0x400000000000, 0x30, x1, 416, x3)

inst_53:
// rs1_val == 140737488355328, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x800000000000; immval:0x70
TEST_CI_OP( c.addi16sp, x2, 0x800000000070, 0x800000000000, 0x70, x1, 424, x3)

inst_54:
// rs1_val == 281474976710656, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x1000000000000; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0x1000000000030, 0x1000000000000, 0x30, x1, 432, x3)

inst_55:
// rs1_val == 562949953421312, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x2000000000000; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0x2000000000030, 0x2000000000000, 0x30, x1, 440, x3)

inst_56:
// rs1_val == 1125899906842624, imm_val == -352
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x4000000000000; immval:-0x160
TEST_CI_OP( c.addi16sp, x2, 0x3fffffffffea0, 0x4000000000000, -0x160, x1, 448, x3)

inst_57:
// rs1_val == 2251799813685248, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x8000000000000; immval:-0x30
TEST_CI_OP( c.addi16sp, x2, 0x7ffffffffffd0, 0x8000000000000, -0x30, x1, 456, x3)

inst_58:
// rs1_val == 4503599627370496, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x10000000000000; immval:0x80
TEST_CI_OP( c.addi16sp, x2, 0x10000000000080, 0x10000000000000, 0x80, x1, 464, x3)

inst_59:
// rs1_val == 9007199254740992, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x20000000000000; immval:0x1f0
TEST_CI_OP( c.addi16sp, x2, 0x200000000001f0, 0x20000000000000, 0x1f0, x1, 472, x3)

inst_60:
// rs1_val == 18014398509481984, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x40000000000000; immval:0xf0
TEST_CI_OP( c.addi16sp, x2, 0x400000000000f0, 0x40000000000000, 0xf0, x1, 480, x3)

inst_61:
// rs1_val == 36028797018963968, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x80000000000000; immval:-0x30
TEST_CI_OP( c.addi16sp, x2, 0x7fffffffffffd0, 0x80000000000000, -0x30, x1, 488, x3)

inst_62:
// rs1_val == 72057594037927936, imm_val == -32
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x100000000000000; immval:-0x20
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffffe0, 0x100000000000000, -0x20, x1, 496, x3)

inst_63:
// rs1_val == 144115188075855872, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x200000000000000; immval:0x20
TEST_CI_OP( c.addi16sp, x2, 0x200000000000020, 0x200000000000000, 0x20, x1, 504, x3)

inst_64:
// rs1_val == 288230376151711744, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x400000000000000; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0x3ffffffffffffc0, 0x400000000000000, -0x40, x1, 512, x3)

inst_65:
// rs1_val == 576460752303423488, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x800000000000000; immval:0x40
TEST_CI_OP( c.addi16sp, x2, 0x800000000000040, 0x800000000000000, 0x40, x1, 520, x3)

inst_66:
// rs1_val == 1152921504606846976, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x1000000000000000; immval:0x20
TEST_CI_OP( c.addi16sp, x2, 0x1000000000000020, 0x1000000000000000, 0x20, x1, 528, x3)

inst_67:
// rs1_val == 2305843009213693952, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x2000000000000000; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0x2000000000000030, 0x2000000000000000, 0x30, x1, 536, x3)

inst_68:
// rs1_val == 4611686018427387904, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x4000000000000000; immval:0x50
TEST_CI_OP( c.addi16sp, x2, 0x4000000000000050, 0x4000000000000000, 0x50, x1, 544, x3)

inst_69:
// rs1_val == -9007199254740993, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x20000000000001; immval:-0x10
TEST_CI_OP( c.addi16sp, x2, 0xffdfffffffffffef, -0x20000000000001, -0x10, x1, 552, x3)

inst_70:
// rs1_val == -18014398509481985, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x40000000000001; immval:0x1f0
TEST_CI_OP( c.addi16sp, x2, 0xffc00000000001ef, -0x40000000000001, 0x1f0, x1, 560, x3)

inst_71:
// rs1_val == -36028797018963969, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x80000000000001; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0xff8000000000002f, -0x80000000000001, 0x30, x1, 568, x3)

inst_72:
// rs1_val == -72057594037927937, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x100000000000001; immval:0x80
TEST_CI_OP( c.addi16sp, x2, 0xff0000000000007f, -0x100000000000001, 0x80, x1, 576, x3)

inst_73:
// rs1_val == -144115188075855873, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x200000000000001; immval:-0x80
TEST_CI_OP( c.addi16sp, x2, 0xfdffffffffffff7f, -0x200000000000001, -0x80, x1, 584, x3)

inst_74:
// rs1_val == -288230376151711745, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x400000000000001; immval:0x150
TEST_CI_OP( c.addi16sp, x2, 0xfc0000000000014f, -0x400000000000001, 0x150, x1, 592, x3)

inst_75:
// rs1_val == -576460752303423489, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x800000000000001; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0xf7ffffffffffffbf, -0x800000000000001, -0x40, x1, 600, x3)

inst_76:
// rs1_val == -1152921504606846977, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x1000000000000001; immval:-0x70
TEST_CI_OP( c.addi16sp, x2, 0xefffffffffffff8f, -0x1000000000000001, -0x70, x1, 608, x3)

inst_77:
// rs1_val == -2305843009213693953, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x2000000000000001; immval:-0x100
TEST_CI_OP( c.addi16sp, x2, 0xdffffffffffffeff, -0x2000000000000001, -0x100, x1, 616, x3)

inst_78:
// rs1_val == -4611686018427387905, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x4000000000000001; immval:-0x60
TEST_CI_OP( c.addi16sp, x2, 0xbfffffffffffff9f, -0x4000000000000001, -0x60, x1, 624, x3)

inst_79:
// rs1_val == 6148914691236517205, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x5555555555555555; immval:0x100
TEST_CI_OP( c.addi16sp, x2, 0x5555555555555655, 0x5555555555555555, 0x100, x1, 632, x3)

inst_80:
// rs1_val == -6148914691236517206, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x5555555555555556; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0xaaaaaaaaaaaaaa6a, -0x5555555555555556, -0x40, x1, 640, x3)

inst_81:
// imm_val == -272, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:0x100; immval:-0x110
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffffff0, 0x100, -0x110, x1, 648, x3)

inst_82:
// rs1_val == -3, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x3; immval:0x50
TEST_CI_OP( c.addi16sp, x2, 0x4d, -0x3, 0x50, x1, 656, x3)

inst_83:
// rs1_val == -5, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x5; immval:0x20
TEST_CI_OP( c.addi16sp, x2, 0x1b, -0x5, 0x20, x1, 664, x3)

inst_84:
// rs1_val == -9, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x9; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffffffb7, -0x9, -0x40, x1, 672, x3)

inst_85:
// rs1_val == -17, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x11; immval:0x150
TEST_CI_OP( c.addi16sp, x2, 0x13f, -0x11, 0x150, x1, 680, x3)

inst_86:
// rs1_val == -33, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x21; immval:-0x110
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffffecf, -0x21, -0x110, x1, 688, x3)

inst_87:
// rs1_val == -65, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x41; immval:-0xa0
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffffff1f, -0x41, -0xa0, x1, 696, x3)

inst_88:
// rs1_val == -129, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x81; immval:-0x200
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffffd7f, -0x81, -0x200, x1, 704, x3)

inst_89:
// rs1_val == -257, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x101; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffffebf, -0x101, -0x40, x1, 712, x3)

inst_90:
// rs1_val == -513, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x201; immval:0x60
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffffe5f, -0x201, 0x60, x1, 720, x3)

inst_91:
// rs1_val == -1025, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x401; immval:0x1f0
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffffdef, -0x401, 0x1f0, x1, 728, x3)

inst_92:
// rs1_val == -2049, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x801; immval:0x40
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffff83f, -0x801, 0x40, x1, 736, x3)

inst_93:
// rs1_val == -4097, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x1001; immval:0x50
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffff04f, -0x1001, 0x50, x1, 744, x3)

inst_94:
// rs1_val == -8193, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x2001; immval:-0x10
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffffdfef, -0x2001, -0x10, x1, 752, x3)

inst_95:
// rs1_val == -16385, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x4001; immval:-0x100
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffffbeff, -0x4001, -0x100, x1, 760, x3)

inst_96:
// rs1_val == -32769, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x8001; immval:0x70
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffff806f, -0x8001, 0x70, x1, 768, x3)

inst_97:
// rs1_val == -131073, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x20001; immval:0x90
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffe008f, -0x20001, 0x90, x1, 776, x3)

inst_98:
// rs1_val == -262145, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x40001; immval:0x80
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffffc007f, -0x40001, 0x80, x1, 784, x3)

inst_99:
// rs1_val == -524289, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x80001; immval:0x90
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffff8008f, -0x80001, 0x90, x1, 792, x3)

inst_100:
// rs1_val == -1048577, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x100001; immval:-0x10
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffefffef, -0x100001, -0x10, x1, 800, x3)

inst_101:
// rs1_val == -2097153, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x200001; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffe0002f, -0x200001, 0x30, x1, 808, x3)

inst_102:
// rs1_val == -4194305, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x400001; immval:0x80
TEST_CI_OP( c.addi16sp, x2, 0xffffffffffc0007f, -0x400001, 0x80, x1, 816, x3)

inst_103:
// rs1_val == -8388609, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x800001; immval:0x20
TEST_CI_OP( c.addi16sp, x2, 0xffffffffff80001f, -0x800001, 0x20, x1, 824, x3)

inst_104:
// rs1_val == -16777217, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x1000001; immval:0x80
TEST_CI_OP( c.addi16sp, x2, 0xffffffffff00007f, -0x1000001, 0x80, x1, 832, x3)

inst_105:
// rs1_val == -33554433, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x2000001; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffe00002f, -0x2000001, 0x30, x1, 840, x3)

inst_106:
// rs1_val == -67108865, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x4000001; immval:-0x50
TEST_CI_OP( c.addi16sp, x2, 0xfffffffffbffffaf, -0x4000001, -0x50, x1, 848, x3)

inst_107:
// rs1_val == -134217729, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x8000001; immval:0x30
TEST_CI_OP( c.addi16sp, x2, 0xfffffffff800002f, -0x8000001, 0x30, x1, 856, x3)

inst_108:
// rs1_val == -268435457, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x10000001; immval:-0x30
TEST_CI_OP( c.addi16sp, x2, 0xffffffffefffffcf, -0x10000001, -0x30, x1, 864, x3)

inst_109:
// rs1_val == -536870913, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x20000001; immval:-0x40
TEST_CI_OP( c.addi16sp, x2, 0xffffffffdfffffbf, -0x20000001, -0x40, x1, 872, x3)

inst_110:
// rs1_val == -1073741825, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x40000001; immval:-0x110
TEST_CI_OP( c.addi16sp, x2, 0xffffffffbffffeef, -0x40000001, -0x110, x1, 880, x3)

inst_111:
// rs1_val == -2147483649, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x80000001; immval:-0x60
TEST_CI_OP( c.addi16sp, x2, 0xffffffff7fffff9f, -0x80000001, -0x60, x1, 888, x3)

inst_112:
// rs1_val == -4294967297, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x100000001; immval:0x70
TEST_CI_OP( c.addi16sp, x2, 0xffffffff0000006f, -0x100000001, 0x70, x1, 896, x3)

inst_113:
// rs1_val == -8589934593, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x200000001; immval:-0x90
TEST_CI_OP( c.addi16sp, x2, 0xfffffffdffffff6f, -0x200000001, -0x90, x1, 904, x3)

inst_114:
// rs1_val == -17179869185, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x400000001; immval:-0xa0
TEST_CI_OP( c.addi16sp, x2, 0xfffffffbffffff5f, -0x400000001, -0xa0, x1, 912, x3)

inst_115:
// rs1_val == -34359738369, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x800000001; immval:0x90
TEST_CI_OP( c.addi16sp, x2, 0xfffffff80000008f, -0x800000001, 0x90, x1, 920, x3)

inst_116:
// rs1_val == -68719476737, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x1000000001; immval:-0xa0
TEST_CI_OP( c.addi16sp, x2, 0xffffffefffffff5f, -0x1000000001, -0xa0, x1, 928, x3)

inst_117:
// rs1_val == -137438953473, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x2000000001; immval:0x100
TEST_CI_OP( c.addi16sp, x2, 0xffffffe0000000ff, -0x2000000001, 0x100, x1, 936, x3)

inst_118:
// rs1_val == -549755813889, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x8000000001; immval:-0xa0
TEST_CI_OP( c.addi16sp, x2, 0xffffff7fffffff5f, -0x8000000001, -0xa0, x1, 944, x3)

inst_119:
// rs1_val == -1099511627777, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x10000000001; immval:-0x30
TEST_CI_OP( c.addi16sp, x2, 0xfffffeffffffffcf, -0x10000000001, -0x30, x1, 952, x3)

inst_120:
// rs1_val == -2199023255553, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x20000000001; immval:-0xa0
TEST_CI_OP( c.addi16sp, x2, 0xfffffdffffffff5f, -0x20000000001, -0xa0, x1, 960, x3)

inst_121:
// rs1_val == -4398046511105, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x40000000001; immval:-0x110
TEST_CI_OP( c.addi16sp, x2, 0xfffffbfffffffeef, -0x40000000001, -0x110, x1, 968, x3)

inst_122:
// rs1_val == -8796093022209, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x80000000001; immval:0x10
TEST_CI_OP( c.addi16sp, x2, 0xfffff8000000000f, -0x80000000001, 0x10, x1, 976, x3)

inst_123:
// rs1_val == -17592186044417, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x100000000001; immval:0x70
TEST_CI_OP( c.addi16sp, x2, 0xfffff0000000006f, -0x100000000001, 0x70, x1, 984, x3)

inst_124:
// rs1_val == -35184372088833, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x200000000001; immval:0x40
TEST_CI_OP( c.addi16sp, x2, 0xffffe0000000003f, -0x200000000001, 0x40, x1, 992, x3)

inst_125:
// rs1_val == -70368744177665, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x400000000001; immval:0x100
TEST_CI_OP( c.addi16sp, x2, 0xffffc000000000ff, -0x400000000001, 0x100, x1, 1000, x3)

inst_126:
// rs1_val == -140737488355329, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x800000000001; immval:0x40
TEST_CI_OP( c.addi16sp, x2, 0xffff80000000003f, -0x800000000001, 0x40, x1, 1008, x3)

inst_127:
// rs1_val == -281474976710657, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x1000000000001; immval:0x1f0
TEST_CI_OP( c.addi16sp, x2, 0xffff0000000001ef, -0x1000000000001, 0x1f0, x1, 1016, x3)

inst_128:
// rs1_val == -562949953421313, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x2000000000001; immval:-0xa0
TEST_CI_OP( c.addi16sp, x2, 0xfffdffffffffff5f, -0x2000000000001, -0xa0, x1, 1024, x3)

inst_129:
// rs1_val == -1125899906842625, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x4000000000001; immval:-0x10
TEST_CI_OP( c.addi16sp, x2, 0xfffbffffffffffef, -0x4000000000001, -0x10, x1, 1032, x3)

inst_130:
// rs1_val == -2251799813685249, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x8000000000001; immval:-0x70
TEST_CI_OP( c.addi16sp, x2, 0xfff7ffffffffff8f, -0x8000000000001, -0x70, x1, 1040, x3)

inst_131:
// rs1_val == -4503599627370497, 
// opcode:c.addi16sp; op1:x2; dest:x2 op1val:-0x10000000000001; immval:-0x20
TEST_CI_OP( c.addi16sp, x2, 0xffefffffffffffdf, -0x10000000000001, -0x20, x1, 1048, x3)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 132*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
