
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 04:49:48 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64ic.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the c.andi instruction of the RISC-V C extension for the candi covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IC")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*C.*);def TEST_CASE_1=True;",candi)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rs1==x9, rs1_val == imm_val, rs1_val > 0 and imm_val > 0
// opcode: c.andi; op1:x9; immval:0x9
TEST_CI_OP( c.andi, x9, 0x9, 0x9, 0x9, x1, 0, x2)

inst_1:
// rs1==x10, rs1_val != imm_val, rs1_val == -9, imm_val == -3, rs1_val < 0 and imm_val < 0
// opcode: c.andi; op1:x10; immval:-0x3
TEST_CI_OP( c.andi, x10, 0xfffffffffffffff5, -0x9, -0x3, x1, 8, x2)

inst_2:
// rs1==x11, rs1_val > 0 and imm_val < 0, rs1_val == 4
// opcode: c.andi; op1:x11; immval:-0xa
TEST_CI_OP( c.andi, x11, 0x4, 0x4, -0xa, x1, 16, x2)

inst_3:
// rs1==x12, rs1_val < 0 and imm_val > 0, rs1_val == -129
// opcode: c.andi; op1:x12; immval:0x3
TEST_CI_OP( c.andi, x12, 0x3, -0x81, 0x3, x1, 24, x2)

inst_4:
// rs1==x14, imm_val == (-2**(6-1)), imm_val == -32, rs1_val == 8192
// opcode: c.andi; op1:x14; immval:-0x20
TEST_CI_OP( c.andi, x14, 0x2000, 0x2000, -0x20, x1, 32, x2)

inst_5:
// rs1==x8, imm_val == 0, rs1_val == 70368744177664
// opcode: c.andi; op1:x8; immval:0x0
TEST_CI_OP( c.andi, x8, 0x0, 0x400000000000, 0x0, x1, 40, x2)

inst_6:
// rs1==x15, imm_val == (2**(6-1)-1), imm_val == 31, rs1_val == -68719476737
// opcode: c.andi; op1:x15; immval:0x1f
TEST_CI_OP( c.andi, x15, 0x1f, -0x1000000001, 0x1f, x1, 48, x2)

inst_7:
// rs1==x13, imm_val == 1, rs1_val == 0
// opcode: c.andi; op1:x13; immval:0x1
TEST_CI_OP( c.andi, x13, 0x0, 0x0, 0x1, x1, 56, x2)

inst_8:
// rs1_val == (-2**(xlen-1)), rs1_val == -9223372036854775808
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x8000000000000000, -0x8000000000000000, -0x4, x1, 64, x2)

inst_9:
// rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, 0x7fffffffffffffff, 0x5, x1, 72, x2)

inst_10:
// rs1_val == 1, imm_val == -2
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x1, -0x2, x1, 80, x2)

inst_11:
// imm_val == 2, rs1_val == 268435456
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x10000000, 0x2, x1, 88, x2)

inst_12:
// imm_val == 4, rs1_val==-6148914691236517205 and imm_val==4
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, -0x5555555555555555, 0x4, x1, 96, x2)

inst_13:
// imm_val == 8, rs1_val == -262145
// opcode: c.andi; op1:x10; immval:0x8
TEST_CI_OP( c.andi, x10, 0x8, -0x40001, 0x8, x1, 104, x2)

inst_14:
// imm_val == 16, rs1_val == -4611686018427387905
// opcode: c.andi; op1:x10; immval:0x10
TEST_CI_OP( c.andi, x10, 0x10, -0x4000000000000001, 0x10, x1, 112, x2)

inst_15:
// imm_val == -5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x3, 0x7, -0x5, x1, 120, x2)

inst_16:
// imm_val == -9, rs1_val == -32769
// opcode: c.andi; op1:x10; immval:-0x9
TEST_CI_OP( c.andi, x10, 0xffffffffffff7ff7, -0x8001, -0x9, x1, 128, x2)

inst_17:
// imm_val == -17, rs1_val == 18014398509481984
// opcode: c.andi; op1:x10; immval:-0x11
TEST_CI_OP( c.andi, x10, 0x40000000000000, 0x40000000000000, -0x11, x1, 136, x2)

inst_18:
// imm_val == 21, 
// opcode: c.andi; op1:x10; immval:0x15
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x15, x1, 144, x2)

inst_19:
// imm_val == -22, rs1_val == 36028797018963968
// opcode: c.andi; op1:x10; immval:-0x16
TEST_CI_OP( c.andi, x10, 0x80000000000000, 0x80000000000000, -0x16, x1, 152, x2)

inst_20:
// rs1_val == 2, rs1_val==2 and imm_val==-2
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x2, -0x2, x1, 160, x2)

inst_21:
// rs1_val == 8, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x8, 0x0, x1, 168, x2)

inst_22:
// rs1_val == 16, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x10, 0x4, x1, 176, x2)

inst_23:
// rs1_val == 32, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x20, 0x20, -0x5, x1, 184, x2)

inst_24:
// rs1_val == 64, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x40, 0x3, x1, 192, x2)

inst_25:
// rs1_val == 128, 
// opcode: c.andi; op1:x10; immval:0x1
TEST_CI_OP( c.andi, x10, 0x0, 0x80, 0x1, x1, 200, x2)

inst_26:
// rs1_val == 256, 
// opcode: c.andi; op1:x10; immval:-0x3
TEST_CI_OP( c.andi, x10, 0x100, 0x100, -0x3, x1, 208, x2)

inst_27:
// rs1_val == 512, 
// opcode: c.andi; op1:x10; immval:0x15
TEST_CI_OP( c.andi, x10, 0x0, 0x200, 0x15, x1, 216, x2)

inst_28:
// rs1_val == 1024, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x400, 0x400, -0x1, x1, 224, x2)

inst_29:
// rs1_val == 2048, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x0, 0x800, 0x6, x1, 232, x2)

inst_30:
// rs1_val == 4096, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x1000, 0x2, x1, 240, x2)

inst_31:
// rs1_val == 16384, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x4000, 0x5, x1, 248, x2)

inst_32:
// rs1_val == 32768, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x8000, 0x8000, -0x2, x1, 256, x2)

inst_33:
// rs1_val == 65536, 
// opcode: c.andi; op1:x10; immval:-0x16
TEST_CI_OP( c.andi, x10, 0x10000, 0x10000, -0x16, x1, 264, x2)

inst_34:
// rs1_val == 131072, 
// opcode: c.andi; op1:x10; immval:-0x20
TEST_CI_OP( c.andi, x10, 0x20000, 0x20000, -0x20, x1, 272, x2)

inst_35:
// rs1_val == 262144, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x40000, 0x40000, -0x1, x1, 280, x2)

inst_36:
// rs1_val == 524288, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x80000, 0x0, x1, 288, x2)

inst_37:
// rs1_val == 1048576, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x0, 0x100000, 0x6, x1, 296, x2)

inst_38:
// rs1_val == 2097152, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x200000, 0x9, x1, 304, x2)

inst_39:
// rs1_val == 4194304, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x400000, 0x9, x1, 312, x2)

inst_40:
// rs1_val == 8388608, 
// opcode: c.andi; op1:x10; immval:0xf
TEST_CI_OP( c.andi, x10, 0x0, 0x800000, 0xf, x1, 320, x2)

inst_41:
// rs1_val == 16777216, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x1000000, 0x1000000, -0x1, x1, 328, x2)

inst_42:
// rs1_val == 33554432, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x2000000, 0x5, x1, 336, x2)

inst_43:
// rs1_val == 67108864, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x4000000, 0x4, x1, 344, x2)

inst_44:
// rs1_val == 134217728, 
// opcode: c.andi; op1:x10; immval:0x1
TEST_CI_OP( c.andi, x10, 0x0, 0x8000000, 0x1, x1, 352, x2)

inst_45:
// rs1_val == 536870912, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x20000000, 0x20000000, -0x5, x1, 360, x2)

inst_46:
// rs1_val == 1073741824, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x40000000, 0x4, x1, 368, x2)

inst_47:
// rs1_val == 2147483648, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x80000000, 0x4, x1, 376, x2)

inst_48:
// rs1_val == 4294967296, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x100000000, 0x5, x1, 384, x2)

inst_49:
// rs1_val == 8589934592, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x200000000, 0x200000000, -0x2, x1, 392, x2)

inst_50:
// rs1_val == 17179869184, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x400000000, 0x9, x1, 400, x2)

inst_51:
// rs1_val == 34359738368, 
// opcode: c.andi; op1:x10; immval:-0x11
TEST_CI_OP( c.andi, x10, 0x800000000, 0x800000000, -0x11, x1, 408, x2)

inst_52:
// rs1_val == 68719476736, 
// opcode: c.andi; op1:x10; immval:0x1
TEST_CI_OP( c.andi, x10, 0x0, 0x1000000000, 0x1, x1, 416, x2)

inst_53:
// rs1_val == 137438953472, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x0, 0x2000000000, 0x6, x1, 424, x2)

inst_54:
// rs1_val == 274877906944, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x4000000000, 0x3, x1, 432, x2)

inst_55:
// rs1_val == 549755813888, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x8000000000, 0x4, x1, 440, x2)

inst_56:
// rs1_val == 1099511627776, 
// opcode: c.andi; op1:x10; immval:0x15
TEST_CI_OP( c.andi, x10, 0x0, 0x10000000000, 0x15, x1, 448, x2)

inst_57:
// rs1_val == 2199023255552, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x20000000000, 0x4, x1, 456, x2)

inst_58:
// rs1_val == 4398046511104, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x40000000000, 0x4, x1, 464, x2)

inst_59:
// rs1_val == 8796093022208, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x80000000000, 0x4, x1, 472, x2)

inst_60:
// rs1_val == 17592186044416, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x100000000000, 0x4, x1, 480, x2)

inst_61:
// rs1_val == 35184372088832, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x200000000000, 0x4, x1, 488, x2)

inst_62:
// rs1_val == 140737488355328, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x800000000000, 0x3, x1, 496, x2)

inst_63:
// rs1_val == 281474976710656, 
// opcode: c.andi; op1:x10; immval:0x1f
TEST_CI_OP( c.andi, x10, 0x0, 0x1000000000000, 0x1f, x1, 504, x2)

inst_64:
// rs1_val == 562949953421312, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x2000000000000, 0x3, x1, 512, x2)

inst_65:
// rs1_val == 1125899906842624, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x4000000000000, 0x0, x1, 520, x2)

inst_66:
// rs1_val == 2251799813685248, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x8000000000000, 0x5, x1, 528, x2)

inst_67:
// rs1_val == 4503599627370496, 
// opcode: c.andi; op1:x10; immval:-0x11
TEST_CI_OP( c.andi, x10, 0x10000000000000, 0x10000000000000, -0x11, x1, 536, x2)

inst_68:
// rs1_val == 9007199254740992, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x20000000000000, 0x20000000000000, -0x2, x1, 544, x2)

inst_69:
// rs1_val == 72057594037927936, 
// opcode: c.andi; op1:x10; immval:-0xa
TEST_CI_OP( c.andi, x10, 0x100000000000000, 0x100000000000000, -0xa, x1, 552, x2)

inst_70:
// rs1_val == 144115188075855872, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x200000000000000, 0x3, x1, 560, x2)

inst_71:
// rs1_val == 288230376151711744, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x400000000000000, 0x2, x1, 568, x2)

inst_72:
// rs1_val == 576460752303423488, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x800000000000000, 0x5, x1, 576, x2)

inst_73:
// rs1_val == 1152921504606846976, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x1000000000000000, 0x3, x1, 584, x2)

inst_74:
// rs1_val == 2305843009213693952, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x2000000000000000, 0x2000000000000000, -0x2, x1, 592, x2)

inst_75:
// rs1_val == 4611686018427387904, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x4000000000000000, 0x5, x1, 600, x2)

inst_76:
// rs1_val == -2, 
// opcode: c.andi; op1:x10; immval:-0x7
TEST_CI_OP( c.andi, x10, 0xfffffffffffffff8, -0x2, -0x7, x1, 608, x2)

inst_77:
// rs1_val == -3, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xfffffffffffffffd, -0x3, -0x1, x1, 616, x2)

inst_78:
// rs1_val == -5, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xfffffffffffffff8, -0x5, -0x4, x1, 624, x2)

inst_79:
// rs1_val == -17, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x7, -0x11, 0x7, x1, 632, x2)

inst_80:
// rs1_val == -33, 
// opcode: c.andi; op1:x10; immval:-0x20
TEST_CI_OP( c.andi, x10, 0xffffffffffffffc0, -0x21, -0x20, x1, 640, x2)

inst_81:
// rs1_val == -65, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, -0x41, 0x6, x1, 648, x2)

inst_82:
// rs1_val == -257, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x7, -0x101, 0x7, x1, 656, x2)

inst_83:
// rs1_val == -513, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, -0x201, 0x4, x1, 664, x2)

inst_84:
// rs1_val == -1025, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, -0x401, 0x0, x1, 672, x2)

inst_85:
// rs1_val == -2049, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, -0x801, 0x4, x1, 680, x2)

inst_86:
// rs1_val == -4097, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x7, -0x1001, 0x7, x1, 688, x2)

inst_87:
// rs1_val == -8193, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, -0x2001, 0x4, x1, 696, x2)

inst_88:
// rs1_val == -16385, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, -0x4001, 0x4, x1, 704, x2)

inst_89:
// rs1_val == -65537, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x3, -0x10001, 0x3, x1, 712, x2)

inst_90:
// rs1_val == -131073, 
// opcode: c.andi; op1:x10; immval:-0x3
TEST_CI_OP( c.andi, x10, 0xfffffffffffdfffd, -0x20001, -0x3, x1, 720, x2)

inst_91:
// rs1_val == -524289, 
// opcode: c.andi; op1:x10; immval:-0xa
TEST_CI_OP( c.andi, x10, 0xfffffffffff7fff6, -0x80001, -0xa, x1, 728, x2)

inst_92:
// rs1_val == -1048577, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xffffffffffeffffc, -0x100001, -0x4, x1, 736, x2)

inst_93:
// rs1_val == -2097153, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x3, -0x200001, 0x3, x1, 744, x2)

inst_94:
// rs1_val == -4194305, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, -0x400001, 0x4, x1, 752, x2)

inst_95:
// rs1_val == -8388609, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xffffffffff7fffff, -0x800001, -0x1, x1, 760, x2)

inst_96:
// rs1_val == -16777217, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xfffffffffefffffe, -0x1000001, -0x2, x1, 768, x2)

inst_97:
// rs1_val == -33554433, 
// opcode: c.andi; op1:x10; immval:-0x6
TEST_CI_OP( c.andi, x10, 0xfffffffffdfffffa, -0x2000001, -0x6, x1, 776, x2)

inst_98:
// rs1_val == -67108865, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xfffffffffbfffffb, -0x4000001, -0x5, x1, 784, x2)

inst_99:
// rs1_val == -134217729, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xfffffffff7fffffe, -0x8000001, -0x2, x1, 792, x2)

inst_100:
// rs1_val == -268435457, 
// opcode: c.andi; op1:x10; immval:0xf
TEST_CI_OP( c.andi, x10, 0xf, -0x10000001, 0xf, x1, 800, x2)

inst_101:
// rs1_val == -536870913, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xffffffffdffffffc, -0x20000001, -0x4, x1, 808, x2)

inst_102:
// rs1_val == -1073741825, 
// opcode: c.andi; op1:x10; immval:-0x11
TEST_CI_OP( c.andi, x10, 0xffffffffbfffffef, -0x40000001, -0x11, x1, 816, x2)

inst_103:
// rs1_val == -2147483649, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, -0x80000001, 0x6, x1, 824, x2)

inst_104:
// rs1_val == -4294967297, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xfffffffefffffffe, -0x100000001, -0x2, x1, 832, x2)

inst_105:
// rs1_val == -8589934593, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xfffffffdfffffffb, -0x200000001, -0x5, x1, 840, x2)

inst_106:
// rs1_val == -17179869185, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, -0x400000001, 0x2, x1, 848, x2)

inst_107:
// rs1_val == -34359738369, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, -0x800000001, 0x0, x1, 856, x2)

inst_108:
// rs1_val == -137438953473, 
// opcode: c.andi; op1:x10; immval:-0x3
TEST_CI_OP( c.andi, x10, 0xffffffdffffffffd, -0x2000000001, -0x3, x1, 864, x2)

inst_109:
// rs1_val == -274877906945, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x9, -0x4000000001, 0x9, x1, 872, x2)

inst_110:
// rs1_val == -549755813889, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, -0x8000000001, 0x6, x1, 880, x2)

inst_111:
// rs1_val == -1099511627777, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xfffffefffffffffe, -0x10000000001, -0x2, x1, 888, x2)

inst_112:
// rs1_val == -2199023255553, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, -0x20000000001, 0x5, x1, 896, x2)

inst_113:
// rs1_val == -4398046511105, 
// opcode: c.andi; op1:x10; immval:-0x20
TEST_CI_OP( c.andi, x10, 0xfffffbffffffffe0, -0x40000000001, -0x20, x1, 904, x2)

inst_114:
// rs1_val == -8796093022209, 
// opcode: c.andi; op1:x10; immval:0xf
TEST_CI_OP( c.andi, x10, 0xf, -0x80000000001, 0xf, x1, 912, x2)

inst_115:
// rs1_val == -17592186044417, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, -0x100000000001, 0x6, x1, 920, x2)

inst_116:
// rs1_val == -35184372088833, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, -0x200000000001, 0x5, x1, 928, x2)

inst_117:
// rs1_val == -70368744177665, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, -0x400000000001, 0x4, x1, 936, x2)

inst_118:
// rs1_val == -140737488355329, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xffff7ffffffffffe, -0x800000000001, -0x2, x1, 944, x2)

inst_119:
// rs1_val == -281474976710657, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, -0x1000000000001, 0x5, x1, 952, x2)

inst_120:
// rs1_val == -562949953421313, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, -0x2000000000001, 0x6, x1, 960, x2)

inst_121:
// rs1_val == -1125899906842625, 
// opcode: c.andi; op1:x10; immval:0xf
TEST_CI_OP( c.andi, x10, 0xf, -0x4000000000001, 0xf, x1, 968, x2)

inst_122:
// rs1_val == -2251799813685249, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xfff7fffffffffffb, -0x8000000000001, -0x5, x1, 976, x2)

inst_123:
// rs1_val == -4503599627370497, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, -0x10000000000001, 0x5, x1, 984, x2)

inst_124:
// rs1_val == -9007199254740993, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x3, -0x20000000000001, 0x3, x1, 992, x2)

inst_125:
// rs1_val == -18014398509481985, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xffbffffffffffffc, -0x40000000000001, -0x4, x1, 1000, x2)

inst_126:
// rs1_val == -36028797018963969, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x9, -0x80000000000001, 0x9, x1, 1008, x2)

inst_127:
// rs1_val == -72057594037927937, 
// opcode: c.andi; op1:x10; immval:0x8
TEST_CI_OP( c.andi, x10, 0x8, -0x100000000000001, 0x8, x1, 1016, x2)

inst_128:
// rs1_val == -144115188075855873, 
// opcode: c.andi; op1:x10; immval:-0x16
TEST_CI_OP( c.andi, x10, 0xfdffffffffffffea, -0x200000000000001, -0x16, x1, 1024, x2)

inst_129:
// rs1_val == -288230376151711745, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xfbfffffffffffffe, -0x400000000000001, -0x2, x1, 1032, x2)

inst_130:
// rs1_val == -576460752303423489, 
// opcode: c.andi; op1:x10; immval:-0x3
TEST_CI_OP( c.andi, x10, 0xf7fffffffffffffd, -0x800000000000001, -0x3, x1, 1040, x2)

inst_131:
// rs1_val == -1152921504606846977, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, -0x1000000000000001, 0x2, x1, 1048, x2)

inst_132:
// rs1_val == -2305843009213693953, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xdfffffffffffffff, -0x2000000000000001, -0x1, x1, 1056, x2)

inst_133:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205 and imm_val==-1
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x5555555555555555, 0x5555555555555555, -0x1, x1, 1064, x2)

inst_134:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206 and imm_val==9
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x8, -0x5555555555555556, 0x9, x1, 1072, x2)

inst_135:
// rs1_val==3 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x3, 0x3, 0x3, x1, 1080, x2)

inst_136:
// rs1_val==3 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x1, 0x3, 0x5, x1, 1088, x2)

inst_137:
// rs1_val==3 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0x3, 0xa, x1, 1096, x2)

inst_138:
// rs1_val==3 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x2, 0x3, 0x6, x1, 1104, x2)

inst_139:
// rs1_val==3 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x3, -0x2, x1, 1112, x2)

inst_140:
// rs1_val==3 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x3, 0x3, -0x5, x1, 1120, x2)

inst_141:
// rs1_val==3 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x3, 0x2, x1, 1128, x2)

inst_142:
// rs1_val==3 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x3, 0x4, x1, 1136, x2)

inst_143:
// rs1_val==3 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x1, 0x3, 0x9, x1, 1144, x2)

inst_144:
// rs1_val==3 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x3, 0x0, x1, 1152, x2)

inst_145:
// rs1_val==3 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x3, 0x3, 0xb, x1, 1160, x2)

inst_146:
// rs1_val==3 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x3, 0x3, 0x7, x1, 1168, x2)

inst_147:
// rs1_val==3 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x3, 0x3, -0x1, x1, 1176, x2)

inst_148:
// rs1_val==3 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x3, -0x4, x1, 1184, x2)

inst_149:
// rs1_val==6148914691236517205 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x1, 0x5555555555555555, 0x3, x1, 1192, x2)

inst_150:
// rs1_val==6148914691236517205 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, 0x5555555555555555, 0x5, x1, 1200, x2)

inst_151:
// rs1_val==6148914691236517205 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555555, 0xa, x1, 1208, x2)

inst_152:
// rs1_val==6148914691236517205 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x4, 0x5555555555555555, 0x6, x1, 1216, x2)

inst_153:
// rs1_val==6148914691236517205 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x5555555555555554, 0x5555555555555555, -0x2, x1, 1224, x2)

inst_154:
// rs1_val==6148914691236517205 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x5555555555555551, 0x5555555555555555, -0x5, x1, 1232, x2)

inst_155:
// rs1_val==6148914691236517205 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555555, 0x2, x1, 1240, x2)

inst_156:
// rs1_val==6148914691236517205 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x5555555555555555, 0x4, x1, 1248, x2)

inst_157:
// rs1_val==6148914691236517205 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x1, 0x5555555555555555, 0x9, x1, 1256, x2)

inst_158:
// rs1_val==6148914691236517205 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555555, 0x0, x1, 1264, x2)

inst_159:
// rs1_val==6148914691236517205 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x1, 0x5555555555555555, 0xb, x1, 1272, x2)

inst_160:
// rs1_val==6148914691236517205 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x5, 0x5555555555555555, 0x7, x1, 1280, x2)

inst_161:
// rs1_val==6148914691236517205 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x5555555555555554, 0x5555555555555555, -0x4, x1, 1288, x2)

inst_162:
// rs1_val==-6148914691236517206 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x2, -0x5555555555555556, 0x3, x1, 1296, x2)

inst_163:
// rs1_val==-6148914691236517206 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, -0x5555555555555556, 0x5, x1, 1304, x2)

inst_164:
// rs1_val==-6148914691236517206 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0xa, -0x5555555555555556, 0xa, x1, 1312, x2)

inst_165:
// rs1_val==-6148914691236517206 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x2, -0x5555555555555556, 0x6, x1, 1320, x2)

inst_166:
// rs1_val==-6148914691236517206 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, -0x2, x1, 1328, x2)

inst_167:
// rs1_val==-6148914691236517206 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, -0x5, x1, 1336, x2)

inst_168:
// rs1_val==-6148914691236517206 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, -0x5555555555555556, 0x2, x1, 1344, x2)

inst_169:
// rs1_val==-6148914691236517206 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, -0x5555555555555556, 0x4, x1, 1352, x2)

inst_170:
// rs1_val==-6148914691236517206 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, -0x5555555555555556, 0x0, x1, 1360, x2)

inst_171:
// rs1_val==-6148914691236517206 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0xa, -0x5555555555555556, 0xb, x1, 1368, x2)

inst_172:
// rs1_val==-6148914691236517206 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x2, -0x5555555555555556, 0x7, x1, 1376, x2)

inst_173:
// rs1_val==-6148914691236517206 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, -0x1, x1, 1384, x2)

inst_174:
// rs1_val==-6148914691236517206 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xaaaaaaaaaaaaaaa8, -0x5555555555555556, -0x4, x1, 1392, x2)

inst_175:
// rs1_val==5 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x1, 0x5, 0x3, x1, 1400, x2)

inst_176:
// rs1_val==5 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, 0x5, 0x5, x1, 1408, x2)

inst_177:
// rs1_val==5 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x0, 0x5, 0xa, x1, 1416, x2)

inst_178:
// rs1_val==5 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x4, 0x5, 0x6, x1, 1424, x2)

inst_179:
// rs1_val==5 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x4, 0x5, -0x2, x1, 1432, x2)

inst_180:
// rs1_val==5 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x1, 0x5, -0x5, x1, 1440, x2)

inst_181:
// rs1_val==5 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x5, 0x2, x1, 1448, x2)

inst_182:
// rs1_val==5 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x5, 0x4, x1, 1456, x2)

inst_183:
// rs1_val==5 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x1, 0x5, 0x9, x1, 1464, x2)

inst_184:
// rs1_val==5 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x5, 0x0, x1, 1472, x2)

inst_185:
// rs1_val==5 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x1, 0x5, 0xb, x1, 1480, x2)

inst_186:
// rs1_val==5 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x5, 0x5, 0x7, x1, 1488, x2)

inst_187:
// rs1_val==5 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x5, 0x5, -0x1, x1, 1496, x2)

inst_188:
// rs1_val==5 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x5, -0x4, x1, 1504, x2)

inst_189:
// rs1_val==3689348814741910323 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x3, 0x3333333333333333, 0x3, x1, 1512, x2)

inst_190:
// rs1_val==3689348814741910323 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x1, 0x3333333333333333, 0x5, x1, 1520, x2)

inst_191:
// rs1_val==3689348814741910323 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333333, 0xa, x1, 1528, x2)

inst_192:
// rs1_val==3689348814741910323 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333333, 0x6, x1, 1536, x2)

inst_193:
// rs1_val==3689348814741910323 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x3333333333333332, 0x3333333333333333, -0x2, x1, 1544, x2)

inst_194:
// rs1_val==3689348814741910323 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x3333333333333333, 0x3333333333333333, -0x5, x1, 1552, x2)

inst_195:
// rs1_val==3689348814741910323 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333333, 0x2, x1, 1560, x2)

inst_196:
// rs1_val==3689348814741910323 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333333, 0x4, x1, 1568, x2)

inst_197:
// rs1_val==3689348814741910323 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x1, 0x3333333333333333, 0x9, x1, 1576, x2)

inst_198:
// rs1_val==3689348814741910323 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333333, 0x0, x1, 1584, x2)

inst_199:
// rs1_val==3689348814741910323 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x3, 0x3333333333333333, 0xb, x1, 1592, x2)

inst_200:
// rs1_val==3689348814741910323 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x3, 0x3333333333333333, 0x7, x1, 1600, x2)

inst_201:
// rs1_val==3689348814741910323 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x3333333333333333, 0x3333333333333333, -0x1, x1, 1608, x2)

inst_202:
// rs1_val==3689348814741910323 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x3333333333333330, 0x3333333333333333, -0x4, x1, 1616, x2)

inst_203:
// rs1_val==7378697629483820646 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x2, 0x6666666666666666, 0x3, x1, 1624, x2)

inst_204:
// rs1_val==7378697629483820646 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x4, 0x6666666666666666, 0x5, x1, 1632, x2)

inst_205:
// rs1_val==7378697629483820646 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0x6666666666666666, 0xa, x1, 1640, x2)

inst_206:
// rs1_val==7378697629483820646 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, 0x6666666666666666, 0x6, x1, 1648, x2)

inst_207:
// rs1_val==7378697629483820646 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x6666666666666666, 0x6666666666666666, -0x2, x1, 1656, x2)

inst_208:
// rs1_val==7378697629483820646 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x6666666666666662, 0x6666666666666666, -0x5, x1, 1664, x2)

inst_209:
// rs1_val==7378697629483820646 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x6666666666666666, 0x2, x1, 1672, x2)

inst_210:
// rs1_val==7378697629483820646 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x6666666666666666, 0x4, x1, 1680, x2)

inst_211:
// rs1_val==7378697629483820646 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x6666666666666666, 0x9, x1, 1688, x2)

inst_212:
// rs1_val==7378697629483820646 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x6666666666666666, 0x0, x1, 1696, x2)

inst_213:
// rs1_val==7378697629483820646 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x2, 0x6666666666666666, 0xb, x1, 1704, x2)

inst_214:
// rs1_val==7378697629483820646 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x6, 0x6666666666666666, 0x7, x1, 1712, x2)

inst_215:
// rs1_val==7378697629483820646 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x6666666666666666, 0x6666666666666666, -0x1, x1, 1720, x2)

inst_216:
// rs1_val==7378697629483820646 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x6666666666666664, 0x6666666666666666, -0x4, x1, 1728, x2)

inst_217:
// rs1_val==-3037000499 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x1, -0xb504f333, 0x3, x1, 1736, x2)

inst_218:
// rs1_val==-3037000499 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, -0xb504f333, 0x5, x1, 1744, x2)

inst_219:
// rs1_val==-3037000499 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x8, -0xb504f333, 0xa, x1, 1752, x2)

inst_220:
// rs1_val==-3037000499 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x4, -0xb504f333, 0x6, x1, 1760, x2)

inst_221:
// rs1_val==-3037000499 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xffffffff4afb0ccc, -0xb504f333, -0x2, x1, 1768, x2)

inst_222:
// rs1_val==-3037000499 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xffffffff4afb0cc9, -0xb504f333, -0x5, x1, 1776, x2)

inst_223:
// rs1_val==-3037000499 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, -0xb504f333, 0x2, x1, 1784, x2)

inst_224:
// rs1_val==-3037000499 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, -0xb504f333, 0x4, x1, 1792, x2)

inst_225:
// rs1_val==-3037000499 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x9, -0xb504f333, 0x9, x1, 1800, x2)

inst_226:
// rs1_val==-3037000499 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, -0xb504f333, 0x0, x1, 1808, x2)

inst_227:
// rs1_val==-3037000499 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x9, -0xb504f333, 0xb, x1, 1816, x2)

inst_228:
// rs1_val==-3037000499 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x5, -0xb504f333, 0x7, x1, 1824, x2)

inst_229:
// rs1_val==-3037000499 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xffffffff4afb0ccd, -0xb504f333, -0x1, x1, 1832, x2)

inst_230:
// rs1_val==-3037000499 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xffffffff4afb0ccc, -0xb504f333, -0x4, x1, 1840, x2)

inst_231:
// rs1_val==3037000499 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x3, 0xb504f333, 0x3, x1, 1848, x2)

inst_232:
// rs1_val==3037000499 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x1, 0xb504f333, 0x5, x1, 1856, x2)

inst_233:
// rs1_val==3037000499 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f333, 0xa, x1, 1864, x2)

inst_234:
// rs1_val==3037000499 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f333, 0x6, x1, 1872, x2)

inst_235:
// rs1_val==3037000499 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xb504f332, 0xb504f333, -0x2, x1, 1880, x2)

inst_236:
// rs1_val==3037000499 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xb504f333, 0xb504f333, -0x5, x1, 1888, x2)

inst_237:
// rs1_val==3037000499 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f333, 0x2, x1, 1896, x2)

inst_238:
// rs1_val==3037000499 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f333, 0x4, x1, 1904, x2)

inst_239:
// rs1_val==3037000499 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x1, 0xb504f333, 0x9, x1, 1912, x2)

inst_240:
// rs1_val==3037000499 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f333, 0x0, x1, 1920, x2)

inst_241:
// rs1_val==3037000499 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x3, 0xb504f333, 0xb, x1, 1928, x2)

inst_242:
// rs1_val==3037000499 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x3, 0xb504f333, 0x7, x1, 1936, x2)

inst_243:
// rs1_val==3037000499 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xb504f333, 0xb504f333, -0x1, x1, 1944, x2)

inst_244:
// rs1_val==3037000499 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xb504f330, 0xb504f333, -0x4, x1, 1952, x2)

inst_245:
// rs1_val==2 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x2, 0x2, 0x3, x1, 1960, x2)

inst_246:
// rs1_val==2 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x2, 0x5, x1, 1968, x2)

inst_247:
// rs1_val==2 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0x2, 0xa, x1, 1976, x2)

inst_248:
// rs1_val==2 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x2, 0x2, 0x6, x1, 1984, x2)

inst_249:
// rs1_val==2 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x2, 0x2, -0x5, x1, 1992, x2)

inst_250:
// rs1_val==2 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x2, 0x2, x1, 2000, x2)

inst_251:
// rs1_val==2 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x2, 0x4, x1, 2008, x2)

inst_252:
// rs1_val==2 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x2, 0x9, x1, 2016, x2)

inst_253:
// rs1_val==2 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x2, 0x0, x1, 2024, x2)

inst_254:
// rs1_val==2 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x2, 0x2, 0xb, x1, 2032, x2)

inst_255:
// rs1_val==2 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x2, 0x2, 0x7, x1, 2040, x2)
RVTEST_SIGBASE( x1,signature_x1_2)

inst_256:
// rs1_val==2 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x2, 0x2, -0x1, x1, 0, x2)

inst_257:
// rs1_val==2 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x2, -0x4, x1, 8, x2)

inst_258:
// rs1_val==6148914691236517204 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555554, 0x3, x1, 16, x2)

inst_259:
// rs1_val==6148914691236517204 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x4, 0x5555555555555554, 0x5, x1, 24, x2)

inst_260:
// rs1_val==6148914691236517204 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555554, 0xa, x1, 32, x2)

inst_261:
// rs1_val==6148914691236517204 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x4, 0x5555555555555554, 0x6, x1, 40, x2)

inst_262:
// rs1_val==6148914691236517204 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x5555555555555554, 0x5555555555555554, -0x2, x1, 48, x2)

inst_263:
// rs1_val==6148914691236517204 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x5555555555555550, 0x5555555555555554, -0x5, x1, 56, x2)

inst_264:
// rs1_val==6148914691236517204 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555554, 0x2, x1, 64, x2)

inst_265:
// rs1_val==6148914691236517204 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x5555555555555554, 0x4, x1, 72, x2)

inst_266:
// rs1_val==6148914691236517204 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555554, 0x9, x1, 80, x2)

inst_267:
// rs1_val==6148914691236517204 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555554, 0x0, x1, 88, x2)

inst_268:
// rs1_val==6148914691236517204 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555554, 0xb, x1, 96, x2)

inst_269:
// rs1_val==6148914691236517204 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x4, 0x5555555555555554, 0x7, x1, 104, x2)

inst_270:
// rs1_val==6148914691236517204 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x5555555555555554, 0x5555555555555554, -0x1, x1, 112, x2)

inst_271:
// rs1_val==6148914691236517204 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x5555555555555554, 0x5555555555555554, -0x4, x1, 120, x2)

inst_272:
// rs1_val==0 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x3, x1, 128, x2)

inst_273:
// rs1_val==0 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x5, x1, 136, x2)

inst_274:
// rs1_val==0 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0xa, x1, 144, x2)

inst_275:
// rs1_val==0 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x6, x1, 152, x2)

inst_276:
// rs1_val==0 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x0, -0x2, x1, 160, x2)

inst_277:
// rs1_val==0 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x0, -0x5, x1, 168, x2)

inst_278:
// rs1_val==0 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x2, x1, 176, x2)

inst_279:
// rs1_val==0 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x4, x1, 184, x2)

inst_280:
// rs1_val==0 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x9, x1, 192, x2)

inst_281:
// rs1_val==0 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x0, x1, 200, x2)

inst_282:
// rs1_val==0 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0xb, x1, 208, x2)

inst_283:
// rs1_val==0 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x0, 0x0, 0x7, x1, 216, x2)

inst_284:
// rs1_val==0 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x0, 0x0, -0x1, x1, 224, x2)

inst_285:
// rs1_val==0 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x0, -0x4, x1, 232, x2)

inst_286:
// rs1_val==4 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x4, 0x3, x1, 240, x2)

inst_287:
// rs1_val==4 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x4, 0x4, 0x5, x1, 248, x2)

inst_288:
// rs1_val==4 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x0, 0x4, 0xa, x1, 256, x2)

inst_289:
// rs1_val==4 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x4, 0x4, 0x6, x1, 264, x2)

inst_290:
// rs1_val==4 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x4, 0x4, -0x2, x1, 272, x2)

inst_291:
// rs1_val==4 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x4, -0x5, x1, 280, x2)

inst_292:
// rs1_val==4 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x4, 0x2, x1, 288, x2)

inst_293:
// rs1_val==4 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x4, 0x4, x1, 296, x2)

inst_294:
// rs1_val==4 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x4, 0x9, x1, 304, x2)

inst_295:
// rs1_val==4 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x4, 0x0, x1, 312, x2)

inst_296:
// rs1_val==4 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x0, 0x4, 0xb, x1, 320, x2)

inst_297:
// rs1_val==4 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x4, 0x4, 0x7, x1, 328, x2)

inst_298:
// rs1_val==4 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x4, 0x4, -0x1, x1, 336, x2)

inst_299:
// rs1_val==4 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x4, -0x4, x1, 344, x2)

inst_300:
// rs1_val==3689348814741910322 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333332, 0x3, x1, 352, x2)

inst_301:
// rs1_val==3689348814741910322 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333332, 0x5, x1, 360, x2)

inst_302:
// rs1_val==3689348814741910322 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333332, 0xa, x1, 368, x2)

inst_303:
// rs1_val==3689348814741910322 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333332, 0x6, x1, 376, x2)

inst_304:
// rs1_val==3689348814741910322 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x3333333333333332, 0x3333333333333332, -0x2, x1, 384, x2)

inst_305:
// rs1_val==3689348814741910322 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x3333333333333332, 0x3333333333333332, -0x5, x1, 392, x2)

inst_306:
// rs1_val==3689348814741910322 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333332, 0x2, x1, 400, x2)

inst_307:
// rs1_val==3689348814741910322 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333332, 0x4, x1, 408, x2)

inst_308:
// rs1_val==3689348814741910322 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333332, 0x9, x1, 416, x2)

inst_309:
// rs1_val==3689348814741910322 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333332, 0x0, x1, 424, x2)

inst_310:
// rs1_val==3689348814741910322 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333332, 0xb, x1, 432, x2)

inst_311:
// rs1_val==3689348814741910322 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x2, 0x3333333333333332, 0x7, x1, 440, x2)

inst_312:
// rs1_val==3689348814741910322 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x3333333333333332, 0x3333333333333332, -0x1, x1, 448, x2)

inst_313:
// rs1_val==3689348814741910322 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x3333333333333330, 0x3333333333333332, -0x4, x1, 456, x2)

inst_314:
// rs1_val==7378697629483820645 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x1, 0x6666666666666665, 0x3, x1, 464, x2)

inst_315:
// rs1_val==7378697629483820645 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, 0x6666666666666665, 0x5, x1, 472, x2)

inst_316:
// rs1_val==7378697629483820645 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x0, 0x6666666666666665, 0xa, x1, 480, x2)

inst_317:
// rs1_val==7378697629483820645 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x4, 0x6666666666666665, 0x6, x1, 488, x2)

inst_318:
// rs1_val==7378697629483820645 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x6666666666666664, 0x6666666666666665, -0x2, x1, 496, x2)

inst_319:
// rs1_val==7378697629483820645 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x6666666666666661, 0x6666666666666665, -0x5, x1, 504, x2)

inst_320:
// rs1_val==7378697629483820645 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x6666666666666665, 0x2, x1, 512, x2)

inst_321:
// rs1_val==7378697629483820645 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x6666666666666665, 0x4, x1, 520, x2)

inst_322:
// rs1_val==7378697629483820645 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x1, 0x6666666666666665, 0x9, x1, 528, x2)

inst_323:
// rs1_val==7378697629483820645 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x6666666666666665, 0x0, x1, 536, x2)

inst_324:
// rs1_val==7378697629483820645 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x1, 0x6666666666666665, 0xb, x1, 544, x2)

inst_325:
// rs1_val==7378697629483820645 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x5, 0x6666666666666665, 0x7, x1, 552, x2)

inst_326:
// rs1_val==7378697629483820645 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x6666666666666665, 0x6666666666666665, -0x1, x1, 560, x2)

inst_327:
// rs1_val==7378697629483820645 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x6666666666666664, 0x6666666666666665, -0x4, x1, 568, x2)

inst_328:
// rs1_val==3037000498 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f332, 0x3, x1, 576, x2)

inst_329:
// rs1_val==3037000498 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f332, 0x5, x1, 584, x2)

inst_330:
// rs1_val==3037000498 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f332, 0xa, x1, 592, x2)

inst_331:
// rs1_val==3037000498 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f332, 0x6, x1, 600, x2)

inst_332:
// rs1_val==3037000498 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xb504f332, 0xb504f332, -0x2, x1, 608, x2)

inst_333:
// rs1_val==3037000498 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xb504f332, 0xb504f332, -0x5, x1, 616, x2)

inst_334:
// rs1_val==3037000498 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f332, 0x2, x1, 624, x2)

inst_335:
// rs1_val==3037000498 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f332, 0x4, x1, 632, x2)

inst_336:
// rs1_val==3037000498 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f332, 0x9, x1, 640, x2)

inst_337:
// rs1_val==3037000498 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f332, 0x0, x1, 648, x2)

inst_338:
// rs1_val==3037000498 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f332, 0xb, x1, 656, x2)

inst_339:
// rs1_val==3037000498 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x2, 0xb504f332, 0x7, x1, 664, x2)

inst_340:
// rs1_val==3037000498 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xb504f332, 0xb504f332, -0x1, x1, 672, x2)

inst_341:
// rs1_val==3037000498 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xb504f330, 0xb504f332, -0x4, x1, 680, x2)

inst_342:
// rs1_val==6148914691236517206 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x2, 0x5555555555555556, 0x3, x1, 688, x2)

inst_343:
// rs1_val==6148914691236517206 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x4, 0x5555555555555556, 0x5, x1, 696, x2)

inst_344:
// rs1_val==6148914691236517206 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0x5555555555555556, 0xa, x1, 704, x2)

inst_345:
// rs1_val==6148914691236517206 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, 0x5555555555555556, 0x6, x1, 712, x2)

inst_346:
// rs1_val==6148914691236517206 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x5555555555555556, 0x5555555555555556, -0x2, x1, 720, x2)

inst_347:
// rs1_val==6148914691236517206 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x5555555555555552, 0x5555555555555556, -0x5, x1, 728, x2)

inst_348:
// rs1_val==6148914691236517206 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x5555555555555556, 0x2, x1, 736, x2)

inst_349:
// rs1_val==6148914691236517206 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x5555555555555556, 0x4, x1, 744, x2)

inst_350:
// rs1_val==6148914691236517206 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555556, 0x9, x1, 752, x2)

inst_351:
// rs1_val==6148914691236517206 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x5555555555555556, 0x0, x1, 760, x2)

inst_352:
// rs1_val==6148914691236517206 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x2, 0x5555555555555556, 0xb, x1, 768, x2)

inst_353:
// rs1_val==6148914691236517206 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x6, 0x5555555555555556, 0x7, x1, 776, x2)

inst_354:
// rs1_val==6148914691236517206 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x5555555555555556, 0x5555555555555556, -0x1, x1, 784, x2)

inst_355:
// rs1_val==6148914691236517206 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x5555555555555554, 0x5555555555555556, -0x4, x1, 792, x2)

inst_356:
// rs1_val==-6148914691236517205 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x3, -0x5555555555555555, 0x3, x1, 800, x2)

inst_357:
// rs1_val==-6148914691236517205 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x1, -0x5555555555555555, 0x5, x1, 808, x2)

inst_358:
// rs1_val==-6148914691236517205 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0xa, -0x5555555555555555, 0xa, x1, 816, x2)

inst_359:
// rs1_val==-6148914691236517205 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x2, -0x5555555555555555, 0x6, x1, 824, x2)

inst_360:
// rs1_val==-6148914691236517205 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555555, -0x2, x1, 832, x2)

inst_361:
// rs1_val==-6148914691236517205 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, -0x5, x1, 840, x2)

inst_362:
// rs1_val==-6148914691236517205 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, -0x5555555555555555, 0x2, x1, 848, x2)

inst_363:
// rs1_val==-6148914691236517205 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x9, -0x5555555555555555, 0x9, x1, 856, x2)

inst_364:
// rs1_val==-6148914691236517205 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, -0x5555555555555555, 0x0, x1, 864, x2)

inst_365:
// rs1_val==-6148914691236517205 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0xb, -0x5555555555555555, 0xb, x1, 872, x2)

inst_366:
// rs1_val==-6148914691236517205 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x3, -0x5555555555555555, 0x7, x1, 880, x2)

inst_367:
// rs1_val==-6148914691236517205 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, -0x1, x1, 888, x2)

inst_368:
// rs1_val==-6148914691236517205 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xaaaaaaaaaaaaaaa8, -0x5555555555555555, -0x4, x1, 896, x2)

inst_369:
// rs1_val==6 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x2, 0x6, 0x3, x1, 904, x2)

inst_370:
// rs1_val==6 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x4, 0x6, 0x5, x1, 912, x2)

inst_371:
// rs1_val==6 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0x6, 0xa, x1, 920, x2)

inst_372:
// rs1_val==6 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, 0x6, 0x6, x1, 928, x2)

inst_373:
// rs1_val==6 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x6, 0x6, -0x2, x1, 936, x2)

inst_374:
// rs1_val==6 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x2, 0x6, -0x5, x1, 944, x2)

inst_375:
// rs1_val==6 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x6, 0x2, x1, 952, x2)

inst_376:
// rs1_val==6 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x6, 0x4, x1, 960, x2)

inst_377:
// rs1_val==6 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x6, 0x9, x1, 968, x2)

inst_378:
// rs1_val==6 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x6, 0x0, x1, 976, x2)

inst_379:
// rs1_val==6 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x2, 0x6, 0xb, x1, 984, x2)

inst_380:
// rs1_val==6 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x6, 0x6, 0x7, x1, 992, x2)

inst_381:
// rs1_val==6 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x6, 0x6, -0x1, x1, 1000, x2)

inst_382:
// rs1_val==6 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x6, -0x4, x1, 1008, x2)

inst_383:
// rs1_val==3689348814741910324 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333334, 0x3, x1, 1016, x2)

inst_384:
// rs1_val==3689348814741910324 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x4, 0x3333333333333334, 0x5, x1, 1024, x2)

inst_385:
// rs1_val==3689348814741910324 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333334, 0xa, x1, 1032, x2)

inst_386:
// rs1_val==3689348814741910324 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x4, 0x3333333333333334, 0x6, x1, 1040, x2)

inst_387:
// rs1_val==3689348814741910324 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x3333333333333334, 0x3333333333333334, -0x2, x1, 1048, x2)

inst_388:
// rs1_val==3689348814741910324 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x3333333333333330, 0x3333333333333334, -0x5, x1, 1056, x2)

inst_389:
// rs1_val==3689348814741910324 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333334, 0x2, x1, 1064, x2)

inst_390:
// rs1_val==3689348814741910324 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x3333333333333334, 0x4, x1, 1072, x2)

inst_391:
// rs1_val==3689348814741910324 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333334, 0x9, x1, 1080, x2)

inst_392:
// rs1_val==3689348814741910324 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333334, 0x0, x1, 1088, x2)

inst_393:
// rs1_val==3689348814741910324 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x0, 0x3333333333333334, 0xb, x1, 1096, x2)

inst_394:
// rs1_val==3689348814741910324 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x4, 0x3333333333333334, 0x7, x1, 1104, x2)

inst_395:
// rs1_val==3689348814741910324 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x3333333333333334, 0x3333333333333334, -0x1, x1, 1112, x2)

inst_396:
// rs1_val==3689348814741910324 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x3333333333333334, 0x3333333333333334, -0x4, x1, 1120, x2)

inst_397:
// rs1_val==7378697629483820647 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x3, 0x6666666666666667, 0x3, x1, 1128, x2)

inst_398:
// rs1_val==7378697629483820647 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x5, 0x6666666666666667, 0x5, x1, 1136, x2)

inst_399:
// rs1_val==7378697629483820647 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x2, 0x6666666666666667, 0xa, x1, 1144, x2)

inst_400:
// rs1_val==7378697629483820647 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, 0x6666666666666667, 0x6, x1, 1152, x2)

inst_401:
// rs1_val==7378697629483820647 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0x6666666666666666, 0x6666666666666667, -0x2, x1, 1160, x2)

inst_402:
// rs1_val==7378697629483820647 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0x6666666666666663, 0x6666666666666667, -0x5, x1, 1168, x2)

inst_403:
// rs1_val==7378697629483820647 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, 0x6666666666666667, 0x2, x1, 1176, x2)

inst_404:
// rs1_val==7378697629483820647 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0x6666666666666667, 0x4, x1, 1184, x2)

inst_405:
// rs1_val==7378697629483820647 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x1, 0x6666666666666667, 0x9, x1, 1192, x2)

inst_406:
// rs1_val==7378697629483820647 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0x6666666666666667, 0x0, x1, 1200, x2)

inst_407:
// rs1_val==7378697629483820647 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x3, 0x6666666666666667, 0xb, x1, 1208, x2)

inst_408:
// rs1_val==-3037000498 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xffffffff4afb0cce, -0xb504f332, -0x1, x1, 1216, x2)

inst_409:
// rs1_val==-3037000498 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xffffffff4afb0ccc, -0xb504f332, -0x4, x1, 1224, x2)

inst_410:
// rs1_val==3037000500 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f334, 0x3, x1, 1232, x2)

inst_411:
// rs1_val==3037000500 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x4, 0xb504f334, 0x5, x1, 1240, x2)

inst_412:
// rs1_val==3037000500 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f334, 0xa, x1, 1248, x2)

inst_413:
// rs1_val==3037000500 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x4, 0xb504f334, 0x6, x1, 1256, x2)

inst_414:
// rs1_val==3037000500 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xb504f334, 0xb504f334, -0x2, x1, 1264, x2)

inst_415:
// rs1_val==3037000500 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xb504f330, 0xb504f334, -0x5, x1, 1272, x2)

inst_416:
// rs1_val==3037000500 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f334, 0x2, x1, 1280, x2)

inst_417:
// rs1_val==3037000500 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, 0xb504f334, 0x4, x1, 1288, x2)

inst_418:
// rs1_val==3037000500 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f334, 0x9, x1, 1296, x2)

inst_419:
// rs1_val==3037000500 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f334, 0x0, x1, 1304, x2)

inst_420:
// rs1_val==3037000500 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0x0, 0xb504f334, 0xb, x1, 1312, x2)

inst_421:
// rs1_val==3037000500 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x4, 0xb504f334, 0x7, x1, 1320, x2)

inst_422:
// rs1_val==3037000500 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0xb504f334, 0xb504f334, -0x1, x1, 1328, x2)

inst_423:
// rs1_val==3037000500 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0xb504f334, 0xb504f334, -0x4, x1, 1336, x2)

inst_424:
// rs1_val==7378697629483820647 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x7, 0x6666666666666667, 0x7, x1, 1344, x2)

inst_425:
// rs1_val==7378697629483820647 and imm_val==-1, 
// opcode: c.andi; op1:x10; immval:-0x1
TEST_CI_OP( c.andi, x10, 0x6666666666666667, 0x6666666666666667, -0x1, x1, 1352, x2)

inst_426:
// rs1_val==7378697629483820647 and imm_val==-4, 
// opcode: c.andi; op1:x10; immval:-0x4
TEST_CI_OP( c.andi, x10, 0x6666666666666664, 0x6666666666666667, -0x4, x1, 1360, x2)

inst_427:
// rs1_val==-3037000498 and imm_val==3, 
// opcode: c.andi; op1:x10; immval:0x3
TEST_CI_OP( c.andi, x10, 0x2, -0xb504f332, 0x3, x1, 1368, x2)

inst_428:
// rs1_val==-3037000498 and imm_val==5, 
// opcode: c.andi; op1:x10; immval:0x5
TEST_CI_OP( c.andi, x10, 0x4, -0xb504f332, 0x5, x1, 1376, x2)

inst_429:
// rs1_val==-3037000498 and imm_val==10, 
// opcode: c.andi; op1:x10; immval:0xa
TEST_CI_OP( c.andi, x10, 0xa, -0xb504f332, 0xa, x1, 1384, x2)

inst_430:
// rs1_val==-3037000498 and imm_val==6, 
// opcode: c.andi; op1:x10; immval:0x6
TEST_CI_OP( c.andi, x10, 0x6, -0xb504f332, 0x6, x1, 1392, x2)

inst_431:
// rs1_val==-3037000498 and imm_val==-2, 
// opcode: c.andi; op1:x10; immval:-0x2
TEST_CI_OP( c.andi, x10, 0xffffffff4afb0cce, -0xb504f332, -0x2, x1, 1400, x2)

inst_432:
// rs1_val==-3037000498 and imm_val==-5, 
// opcode: c.andi; op1:x10; immval:-0x5
TEST_CI_OP( c.andi, x10, 0xffffffff4afb0cca, -0xb504f332, -0x5, x1, 1408, x2)

inst_433:
// rs1_val==-3037000498 and imm_val==2, 
// opcode: c.andi; op1:x10; immval:0x2
TEST_CI_OP( c.andi, x10, 0x2, -0xb504f332, 0x2, x1, 1416, x2)

inst_434:
// rs1_val==-3037000498 and imm_val==4, 
// opcode: c.andi; op1:x10; immval:0x4
TEST_CI_OP( c.andi, x10, 0x4, -0xb504f332, 0x4, x1, 1424, x2)

inst_435:
// rs1_val==-3037000498 and imm_val==9, 
// opcode: c.andi; op1:x10; immval:0x9
TEST_CI_OP( c.andi, x10, 0x8, -0xb504f332, 0x9, x1, 1432, x2)

inst_436:
// rs1_val==-3037000498 and imm_val==0, 
// opcode: c.andi; op1:x10; immval:0x0
TEST_CI_OP( c.andi, x10, 0x0, -0xb504f332, 0x0, x1, 1440, x2)

inst_437:
// rs1_val==-3037000498 and imm_val==11, 
// opcode: c.andi; op1:x10; immval:0xb
TEST_CI_OP( c.andi, x10, 0xa, -0xb504f332, 0xb, x1, 1448, x2)

inst_438:
// rs1_val==-3037000498 and imm_val==7, 
// opcode: c.andi; op1:x10; immval:0x7
TEST_CI_OP( c.andi, x10, 0x6, -0xb504f332, 0x7, x1, 1456, x2)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_2:
    .fill 183*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
