
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 04:49:48 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64ic.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the c.bnez instruction of the RISC-V C extension for the cbnez covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IC")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*C.*);def TEST_CASE_1=True;",cbnez)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rs1==x12, rs1_val == (-2**(xlen-1)), rs1_val < 0 and imm_val < 0, rs1_val == -9223372036854775808
// opcode: c.bnez; op1:x12; op1val:-0x8000000000000000; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x12, -0x8000000000000000, 0x80, 1b, x1, 0)

inst_1:
// rs1==x14, rs1_val == 0, rs1_val==0, rs1_val == 0 and imm_val > 0
// opcode: c.bnez; op1:x14; op1val:0x0; immval:0x12
TEST_CBRANCH_OP(c.bnez, x2, x14, 0x0, 0x12, 3f, x1, 8)

inst_2:
// rs1==x13, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807, rs1_val > 0 and imm_val < 0
// opcode: c.bnez; op1:x13; op1val:0x7fffffffffffffff; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x13, 0x7fffffffffffffff, 0x6, 1b, x1, 16)

inst_3:
// rs1==x15, rs1_val == 1, 
// opcode: c.bnez; op1:x15; op1val:0x1; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x15, 0x1, 0xa, 1b, x1, 24)

inst_4:
// rs1==x10, rs1_val > 0 and imm_val > 0, rs1_val == 2305843009213693952
// opcode: c.bnez; op1:x10; op1val:0x2000000000000000; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x2000000000000000, 0x80, 3f, x1, 32)

inst_5:
// rs1==x8, rs1_val < 0 and imm_val > 0, rs1_val == -8193
// opcode: c.bnez; op1:x8; op1val:-0x2001; immval:0x20
TEST_CBRANCH_OP(c.bnez, x2, x8, -0x2001, 0x20, 3f, x1, 40)

inst_6:
// rs1==x11, rs1_val == 0 and imm_val < 0, 
// opcode: c.bnez; op1:x11; op1val:0x0; immval:0x22
TEST_CBRANCH_OP(c.bnez, x2, x11, 0x0, 0x22, 1b, x1, 48)

inst_7:
// rs1==x9, rs1_val == 2, rs1_val==2
// opcode: c.bnez; op1:x9; op1val:0x2; immval:0x20
TEST_CBRANCH_OP(c.bnez, x2, x9, 0x2, 0x20, 3f, x1, 56)

inst_8:
// rs1_val == 4, rs1_val==4
// opcode: c.bnez; op1:x10; op1val:0x4; immval:0x82
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x4, 0x82, 1b, x1, 64)

inst_9:
// rs1_val == 8, 
// opcode: c.bnez; op1:x10; op1val:0x8; immval:0x14
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x8, 0x14, 1b, x1, 72)

inst_10:
// rs1_val == 16, 
// opcode: c.bnez; op1:x10; op1val:0x10; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x10, 0xe, 1b, x1, 80)

inst_11:
// rs1_val == 32, 
// opcode: c.bnez; op1:x10; op1val:0x20; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x20, 0x80, 1b, x1, 88)

inst_12:
// rs1_val == 64, 
// opcode: c.bnez; op1:x10; op1val:0x40; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x40, 0xa, 3f, x1, 96)

inst_13:
// rs1_val == 128, 
// opcode: c.bnez; op1:x10; op1val:0x80; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x80, 0x80, 3f, x1, 104)

inst_14:
// rs1_val == 256, 
// opcode: c.bnez; op1:x10; op1val:0x100; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x100, 0x4, 3f, x1, 112)

inst_15:
// rs1_val == 512, 
// opcode: c.bnez; op1:x10; op1val:0x200; immval:0x20
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x200, 0x20, 3f, x1, 120)

inst_16:
// rs1_val == 1024, 
// opcode: c.bnez; op1:x10; op1val:0x400; immval:0x42
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x400, 0x42, 1b, x1, 128)

inst_17:
// rs1_val == 2048, 
// opcode: c.bnez; op1:x10; op1val:0x800; immval:0xac
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x800, 0xac, 1b, x1, 136)

inst_18:
// rs1_val == 4096, 
// opcode: c.bnez; op1:x10; op1val:0x1000; immval:0x82
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x1000, 0x82, 1b, x1, 144)

inst_19:
// rs1_val == 8192, 
// opcode: c.bnez; op1:x10; op1val:0x2000; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x2000, 0x10, 3f, x1, 152)

inst_20:
// rs1_val == 16384, 
// opcode: c.bnez; op1:x10; op1val:0x4000; immval:0xaa
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x4000, 0xaa, 3f, x1, 160)

inst_21:
// rs1_val == 32768, 
// opcode: c.bnez; op1:x10; op1val:0x8000; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x8000, 0xa, 3f, x1, 168)

inst_22:
// rs1_val == 65536, 
// opcode: c.bnez; op1:x10; op1val:0x10000; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x10000, 0x80, 1b, x1, 176)

inst_23:
// rs1_val == 131072, 
// opcode: c.bnez; op1:x10; op1val:0x20000; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x20000, 0x10, 3f, x1, 184)

inst_24:
// rs1_val == 262144, 
// opcode: c.bnez; op1:x10; op1val:0x40000; immval:0x22
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x40000, 0x22, 1b, x1, 192)

inst_25:
// rs1_val == 524288, 
// opcode: c.bnez; op1:x10; op1val:0x80000; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x80000, 0x10, 1b, x1, 200)

inst_26:
// rs1_val == 1048576, 
// opcode: c.bnez; op1:x10; op1val:0x100000; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x100000, 0x7e, 3f, x1, 208)

inst_27:
// rs1_val == 2097152, 
// opcode: c.bnez; op1:x10; op1val:0x200000; immval:0x8
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x200000, 0x8, 1b, x1, 216)

inst_28:
// rs1_val == 4194304, 
// opcode: c.bnez; op1:x10; op1val:0x400000; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x400000, 0x10, 3f, x1, 224)

inst_29:
// rs1_val == 8388608, 
// opcode: c.bnez; op1:x10; op1val:0x800000; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x800000, 0x4, 3f, x1, 232)

inst_30:
// rs1_val == 16777216, 
// opcode: c.bnez; op1:x10; op1val:0x1000000; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x1000000, 0x7e, 3f, x1, 240)

inst_31:
// rs1_val == 33554432, 
// opcode: c.bnez; op1:x10; op1val:0x2000000; immval:0x82
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x2000000, 0x82, 1b, x1, 248)

inst_32:
// rs1_val == 67108864, 
// opcode: c.bnez; op1:x10; op1val:0x4000000; immval:0x8
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x4000000, 0x8, 3f, x1, 256)

inst_33:
// rs1_val == 134217728, 
// opcode: c.bnez; op1:x10; op1val:0x8000000; immval:0x12
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x8000000, 0x12, 1b, x1, 264)

inst_34:
// rs1_val == 268435456, 
// opcode: c.bnez; op1:x10; op1val:0x10000000; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x10000000, 0x6, 1b, x1, 272)

inst_35:
// rs1_val == 536870912, 
// opcode: c.bnez; op1:x10; op1val:0x20000000; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x20000000, 0xe, 1b, x1, 280)

inst_36:
// rs1_val == 1073741824, 
// opcode: c.bnez; op1:x10; op1val:0x40000000; immval:0x8
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x40000000, 0x8, 1b, x1, 288)

inst_37:
// rs1_val == 2147483648, 
// opcode: c.bnez; op1:x10; op1val:0x80000000; immval:0x8
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x80000000, 0x8, 1b, x1, 296)

inst_38:
// rs1_val == 4294967296, 
// opcode: c.bnez; op1:x10; op1val:0x100000000; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x100000000, 0xa, 1b, x1, 304)

inst_39:
// rs1_val == 8589934592, 
// opcode: c.bnez; op1:x10; op1val:0x200000000; immval:0xc
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x200000000, 0xc, 1b, x1, 312)

inst_40:
// rs1_val == 17179869184, 
// opcode: c.bnez; op1:x10; op1val:0x400000000; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x400000000, 0x10, 1b, x1, 320)

inst_41:
// rs1_val == 34359738368, 
// opcode: c.bnez; op1:x10; op1val:0x800000000; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x800000000, 0xe, 3f, x1, 328)

inst_42:
// rs1_val == 68719476736, 
// opcode: c.bnez; op1:x10; op1val:0x1000000000; immval:0x42
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x1000000000, 0x42, 1b, x1, 336)

inst_43:
// rs1_val == 137438953472, 
// opcode: c.bnez; op1:x10; op1val:0x2000000000; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x2000000000, 0xe, 1b, x1, 344)

inst_44:
// rs1_val == 274877906944, 
// opcode: c.bnez; op1:x10; op1val:0x4000000000; immval:0x8
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x4000000000, 0x8, 3f, x1, 352)

inst_45:
// rs1_val == 549755813888, 
// opcode: c.bnez; op1:x10; op1val:0x8000000000; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x8000000000, 0xe, 1b, x1, 360)

inst_46:
// rs1_val == 1099511627776, 
// opcode: c.bnez; op1:x10; op1val:0x10000000000; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x10000000000, 0xe, 1b, x1, 368)

inst_47:
// rs1_val == 2199023255552, 
// opcode: c.bnez; op1:x10; op1val:0x20000000000; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x20000000000, 0x80, 1b, x1, 376)

inst_48:
// rs1_val == 4398046511104, 
// opcode: c.bnez; op1:x10; op1val:0x40000000000; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x40000000000, 0x4, 3f, x1, 384)

inst_49:
// rs1_val == 8796093022208, 
// opcode: c.bnez; op1:x10; op1val:0x80000000000; immval:0x12
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x80000000000, 0x12, 3f, x1, 392)

inst_50:
// rs1_val == 17592186044416, 
// opcode: c.bnez; op1:x10; op1val:0x100000000000; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x100000000000, 0x80, 3f, x1, 400)

inst_51:
// rs1_val == 35184372088832, 
// opcode: c.bnez; op1:x10; op1val:0x200000000000; immval:0xc
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x200000000000, 0xc, 1b, x1, 408)

inst_52:
// rs1_val == 70368744177664, 
// opcode: c.bnez; op1:x10; op1val:0x400000000000; immval:0xc
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x400000000000, 0xc, 1b, x1, 416)

inst_53:
// rs1_val == 140737488355328, 
// opcode: c.bnez; op1:x10; op1val:0x800000000000; immval:0x12
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x800000000000, 0x12, 1b, x1, 424)

inst_54:
// rs1_val == 281474976710656, 
// opcode: c.bnez; op1:x10; op1val:0x1000000000000; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x1000000000000, 0x80, 3f, x1, 432)

inst_55:
// rs1_val == 562949953421312, 
// opcode: c.bnez; op1:x10; op1val:0x2000000000000; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x2000000000000, 0x80, 1b, x1, 440)

inst_56:
// rs1_val == 1125899906842624, 
// opcode: c.bnez; op1:x10; op1val:0x4000000000000; immval:0x14
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x4000000000000, 0x14, 1b, x1, 448)

inst_57:
// rs1_val == 2251799813685248, 
// opcode: c.bnez; op1:x10; op1val:0x8000000000000; immval:0x8
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x8000000000000, 0x8, 3f, x1, 456)

inst_58:
// rs1_val == 4503599627370496, 
// opcode: c.bnez; op1:x10; op1val:0x10000000000000; immval:0x42
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x10000000000000, 0x42, 1b, x1, 464)

inst_59:
// rs1_val == 9007199254740992, 
// opcode: c.bnez; op1:x10; op1val:0x20000000000000; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x20000000000000, 0x7e, 3f, x1, 472)

inst_60:
// rs1_val == 18014398509481984, 
// opcode: c.bnez; op1:x10; op1val:0x40000000000000; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x40000000000000, 0xe, 3f, x1, 480)

inst_61:
// rs1_val == 36028797018963968, 
// opcode: c.bnez; op1:x10; op1val:0x80000000000000; immval:0xaa
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x80000000000000, 0xaa, 3f, x1, 488)

inst_62:
// rs1_val == 72057594037927936, 
// opcode: c.bnez; op1:x10; op1val:0x100000000000000; immval:0x22
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x100000000000000, 0x22, 1b, x1, 496)

inst_63:
// rs1_val == 144115188075855872, 
// opcode: c.bnez; op1:x10; op1val:0x200000000000000; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x200000000000000, 0x4, 3f, x1, 504)

inst_64:
// rs1_val == 288230376151711744, 
// opcode: c.bnez; op1:x10; op1val:0x400000000000000; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x400000000000000, 0x7e, 3f, x1, 512)

inst_65:
// rs1_val == 576460752303423488, 
// opcode: c.bnez; op1:x10; op1val:0x800000000000000; immval:0x20
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x800000000000000, 0x20, 3f, x1, 520)

inst_66:
// rs1_val == 1152921504606846976, 
// opcode: c.bnez; op1:x10; op1val:0x1000000000000000; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x1000000000000000, 0x6, 1b, x1, 528)

inst_67:
// rs1_val == 4611686018427387904, 
// opcode: c.bnez; op1:x10; op1val:0x4000000000000000; immval:0x20
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x4000000000000000, 0x20, 3f, x1, 536)

inst_68:
// rs1_val == -2, 
// opcode: c.bnez; op1:x10; op1val:-0x2; immval:0x22
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x2, 0x22, 1b, x1, 544)

inst_69:
// rs1_val == -3, 
// opcode: c.bnez; op1:x10; op1val:-0x3; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x3, 0x10, 3f, x1, 552)

inst_70:
// rs1_val == -5, 
// opcode: c.bnez; op1:x10; op1val:-0x5; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x5, 0x80, 1b, x1, 560)

inst_71:
// rs1_val == -9, 
// opcode: c.bnez; op1:x10; op1val:-0x9; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x9, 0x10, 1b, x1, 568)

inst_72:
// rs1_val == -17, 
// opcode: c.bnez; op1:x10; op1val:-0x11; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x11, 0x10, 1b, x1, 576)

inst_73:
// rs1_val == -33, 
// opcode: c.bnez; op1:x10; op1val:-0x21; immval:0x42
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x21, 0x42, 1b, x1, 584)

inst_74:
// rs1_val == -65, 
// opcode: c.bnez; op1:x10; op1val:-0x41; immval:0xaa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x41, 0xaa, 3f, x1, 592)

inst_75:
// rs1_val == -129, 
// opcode: c.bnez; op1:x10; op1val:-0x81; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x81, 0x4, 3f, x1, 600)

inst_76:
// rs1_val == -257, 
// opcode: c.bnez; op1:x10; op1val:-0x101; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x101, 0x80, 1b, x1, 608)

inst_77:
// rs1_val == -513, 
// opcode: c.bnez; op1:x10; op1val:-0x201; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x201, 0x7e, 3f, x1, 616)

inst_78:
// rs1_val == -1025, 
// opcode: c.bnez; op1:x10; op1val:-0x401; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x401, 0x6, 3f, x1, 624)

inst_79:
// rs1_val == -2049, 
// opcode: c.bnez; op1:x10; op1val:-0x801; immval:0xaa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x801, 0xaa, 3f, x1, 632)

inst_80:
// rs1_val == -4097, 
// opcode: c.bnez; op1:x10; op1val:-0x1001; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x1001, 0xa, 3f, x1, 640)

inst_81:
// rs1_val == -16385, 
// opcode: c.bnez; op1:x10; op1val:-0x4001; immval:0x22
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x4001, 0x22, 1b, x1, 648)

inst_82:
// rs1_val == -32769, 
// opcode: c.bnez; op1:x10; op1val:-0x8001; immval:0xc
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x8001, 0xc, 3f, x1, 656)

inst_83:
// rs1_val == -65537, 
// opcode: c.bnez; op1:x10; op1val:-0x10001; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x10001, 0xa, 1b, x1, 664)

inst_84:
// rs1_val == -131073, 
// opcode: c.bnez; op1:x10; op1val:-0x20001; immval:0xaa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x20001, 0xaa, 3f, x1, 672)

inst_85:
// rs1_val == -262145, 
// opcode: c.bnez; op1:x10; op1val:-0x40001; immval:0x12
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x40001, 0x12, 1b, x1, 680)

inst_86:
// rs1_val == -524289, 
// opcode: c.bnez; op1:x10; op1val:-0x80001; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x80001, 0x4, 3f, x1, 688)

inst_87:
// rs1_val == -1048577, 
// opcode: c.bnez; op1:x10; op1val:-0x100001; immval:0xc
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x100001, 0xc, 1b, x1, 696)

inst_88:
// rs1_val == -36028797018963969, 
// opcode: c.bnez; op1:x10; op1val:-0x80000000000001; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x80000000000001, 0x80, 1b, x1, 704)

inst_89:
// rs1_val == -72057594037927937, 
// opcode: c.bnez; op1:x10; op1val:-0x100000000000001; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x100000000000001, 0x6, 1b, x1, 712)

inst_90:
// rs1_val == -144115188075855873, 
// opcode: c.bnez; op1:x10; op1val:-0x200000000000001; immval:0x82
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x200000000000001, 0x82, 1b, x1, 720)

inst_91:
// rs1_val == -288230376151711745, 
// opcode: c.bnez; op1:x10; op1val:-0x400000000000001; immval:0xac
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x400000000000001, 0xac, 1b, x1, 728)

inst_92:
// rs1_val == -576460752303423489, 
// opcode: c.bnez; op1:x10; op1val:-0x800000000000001; immval:0x14
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x800000000000001, 0x14, 1b, x1, 736)

inst_93:
// rs1_val == -1152921504606846977, 
// opcode: c.bnez; op1:x10; op1val:-0x1000000000000001; immval:0x22
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x1000000000000001, 0x22, 1b, x1, 744)

inst_94:
// rs1_val == -2305843009213693953, 
// opcode: c.bnez; op1:x10; op1val:-0x2000000000000001; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x2000000000000001, 0xa, 3f, x1, 752)

inst_95:
// rs1_val == -4611686018427387905, 
// opcode: c.bnez; op1:x10; op1val:-0x4000000000000001; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x4000000000000001, 0xa, 1b, x1, 760)

inst_96:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode: c.bnez; op1:x10; op1val:0x5555555555555555; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x5555555555555555, 0x6, 1b, x1, 768)

inst_97:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode: c.bnez; op1:x10; op1val:-0x5555555555555556; immval:0x8
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x5555555555555556, 0x8, 1b, x1, 776)

inst_98:
// rs1_val==3, 
// opcode: c.bnez; op1:x10; op1val:0x3; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x3, 0xa, 1b, x1, 784)

inst_99:
// rs1_val==5, 
// opcode: c.bnez; op1:x10; op1val:0x5; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x5, 0xa, 1b, x1, 792)

inst_100:
// rs1_val==3689348814741910323, 
// opcode: c.bnez; op1:x10; op1val:0x3333333333333333; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x3333333333333333, 0x10, 1b, x1, 800)

inst_101:
// rs1_val==7378697629483820646, 
// opcode: c.bnez; op1:x10; op1val:0x6666666666666666; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x6666666666666666, 0x80, 1b, x1, 808)

inst_102:
// rs1_val==-3037000499, 
// opcode: c.bnez; op1:x10; op1val:-0xb504f333; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, -0xb504f333, 0x80, 3f, x1, 816)

inst_103:
// rs1_val==3037000499, 
// opcode: c.bnez; op1:x10; op1val:0xb504f333; immval:0x14
TEST_CBRANCH_OP(c.bnez, x2, x10, 0xb504f333, 0x14, 1b, x1, 824)

inst_104:
// rs1_val==6148914691236517204, 
// opcode: c.bnez; op1:x10; op1val:0x5555555555555554; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x5555555555555554, 0x6, 3f, x1, 832)

inst_105:
// rs1_val==3689348814741910322, 
// opcode: c.bnez; op1:x10; op1val:0x3333333333333332; immval:0x80
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x3333333333333332, 0x80, 1b, x1, 840)

inst_106:
// rs1_val==7378697629483820645, 
// opcode: c.bnez; op1:x10; op1val:0x6666666666666665; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x6666666666666665, 0x6, 3f, x1, 848)

inst_107:
// rs1_val==3037000498, 
// opcode: c.bnez; op1:x10; op1val:0xb504f332; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, 0xb504f332, 0x6, 1b, x1, 856)

inst_108:
// rs1_val==6148914691236517206, 
// opcode: c.bnez; op1:x10; op1val:0x5555555555555556; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x5555555555555556, 0xe, 3f, x1, 864)

inst_109:
// rs1_val==-6148914691236517205, 
// opcode: c.bnez; op1:x10; op1val:-0x5555555555555555; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x5555555555555555, 0xa, 1b, x1, 872)

inst_110:
// rs1_val==6, 
// opcode: c.bnez; op1:x10; op1val:0x6; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x6, 0x6, 1b, x1, 880)

inst_111:
// rs1_val==3689348814741910324, 
// opcode: c.bnez; op1:x10; op1val:0x3333333333333334; immval:0x14
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x3333333333333334, 0x14, 1b, x1, 888)

inst_112:
// rs1_val==7378697629483820647, 
// opcode: c.bnez; op1:x10; op1val:0x6666666666666667; immval:0xc
TEST_CBRANCH_OP(c.bnez, x2, x10, 0x6666666666666667, 0xc, 1b, x1, 896)

inst_113:
// rs1_val==-3037000498, 
// opcode: c.bnez; op1:x10; op1val:-0xb504f332; immval:0x8
TEST_CBRANCH_OP(c.bnez, x2, x10, -0xb504f332, 0x8, 3f, x1, 904)

inst_114:
// rs1_val==3037000500, 
// opcode: c.bnez; op1:x10; op1val:0xb504f334; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, 0xb504f334, 0x7e, 3f, x1, 912)

inst_115:
// rs1_val == -2097153, 
// opcode: c.bnez; op1:x10; op1val:-0x200001; immval:0xe
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x200001, 0xe, 1b, x1, 920)

inst_116:
// rs1_val == -4194305, 
// opcode: c.bnez; op1:x10; op1val:-0x400001; immval:0xaa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x400001, 0xaa, 3f, x1, 928)

inst_117:
// rs1_val == -8388609, 
// opcode: c.bnez; op1:x10; op1val:-0x800001; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x800001, 0x10, 1b, x1, 936)

inst_118:
// rs1_val == -16777217, 
// opcode: c.bnez; op1:x10; op1val:-0x1000001; immval:0xc
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x1000001, 0xc, 1b, x1, 944)

inst_119:
// rs1_val == -33554433, 
// opcode: c.bnez; op1:x10; op1val:-0x2000001; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x2000001, 0x4, 3f, x1, 952)

inst_120:
// rs1_val == -67108865, 
// opcode: c.bnez; op1:x10; op1val:-0x4000001; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x4000001, 0x6, 3f, x1, 960)

inst_121:
// rs1_val == -134217729, 
// opcode: c.bnez; op1:x10; op1val:-0x8000001; immval:0x22
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x8000001, 0x22, 1b, x1, 968)

inst_122:
// rs1_val == -268435457, 
// opcode: c.bnez; op1:x10; op1val:-0x10000001; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x10000001, 0x6, 1b, x1, 976)

inst_123:
// rs1_val == -536870913, 
// opcode: c.bnez; op1:x10; op1val:-0x20000001; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x20000001, 0x10, 1b, x1, 984)

inst_124:
// rs1_val == -1073741825, 
// opcode: c.bnez; op1:x10; op1val:-0x40000001; immval:0x40
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x40000001, 0x40, 3f, x1, 992)

inst_125:
// rs1_val == -2147483649, 
// opcode: c.bnez; op1:x10; op1val:-0x80000001; immval:0x42
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x80000001, 0x42, 1b, x1, 1000)

inst_126:
// rs1_val == -4294967297, 
// opcode: c.bnez; op1:x10; op1val:-0x100000001; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x100000001, 0x4, 3f, x1, 1008)

inst_127:
// rs1_val == -8589934593, 
// opcode: c.bnez; op1:x10; op1val:-0x200000001; immval:0x12
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x200000001, 0x12, 3f, x1, 1016)

inst_128:
// rs1_val == -17179869185, 
// opcode: c.bnez; op1:x10; op1val:-0x400000001; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x400000001, 0xa, 3f, x1, 1024)

inst_129:
// rs1_val == -34359738369, 
// opcode: c.bnez; op1:x10; op1val:-0x800000001; immval:0x14
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x800000001, 0x14, 1b, x1, 1032)

inst_130:
// rs1_val == -68719476737, 
// opcode: c.bnez; op1:x10; op1val:-0x1000000001; immval:0x42
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x1000000001, 0x42, 1b, x1, 1040)

inst_131:
// rs1_val == -137438953473, 
// opcode: c.bnez; op1:x10; op1val:-0x2000000001; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x2000000001, 0x7e, 3f, x1, 1048)

inst_132:
// rs1_val == -274877906945, 
// opcode: c.bnez; op1:x10; op1val:-0x4000000001; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x4000000001, 0x4, 3f, x1, 1056)

inst_133:
// rs1_val == -549755813889, 
// opcode: c.bnez; op1:x10; op1val:-0x8000000001; immval:0x12
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x8000000001, 0x12, 1b, x1, 1064)

inst_134:
// rs1_val == -1099511627777, 
// opcode: c.bnez; op1:x10; op1val:-0x10000000001; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x10000000001, 0x7e, 3f, x1, 1072)

inst_135:
// rs1_val == -2199023255553, 
// opcode: c.bnez; op1:x10; op1val:-0x20000000001; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x20000000001, 0xa, 3f, x1, 1080)

inst_136:
// rs1_val == -4398046511105, 
// opcode: c.bnez; op1:x10; op1val:-0x40000000001; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x40000000001, 0x10, 3f, x1, 1088)

inst_137:
// rs1_val == -8796093022209, 
// opcode: c.bnez; op1:x10; op1val:-0x80000000001; immval:0x40
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x80000000001, 0x40, 3f, x1, 1096)

inst_138:
// rs1_val == -17592186044417, 
// opcode: c.bnez; op1:x10; op1val:-0x100000000001; immval:0x10
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x100000000001, 0x10, 1b, x1, 1104)

inst_139:
// rs1_val == -35184372088833, 
// opcode: c.bnez; op1:x10; op1val:-0x200000000001; immval:0x6
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x200000000001, 0x6, 3f, x1, 1112)

inst_140:
// rs1_val == -70368744177665, 
// opcode: c.bnez; op1:x10; op1val:-0x400000000001; immval:0x42
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x400000000001, 0x42, 1b, x1, 1120)

inst_141:
// rs1_val == -140737488355329, 
// opcode: c.bnez; op1:x10; op1val:-0x800000000001; immval:0xc
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x800000000001, 0xc, 1b, x1, 1128)

inst_142:
// rs1_val == -281474976710657, 
// opcode: c.bnez; op1:x10; op1val:-0x1000000000001; immval:0xac
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x1000000000001, 0xac, 1b, x1, 1136)

inst_143:
// rs1_val == -562949953421313, 
// opcode: c.bnez; op1:x10; op1val:-0x2000000000001; immval:0x7e
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x2000000000001, 0x7e, 3f, x1, 1144)

inst_144:
// rs1_val == -1125899906842625, 
// opcode: c.bnez; op1:x10; op1val:-0x4000000000001; immval:0x82
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x4000000000001, 0x82, 1b, x1, 1152)

inst_145:
// rs1_val == -2251799813685249, 
// opcode: c.bnez; op1:x10; op1val:-0x8000000000001; immval:0xa
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x8000000000001, 0xa, 3f, x1, 1160)

inst_146:
// rs1_val == -4503599627370497, 
// opcode: c.bnez; op1:x10; op1val:-0x10000000000001; immval:0x12
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x10000000000001, 0x12, 3f, x1, 1168)

inst_147:
// rs1_val == -9007199254740993, 
// opcode: c.bnez; op1:x10; op1val:-0x20000000000001; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x20000000000001, 0x4, 3f, x1, 1176)

inst_148:
// rs1_val == -18014398509481985, 
// opcode: c.bnez; op1:x10; op1val:-0x40000000000001; immval:0x4
TEST_CBRANCH_OP(c.bnez, x2, x10, -0x40000000000001, 0x4, 3f, x1, 1184)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 149*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
