
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 04:49:48 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64ic.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the c.mv instruction of the RISC-V C extension for the cmv covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IC")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*C.*);def TEST_CASE_1=True;",cmv)

RVTEST_SIGBASE( x13,signature_x13_1)

inst_0:
// rs2 != rd and rs2 != 0, rd==x11, rs2==x12, rs2_val == (-2**(xlen-1)), rs2_val == -9223372036854775808
// opcode: c.mv; op2:x12; dest:x11; op2val:-0x8000000000000000
TEST_CMV_OP( c.mv, x11, x12, -0x8000000000000000, -0x8000000000000000, x13, 0, x10)

inst_1:
// rs2 == rd and rs2 != 0, rd==x2, rs2==x2, rs2_val == 0, rs2_val==0
// opcode: c.mv; op2:x2; dest:x2; op2val:0x0
TEST_CMV_OP( c.mv, x2, x2, 0x0, 0x0, x13, 8, x10)

inst_2:
// rd==x19, rs2==x7, rs2_val == (2**(xlen-1)-1), rs2_val == 9223372036854775807
// opcode: c.mv; op2:x7; dest:x19; op2val:0x7fffffffffffffff
TEST_CMV_OP( c.mv, x19, x7, 0x7fffffffffffffff, 0x7fffffffffffffff, x13, 16, x10)

inst_3:
// rd==x6, rs2==x17, rs2_val == 1, 
// opcode: c.mv; op2:x17; dest:x6; op2val:0x1
TEST_CMV_OP( c.mv, x6, x17, 0x1, 0x1, x13, 24, x10)

inst_4:
// rd==x14, rs2==x26, rs2_val == 2, rs2_val==2
// opcode: c.mv; op2:x26; dest:x14; op2val:0x2
TEST_CMV_OP( c.mv, x14, x26, 0x2, 0x2, x13, 32, x10)

inst_5:
// rd==x21, rs2==x5, rs2_val == 4, rs2_val==4
// opcode: c.mv; op2:x5; dest:x21; op2val:0x4
TEST_CMV_OP( c.mv, x21, x5, 0x4, 0x4, x13, 40, x10)

inst_6:
// rd==x27, rs2==x1, rs2_val == 8, 
// opcode: c.mv; op2:x1; dest:x27; op2val:0x8
TEST_CMV_OP( c.mv, x27, x1, 0x8, 0x8, x13, 48, x10)

inst_7:
// rd==x17, rs2==x9, rs2_val == 16, 
// opcode: c.mv; op2:x9; dest:x17; op2val:0x10
TEST_CMV_OP( c.mv, x17, x9, 0x10, 0x10, x13, 56, x10)

inst_8:
// rd==x0, rs2==x18, rs2_val == 32, 
// opcode: c.mv; op2:x18; dest:x0; op2val:0x20
TEST_CMV_OP( c.mv, x0, x18, 0, 0x20, x13, 64, x10)

inst_9:
// rd==x9, rs2==x22, rs2_val == 64, 
// opcode: c.mv; op2:x22; dest:x9; op2val:0x40
TEST_CMV_OP( c.mv, x9, x22, 0x40, 0x40, x13, 72, x10)

inst_10:
// rd==x4, rs2==x8, rs2_val == 128, 
// opcode: c.mv; op2:x8; dest:x4; op2val:0x80
TEST_CMV_OP( c.mv, x4, x8, 0x80, 0x80, x13, 80, x10)

inst_11:
// rd==x3, rs2==x24, rs2_val == 256, 
// opcode: c.mv; op2:x24; dest:x3; op2val:0x100
TEST_CMV_OP( c.mv, x3, x24, 0x100, 0x100, x13, 88, x10)

inst_12:
// rd==x20, rs2==x21, rs2_val == 512, 
// opcode: c.mv; op2:x21; dest:x20; op2val:0x200
TEST_CMV_OP( c.mv, x20, x21, 0x200, 0x200, x13, 96, x10)

inst_13:
// rd==x12, rs2==x23, rs2_val == 1024, 
// opcode: c.mv; op2:x23; dest:x12; op2val:0x400
TEST_CMV_OP( c.mv, x12, x23, 0x400, 0x400, x13, 104, x10)

inst_14:
// rd==x22, rs2==x31, rs2_val == 2048, 
// opcode: c.mv; op2:x31; dest:x22; op2val:0x800
TEST_CMV_OP( c.mv, x22, x31, 0x800, 0x800, x13, 112, x10)

inst_15:
// rd==x18, rs2==x3, rs2_val == 4096, 
// opcode: c.mv; op2:x3; dest:x18; op2val:0x1000
TEST_CMV_OP( c.mv, x18, x3, 0x1000, 0x1000, x13, 120, x10)

inst_16:
// rd==x7, rs2==x4, rs2_val == 8192, 
// opcode: c.mv; op2:x4; dest:x7; op2val:0x2000
TEST_CMV_OP( c.mv, x7, x4, 0x2000, 0x2000, x13, 128, x10)

inst_17:
// rd==x8, rs2==x25, rs2_val == 16384, 
// opcode: c.mv; op2:x25; dest:x8; op2val:0x4000
TEST_CMV_OP( c.mv, x8, x25, 0x4000, 0x4000, x13, 136, x10)

inst_18:
// rd==x15, rs2==x14, rs2_val == 32768, 
// opcode: c.mv; op2:x14; dest:x15; op2val:0x8000
TEST_CMV_OP( c.mv, x15, x14, 0x8000, 0x8000, x13, 144, x10)

inst_19:
// rd==x31, rs2==x29, rs2_val == 65536, 
// opcode: c.mv; op2:x29; dest:x31; op2val:0x10000
TEST_CMV_OP( c.mv, x31, x29, 0x10000, 0x10000, x13, 152, x10)

inst_20:
// rd==x29, rs2==x28, rs2_val == 131072, 
// opcode: c.mv; op2:x28; dest:x29; op2val:0x20000
TEST_CMV_OP( c.mv, x29, x28, 0x20000, 0x20000, x13, 160, x10)

inst_21:
// rd==x10, rs2==x16, rs2_val == 262144, 
// opcode: c.mv; op2:x16; dest:x10; op2val:0x40000
TEST_CMV_OP( c.mv, x10, x16, 0x40000, 0x40000, x13, 168, x3)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_22:
// rd==x25, rs2==x20, rs2_val == 524288, 
// opcode: c.mv; op2:x20; dest:x25; op2val:0x80000
TEST_CMV_OP( c.mv, x25, x20, 0x80000, 0x80000, x2, 0, x3)

inst_23:
// rd==x5, rs2==x13, rs2_val == 1048576, 
// opcode: c.mv; op2:x13; dest:x5; op2val:0x100000
TEST_CMV_OP( c.mv, x5, x13, 0x100000, 0x100000, x2, 8, x3)

inst_24:
// rd==x1, rs2==x6, rs2_val == 2097152, 
// opcode: c.mv; op2:x6; dest:x1; op2val:0x200000
TEST_CMV_OP( c.mv, x1, x6, 0x200000, 0x200000, x2, 16, x3)

inst_25:
// rd==x26, rs2==x15, rs2_val == 4194304, 
// opcode: c.mv; op2:x15; dest:x26; op2val:0x400000
TEST_CMV_OP( c.mv, x26, x15, 0x400000, 0x400000, x2, 24, x3)

inst_26:
// rd==x24, rs2==x10, rs2_val == 8388608, 
// opcode: c.mv; op2:x10; dest:x24; op2val:0x800000
TEST_CMV_OP( c.mv, x24, x10, 0x800000, 0x800000, x2, 32, x3)

inst_27:
// rd==x28, rs2==x30, rs2_val == 16777216, 
// opcode: c.mv; op2:x30; dest:x28; op2val:0x1000000
TEST_CMV_OP( c.mv, x28, x30, 0x1000000, 0x1000000, x2, 40, x3)

inst_28:
// rd==x23, rs2==x19, rs2_val == 33554432, 
// opcode: c.mv; op2:x19; dest:x23; op2val:0x2000000
TEST_CMV_OP( c.mv, x23, x19, 0x2000000, 0x2000000, x2, 48, x3)

inst_29:
// rd==x30, rs2==x11, rs2_val == 67108864, 
// opcode: c.mv; op2:x11; dest:x30; op2val:0x4000000
TEST_CMV_OP( c.mv, x30, x11, 0x4000000, 0x4000000, x2, 56, x3)

inst_30:
// rd==x13, rs2==x27, rs2_val == 134217728, 
// opcode: c.mv; op2:x27; dest:x13; op2val:0x8000000
TEST_CMV_OP( c.mv, x13, x27, 0x8000000, 0x8000000, x2, 64, x3)

inst_31:
// rd==x16, rs2_val == 268435456, 
// opcode: c.mv; op2:x28; dest:x16; op2val:0x10000000
TEST_CMV_OP( c.mv, x16, x28, 0x10000000, 0x10000000, x2, 72, x3)

inst_32:
// rs2_val == 536870912, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x20000000
TEST_CMV_OP( c.mv, x10, x11, 0x20000000, 0x20000000, x2, 80, x3)

inst_33:
// rs2_val == 1073741824, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x40000000
TEST_CMV_OP( c.mv, x10, x11, 0x40000000, 0x40000000, x2, 88, x3)

inst_34:
// rs2_val == 2147483648, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x80000000
TEST_CMV_OP( c.mv, x10, x11, 0x80000000, 0x80000000, x2, 96, x3)

inst_35:
// rs2_val == 4294967296, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x100000000
TEST_CMV_OP( c.mv, x10, x11, 0x100000000, 0x100000000, x2, 104, x3)

inst_36:
// rs2_val == 8589934592, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x200000000
TEST_CMV_OP( c.mv, x10, x11, 0x200000000, 0x200000000, x2, 112, x3)

inst_37:
// rs2_val == 17179869184, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x400000000
TEST_CMV_OP( c.mv, x10, x11, 0x400000000, 0x400000000, x2, 120, x3)

inst_38:
// rs2_val == 34359738368, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x800000000
TEST_CMV_OP( c.mv, x10, x11, 0x800000000, 0x800000000, x2, 128, x3)

inst_39:
// rs2_val == 68719476736, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x1000000000
TEST_CMV_OP( c.mv, x10, x11, 0x1000000000, 0x1000000000, x2, 136, x3)

inst_40:
// rs2_val == 137438953472, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x2000000000
TEST_CMV_OP( c.mv, x10, x11, 0x2000000000, 0x2000000000, x2, 144, x3)

inst_41:
// rs2_val == 274877906944, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x4000000000
TEST_CMV_OP( c.mv, x10, x11, 0x4000000000, 0x4000000000, x2, 152, x3)

inst_42:
// rs2_val == 549755813888, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x8000000000
TEST_CMV_OP( c.mv, x10, x11, 0x8000000000, 0x8000000000, x2, 160, x3)

inst_43:
// rs2_val == 1099511627776, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x10000000000
TEST_CMV_OP( c.mv, x10, x11, 0x10000000000, 0x10000000000, x2, 168, x3)

inst_44:
// rs2_val == 2199023255552, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x20000000000
TEST_CMV_OP( c.mv, x10, x11, 0x20000000000, 0x20000000000, x2, 176, x3)

inst_45:
// rs2_val == 4398046511104, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x40000000000
TEST_CMV_OP( c.mv, x10, x11, 0x40000000000, 0x40000000000, x2, 184, x3)

inst_46:
// rs2_val == 8796093022208, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x80000000000
TEST_CMV_OP( c.mv, x10, x11, 0x80000000000, 0x80000000000, x2, 192, x3)

inst_47:
// rs2_val == 17592186044416, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x100000000000
TEST_CMV_OP( c.mv, x10, x11, 0x100000000000, 0x100000000000, x2, 200, x3)

inst_48:
// rs2_val == 35184372088832, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x200000000000
TEST_CMV_OP( c.mv, x10, x11, 0x200000000000, 0x200000000000, x2, 208, x3)

inst_49:
// rs2_val == 70368744177664, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x400000000000
TEST_CMV_OP( c.mv, x10, x11, 0x400000000000, 0x400000000000, x2, 216, x3)

inst_50:
// rs2_val == 140737488355328, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x800000000000
TEST_CMV_OP( c.mv, x10, x11, 0x800000000000, 0x800000000000, x2, 224, x3)

inst_51:
// rs2_val == 281474976710656, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x1000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x1000000000000, 0x1000000000000, x2, 232, x3)

inst_52:
// rs2_val == 562949953421312, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x2000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x2000000000000, 0x2000000000000, x2, 240, x3)

inst_53:
// rs2_val == 1125899906842624, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x4000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x4000000000000, 0x4000000000000, x2, 248, x3)

inst_54:
// rs2_val == 2251799813685248, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x8000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x8000000000000, 0x8000000000000, x2, 256, x3)

inst_55:
// rs2_val == 4503599627370496, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x10000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x10000000000000, 0x10000000000000, x2, 264, x3)

inst_56:
// rs2_val == 9007199254740992, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x20000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x20000000000000, 0x20000000000000, x2, 272, x3)

inst_57:
// rs2_val == 18014398509481984, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x40000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x40000000000000, 0x40000000000000, x2, 280, x3)

inst_58:
// rs2_val == 36028797018963968, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x80000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x80000000000000, 0x80000000000000, x2, 288, x3)

inst_59:
// rs2_val == 72057594037927936, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x100000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x100000000000000, 0x100000000000000, x2, 296, x3)

inst_60:
// rs2_val == 144115188075855872, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x200000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x200000000000000, 0x200000000000000, x2, 304, x3)

inst_61:
// rs2_val == 288230376151711744, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x400000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x400000000000000, 0x400000000000000, x2, 312, x3)

inst_62:
// rs2_val == 576460752303423488, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x800000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x800000000000000, 0x800000000000000, x2, 320, x3)

inst_63:
// rs2_val == 1152921504606846976, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x1000000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x1000000000000000, 0x1000000000000000, x2, 328, x3)

inst_64:
// rs2_val == 2305843009213693952, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x2000000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x2000000000000000, 0x2000000000000000, x2, 336, x3)

inst_65:
// rs2_val == 4611686018427387904, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x4000000000000000
TEST_CMV_OP( c.mv, x10, x11, 0x4000000000000000, 0x4000000000000000, x2, 344, x3)

inst_66:
// rs2_val == -2, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x2
TEST_CMV_OP( c.mv, x10, x11, -0x2, -0x2, x2, 352, x3)

inst_67:
// rs2_val == -3, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x3
TEST_CMV_OP( c.mv, x10, x11, -0x3, -0x3, x2, 360, x3)

inst_68:
// rs2_val == -5, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x5
TEST_CMV_OP( c.mv, x10, x11, -0x5, -0x5, x2, 368, x3)

inst_69:
// rs2_val == -9, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x9
TEST_CMV_OP( c.mv, x10, x11, -0x9, -0x9, x2, 376, x3)

inst_70:
// rs2_val == -17, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x11
TEST_CMV_OP( c.mv, x10, x11, -0x11, -0x11, x2, 384, x3)

inst_71:
// rs2_val == -33, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x21
TEST_CMV_OP( c.mv, x10, x11, -0x21, -0x21, x2, 392, x3)

inst_72:
// rs2_val == -65, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x41
TEST_CMV_OP( c.mv, x10, x11, -0x41, -0x41, x2, 400, x3)

inst_73:
// rs2_val == -129, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x81
TEST_CMV_OP( c.mv, x10, x11, -0x81, -0x81, x2, 408, x3)

inst_74:
// rs2_val == -257, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x101
TEST_CMV_OP( c.mv, x10, x11, -0x101, -0x101, x2, 416, x3)

inst_75:
// rs2_val == -513, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x201
TEST_CMV_OP( c.mv, x10, x11, -0x201, -0x201, x2, 424, x3)

inst_76:
// rs2_val == -1025, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x401
TEST_CMV_OP( c.mv, x10, x11, -0x401, -0x401, x2, 432, x3)

inst_77:
// rs2_val == -2049, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x801
TEST_CMV_OP( c.mv, x10, x11, -0x801, -0x801, x2, 440, x3)

inst_78:
// rs2_val == -4097, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x1001
TEST_CMV_OP( c.mv, x10, x11, -0x1001, -0x1001, x2, 448, x3)

inst_79:
// rs2_val == -8193, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x2001
TEST_CMV_OP( c.mv, x10, x11, -0x2001, -0x2001, x2, 456, x3)

inst_80:
// rs2_val == -16385, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x4001
TEST_CMV_OP( c.mv, x10, x11, -0x4001, -0x4001, x2, 464, x3)

inst_81:
// rs2_val == -32769, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x8001
TEST_CMV_OP( c.mv, x10, x11, -0x8001, -0x8001, x2, 472, x3)

inst_82:
// rs2_val == -65537, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x10001
TEST_CMV_OP( c.mv, x10, x11, -0x10001, -0x10001, x2, 480, x3)

inst_83:
// rs2_val == -131073, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x20001
TEST_CMV_OP( c.mv, x10, x11, -0x20001, -0x20001, x2, 488, x3)

inst_84:
// rs2_val == -262145, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x40001
TEST_CMV_OP( c.mv, x10, x11, -0x40001, -0x40001, x2, 496, x3)

inst_85:
// rs2_val == -524289, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x80001
TEST_CMV_OP( c.mv, x10, x11, -0x80001, -0x80001, x2, 504, x3)

inst_86:
// rs2_val == -1048577, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x100001
TEST_CMV_OP( c.mv, x10, x11, -0x100001, -0x100001, x2, 512, x3)

inst_87:
// rs2_val == -2305843009213693953, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x2000000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x2000000000000001, -0x2000000000000001, x2, 520, x3)

inst_88:
// rs2_val == -4611686018427387905, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x4000000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x4000000000000001, -0x4000000000000001, x2, 528, x3)

inst_89:
// rs2_val == 6148914691236517205, rs2_val==6148914691236517205
// opcode: c.mv; op2:x11; dest:x10; op2val:0x5555555555555555
TEST_CMV_OP( c.mv, x10, x11, 0x5555555555555555, 0x5555555555555555, x2, 536, x3)

inst_90:
// rs2_val == -6148914691236517206, rs2_val==-6148914691236517206
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x5555555555555556
TEST_CMV_OP( c.mv, x10, x11, -0x5555555555555556, -0x5555555555555556, x2, 544, x3)

inst_91:
// rs2_val==3, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x3
TEST_CMV_OP( c.mv, x10, x11, 0x3, 0x3, x2, 552, x3)

inst_92:
// rs2_val==5, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x5
TEST_CMV_OP( c.mv, x10, x11, 0x5, 0x5, x2, 560, x3)

inst_93:
// rs2_val==3689348814741910323, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x3333333333333333
TEST_CMV_OP( c.mv, x10, x11, 0x3333333333333333, 0x3333333333333333, x2, 568, x3)

inst_94:
// rs2_val==7378697629483820646, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x6666666666666666
TEST_CMV_OP( c.mv, x10, x11, 0x6666666666666666, 0x6666666666666666, x2, 576, x3)

inst_95:
// rs2_val==-3037000499, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0xb504f333
TEST_CMV_OP( c.mv, x10, x11, -0xb504f333, -0xb504f333, x2, 584, x3)

inst_96:
// rs2_val==3037000499, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0xb504f333
TEST_CMV_OP( c.mv, x10, x11, 0xb504f333, 0xb504f333, x2, 592, x3)

inst_97:
// rs2_val==6148914691236517204, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x5555555555555554
TEST_CMV_OP( c.mv, x10, x11, 0x5555555555555554, 0x5555555555555554, x2, 600, x3)

inst_98:
// rs2_val==3689348814741910322, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x3333333333333332
TEST_CMV_OP( c.mv, x10, x11, 0x3333333333333332, 0x3333333333333332, x2, 608, x3)

inst_99:
// rs2_val==7378697629483820645, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x6666666666666665
TEST_CMV_OP( c.mv, x10, x11, 0x6666666666666665, 0x6666666666666665, x2, 616, x3)

inst_100:
// rs2_val==3037000498, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0xb504f332
TEST_CMV_OP( c.mv, x10, x11, 0xb504f332, 0xb504f332, x2, 624, x3)

inst_101:
// rs2_val==6148914691236517206, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x5555555555555556
TEST_CMV_OP( c.mv, x10, x11, 0x5555555555555556, 0x5555555555555556, x2, 632, x3)

inst_102:
// rs2_val==-6148914691236517205, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x5555555555555555
TEST_CMV_OP( c.mv, x10, x11, -0x5555555555555555, -0x5555555555555555, x2, 640, x3)

inst_103:
// rs2_val==6, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x6
TEST_CMV_OP( c.mv, x10, x11, 0x6, 0x6, x2, 648, x3)

inst_104:
// rs2_val==3689348814741910324, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x3333333333333334
TEST_CMV_OP( c.mv, x10, x11, 0x3333333333333334, 0x3333333333333334, x2, 656, x3)

inst_105:
// rs2_val==7378697629483820647, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x6666666666666667
TEST_CMV_OP( c.mv, x10, x11, 0x6666666666666667, 0x6666666666666667, x2, 664, x3)

inst_106:
// rs2_val==-3037000498, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0xb504f332
TEST_CMV_OP( c.mv, x10, x11, -0xb504f332, -0xb504f332, x2, 672, x3)

inst_107:
// rs2_val==3037000500, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0xb504f334
TEST_CMV_OP( c.mv, x10, x11, 0xb504f334, 0xb504f334, x2, 680, x3)

inst_108:
// rs2_val == -2097153, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x200001
TEST_CMV_OP( c.mv, x10, x11, -0x200001, -0x200001, x2, 688, x3)

inst_109:
// rs2_val == -4194305, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x400001
TEST_CMV_OP( c.mv, x10, x11, -0x400001, -0x400001, x2, 696, x3)

inst_110:
// rs2_val == -8388609, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x800001
TEST_CMV_OP( c.mv, x10, x11, -0x800001, -0x800001, x2, 704, x3)

inst_111:
// rs2_val == -16777217, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x1000001
TEST_CMV_OP( c.mv, x10, x11, -0x1000001, -0x1000001, x2, 712, x3)

inst_112:
// rs2_val == -33554433, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x2000001
TEST_CMV_OP( c.mv, x10, x11, -0x2000001, -0x2000001, x2, 720, x3)

inst_113:
// rs2_val == -67108865, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x4000001
TEST_CMV_OP( c.mv, x10, x11, -0x4000001, -0x4000001, x2, 728, x3)

inst_114:
// rs2_val == -134217729, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x8000001
TEST_CMV_OP( c.mv, x10, x11, -0x8000001, -0x8000001, x2, 736, x3)

inst_115:
// rs2_val == -268435457, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x10000001
TEST_CMV_OP( c.mv, x10, x11, -0x10000001, -0x10000001, x2, 744, x3)

inst_116:
// rs2_val == -536870913, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x20000001
TEST_CMV_OP( c.mv, x10, x11, -0x20000001, -0x20000001, x2, 752, x3)

inst_117:
// rs2_val == -1073741825, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x40000001
TEST_CMV_OP( c.mv, x10, x11, -0x40000001, -0x40000001, x2, 760, x3)

inst_118:
// rs2_val == -2147483649, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x80000001
TEST_CMV_OP( c.mv, x10, x11, -0x80000001, -0x80000001, x2, 768, x3)

inst_119:
// rs2_val == -4294967297, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x100000001
TEST_CMV_OP( c.mv, x10, x11, -0x100000001, -0x100000001, x2, 776, x3)

inst_120:
// rs2_val == -8589934593, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x200000001
TEST_CMV_OP( c.mv, x10, x11, -0x200000001, -0x200000001, x2, 784, x3)

inst_121:
// rs2_val == -17179869185, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x400000001
TEST_CMV_OP( c.mv, x10, x11, -0x400000001, -0x400000001, x2, 792, x3)

inst_122:
// rs2_val == -34359738369, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x800000001
TEST_CMV_OP( c.mv, x10, x11, -0x800000001, -0x800000001, x2, 800, x3)

inst_123:
// rs2_val == -68719476737, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x1000000001
TEST_CMV_OP( c.mv, x10, x11, -0x1000000001, -0x1000000001, x2, 808, x3)

inst_124:
// rs2_val == -137438953473, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x2000000001
TEST_CMV_OP( c.mv, x10, x11, -0x2000000001, -0x2000000001, x2, 816, x3)

inst_125:
// rs2_val == -274877906945, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x4000000001
TEST_CMV_OP( c.mv, x10, x11, -0x4000000001, -0x4000000001, x2, 824, x3)

inst_126:
// rs2_val == -549755813889, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x8000000001
TEST_CMV_OP( c.mv, x10, x11, -0x8000000001, -0x8000000001, x2, 832, x3)

inst_127:
// rs2_val == -1099511627777, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x10000000001
TEST_CMV_OP( c.mv, x10, x11, -0x10000000001, -0x10000000001, x2, 840, x3)

inst_128:
// rs2_val == -2199023255553, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x20000000001
TEST_CMV_OP( c.mv, x10, x11, -0x20000000001, -0x20000000001, x2, 848, x3)

inst_129:
// rs2_val == -4398046511105, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x40000000001
TEST_CMV_OP( c.mv, x10, x11, -0x40000000001, -0x40000000001, x2, 856, x3)

inst_130:
// rs2_val == -8796093022209, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x80000000001
TEST_CMV_OP( c.mv, x10, x11, -0x80000000001, -0x80000000001, x2, 864, x3)

inst_131:
// rs2_val == -17592186044417, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x100000000001
TEST_CMV_OP( c.mv, x10, x11, -0x100000000001, -0x100000000001, x2, 872, x3)

inst_132:
// rs2_val == -35184372088833, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x200000000001
TEST_CMV_OP( c.mv, x10, x11, -0x200000000001, -0x200000000001, x2, 880, x3)

inst_133:
// rs2_val == -70368744177665, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x400000000001
TEST_CMV_OP( c.mv, x10, x11, -0x400000000001, -0x400000000001, x2, 888, x3)

inst_134:
// rs2_val == -140737488355329, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x800000000001
TEST_CMV_OP( c.mv, x10, x11, -0x800000000001, -0x800000000001, x2, 896, x3)

inst_135:
// rs2_val == -281474976710657, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x1000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x1000000000001, -0x1000000000001, x2, 904, x3)

inst_136:
// rs2_val == -562949953421313, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x2000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x2000000000001, -0x2000000000001, x2, 912, x3)

inst_137:
// rs2_val == -1125899906842625, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x4000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x4000000000001, -0x4000000000001, x2, 920, x3)

inst_138:
// rs2_val == -2251799813685249, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x8000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x8000000000001, -0x8000000000001, x2, 928, x3)

inst_139:
// rs2_val == -4503599627370497, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x10000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x10000000000001, -0x10000000000001, x2, 936, x3)

inst_140:
// rs2_val == -9007199254740993, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x20000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x20000000000001, -0x20000000000001, x2, 944, x3)

inst_141:
// rs2_val == -18014398509481985, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x40000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x40000000000001, -0x40000000000001, x2, 952, x3)

inst_142:
// rs2_val == -36028797018963969, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x80000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x80000000000001, -0x80000000000001, x2, 960, x3)

inst_143:
// rs2_val == -72057594037927937, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x100000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x100000000000001, -0x100000000000001, x2, 968, x3)

inst_144:
// rs2_val == -144115188075855873, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x200000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x200000000000001, -0x200000000000001, x2, 976, x3)

inst_145:
// rs2_val == -288230376151711745, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x400000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x400000000000001, -0x400000000000001, x2, 984, x3)

inst_146:
// rs2_val == -576460752303423489, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x800000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x800000000000001, -0x800000000000001, x2, 992, x3)

inst_147:
// rs2_val == -1152921504606846977, 
// opcode: c.mv; op2:x11; dest:x10; op2val:-0x1000000000000001
TEST_CMV_OP( c.mv, x10, x11, -0x1000000000000001, -0x1000000000000001, x2, 1000, x3)

inst_148:
// rs2_val == 32, 
// opcode: c.mv; op2:x11; dest:x10; op2val:0x20
TEST_CMV_OP( c.mv, x10, x11, 0x20, 0x20, x2, 1008, x3)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x13_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x13_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 127*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
