
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 04:49:48 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64ic.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the c.srai instruction of the RISC-V C extension for the csrai covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IC")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*C.*);def TEST_CASE_1=True;",csrai)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rs1==x8, rs1_val < 0 and imm_val < xlen, rs1_val == -67108865
// opcode:c.srai; op1:x8; dest:x8 op1val:-0x4000001; immval:0xc
TEST_CI_OP( c.srai, x8, 0xffffffffffffbfff, -0x4000001, 0xc, x1, 0, x2)

inst_1:
// rs1==x12, rs1_val > 0 and imm_val < xlen, rs1_val == 1073741824, imm_val == 59
// opcode:c.srai; op1:x12; dest:x12 op1val:0x40000000; immval:0x3b
TEST_CI_OP( c.srai, x12, 0x0, 0x40000000, 0x3b, x1, 8, x2)

inst_2:
// rs1==x15, rs1_val == imm_val and imm_val != 0  and imm_val < xlen, imm_val == 1, rs1_val == 1 and imm_val != 0 and imm_val < xlen, rs1_val == 1
// opcode:c.srai; op1:x15; dest:x15 op1val:0x1; immval:0x1
TEST_CI_OP( c.srai, x15, 0x0, 0x1, 0x1, x1, 16, x2)

inst_3:
// rs1==x11, rs1_val == (-2**(xlen-1)) and imm_val != 0 and imm_val < xlen, rs1_val == -9223372036854775808
// opcode:c.srai; op1:x11; dest:x11 op1val:-0x8000000000000000; immval:0xd
TEST_CI_OP( c.srai, x11, 0xfffc000000000000, -0x8000000000000000, 0xd, x1, 24, x2)

inst_4:
// rs1==x10, rs1_val == 0 and imm_val != 0 and imm_val < xlen, imm_val == 8, rs1_val==0
// opcode:c.srai; op1:x10; dest:x10 op1val:0x0; immval:0x8
TEST_CI_OP( c.srai, x10, 0x0, 0x0, 0x8, x1, 32, x2)

inst_5:
// rs1==x13, rs1_val == (2**(xlen-1)-1) and imm_val != 0 and imm_val < xlen, imm_val == 32, rs1_val == 9223372036854775807
// opcode:c.srai; op1:x13; dest:x13 op1val:0x7fffffffffffffff; immval:0x20
TEST_CI_OP( c.srai, x13, 0x7fffffff, 0x7fffffffffffffff, 0x20, x1, 40, x2)

inst_6:
// rs1==x14, rs1_val == 2, rs1_val==2, imm_val == 47
// opcode:c.srai; op1:x14; dest:x14 op1val:0x2; immval:0x2f
TEST_CI_OP( c.srai, x14, 0x0, 0x2, 0x2f, x1, 48, x2)

inst_7:
// rs1==x9, rs1_val == 4, rs1_val==4
// opcode:c.srai; op1:x9; dest:x9 op1val:0x4; immval:0x7
TEST_CI_OP( c.srai, x9, 0x0, 0x4, 0x7, x1, 56, x2)

inst_8:
// rs1_val == 8, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x8; immval:0x8
TEST_CI_OP( c.srai, x10, 0x0, 0x8, 0x8, x1, 64, x2)

inst_9:
// rs1_val == 16, imm_val == 42
// opcode:c.srai; op1:x10; dest:x10 op1val:0x10; immval:0x2a
TEST_CI_OP( c.srai, x10, 0x0, 0x10, 0x2a, x1, 72, x2)

inst_10:
// rs1_val == 32, imm_val == 62
// opcode:c.srai; op1:x10; dest:x10 op1val:0x20; immval:0x3e
TEST_CI_OP( c.srai, x10, 0x0, 0x20, 0x3e, x1, 80, x2)

inst_11:
// rs1_val == 64, imm_val == 31
// opcode:c.srai; op1:x10; dest:x10 op1val:0x40; immval:0x1f
TEST_CI_OP( c.srai, x10, 0x0, 0x40, 0x1f, x1, 88, x2)

inst_12:
// rs1_val == 128, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x80; immval:0xb
TEST_CI_OP( c.srai, x10, 0x0, 0x80, 0xb, x1, 96, x2)

inst_13:
// rs1_val == 256, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x100; immval:0x7
TEST_CI_OP( c.srai, x10, 0x2, 0x100, 0x7, x1, 104, x2)

inst_14:
// rs1_val == 512, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x200; immval:0xb
TEST_CI_OP( c.srai, x10, 0x0, 0x200, 0xb, x1, 112, x2)

inst_15:
// rs1_val == 1024, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x400; immval:0xd
TEST_CI_OP( c.srai, x10, 0x0, 0x400, 0xd, x1, 120, x2)

inst_16:
// rs1_val == 2048, imm_val == 4
// opcode:c.srai; op1:x10; dest:x10 op1val:0x800; immval:0x4
TEST_CI_OP( c.srai, x10, 0x80, 0x800, 0x4, x1, 128, x2)

inst_17:
// rs1_val == 4096, imm_val == 16
// opcode:c.srai; op1:x10; dest:x10 op1val:0x1000; immval:0x10
TEST_CI_OP( c.srai, x10, 0x0, 0x1000, 0x10, x1, 136, x2)

inst_18:
// rs1_val == 8192, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x2000; immval:0xf
TEST_CI_OP( c.srai, x10, 0x0, 0x2000, 0xf, x1, 144, x2)

inst_19:
// rs1_val == 16384, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x4000; immval:0xf
TEST_CI_OP( c.srai, x10, 0x0, 0x4000, 0xf, x1, 152, x2)

inst_20:
// rs1_val == 32768, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x8000; immval:0x4
TEST_CI_OP( c.srai, x10, 0x800, 0x8000, 0x4, x1, 160, x2)

inst_21:
// rs1_val == 65536, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x10000; immval:0x20
TEST_CI_OP( c.srai, x10, 0x0, 0x10000, 0x20, x1, 168, x2)

inst_22:
// rs1_val == 131072, imm_val == 21
// opcode:c.srai; op1:x10; dest:x10 op1val:0x20000; immval:0x15
TEST_CI_OP( c.srai, x10, 0x0, 0x20000, 0x15, x1, 176, x2)

inst_23:
// rs1_val == 262144, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x40000; immval:0x5
TEST_CI_OP( c.srai, x10, 0x2000, 0x40000, 0x5, x1, 184, x2)

inst_24:
// rs1_val == 524288, imm_val == 2
// opcode:c.srai; op1:x10; dest:x10 op1val:0x80000; immval:0x2
TEST_CI_OP( c.srai, x10, 0x20000, 0x80000, 0x2, x1, 192, x2)

inst_25:
// rs1_val == 1048576, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x100000; immval:0xb
TEST_CI_OP( c.srai, x10, 0x200, 0x100000, 0xb, x1, 200, x2)

inst_26:
// rs1_val == 2097152, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x200000; immval:0x10
TEST_CI_OP( c.srai, x10, 0x20, 0x200000, 0x10, x1, 208, x2)

inst_27:
// rs1_val == 4194304, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x400000; immval:0x13
TEST_CI_OP( c.srai, x10, 0x8, 0x400000, 0x13, x1, 216, x2)

inst_28:
// rs1_val == 8388608, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x800000; immval:0x6
TEST_CI_OP( c.srai, x10, 0x20000, 0x800000, 0x6, x1, 224, x2)

inst_29:
// rs1_val == 16777216, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x1000000; immval:0x1f
TEST_CI_OP( c.srai, x10, 0x0, 0x1000000, 0x1f, x1, 232, x2)

inst_30:
// rs1_val == 33554432, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x2000000; immval:0x5
TEST_CI_OP( c.srai, x10, 0x100000, 0x2000000, 0x5, x1, 240, x2)

inst_31:
// rs1_val == 67108864, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x4000000; immval:0x15
TEST_CI_OP( c.srai, x10, 0x20, 0x4000000, 0x15, x1, 248, x2)

inst_32:
// rs1_val == 134217728, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x8000000; immval:0x3
TEST_CI_OP( c.srai, x10, 0x1000000, 0x8000000, 0x3, x1, 256, x2)

inst_33:
// rs1_val == 268435456, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x10000000; immval:0xa
TEST_CI_OP( c.srai, x10, 0x40000, 0x10000000, 0xa, x1, 264, x2)

inst_34:
// rs1_val == 536870912, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x20000000; immval:0x8
TEST_CI_OP( c.srai, x10, 0x200000, 0x20000000, 0x8, x1, 272, x2)

inst_35:
// rs1_val == 2147483648, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x80000000; immval:0xe
TEST_CI_OP( c.srai, x10, 0x20000, 0x80000000, 0xe, x1, 280, x2)

inst_36:
// rs1_val == 4294967296, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x100000000; immval:0x2
TEST_CI_OP( c.srai, x10, 0x40000000, 0x100000000, 0x2, x1, 288, x2)

inst_37:
// rs1_val == 8589934592, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x200000000; immval:0x3b
TEST_CI_OP( c.srai, x10, 0x0, 0x200000000, 0x3b, x1, 296, x2)

inst_38:
// rs1_val == 17179869184, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x400000000; immval:0xc
TEST_CI_OP( c.srai, x10, 0x400000, 0x400000000, 0xc, x1, 304, x2)

inst_39:
// rs1_val == 34359738368, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x800000000; immval:0xf
TEST_CI_OP( c.srai, x10, 0x100000, 0x800000000, 0xf, x1, 312, x2)

inst_40:
// rs1_val == 68719476736, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x1000000000; immval:0x11
TEST_CI_OP( c.srai, x10, 0x80000, 0x1000000000, 0x11, x1, 320, x2)

inst_41:
// rs1_val == 137438953472, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x2000000000; immval:0x10
TEST_CI_OP( c.srai, x10, 0x200000, 0x2000000000, 0x10, x1, 328, x2)

inst_42:
// rs1_val == 274877906944, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x4000000000; immval:0x6
TEST_CI_OP( c.srai, x10, 0x100000000, 0x4000000000, 0x6, x1, 336, x2)

inst_43:
// rs1_val == 549755813888, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x8000000000; immval:0x8
TEST_CI_OP( c.srai, x10, 0x80000000, 0x8000000000, 0x8, x1, 344, x2)

inst_44:
// rs1_val == 1099511627776, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x10000000000; immval:0x15
TEST_CI_OP( c.srai, x10, 0x80000, 0x10000000000, 0x15, x1, 352, x2)

inst_45:
// rs1_val == 2199023255552, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x20000000000; immval:0x8
TEST_CI_OP( c.srai, x10, 0x200000000, 0x20000000000, 0x8, x1, 360, x2)

inst_46:
// rs1_val == 4398046511104, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x40000000000; immval:0x2
TEST_CI_OP( c.srai, x10, 0x10000000000, 0x40000000000, 0x2, x1, 368, x2)

inst_47:
// rs1_val == 8796093022208, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x80000000000; immval:0xe
TEST_CI_OP( c.srai, x10, 0x20000000, 0x80000000000, 0xe, x1, 376, x2)

inst_48:
// rs1_val == 17592186044416, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x100000000000; immval:0x1
TEST_CI_OP( c.srai, x10, 0x80000000000, 0x100000000000, 0x1, x1, 384, x2)

inst_49:
// rs1_val == 35184372088832, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x200000000000; immval:0x11
TEST_CI_OP( c.srai, x10, 0x10000000, 0x200000000000, 0x11, x1, 392, x2)

inst_50:
// rs1_val == 70368744177664, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x400000000000; immval:0x2a
TEST_CI_OP( c.srai, x10, 0x10, 0x400000000000, 0x2a, x1, 400, x2)

inst_51:
// rs1_val == 140737488355328, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x800000000000; immval:0x1f
TEST_CI_OP( c.srai, x10, 0x10000, 0x800000000000, 0x1f, x1, 408, x2)

inst_52:
// rs1_val == 281474976710656, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x1000000000000; immval:0x3e
TEST_CI_OP( c.srai, x10, 0x0, 0x1000000000000, 0x3e, x1, 416, x2)

inst_53:
// rs1_val == 562949953421312, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x2000000000000; immval:0xb
TEST_CI_OP( c.srai, x10, 0x4000000000, 0x2000000000000, 0xb, x1, 424, x2)

inst_54:
// rs1_val == 1125899906842624, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x4000000000000; immval:0x1f
TEST_CI_OP( c.srai, x10, 0x80000, 0x4000000000000, 0x1f, x1, 432, x2)

inst_55:
// rs1_val == 2251799813685248, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x8000000000000; immval:0x2
TEST_CI_OP( c.srai, x10, 0x2000000000000, 0x8000000000000, 0x2, x1, 440, x2)

inst_56:
// rs1_val == 4503599627370496, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x10000000000000; immval:0x12
TEST_CI_OP( c.srai, x10, 0x400000000, 0x10000000000000, 0x12, x1, 448, x2)

inst_57:
// rs1_val == 9007199254740992, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x20000000000000; immval:0x3f
TEST_CI_OP( c.srai, x10, 0x0, 0x20000000000000, 0x3f, x1, 456, x2)

inst_58:
// rs1_val == 18014398509481984, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x40000000000000; immval:0x3f
TEST_CI_OP( c.srai, x10, 0x0, 0x40000000000000, 0x3f, x1, 464, x2)

inst_59:
// rs1_val == 36028797018963968, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x80000000000000; immval:0x12
TEST_CI_OP( c.srai, x10, 0x2000000000, 0x80000000000000, 0x12, x1, 472, x2)

inst_60:
// rs1_val == 72057594037927936, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x100000000000000; immval:0x3
TEST_CI_OP( c.srai, x10, 0x20000000000000, 0x100000000000000, 0x3, x1, 480, x2)

inst_61:
// rs1_val == 144115188075855872, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x200000000000000; immval:0x1
TEST_CI_OP( c.srai, x10, 0x100000000000000, 0x200000000000000, 0x1, x1, 488, x2)

inst_62:
// rs1_val == 288230376151711744, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x400000000000000; immval:0xf
TEST_CI_OP( c.srai, x10, 0x80000000000, 0x400000000000000, 0xf, x1, 496, x2)

inst_63:
// rs1_val == 576460752303423488, imm_val == 61
// opcode:c.srai; op1:x10; dest:x10 op1val:0x800000000000000; immval:0x3d
TEST_CI_OP( c.srai, x10, 0x0, 0x800000000000000, 0x3d, x1, 504, x2)

inst_64:
// rs1_val == 1152921504606846976, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x1000000000000000; immval:0x3d
TEST_CI_OP( c.srai, x10, 0x0, 0x1000000000000000, 0x3d, x1, 512, x2)

inst_65:
// rs1_val == 2305843009213693952, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x2000000000000000; immval:0x9
TEST_CI_OP( c.srai, x10, 0x10000000000000, 0x2000000000000000, 0x9, x1, 520, x2)

inst_66:
// rs1_val == 4611686018427387904, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x4000000000000000; immval:0xc
TEST_CI_OP( c.srai, x10, 0x4000000000000, 0x4000000000000000, 0xc, x1, 528, x2)

inst_67:
// rs1_val == -2, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x2; immval:0x10
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x2, 0x10, x1, 536, x2)

inst_68:
// rs1_val == -3, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x3; immval:0xd
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x3, 0xd, x1, 544, x2)

inst_69:
// rs1_val == -5, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x5; immval:0x3d
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x5, 0x3d, x1, 552, x2)

inst_70:
// rs1_val == -9, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x9; immval:0x3f
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x9, 0x3f, x1, 560, x2)

inst_71:
// rs1_val == -17, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x11; immval:0x5
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x11, 0x5, x1, 568, x2)

inst_72:
// rs1_val == -33, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x21; immval:0xe
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x21, 0xe, x1, 576, x2)

inst_73:
// rs1_val == -65, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x41; immval:0x10
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x41, 0x10, x1, 584, x2)

inst_74:
// rs1_val == -129, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x81; immval:0x7
TEST_CI_OP( c.srai, x10, 0xfffffffffffffffe, -0x81, 0x7, x1, 592, x2)

inst_75:
// rs1_val == -257, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x101; immval:0x3b
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x101, 0x3b, x1, 600, x2)

inst_76:
// rs1_val == -513, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x201; immval:0x9
TEST_CI_OP( c.srai, x10, 0xfffffffffffffffe, -0x201, 0x9, x1, 608, x2)

inst_77:
// rs1_val == -1025, imm_val == 55
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x401; immval:0x37
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x401, 0x37, x1, 616, x2)

inst_78:
// rs1_val == -2049, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x801; immval:0x15
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x801, 0x15, x1, 624, x2)

inst_79:
// rs1_val == -4097, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x1001; immval:0xb
TEST_CI_OP( c.srai, x10, 0xfffffffffffffffd, -0x1001, 0xb, x1, 632, x2)

inst_80:
// rs1_val == -8193, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x2001; immval:0x7
TEST_CI_OP( c.srai, x10, 0xffffffffffffffbf, -0x2001, 0x7, x1, 640, x2)

inst_81:
// rs1_val == -16385, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x4001; immval:0x9
TEST_CI_OP( c.srai, x10, 0xffffffffffffffdf, -0x4001, 0x9, x1, 648, x2)

inst_82:
// rs1_val == -32769, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x8001; immval:0xf
TEST_CI_OP( c.srai, x10, 0xfffffffffffffffe, -0x8001, 0xf, x1, 656, x2)

inst_83:
// rs1_val == -65537, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x10001; immval:0x2f
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x10001, 0x2f, x1, 664, x2)

inst_84:
// rs1_val == -131073, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x20001; immval:0x3e
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x20001, 0x3e, x1, 672, x2)

inst_85:
// rs1_val == -262145, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x40001; immval:0x15
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x40001, 0x15, x1, 680, x2)

inst_86:
// rs1_val == -524289, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x80001; immval:0x3f
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x80001, 0x3f, x1, 688, x2)

inst_87:
// rs1_val == -144115188075855873, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x200000000000001; immval:0xf
TEST_CI_OP( c.srai, x10, 0xfffffbffffffffff, -0x200000000000001, 0xf, x1, 696, x2)

inst_88:
// rs1_val == -288230376151711745, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x400000000000001; immval:0x13
TEST_CI_OP( c.srai, x10, 0xffffff7fffffffff, -0x400000000000001, 0x13, x1, 704, x2)

inst_89:
// rs1_val == -576460752303423489, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x800000000000001; immval:0x2
TEST_CI_OP( c.srai, x10, 0xfdffffffffffffff, -0x800000000000001, 0x2, x1, 712, x2)

inst_90:
// rs1_val == -1152921504606846977, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x1000000000000001; immval:0x3d
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x1000000000000001, 0x3d, x1, 720, x2)

inst_91:
// rs1_val == -2305843009213693953, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x2000000000000001; immval:0xc
TEST_CI_OP( c.srai, x10, 0xfffdffffffffffff, -0x2000000000000001, 0xc, x1, 728, x2)

inst_92:
// rs1_val == -4611686018427387905, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x4000000000000001; immval:0x8
TEST_CI_OP( c.srai, x10, 0xffbfffffffffffff, -0x4000000000000001, 0x8, x1, 736, x2)

inst_93:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode:c.srai; op1:x10; dest:x10 op1val:0x5555555555555555; immval:0x37
TEST_CI_OP( c.srai, x10, 0xaa, 0x5555555555555555, 0x37, x1, 744, x2)

inst_94:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x5555555555555556; immval:0xa
TEST_CI_OP( c.srai, x10, 0xffeaaaaaaaaaaaaa, -0x5555555555555556, 0xa, x1, 752, x2)

inst_95:
// rs1_val==3, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x3; immval:0x2
TEST_CI_OP( c.srai, x10, 0x0, 0x3, 0x2, x1, 760, x2)

inst_96:
// rs1_val==5, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x5; immval:0x9
TEST_CI_OP( c.srai, x10, 0x0, 0x5, 0x9, x1, 768, x2)

inst_97:
// rs1_val==3689348814741910323, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x3333333333333333; immval:0x3f
TEST_CI_OP( c.srai, x10, 0x0, 0x3333333333333333, 0x3f, x1, 776, x2)

inst_98:
// rs1_val==7378697629483820646, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x6666666666666666; immval:0x1f
TEST_CI_OP( c.srai, x10, 0xcccccccc, 0x6666666666666666, 0x1f, x1, 784, x2)

inst_99:
// rs1_val==-3037000499, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0xb504f333; immval:0x2a
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0xb504f333, 0x2a, x1, 792, x2)

inst_100:
// rs1_val==3037000499, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0xb504f333; immval:0x3f
TEST_CI_OP( c.srai, x10, 0x0, 0xb504f333, 0x3f, x1, 800, x2)

inst_101:
// rs1_val==6148914691236517204, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x5555555555555554; immval:0xf
TEST_CI_OP( c.srai, x10, 0xaaaaaaaaaaaa, 0x5555555555555554, 0xf, x1, 808, x2)

inst_102:
// rs1_val==3689348814741910322, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x3333333333333332; immval:0xf
TEST_CI_OP( c.srai, x10, 0x666666666666, 0x3333333333333332, 0xf, x1, 816, x2)

inst_103:
// rs1_val==7378697629483820645, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x6666666666666665; immval:0x3e
TEST_CI_OP( c.srai, x10, 0x1, 0x6666666666666665, 0x3e, x1, 824, x2)

inst_104:
// rs1_val==3037000498, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0xb504f332; immval:0x3e
TEST_CI_OP( c.srai, x10, 0x0, 0xb504f332, 0x3e, x1, 832, x2)

inst_105:
// rs1_val==6148914691236517206, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x5555555555555556; immval:0x6
TEST_CI_OP( c.srai, x10, 0x155555555555555, 0x5555555555555556, 0x6, x1, 840, x2)

inst_106:
// rs1_val==-6148914691236517205, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x5555555555555555; immval:0xc
TEST_CI_OP( c.srai, x10, 0xfffaaaaaaaaaaaaa, -0x5555555555555555, 0xc, x1, 848, x2)

inst_107:
// rs1_val==6, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x6; immval:0x9
TEST_CI_OP( c.srai, x10, 0x0, 0x6, 0x9, x1, 856, x2)

inst_108:
// rs1_val==3689348814741910324, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x3333333333333334; immval:0x20
TEST_CI_OP( c.srai, x10, 0x33333333, 0x3333333333333334, 0x20, x1, 864, x2)

inst_109:
// rs1_val==7378697629483820647, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0x6666666666666667; immval:0xe
TEST_CI_OP( c.srai, x10, 0x1999999999999, 0x6666666666666667, 0xe, x1, 872, x2)

inst_110:
// rs1_val==-3037000498, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0xb504f332; immval:0xc
TEST_CI_OP( c.srai, x10, 0xfffffffffff4afb0, -0xb504f332, 0xc, x1, 880, x2)

inst_111:
// rs1_val==3037000500, 
// opcode:c.srai; op1:x10; dest:x10 op1val:0xb504f334; immval:0xe
TEST_CI_OP( c.srai, x10, 0x2d413, 0xb504f334, 0xe, x1, 888, x2)

inst_112:
// rs1_val == -1048577, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x100001; immval:0x2a
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x100001, 0x2a, x1, 896, x2)

inst_113:
// rs1_val == -2097153, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x200001; immval:0x2f
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x200001, 0x2f, x1, 904, x2)

inst_114:
// rs1_val == -4194305, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x400001; immval:0x1
TEST_CI_OP( c.srai, x10, 0xffffffffffdfffff, -0x400001, 0x1, x1, 912, x2)

inst_115:
// rs1_val == -8388609, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x800001; immval:0x1f
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x800001, 0x1f, x1, 920, x2)

inst_116:
// rs1_val == -16777217, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x1000001; immval:0x15
TEST_CI_OP( c.srai, x10, 0xfffffffffffffff7, -0x1000001, 0x15, x1, 928, x2)

inst_117:
// rs1_val == -33554433, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x2000001; immval:0xe
TEST_CI_OP( c.srai, x10, 0xfffffffffffff7ff, -0x2000001, 0xe, x1, 936, x2)

inst_118:
// rs1_val == -134217729, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x8000001; immval:0x4
TEST_CI_OP( c.srai, x10, 0xffffffffff7fffff, -0x8000001, 0x4, x1, 944, x2)

inst_119:
// rs1_val == -268435457, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x10000001; immval:0x10
TEST_CI_OP( c.srai, x10, 0xffffffffffffefff, -0x10000001, 0x10, x1, 952, x2)

inst_120:
// rs1_val == -536870913, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x20000001; immval:0xd
TEST_CI_OP( c.srai, x10, 0xfffffffffffeffff, -0x20000001, 0xd, x1, 960, x2)

inst_121:
// rs1_val == -1073741825, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x40000001; immval:0xe
TEST_CI_OP( c.srai, x10, 0xfffffffffffeffff, -0x40000001, 0xe, x1, 968, x2)

inst_122:
// rs1_val == -2147483649, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x80000001; immval:0x13
TEST_CI_OP( c.srai, x10, 0xffffffffffffefff, -0x80000001, 0x13, x1, 976, x2)

inst_123:
// rs1_val == -4294967297, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x100000001; immval:0x2a
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x100000001, 0x2a, x1, 984, x2)

inst_124:
// rs1_val == -8589934593, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x200000001; immval:0x13
TEST_CI_OP( c.srai, x10, 0xffffffffffffbfff, -0x200000001, 0x13, x1, 992, x2)

inst_125:
// rs1_val == -17179869185, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x400000001; immval:0x2a
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x400000001, 0x2a, x1, 1000, x2)

inst_126:
// rs1_val == -34359738369, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x800000001; immval:0xa
TEST_CI_OP( c.srai, x10, 0xfffffffffdffffff, -0x800000001, 0xa, x1, 1008, x2)

inst_127:
// rs1_val == -68719476737, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x1000000001; immval:0x10
TEST_CI_OP( c.srai, x10, 0xffffffffffefffff, -0x1000000001, 0x10, x1, 1016, x2)

inst_128:
// rs1_val == -137438953473, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x2000000001; immval:0x13
TEST_CI_OP( c.srai, x10, 0xfffffffffffbffff, -0x2000000001, 0x13, x1, 1024, x2)

inst_129:
// rs1_val == -274877906945, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x4000000001; immval:0x12
TEST_CI_OP( c.srai, x10, 0xffffffffffefffff, -0x4000000001, 0x12, x1, 1032, x2)

inst_130:
// rs1_val == -549755813889, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x8000000001; immval:0x3
TEST_CI_OP( c.srai, x10, 0xffffffefffffffff, -0x8000000001, 0x3, x1, 1040, x2)

inst_131:
// rs1_val == -1099511627777, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x10000000001; immval:0x2f
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x10000000001, 0x2f, x1, 1048, x2)

inst_132:
// rs1_val == -2199023255553, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x20000000001; immval:0x1f
TEST_CI_OP( c.srai, x10, 0xfffffffffffffbff, -0x20000000001, 0x1f, x1, 1056, x2)

inst_133:
// rs1_val == -4398046511105, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x40000000001; immval:0x7
TEST_CI_OP( c.srai, x10, 0xfffffff7ffffffff, -0x40000000001, 0x7, x1, 1064, x2)

inst_134:
// rs1_val == -8796093022209, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x80000000001; immval:0x3b
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x80000000001, 0x3b, x1, 1072, x2)

inst_135:
// rs1_val == -17592186044417, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x100000000001; immval:0x12
TEST_CI_OP( c.srai, x10, 0xfffffffffbffffff, -0x100000000001, 0x12, x1, 1080, x2)

inst_136:
// rs1_val == -35184372088833, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x200000000001; immval:0x3b
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x200000000001, 0x3b, x1, 1088, x2)

inst_137:
// rs1_val == -70368744177665, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x400000000001; immval:0x1
TEST_CI_OP( c.srai, x10, 0xffffdfffffffffff, -0x400000000001, 0x1, x1, 1096, x2)

inst_138:
// rs1_val == -140737488355329, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x800000000001; immval:0x3e
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x800000000001, 0x3e, x1, 1104, x2)

inst_139:
// rs1_val == -281474976710657, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x1000000000001; immval:0x8
TEST_CI_OP( c.srai, x10, 0xfffffeffffffffff, -0x1000000000001, 0x8, x1, 1112, x2)

inst_140:
// rs1_val == -562949953421313, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x2000000000001; immval:0xc
TEST_CI_OP( c.srai, x10, 0xffffffdfffffffff, -0x2000000000001, 0xc, x1, 1120, x2)

inst_141:
// rs1_val == -1125899906842625, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x4000000000001; immval:0xb
TEST_CI_OP( c.srai, x10, 0xffffff7fffffffff, -0x4000000000001, 0xb, x1, 1128, x2)

inst_142:
// rs1_val == -2251799813685249, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x8000000000001; immval:0x11
TEST_CI_OP( c.srai, x10, 0xfffffffbffffffff, -0x8000000000001, 0x11, x1, 1136, x2)

inst_143:
// rs1_val == -4503599627370497, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x10000000000001; immval:0xc
TEST_CI_OP( c.srai, x10, 0xfffffeffffffffff, -0x10000000000001, 0xc, x1, 1144, x2)

inst_144:
// rs1_val == -9007199254740993, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x20000000000001; immval:0x3d
TEST_CI_OP( c.srai, x10, 0xffffffffffffffff, -0x20000000000001, 0x3d, x1, 1152, x2)

inst_145:
// rs1_val == -18014398509481985, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x40000000000001; immval:0x5
TEST_CI_OP( c.srai, x10, 0xfffdffffffffffff, -0x40000000000001, 0x5, x1, 1160, x2)

inst_146:
// rs1_val == -36028797018963969, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x80000000000001; immval:0x1
TEST_CI_OP( c.srai, x10, 0xffbfffffffffffff, -0x80000000000001, 0x1, x1, 1168, x2)

inst_147:
// rs1_val == -72057594037927937, 
// opcode:c.srai; op1:x10; dest:x10 op1val:-0x100000000000001; immval:0xe
TEST_CI_OP( c.srai, x10, 0xfffffbffffffffff, -0x100000000000001, 0xe, x1, 1176, x2)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 148*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
