
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 04:49:48 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64ic.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the c.srli instruction of the RISC-V C extension for the csrli covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IC")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*C.*);def TEST_CASE_1=True;",csrli)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rs1==x13, rs1_val < 0 and imm_val < xlen, rs1_val == -1125899906842625
// opcode:c.srli; op1:x13; dest:x13 op1val:-0x4000000000001; immval:0x3
TEST_CI_OP( c.srli, x13, 0x1fff7fffffffffff, -0x4000000000001, 0x3, x1, 0, x2)

inst_1:
// rs1==x11, rs1_val > 0 and imm_val < xlen, imm_val == 16, rs1_val == 536870912
// opcode:c.srli; op1:x11; dest:x11 op1val:0x20000000; immval:0x10
TEST_CI_OP( c.srli, x11, 0x2000, 0x20000000, 0x10, x1, 8, x2)

inst_2:
// rs1==x12, rs1_val == imm_val and imm_val != 0  and imm_val < xlen, rs1_val==5
// opcode:c.srli; op1:x12; dest:x12 op1val:0x5; immval:0x5
TEST_CI_OP( c.srli, x12, 0x0, 0x5, 0x5, x1, 16, x2)

inst_3:
// rs1==x10, rs1_val == (-2**(xlen-1)) and imm_val != 0 and imm_val < xlen, rs1_val == -9223372036854775808
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x8000000000000000; immval:0x13
TEST_CI_OP( c.srli, x10, 0x100000000000, -0x8000000000000000, 0x13, x1, 24, x2)

inst_4:
// rs1==x15, rs1_val == 0 and imm_val != 0 and imm_val < xlen, rs1_val==0
// opcode:c.srli; op1:x15; dest:x15 op1val:0x0; immval:0x7
TEST_CI_OP( c.srli, x15, 0x0, 0x0, 0x7, x1, 32, x2)

inst_5:
// rs1==x14, rs1_val == (2**(xlen-1)-1) and imm_val != 0 and imm_val < xlen, imm_val == 8, rs1_val == 9223372036854775807
// opcode:c.srli; op1:x14; dest:x14 op1val:0x7fffffffffffffff; immval:0x8
TEST_CI_OP( c.srli, x14, 0x7fffffffffffff, 0x7fffffffffffffff, 0x8, x1, 40, x2)

inst_6:
// rs1==x9, rs1_val == 1 and imm_val != 0 and imm_val < xlen, rs1_val == 1
// opcode:c.srli; op1:x9; dest:x9 op1val:0x1; immval:0x8
TEST_CI_OP( c.srli, x9, 0x0, 0x1, 0x8, x1, 48, x2)

inst_7:
// rs1==x8, rs1_val == 2, rs1_val==2
// opcode:c.srli; op1:x8; dest:x8 op1val:0x2; immval:0x5
TEST_CI_OP( c.srli, x8, 0x0, 0x2, 0x5, x1, 56, x2)

inst_8:
// rs1_val == 4, rs1_val==4, imm_val == 61
// opcode:c.srli; op1:x10; dest:x10 op1val:0x4; immval:0x3d
TEST_CI_OP( c.srli, x10, 0x0, 0x4, 0x3d, x1, 64, x2)

inst_9:
// rs1_val == 8, imm_val == 55
// opcode:c.srli; op1:x10; dest:x10 op1val:0x8; immval:0x37
TEST_CI_OP( c.srli, x10, 0x0, 0x8, 0x37, x1, 72, x2)

inst_10:
// rs1_val == 16, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x10; immval:0x3f
TEST_CI_OP( c.srli, x10, 0x0, 0x10, 0x3f, x1, 80, x2)

inst_11:
// rs1_val == 32, imm_val == 59
// opcode:c.srli; op1:x10; dest:x10 op1val:0x20; immval:0x3b
TEST_CI_OP( c.srli, x10, 0x0, 0x20, 0x3b, x1, 88, x2)

inst_12:
// rs1_val == 64, imm_val == 21
// opcode:c.srli; op1:x10; dest:x10 op1val:0x40; immval:0x15
TEST_CI_OP( c.srli, x10, 0x0, 0x40, 0x15, x1, 96, x2)

inst_13:
// rs1_val == 128, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x80; immval:0xc
TEST_CI_OP( c.srli, x10, 0x0, 0x80, 0xc, x1, 104, x2)

inst_14:
// rs1_val == 256, imm_val == 2
// opcode:c.srli; op1:x10; dest:x10 op1val:0x100; immval:0x2
TEST_CI_OP( c.srli, x10, 0x40, 0x100, 0x2, x1, 112, x2)

inst_15:
// rs1_val == 512, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x200; immval:0x3b
TEST_CI_OP( c.srli, x10, 0x0, 0x200, 0x3b, x1, 120, x2)

inst_16:
// rs1_val == 1024, imm_val == 4
// opcode:c.srli; op1:x10; dest:x10 op1val:0x400; immval:0x4
TEST_CI_OP( c.srli, x10, 0x40, 0x400, 0x4, x1, 128, x2)

inst_17:
// rs1_val == 2048, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x800; immval:0x7
TEST_CI_OP( c.srli, x10, 0x10, 0x800, 0x7, x1, 136, x2)

inst_18:
// rs1_val == 4096, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x1000; immval:0x3
TEST_CI_OP( c.srli, x10, 0x200, 0x1000, 0x3, x1, 144, x2)

inst_19:
// rs1_val == 8192, imm_val == 31
// opcode:c.srli; op1:x10; dest:x10 op1val:0x2000; immval:0x1f
TEST_CI_OP( c.srli, x10, 0x0, 0x2000, 0x1f, x1, 152, x2)

inst_20:
// rs1_val == 16384, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x4000; immval:0x3d
TEST_CI_OP( c.srli, x10, 0x0, 0x4000, 0x3d, x1, 160, x2)

inst_21:
// rs1_val == 32768, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x8000; immval:0x10
TEST_CI_OP( c.srli, x10, 0x0, 0x8000, 0x10, x1, 168, x2)

inst_22:
// rs1_val == 65536, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x10000; immval:0x3
TEST_CI_OP( c.srli, x10, 0x2000, 0x10000, 0x3, x1, 176, x2)

inst_23:
// rs1_val == 131072, imm_val == 1
// opcode:c.srli; op1:x10; dest:x10 op1val:0x20000; immval:0x1
TEST_CI_OP( c.srli, x10, 0x10000, 0x20000, 0x1, x1, 184, x2)

inst_24:
// rs1_val == 262144, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x40000; immval:0x1f
TEST_CI_OP( c.srli, x10, 0x0, 0x40000, 0x1f, x1, 192, x2)

inst_25:
// rs1_val == 524288, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x80000; immval:0x13
TEST_CI_OP( c.srli, x10, 0x1, 0x80000, 0x13, x1, 200, x2)

inst_26:
// rs1_val == 1048576, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x100000; immval:0xf
TEST_CI_OP( c.srli, x10, 0x20, 0x100000, 0xf, x1, 208, x2)

inst_27:
// rs1_val == 2097152, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x200000; immval:0x10
TEST_CI_OP( c.srli, x10, 0x20, 0x200000, 0x10, x1, 216, x2)

inst_28:
// rs1_val == 4194304, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x400000; immval:0x4
TEST_CI_OP( c.srli, x10, 0x40000, 0x400000, 0x4, x1, 224, x2)

inst_29:
// rs1_val == 8388608, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x800000; immval:0xa
TEST_CI_OP( c.srli, x10, 0x2000, 0x800000, 0xa, x1, 232, x2)

inst_30:
// rs1_val == 16777216, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x1000000; immval:0xd
TEST_CI_OP( c.srli, x10, 0x800, 0x1000000, 0xd, x1, 240, x2)

inst_31:
// rs1_val == 33554432, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x2000000; immval:0x3b
TEST_CI_OP( c.srli, x10, 0x0, 0x2000000, 0x3b, x1, 248, x2)

inst_32:
// rs1_val == 67108864, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x4000000; immval:0x10
TEST_CI_OP( c.srli, x10, 0x400, 0x4000000, 0x10, x1, 256, x2)

inst_33:
// rs1_val == 134217728, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x8000000; immval:0x37
TEST_CI_OP( c.srli, x10, 0x0, 0x8000000, 0x37, x1, 264, x2)

inst_34:
// rs1_val == 268435456, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x10000000; immval:0x7
TEST_CI_OP( c.srli, x10, 0x200000, 0x10000000, 0x7, x1, 272, x2)

inst_35:
// rs1_val == 1073741824, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x40000000; immval:0x3b
TEST_CI_OP( c.srli, x10, 0x0, 0x40000000, 0x3b, x1, 280, x2)

inst_36:
// rs1_val == 2147483648, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x80000000; immval:0x9
TEST_CI_OP( c.srli, x10, 0x400000, 0x80000000, 0x9, x1, 288, x2)

inst_37:
// rs1_val == 4294967296, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x100000000; immval:0xe
TEST_CI_OP( c.srli, x10, 0x40000, 0x100000000, 0xe, x1, 296, x2)

inst_38:
// rs1_val == 8589934592, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x200000000; immval:0x1
TEST_CI_OP( c.srli, x10, 0x100000000, 0x200000000, 0x1, x1, 304, x2)

inst_39:
// rs1_val == 17179869184, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x400000000; immval:0x11
TEST_CI_OP( c.srli, x10, 0x20000, 0x400000000, 0x11, x1, 312, x2)

inst_40:
// rs1_val == 34359738368, imm_val == 62
// opcode:c.srli; op1:x10; dest:x10 op1val:0x800000000; immval:0x3e
TEST_CI_OP( c.srli, x10, 0x0, 0x800000000, 0x3e, x1, 320, x2)

inst_41:
// rs1_val == 68719476736, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x1000000000; immval:0xb
TEST_CI_OP( c.srli, x10, 0x2000000, 0x1000000000, 0xb, x1, 328, x2)

inst_42:
// rs1_val == 137438953472, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x2000000000; immval:0x6
TEST_CI_OP( c.srli, x10, 0x80000000, 0x2000000000, 0x6, x1, 336, x2)

inst_43:
// rs1_val == 274877906944, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x4000000000; immval:0x1f
TEST_CI_OP( c.srli, x10, 0x80, 0x4000000000, 0x1f, x1, 344, x2)

inst_44:
// rs1_val == 549755813888, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x8000000000; immval:0x15
TEST_CI_OP( c.srli, x10, 0x40000, 0x8000000000, 0x15, x1, 352, x2)

inst_45:
// rs1_val == 1099511627776, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x10000000000; immval:0x9
TEST_CI_OP( c.srli, x10, 0x80000000, 0x10000000000, 0x9, x1, 360, x2)

inst_46:
// rs1_val == 2199023255552, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x20000000000; immval:0x3e
TEST_CI_OP( c.srli, x10, 0x0, 0x20000000000, 0x3e, x1, 368, x2)

inst_47:
// rs1_val == 4398046511104, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x40000000000; immval:0x3
TEST_CI_OP( c.srli, x10, 0x8000000000, 0x40000000000, 0x3, x1, 376, x2)

inst_48:
// rs1_val == 8796093022208, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x80000000000; immval:0x6
TEST_CI_OP( c.srli, x10, 0x2000000000, 0x80000000000, 0x6, x1, 384, x2)

inst_49:
// rs1_val == 17592186044416, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x100000000000; immval:0x1
TEST_CI_OP( c.srli, x10, 0x80000000000, 0x100000000000, 0x1, x1, 392, x2)

inst_50:
// rs1_val == 35184372088832, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x200000000000; immval:0x3
TEST_CI_OP( c.srli, x10, 0x40000000000, 0x200000000000, 0x3, x1, 400, x2)

inst_51:
// rs1_val == 70368744177664, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x400000000000; immval:0x9
TEST_CI_OP( c.srli, x10, 0x2000000000, 0x400000000000, 0x9, x1, 408, x2)

inst_52:
// rs1_val == 140737488355328, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x800000000000; immval:0x1
TEST_CI_OP( c.srli, x10, 0x400000000000, 0x800000000000, 0x1, x1, 416, x2)

inst_53:
// rs1_val == 281474976710656, imm_val == 47
// opcode:c.srli; op1:x10; dest:x10 op1val:0x1000000000000; immval:0x2f
TEST_CI_OP( c.srli, x10, 0x2, 0x1000000000000, 0x2f, x1, 424, x2)

inst_54:
// rs1_val == 562949953421312, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x2000000000000; immval:0xe
TEST_CI_OP( c.srli, x10, 0x800000000, 0x2000000000000, 0xe, x1, 432, x2)

inst_55:
// rs1_val == 1125899906842624, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x4000000000000; immval:0x3f
TEST_CI_OP( c.srli, x10, 0x0, 0x4000000000000, 0x3f, x1, 440, x2)

inst_56:
// rs1_val == 2251799813685248, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x8000000000000; immval:0x3f
TEST_CI_OP( c.srli, x10, 0x0, 0x8000000000000, 0x3f, x1, 448, x2)

inst_57:
// rs1_val == 4503599627370496, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x10000000000000; immval:0x3f
TEST_CI_OP( c.srli, x10, 0x0, 0x10000000000000, 0x3f, x1, 456, x2)

inst_58:
// rs1_val == 9007199254740992, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x20000000000000; immval:0x12
TEST_CI_OP( c.srli, x10, 0x800000000, 0x20000000000000, 0x12, x1, 464, x2)

inst_59:
// rs1_val == 18014398509481984, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x40000000000000; immval:0x12
TEST_CI_OP( c.srli, x10, 0x1000000000, 0x40000000000000, 0x12, x1, 472, x2)

inst_60:
// rs1_val == 36028797018963968, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x80000000000000; immval:0xa
TEST_CI_OP( c.srli, x10, 0x200000000000, 0x80000000000000, 0xa, x1, 480, x2)

inst_61:
// rs1_val == 72057594037927936, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x100000000000000; immval:0x15
TEST_CI_OP( c.srli, x10, 0x800000000, 0x100000000000000, 0x15, x1, 488, x2)

inst_62:
// rs1_val == 144115188075855872, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x200000000000000; immval:0xb
TEST_CI_OP( c.srli, x10, 0x400000000000, 0x200000000000000, 0xb, x1, 496, x2)

inst_63:
// rs1_val == 288230376151711744, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x400000000000000; immval:0x3d
TEST_CI_OP( c.srli, x10, 0x0, 0x400000000000000, 0x3d, x1, 504, x2)

inst_64:
// rs1_val == 576460752303423488, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x800000000000000; immval:0xf
TEST_CI_OP( c.srli, x10, 0x100000000000, 0x800000000000000, 0xf, x1, 512, x2)

inst_65:
// rs1_val == 1152921504606846976, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x1000000000000000; immval:0x3b
TEST_CI_OP( c.srli, x10, 0x2, 0x1000000000000000, 0x3b, x1, 520, x2)

inst_66:
// rs1_val == 2305843009213693952, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x2000000000000000; immval:0x3f
TEST_CI_OP( c.srli, x10, 0x0, 0x2000000000000000, 0x3f, x1, 528, x2)

inst_67:
// rs1_val == 4611686018427387904, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x4000000000000000; immval:0x9
TEST_CI_OP( c.srli, x10, 0x20000000000000, 0x4000000000000000, 0x9, x1, 536, x2)

inst_68:
// rs1_val == -2, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x2; immval:0xe
TEST_CI_OP( c.srli, x10, 0x3ffffffffffff, -0x2, 0xe, x1, 544, x2)

inst_69:
// rs1_val == -3, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x3; immval:0xc
TEST_CI_OP( c.srli, x10, 0xfffffffffffff, -0x3, 0xc, x1, 552, x2)

inst_70:
// rs1_val == -5, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x5; immval:0x6
TEST_CI_OP( c.srli, x10, 0x3ffffffffffffff, -0x5, 0x6, x1, 560, x2)

inst_71:
// rs1_val == -9, imm_val == 32
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x9; immval:0x20
TEST_CI_OP( c.srli, x10, 0xffffffff, -0x9, 0x20, x1, 568, x2)

inst_72:
// rs1_val == -17, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x11; immval:0x3
TEST_CI_OP( c.srli, x10, 0x1ffffffffffffffd, -0x11, 0x3, x1, 576, x2)

inst_73:
// rs1_val == -33, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x21; immval:0x3
TEST_CI_OP( c.srli, x10, 0x1ffffffffffffffb, -0x21, 0x3, x1, 584, x2)

inst_74:
// rs1_val == -65, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x41; immval:0x2f
TEST_CI_OP( c.srli, x10, 0x1ffff, -0x41, 0x2f, x1, 592, x2)

inst_75:
// rs1_val == -129, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x81; immval:0x20
TEST_CI_OP( c.srli, x10, 0xffffffff, -0x81, 0x20, x1, 600, x2)

inst_76:
// rs1_val == -257, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x101; immval:0x3e
TEST_CI_OP( c.srli, x10, 0x3, -0x101, 0x3e, x1, 608, x2)

inst_77:
// rs1_val == -513, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x201; immval:0x37
TEST_CI_OP( c.srli, x10, 0x1ff, -0x201, 0x37, x1, 616, x2)

inst_78:
// rs1_val == -1025, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x401; immval:0xd
TEST_CI_OP( c.srli, x10, 0x7ffffffffffff, -0x401, 0xd, x1, 624, x2)

inst_79:
// rs1_val == -2049, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x801; immval:0x4
TEST_CI_OP( c.srli, x10, 0xfffffffffffff7f, -0x801, 0x4, x1, 632, x2)

inst_80:
// rs1_val == -4097, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x1001; immval:0xe
TEST_CI_OP( c.srli, x10, 0x3ffffffffffff, -0x1001, 0xe, x1, 640, x2)

inst_81:
// rs1_val == -8193, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x2001; immval:0x11
TEST_CI_OP( c.srli, x10, 0x7fffffffffff, -0x2001, 0x11, x1, 648, x2)

inst_82:
// rs1_val == -16385, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x4001; immval:0x5
TEST_CI_OP( c.srli, x10, 0x7fffffffffffdff, -0x4001, 0x5, x1, 656, x2)

inst_83:
// rs1_val == -32769, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x8001; immval:0x9
TEST_CI_OP( c.srli, x10, 0x7fffffffffffbf, -0x8001, 0x9, x1, 664, x2)

inst_84:
// rs1_val == -65537, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x10001; immval:0x3
TEST_CI_OP( c.srli, x10, 0x1fffffffffffdfff, -0x10001, 0x3, x1, 672, x2)

inst_85:
// rs1_val == -131073, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x20001; immval:0x13
TEST_CI_OP( c.srli, x10, 0x1fffffffffff, -0x20001, 0x13, x1, 680, x2)

inst_86:
// rs1_val == -262145, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x40001; immval:0x1f
TEST_CI_OP( c.srli, x10, 0x1ffffffff, -0x40001, 0x1f, x1, 688, x2)

inst_87:
// rs1_val == -524289, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x80001; immval:0x10
TEST_CI_OP( c.srli, x10, 0xfffffffffff7, -0x80001, 0x10, x1, 696, x2)

inst_88:
// rs1_val == -144115188075855873, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x200000000000001; immval:0x3e
TEST_CI_OP( c.srli, x10, 0x3, -0x200000000000001, 0x3e, x1, 704, x2)

inst_89:
// rs1_val == -288230376151711745, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x400000000000001; immval:0x37
TEST_CI_OP( c.srli, x10, 0x1f7, -0x400000000000001, 0x37, x1, 712, x2)

inst_90:
// rs1_val == -576460752303423489, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x800000000000001; immval:0x15
TEST_CI_OP( c.srli, x10, 0x7bfffffffff, -0x800000000000001, 0x15, x1, 720, x2)

inst_91:
// rs1_val == -1152921504606846977, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x1000000000000001; immval:0x9
TEST_CI_OP( c.srli, x10, 0x77ffffffffffff, -0x1000000000000001, 0x9, x1, 728, x2)

inst_92:
// rs1_val == -2305843009213693953, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x2000000000000001; immval:0x6
TEST_CI_OP( c.srli, x10, 0x37fffffffffffff, -0x2000000000000001, 0x6, x1, 736, x2)

inst_93:
// rs1_val == -4611686018427387905, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x4000000000000001; immval:0x10
TEST_CI_OP( c.srli, x10, 0xbfffffffffff, -0x4000000000000001, 0x10, x1, 744, x2)

inst_94:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode:c.srli; op1:x10; dest:x10 op1val:0x5555555555555555; immval:0x1f
TEST_CI_OP( c.srli, x10, 0xaaaaaaaa, 0x5555555555555555, 0x1f, x1, 752, x2)

inst_95:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x5555555555555556; immval:0x6
TEST_CI_OP( c.srli, x10, 0x2aaaaaaaaaaaaaa, -0x5555555555555556, 0x6, x1, 760, x2)

inst_96:
// rs1_val==3, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x3; immval:0xc
TEST_CI_OP( c.srli, x10, 0x0, 0x3, 0xc, x1, 768, x2)

inst_97:
// rs1_val==3689348814741910323, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x3333333333333333; immval:0xf
TEST_CI_OP( c.srli, x10, 0x666666666666, 0x3333333333333333, 0xf, x1, 776, x2)

inst_98:
// rs1_val==7378697629483820646, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x6666666666666666; immval:0xb
TEST_CI_OP( c.srli, x10, 0xccccccccccccc, 0x6666666666666666, 0xb, x1, 784, x2)

inst_99:
// rs1_val==-3037000499, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0xb504f333; immval:0x37
TEST_CI_OP( c.srli, x10, 0x1ff, -0xb504f333, 0x37, x1, 792, x2)

inst_100:
// rs1_val==3037000499, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0xb504f333; immval:0x7
TEST_CI_OP( c.srli, x10, 0x16a09e6, 0xb504f333, 0x7, x1, 800, x2)

inst_101:
// rs1_val==6148914691236517204, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x5555555555555554; immval:0x20
TEST_CI_OP( c.srli, x10, 0x55555555, 0x5555555555555554, 0x20, x1, 808, x2)

inst_102:
// rs1_val==3689348814741910322, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x3333333333333332; immval:0x1
TEST_CI_OP( c.srli, x10, 0x1999999999999999, 0x3333333333333332, 0x1, x1, 816, x2)

inst_103:
// rs1_val==7378697629483820645, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x6666666666666665; immval:0xd
TEST_CI_OP( c.srli, x10, 0x3333333333333, 0x6666666666666665, 0xd, x1, 824, x2)

inst_104:
// rs1_val==3037000498, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0xb504f332; immval:0xa
TEST_CI_OP( c.srli, x10, 0x2d413c, 0xb504f332, 0xa, x1, 832, x2)

inst_105:
// rs1_val==6148914691236517206, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x5555555555555556; immval:0x2
TEST_CI_OP( c.srli, x10, 0x1555555555555555, 0x5555555555555556, 0x2, x1, 840, x2)

inst_106:
// rs1_val==-6148914691236517205, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x5555555555555555; immval:0x12
TEST_CI_OP( c.srli, x10, 0x2aaaaaaaaaaa, -0x5555555555555555, 0x12, x1, 848, x2)

inst_107:
// rs1_val==6, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x6; immval:0x4
TEST_CI_OP( c.srli, x10, 0x0, 0x6, 0x4, x1, 856, x2)

inst_108:
// rs1_val==3689348814741910324, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x3333333333333334; immval:0xa
TEST_CI_OP( c.srli, x10, 0xccccccccccccc, 0x3333333333333334, 0xa, x1, 864, x2)

inst_109:
// rs1_val==7378697629483820647, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x6666666666666667; immval:0x8
TEST_CI_OP( c.srli, x10, 0x66666666666666, 0x6666666666666667, 0x8, x1, 872, x2)

inst_110:
// rs1_val==-3037000498, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0xb504f332; immval:0x5
TEST_CI_OP( c.srli, x10, 0x7fffffffa57d866, -0xb504f332, 0x5, x1, 880, x2)

inst_111:
// rs1_val==3037000500, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0xb504f334; immval:0x2f
TEST_CI_OP( c.srli, x10, 0x0, 0xb504f334, 0x2f, x1, 888, x2)

inst_112:
// imm_val == 42, 
// opcode:c.srli; op1:x10; dest:x10 op1val:0x100000000000000; immval:0x2a
TEST_CI_OP( c.srli, x10, 0x4000, 0x100000000000000, 0x2a, x1, 896, x2)

inst_113:
// rs1_val == -1048577, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x100001; immval:0x5
TEST_CI_OP( c.srli, x10, 0x7ffffffffff7fff, -0x100001, 0x5, x1, 904, x2)

inst_114:
// rs1_val == -2097153, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x200001; immval:0x20
TEST_CI_OP( c.srli, x10, 0xffffffff, -0x200001, 0x20, x1, 912, x2)

inst_115:
// rs1_val == -4194305, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x400001; immval:0x8
TEST_CI_OP( c.srli, x10, 0xffffffffffbfff, -0x400001, 0x8, x1, 920, x2)

inst_116:
// rs1_val == -8388609, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x800001; immval:0x3d
TEST_CI_OP( c.srli, x10, 0x7, -0x800001, 0x3d, x1, 928, x2)

inst_117:
// rs1_val == -16777217, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x1000001; immval:0x2
TEST_CI_OP( c.srli, x10, 0x3fffffffffbfffff, -0x1000001, 0x2, x1, 936, x2)

inst_118:
// rs1_val == -33554433, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x2000001; immval:0x3
TEST_CI_OP( c.srli, x10, 0x1fffffffffbfffff, -0x2000001, 0x3, x1, 944, x2)

inst_119:
// rs1_val == -67108865, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x4000001; immval:0xa
TEST_CI_OP( c.srli, x10, 0x3ffffffffeffff, -0x4000001, 0xa, x1, 952, x2)

inst_120:
// rs1_val == -134217729, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x8000001; immval:0xa
TEST_CI_OP( c.srli, x10, 0x3ffffffffdffff, -0x8000001, 0xa, x1, 960, x2)

inst_121:
// rs1_val == -268435457, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x10000001; immval:0xd
TEST_CI_OP( c.srli, x10, 0x7ffffffff7fff, -0x10000001, 0xd, x1, 968, x2)

inst_122:
// rs1_val == -536870913, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x20000001; immval:0x1f
TEST_CI_OP( c.srli, x10, 0x1ffffffff, -0x20000001, 0x1f, x1, 976, x2)

inst_123:
// rs1_val == -1073741825, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x40000001; immval:0x20
TEST_CI_OP( c.srli, x10, 0xffffffff, -0x40000001, 0x20, x1, 984, x2)

inst_124:
// rs1_val == -2147483649, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x80000001; immval:0x3e
TEST_CI_OP( c.srli, x10, 0x3, -0x80000001, 0x3e, x1, 992, x2)

inst_125:
// rs1_val == -4294967297, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x100000001; immval:0x37
TEST_CI_OP( c.srli, x10, 0x1ff, -0x100000001, 0x37, x1, 1000, x2)

inst_126:
// rs1_val == -8589934593, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x200000001; immval:0xb
TEST_CI_OP( c.srli, x10, 0x1fffffffbfffff, -0x200000001, 0xb, x1, 1008, x2)

inst_127:
// rs1_val == -17179869185, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x400000001; immval:0x2f
TEST_CI_OP( c.srli, x10, 0x1ffff, -0x400000001, 0x2f, x1, 1016, x2)

inst_128:
// rs1_val == -34359738369, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x800000001; immval:0x3f
TEST_CI_OP( c.srli, x10, 0x1, -0x800000001, 0x3f, x1, 1024, x2)

inst_129:
// rs1_val == -68719476737, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x1000000001; immval:0x5
TEST_CI_OP( c.srli, x10, 0x7ffffff7fffffff, -0x1000000001, 0x5, x1, 1032, x2)

inst_130:
// rs1_val == -137438953473, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x2000000001; immval:0x3d
TEST_CI_OP( c.srli, x10, 0x7, -0x2000000001, 0x3d, x1, 1040, x2)

inst_131:
// rs1_val == -274877906945, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x4000000001; immval:0xd
TEST_CI_OP( c.srli, x10, 0x7fffffdffffff, -0x4000000001, 0xd, x1, 1048, x2)

inst_132:
// rs1_val == -549755813889, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x8000000001; immval:0xb
TEST_CI_OP( c.srli, x10, 0x1fffffefffffff, -0x8000000001, 0xb, x1, 1056, x2)

inst_133:
// rs1_val == -1099511627777, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x10000000001; immval:0x15
TEST_CI_OP( c.srli, x10, 0x7fffff7ffff, -0x10000000001, 0x15, x1, 1064, x2)

inst_134:
// rs1_val == -2199023255553, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x20000000001; immval:0x7
TEST_CI_OP( c.srli, x10, 0x1fffffbffffffff, -0x20000000001, 0x7, x1, 1072, x2)

inst_135:
// rs1_val == -4398046511105, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x40000000001; immval:0x3
TEST_CI_OP( c.srli, x10, 0x1fffff7fffffffff, -0x40000000001, 0x3, x1, 1080, x2)

inst_136:
// rs1_val == -8796093022209, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x80000000001; immval:0xa
TEST_CI_OP( c.srli, x10, 0x3ffffdffffffff, -0x80000000001, 0xa, x1, 1088, x2)

inst_137:
// rs1_val == -17592186044417, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x100000000001; immval:0x3d
TEST_CI_OP( c.srli, x10, 0x7, -0x100000000001, 0x3d, x1, 1096, x2)

inst_138:
// rs1_val == -35184372088833, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x200000000001; immval:0x1f
TEST_CI_OP( c.srli, x10, 0x1ffffbfff, -0x200000000001, 0x1f, x1, 1104, x2)

inst_139:
// rs1_val == -70368744177665, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x400000000001; immval:0xc
TEST_CI_OP( c.srli, x10, 0xffffbffffffff, -0x400000000001, 0xc, x1, 1112, x2)

inst_140:
// rs1_val == -140737488355329, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x800000000001; immval:0x1
TEST_CI_OP( c.srli, x10, 0x7fffbfffffffffff, -0x800000000001, 0x1, x1, 1120, x2)

inst_141:
// rs1_val == -281474976710657, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x1000000000001; immval:0x3
TEST_CI_OP( c.srli, x10, 0x1fffdfffffffffff, -0x1000000000001, 0x3, x1, 1128, x2)

inst_142:
// rs1_val == -562949953421313, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x2000000000001; immval:0x2
TEST_CI_OP( c.srli, x10, 0x3fff7fffffffffff, -0x2000000000001, 0x2, x1, 1136, x2)

inst_143:
// rs1_val == -2251799813685249, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x8000000000001; immval:0x5
TEST_CI_OP( c.srli, x10, 0x7ffbfffffffffff, -0x8000000000001, 0x5, x1, 1144, x2)

inst_144:
// rs1_val == -4503599627370497, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x10000000000001; immval:0x12
TEST_CI_OP( c.srli, x10, 0x3ffbffffffff, -0x10000000000001, 0x12, x1, 1152, x2)

inst_145:
// rs1_val == -9007199254740993, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x20000000000001; immval:0x37
TEST_CI_OP( c.srli, x10, 0x1ff, -0x20000000000001, 0x37, x1, 1160, x2)

inst_146:
// rs1_val == -18014398509481985, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x40000000000001; immval:0xc
TEST_CI_OP( c.srli, x10, 0xffbffffffffff, -0x40000000000001, 0xc, x1, 1168, x2)

inst_147:
// rs1_val == -36028797018963969, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x80000000000001; immval:0x13
TEST_CI_OP( c.srli, x10, 0x1fefffffffff, -0x80000000000001, 0x13, x1, 1176, x2)

inst_148:
// rs1_val == -72057594037927937, 
// opcode:c.srli; op1:x10; dest:x10 op1val:-0x100000000000001; immval:0x2f
TEST_CI_OP( c.srli, x10, 0x1fdff, -0x100000000000001, 0x2f, x1, 1184, x2)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 149*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
