
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the add instruction of the RISC-V I extension for the add covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",add)

RVTEST_SIGBASE( x8,signature_x8_1)

inst_0:
// rs1 == rs2 != rd, rs1==x0, rs2==x0, rd==x20, rs1_val > 0 and rs2_val > 0, rs1_val == 4, rs1_val==4 and rs2_val==6148914691236517206, rs1_val != rs2_val
// opcode: add ; op1:x0; op2:x0; dest:x20; op1val:0x0;  op2val:0x0
TEST_RR_OP(add, x20, x0, x0, 0x0, 0x0, 0x0, x8, 0, x16)

inst_1:
// rs2 == rd != rs1, rs1==x2, rs2==x26, rd==x26, rs1_val > 0 and rs2_val < 0, rs2_val == -1073741825
// opcode: add ; op1:x2; op2:x26; dest:x26; op1val:0x5;  op2val:-0x40000001
TEST_RR_OP(add, x26, x2, x26, 0xffffffffc0000004, 0x5, -0x40000001, x8, 8, x16)

inst_2:
// rs1 == rs2 == rd, rs1==x22, rs2==x22, rd==x22, rs1_val < 0 and rs2_val < 0, rs1_val == -8388609
// opcode: add ; op1:x22; op2:x22; dest:x22; op1val:-0x800001;  op2val:-0x800001
TEST_RR_OP(add, x22, x22, x22, 0xfffffffffefffffe, -0x800001, -0x800001, x8, 16, x16)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x26, rs2==x6, rd==x10, rs1_val < 0 and rs2_val > 0, rs1_val == -65, rs2_val == 36028797018963968
// opcode: add ; op1:x26; op2:x6; dest:x10; op1val:-0x41;  op2val:0x80000000000000
TEST_RR_OP(add, x10, x26, x6, 0x7fffffffffffbf, -0x41, 0x80000000000000, x8, 24, x16)

inst_4:
// rs1 == rd != rs2, rs1==x27, rs2==x23, rd==x27, rs1_val == rs2_val, rs2_val == 64, rs1_val == 64
// opcode: add ; op1:x27; op2:x23; dest:x27; op1val:0x40;  op2val:0x40
TEST_RR_OP(add, x27, x27, x23, 0x80, 0x40, 0x40, x8, 32, x16)

inst_5:
// rs1==x20, rs2==x3, rd==x2, rs2_val == (-2**(xlen-1)), rs2_val == -9223372036854775808
// opcode: add ; op1:x20; op2:x3; dest:x2; op1val:0x6666666666666665;  op2val:-0x8000000000000000
TEST_RR_OP(add, x2, x20, x3, 0xe666666666666665, 0x6666666666666665, -0x8000000000000000, x8, 40, x16)

inst_6:
// rs1==x13, rs2==x30, rd==x14, rs2_val == 0, rs1_val == 1
// opcode: add ; op1:x13; op2:x30; dest:x14; op1val:0x1;  op2val:0x0
TEST_RR_OP(add, x14, x13, x30, 0x1, 0x1, 0x0, x8, 48, x16)

inst_7:
// rs1==x6, rs2==x10, rd==x7, rs2_val == (2**(xlen-1)-1), rs2_val == 9223372036854775807, rs1_val == 131072
// opcode: add ; op1:x6; op2:x10; dest:x7; op1val:0x20000;  op2val:0x7fffffffffffffff
TEST_RR_OP(add, x7, x6, x10, 0x800000000001ffff, 0x20000, 0x7fffffffffffffff, x8, 56, x16)

inst_8:
// rs1==x9, rs2==x25, rd==x1, rs2_val == 1, rs1_val == 268435456
// opcode: add ; op1:x9; op2:x25; dest:x1; op1val:0x10000000;  op2val:0x1
TEST_RR_OP(add, x1, x9, x25, 0x10000001, 0x10000000, 0x1, x8, 64, x16)

inst_9:
// rs1==x14, rs2==x31, rd==x5, rs1_val == (-2**(xlen-1)), rs1_val == -9223372036854775808, rs2_val == -257
// opcode: add ; op1:x14; op2:x31; dest:x5; op1val:-0x8000000000000000;  op2val:-0x101
TEST_RR_OP(add, x5, x14, x31, 0x7ffffffffffffeff, -0x8000000000000000, -0x101, x8, 72, x16)

inst_10:
// rs1==x29, rs2==x1, rd==x19, rs1_val == 0, rs2_val == 8796093022208
// opcode: add ; op1:x29; op2:x1; dest:x19; op1val:0x0;  op2val:0x80000000000
TEST_RR_OP(add, x19, x29, x1, 0x80000000000, 0x0, 0x80000000000, x8, 80, x16)

inst_11:
// rs1==x15, rs2==x11, rd==x21, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807, rs2_val == -65537
// opcode: add ; op1:x15; op2:x11; dest:x21; op1val:0x7fffffffffffffff;  op2val:-0x10001
TEST_RR_OP(add, x21, x15, x11, 0x7ffffffffffefffe, 0x7fffffffffffffff, -0x10001, x8, 88, x16)

inst_12:
// rs1==x3, rs2==x7, rd==x9, rs2_val == 2, rs1_val == -5
// opcode: add ; op1:x3; op2:x7; dest:x9; op1val:-0x5;  op2val:0x2
TEST_RR_OP(add, x9, x3, x7, 0xfffffffffffffffd, -0x5, 0x2, x8, 96, x16)

inst_13:
// rs1==x21, rs2==x27, rd==x6, rs2_val == 4, rs1_val == 2305843009213693952
// opcode: add ; op1:x21; op2:x27; dest:x6; op1val:0x2000000000000000;  op2val:0x4
TEST_RR_OP(add, x6, x21, x27, 0x2000000000000004, 0x2000000000000000, 0x4, x8, 104, x16)

inst_14:
// rs1==x30, rs2==x13, rd==x23, rs2_val == 8, rs1_val == 137438953472
// opcode: add ; op1:x30; op2:x13; dest:x23; op1val:0x2000000000;  op2val:0x8
TEST_RR_OP(add, x23, x30, x13, 0x2000000008, 0x2000000000, 0x8, x8, 112, x16)

inst_15:
// rs1==x10, rs2==x19, rd==x24, rs2_val == 16, rs1_val == -9007199254740993
// opcode: add ; op1:x10; op2:x19; dest:x24; op1val:-0x20000000000001;  op2val:0x10
TEST_RR_OP(add, x24, x10, x19, 0xffe000000000000f, -0x20000000000001, 0x10, x8, 120, x16)

inst_16:
// rs1==x1, rs2==x9, rd==x30, rs2_val == 32, 
// opcode: add ; op1:x1; op2:x9; dest:x30; op1val:0x0;  op2val:0x20
TEST_RR_OP(add, x30, x1, x9, 0x20, 0x0, 0x20, x8, 128, x16)

inst_17:
// rs1==x12, rs2==x4, rd==x13, rs2_val == 128, rs1_val == 576460752303423488
// opcode: add ; op1:x12; op2:x4; dest:x13; op1val:0x800000000000000;  op2val:0x80
TEST_RR_OP(add, x13, x12, x4, 0x800000000000080, 0x800000000000000, 0x80, x8, 136, x16)

inst_18:
// rs1==x18, rs2==x17, rd==x0, rs2_val == 256, 
// opcode: add ; op1:x18; op2:x17; dest:x0; op1val:0x1;  op2val:0x100
TEST_RR_OP(add, x0, x18, x17, 0, 0x1, 0x100, x8, 144, x16)
RVTEST_SIGBASE( x1,signature_x1_0)

inst_19:
// rs1==x19, rs2==x15, rd==x16, rs2_val == 512, rs1_val == 65536
// opcode: add ; op1:x19; op2:x15; dest:x16; op1val:0x10000;  op2val:0x200
TEST_RR_OP(add, x16, x19, x15, 0x10200, 0x10000, 0x200, x1, 0, x6)

inst_20:
// rs1==x28, rs2==x20, rd==x4, rs2_val == 1024, 
// opcode: add ; op1:x28; op2:x20; dest:x4; op1val:0x5;  op2val:0x400
TEST_RR_OP(add, x4, x28, x20, 0x405, 0x5, 0x400, x1, 8, x6)

inst_21:
// rs1==x8, rs2==x28, rd==x12, rs2_val == 2048, rs1_val == -32769
// opcode: add ; op1:x8; op2:x28; dest:x12; op1val:-0x8001;  op2val:0x800
TEST_RR_OP(add, x12, x8, x28, 0xffffffffffff87ff, -0x8001, 0x800, x1, 16, x6)

inst_22:
// rs1==x16, rs2==x5, rd==x11, rs2_val == 4096, rs1_val == 2251799813685248
// opcode: add ; op1:x16; op2:x5; dest:x11; op1val:0x8000000000000;  op2val:0x1000
TEST_RR_OP(add, x11, x16, x5, 0x8000000001000, 0x8000000000000, 0x1000, x1, 24, x6)

inst_23:
// rs1==x4, rs2==x24, rd==x29, rs2_val == 8192, 
// opcode: add ; op1:x4; op2:x24; dest:x29; op1val:-0xb504f332;  op2val:0x2000
TEST_RR_OP(add, x29, x4, x24, 0xffffffff4afb2cce, -0xb504f332, 0x2000, x1, 32, x6)

inst_24:
// rs1==x11, rs2==x29, rd==x3, rs2_val == 16384, rs1_val == -9
// opcode: add ; op1:x11; op2:x29; dest:x3; op1val:-0x9;  op2val:0x4000
TEST_RR_OP(add, x3, x11, x29, 0x3ff7, -0x9, 0x4000, x1, 40, x6)

inst_25:
// rs1==x7, rs2==x12, rd==x15, rs2_val == 32768, 
// opcode: add ; op1:x7; op2:x12; dest:x15; op1val:0x4;  op2val:0x8000
TEST_RR_OP(add, x15, x7, x12, 0x8004, 0x4, 0x8000, x1, 48, x6)

inst_26:
// rs1==x17, rs2==x16, rd==x31, rs2_val == 65536, 
// opcode: add ; op1:x17; op2:x16; dest:x31; op1val:-0x4;  op2val:0x10000
TEST_RR_OP(add, x31, x17, x16, 0xfffc, -0x4, 0x10000, x1, 56, x6)

inst_27:
// rs1==x31, rs2==x18, rd==x17, rs2_val == 131072, 
// opcode: add ; op1:x31; op2:x18; dest:x17; op1val:-0x8000000000000000;  op2val:0x20000
TEST_RR_OP(add, x17, x31, x18, 0x8000000000020000, -0x8000000000000000, 0x20000, x1, 64, x6)

inst_28:
// rs1==x5, rs2==x21, rd==x8, rs2_val == 262144, 
// opcode: add ; op1:x5; op2:x21; dest:x8; op1val:0x5;  op2val:0x40000
TEST_RR_OP(add, x8, x5, x21, 0x40005, 0x5, 0x40000, x1, 72, x6)

inst_29:
// rs1==x24, rs2==x2, rd==x18, rs2_val == 524288, rs1_val == -536870913
// opcode: add ; op1:x24; op2:x2; dest:x18; op1val:-0x20000001;  op2val:0x80000
TEST_RR_OP(add, x18, x24, x2, 0xffffffffe007ffff, -0x20000001, 0x80000, x1, 80, x6)

inst_30:
// rs1==x23, rs2==x14, rd==x25, rs2_val == 1048576, 
// opcode: add ; op1:x23; op2:x14; dest:x25; op1val:0x5;  op2val:0x100000
TEST_RR_OP(add, x25, x23, x14, 0x100005, 0x5, 0x100000, x1, 88, x6)

inst_31:
// rs1==x25, rs2==x8, rd==x28, rs2_val == 2097152, rs1_val == -262145
// opcode: add ; op1:x25; op2:x8; dest:x28; op1val:-0x40001;  op2val:0x200000
TEST_RR_OP(add, x28, x25, x8, 0x1bffff, -0x40001, 0x200000, x1, 96, x6)

inst_32:
// rs2_val == 4194304, rs1_val == 8
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:0x400000
TEST_RR_OP(add, x12, x10, x11, 0x400008, 0x8, 0x400000, x1, 104, x6)

inst_33:
// rs2_val == 8388608, rs1_val == -16777217
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0x800000
TEST_RR_OP(add, x12, x10, x11, 0xffffffffff7fffff, -0x1000001, 0x800000, x1, 112, x6)

inst_34:
// rs2_val == 16777216, rs1_val == -2251799813685249
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000001;  op2val:0x1000000
TEST_RR_OP(add, x12, x10, x11, 0xfff8000000ffffff, -0x8000000000001, 0x1000000, x1, 120, x6)

inst_35:
// rs2_val == 33554432, rs1_val == 2199023255552
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:0x2000000
TEST_RR_OP(add, x12, x10, x11, 0x20002000000, 0x20000000000, 0x2000000, x1, 128, x6)

inst_36:
// rs2_val == 67108864, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0x4000000
TEST_RR_OP(add, x12, x10, x11, 0x3fbffff, -0x40001, 0x4000000, x1, 136, x6)

inst_37:
// rs2_val == 134217728, rs1_val == 2147483648
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0x8000000
TEST_RR_OP(add, x12, x10, x11, 0x88000000, 0x80000000, 0x8000000, x1, 144, x6)

inst_38:
// rs2_val == 268435456, rs1_val == 1073741824
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0x10000000
TEST_RR_OP(add, x12, x10, x11, 0x50000000, 0x40000000, 0x10000000, x1, 152, x6)

inst_39:
// rs2_val == 536870912, rs1_val == 16
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x20000000
TEST_RR_OP(add, x12, x10, x11, 0x20000010, 0x10, 0x20000000, x1, 160, x6)

inst_40:
// rs2_val == 1073741824, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x40000000
TEST_RR_OP(add, x12, x10, x11, 0x3333333373333334, 0x3333333333333334, 0x40000000, x1, 168, x6)

inst_41:
// rs2_val == 2147483648, rs1_val == 549755813888
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0x80000000
TEST_RR_OP(add, x12, x10, x11, 0x8080000000, 0x8000000000, 0x80000000, x1, 176, x6)

inst_42:
// rs2_val == 4294967296, rs1_val == 35184372088832
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0x100000000
TEST_RR_OP(add, x12, x10, x11, 0x200100000000, 0x200000000000, 0x100000000, x1, 184, x6)

inst_43:
// rs2_val == 8589934592, rs1_val == 8192
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0x200000000
TEST_RR_OP(add, x12, x10, x11, 0x200002000, 0x2000, 0x200000000, x1, 192, x6)

inst_44:
// rs2_val == 17179869184, rs1_val == -8589934593
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:0x400000000
TEST_RR_OP(add, x12, x10, x11, 0x1ffffffff, -0x200000001, 0x400000000, x1, 200, x6)

inst_45:
// rs2_val == 34359738368, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0x800000000
TEST_RR_OP(add, x12, x10, x11, 0x800002000, 0x2000, 0x800000000, x1, 208, x6)

inst_46:
// rs2_val == 68719476736, rs1_val == 36028797018963968
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:0x1000000000
TEST_RR_OP(add, x12, x10, x11, 0x80001000000000, 0x80000000000000, 0x1000000000, x1, 216, x6)

inst_47:
// rs2_val == 137438953472, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:0x2000000000
TEST_RR_OP(add, x12, x10, x11, 0x1dffffffff, -0x200000001, 0x2000000000, x1, 224, x6)

inst_48:
// rs2_val == 274877906944, rs1_val == 6148914691236517205
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4000000000
TEST_RR_OP(add, x12, x10, x11, 0x5555559555555555, 0x5555555555555555, 0x4000000000, x1, 232, x6)

inst_49:
// rs2_val == 549755813888, rs1_val == 8388608
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:0x8000000000
TEST_RR_OP(add, x12, x10, x11, 0x8000800000, 0x800000, 0x8000000000, x1, 240, x6)

inst_50:
// rs2_val == 1099511627776, rs1_val == -274877906945
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000001;  op2val:0x10000000000
TEST_RR_OP(add, x12, x10, x11, 0xbfffffffff, -0x4000000001, 0x10000000000, x1, 248, x6)

inst_51:
// rs2_val == 2199023255552, rs1_val == -33
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x20000000000
TEST_RR_OP(add, x12, x10, x11, 0x1ffffffffdf, -0x21, 0x20000000000, x1, 256, x6)

inst_52:
// rs2_val == 4398046511104, rs1_val == 4194304
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0x40000000000
TEST_RR_OP(add, x12, x10, x11, 0x40000400000, 0x400000, 0x40000000000, x1, 264, x6)

inst_53:
// rs2_val == 17592186044416, rs1_val == 1099511627776
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0x100000000000
TEST_RR_OP(add, x12, x10, x11, 0x110000000000, 0x10000000000, 0x100000000000, x1, 272, x6)

inst_54:
// rs2_val == 35184372088832, rs1_val == 134217728
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x200000000000
TEST_RR_OP(add, x12, x10, x11, 0x200008000000, 0x8000000, 0x200000000000, x1, 280, x6)

inst_55:
// rs2_val == 70368744177664, rs1_val == 72057594037927936
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0x400000000000
TEST_RR_OP(add, x12, x10, x11, 0x100400000000000, 0x100000000000000, 0x400000000000, x1, 288, x6)

inst_56:
// rs2_val == 140737488355328, rs1_val == 562949953421312
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0x800000000000
TEST_RR_OP(add, x12, x10, x11, 0x2800000000000, 0x2000000000000, 0x800000000000, x1, 296, x6)

inst_57:
// rs2_val == 281474976710656, rs1_val == -4503599627370497
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0x1000000000000
TEST_RR_OP(add, x12, x10, x11, 0xfff0ffffffffffff, -0x10000000000001, 0x1000000000000, x1, 304, x6)

inst_58:
// rs2_val == 562949953421312, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0x2000000000000
TEST_RR_OP(add, x12, x10, x11, 0xfff1ffffffffffff, -0x10000000000001, 0x2000000000000, x1, 312, x6)

inst_59:
// rs2_val == 1125899906842624, rs1_val == -2147483649
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x80000001;  op2val:0x4000000000000
TEST_RR_OP(add, x12, x10, x11, 0x3ffff7fffffff, -0x80000001, 0x4000000000000, x1, 320, x6)

inst_60:
// rs2_val == 2251799813685248, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0x8000000000000
TEST_RR_OP(add, x12, x10, x11, 0x8000000002000, 0x2000, 0x8000000000000, x1, 328, x6)

inst_61:
// rs2_val == 4503599627370496, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0x10000000000000
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffffff, -0x10000000000001, 0x10000000000000, x1, 336, x6)

inst_62:
// rs2_val == 9007199254740992, rs1_val == 524288
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0x20000000000000
TEST_RR_OP(add, x12, x10, x11, 0x20000000080000, 0x80000, 0x20000000000000, x1, 344, x6)

inst_63:
// rs2_val == 18014398509481984, rs1_val == -2
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:0x40000000000000
TEST_RR_OP(add, x12, x10, x11, 0x3ffffffffffffe, -0x2, 0x40000000000000, x1, 352, x6)

inst_64:
// rs2_val == 72057594037927936, rs1_val == -524289
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x100000000000000
TEST_RR_OP(add, x12, x10, x11, 0xfffffffff7ffff, -0x80001, 0x100000000000000, x1, 360, x6)

inst_65:
// rs2_val == 144115188075855872, rs1_val == 1152921504606846976
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0x200000000000000
TEST_RR_OP(add, x12, x10, x11, 0x1200000000000000, 0x1000000000000000, 0x200000000000000, x1, 368, x6)

inst_66:
// rs2_val == 288230376151711744, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x8;  op2val:0x400000000000000
TEST_RR_OP(add, x12, x10, x11, 0x3fffffffffffff8, -0x8, 0x400000000000000, x1, 376, x6)

inst_67:
// rs2_val == 576460752303423488, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x800000000000000
TEST_RR_OP(add, x12, x10, x11, 0x800000000000004, 0x4, 0x800000000000000, x1, 384, x6)

inst_68:
// rs2_val == 1152921504606846976, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x1000000000000000
TEST_RR_OP(add, x12, x10, x11, 0x7666666666666667, 0x6666666666666667, 0x1000000000000000, x1, 392, x6)

inst_69:
// rs2_val == 2305843009213693952, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x2000000000000000
TEST_RR_OP(add, x12, x10, x11, 0x1ffffffffff7ffff, -0x80001, 0x2000000000000000, x1, 400, x6)

inst_70:
// rs2_val == 4611686018427387904, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4000000000000000
TEST_RR_OP(add, x12, x10, x11, 0x7333333333333333, 0x3333333333333333, 0x4000000000000000, x1, 408, x6)

inst_71:
// rs2_val == -2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x2
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffffffe, 0x0, -0x2, x1, 416, x6)

inst_72:
// rs2_val == -3, rs1_val == -1125899906842625
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000001;  op2val:-0x3
TEST_RR_OP(add, x12, x10, x11, 0xfffbfffffffffffc, -0x4000000000001, -0x3, x1, 424, x6)

inst_73:
// rs2_val == -5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555551, 0x5555555555555556, -0x5, x1, 432, x6)

inst_74:
// rs2_val == -9, rs1_val == -268435457
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:-0x9
TEST_RR_OP(add, x12, x10, x11, 0xffffffffeffffff6, -0x10000001, -0x9, x1, 440, x6)

inst_75:
// rs2_val == -17, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1;  op2val:-0x11
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffffee, -0x1, -0x11, x1, 448, x6)

inst_76:
// rs2_val == -33, rs1_val == -1152921504606846977
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:-0x21
TEST_RR_OP(add, x12, x10, x11, 0xefffffffffffffde, -0x1000000000000001, -0x21, x1, 456, x6)

inst_77:
// rs2_val == -65, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:-0x41
TEST_RR_OP(add, x12, x10, x11, 0x1ffffffffffbf, 0x2000000000000, -0x41, x1, 464, x6)

inst_78:
// rs2_val == -129, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x81
TEST_RR_OP(add, x12, x10, x11, 0xb504f2b1, 0xb504f332, -0x81, x1, 472, x6)

inst_79:
// rs2_val == -513, rs1_val == 32
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:-0x201
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffffe1f, 0x20, -0x201, x1, 480, x6)

inst_80:
// rs2_val == -1025, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:-0x401
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffffc1f, 0x20, -0x401, x1, 488, x6)

inst_81:
// rs2_val == -2049, rs1_val == 256
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:-0x801
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffff8ff, 0x100, -0x801, x1, 496, x6)

inst_82:
// rs2_val == -4097, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:-0x1001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffff7effe, -0x80001, -0x1001, x1, 504, x6)

inst_83:
// rs2_val == -8193, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:-0x2001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffdfff, 0x1000000000000000, -0x2001, x1, 512, x6)

inst_84:
// rs2_val == -16385, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x4001
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffc003, 0x4, -0x4001, x1, 520, x6)

inst_85:
// rs2_val == -32769, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:-0x8001
TEST_RR_OP(add, x12, x10, x11, 0xefffffffffff7ffe, -0x1000000000000001, -0x8001, x1, 528, x6)

inst_86:
// rs2_val == -131073, rs1_val == -65537
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:-0x20001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffcfffe, -0x10001, -0x20001, x1, 536, x6)

inst_87:
// rs2_val == -262145, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:-0x40001
TEST_RR_OP(add, x12, x10, x11, 0x3bffff, 0x400000, -0x40001, x1, 544, x6)

inst_88:
// rs2_val == -524289, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:-0x80001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffef7fffe, -0x1000001, -0x80001, x1, 552, x6)

inst_89:
// rs2_val == -1048577, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffffffffffff;  op2val:-0x100001
TEST_RR_OP(add, x12, x10, x11, 0x7fffffffffeffffe, 0x7fffffffffffffff, -0x100001, x1, 560, x6)

inst_90:
// rs2_val == -2097153, rs1_val == -70368744177665
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000001;  op2val:-0x200001
TEST_RR_OP(add, x12, x10, x11, 0xffffbfffffdffffe, -0x400000000001, -0x200001, x1, 568, x6)

inst_91:
// rs2_val == -4194305, rs1_val == -36028797018963969
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:-0x400001
TEST_RR_OP(add, x12, x10, x11, 0xff7fffffffbffffe, -0x80000000000001, -0x400001, x1, 576, x6)

inst_92:
// rs2_val == -8388609, rs1_val == 1048576
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:-0x800001
TEST_RR_OP(add, x12, x10, x11, 0xffffffffff8fffff, 0x100000, -0x800001, x1, 584, x6)

inst_93:
// rs2_val == -16777217, rs1_val == 140737488355328
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:-0x1000001
TEST_RR_OP(add, x12, x10, x11, 0x7ffffeffffff, 0x800000000000, -0x1000001, x1, 592, x6)

inst_94:
// rs2_val == -33554433, rs1_val == -17592186044417
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000001;  op2val:-0x2000001
TEST_RR_OP(add, x12, x10, x11, 0xffffeffffdfffffe, -0x100000000001, -0x2000001, x1, 600, x6)

inst_95:
// rs2_val == -67108865, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:-0x4000001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffc00ffff, 0x10000, -0x4000001, x1, 608, x6)

inst_96:
// rs2_val == -134217729, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x4;  op2val:-0x8000001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffff7fffffb, -0x4, -0x8000001, x1, 616, x6)

inst_97:
// rs2_val == -268435457, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:-0x10000001
TEST_RR_OP(add, x12, x10, x11, 0x7fffefffffff, 0x800000000000, -0x10000001, x1, 624, x6)

inst_98:
// rs2_val == -536870913, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:-0x20000001
TEST_RR_OP(add, x12, x10, x11, 0x1fffffffdfffffff, 0x2000000000000000, -0x20000001, x1, 632, x6)

inst_99:
// rs2_val == -2147483649, rs1_val == -4194305
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:-0x80000001
TEST_RR_OP(add, x12, x10, x11, 0xffffffff7fbffffe, -0x400001, -0x80000001, x1, 640, x6)

inst_100:
// rs2_val == -4294967297, rs1_val == 9007199254740992
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:-0x100000001
TEST_RR_OP(add, x12, x10, x11, 0x1ffffeffffffff, 0x20000000000000, -0x100000001, x1, 648, x6)

inst_101:
// rs2_val == -8589934593, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:-0x200000001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffe003fffff, 0x400000, -0x200000001, x1, 656, x6)

inst_102:
// rs2_val == -17179869185, rs1_val == -144115188075855873
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:-0x400000001
TEST_RR_OP(add, x12, x10, x11, 0xfdfffffbfffffffe, -0x200000000000001, -0x400000001, x1, 664, x6)

inst_103:
// rs2_val == -34359738369, rs1_val == 274877906944
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:-0x800000001
TEST_RR_OP(add, x12, x10, x11, 0x37ffffffff, 0x4000000000, -0x800000001, x1, 672, x6)

inst_104:
// rs2_val == -68719476737, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x1000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffffef4afb0ccc, -0xb504f333, -0x1000000001, x1, 680, x6)

inst_105:
// rs2_val == -137438953473, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:-0x2000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffffdffffefffe, -0x10001, -0x2000000001, x1, 688, x6)

inst_106:
// rs2_val == -274877906945, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:-0x4000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffffbfffffffbe, -0x41, -0x4000000001, x1, 696, x6)

inst_107:
// rs2_val == -549755813889, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x8000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffff8000000003, 0x4, -0x8000000001, x1, 704, x6)

inst_108:
// rs2_val == -1099511627777, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:-0x10000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffff000000003f, 0x40, -0x10000000001, x1, 712, x6)

inst_109:
// rs2_val == -2199023255553, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:-0x20000000001
TEST_RR_OP(add, x12, x10, x11, 0xffeffdfffffffffe, -0x10000000000001, -0x20000000001, x1, 720, x6)

inst_110:
// rs2_val == -4398046511105, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x40000000001
TEST_RR_OP(add, x12, x10, x11, 0xfffffc0000000004, 0x5, -0x40000000001, x1, 728, x6)

inst_111:
// rs2_val == -8796093022209, rs1_val == -8796093022209
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:-0x80000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffeffffffffffe, -0x80000000001, -0x80000000001, x1, 736, x6)

inst_112:
// rs2_val == -17592186044417, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:-0x100000000001
TEST_RR_OP(add, x12, x10, x11, 0xfffff0000000000f, 0x10, -0x100000000001, x1, 744, x6)

inst_113:
// rs2_val == -35184372088833, rs1_val == -137438953473
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000001;  op2val:-0x200000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffdfdffffffffe, -0x2000000001, -0x200000000001, x1, 752, x6)

inst_114:
// rs2_val == -70368744177665, rs1_val == 1024
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:-0x400000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffc000000003ff, 0x400, -0x400000000001, x1, 760, x6)

inst_115:
// rs2_val == -140737488355329, rs1_val == 67108864
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:-0x800000000001
TEST_RR_OP(add, x12, x10, x11, 0xffff800003ffffff, 0x4000000, -0x800000000001, x1, 768, x6)

inst_116:
// rs2_val == -281474976710657, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:-0x1000000000001
TEST_RR_OP(add, x12, x10, x11, 0xffff003fffffffff, 0x4000000000, -0x1000000000001, x1, 776, x6)

inst_117:
// rs2_val == -562949953421313, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:-0x2000000000001
TEST_RR_OP(add, x12, x10, x11, 0xfffe000000001fff, 0x2000, -0x2000000000001, x1, 784, x6)

inst_118:
// rs2_val == -1125899906842625, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:-0x4000000000001
TEST_RR_OP(add, x12, x10, x11, 0xfffc003fffffffff, 0x4000000000, -0x4000000000001, x1, 792, x6)

inst_119:
// rs2_val == -2251799813685249, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:-0x8000000000001
TEST_RR_OP(add, x12, x10, x11, 0xfff7ffffdffffffe, -0x20000001, -0x8000000000001, x1, 800, x6)

inst_120:
// rs2_val == -4503599627370497, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:-0x10000000000001
TEST_RR_OP(add, x12, x10, x11, 0xfff000ffffffffff, 0x10000000000, -0x10000000000001, x1, 808, x6)

inst_121:
// rs2_val == -9007199254740993, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x20000000000001
TEST_RR_OP(add, x12, x10, x11, 0x5535555555555553, 0x5555555555555554, -0x20000000000001, x1, 816, x6)

inst_122:
// rs2_val == -18014398509481985, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x40000000000001
TEST_RR_OP(add, x12, x10, x11, 0x5515555555555554, 0x5555555555555555, -0x40000000000001, x1, 824, x6)

inst_123:
// rs2_val == -36028797018963969, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:-0x80000000000001
TEST_RR_OP(add, x12, x10, x11, 0xff7ffffffff7fffe, -0x80001, -0x80000000000001, x1, 832, x6)

inst_124:
// rs2_val == -72057594037927937, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x100000000000001
TEST_RR_OP(add, x12, x10, x11, 0xff00000000000004, 0x5, -0x100000000000001, x1, 840, x6)

inst_125:
// rs2_val == -144115188075855873, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x200000000000001
TEST_RR_OP(add, x12, x10, x11, 0xa8aaaaaaaaaaaaaa, -0x5555555555555555, -0x200000000000001, x1, 848, x6)

inst_126:
// rs2_val == -288230376151711745, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x400000000000001
TEST_RR_OP(add, x12, x10, x11, 0xfbffffffffffffff, 0x0, -0x400000000000001, x1, 856, x6)

inst_127:
// rs2_val == -576460752303423489, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:-0x800000000000001
TEST_RR_OP(add, x12, x10, x11, 0xf7ffffffffffffde, -0x21, -0x800000000000001, x1, 864, x6)

inst_128:
// rs2_val == -1152921504606846977, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:-0x1000000000000001
TEST_RR_OP(add, x12, x10, x11, 0xf00000000000001f, 0x20, -0x1000000000000001, x1, 872, x6)

inst_129:
// rs2_val == -2305843009213693953, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x2000000000000001
TEST_RR_OP(add, x12, x10, x11, 0x8aaaaaaaaaaaaaaa, -0x5555555555555555, -0x2000000000000001, x1, 880, x6)

inst_130:
// rs2_val == -4611686018427387905, rs1_val == 512
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:-0x4000000000000001
TEST_RR_OP(add, x12, x10, x11, 0xc0000000000001ff, 0x200, -0x4000000000000001, x1, 888, x6)

inst_131:
// rs2_val == 6148914691236517205, rs1_val==7378697629483820646 and rs2_val==6148914691236517205
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x6666666666666666, 0x5555555555555555, x1, 896, x6)

inst_132:
// rs2_val == -6148914691236517206, rs1_val == 18014398509481984
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaeaaaaaaaaaaaaa, 0x40000000000000, -0x5555555555555556, x1, 904, x6)

inst_133:
// rs1_val == 2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x10000000000000
TEST_RR_OP(add, x12, x10, x11, 0x10000000000002, 0x2, 0x10000000000000, x1, 912, x6)

inst_134:
// rs1_val == 128, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:0x10000000000
TEST_RR_OP(add, x12, x10, x11, 0x10000000080, 0x80, 0x10000000000, x1, 920, x6)

inst_135:
// rs1_val == 2048, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:-0x80000001
TEST_RR_OP(add, x12, x10, x11, 0xffffffff800007ff, 0x800, -0x80000001, x1, 928, x6)

inst_136:
// rs1_val == 4096, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0x4000000
TEST_RR_OP(add, x12, x10, x11, 0x4001000, 0x1000, 0x4000000, x1, 936, x6)

inst_137:
// rs1_val == 16384, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:-0x100001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffff03fff, 0x4000, -0x100001, x1, 944, x6)

inst_138:
// rs1_val == 32768, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:-0x6
TEST_RR_OP(add, x12, x10, x11, 0x7ffa, 0x8000, -0x6, x1, 952, x6)

inst_139:
// rs1_val == 262144, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:-0x40000001
TEST_RR_OP(add, x12, x10, x11, 0xffffffffc003ffff, 0x40000, -0x40000001, x1, 960, x6)

inst_140:
// rs1_val == 2097152, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xb524f334, 0x200000, 0xb504f334, x1, 968, x6)

inst_141:
// rs1_val == 16777216, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:-0x4001
TEST_RR_OP(add, x12, x10, x11, 0xffbfff, 0x1000000, -0x4001, x1, 976, x6)

inst_142:
// rs1_val == 33554432, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:-0x80000000000001
TEST_RR_OP(add, x12, x10, x11, 0xff80000001ffffff, 0x2000000, -0x80000000000001, x1, 984, x6)

inst_143:
// rs1_val == 536870912, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x80
TEST_RR_OP(add, x12, x10, x11, 0x20000080, 0x20000000, 0x80, x1, 992, x6)

inst_144:
// rs1_val == 4294967296, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:-0x8000000000000000
TEST_RR_OP(add, x12, x10, x11, 0x8000000100000000, 0x100000000, -0x8000000000000000, x1, 1000, x6)

inst_145:
// rs1_val == 8589934592, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:0x4000000000000000
TEST_RR_OP(add, x12, x10, x11, 0x4000000200000000, 0x200000000, 0x4000000000000000, x1, 1008, x6)

inst_146:
// rs1_val == 17179869184, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:0x80000
TEST_RR_OP(add, x12, x10, x11, 0x400080000, 0x400000000, 0x80000, x1, 1016, x6)

inst_147:
// rs1_val == 34359738368, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x20000000000000
TEST_RR_OP(add, x12, x10, x11, 0x20000800000000, 0x800000000, 0x20000000000000, x1, 1024, x6)

inst_148:
// rs1_val == 68719476736, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:-0x10000001
TEST_RR_OP(add, x12, x10, x11, 0xfefffffff, 0x1000000000, -0x10000001, x1, 1032, x6)

inst_149:
// rs1_val == 4398046511104, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0x200
TEST_RR_OP(add, x12, x10, x11, 0x40000000200, 0x40000000000, 0x200, x1, 1040, x6)

inst_150:
// rs1_val == 8796093022208, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x4000000
TEST_RR_OP(add, x12, x10, x11, 0x80004000000, 0x80000000000, 0x4000000, x1, 1048, x6)

inst_151:
// rs1_val == 17592186044416, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0x80000000000000
TEST_RR_OP(add, x12, x10, x11, 0x80100000000000, 0x100000000000, 0x80000000000000, x1, 1056, x6)

inst_152:
// rs1_val == 70368744177664, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0x800000000000000
TEST_RR_OP(add, x12, x10, x11, 0x800400000000000, 0x400000000000, 0x800000000000000, x1, 1064, x6)

inst_153:
// rs1_val == 281474976710656, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:0x40
TEST_RR_OP(add, x12, x10, x11, 0x1000000000040, 0x1000000000000, 0x40, x1, 1072, x6)

inst_154:
// rs1_val == 1125899906842624, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:0x400000
TEST_RR_OP(add, x12, x10, x11, 0x4000000400000, 0x4000000000000, 0x400000, x1, 1080, x6)

inst_155:
// rs1_val == 4503599627370496, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0x40
TEST_RR_OP(add, x12, x10, x11, 0x10000000000040, 0x10000000000000, 0x40, x1, 1088, x6)

inst_156:
// rs1_val == 144115188075855872, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:-0x10000001
TEST_RR_OP(add, x12, x10, x11, 0x1ffffffefffffff, 0x200000000000000, -0x10000001, x1, 1096, x6)

inst_157:
// rs1_val == 288230376151711744, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x5955555555555554, 0x400000000000000, 0x5555555555555554, x1, 1104, x6)

inst_158:
// rs1_val == 4611686018427387904, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x4000000000000000, 0x4000000000000000, 0x0, x1, 1112, x6)

inst_159:
// rs1_val == -3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:-0x6
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffffff7, -0x3, -0x6, x1, 1120, x6)

inst_160:
// rs1_val == -17, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:0x4000000
TEST_RR_OP(add, x12, x10, x11, 0x3ffffef, -0x11, 0x4000000, x1, 1128, x6)

inst_161:
// rs1_val == -129, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffff7f, -0x81, 0x0, x1, 1136, x6)

inst_162:
// rs1_val == -257, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:0x200
TEST_RR_OP(add, x12, x10, x11, 0xff, -0x101, 0x200, x1, 1144, x6)

inst_163:
// rs1_val == -513, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:-0x4000001
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffbfffdfe, -0x201, -0x4000001, x1, 1152, x6)

inst_164:
// rs1_val == -1025, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:-0x5
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffffbfa, -0x401, -0x5, x1, 1160, x6)

inst_165:
// rs1_val == -2049, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x3333333333332b31, -0x801, 0x3333333333333332, x1, 1168, x6)

inst_166:
// rs1_val == -4097, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:-0x200001
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffdfeffe, -0x1001, -0x200001, x1, 1176, x6)

inst_167:
// rs1_val == -8193, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:-0x4000000000000001
TEST_RR_OP(add, x12, x10, x11, 0xbfffffffffffdffe, -0x2001, -0x4000000000000001, x1, 1184, x6)

inst_168:
// rs1_val == -16385, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:-0x100001
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffefbffe, -0x4001, -0x100001, x1, 1192, x6)

inst_169:
// rs1_val == -131073, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:0x8
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffe0007, -0x20001, 0x8, x1, 1200, x6)

inst_170:
// rs1_val == -1048577, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x6666666666566664, -0x100001, 0x6666666666666665, x1, 1208, x6)

inst_171:
// rs1_val == -2097153, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:-0x80000000000001
TEST_RR_OP(add, x12, x10, x11, 0xff7fffffffdffffe, -0x200001, -0x80000000000001, x1, 1216, x6)

inst_172:
// rs1_val == -33554433, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0x4000000000000
TEST_RR_OP(add, x12, x10, x11, 0x3fffffdffffff, -0x2000001, 0x4000000000000, x1, 1224, x6)

inst_173:
// rs1_val == -67108865, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:0x8000000
TEST_RR_OP(add, x12, x10, x11, 0x3ffffff, -0x4000001, 0x8000000, x1, 1232, x6)

inst_174:
// rs1_val == -134217729, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:-0x1000000000000001
TEST_RR_OP(add, x12, x10, x11, 0xeffffffff7fffffe, -0x8000001, -0x1000000000000001, x1, 1240, x6)

inst_175:
// rs1_val == -1073741825, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0x4000000
TEST_RR_OP(add, x12, x10, x11, 0xffffffffc3ffffff, -0x40000001, 0x4000000, x1, 1248, x6)

inst_176:
// rs1_val == -4294967297, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:-0x200000000001
TEST_RR_OP(add, x12, x10, x11, 0xffffdffefffffffe, -0x100000001, -0x200000000001, x1, 1256, x6)

inst_177:
// rs1_val == -17179869185, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x400000001;  op2val:-0x20000000000001
TEST_RR_OP(add, x12, x10, x11, 0xffdffffbfffffffe, -0x400000001, -0x20000000000001, x1, 1264, x6)

inst_178:
// rs1_val == -34359738369, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x800000001;  op2val:0x400000000000000
TEST_RR_OP(add, x12, x10, x11, 0x3fffff7ffffffff, -0x800000001, 0x400000000000000, x1, 1272, x6)

inst_179:
// rs1_val == -68719476737, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:-0x4
TEST_RR_OP(add, x12, x10, x11, 0xffffffeffffffffb, -0x1000000001, -0x4, x1, 1280, x6)

inst_180:
// rs1_val == -549755813889, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0x10000000000
TEST_RR_OP(add, x12, x10, x11, 0x7fffffffff, -0x8000000001, 0x10000000000, x1, 1288, x6)

inst_181:
// rs1_val == -1099511627777, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000001;  op2val:0x2000
TEST_RR_OP(add, x12, x10, x11, 0xffffff0000001fff, -0x10000000001, 0x2000, x1, 1296, x6)

inst_182:
// rs1_val == -2199023255553, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000001;  op2val:0x10000000000
TEST_RR_OP(add, x12, x10, x11, 0xfffffeffffffffff, -0x20000000001, 0x10000000000, x1, 1304, x6)

inst_183:
// rs1_val == -4398046511105, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:-0x40000000001
TEST_RR_OP(add, x12, x10, x11, 0xfffff7fffffffffe, -0x40000000001, -0x40000000001, x1, 1312, x6)

inst_184:
// rs1_val == -35184372088833, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000001;  op2val:-0x8001
TEST_RR_OP(add, x12, x10, x11, 0xffffdfffffff7ffe, -0x200000000001, -0x8001, x1, 1320, x6)

inst_185:
// rs1_val == -140737488355329, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0x20000000000000
TEST_RR_OP(add, x12, x10, x11, 0x1f7fffffffffff, -0x800000000001, 0x20000000000000, x1, 1328, x6)

inst_186:
// rs1_val == -281474976710657, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000001;  op2val:-0x800000001
TEST_RR_OP(add, x12, x10, x11, 0xfffefff7fffffffe, -0x1000000000001, -0x800000001, x1, 1336, x6)

inst_187:
// rs1_val == -562949953421313, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000001;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xfffe0000b504f332, -0x2000000000001, 0xb504f333, x1, 1344, x6)

inst_188:
// rs1_val == -18014398509481985, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000000001;  op2val:-0x3
TEST_RR_OP(add, x12, x10, x11, 0xffbffffffffffffc, -0x40000000000001, -0x3, x1, 1352, x6)

inst_189:
// rs1_val == -72057594037927937, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000000001;  op2val:-0x801
TEST_RR_OP(add, x12, x10, x11, 0xfefffffffffff7fe, -0x100000000000001, -0x801, x1, 1360, x6)

inst_190:
// rs1_val == -288230376151711745, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:0x1000000000000000
TEST_RR_OP(add, x12, x10, x11, 0xbffffffffffffff, -0x400000000000001, 0x1000000000000000, x1, 1368, x6)

inst_191:
// rs1_val == -576460752303423489, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xf8000000b504f331, -0x800000000000001, 0xb504f332, x1, 1376, x6)

inst_192:
// rs1_val == -2305843009213693953, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000000001;  op2val:0x800000000000000
TEST_RR_OP(add, x12, x10, x11, 0xe7ffffffffffffff, -0x2000000000000001, 0x800000000000000, x1, 1384, x6)

inst_193:
// rs1_val == -4611686018427387905, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:-0x401
TEST_RR_OP(add, x12, x10, x11, 0xbffffffffffffbfe, -0x4000000000000001, -0x401, x1, 1392, x6)

inst_194:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206 and rs2_val==0
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, 0x0, x1, 1400, x6)

inst_195:
// rs1_val==3 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x3, 0x3, x1, 1408, x6)

inst_196:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555558, 0x3, 0x5555555555555555, x1, 1416, x6)

inst_197:
// rs1_val==3 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaad, 0x3, -0x5555555555555556, x1, 1424, x6)

inst_198:
// rs1_val==3 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x3, 0x5, x1, 1432, x6)

inst_199:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333336, 0x3, 0x3333333333333333, x1, 1440, x6)

inst_200:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666669, 0x3, 0x6666666666666666, x1, 1448, x6)

inst_201:
// rs1_val==3 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd0, 0x3, -0xb504f333, x1, 1456, x6)

inst_202:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xb504f336, 0x3, 0xb504f333, x1, 1464, x6)

inst_203:
// rs1_val==3 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x5, 0x3, 0x2, x1, 1472, x6)

inst_204:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555557, 0x3, 0x5555555555555554, x1, 1480, x6)

inst_205:
// rs1_val==3 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x3, 0x3, 0x0, x1, 1488, x6)

inst_206:
// rs1_val==3 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x7, 0x3, 0x4, x1, 1496, x6)

inst_207:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333335, 0x3, 0x3333333333333332, x1, 1504, x6)

inst_208:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666668, 0x3, 0x6666666666666665, x1, 1512, x6)

inst_209:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xb504f335, 0x3, 0xb504f332, x1, 1520, x6)

inst_210:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555559, 0x3, 0x5555555555555556, x1, 1528, x6)

inst_211:
// rs1_val==3 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaae, 0x3, -0x5555555555555555, x1, 1536, x6)

inst_212:
// rs1_val==3 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x9, 0x3, 0x6, x1, 1544, x6)

inst_213:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333337, 0x3, 0x3333333333333334, x1, 1552, x6)

inst_214:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666a, 0x3, 0x6666666666666667, x1, 1560, x6)

inst_215:
// rs1_val==3 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd1, 0x3, -0xb504f332, x1, 1568, x6)

inst_216:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xb504f337, 0x3, 0xb504f334, x1, 1576, x6)

inst_217:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555558, 0x5555555555555555, 0x3, x1, 1584, x6)

inst_218:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555555, 0x5555555555555555, x1, 1592, x6)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffffff, 0x5555555555555555, -0x5555555555555556, x1, 1600, x6)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555a, 0x5555555555555555, 0x5, x1, 1608, x6)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888888, 0x5555555555555555, 0x3333333333333333, x1, 1616, x6)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x5555555555555555, 0x6666666666666666, x1, 1624, x6)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506222, 0x5555555555555555, -0xb504f333, x1, 1632, x6)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4888, 0x5555555555555555, 0xb504f333, x1, 1640, x6)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555557, 0x5555555555555555, 0x2, x1, 1648, x6)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x5555555555555555, 0x5555555555555554, x1, 1656, x6)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x0, x1, 1664, x6)

inst_228:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555559, 0x5555555555555555, 0x4, x1, 1672, x6)

inst_229:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888887, 0x5555555555555555, 0x3333333333333332, x1, 1680, x6)

inst_230:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbba, 0x5555555555555555, 0x6666666666666665, x1, 1688, x6)

inst_231:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4887, 0x5555555555555555, 0xb504f332, x1, 1696, x6)

inst_232:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaab, 0x5555555555555555, 0x5555555555555556, x1, 1704, x6)

inst_233:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x0, 0x5555555555555555, -0x5555555555555555, x1, 1712, x6)

inst_234:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555b, 0x5555555555555555, 0x6, x1, 1720, x6)

inst_235:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888889, 0x5555555555555555, 0x3333333333333334, x1, 1728, x6)

inst_236:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbc, 0x5555555555555555, 0x6666666666666667, x1, 1736, x6)

inst_237:
// rs1_val==6148914691236517205 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506223, 0x5555555555555555, -0xb504f332, x1, 1744, x6)

inst_238:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4889, 0x5555555555555555, 0xb504f334, x1, 1752, x6)

inst_239:
// rs1_val==-6148914691236517206 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaad, -0x5555555555555556, 0x3, x1, 1760, x6)

inst_240:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffffff, -0x5555555555555556, 0x5555555555555555, x1, 1768, x6)

inst_241:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555554, -0x5555555555555556, -0x5555555555555556, x1, 1776, x6)

inst_242:
// rs1_val==-6148914691236517206 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaf, -0x5555555555555556, 0x5, x1, 1784, x6)

inst_243:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0xdddddddddddddddd, -0x5555555555555556, 0x3333333333333333, x1, 1792, x6)

inst_244:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111110, -0x5555555555555556, 0x6666666666666666, x1, 1800, x6)

inst_245:
// rs1_val==-6148914691236517206 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9f5a5b777, -0x5555555555555556, -0xb504f333, x1, 1808, x6)

inst_246:
// rs1_val==-6148914691236517206 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9ddd, -0x5555555555555556, 0xb504f333, x1, 1816, x6)

inst_247:
// rs1_val==-6148914691236517206 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaac, -0x5555555555555556, 0x2, x1, 1824, x6)

inst_248:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffffffe, -0x5555555555555556, 0x5555555555555554, x1, 1832, x6)

inst_249:
// rs1_val==-6148914691236517206 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x4, x1, 1840, x6)

inst_250:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0xdddddddddddddddc, -0x5555555555555556, 0x3333333333333332, x1, 1848, x6)

inst_251:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x111111111111110f, -0x5555555555555556, 0x6666666666666665, x1, 1856, x6)

inst_252:
// rs1_val==-6148914691236517206 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9ddc, -0x5555555555555556, 0xb504f332, x1, 1864, x6)

inst_253:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x0, -0x5555555555555556, 0x5555555555555556, x1, 1872, x6)

inst_254:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555555, -0x5555555555555556, -0x5555555555555555, x1, 1880, x6)

inst_255:
// rs1_val==-6148914691236517206 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaab0, -0x5555555555555556, 0x6, x1, 1888, x6)

inst_256:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0xddddddddddddddde, -0x5555555555555556, 0x3333333333333334, x1, 1896, x6)

inst_257:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111111, -0x5555555555555556, 0x6666666666666667, x1, 1904, x6)

inst_258:
// rs1_val==-6148914691236517206 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9f5a5b778, -0x5555555555555556, -0xb504f332, x1, 1912, x6)

inst_259:
// rs1_val==-6148914691236517206 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9dde, -0x5555555555555556, 0xb504f334, x1, 1920, x6)

inst_260:
// rs1_val==5 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x5, 0x3, x1, 1928, x6)

inst_261:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555a, 0x5, 0x5555555555555555, x1, 1936, x6)

inst_262:
// rs1_val==5 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaf, 0x5, -0x5555555555555556, x1, 1944, x6)

inst_263:
// rs1_val==5 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xa, 0x5, 0x5, x1, 1952, x6)

inst_264:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333338, 0x5, 0x3333333333333333, x1, 1960, x6)

inst_265:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666b, 0x5, 0x6666666666666666, x1, 1968, x6)

inst_266:
// rs1_val==5 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd2, 0x5, -0xb504f333, x1, 1976, x6)

inst_267:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xb504f338, 0x5, 0xb504f333, x1, 1984, x6)

inst_268:
// rs1_val==5 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x7, 0x5, 0x2, x1, 1992, x6)

inst_269:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555559, 0x5, 0x5555555555555554, x1, 2000, x6)

inst_270:
// rs1_val==5 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x5, 0x5, 0x0, x1, 2008, x6)

inst_271:
// rs1_val==5 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x9, 0x5, 0x4, x1, 2016, x6)

inst_272:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333337, 0x5, 0x3333333333333332, x1, 2024, x6)

inst_273:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666a, 0x5, 0x6666666666666665, x1, 2032, x6)

inst_274:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xb504f337, 0x5, 0xb504f332, x1, 2040, x6)
RVTEST_SIGBASE( x1,signature_x1_1)

inst_275:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555b, 0x5, 0x5555555555555556, x1, 0, x6)

inst_276:
// rs1_val==5 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaab0, 0x5, -0x5555555555555555, x1, 8, x6)

inst_277:
// rs1_val==5 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xb, 0x5, 0x6, x1, 16, x6)

inst_278:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333339, 0x5, 0x3333333333333334, x1, 24, x6)

inst_279:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666c, 0x5, 0x6666666666666667, x1, 32, x6)

inst_280:
// rs1_val==5 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd3, 0x5, -0xb504f332, x1, 40, x6)

inst_281:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xb504f339, 0x5, 0xb504f334, x1, 48, x6)

inst_282:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333336, 0x3333333333333333, 0x3, x1, 56, x6)

inst_283:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888888, 0x3333333333333333, 0x5555555555555555, x1, 64, x6)

inst_284:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xdddddddddddddddd, 0x3333333333333333, -0x5555555555555556, x1, 72, x6)

inst_285:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333338, 0x3333333333333333, 0x5, x1, 80, x6)

inst_286:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666666, 0x3333333333333333, 0x3333333333333333, x1, 88, x6)

inst_287:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999999, 0x3333333333333333, 0x6666666666666666, x1, 96, x6)

inst_288:
// rs1_val==3689348814741910323 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4000, 0x3333333333333333, -0xb504f333, x1, 104, x6)

inst_289:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382666, 0x3333333333333333, 0xb504f333, x1, 112, x6)

inst_290:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333335, 0x3333333333333333, 0x2, x1, 120, x6)

inst_291:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888887, 0x3333333333333333, 0x5555555555555554, x1, 128, x6)

inst_292:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x0, x1, 136, x6)

inst_293:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333337, 0x3333333333333333, 0x4, x1, 144, x6)

inst_294:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666665, 0x3333333333333333, 0x3333333333333332, x1, 152, x6)

inst_295:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999998, 0x3333333333333333, 0x6666666666666665, x1, 160, x6)

inst_296:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382665, 0x3333333333333333, 0xb504f332, x1, 168, x6)

inst_297:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888889, 0x3333333333333333, 0x5555555555555556, x1, 176, x6)

inst_298:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xddddddddddddddde, 0x3333333333333333, -0x5555555555555555, x1, 184, x6)

inst_299:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333339, 0x3333333333333333, 0x6, x1, 192, x6)

inst_300:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666667, 0x3333333333333333, 0x3333333333333334, x1, 200, x6)

inst_301:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x999999999999999a, 0x3333333333333333, 0x6666666666666667, x1, 208, x6)

inst_302:
// rs1_val==3689348814741910323 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4001, 0x3333333333333333, -0xb504f332, x1, 216, x6)

inst_303:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382667, 0x3333333333333333, 0xb504f334, x1, 224, x6)

inst_304:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666669, 0x6666666666666666, 0x3, x1, 232, x6)

inst_305:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111110, 0x6666666666666666, -0x5555555555555556, x1, 240, x6)

inst_306:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666b, 0x6666666666666666, 0x5, x1, 248, x6)

inst_307:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999999, 0x6666666666666666, 0x3333333333333333, x1, 256, x6)

inst_308:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0xcccccccccccccccc, 0x6666666666666666, 0x6666666666666666, x1, 264, x6)

inst_309:
// rs1_val==7378697629483820646 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617333, 0x6666666666666666, -0xb504f333, x1, 272, x6)

inst_310:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5999, 0x6666666666666666, 0xb504f333, x1, 280, x6)

inst_311:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666668, 0x6666666666666666, 0x2, x1, 288, x6)

inst_312:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbba, 0x6666666666666666, 0x5555555555555554, x1, 296, x6)

inst_313:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666666, 0x6666666666666666, 0x0, x1, 304, x6)

inst_314:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666a, 0x6666666666666666, 0x4, x1, 312, x6)

inst_315:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999998, 0x6666666666666666, 0x3333333333333332, x1, 320, x6)

inst_316:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0xcccccccccccccccb, 0x6666666666666666, 0x6666666666666665, x1, 328, x6)

inst_317:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5998, 0x6666666666666666, 0xb504f332, x1, 336, x6)

inst_318:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbc, 0x6666666666666666, 0x5555555555555556, x1, 344, x6)

inst_319:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111111, 0x6666666666666666, -0x5555555555555555, x1, 352, x6)

inst_320:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666c, 0x6666666666666666, 0x6, x1, 360, x6)

inst_321:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x999999999999999a, 0x6666666666666666, 0x3333333333333334, x1, 368, x6)

inst_322:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0xcccccccccccccccd, 0x6666666666666666, 0x6666666666666667, x1, 376, x6)

inst_323:
// rs1_val==7378697629483820646 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617334, 0x6666666666666666, -0xb504f332, x1, 384, x6)

inst_324:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b599a, 0x6666666666666666, 0xb504f334, x1, 392, x6)

inst_325:
// rs1_val==-3037000499 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd0, -0xb504f333, 0x3, x1, 400, x6)

inst_326:
// rs1_val==-3037000499 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506222, -0xb504f333, 0x5555555555555555, x1, 408, x6)

inst_327:
// rs1_val==-3037000499 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9f5a5b777, -0xb504f333, -0x5555555555555556, x1, 416, x6)

inst_328:
// rs1_val==-3037000499 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd2, -0xb504f333, 0x5, x1, 424, x6)

inst_329:
// rs1_val==-3037000499 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4000, -0xb504f333, 0x3333333333333333, x1, 432, x6)

inst_330:
// rs1_val==-3037000499 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617333, -0xb504f333, 0x6666666666666666, x1, 440, x6)

inst_331:
// rs1_val==-3037000499 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xfffffffe95f6199a, -0xb504f333, -0xb504f333, x1, 448, x6)

inst_332:
// rs1_val==-3037000499 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x0, -0xb504f333, 0xb504f333, x1, 456, x6)

inst_333:
// rs1_val==-3037000499 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0ccf, -0xb504f333, 0x2, x1, 464, x6)

inst_334:
// rs1_val==-3037000499 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506221, -0xb504f333, 0x5555555555555554, x1, 472, x6)

inst_335:
// rs1_val==-3037000499 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0ccd, -0xb504f333, 0x0, x1, 480, x6)

inst_336:
// rs1_val==-3037000499 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd1, -0xb504f333, 0x4, x1, 488, x6)

inst_337:
// rs1_val==-3037000499 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e3fff, -0xb504f333, 0x3333333333333332, x1, 496, x6)

inst_338:
// rs1_val==-3037000499 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617332, -0xb504f333, 0x6666666666666665, x1, 504, x6)

inst_339:
// rs1_val==-3037000499 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffffff, -0xb504f333, 0xb504f332, x1, 512, x6)

inst_340:
// rs1_val==-3037000499 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506223, -0xb504f333, 0x5555555555555556, x1, 520, x6)

inst_341:
// rs1_val==-3037000499 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9f5a5b778, -0xb504f333, -0x5555555555555555, x1, 528, x6)

inst_342:
// rs1_val==-3037000499 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd3, -0xb504f333, 0x6, x1, 536, x6)

inst_343:
// rs1_val==-3037000499 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4001, -0xb504f333, 0x3333333333333334, x1, 544, x6)

inst_344:
// rs1_val==-3037000499 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617334, -0xb504f333, 0x6666666666666667, x1, 552, x6)

inst_345:
// rs1_val==-3037000499 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xfffffffe95f6199b, -0xb504f333, -0xb504f332, x1, 560, x6)

inst_346:
// rs1_val==-3037000499 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x1, -0xb504f333, 0xb504f334, x1, 568, x6)

inst_347:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xb504f336, 0xb504f333, 0x3, x1, 576, x6)

inst_348:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4888, 0xb504f333, 0x5555555555555555, x1, 584, x6)

inst_349:
// rs1_val==3037000499 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9ddd, 0xb504f333, -0x5555555555555556, x1, 592, x6)

inst_350:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xb504f338, 0xb504f333, 0x5, x1, 600, x6)

inst_351:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382666, 0xb504f333, 0x3333333333333333, x1, 608, x6)

inst_352:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5999, 0xb504f333, 0x6666666666666666, x1, 616, x6)

inst_353:
// rs1_val==3037000499 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x0, 0xb504f333, -0xb504f333, x1, 624, x6)

inst_354:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x16a09e666, 0xb504f333, 0xb504f333, x1, 632, x6)

inst_355:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xb504f335, 0xb504f333, 0x2, x1, 640, x6)

inst_356:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4887, 0xb504f333, 0x5555555555555554, x1, 648, x6)

inst_357:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xb504f333, 0xb504f333, 0x0, x1, 656, x6)

inst_358:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xb504f337, 0xb504f333, 0x4, x1, 664, x6)

inst_359:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382665, 0xb504f333, 0x3333333333333332, x1, 672, x6)

inst_360:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5998, 0xb504f333, 0x6666666666666665, x1, 680, x6)

inst_361:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x16a09e665, 0xb504f333, 0xb504f332, x1, 688, x6)

inst_362:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4889, 0xb504f333, 0x5555555555555556, x1, 696, x6)

inst_363:
// rs1_val==3037000499 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9dde, 0xb504f333, -0x5555555555555555, x1, 704, x6)

inst_364:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xb504f339, 0xb504f333, 0x6, x1, 712, x6)

inst_365:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382667, 0xb504f333, 0x3333333333333334, x1, 720, x6)

inst_366:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b599a, 0xb504f333, 0x6666666666666667, x1, 728, x6)

inst_367:
// rs1_val==3037000499 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x1, 0xb504f333, -0xb504f332, x1, 736, x6)

inst_368:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x16a09e667, 0xb504f333, 0xb504f334, x1, 744, x6)

inst_369:
// rs1_val==2 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x5, 0x2, 0x3, x1, 752, x6)

inst_370:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555557, 0x2, 0x5555555555555555, x1, 760, x6)

inst_371:
// rs1_val==2 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaac, 0x2, -0x5555555555555556, x1, 768, x6)

inst_372:
// rs1_val==2 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x7, 0x2, 0x5, x1, 776, x6)

inst_373:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333335, 0x2, 0x3333333333333333, x1, 784, x6)

inst_374:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666668, 0x2, 0x6666666666666666, x1, 792, x6)

inst_375:
// rs1_val==2 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0ccf, 0x2, -0xb504f333, x1, 800, x6)

inst_376:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xb504f335, 0x2, 0xb504f333, x1, 808, x6)

inst_377:
// rs1_val==2 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x4, 0x2, 0x2, x1, 816, x6)

inst_378:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555556, 0x2, 0x5555555555555554, x1, 824, x6)

inst_379:
// rs1_val==2 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x2, 0x2, 0x0, x1, 832, x6)

inst_380:
// rs1_val==2 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x2, 0x4, x1, 840, x6)

inst_381:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333334, 0x2, 0x3333333333333332, x1, 848, x6)

inst_382:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666667, 0x2, 0x6666666666666665, x1, 856, x6)

inst_383:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xb504f334, 0x2, 0xb504f332, x1, 864, x6)

inst_384:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555558, 0x2, 0x5555555555555556, x1, 872, x6)

inst_385:
// rs1_val==2 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaad, 0x2, -0x5555555555555555, x1, 880, x6)

inst_386:
// rs1_val==2 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x2, 0x6, x1, 888, x6)

inst_387:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333336, 0x2, 0x3333333333333334, x1, 896, x6)

inst_388:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666669, 0x2, 0x6666666666666667, x1, 904, x6)

inst_389:
// rs1_val==2 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd0, 0x2, -0xb504f332, x1, 912, x6)

inst_390:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xb504f336, 0x2, 0xb504f334, x1, 920, x6)

inst_391:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555557, 0x5555555555555554, 0x3, x1, 928, x6)

inst_392:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x5555555555555554, 0x5555555555555555, x1, 936, x6)

inst_393:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xfffffffffffffffe, 0x5555555555555554, -0x5555555555555556, x1, 944, x6)

inst_394:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555559, 0x5555555555555554, 0x5, x1, 952, x6)

inst_395:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888887, 0x5555555555555554, 0x3333333333333333, x1, 960, x6)

inst_396:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbba, 0x5555555555555554, 0x6666666666666666, x1, 968, x6)

inst_397:
// rs1_val==6148914691236517204 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506221, 0x5555555555555554, -0xb504f333, x1, 976, x6)

inst_398:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4887, 0x5555555555555554, 0xb504f333, x1, 984, x6)

inst_399:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555556, 0x5555555555555554, 0x2, x1, 992, x6)

inst_400:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaa8, 0x5555555555555554, 0x5555555555555554, x1, 1000, x6)

inst_401:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x0, x1, 1008, x6)

inst_402:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555558, 0x5555555555555554, 0x4, x1, 1016, x6)

inst_403:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888886, 0x5555555555555554, 0x3333333333333332, x1, 1024, x6)

inst_404:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbb9, 0x5555555555555554, 0x6666666666666665, x1, 1032, x6)

inst_405:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4886, 0x5555555555555554, 0xb504f332, x1, 1040, x6)

inst_406:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555554, 0x5555555555555556, x1, 1048, x6)

inst_407:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffffff, 0x5555555555555554, -0x5555555555555555, x1, 1056, x6)

inst_408:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555a, 0x5555555555555554, 0x6, x1, 1064, x6)

inst_409:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888888, 0x5555555555555554, 0x3333333333333334, x1, 1072, x6)

inst_410:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x5555555555555554, 0x6666666666666667, x1, 1080, x6)

inst_411:
// rs1_val==6148914691236517204 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506222, 0x5555555555555554, -0xb504f332, x1, 1088, x6)

inst_412:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4888, 0x5555555555555554, 0xb504f334, x1, 1096, x6)

inst_413:
// rs1_val==0 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x3, 0x0, 0x3, x1, 1104, x6)

inst_414:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555555, 0x0, 0x5555555555555555, x1, 1112, x6)

inst_415:
// rs1_val==0 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x0, -0x5555555555555556, x1, 1120, x6)

inst_416:
// rs1_val==0 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x5, 0x0, 0x5, x1, 1128, x6)

inst_417:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333333, 0x0, 0x3333333333333333, x1, 1136, x6)

inst_418:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666666, 0x0, 0x6666666666666666, x1, 1144, x6)

inst_419:
// rs1_val==0 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0ccd, 0x0, -0xb504f333, x1, 1152, x6)

inst_420:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xb504f333, 0x0, 0xb504f333, x1, 1160, x6)

inst_421:
// rs1_val==0 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cce, 0x0, -0xb504f332, x1, 1168, x6)

inst_422:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xb504f334, 0x0, 0xb504f334, x1, 1176, x6)

inst_423:
// rs1_val==4 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x7, 0x4, 0x3, x1, 1184, x6)

inst_424:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555559, 0x4, 0x5555555555555555, x1, 1192, x6)

inst_425:
// rs1_val==4 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaae, 0x4, -0x5555555555555556, x1, 1200, x6)

inst_426:
// rs1_val==4 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x9, 0x4, 0x5, x1, 1208, x6)

inst_427:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333337, 0x4, 0x3333333333333333, x1, 1216, x6)

inst_428:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666a, 0x4, 0x6666666666666666, x1, 1224, x6)

inst_429:
// rs1_val==4 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd1, 0x4, -0xb504f333, x1, 1232, x6)

inst_430:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xb504f337, 0x4, 0xb504f333, x1, 1240, x6)

inst_431:
// rs1_val==4 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x4, 0x2, x1, 1248, x6)

inst_432:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555558, 0x4, 0x5555555555555554, x1, 1256, x6)

inst_433:
// rs1_val==4 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x4, 0x4, 0x0, x1, 1264, x6)

inst_434:
// rs1_val==4 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x4, 0x4, x1, 1272, x6)

inst_435:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333336, 0x4, 0x3333333333333332, x1, 1280, x6)

inst_436:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666669, 0x4, 0x6666666666666665, x1, 1288, x6)

inst_437:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xb504f336, 0x4, 0xb504f332, x1, 1296, x6)

inst_438:
// rs1_val==4 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaf, 0x4, -0x5555555555555555, x1, 1304, x6)

inst_439:
// rs1_val==4 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xa, 0x4, 0x6, x1, 1312, x6)

inst_440:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333338, 0x4, 0x3333333333333334, x1, 1320, x6)

inst_441:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666b, 0x4, 0x6666666666666667, x1, 1328, x6)

inst_442:
// rs1_val==4 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd2, 0x4, -0xb504f332, x1, 1336, x6)

inst_443:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xb504f338, 0x4, 0xb504f334, x1, 1344, x6)

inst_444:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333335, 0x3333333333333332, 0x3, x1, 1352, x6)

inst_445:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888887, 0x3333333333333332, 0x5555555555555555, x1, 1360, x6)

inst_446:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xdddddddddddddddc, 0x3333333333333332, -0x5555555555555556, x1, 1368, x6)

inst_447:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333337, 0x3333333333333332, 0x5, x1, 1376, x6)

inst_448:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666665, 0x3333333333333332, 0x3333333333333333, x1, 1384, x6)

inst_449:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999998, 0x3333333333333332, 0x6666666666666666, x1, 1392, x6)

inst_450:
// rs1_val==3689348814741910322 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e3fff, 0x3333333333333332, -0xb504f333, x1, 1400, x6)

inst_451:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382665, 0x3333333333333332, 0xb504f333, x1, 1408, x6)

inst_452:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333334, 0x3333333333333332, 0x2, x1, 1416, x6)

inst_453:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888886, 0x3333333333333332, 0x5555555555555554, x1, 1424, x6)

inst_454:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x0, x1, 1432, x6)

inst_455:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333336, 0x3333333333333332, 0x4, x1, 1440, x6)

inst_456:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666664, 0x3333333333333332, 0x3333333333333332, x1, 1448, x6)

inst_457:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999997, 0x3333333333333332, 0x6666666666666665, x1, 1456, x6)

inst_458:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382664, 0x3333333333333332, 0xb504f332, x1, 1464, x6)

inst_459:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888888, 0x3333333333333332, 0x5555555555555556, x1, 1472, x6)

inst_460:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xdddddddddddddddd, 0x3333333333333332, -0x5555555555555555, x1, 1480, x6)

inst_461:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333338, 0x3333333333333332, 0x6, x1, 1488, x6)

inst_462:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666666, 0x3333333333333332, 0x3333333333333334, x1, 1496, x6)

inst_463:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999999, 0x3333333333333332, 0x6666666666666667, x1, 1504, x6)

inst_464:
// rs1_val==3689348814741910322 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4000, 0x3333333333333332, -0xb504f332, x1, 1512, x6)

inst_465:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382666, 0x3333333333333332, 0xb504f334, x1, 1520, x6)

inst_466:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666668, 0x6666666666666665, 0x3, x1, 1528, x6)

inst_467:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbba, 0x6666666666666665, 0x5555555555555555, x1, 1536, x6)

inst_468:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x111111111111110f, 0x6666666666666665, -0x5555555555555556, x1, 1544, x6)

inst_469:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666a, 0x6666666666666665, 0x5, x1, 1552, x6)

inst_470:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999998, 0x6666666666666665, 0x3333333333333333, x1, 1560, x6)

inst_471:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0xcccccccccccccccb, 0x6666666666666665, 0x6666666666666666, x1, 1568, x6)

inst_472:
// rs1_val==7378697629483820645 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617332, 0x6666666666666665, -0xb504f333, x1, 1576, x6)

inst_473:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5998, 0x6666666666666665, 0xb504f333, x1, 1584, x6)

inst_474:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666667, 0x6666666666666665, 0x2, x1, 1592, x6)

inst_475:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbb9, 0x6666666666666665, 0x5555555555555554, x1, 1600, x6)

inst_476:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666665, 0x6666666666666665, 0x0, x1, 1608, x6)

inst_477:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666669, 0x6666666666666665, 0x4, x1, 1616, x6)

inst_478:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999997, 0x6666666666666665, 0x3333333333333332, x1, 1624, x6)

inst_479:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0xccccccccccccccca, 0x6666666666666665, 0x6666666666666665, x1, 1632, x6)

inst_480:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5997, 0x6666666666666665, 0xb504f332, x1, 1640, x6)

inst_481:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x6666666666666665, 0x5555555555555556, x1, 1648, x6)

inst_482:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111110, 0x6666666666666665, -0x5555555555555555, x1, 1656, x6)

inst_483:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666b, 0x6666666666666665, 0x6, x1, 1664, x6)

inst_484:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999999, 0x6666666666666665, 0x3333333333333334, x1, 1672, x6)

inst_485:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0xcccccccccccccccc, 0x6666666666666665, 0x6666666666666667, x1, 1680, x6)

inst_486:
// rs1_val==7378697629483820645 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617333, 0x6666666666666665, -0xb504f332, x1, 1688, x6)

inst_487:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5999, 0x6666666666666665, 0xb504f334, x1, 1696, x6)

inst_488:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xb504f335, 0xb504f332, 0x3, x1, 1704, x6)

inst_489:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4887, 0xb504f332, 0x5555555555555555, x1, 1712, x6)

inst_490:
// rs1_val==3037000498 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9ddc, 0xb504f332, -0x5555555555555556, x1, 1720, x6)

inst_491:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xb504f337, 0xb504f332, 0x5, x1, 1728, x6)

inst_492:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382665, 0xb504f332, 0x3333333333333333, x1, 1736, x6)

inst_493:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5998, 0xb504f332, 0x6666666666666666, x1, 1744, x6)

inst_494:
// rs1_val==3037000498 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffffff, 0xb504f332, -0xb504f333, x1, 1752, x6)

inst_495:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x16a09e665, 0xb504f332, 0xb504f333, x1, 1760, x6)

inst_496:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xb504f334, 0xb504f332, 0x2, x1, 1768, x6)

inst_497:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4886, 0xb504f332, 0x5555555555555554, x1, 1776, x6)

inst_498:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xb504f332, 0xb504f332, 0x0, x1, 1784, x6)

inst_499:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xb504f336, 0xb504f332, 0x4, x1, 1792, x6)

inst_500:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382664, 0xb504f332, 0x3333333333333332, x1, 1800, x6)

inst_501:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5997, 0xb504f332, 0x6666666666666665, x1, 1808, x6)

inst_502:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x16a09e664, 0xb504f332, 0xb504f332, x1, 1816, x6)

inst_503:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4888, 0xb504f332, 0x5555555555555556, x1, 1824, x6)

inst_504:
// rs1_val==3037000498 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9ddd, 0xb504f332, -0x5555555555555555, x1, 1832, x6)

inst_505:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xb504f338, 0xb504f332, 0x6, x1, 1840, x6)

inst_506:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382666, 0xb504f332, 0x3333333333333334, x1, 1848, x6)

inst_507:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5999, 0xb504f332, 0x6666666666666667, x1, 1856, x6)

inst_508:
// rs1_val==3037000498 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x0, 0xb504f332, -0xb504f332, x1, 1864, x6)

inst_509:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x16a09e666, 0xb504f332, 0xb504f334, x1, 1872, x6)

inst_510:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555559, 0x5555555555555556, 0x3, x1, 1880, x6)

inst_511:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaab, 0x5555555555555556, 0x5555555555555555, x1, 1888, x6)

inst_512:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x0, 0x5555555555555556, -0x5555555555555556, x1, 1896, x6)

inst_513:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555b, 0x5555555555555556, 0x5, x1, 1904, x6)

inst_514:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888889, 0x5555555555555556, 0x3333333333333333, x1, 1912, x6)

inst_515:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbc, 0x5555555555555556, 0x6666666666666666, x1, 1920, x6)

inst_516:
// rs1_val==6148914691236517206 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506223, 0x5555555555555556, -0xb504f333, x1, 1928, x6)

inst_517:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4889, 0x5555555555555556, 0xb504f333, x1, 1936, x6)

inst_518:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555558, 0x5555555555555556, 0x2, x1, 1944, x6)

inst_519:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555556, 0x5555555555555554, x1, 1952, x6)

inst_520:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0x0, x1, 1960, x6)

inst_521:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555a, 0x5555555555555556, 0x4, x1, 1968, x6)

inst_522:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888888, 0x5555555555555556, 0x3333333333333332, x1, 1976, x6)

inst_523:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x5555555555555556, 0x6666666666666665, x1, 1984, x6)

inst_524:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4888, 0x5555555555555556, 0xb504f332, x1, 1992, x6)

inst_525:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaac, 0x5555555555555556, 0x5555555555555556, x1, 2000, x6)

inst_526:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x1, 0x5555555555555556, -0x5555555555555555, x1, 2008, x6)

inst_527:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555c, 0x5555555555555556, 0x6, x1, 2016, x6)

inst_528:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x888888888888888a, 0x5555555555555556, 0x3333333333333334, x1, 2024, x6)

inst_529:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbd, 0x5555555555555556, 0x6666666666666667, x1, 2032, x6)

inst_530:
// rs1_val==6148914691236517206 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506224, 0x5555555555555556, -0xb504f332, x1, 2040, x6)
RVTEST_SIGBASE( x1,signature_x1_2)

inst_531:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a488a, 0x5555555555555556, 0xb504f334, x1, 0, x6)

inst_532:
// rs1_val==-6148914691236517205 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaae, -0x5555555555555555, 0x3, x1, 8, x6)

inst_533:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x0, -0x5555555555555555, 0x5555555555555555, x1, 16, x6)

inst_534:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555555, -0x5555555555555555, -0x5555555555555556, x1, 24, x6)

inst_535:
// rs1_val==-6148914691236517205 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaab0, -0x5555555555555555, 0x5, x1, 32, x6)

inst_536:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0xddddddddddddddde, -0x5555555555555555, 0x3333333333333333, x1, 40, x6)

inst_537:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111111, -0x5555555555555555, 0x6666666666666666, x1, 48, x6)

inst_538:
// rs1_val==-6148914691236517205 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9f5a5b778, -0x5555555555555555, -0xb504f333, x1, 56, x6)

inst_539:
// rs1_val==-6148914691236517205 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9dde, -0x5555555555555555, 0xb504f333, x1, 64, x6)

inst_540:
// rs1_val==-6148914691236517205 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaad, -0x5555555555555555, 0x2, x1, 72, x6)

inst_541:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0xffffffffffffffff, -0x5555555555555555, 0x5555555555555554, x1, 80, x6)

inst_542:
// rs1_val==-6148914691236517205 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, 0x0, x1, 88, x6)

inst_543:
// rs1_val==-6148914691236517205 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x4, x1, 96, x6)

inst_544:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0xdddddddddddddddd, -0x5555555555555555, 0x3333333333333332, x1, 104, x6)

inst_545:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111110, -0x5555555555555555, 0x6666666666666665, x1, 112, x6)

inst_546:
// rs1_val==-6148914691236517205 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9ddd, -0x5555555555555555, 0xb504f332, x1, 120, x6)

inst_547:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x1, -0x5555555555555555, 0x5555555555555556, x1, 128, x6)

inst_548:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555556, -0x5555555555555555, -0x5555555555555555, x1, 136, x6)

inst_549:
// rs1_val==-6148914691236517205 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaab1, -0x5555555555555555, 0x6, x1, 144, x6)

inst_550:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0xdddddddddddddddf, -0x5555555555555555, 0x3333333333333334, x1, 152, x6)

inst_551:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111112, -0x5555555555555555, 0x6666666666666667, x1, 160, x6)

inst_552:
// rs1_val==-6148914691236517205 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9f5a5b779, -0x5555555555555555, -0xb504f332, x1, 168, x6)

inst_553:
// rs1_val==-6148914691236517205 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9ddf, -0x5555555555555555, 0xb504f334, x1, 176, x6)

inst_554:
// rs1_val==6 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x9, 0x6, 0x3, x1, 184, x6)

inst_555:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555b, 0x6, 0x5555555555555555, x1, 192, x6)

inst_556:
// rs1_val==6 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaab0, 0x6, -0x5555555555555556, x1, 200, x6)

inst_557:
// rs1_val==6 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xb, 0x6, 0x5, x1, 208, x6)

inst_558:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333339, 0x6, 0x3333333333333333, x1, 216, x6)

inst_559:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666c, 0x6, 0x6666666666666666, x1, 224, x6)

inst_560:
// rs1_val==6 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd3, 0x6, -0xb504f333, x1, 232, x6)

inst_561:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xb504f339, 0x6, 0xb504f333, x1, 240, x6)

inst_562:
// rs1_val==6 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x8, 0x6, 0x2, x1, 248, x6)

inst_563:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555a, 0x6, 0x5555555555555554, x1, 256, x6)

inst_564:
// rs1_val==6 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x6, 0x0, x1, 264, x6)

inst_565:
// rs1_val==6 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xa, 0x6, 0x4, x1, 272, x6)

inst_566:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333338, 0x6, 0x3333333333333332, x1, 280, x6)

inst_567:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666b, 0x6, 0x6666666666666665, x1, 288, x6)

inst_568:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xb504f338, 0x6, 0xb504f332, x1, 296, x6)

inst_569:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555c, 0x6, 0x5555555555555556, x1, 304, x6)

inst_570:
// rs1_val==6 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaab1, 0x6, -0x5555555555555555, x1, 312, x6)

inst_571:
// rs1_val==6 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xc, 0x6, 0x6, x1, 320, x6)

inst_572:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x333333333333333a, 0x6, 0x3333333333333334, x1, 328, x6)

inst_573:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666d, 0x6, 0x6666666666666667, x1, 336, x6)

inst_574:
// rs1_val==6 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd4, 0x6, -0xb504f332, x1, 344, x6)

inst_575:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0xb504f33a, 0x6, 0xb504f334, x1, 352, x6)

inst_576:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333337, 0x3333333333333334, 0x3, x1, 360, x6)

inst_577:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888889, 0x3333333333333334, 0x5555555555555555, x1, 368, x6)

inst_578:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xddddddddddddddde, 0x3333333333333334, -0x5555555555555556, x1, 376, x6)

inst_579:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333339, 0x3333333333333334, 0x5, x1, 384, x6)

inst_580:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666667, 0x3333333333333334, 0x3333333333333333, x1, 392, x6)

inst_581:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x999999999999999a, 0x3333333333333334, 0x6666666666666666, x1, 400, x6)

inst_582:
// rs1_val==3689348814741910324 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4001, 0x3333333333333334, -0xb504f333, x1, 408, x6)

inst_583:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382667, 0x3333333333333334, 0xb504f333, x1, 416, x6)

inst_584:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333336, 0x3333333333333334, 0x2, x1, 424, x6)

inst_585:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x8888888888888888, 0x3333333333333334, 0x5555555555555554, x1, 432, x6)

inst_586:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x0, x1, 440, x6)

inst_587:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333338, 0x3333333333333334, 0x4, x1, 448, x6)

inst_588:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666666, 0x3333333333333334, 0x3333333333333332, x1, 456, x6)

inst_589:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999999, 0x3333333333333334, 0x6666666666666665, x1, 464, x6)

inst_590:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382666, 0x3333333333333334, 0xb504f332, x1, 472, x6)

inst_591:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x888888888888888a, 0x3333333333333334, 0x5555555555555556, x1, 480, x6)

inst_592:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xdddddddddddddddf, 0x3333333333333334, -0x5555555555555555, x1, 488, x6)

inst_593:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x333333333333333a, 0x3333333333333334, 0x6, x1, 496, x6)

inst_594:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666668, 0x3333333333333334, 0x3333333333333334, x1, 504, x6)

inst_595:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x999999999999999b, 0x3333333333333334, 0x6666666666666667, x1, 512, x6)

inst_596:
// rs1_val==3689348814741910324 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4002, 0x3333333333333334, -0xb504f332, x1, 520, x6)

inst_597:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382668, 0x3333333333333334, 0xb504f334, x1, 528, x6)

inst_598:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666a, 0x6666666666666667, 0x3, x1, 536, x6)

inst_599:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbc, 0x6666666666666667, 0x5555555555555555, x1, 544, x6)

inst_600:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111111, 0x6666666666666667, -0x5555555555555556, x1, 552, x6)

inst_601:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666c, 0x6666666666666667, 0x5, x1, 560, x6)

inst_602:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x999999999999999a, 0x6666666666666667, 0x3333333333333333, x1, 568, x6)

inst_603:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0xcccccccccccccccd, 0x6666666666666667, 0x6666666666666666, x1, 576, x6)

inst_604:
// rs1_val==7378697629483820647 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617334, 0x6666666666666667, -0xb504f333, x1, 584, x6)

inst_605:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b599a, 0x6666666666666667, 0xb504f333, x1, 592, x6)

inst_606:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666669, 0x6666666666666667, 0x2, x1, 600, x6)

inst_607:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbb, 0x6666666666666667, 0x5555555555555554, x1, 608, x6)

inst_608:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666667, 0x6666666666666667, 0x0, x1, 616, x6)

inst_609:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666b, 0x6666666666666667, 0x4, x1, 624, x6)

inst_610:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x9999999999999999, 0x6666666666666667, 0x3333333333333332, x1, 632, x6)

inst_611:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0xcccccccccccccccc, 0x6666666666666667, 0x6666666666666665, x1, 640, x6)

inst_612:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5999, 0x6666666666666667, 0xb504f332, x1, 648, x6)

inst_613:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xbbbbbbbbbbbbbbbd, 0x6666666666666667, 0x5555555555555556, x1, 656, x6)

inst_614:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x1111111111111112, 0x6666666666666667, -0x5555555555555555, x1, 664, x6)

inst_615:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x666666666666666d, 0x6666666666666667, 0x6, x1, 672, x6)

inst_616:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x999999999999999b, 0x6666666666666667, 0x3333333333333334, x1, 680, x6)

inst_617:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0xccccccccccccccce, 0x6666666666666667, 0x6666666666666667, x1, 688, x6)

inst_618:
// rs1_val==7378697629483820647 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617335, 0x6666666666666667, -0xb504f332, x1, 696, x6)

inst_619:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b599b, 0x6666666666666667, 0xb504f334, x1, 704, x6)

inst_620:
// rs1_val==-3037000498 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd1, -0xb504f332, 0x3, x1, 712, x6)

inst_621:
// rs1_val==-3037000498 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506223, -0xb504f332, 0x5555555555555555, x1, 720, x6)

inst_622:
// rs1_val==-3037000498 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9f5a5b778, -0xb504f332, -0x5555555555555556, x1, 728, x6)

inst_623:
// rs1_val==-3037000498 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd3, -0xb504f332, 0x5, x1, 736, x6)

inst_624:
// rs1_val==-3037000498 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4001, -0xb504f332, 0x3333333333333333, x1, 744, x6)

inst_625:
// rs1_val==-3037000498 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617334, -0xb504f332, 0x6666666666666666, x1, 752, x6)

inst_626:
// rs1_val==-3037000498 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0xfffffffe95f6199b, -0xb504f332, -0xb504f333, x1, 760, x6)

inst_627:
// rs1_val==-3037000498 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x1, -0xb504f332, 0xb504f333, x1, 768, x6)

inst_628:
// rs1_val==-3037000498 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd0, -0xb504f332, 0x2, x1, 776, x6)

inst_629:
// rs1_val==-3037000498 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506222, -0xb504f332, 0x5555555555555554, x1, 784, x6)

inst_630:
// rs1_val==-3037000498 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cce, -0xb504f332, 0x0, x1, 792, x6)

inst_631:
// rs1_val==-3037000498 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd2, -0xb504f332, 0x4, x1, 800, x6)

inst_632:
// rs1_val==-3037000498 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4000, -0xb504f332, 0x3333333333333332, x1, 808, x6)

inst_633:
// rs1_val==-3037000498 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617333, -0xb504f332, 0x6666666666666665, x1, 816, x6)

inst_634:
// rs1_val==-3037000498 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x0, -0xb504f332, 0xb504f332, x1, 824, x6)

inst_635:
// rs1_val==-3037000498 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x55555554a0506224, -0xb504f332, 0x5555555555555556, x1, 832, x6)

inst_636:
// rs1_val==-3037000498 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaa9f5a5b779, -0xb504f332, -0x5555555555555555, x1, 840, x6)

inst_637:
// rs1_val==-3037000498 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xffffffff4afb0cd4, -0xb504f332, 0x6, x1, 848, x6)

inst_638:
// rs1_val==-3037000498 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x333333327e2e4002, -0xb504f332, 0x3333333333333334, x1, 856, x6)

inst_639:
// rs1_val==-3037000498 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x66666665b1617335, -0xb504f332, 0x6666666666666667, x1, 864, x6)

inst_640:
// rs1_val==-3037000498 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xfffffffe95f6199c, -0xb504f332, -0xb504f332, x1, 872, x6)

inst_641:
// rs1_val==-3037000498 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x2, -0xb504f332, 0xb504f334, x1, 880, x6)

inst_642:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3
TEST_RR_OP(add, x12, x10, x11, 0xb504f337, 0xb504f334, 0x3, x1, 888, x6)

inst_643:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4889, 0xb504f334, 0x5555555555555555, x1, 896, x6)

inst_644:
// rs1_val==3037000500 and rs2_val==-6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9dde, 0xb504f334, -0x5555555555555556, x1, 904, x6)

inst_645:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5
TEST_RR_OP(add, x12, x10, x11, 0xb504f339, 0xb504f334, 0x5, x1, 912, x6)

inst_646:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333333
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382667, 0xb504f334, 0x3333333333333333, x1, 920, x6)

inst_647:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666666
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b599a, 0xb504f334, 0x6666666666666666, x1, 928, x6)

inst_648:
// rs1_val==3037000500 and rs2_val==-3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x1, 0xb504f334, -0xb504f333, x1, 936, x6)

inst_649:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f333
TEST_RR_OP(add, x12, x10, x11, 0x16a09e667, 0xb504f334, 0xb504f333, x1, 944, x6)

inst_650:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0xb504f336, 0xb504f334, 0x2, x1, 952, x6)

inst_651:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a4888, 0xb504f334, 0x5555555555555554, x1, 960, x6)

inst_652:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0xb504f334, 0xb504f334, 0x0, x1, 968, x6)

inst_653:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0xb504f338, 0xb504f334, 0x4, x1, 976, x6)

inst_654:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382666, 0xb504f334, 0x3333333333333332, x1, 984, x6)

inst_655:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b5999, 0xb504f334, 0x6666666666666665, x1, 992, x6)

inst_656:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x16a09e666, 0xb504f334, 0xb504f332, x1, 1000, x6)

inst_657:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x555555560a5a488a, 0xb504f334, 0x5555555555555556, x1, 1008, x6)

inst_658:
// rs1_val==3037000500 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaab5faf9ddf, 0xb504f334, -0x5555555555555555, x1, 1016, x6)

inst_659:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0xb504f33a, 0xb504f334, 0x6, x1, 1024, x6)

inst_660:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x33333333e8382668, 0xb504f334, 0x3333333333333334, x1, 1032, x6)

inst_661:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x666666671b6b599b, 0xb504f334, 0x6666666666666667, x1, 1040, x6)

inst_662:
// rs1_val==3037000500 and rs2_val==-3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0x2, 0xb504f334, -0xb504f332, x1, 1048, x6)

inst_663:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f334
TEST_RR_OP(add, x12, x10, x11, 0x16a09e668, 0xb504f334, 0xb504f334, x1, 1056, x6)

inst_664:
// rs1_val==0 and rs2_val==2, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(add, x12, x10, x11, 0x2, 0x0, 0x2, x1, 1064, x6)

inst_665:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555554
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555554, 0x0, 0x5555555555555554, x1, 1072, x6)

inst_666:
// rs1_val==0 and rs2_val==0, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(add, x12, x10, x11, 0x0, 0x0, 0x0, x1, 1080, x6)

inst_667:
// rs1_val==0 and rs2_val==4, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(add, x12, x10, x11, 0x4, 0x0, 0x4, x1, 1088, x6)

inst_668:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333332
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333332, 0x0, 0x3333333333333332, x1, 1096, x6)

inst_669:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666665
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666665, 0x0, 0x6666666666666665, x1, 1104, x6)

inst_670:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f332
TEST_RR_OP(add, x12, x10, x11, 0xb504f332, 0x0, 0xb504f332, x1, 1112, x6)

inst_671:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x5555555555555556, 0x0, 0x5555555555555556, x1, 1120, x6)

inst_672:
// rs1_val==0 and rs2_val==-6148914691236517205, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555555
TEST_RR_OP(add, x12, x10, x11, 0xaaaaaaaaaaaaaaab, 0x0, -0x5555555555555555, x1, 1128, x6)

inst_673:
// rs1_val==0 and rs2_val==6, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(add, x12, x10, x11, 0x6, 0x0, 0x6, x1, 1136, x6)

inst_674:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333334
TEST_RR_OP(add, x12, x10, x11, 0x3333333333333334, 0x0, 0x3333333333333334, x1, 1144, x6)

inst_675:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666667
TEST_RR_OP(add, x12, x10, x11, 0x6666666666666667, 0x0, 0x6666666666666667, x1, 1152, x6)

inst_676:
// rs1_val > 0 and rs2_val > 0, rs1_val == 4, rs1_val==4 and rs2_val==6148914691236517206, rs1_val != rs2_val
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555556
TEST_RR_OP(add, x12, x10, x11, 0x555555555555555a, 0x4, 0x5555555555555556, x1, 1160, x6)

inst_677:
// rs1_val < 0 and rs2_val < 0, rs1_val == -8388609
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:-0x4
TEST_RR_OP(add, x12, x10, x11, 0xffffffffff7ffffb, -0x800001, -0x4, x1, 1168, x6)

inst_678:
// rs2_val == 256, 
// opcode: add ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x100
TEST_RR_OP(add, x12, x10, x11, 0x101, 0x1, 0x100, x1, 1176, x6)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x8_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x8_1:
    .fill 19*(XLEN/32),4,0xdeadbeef


signature_x1_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_2:
    .fill 148*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
