
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the addi instruction of the RISC-V I extension for the addi covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",addi)

RVTEST_SIGBASE( x16,signature_x16_1)

inst_0:
// rs1 == rd, rs1==x19, rd==x19, imm_val == (-2**(12-1)), imm_val == -2048, rs1_val != imm_val, rs1_val == -4097, rs1_val < 0 and imm_val < 0
// opcode: addi ; op1:x19; dest:x19; op1val:-0x1001;  immval:-0x800
TEST_IMM_OP( addi, x19, x19, 0xffffffffffffe7ff, -0x1001, -0x800, x16, 0, x18)

inst_1:
// rs1 != rd, rs1==x1, rd==x15, imm_val == 0, rs1_val == -65537
// opcode: addi ; op1:x1; dest:x15; op1val:-0x10001;  immval:0x0
TEST_IMM_OP( addi, x15, x1, 0xfffffffffffeffff, -0x10001, 0x0, x16, 8, x18)

inst_2:
// rs1==x22, rd==x12, imm_val == (2**(12-1)-1), rs1_val > 0 and imm_val > 0, imm_val == 2047, rs1_val == 4194304
// opcode: addi ; op1:x22; dest:x12; op1val:0x400000;  immval:0x7ff
TEST_IMM_OP( addi, x12, x22, 0x4007ff, 0x400000, 0x7ff, x16, 16, x18)

inst_3:
// rs1==x26, rd==x10, imm_val == 1, rs1_val == 18014398509481984
// opcode: addi ; op1:x26; dest:x10; op1val:0x40000000000000;  immval:0x1
TEST_IMM_OP( addi, x10, x26, 0x40000000000001, 0x40000000000000, 0x1, x16, 24, x18)

inst_4:
// rs1==x17, rd==x21, rs1_val == (-2**(xlen-1)), imm_val == -129, rs1_val == -9223372036854775808
// opcode: addi ; op1:x17; dest:x21; op1val:-0x8000000000000000;  immval:-0x81
TEST_IMM_OP( addi, x21, x17, 0x7fffffffffffff7f, -0x8000000000000000, -0x81, x16, 32, x18)

inst_5:
// rs1==x30, rd==x25, rs1_val == 0, rs1_val==0 and imm_val==4, imm_val == 4
// opcode: addi ; op1:x30; dest:x25; op1val:0x0;  immval:0x4
TEST_IMM_OP( addi, x25, x30, 0x4, 0x0, 0x4, x16, 40, x18)

inst_6:
// rs1==x0, rd==x24, rs1_val == (2**(xlen-1)-1), imm_val == -513, rs1_val > 0 and imm_val < 0, rs1_val == 9223372036854775807
// opcode: addi ; op1:x0; dest:x24; op1val:0x0;  immval:-0x201
TEST_IMM_OP( addi, x24, x0, 0xfffffffffffffdff, 0x0, -0x201, x16, 48, x18)

inst_7:
// rs1==x14, rd==x30, rs1_val == 1, 
// opcode: addi ; op1:x14; dest:x30; op1val:0x1;  immval:0x333
TEST_IMM_OP( addi, x30, x14, 0x334, 0x1, 0x333, x16, 56, x18)

inst_8:
// rs1==x6, rd==x4, rs1_val == imm_val, 
// opcode: addi ; op1:x6; dest:x4; op1val:0x7;  immval:0x7
TEST_IMM_OP( addi, x4, x6, 0xe, 0x7, 0x7, x16, 64, x18)

inst_9:
// rs1==x21, rd==x8, rs1_val < 0 and imm_val > 0, rs1_val == -281474976710657
// opcode: addi ; op1:x21; dest:x8; op1val:-0x1000000000001;  immval:0x665
TEST_IMM_OP( addi, x8, x21, 0xffff000000000664, -0x1000000000001, 0x665, x16, 72, x18)

inst_10:
// rs1==x10, rd==x13, imm_val == 2, rs1_val == 131072
// opcode: addi ; op1:x10; dest:x13; op1val:0x20000;  immval:0x2
TEST_IMM_OP( addi, x13, x10, 0x20002, 0x20000, 0x2, x16, 80, x18)

inst_11:
// rs1==x25, rd==x22, imm_val == 8, rs1_val == -36028797018963969
// opcode: addi ; op1:x25; dest:x22; op1val:-0x80000000000001;  immval:0x8
TEST_IMM_OP( addi, x22, x25, 0xff80000000000007, -0x80000000000001, 0x8, x16, 88, x18)

inst_12:
// rs1==x27, rd==x9, imm_val == 16, rs1_val == -8388609
// opcode: addi ; op1:x27; dest:x9; op1val:-0x800001;  immval:0x10
TEST_IMM_OP( addi, x9, x27, 0xffffffffff80000f, -0x800001, 0x10, x16, 96, x18)

inst_13:
// rs1==x28, rd==x5, imm_val == 32, rs1_val == -18014398509481985
// opcode: addi ; op1:x28; dest:x5; op1val:-0x40000000000001;  immval:0x20
TEST_IMM_OP( addi, x5, x28, 0xffc000000000001f, -0x40000000000001, 0x20, x16, 104, x18)

inst_14:
// rs1==x2, rd==x6, imm_val == 64, rs1_val == 17592186044416
// opcode: addi ; op1:x2; dest:x6; op1val:0x100000000000;  immval:0x40
TEST_IMM_OP( addi, x6, x2, 0x100000000040, 0x100000000000, 0x40, x16, 112, x18)

inst_15:
// rs1==x9, rd==x11, imm_val == 128, rs1_val == 33554432
// opcode: addi ; op1:x9; dest:x11; op1val:0x2000000;  immval:0x80
TEST_IMM_OP( addi, x11, x9, 0x2000080, 0x2000000, 0x80, x16, 120, x18)

inst_16:
// rs1==x11, rd==x20, imm_val == 256, 
// opcode: addi ; op1:x11; dest:x20; op1val:0x5555555555555554;  immval:0x100
TEST_IMM_OP( addi, x20, x11, 0x5555555555555654, 0x5555555555555554, 0x100, x16, 128, x18)

inst_17:
// rs1==x7, rd==x26, imm_val == 512, rs1_val == -4398046511105
// opcode: addi ; op1:x7; dest:x26; op1val:-0x40000000001;  immval:0x200
TEST_IMM_OP( addi, x26, x7, 0xfffffc00000001ff, -0x40000000001, 0x200, x16, 136, x18)

inst_18:
// rs1==x13, rd==x0, imm_val == 1024, rs1_val == -17
// opcode: addi ; op1:x13; dest:x0; op1val:-0x11;  immval:0x400
TEST_IMM_OP( addi, x0, x13, 0, -0x11, 0x400, x16, 144, x18)

inst_19:
// rs1==x29, rd==x28, imm_val == -2, rs1_val == -2147483649
// opcode: addi ; op1:x29; dest:x28; op1val:-0x80000001;  immval:-0x2
TEST_IMM_OP( addi, x28, x29, 0xffffffff7ffffffd, -0x80000001, -0x2, x16, 152, x18)

inst_20:
// rs1==x24, rd==x2, imm_val == -3, rs1_val == -134217729
// opcode: addi ; op1:x24; dest:x2; op1val:-0x8000001;  immval:-0x3
TEST_IMM_OP( addi, x2, x24, 0xfffffffff7fffffc, -0x8000001, -0x3, x16, 160, x18)

inst_21:
// rs1==x3, rd==x17, imm_val == -5, rs1_val == 536870912
// opcode: addi ; op1:x3; dest:x17; op1val:0x20000000;  immval:-0x5
TEST_IMM_OP( addi, x17, x3, 0x1ffffffb, 0x20000000, -0x5, x16, 168, x18)

inst_22:
// rs1==x15, rd==x18, imm_val == -9, 
// opcode: addi ; op1:x15; dest:x18; op1val:0x6666666666666666;  immval:-0x9
TEST_IMM_OP( addi, x18, x15, 0x666666666666665d, 0x6666666666666666, -0x9, x16, 176, x6)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_23:
// rs1==x23, rd==x14, imm_val == -17, rs1_val == 4
// opcode: addi ; op1:x23; dest:x14; op1val:0x4;  immval:-0x11
TEST_IMM_OP( addi, x14, x23, 0xfffffffffffffff3, 0x4, -0x11, x2, 0, x6)

inst_24:
// rs1==x16, rd==x29, imm_val == -33, rs1_val == -8796093022209
// opcode: addi ; op1:x16; dest:x29; op1val:-0x80000000001;  immval:-0x21
TEST_IMM_OP( addi, x29, x16, 0xfffff7ffffffffde, -0x80000000001, -0x21, x2, 8, x6)

inst_25:
// rs1==x18, rd==x3, imm_val == -65, rs1_val == -65
// opcode: addi ; op1:x18; dest:x3; op1val:-0x41;  immval:-0x41
TEST_IMM_OP( addi, x3, x18, 0xffffffffffffff7e, -0x41, -0x41, x2, 16, x6)

inst_26:
// rs1==x12, rd==x7, imm_val == -257, rs1_val == -268435457
// opcode: addi ; op1:x12; dest:x7; op1val:-0x10000001;  immval:-0x101
TEST_IMM_OP( addi, x7, x12, 0xffffffffeffffefe, -0x10000001, -0x101, x2, 24, x6)

inst_27:
// rs1==x20, rd==x16, imm_val == -1025, 
// opcode: addi ; op1:x20; dest:x16; op1val:-0x1;  immval:-0x401
TEST_IMM_OP( addi, x16, x20, 0xfffffffffffffbfe, -0x1, -0x401, x2, 32, x6)

inst_28:
// rs1==x5, rd==x31, imm_val == 1365, rs1_val == -129
// opcode: addi ; op1:x5; dest:x31; op1val:-0x81;  immval:0x555
TEST_IMM_OP( addi, x31, x5, 0x4d4, -0x81, 0x555, x2, 40, x6)

inst_29:
// rs1==x4, rd==x27, imm_val == -1366, rs1_val == 262144
// opcode: addi ; op1:x4; dest:x27; op1val:0x40000;  immval:-0x556
TEST_IMM_OP( addi, x27, x4, 0x3faaa, 0x40000, -0x556, x2, 48, x6)

inst_30:
// rs1==x31, rd==x23, rs1_val == 2, 
// opcode: addi ; op1:x31; dest:x23; op1val:0x2;  immval:-0x11
TEST_IMM_OP( addi, x23, x31, 0xfffffffffffffff1, 0x2, -0x11, x2, 56, x6)

inst_31:
// rs1==x8, rd==x1, rs1_val == 8, 
// opcode: addi ; op1:x8; dest:x1; op1val:0x8;  immval:0x667
TEST_IMM_OP( addi, x1, x8, 0x66f, 0x8, 0x667, x2, 64, x6)

inst_32:
// rs1_val == 16, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x10;  immval:-0x7
TEST_IMM_OP( addi, x11, x10, 0x9, 0x10, -0x7, x2, 72, x6)

inst_33:
// rs1_val == 32, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x20;  immval:0x40
TEST_IMM_OP( addi, x11, x10, 0x60, 0x20, 0x40, x2, 80, x6)

inst_34:
// rs1_val == 64, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x40;  immval:0x40
TEST_IMM_OP( addi, x11, x10, 0x80, 0x40, 0x40, x2, 88, x6)

inst_35:
// rs1_val == 128, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x80;  immval:-0x201
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffe7f, 0x80, -0x201, x2, 96, x6)

inst_36:
// rs1_val == 256, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x100;  immval:-0x8
TEST_IMM_OP( addi, x11, x10, 0xf8, 0x100, -0x8, x2, 104, x6)

inst_37:
// rs1_val == 512, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x200;  immval:0x8
TEST_IMM_OP( addi, x11, x10, 0x208, 0x200, 0x8, x2, 112, x6)

inst_38:
// rs1_val == 1024, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x400;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x406, 0x400, 0x6, x2, 120, x6)

inst_39:
// rs1_val == 2048, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x800;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x800, 0x800, 0x0, x2, 128, x6)

inst_40:
// rs1_val == 4096, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x1000;  immval:-0x1
TEST_IMM_OP( addi, x11, x10, 0xfff, 0x1000, -0x1, x2, 136, x6)

inst_41:
// rs1_val == 8192, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2000;  immval:-0x800
TEST_IMM_OP( addi, x11, x10, 0x1800, 0x2000, -0x800, x2, 144, x6)

inst_42:
// rs1_val == 16384, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4000;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x4002, 0x4000, 0x2, x2, 152, x6)

inst_43:
// rs1_val == 32768, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x8000;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x8004, 0x8000, 0x4, x2, 160, x6)

inst_44:
// rs1_val == 65536, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x10000;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x10005, 0x10000, 0x5, x2, 168, x6)

inst_45:
// rs1_val == 524288, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x80000;  immval:0x400
TEST_IMM_OP( addi, x11, x10, 0x80400, 0x80000, 0x400, x2, 176, x6)

inst_46:
// rs1_val == 1048576, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x100000;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x10002e, 0x100000, 0x2e, x2, 184, x6)

inst_47:
// rs1_val == 2097152, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x200000;  immval:-0x81
TEST_IMM_OP( addi, x11, x10, 0x1fff7f, 0x200000, -0x81, x2, 192, x6)

inst_48:
// rs1_val == 8388608, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x800000;  immval:0x80
TEST_IMM_OP( addi, x11, x10, 0x800080, 0x800000, 0x80, x2, 200, x6)

inst_49:
// rs1_val == 16777216, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x1000000;  immval:-0x21
TEST_IMM_OP( addi, x11, x10, 0xffffdf, 0x1000000, -0x21, x2, 208, x6)

inst_50:
// rs1_val == 67108864, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x4000004, 0x4000000, 0x4, x2, 216, x6)

inst_51:
// rs1_val == 134217728, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x8000000;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x7ffffd4, 0x8000000, -0x2c, x2, 224, x6)

inst_52:
// rs1_val == 268435456, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x10000000;  immval:-0x11
TEST_IMM_OP( addi, x11, x10, 0xfffffef, 0x10000000, -0x11, x2, 232, x6)

inst_53:
// rs1_val == 1073741824, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x40000000;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x40000000, 0x40000000, 0x0, x2, 240, x6)

inst_54:
// rs1_val == 2147483648, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x80000000;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x80000005, 0x80000000, 0x5, x2, 248, x6)

inst_55:
// rs1_val == 4294967296, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x100000000;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffaaa, 0x100000000, -0x556, x2, 256, x6)

inst_56:
// rs1_val == 8589934592, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x200000000;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x200000004, 0x200000000, 0x4, x2, 264, x6)

inst_57:
// rs1_val == 17179869184, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x400000000;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x400000004, 0x400000000, 0x4, x2, 272, x6)

inst_58:
// rs1_val == 34359738368, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x800000000;  immval:-0x800
TEST_IMM_OP( addi, x11, x10, 0x7fffff800, 0x800000000, -0x800, x2, 280, x6)

inst_59:
// rs1_val == 68719476736, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x1000000000;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x1000000665, 0x1000000000, 0x665, x2, 288, x6)

inst_60:
// rs1_val == 137438953472, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2000000000;  immval:0x1
TEST_IMM_OP( addi, x11, x10, 0x2000000001, 0x2000000000, 0x1, x2, 296, x6)

inst_61:
// rs1_val == 274877906944, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4000000000;  immval:0x80
TEST_IMM_OP( addi, x11, x10, 0x4000000080, 0x4000000000, 0x80, x2, 304, x6)

inst_62:
// rs1_val == 549755813888, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x8000000000;  immval:-0x8
TEST_IMM_OP( addi, x11, x10, 0x7ffffffff8, 0x8000000000, -0x8, x2, 312, x6)

inst_63:
// rs1_val == 1099511627776, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x10000000000;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x1000000002e, 0x10000000000, 0x2e, x2, 320, x6)

inst_64:
// rs1_val == 2199023255552, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x20000000000;  immval:-0x101
TEST_IMM_OP( addi, x11, x10, 0x1fffffffeff, 0x20000000000, -0x101, x2, 328, x6)

inst_65:
// rs1_val == 4398046511104, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x40000000000;  immval:0x200
TEST_IMM_OP( addi, x11, x10, 0x40000000200, 0x40000000000, 0x200, x2, 336, x6)

inst_66:
// rs1_val == 8796093022208, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x8
TEST_IMM_OP( addi, x11, x10, 0x80000000008, 0x80000000000, 0x8, x2, 344, x6)

inst_67:
// rs1_val == 35184372088832, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x200000000002, 0x200000000000, 0x2, x2, 352, x6)

inst_68:
// rs1_val == 70368744177664, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x400000000554, 0x400000000000, 0x554, x2, 360, x6)

inst_69:
// rs1_val == 140737488355328, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x800000000000;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x800000000004, 0x800000000000, 0x4, x2, 368, x6)

inst_70:
// rs1_val == 281474976710656, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x100000000002d, 0x1000000000000, 0x2d, x2, 376, x6)

inst_71:
// rs1_val == 562949953421312, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x2000000000332, 0x2000000000000, 0x332, x2, 384, x6)

inst_72:
// rs1_val == 1125899906842624, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x4000000000555, 0x4000000000000, 0x555, x2, 392, x6)

inst_73:
// rs1_val == 2251799813685248, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x8000000000000;  immval:0x9
TEST_IMM_OP( addi, x11, x10, 0x8000000000009, 0x8000000000000, 0x9, x2, 400, x6)

inst_74:
// rs1_val == 4503599627370496, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x10000000000000;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x10000000000000, 0x10000000000000, 0x0, x2, 408, x6)

inst_75:
// rs1_val == 9007199254740992, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x20000000000554, 0x20000000000000, 0x554, x2, 416, x6)

inst_76:
// rs1_val == 36028797018963968, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x80000000000000, 0x80000000000000, 0x0, x2, 424, x6)

inst_77:
// rs1_val == 72057594037927936, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:-0x201
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffdff, 0x100000000000000, -0x201, x2, 432, x6)

inst_78:
// rs1_val == 144115188075855872, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:-0x800
TEST_IMM_OP( addi, x11, x10, 0x1fffffffffff800, 0x200000000000000, -0x800, x2, 440, x6)

inst_79:
// rs1_val == 288230376151711744, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0x80
TEST_IMM_OP( addi, x11, x10, 0x400000000000080, 0x400000000000000, 0x80, x2, 448, x6)

inst_80:
// rs1_val == 576460752303423488, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:-0x81
TEST_IMM_OP( addi, x11, x10, 0x7ffffffffffff7f, 0x800000000000000, -0x81, x2, 456, x6)

inst_81:
// rs1_val == 1152921504606846976, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:-0x1
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffff, 0x1000000000000000, -0x1, x2, 464, x6)

inst_82:
// rs1_val == 2305843009213693952, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x2000000000000002, 0x2000000000000000, 0x2, x2, 472, x6)

inst_83:
// rs1_val == 4611686018427387904, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4000000000000000;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x4000000000000555, 0x4000000000000000, 0x555, x2, 480, x6)

inst_84:
// rs1_val == -2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x2;  immval:-0x2
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffffc, -0x2, -0x2, x2, 488, x6)

inst_85:
// rs1_val == -3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x3;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x2, -0x3, 0x5, x2, 496, x6)

inst_86:
// rs1_val == -5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x660, -0x5, 0x665, x2, 504, x6)

inst_87:
// rs1_val == -9, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x9;  immval:-0x201
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffdf6, -0x9, -0x201, x2, 512, x6)

inst_88:
// rs1_val == -33, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x21;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xd, -0x21, 0x2e, x2, 520, x6)

inst_89:
// rs1_val == -257, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x101;  immval:0x10
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffff0f, -0x101, 0x10, x2, 528, x6)

inst_90:
// rs1_val == -513, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x201;  immval:-0x8
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffdf7, -0x201, -0x8, x2, 536, x6)

inst_91:
// rs1_val == -1025, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x401;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x266, -0x401, 0x667, x2, 544, x6)

inst_92:
// rs1_val == -2049, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x801;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffff802, -0x801, 0x3, x2, 552, x6)

inst_93:
// rs1_val == -8193, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x2001;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffdfd2, -0x2001, -0x2d, x2, 560, x6)

inst_94:
// rs1_val == -16385, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x400
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffc3ff, -0x4001, 0x400, x2, 568, x6)

inst_95:
// rs1_val == -32769, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xffffffffffff8664, -0x8001, 0x665, x2, 576, x6)

inst_96:
// rs1_val == -131073, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x20001;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffdfaa9, -0x20001, -0x556, x2, 584, x6)

inst_97:
// rs1_val == -262145, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffc0004, -0x40001, 0x5, x2, 592, x6)

inst_98:
// rs1_val == -524289, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x80001;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xfffffffffff80333, -0x80001, 0x334, x2, 600, x6)

inst_99:
// rs1_val == -1048577, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x100001;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xfffffffffff00004, -0x100001, 0x5, x2, 608, x6)

inst_100:
// rs1_val == -2097153, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x200001;  immval:-0x11
TEST_IMM_OP( addi, x11, x10, 0xffffffffffdfffee, -0x200001, -0x11, x2, 616, x6)

inst_101:
// rs1_val == -4194305, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x7ff
TEST_IMM_OP( addi, x11, x10, 0xffffffffffc007fe, -0x400001, 0x7ff, x2, 624, x6)

inst_102:
// rs1_val == -16777217, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x1000001;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffffffefffaa9, -0x1000001, -0x556, x2, 632, x6)

inst_103:
// rs1_val == -33554433, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x2000001;  immval:-0x2
TEST_IMM_OP( addi, x11, x10, 0xfffffffffdfffffd, -0x2000001, -0x2, x2, 640, x6)

inst_104:
// rs1_val == -67108865, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x80
TEST_IMM_OP( addi, x11, x10, 0xfffffffffc00007f, -0x4000001, 0x80, x2, 648, x6)

inst_105:
// rs1_val == -536870913, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x20000001;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xffffffffdfffffff, -0x20000001, 0x0, x2, 656, x6)

inst_106:
// rs1_val == -1073741825, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x40000001;  immval:-0x1
TEST_IMM_OP( addi, x11, x10, 0xffffffffbffffffe, -0x40000001, -0x1, x2, 664, x6)

inst_107:
// rs1_val == -4294967297, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x100000001;  immval:-0xa
TEST_IMM_OP( addi, x11, x10, 0xfffffffefffffff5, -0x100000001, -0xa, x2, 672, x6)

inst_108:
// rs1_val == -8589934593, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x200000001;  immval:-0x3
TEST_IMM_OP( addi, x11, x10, 0xfffffffdfffffffc, -0x200000001, -0x3, x2, 680, x6)

inst_109:
// rs1_val == -17179869185, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x400000001;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xfffffffc00000004, -0x400000001, 0x5, x2, 688, x6)

inst_110:
// rs1_val == -34359738369, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x800000001;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xfffffff800000333, -0x800000001, 0x334, x2, 696, x6)

inst_111:
// rs1_val == -68719476737, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x1000000001;  immval:-0x101
TEST_IMM_OP( addi, x11, x10, 0xffffffeffffffefe, -0x1000000001, -0x101, x2, 704, x6)

inst_112:
// rs1_val == -137438953473, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x2000000001;  immval:0x40
TEST_IMM_OP( addi, x11, x10, 0xffffffe00000003f, -0x2000000001, 0x40, x2, 712, x6)

inst_113:
// rs1_val == -274877906945, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffbfffffffd3, -0x4000000001, -0x2c, x2, 720, x6)

inst_114:
// rs1_val == -549755813889, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:-0x201
TEST_IMM_OP( addi, x11, x10, 0xffffff7ffffffdfe, -0x8000000001, -0x201, x2, 728, x6)

inst_115:
// rs1_val == -1099511627777, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xffffff000000002d, -0x10000000001, 0x2e, x2, 736, x6)

inst_116:
// rs1_val == -2199023255553, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x20000000001;  immval:-0x81
TEST_IMM_OP( addi, x11, x10, 0xfffffdffffffff7e, -0x20000000001, -0x81, x2, 744, x6)

inst_117:
// rs1_val == -17592186044417, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:0x7ff
TEST_IMM_OP( addi, x11, x10, 0xfffff000000007fe, -0x100000000001, 0x7ff, x2, 752, x6)

inst_118:
// rs1_val == -35184372088833, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xffffe00000000554, -0x200000000001, 0x555, x2, 760, x6)

inst_119:
// rs1_val == -70368744177665, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x400000000001;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xffffc00000000002, -0x400000000001, 0x3, x2, 768, x6)

inst_120:
// rs1_val == -140737488355329, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:-0x800
TEST_IMM_OP( addi, x11, x10, 0xffff7ffffffff7ff, -0x800000000001, -0x800, x2, 776, x6)

inst_121:
// rs1_val == -562949953421313, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x2000000000001;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xfffe000000000666, -0x2000000000001, 0x667, x2, 784, x6)

inst_122:
// rs1_val == -1125899906842625, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xfffc000000000003, -0x4000000000001, 0x4, x2, 792, x6)

inst_123:
// rs1_val == -2251799813685249, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x8000000000001;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xfff7ffffffffffd2, -0x8000000000001, -0x2d, x2, 800, x6)

inst_124:
// rs1_val == -4503599627370497, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xfff0000000000332, -0x10000000000001, 0x333, x2, 808, x6)

inst_125:
// rs1_val == -9007199254740993, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x20000000000001;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xffe0000000000554, -0x20000000000001, 0x555, x2, 816, x6)

inst_126:
// rs1_val == -72057594037927937, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:-0x2
TEST_IMM_OP( addi, x11, x10, 0xfefffffffffffffd, -0x100000000000001, -0x2, x2, 824, x6)

inst_127:
// rs1_val == -144115188075855873, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:0x400
TEST_IMM_OP( addi, x11, x10, 0xfe000000000003ff, -0x200000000000001, 0x400, x2, 832, x6)

inst_128:
// rs1_val == -288230376151711745, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x400000000000001;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xfbffffffffffffff, -0x400000000000001, 0x0, x2, 840, x6)

inst_129:
// rs1_val == -576460752303423489, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:-0x81
TEST_IMM_OP( addi, x11, x10, 0xf7ffffffffffff7e, -0x800000000000001, -0x81, x2, 848, x6)

inst_130:
// rs1_val == -1152921504606846977, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:0x10
TEST_IMM_OP( addi, x11, x10, 0xf00000000000000f, -0x1000000000000001, 0x10, x2, 856, x6)

inst_131:
// rs1_val == -2305843009213693953, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xe000000000000002, -0x2000000000000001, 0x3, x2, 864, x6)

inst_132:
// rs1_val == -4611686018427387905, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:-0x201
TEST_IMM_OP( addi, x11, x10, 0xbffffffffffffdfe, -0x4000000000000001, -0x201, x2, 872, x6)

inst_133:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205 and imm_val==6
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x555555555555555b, 0x5555555555555555, 0x6, x2, 880, x6)

inst_134:
// rs1_val == -6148914691236517206, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x8
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaab2, -0x5555555555555556, 0x8, x2, 888, x6)

inst_135:
// rs1_val==3 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x6, 0x3, 0x3, x2, 896, x6)

inst_136:
// rs1_val==3 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x558, 0x3, 0x555, x2, 904, x6)

inst_137:
// rs1_val==3 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaad, 0x3, -0x556, x2, 912, x6)

inst_138:
// rs1_val==3 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x8, 0x3, 0x5, x2, 920, x6)

inst_139:
// rs1_val==3 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x336, 0x3, 0x333, x2, 928, x6)

inst_140:
// rs1_val==3 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x669, 0x3, 0x666, x2, 936, x6)

inst_141:
// rs1_val==3 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd6, 0x3, -0x2d, x2, 944, x6)

inst_142:
// rs1_val==3 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x30, 0x3, 0x2d, x2, 952, x6)

inst_143:
// rs1_val==3 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x5, 0x3, 0x2, x2, 960, x6)

inst_144:
// rs1_val==3 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x557, 0x3, 0x554, x2, 968, x6)

inst_145:
// rs1_val==3 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x3, 0x3, 0x0, x2, 976, x6)

inst_146:
// rs1_val==3 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x7, 0x3, 0x4, x2, 984, x6)

inst_147:
// rs1_val==3 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x335, 0x3, 0x332, x2, 992, x6)

inst_148:
// rs1_val==3 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x668, 0x3, 0x665, x2, 1000, x6)

inst_149:
// rs1_val==3 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x2f, 0x3, 0x2c, x2, 1008, x6)

inst_150:
// rs1_val==3 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x559, 0x3, 0x556, x2, 1016, x6)

inst_151:
// rs1_val==3 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaae, 0x3, -0x555, x2, 1024, x6)

inst_152:
// rs1_val==3 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x9, 0x3, 0x6, x2, 1032, x6)

inst_153:
// rs1_val==3 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x337, 0x3, 0x334, x2, 1040, x6)

inst_154:
// rs1_val==3 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66a, 0x3, 0x667, x2, 1048, x6)

inst_155:
// rs1_val==3 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd7, 0x3, -0x2c, x2, 1056, x6)

inst_156:
// rs1_val==3 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x31, 0x3, 0x2e, x2, 1064, x6)

inst_157:
// rs1_val==6148914691236517205 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x5555555555555558, 0x5555555555555555, 0x3, x2, 1072, x6)

inst_158:
// rs1_val==6148914691236517205 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aaa, 0x5555555555555555, 0x555, x2, 1080, x6)

inst_159:
// rs1_val==6148914691236517205 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x5555555555554fff, 0x5555555555555555, -0x556, x2, 1088, x6)

inst_160:
// rs1_val==6148914691236517205 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x555555555555555a, 0x5555555555555555, 0x5, x2, 1096, x6)

inst_161:
// rs1_val==6148914691236517205 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x5555555555555888, 0x5555555555555555, 0x333, x2, 1104, x6)

inst_162:
// rs1_val==6148914691236517205 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bbb, 0x5555555555555555, 0x666, x2, 1112, x6)

inst_163:
// rs1_val==6148914691236517205 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x5555555555555528, 0x5555555555555555, -0x2d, x2, 1120, x6)

inst_164:
// rs1_val==6148914691236517205 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x5555555555555582, 0x5555555555555555, 0x2d, x2, 1128, x6)

inst_165:
// rs1_val==6148914691236517205 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x5555555555555557, 0x5555555555555555, 0x2, x2, 1136, x6)

inst_166:
// rs1_val==6148914691236517205 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aa9, 0x5555555555555555, 0x554, x2, 1144, x6)

inst_167:
// rs1_val==6148914691236517205 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x5555555555555555, 0x5555555555555555, 0x0, x2, 1152, x6)

inst_168:
// rs1_val==6148914691236517205 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x5555555555555559, 0x5555555555555555, 0x4, x2, 1160, x6)

inst_169:
// rs1_val==6148914691236517205 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x5555555555555887, 0x5555555555555555, 0x332, x2, 1168, x6)

inst_170:
// rs1_val==6148914691236517205 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bba, 0x5555555555555555, 0x665, x2, 1176, x6)

inst_171:
// rs1_val==6148914691236517205 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x5555555555555581, 0x5555555555555555, 0x2c, x2, 1184, x6)

inst_172:
// rs1_val==6148914691236517205 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aab, 0x5555555555555555, 0x556, x2, 1192, x6)

inst_173:
// rs1_val==6148914691236517205 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x5555555555555000, 0x5555555555555555, -0x555, x2, 1200, x6)

inst_174:
// rs1_val==6148914691236517205 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x5555555555555889, 0x5555555555555555, 0x334, x2, 1208, x6)

inst_175:
// rs1_val==6148914691236517205 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bbc, 0x5555555555555555, 0x667, x2, 1216, x6)

inst_176:
// rs1_val==6148914691236517205 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x5555555555555529, 0x5555555555555555, -0x2c, x2, 1224, x6)

inst_177:
// rs1_val==6148914691236517205 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x5555555555555583, 0x5555555555555555, 0x2e, x2, 1232, x6)

inst_178:
// rs1_val==-6148914691236517206 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaad, -0x5555555555555556, 0x3, x2, 1240, x6)

inst_179:
// rs1_val==-6148914691236517206 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaafff, -0x5555555555555556, 0x555, x2, 1248, x6)

inst_180:
// rs1_val==-6148914691236517206 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaa554, -0x5555555555555556, -0x556, x2, 1256, x6)

inst_181:
// rs1_val==-6148914691236517206 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555556, 0x5, x2, 1264, x6)

inst_182:
// rs1_val==-6148914691236517206 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaddd, -0x5555555555555556, 0x333, x2, 1272, x6)

inst_183:
// rs1_val==-6148914691236517206 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab110, -0x5555555555555556, 0x666, x2, 1280, x6)

inst_184:
// rs1_val==-6148914691236517206 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaa7d, -0x5555555555555556, -0x2d, x2, 1288, x6)

inst_185:
// rs1_val==-6148914691236517206 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaad7, -0x5555555555555556, 0x2d, x2, 1296, x6)

inst_186:
// rs1_val==-6148914691236517206 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaac, -0x5555555555555556, 0x2, x2, 1304, x6)

inst_187:
// rs1_val==-6148914691236517206 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaffe, -0x5555555555555556, 0x554, x2, 1312, x6)

inst_188:
// rs1_val==-6148914691236517206 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, 0x0, x2, 1320, x6)

inst_189:
// rs1_val==-6148914691236517206 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x4, x2, 1328, x6)

inst_190:
// rs1_val==-6148914691236517206 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaddc, -0x5555555555555556, 0x332, x2, 1336, x6)

inst_191:
// rs1_val==-6148914691236517206 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab10f, -0x5555555555555556, 0x665, x2, 1344, x6)

inst_192:
// rs1_val==-6148914691236517206 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaad6, -0x5555555555555556, 0x2c, x2, 1352, x6)

inst_193:
// rs1_val==-6148914691236517206 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab000, -0x5555555555555556, 0x556, x2, 1360, x6)

inst_194:
// rs1_val==-6148914691236517206 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaa555, -0x5555555555555556, -0x555, x2, 1368, x6)

inst_195:
// rs1_val==-6148914691236517206 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaab0, -0x5555555555555556, 0x6, x2, 1376, x6)

inst_196:
// rs1_val==-6148914691236517206 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaadde, -0x5555555555555556, 0x334, x2, 1384, x6)

inst_197:
// rs1_val==-6148914691236517206 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab111, -0x5555555555555556, 0x667, x2, 1392, x6)

inst_198:
// rs1_val==-6148914691236517206 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaa7e, -0x5555555555555556, -0x2c, x2, 1400, x6)

inst_199:
// rs1_val==-6148914691236517206 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaad8, -0x5555555555555556, 0x2e, x2, 1408, x6)

inst_200:
// rs1_val==5 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x8, 0x5, 0x3, x2, 1416, x6)

inst_201:
// rs1_val==5 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x55a, 0x5, 0x555, x2, 1424, x6)

inst_202:
// rs1_val==5 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaaf, 0x5, -0x556, x2, 1432, x6)

inst_203:
// rs1_val==5 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xa, 0x5, 0x5, x2, 1440, x6)

inst_204:
// rs1_val==5 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x338, 0x5, 0x333, x2, 1448, x6)

inst_205:
// rs1_val==5 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66b, 0x5, 0x666, x2, 1456, x6)

inst_206:
// rs1_val==5 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd8, 0x5, -0x2d, x2, 1464, x6)

inst_207:
// rs1_val==5 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x32, 0x5, 0x2d, x2, 1472, x6)

inst_208:
// rs1_val==5 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x7, 0x5, 0x2, x2, 1480, x6)

inst_209:
// rs1_val==5 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x559, 0x5, 0x554, x2, 1488, x6)

inst_210:
// rs1_val==5 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x5, 0x5, 0x0, x2, 1496, x6)

inst_211:
// rs1_val==5 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x9, 0x5, 0x4, x2, 1504, x6)

inst_212:
// rs1_val==5 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x337, 0x5, 0x332, x2, 1512, x6)

inst_213:
// rs1_val==5 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x66a, 0x5, 0x665, x2, 1520, x6)

inst_214:
// rs1_val==5 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x31, 0x5, 0x2c, x2, 1528, x6)

inst_215:
// rs1_val==5 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55b, 0x5, 0x556, x2, 1536, x6)

inst_216:
// rs1_val==5 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffab0, 0x5, -0x555, x2, 1544, x6)

inst_217:
// rs1_val==5 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xb, 0x5, 0x6, x2, 1552, x6)

inst_218:
// rs1_val==5 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x339, 0x5, 0x334, x2, 1560, x6)

inst_219:
// rs1_val==5 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66c, 0x5, 0x667, x2, 1568, x6)

inst_220:
// rs1_val==5 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd9, 0x5, -0x2c, x2, 1576, x6)

inst_221:
// rs1_val==5 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x33, 0x5, 0x2e, x2, 1584, x6)

inst_222:
// rs1_val==3689348814741910323 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x3333333333333336, 0x3333333333333333, 0x3, x2, 1592, x6)

inst_223:
// rs1_val==3689348814741910323 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x3333333333333888, 0x3333333333333333, 0x555, x2, 1600, x6)

inst_224:
// rs1_val==3689348814741910323 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x3333333333332ddd, 0x3333333333333333, -0x556, x2, 1608, x6)

inst_225:
// rs1_val==3689348814741910323 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x3333333333333338, 0x3333333333333333, 0x5, x2, 1616, x6)

inst_226:
// rs1_val==3689348814741910323 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x3333333333333666, 0x3333333333333333, 0x333, x2, 1624, x6)

inst_227:
// rs1_val==3689348814741910323 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x3333333333333999, 0x3333333333333333, 0x666, x2, 1632, x6)

inst_228:
// rs1_val==3689348814741910323 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x3333333333333306, 0x3333333333333333, -0x2d, x2, 1640, x6)

inst_229:
// rs1_val==3689348814741910323 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x3333333333333360, 0x3333333333333333, 0x2d, x2, 1648, x6)

inst_230:
// rs1_val==3689348814741910323 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x3333333333333335, 0x3333333333333333, 0x2, x2, 1656, x6)

inst_231:
// rs1_val==3689348814741910323 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x3333333333333887, 0x3333333333333333, 0x554, x2, 1664, x6)

inst_232:
// rs1_val==3689348814741910323 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x3333333333333333, 0x3333333333333333, 0x0, x2, 1672, x6)

inst_233:
// rs1_val==3689348814741910323 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x3333333333333337, 0x3333333333333333, 0x4, x2, 1680, x6)

inst_234:
// rs1_val==3689348814741910323 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x3333333333333665, 0x3333333333333333, 0x332, x2, 1688, x6)

inst_235:
// rs1_val==3689348814741910323 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x3333333333333998, 0x3333333333333333, 0x665, x2, 1696, x6)

inst_236:
// rs1_val==3689348814741910323 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x333333333333335f, 0x3333333333333333, 0x2c, x2, 1704, x6)

inst_237:
// rs1_val==3689348814741910323 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x3333333333333889, 0x3333333333333333, 0x556, x2, 1712, x6)

inst_238:
// rs1_val==3689348814741910323 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x3333333333332dde, 0x3333333333333333, -0x555, x2, 1720, x6)

inst_239:
// rs1_val==3689348814741910323 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x3333333333333339, 0x3333333333333333, 0x6, x2, 1728, x6)

inst_240:
// rs1_val==3689348814741910323 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x3333333333333667, 0x3333333333333333, 0x334, x2, 1736, x6)

inst_241:
// rs1_val==3689348814741910323 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x333333333333399a, 0x3333333333333333, 0x667, x2, 1744, x6)

inst_242:
// rs1_val==3689348814741910323 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x3333333333333307, 0x3333333333333333, -0x2c, x2, 1752, x6)

inst_243:
// rs1_val==3689348814741910323 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x3333333333333361, 0x3333333333333333, 0x2e, x2, 1760, x6)

inst_244:
// rs1_val==7378697629483820646 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x6666666666666669, 0x6666666666666666, 0x3, x2, 1768, x6)

inst_245:
// rs1_val==7378697629483820646 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bbb, 0x6666666666666666, 0x555, x2, 1776, x6)

inst_246:
// rs1_val==7378697629483820646 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x6666666666666110, 0x6666666666666666, -0x556, x2, 1784, x6)

inst_247:
// rs1_val==7378697629483820646 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x666666666666666b, 0x6666666666666666, 0x5, x2, 1792, x6)

inst_248:
// rs1_val==7378697629483820646 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x6666666666666999, 0x6666666666666666, 0x333, x2, 1800, x6)

inst_249:
// rs1_val==7378697629483820646 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x6666666666666ccc, 0x6666666666666666, 0x666, x2, 1808, x6)

inst_250:
// rs1_val==7378697629483820646 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x6666666666666639, 0x6666666666666666, -0x2d, x2, 1816, x6)

inst_251:
// rs1_val==7378697629483820646 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x6666666666666693, 0x6666666666666666, 0x2d, x2, 1824, x6)

inst_252:
// rs1_val==7378697629483820646 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x6666666666666668, 0x6666666666666666, 0x2, x2, 1832, x6)

inst_253:
// rs1_val==7378697629483820646 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bba, 0x6666666666666666, 0x554, x2, 1840, x6)

inst_254:
// rs1_val==7378697629483820646 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x6666666666666666, 0x6666666666666666, 0x0, x2, 1848, x6)

inst_255:
// rs1_val==7378697629483820646 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x666666666666666a, 0x6666666666666666, 0x4, x2, 1856, x6)

inst_256:
// rs1_val==7378697629483820646 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x6666666666666998, 0x6666666666666666, 0x332, x2, 1864, x6)

inst_257:
// rs1_val==7378697629483820646 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x6666666666666ccb, 0x6666666666666666, 0x665, x2, 1872, x6)

inst_258:
// rs1_val==7378697629483820646 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x6666666666666692, 0x6666666666666666, 0x2c, x2, 1880, x6)

inst_259:
// rs1_val==7378697629483820646 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bbc, 0x6666666666666666, 0x556, x2, 1888, x6)

inst_260:
// rs1_val==7378697629483820646 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x6666666666666111, 0x6666666666666666, -0x555, x2, 1896, x6)

inst_261:
// rs1_val==7378697629483820646 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x666666666666666c, 0x6666666666666666, 0x6, x2, 1904, x6)

inst_262:
// rs1_val==7378697629483820646 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x666666666666699a, 0x6666666666666666, 0x334, x2, 1912, x6)

inst_263:
// rs1_val==7378697629483820646 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x6666666666666ccd, 0x6666666666666666, 0x667, x2, 1920, x6)

inst_264:
// rs1_val==7378697629483820646 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x666666666666663a, 0x6666666666666666, -0x2c, x2, 1928, x6)

inst_265:
// rs1_val==7378697629483820646 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x6666666666666694, 0x6666666666666666, 0x2e, x2, 1936, x6)

inst_266:
// rs1_val==-3037000499 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd0, -0xb504f333, 0x3, x2, 1944, x6)

inst_267:
// rs1_val==-3037000499 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1222, -0xb504f333, 0x555, x2, 1952, x6)

inst_268:
// rs1_val==-3037000499 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0777, -0xb504f333, -0x556, x2, 1960, x6)

inst_269:
// rs1_val==-3037000499 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd2, -0xb504f333, 0x5, x2, 1968, x6)

inst_270:
// rs1_val==-3037000499 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1000, -0xb504f333, 0x333, x2, 1976, x6)

inst_271:
// rs1_val==-3037000499 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1333, -0xb504f333, 0x666, x2, 1984, x6)

inst_272:
// rs1_val==-3037000499 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0ca0, -0xb504f333, -0x2d, x2, 1992, x6)

inst_273:
// rs1_val==-3037000499 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cfa, -0xb504f333, 0x2d, x2, 2000, x6)

inst_274:
// rs1_val==-3037000499 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0ccf, -0xb504f333, 0x2, x2, 2008, x6)

inst_275:
// rs1_val==-3037000499 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1221, -0xb504f333, 0x554, x2, 2016, x6)

inst_276:
// rs1_val==-3037000499 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0ccd, -0xb504f333, 0x0, x2, 2024, x6)

inst_277:
// rs1_val==-3037000499 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd1, -0xb504f333, 0x4, x2, 2032, x6)

inst_278:
// rs1_val==-3037000499 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0fff, -0xb504f333, 0x332, x2, 2040, x6)
RVTEST_SIGBASE( x2,signature_x2_1)

inst_279:
// rs1_val==-3037000499 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1332, -0xb504f333, 0x665, x2, 0, x6)

inst_280:
// rs1_val==-3037000499 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cf9, -0xb504f333, 0x2c, x2, 8, x6)

inst_281:
// rs1_val==-3037000499 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1223, -0xb504f333, 0x556, x2, 16, x6)

inst_282:
// rs1_val==-3037000499 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0778, -0xb504f333, -0x555, x2, 24, x6)

inst_283:
// rs1_val==-3037000499 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd3, -0xb504f333, 0x6, x2, 32, x6)

inst_284:
// rs1_val==-3037000499 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1001, -0xb504f333, 0x334, x2, 40, x6)

inst_285:
// rs1_val==-3037000499 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1334, -0xb504f333, 0x667, x2, 48, x6)

inst_286:
// rs1_val==-3037000499 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0ca1, -0xb504f333, -0x2c, x2, 56, x6)

inst_287:
// rs1_val==-3037000499 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cfb, -0xb504f333, 0x2e, x2, 64, x6)

inst_288:
// rs1_val==3037000499 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xb504f336, 0xb504f333, 0x3, x2, 72, x6)

inst_289:
// rs1_val==3037000499 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xb504f888, 0xb504f333, 0x555, x2, 80, x6)

inst_290:
// rs1_val==3037000499 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xb504eddd, 0xb504f333, -0x556, x2, 88, x6)

inst_291:
// rs1_val==3037000499 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xb504f338, 0xb504f333, 0x5, x2, 96, x6)

inst_292:
// rs1_val==3037000499 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xb504f666, 0xb504f333, 0x333, x2, 104, x6)

inst_293:
// rs1_val==3037000499 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xb504f999, 0xb504f333, 0x666, x2, 112, x6)

inst_294:
// rs1_val==3037000499 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xb504f306, 0xb504f333, -0x2d, x2, 120, x6)

inst_295:
// rs1_val==3037000499 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xb504f360, 0xb504f333, 0x2d, x2, 128, x6)

inst_296:
// rs1_val==3037000499 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xb504f335, 0xb504f333, 0x2, x2, 136, x6)

inst_297:
// rs1_val==3037000499 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xb504f887, 0xb504f333, 0x554, x2, 144, x6)

inst_298:
// rs1_val==3037000499 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xb504f333, 0xb504f333, 0x0, x2, 152, x6)

inst_299:
// rs1_val==3037000499 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xb504f337, 0xb504f333, 0x4, x2, 160, x6)

inst_300:
// rs1_val==3037000499 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xb504f665, 0xb504f333, 0x332, x2, 168, x6)

inst_301:
// rs1_val==3037000499 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xb504f998, 0xb504f333, 0x665, x2, 176, x6)

inst_302:
// rs1_val==3037000499 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xb504f35f, 0xb504f333, 0x2c, x2, 184, x6)

inst_303:
// rs1_val==3037000499 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xb504f889, 0xb504f333, 0x556, x2, 192, x6)

inst_304:
// rs1_val==3037000499 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xb504edde, 0xb504f333, -0x555, x2, 200, x6)

inst_305:
// rs1_val==3037000499 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xb504f339, 0xb504f333, 0x6, x2, 208, x6)

inst_306:
// rs1_val==3037000499 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xb504f667, 0xb504f333, 0x334, x2, 216, x6)

inst_307:
// rs1_val==3037000499 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xb504f99a, 0xb504f333, 0x667, x2, 224, x6)

inst_308:
// rs1_val==3037000499 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xb504f307, 0xb504f333, -0x2c, x2, 232, x6)

inst_309:
// rs1_val==3037000499 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xb504f361, 0xb504f333, 0x2e, x2, 240, x6)

inst_310:
// rs1_val==2 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x5, 0x2, 0x3, x2, 248, x6)

inst_311:
// rs1_val==2 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x557, 0x2, 0x555, x2, 256, x6)

inst_312:
// rs1_val==2 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaac, 0x2, -0x556, x2, 264, x6)

inst_313:
// rs1_val==2 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x7, 0x2, 0x5, x2, 272, x6)

inst_314:
// rs1_val==2 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x335, 0x2, 0x333, x2, 280, x6)

inst_315:
// rs1_val==2 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x668, 0x2, 0x666, x2, 288, x6)

inst_316:
// rs1_val==2 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd5, 0x2, -0x2d, x2, 296, x6)

inst_317:
// rs1_val==2 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x2f, 0x2, 0x2d, x2, 304, x6)

inst_318:
// rs1_val==2 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x4, 0x2, 0x2, x2, 312, x6)

inst_319:
// rs1_val==2 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x556, 0x2, 0x554, x2, 320, x6)

inst_320:
// rs1_val==2 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x2, 0x2, 0x0, x2, 328, x6)

inst_321:
// rs1_val==2 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x6, 0x2, 0x4, x2, 336, x6)

inst_322:
// rs1_val==2 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x334, 0x2, 0x332, x2, 344, x6)

inst_323:
// rs1_val==2 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x667, 0x2, 0x665, x2, 352, x6)

inst_324:
// rs1_val==2 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x2e, 0x2, 0x2c, x2, 360, x6)

inst_325:
// rs1_val==2 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x558, 0x2, 0x556, x2, 368, x6)

inst_326:
// rs1_val==2 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaad, 0x2, -0x555, x2, 376, x6)

inst_327:
// rs1_val==2 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x8, 0x2, 0x6, x2, 384, x6)

inst_328:
// rs1_val==2 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x336, 0x2, 0x334, x2, 392, x6)

inst_329:
// rs1_val==2 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x669, 0x2, 0x667, x2, 400, x6)

inst_330:
// rs1_val==2 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd6, 0x2, -0x2c, x2, 408, x6)

inst_331:
// rs1_val==2 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x30, 0x2, 0x2e, x2, 416, x6)

inst_332:
// rs1_val==6148914691236517204 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x5555555555555557, 0x5555555555555554, 0x3, x2, 424, x6)

inst_333:
// rs1_val==6148914691236517204 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aa9, 0x5555555555555554, 0x555, x2, 432, x6)

inst_334:
// rs1_val==6148914691236517204 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x5555555555554ffe, 0x5555555555555554, -0x556, x2, 440, x6)

inst_335:
// rs1_val==6148914691236517204 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x5555555555555559, 0x5555555555555554, 0x5, x2, 448, x6)

inst_336:
// rs1_val==6148914691236517204 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x5555555555555887, 0x5555555555555554, 0x333, x2, 456, x6)

inst_337:
// rs1_val==6148914691236517204 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bba, 0x5555555555555554, 0x666, x2, 464, x6)

inst_338:
// rs1_val==6148914691236517204 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x5555555555555527, 0x5555555555555554, -0x2d, x2, 472, x6)

inst_339:
// rs1_val==6148914691236517204 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x5555555555555581, 0x5555555555555554, 0x2d, x2, 480, x6)

inst_340:
// rs1_val==6148914691236517204 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x5555555555555556, 0x5555555555555554, 0x2, x2, 488, x6)

inst_341:
// rs1_val==6148914691236517204 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aa8, 0x5555555555555554, 0x554, x2, 496, x6)

inst_342:
// rs1_val==6148914691236517204 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x5555555555555554, 0x5555555555555554, 0x0, x2, 504, x6)

inst_343:
// rs1_val==6148914691236517204 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x5555555555555558, 0x5555555555555554, 0x4, x2, 512, x6)

inst_344:
// rs1_val==6148914691236517204 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x5555555555555886, 0x5555555555555554, 0x332, x2, 520, x6)

inst_345:
// rs1_val==6148914691236517204 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bb9, 0x5555555555555554, 0x665, x2, 528, x6)

inst_346:
// rs1_val==6148914691236517204 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x5555555555555580, 0x5555555555555554, 0x2c, x2, 536, x6)

inst_347:
// rs1_val==6148914691236517204 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aaa, 0x5555555555555554, 0x556, x2, 544, x6)

inst_348:
// rs1_val==6148914691236517204 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x5555555555554fff, 0x5555555555555554, -0x555, x2, 552, x6)

inst_349:
// rs1_val==6148914691236517204 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x555555555555555a, 0x5555555555555554, 0x6, x2, 560, x6)

inst_350:
// rs1_val==6148914691236517204 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x5555555555555888, 0x5555555555555554, 0x334, x2, 568, x6)

inst_351:
// rs1_val==6148914691236517204 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bbb, 0x5555555555555554, 0x667, x2, 576, x6)

inst_352:
// rs1_val==6148914691236517204 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x5555555555555528, 0x5555555555555554, -0x2c, x2, 584, x6)

inst_353:
// rs1_val==6148914691236517204 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x5555555555555582, 0x5555555555555554, 0x2e, x2, 592, x6)

inst_354:
// rs1_val==0 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x3, 0x0, 0x3, x2, 600, x6)

inst_355:
// rs1_val==0 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x555, 0x0, 0x555, x2, 608, x6)

inst_356:
// rs1_val==0 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaaa, 0x0, -0x556, x2, 616, x6)

inst_357:
// rs1_val==0 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x5, 0x0, 0x5, x2, 624, x6)

inst_358:
// rs1_val==0 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x333, 0x0, 0x333, x2, 632, x6)

inst_359:
// rs1_val==0 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x666, 0x0, 0x666, x2, 640, x6)

inst_360:
// rs1_val==0 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd3, 0x0, -0x2d, x2, 648, x6)

inst_361:
// rs1_val==0 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x2d, 0x0, 0x2d, x2, 656, x6)

inst_362:
// rs1_val==6148914691236517206 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x5555555555555582, 0x5555555555555556, 0x2c, x2, 664, x6)

inst_363:
// rs1_val==6148914691236517206 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aac, 0x5555555555555556, 0x556, x2, 672, x6)

inst_364:
// rs1_val==6148914691236517206 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x5555555555555001, 0x5555555555555556, -0x555, x2, 680, x6)

inst_365:
// rs1_val==6148914691236517206 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x555555555555555c, 0x5555555555555556, 0x6, x2, 688, x6)

inst_366:
// rs1_val==6148914691236517206 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x555555555555588a, 0x5555555555555556, 0x334, x2, 696, x6)

inst_367:
// rs1_val==6148914691236517206 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bbd, 0x5555555555555556, 0x667, x2, 704, x6)

inst_368:
// rs1_val==6148914691236517206 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x555555555555552a, 0x5555555555555556, -0x2c, x2, 712, x6)

inst_369:
// rs1_val==6148914691236517206 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x5555555555555584, 0x5555555555555556, 0x2e, x2, 720, x6)

inst_370:
// rs1_val==-6148914691236517205 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaae, -0x5555555555555555, 0x3, x2, 728, x6)

inst_371:
// rs1_val==-6148914691236517205 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab000, -0x5555555555555555, 0x555, x2, 736, x6)

inst_372:
// rs1_val==-6148914691236517205 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaa555, -0x5555555555555555, -0x556, x2, 744, x6)

inst_373:
// rs1_val==-6148914691236517205 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaab0, -0x5555555555555555, 0x5, x2, 752, x6)

inst_374:
// rs1_val==-6148914691236517205 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaadde, -0x5555555555555555, 0x333, x2, 760, x6)

inst_375:
// rs1_val==-6148914691236517205 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab111, -0x5555555555555555, 0x666, x2, 768, x6)

inst_376:
// rs1_val==-6148914691236517205 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaa7e, -0x5555555555555555, -0x2d, x2, 776, x6)

inst_377:
// rs1_val==-6148914691236517205 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaad8, -0x5555555555555555, 0x2d, x2, 784, x6)

inst_378:
// rs1_val==-6148914691236517205 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaad, -0x5555555555555555, 0x2, x2, 792, x6)

inst_379:
// rs1_val==-6148914691236517205 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaafff, -0x5555555555555555, 0x554, x2, 800, x6)

inst_380:
// rs1_val==-6148914691236517205 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, 0x0, x2, 808, x6)

inst_381:
// rs1_val==-6148914691236517205 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x4, x2, 816, x6)

inst_382:
// rs1_val==-6148914691236517205 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaddd, -0x5555555555555555, 0x332, x2, 824, x6)

inst_383:
// rs1_val==-6148914691236517205 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab110, -0x5555555555555555, 0x665, x2, 832, x6)

inst_384:
// rs1_val==-6148914691236517205 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaad7, -0x5555555555555555, 0x2c, x2, 840, x6)

inst_385:
// rs1_val==-6148914691236517205 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab001, -0x5555555555555555, 0x556, x2, 848, x6)

inst_386:
// rs1_val==-6148914691236517205 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaa556, -0x5555555555555555, -0x555, x2, 856, x6)

inst_387:
// rs1_val==-6148914691236517205 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaab1, -0x5555555555555555, 0x6, x2, 864, x6)

inst_388:
// rs1_val==-6148914691236517205 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaddf, -0x5555555555555555, 0x334, x2, 872, x6)

inst_389:
// rs1_val==-6148914691236517205 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaab112, -0x5555555555555555, 0x667, x2, 880, x6)

inst_390:
// rs1_val==-6148914691236517205 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaa7f, -0x5555555555555555, -0x2c, x2, 888, x6)

inst_391:
// rs1_val==-6148914691236517205 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xaaaaaaaaaaaaaad9, -0x5555555555555555, 0x2e, x2, 896, x6)

inst_392:
// rs1_val==6 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x9, 0x6, 0x3, x2, 904, x6)

inst_393:
// rs1_val==6 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x55b, 0x6, 0x555, x2, 912, x6)

inst_394:
// rs1_val==6 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffab0, 0x6, -0x556, x2, 920, x6)

inst_395:
// rs1_val==6 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xb, 0x6, 0x5, x2, 928, x6)

inst_396:
// rs1_val==6 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x339, 0x6, 0x333, x2, 936, x6)

inst_397:
// rs1_val==6 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66c, 0x6, 0x666, x2, 944, x6)

inst_398:
// rs1_val==6 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd9, 0x6, -0x2d, x2, 952, x6)

inst_399:
// rs1_val==6 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x33, 0x6, 0x2d, x2, 960, x6)

inst_400:
// rs1_val==6 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x8, 0x6, 0x2, x2, 968, x6)

inst_401:
// rs1_val==6 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x55a, 0x6, 0x554, x2, 976, x6)

inst_402:
// rs1_val==6 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x6, 0x6, 0x0, x2, 984, x6)

inst_403:
// rs1_val==6 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xa, 0x6, 0x4, x2, 992, x6)

inst_404:
// rs1_val==6 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x338, 0x6, 0x332, x2, 1000, x6)

inst_405:
// rs1_val==6 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x66b, 0x6, 0x665, x2, 1008, x6)

inst_406:
// rs1_val==6 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x32, 0x6, 0x2c, x2, 1016, x6)

inst_407:
// rs1_val==6 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55c, 0x6, 0x556, x2, 1024, x6)

inst_408:
// rs1_val==6 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffab1, 0x6, -0x555, x2, 1032, x6)

inst_409:
// rs1_val==6 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xc, 0x6, 0x6, x2, 1040, x6)

inst_410:
// rs1_val==6 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x33a, 0x6, 0x334, x2, 1048, x6)

inst_411:
// rs1_val==6 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66d, 0x6, 0x667, x2, 1056, x6)

inst_412:
// rs1_val==6 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffda, 0x6, -0x2c, x2, 1064, x6)

inst_413:
// rs1_val==6 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x34, 0x6, 0x2e, x2, 1072, x6)

inst_414:
// rs1_val==3689348814741910324 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x3333333333333337, 0x3333333333333334, 0x3, x2, 1080, x6)

inst_415:
// rs1_val==3689348814741910324 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x3333333333333889, 0x3333333333333334, 0x555, x2, 1088, x6)

inst_416:
// rs1_val==3689348814741910324 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x3333333333332dde, 0x3333333333333334, -0x556, x2, 1096, x6)

inst_417:
// rs1_val==3689348814741910324 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x3333333333333339, 0x3333333333333334, 0x5, x2, 1104, x6)

inst_418:
// rs1_val==3689348814741910324 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x3333333333333667, 0x3333333333333334, 0x333, x2, 1112, x6)

inst_419:
// rs1_val==3689348814741910324 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x333333333333399a, 0x3333333333333334, 0x666, x2, 1120, x6)

inst_420:
// rs1_val==3689348814741910324 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x3333333333333307, 0x3333333333333334, -0x2d, x2, 1128, x6)

inst_421:
// rs1_val==3689348814741910324 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x3333333333333361, 0x3333333333333334, 0x2d, x2, 1136, x6)

inst_422:
// rs1_val==3689348814741910324 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x3333333333333336, 0x3333333333333334, 0x2, x2, 1144, x6)

inst_423:
// rs1_val==3689348814741910324 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x3333333333333888, 0x3333333333333334, 0x554, x2, 1152, x6)

inst_424:
// rs1_val==3689348814741910324 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x3333333333333334, 0x3333333333333334, 0x0, x2, 1160, x6)

inst_425:
// rs1_val==3689348814741910324 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x3333333333333338, 0x3333333333333334, 0x4, x2, 1168, x6)

inst_426:
// rs1_val==3689348814741910324 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x3333333333333666, 0x3333333333333334, 0x332, x2, 1176, x6)

inst_427:
// rs1_val==3689348814741910324 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x3333333333333999, 0x3333333333333334, 0x665, x2, 1184, x6)

inst_428:
// rs1_val==3689348814741910324 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x3333333333333360, 0x3333333333333334, 0x2c, x2, 1192, x6)

inst_429:
// rs1_val==3689348814741910324 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x333333333333388a, 0x3333333333333334, 0x556, x2, 1200, x6)

inst_430:
// rs1_val==3689348814741910324 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x3333333333332ddf, 0x3333333333333334, -0x555, x2, 1208, x6)

inst_431:
// rs1_val==3689348814741910324 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x333333333333333a, 0x3333333333333334, 0x6, x2, 1216, x6)

inst_432:
// rs1_val==3689348814741910324 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x3333333333333668, 0x3333333333333334, 0x334, x2, 1224, x6)

inst_433:
// rs1_val==3689348814741910324 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x333333333333399b, 0x3333333333333334, 0x667, x2, 1232, x6)

inst_434:
// rs1_val==3689348814741910324 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x3333333333333308, 0x3333333333333334, -0x2c, x2, 1240, x6)

inst_435:
// rs1_val==3689348814741910324 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x3333333333333362, 0x3333333333333334, 0x2e, x2, 1248, x6)

inst_436:
// rs1_val==7378697629483820647 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x666666666666666a, 0x6666666666666667, 0x3, x2, 1256, x6)

inst_437:
// rs1_val==7378697629483820647 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bbc, 0x6666666666666667, 0x555, x2, 1264, x6)

inst_438:
// rs1_val==7378697629483820647 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x6666666666666111, 0x6666666666666667, -0x556, x2, 1272, x6)

inst_439:
// rs1_val==7378697629483820647 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x666666666666666c, 0x6666666666666667, 0x5, x2, 1280, x6)

inst_440:
// rs1_val==7378697629483820647 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x666666666666699a, 0x6666666666666667, 0x333, x2, 1288, x6)

inst_441:
// rs1_val==7378697629483820647 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x6666666666666ccd, 0x6666666666666667, 0x666, x2, 1296, x6)

inst_442:
// rs1_val==7378697629483820647 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x666666666666663a, 0x6666666666666667, -0x2d, x2, 1304, x6)

inst_443:
// rs1_val==7378697629483820647 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x6666666666666694, 0x6666666666666667, 0x2d, x2, 1312, x6)

inst_444:
// rs1_val==7378697629483820647 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x6666666666666669, 0x6666666666666667, 0x2, x2, 1320, x6)

inst_445:
// rs1_val==7378697629483820647 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bbb, 0x6666666666666667, 0x554, x2, 1328, x6)

inst_446:
// rs1_val==7378697629483820647 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x0, x2, 1336, x6)

inst_447:
// rs1_val==7378697629483820647 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x666666666666666b, 0x6666666666666667, 0x4, x2, 1344, x6)

inst_448:
// rs1_val==7378697629483820647 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x6666666666666999, 0x6666666666666667, 0x332, x2, 1352, x6)

inst_449:
// rs1_val==7378697629483820647 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x6666666666666ccc, 0x6666666666666667, 0x665, x2, 1360, x6)

inst_450:
// rs1_val==7378697629483820647 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x6666666666666693, 0x6666666666666667, 0x2c, x2, 1368, x6)

inst_451:
// rs1_val==7378697629483820647 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bbd, 0x6666666666666667, 0x556, x2, 1376, x6)

inst_452:
// rs1_val==7378697629483820647 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x6666666666666112, 0x6666666666666667, -0x555, x2, 1384, x6)

inst_453:
// rs1_val==7378697629483820647 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x666666666666666d, 0x6666666666666667, 0x6, x2, 1392, x6)

inst_454:
// rs1_val==7378697629483820647 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x666666666666699b, 0x6666666666666667, 0x334, x2, 1400, x6)

inst_455:
// rs1_val==7378697629483820647 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x6666666666666cce, 0x6666666666666667, 0x667, x2, 1408, x6)

inst_456:
// rs1_val==7378697629483820647 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x666666666666663b, 0x6666666666666667, -0x2c, x2, 1416, x6)

inst_457:
// rs1_val==7378697629483820647 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x6666666666666695, 0x6666666666666667, 0x2e, x2, 1424, x6)

inst_458:
// rs1_val==-3037000498 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd1, -0xb504f332, 0x3, x2, 1432, x6)

inst_459:
// rs1_val==-3037000498 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1223, -0xb504f332, 0x555, x2, 1440, x6)

inst_460:
// rs1_val==-3037000498 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0778, -0xb504f332, -0x556, x2, 1448, x6)

inst_461:
// rs1_val==-3037000498 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd3, -0xb504f332, 0x5, x2, 1456, x6)

inst_462:
// rs1_val==-3037000498 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1001, -0xb504f332, 0x333, x2, 1464, x6)

inst_463:
// rs1_val==-3037000498 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1334, -0xb504f332, 0x666, x2, 1472, x6)

inst_464:
// rs1_val==-3037000498 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0ca1, -0xb504f332, -0x2d, x2, 1480, x6)

inst_465:
// rs1_val==-3037000498 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cfb, -0xb504f332, 0x2d, x2, 1488, x6)

inst_466:
// rs1_val==-3037000498 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd0, -0xb504f332, 0x2, x2, 1496, x6)

inst_467:
// rs1_val==-3037000498 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1222, -0xb504f332, 0x554, x2, 1504, x6)

inst_468:
// rs1_val==-3037000498 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cce, -0xb504f332, 0x0, x2, 1512, x6)

inst_469:
// rs1_val==-3037000498 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd2, -0xb504f332, 0x4, x2, 1520, x6)

inst_470:
// rs1_val==-3037000498 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1000, -0xb504f332, 0x332, x2, 1528, x6)

inst_471:
// rs1_val==-3037000498 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1333, -0xb504f332, 0x665, x2, 1536, x6)

inst_472:
// rs1_val==-3037000498 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cfa, -0xb504f332, 0x2c, x2, 1544, x6)

inst_473:
// rs1_val==-3037000498 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1224, -0xb504f332, 0x556, x2, 1552, x6)

inst_474:
// rs1_val==-3037000498 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0779, -0xb504f332, -0x555, x2, 1560, x6)

inst_475:
// rs1_val==-3037000498 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cd4, -0xb504f332, 0x6, x2, 1568, x6)

inst_476:
// rs1_val==-3037000498 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1002, -0xb504f332, 0x334, x2, 1576, x6)

inst_477:
// rs1_val==-3037000498 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb1335, -0xb504f332, 0x667, x2, 1584, x6)

inst_478:
// rs1_val==-3037000498 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0ca2, -0xb504f332, -0x2c, x2, 1592, x6)

inst_479:
// rs1_val==-3037000498 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xffffffff4afb0cfc, -0xb504f332, 0x2e, x2, 1600, x6)

inst_480:
// rs1_val==3037000500 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xb504f337, 0xb504f334, 0x3, x2, 1608, x6)

inst_481:
// rs1_val==3037000500 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xb504f889, 0xb504f334, 0x555, x2, 1616, x6)

inst_482:
// rs1_val==3037000500 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xb504edde, 0xb504f334, -0x556, x2, 1624, x6)

inst_483:
// rs1_val==3037000500 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xb504f339, 0xb504f334, 0x5, x2, 1632, x6)

inst_484:
// rs1_val==3037000500 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xb504f667, 0xb504f334, 0x333, x2, 1640, x6)

inst_485:
// rs1_val==3037000500 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xb504f99a, 0xb504f334, 0x666, x2, 1648, x6)

inst_486:
// rs1_val==3037000500 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xb504f307, 0xb504f334, -0x2d, x2, 1656, x6)

inst_487:
// rs1_val==3037000500 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xb504f361, 0xb504f334, 0x2d, x2, 1664, x6)

inst_488:
// rs1_val==3037000500 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xb504f336, 0xb504f334, 0x2, x2, 1672, x6)

inst_489:
// rs1_val==3037000500 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xb504f888, 0xb504f334, 0x554, x2, 1680, x6)

inst_490:
// rs1_val==3037000500 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xb504f334, 0xb504f334, 0x0, x2, 1688, x6)

inst_491:
// rs1_val==3037000500 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xb504f338, 0xb504f334, 0x4, x2, 1696, x6)

inst_492:
// rs1_val==3037000500 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xb504f666, 0xb504f334, 0x332, x2, 1704, x6)

inst_493:
// rs1_val==3037000500 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xb504f999, 0xb504f334, 0x665, x2, 1712, x6)

inst_494:
// rs1_val==3037000500 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xb504f360, 0xb504f334, 0x2c, x2, 1720, x6)

inst_495:
// rs1_val==3037000500 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xb504f88a, 0xb504f334, 0x556, x2, 1728, x6)

inst_496:
// rs1_val==3037000500 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xb504eddf, 0xb504f334, -0x555, x2, 1736, x6)

inst_497:
// rs1_val==3037000500 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xb504f33a, 0xb504f334, 0x6, x2, 1744, x6)

inst_498:
// rs1_val==3037000500 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xb504f668, 0xb504f334, 0x334, x2, 1752, x6)

inst_499:
// rs1_val==3037000500 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xb504f99b, 0xb504f334, 0x667, x2, 1760, x6)

inst_500:
// rs1_val==3037000500 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xb504f308, 0xb504f334, -0x2c, x2, 1768, x6)

inst_501:
// rs1_val==3037000500 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xb504f362, 0xb504f334, 0x2e, x2, 1776, x6)

inst_502:
// rs1_val==0 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x2, 0x0, 0x2, x2, 1784, x6)

inst_503:
// rs1_val==0 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x554, 0x0, 0x554, x2, 1792, x6)

inst_504:
// rs1_val==0 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x0, 0x0, 0x0, x2, 1800, x6)

inst_505:
// rs1_val==0 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x332, 0x0, 0x332, x2, 1808, x6)

inst_506:
// rs1_val==0 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x665, 0x0, 0x665, x2, 1816, x6)

inst_507:
// rs1_val==0 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x2c, 0x0, 0x2c, x2, 1824, x6)

inst_508:
// rs1_val==0 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x556, 0x0, 0x556, x2, 1832, x6)

inst_509:
// rs1_val==0 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaab, 0x0, -0x555, x2, 1840, x6)

inst_510:
// rs1_val==0 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x6, 0x0, 0x6, x2, 1848, x6)

inst_511:
// rs1_val==0 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x334, 0x0, 0x334, x2, 1856, x6)

inst_512:
// rs1_val==0 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x667, 0x0, 0x667, x2, 1864, x6)

inst_513:
// rs1_val==0 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd4, 0x0, -0x2c, x2, 1872, x6)

inst_514:
// rs1_val==0 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x2e, 0x0, 0x2e, x2, 1880, x6)

inst_515:
// rs1_val==4 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x7, 0x4, 0x3, x2, 1888, x6)

inst_516:
// rs1_val==4 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x559, 0x4, 0x555, x2, 1896, x6)

inst_517:
// rs1_val==4 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaae, 0x4, -0x556, x2, 1904, x6)

inst_518:
// rs1_val==4 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x9, 0x4, 0x5, x2, 1912, x6)

inst_519:
// rs1_val==4 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x337, 0x4, 0x333, x2, 1920, x6)

inst_520:
// rs1_val==4 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x66a, 0x4, 0x666, x2, 1928, x6)

inst_521:
// rs1_val==4 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd7, 0x4, -0x2d, x2, 1936, x6)

inst_522:
// rs1_val==4 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x31, 0x4, 0x2d, x2, 1944, x6)

inst_523:
// rs1_val==4 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x6, 0x4, 0x2, x2, 1952, x6)

inst_524:
// rs1_val==4 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x558, 0x4, 0x554, x2, 1960, x6)

inst_525:
// rs1_val==4 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x4, 0x4, 0x0, x2, 1968, x6)

inst_526:
// rs1_val==4 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x8, 0x4, 0x4, x2, 1976, x6)

inst_527:
// rs1_val==4 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x336, 0x4, 0x332, x2, 1984, x6)

inst_528:
// rs1_val==4 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x669, 0x4, 0x665, x2, 1992, x6)

inst_529:
// rs1_val==4 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x30, 0x4, 0x2c, x2, 2000, x6)

inst_530:
// rs1_val==4 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x55a, 0x4, 0x556, x2, 2008, x6)

inst_531:
// rs1_val==4 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xfffffffffffffaaf, 0x4, -0x555, x2, 2016, x6)

inst_532:
// rs1_val==4 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xa, 0x4, 0x6, x2, 2024, x6)

inst_533:
// rs1_val==4 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x338, 0x4, 0x334, x2, 2032, x6)

inst_534:
// rs1_val==4 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x66b, 0x4, 0x667, x2, 2040, x6)
RVTEST_SIGBASE( x2,signature_x2_2)

inst_535:
// rs1_val==4 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xffffffffffffffd8, 0x4, -0x2c, x2, 0, x6)

inst_536:
// rs1_val==4 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x32, 0x4, 0x2e, x2, 8, x6)

inst_537:
// rs1_val==3689348814741910322 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x3333333333333335, 0x3333333333333332, 0x3, x2, 16, x6)

inst_538:
// rs1_val==3689348814741910322 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x3333333333333887, 0x3333333333333332, 0x555, x2, 24, x6)

inst_539:
// rs1_val==3689348814741910322 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x3333333333332ddc, 0x3333333333333332, -0x556, x2, 32, x6)

inst_540:
// rs1_val==3689348814741910322 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x3333333333333337, 0x3333333333333332, 0x5, x2, 40, x6)

inst_541:
// rs1_val==3689348814741910322 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x3333333333333665, 0x3333333333333332, 0x333, x2, 48, x6)

inst_542:
// rs1_val==3689348814741910322 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x3333333333333998, 0x3333333333333332, 0x666, x2, 56, x6)

inst_543:
// rs1_val==3689348814741910322 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x3333333333333305, 0x3333333333333332, -0x2d, x2, 64, x6)

inst_544:
// rs1_val==3689348814741910322 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x333333333333335f, 0x3333333333333332, 0x2d, x2, 72, x6)

inst_545:
// rs1_val==3689348814741910322 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x3333333333333334, 0x3333333333333332, 0x2, x2, 80, x6)

inst_546:
// rs1_val==3689348814741910322 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x3333333333333886, 0x3333333333333332, 0x554, x2, 88, x6)

inst_547:
// rs1_val==3689348814741910322 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x3333333333333332, 0x3333333333333332, 0x0, x2, 96, x6)

inst_548:
// rs1_val==3689348814741910322 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x3333333333333336, 0x3333333333333332, 0x4, x2, 104, x6)

inst_549:
// rs1_val==3689348814741910322 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x3333333333333664, 0x3333333333333332, 0x332, x2, 112, x6)

inst_550:
// rs1_val==3689348814741910322 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x3333333333333997, 0x3333333333333332, 0x665, x2, 120, x6)

inst_551:
// rs1_val==3689348814741910322 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x333333333333335e, 0x3333333333333332, 0x2c, x2, 128, x6)

inst_552:
// rs1_val==3689348814741910322 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x3333333333333888, 0x3333333333333332, 0x556, x2, 136, x6)

inst_553:
// rs1_val==3689348814741910322 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x3333333333332ddd, 0x3333333333333332, -0x555, x2, 144, x6)

inst_554:
// rs1_val==3689348814741910322 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x3333333333333338, 0x3333333333333332, 0x6, x2, 152, x6)

inst_555:
// rs1_val==3689348814741910322 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x3333333333333666, 0x3333333333333332, 0x334, x2, 160, x6)

inst_556:
// rs1_val==3689348814741910322 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x3333333333333999, 0x3333333333333332, 0x667, x2, 168, x6)

inst_557:
// rs1_val==3689348814741910322 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x3333333333333306, 0x3333333333333332, -0x2c, x2, 176, x6)

inst_558:
// rs1_val==3689348814741910322 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x3333333333333360, 0x3333333333333332, 0x2e, x2, 184, x6)

inst_559:
// rs1_val==7378697629483820645 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x6666666666666668, 0x6666666666666665, 0x3, x2, 192, x6)

inst_560:
// rs1_val==7378697629483820645 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bba, 0x6666666666666665, 0x555, x2, 200, x6)

inst_561:
// rs1_val==7378697629483820645 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x666666666666610f, 0x6666666666666665, -0x556, x2, 208, x6)

inst_562:
// rs1_val==7378697629483820645 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x666666666666666a, 0x6666666666666665, 0x5, x2, 216, x6)

inst_563:
// rs1_val==7378697629483820645 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x6666666666666998, 0x6666666666666665, 0x333, x2, 224, x6)

inst_564:
// rs1_val==7378697629483820645 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x6666666666666ccb, 0x6666666666666665, 0x666, x2, 232, x6)

inst_565:
// rs1_val==7378697629483820645 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x6666666666666638, 0x6666666666666665, -0x2d, x2, 240, x6)

inst_566:
// rs1_val==7378697629483820645 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x6666666666666692, 0x6666666666666665, 0x2d, x2, 248, x6)

inst_567:
// rs1_val==7378697629483820645 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x6666666666666667, 0x6666666666666665, 0x2, x2, 256, x6)

inst_568:
// rs1_val==7378697629483820645 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bb9, 0x6666666666666665, 0x554, x2, 264, x6)

inst_569:
// rs1_val==7378697629483820645 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x6666666666666665, 0x6666666666666665, 0x0, x2, 272, x6)

inst_570:
// rs1_val==7378697629483820645 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x6666666666666669, 0x6666666666666665, 0x4, x2, 280, x6)

inst_571:
// rs1_val==7378697629483820645 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x6666666666666997, 0x6666666666666665, 0x332, x2, 288, x6)

inst_572:
// rs1_val==7378697629483820645 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x6666666666666cca, 0x6666666666666665, 0x665, x2, 296, x6)

inst_573:
// rs1_val==7378697629483820645 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0x6666666666666691, 0x6666666666666665, 0x2c, x2, 304, x6)

inst_574:
// rs1_val==7378697629483820645 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0x6666666666666bbb, 0x6666666666666665, 0x556, x2, 312, x6)

inst_575:
// rs1_val==7378697629483820645 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0x6666666666666110, 0x6666666666666665, -0x555, x2, 320, x6)

inst_576:
// rs1_val==7378697629483820645 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0x666666666666666b, 0x6666666666666665, 0x6, x2, 328, x6)

inst_577:
// rs1_val==7378697629483820645 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0x6666666666666999, 0x6666666666666665, 0x334, x2, 336, x6)

inst_578:
// rs1_val==7378697629483820645 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0x6666666666666ccc, 0x6666666666666665, 0x667, x2, 344, x6)

inst_579:
// rs1_val==7378697629483820645 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0x6666666666666639, 0x6666666666666665, -0x2c, x2, 352, x6)

inst_580:
// rs1_val==7378697629483820645 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0x6666666666666693, 0x6666666666666665, 0x2e, x2, 360, x6)

inst_581:
// rs1_val==3037000498 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0xb504f335, 0xb504f332, 0x3, x2, 368, x6)

inst_582:
// rs1_val==3037000498 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0xb504f887, 0xb504f332, 0x555, x2, 376, x6)

inst_583:
// rs1_val==3037000498 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0xb504eddc, 0xb504f332, -0x556, x2, 384, x6)

inst_584:
// rs1_val==3037000498 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0xb504f337, 0xb504f332, 0x5, x2, 392, x6)

inst_585:
// rs1_val==3037000498 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0xb504f665, 0xb504f332, 0x333, x2, 400, x6)

inst_586:
// rs1_val==3037000498 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0xb504f998, 0xb504f332, 0x666, x2, 408, x6)

inst_587:
// rs1_val==3037000498 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0xb504f305, 0xb504f332, -0x2d, x2, 416, x6)

inst_588:
// rs1_val==3037000498 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0xb504f35f, 0xb504f332, 0x2d, x2, 424, x6)

inst_589:
// rs1_val==3037000498 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0xb504f334, 0xb504f332, 0x2, x2, 432, x6)

inst_590:
// rs1_val==3037000498 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0xb504f886, 0xb504f332, 0x554, x2, 440, x6)

inst_591:
// rs1_val==3037000498 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0xb504f332, 0xb504f332, 0x0, x2, 448, x6)

inst_592:
// rs1_val==3037000498 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0xb504f336, 0xb504f332, 0x4, x2, 456, x6)

inst_593:
// rs1_val==3037000498 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0xb504f664, 0xb504f332, 0x332, x2, 464, x6)

inst_594:
// rs1_val==3037000498 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0xb504f997, 0xb504f332, 0x665, x2, 472, x6)

inst_595:
// rs1_val==3037000498 and imm_val==44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2c
TEST_IMM_OP( addi, x11, x10, 0xb504f35e, 0xb504f332, 0x2c, x2, 480, x6)

inst_596:
// rs1_val==3037000498 and imm_val==1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x556
TEST_IMM_OP( addi, x11, x10, 0xb504f888, 0xb504f332, 0x556, x2, 488, x6)

inst_597:
// rs1_val==3037000498 and imm_val==-1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x555
TEST_IMM_OP( addi, x11, x10, 0xb504eddd, 0xb504f332, -0x555, x2, 496, x6)

inst_598:
// rs1_val==3037000498 and imm_val==6, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x6
TEST_IMM_OP( addi, x11, x10, 0xb504f338, 0xb504f332, 0x6, x2, 504, x6)

inst_599:
// rs1_val==3037000498 and imm_val==820, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x334
TEST_IMM_OP( addi, x11, x10, 0xb504f666, 0xb504f332, 0x334, x2, 512, x6)

inst_600:
// rs1_val==3037000498 and imm_val==1639, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x667
TEST_IMM_OP( addi, x11, x10, 0xb504f999, 0xb504f332, 0x667, x2, 520, x6)

inst_601:
// rs1_val==3037000498 and imm_val==-44, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2c
TEST_IMM_OP( addi, x11, x10, 0xb504f306, 0xb504f332, -0x2c, x2, 528, x6)

inst_602:
// rs1_val==3037000498 and imm_val==46, 
// opcode: addi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2e
TEST_IMM_OP( addi, x11, x10, 0xb504f360, 0xb504f332, 0x2e, x2, 536, x6)

inst_603:
// rs1_val==6148914691236517206 and imm_val==3, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x3
TEST_IMM_OP( addi, x11, x10, 0x5555555555555559, 0x5555555555555556, 0x3, x2, 544, x6)

inst_604:
// rs1_val==6148914691236517206 and imm_val==1365, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x555
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aab, 0x5555555555555556, 0x555, x2, 552, x6)

inst_605:
// rs1_val==6148914691236517206 and imm_val==-1366, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x556
TEST_IMM_OP( addi, x11, x10, 0x5555555555555000, 0x5555555555555556, -0x556, x2, 560, x6)

inst_606:
// rs1_val==6148914691236517206 and imm_val==5, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x5
TEST_IMM_OP( addi, x11, x10, 0x555555555555555b, 0x5555555555555556, 0x5, x2, 568, x6)

inst_607:
// rs1_val==6148914691236517206 and imm_val==819, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x333
TEST_IMM_OP( addi, x11, x10, 0x5555555555555889, 0x5555555555555556, 0x333, x2, 576, x6)

inst_608:
// rs1_val==6148914691236517206 and imm_val==1638, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x666
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bbc, 0x5555555555555556, 0x666, x2, 584, x6)

inst_609:
// rs1_val==6148914691236517206 and imm_val==-45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( addi, x11, x10, 0x5555555555555529, 0x5555555555555556, -0x2d, x2, 592, x6)

inst_610:
// rs1_val==6148914691236517206 and imm_val==45, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2d
TEST_IMM_OP( addi, x11, x10, 0x5555555555555583, 0x5555555555555556, 0x2d, x2, 600, x6)

inst_611:
// rs1_val==6148914691236517206 and imm_val==2, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2
TEST_IMM_OP( addi, x11, x10, 0x5555555555555558, 0x5555555555555556, 0x2, x2, 608, x6)

inst_612:
// rs1_val==6148914691236517206 and imm_val==1364, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x554
TEST_IMM_OP( addi, x11, x10, 0x5555555555555aaa, 0x5555555555555556, 0x554, x2, 616, x6)

inst_613:
// rs1_val==6148914691236517206 and imm_val==0, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x0
TEST_IMM_OP( addi, x11, x10, 0x5555555555555556, 0x5555555555555556, 0x0, x2, 624, x6)

inst_614:
// rs1_val==6148914691236517206 and imm_val==4, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x4
TEST_IMM_OP( addi, x11, x10, 0x555555555555555a, 0x5555555555555556, 0x4, x2, 632, x6)

inst_615:
// rs1_val==6148914691236517206 and imm_val==818, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x332
TEST_IMM_OP( addi, x11, x10, 0x5555555555555888, 0x5555555555555556, 0x332, x2, 640, x6)

inst_616:
// rs1_val==6148914691236517206 and imm_val==1637, 
// opcode: addi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x665
TEST_IMM_OP( addi, x11, x10, 0x5555555555555bbb, 0x5555555555555556, 0x665, x2, 648, x6)

inst_617:
// rs1_val == (2**(xlen-1)-1), imm_val == -513, rs1_val > 0 and imm_val < 0, rs1_val == 9223372036854775807
// opcode: addi ; op1:x10; dest:x11; op1val:0x7fffffffffffffff;  immval:-0x201
TEST_IMM_OP( addi, x11, x10, 0x7ffffffffffffdfe, 0x7fffffffffffffff, -0x201, x2, 656, x6)

inst_618:
// imm_val == 1024, rs1_val == -17
// opcode: addi ; op1:x10; dest:x11; op1val:-0x11;  immval:0x400
TEST_IMM_OP( addi, x11, x10, 0x3ef, -0x11, 0x400, x2, 664, x6)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x16_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x16_1:
    .fill 23*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x2_2:
    .fill 84*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
