
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the addiw instruction of the RISC-V I extension for the addiw covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*RV64.*I.*);def TEST_CASE_1=True;",addiw)

RVTEST_SIGBASE( x15,signature_x15_1)

inst_0:
// rs1 == rd, rs1==x17, rd==x17, imm_val == (-2**(12-1)), imm_val == -2048, rs1_val != imm_val, rs1_val < 0 and imm_val < 0, rs1_val == -6148914691236517206
// opcode: addiw ; op1:x17; dest:x17; op1val:-0x5555555555555556;  immval:-0x800
TEST_IMM_OP( addiw, x17, x17, -0x55555d56, -0x5555555555555556, -0x800, x15, 0, x5)

inst_1:
// rs1 != rd, rs1==x2, rd==x20, imm_val == 0, rs1_val == -536870913
// opcode: addiw ; op1:x2; dest:x20; op1val:-0x20000001;  immval:0x0
TEST_IMM_OP( addiw, x20, x2, -0x20000001, -0x20000001, 0x0, x15, 8, x5)

inst_2:
// rs1==x20, rd==x16, imm_val == (2**(12-1)-1), rs1_val < 0 and imm_val > 0, imm_val == 2047
// opcode: addiw ; op1:x20; dest:x16; op1val:-0x4000000000000000;  immval:0x7ff
TEST_IMM_OP( addiw, x16, x20, 0x7ff, -0x4000000000000000, 0x7ff, x15, 16, x5)

inst_3:
// rs1==x26, rd==x29, imm_val == 1, rs1_val > 0 and imm_val > 0
// opcode: addiw ; op1:x26; dest:x29; op1val:0x5555555555555556;  immval:0x1
TEST_IMM_OP( addiw, x29, x26, 0x55555557, 0x5555555555555556, 0x1, x15, 24, x5)

inst_4:
// rs1==x8, rd==x27, rs1_val == (-2**(xlen-1)), rs1_val == -9223372036854775808
// opcode: addiw ; op1:x8; dest:x27; op1val:-0x8000000000000000;  immval:0x333
TEST_IMM_OP( addiw, x27, x8, 0x333, -0x8000000000000000, 0x333, x15, 32, x5)

inst_5:
// rs1==x18, rd==x25, rs1_val == 0, rs1_val==0 and imm_val==-1366, imm_val == -1366
// opcode: addiw ; op1:x18; dest:x25; op1val:0x0;  immval:-0x556
TEST_IMM_OP( addiw, x25, x18, -0x556, 0x0, -0x556, x15, 40, x5)

inst_6:
// rs1==x7, rd==x6, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807
// opcode: addiw ; op1:x7; dest:x6; op1val:0x7fffffffffffffff;  immval:0x7
TEST_IMM_OP( addiw, x6, x7, 0x6, 0x7fffffffffffffff, 0x7, x15, 48, x5)

inst_7:
// rs1==x10, rd==x0, rs1_val == 1, 
// opcode: addiw ; op1:x10; dest:x0; op1val:0x1;  immval:0x6
TEST_IMM_OP( addiw, x0, x10, 0, 0x1, 0x6, x15, 56, x5)

inst_8:
// rs1==x27, rd==x9, rs1_val == imm_val, imm_val == 8, rs1_val == 8
// opcode: addiw ; op1:x27; dest:x9; op1val:0x8;  immval:0x8
TEST_IMM_OP( addiw, x9, x27, 0x10, 0x8, 0x8, x15, 64, x5)

inst_9:
// rs1==x6, rd==x31, rs1_val > 0 and imm_val < 0, 
// opcode: addiw ; op1:x6; dest:x31; op1val:0x7;  immval:-0x400
TEST_IMM_OP( addiw, x31, x6, -0x3f9, 0x7, -0x400, x15, 72, x5)

inst_10:
// rs1==x0, rd==x22, imm_val == 2, rs1_val == 4294967296
// opcode: addiw ; op1:x0; dest:x22; op1val:0x0;  immval:0x2
TEST_IMM_OP( addiw, x22, x0, 0x2, 0x0, 0x2, x15, 80, x5)

inst_11:
// rs1==x16, rd==x7, imm_val == 4, rs1_val == -2
// opcode: addiw ; op1:x16; dest:x7; op1val:-0x2;  immval:0x4
TEST_IMM_OP( addiw, x7, x16, 0x2, -0x2, 0x4, x15, 88, x5)

inst_12:
// rs1==x19, rd==x21, imm_val == 16, rs1_val == 4
// opcode: addiw ; op1:x19; dest:x21; op1val:0x4;  immval:0x10
TEST_IMM_OP( addiw, x21, x19, 0x14, 0x4, 0x10, x15, 96, x5)

inst_13:
// rs1==x1, rd==x4, imm_val == 32, rs1_val == -562949953421313
// opcode: addiw ; op1:x1; dest:x4; op1val:-0x2000000000001;  immval:0x20
TEST_IMM_OP( addiw, x4, x1, 0x1f, -0x2000000000001, 0x20, x15, 104, x5)

inst_14:
// rs1==x13, rd==x23, imm_val == 64, rs1_val == 16384
// opcode: addiw ; op1:x13; dest:x23; op1val:0x4000;  immval:0x40
TEST_IMM_OP( addiw, x23, x13, 0x4040, 0x4000, 0x40, x15, 112, x5)

inst_15:
// rs1==x29, rd==x13, imm_val == 128, 
// opcode: addiw ; op1:x29; dest:x13; op1val:-0x4000000000000000;  immval:0x80
TEST_IMM_OP( addiw, x13, x29, 0x80, -0x4000000000000000, 0x80, x15, 120, x5)

inst_16:
// rs1==x24, rd==x12, imm_val == 256, 
// opcode: addiw ; op1:x24; dest:x12; op1val:-0x7;  immval:0x100
TEST_IMM_OP( addiw, x12, x24, 0xf9, -0x7, 0x100, x15, 128, x5)

inst_17:
// rs1==x31, rd==x10, imm_val == 512, rs1_val == -8796093022209
// opcode: addiw ; op1:x31; dest:x10; op1val:-0x80000000001;  immval:0x200
TEST_IMM_OP( addiw, x10, x31, 0x1ff, -0x80000000001, 0x200, x15, 136, x5)

inst_18:
// rs1==x11, rd==x3, imm_val == 1024, 
// opcode: addiw ; op1:x11; dest:x3; op1val:0xb504f332;  immval:0x400
TEST_IMM_OP( addiw, x3, x11, -0x4afb08ce, 0xb504f332, 0x400, x15, 144, x5)

inst_19:
// rs1==x9, rd==x14, imm_val == -2, rs1_val == 4503599627370496
// opcode: addiw ; op1:x9; dest:x14; op1val:0x10000000000000;  immval:-0x2
TEST_IMM_OP( addiw, x14, x9, -0x2, 0x10000000000000, -0x2, x15, 152, x5)

inst_20:
// rs1==x14, rd==x26, imm_val == -3, rs1_val == 1073741824
// opcode: addiw ; op1:x14; dest:x26; op1val:0x40000000;  immval:-0x3
TEST_IMM_OP( addiw, x26, x14, 0x3ffffffd, 0x40000000, -0x3, x15, 160, x7)

inst_21:
// rs1==x28, rd==x5, imm_val == -5, 
// opcode: addiw ; op1:x28; dest:x5; op1val:0x0;  immval:-0x5
TEST_IMM_OP( addiw, x5, x28, -0x5, 0x0, -0x5, x15, 168, x7)
RVTEST_SIGBASE( x6,signature_x6_0)

inst_22:
// rs1==x25, rd==x18, imm_val == -9, rs1_val == -2147483649
// opcode: addiw ; op1:x25; dest:x18; op1val:-0x80000001;  immval:-0x9
TEST_IMM_OP( addiw, x18, x25, 0x7ffffff6, -0x80000001, -0x9, x6, 0, x7)

inst_23:
// rs1==x4, rd==x19, imm_val == -17, rs1_val == -36028797018963969
// opcode: addiw ; op1:x4; dest:x19; op1val:-0x80000000000001;  immval:-0x11
TEST_IMM_OP( addiw, x19, x4, -0x12, -0x80000000000001, -0x11, x6, 8, x7)

inst_24:
// rs1==x30, rd==x2, imm_val == -33, rs1_val == -1048577
// opcode: addiw ; op1:x30; dest:x2; op1val:-0x100001;  immval:-0x21
TEST_IMM_OP( addiw, x2, x30, -0x100022, -0x100001, -0x21, x6, 16, x7)

inst_25:
// rs1==x21, rd==x15, imm_val == -65, rs1_val == -288230376151711745
// opcode: addiw ; op1:x21; dest:x15; op1val:-0x400000000000001;  immval:-0x41
TEST_IMM_OP( addiw, x15, x21, -0x42, -0x400000000000001, -0x41, x6, 24, x7)

inst_26:
// rs1==x3, rd==x8, imm_val == -129, 
// opcode: addiw ; op1:x3; dest:x8; op1val:-0x8000000000000000;  immval:-0x81
TEST_IMM_OP( addiw, x8, x3, -0x81, -0x8000000000000000, -0x81, x6, 32, x7)

inst_27:
// rs1==x12, rd==x30, imm_val == -257, 
// opcode: addiw ; op1:x12; dest:x30; op1val:0x3333333333333334;  immval:-0x101
TEST_IMM_OP( addiw, x30, x12, 0x33333233, 0x3333333333333334, -0x101, x6, 40, x7)

inst_28:
// rs1==x15, rd==x11, imm_val == -513, rs1_val == 4194304
// opcode: addiw ; op1:x15; dest:x11; op1val:0x400000;  immval:-0x201
TEST_IMM_OP( addiw, x11, x15, 0x3ffdff, 0x400000, -0x201, x6, 48, x7)

inst_29:
// rs1==x23, rd==x24, imm_val == -1025, 
// opcode: addiw ; op1:x23; dest:x24; op1val:-0xa;  immval:-0x401
TEST_IMM_OP( addiw, x24, x23, -0x40b, -0xa, -0x401, x6, 56, x7)

inst_30:
// rs1==x5, rd==x28, imm_val == 1365, rs1_val==-6148914691236517206 and imm_val==1365
// opcode: addiw ; op1:x5; dest:x28; op1val:-0x5555555555555556;  immval:0x555
TEST_IMM_OP( addiw, x28, x5, -0x55555001, -0x5555555555555556, 0x555, x6, 64, x7)

inst_31:
// rs1==x22, rd==x1, rs1_val == 2, rs1_val==2 and imm_val==819
// opcode: addiw ; op1:x22; dest:x1; op1val:0x2;  immval:0x333
TEST_IMM_OP( addiw, x1, x22, 0x335, 0x2, 0x333, x6, 72, x7)

inst_32:
// rs1_val == 16, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x10;  immval:0x9
TEST_IMM_OP( addiw, x11, x10, 0x19, 0x10, 0x9, x6, 80, x7)

inst_33:
// rs1_val == 32, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x20;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x24, 0x20, 0x4, x6, 88, x7)

inst_34:
// rs1_val == 64, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x40;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x594, 0x40, 0x554, x6, 96, x7)

inst_35:
// rs1_val == 128, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x80;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x80, 0x80, 0x0, x6, 104, x7)

inst_36:
// rs1_val == 256, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x100;  immval:0x8
TEST_IMM_OP( addiw, x11, x10, 0x108, 0x100, 0x8, x6, 112, x7)

inst_37:
// rs1_val == 512, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x200;  immval:0x3ff
TEST_IMM_OP( addiw, x11, x10, 0x5ff, 0x200, 0x3ff, x6, 120, x7)

inst_38:
// rs1_val == 1024, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x400;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x42e, 0x400, 0x2e, x6, 128, x7)

inst_39:
// rs1_val == 2048, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x800;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0xb34, 0x800, 0x334, x6, 136, x7)

inst_40:
// rs1_val == 4096, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x1000;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x1555, 0x1000, 0x555, x6, 144, x7)

inst_41:
// rs1_val == 8192, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2000;  immval:0x80
TEST_IMM_OP( addiw, x11, x10, 0x2080, 0x2000, 0x80, x6, 152, x7)

inst_42:
// rs1_val == 32768, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x8000;  immval:0x80
TEST_IMM_OP( addiw, x11, x10, 0x8080, 0x8000, 0x80, x6, 160, x7)

inst_43:
// rs1_val == 65536, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x10000;  immval:-0x7
TEST_IMM_OP( addiw, x11, x10, 0xfff9, 0x10000, -0x7, x6, 168, x7)

inst_44:
// rs1_val == 131072, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x20000;  immval:0x7
TEST_IMM_OP( addiw, x11, x10, 0x20007, 0x20000, 0x7, x6, 176, x7)

inst_45:
// rs1_val == 262144, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x40000;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x3ffd4, 0x40000, -0x2c, x6, 184, x7)

inst_46:
// rs1_val == 524288, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x80000;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x80665, 0x80000, 0x665, x6, 192, x7)

inst_47:
// rs1_val == 1048576, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x100000;  immval:-0x9
TEST_IMM_OP( addiw, x11, x10, 0xffff7, 0x100000, -0x9, x6, 200, x7)

inst_48:
// rs1_val == 2097152, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x200000;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x200002, 0x200000, 0x2, x6, 208, x7)

inst_49:
// rs1_val == 8388608, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x800000;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x800004, 0x800000, 0x4, x6, 216, x7)

inst_50:
// rs1_val == 16777216, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x1000000;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x1000003, 0x1000000, 0x3, x6, 224, x7)

inst_51:
// rs1_val == 33554432, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2000000;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x2000666, 0x2000000, 0x666, x6, 232, x7)

inst_52:
// rs1_val == 67108864, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x20
TEST_IMM_OP( addiw, x11, x10, 0x4000020, 0x4000000, 0x20, x6, 240, x7)

inst_53:
// rs1_val == 134217728, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x9
TEST_IMM_OP( addiw, x11, x10, 0x8000009, 0x8000000, 0x9, x6, 248, x7)

inst_54:
// rs1_val == 268435456, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x10000004, 0x10000000, 0x4, x6, 256, x7)

inst_55:
// rs1_val == 536870912, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x20000000;  immval:-0x7
TEST_IMM_OP( addiw, x11, x10, 0x1ffffff9, 0x20000000, -0x7, x6, 264, x7)

inst_56:
// rs1_val == 2147483648, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x80000000;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, -0x7ffffccc, 0x80000000, 0x334, x6, 272, x7)

inst_57:
// rs1_val == 8589934592, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x200000000;  immval:0x9
TEST_IMM_OP( addiw, x11, x10, 0x9, 0x200000000, 0x9, x6, 280, x7)

inst_58:
// rs1_val == 17179869184, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x400000000;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x2d, 0x400000000, -0x2d, x6, 288, x7)

inst_59:
// rs1_val == 34359738368, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x800000000;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x5, 0x800000000, 0x5, x6, 296, x7)

inst_60:
// rs1_val == 68719476736, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x1000000000;  immval:-0x6
TEST_IMM_OP( addiw, x11, x10, -0x6, 0x1000000000, -0x6, x6, 304, x7)

inst_61:
// rs1_val == 137438953472, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2000000000;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x2d, 0x2000000000, -0x2d, x6, 312, x7)

inst_62:
// rs1_val == 274877906944, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4000000000;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x4, 0x4000000000, 0x4, x6, 320, x7)

inst_63:
// rs1_val == 549755813888, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x100
TEST_IMM_OP( addiw, x11, x10, 0x100, 0x8000000000, 0x100, x6, 328, x7)

inst_64:
// rs1_val == 1099511627776, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x10000000000;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x6, 0x10000000000, 0x6, x6, 336, x7)

inst_65:
// rs1_val == 2199023255552, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x20000000000;  immval:-0x3
TEST_IMM_OP( addiw, x11, x10, -0x3, 0x20000000000, -0x3, x6, 344, x7)

inst_66:
// rs1_val == 4398046511104, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x40000000000;  immval:-0xa
TEST_IMM_OP( addiw, x11, x10, -0xa, 0x40000000000, -0xa, x6, 352, x7)

inst_67:
// rs1_val == 8796093022208, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x5, 0x80000000000, 0x5, x6, 360, x7)

inst_68:
// rs1_val == 17592186044416, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x100000000000;  immval:-0x6
TEST_IMM_OP( addiw, x11, x10, -0x6, 0x100000000000, -0x6, x6, 368, x7)

inst_69:
// rs1_val == 35184372088832, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x200000000000;  immval:-0x4
TEST_IMM_OP( addiw, x11, x10, -0x4, 0x200000000000, -0x4, x6, 376, x7)

inst_70:
// rs1_val == 70368744177664, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x334, 0x400000000000, 0x334, x6, 384, x7)

inst_71:
// rs1_val == 140737488355328, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x800000000000;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x555, 0x800000000000, 0x555, x6, 392, x7)

inst_72:
// rs1_val == 281474976710656, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x2c, 0x1000000000000, 0x2c, x6, 400, x7)

inst_73:
// rs1_val == 562949953421312, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x4, 0x2000000000000, 0x4, x6, 408, x7)

inst_74:
// rs1_val == 1125899906842624, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x667, 0x4000000000000, 0x667, x6, 416, x7)

inst_75:
// rs1_val == 2251799813685248, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x8000000000000;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x332, 0x8000000000000, 0x332, x6, 424, x7)

inst_76:
// rs1_val == 9007199254740992, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:-0x9
TEST_IMM_OP( addiw, x11, x10, -0x9, 0x20000000000000, -0x9, x6, 432, x7)

inst_77:
// rs1_val == 18014398509481984, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:-0x3
TEST_IMM_OP( addiw, x11, x10, -0x3, 0x40000000000000, -0x3, x6, 440, x7)

inst_78:
// rs1_val == 36028797018963968, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:-0x4
TEST_IMM_OP( addiw, x11, x10, -0x4, 0x80000000000000, -0x4, x6, 448, x7)

inst_79:
// rs1_val == 72057594037927936, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:0x8
TEST_IMM_OP( addiw, x11, x10, 0x8, 0x100000000000000, 0x8, x6, 456, x7)

inst_80:
// rs1_val == 144115188075855872, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:-0x8
TEST_IMM_OP( addiw, x11, x10, -0x8, 0x200000000000000, -0x8, x6, 464, x7)

inst_81:
// rs1_val == 288230376151711744, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0x1
TEST_IMM_OP( addiw, x11, x10, 0x1, 0x400000000000000, 0x1, x6, 472, x7)

inst_82:
// rs1_val == 576460752303423488, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:0x1
TEST_IMM_OP( addiw, x11, x10, 0x1, 0x800000000000000, 0x1, x6, 480, x7)

inst_83:
// rs1_val == 1152921504606846976, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x2, 0x1000000000000000, 0x2, x6, 488, x7)

inst_84:
// rs1_val == 2305843009213693952, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x8
TEST_IMM_OP( addiw, x11, x10, 0x8, 0x2000000000000000, 0x8, x6, 496, x7)

inst_85:
// rs1_val == 4611686018427387904, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4000000000000000;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x334, 0x4000000000000000, 0x334, x6, 504, x7)

inst_86:
// rs1_val == -3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x3;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x551, -0x3, 0x554, x6, 512, x7)

inst_87:
// rs1_val == -5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5;  immval:-0x6
TEST_IMM_OP( addiw, x11, x10, -0xb, -0x5, -0x6, x6, 520, x7)

inst_88:
// rs1_val == -9, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x9;  immval:-0x6
TEST_IMM_OP( addiw, x11, x10, -0xf, -0x9, -0x6, x6, 528, x7)

inst_89:
// rs1_val == -17, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x11;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x1b, -0x11, 0x2c, x6, 536, x7)

inst_90:
// rs1_val == -33, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x21;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x313, -0x21, 0x334, x6, 544, x7)

inst_91:
// rs1_val == -65, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x41;  immval:-0x101
TEST_IMM_OP( addiw, x11, x10, -0x142, -0x41, -0x101, x6, 552, x7)

inst_92:
// rs1_val == -129, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x81;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, -0x54, -0x81, 0x2d, x6, 560, x7)

inst_93:
// rs1_val == -257, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x101;  immval:0x200
TEST_IMM_OP( addiw, x11, x10, 0xff, -0x101, 0x200, x6, 568, x7)

inst_94:
// rs1_val == -513, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x201;  immval:-0xa
TEST_IMM_OP( addiw, x11, x10, -0x20b, -0x201, -0xa, x6, 576, x7)

inst_95:
// rs1_val == -1025, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x401;  immval:-0x8
TEST_IMM_OP( addiw, x11, x10, -0x409, -0x401, -0x8, x6, 584, x7)

inst_96:
// rs1_val == -2049, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x801;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, -0x7fd, -0x801, 0x4, x6, 592, x7)

inst_97:
// rs1_val == -4097, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x1001;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, -0x99b, -0x1001, 0x666, x6, 600, x7)

inst_98:
// rs1_val == -8193, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x2001;  immval:-0x401
TEST_IMM_OP( addiw, x11, x10, -0x2402, -0x2001, -0x401, x6, 608, x7)

inst_99:
// rs1_val == -16385, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, -0x3ccf, -0x4001, 0x332, x6, 616, x7)

inst_100:
// rs1_val == -32769, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x80
TEST_IMM_OP( addiw, x11, x10, -0x7f81, -0x8001, 0x80, x6, 624, x7)

inst_101:
// rs1_val == -65537, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x10001;  immval:-0x101
TEST_IMM_OP( addiw, x11, x10, -0x10102, -0x10001, -0x101, x6, 632, x7)

inst_102:
// rs1_val == -131073, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x20001;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, -0x1ffff, -0x20001, 0x2, x6, 640, x7)

inst_103:
// rs1_val == -262145, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x40001;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x40557, -0x40001, -0x556, x6, 648, x7)

inst_104:
// rs1_val == -524289, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x80001;  immval:-0x8
TEST_IMM_OP( addiw, x11, x10, -0x80009, -0x80001, -0x8, x6, 656, x7)

inst_105:
// rs1_val == -2097153, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x200001;  immval:-0x8
TEST_IMM_OP( addiw, x11, x10, -0x200009, -0x200001, -0x8, x6, 664, x7)

inst_106:
// rs1_val == -4194305, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, -0x3fffff, -0x400001, 0x2, x6, 672, x7)

inst_107:
// rs1_val == -8388609, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x800001;  immval:0x400
TEST_IMM_OP( addiw, x11, x10, -0x7ffc01, -0x800001, 0x400, x6, 680, x7)

inst_108:
// rs1_val == -16777217, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x1000001;  immval:-0x7
TEST_IMM_OP( addiw, x11, x10, -0x1000008, -0x1000001, -0x7, x6, 688, x7)

inst_109:
// rs1_val == -33554433, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x2000001;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x200002d, -0x2000001, -0x2c, x6, 696, x7)

inst_110:
// rs1_val == -67108865, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x4000001;  immval:-0x800
TEST_IMM_OP( addiw, x11, x10, -0x4000801, -0x4000001, -0x800, x6, 704, x7)

inst_111:
// rs1_val == -134217729, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, -0x7fffaad, -0x8000001, 0x554, x6, 712, x7)

inst_112:
// rs1_val == -268435457, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0x3ff
TEST_IMM_OP( addiw, x11, x10, -0xffffc02, -0x10000001, 0x3ff, x6, 720, x7)

inst_113:
// rs1_val == -1073741825, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x40
TEST_IMM_OP( addiw, x11, x10, -0x3fffffc1, -0x40000001, 0x40, x6, 728, x7)

inst_114:
// rs1_val == -4294967297, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x100000001;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x2e, -0x100000001, -0x2d, x6, 736, x7)

inst_115:
// rs1_val == -8589934593, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x200000001;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x4, -0x200000001, 0x5, x6, 744, x7)

inst_116:
// rs1_val == -17179869185, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x400000001;  immval:-0x7
TEST_IMM_OP( addiw, x11, x10, -0x8, -0x400000001, -0x7, x6, 752, x7)

inst_117:
// rs1_val == -34359738369, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x800000001;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x555, -0x800000001, 0x556, x6, 760, x7)

inst_118:
// rs1_val == -68719476737, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x1000000001;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, -0x1, -0x1000000001, 0x0, x6, 768, x7)

inst_119:
// rs1_val == -137438953473, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x2000000001;  immval:0x10
TEST_IMM_OP( addiw, x11, x10, 0xf, -0x2000000001, 0x10, x6, 776, x7)

inst_120:
// rs1_val == -274877906945, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x5, -0x4000000001, 0x6, x6, 784, x7)

inst_121:
// rs1_val == -549755813889, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x2, -0x8000000001, 0x3, x6, 792, x7)

inst_122:
// rs1_val == -1099511627777, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:0x200
TEST_IMM_OP( addiw, x11, x10, 0x1ff, -0x10000000001, 0x200, x6, 800, x7)

inst_123:
// rs1_val == -2199023255553, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x20000000001;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x666, -0x20000000001, 0x667, x6, 808, x7)

inst_124:
// rs1_val == -4398046511105, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x40000000001;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x3, -0x40000000001, 0x4, x6, 816, x7)

inst_125:
// rs1_val == -17592186044417, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:-0x2
TEST_IMM_OP( addiw, x11, x10, -0x3, -0x100000000001, -0x2, x6, 824, x7)

inst_126:
// rs1_val == -35184372088833, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:0x3ff
TEST_IMM_OP( addiw, x11, x10, 0x3fe, -0x200000000001, 0x3ff, x6, 832, x7)

inst_127:
// rs1_val == -70368744177665, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x400000000001;  immval:0x80
TEST_IMM_OP( addiw, x11, x10, 0x7f, -0x400000000001, 0x80, x6, 840, x7)

inst_128:
// rs1_val == -140737488355329, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:-0x41
TEST_IMM_OP( addiw, x11, x10, -0x42, -0x800000000001, -0x41, x6, 848, x7)

inst_129:
// rs1_val == -281474976710657, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x1000000000001;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, -0x1, -0x1000000000001, 0x0, x6, 856, x7)

inst_130:
// rs1_val == -1125899906842625, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x2, -0x4000000000001, 0x3, x6, 864, x7)

inst_131:
// rs1_val == -2251799813685249, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x8000000000001;  immval:-0x800
TEST_IMM_OP( addiw, x11, x10, -0x801, -0x8000000000001, -0x800, x6, 872, x7)

inst_132:
// rs1_val == -4503599627370497, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x2d, -0x10000000000001, -0x2c, x6, 880, x7)

inst_133:
// rs1_val == -9007199254740993, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x20000000000001;  immval:-0x11
TEST_IMM_OP( addiw, x11, x10, -0x12, -0x20000000000001, -0x11, x6, 888, x7)

inst_134:
// rs1_val == -18014398509481985, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x40000000000001;  immval:0x20
TEST_IMM_OP( addiw, x11, x10, 0x1f, -0x40000000000001, 0x20, x6, 896, x7)

inst_135:
// rs1_val == -72057594037927937, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:0x400
TEST_IMM_OP( addiw, x11, x10, 0x3ff, -0x100000000000001, 0x400, x6, 904, x7)

inst_136:
// rs1_val == -144115188075855873, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x666, -0x200000000000001, 0x667, x6, 912, x7)

inst_137:
// rs1_val == -576460752303423489, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:-0x2
TEST_IMM_OP( addiw, x11, x10, -0x3, -0x800000000000001, -0x2, x6, 920, x7)

inst_138:
// rs1_val == -1152921504606846977, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:-0x11
TEST_IMM_OP( addiw, x11, x10, -0x12, -0x1000000000000001, -0x11, x6, 928, x7)

inst_139:
// rs1_val == -2305843009213693953, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x2e, -0x2000000000000001, -0x2d, x6, 936, x7)

inst_140:
// rs1_val == -4611686018427387905, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, -0x1, -0x4000000000000001, 0x0, x6, 944, x7)

inst_141:
// rs1_val == 6148914691236517205, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x81
TEST_IMM_OP( addiw, x11, x10, 0x555554d4, 0x5555555555555555, -0x81, x6, 952, x7)

inst_142:
// rs1_val==3 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x6, 0x3, 0x3, x6, 960, x7)

inst_143:
// rs1_val==3 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x558, 0x3, 0x555, x6, 968, x7)

inst_144:
// rs1_val==3 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x553, 0x3, -0x556, x6, 976, x7)

inst_145:
// rs1_val==3 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x8, 0x3, 0x5, x6, 984, x7)

inst_146:
// rs1_val==3 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x336, 0x3, 0x333, x6, 992, x7)

inst_147:
// rs1_val==3 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x669, 0x3, 0x666, x6, 1000, x7)

inst_148:
// rs1_val==3 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x2a, 0x3, -0x2d, x6, 1008, x7)

inst_149:
// rs1_val==3 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x30, 0x3, 0x2d, x6, 1016, x7)

inst_150:
// rs1_val==3 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x5, 0x3, 0x2, x6, 1024, x7)

inst_151:
// rs1_val==3 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x557, 0x3, 0x554, x6, 1032, x7)

inst_152:
// rs1_val==3 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x3, 0x3, 0x0, x6, 1040, x7)

inst_153:
// rs1_val==3 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x7, 0x3, 0x4, x6, 1048, x7)

inst_154:
// rs1_val==3 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x335, 0x3, 0x332, x6, 1056, x7)

inst_155:
// rs1_val==3 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x668, 0x3, 0x665, x6, 1064, x7)

inst_156:
// rs1_val==3 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x2f, 0x3, 0x2c, x6, 1072, x7)

inst_157:
// rs1_val==3 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x559, 0x3, 0x556, x6, 1080, x7)

inst_158:
// rs1_val==3 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x552, 0x3, -0x555, x6, 1088, x7)

inst_159:
// rs1_val==3 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x9, 0x3, 0x6, x6, 1096, x7)

inst_160:
// rs1_val==3 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x337, 0x3, 0x334, x6, 1104, x7)

inst_161:
// rs1_val==3 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x66a, 0x3, 0x667, x6, 1112, x7)

inst_162:
// rs1_val==3 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x29, 0x3, -0x2c, x6, 1120, x7)

inst_163:
// rs1_val==3 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x31, 0x3, 0x2e, x6, 1128, x7)

inst_164:
// rs1_val==6148914691236517205 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x55555558, 0x5555555555555555, 0x3, x6, 1136, x7)

inst_165:
// rs1_val==6148914691236517205 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x55555aaa, 0x5555555555555555, 0x555, x6, 1144, x7)

inst_166:
// rs1_val==6148914691236517205 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x55554fff, 0x5555555555555555, -0x556, x6, 1152, x7)

inst_167:
// rs1_val==6148914691236517205 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x5555555a, 0x5555555555555555, 0x5, x6, 1160, x7)

inst_168:
// rs1_val==6148914691236517205 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x55555888, 0x5555555555555555, 0x333, x6, 1168, x7)

inst_169:
// rs1_val==6148914691236517205 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x55555bbb, 0x5555555555555555, 0x666, x6, 1176, x7)

inst_170:
// rs1_val==6148914691236517205 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x55555528, 0x5555555555555555, -0x2d, x6, 1184, x7)

inst_171:
// rs1_val==6148914691236517205 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x55555582, 0x5555555555555555, 0x2d, x6, 1192, x7)

inst_172:
// rs1_val==6148914691236517205 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x55555557, 0x5555555555555555, 0x2, x6, 1200, x7)

inst_173:
// rs1_val==6148914691236517205 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x55555aa9, 0x5555555555555555, 0x554, x6, 1208, x7)

inst_174:
// rs1_val==6148914691236517205 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x55555555, 0x5555555555555555, 0x0, x6, 1216, x7)

inst_175:
// rs1_val==6148914691236517205 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x55555559, 0x5555555555555555, 0x4, x6, 1224, x7)

inst_176:
// rs1_val==6148914691236517205 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x55555887, 0x5555555555555555, 0x332, x6, 1232, x7)

inst_177:
// rs1_val==6148914691236517205 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x55555bba, 0x5555555555555555, 0x665, x6, 1240, x7)

inst_178:
// rs1_val==6148914691236517205 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x55555581, 0x5555555555555555, 0x2c, x6, 1248, x7)

inst_179:
// rs1_val==6148914691236517205 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x55555aab, 0x5555555555555555, 0x556, x6, 1256, x7)

inst_180:
// rs1_val==6148914691236517205 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x55555000, 0x5555555555555555, -0x555, x6, 1264, x7)

inst_181:
// rs1_val==6148914691236517205 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x5555555b, 0x5555555555555555, 0x6, x6, 1272, x7)

inst_182:
// rs1_val==6148914691236517205 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x55555889, 0x5555555555555555, 0x334, x6, 1280, x7)

inst_183:
// rs1_val==6148914691236517205 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x55555bbc, 0x5555555555555555, 0x667, x6, 1288, x7)

inst_184:
// rs1_val==6148914691236517205 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x55555529, 0x5555555555555555, -0x2c, x6, 1296, x7)

inst_185:
// rs1_val==6148914691236517205 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x55555583, 0x5555555555555555, 0x2e, x6, 1304, x7)

inst_186:
// rs1_val==-6148914691236517206 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, -0x55555553, -0x5555555555555556, 0x3, x6, 1312, x7)

inst_187:
// rs1_val==-6148914691236517206 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x55555aac, -0x5555555555555556, -0x556, x6, 1320, x7)

inst_188:
// rs1_val==-6148914691236517206 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, -0x55555551, -0x5555555555555556, 0x5, x6, 1328, x7)

inst_189:
// rs1_val==-6148914691236517206 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, -0x55555223, -0x5555555555555556, 0x333, x6, 1336, x7)

inst_190:
// rs1_val==-6148914691236517206 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, -0x55554ef0, -0x5555555555555556, 0x666, x6, 1344, x7)

inst_191:
// rs1_val==-6148914691236517206 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x55555583, -0x5555555555555556, -0x2d, x6, 1352, x7)

inst_192:
// rs1_val==-6148914691236517206 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, -0x55555529, -0x5555555555555556, 0x2d, x6, 1360, x7)

inst_193:
// rs1_val==-6148914691236517206 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, -0x55555554, -0x5555555555555556, 0x2, x6, 1368, x7)

inst_194:
// rs1_val==-6148914691236517206 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, -0x55555002, -0x5555555555555556, 0x554, x6, 1376, x7)

inst_195:
// rs1_val==-6148914691236517206 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, -0x55555556, -0x5555555555555556, 0x0, x6, 1384, x7)

inst_196:
// rs1_val==-6148914691236517206 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, -0x55555552, -0x5555555555555556, 0x4, x6, 1392, x7)

inst_197:
// rs1_val==-6148914691236517206 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, -0x55555224, -0x5555555555555556, 0x332, x6, 1400, x7)

inst_198:
// rs1_val==-6148914691236517206 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, -0x55554ef1, -0x5555555555555556, 0x665, x6, 1408, x7)

inst_199:
// rs1_val==-6148914691236517206 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, -0x5555552a, -0x5555555555555556, 0x2c, x6, 1416, x7)

inst_200:
// rs1_val==-6148914691236517206 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, -0x55555000, -0x5555555555555556, 0x556, x6, 1424, x7)

inst_201:
// rs1_val==-6148914691236517206 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x55555aab, -0x5555555555555556, -0x555, x6, 1432, x7)

inst_202:
// rs1_val==-6148914691236517206 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, -0x55555550, -0x5555555555555556, 0x6, x6, 1440, x7)

inst_203:
// rs1_val==-6148914691236517206 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, -0x55555222, -0x5555555555555556, 0x334, x6, 1448, x7)

inst_204:
// rs1_val==-6148914691236517206 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, -0x55554eef, -0x5555555555555556, 0x667, x6, 1456, x7)

inst_205:
// rs1_val==-6148914691236517206 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x55555582, -0x5555555555555556, -0x2c, x6, 1464, x7)

inst_206:
// rs1_val==-6148914691236517206 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, -0x55555528, -0x5555555555555556, 0x2e, x6, 1472, x7)

inst_207:
// rs1_val==5 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x8, 0x5, 0x3, x6, 1480, x7)

inst_208:
// rs1_val==5 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x55a, 0x5, 0x555, x6, 1488, x7)

inst_209:
// rs1_val==5 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x551, 0x5, -0x556, x6, 1496, x7)

inst_210:
// rs1_val==5 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0xa, 0x5, 0x5, x6, 1504, x7)

inst_211:
// rs1_val==5 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x338, 0x5, 0x333, x6, 1512, x7)

inst_212:
// rs1_val==5 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x66b, 0x5, 0x666, x6, 1520, x7)

inst_213:
// rs1_val==5 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x28, 0x5, -0x2d, x6, 1528, x7)

inst_214:
// rs1_val==5 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x32, 0x5, 0x2d, x6, 1536, x7)

inst_215:
// rs1_val==5 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x7, 0x5, 0x2, x6, 1544, x7)

inst_216:
// rs1_val==5 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x559, 0x5, 0x554, x6, 1552, x7)

inst_217:
// rs1_val==5 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x5, 0x5, 0x0, x6, 1560, x7)

inst_218:
// rs1_val==5 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x9, 0x5, 0x4, x6, 1568, x7)

inst_219:
// rs1_val==5 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x337, 0x5, 0x332, x6, 1576, x7)

inst_220:
// rs1_val==5 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x66a, 0x5, 0x665, x6, 1584, x7)

inst_221:
// rs1_val==5 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x31, 0x5, 0x2c, x6, 1592, x7)

inst_222:
// rs1_val==5 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x55b, 0x5, 0x556, x6, 1600, x7)

inst_223:
// rs1_val==5 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x550, 0x5, -0x555, x6, 1608, x7)

inst_224:
// rs1_val==5 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0xb, 0x5, 0x6, x6, 1616, x7)

inst_225:
// rs1_val==5 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x339, 0x5, 0x334, x6, 1624, x7)

inst_226:
// rs1_val==5 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x66c, 0x5, 0x667, x6, 1632, x7)

inst_227:
// rs1_val==5 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x27, 0x5, -0x2c, x6, 1640, x7)

inst_228:
// rs1_val==5 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x33, 0x5, 0x2e, x6, 1648, x7)

inst_229:
// rs1_val==3689348814741910323 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x33333336, 0x3333333333333333, 0x3, x6, 1656, x7)

inst_230:
// rs1_val==3689348814741910323 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x33333888, 0x3333333333333333, 0x555, x6, 1664, x7)

inst_231:
// rs1_val==3689348814741910323 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x33332ddd, 0x3333333333333333, -0x556, x6, 1672, x7)

inst_232:
// rs1_val==3689348814741910323 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x33333338, 0x3333333333333333, 0x5, x6, 1680, x7)

inst_233:
// rs1_val==3689348814741910323 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x33333666, 0x3333333333333333, 0x333, x6, 1688, x7)

inst_234:
// rs1_val==3689348814741910323 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x33333999, 0x3333333333333333, 0x666, x6, 1696, x7)

inst_235:
// rs1_val==3689348814741910323 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x33333306, 0x3333333333333333, -0x2d, x6, 1704, x7)

inst_236:
// rs1_val==3689348814741910323 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x33333360, 0x3333333333333333, 0x2d, x6, 1712, x7)

inst_237:
// rs1_val==3689348814741910323 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x33333335, 0x3333333333333333, 0x2, x6, 1720, x7)

inst_238:
// rs1_val==3689348814741910323 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x33333887, 0x3333333333333333, 0x554, x6, 1728, x7)

inst_239:
// rs1_val==3689348814741910323 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x33333333, 0x3333333333333333, 0x0, x6, 1736, x7)

inst_240:
// rs1_val==3689348814741910323 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x33333337, 0x3333333333333333, 0x4, x6, 1744, x7)

inst_241:
// rs1_val==3689348814741910323 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x33333665, 0x3333333333333333, 0x332, x6, 1752, x7)

inst_242:
// rs1_val==3689348814741910323 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x33333998, 0x3333333333333333, 0x665, x6, 1760, x7)

inst_243:
// rs1_val==3689348814741910323 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x3333335f, 0x3333333333333333, 0x2c, x6, 1768, x7)

inst_244:
// rs1_val==3689348814741910323 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x33333889, 0x3333333333333333, 0x556, x6, 1776, x7)

inst_245:
// rs1_val==3689348814741910323 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x33332dde, 0x3333333333333333, -0x555, x6, 1784, x7)

inst_246:
// rs1_val==3689348814741910323 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x33333339, 0x3333333333333333, 0x6, x6, 1792, x7)

inst_247:
// rs1_val==3689348814741910323 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x33333667, 0x3333333333333333, 0x334, x6, 1800, x7)

inst_248:
// rs1_val==3689348814741910323 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x3333399a, 0x3333333333333333, 0x667, x6, 1808, x7)

inst_249:
// rs1_val==3689348814741910323 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x33333307, 0x3333333333333333, -0x2c, x6, 1816, x7)

inst_250:
// rs1_val==3689348814741910323 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x33333361, 0x3333333333333333, 0x2e, x6, 1824, x7)

inst_251:
// rs1_val==7378697629483820646 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x66666669, 0x6666666666666666, 0x3, x6, 1832, x7)

inst_252:
// rs1_val==7378697629483820646 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x66666bbb, 0x6666666666666666, 0x555, x6, 1840, x7)

inst_253:
// rs1_val==7378697629483820646 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x66666110, 0x6666666666666666, -0x556, x6, 1848, x7)

inst_254:
// rs1_val==7378697629483820646 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x6666666b, 0x6666666666666666, 0x5, x6, 1856, x7)

inst_255:
// rs1_val==7378697629483820646 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x66666999, 0x6666666666666666, 0x333, x6, 1864, x7)

inst_256:
// rs1_val==7378697629483820646 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x66666ccc, 0x6666666666666666, 0x666, x6, 1872, x7)

inst_257:
// rs1_val==7378697629483820646 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x66666639, 0x6666666666666666, -0x2d, x6, 1880, x7)

inst_258:
// rs1_val==7378697629483820646 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x66666693, 0x6666666666666666, 0x2d, x6, 1888, x7)

inst_259:
// rs1_val==7378697629483820646 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x66666668, 0x6666666666666666, 0x2, x6, 1896, x7)

inst_260:
// rs1_val==7378697629483820646 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x66666bba, 0x6666666666666666, 0x554, x6, 1904, x7)

inst_261:
// rs1_val==7378697629483820646 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x66666666, 0x6666666666666666, 0x0, x6, 1912, x7)

inst_262:
// rs1_val==7378697629483820646 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x6666666a, 0x6666666666666666, 0x4, x6, 1920, x7)

inst_263:
// rs1_val==7378697629483820646 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x66666998, 0x6666666666666666, 0x332, x6, 1928, x7)

inst_264:
// rs1_val==7378697629483820646 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x66666ccb, 0x6666666666666666, 0x665, x6, 1936, x7)

inst_265:
// rs1_val==7378697629483820646 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x66666692, 0x6666666666666666, 0x2c, x6, 1944, x7)

inst_266:
// rs1_val==7378697629483820646 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x66666bbc, 0x6666666666666666, 0x556, x6, 1952, x7)

inst_267:
// rs1_val==7378697629483820646 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x66666111, 0x6666666666666666, -0x555, x6, 1960, x7)

inst_268:
// rs1_val==7378697629483820646 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x6666666c, 0x6666666666666666, 0x6, x6, 1968, x7)

inst_269:
// rs1_val==7378697629483820646 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x6666699a, 0x6666666666666666, 0x334, x6, 1976, x7)

inst_270:
// rs1_val==7378697629483820646 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x66666ccd, 0x6666666666666666, 0x667, x6, 1984, x7)

inst_271:
// rs1_val==7378697629483820646 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x6666663a, 0x6666666666666666, -0x2c, x6, 1992, x7)

inst_272:
// rs1_val==7378697629483820646 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x66666694, 0x6666666666666666, 0x2e, x6, 2000, x7)

inst_273:
// rs1_val==-3037000499 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd0, -0xb504f333, 0x3, x6, 2008, x7)

inst_274:
// rs1_val==-3037000499 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x4afb1222, -0xb504f333, 0x555, x6, 2016, x7)

inst_275:
// rs1_val==-3037000499 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x4afb0777, -0xb504f333, -0x556, x6, 2024, x7)

inst_276:
// rs1_val==-3037000499 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd2, -0xb504f333, 0x5, x6, 2032, x7)

inst_277:
// rs1_val==-3037000499 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x4afb1000, -0xb504f333, 0x333, x6, 2040, x7)
RVTEST_SIGBASE( x6,signature_x6_1)

inst_278:
// rs1_val==-3037000499 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x4afb1333, -0xb504f333, 0x666, x6, 0, x7)

inst_279:
// rs1_val==-3037000499 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x4afb0ca0, -0xb504f333, -0x2d, x6, 8, x7)

inst_280:
// rs1_val==-3037000499 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cfa, -0xb504f333, 0x2d, x6, 16, x7)

inst_281:
// rs1_val==-3037000499 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x4afb0ccf, -0xb504f333, 0x2, x6, 24, x7)

inst_282:
// rs1_val==-3037000499 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x4afb1221, -0xb504f333, 0x554, x6, 32, x7)

inst_283:
// rs1_val==-3037000499 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x4afb0ccd, -0xb504f333, 0x0, x6, 40, x7)

inst_284:
// rs1_val==-3037000499 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd1, -0xb504f333, 0x4, x6, 48, x7)

inst_285:
// rs1_val==-3037000499 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x4afb0fff, -0xb504f333, 0x332, x6, 56, x7)

inst_286:
// rs1_val==-3037000499 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x4afb1332, -0xb504f333, 0x665, x6, 64, x7)

inst_287:
// rs1_val==-3037000499 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cf9, -0xb504f333, 0x2c, x6, 72, x7)

inst_288:
// rs1_val==-3037000499 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x4afb1223, -0xb504f333, 0x556, x6, 80, x7)

inst_289:
// rs1_val==-3037000499 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x4afb0778, -0xb504f333, -0x555, x6, 88, x7)

inst_290:
// rs1_val==-3037000499 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd3, -0xb504f333, 0x6, x6, 96, x7)

inst_291:
// rs1_val==-3037000499 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x4afb1001, -0xb504f333, 0x334, x6, 104, x7)

inst_292:
// rs1_val==-3037000499 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x4afb1334, -0xb504f333, 0x667, x6, 112, x7)

inst_293:
// rs1_val==-3037000499 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x4afb0ca1, -0xb504f333, -0x2c, x6, 120, x7)

inst_294:
// rs1_val==-3037000499 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cfb, -0xb504f333, 0x2e, x6, 128, x7)

inst_295:
// rs1_val==3037000499 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cca, 0xb504f333, 0x3, x6, 136, x7)

inst_296:
// rs1_val==3037000499 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, -0x4afb0778, 0xb504f333, 0x555, x6, 144, x7)

inst_297:
// rs1_val==3037000499 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x4afb1223, 0xb504f333, -0x556, x6, 152, x7)

inst_298:
// rs1_val==3037000499 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc8, 0xb504f333, 0x5, x6, 160, x7)

inst_299:
// rs1_val==3037000499 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, -0x4afb099a, 0xb504f333, 0x333, x6, 168, x7)

inst_300:
// rs1_val==3037000499 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, -0x4afb0667, 0xb504f333, 0x666, x6, 176, x7)

inst_301:
// rs1_val==3037000499 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cfa, 0xb504f333, -0x2d, x6, 184, x7)

inst_302:
// rs1_val==3037000499 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ca0, 0xb504f333, 0x2d, x6, 192, x7)

inst_303:
// rs1_val==3037000499 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ccb, 0xb504f333, 0x2, x6, 200, x7)

inst_304:
// rs1_val==3037000499 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, -0x4afb0779, 0xb504f333, 0x554, x6, 208, x7)

inst_305:
// rs1_val==3037000499 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ccd, 0xb504f333, 0x0, x6, 216, x7)

inst_306:
// rs1_val==3037000499 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc9, 0xb504f333, 0x4, x6, 224, x7)

inst_307:
// rs1_val==3037000499 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, -0x4afb099b, 0xb504f333, 0x332, x6, 232, x7)

inst_308:
// rs1_val==3037000499 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, -0x4afb0668, 0xb504f333, 0x665, x6, 240, x7)

inst_309:
// rs1_val==3037000499 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ca1, 0xb504f333, 0x2c, x6, 248, x7)

inst_310:
// rs1_val==3037000499 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, -0x4afb0777, 0xb504f333, 0x556, x6, 256, x7)

inst_311:
// rs1_val==3037000499 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x4afb1222, 0xb504f333, -0x555, x6, 264, x7)

inst_312:
// rs1_val==3037000499 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc7, 0xb504f333, 0x6, x6, 272, x7)

inst_313:
// rs1_val==3037000499 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, -0x4afb0999, 0xb504f333, 0x334, x6, 280, x7)

inst_314:
// rs1_val==3037000499 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, -0x4afb0666, 0xb504f333, 0x667, x6, 288, x7)

inst_315:
// rs1_val==3037000499 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cf9, 0xb504f333, -0x2c, x6, 296, x7)

inst_316:
// rs1_val==3037000499 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, -0x4afb0c9f, 0xb504f333, 0x2e, x6, 304, x7)

inst_317:
// rs1_val==2 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x5, 0x2, 0x3, x6, 312, x7)

inst_318:
// rs1_val==2 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x557, 0x2, 0x555, x6, 320, x7)

inst_319:
// rs1_val==2 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x554, 0x2, -0x556, x6, 328, x7)

inst_320:
// rs1_val==2 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x7, 0x2, 0x5, x6, 336, x7)

inst_321:
// rs1_val==2 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x668, 0x2, 0x666, x6, 344, x7)

inst_322:
// rs1_val==2 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x2b, 0x2, -0x2d, x6, 352, x7)

inst_323:
// rs1_val==2 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x2f, 0x2, 0x2d, x6, 360, x7)

inst_324:
// rs1_val==2 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x4, 0x2, 0x2, x6, 368, x7)

inst_325:
// rs1_val==2 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x556, 0x2, 0x554, x6, 376, x7)

inst_326:
// rs1_val==2 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x2, 0x2, 0x0, x6, 384, x7)

inst_327:
// rs1_val==2 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x6, 0x2, 0x4, x6, 392, x7)

inst_328:
// rs1_val==2 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x334, 0x2, 0x332, x6, 400, x7)

inst_329:
// rs1_val==2 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x667, 0x2, 0x665, x6, 408, x7)

inst_330:
// rs1_val==2 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x2e, 0x2, 0x2c, x6, 416, x7)

inst_331:
// rs1_val==2 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x558, 0x2, 0x556, x6, 424, x7)

inst_332:
// rs1_val==2 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x553, 0x2, -0x555, x6, 432, x7)

inst_333:
// rs1_val==2 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x8, 0x2, 0x6, x6, 440, x7)

inst_334:
// rs1_val==2 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x336, 0x2, 0x334, x6, 448, x7)

inst_335:
// rs1_val==2 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x669, 0x2, 0x667, x6, 456, x7)

inst_336:
// rs1_val==2 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x2a, 0x2, -0x2c, x6, 464, x7)

inst_337:
// rs1_val==2 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x30, 0x2, 0x2e, x6, 472, x7)

inst_338:
// rs1_val==6148914691236517204 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x55555557, 0x5555555555555554, 0x3, x6, 480, x7)

inst_339:
// rs1_val==6148914691236517204 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x55555aa9, 0x5555555555555554, 0x555, x6, 488, x7)

inst_340:
// rs1_val==6148914691236517204 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x55554ffe, 0x5555555555555554, -0x556, x6, 496, x7)

inst_341:
// rs1_val==6148914691236517204 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x55555559, 0x5555555555555554, 0x5, x6, 504, x7)

inst_342:
// rs1_val==6148914691236517204 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x55555887, 0x5555555555555554, 0x333, x6, 512, x7)

inst_343:
// rs1_val==6148914691236517204 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x55555bba, 0x5555555555555554, 0x666, x6, 520, x7)

inst_344:
// rs1_val==6148914691236517204 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x55555527, 0x5555555555555554, -0x2d, x6, 528, x7)

inst_345:
// rs1_val==6148914691236517204 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x55555581, 0x5555555555555554, 0x2d, x6, 536, x7)

inst_346:
// rs1_val==6148914691236517204 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x55555556, 0x5555555555555554, 0x2, x6, 544, x7)

inst_347:
// rs1_val==6148914691236517204 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x55555aa8, 0x5555555555555554, 0x554, x6, 552, x7)

inst_348:
// rs1_val==6148914691236517204 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x55555554, 0x5555555555555554, 0x0, x6, 560, x7)

inst_349:
// rs1_val==6148914691236517204 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x55555558, 0x5555555555555554, 0x4, x6, 568, x7)

inst_350:
// rs1_val==6148914691236517204 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x55555886, 0x5555555555555554, 0x332, x6, 576, x7)

inst_351:
// rs1_val==6148914691236517204 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x55555bb9, 0x5555555555555554, 0x665, x6, 584, x7)

inst_352:
// rs1_val==6148914691236517204 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x55555580, 0x5555555555555554, 0x2c, x6, 592, x7)

inst_353:
// rs1_val==6148914691236517204 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x55555aaa, 0x5555555555555554, 0x556, x6, 600, x7)

inst_354:
// rs1_val==6148914691236517204 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x55554fff, 0x5555555555555554, -0x555, x6, 608, x7)

inst_355:
// rs1_val==6148914691236517204 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x5555555a, 0x5555555555555554, 0x6, x6, 616, x7)

inst_356:
// rs1_val==6148914691236517204 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x55555888, 0x5555555555555554, 0x334, x6, 624, x7)

inst_357:
// rs1_val==6148914691236517204 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x55555bbb, 0x5555555555555554, 0x667, x6, 632, x7)

inst_358:
// rs1_val==6148914691236517204 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x55555528, 0x5555555555555554, -0x2c, x6, 640, x7)

inst_359:
// rs1_val==6148914691236517204 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x55555582, 0x5555555555555554, 0x2e, x6, 648, x7)

inst_360:
// rs1_val==0 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x3, 0x0, 0x3, x6, 656, x7)

inst_361:
// rs1_val==0 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x555, 0x0, 0x555, x6, 664, x7)

inst_362:
// rs1_val==0 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x5, 0x0, 0x5, x6, 672, x7)

inst_363:
// rs1_val==0 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x333, 0x0, 0x333, x6, 680, x7)

inst_364:
// rs1_val==0 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x666, 0x0, 0x666, x6, 688, x7)

inst_365:
// rs1_val==0 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x2d, 0x0, -0x2d, x6, 696, x7)

inst_366:
// rs1_val==0 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x2d, 0x0, 0x2d, x6, 704, x7)

inst_367:
// rs1_val==0 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x2, 0x0, 0x2, x6, 712, x7)

inst_368:
// rs1_val==6148914691236517206 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x55555582, 0x5555555555555556, 0x2c, x6, 720, x7)

inst_369:
// rs1_val==6148914691236517206 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x55555aac, 0x5555555555555556, 0x556, x6, 728, x7)

inst_370:
// rs1_val==6148914691236517206 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x55555001, 0x5555555555555556, -0x555, x6, 736, x7)

inst_371:
// rs1_val==6148914691236517206 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x5555555c, 0x5555555555555556, 0x6, x6, 744, x7)

inst_372:
// rs1_val==6148914691236517206 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x5555588a, 0x5555555555555556, 0x334, x6, 752, x7)

inst_373:
// rs1_val==6148914691236517206 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x55555bbd, 0x5555555555555556, 0x667, x6, 760, x7)

inst_374:
// rs1_val==6148914691236517206 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x5555552a, 0x5555555555555556, -0x2c, x6, 768, x7)

inst_375:
// rs1_val==6148914691236517206 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x55555584, 0x5555555555555556, 0x2e, x6, 776, x7)

inst_376:
// rs1_val==-6148914691236517205 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, -0x55555552, -0x5555555555555555, 0x3, x6, 784, x7)

inst_377:
// rs1_val==-6148914691236517205 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, -0x55555000, -0x5555555555555555, 0x555, x6, 792, x7)

inst_378:
// rs1_val==-6148914691236517205 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x55555aab, -0x5555555555555555, -0x556, x6, 800, x7)

inst_379:
// rs1_val==-6148914691236517205 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, -0x55555550, -0x5555555555555555, 0x5, x6, 808, x7)

inst_380:
// rs1_val==-6148914691236517205 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, -0x55555222, -0x5555555555555555, 0x333, x6, 816, x7)

inst_381:
// rs1_val==-6148914691236517205 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, -0x55554eef, -0x5555555555555555, 0x666, x6, 824, x7)

inst_382:
// rs1_val==-6148914691236517205 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x55555582, -0x5555555555555555, -0x2d, x6, 832, x7)

inst_383:
// rs1_val==-6148914691236517205 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, -0x55555528, -0x5555555555555555, 0x2d, x6, 840, x7)

inst_384:
// rs1_val==-6148914691236517205 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, -0x55555553, -0x5555555555555555, 0x2, x6, 848, x7)

inst_385:
// rs1_val==-6148914691236517205 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, -0x55555001, -0x5555555555555555, 0x554, x6, 856, x7)

inst_386:
// rs1_val==-6148914691236517205 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, -0x55555555, -0x5555555555555555, 0x0, x6, 864, x7)

inst_387:
// rs1_val==-6148914691236517205 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, -0x55555551, -0x5555555555555555, 0x4, x6, 872, x7)

inst_388:
// rs1_val==-6148914691236517205 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, -0x55555223, -0x5555555555555555, 0x332, x6, 880, x7)

inst_389:
// rs1_val==-6148914691236517205 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, -0x55554ef0, -0x5555555555555555, 0x665, x6, 888, x7)

inst_390:
// rs1_val==-6148914691236517205 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, -0x55555529, -0x5555555555555555, 0x2c, x6, 896, x7)

inst_391:
// rs1_val==-6148914691236517205 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, -0x55554fff, -0x5555555555555555, 0x556, x6, 904, x7)

inst_392:
// rs1_val==-6148914691236517205 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x55555aaa, -0x5555555555555555, -0x555, x6, 912, x7)

inst_393:
// rs1_val==-6148914691236517205 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, -0x5555554f, -0x5555555555555555, 0x6, x6, 920, x7)

inst_394:
// rs1_val==-6148914691236517205 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, -0x55555221, -0x5555555555555555, 0x334, x6, 928, x7)

inst_395:
// rs1_val==-6148914691236517205 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, -0x55554eee, -0x5555555555555555, 0x667, x6, 936, x7)

inst_396:
// rs1_val==-6148914691236517205 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x55555581, -0x5555555555555555, -0x2c, x6, 944, x7)

inst_397:
// rs1_val==-6148914691236517205 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, -0x55555527, -0x5555555555555555, 0x2e, x6, 952, x7)

inst_398:
// rs1_val==6 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x9, 0x6, 0x3, x6, 960, x7)

inst_399:
// rs1_val==6 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x55b, 0x6, 0x555, x6, 968, x7)

inst_400:
// rs1_val==6 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x550, 0x6, -0x556, x6, 976, x7)

inst_401:
// rs1_val==6 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0xb, 0x6, 0x5, x6, 984, x7)

inst_402:
// rs1_val==6 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x339, 0x6, 0x333, x6, 992, x7)

inst_403:
// rs1_val==6 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x66c, 0x6, 0x666, x6, 1000, x7)

inst_404:
// rs1_val==6 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x27, 0x6, -0x2d, x6, 1008, x7)

inst_405:
// rs1_val==6 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x33, 0x6, 0x2d, x6, 1016, x7)

inst_406:
// rs1_val==6 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x8, 0x6, 0x2, x6, 1024, x7)

inst_407:
// rs1_val==6 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x55a, 0x6, 0x554, x6, 1032, x7)

inst_408:
// rs1_val==6 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x6, 0x6, 0x0, x6, 1040, x7)

inst_409:
// rs1_val==6 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0xa, 0x6, 0x4, x6, 1048, x7)

inst_410:
// rs1_val==6 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x338, 0x6, 0x332, x6, 1056, x7)

inst_411:
// rs1_val==6 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x66b, 0x6, 0x665, x6, 1064, x7)

inst_412:
// rs1_val==6 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x32, 0x6, 0x2c, x6, 1072, x7)

inst_413:
// rs1_val==6 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x55c, 0x6, 0x556, x6, 1080, x7)

inst_414:
// rs1_val==6 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x54f, 0x6, -0x555, x6, 1088, x7)

inst_415:
// rs1_val==6 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0xc, 0x6, 0x6, x6, 1096, x7)

inst_416:
// rs1_val==6 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x33a, 0x6, 0x334, x6, 1104, x7)

inst_417:
// rs1_val==6 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x66d, 0x6, 0x667, x6, 1112, x7)

inst_418:
// rs1_val==6 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x26, 0x6, -0x2c, x6, 1120, x7)

inst_419:
// rs1_val==6 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x34, 0x6, 0x2e, x6, 1128, x7)

inst_420:
// rs1_val==3689348814741910324 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x33333337, 0x3333333333333334, 0x3, x6, 1136, x7)

inst_421:
// rs1_val==3689348814741910324 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x33333889, 0x3333333333333334, 0x555, x6, 1144, x7)

inst_422:
// rs1_val==3689348814741910324 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x33332dde, 0x3333333333333334, -0x556, x6, 1152, x7)

inst_423:
// rs1_val==3689348814741910324 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x33333339, 0x3333333333333334, 0x5, x6, 1160, x7)

inst_424:
// rs1_val==3689348814741910324 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x33333667, 0x3333333333333334, 0x333, x6, 1168, x7)

inst_425:
// rs1_val==3689348814741910324 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x3333399a, 0x3333333333333334, 0x666, x6, 1176, x7)

inst_426:
// rs1_val==3689348814741910324 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x33333307, 0x3333333333333334, -0x2d, x6, 1184, x7)

inst_427:
// rs1_val==3689348814741910324 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x33333361, 0x3333333333333334, 0x2d, x6, 1192, x7)

inst_428:
// rs1_val==3689348814741910324 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x33333336, 0x3333333333333334, 0x2, x6, 1200, x7)

inst_429:
// rs1_val==3689348814741910324 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x33333888, 0x3333333333333334, 0x554, x6, 1208, x7)

inst_430:
// rs1_val==3689348814741910324 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x33333334, 0x3333333333333334, 0x0, x6, 1216, x7)

inst_431:
// rs1_val==3689348814741910324 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x33333338, 0x3333333333333334, 0x4, x6, 1224, x7)

inst_432:
// rs1_val==3689348814741910324 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x33333666, 0x3333333333333334, 0x332, x6, 1232, x7)

inst_433:
// rs1_val==3689348814741910324 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x33333999, 0x3333333333333334, 0x665, x6, 1240, x7)

inst_434:
// rs1_val==3689348814741910324 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x33333360, 0x3333333333333334, 0x2c, x6, 1248, x7)

inst_435:
// rs1_val==3689348814741910324 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x3333388a, 0x3333333333333334, 0x556, x6, 1256, x7)

inst_436:
// rs1_val==3689348814741910324 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x33332ddf, 0x3333333333333334, -0x555, x6, 1264, x7)

inst_437:
// rs1_val==3689348814741910324 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x3333333a, 0x3333333333333334, 0x6, x6, 1272, x7)

inst_438:
// rs1_val==3689348814741910324 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x33333668, 0x3333333333333334, 0x334, x6, 1280, x7)

inst_439:
// rs1_val==3689348814741910324 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x3333399b, 0x3333333333333334, 0x667, x6, 1288, x7)

inst_440:
// rs1_val==3689348814741910324 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x33333308, 0x3333333333333334, -0x2c, x6, 1296, x7)

inst_441:
// rs1_val==3689348814741910324 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x33333362, 0x3333333333333334, 0x2e, x6, 1304, x7)

inst_442:
// rs1_val==7378697629483820647 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x6666666a, 0x6666666666666667, 0x3, x6, 1312, x7)

inst_443:
// rs1_val==7378697629483820647 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x66666bbc, 0x6666666666666667, 0x555, x6, 1320, x7)

inst_444:
// rs1_val==7378697629483820647 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x66666111, 0x6666666666666667, -0x556, x6, 1328, x7)

inst_445:
// rs1_val==7378697629483820647 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x6666666c, 0x6666666666666667, 0x5, x6, 1336, x7)

inst_446:
// rs1_val==7378697629483820647 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x6666699a, 0x6666666666666667, 0x333, x6, 1344, x7)

inst_447:
// rs1_val==7378697629483820647 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x66666ccd, 0x6666666666666667, 0x666, x6, 1352, x7)

inst_448:
// rs1_val==7378697629483820647 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x6666663a, 0x6666666666666667, -0x2d, x6, 1360, x7)

inst_449:
// rs1_val==7378697629483820647 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x66666694, 0x6666666666666667, 0x2d, x6, 1368, x7)

inst_450:
// rs1_val==7378697629483820647 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x66666669, 0x6666666666666667, 0x2, x6, 1376, x7)

inst_451:
// rs1_val==7378697629483820647 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x66666bbb, 0x6666666666666667, 0x554, x6, 1384, x7)

inst_452:
// rs1_val==7378697629483820647 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x66666667, 0x6666666666666667, 0x0, x6, 1392, x7)

inst_453:
// rs1_val==7378697629483820647 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x6666666b, 0x6666666666666667, 0x4, x6, 1400, x7)

inst_454:
// rs1_val==7378697629483820647 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x66666999, 0x6666666666666667, 0x332, x6, 1408, x7)

inst_455:
// rs1_val==7378697629483820647 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x66666ccc, 0x6666666666666667, 0x665, x6, 1416, x7)

inst_456:
// rs1_val==7378697629483820647 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x66666693, 0x6666666666666667, 0x2c, x6, 1424, x7)

inst_457:
// rs1_val==7378697629483820647 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x66666bbd, 0x6666666666666667, 0x556, x6, 1432, x7)

inst_458:
// rs1_val==7378697629483820647 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x66666112, 0x6666666666666667, -0x555, x6, 1440, x7)

inst_459:
// rs1_val==7378697629483820647 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x6666666d, 0x6666666666666667, 0x6, x6, 1448, x7)

inst_460:
// rs1_val==7378697629483820647 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x6666699b, 0x6666666666666667, 0x334, x6, 1456, x7)

inst_461:
// rs1_val==7378697629483820647 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x66666cce, 0x6666666666666667, 0x667, x6, 1464, x7)

inst_462:
// rs1_val==7378697629483820647 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x6666663b, 0x6666666666666667, -0x2c, x6, 1472, x7)

inst_463:
// rs1_val==7378697629483820647 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x66666695, 0x6666666666666667, 0x2e, x6, 1480, x7)

inst_464:
// rs1_val==-3037000498 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd1, -0xb504f332, 0x3, x6, 1488, x7)

inst_465:
// rs1_val==-3037000498 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x4afb1223, -0xb504f332, 0x555, x6, 1496, x7)

inst_466:
// rs1_val==-3037000498 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x4afb0778, -0xb504f332, -0x556, x6, 1504, x7)

inst_467:
// rs1_val==-3037000498 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd3, -0xb504f332, 0x5, x6, 1512, x7)

inst_468:
// rs1_val==-3037000498 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x4afb1001, -0xb504f332, 0x333, x6, 1520, x7)

inst_469:
// rs1_val==-3037000498 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x4afb1334, -0xb504f332, 0x666, x6, 1528, x7)

inst_470:
// rs1_val==-3037000498 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x4afb0ca1, -0xb504f332, -0x2d, x6, 1536, x7)

inst_471:
// rs1_val==-3037000498 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cfb, -0xb504f332, 0x2d, x6, 1544, x7)

inst_472:
// rs1_val==-3037000498 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd0, -0xb504f332, 0x2, x6, 1552, x7)

inst_473:
// rs1_val==-3037000498 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x4afb1222, -0xb504f332, 0x554, x6, 1560, x7)

inst_474:
// rs1_val==-3037000498 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cce, -0xb504f332, 0x0, x6, 1568, x7)

inst_475:
// rs1_val==-3037000498 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd2, -0xb504f332, 0x4, x6, 1576, x7)

inst_476:
// rs1_val==-3037000498 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x4afb1000, -0xb504f332, 0x332, x6, 1584, x7)

inst_477:
// rs1_val==-3037000498 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x4afb1333, -0xb504f332, 0x665, x6, 1592, x7)

inst_478:
// rs1_val==-3037000498 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cfa, -0xb504f332, 0x2c, x6, 1600, x7)

inst_479:
// rs1_val==-3037000498 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x4afb1224, -0xb504f332, 0x556, x6, 1608, x7)

inst_480:
// rs1_val==-3037000498 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x4afb0779, -0xb504f332, -0x555, x6, 1616, x7)

inst_481:
// rs1_val==-3037000498 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cd4, -0xb504f332, 0x6, x6, 1624, x7)

inst_482:
// rs1_val==-3037000498 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x4afb1002, -0xb504f332, 0x334, x6, 1632, x7)

inst_483:
// rs1_val==-3037000498 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x4afb1335, -0xb504f332, 0x667, x6, 1640, x7)

inst_484:
// rs1_val==-3037000498 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x4afb0ca2, -0xb504f332, -0x2c, x6, 1648, x7)

inst_485:
// rs1_val==-3037000498 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x4afb0cfc, -0xb504f332, 0x2e, x6, 1656, x7)

inst_486:
// rs1_val==3037000500 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc9, 0xb504f334, 0x3, x6, 1664, x7)

inst_487:
// rs1_val==3037000500 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, -0x4afb0777, 0xb504f334, 0x555, x6, 1672, x7)

inst_488:
// rs1_val==3037000500 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x4afb1222, 0xb504f334, -0x556, x6, 1680, x7)

inst_489:
// rs1_val==3037000500 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc7, 0xb504f334, 0x5, x6, 1688, x7)

inst_490:
// rs1_val==3037000500 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, -0x4afb0999, 0xb504f334, 0x333, x6, 1696, x7)

inst_491:
// rs1_val==3037000500 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, -0x4afb0666, 0xb504f334, 0x666, x6, 1704, x7)

inst_492:
// rs1_val==3037000500 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cf9, 0xb504f334, -0x2d, x6, 1712, x7)

inst_493:
// rs1_val==3037000500 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, -0x4afb0c9f, 0xb504f334, 0x2d, x6, 1720, x7)

inst_494:
// rs1_val==3037000500 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cca, 0xb504f334, 0x2, x6, 1728, x7)

inst_495:
// rs1_val==3037000500 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, -0x4afb0778, 0xb504f334, 0x554, x6, 1736, x7)

inst_496:
// rs1_val==3037000500 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ccc, 0xb504f334, 0x0, x6, 1744, x7)

inst_497:
// rs1_val==3037000500 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc8, 0xb504f334, 0x4, x6, 1752, x7)

inst_498:
// rs1_val==3037000500 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, -0x4afb099a, 0xb504f334, 0x332, x6, 1760, x7)

inst_499:
// rs1_val==3037000500 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, -0x4afb0667, 0xb504f334, 0x665, x6, 1768, x7)

inst_500:
// rs1_val==3037000500 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ca0, 0xb504f334, 0x2c, x6, 1776, x7)

inst_501:
// rs1_val==3037000500 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, -0x4afb0776, 0xb504f334, 0x556, x6, 1784, x7)

inst_502:
// rs1_val==3037000500 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x4afb1221, 0xb504f334, -0x555, x6, 1792, x7)

inst_503:
// rs1_val==3037000500 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc6, 0xb504f334, 0x6, x6, 1800, x7)

inst_504:
// rs1_val==3037000500 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, -0x4afb0998, 0xb504f334, 0x334, x6, 1808, x7)

inst_505:
// rs1_val==3037000500 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, -0x4afb0665, 0xb504f334, 0x667, x6, 1816, x7)

inst_506:
// rs1_val==3037000500 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cf8, 0xb504f334, -0x2c, x6, 1824, x7)

inst_507:
// rs1_val==3037000500 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, -0x4afb0c9e, 0xb504f334, 0x2e, x6, 1832, x7)

inst_508:
// rs1_val==0 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x554, 0x0, 0x554, x6, 1840, x7)

inst_509:
// rs1_val==0 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x0, 0x0, 0x0, x6, 1848, x7)

inst_510:
// rs1_val==0 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x4, 0x0, 0x4, x6, 1856, x7)

inst_511:
// rs1_val==0 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x332, 0x0, 0x332, x6, 1864, x7)

inst_512:
// rs1_val==0 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x665, 0x0, 0x665, x6, 1872, x7)

inst_513:
// rs1_val==0 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x2c, 0x0, 0x2c, x6, 1880, x7)

inst_514:
// rs1_val==0 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x556, 0x0, 0x556, x6, 1888, x7)

inst_515:
// rs1_val==0 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x555, 0x0, -0x555, x6, 1896, x7)

inst_516:
// rs1_val==0 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x6, 0x0, 0x6, x6, 1904, x7)

inst_517:
// rs1_val==0 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x334, 0x0, 0x334, x6, 1912, x7)

inst_518:
// rs1_val==0 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x667, 0x0, 0x667, x6, 1920, x7)

inst_519:
// rs1_val==0 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x2c, 0x0, -0x2c, x6, 1928, x7)

inst_520:
// rs1_val==0 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x2e, 0x0, 0x2e, x6, 1936, x7)

inst_521:
// rs1_val==4 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x7, 0x4, 0x3, x6, 1944, x7)

inst_522:
// rs1_val==4 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x559, 0x4, 0x555, x6, 1952, x7)

inst_523:
// rs1_val==4 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x552, 0x4, -0x556, x6, 1960, x7)

inst_524:
// rs1_val==4 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x9, 0x4, 0x5, x6, 1968, x7)

inst_525:
// rs1_val==4 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x337, 0x4, 0x333, x6, 1976, x7)

inst_526:
// rs1_val==4 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x66a, 0x4, 0x666, x6, 1984, x7)

inst_527:
// rs1_val==4 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x29, 0x4, -0x2d, x6, 1992, x7)

inst_528:
// rs1_val==4 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x31, 0x4, 0x2d, x6, 2000, x7)

inst_529:
// rs1_val==4 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x6, 0x4, 0x2, x6, 2008, x7)

inst_530:
// rs1_val==4 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x558, 0x4, 0x554, x6, 2016, x7)

inst_531:
// rs1_val==4 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x4, 0x4, 0x0, x6, 2024, x7)

inst_532:
// rs1_val==4 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x8, 0x4, 0x4, x6, 2032, x7)

inst_533:
// rs1_val==4 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x336, 0x4, 0x332, x6, 2040, x7)
RVTEST_SIGBASE( x6,signature_x6_2)

inst_534:
// rs1_val==4 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x669, 0x4, 0x665, x6, 0, x7)

inst_535:
// rs1_val==4 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x30, 0x4, 0x2c, x6, 8, x7)

inst_536:
// rs1_val==4 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x55a, 0x4, 0x556, x6, 16, x7)

inst_537:
// rs1_val==4 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x551, 0x4, -0x555, x6, 24, x7)

inst_538:
// rs1_val==4 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0xa, 0x4, 0x6, x6, 32, x7)

inst_539:
// rs1_val==4 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x338, 0x4, 0x334, x6, 40, x7)

inst_540:
// rs1_val==4 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x66b, 0x4, 0x667, x6, 48, x7)

inst_541:
// rs1_val==4 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x28, 0x4, -0x2c, x6, 56, x7)

inst_542:
// rs1_val==4 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x32, 0x4, 0x2e, x6, 64, x7)

inst_543:
// rs1_val==3689348814741910322 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x33333335, 0x3333333333333332, 0x3, x6, 72, x7)

inst_544:
// rs1_val==3689348814741910322 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x33333887, 0x3333333333333332, 0x555, x6, 80, x7)

inst_545:
// rs1_val==3689348814741910322 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x33332ddc, 0x3333333333333332, -0x556, x6, 88, x7)

inst_546:
// rs1_val==3689348814741910322 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x33333337, 0x3333333333333332, 0x5, x6, 96, x7)

inst_547:
// rs1_val==3689348814741910322 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x33333665, 0x3333333333333332, 0x333, x6, 104, x7)

inst_548:
// rs1_val==3689348814741910322 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x33333998, 0x3333333333333332, 0x666, x6, 112, x7)

inst_549:
// rs1_val==3689348814741910322 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x33333305, 0x3333333333333332, -0x2d, x6, 120, x7)

inst_550:
// rs1_val==3689348814741910322 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x3333335f, 0x3333333333333332, 0x2d, x6, 128, x7)

inst_551:
// rs1_val==3689348814741910322 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x33333334, 0x3333333333333332, 0x2, x6, 136, x7)

inst_552:
// rs1_val==3689348814741910322 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x33333886, 0x3333333333333332, 0x554, x6, 144, x7)

inst_553:
// rs1_val==3689348814741910322 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x33333332, 0x3333333333333332, 0x0, x6, 152, x7)

inst_554:
// rs1_val==3689348814741910322 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x33333336, 0x3333333333333332, 0x4, x6, 160, x7)

inst_555:
// rs1_val==3689348814741910322 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x33333664, 0x3333333333333332, 0x332, x6, 168, x7)

inst_556:
// rs1_val==3689348814741910322 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x33333997, 0x3333333333333332, 0x665, x6, 176, x7)

inst_557:
// rs1_val==3689348814741910322 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x3333335e, 0x3333333333333332, 0x2c, x6, 184, x7)

inst_558:
// rs1_val==3689348814741910322 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x33333888, 0x3333333333333332, 0x556, x6, 192, x7)

inst_559:
// rs1_val==3689348814741910322 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x33332ddd, 0x3333333333333332, -0x555, x6, 200, x7)

inst_560:
// rs1_val==3689348814741910322 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x33333338, 0x3333333333333332, 0x6, x6, 208, x7)

inst_561:
// rs1_val==3689348814741910322 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x33333666, 0x3333333333333332, 0x334, x6, 216, x7)

inst_562:
// rs1_val==3689348814741910322 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x33333999, 0x3333333333333332, 0x667, x6, 224, x7)

inst_563:
// rs1_val==3689348814741910322 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x33333306, 0x3333333333333332, -0x2c, x6, 232, x7)

inst_564:
// rs1_val==3689348814741910322 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x33333360, 0x3333333333333332, 0x2e, x6, 240, x7)

inst_565:
// rs1_val==7378697629483820645 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x66666668, 0x6666666666666665, 0x3, x6, 248, x7)

inst_566:
// rs1_val==7378697629483820645 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x66666bba, 0x6666666666666665, 0x555, x6, 256, x7)

inst_567:
// rs1_val==7378697629483820645 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x6666610f, 0x6666666666666665, -0x556, x6, 264, x7)

inst_568:
// rs1_val==7378697629483820645 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x6666666a, 0x6666666666666665, 0x5, x6, 272, x7)

inst_569:
// rs1_val==7378697629483820645 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x66666998, 0x6666666666666665, 0x333, x6, 280, x7)

inst_570:
// rs1_val==7378697629483820645 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x66666ccb, 0x6666666666666665, 0x666, x6, 288, x7)

inst_571:
// rs1_val==7378697629483820645 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x66666638, 0x6666666666666665, -0x2d, x6, 296, x7)

inst_572:
// rs1_val==7378697629483820645 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x66666692, 0x6666666666666665, 0x2d, x6, 304, x7)

inst_573:
// rs1_val==7378697629483820645 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x66666667, 0x6666666666666665, 0x2, x6, 312, x7)

inst_574:
// rs1_val==7378697629483820645 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x66666bb9, 0x6666666666666665, 0x554, x6, 320, x7)

inst_575:
// rs1_val==7378697629483820645 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x66666665, 0x6666666666666665, 0x0, x6, 328, x7)

inst_576:
// rs1_val==7378697629483820645 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x66666669, 0x6666666666666665, 0x4, x6, 336, x7)

inst_577:
// rs1_val==7378697629483820645 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x66666997, 0x6666666666666665, 0x332, x6, 344, x7)

inst_578:
// rs1_val==7378697629483820645 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x66666cca, 0x6666666666666665, 0x665, x6, 352, x7)

inst_579:
// rs1_val==7378697629483820645 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, 0x66666691, 0x6666666666666665, 0x2c, x6, 360, x7)

inst_580:
// rs1_val==7378697629483820645 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, 0x66666bbb, 0x6666666666666665, 0x556, x6, 368, x7)

inst_581:
// rs1_val==7378697629483820645 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, 0x66666110, 0x6666666666666665, -0x555, x6, 376, x7)

inst_582:
// rs1_val==7378697629483820645 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x6666666b, 0x6666666666666665, 0x6, x6, 384, x7)

inst_583:
// rs1_val==7378697629483820645 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, 0x66666999, 0x6666666666666665, 0x334, x6, 392, x7)

inst_584:
// rs1_val==7378697629483820645 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, 0x66666ccc, 0x6666666666666665, 0x667, x6, 400, x7)

inst_585:
// rs1_val==7378697629483820645 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, 0x66666639, 0x6666666666666665, -0x2c, x6, 408, x7)

inst_586:
// rs1_val==7378697629483820645 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, 0x66666693, 0x6666666666666665, 0x2e, x6, 416, x7)

inst_587:
// rs1_val==3037000498 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ccb, 0xb504f332, 0x3, x6, 424, x7)

inst_588:
// rs1_val==3037000498 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, -0x4afb0779, 0xb504f332, 0x555, x6, 432, x7)

inst_589:
// rs1_val==3037000498 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, -0x4afb1224, 0xb504f332, -0x556, x6, 440, x7)

inst_590:
// rs1_val==3037000498 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc9, 0xb504f332, 0x5, x6, 448, x7)

inst_591:
// rs1_val==3037000498 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, -0x4afb099b, 0xb504f332, 0x333, x6, 456, x7)

inst_592:
// rs1_val==3037000498 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, -0x4afb0668, 0xb504f332, 0x666, x6, 464, x7)

inst_593:
// rs1_val==3037000498 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cfb, 0xb504f332, -0x2d, x6, 472, x7)

inst_594:
// rs1_val==3037000498 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ca1, 0xb504f332, 0x2d, x6, 480, x7)

inst_595:
// rs1_val==3037000498 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ccc, 0xb504f332, 0x2, x6, 488, x7)

inst_596:
// rs1_val==3037000498 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, -0x4afb077a, 0xb504f332, 0x554, x6, 496, x7)

inst_597:
// rs1_val==3037000498 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cce, 0xb504f332, 0x0, x6, 504, x7)

inst_598:
// rs1_val==3037000498 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cca, 0xb504f332, 0x4, x6, 512, x7)

inst_599:
// rs1_val==3037000498 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, -0x4afb099c, 0xb504f332, 0x332, x6, 520, x7)

inst_600:
// rs1_val==3037000498 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, -0x4afb0669, 0xb504f332, 0x665, x6, 528, x7)

inst_601:
// rs1_val==3037000498 and imm_val==44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2c
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ca2, 0xb504f332, 0x2c, x6, 536, x7)

inst_602:
// rs1_val==3037000498 and imm_val==1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x556
TEST_IMM_OP( addiw, x11, x10, -0x4afb0778, 0xb504f332, 0x556, x6, 544, x7)

inst_603:
// rs1_val==3037000498 and imm_val==-1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x555
TEST_IMM_OP( addiw, x11, x10, -0x4afb1223, 0xb504f332, -0x555, x6, 552, x7)

inst_604:
// rs1_val==3037000498 and imm_val==6, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cc8, 0xb504f332, 0x6, x6, 560, x7)

inst_605:
// rs1_val==3037000498 and imm_val==820, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x334
TEST_IMM_OP( addiw, x11, x10, -0x4afb099a, 0xb504f332, 0x334, x6, 568, x7)

inst_606:
// rs1_val==3037000498 and imm_val==1639, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x667
TEST_IMM_OP( addiw, x11, x10, -0x4afb0667, 0xb504f332, 0x667, x6, 576, x7)

inst_607:
// rs1_val==3037000498 and imm_val==-44, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2c
TEST_IMM_OP( addiw, x11, x10, -0x4afb0cfa, 0xb504f332, -0x2c, x6, 584, x7)

inst_608:
// rs1_val==3037000498 and imm_val==46, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2e
TEST_IMM_OP( addiw, x11, x10, -0x4afb0ca0, 0xb504f332, 0x2e, x6, 592, x7)

inst_609:
// rs1_val==6148914691236517206 and imm_val==3, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x3
TEST_IMM_OP( addiw, x11, x10, 0x55555559, 0x5555555555555556, 0x3, x6, 600, x7)

inst_610:
// rs1_val==6148914691236517206 and imm_val==1365, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x555
TEST_IMM_OP( addiw, x11, x10, 0x55555aab, 0x5555555555555556, 0x555, x6, 608, x7)

inst_611:
// rs1_val==6148914691236517206 and imm_val==-1366, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x556
TEST_IMM_OP( addiw, x11, x10, 0x55555000, 0x5555555555555556, -0x556, x6, 616, x7)

inst_612:
// rs1_val==6148914691236517206 and imm_val==5, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x5
TEST_IMM_OP( addiw, x11, x10, 0x5555555b, 0x5555555555555556, 0x5, x6, 624, x7)

inst_613:
// rs1_val==6148914691236517206 and imm_val==819, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x333
TEST_IMM_OP( addiw, x11, x10, 0x55555889, 0x5555555555555556, 0x333, x6, 632, x7)

inst_614:
// rs1_val==6148914691236517206 and imm_val==1638, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x666
TEST_IMM_OP( addiw, x11, x10, 0x55555bbc, 0x5555555555555556, 0x666, x6, 640, x7)

inst_615:
// rs1_val==6148914691236517206 and imm_val==-45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( addiw, x11, x10, 0x55555529, 0x5555555555555556, -0x2d, x6, 648, x7)

inst_616:
// rs1_val==6148914691236517206 and imm_val==45, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2d
TEST_IMM_OP( addiw, x11, x10, 0x55555583, 0x5555555555555556, 0x2d, x6, 656, x7)

inst_617:
// rs1_val==6148914691236517206 and imm_val==2, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x55555558, 0x5555555555555556, 0x2, x6, 664, x7)

inst_618:
// rs1_val==6148914691236517206 and imm_val==1364, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x554
TEST_IMM_OP( addiw, x11, x10, 0x55555aaa, 0x5555555555555556, 0x554, x6, 672, x7)

inst_619:
// rs1_val==6148914691236517206 and imm_val==0, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x0
TEST_IMM_OP( addiw, x11, x10, 0x55555556, 0x5555555555555556, 0x0, x6, 680, x7)

inst_620:
// rs1_val==6148914691236517206 and imm_val==4, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x4
TEST_IMM_OP( addiw, x11, x10, 0x5555555a, 0x5555555555555556, 0x4, x6, 688, x7)

inst_621:
// rs1_val==6148914691236517206 and imm_val==818, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x332
TEST_IMM_OP( addiw, x11, x10, 0x55555888, 0x5555555555555556, 0x332, x6, 696, x7)

inst_622:
// rs1_val==6148914691236517206 and imm_val==1637, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x665
TEST_IMM_OP( addiw, x11, x10, 0x55555bbb, 0x5555555555555556, 0x665, x6, 704, x7)

inst_623:
// rs1_val == 1, 
// opcode: addiw ; op1:x10; dest:x11; op1val:0x1;  immval:0x6
TEST_IMM_OP( addiw, x11, x10, 0x7, 0x1, 0x6, x6, 712, x7)

inst_624:
// imm_val == 2, rs1_val == 4294967296
// opcode: addiw ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x2
TEST_IMM_OP( addiw, x11, x10, 0x2, 0x100000000, 0x2, x6, 720, x7)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x15_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x15_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x6_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x6_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x6_2:
    .fill 91*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
