
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the andi instruction of the RISC-V I extension for the andi covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",andi)

RVTEST_SIGBASE( x5,signature_x5_1)

inst_0:
// rs1 == rd, rs1==x18, rd==x18, imm_val == (-2**(12-1)), imm_val == -2048, rs1_val != imm_val, rs1_val < 0 and imm_val < 0, rs1_val == -257
// opcode: andi ; op1:x18; dest:x18; op1val:-0x101;  immval:-0x800
TEST_IMM_OP( andi, x18, x18, 0xfffffffffffff800, -0x101, -0x800, x5, 0, x11)

inst_1:
// rs1 != rd, rs1==x8, rd==x17, imm_val == 0, rs1_val == -65537
// opcode: andi ; op1:x8; dest:x17; op1val:-0x10001;  immval:0x0
TEST_IMM_OP( andi, x17, x8, 0x0, -0x10001, 0x0, x5, 8, x11)

inst_2:
// rs1==x19, rd==x10, imm_val == (2**(12-1)-1), rs1_val == 1024, rs1_val > 0 and imm_val > 0, imm_val == 2047
// opcode: andi ; op1:x19; dest:x10; op1val:0x400;  immval:0x7ff
TEST_IMM_OP( andi, x10, x19, 0x400, 0x400, 0x7ff, x5, 16, x11)

inst_3:
// rs1==x20, rd==x1, imm_val == 1, rs1_val == 4096
// opcode: andi ; op1:x20; dest:x1; op1val:0x1000;  immval:0x1
TEST_IMM_OP( andi, x1, x20, 0x0, 0x1000, 0x1, x5, 24, x11)

inst_4:
// rs1==x22, rd==x31, rs1_val == (-2**(xlen-1)), rs1_val < 0 and imm_val > 0, rs1_val == -9223372036854775808
// opcode: andi ; op1:x22; dest:x31; op1val:-0x8000000000000000;  immval:0x554
TEST_IMM_OP( andi, x31, x22, 0x0, -0x8000000000000000, 0x554, x5, 32, x11)

inst_5:
// rs1==x3, rd==x24, rs1_val == 0, rs1_val==0 and imm_val==45
// opcode: andi ; op1:x3; dest:x24; op1val:0x0;  immval:0x2d
TEST_IMM_OP( andi, x24, x3, 0x0, 0x0, 0x2d, x5, 40, x11)

inst_6:
// rs1==x6, rd==x2, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807, imm_val == 512
// opcode: andi ; op1:x6; dest:x2; op1val:0x7fffffffffffffff;  immval:0x200
TEST_IMM_OP( andi, x2, x6, 0x200, 0x7fffffffffffffff, 0x200, x5, 48, x11)

inst_7:
// rs1==x1, rd==x7, rs1_val == 1, rs1_val > 0 and imm_val < 0, imm_val == -33
// opcode: andi ; op1:x1; dest:x7; op1val:0x1;  immval:-0x21
TEST_IMM_OP( andi, x7, x1, 0x1, 0x1, -0x21, x5, 56, x11)

inst_8:
// rs1==x31, rd==x29, rs1_val == imm_val, rs1_val==0 and imm_val==0
// opcode: andi ; op1:x31; dest:x29; op1val:0x0;  immval:0x0
TEST_IMM_OP( andi, x29, x31, 0x0, 0x0, 0x0, x5, 64, x11)

inst_9:
// rs1==x23, rd==x26, imm_val == 2, rs1_val == -17
// opcode: andi ; op1:x23; dest:x26; op1val:-0x11;  immval:0x2
TEST_IMM_OP( andi, x26, x23, 0x2, -0x11, 0x2, x5, 72, x11)

inst_10:
// rs1==x9, rd==x27, imm_val == 4, 
// opcode: andi ; op1:x9; dest:x27; op1val:0x1000;  immval:0x4
TEST_IMM_OP( andi, x27, x9, 0x0, 0x1000, 0x4, x5, 80, x11)

inst_11:
// rs1==x2, rd==x20, imm_val == 8, rs1_val == -288230376151711745
// opcode: andi ; op1:x2; dest:x20; op1val:-0x400000000000001;  immval:0x8
TEST_IMM_OP( andi, x20, x2, 0x8, -0x400000000000001, 0x8, x5, 88, x11)

inst_12:
// rs1==x13, rd==x21, imm_val == 16, rs1_val == 2199023255552
// opcode: andi ; op1:x13; dest:x21; op1val:0x20000000000;  immval:0x10
TEST_IMM_OP( andi, x21, x13, 0x0, 0x20000000000, 0x10, x5, 96, x11)

inst_13:
// rs1==x15, rd==x28, imm_val == 32, rs1_val == 16
// opcode: andi ; op1:x15; dest:x28; op1val:0x10;  immval:0x20
TEST_IMM_OP( andi, x28, x15, 0x0, 0x10, 0x20, x5, 104, x11)

inst_14:
// rs1==x21, rd==x30, imm_val == 64, 
// opcode: andi ; op1:x21; dest:x30; op1val:0x7fffffffffffffff;  immval:0x40
TEST_IMM_OP( andi, x30, x21, 0x40, 0x7fffffffffffffff, 0x40, x5, 112, x11)

inst_15:
// rs1==x30, rd==x13, imm_val == 128, rs1_val == -4194305
// opcode: andi ; op1:x30; dest:x13; op1val:-0x400001;  immval:0x80
TEST_IMM_OP( andi, x13, x30, 0x80, -0x400001, 0x80, x5, 120, x11)

inst_16:
// rs1==x26, rd==x22, imm_val == 256, rs1_val == 1125899906842624
// opcode: andi ; op1:x26; dest:x22; op1val:0x4000000000000;  immval:0x100
TEST_IMM_OP( andi, x22, x26, 0x0, 0x4000000000000, 0x100, x5, 128, x11)

inst_17:
// rs1==x29, rd==x4, imm_val == 1024, 
// opcode: andi ; op1:x29; dest:x4; op1val:0x6666666666666665;  immval:0x400
TEST_IMM_OP( andi, x4, x29, 0x400, 0x6666666666666665, 0x400, x5, 136, x11)

inst_18:
// rs1==x25, rd==x0, imm_val == -2, 
// opcode: andi ; op1:x25; dest:x0; op1val:0x5555555555555554;  immval:-0x2
TEST_IMM_OP( andi, x0, x25, 0, 0x5555555555555554, -0x2, x5, 144, x11)

inst_19:
// rs1==x12, rd==x23, imm_val == -3, rs1_val == 137438953472
// opcode: andi ; op1:x12; dest:x23; op1val:0x2000000000;  immval:-0x3
TEST_IMM_OP( andi, x23, x12, 0x2000000000, 0x2000000000, -0x3, x5, 152, x11)

inst_20:
// rs1==x24, rd==x6, imm_val == -5, rs1_val == -2199023255553
// opcode: andi ; op1:x24; dest:x6; op1val:-0x20000000001;  immval:-0x5
TEST_IMM_OP( andi, x6, x24, 0xfffffdfffffffffb, -0x20000000001, -0x5, x5, 160, x2)

inst_21:
// rs1==x7, rd==x11, imm_val == -9, 
// opcode: andi ; op1:x7; dest:x11; op1val:0x6666666666666665;  immval:-0x9
TEST_IMM_OP( andi, x11, x7, 0x6666666666666665, 0x6666666666666665, -0x9, x5, 168, x2)
RVTEST_SIGBASE( x1,signature_x1_0)

inst_22:
// rs1==x28, rd==x25, imm_val == -17, rs1_val == 6148914691236517205
// opcode: andi ; op1:x28; dest:x25; op1val:0x5555555555555555;  immval:-0x11
TEST_IMM_OP( andi, x25, x28, 0x5555555555555545, 0x5555555555555555, -0x11, x1, 0, x2)

inst_23:
// rs1==x27, rd==x5, imm_val == -65, rs1_val == 8
// opcode: andi ; op1:x27; dest:x5; op1val:0x8;  immval:-0x41
TEST_IMM_OP( andi, x5, x27, 0x8, 0x8, -0x41, x1, 8, x2)

inst_24:
// rs1==x16, rd==x19, imm_val == -129, rs1_val == -4398046511105
// opcode: andi ; op1:x16; dest:x19; op1val:-0x40000000001;  immval:-0x81
TEST_IMM_OP( andi, x19, x16, 0xfffffbffffffff7f, -0x40000000001, -0x81, x1, 16, x2)

inst_25:
// rs1==x10, rd==x3, imm_val == -257, rs1_val == 4611686018427387904
// opcode: andi ; op1:x10; dest:x3; op1val:0x4000000000000000;  immval:-0x101
TEST_IMM_OP( andi, x3, x10, 0x4000000000000000, 0x4000000000000000, -0x101, x1, 24, x2)

inst_26:
// rs1==x0, rd==x16, imm_val == -513, rs1_val == -262145
// opcode: andi ; op1:x0; dest:x16; op1val:0x0;  immval:-0x201
TEST_IMM_OP( andi, x16, x0, 0x0, 0x0, -0x201, x1, 32, x2)

inst_27:
// rs1==x17, rd==x9, imm_val == -1025, 
// opcode: andi ; op1:x17; dest:x9; op1val:0x3333333333333332;  immval:-0x401
TEST_IMM_OP( andi, x9, x17, 0x3333333333333332, 0x3333333333333332, -0x401, x1, 40, x2)

inst_28:
// rs1==x14, rd==x12, imm_val == 1365, rs1_val==3037000500 and imm_val==1365
// opcode: andi ; op1:x14; dest:x12; op1val:0xb504f334;  immval:0x555
TEST_IMM_OP( andi, x12, x14, 0x114, 0xb504f334, 0x555, x1, 48, x2)

inst_29:
// rs1==x5, rd==x15, imm_val == -1366, rs1_val == -18014398509481985
// opcode: andi ; op1:x5; dest:x15; op1val:-0x40000000000001;  immval:-0x556
TEST_IMM_OP( andi, x15, x5, 0xffbffffffffffaaa, -0x40000000000001, -0x556, x1, 56, x2)

inst_30:
// rs1==x11, rd==x8, rs1_val == 2, rs1_val==2 and imm_val==-1365
// opcode: andi ; op1:x11; dest:x8; op1val:0x2;  immval:-0x555
TEST_IMM_OP( andi, x8, x11, 0x2, 0x2, -0x555, x1, 64, x2)

inst_31:
// rs1==x4, rd==x14, rs1_val == 4, 
// opcode: andi ; op1:x4; dest:x14; op1val:0x4;  immval:-0x800
TEST_IMM_OP( andi, x14, x4, 0x0, 0x4, -0x800, x1, 72, x2)

inst_32:
// rs1_val == 32, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x20;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x20, 0x555, x1, 80, x2)

inst_33:
// rs1_val == 64, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x40;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x40, 0x0, x1, 88, x2)

inst_34:
// rs1_val == 128, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x80;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x0, 0x80, 0x666, x1, 96, x2)

inst_35:
// rs1_val == 256, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x100;  immval:-0xa
TEST_IMM_OP( andi, x11, x10, 0x100, 0x100, -0xa, x1, 104, x2)

inst_36:
// rs1_val == 512, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x200;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x200, 0x2, x1, 112, x2)

inst_37:
// rs1_val == 2048, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x800;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x800, 0x800, -0x556, x1, 120, x2)

inst_38:
// rs1_val == 8192, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2000;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2000, 0x333, x1, 128, x2)

inst_39:
// rs1_val == 16384, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4000;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4000, 0x554, x1, 136, x2)

inst_40:
// rs1_val == 32768, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x8000;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x8000, 0x556, x1, 144, x2)

inst_41:
// rs1_val == 65536, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x10000;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x10000, 0x2, x1, 152, x2)

inst_42:
// rs1_val == 131072, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x20000;  immval:-0x3
TEST_IMM_OP( andi, x11, x10, 0x20000, 0x20000, -0x3, x1, 160, x2)

inst_43:
// rs1_val == 262144, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x40000;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x40000, 0x0, x1, 168, x2)

inst_44:
// rs1_val == 524288, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x80000;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x80000, 0x0, x1, 176, x2)

inst_45:
// rs1_val == 1048576, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x100000;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x100000, 0x100000, -0x2c, x1, 184, x2)

inst_46:
// rs1_val == 2097152, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x200000;  immval:-0x5
TEST_IMM_OP( andi, x11, x10, 0x200000, 0x200000, -0x5, x1, 192, x2)

inst_47:
// rs1_val == 4194304, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x400000;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x0, 0x400000, 0x6, x1, 200, x2)

inst_48:
// rs1_val == 8388608, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x800000;  immval:-0x2
TEST_IMM_OP( andi, x11, x10, 0x800000, 0x800000, -0x2, x1, 208, x2)

inst_49:
// rs1_val == 16777216, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x1000000;  immval:-0x9
TEST_IMM_OP( andi, x11, x10, 0x1000000, 0x1000000, -0x9, x1, 216, x2)

inst_50:
// rs1_val == 33554432, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2000000;  immval:0x7
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2000000, 0x7, x1, 224, x2)

inst_51:
// rs1_val == 67108864, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x7
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4000000, 0x7, x1, 232, x2)

inst_52:
// rs1_val == 134217728, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x8000000, 0x555, x1, 240, x2)

inst_53:
// rs1_val == 268435456, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, 0x10000000, 0x554, x1, 248, x2)

inst_54:
// rs1_val == 536870912, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x0, 0x20000000, 0x333, x1, 256, x2)

inst_55:
// rs1_val == 1073741824, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x40000000;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x40000000, 0x40000000, -0x555, x1, 264, x2)

inst_56:
// rs1_val == 2147483648, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x80000000;  immval:-0x7
TEST_IMM_OP( andi, x11, x10, 0x80000000, 0x80000000, -0x7, x1, 272, x2)

inst_57:
// rs1_val == 4294967296, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x80
TEST_IMM_OP( andi, x11, x10, 0x0, 0x100000000, 0x80, x1, 280, x2)

inst_58:
// rs1_val == 8589934592, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x200000000;  immval:0x9
TEST_IMM_OP( andi, x11, x10, 0x0, 0x200000000, 0x9, x1, 288, x2)

inst_59:
// rs1_val == 17179869184, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x400000000;  immval:-0x3
TEST_IMM_OP( andi, x11, x10, 0x400000000, 0x400000000, -0x3, x1, 296, x2)

inst_60:
// rs1_val == 34359738368, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x800000000;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x800000000, 0x4, x1, 304, x2)

inst_61:
// rs1_val == 68719476736, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x1000000000;  immval:-0x3
TEST_IMM_OP( andi, x11, x10, 0x1000000000, 0x1000000000, -0x3, x1, 312, x2)

inst_62:
// rs1_val == 274877906944, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4000000000;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4000000000, 0x0, x1, 320, x2)

inst_63:
// rs1_val == 549755813888, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x10
TEST_IMM_OP( andi, x11, x10, 0x0, 0x8000000000, 0x10, x1, 328, x2)

inst_64:
// rs1_val == 1099511627776, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x10000000000;  immval:0x3ff
TEST_IMM_OP( andi, x11, x10, 0x0, 0x10000000000, 0x3ff, x1, 336, x2)

inst_65:
// rs1_val == 4398046511104, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x40000000000;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x40000000000, 0x40000000000, -0x555, x1, 344, x2)

inst_66:
// rs1_val == 8796093022208, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x40
TEST_IMM_OP( andi, x11, x10, 0x0, 0x80000000000, 0x40, x1, 352, x2)

inst_67:
// rs1_val == 17592186044416, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x100000000000;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x100000000000, 0x100000000000, -0x2c, x1, 360, x2)

inst_68:
// rs1_val == 35184372088832, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x0, 0x200000000000, 0x667, x1, 368, x2)

inst_69:
// rs1_val == 70368744177664, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0x7
TEST_IMM_OP( andi, x11, x10, 0x0, 0x400000000000, 0x7, x1, 376, x2)

inst_70:
// rs1_val == 140737488355328, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x800000000000;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x800000000000, 0x555, x1, 384, x2)

inst_71:
// rs1_val == 281474976710656, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x1000000000000, 0x3, x1, 392, x2)

inst_72:
// rs1_val == 562949953421312, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:-0x4
TEST_IMM_OP( andi, x11, x10, 0x2000000000000, 0x2000000000000, -0x4, x1, 400, x2)

inst_73:
// rs1_val == 2251799813685248, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x8000000000000;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0x8000000000000, 0x5, x1, 408, x2)

inst_74:
// rs1_val == 4503599627370496, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x10000000000000;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x0, 0x10000000000000, 0x333, x1, 416, x2)

inst_75:
// rs1_val == 9007199254740992, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:0x8
TEST_IMM_OP( andi, x11, x10, 0x0, 0x20000000000000, 0x8, x1, 424, x2)

inst_76:
// rs1_val == 18014398509481984, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x40000000000000, 0x0, x1, 432, x2)

inst_77:
// rs1_val == 36028797018963968, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:-0x400
TEST_IMM_OP( andi, x11, x10, 0x80000000000000, 0x80000000000000, -0x400, x1, 440, x2)

inst_78:
// rs1_val == 72057594037927936, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x100000000000000, 0x0, x1, 448, x2)

inst_79:
// rs1_val == 144115188075855872, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:-0xa
TEST_IMM_OP( andi, x11, x10, 0x200000000000000, 0x200000000000000, -0xa, x1, 456, x2)

inst_80:
// rs1_val == 288230376151711744, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0x400
TEST_IMM_OP( andi, x11, x10, 0x0, 0x400000000000000, 0x400, x1, 464, x2)

inst_81:
// rs1_val == 576460752303423488, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x800000000000000, 0x2, x1, 472, x2)

inst_82:
// rs1_val == 1152921504606846976, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x1000000000000000, 0x1000000000000000, -0x556, x1, 480, x2)

inst_83:
// rs1_val == 2305843009213693952, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2000000000000000, 0x667, x1, 488, x2)

inst_84:
// rs1_val == -2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x2;  immval:0x7
TEST_IMM_OP( andi, x11, x10, 0x6, -0x2, 0x7, x1, 496, x2)

inst_85:
// rs1_val == -3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x3;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x330, -0x3, 0x332, x1, 504, x2)

inst_86:
// rs1_val == -5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5, 0x4, x1, 512, x2)

inst_87:
// rs1_val == -9, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x9;  immval:0x7
TEST_IMM_OP( andi, x11, x10, 0x7, -0x9, 0x7, x1, 520, x2)

inst_88:
// rs1_val == -33, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x21;  immval:-0x4
TEST_IMM_OP( andi, x11, x10, 0xffffffffffffffdc, -0x21, -0x4, x1, 528, x2)

inst_89:
// rs1_val == -65, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x41;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x626, -0x41, 0x666, x1, 536, x2)

inst_90:
// rs1_val == -129, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x81;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x81, 0x0, x1, 544, x2)

inst_91:
// rs1_val == -513, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x201;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x467, -0x201, 0x667, x1, 552, x2)

inst_92:
// rs1_val == -1025, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x401;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, -0x401, 0x2, x1, 560, x2)

inst_93:
// rs1_val == -2049, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x801;  immval:0x7
TEST_IMM_OP( andi, x11, x10, 0x7, -0x801, 0x7, x1, 568, x2)

inst_94:
// rs1_val == -4097, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x1001;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x1001, 0x0, x1, 576, x2)

inst_95:
// rs1_val == -8193, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x2001;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, -0x2001, 0x5, x1, 584, x2)

inst_96:
// rs1_val == -16385, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x3ff
TEST_IMM_OP( andi, x11, x10, 0x3ff, -0x4001, 0x3ff, x1, 592, x2)

inst_97:
// rs1_val == -32769, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x8001, 0x0, x1, 600, x2)

inst_98:
// rs1_val == -131073, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x20001;  immval:-0x7
TEST_IMM_OP( andi, x11, x10, 0xfffffffffffdfff9, -0x20001, -0x7, x1, 608, x2)

inst_99:
// rs1_val == -524289, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x80001;  immval:-0x3
TEST_IMM_OP( andi, x11, x10, 0xfffffffffff7fffd, -0x80001, -0x3, x1, 616, x2)

inst_100:
// rs1_val == -1048577, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x100001;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x334, -0x100001, 0x334, x1, 624, x2)

inst_101:
// rs1_val == -2097153, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x200001;  immval:-0xa
TEST_IMM_OP( andi, x11, x10, 0xffffffffffdffff6, -0x200001, -0xa, x1, 632, x2)

inst_102:
// rs1_val == -8388609, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x800001;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, -0x800001, 0x2, x1, 640, x2)

inst_103:
// rs1_val == -16777217, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x1000001;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x1000001, 0x0, x1, 648, x2)

inst_104:
// rs1_val == -33554433, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x2000001;  immval:0x8
TEST_IMM_OP( andi, x11, x10, 0x8, -0x2000001, 0x8, x1, 656, x2)

inst_105:
// rs1_val == -67108865, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x332, -0x4000001, 0x332, x1, 664, x2)

inst_106:
// rs1_val == -134217729, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x8000001;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xfffffffff7ffffd3, -0x8000001, -0x2d, x1, 672, x2)

inst_107:
// rs1_val == -268435457, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, -0x10000001, 0x5, x1, 680, x2)

inst_108:
// rs1_val == -536870913, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x20000001;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x20000001, 0x0, x1, 688, x2)

inst_109:
// rs1_val == -1073741825, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x40000001;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xffffffffbfffffd3, -0x40000001, -0x2d, x1, 696, x2)

inst_110:
// rs1_val == -2147483649, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x80000001;  immval:0x3ff
TEST_IMM_OP( andi, x11, x10, 0x3ff, -0x80000001, 0x3ff, x1, 704, x2)

inst_111:
// rs1_val == -4294967297, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x100000001;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, -0x100000001, 0x6, x1, 712, x2)

inst_112:
// rs1_val == -8589934593, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x200000001;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x556, -0x200000001, 0x556, x1, 720, x2)

inst_113:
// rs1_val == -17179869185, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x400000001;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xfffffffbfffffaaa, -0x400000001, -0x556, x1, 728, x2)

inst_114:
// rs1_val == -34359738369, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x800000001;  immval:0x20
TEST_IMM_OP( andi, x11, x10, 0x20, -0x800000001, 0x20, x1, 736, x2)

inst_115:
// rs1_val == -68719476737, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x1000000001;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xffffffefffffffd3, -0x1000000001, -0x2d, x1, 744, x2)

inst_116:
// rs1_val == -137438953473, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x2000000001;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, -0x2000000001, 0x4, x1, 752, x2)

inst_117:
// rs1_val == -274877906945, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x2d, -0x4000000001, 0x2d, x1, 760, x2)

inst_118:
// rs1_val == -549755813889, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:0x20
TEST_IMM_OP( andi, x11, x10, 0x20, -0x8000000001, 0x20, x1, 768, x2)

inst_119:
// rs1_val == -1099511627777, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xfffffeffffffffd4, -0x10000000001, -0x2c, x1, 776, x2)

inst_120:
// rs1_val == -8796093022209, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x80000000001;  immval:-0x5
TEST_IMM_OP( andi, x11, x10, 0xfffff7fffffffffb, -0x80000000001, -0x5, x1, 784, x2)

inst_121:
// rs1_val == -17592186044417, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xffffefffffffffd4, -0x100000000001, -0x2c, x1, 792, x2)

inst_122:
// rs1_val == -35184372088833, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xffffdfffffffffd4, -0x200000000001, -0x2c, x1, 800, x2)

inst_123:
// rs1_val == -70368744177665, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x400000000001;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x2c, -0x400000000001, 0x2c, x1, 808, x2)

inst_124:
// rs1_val == -140737488355329, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x555, -0x800000000001, 0x555, x1, 816, x2)

inst_125:
// rs1_val == -281474976710657, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x1000000000001;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x334, -0x1000000000001, 0x334, x1, 824, x2)

inst_126:
// rs1_val == -562949953421313, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x2000000000001;  immval:-0x41
TEST_IMM_OP( andi, x11, x10, 0xfffdffffffffffbf, -0x2000000000001, -0x41, x1, 832, x2)

inst_127:
// rs1_val == -1125899906842625, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xfffbffffffffffd4, -0x4000000000001, -0x2c, x1, 840, x2)

inst_128:
// rs1_val == -2251799813685249, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x8000000000001;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xfff7ffffffffffd4, -0x8000000000001, -0x2c, x1, 848, x2)

inst_129:
// rs1_val == -4503599627370497, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:-0x401
TEST_IMM_OP( andi, x11, x10, 0xffeffffffffffbff, -0x10000000000001, -0x401, x1, 856, x2)

inst_130:
// rs1_val == -9007199254740993, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x20000000000001;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xffdfffffffffffd3, -0x20000000000001, -0x2d, x1, 864, x2)

inst_131:
// rs1_val == -36028797018963969, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x80000000000001;  immval:-0x5
TEST_IMM_OP( andi, x11, x10, 0xff7ffffffffffffb, -0x80000000000001, -0x5, x1, 872, x2)

inst_132:
// rs1_val == -72057594037927937, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x332, -0x100000000000001, 0x332, x1, 880, x2)

inst_133:
// rs1_val == -144115188075855873, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, -0x200000000000001, 0x3, x1, 888, x2)

inst_134:
// rs1_val == -576460752303423489, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x800000000000001, 0x0, x1, 896, x2)

inst_135:
// rs1_val == -1152921504606846977, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:0x80
TEST_IMM_OP( andi, x11, x10, 0x80, -0x1000000000000001, 0x80, x1, 904, x2)

inst_136:
// rs1_val == -2305843009213693953, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, -0x2000000000000001, 0x4, x1, 912, x2)

inst_137:
// rs1_val == -4611686018427387905, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x556, -0x4000000000000001, 0x556, x1, 920, x2)

inst_138:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206 and imm_val==0
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5555555555555556, 0x0, x1, 928, x2)

inst_139:
// rs1_val==3 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, 0x3, x1, 936, x2)

inst_140:
// rs1_val==3 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3, 0x555, x1, 944, x2)

inst_141:
// rs1_val==3 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, -0x556, x1, 952, x2)

inst_142:
// rs1_val==3 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3, 0x5, x1, 960, x2)

inst_143:
// rs1_val==3 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, 0x333, x1, 968, x2)

inst_144:
// rs1_val==3 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x666, x1, 976, x2)

inst_145:
// rs1_val==3 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, -0x2d, x1, 984, x2)

inst_146:
// rs1_val==3 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3, 0x2d, x1, 992, x2)

inst_147:
// rs1_val==3 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x2, x1, 1000, x2)

inst_148:
// rs1_val==3 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x554, x1, 1008, x2)

inst_149:
// rs1_val==3 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x0, x1, 1016, x2)

inst_150:
// rs1_val==3 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x4, x1, 1024, x2)

inst_151:
// rs1_val==3 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x332, x1, 1032, x2)

inst_152:
// rs1_val==3 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3, 0x665, x1, 1040, x2)

inst_153:
// rs1_val==3 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x2c, x1, 1048, x2)

inst_154:
// rs1_val==3 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x556, x1, 1056, x2)

inst_155:
// rs1_val==3 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, -0x555, x1, 1064, x2)

inst_156:
// rs1_val==3 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x6, x1, 1072, x2)

inst_157:
// rs1_val==3 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, 0x334, x1, 1080, x2)

inst_158:
// rs1_val==3 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3, 0x667, x1, 1088, x2)

inst_159:
// rs1_val==3 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3, -0x2c, x1, 1096, x2)

inst_160:
// rs1_val==3 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3, 0x2e, x1, 1104, x2)

inst_161:
// rs1_val==6148914691236517205 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5555555555555555, 0x3, x1, 1112, x2)

inst_162:
// rs1_val==6148914691236517205 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x555, 0x5555555555555555, 0x555, x1, 1120, x2)

inst_163:
// rs1_val==6148914691236517205 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x5555555555555000, 0x5555555555555555, -0x556, x1, 1128, x2)

inst_164:
// rs1_val==6148914691236517205 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5555555555555555, 0x5, x1, 1136, x2)

inst_165:
// rs1_val==6148914691236517205 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x111, 0x5555555555555555, 0x333, x1, 1144, x2)

inst_166:
// rs1_val==6148914691236517205 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x444, 0x5555555555555555, 0x666, x1, 1152, x2)

inst_167:
// rs1_val==6148914691236517205 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x5555555555555551, 0x5555555555555555, -0x2d, x1, 1160, x2)

inst_168:
// rs1_val==6148914691236517205 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5555555555555555, 0x2d, x1, 1168, x2)

inst_169:
// rs1_val==6148914691236517205 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5555555555555555, 0x2, x1, 1176, x2)

inst_170:
// rs1_val==6148914691236517205 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x554, 0x5555555555555555, 0x554, x1, 1184, x2)

inst_171:
// rs1_val==6148914691236517205 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5555555555555555, 0x0, x1, 1192, x2)

inst_172:
// rs1_val==6148914691236517205 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555555, 0x4, x1, 1200, x2)

inst_173:
// rs1_val==6148914691236517205 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x110, 0x5555555555555555, 0x332, x1, 1208, x2)

inst_174:
// rs1_val==6148914691236517205 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x445, 0x5555555555555555, 0x665, x1, 1216, x2)

inst_175:
// rs1_val==6148914691236517205 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555555, 0x2c, x1, 1224, x2)

inst_176:
// rs1_val==6148914691236517205 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x554, 0x5555555555555555, 0x556, x1, 1232, x2)

inst_177:
// rs1_val==6148914691236517205 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x5555555555555001, 0x5555555555555555, -0x555, x1, 1240, x2)

inst_178:
// rs1_val==6148914691236517205 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555555, 0x6, x1, 1248, x2)

inst_179:
// rs1_val==6148914691236517205 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x114, 0x5555555555555555, 0x334, x1, 1256, x2)

inst_180:
// rs1_val==6148914691236517205 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x445, 0x5555555555555555, 0x667, x1, 1264, x2)

inst_181:
// rs1_val==6148914691236517205 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x5555555555555554, 0x5555555555555555, -0x2c, x1, 1272, x2)

inst_182:
// rs1_val==6148914691236517205 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555555, 0x2e, x1, 1280, x2)

inst_183:
// rs1_val==-6148914691236517206 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, -0x5555555555555556, 0x3, x1, 1288, x2)

inst_184:
// rs1_val==-6148914691236517206 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5555555555555556, 0x555, x1, 1296, x2)

inst_185:
// rs1_val==-6148914691236517206 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, -0x556, x1, 1304, x2)

inst_186:
// rs1_val==-6148914691236517206 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5555555555555556, 0x5, x1, 1312, x2)

inst_187:
// rs1_val==-6148914691236517206 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x222, -0x5555555555555556, 0x333, x1, 1320, x2)

inst_188:
// rs1_val==-6148914691236517206 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, -0x5555555555555556, 0x666, x1, 1328, x2)

inst_189:
// rs1_val==-6148914691236517206 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaaaaaaaa82, -0x5555555555555556, -0x2d, x1, 1336, x2)

inst_190:
// rs1_val==-6148914691236517206 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x28, -0x5555555555555556, 0x2d, x1, 1344, x2)

inst_191:
// rs1_val==-6148914691236517206 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, -0x5555555555555556, 0x2, x1, 1352, x2)

inst_192:
// rs1_val==-6148914691236517206 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5555555555555556, 0x554, x1, 1360, x2)

inst_193:
// rs1_val==-6148914691236517206 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5555555555555556, 0x4, x1, 1368, x2)

inst_194:
// rs1_val==-6148914691236517206 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x222, -0x5555555555555556, 0x332, x1, 1376, x2)

inst_195:
// rs1_val==-6148914691236517206 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x220, -0x5555555555555556, 0x665, x1, 1384, x2)

inst_196:
// rs1_val==-6148914691236517206 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x28, -0x5555555555555556, 0x2c, x1, 1392, x2)

inst_197:
// rs1_val==-6148914691236517206 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x2, -0x5555555555555556, 0x556, x1, 1400, x2)

inst_198:
// rs1_val==-6148914691236517206 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, -0x555, x1, 1408, x2)

inst_199:
// rs1_val==-6148914691236517206 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, -0x5555555555555556, 0x6, x1, 1416, x2)

inst_200:
// rs1_val==-6148914691236517206 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x220, -0x5555555555555556, 0x334, x1, 1424, x2)

inst_201:
// rs1_val==-6148914691236517206 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x222, -0x5555555555555556, 0x667, x1, 1432, x2)

inst_202:
// rs1_val==-6148914691236517206 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaaaaaaaa80, -0x5555555555555556, -0x2c, x1, 1440, x2)

inst_203:
// rs1_val==-6148914691236517206 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2a, -0x5555555555555556, 0x2e, x1, 1448, x2)

inst_204:
// rs1_val==5 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5, 0x3, x1, 1456, x2)

inst_205:
// rs1_val==5 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x555, x1, 1464, x2)

inst_206:
// rs1_val==5 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5, -0x556, x1, 1472, x2)

inst_207:
// rs1_val==5 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x5, x1, 1480, x2)

inst_208:
// rs1_val==5 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5, 0x333, x1, 1488, x2)

inst_209:
// rs1_val==5 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x666, x1, 1496, x2)

inst_210:
// rs1_val==5 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5, -0x2d, x1, 1504, x2)

inst_211:
// rs1_val==5 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x2d, x1, 1512, x2)

inst_212:
// rs1_val==5 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5, 0x2, x1, 1520, x2)

inst_213:
// rs1_val==5 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x554, x1, 1528, x2)

inst_214:
// rs1_val==5 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5, 0x0, x1, 1536, x2)

inst_215:
// rs1_val==5 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x4, x1, 1544, x2)

inst_216:
// rs1_val==5 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5, 0x332, x1, 1552, x2)

inst_217:
// rs1_val==5 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x665, x1, 1560, x2)

inst_218:
// rs1_val==5 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x2c, x1, 1568, x2)

inst_219:
// rs1_val==5 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x556, x1, 1576, x2)

inst_220:
// rs1_val==5 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x1, 0x5, -0x555, x1, 1584, x2)

inst_221:
// rs1_val==5 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x6, x1, 1592, x2)

inst_222:
// rs1_val==5 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x334, x1, 1600, x2)

inst_223:
// rs1_val==5 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x5, 0x5, 0x667, x1, 1608, x2)

inst_224:
// rs1_val==5 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, -0x2c, x1, 1616, x2)

inst_225:
// rs1_val==5 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5, 0x2e, x1, 1624, x2)

inst_226:
// rs1_val==3689348814741910323 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, 0x3333333333333333, 0x3, x1, 1632, x2)

inst_227:
// rs1_val==3689348814741910323 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x111, 0x3333333333333333, 0x555, x1, 1640, x2)

inst_228:
// rs1_val==3689348814741910323 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x3333333333333222, 0x3333333333333333, -0x556, x1, 1648, x2)

inst_229:
// rs1_val==3689348814741910323 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x1, 0x3333333333333333, 0x5, x1, 1656, x2)

inst_230:
// rs1_val==3689348814741910323 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x333, 0x3333333333333333, 0x333, x1, 1664, x2)

inst_231:
// rs1_val==3689348814741910323 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, 0x3333333333333333, 0x666, x1, 1672, x2)

inst_232:
// rs1_val==3689348814741910323 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x3333333333333313, 0x3333333333333333, -0x2d, x1, 1680, x2)

inst_233:
// rs1_val==3689348814741910323 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x21, 0x3333333333333333, 0x2d, x1, 1688, x2)

inst_234:
// rs1_val==3689348814741910323 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3333333333333333, 0x2, x1, 1696, x2)

inst_235:
// rs1_val==3689348814741910323 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x110, 0x3333333333333333, 0x554, x1, 1704, x2)

inst_236:
// rs1_val==3689348814741910323 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3333333333333333, 0x0, x1, 1712, x2)

inst_237:
// rs1_val==3689348814741910323 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3333333333333333, 0x4, x1, 1720, x2)

inst_238:
// rs1_val==3689348814741910323 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x332, 0x3333333333333333, 0x332, x1, 1728, x2)

inst_239:
// rs1_val==3689348814741910323 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x221, 0x3333333333333333, 0x665, x1, 1736, x2)

inst_240:
// rs1_val==3689348814741910323 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x20, 0x3333333333333333, 0x2c, x1, 1744, x2)

inst_241:
// rs1_val==3689348814741910323 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x112, 0x3333333333333333, 0x556, x1, 1752, x2)

inst_242:
// rs1_val==3689348814741910323 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x3333333333333223, 0x3333333333333333, -0x555, x1, 1760, x2)

inst_243:
// rs1_val==3689348814741910323 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3333333333333333, 0x6, x1, 1768, x2)

inst_244:
// rs1_val==3689348814741910323 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x330, 0x3333333333333333, 0x334, x1, 1776, x2)

inst_245:
// rs1_val==3689348814741910323 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x223, 0x3333333333333333, 0x667, x1, 1784, x2)

inst_246:
// rs1_val==3689348814741910323 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x3333333333333310, 0x3333333333333333, -0x2c, x1, 1792, x2)

inst_247:
// rs1_val==3689348814741910323 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x22, 0x3333333333333333, 0x2e, x1, 1800, x2)

inst_248:
// rs1_val==7378697629483820646 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6666666666666666, 0x3, x1, 1808, x2)

inst_249:
// rs1_val==7378697629483820646 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x444, 0x6666666666666666, 0x555, x1, 1816, x2)

inst_250:
// rs1_val==7378697629483820646 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x6666666666666222, 0x6666666666666666, -0x556, x1, 1824, x2)

inst_251:
// rs1_val==7378697629483820646 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6666666666666666, 0x5, x1, 1832, x2)

inst_252:
// rs1_val==7378697629483820646 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x222, 0x6666666666666666, 0x333, x1, 1840, x2)

inst_253:
// rs1_val==7378697629483820646 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x666, 0x6666666666666666, 0x666, x1, 1848, x2)

inst_254:
// rs1_val==7378697629483820646 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x6666666666666642, 0x6666666666666666, -0x2d, x1, 1856, x2)

inst_255:
// rs1_val==7378697629483820646 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x24, 0x6666666666666666, 0x2d, x1, 1864, x2)

inst_256:
// rs1_val==7378697629483820646 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6666666666666666, 0x2, x1, 1872, x2)

inst_257:
// rs1_val==7378697629483820646 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x444, 0x6666666666666666, 0x554, x1, 1880, x2)

inst_258:
// rs1_val==7378697629483820646 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x6666666666666666, 0x0, x1, 1888, x2)

inst_259:
// rs1_val==7378697629483820646 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6666666666666666, 0x4, x1, 1896, x2)

inst_260:
// rs1_val==7378697629483820646 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x222, 0x6666666666666666, 0x332, x1, 1904, x2)

inst_261:
// rs1_val==7378697629483820646 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x664, 0x6666666666666666, 0x665, x1, 1912, x2)

inst_262:
// rs1_val==7378697629483820646 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0x6666666666666666, 0x2c, x1, 1920, x2)

inst_263:
// rs1_val==7378697629483820646 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x446, 0x6666666666666666, 0x556, x1, 1928, x2)

inst_264:
// rs1_val==7378697629483820646 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x6666666666666222, 0x6666666666666666, -0x555, x1, 1936, x2)

inst_265:
// rs1_val==7378697629483820646 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6666666666666666, 0x6, x1, 1944, x2)

inst_266:
// rs1_val==7378697629483820646 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x224, 0x6666666666666666, 0x334, x1, 1952, x2)

inst_267:
// rs1_val==7378697629483820646 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x666, 0x6666666666666666, 0x667, x1, 1960, x2)

inst_268:
// rs1_val==7378697629483820646 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x6666666666666644, 0x6666666666666666, -0x2c, x1, 1968, x2)

inst_269:
// rs1_val==7378697629483820646 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x26, 0x6666666666666666, 0x2e, x1, 1976, x2)

inst_270:
// rs1_val==-3037000499 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, -0xb504f333, 0x3, x1, 1984, x2)

inst_271:
// rs1_val==-3037000499 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x445, -0xb504f333, 0x555, x1, 1992, x2)

inst_272:
// rs1_val==-3037000499 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xffffffff4afb0888, -0xb504f333, -0x556, x1, 2000, x2)

inst_273:
// rs1_val==-3037000499 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, -0xb504f333, 0x5, x1, 2008, x2)

inst_274:
// rs1_val==-3037000499 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x1, -0xb504f333, 0x333, x1, 2016, x2)

inst_275:
// rs1_val==-3037000499 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x444, -0xb504f333, 0x666, x1, 2024, x2)

inst_276:
// rs1_val==-3037000499 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xffffffff4afb0cc1, -0xb504f333, -0x2d, x1, 2032, x2)

inst_277:
// rs1_val==-3037000499 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0xd, -0xb504f333, 0x2d, x1, 2040, x2)
RVTEST_SIGBASE( x1,signature_x1_1)

inst_278:
// rs1_val==-3037000499 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb504f333, 0x2, x1, 0, x2)

inst_279:
// rs1_val==-3037000499 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x444, -0xb504f333, 0x554, x1, 8, x2)

inst_280:
// rs1_val==-3037000499 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb504f333, 0x0, x1, 16, x2)

inst_281:
// rs1_val==-3037000499 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504f333, 0x4, x1, 24, x2)

inst_282:
// rs1_val==-3037000499 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb504f333, 0x332, x1, 32, x2)

inst_283:
// rs1_val==-3037000499 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x445, -0xb504f333, 0x665, x1, 40, x2)

inst_284:
// rs1_val==-3037000499 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0xc, -0xb504f333, 0x2c, x1, 48, x2)

inst_285:
// rs1_val==-3037000499 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x444, -0xb504f333, 0x556, x1, 56, x2)

inst_286:
// rs1_val==-3037000499 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xffffffff4afb0889, -0xb504f333, -0x555, x1, 64, x2)

inst_287:
// rs1_val==-3037000499 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504f333, 0x6, x1, 72, x2)

inst_288:
// rs1_val==-3037000499 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504f333, 0x334, x1, 80, x2)

inst_289:
// rs1_val==-3037000499 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x445, -0xb504f333, 0x667, x1, 88, x2)

inst_290:
// rs1_val==-3037000499 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xffffffff4afb0cc4, -0xb504f333, -0x2c, x1, 96, x2)

inst_291:
// rs1_val==-3037000499 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0xc, -0xb504f333, 0x2e, x1, 104, x2)

inst_292:
// rs1_val==3037000499 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, 0xb504f333, 0x3, x1, 112, x2)

inst_293:
// rs1_val==3037000499 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x111, 0xb504f333, 0x555, x1, 120, x2)

inst_294:
// rs1_val==3037000499 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xb504f222, 0xb504f333, -0x556, x1, 128, x2)

inst_295:
// rs1_val==3037000499 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x1, 0xb504f333, 0x5, x1, 136, x2)

inst_296:
// rs1_val==3037000499 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x333, 0xb504f333, 0x333, x1, 144, x2)

inst_297:
// rs1_val==3037000499 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, 0xb504f333, 0x666, x1, 152, x2)

inst_298:
// rs1_val==3037000499 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xb504f313, 0xb504f333, -0x2d, x1, 160, x2)

inst_299:
// rs1_val==3037000499 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x21, 0xb504f333, 0x2d, x1, 168, x2)

inst_300:
// rs1_val==3037000499 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0xb504f333, 0x2, x1, 176, x2)

inst_301:
// rs1_val==3037000499 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x110, 0xb504f333, 0x554, x1, 184, x2)

inst_302:
// rs1_val==3037000499 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504f333, 0x0, x1, 192, x2)

inst_303:
// rs1_val==3037000499 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504f333, 0x4, x1, 200, x2)

inst_304:
// rs1_val==3037000499 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x332, 0xb504f333, 0x332, x1, 208, x2)

inst_305:
// rs1_val==3037000499 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x221, 0xb504f333, 0x665, x1, 216, x2)

inst_306:
// rs1_val==3037000499 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x20, 0xb504f333, 0x2c, x1, 224, x2)

inst_307:
// rs1_val==3037000499 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x112, 0xb504f333, 0x556, x1, 232, x2)

inst_308:
// rs1_val==3037000499 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xb504f223, 0xb504f333, -0x555, x1, 240, x2)

inst_309:
// rs1_val==3037000499 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0xb504f333, 0x6, x1, 248, x2)

inst_310:
// rs1_val==3037000499 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x330, 0xb504f333, 0x334, x1, 256, x2)

inst_311:
// rs1_val==3037000499 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x223, 0xb504f333, 0x667, x1, 264, x2)

inst_312:
// rs1_val==3037000499 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xb504f310, 0xb504f333, -0x2c, x1, 272, x2)

inst_313:
// rs1_val==3037000499 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x22, 0xb504f333, 0x2e, x1, 280, x2)

inst_314:
// rs1_val==2 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x3, x1, 288, x2)

inst_315:
// rs1_val==2 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x555, x1, 296, x2)

inst_316:
// rs1_val==2 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, -0x556, x1, 304, x2)

inst_317:
// rs1_val==2 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x5, x1, 312, x2)

inst_318:
// rs1_val==2 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x333, x1, 320, x2)

inst_319:
// rs1_val==2 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x666, x1, 328, x2)

inst_320:
// rs1_val==2 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, -0x2d, x1, 336, x2)

inst_321:
// rs1_val==2 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x2d, x1, 344, x2)

inst_322:
// rs1_val==2 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x2, x1, 352, x2)

inst_323:
// rs1_val==2 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x554, x1, 360, x2)

inst_324:
// rs1_val==2 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x0, x1, 368, x2)

inst_325:
// rs1_val==2 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x4, x1, 376, x2)

inst_326:
// rs1_val==2 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x332, x1, 384, x2)

inst_327:
// rs1_val==2 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x665, x1, 392, x2)

inst_328:
// rs1_val==2 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x2c, x1, 400, x2)

inst_329:
// rs1_val==2 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x556, x1, 408, x2)

inst_330:
// rs1_val==2 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x6, x1, 416, x2)

inst_331:
// rs1_val==2 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, 0x334, x1, 424, x2)

inst_332:
// rs1_val==2 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x667, x1, 432, x2)

inst_333:
// rs1_val==2 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x2, -0x2c, x1, 440, x2)

inst_334:
// rs1_val==2 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2, 0x2, 0x2e, x1, 448, x2)

inst_335:
// rs1_val==6148914691236517204 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5555555555555554, 0x3, x1, 456, x2)

inst_336:
// rs1_val==6148914691236517204 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x554, 0x5555555555555554, 0x555, x1, 464, x2)

inst_337:
// rs1_val==6148914691236517204 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x5555555555555000, 0x5555555555555554, -0x556, x1, 472, x2)

inst_338:
// rs1_val==6148914691236517204 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555554, 0x5, x1, 480, x2)

inst_339:
// rs1_val==6148914691236517204 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x110, 0x5555555555555554, 0x333, x1, 488, x2)

inst_340:
// rs1_val==6148914691236517204 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x444, 0x5555555555555554, 0x666, x1, 496, x2)

inst_341:
// rs1_val==6148914691236517204 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x5555555555555550, 0x5555555555555554, -0x2d, x1, 504, x2)

inst_342:
// rs1_val==6148914691236517204 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555554, 0x2d, x1, 512, x2)

inst_343:
// rs1_val==6148914691236517204 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5555555555555554, 0x2, x1, 520, x2)

inst_344:
// rs1_val==6148914691236517204 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x554, 0x5555555555555554, 0x554, x1, 528, x2)

inst_345:
// rs1_val==6148914691236517204 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5555555555555554, 0x0, x1, 536, x2)

inst_346:
// rs1_val==6148914691236517204 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555554, 0x4, x1, 544, x2)

inst_347:
// rs1_val==6148914691236517204 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x110, 0x5555555555555554, 0x332, x1, 552, x2)

inst_348:
// rs1_val==6148914691236517204 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x444, 0x5555555555555554, 0x665, x1, 560, x2)

inst_349:
// rs1_val==6148914691236517204 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555554, 0x2c, x1, 568, x2)

inst_350:
// rs1_val==6148914691236517204 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x554, 0x5555555555555554, 0x556, x1, 576, x2)

inst_351:
// rs1_val==6148914691236517204 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x5555555555555000, 0x5555555555555554, -0x555, x1, 584, x2)

inst_352:
// rs1_val==6148914691236517204 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555554, 0x6, x1, 592, x2)

inst_353:
// rs1_val==6148914691236517204 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x114, 0x5555555555555554, 0x334, x1, 600, x2)

inst_354:
// rs1_val==6148914691236517204 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x444, 0x5555555555555554, 0x667, x1, 608, x2)

inst_355:
// rs1_val==6148914691236517204 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x5555555555555554, 0x5555555555555554, -0x2c, x1, 616, x2)

inst_356:
// rs1_val==6148914691236517204 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555554, 0x2e, x1, 624, x2)

inst_357:
// rs1_val==0 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x3, x1, 632, x2)

inst_358:
// rs1_val==0 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x555, x1, 640, x2)

inst_359:
// rs1_val==0 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, -0x556, x1, 648, x2)

inst_360:
// rs1_val==0 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x5, x1, 656, x2)

inst_361:
// rs1_val==0 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x333, x1, 664, x2)

inst_362:
// rs1_val==0 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x666, x1, 672, x2)

inst_363:
// rs1_val==6148914691236517206 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555556, 0x2c, x1, 680, x2)

inst_364:
// rs1_val==6148914691236517206 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x556, 0x5555555555555556, 0x556, x1, 688, x2)

inst_365:
// rs1_val==6148914691236517206 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x5555555555555002, 0x5555555555555556, -0x555, x1, 696, x2)

inst_366:
// rs1_val==6148914691236517206 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, 0x5555555555555556, 0x6, x1, 704, x2)

inst_367:
// rs1_val==6148914691236517206 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x114, 0x5555555555555556, 0x334, x1, 712, x2)

inst_368:
// rs1_val==6148914691236517206 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x446, 0x5555555555555556, 0x667, x1, 720, x2)

inst_369:
// rs1_val==6148914691236517206 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x5555555555555554, 0x5555555555555556, -0x2c, x1, 728, x2)

inst_370:
// rs1_val==6148914691236517206 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x6, 0x5555555555555556, 0x2e, x1, 736, x2)

inst_371:
// rs1_val==-6148914691236517205 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, -0x5555555555555555, 0x3, x1, 744, x2)

inst_372:
// rs1_val==-6148914691236517205 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x1, -0x5555555555555555, 0x555, x1, 752, x2)

inst_373:
// rs1_val==-6148914691236517205 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555555, -0x556, x1, 760, x2)

inst_374:
// rs1_val==-6148914691236517205 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x1, -0x5555555555555555, 0x5, x1, 768, x2)

inst_375:
// rs1_val==-6148914691236517205 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x223, -0x5555555555555555, 0x333, x1, 776, x2)

inst_376:
// rs1_val==-6148914691236517205 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, -0x5555555555555555, 0x666, x1, 784, x2)

inst_377:
// rs1_val==-6148914691236517205 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaaaaaaaa83, -0x5555555555555555, -0x2d, x1, 792, x2)

inst_378:
// rs1_val==-6148914691236517205 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x29, -0x5555555555555555, 0x2d, x1, 800, x2)

inst_379:
// rs1_val==-6148914691236517205 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, -0x5555555555555555, 0x2, x1, 808, x2)

inst_380:
// rs1_val==-6148914691236517205 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5555555555555555, 0x554, x1, 816, x2)

inst_381:
// rs1_val==-6148914691236517205 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5555555555555555, 0x0, x1, 824, x2)

inst_382:
// rs1_val==-6148914691236517205 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, -0x5555555555555555, 0x4, x1, 832, x2)

inst_383:
// rs1_val==-6148914691236517205 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x222, -0x5555555555555555, 0x332, x1, 840, x2)

inst_384:
// rs1_val==-6148914691236517205 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x221, -0x5555555555555555, 0x665, x1, 848, x2)

inst_385:
// rs1_val==-6148914691236517205 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x28, -0x5555555555555555, 0x2c, x1, 856, x2)

inst_386:
// rs1_val==-6148914691236517205 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x2, -0x5555555555555555, 0x556, x1, 864, x2)

inst_387:
// rs1_val==-6148914691236517205 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, -0x555, x1, 872, x2)

inst_388:
// rs1_val==-6148914691236517205 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, -0x5555555555555555, 0x6, x1, 880, x2)

inst_389:
// rs1_val==-6148914691236517205 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x220, -0x5555555555555555, 0x334, x1, 888, x2)

inst_390:
// rs1_val==-6148914691236517205 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x223, -0x5555555555555555, 0x667, x1, 896, x2)

inst_391:
// rs1_val==-6148914691236517205 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xaaaaaaaaaaaaaa80, -0x5555555555555555, -0x2c, x1, 904, x2)

inst_392:
// rs1_val==-6148914691236517205 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x2a, -0x5555555555555555, 0x2e, x1, 912, x2)

inst_393:
// rs1_val==6 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, 0x3, x1, 920, x2)

inst_394:
// rs1_val==6 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x555, x1, 928, x2)

inst_395:
// rs1_val==6 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, -0x556, x1, 936, x2)

inst_396:
// rs1_val==6 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x5, x1, 944, x2)

inst_397:
// rs1_val==6 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, 0x333, x1, 952, x2)

inst_398:
// rs1_val==6 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x666, x1, 960, x2)

inst_399:
// rs1_val==6 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, -0x2d, x1, 968, x2)

inst_400:
// rs1_val==6 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x2d, x1, 976, x2)

inst_401:
// rs1_val==6 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, 0x2, x1, 984, x2)

inst_402:
// rs1_val==6 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x554, x1, 992, x2)

inst_403:
// rs1_val==6 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x6, 0x0, x1, 1000, x2)

inst_404:
// rs1_val==6 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x4, x1, 1008, x2)

inst_405:
// rs1_val==6 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, 0x332, x1, 1016, x2)

inst_406:
// rs1_val==6 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x665, x1, 1024, x2)

inst_407:
// rs1_val==6 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x2c, x1, 1032, x2)

inst_408:
// rs1_val==6 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x556, x1, 1040, x2)

inst_409:
// rs1_val==6 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6, -0x555, x1, 1048, x2)

inst_410:
// rs1_val==6 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x6, x1, 1056, x2)

inst_411:
// rs1_val==6 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, 0x334, x1, 1064, x2)

inst_412:
// rs1_val==6 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x667, x1, 1072, x2)

inst_413:
// rs1_val==6 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6, -0x2c, x1, 1080, x2)

inst_414:
// rs1_val==6 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6, 0x2e, x1, 1088, x2)

inst_415:
// rs1_val==3689348814741910324 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3333333333333334, 0x3, x1, 1096, x2)

inst_416:
// rs1_val==3689348814741910324 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x114, 0x3333333333333334, 0x555, x1, 1104, x2)

inst_417:
// rs1_val==3689348814741910324 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x3333333333333220, 0x3333333333333334, -0x556, x1, 1112, x2)

inst_418:
// rs1_val==3689348814741910324 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x3333333333333334, 0x5, x1, 1120, x2)

inst_419:
// rs1_val==3689348814741910324 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x330, 0x3333333333333334, 0x333, x1, 1128, x2)

inst_420:
// rs1_val==3689348814741910324 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x224, 0x3333333333333334, 0x666, x1, 1136, x2)

inst_421:
// rs1_val==3689348814741910324 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x3333333333333310, 0x3333333333333334, -0x2d, x1, 1144, x2)

inst_422:
// rs1_val==3689348814741910324 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x24, 0x3333333333333334, 0x2d, x1, 1152, x2)

inst_423:
// rs1_val==3689348814741910324 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3333333333333334, 0x2, x1, 1160, x2)

inst_424:
// rs1_val==3689348814741910324 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x114, 0x3333333333333334, 0x554, x1, 1168, x2)

inst_425:
// rs1_val==3689348814741910324 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3333333333333334, 0x0, x1, 1176, x2)

inst_426:
// rs1_val==3689348814741910324 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x3333333333333334, 0x4, x1, 1184, x2)

inst_427:
// rs1_val==3689348814741910324 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x330, 0x3333333333333334, 0x332, x1, 1192, x2)

inst_428:
// rs1_val==3689348814741910324 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x224, 0x3333333333333334, 0x665, x1, 1200, x2)

inst_429:
// rs1_val==3689348814741910324 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0x3333333333333334, 0x2c, x1, 1208, x2)

inst_430:
// rs1_val==3689348814741910324 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x114, 0x3333333333333334, 0x556, x1, 1216, x2)

inst_431:
// rs1_val==3689348814741910324 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x3333333333333220, 0x3333333333333334, -0x555, x1, 1224, x2)

inst_432:
// rs1_val==3689348814741910324 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x3333333333333334, 0x6, x1, 1232, x2)

inst_433:
// rs1_val==3689348814741910324 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x334, 0x3333333333333334, 0x334, x1, 1240, x2)

inst_434:
// rs1_val==3689348814741910324 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x224, 0x3333333333333334, 0x667, x1, 1248, x2)

inst_435:
// rs1_val==3689348814741910324 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x3333333333333314, 0x3333333333333334, -0x2c, x1, 1256, x2)

inst_436:
// rs1_val==3689348814741910324 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x24, 0x3333333333333334, 0x2e, x1, 1264, x2)

inst_437:
// rs1_val==7378697629483820647 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x3, 0x6666666666666667, 0x3, x1, 1272, x2)

inst_438:
// rs1_val==7378697629483820647 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x445, 0x6666666666666667, 0x555, x1, 1280, x2)

inst_439:
// rs1_val==7378697629483820647 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x6666666666666222, 0x6666666666666667, -0x556, x1, 1288, x2)

inst_440:
// rs1_val==7378697629483820647 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0x6666666666666667, 0x5, x1, 1296, x2)

inst_441:
// rs1_val==7378697629483820647 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x223, 0x6666666666666667, 0x333, x1, 1304, x2)

inst_442:
// rs1_val==7378697629483820647 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x666, 0x6666666666666667, 0x666, x1, 1312, x2)

inst_443:
// rs1_val==7378697629483820647 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x6666666666666643, 0x6666666666666667, -0x2d, x1, 1320, x2)

inst_444:
// rs1_val==7378697629483820647 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x25, 0x6666666666666667, 0x2d, x1, 1328, x2)

inst_445:
// rs1_val==7378697629483820647 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x6666666666666667, 0x2, x1, 1336, x2)

inst_446:
// rs1_val==7378697629483820647 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x444, 0x6666666666666667, 0x554, x1, 1344, x2)

inst_447:
// rs1_val==7378697629483820647 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x6666666666666667, 0x0, x1, 1352, x2)

inst_448:
// rs1_val==7378697629483820647 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6666666666666667, 0x4, x1, 1360, x2)

inst_449:
// rs1_val==7378697629483820647 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x222, 0x6666666666666667, 0x332, x1, 1368, x2)

inst_450:
// rs1_val==7378697629483820647 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x665, 0x6666666666666667, 0x665, x1, 1376, x2)

inst_451:
// rs1_val==7378697629483820647 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0x6666666666666667, 0x2c, x1, 1384, x2)

inst_452:
// rs1_val==7378697629483820647 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x446, 0x6666666666666667, 0x556, x1, 1392, x2)

inst_453:
// rs1_val==7378697629483820647 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x6666666666666223, 0x6666666666666667, -0x555, x1, 1400, x2)

inst_454:
// rs1_val==7378697629483820647 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, 0x6666666666666667, 0x6, x1, 1408, x2)

inst_455:
// rs1_val==7378697629483820647 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x224, 0x6666666666666667, 0x334, x1, 1416, x2)

inst_456:
// rs1_val==7378697629483820647 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x667, 0x6666666666666667, 0x667, x1, 1424, x2)

inst_457:
// rs1_val==7378697629483820647 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x6666666666666644, 0x6666666666666667, -0x2c, x1, 1432, x2)

inst_458:
// rs1_val==7378697629483820647 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x26, 0x6666666666666667, 0x2e, x1, 1440, x2)

inst_459:
// rs1_val==-3037000498 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, -0xb504f332, 0x3, x1, 1448, x2)

inst_460:
// rs1_val==-3037000498 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x444, -0xb504f332, 0x555, x1, 1456, x2)

inst_461:
// rs1_val==-3037000498 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xffffffff4afb088a, -0xb504f332, -0x556, x1, 1464, x2)

inst_462:
// rs1_val==-3037000498 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504f332, 0x5, x1, 1472, x2)

inst_463:
// rs1_val==-3037000498 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x2, -0xb504f332, 0x333, x1, 1480, x2)

inst_464:
// rs1_val==-3037000498 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x446, -0xb504f332, 0x666, x1, 1488, x2)

inst_465:
// rs1_val==-3037000498 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xffffffff4afb0cc2, -0xb504f332, -0x2d, x1, 1496, x2)

inst_466:
// rs1_val==-3037000498 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0xc, -0xb504f332, 0x2d, x1, 1504, x2)

inst_467:
// rs1_val==-3037000498 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, -0xb504f332, 0x2, x1, 1512, x2)

inst_468:
// rs1_val==-3037000498 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x444, -0xb504f332, 0x554, x1, 1520, x2)

inst_469:
// rs1_val==-3037000498 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, -0xb504f332, 0x0, x1, 1528, x2)

inst_470:
// rs1_val==-3037000498 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504f332, 0x4, x1, 1536, x2)

inst_471:
// rs1_val==-3037000498 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x2, -0xb504f332, 0x332, x1, 1544, x2)

inst_472:
// rs1_val==-3037000498 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x444, -0xb504f332, 0x665, x1, 1552, x2)

inst_473:
// rs1_val==-3037000498 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0xc, -0xb504f332, 0x2c, x1, 1560, x2)

inst_474:
// rs1_val==-3037000498 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x446, -0xb504f332, 0x556, x1, 1568, x2)

inst_475:
// rs1_val==-3037000498 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xffffffff4afb088a, -0xb504f332, -0x555, x1, 1576, x2)

inst_476:
// rs1_val==-3037000498 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x6, -0xb504f332, 0x6, x1, 1584, x2)

inst_477:
// rs1_val==-3037000498 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x4, -0xb504f332, 0x334, x1, 1592, x2)

inst_478:
// rs1_val==-3037000498 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x446, -0xb504f332, 0x667, x1, 1600, x2)

inst_479:
// rs1_val==-3037000498 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xffffffff4afb0cc4, -0xb504f332, -0x2c, x1, 1608, x2)

inst_480:
// rs1_val==-3037000498 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0xe, -0xb504f332, 0x2e, x1, 1616, x2)

inst_481:
// rs1_val==3037000500 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504f334, 0x3, x1, 1624, x2)

inst_482:
// rs1_val==3037000500 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xb504f220, 0xb504f334, -0x556, x1, 1632, x2)

inst_483:
// rs1_val==3037000500 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504f334, 0x5, x1, 1640, x2)

inst_484:
// rs1_val==3037000500 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x330, 0xb504f334, 0x333, x1, 1648, x2)

inst_485:
// rs1_val==3037000500 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x224, 0xb504f334, 0x666, x1, 1656, x2)

inst_486:
// rs1_val==3037000500 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xb504f310, 0xb504f334, -0x2d, x1, 1664, x2)

inst_487:
// rs1_val==3037000500 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x24, 0xb504f334, 0x2d, x1, 1672, x2)

inst_488:
// rs1_val==3037000500 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504f334, 0x2, x1, 1680, x2)

inst_489:
// rs1_val==3037000500 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x114, 0xb504f334, 0x554, x1, 1688, x2)

inst_490:
// rs1_val==3037000500 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504f334, 0x0, x1, 1696, x2)

inst_491:
// rs1_val==3037000500 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504f334, 0x4, x1, 1704, x2)

inst_492:
// rs1_val==3037000500 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x330, 0xb504f334, 0x332, x1, 1712, x2)

inst_493:
// rs1_val==3037000500 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x224, 0xb504f334, 0x665, x1, 1720, x2)

inst_494:
// rs1_val==3037000500 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0xb504f334, 0x2c, x1, 1728, x2)

inst_495:
// rs1_val==3037000500 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x114, 0xb504f334, 0x556, x1, 1736, x2)

inst_496:
// rs1_val==3037000500 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xb504f220, 0xb504f334, -0x555, x1, 1744, x2)

inst_497:
// rs1_val==3037000500 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0xb504f334, 0x6, x1, 1752, x2)

inst_498:
// rs1_val==3037000500 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x334, 0xb504f334, 0x334, x1, 1760, x2)

inst_499:
// rs1_val==3037000500 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x224, 0xb504f334, 0x667, x1, 1768, x2)

inst_500:
// rs1_val==3037000500 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xb504f314, 0xb504f334, -0x2c, x1, 1776, x2)

inst_501:
// rs1_val==0 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, -0x2d, x1, 1784, x2)

inst_502:
// rs1_val==3037000500 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x24, 0xb504f334, 0x2e, x1, 1792, x2)

inst_503:
// rs1_val==0 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x2, x1, 1800, x2)

inst_504:
// rs1_val==0 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x554, x1, 1808, x2)

inst_505:
// rs1_val==0 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x4, x1, 1816, x2)

inst_506:
// rs1_val==0 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x332, x1, 1824, x2)

inst_507:
// rs1_val==0 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x665, x1, 1832, x2)

inst_508:
// rs1_val==0 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x2c, x1, 1840, x2)

inst_509:
// rs1_val==0 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x556, x1, 1848, x2)

inst_510:
// rs1_val==0 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, -0x555, x1, 1856, x2)

inst_511:
// rs1_val==0 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x6, x1, 1864, x2)

inst_512:
// rs1_val==0 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x334, x1, 1872, x2)

inst_513:
// rs1_val==0 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x667, x1, 1880, x2)

inst_514:
// rs1_val==0 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, -0x2c, x1, 1888, x2)

inst_515:
// rs1_val==0 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x0, 0x0, 0x2e, x1, 1896, x2)

inst_516:
// rs1_val==4 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x3, x1, 1904, x2)

inst_517:
// rs1_val==4 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x555, x1, 1912, x2)

inst_518:
// rs1_val==4 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, -0x556, x1, 1920, x2)

inst_519:
// rs1_val==4 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x5, x1, 1928, x2)

inst_520:
// rs1_val==4 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x333, x1, 1936, x2)

inst_521:
// rs1_val==4 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x666, x1, 1944, x2)

inst_522:
// rs1_val==4 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, -0x2d, x1, 1952, x2)

inst_523:
// rs1_val==4 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x2d, x1, 1960, x2)

inst_524:
// rs1_val==4 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x2, x1, 1968, x2)

inst_525:
// rs1_val==4 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x554, x1, 1976, x2)

inst_526:
// rs1_val==4 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x0, x1, 1984, x2)

inst_527:
// rs1_val==4 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x4, x1, 1992, x2)

inst_528:
// rs1_val==4 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, 0x332, x1, 2000, x2)

inst_529:
// rs1_val==4 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x665, x1, 2008, x2)

inst_530:
// rs1_val==4 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x2c, x1, 2016, x2)

inst_531:
// rs1_val==4 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x556, x1, 2024, x2)

inst_532:
// rs1_val==4 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x0, 0x4, -0x555, x1, 2032, x2)

inst_533:
// rs1_val==4 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x6, x1, 2040, x2)
RVTEST_SIGBASE( x1,signature_x1_2)

inst_534:
// rs1_val==4 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x334, x1, 0, x2)

inst_535:
// rs1_val==4 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x667, x1, 8, x2)

inst_536:
// rs1_val==4 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, -0x2c, x1, 16, x2)

inst_537:
// rs1_val==4 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x4, 0x4, 0x2e, x1, 24, x2)

inst_538:
// rs1_val==3689348814741910322 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3333333333333332, 0x3, x1, 32, x2)

inst_539:
// rs1_val==3689348814741910322 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x110, 0x3333333333333332, 0x555, x1, 40, x2)

inst_540:
// rs1_val==3689348814741910322 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x3333333333333222, 0x3333333333333332, -0x556, x1, 48, x2)

inst_541:
// rs1_val==3689348814741910322 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3333333333333332, 0x5, x1, 56, x2)

inst_542:
// rs1_val==3689348814741910322 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x332, 0x3333333333333332, 0x333, x1, 64, x2)

inst_543:
// rs1_val==3689348814741910322 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, 0x3333333333333332, 0x666, x1, 72, x2)

inst_544:
// rs1_val==3689348814741910322 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x3333333333333312, 0x3333333333333332, -0x2d, x1, 80, x2)

inst_545:
// rs1_val==3689348814741910322 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x20, 0x3333333333333332, 0x2d, x1, 88, x2)

inst_546:
// rs1_val==3689348814741910322 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3333333333333332, 0x2, x1, 96, x2)

inst_547:
// rs1_val==3689348814741910322 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x110, 0x3333333333333332, 0x554, x1, 104, x2)

inst_548:
// rs1_val==3689348814741910322 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3333333333333332, 0x0, x1, 112, x2)

inst_549:
// rs1_val==3689348814741910322 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0x3333333333333332, 0x4, x1, 120, x2)

inst_550:
// rs1_val==3689348814741910322 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x332, 0x3333333333333332, 0x332, x1, 128, x2)

inst_551:
// rs1_val==3689348814741910322 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x220, 0x3333333333333332, 0x665, x1, 136, x2)

inst_552:
// rs1_val==3689348814741910322 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x20, 0x3333333333333332, 0x2c, x1, 144, x2)

inst_553:
// rs1_val==3689348814741910322 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x112, 0x3333333333333332, 0x556, x1, 152, x2)

inst_554:
// rs1_val==3689348814741910322 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x3333333333333222, 0x3333333333333332, -0x555, x1, 160, x2)

inst_555:
// rs1_val==3689348814741910322 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0x3333333333333332, 0x6, x1, 168, x2)

inst_556:
// rs1_val==3689348814741910322 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x330, 0x3333333333333332, 0x334, x1, 176, x2)

inst_557:
// rs1_val==3689348814741910322 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x222, 0x3333333333333332, 0x667, x1, 184, x2)

inst_558:
// rs1_val==3689348814741910322 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x3333333333333310, 0x3333333333333332, -0x2c, x1, 192, x2)

inst_559:
// rs1_val==3689348814741910322 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x22, 0x3333333333333332, 0x2e, x1, 200, x2)

inst_560:
// rs1_val==7378697629483820645 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x1, 0x6666666666666665, 0x3, x1, 208, x2)

inst_561:
// rs1_val==7378697629483820645 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x445, 0x6666666666666665, 0x555, x1, 216, x2)

inst_562:
// rs1_val==7378697629483820645 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x6666666666666220, 0x6666666666666665, -0x556, x1, 224, x2)

inst_563:
// rs1_val==7378697629483820645 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x5, 0x6666666666666665, 0x5, x1, 232, x2)

inst_564:
// rs1_val==7378697629483820645 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x221, 0x6666666666666665, 0x333, x1, 240, x2)

inst_565:
// rs1_val==7378697629483820645 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x664, 0x6666666666666665, 0x666, x1, 248, x2)

inst_566:
// rs1_val==7378697629483820645 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x6666666666666641, 0x6666666666666665, -0x2d, x1, 256, x2)

inst_567:
// rs1_val==7378697629483820645 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x25, 0x6666666666666665, 0x2d, x1, 264, x2)

inst_568:
// rs1_val==7378697629483820645 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x0, 0x6666666666666665, 0x2, x1, 272, x2)

inst_569:
// rs1_val==7378697629483820645 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x444, 0x6666666666666665, 0x554, x1, 280, x2)

inst_570:
// rs1_val==7378697629483820645 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x6666666666666665, 0x0, x1, 288, x2)

inst_571:
// rs1_val==7378697629483820645 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6666666666666665, 0x4, x1, 296, x2)

inst_572:
// rs1_val==7378697629483820645 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x220, 0x6666666666666665, 0x332, x1, 304, x2)

inst_573:
// rs1_val==7378697629483820645 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x665, 0x6666666666666665, 0x665, x1, 312, x2)

inst_574:
// rs1_val==7378697629483820645 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x24, 0x6666666666666665, 0x2c, x1, 320, x2)

inst_575:
// rs1_val==7378697629483820645 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x444, 0x6666666666666665, 0x556, x1, 328, x2)

inst_576:
// rs1_val==7378697629483820645 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0x6666666666666221, 0x6666666666666665, -0x555, x1, 336, x2)

inst_577:
// rs1_val==7378697629483820645 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x4, 0x6666666666666665, 0x6, x1, 344, x2)

inst_578:
// rs1_val==7378697629483820645 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x224, 0x6666666666666665, 0x334, x1, 352, x2)

inst_579:
// rs1_val==7378697629483820645 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x665, 0x6666666666666665, 0x667, x1, 360, x2)

inst_580:
// rs1_val==7378697629483820645 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0x6666666666666644, 0x6666666666666665, -0x2c, x1, 368, x2)

inst_581:
// rs1_val==7378697629483820645 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x24, 0x6666666666666665, 0x2e, x1, 376, x2)

inst_582:
// rs1_val==3037000498 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0xb504f332, 0x3, x1, 384, x2)

inst_583:
// rs1_val==3037000498 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x110, 0xb504f332, 0x555, x1, 392, x2)

inst_584:
// rs1_val==3037000498 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0xb504f222, 0xb504f332, -0x556, x1, 400, x2)

inst_585:
// rs1_val==3037000498 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504f332, 0x5, x1, 408, x2)

inst_586:
// rs1_val==3037000498 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x332, 0xb504f332, 0x333, x1, 416, x2)

inst_587:
// rs1_val==3037000498 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x222, 0xb504f332, 0x666, x1, 424, x2)

inst_588:
// rs1_val==3037000498 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0xb504f312, 0xb504f332, -0x2d, x1, 432, x2)

inst_589:
// rs1_val==3037000498 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x20, 0xb504f332, 0x2d, x1, 440, x2)

inst_590:
// rs1_val==3037000498 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0xb504f332, 0x2, x1, 448, x2)

inst_591:
// rs1_val==3037000498 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x110, 0xb504f332, 0x554, x1, 456, x2)

inst_592:
// rs1_val==3037000498 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504f332, 0x0, x1, 464, x2)

inst_593:
// rs1_val==3037000498 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x0, 0xb504f332, 0x4, x1, 472, x2)

inst_594:
// rs1_val==3037000498 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x332, 0xb504f332, 0x332, x1, 480, x2)

inst_595:
// rs1_val==3037000498 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x220, 0xb504f332, 0x665, x1, 488, x2)

inst_596:
// rs1_val==3037000498 and imm_val==44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2c
TEST_IMM_OP( andi, x11, x10, 0x20, 0xb504f332, 0x2c, x1, 496, x2)

inst_597:
// rs1_val==3037000498 and imm_val==1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x556
TEST_IMM_OP( andi, x11, x10, 0x112, 0xb504f332, 0x556, x1, 504, x2)

inst_598:
// rs1_val==3037000498 and imm_val==-1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x555
TEST_IMM_OP( andi, x11, x10, 0xb504f222, 0xb504f332, -0x555, x1, 512, x2)

inst_599:
// rs1_val==3037000498 and imm_val==6, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x6
TEST_IMM_OP( andi, x11, x10, 0x2, 0xb504f332, 0x6, x1, 520, x2)

inst_600:
// rs1_val==3037000498 and imm_val==820, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x334
TEST_IMM_OP( andi, x11, x10, 0x330, 0xb504f332, 0x334, x1, 528, x2)

inst_601:
// rs1_val==3037000498 and imm_val==1639, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x667
TEST_IMM_OP( andi, x11, x10, 0x222, 0xb504f332, 0x667, x1, 536, x2)

inst_602:
// rs1_val==3037000498 and imm_val==-44, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2c
TEST_IMM_OP( andi, x11, x10, 0xb504f310, 0xb504f332, -0x2c, x1, 544, x2)

inst_603:
// rs1_val==3037000498 and imm_val==46, 
// opcode: andi ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2e
TEST_IMM_OP( andi, x11, x10, 0x22, 0xb504f332, 0x2e, x1, 552, x2)

inst_604:
// rs1_val==6148914691236517206 and imm_val==3, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x3
TEST_IMM_OP( andi, x11, x10, 0x2, 0x5555555555555556, 0x3, x1, 560, x2)

inst_605:
// rs1_val==6148914691236517206 and imm_val==1365, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x555
TEST_IMM_OP( andi, x11, x10, 0x554, 0x5555555555555556, 0x555, x1, 568, x2)

inst_606:
// rs1_val==6148914691236517206 and imm_val==-1366, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x556
TEST_IMM_OP( andi, x11, x10, 0x5555555555555002, 0x5555555555555556, -0x556, x1, 576, x2)

inst_607:
// rs1_val==6148914691236517206 and imm_val==5, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x5
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555556, 0x5, x1, 584, x2)

inst_608:
// rs1_val==6148914691236517206 and imm_val==819, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x333
TEST_IMM_OP( andi, x11, x10, 0x112, 0x5555555555555556, 0x333, x1, 592, x2)

inst_609:
// rs1_val==6148914691236517206 and imm_val==1638, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x666
TEST_IMM_OP( andi, x11, x10, 0x446, 0x5555555555555556, 0x666, x1, 600, x2)

inst_610:
// rs1_val==6148914691236517206 and imm_val==-45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( andi, x11, x10, 0x5555555555555552, 0x5555555555555556, -0x2d, x1, 608, x2)

inst_611:
// rs1_val==6148914691236517206 and imm_val==45, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2d
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555556, 0x2d, x1, 616, x2)

inst_612:
// rs1_val==6148914691236517206 and imm_val==2, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2
TEST_IMM_OP( andi, x11, x10, 0x2, 0x5555555555555556, 0x2, x1, 624, x2)

inst_613:
// rs1_val==6148914691236517206 and imm_val==1364, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x554
TEST_IMM_OP( andi, x11, x10, 0x554, 0x5555555555555556, 0x554, x1, 632, x2)

inst_614:
// rs1_val==6148914691236517206 and imm_val==0, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x0
TEST_IMM_OP( andi, x11, x10, 0x0, 0x5555555555555556, 0x0, x1, 640, x2)

inst_615:
// rs1_val==6148914691236517206 and imm_val==4, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x4
TEST_IMM_OP( andi, x11, x10, 0x4, 0x5555555555555556, 0x4, x1, 648, x2)

inst_616:
// rs1_val==6148914691236517206 and imm_val==818, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x332
TEST_IMM_OP( andi, x11, x10, 0x112, 0x5555555555555556, 0x332, x1, 656, x2)

inst_617:
// rs1_val==6148914691236517206 and imm_val==1637, 
// opcode: andi ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x665
TEST_IMM_OP( andi, x11, x10, 0x444, 0x5555555555555556, 0x665, x1, 664, x2)

inst_618:
// imm_val == -513, rs1_val == -262145
// opcode: andi ; op1:x10; dest:x11; op1val:-0x40001;  immval:-0x201
TEST_IMM_OP( andi, x11, x10, 0xfffffffffffbfdff, -0x40001, -0x201, x1, 672, x2)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x5_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x5_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x1_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_2:
    .fill 85*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
