
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the bgeu instruction of the RISC-V I extension for the bgeu covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",bgeu)

RVTEST_SIGBASE( x6,signature_x6_1)

inst_0:
// rs1 != rs2, rs1==x9, rs2==x29, rs1_val > 0 and rs2_val > 0, rs1_val > 0 and rs2_val > 0 and rs1_val < rs2_val and imm_val < 0 , rs2_val == 18446744073709551359
// opcode: bgeu, op1:x9; op2:x29; op1val:0x6666666666666665; op2val:0xfffffffffffffeff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x10, x9, x29, 0x6666666666666665, 0xfffffffffffffeff, 0x556, 1b, x6, 0,0)

inst_1:
// rs1 == rs2, rs1==x31, rs2==x31, rs1_val > 0 and rs2_val > 0 and rs1_val == rs2_val and imm_val > 0, 
// opcode: bgeu, op1:x31; op2:x31; op1val:0xb; op2val:0xb; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x10, x31, x31, 0xb, 0xb, 0x200, 3f, x6, 8,0)

inst_2:
// rs1==x15, rs2==x24, rs1_val > 0 and rs2_val > 0 and rs1_val == rs2_val and imm_val < 0, rs1_val==3689348814741910323 and rs2_val==3689348814741910323
// opcode: bgeu, op1:x15; op2:x24; op1val:0x3333333333333333; op2val:0x3333333333333333; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x10, x15, x24, 0x3333333333333333, 0x3333333333333333, 0x2, 1b, x6, 16,0)

inst_3:
// rs1==x29, rs2==x30, rs1_val > 0 and rs2_val > 0 and rs1_val > rs2_val and imm_val > 0 , rs1_val == 18446744073709535231, rs2_val == 18446462598732840959
// opcode: bgeu, op1:x29; op2:x30; op1val:0xffffffffffffbfff; op2val:0xfffeffffffffffff; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x10, x29, x30, 0xffffffffffffbfff, 0xfffeffffffffffff, 0x80, 3f, x6, 24,0)

inst_4:
// rs1==x8, rs2==x19, rs1_val > 0 and rs2_val > 0 and rs1_val > rs2_val and imm_val < 0 , rs1_val == 18446743523953737727, rs2_val == 576460752303423488
// opcode: bgeu, op1:x8; op2:x19; op1val:0xffffff7fffffffff; op2val:0x800000000000000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x10, x8, x19, 0xffffff7fffffffff, 0x800000000000000, 0x4, 1b, x6, 32,0)

inst_5:
// rs1==x26, rs2==x7, rs1_val > 0 and rs2_val > 0 and rs1_val < rs2_val and imm_val > 0 , rs1_val == 1, rs2_val == 17592186044416
// opcode: bgeu, op1:x26; op2:x7; op1val:0x1; op2val:0x100000000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x10, x26, x7, 0x1, 0x100000000000, 0x6, 3f, x6, 40,0)

inst_6:
// rs1==x16, rs2==x0, rs2_val == 1, rs1_val == 18446744073705357311
// opcode: bgeu, op1:x16; op2:x0; op1val:0xffffffffffbfffff; op2val:0x0; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x10, x16, x0, 0xffffffffffbfffff, 0x0, 0x556, 1b, x6, 48,0)

inst_7:
// rs1==x1, rs2==x26, rs2_val == 2, rs1_val == 68719476736
// opcode: bgeu, op1:x1; op2:x26; op1val:0x1000000000; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x10, x1, x26, 0x1000000000, 0x2, 0x400, 3f, x6, 56,0)

inst_8:
// rs1==x4, rs2==x9, rs2_val == 4, rs1_val == 18446744073709549567
// opcode: bgeu, op1:x4; op2:x9; op1val:0xfffffffffffff7ff; op2val:0x4; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x10, x4, x9, 0xfffffffffffff7ff, 0x4, 0x0, 1b, x6, 64,0)

inst_9:
// rs1==x14, rs2==x5, rs2_val == 8, rs1_val == 8589934592
// opcode: bgeu, op1:x14; op2:x5; op1val:0x200000000; op2val:0x8; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x10, x14, x5, 0x200000000, 0x8, 0x100, 3f, x6, 72,0)

inst_10:
// rs1==x17, rs2==x8, rs2_val == 16, rs1_val == 17179869184
// opcode: bgeu, op1:x17; op2:x8; op1val:0x400000000; op2val:0x10; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x10, x17, x8, 0x400000000, 0x10, 0x20, 3f, x6, 80,0)

inst_11:
// rs1==x28, rs2==x15, rs2_val == 32, 
// opcode: bgeu, op1:x28; op2:x15; op1val:0x0; op2val:0x20; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x10, x28, x15, 0x0, 0x20, 0x2, 3f, x6, 88,0)

inst_12:
// rs1==x7, rs2==x16, rs2_val == 64, rs1_val == 36028797018963968
// opcode: bgeu, op1:x7; op2:x16; op1val:0x80000000000000; op2val:0x40; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x10, x7, x16, 0x80000000000000, 0x40, 0x20, 3f, x6, 96,0)

inst_13:
// rs1==x27, rs2==x17, rs2_val == 128, rs1_val == 1048576
// opcode: bgeu, op1:x27; op2:x17; op1val:0x100000; op2val:0x80; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x10, x27, x17, 0x100000, 0x80, 0x200, 3f, x6, 104,0)

inst_14:
// rs1==x20, rs2==x18, rs2_val == 256, rs1_val == 18444492273895866367
// opcode: bgeu, op1:x20; op2:x18; op1val:0xfff7ffffffffffff; op2val:0x100; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x10, x20, x18, 0xfff7ffffffffffff, 0x100, 0x20, 3f, x6, 112,0)

inst_15:
// rs1==x11, rs2==x2, rs2_val == 512, 
// opcode: bgeu, op1:x11; op2:x2; op1val:0x80000000000000; op2val:0x200; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x10, x11, x2, 0x80000000000000, 0x200, 0x2, 3f, x6, 120,0)

inst_16:
// rs1==x21, rs2==x25, rs2_val == 1024, rs1_val == 18437736874454810623
// opcode: bgeu, op1:x21; op2:x25; op1val:0xffdfffffffffffff; op2val:0x400; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x10, x21, x25, 0xffdfffffffffffff, 0x400, 0x40, 3f, x6, 128,0)

inst_17:
// rs1==x3, rs2==x28, rs2_val == 2048, 
// opcode: bgeu, op1:x3; op2:x28; op1val:0x1000000000; op2val:0x800; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x10, x3, x28, 0x1000000000, 0x800, 0x6, 1b, x6, 136,0)

inst_18:
// rs1==x18, rs2==x20, rs2_val == 4096, rs1_val == 18446744073709420543
// opcode: bgeu, op1:x18; op2:x20; op1val:0xfffffffffffdffff; op2val:0x1000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x10, x18, x20, 0xfffffffffffdffff, 0x1000, 0x8, 1b, x6, 144,0)

inst_19:
// rs1==x13, rs2==x14, rs2_val == 8192, rs1_val == 70368744177664
// opcode: bgeu, op1:x13; op2:x14; op1val:0x400000000000; op2val:0x2000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x10, x13, x14, 0x400000000000, 0x2000, 0x4, 3f, x6, 152,0)

inst_20:
// rs1==x0, rs2==x12, rs2_val == 16384, 
// opcode: bgeu, op1:x0; op2:x12; op1val:0x0; op2val:0x4000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x10, x0, x12, 0x0, 0x4000, 0x6, 3f, x6, 160,0)

inst_21:
// rs1==x19, rs2==x23, rs2_val == 32768, rs1_val == 4096
// opcode: bgeu, op1:x19; op2:x23; op1val:0x1000; op2val:0x8000; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x19, x23, 0x1000, 0x8000, 0x80, 3f, x6, 168,0)
RVTEST_SIGBASE( x7,signature_x7_0)

inst_22:
// rs1==x24, rs2==x27, rs2_val == 65536, 
// opcode: bgeu, op1:x24; op2:x27; op1val:0xfffffffffffff7ff; op2val:0x10000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x24, x27, 0xfffffffffffff7ff, 0x10000, 0x0, 1b, x7, 0,0)

inst_23:
// rs1==x30, rs2==x3, rs2_val == 131072, rs1_val == 536870912
// opcode: bgeu, op1:x30; op2:x3; op1val:0x20000000; op2val:0x20000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x30, x3, 0x20000000, 0x20000, 0x4, 3f, x7, 8,0)

inst_24:
// rs1==x22, rs2==x11, rs2_val == 262144, 
// opcode: bgeu, op1:x22; op2:x11; op1val:0x13; op2val:0x40000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x22, x11, 0x13, 0x40000, 0x10, 3f, x7, 16,0)

inst_25:
// rs1==x6, rs2==x21, rs2_val == 524288, rs1_val == 18446744056529682431
// opcode: bgeu, op1:x6; op2:x21; op1val:0xfffffffbffffffff; op2val:0x80000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x6, x21, 0xfffffffbffffffff, 0x80000, 0x8, 1b, x7, 24,0)

inst_26:
// rs1==x5, rs2==x13, rs2_val == 1048576, 
// opcode: bgeu, op1:x5; op2:x13; op1val:0xffffffffffbfffff; op2val:0x100000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x5, x13, 0xffffffffffbfffff, 0x100000, 0x400, 1b, x7, 32,0)

inst_27:
// rs1==x23, rs2==x22, rs2_val == 2097152, rs1_val == 18446708889337462783
// opcode: bgeu, op1:x23; op2:x22; op1val:0xffffdfffffffffff; op2val:0x200000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x23, x22, 0xffffdfffffffffff, 0x200000, 0x8, 3f, x7, 40,0)

inst_28:
// rs1==x10, rs2==x4, rs2_val == 4194304, rs1_val == 18446741874686296063
// opcode: bgeu, op1:x10; op2:x4; op1val:0xfffffdffffffffff; op2val:0x400000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x4, 0xfffffdffffffffff, 0x400000, 0x10, 3f, x7, 48,0)

inst_29:
// rs1==x12, rs2==x10, rs2_val == 8388608, rs1_val == 262144
// opcode: bgeu, op1:x12; op2:x10; op1val:0x40000; op2val:0x800000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x12, x10, 0x40000, 0x800000, 0x2, 1b, x7, 56,0)

inst_30:
// rs1==x2, rs2==x6, rs2_val == 16777216, rs1_val == 18446744073709543423
// opcode: bgeu, op1:x2; op2:x6; op1val:0xffffffffffffdfff; op2val:0x1000000; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x2, x6, 0xffffffffffffdfff, 0x1000000, 0x100, 3f, x7, 64,0)

inst_31:
// rs1==x25, rs2==x1, rs2_val == 33554432, 
// opcode: bgeu, op1:x25; op2:x1; op1val:0xf; op2val:0x2000000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x25, x1, 0xf, 0x2000000, 0x556, 1b, x7, 72,0)

inst_32:
// rs2_val == 67108864, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x4000000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x4000000, 0x4, 3f, x7, 80,0)

inst_33:
// rs2_val == 134217728, rs1_val == 6148914691236517205
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x8000000; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x8000000, 0x20, 3f, x7, 88,0)

inst_34:
// rs2_val == 268435456, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x10000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x10000000, 0x400, 1b, x7, 96,0)

inst_35:
// rs2_val == 536870912, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400000000000; op2val:0x20000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x400000000000, 0x20000000, 0x400, 1b, x7, 104,0)

inst_36:
// rs2_val == 1073741824, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x40000000; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x40000000, 0xa, 1b, x7, 112,0)

inst_37:
// rs2_val == 2147483648, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x7; op2val:0x80000000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x7, 0x80000000, 0x4, 1b, x7, 120,0)

inst_38:
// rs2_val == 4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffbfffff; op2val:0x100000000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffbfffff, 0x100000000, 0x10, 3f, x7, 128,0)

inst_39:
// rs2_val == 8589934592, rs1_val == 18446462598732840959
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffeffffffffffff; op2val:0x200000000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffeffffffffffff, 0x200000000, 0x2, 1b, x7, 136,0)

inst_40:
// rs2_val == 17179869184, rs1_val == 35184372088832
// opcode: bgeu, op1:x10; op2:x11; op1val:0x200000000000; op2val:0x400000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x200000000000, 0x400000000, 0x400, 3f, x7, 144,0)

inst_41:
// rs2_val == 34359738368, rs1_val == 18446673704965373951
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffbfffffffffff; op2val:0x800000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffbfffffffffff, 0x800000000, 0x6, 3f, x7, 152,0)

inst_42:
// rs2_val == 68719476736, rs1_val == 137438953472
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000000000; op2val:0x1000000000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2000000000, 0x1000000000, 0x556, 1b, x7, 160,0)

inst_43:
// rs2_val == 137438953472, rs1_val == 288230376151711744
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400000000000000; op2val:0x2000000000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x400000000000000, 0x2000000000, 0x2, 3f, x7, 168,0)

inst_44:
// rs2_val == 274877906944, rs1_val == 18446744073441116159
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffefffffff; op2val:0x4000000000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffefffffff, 0x4000000000, 0x2, 1b, x7, 176,0)

inst_45:
// rs2_val == 549755813888, rs1_val == 18446744073709551551
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffffffbf; op2val:0x8000000000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffffffbf, 0x8000000000, 0x0, 3f, x7, 184,0)

inst_46:
// rs2_val == 1099511627776, rs1_val == 18446744073642442751
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffbffffff; op2val:0x10000000000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffbffffff, 0x10000000000, 0x2, 3f, x7, 192,0)

inst_47:
// rs2_val == 2199023255552, rs1_val == 12297829382473034410
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x20000000000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x20000000000, 0x10, 3f, x7, 200,0)

inst_48:
// rs2_val == 4398046511104, rs1_val == 134217728
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8000000; op2val:0x40000000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x8000000, 0x40000000000, 0x200, 3f, x7, 208,0)

inst_49:
// rs2_val == 8796093022208, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1000; op2val:0x80000000000; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1000, 0x80000000000, 0x80, 3f, x7, 216,0)

inst_50:
// rs2_val == 35184372088832, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400000000000000; op2val:0x200000000000; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x400000000000000, 0x200000000000, 0x40, 3f, x7, 224,0)

inst_51:
// rs2_val == 70368744177664, rs1_val == 4294967296
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x400000000000; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x400000000000, 0x100, 3f, x7, 232,0)

inst_52:
// rs2_val == 140737488355328, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x800000000000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x800000000000, 0x0, 3f, x7, 240,0)

inst_53:
// rs2_val == 281474976710656, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x9; op2val:0x1000000000000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x9, 0x1000000000000, 0x10, 3f, x7, 248,0)

inst_54:
// rs2_val == 562949953421312, rs1_val == 17870283321406128127
// opcode: bgeu, op1:x10; op2:x11; op1val:0xf7ffffffffffffff; op2val:0x2000000000000; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xf7ffffffffffffff, 0x2000000000000, 0xa, 1b, x7, 256,0)

inst_55:
// rs2_val == 1125899906842624, rs1_val == 9223372036854775807
// opcode: bgeu, op1:x10; op2:x11; op1val:0x7fffffffffffffff; op2val:0x4000000000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x7fffffffffffffff, 0x4000000000000, 0x6, 1b, x7, 264,0)

inst_56:
// rs2_val == 2251799813685248, rs1_val == 4503599627370496
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000000000000; op2val:0x8000000000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x10000000000000, 0x8000000000000, 0x400, 3f, x7, 272,0)

inst_57:
// rs2_val == 4503599627370496, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000000000; op2val:0x10000000000000; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2000000000, 0x10000000000000, 0x40, 3f, x7, 280,0)

inst_58:
// rs2_val == 9007199254740992, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x20000000000000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x20000000000000, 0x8, 1b, x7, 288,0)

inst_59:
// rs2_val == 18014398509481984, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffdfffffffffff; op2val:0x40000000000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffdfffffffffff, 0x40000000000000, 0x200, 3f, x7, 296,0)

inst_60:
// rs2_val == 36028797018963968, rs1_val == 18446744073709027327
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffff7ffff; op2val:0x80000000000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffff7ffff, 0x80000000000000, 0x6, 1b, x7, 304,0)

inst_61:
// rs2_val == 72057594037927936, rs1_val == 18446744073709551613
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffffffd; op2val:0x100000000000000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffffffd, 0x100000000000000, 0x556, 1b, x7, 312,0)

inst_62:
// rs2_val == 144115188075855872, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x200000000000000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x200000000000000, 0x8, 1b, x7, 320,0)

inst_63:
// rs2_val == 288230376151711744, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400000000000000; op2val:0x400000000000000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x400000000000000, 0x400000000000000, 0x10, 3f, x7, 328,0)

inst_64:
// rs2_val == 1152921504606846976, rs1_val == 4611686018427387904
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000000000000000; op2val:0x1000000000000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4000000000000000, 0x1000000000000000, 0x400, 3f, x7, 336,0)

inst_65:
// rs2_val == 2305843009213693952, rs1_val == 18446603336221196287
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffff7fffffffffff; op2val:0x2000000000000000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffff7fffffffffff, 0x2000000000000000, 0x556, 1b, x7, 344,0)

inst_66:
// rs2_val == 4611686018427387904, rs1_val == 18446742974197923839
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffeffffffffff; op2val:0x4000000000000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffeffffffffff, 0x4000000000000000, 0x6, 3f, x7, 352,0)

inst_67:
// rs2_val == 9223372036854775808, rs1_val == 1125899906842624
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000000000000; op2val:0x8000000000000000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4000000000000, 0x8000000000000000, 0x0, 1b, x7, 360,0)

inst_68:
// rs2_val == 18446744073709551614, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000000000; op2val:0xfffffffffffffffe; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2000000000, 0xfffffffffffffffe, 0x10, 3f, x7, 368,0)

inst_69:
// rs2_val == 18446744073709551613, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400000000000000; op2val:0xfffffffffffffffd; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x400000000000000, 0xfffffffffffffffd, 0x8, 3f, x7, 376,0)

inst_70:
// rs2_val == 18446744073709551611, rs1_val == 18446744073575333887
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffff7ffffff; op2val:0xfffffffffffffffb; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffff7ffffff, 0xfffffffffffffffb, 0x20, 3f, x7, 384,0)

inst_71:
// rs2_val == 18446744073709551607, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000000000000000; op2val:0xfffffffffffffff7; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4000000000000000, 0xfffffffffffffff7, 0x2, 3f, x7, 392,0)

inst_72:
// rs2_val == 18446744073709551599, rs1_val == 1073741824
// opcode: bgeu, op1:x10; op2:x11; op1val:0x40000000; op2val:0xffffffffffffffef; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x40000000, 0xffffffffffffffef, 0x20, 3f, x7, 400,0)

inst_73:
// rs2_val == 18446744073709551583, rs1_val == 2199023255552
// opcode: bgeu, op1:x10; op2:x11; op1val:0x20000000000; op2val:0xffffffffffffffdf; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x20000000000, 0xffffffffffffffdf, 0x200, 3f, x7, 408,0)

inst_74:
// rs2_val == 18446744073709551551, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x7; op2val:0xffffffffffffffbf; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x7, 0xffffffffffffffbf, 0x556, 1b, x7, 416,0)

inst_75:
// rs2_val == 18446744073709551487, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffffbfff; op2val:0xffffffffffffff7f; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffffbfff, 0xffffffffffffff7f, 0x40, 3f, x7, 424,0)

inst_76:
// rs2_val == 18446744073709551103, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xfffffffffffffdff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xfffffffffffffdff, 0x2, 1b, x7, 432,0)

inst_77:
// rs2_val == 18446744073709550591, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xfffffffffffffbff; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0xfffffffffffffbff, 0x40, 3f, x7, 440,0)

inst_78:
// rs2_val == 18446744073709549567, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xfffffffffffff7ff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xfffffffffffff7ff, 0x0, 1b, x7, 448,0)

inst_79:
// rs2_val == 18446744073709547519, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffbffffff; op2val:0xffffffffffffefff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffbffffff, 0xffffffffffffefff, 0x0, 3f, x7, 456,0)

inst_80:
// rs2_val == 18446744073709543423, rs1_val == 18158513697557839871
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfbffffffffffffff; op2val:0xffffffffffffdfff; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfbffffffffffffff, 0xffffffffffffdfff, 0xa, 1b, x7, 464,0)

inst_81:
// rs2_val == 18446744073709535231, rs1_val == 67108864
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000000; op2val:0xffffffffffffbfff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4000000, 0xffffffffffffbfff, 0x8, 1b, x7, 472,0)

inst_82:
// rs2_val == 18446744073709518847, rs1_val == 18446744004990074879
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffefffffffff; op2val:0xffffffffffff7fff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffefffffffff, 0xffffffffffff7fff, 0x400, 3f, x7, 480,0)

inst_83:
// rs2_val == 18446744073709486079, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffdffff; op2val:0xfffffffffffeffff; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffdffff, 0xfffffffffffeffff, 0xa, 1b, x7, 488,0)

inst_84:
// rs2_val == 18446744073709420543, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xf7ffffffffffffff; op2val:0xfffffffffffdffff; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xf7ffffffffffffff, 0xfffffffffffdffff, 0x20, 3f, x7, 496,0)

inst_85:
// rs2_val == 18446744073709289471, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x9; op2val:0xfffffffffffbffff; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x9, 0xfffffffffffbffff, 0x20, 3f, x7, 504,0)

inst_86:
// rs2_val == 18446744073709027327, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xfffffffffff7ffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0xfffffffffff7ffff, 0x400, 3f, x7, 512,0)

inst_87:
// rs2_val == 18446744073708503039, rs1_val == 18446744073709551599
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffffffef; op2val:0xffffffffffefffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffffffef, 0xffffffffffefffff, 0x0, 1b, x7, 520,0)

inst_88:
// rs2_val == 18446744073707454463, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xffffffffffdfffff; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xffffffffffdfffff, 0x80, 3f, x7, 528,0)

inst_89:
// rs2_val == 18446744073705357311, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffefffffff; op2val:0xffffffffffbfffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffefffffff, 0xffffffffffbfffff, 0x4, 3f, x7, 536,0)

inst_90:
// rs2_val == 18446744073701163007, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffffdfff; op2val:0xffffffffff7fffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffffdfff, 0xffffffffff7fffff, 0x4, 1b, x7, 544,0)

inst_91:
// rs2_val == 18446744073692774399, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xfffffffffeffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xfffffffffeffffff, 0x6, 1b, x7, 552,0)

inst_92:
// rs2_val == 18446744073675997183, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffdffffffffff; op2val:0xfffffffffdffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffdffffffffff, 0xfffffffffdffffff, 0x2, 3f, x7, 560,0)

inst_93:
// rs2_val == 18446744073642442751, rs1_val == 9007199254740992
// opcode: bgeu, op1:x10; op2:x11; op1val:0x20000000000000; op2val:0xfffffffffbffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x20000000000000, 0xfffffffffbffffff, 0x6, 1b, x7, 568,0)

inst_94:
// rs2_val == 18446744073575333887, rs1_val == 18446744039349813247
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffff7ffffffff; op2val:0xfffffffff7ffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffff7ffffffff, 0xfffffffff7ffffff, 0x6, 3f, x7, 576,0)

inst_95:
// rs2_val == 18446744073441116159, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x200000000000; op2val:0xffffffffefffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x200000000000, 0xffffffffefffffff, 0x0, 3f, x7, 584,0)

inst_96:
// rs2_val == 18446744073172680703, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xffffffffdfffffff; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xffffffffdfffffff, 0x40, 3f, x7, 592,0)

inst_97:
// rs2_val == 18446744072635809791, rs1_val == 18446744073709551359
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffffeff; op2val:0xffffffffbfffffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffffeff, 0xffffffffbfffffff, 0x400, 3f, x7, 600,0)

inst_98:
// rs2_val == 18446744071562067967, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffdfffffffffff; op2val:0xffffffff7fffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffdfffffffffff, 0xffffffff7fffffff, 0x0, 3f, x7, 608,0)

inst_99:
// rs2_val == 18446744069414584319, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffff7ffff; op2val:0xfffffffeffffffff; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffff7ffff, 0xfffffffeffffffff, 0x200, 3f, x7, 616,0)

inst_100:
// rs2_val == 18446744065119617023, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xfffffffdffffffff; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0xfffffffdffffffff, 0x80, 3f, x7, 624,0)

inst_101:
// rs2_val == 18446744056529682431, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1000; op2val:0xfffffffbffffffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1000, 0xfffffffbffffffff, 0x400, 3f, x7, 632,0)

inst_102:
// rs2_val == 18446744039349813247, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffff7fffffffff; op2val:0xfffffff7ffffffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffff7fffffffff, 0xfffffff7ffffffff, 0x400, 3f, x7, 640,0)

inst_103:
// rs2_val == 18446744004990074879, rs1_val == 65536
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000; op2val:0xffffffefffffffff; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x10000, 0xffffffefffffffff, 0x100, 3f, x7, 648,0)

inst_104:
// rs2_val == 18446743936270598143, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x11; op2val:0xffffffdfffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x11, 0xffffffdfffffffff, 0x0, 1b, x7, 656,0)

inst_105:
// rs2_val == 18446743798831644671, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xf7ffffffffffffff; op2val:0xffffffbfffffffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xf7ffffffffffffff, 0xffffffbfffffffff, 0x8, 3f, x7, 664,0)

inst_106:
// rs2_val == 18446743523953737727, rs1_val == 524288
// opcode: bgeu, op1:x10; op2:x11; op1val:0x80000; op2val:0xffffff7fffffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x80000, 0xffffff7fffffffff, 0x6, 1b, x7, 672,0)

inst_107:
// rs2_val == 18446742974197923839, rs1_val == 13835058055282163711
// opcode: bgeu, op1:x10; op2:x11; op1val:0xbfffffffffffffff; op2val:0xfffffeffffffffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xbfffffffffffffff, 0xfffffeffffffffff, 0x8, 1b, x7, 680,0)

inst_108:
// rs2_val == 18446741874686296063, rs1_val == 8
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8; op2val:0xfffffdffffffffff; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x8, 0xfffffdffffffffff, 0x200, 3f, x7, 688,0)

inst_109:
// rs2_val == 18446739675663040511, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xfffffbffffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0xfffffbffffffffff, 0x0, 3f, x7, 696,0)

inst_110:
// rs2_val == 18446735277616529407, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xfffff7ffffffffff; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0xfffff7ffffffffff, 0xa, 1b, x7, 704,0)

inst_111:
// rs2_val == 18446726481523507199, rs1_val == 128
// opcode: bgeu, op1:x10; op2:x11; op1val:0x80; op2val:0xffffefffffffffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x80, 0xffffefffffffffff, 0x556, 1b, x7, 712,0)

inst_112:
// rs2_val == 18446708889337462783, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xffffdfffffffffff; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xffffdfffffffffff, 0x80, 3f, x7, 720,0)

inst_113:
// rs2_val == 18446673704965373951, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffdffff; op2val:0xffffbfffffffffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffdffff, 0xffffbfffffffffff, 0x10, 3f, x7, 728,0)

inst_114:
// rs2_val == 18446603336221196287, rs1_val == 18446735277616529407
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffff7ffffffffff; op2val:0xffff7fffffffffff; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffff7ffffffffff, 0xffff7fffffffffff, 0x20, 3f, x7, 736,0)

inst_115:
// rs2_val == 18446181123756130303, rs1_val == 17592186044416
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000000; op2val:0xfffdffffffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000000, 0xfffdffffffffffff, 0x0, 3f, x7, 744,0)

inst_116:
// rs2_val == 18445618173802708991, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xfffbffffffffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xfffbffffffffffff, 0x2, 1b, x7, 752,0)

inst_117:
// rs2_val == 18444492273895866367, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xfff7ffffffffffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0xfff7ffffffffffff, 0x400, 1b, x7, 760,0)

inst_118:
// rs2_val == 18442240474082181119, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffbffffff; op2val:0xffefffffffffffff; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffbffffff, 0xffefffffffffffff, 0x20, 3f, x7, 768,0)

inst_119:
// rs2_val == 18437736874454810623, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffdffff; op2val:0xffdfffffffffffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffdffff, 0xffdfffffffffffff, 0x556, 1b, x7, 776,0)

inst_120:
// rs2_val == 18428729675200069631, rs1_val == 18374686479671623679
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfeffffffffffffff; op2val:0xffbfffffffffffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfeffffffffffffff, 0xffbfffffffffffff, 0x400, 1b, x7, 784,0)

inst_121:
// rs2_val == 18410715276690587647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb; op2val:0xff7fffffffffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb, 0xff7fffffffffffff, 0x6, 1b, x7, 792,0)

inst_122:
// rs2_val == 18374686479671623679, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffbffffffff; op2val:0xfeffffffffffffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffbffffffff, 0xfeffffffffffffff, 0x556, 1b, x7, 800,0)

inst_123:
// rs2_val == 18302628885633695743, rs1_val == 144115188075855872
// opcode: bgeu, op1:x10; op2:x11; op1val:0x200000000000000; op2val:0xfdffffffffffffff; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x200000000000000, 0xfdffffffffffffff, 0x20, 3f, x7, 808,0)

inst_124:
// rs2_val == 18158513697557839871, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffeffffffffffff; op2val:0xfbffffffffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffeffffffffffff, 0xfbffffffffffffff, 0x0, 3f, x7, 816,0)

inst_125:
// rs2_val == 17870283321406128127, rs1_val == 18302628885633695743
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfdffffffffffffff; op2val:0xf7ffffffffffffff; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfdffffffffffffff, 0xf7ffffffffffffff, 0x200, 3f, x7, 824,0)

inst_126:
// rs2_val == 17293822569102704639, rs1_val == 512
// opcode: bgeu, op1:x10; op2:x11; op1val:0x200; op2val:0xefffffffffffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x200, 0xefffffffffffffff, 0x2, 1b, x7, 832,0)

inst_127:
// rs2_val == 16140901064495857663, rs1_val == 18446181123756130303
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffdffffffffffff; op2val:0xdfffffffffffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffdffffffffffff, 0xdfffffffffffffff, 0x2, 3f, x7, 840,0)

inst_128:
// rs2_val == 13835058055282163711, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfeffffffffffffff; op2val:0xbfffffffffffffff; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfeffffffffffffff, 0xbfffffffffffffff, 0x40, 3f, x7, 848,0)

inst_129:
// rs2_val == 9223372036854775807, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffff7ffffffffff; op2val:0x7fffffffffffffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffff7ffffffffff, 0x7fffffffffffffff, 0x4, 1b, x7, 856,0)

inst_130:
// rs2_val == 6148914691236517205, rs1_val == 2147483648
// opcode: bgeu, op1:x10; op2:x11; op1val:0x80000000; op2val:0x5555555555555555; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x80000000, 0x5555555555555555, 0x556, 1b, x7, 864,0)

inst_131:
// rs2_val == 12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffffffef; op2val:0xaaaaaaaaaaaaaaaa; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffffffef, 0xaaaaaaaaaaaaaaaa, 0x200, 3f, x7, 872,0)

inst_132:
// rs1_val == 2, rs1_val==2 and rs2_val==3037000499
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xb504f333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0xb504f333, 0x6, 3f, x7, 880,0)

inst_133:
// rs1_val == 4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x100000000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x100000000000, 0x200, 3f, x7, 888,0)

inst_134:
// rs1_val == 16, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10; op2val:0x40000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x10, 0x40000, 0x6, 3f, x7, 896,0)

inst_135:
// rs1_val == 32, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x20; op2val:0xf7ffffffffffffff; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x20, 0xf7ffffffffffffff, 0x40, 3f, x7, 904,0)

inst_136:
// rs1_val == 64, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x40; op2val:0x20000000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x40, 0x20000000, 0x0, 3f, x7, 912,0)

inst_137:
// rs1_val == 256, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100; op2val:0x10000000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100, 0x10000000000, 0x200, 3f, x7, 920,0)

inst_138:
// rs1_val == 1024, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400; op2val:0x800; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x400, 0x800, 0xa, 1b, x7, 928,0)

inst_139:
// rs1_val == 2048, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x800; op2val:0xffffbfffffffffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x800, 0xffffbfffffffffff, 0x10, 3f, x7, 936,0)

inst_140:
// rs1_val == 8192, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000; op2val:0xfdffffffffffffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2000, 0xfdffffffffffffff, 0x4, 1b, x7, 944,0)

inst_141:
// rs1_val == 16384, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000; op2val:0xffffffbfffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4000, 0xffffffbfffffffff, 0x0, 1b, x7, 952,0)

inst_142:
// rs1_val == 32768, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8000; op2val:0xffffffff7fffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x8000, 0xffffffff7fffffff, 0x0, 1b, x7, 960,0)

inst_143:
// rs1_val == 131072, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x20000; op2val:0x80000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x20000, 0x80000000, 0x200, 3f, x7, 968,0)

inst_144:
// rs1_val == 2097152, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x200000; op2val:0xffffffffffefffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x200000, 0xffffffffffefffff, 0x6, 1b, x7, 976,0)

inst_145:
// rs1_val == 4194304, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x400000; op2val:0xffffffffffffffef; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x400000, 0xffffffffffffffef, 0x400, 3f, x7, 984,0)

inst_146:
// rs1_val == 8388608, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x800000; op2val:0x200000000; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x800000, 0x200000000, 0x20, 3f, x7, 992,0)

inst_147:
// rs1_val == 16777216, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1000000; op2val:0x20000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1000000, 0x20000, 0x6, 3f, x7, 1000,0)

inst_148:
// rs1_val == 33554432, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000000; op2val:0xfffff7ffffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2000000, 0xfffff7ffffffffff, 0x0, 3f, x7, 1008,0)

inst_149:
// rs1_val == 268435456, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000000; op2val:0xfffffffdffffffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x10000000, 0xfffffffdffffffff, 0x10, 3f, x7, 1016,0)

inst_150:
// rs1_val == 34359738368, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x800000000; op2val:0x800000000000000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x800000000, 0x800000000000000, 0x8, 1b, x7, 1024,0)

inst_151:
// rs1_val == 274877906944, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4000000000; op2val:0xffffffffffdfffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4000000000, 0xffffffffffdfffff, 0x2, 3f, x7, 1032,0)

inst_152:
// rs1_val == 549755813888, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8000000000; op2val:0x6666666666666666; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x8000000000, 0x6666666666666666, 0x6, 3f, x7, 1040,0)

inst_153:
// rs1_val == 1099511627776, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x10000000000; op2val:0x2000000000000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x10000000000, 0x2000000000000, 0x0, 1b, x7, 1048,0)

inst_154:
// rs1_val == 4398046511104, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x40000000000; op2val:0x80000000000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x40000000000, 0x80000000000, 0x8, 1b, x7, 1056,0)

inst_155:
// rs1_val == 8796093022208, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x80000000000; op2val:0x200; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x80000000000, 0x200, 0x4, 3f, x7, 1064,0)

inst_156:
// rs1_val == 140737488355328, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x800000000000; op2val:0xaaaaaaaaaaaaaaa9; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x800000000000, 0xaaaaaaaaaaaaaaa9, 0x4, 1b, x7, 1072,0)

inst_157:
// rs1_val == 281474976710656, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1000000000000; op2val:0xb504f333; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1000000000000, 0xb504f333, 0x100, 3f, x7, 1080,0)

inst_158:
// rs1_val == 562949953421312, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000000000000; op2val:0xc; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2000000000000, 0xc, 0x2, 1b, x7, 1088,0)

inst_159:
// rs1_val == 2251799813685248, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8000000000000; op2val:0xd; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x8000000000000, 0xd, 0x100, 3f, x7, 1096,0)

inst_160:
// rs1_val == 18014398509481984, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x40000000000000; op2val:0xffffffefffffffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x40000000000000, 0xffffffefffffffff, 0x556, 1b, x7, 1104,0)

inst_161:
// rs1_val == 72057594037927936, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000000000; op2val:0xaaaaaaaaaaaaaaab; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000000000, 0xaaaaaaaaaaaaaaab, 0x200, 3f, x7, 1112,0)

inst_162:
// rs1_val == 576460752303423488, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x800000000000000; op2val:0x3333333333333333; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x800000000000000, 0x3333333333333333, 0x400, 3f, x7, 1120,0)

inst_163:
// rs1_val == 1152921504606846976, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1000000000000000; op2val:0xfffffffbffffffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1000000000000000, 0xfffffffbffffffff, 0x4, 1b, x7, 1128,0)

inst_164:
// rs1_val == 2305843009213693952, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2000000000000000; op2val:0x1; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2000000000000000, 0x1, 0x0, 3f, x7, 1136,0)

inst_165:
// rs1_val == 9223372036854775808, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x8000000000000000; op2val:0x7; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x8000000000000000, 0x7, 0x2, 3f, x7, 1144,0)

inst_166:
// rs1_val == 18446744073709551614, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffffffe; op2val:0xffffffffdfffffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffffffe, 0xffffffffdfffffff, 0x400, 3f, x7, 1152,0)

inst_167:
// rs1_val == 18446744073709551611, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffffffb; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffffffb, 0x0, 0x4, 1b, x7, 1160,0)

inst_168:
// rs1_val == 18446744073709551607, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffffff7; op2val:0xffff7fffffffffff; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffffff7, 0xffff7fffffffffff, 0x100, 3f, x7, 1168,0)

inst_169:
// rs1_val == 18446744073709551583, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffffffdf; op2val:0x40000000000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffffffdf, 0x40000000000, 0x556, 1b, x7, 1176,0)

inst_170:
// rs1_val == 18446744073709551487, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffffff7f; op2val:0xfeffffffffffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffffff7f, 0xfeffffffffffffff, 0x2, 1b, x7, 1184,0)

inst_171:
// rs1_val == 18446744073709551103, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffffdff; op2val:0xfffffeffffffffff; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffffdff, 0xfffffeffffffffff, 0x4, 1b, x7, 1192,0)

inst_172:
// rs1_val == 18446744073709550591, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffffbff; op2val:0xf7ffffffffffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffffbff, 0xf7ffffffffffffff, 0x2, 3f, x7, 1200,0)

inst_173:
// rs1_val == 18446744073709547519, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffffefff; op2val:0x200000000000; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffffefff, 0x200000000000, 0x2, 1b, x7, 1208,0)

inst_174:
// rs1_val == 18446744073709518847, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffff7fff; op2val:0x2000000000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffff7fff, 0x2000000000, 0x8, 3f, x7, 1216,0)

inst_175:
// rs1_val == 18446744073709486079, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffeffff; op2val:0x8000000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffeffff, 0x8000000000, 0x200, 3f, x7, 1224,0)

inst_176:
// rs1_val == 18446744073709289471, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffffbffff; op2val:0x4000000; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffffbffff, 0x4000000, 0x80, 3f, x7, 1232,0)

inst_177:
// rs1_val == 18446744073708503039, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffefffff; op2val:0xffff7fffffffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffefffff, 0xffff7fffffffffff, 0x2, 3f, x7, 1240,0)

inst_178:
// rs1_val == 18446744073707454463, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffffdfffff; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffffdfffff, 0x3, 0x8, 3f, x7, 1248,0)

inst_179:
// rs1_val == 18446744073701163007, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffff7fffff; op2val:0x9; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffff7fffff, 0x9, 0x200, 3f, x7, 1256,0)

inst_180:
// rs1_val == 18446744073692774399, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffeffffff; op2val:0x100000000000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffeffffff, 0x100000000000, 0x0, 3f, x7, 1264,0)

inst_181:
// rs1_val == 18446744073675997183, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffffdffffff; op2val:0x5555555555555556; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffffdffffff, 0x5555555555555556, 0x200, 3f, x7, 1272,0)

inst_182:
// rs1_val == 18446744073172680703, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffdfffffff; op2val:0x10000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffdfffffff, 0x10000, 0x6, 3f, x7, 1280,0)

inst_183:
// rs1_val == 18446744072635809791, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffffbfffffff; op2val:0xffffffffffefffff; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffffbfffffff, 0xffffffffffefffff, 0x556, 1b, x7, 1288,0)

inst_184:
// rs1_val == 18446744071562067967, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff7fffffff; op2val:0xffff7fffffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff7fffffff, 0xffff7fffffffffff, 0x0, 1b, x7, 1296,0)

inst_185:
// rs1_val == 18446744069414584319, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffeffffffff; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffeffffffff, 0x0, 0x4, 1b, x7, 1304,0)

inst_186:
// rs1_val == 18446744065119617023, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffffdffffffff; op2val:0xfffffffffffffffe; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffffdffffffff, 0xfffffffffffffffe, 0x2, 1b, x7, 1312,0)

inst_187:
// rs1_val == 18446743936270598143, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffdfffffffff; op2val:0xffffffffffffff7f; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffdfffffffff, 0xffffffffffffff7f, 0xa, 1b, x7, 1320,0)

inst_188:
// rs1_val == 18446743798831644671, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffbfffffffff; op2val:0x2000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffbfffffffff, 0x2000, 0x200, 3f, x7, 1328,0)

inst_189:
// rs1_val == 18446739675663040511, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffffbffffffffff; op2val:0x2; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffffbffffffffff, 0x2, 0x556, 1b, x7, 1336,0)

inst_190:
// rs1_val == 18446726481523507199, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffefffffffffff; op2val:0xffffdfffffffffff; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffefffffffffff, 0xffffdfffffffffff, 0x100, 3f, x7, 1344,0)

inst_191:
// rs1_val == 18445618173802708991, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xfffbffffffffffff; op2val:0x5555555555555555; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xfffbffffffffffff, 0x5555555555555555, 0x556, 1b, x7, 1352,0)

inst_192:
// rs1_val == 18442240474082181119, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffefffffffffffff; op2val:0xfffffffffdffffff; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffefffffffffffff, 0xfffffffffdffffff, 0x400, 3f, x7, 1360,0)

inst_193:
// rs1_val == 18428729675200069631, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffbfffffffffffff; op2val:0x5; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffbfffffffffffff, 0x5, 0x8, 1b, x7, 1368,0)

inst_194:
// rs1_val == 18410715276690587647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xff7fffffffffffff; op2val:0x200000000; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xff7fffffffffffff, 0x200000000, 0x8, 3f, x7, 1376,0)

inst_195:
// rs1_val == 17293822569102704639, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xefffffffffffffff; op2val:0x4; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xefffffffffffffff, 0x4, 0x40, 3f, x7, 1384,0)

inst_196:
// rs1_val == 16140901064495857663, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xdfffffffffffffff; op2val:0x2000000000; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xdfffffffffffffff, 0x2000000000, 0x100, 3f, x7, 1392,0)

inst_197:
// rs1_val==3 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x3; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x3, 0x80, 3f, x7, 1400,0)

inst_198:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x5555555555555555; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x5555555555555555, 0x0, 1b, x7, 1408,0)

inst_199:
// rs1_val==3 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xaaaaaaaaaaaaaaaa; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0xaaaaaaaaaaaaaaaa, 0x80, 3f, x7, 1416,0)

inst_200:
// rs1_val==3 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x5; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x5, 0x10, 3f, x7, 1424,0)

inst_201:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x3333333333333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x3333333333333333, 0x6, 3f, x7, 1432,0)

inst_202:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x6666666666666666; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x6666666666666666, 0x100, 3f, x7, 1440,0)

inst_203:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xb504f333; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0xb504f333, 0x400, 1b, x7, 1448,0)

inst_204:
// rs1_val==3 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x0, 0x4, 3f, x7, 1456,0)

inst_205:
// rs1_val==3 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x100000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x100000000, 0x200, 3f, x7, 1464,0)

inst_206:
// rs1_val==3 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x2; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x2, 0x6, 3f, x7, 1472,0)

inst_207:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x5555555555555554; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x5555555555555554, 0x4, 3f, x7, 1480,0)

inst_208:
// rs1_val==3 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xaaaaaaaaaaaaaaa9; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0xaaaaaaaaaaaaaaa9, 0x4, 3f, x7, 1488,0)

inst_209:
// rs1_val==3 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x4; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x4, 0x200, 3f, x7, 1496,0)

inst_210:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x3333333333333332; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x3333333333333332, 0x40, 3f, x7, 1504,0)

inst_211:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x6666666666666665; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x6666666666666665, 0x100, 3f, x7, 1512,0)

inst_212:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xb504f332; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0xb504f332, 0x556, 1b, x7, 1520,0)

inst_213:
// rs1_val==3 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xffffffff; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0xffffffff, 0x200, 3f, x7, 1528,0)

inst_214:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x5555555555555556; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x5555555555555556, 0xa, 1b, x7, 1536,0)

inst_215:
// rs1_val==3 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xaaaaaaaaaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0xaaaaaaaaaaaaaaab, 0x4, 3f, x7, 1544,0)

inst_216:
// rs1_val==3 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x6; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x6, 0x6, 1b, x7, 1552,0)

inst_217:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x3333333333333334; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x3333333333333334, 0x400, 3f, x7, 1560,0)

inst_218:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x6666666666666667; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x6666666666666667, 0x8, 3f, x7, 1568,0)

inst_219:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0xb504f334; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0xb504f334, 0x400, 1b, x7, 1576,0)

inst_220:
// rs1_val==3 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x1; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x1, 0x2, 3f, x7, 1584,0)

inst_221:
// rs1_val==3 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3; op2val:0x100000001; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3, 0x100000001, 0x2, 1b, x7, 1592,0)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x3; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x3, 0x0, 1b, x7, 1600,0)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x5555555555555555; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x80, 3f, x7, 1608,0)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xaaaaaaaaaaaaaaaa; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0xaaaaaaaaaaaaaaaa, 0x6, 3f, x7, 1616,0)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x5; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x5, 0x0, 3f, x7, 1624,0)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x3333333333333333; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x3333333333333333, 0x8, 1b, x7, 1632,0)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x6666666666666666; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x6666666666666666, 0x0, 3f, x7, 1640,0)

inst_228:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xb504f333; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0xb504f333, 0x556, 1b, x7, 1648,0)

inst_229:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x0; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x0, 0x40, 3f, x7, 1656,0)

inst_230:
// rs1_val==6148914691236517205 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x100000000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x100000000, 0x4, 1b, x7, 1664,0)

inst_231:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x2; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x2, 0x4, 1b, x7, 1672,0)

inst_232:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x5555555555555554; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x5555555555555554, 0x400, 1b, x7, 1680,0)

inst_233:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xaaaaaaaaaaaaaaa9; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0xaaaaaaaaaaaaaaa9, 0x2, 1b, x7, 1688,0)

inst_234:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x4; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x4, 0x100, 3f, x7, 1696,0)

inst_235:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x3333333333333332; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x3333333333333332, 0x0, 1b, x7, 1704,0)

inst_236:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x6666666666666665; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x6666666666666665, 0x4, 1b, x7, 1712,0)

inst_237:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xb504f332; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0xb504f332, 0x20, 3f, x7, 1720,0)

inst_238:
// rs1_val==6148914691236517205 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xffffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0xffffffff, 0x2, 1b, x7, 1728,0)

inst_239:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x5555555555555556; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x5555555555555556, 0x200, 3f, x7, 1736,0)

inst_240:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xaaaaaaaaaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0xaaaaaaaaaaaaaaab, 0x4, 3f, x7, 1744,0)

inst_241:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x6; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x6, 0xa, 1b, x7, 1752,0)

inst_242:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x3333333333333334; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x3333333333333334, 0x0, 1b, x7, 1760,0)

inst_243:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x6666666666666667; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x6666666666666667, 0x6, 1b, x7, 1768,0)

inst_244:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0xb504f334; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0xb504f334, 0x20, 3f, x7, 1776,0)

inst_245:
// rs1_val==6148914691236517205 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x1; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x1, 0xa, 1b, x7, 1784,0)

inst_246:
// rs1_val==6148914691236517205 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555555; op2val:0x100000001; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555555, 0x100000001, 0x0, 1b, x7, 1792,0)

inst_247:
// rs1_val==12297829382473034410 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x3, 0x8, 1b, x7, 1800,0)

inst_248:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x5555555555555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555555, 0x2, 3f, x7, 1808,0)

inst_249:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0xaaaaaaaaaaaaaaaa; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, 0x6, 3f, x7, 1816,0)

inst_250:
// rs1_val==12297829382473034410 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x5; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5, 0x2, 1b, x7, 1824,0)

inst_251:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x3333333333333333; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x3333333333333333, 0x80, 3f, x7, 1832,0)

inst_252:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x6666666666666666; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x6666666666666666, 0x20, 3f, x7, 1840,0)

inst_253:
// rs1_val==12297829382473034410 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0xb504f333; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xb504f333, 0x80, 3f, x7, 1848,0)

inst_254:
// rs1_val==12297829382473034410 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x0; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x0, 0x6, 3f, x7, 1856,0)

inst_255:
// rs1_val==12297829382473034410 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x100000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x100000000, 0x400, 1b, x7, 1864,0)

inst_256:
// rs1_val==12297829382473034410 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x2; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x2, 0x100, 3f, x7, 1872,0)

inst_257:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x5555555555555554; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555554, 0x400, 3f, x7, 1880,0)

inst_258:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0xaaaaaaaaaaaaaaa9; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaa9, 0xa, 1b, x7, 1888,0)

inst_259:
// rs1_val==12297829382473034410 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x4; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x4, 0x8, 1b, x7, 1896,0)

inst_260:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x3333333333333332; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x3333333333333332, 0x80, 3f, x7, 1904,0)

inst_261:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x6666666666666665; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x6666666666666665, 0x4, 1b, x7, 1912,0)

inst_262:
// rs1_val==12297829382473034410 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0xb504f332; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xb504f332, 0x556, 1b, x7, 1920,0)

inst_263:
// rs1_val==12297829382473034410 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0xffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xffffffff, 0x0, 1b, x7, 1928,0)

inst_264:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x5555555555555556; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x5555555555555556, 0x100, 3f, x7, 1936,0)

inst_265:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0xaaaaaaaaaaaaaaab; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaab, 0x0, 1b, x7, 1944,0)

inst_266:
// rs1_val==12297829382473034410 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x6; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x6, 0x20, 3f, x7, 1952,0)

inst_267:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x3333333333333334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x3333333333333334, 0x4, 3f, x7, 1960,0)

inst_268:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x6666666666666667; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x6666666666666667, 0x2, 3f, x7, 1968,0)

inst_269:
// rs1_val==12297829382473034410 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0xb504f334; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xb504f334, 0x400, 1b, x7, 1976,0)

inst_270:
// rs1_val==12297829382473034410 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x1; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x1, 0x556, 1b, x7, 1984,0)

inst_271:
// rs1_val==12297829382473034410 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaaa; op2val:0x100000001; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x100000001, 0x20, 3f, x7, 1992,0)

inst_272:
// rs1_val==5 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x3; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x3, 0x4, 3f, x7, 2000,0)

inst_273:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x5555555555555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x5555555555555555, 0x2, 1b, x7, 2008,0)

inst_274:
// rs1_val==5 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xaaaaaaaaaaaaaaaa; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0xaaaaaaaaaaaaaaaa, 0x400, 3f, x7, 2016,0)

inst_275:
// rs1_val==5 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x5; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x5, 0x2, 3f, x7, 2024,0)

inst_276:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x3333333333333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x3333333333333333, 0x6, 1b, x7, 2032,0)

inst_277:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x6666666666666666; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x6666666666666666, 0x8, 1b, x7, 2040,0)
RVTEST_SIGBASE( x7,signature_x7_1)

inst_278:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xb504f333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0xb504f333, 0x6, 1b, x7, 0,0)

inst_279:
// rs1_val==5 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x0, 0x4, 1b, x7, 8,0)

inst_280:
// rs1_val==5 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x100000000; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x100000000, 0x40, 3f, x7, 16,0)

inst_281:
// rs1_val==5 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x2; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x2, 0x2, 3f, x7, 24,0)

inst_282:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x5555555555555554; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x5555555555555554, 0x10, 3f, x7, 32,0)

inst_283:
// rs1_val==5 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xaaaaaaaaaaaaaaa9; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0xaaaaaaaaaaaaaaa9, 0x4, 1b, x7, 40,0)

inst_284:
// rs1_val==5 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x4; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x4, 0x200, 3f, x7, 48,0)

inst_285:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x3333333333333332; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x3333333333333332, 0x20, 3f, x7, 56,0)

inst_286:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x6666666666666665; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x6666666666666665, 0x556, 1b, x7, 64,0)

inst_287:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xb504f332; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0xb504f332, 0x2, 3f, x7, 72,0)

inst_288:
// rs1_val==5 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xffffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0xffffffff, 0x6, 1b, x7, 80,0)

inst_289:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x5555555555555556; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x5555555555555556, 0x0, 3f, x7, 88,0)

inst_290:
// rs1_val==5 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xaaaaaaaaaaaaaaab; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0xaaaaaaaaaaaaaaab, 0x400, 3f, x7, 96,0)

inst_291:
// rs1_val==5 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x6; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x6, 0x556, 1b, x7, 104,0)

inst_292:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x3333333333333334; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x3333333333333334, 0x6, 3f, x7, 112,0)

inst_293:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x6666666666666667; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x6666666666666667, 0x400, 3f, x7, 120,0)

inst_294:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0xb504f334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0xb504f334, 0x2, 3f, x7, 128,0)

inst_295:
// rs1_val==5 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x1, 0x8, 1b, x7, 136,0)

inst_296:
// rs1_val==5 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5; op2val:0x100000001; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5, 0x100000001, 0x6, 1b, x7, 144,0)

inst_297:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x3; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x3, 0x400, 3f, x7, 152,0)

inst_298:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x5555555555555555; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x5555555555555555, 0x4, 3f, x7, 160,0)

inst_299:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xaaaaaaaaaaaaaaaa; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0xaaaaaaaaaaaaaaaa, 0x0, 3f, x7, 168,0)

inst_300:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x5; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x5, 0x4, 1b, x7, 176,0)

inst_301:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x6666666666666666; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x6666666666666666, 0x556, 1b, x7, 184,0)

inst_302:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xb504f333; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0xb504f333, 0x100, 3f, x7, 192,0)

inst_303:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x0; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x0, 0xa, 1b, x7, 200,0)

inst_304:
// rs1_val==3689348814741910323 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x100000000; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x100000000, 0x80, 3f, x7, 208,0)

inst_305:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x2; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x2, 0x6, 3f, x7, 216,0)

inst_306:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x5555555555555554; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x5555555555555554, 0x20, 3f, x7, 224,0)

inst_307:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xaaaaaaaaaaaaaaa9; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0xaaaaaaaaaaaaaaa9, 0x200, 3f, x7, 232,0)

inst_308:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x4; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x4, 0x100, 3f, x7, 240,0)

inst_309:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x3333333333333332; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x3333333333333332, 0x200, 3f, x7, 248,0)

inst_310:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x6666666666666665; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x6666666666666665, 0x400, 1b, x7, 256,0)

inst_311:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xb504f332; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0xb504f332, 0x40, 3f, x7, 264,0)

inst_312:
// rs1_val==3689348814741910323 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xffffffff; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0xffffffff, 0x40, 3f, x7, 272,0)

inst_313:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x5555555555555556; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x5555555555555556, 0x4, 3f, x7, 280,0)

inst_314:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xaaaaaaaaaaaaaaab; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0xaaaaaaaaaaaaaaab, 0xa, 1b, x7, 288,0)

inst_315:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x6; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x6, 0x2, 1b, x7, 296,0)

inst_316:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x3333333333333334; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x3333333333333334, 0xa, 1b, x7, 304,0)

inst_317:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x6666666666666667; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x6666666666666667, 0x4, 3f, x7, 312,0)

inst_318:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0xb504f334; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0xb504f334, 0x100, 3f, x7, 320,0)

inst_319:
// rs1_val==3689348814741910323 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x1; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x1, 0x20, 3f, x7, 328,0)

inst_320:
// rs1_val==3689348814741910323 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333333; op2val:0x100000001; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333333, 0x100000001, 0x400, 3f, x7, 336,0)

inst_321:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x3; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x3, 0x556, 1b, x7, 344,0)

inst_322:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x5555555555555555; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x5555555555555555, 0x100, 3f, x7, 352,0)

inst_323:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xaaaaaaaaaaaaaaaa; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0xaaaaaaaaaaaaaaaa, 0x40, 3f, x7, 360,0)

inst_324:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x5; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x5, 0x556, 1b, x7, 368,0)

inst_325:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x3333333333333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x3333333333333333, 0x6, 1b, x7, 376,0)

inst_326:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x6666666666666666; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x6666666666666666, 0x10, 3f, x7, 384,0)

inst_327:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xb504f333; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0xb504f333, 0x400, 1b, x7, 392,0)

inst_328:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x0; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x0, 0x2, 3f, x7, 400,0)

inst_329:
// rs1_val==7378697629483820646 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x100000000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x100000000, 0x10, 3f, x7, 408,0)

inst_330:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x2, 0x400, 3f, x7, 416,0)

inst_331:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x5555555555555554; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x5555555555555554, 0x40, 3f, x7, 424,0)

inst_332:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xaaaaaaaaaaaaaaa9; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0xaaaaaaaaaaaaaaa9, 0x20, 3f, x7, 432,0)

inst_333:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x4; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x4, 0x10, 3f, x7, 440,0)

inst_334:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x3333333333333332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x3333333333333332, 0x4, 3f, x7, 448,0)

inst_335:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x6666666666666665; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x6666666666666665, 0x2, 1b, x7, 456,0)

inst_336:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xb504f332; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0xb504f332, 0x0, 3f, x7, 464,0)

inst_337:
// rs1_val==7378697629483820646 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xffffffff; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0xffffffff, 0x0, 1b, x7, 472,0)

inst_338:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x5555555555555556; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x5555555555555556, 0x6, 3f, x7, 480,0)

inst_339:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xaaaaaaaaaaaaaaab; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0xaaaaaaaaaaaaaaab, 0x10, 3f, x7, 488,0)

inst_340:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x6; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x6, 0x100, 3f, x7, 496,0)

inst_341:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x3333333333333334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x3333333333333334, 0x4, 3f, x7, 504,0)

inst_342:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x6666666666666667; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x6666666666666667, 0x80, 3f, x7, 512,0)

inst_343:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0xb504f334; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0xb504f334, 0x0, 3f, x7, 520,0)

inst_344:
// rs1_val==7378697629483820646 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x1, 0x8, 3f, x7, 528,0)

inst_345:
// rs1_val==7378697629483820646 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666666; op2val:0x100000001; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666666, 0x100000001, 0x100, 3f, x7, 536,0)

inst_346:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x3; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x3, 0x400, 1b, x7, 544,0)

inst_347:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x5555555555555555; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x5555555555555555, 0x6, 1b, x7, 552,0)

inst_348:
// rs1_val==3037000499 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0xaaaaaaaaaaaaaaaa; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0xaaaaaaaaaaaaaaaa, 0x0, 1b, x7, 560,0)

inst_349:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x5; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x5, 0x2, 3f, x7, 568,0)

inst_350:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x3333333333333333; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x3333333333333333, 0x4, 1b, x7, 576,0)

inst_351:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x6666666666666666; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x6666666666666666, 0x0, 3f, x7, 584,0)

inst_352:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0xb504f333; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0xb504f333, 0x10, 3f, x7, 592,0)

inst_353:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x0, 0x4, 1b, x7, 600,0)

inst_354:
// rs1_val==3037000499 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x100000000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x100000000, 0x556, 1b, x7, 608,0)

inst_355:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x2, 0x400, 3f, x7, 616,0)

inst_356:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x5555555555555554; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x5555555555555554, 0x40, 3f, x7, 624,0)

inst_357:
// rs1_val==3037000499 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0xaaaaaaaaaaaaaaa9; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0xaaaaaaaaaaaaaaa9, 0x6, 3f, x7, 632,0)

inst_358:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x4; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x4, 0x100, 3f, x7, 640,0)

inst_359:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x3333333333333332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x3333333333333332, 0x8, 3f, x7, 648,0)

inst_360:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x6666666666666665; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x6666666666666665, 0x8, 3f, x7, 656,0)

inst_361:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0xb504f332; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0xb504f332, 0x10, 3f, x7, 664,0)

inst_362:
// rs1_val==3037000499 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0xffffffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0xffffffff, 0x8, 3f, x7, 672,0)

inst_363:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x5555555555555556; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x5555555555555556, 0x10, 3f, x7, 680,0)

inst_364:
// rs1_val==3037000499 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0xaaaaaaaaaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0xaaaaaaaaaaaaaaab, 0x4, 1b, x7, 688,0)

inst_365:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x6; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x6, 0x20, 3f, x7, 696,0)

inst_366:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x3333333333333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x3333333333333334, 0x2, 3f, x7, 704,0)

inst_367:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x6666666666666667; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x6666666666666667, 0x556, 1b, x7, 712,0)

inst_368:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0xb504f334; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0xb504f334, 0x20, 3f, x7, 720,0)

inst_369:
// rs1_val==3037000499 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x1; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x1, 0x556, 1b, x7, 728,0)

inst_370:
// rs1_val==3037000499 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f333; op2val:0x100000001; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f333, 0x100000001, 0x20, 3f, x7, 736,0)

inst_371:
// rs1_val==0 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x3; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x3, 0x80, 3f, x7, 744,0)

inst_372:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x5555555555555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x5555555555555555, 0x2, 3f, x7, 752,0)

inst_373:
// rs1_val==0 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xaaaaaaaaaaaaaaaa; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x4, 3f, x7, 760,0)

inst_374:
// rs1_val==0 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x5; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x5, 0x200, 3f, x7, 768,0)

inst_375:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x3333333333333333; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x3333333333333333, 0x4, 1b, x7, 776,0)

inst_376:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x6666666666666666; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x6666666666666666, 0x20, 3f, x7, 784,0)

inst_377:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xb504f333; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xb504f333, 0x400, 3f, x7, 792,0)

inst_378:
// rs1_val==0 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x0; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x0, 0x6, 1b, x7, 800,0)

inst_379:
// rs1_val==0 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x100000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x100000000, 0x200, 3f, x7, 808,0)

inst_380:
// rs1_val==0 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x2; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x2, 0x200, 3f, x7, 816,0)

inst_381:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x5555555555555554; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x5555555555555554, 0x400, 3f, x7, 824,0)

inst_382:
// rs1_val==0 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xaaaaaaaaaaaaaaa9; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x0, 3f, x7, 832,0)

inst_383:
// rs1_val==0 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x4; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x4, 0x4, 3f, x7, 840,0)

inst_384:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x3333333333333332; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x3333333333333332, 0x20, 3f, x7, 848,0)

inst_385:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x6666666666666665; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x6666666666666665, 0x200, 3f, x7, 856,0)

inst_386:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xb504f332; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xb504f332, 0x100, 3f, x7, 864,0)

inst_387:
// rs1_val==0 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xffffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xffffffff, 0x6, 1b, x7, 872,0)

inst_388:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x5555555555555556; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x5555555555555556, 0x80, 3f, x7, 880,0)

inst_389:
// rs1_val==0 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xaaaaaaaaaaaaaaab; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x400, 3f, x7, 888,0)

inst_390:
// rs1_val==0 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x6; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x6, 0x6, 3f, x7, 896,0)

inst_391:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x3333333333333334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x3333333333333334, 0x4, 3f, x7, 904,0)

inst_392:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x6666666666666667; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x6666666666666667, 0x20, 3f, x7, 912,0)

inst_393:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0xb504f334; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0xb504f334, 0x100, 3f, x7, 920,0)

inst_394:
// rs1_val==0 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x1; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x1, 0x10, 3f, x7, 928,0)

inst_395:
// rs1_val==0 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x0; op2val:0x100000001; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x0, 0x100000001, 0x200, 3f, x7, 936,0)

inst_396:
// rs1_val==4294967296 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x3, 0x8, 1b, x7, 944,0)

inst_397:
// rs1_val==4294967296 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x5555555555555555; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x5555555555555555, 0x556, 1b, x7, 952,0)

inst_398:
// rs1_val==4294967296 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0xaaaaaaaaaaaaaaaa; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0xaaaaaaaaaaaaaaaa, 0x80, 3f, x7, 960,0)

inst_399:
// rs1_val==4294967296 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x5; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x5, 0x0, 1b, x7, 968,0)

inst_400:
// rs1_val==4294967296 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x3333333333333333; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x3333333333333333, 0x80, 3f, x7, 976,0)

inst_401:
// rs1_val==4294967296 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x6666666666666666; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x6666666666666666, 0x400, 3f, x7, 984,0)

inst_402:
// rs1_val==4294967296 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0xb504f333; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0xb504f333, 0x8, 1b, x7, 992,0)

inst_403:
// rs1_val==4294967296 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x0; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x0, 0x6, 3f, x7, 1000,0)

inst_404:
// rs1_val==4294967296 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x100000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x100000000, 0x6, 1b, x7, 1008,0)

inst_405:
// rs1_val==4294967296 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x2; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x2, 0x100, 3f, x7, 1016,0)

inst_406:
// rs1_val==4294967296 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x5555555555555554; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x5555555555555554, 0xa, 1b, x7, 1024,0)

inst_407:
// rs1_val==4294967296 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0xaaaaaaaaaaaaaaa9; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0xaaaaaaaaaaaaaaa9, 0x200, 3f, x7, 1032,0)

inst_408:
// rs1_val==4294967296 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x4; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x4, 0x8, 1b, x7, 1040,0)

inst_409:
// rs1_val==4294967296 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x3333333333333332; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x3333333333333332, 0x556, 1b, x7, 1048,0)

inst_410:
// rs1_val==4294967296 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x6666666666666665; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x6666666666666665, 0x80, 3f, x7, 1056,0)

inst_411:
// rs1_val==4294967296 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0xb504f332; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0xb504f332, 0x10, 3f, x7, 1064,0)

inst_412:
// rs1_val==4294967296 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0xffffffff; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0xffffffff, 0x200, 3f, x7, 1072,0)

inst_413:
// rs1_val==4294967296 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x5555555555555556; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x5555555555555556, 0x80, 3f, x7, 1080,0)

inst_414:
// rs1_val==4294967296 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0xaaaaaaaaaaaaaaab; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0xaaaaaaaaaaaaaaab, 0x20, 3f, x7, 1088,0)

inst_415:
// rs1_val==4294967296 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x6; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x6, 0x6, 1b, x7, 1096,0)

inst_416:
// rs1_val==4294967296 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x3333333333333334; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x3333333333333334, 0x100, 3f, x7, 1104,0)

inst_417:
// rs1_val==4294967296 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x6666666666666667; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x6666666666666667, 0x6, 3f, x7, 1112,0)

inst_418:
// rs1_val==4294967296 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0xb504f334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0xb504f334, 0x2, 1b, x7, 1120,0)

inst_419:
// rs1_val==4294967296 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x1, 0x8, 1b, x7, 1128,0)

inst_420:
// rs1_val==4294967296 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000000; op2val:0x100000001; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000000, 0x100000001, 0x8, 1b, x7, 1136,0)

inst_421:
// rs1_val==2 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x3; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x3, 0x4, 1b, x7, 1144,0)

inst_422:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x5555555555555555; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x5555555555555555, 0x0, 1b, x7, 1152,0)

inst_423:
// rs1_val==2 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xaaaaaaaaaaaaaaaa; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0xaaaaaaaaaaaaaaaa, 0x8, 1b, x7, 1160,0)

inst_424:
// rs1_val==2 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x5; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x5, 0x400, 1b, x7, 1168,0)

inst_425:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x3333333333333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x3333333333333333, 0x6, 3f, x7, 1176,0)

inst_426:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x6666666666666666; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x6666666666666666, 0x400, 1b, x7, 1184,0)

inst_427:
// rs1_val==2 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x0; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x0, 0x8, 1b, x7, 1192,0)

inst_428:
// rs1_val==2 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x100000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x100000000, 0x6, 3f, x7, 1200,0)

inst_429:
// rs1_val==2 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x2; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x2, 0x2, 3f, x7, 1208,0)

inst_430:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x5555555555555554; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x5555555555555554, 0x6, 1b, x7, 1216,0)

inst_431:
// rs1_val==2 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xaaaaaaaaaaaaaaa9; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0xaaaaaaaaaaaaaaa9, 0x2, 1b, x7, 1224,0)

inst_432:
// rs1_val==2 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x4; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x4, 0x40, 3f, x7, 1232,0)

inst_433:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x3333333333333332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x3333333333333332, 0x8, 3f, x7, 1240,0)

inst_434:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x6666666666666665; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x6666666666666665, 0x556, 1b, x7, 1248,0)

inst_435:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xb504f332; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0xb504f332, 0x10, 3f, x7, 1256,0)

inst_436:
// rs1_val==2 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xffffffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0xffffffff, 0x10, 3f, x7, 1264,0)

inst_437:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x5555555555555556; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x5555555555555556, 0x8, 1b, x7, 1272,0)

inst_438:
// rs1_val==2 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xaaaaaaaaaaaaaaab; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0xaaaaaaaaaaaaaaab, 0x100, 3f, x7, 1280,0)

inst_439:
// rs1_val==2 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x6; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x6, 0x6, 3f, x7, 1288,0)

inst_440:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x3333333333333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x3333333333333334, 0x2, 3f, x7, 1296,0)

inst_441:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x6666666666666667; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x6666666666666667, 0x556, 1b, x7, 1304,0)

inst_442:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0xb504f334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0xb504f334, 0x2, 1b, x7, 1312,0)

inst_443:
// rs1_val==2 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x1; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x1, 0x4, 3f, x7, 1320,0)

inst_444:
// rs1_val==2 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x2; op2val:0x100000001; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x2, 0x100000001, 0x80, 3f, x7, 1328,0)

inst_445:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x3; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x3, 0x10, 3f, x7, 1336,0)

inst_446:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x5555555555555555; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x5555555555555555, 0x10, 3f, x7, 1344,0)

inst_447:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xaaaaaaaaaaaaaaaa; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xaaaaaaaaaaaaaaaa, 0x2, 3f, x7, 1352,0)

inst_448:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x5; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x5, 0x6, 3f, x7, 1360,0)

inst_449:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x3333333333333333; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x3333333333333333, 0x0, 3f, x7, 1368,0)

inst_450:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x6666666666666666; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x6666666666666666, 0x6, 3f, x7, 1376,0)

inst_451:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xb504f333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xb504f333, 0x6, 3f, x7, 1384,0)

inst_452:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x0; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x0, 0x6, 1b, x7, 1392,0)

inst_453:
// rs1_val==6148914691236517204 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x100000000; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x100000000, 0x40, 3f, x7, 1400,0)

inst_454:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x2, 0x400, 1b, x7, 1408,0)

inst_455:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x5555555555555554; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x2, 1b, x7, 1416,0)

inst_456:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xaaaaaaaaaaaaaaa9; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xaaaaaaaaaaaaaaa9, 0x8, 1b, x7, 1424,0)

inst_457:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x4; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x4, 0x6, 1b, x7, 1432,0)

inst_458:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x3333333333333332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x3333333333333332, 0x4, 3f, x7, 1440,0)

inst_459:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x6666666666666665; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x6666666666666665, 0x200, 3f, x7, 1448,0)

inst_460:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xb504f332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xb504f332, 0x4, 1b, x7, 1456,0)

inst_461:
// rs1_val==6148914691236517204 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xffffffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xffffffff, 0x8, 3f, x7, 1464,0)

inst_462:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x5555555555555556; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x5555555555555556, 0x556, 1b, x7, 1472,0)

inst_463:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xaaaaaaaaaaaaaaab; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xaaaaaaaaaaaaaaab, 0x556, 1b, x7, 1480,0)

inst_464:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x6; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x6, 0x0, 3f, x7, 1488,0)

inst_465:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x3333333333333334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x3333333333333334, 0x4, 1b, x7, 1496,0)

inst_466:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x6666666666666667; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x6666666666666667, 0x20, 3f, x7, 1504,0)

inst_467:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0xb504f334; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0xb504f334, 0x4, 1b, x7, 1512,0)

inst_468:
// rs1_val==6148914691236517204 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x1; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x1, 0xa, 1b, x7, 1520,0)

inst_469:
// rs1_val==6148914691236517204 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555554; op2val:0x100000001; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555554, 0x100000001, 0x0, 3f, x7, 1528,0)

inst_470:
// rs1_val==12297829382473034409 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x3; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x3, 0x80, 3f, x7, 1536,0)

inst_471:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x5555555555555555; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x5555555555555555, 0x6, 3f, x7, 1544,0)

inst_472:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0xaaaaaaaaaaaaaaaa; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaaa, 0x20, 3f, x7, 1552,0)

inst_473:
// rs1_val==12297829382473034409 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x5; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x5, 0x0, 1b, x7, 1560,0)

inst_474:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x3333333333333333; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x3333333333333333, 0x0, 3f, x7, 1568,0)

inst_475:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x6666666666666666; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x6666666666666666, 0x80, 3f, x7, 1576,0)

inst_476:
// rs1_val==12297829382473034409 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0xb504f333; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xb504f333, 0x4, 3f, x7, 1584,0)

inst_477:
// rs1_val==12297829382473034409 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x0; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x0, 0x8, 1b, x7, 1592,0)

inst_478:
// rs1_val==12297829382473034409 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x100000000; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x100000000, 0x0, 1b, x7, 1600,0)

inst_479:
// rs1_val==12297829382473034409 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x2, 0x400, 3f, x7, 1608,0)

inst_480:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x5555555555555554; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x5555555555555554, 0x200, 3f, x7, 1616,0)

inst_481:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0xaaaaaaaaaaaaaaa9; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaa9, 0x40, 3f, x7, 1624,0)

inst_482:
// rs1_val==12297829382473034409 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x4; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x4, 0x200, 3f, x7, 1632,0)

inst_483:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x3333333333333332; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x3333333333333332, 0x400, 3f, x7, 1640,0)

inst_484:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x6666666666666665; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x6666666666666665, 0x8, 3f, x7, 1648,0)

inst_485:
// rs1_val==12297829382473034409 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0xb504f332; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xb504f332, 0x100, 3f, x7, 1656,0)

inst_486:
// rs1_val==12297829382473034409 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0xffffffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xffffffff, 0x10, 3f, x7, 1664,0)

inst_487:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x5555555555555556; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x5555555555555556, 0x6, 3f, x7, 1672,0)

inst_488:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0xaaaaaaaaaaaaaaab; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaab, 0x6, 3f, x7, 1680,0)

inst_489:
// rs1_val==12297829382473034409 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x6; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x6, 0xa, 1b, x7, 1688,0)

inst_490:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x3333333333333334; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x3333333333333334, 0x100, 3f, x7, 1696,0)

inst_491:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x6666666666666667; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x6666666666666667, 0x20, 3f, x7, 1704,0)

inst_492:
// rs1_val==12297829382473034409 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0xb504f334; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xb504f334, 0x40, 3f, x7, 1712,0)

inst_493:
// rs1_val==12297829382473034409 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x1, 0x8, 1b, x7, 1720,0)

inst_494:
// rs1_val==12297829382473034409 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaa9; op2val:0x100000001; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x100000001, 0x8, 3f, x7, 1728,0)

inst_495:
// rs1_val==4 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x3; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x3, 0x4, 1b, x7, 1736,0)

inst_496:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x5555555555555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x5555555555555555, 0x2, 1b, x7, 1744,0)

inst_497:
// rs1_val==4 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xaaaaaaaaaaaaaaaa; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0xaaaaaaaaaaaaaaaa, 0x400, 1b, x7, 1752,0)

inst_498:
// rs1_val==4 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x5; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x5, 0x400, 1b, x7, 1760,0)

inst_499:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x3333333333333333; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x3333333333333333, 0x80, 3f, x7, 1768,0)

inst_500:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x6666666666666666; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x6666666666666666, 0x200, 3f, x7, 1776,0)

inst_501:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xb504f333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0xb504f333, 0x6, 3f, x7, 1784,0)

inst_502:
// rs1_val==4 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x0; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x0, 0x100, 3f, x7, 1792,0)

inst_503:
// rs1_val==4 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x100000000; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x100000000, 0x40, 3f, x7, 1800,0)

inst_504:
// rs1_val==4 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x2; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x2, 0x80, 3f, x7, 1808,0)

inst_505:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x5555555555555554; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x5555555555555554, 0x80, 3f, x7, 1816,0)

inst_506:
// rs1_val==4 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xaaaaaaaaaaaaaaa9; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0xaaaaaaaaaaaaaaa9, 0x556, 1b, x7, 1824,0)

inst_507:
// rs1_val==4 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x4; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x4, 0x0, 1b, x7, 1832,0)

inst_508:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x3333333333333332; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x3333333333333332, 0xa, 1b, x7, 1840,0)

inst_509:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x6666666666666665; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x6666666666666665, 0x0, 3f, x7, 1848,0)

inst_510:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xb504f332; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0xb504f332, 0x556, 1b, x7, 1856,0)

inst_511:
// rs1_val==4 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xffffffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0xffffffff, 0x10, 3f, x7, 1864,0)

inst_512:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x5555555555555556; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x5555555555555556, 0x6, 1b, x7, 1872,0)

inst_513:
// rs1_val==4 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xaaaaaaaaaaaaaaab; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0xaaaaaaaaaaaaaaab, 0x8, 3f, x7, 1880,0)

inst_514:
// rs1_val==4 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x6; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x6, 0x80, 3f, x7, 1888,0)

inst_515:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x3333333333333334; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x3333333333333334, 0xa, 1b, x7, 1896,0)

inst_516:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x6666666666666667; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x6666666666666667, 0x0, 1b, x7, 1904,0)

inst_517:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0xb504f334; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0xb504f334, 0x20, 3f, x7, 1912,0)

inst_518:
// rs1_val==4 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x1; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x1, 0x4, 1b, x7, 1920,0)

inst_519:
// rs1_val==4 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x4; op2val:0x100000001; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x4, 0x100000001, 0x20, 3f, x7, 1928,0)

inst_520:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x3; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x3, 0x4, 1b, x7, 1936,0)

inst_521:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x5555555555555555; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x5555555555555555, 0x6, 1b, x7, 1944,0)

inst_522:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xaaaaaaaaaaaaaaaa; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0xaaaaaaaaaaaaaaaa, 0x20, 3f, x7, 1952,0)

inst_523:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x5; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x5, 0x8, 3f, x7, 1960,0)

inst_524:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x3333333333333333; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x3333333333333333, 0x80, 3f, x7, 1968,0)

inst_525:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x6666666666666666; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x6666666666666666, 0x40, 3f, x7, 1976,0)

inst_526:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xb504f333; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0xb504f333, 0x2, 1b, x7, 1984,0)

inst_527:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x0; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x0, 0x100, 3f, x7, 1992,0)

inst_528:
// rs1_val==3689348814741910322 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x100000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x100000000, 0x400, 1b, x7, 2000,0)

inst_529:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x2; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x2, 0x2, 3f, x7, 2008,0)

inst_530:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x5555555555555554; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x5555555555555554, 0x80, 3f, x7, 2016,0)

inst_531:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xaaaaaaaaaaaaaaa9; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0xaaaaaaaaaaaaaaa9, 0x20, 3f, x7, 2024,0)

inst_532:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x4; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x4, 0x80, 3f, x7, 2032,0)

inst_533:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x3333333333333332; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x0, 1b, x7, 2040,0)
RVTEST_SIGBASE( x7,signature_x7_2)

inst_534:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x6666666666666665; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x6666666666666665, 0x400, 1b, x7, 0,0)

inst_535:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xb504f332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0xb504f332, 0x4, 1b, x7, 8,0)

inst_536:
// rs1_val==3689348814741910322 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xffffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0xffffffff, 0x6, 3f, x7, 16,0)

inst_537:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x5555555555555556; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x5555555555555556, 0x200, 3f, x7, 24,0)

inst_538:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xaaaaaaaaaaaaaaab; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0xaaaaaaaaaaaaaaab, 0x2, 1b, x7, 32,0)

inst_539:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x6, 0x4, 1b, x7, 40,0)

inst_540:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x3333333333333334; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x3333333333333334, 0x10, 3f, x7, 48,0)

inst_541:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x6666666666666667; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x6666666666666667, 0x40, 3f, x7, 56,0)

inst_542:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0xb504f334; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0xb504f334, 0x100, 3f, x7, 64,0)

inst_543:
// rs1_val==3689348814741910322 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x1, 0x8, 1b, x7, 72,0)

inst_544:
// rs1_val==3689348814741910322 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333332; op2val:0x100000001; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333332, 0x100000001, 0xa, 1b, x7, 80,0)

inst_545:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x3; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x3, 0x4, 1b, x7, 88,0)

inst_546:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x5555555555555555; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x5555555555555555, 0x2, 1b, x7, 96,0)

inst_547:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xaaaaaaaaaaaaaaaa; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0xaaaaaaaaaaaaaaaa, 0xa, 1b, x7, 104,0)

inst_548:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x5; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x5, 0x400, 1b, x7, 112,0)

inst_549:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x3333333333333333; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x3333333333333333, 0x8, 1b, x7, 120,0)

inst_550:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x6666666666666666; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x6666666666666666, 0x6, 3f, x7, 128,0)

inst_551:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xb504f333; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0xb504f333, 0x8, 3f, x7, 136,0)

inst_552:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x0; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x0, 0x2, 1b, x7, 144,0)

inst_553:
// rs1_val==7378697629483820645 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x100000000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x100000000, 0x4, 1b, x7, 152,0)

inst_554:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x2; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x2, 0x4, 1b, x7, 160,0)

inst_555:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x5555555555555554; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x5555555555555554, 0x0, 3f, x7, 168,0)

inst_556:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xaaaaaaaaaaaaaaa9; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0xaaaaaaaaaaaaaaa9, 0x80, 3f, x7, 176,0)

inst_557:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x4; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x4, 0x2, 1b, x7, 184,0)

inst_558:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x3333333333333332; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x3333333333333332, 0x2, 1b, x7, 192,0)

inst_559:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x6666666666666665; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x6666666666666665, 0x556, 1b, x7, 200,0)

inst_560:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xb504f332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0xb504f332, 0x8, 1b, x7, 208,0)

inst_561:
// rs1_val==7378697629483820645 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xffffffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0xffffffff, 0x8, 1b, x7, 216,0)

inst_562:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x5555555555555556; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x5555555555555556, 0x8, 3f, x7, 224,0)

inst_563:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xaaaaaaaaaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0xaaaaaaaaaaaaaaab, 0x4, 3f, x7, 232,0)

inst_564:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x6; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x6, 0x200, 3f, x7, 240,0)

inst_565:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x3333333333333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x3333333333333334, 0x2, 3f, x7, 248,0)

inst_566:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x6666666666666667; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x6666666666666667, 0x100, 3f, x7, 256,0)

inst_567:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0xb504f334; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0xb504f334, 0x400, 1b, x7, 264,0)

inst_568:
// rs1_val==7378697629483820645 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x1; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x1, 0x556, 1b, x7, 272,0)

inst_569:
// rs1_val==7378697629483820645 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666665; op2val:0x100000001; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666665, 0x100000001, 0x0, 3f, x7, 280,0)

inst_570:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x3; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x3, 0x40, 3f, x7, 288,0)

inst_571:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x5555555555555555; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x5555555555555555, 0x556, 1b, x7, 296,0)

inst_572:
// rs1_val==3037000498 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0xaaaaaaaaaaaaaaaa; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0xaaaaaaaaaaaaaaaa, 0x4, 1b, x7, 304,0)

inst_573:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x5; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x5, 0x400, 3f, x7, 312,0)

inst_574:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x3333333333333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x3333333333333333, 0x6, 1b, x7, 320,0)

inst_575:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x6666666666666666; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x6666666666666666, 0x4, 1b, x7, 328,0)

inst_576:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0xb504f333; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0xb504f333, 0x2, 3f, x7, 336,0)

inst_577:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x0; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x0, 0x0, 1b, x7, 344,0)

inst_578:
// rs1_val==3037000498 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x100000000; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x100000000, 0x10, 3f, x7, 352,0)

inst_579:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x2, 0x400, 1b, x7, 360,0)

inst_580:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x5555555555555554; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x5555555555555554, 0x100, 3f, x7, 368,0)

inst_581:
// rs1_val==3037000498 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0xaaaaaaaaaaaaaaa9; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0xaaaaaaaaaaaaaaa9, 0x8, 1b, x7, 376,0)

inst_582:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x4; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x4, 0x8, 3f, x7, 384,0)

inst_583:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x3333333333333332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x3333333333333332, 0x8, 3f, x7, 392,0)

inst_584:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x6666666666666665; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x6666666666666665, 0x8, 1b, x7, 400,0)

inst_585:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0xb504f332; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0xb504f332, 0x200, 3f, x7, 408,0)

inst_586:
// rs1_val==3037000498 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0xffffffff; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0xffffffff, 0x200, 3f, x7, 416,0)

inst_587:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x5555555555555556; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x5555555555555556, 0x20, 3f, x7, 424,0)

inst_588:
// rs1_val==3037000498 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0xaaaaaaaaaaaaaaab; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0xaaaaaaaaaaaaaaab, 0x4, 1b, x7, 432,0)

inst_589:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x6, 0x4, 3f, x7, 440,0)

inst_590:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x3333333333333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x3333333333333334, 0x2, 1b, x7, 448,0)

inst_591:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x6666666666666667; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x6666666666666667, 0x100, 3f, x7, 456,0)

inst_592:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0xb504f334; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0xb504f334, 0x0, 3f, x7, 464,0)

inst_593:
// rs1_val==3037000498 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x1; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x1, 0x40, 3f, x7, 472,0)

inst_594:
// rs1_val==3037000498 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f332; op2val:0x100000001; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f332, 0x100000001, 0x4, 3f, x7, 480,0)

inst_595:
// rs1_val==4294967295 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x3; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x3, 0x2, 1b, x7, 488,0)

inst_596:
// rs1_val==4294967295 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x5555555555555555; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x5555555555555555, 0x100, 3f, x7, 496,0)

inst_597:
// rs1_val==4294967295 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0xaaaaaaaaaaaaaaaa; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0xaaaaaaaaaaaaaaaa, 0x400, 1b, x7, 504,0)

inst_598:
// rs1_val==4294967295 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x5; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x5, 0x2, 1b, x7, 512,0)

inst_599:
// rs1_val==4294967295 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x3333333333333333; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x3333333333333333, 0x400, 3f, x7, 520,0)

inst_600:
// rs1_val==4294967295 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x6666666666666666; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x6666666666666666, 0x200, 3f, x7, 528,0)

inst_601:
// rs1_val==4294967295 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0xb504f333; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0xb504f333, 0x20, 3f, x7, 536,0)

inst_602:
// rs1_val==4294967295 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x0, 0x4, 3f, x7, 544,0)

inst_603:
// rs1_val==4294967295 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x100000000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x100000000, 0x556, 1b, x7, 552,0)

inst_604:
// rs1_val==4294967295 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x2; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x2, 0xa, 1b, x7, 560,0)

inst_605:
// rs1_val==4294967295 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x5555555555555554; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x5555555555555554, 0x0, 3f, x7, 568,0)

inst_606:
// rs1_val==4294967295 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0xaaaaaaaaaaaaaaa9; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0xaaaaaaaaaaaaaaa9, 0x100, 3f, x7, 576,0)

inst_607:
// rs1_val==4294967295 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x4; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x4, 0x6, 1b, x7, 584,0)

inst_608:
// rs1_val==4294967295 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x3333333333333332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x3333333333333332, 0x4, 1b, x7, 592,0)

inst_609:
// rs1_val==4294967295 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x6666666666666665; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x6666666666666665, 0x10, 3f, x7, 600,0)

inst_610:
// rs1_val==4294967295 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0xb504f332; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0xb504f332, 0x0, 3f, x7, 608,0)

inst_611:
// rs1_val==4294967295 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0xffffffff; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0xffffffff, 0x8, 1b, x7, 616,0)

inst_612:
// rs1_val==4294967295 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x5555555555555556; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x5555555555555556, 0x20, 3f, x7, 624,0)

inst_613:
// rs1_val==4294967295 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0xaaaaaaaaaaaaaaab; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0xaaaaaaaaaaaaaaab, 0x10, 3f, x7, 632,0)

inst_614:
// rs1_val==4294967295 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x6; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x6, 0x400, 1b, x7, 640,0)

inst_615:
// rs1_val==4294967295 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x3333333333333334; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x3333333333333334, 0x8, 1b, x7, 648,0)

inst_616:
// rs1_val==4294967295 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x6666666666666667; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x6666666666666667, 0x8, 1b, x7, 656,0)

inst_617:
// rs1_val==4294967295 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0xb504f334; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0xb504f334, 0x200, 3f, x7, 664,0)

inst_618:
// rs1_val==4294967295 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x1; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x1, 0x4, 3f, x7, 672,0)

inst_619:
// rs1_val==4294967295 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xffffffff; op2val:0x100000001; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xffffffff, 0x100000001, 0x4, 3f, x7, 680,0)

inst_620:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x3; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x3, 0x400, 1b, x7, 688,0)

inst_621:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x5555555555555555; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x5555555555555555, 0x80, 3f, x7, 696,0)

inst_622:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xaaaaaaaaaaaaaaaa; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0xaaaaaaaaaaaaaaaa, 0x0, 1b, x7, 704,0)

inst_623:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x5; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x5, 0x8, 1b, x7, 712,0)

inst_624:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x3333333333333333; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x3333333333333333, 0x400, 1b, x7, 720,0)

inst_625:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x6666666666666666; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x6666666666666666, 0xa, 1b, x7, 728,0)

inst_626:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xb504f333; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0xb504f333, 0x4, 3f, x7, 736,0)

inst_627:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x0; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x0, 0x80, 3f, x7, 744,0)

inst_628:
// rs1_val==6148914691236517206 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x100000000; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x100000000, 0x20, 3f, x7, 752,0)

inst_629:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x2; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x2, 0x200, 3f, x7, 760,0)

inst_630:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x5555555555555554; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x5555555555555554, 0x80, 3f, x7, 768,0)

inst_631:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xaaaaaaaaaaaaaaa9; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0xaaaaaaaaaaaaaaa9, 0x6, 1b, x7, 776,0)

inst_632:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x4; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x4, 0x10, 3f, x7, 784,0)

inst_633:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x3333333333333332; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x3333333333333332, 0x400, 3f, x7, 792,0)

inst_634:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x6666666666666665; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x6666666666666665, 0x4, 1b, x7, 800,0)

inst_635:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xb504f332; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0xb504f332, 0xa, 1b, x7, 808,0)

inst_636:
// rs1_val==6148914691236517206 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xffffffff; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0xffffffff, 0x2, 3f, x7, 816,0)

inst_637:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x5555555555555556; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x5555555555555556, 0x0, 1b, x7, 824,0)

inst_638:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xaaaaaaaaaaaaaaab; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0xaaaaaaaaaaaaaaab, 0xa, 1b, x7, 832,0)

inst_639:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x6; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x6, 0x400, 1b, x7, 840,0)

inst_640:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x3333333333333334; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x3333333333333334, 0x10, 3f, x7, 848,0)

inst_641:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x6666666666666667; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x6666666666666667, 0x200, 3f, x7, 856,0)

inst_642:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0xb504f334; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0xb504f334, 0x20, 3f, x7, 864,0)

inst_643:
// rs1_val==6148914691236517206 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x1; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x1, 0x6, 3f, x7, 872,0)

inst_644:
// rs1_val==6148914691236517206 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x5555555555555556; op2val:0x100000001; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x5555555555555556, 0x100000001, 0x2, 3f, x7, 880,0)

inst_645:
// rs1_val==12297829382473034411 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x3; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x3, 0x6, 3f, x7, 888,0)

inst_646:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x5555555555555555; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x5555555555555555, 0x8, 1b, x7, 896,0)

inst_647:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0xaaaaaaaaaaaaaaaa; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaaa, 0x6, 3f, x7, 904,0)

inst_648:
// rs1_val==12297829382473034411 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x5; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x5, 0x8, 1b, x7, 912,0)

inst_649:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x3333333333333333; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x3333333333333333, 0x556, 1b, x7, 920,0)

inst_650:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x6666666666666666; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x6666666666666666, 0x2, 1b, x7, 928,0)

inst_651:
// rs1_val==12297829382473034411 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0xb504f333; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0xb504f333, 0x8, 3f, x7, 936,0)

inst_652:
// rs1_val==12297829382473034411 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x0; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x0, 0x80, 3f, x7, 944,0)

inst_653:
// rs1_val==12297829382473034411 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x100000000; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x100000000, 0x556, 1b, x7, 952,0)

inst_654:
// rs1_val==12297829382473034411 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x2, 0x400, 1b, x7, 960,0)

inst_655:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x5555555555555554; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x5555555555555554, 0x8, 3f, x7, 968,0)

inst_656:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0xaaaaaaaaaaaaaaa9; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaa9, 0x0, 3f, x7, 976,0)

inst_657:
// rs1_val==12297829382473034411 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x4; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x4, 0x4, 1b, x7, 984,0)

inst_658:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x3333333333333332; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x3333333333333332, 0x400, 3f, x7, 992,0)

inst_659:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x6666666666666665; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x6666666666666665, 0x80, 3f, x7, 1000,0)

inst_660:
// rs1_val==12297829382473034411 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0xb504f332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0xb504f332, 0x4, 3f, x7, 1008,0)

inst_661:
// rs1_val==12297829382473034411 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0xffffffff; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0xffffffff, 0x100, 3f, x7, 1016,0)

inst_662:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x5555555555555556; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x5555555555555556, 0x2, 3f, x7, 1024,0)

inst_663:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0xaaaaaaaaaaaaaaab; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaab, 0x40, 3f, x7, 1032,0)

inst_664:
// rs1_val==12297829382473034411 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x6; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x6, 0x0, 3f, x7, 1040,0)

inst_665:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x3333333333333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x3333333333333334, 0x2, 3f, x7, 1048,0)

inst_666:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x6666666666666667; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x6666666666666667, 0x0, 3f, x7, 1056,0)

inst_667:
// rs1_val==12297829382473034411 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0xb504f334; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0xb504f334, 0x556, 1b, x7, 1064,0)

inst_668:
// rs1_val==12297829382473034411 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x1, 0x8, 1b, x7, 1072,0)

inst_669:
// rs1_val==12297829382473034411 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xaaaaaaaaaaaaaaab; op2val:0x100000001; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xaaaaaaaaaaaaaaab, 0x100000001, 0xa, 1b, x7, 1080,0)

inst_670:
// rs1_val==6 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x3; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x3, 0x400, 1b, x7, 1088,0)

inst_671:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x5555555555555555; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x5555555555555555, 0x40, 3f, x7, 1096,0)

inst_672:
// rs1_val==6 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xaaaaaaaaaaaaaaaa; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0xaaaaaaaaaaaaaaaa, 0x0, 3f, x7, 1104,0)

inst_673:
// rs1_val==6 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x5; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x5, 0x40, 3f, x7, 1112,0)

inst_674:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x3333333333333333; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x3333333333333333, 0x80, 3f, x7, 1120,0)

inst_675:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x6666666666666666; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x6666666666666666, 0x8, 3f, x7, 1128,0)

inst_676:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xb504f333; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0xb504f333, 0x20, 3f, x7, 1136,0)

inst_677:
// rs1_val==6 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x0; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x0, 0x2, 1b, x7, 1144,0)

inst_678:
// rs1_val==6 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x100000000; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x100000000, 0xa, 1b, x7, 1152,0)

inst_679:
// rs1_val==6 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x2; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x2, 0x10, 3f, x7, 1160,0)

inst_680:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x5555555555555554; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x5555555555555554, 0x6, 1b, x7, 1168,0)

inst_681:
// rs1_val==6 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xaaaaaaaaaaaaaaa9; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0xaaaaaaaaaaaaaaa9, 0x200, 3f, x7, 1176,0)

inst_682:
// rs1_val==6 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x4; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x4, 0x400, 1b, x7, 1184,0)

inst_683:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x3333333333333332; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x3333333333333332, 0x2, 1b, x7, 1192,0)

inst_684:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x6666666666666665; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x6666666666666665, 0xa, 1b, x7, 1200,0)

inst_685:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xb504f332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0xb504f332, 0x4, 3f, x7, 1208,0)

inst_686:
// rs1_val==6 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xffffffff; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0xffffffff, 0x10, 3f, x7, 1216,0)

inst_687:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x5555555555555556; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x5555555555555556, 0x40, 3f, x7, 1224,0)

inst_688:
// rs1_val==6 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xaaaaaaaaaaaaaaab; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0xaaaaaaaaaaaaaaab, 0x6, 3f, x7, 1232,0)

inst_689:
// rs1_val==6 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x6; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x6, 0x8, 1b, x7, 1240,0)

inst_690:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x3333333333333334; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x3333333333333334, 0x400, 3f, x7, 1248,0)

inst_691:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x6666666666666667; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x6666666666666667, 0xa, 1b, x7, 1256,0)

inst_692:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0xb504f334; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0xb504f334, 0x556, 1b, x7, 1264,0)

inst_693:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x5555555555555555; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x5555555555555555, 0x8, 3f, x7, 1272,0)

inst_694:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xaaaaaaaaaaaaaaaa; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0xaaaaaaaaaaaaaaaa, 0x4, 1b, x7, 1280,0)

inst_695:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x5; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x5, 0x6, 3f, x7, 1288,0)

inst_696:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x3333333333333333; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x3333333333333333, 0x400, 3f, x7, 1296,0)

inst_697:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x6666666666666666; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x6666666666666666, 0x0, 3f, x7, 1304,0)

inst_698:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xb504f333; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0xb504f333, 0x200, 3f, x7, 1312,0)

inst_699:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x0; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x0, 0x80, 3f, x7, 1320,0)

inst_700:
// rs1_val==3689348814741910324 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x100000000; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x100000000, 0x4, 3f, x7, 1328,0)

inst_701:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x2; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x2, 0x556, 1b, x7, 1336,0)

inst_702:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x5555555555555554; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x5555555555555554, 0x0, 1b, x7, 1344,0)

inst_703:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xaaaaaaaaaaaaaaa9; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0xaaaaaaaaaaaaaaa9, 0x0, 1b, x7, 1352,0)

inst_704:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x4; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x4, 0x400, 3f, x7, 1360,0)

inst_705:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x3333333333333332; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x3333333333333332, 0x400, 1b, x7, 1368,0)

inst_706:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x6666666666666665; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x6666666666666665, 0x4, 3f, x7, 1376,0)

inst_707:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xb504f332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0xb504f332, 0x8, 3f, x7, 1384,0)

inst_708:
// rs1_val==3689348814741910324 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xffffffff; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0xffffffff, 0x80, 3f, x7, 1392,0)

inst_709:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x5555555555555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x5555555555555556, 0x400, 1b, x7, 1400,0)

inst_710:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xaaaaaaaaaaaaaaab; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0xaaaaaaaaaaaaaaab, 0x8, 1b, x7, 1408,0)

inst_711:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x6, 0x4, 1b, x7, 1416,0)

inst_712:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x3333333333333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x2, 3f, x7, 1424,0)

inst_713:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x6666666666666667; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x6666666666666667, 0x6, 3f, x7, 1432,0)

inst_714:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0xb504f334; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0xb504f334, 0xa, 1b, x7, 1440,0)

inst_715:
// rs1_val==3689348814741910324 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x1; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x1, 0x40, 3f, x7, 1448,0)

inst_716:
// rs1_val==3689348814741910324 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x100000001; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x100000001, 0x2, 3f, x7, 1456,0)

inst_717:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x3; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x3, 0x2, 3f, x7, 1464,0)

inst_718:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x5555555555555555; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x5555555555555555, 0x10, 3f, x7, 1472,0)

inst_719:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xaaaaaaaaaaaaaaaa; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0xaaaaaaaaaaaaaaaa, 0x10, 3f, x7, 1480,0)

inst_720:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x5; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x5, 0x200, 3f, x7, 1488,0)

inst_721:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x3333333333333333; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x3333333333333333, 0x40, 3f, x7, 1496,0)

inst_722:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x6666666666666666; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x6666666666666666, 0x0, 1b, x7, 1504,0)

inst_723:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xb504f333; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0xb504f333, 0x200, 3f, x7, 1512,0)

inst_724:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x0; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x0, 0x40, 3f, x7, 1520,0)

inst_725:
// rs1_val==7378697629483820647 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x100000000; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x100000000, 0x40, 3f, x7, 1528,0)

inst_726:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x2; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x2, 0x400, 3f, x7, 1536,0)

inst_727:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x5555555555555554; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x5555555555555554, 0x0, 3f, x7, 1544,0)

inst_728:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xaaaaaaaaaaaaaaa9; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0xaaaaaaaaaaaaaaa9, 0x0, 3f, x7, 1552,0)

inst_729:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x4; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x4, 0x10, 3f, x7, 1560,0)

inst_730:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x3333333333333332; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x3333333333333332, 0x200, 3f, x7, 1568,0)

inst_731:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x6666666666666665; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x6666666666666665, 0xa, 1b, x7, 1576,0)

inst_732:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xb504f332; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0xb504f332, 0x40, 3f, x7, 1584,0)

inst_733:
// rs1_val==7378697629483820647 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xffffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0xffffffff, 0x6, 3f, x7, 1592,0)

inst_734:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x5555555555555556; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x5555555555555556, 0x0, 3f, x7, 1600,0)

inst_735:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xaaaaaaaaaaaaaaab; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0xaaaaaaaaaaaaaaab, 0x20, 3f, x7, 1608,0)

inst_736:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x6, 0x4, 1b, x7, 1616,0)

inst_737:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x3333333333333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x3333333333333334, 0x2, 3f, x7, 1624,0)

inst_738:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x6666666666666667; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x6666666666666667, 0x8, 1b, x7, 1632,0)

inst_739:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0xb504f334; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0xb504f334, 0x0, 1b, x7, 1640,0)

inst_740:
// rs1_val==7378697629483820647 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x1, 0x8, 1b, x7, 1648,0)

inst_741:
// rs1_val==7378697629483820647 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6666666666666667; op2val:0x100000001; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6666666666666667, 0x100000001, 0x6, 1b, x7, 1656,0)

inst_742:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x3; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x3, 0x6, 3f, x7, 1664,0)

inst_743:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x5555555555555555; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x5555555555555555, 0x4, 1b, x7, 1672,0)

inst_744:
// rs1_val==3037000500 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0xaaaaaaaaaaaaaaaa; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0xaaaaaaaaaaaaaaaa, 0x8, 3f, x7, 1680,0)

inst_745:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x5; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x5, 0x2, 1b, x7, 1688,0)

inst_746:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x3333333333333333; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x3333333333333333, 0x0, 1b, x7, 1696,0)

inst_747:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x6666666666666666; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x6666666666666666, 0x8, 3f, x7, 1704,0)

inst_748:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0xb504f333; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0xb504f333, 0x2, 1b, x7, 1712,0)

inst_749:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x0; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x0, 0x6, 1b, x7, 1720,0)

inst_750:
// rs1_val==3037000500 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x100000000; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x100000000, 0x400, 1b, x7, 1728,0)

inst_751:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x2; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x2, 0x2, 1b, x7, 1736,0)

inst_752:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x5555555555555554; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x5555555555555554, 0x0, 1b, x7, 1744,0)

inst_753:
// rs1_val==3037000500 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0xaaaaaaaaaaaaaaa9; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0xaaaaaaaaaaaaaaa9, 0x4, 1b, x7, 1752,0)

inst_754:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x4; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x4, 0x4, 1b, x7, 1760,0)

inst_755:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x3333333333333332; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x3333333333333332, 0x6, 3f, x7, 1768,0)

inst_756:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x6666666666666665; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x6666666666666665, 0x2, 1b, x7, 1776,0)

inst_757:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0xb504f332; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0xb504f332, 0x4, 1b, x7, 1784,0)

inst_758:
// rs1_val==3037000500 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0xffffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0xffffffff, 0x6, 3f, x7, 1792,0)

inst_759:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x5555555555555556; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x5555555555555556, 0x2, 3f, x7, 1800,0)

inst_760:
// rs1_val==3037000500 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0xaaaaaaaaaaaaaaab; immval:0x100; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0xaaaaaaaaaaaaaaab, 0x100, 3f, x7, 1808,0)

inst_761:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x6; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x6, 0x556, 1b, x7, 1816,0)

inst_762:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x3333333333333334; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x3333333333333334, 0x2, 1b, x7, 1824,0)

inst_763:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x6666666666666667; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x6666666666666667, 0x20, 3f, x7, 1832,0)

inst_764:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0xb504f334; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0xb504f334, 0x10, 3f, x7, 1840,0)

inst_765:
// rs1_val==3037000500 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x1; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x1, 0x8, 1b, x7, 1848,0)

inst_766:
// rs1_val==3037000500 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0xb504f334; op2val:0x100000001; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0xb504f334, 0x100000001, 0x8, 3f, x7, 1856,0)

inst_767:
// rs1_val==1 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x3; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x3, 0x6, 1b, x7, 1864,0)

inst_768:
// rs1_val==1 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x5555555555555555; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x5555555555555555, 0x4, 3f, x7, 1872,0)

inst_769:
// rs1_val==1 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xaaaaaaaaaaaaaaaa; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0xaaaaaaaaaaaaaaaa, 0x8, 1b, x7, 1880,0)

inst_770:
// rs1_val==1 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x5; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x5, 0x4, 1b, x7, 1888,0)

inst_771:
// rs1_val==1 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x3333333333333333; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x3333333333333333, 0x6, 3f, x7, 1896,0)

inst_772:
// rs1_val==1 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x6666666666666666; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x6666666666666666, 0x2, 3f, x7, 1904,0)

inst_773:
// rs1_val==1 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xb504f333; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0xb504f333, 0x4, 3f, x7, 1912,0)

inst_774:
// rs1_val==1 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x0, 0x4, 1b, x7, 1920,0)

inst_775:
// rs1_val==1 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x100000000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x100000000, 0x6, 3f, x7, 1928,0)

inst_776:
// rs1_val==1 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x2; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x2, 0x40, 3f, x7, 1936,0)

inst_777:
// rs1_val==1 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x5555555555555554; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x5555555555555554, 0x20, 3f, x7, 1944,0)

inst_778:
// rs1_val==1 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xaaaaaaaaaaaaaaa9; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x400, 1b, x7, 1952,0)

inst_779:
// rs1_val==1 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x4; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x4, 0x8, 3f, x7, 1960,0)

inst_780:
// rs1_val==1 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x3333333333333332; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x3333333333333332, 0x20, 3f, x7, 1968,0)

inst_781:
// rs1_val==1 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x6666666666666665; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x6666666666666665, 0x6, 3f, x7, 1976,0)

inst_782:
// rs1_val==1 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xb504f332; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0xb504f332, 0x80, 3f, x7, 1984,0)

inst_783:
// rs1_val==1 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xffffffff; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0xffffffff, 0xa, 1b, x7, 1992,0)

inst_784:
// rs1_val==1 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x5555555555555556; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x5555555555555556, 0x2, 1b, x7, 2000,0)

inst_785:
// rs1_val==1 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xaaaaaaaaaaaaaaab; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0x2, 3f, x7, 2008,0)

inst_786:
// rs1_val==1 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x6; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x6, 0x2, 3f, x7, 2016,0)

inst_787:
// rs1_val==1 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x3333333333333334; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x3333333333333334, 0x0, 1b, x7, 2024,0)

inst_788:
// rs1_val==1 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x6666666666666667; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x6666666666666667, 0x10, 3f, x7, 2032,0)

inst_789:
// rs1_val==1 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0xb504f334; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0xb504f334, 0x400, 3f, x7, 2040,0)
RVTEST_SIGBASE( x7,signature_x7_3)

inst_790:
// rs1_val==1 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x1; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x1, 0x200, 3f, x7, 0,0)

inst_791:
// rs1_val==1 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x1; op2val:0x100000001; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x1, 0x100000001, 0x200, 3f, x7, 8,0)

inst_792:
// rs1_val==4294967297 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x3; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x3, 0x8, 1b, x7, 16,0)

inst_793:
// rs1_val==4294967297 and rs2_val==6148914691236517205, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x5555555555555555; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x5555555555555555, 0x6, 1b, x7, 24,0)

inst_794:
// rs1_val==4294967297 and rs2_val==12297829382473034410, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xaaaaaaaaaaaaaaaa; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xaaaaaaaaaaaaaaaa, 0xa, 1b, x7, 32,0)

inst_795:
// rs1_val==4294967297 and rs2_val==5, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x5; immval:0xa; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x5, 0xa, 1b, x7, 40,0)

inst_796:
// rs1_val==4294967297 and rs2_val==3689348814741910323, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x3333333333333333; immval:0x20; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x3333333333333333, 0x20, 3f, x7, 48,0)

inst_797:
// rs1_val==4294967297 and rs2_val==7378697629483820646, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x6666666666666666; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x6666666666666666, 0x10, 3f, x7, 56,0)

inst_798:
// rs1_val==4294967297 and rs2_val==3037000499, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xb504f333; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xb504f333, 0x8, 1b, x7, 64,0)

inst_799:
// rs1_val==4294967297 and rs2_val==0, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x0; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x0, 0x4, 1b, x7, 72,0)

inst_800:
// rs1_val==4294967297 and rs2_val==4294967296, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x100000000; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x100000000, 0x200, 3f, x7, 80,0)

inst_801:
// rs1_val==4294967297 and rs2_val==2, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x2; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x2, 0x2, 1b, x7, 88,0)

inst_802:
// rs1_val==4294967297 and rs2_val==6148914691236517204, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x5555555555555554; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x5555555555555554, 0x2, 1b, x7, 96,0)

inst_803:
// rs1_val==4294967297 and rs2_val==12297829382473034409, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xaaaaaaaaaaaaaaa9; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xaaaaaaaaaaaaaaa9, 0x2, 3f, x7, 104,0)

inst_804:
// rs1_val==4294967297 and rs2_val==4, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x4; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x4, 0x40, 3f, x7, 112,0)

inst_805:
// rs1_val==4294967297 and rs2_val==3689348814741910322, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x3333333333333332; immval:0x80; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x3333333333333332, 0x80, 3f, x7, 120,0)

inst_806:
// rs1_val==4294967297 and rs2_val==7378697629483820645, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x6666666666666665; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x6666666666666665, 0x200, 3f, x7, 128,0)

inst_807:
// rs1_val==4294967297 and rs2_val==3037000498, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xb504f332; immval:0x8; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xb504f332, 0x8, 3f, x7, 136,0)

inst_808:
// rs1_val==4294967297 and rs2_val==4294967295, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xffffffff; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xffffffff, 0x6, 3f, x7, 144,0)

inst_809:
// rs1_val==4294967297 and rs2_val==6148914691236517206, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x5555555555555556; immval:0x400; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x5555555555555556, 0x400, 1b, x7, 152,0)

inst_810:
// rs1_val==4294967297 and rs2_val==12297829382473034411, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xaaaaaaaaaaaaaaab; immval:0x10; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xaaaaaaaaaaaaaaab, 0x10, 3f, x7, 160,0)

inst_811:
// rs1_val==4294967297 and rs2_val==6, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x6; immval:0x4; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x6, 0x4, 1b, x7, 168,0)

inst_812:
// rs1_val==4294967297 and rs2_val==3689348814741910324, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x3333333333333334; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x3333333333333334, 0x200, 3f, x7, 176,0)

inst_813:
// rs1_val==4294967297 and rs2_val==7378697629483820647, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x6666666666666667; immval:0x0; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x6666666666666667, 0x0, 1b, x7, 184,0)

inst_814:
// rs1_val==4294967297 and rs2_val==3037000500, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0xb504f334; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0xb504f334, 0x6, 3f, x7, 192,0)

inst_815:
// rs1_val==4294967297 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x1; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x1, 0x6, 1b, x7, 200,0)

inst_816:
// rs1_val==4294967297 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x100000001; op2val:0x100000001; immval:0x2; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x100000001, 0x100000001, 0x2, 1b, x7, 208,0)

inst_817:
// rs1_val==6 and rs2_val==1, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x1; immval:0x40; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x1, 0x40, 3f, x7, 216,0)

inst_818:
// rs1_val==6 and rs2_val==4294967297, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x6; op2val:0x100000001; immval:0x556; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x6, 0x100000001, 0x556, 1b, x7, 224,0)

inst_819:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x3333333333333334; op2val:0x3; immval:0x200; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x3333333333333334, 0x3, 0x200, 3f, x7, 232,0)

inst_820:
// rs2_val == 16384, 
// opcode: bgeu, op1:x10; op2:x11; op1val:0x80000000000000; op2val:0x4000; immval:0x6; align:0
TEST_BRANCH_OP(bgeu, x8, x10, x11, 0x80000000000000, 0x4000, 0x6, 3f, x7, 240,0)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x6_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x6_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x7_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x7_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x7_2:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x7_3:
    .fill 31*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
