
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the lwu instruction of the RISC-V I extension for the lwu-align covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*RV64.*I.*);def TEST_CASE_1=True;",lwu-align)

RVTEST_SIGBASE( x14,signature_x14_1)

inst_0:
// rs1 == rd, rs1==x26, rd==x26, ea_align == 0 and (imm_val % 4) == 0, imm_val > 0
// opcode:lwu op1:x26; dest:x26; immval:0x200; align:0
TEST_LOAD(x14,x25,0,x26,x26,0x200,0,lwu,0)

inst_1:
// rs1 != rd, rs1==x17, rd==x29, ea_align == 0 and (imm_val % 4) == 1, imm_val < 0
// opcode:lwu op1:x17; dest:x29; immval:-0x7; align:0
TEST_LOAD(x14,x25,0,x17,x29,-0x7,8,lwu,0)

inst_2:
// rs1==x13, rd==x6, ea_align == 0 and (imm_val % 4) == 2, 
// opcode:lwu op1:x13; dest:x6; immval:-0x2; align:0
TEST_LOAD(x14,x25,0,x13,x6,-0x2,16,lwu,0)

inst_3:
// rs1==x11, rd==x21, ea_align == 0 and (imm_val % 4) == 3, 
// opcode:lwu op1:x11; dest:x21; immval:-0x21; align:0
TEST_LOAD(x14,x25,0,x11,x21,-0x21,24,lwu,0)

inst_4:
// rs1==x7, rd==x8, imm_val == 0, 
// opcode:lwu op1:x7; dest:x8; immval:0x0; align:0
TEST_LOAD(x14,x25,0,x7,x8,0x0,32,lwu,0)

inst_5:
// rs1==x30, rd==x4, 
// opcode:lwu op1:x30; dest:x4; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x30,x4,-0x800,40,lwu,0)

inst_6:
// rs1==x1, rd==x0, 
// opcode:lwu op1:x1; dest:x0; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x1,x0,-0x800,48,lwu,0)

inst_7:
// rs1==x22, rd==x20, 
// opcode:lwu op1:x22; dest:x20; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x22,x20,-0x800,56,lwu,0)

inst_8:
// rs1==x9, rd==x2, 
// opcode:lwu op1:x9; dest:x2; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x9,x2,-0x800,64,lwu,0)

inst_9:
// rs1==x28, rd==x23, 
// opcode:lwu op1:x28; dest:x23; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x28,x23,-0x800,72,lwu,0)

inst_10:
// rs1==x24, rd==x11, 
// opcode:lwu op1:x24; dest:x11; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x24,x11,-0x800,80,lwu,0)

inst_11:
// rs1==x3, rd==x15, 
// opcode:lwu op1:x3; dest:x15; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x3,x15,-0x800,88,lwu,0)

inst_12:
// rs1==x8, rd==x24, 
// opcode:lwu op1:x8; dest:x24; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x8,x24,-0x800,96,lwu,0)

inst_13:
// rs1==x4, rd==x7, 
// opcode:lwu op1:x4; dest:x7; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x4,x7,-0x800,104,lwu,0)

inst_14:
// rs1==x2, rd==x18, 
// opcode:lwu op1:x2; dest:x18; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x2,x18,-0x800,112,lwu,0)

inst_15:
// rs1==x10, rd==x3, 
// opcode:lwu op1:x10; dest:x3; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x10,x3,-0x800,120,lwu,0)

inst_16:
// rs1==x29, rd==x9, 
// opcode:lwu op1:x29; dest:x9; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x29,x9,-0x800,128,lwu,0)

inst_17:
// rs1==x12, rd==x10, 
// opcode:lwu op1:x12; dest:x10; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x12,x10,-0x800,136,lwu,0)

inst_18:
// rs1==x23, rd==x19, 
// opcode:lwu op1:x23; dest:x19; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x23,x19,-0x800,144,lwu,0)

inst_19:
// rs1==x5, rd==x30, 
// opcode:lwu op1:x5; dest:x30; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x5,x30,-0x800,152,lwu,0)

inst_20:
// rs1==x16, rd==x13, 
// opcode:lwu op1:x16; dest:x13; immval:-0x800; align:0
TEST_LOAD(x14,x25,0,x16,x13,-0x800,160,lwu,0)

inst_21:
// rs1==x6, rd==x31, 
// opcode:lwu op1:x6; dest:x31; immval:-0x800; align:0
TEST_LOAD(x14,x3,0,x6,x31,-0x800,168,lwu,0)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_22:
// rs1==x15, rd==x14, 
// opcode:lwu op1:x15; dest:x14; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x15,x14,-0x800,0,lwu,0)

inst_23:
// rs1==x27, rd==x25, 
// opcode:lwu op1:x27; dest:x25; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x27,x25,-0x800,8,lwu,0)

inst_24:
// rs1==x31, rd==x12, 
// opcode:lwu op1:x31; dest:x12; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x31,x12,-0x800,16,lwu,0)

inst_25:
// rs1==x18, rd==x27, 
// opcode:lwu op1:x18; dest:x27; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x18,x27,-0x800,24,lwu,0)

inst_26:
// rs1==x20, rd==x16, 
// opcode:lwu op1:x20; dest:x16; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x20,x16,-0x800,32,lwu,0)

inst_27:
// rs1==x19, rd==x28, 
// opcode:lwu op1:x19; dest:x28; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x19,x28,-0x800,40,lwu,0)

inst_28:
// rs1==x21, rd==x17, 
// opcode:lwu op1:x21; dest:x17; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x21,x17,-0x800,48,lwu,0)

inst_29:
// rs1==x25, rd==x22, 
// opcode:lwu op1:x25; dest:x22; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x25,x22,-0x800,56,lwu,0)

inst_30:
// rs1==x14, rd==x1, 
// opcode:lwu op1:x14; dest:x1; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x14,x1,-0x800,64,lwu,0)

inst_31:
// rd==x5, 
// opcode:lwu op1:x8; dest:x5; immval:-0x800; align:0
TEST_LOAD(x2,x3,0,x8,x5,-0x800,72,lwu,0)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x14_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x14_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 10*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
