
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the ori instruction of the RISC-V I extension for the ori covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",ori)

RVTEST_SIGBASE( x11,signature_x11_1)

inst_0:
// rs1 == rd, rs1==x6, rd==x6, imm_val == (-2**(12-1)), imm_val == -2048, rs1_val != imm_val, rs1_val > 0 and imm_val < 0, rs1_val == 8192
// opcode: ori ; op1:x6; dest:x6; op1val:0x2000;  immval:-0x800
TEST_IMM_OP( ori, x6, x6, 0xfffffffffffff800, 0x2000, -0x800, x11, 0, x9)

inst_1:
// rs1 != rd, rs1==x28, rd==x2, imm_val == 0, rs1_val == 4, rs1_val==4 and imm_val==0
// opcode: ori ; op1:x28; dest:x2; op1val:0x4;  immval:0x0
TEST_IMM_OP( ori, x2, x28, 0x4, 0x4, 0x0, x11, 8, x9)

inst_2:
// rs1==x25, rd==x19, imm_val == (2**(12-1)-1), rs1_val == -2, rs1_val < 0 and imm_val > 0, imm_val == 2047
// opcode: ori ; op1:x25; dest:x19; op1val:-0x2;  immval:0x7ff
TEST_IMM_OP( ori, x19, x25, 0xffffffffffffffff, -0x2, 0x7ff, x11, 16, x9)

inst_3:
// rs1==x0, rd==x1, imm_val == 1, rs1_val > 0 and imm_val > 0
// opcode: ori ; op1:x0; dest:x1; op1val:0x0;  immval:0x1
TEST_IMM_OP( ori, x1, x0, 0x1, 0x0, 0x1, x11, 24, x9)

inst_4:
// rs1==x4, rd==x7, rs1_val == (-2**(xlen-1)), rs1_val == -9223372036854775808
// opcode: ori ; op1:x4; dest:x7; op1val:-0x8000000000000000;  immval:0x666
TEST_IMM_OP( ori, x7, x4, 0x8000000000000666, -0x8000000000000000, 0x666, x11, 32, x9)

inst_5:
// rs1==x29, rd==x8, rs1_val == 0, imm_val == -513
// opcode: ori ; op1:x29; dest:x8; op1val:0x0;  immval:-0x201
TEST_IMM_OP( ori, x8, x29, 0xfffffffffffffdff, 0x0, -0x201, x11, 40, x9)

inst_6:
// rs1==x22, rd==x17, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807
// opcode: ori ; op1:x22; dest:x17; op1val:0x7fffffffffffffff;  immval:-0x201
TEST_IMM_OP( ori, x17, x22, 0xffffffffffffffff, 0x7fffffffffffffff, -0x201, x11, 48, x9)

inst_7:
// rs1==x17, rd==x10, rs1_val == 1, 
// opcode: ori ; op1:x17; dest:x10; op1val:0x1;  immval:-0x6
TEST_IMM_OP( ori, x10, x17, 0xfffffffffffffffb, 0x1, -0x6, x11, 56, x9)

inst_8:
// rs1==x5, rd==x30, rs1_val == imm_val, rs1_val==5 and imm_val==5
// opcode: ori ; op1:x5; dest:x30; op1val:0x5;  immval:0x5
TEST_IMM_OP( ori, x30, x5, 0x5, 0x5, 0x5, x11, 64, x9)

inst_9:
// rs1==x12, rd==x0, rs1_val < 0 and imm_val < 0, rs1_val == -2097153, imm_val == -9
// opcode: ori ; op1:x12; dest:x0; op1val:-0x200001;  immval:-0x9
TEST_IMM_OP( ori, x0, x12, 0, -0x200001, -0x9, x11, 72, x9)

inst_10:
// rs1==x16, rd==x3, imm_val == 2, rs1_val == 9007199254740992
// opcode: ori ; op1:x16; dest:x3; op1val:0x20000000000000;  immval:0x2
TEST_IMM_OP( ori, x3, x16, 0x20000000000002, 0x20000000000000, 0x2, x11, 80, x9)

inst_11:
// rs1==x31, rd==x20, imm_val == 4, rs1_val == -65
// opcode: ori ; op1:x31; dest:x20; op1val:-0x41;  immval:0x4
TEST_IMM_OP( ori, x20, x31, 0xffffffffffffffbf, -0x41, 0x4, x11, 88, x9)

inst_12:
// rs1==x3, rd==x12, imm_val == 8, rs1_val == 16384
// opcode: ori ; op1:x3; dest:x12; op1val:0x4000;  immval:0x8
TEST_IMM_OP( ori, x12, x3, 0x4008, 0x4000, 0x8, x11, 96, x9)

inst_13:
// rs1==x18, rd==x21, imm_val == 16, rs1_val == -281474976710657
// opcode: ori ; op1:x18; dest:x21; op1val:-0x1000000000001;  immval:0x10
TEST_IMM_OP( ori, x21, x18, 0xfffeffffffffffff, -0x1000000000001, 0x10, x11, 104, x9)

inst_14:
// rs1==x15, rd==x24, imm_val == 32, rs1_val == 4503599627370496
// opcode: ori ; op1:x15; dest:x24; op1val:0x10000000000000;  immval:0x20
TEST_IMM_OP( ori, x24, x15, 0x10000000000020, 0x10000000000000, 0x20, x11, 112, x9)

inst_15:
// rs1==x10, rd==x23, imm_val == 64, rs1_val == -268435457
// opcode: ori ; op1:x10; dest:x23; op1val:-0x10000001;  immval:0x40
TEST_IMM_OP( ori, x23, x10, 0xffffffffefffffff, -0x10000001, 0x40, x11, 120, x9)

inst_16:
// rs1==x20, rd==x18, imm_val == 128, 
// opcode: ori ; op1:x20; dest:x18; op1val:-0x8000000000000000;  immval:0x80
TEST_IMM_OP( ori, x18, x20, 0x8000000000000080, -0x8000000000000000, 0x80, x11, 128, x9)

inst_17:
// rs1==x24, rd==x14, imm_val == 256, rs1_val == 4294967296
// opcode: ori ; op1:x24; dest:x14; op1val:0x100000000;  immval:0x100
TEST_IMM_OP( ori, x14, x24, 0x100000100, 0x100000000, 0x100, x11, 136, x9)

inst_18:
// rs1==x26, rd==x29, imm_val == 512, rs1_val == 2199023255552
// opcode: ori ; op1:x26; dest:x29; op1val:0x20000000000;  immval:0x200
TEST_IMM_OP( ori, x29, x26, 0x20000000200, 0x20000000000, 0x200, x11, 144, x9)

inst_19:
// rs1==x1, rd==x28, imm_val == 1024, rs1_val == -9007199254740993
// opcode: ori ; op1:x1; dest:x28; op1val:-0x20000000000001;  immval:0x400
TEST_IMM_OP( ori, x28, x1, 0xffdfffffffffffff, -0x20000000000001, 0x400, x11, 152, x3)

inst_20:
// rs1==x2, rd==x22, imm_val == -2, 
// opcode: ori ; op1:x2; dest:x22; op1val:0x6666666666666667;  immval:-0x2
TEST_IMM_OP( ori, x22, x2, 0xffffffffffffffff, 0x6666666666666667, -0x2, x11, 160, x3)

inst_21:
// rs1==x9, rd==x16, imm_val == -3, rs1_val == 33554432
// opcode: ori ; op1:x9; dest:x16; op1val:0x2000000;  immval:-0x3
TEST_IMM_OP( ori, x16, x9, 0xfffffffffffffffd, 0x2000000, -0x3, x11, 168, x3)
RVTEST_SIGBASE( x1,signature_x1_0)

inst_22:
// rs1==x13, rd==x26, imm_val == -5, 
// opcode: ori ; op1:x13; dest:x26; op1val:0x7fffffffffffffff;  immval:-0x5
TEST_IMM_OP( ori, x26, x13, 0xffffffffffffffff, 0x7fffffffffffffff, -0x5, x1, 0, x3)

inst_23:
// rs1==x19, rd==x25, imm_val == -17, 
// opcode: ori ; op1:x19; dest:x25; op1val:0x3333333333333334;  immval:-0x11
TEST_IMM_OP( ori, x25, x19, 0xffffffffffffffff, 0x3333333333333334, -0x11, x1, 8, x3)

inst_24:
// rs1==x27, rd==x15, imm_val == -33, rs1_val == -262145
// opcode: ori ; op1:x27; dest:x15; op1val:-0x40001;  immval:-0x21
TEST_IMM_OP( ori, x15, x27, 0xffffffffffffffff, -0x40001, -0x21, x1, 16, x3)

inst_25:
// rs1==x7, rd==x9, imm_val == -65, rs1_val == 6148914691236517205
// opcode: ori ; op1:x7; dest:x9; op1val:0x5555555555555555;  immval:-0x41
TEST_IMM_OP( ori, x9, x7, 0xffffffffffffffff, 0x5555555555555555, -0x41, x1, 24, x3)

inst_26:
// rs1==x30, rd==x4, imm_val == -129, rs1_val == 8589934592
// opcode: ori ; op1:x30; dest:x4; op1val:0x200000000;  immval:-0x81
TEST_IMM_OP( ori, x4, x30, 0xffffffffffffff7f, 0x200000000, -0x81, x1, 32, x3)

inst_27:
// rs1==x23, rd==x5, imm_val == -257, rs1_val == -8388609
// opcode: ori ; op1:x23; dest:x5; op1val:-0x800001;  immval:-0x101
TEST_IMM_OP( ori, x5, x23, 0xffffffffffffffff, -0x800001, -0x101, x1, 40, x3)

inst_28:
// rs1==x21, rd==x11, imm_val == -1025, 
// opcode: ori ; op1:x21; dest:x11; op1val:0x3;  immval:-0x401
TEST_IMM_OP( ori, x11, x21, 0xfffffffffffffbff, 0x3, -0x401, x1, 48, x3)

inst_29:
// rs1==x11, rd==x27, imm_val == 1365, rs1_val==0 and imm_val==1365
// opcode: ori ; op1:x11; dest:x27; op1val:0x0;  immval:0x555
TEST_IMM_OP( ori, x27, x11, 0x555, 0x0, 0x555, x1, 56, x3)

inst_30:
// rs1==x8, rd==x13, imm_val == -1366, rs1_val == 281474976710656
// opcode: ori ; op1:x8; dest:x13; op1val:0x1000000000000;  immval:-0x556
TEST_IMM_OP( ori, x13, x8, 0xfffffffffffffaaa, 0x1000000000000, -0x556, x1, 64, x3)

inst_31:
// rs1==x14, rd==x31, rs1_val == 2, 
// opcode: ori ; op1:x14; dest:x31; op1val:0x2;  immval:0x400
TEST_IMM_OP( ori, x31, x14, 0x402, 0x2, 0x400, x1, 72, x3)

inst_32:
// rs1_val == 8, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x8;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xc, 0x8, 0x4, x1, 80, x3)

inst_33:
// rs1_val == 16, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x10;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x676, 0x10, 0x666, x1, 88, x3)

inst_34:
// rs1_val == 32, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x20;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x2d, 0x20, 0x2d, x1, 96, x3)

inst_35:
// rs1_val == 64, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x40;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd4, 0x40, -0x2c, x1, 104, x3)

inst_36:
// rs1_val == 128, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x80;  immval:-0x5
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffb, 0x80, -0x5, x1, 112, x3)

inst_37:
// rs1_val == 256, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x100;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x104, 0x100, 0x4, x1, 120, x3)

inst_38:
// rs1_val == 512, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x200;  immval:-0x400
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffe00, 0x200, -0x400, x1, 128, x3)

inst_39:
// rs1_val == 1024, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x400;  immval:-0x101
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeff, 0x400, -0x101, x1, 136, x3)

inst_40:
// rs1_val == 2048, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x800;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x803, 0x800, 0x3, x1, 144, x3)

inst_41:
// rs1_val == 4096, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x1000;  immval:0x200
TEST_IMM_OP( ori, x11, x10, 0x1200, 0x1000, 0x200, x1, 152, x3)

inst_42:
// rs1_val == 32768, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x8000;  immval:0x200
TEST_IMM_OP( ori, x11, x10, 0x8200, 0x8000, 0x200, x1, 160, x3)

inst_43:
// rs1_val == 65536, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x10000;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x10000, 0x10000, 0x0, x1, 168, x3)

inst_44:
// rs1_val == 131072, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x20000;  immval:-0x2
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffe, 0x20000, -0x2, x1, 176, x3)

inst_45:
// rs1_val == 262144, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x40000;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x4002c, 0x40000, 0x2c, x1, 184, x3)

inst_46:
// rs1_val == 524288, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x80000;  immval:-0x5
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffb, 0x80000, -0x5, x1, 192, x3)

inst_47:
// rs1_val == 1048576, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x100000;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x100003, 0x100000, 0x3, x1, 200, x3)

inst_48:
// rs1_val == 2097152, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x200000;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x200005, 0x200000, 0x5, x1, 208, x3)

inst_49:
// rs1_val == 4194304, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x400000;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x400556, 0x400000, 0x556, x1, 216, x3)

inst_50:
// rs1_val == 8388608, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x800000;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd4, 0x800000, -0x2c, x1, 224, x3)

inst_51:
// rs1_val == 16777216, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x1000000;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x100002e, 0x1000000, 0x2e, x1, 232, x3)

inst_52:
// rs1_val == 67108864, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x4000000, 0x4000000, 0x0, x1, 240, x3)

inst_53:
// rs1_val == 134217728, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x8000333, 0x8000000, 0x333, x1, 248, x3)

inst_54:
// rs1_val == 268435456, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x10000003, 0x10000000, 0x3, x1, 256, x3)

inst_55:
// rs1_val == 536870912, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x20000000;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd4, 0x20000000, -0x2c, x1, 264, x3)

inst_56:
// rs1_val == 1073741824, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x40000000;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x40000002, 0x40000000, 0x2, x1, 272, x3)

inst_57:
// rs1_val == 2147483648, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x80000000;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd3, 0x80000000, -0x2d, x1, 280, x3)

inst_58:
// rs1_val == 17179869184, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x400000000;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x400000004, 0x400000000, 0x4, x1, 288, x3)

inst_59:
// rs1_val == 34359738368, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x800000000;  immval:0x40
TEST_IMM_OP( ori, x11, x10, 0x800000040, 0x800000000, 0x40, x1, 296, x3)

inst_60:
// rs1_val == 68719476736, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x1000000000;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x1000000332, 0x1000000000, 0x332, x1, 304, x3)

inst_61:
// rs1_val == 137438953472, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2000000000;  immval:-0xa
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff6, 0x2000000000, -0xa, x1, 312, x3)

inst_62:
// rs1_val == 274877906944, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4000000000;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd3, 0x4000000000, -0x2d, x1, 320, x3)

inst_63:
// rs1_val == 549755813888, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x800000002d, 0x8000000000, 0x2d, x1, 328, x3)

inst_64:
// rs1_val == 1099511627776, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x10000000000;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd3, 0x10000000000, -0x2d, x1, 336, x3)

inst_65:
// rs1_val == 4398046511104, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x40000000000;  immval:-0xa
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff6, 0x40000000000, -0xa, x1, 344, x3)

inst_66:
// rs1_val == 8796093022208, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x80000000000;  immval:-0x41
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffbf, 0x80000000000, -0x41, x1, 352, x3)

inst_67:
// rs1_val == 17592186044416, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x100000000000;  immval:-0x5
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffb, 0x100000000000, -0x5, x1, 360, x3)

inst_68:
// rs1_val == 35184372088832, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x200000000000, 0x200000000000, 0x0, x1, 368, x3)

inst_69:
// rs1_val == 70368744177664, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x400000000667, 0x400000000000, 0x667, x1, 376, x3)

inst_70:
// rs1_val == 140737488355328, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x800000000000;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd4, 0x800000000000, -0x2c, x1, 384, x3)

inst_71:
// rs1_val == 562949953421312, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x400
TEST_IMM_OP( ori, x11, x10, 0x2000000000400, 0x2000000000000, 0x400, x1, 392, x3)

inst_72:
// rs1_val == 1125899906842624, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:0x200
TEST_IMM_OP( ori, x11, x10, 0x4000000000200, 0x4000000000000, 0x200, x1, 400, x3)

inst_73:
// rs1_val == 2251799813685248, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x8000000000000;  immval:0x9
TEST_IMM_OP( ori, x11, x10, 0x8000000000009, 0x8000000000000, 0x9, x1, 408, x3)

inst_74:
// rs1_val == 18014398509481984, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:-0x81
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffff7f, 0x40000000000000, -0x81, x1, 416, x3)

inst_75:
// rs1_val == 36028797018963968, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:0x7ff
TEST_IMM_OP( ori, x11, x10, 0x800000000007ff, 0x80000000000000, 0x7ff, x1, 424, x3)

inst_76:
// rs1_val == 72057594037927936, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:-0x4
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffc, 0x100000000000000, -0x4, x1, 432, x3)

inst_77:
// rs1_val == 144115188075855872, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x200000000000004, 0x200000000000000, 0x4, x1, 440, x3)

inst_78:
// rs1_val == 288230376151711744, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x400000000000333, 0x400000000000000, 0x333, x1, 448, x3)

inst_79:
// rs1_val == 576460752303423488, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:-0x4
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffc, 0x800000000000000, -0x4, x1, 456, x3)

inst_80:
// rs1_val == 1152921504606846976, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x1000000000000333, 0x1000000000000000, 0x333, x1, 464, x3)

inst_81:
// rs1_val == 2305843009213693952, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x100
TEST_IMM_OP( ori, x11, x10, 0x2000000000000100, 0x2000000000000000, 0x100, x1, 472, x3)

inst_82:
// rs1_val == 4611686018427387904, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4000000000000000;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x4000000000000003, 0x4000000000000000, 0x3, x1, 480, x3)

inst_83:
// rs1_val == -3, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x3;  immval:-0x400
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffd, -0x3, -0x400, x1, 488, x3)

inst_84:
// rs1_val == -5, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffb, -0x5, -0x555, x1, 496, x3)

inst_85:
// rs1_val == -9, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x9;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x9, 0x2d, x1, 504, x3)

inst_86:
// rs1_val == -17, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x11;  immval:0x9
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffef, -0x11, 0x9, x1, 512, x3)

inst_87:
// rs1_val == -33, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x21;  immval:-0x2
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x21, -0x2, x1, 520, x3)

inst_88:
// rs1_val == -129, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x81;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffff7f, -0x81, 0x332, x1, 528, x3)

inst_89:
// rs1_val == -257, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x101;  immval:-0x7
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x101, -0x7, x1, 536, x3)

inst_90:
// rs1_val == -513, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x201;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffdff, -0x201, 0x0, x1, 544, x3)

inst_91:
// rs1_val == -1025, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x401;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbff, -0x401, 0x0, x1, 552, x3)

inst_92:
// rs1_val == -2049, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x801;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffff7ff, -0x801, 0x4, x1, 560, x3)

inst_93:
// rs1_val == -4097, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x1001;  immval:-0x1
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x1001, -0x1, x1, 568, x3)

inst_94:
// rs1_val == -8193, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x2001;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x2001, -0x2c, x1, 576, x3)

inst_95:
// rs1_val == -16385, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffbfff, -0x4001, 0x667, x1, 584, x3)

inst_96:
// rs1_val == -32769, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x9
TEST_IMM_OP( ori, x11, x10, 0xffffffffffff7fff, -0x8001, 0x9, x1, 592, x3)

inst_97:
// rs1_val == -65537, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x10001;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffeffff, -0x10001, 0x554, x1, 600, x3)

inst_98:
// rs1_val == -131073, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x20001;  immval:-0x101
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x20001, -0x101, x1, 608, x3)

inst_99:
// rs1_val == -524289, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x80001;  immval:0x200
TEST_IMM_OP( ori, x11, x10, 0xfffffffffff7ffff, -0x80001, 0x200, x1, 616, x3)

inst_100:
// rs1_val == -1048577, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x100001;  immval:0x40
TEST_IMM_OP( ori, x11, x10, 0xffffffffffefffff, -0x100001, 0x40, x1, 624, x3)

inst_101:
// rs1_val == -4194305, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x400001;  immval:-0x41
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x400001, -0x41, x1, 632, x3)

inst_102:
// rs1_val == -16777217, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x1000001;  immval:0x100
TEST_IMM_OP( ori, x11, x10, 0xfffffffffeffffff, -0x1000001, 0x100, x1, 640, x3)

inst_103:
// rs1_val == -33554433, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x2000001;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xfffffffffdffffff, -0x2000001, 0x0, x1, 648, x3)

inst_104:
// rs1_val == -67108865, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffbffffff, -0x4000001, 0x2d, x1, 656, x3)

inst_105:
// rs1_val == -134217729, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x8000001;  immval:-0x8
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x8000001, -0x8, x1, 664, x3)

inst_106:
// rs1_val == -536870913, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x20000001;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x20000001, -0x556, x1, 672, x3)

inst_107:
// rs1_val == -1073741825, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xffffffffbfffffff, -0x40000001, 0x0, x1, 680, x3)

inst_108:
// rs1_val == -2147483649, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x80000001;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xffffffff7fffffff, -0x80000001, 0x0, x1, 688, x3)

inst_109:
// rs1_val == -4294967297, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x100000001;  immval:-0x3
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x100000001, -0x3, x1, 696, x3)

inst_110:
// rs1_val == -8589934593, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x200000001;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xfffffffdffffffff, -0x200000001, 0x0, x1, 704, x3)

inst_111:
// rs1_val == -17179869185, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x400000001;  immval:-0x9
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x400000001, -0x9, x1, 712, x3)

inst_112:
// rs1_val == -34359738369, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x800000001;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xfffffff7ffffffff, -0x800000001, 0x4, x1, 720, x3)

inst_113:
// rs1_val == -68719476737, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x1000000001;  immval:0x200
TEST_IMM_OP( ori, x11, x10, 0xffffffefffffffff, -0x1000000001, 0x200, x1, 728, x3)

inst_114:
// rs1_val == -137438953473, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x2000000001;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0xffffffdfffffffff, -0x2000000001, 0x6, x1, 736, x3)

inst_115:
// rs1_val == -274877906945, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0xffffffbfffffffff, -0x4000000001, 0x666, x1, 744, x3)

inst_116:
// rs1_val == -549755813889, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:-0x800
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x8000000001, -0x800, x1, 752, x3)

inst_117:
// rs1_val == -1099511627777, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0xfffffeffffffffff, -0x10000000001, 0x3, x1, 760, x3)

inst_118:
// rs1_val == -2199023255553, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x20000000001;  immval:0x3ff
TEST_IMM_OP( ori, x11, x10, 0xfffffdffffffffff, -0x20000000001, 0x3ff, x1, 768, x3)

inst_119:
// rs1_val == -4398046511105, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x40000000001;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xfffffbffffffffff, -0x40000000001, 0x554, x1, 776, x3)

inst_120:
// rs1_val == -8796093022209, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x80000000001;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xfffff7ffffffffff, -0x80000000001, 0x4, x1, 784, x3)

inst_121:
// rs1_val == -17592186044417, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0xffffefffffffffff, -0x100000000001, 0x2, x1, 792, x3)

inst_122:
// rs1_val == -35184372088833, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x200000000001, -0x556, x1, 800, x3)

inst_123:
// rs1_val == -70368744177665, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x400000000001;  immval:-0x3
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x400000000001, -0x3, x1, 808, x3)

inst_124:
// rs1_val == -140737488355329, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:-0x400
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x800000000001, -0x400, x1, 816, x3)

inst_125:
// rs1_val == -562949953421313, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x2000000000001;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x2000000000001, -0x2d, x1, 824, x3)

inst_126:
// rs1_val == -1125899906842625, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x4000000000001, -0x555, x1, 832, x3)

inst_127:
// rs1_val == -2251799813685249, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x8000000000001;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0xfff7ffffffffffff, -0x8000000000001, 0x665, x1, 840, x3)

inst_128:
// rs1_val == -4503599627370497, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:-0x400
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x10000000000001, -0x400, x1, 848, x3)

inst_129:
// rs1_val == -18014398509481985, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x40000000000001;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0xffbfffffffffffff, -0x40000000000001, 0x5, x1, 856, x3)

inst_130:
// rs1_val == -36028797018963969, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x80000000000001;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0xff7fffffffffffff, -0x80000000000001, 0x556, x1, 864, x3)

inst_131:
// rs1_val == -72057594037927937, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:0x10
TEST_IMM_OP( ori, x11, x10, 0xfeffffffffffffff, -0x100000000000001, 0x10, x1, 872, x3)

inst_132:
// rs1_val == -144115188075855873, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:-0x4
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x200000000000001, -0x4, x1, 880, x3)

inst_133:
// rs1_val == -288230376151711745, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x400000000000001;  immval:-0x101
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x400000000000001, -0x101, x1, 888, x3)

inst_134:
// rs1_val == -576460752303423489, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:0x20
TEST_IMM_OP( ori, x11, x10, 0xf7ffffffffffffff, -0x800000000000001, 0x20, x1, 896, x3)

inst_135:
// rs1_val == -1152921504606846977, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:-0x8
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x1000000000000001, -0x8, x1, 904, x3)

inst_136:
// rs1_val == -2305843009213693953, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:0x7
TEST_IMM_OP( ori, x11, x10, 0xdfffffffffffffff, -0x2000000000000001, 0x7, x1, 912, x3)

inst_137:
// rs1_val == -4611686018427387905, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:-0x4
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x4000000000000001, -0x4, x1, 920, x3)

inst_138:
// rs1_val == -6148914691236517206, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x9
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555556, 0x9, x1, 928, x3)

inst_139:
// rs1_val==3 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x3, 0x3, 0x3, x1, 936, x3)

inst_140:
// rs1_val==3 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x557, 0x3, 0x555, x1, 944, x3)

inst_141:
// rs1_val==3 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaab, 0x3, -0x556, x1, 952, x3)

inst_142:
// rs1_val==3 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x7, 0x3, 0x5, x1, 960, x3)

inst_143:
// rs1_val==3 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x333, 0x3, 0x333, x1, 968, x3)

inst_144:
// rs1_val==3 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x667, 0x3, 0x666, x1, 976, x3)

inst_145:
// rs1_val==3 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd3, 0x3, -0x2d, x1, 984, x3)

inst_146:
// rs1_val==3 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x2f, 0x3, 0x2d, x1, 992, x3)

inst_147:
// rs1_val==3 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x3, 0x3, 0x2, x1, 1000, x3)

inst_148:
// rs1_val==3 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x557, 0x3, 0x554, x1, 1008, x3)

inst_149:
// rs1_val==3 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x3, 0x3, 0x0, x1, 1016, x3)

inst_150:
// rs1_val==3 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x7, 0x3, 0x4, x1, 1024, x3)

inst_151:
// rs1_val==3 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x333, 0x3, 0x332, x1, 1032, x3)

inst_152:
// rs1_val==3 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x667, 0x3, 0x665, x1, 1040, x3)

inst_153:
// rs1_val==3 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x2f, 0x3, 0x2c, x1, 1048, x3)

inst_154:
// rs1_val==3 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x557, 0x3, 0x556, x1, 1056, x3)

inst_155:
// rs1_val==3 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaab, 0x3, -0x555, x1, 1064, x3)

inst_156:
// rs1_val==3 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x7, 0x3, 0x6, x1, 1072, x3)

inst_157:
// rs1_val==3 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x337, 0x3, 0x334, x1, 1080, x3)

inst_158:
// rs1_val==3 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x667, 0x3, 0x667, x1, 1088, x3)

inst_159:
// rs1_val==3 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd7, 0x3, -0x2c, x1, 1096, x3)

inst_160:
// rs1_val==3 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x2f, 0x3, 0x2e, x1, 1104, x3)

inst_161:
// rs1_val==6148914691236517205 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x5555555555555557, 0x5555555555555555, 0x3, x1, 1112, x3)

inst_162:
// rs1_val==6148914691236517205 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x5555555555555555, 0x5555555555555555, 0x555, x1, 1120, x3)

inst_163:
// rs1_val==6148914691236517205 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, 0x5555555555555555, -0x556, x1, 1128, x3)

inst_164:
// rs1_val==6148914691236517205 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x5555555555555555, 0x5555555555555555, 0x5, x1, 1136, x3)

inst_165:
// rs1_val==6148914691236517205 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555555, 0x333, x1, 1144, x3)

inst_166:
// rs1_val==6148914691236517205 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555555, 0x666, x1, 1152, x3)

inst_167:
// rs1_val==6148914691236517205 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd7, 0x5555555555555555, -0x2d, x1, 1160, x3)

inst_168:
// rs1_val==6148914691236517205 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x555555555555557d, 0x5555555555555555, 0x2d, x1, 1168, x3)

inst_169:
// rs1_val==6148914691236517205 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x5555555555555557, 0x5555555555555555, 0x2, x1, 1176, x3)

inst_170:
// rs1_val==6148914691236517205 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x5555555555555555, 0x5555555555555555, 0x554, x1, 1184, x3)

inst_171:
// rs1_val==6148914691236517205 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x5555555555555555, 0x5555555555555555, 0x0, x1, 1192, x3)

inst_172:
// rs1_val==6148914691236517205 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x5555555555555555, 0x5555555555555555, 0x4, x1, 1200, x3)

inst_173:
// rs1_val==6148914691236517205 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555555, 0x332, x1, 1208, x3)

inst_174:
// rs1_val==6148914691236517205 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x5555555555555775, 0x5555555555555555, 0x665, x1, 1216, x3)

inst_175:
// rs1_val==6148914691236517205 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x555555555555557d, 0x5555555555555555, 0x2c, x1, 1224, x3)

inst_176:
// rs1_val==6148914691236517205 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x5555555555555557, 0x5555555555555555, 0x556, x1, 1232, x3)

inst_177:
// rs1_val==6148914691236517205 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, 0x5555555555555555, -0x555, x1, 1240, x3)

inst_178:
// rs1_val==6148914691236517205 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x5555555555555557, 0x5555555555555555, 0x6, x1, 1248, x3)

inst_179:
// rs1_val==6148914691236517205 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x5555555555555775, 0x5555555555555555, 0x334, x1, 1256, x3)

inst_180:
// rs1_val==6148914691236517205 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555555, 0x667, x1, 1264, x3)

inst_181:
// rs1_val==6148914691236517205 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd5, 0x5555555555555555, -0x2c, x1, 1272, x3)

inst_182:
// rs1_val==6148914691236517205 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x555555555555557f, 0x5555555555555555, 0x2e, x1, 1280, x3)

inst_183:
// rs1_val==-6148914691236517206 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555556, 0x3, x1, 1288, x3)

inst_184:
// rs1_val==-6148914691236517206 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaafff, -0x5555555555555556, 0x555, x1, 1296, x3)

inst_185:
// rs1_val==-6148914691236517206 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaaa, -0x5555555555555556, -0x556, x1, 1304, x3)

inst_186:
// rs1_val==-6148914691236517206 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555556, 0x5, x1, 1312, x3)

inst_187:
// rs1_val==-6148914691236517206 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaabbb, -0x5555555555555556, 0x333, x1, 1320, x3)

inst_188:
// rs1_val==-6148914691236517206 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaeee, -0x5555555555555556, 0x666, x1, 1328, x3)

inst_189:
// rs1_val==-6148914691236517206 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffb, -0x5555555555555556, -0x2d, x1, 1336, x3)

inst_190:
// rs1_val==-6148914691236517206 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555556, 0x2d, x1, 1344, x3)

inst_191:
// rs1_val==-6148914691236517206 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, 0x2, x1, 1352, x3)

inst_192:
// rs1_val==-6148914691236517206 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaffe, -0x5555555555555556, 0x554, x1, 1360, x3)

inst_193:
// rs1_val==-6148914691236517206 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, 0x0, x1, 1368, x3)

inst_194:
// rs1_val==-6148914691236517206 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x4, x1, 1376, x3)

inst_195:
// rs1_val==-6148914691236517206 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaabba, -0x5555555555555556, 0x332, x1, 1384, x3)

inst_196:
// rs1_val==-6148914691236517206 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaeef, -0x5555555555555556, 0x665, x1, 1392, x3)

inst_197:
// rs1_val==-6148914691236517206 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x2c, x1, 1400, x3)

inst_198:
// rs1_val==-6148914691236517206 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaffe, -0x5555555555555556, 0x556, x1, 1408, x3)

inst_199:
// rs1_val==-6148914691236517206 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaab, -0x5555555555555556, -0x555, x1, 1416, x3)

inst_200:
// rs1_val==-6148914691236517206 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x6, x1, 1424, x3)

inst_201:
// rs1_val==-6148914691236517206 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaabbe, -0x5555555555555556, 0x334, x1, 1432, x3)

inst_202:
// rs1_val==-6148914691236517206 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaeef, -0x5555555555555556, 0x667, x1, 1440, x3)

inst_203:
// rs1_val==-6148914691236517206 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffe, -0x5555555555555556, -0x2c, x1, 1448, x3)

inst_204:
// rs1_val==-6148914691236517206 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x2e, x1, 1456, x3)

inst_205:
// rs1_val==5 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x7, 0x5, 0x3, x1, 1464, x3)

inst_206:
// rs1_val==5 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x555, 0x5, 0x555, x1, 1472, x3)

inst_207:
// rs1_val==5 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaaf, 0x5, -0x556, x1, 1480, x3)

inst_208:
// rs1_val==5 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x337, 0x5, 0x333, x1, 1488, x3)

inst_209:
// rs1_val==5 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x667, 0x5, 0x666, x1, 1496, x3)

inst_210:
// rs1_val==5 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd7, 0x5, -0x2d, x1, 1504, x3)

inst_211:
// rs1_val==5 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x2d, 0x5, 0x2d, x1, 1512, x3)

inst_212:
// rs1_val==5 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x7, 0x5, 0x2, x1, 1520, x3)

inst_213:
// rs1_val==5 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x555, 0x5, 0x554, x1, 1528, x3)

inst_214:
// rs1_val==5 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x5, 0x5, 0x0, x1, 1536, x3)

inst_215:
// rs1_val==5 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x5, 0x5, 0x4, x1, 1544, x3)

inst_216:
// rs1_val==5 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x337, 0x5, 0x332, x1, 1552, x3)

inst_217:
// rs1_val==5 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x665, 0x5, 0x665, x1, 1560, x3)

inst_218:
// rs1_val==5 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x2d, 0x5, 0x2c, x1, 1568, x3)

inst_219:
// rs1_val==5 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x557, 0x5, 0x556, x1, 1576, x3)

inst_220:
// rs1_val==5 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaaf, 0x5, -0x555, x1, 1584, x3)

inst_221:
// rs1_val==5 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x7, 0x5, 0x6, x1, 1592, x3)

inst_222:
// rs1_val==5 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x335, 0x5, 0x334, x1, 1600, x3)

inst_223:
// rs1_val==5 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x667, 0x5, 0x667, x1, 1608, x3)

inst_224:
// rs1_val==5 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd5, 0x5, -0x2c, x1, 1616, x3)

inst_225:
// rs1_val==5 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x2f, 0x5, 0x2e, x1, 1624, x3)

inst_226:
// rs1_val==3689348814741910323 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x3333333333333333, 0x3333333333333333, 0x3, x1, 1632, x3)

inst_227:
// rs1_val==3689348814741910323 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333333, 0x555, x1, 1640, x3)

inst_228:
// rs1_val==3689348814741910323 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbb, 0x3333333333333333, -0x556, x1, 1648, x3)

inst_229:
// rs1_val==3689348814741910323 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x3333333333333337, 0x3333333333333333, 0x5, x1, 1656, x3)

inst_230:
// rs1_val==3689348814741910323 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x3333333333333333, 0x3333333333333333, 0x333, x1, 1664, x3)

inst_231:
// rs1_val==3689348814741910323 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333333, 0x666, x1, 1672, x3)

inst_232:
// rs1_val==3689348814741910323 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff3, 0x3333333333333333, -0x2d, x1, 1680, x3)

inst_233:
// rs1_val==3689348814741910323 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x333333333333333f, 0x3333333333333333, 0x2d, x1, 1688, x3)

inst_234:
// rs1_val==3689348814741910323 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x3333333333333333, 0x3333333333333333, 0x2, x1, 1696, x3)

inst_235:
// rs1_val==3689348814741910323 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333333, 0x554, x1, 1704, x3)

inst_236:
// rs1_val==3689348814741910323 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x3333333333333333, 0x3333333333333333, 0x0, x1, 1712, x3)

inst_237:
// rs1_val==3689348814741910323 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x3333333333333337, 0x3333333333333333, 0x4, x1, 1720, x3)

inst_238:
// rs1_val==3689348814741910323 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x3333333333333333, 0x3333333333333333, 0x332, x1, 1728, x3)

inst_239:
// rs1_val==3689348814741910323 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333333, 0x665, x1, 1736, x3)

inst_240:
// rs1_val==3689348814741910323 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x333333333333333f, 0x3333333333333333, 0x2c, x1, 1744, x3)

inst_241:
// rs1_val==3689348814741910323 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333333, 0x556, x1, 1752, x3)

inst_242:
// rs1_val==3689348814741910323 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbb, 0x3333333333333333, -0x555, x1, 1760, x3)

inst_243:
// rs1_val==3689348814741910323 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x3333333333333337, 0x3333333333333333, 0x6, x1, 1768, x3)

inst_244:
// rs1_val==3689348814741910323 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x3333333333333337, 0x3333333333333333, 0x334, x1, 1776, x3)

inst_245:
// rs1_val==3689348814741910323 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333333, 0x667, x1, 1784, x3)

inst_246:
// rs1_val==3689348814741910323 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff7, 0x3333333333333333, -0x2c, x1, 1792, x3)

inst_247:
// rs1_val==3689348814741910323 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x333333333333333f, 0x3333333333333333, 0x2e, x1, 1800, x3)

inst_248:
// rs1_val==7378697629483820646 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666666, 0x3, x1, 1808, x3)

inst_249:
// rs1_val==7378697629483820646 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666666, 0x555, x1, 1816, x3)

inst_250:
// rs1_val==7378697629483820646 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeee, 0x6666666666666666, -0x556, x1, 1824, x3)

inst_251:
// rs1_val==7378697629483820646 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666666, 0x5, x1, 1832, x3)

inst_252:
// rs1_val==7378697629483820646 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666666, 0x333, x1, 1840, x3)

inst_253:
// rs1_val==7378697629483820646 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x6666666666666666, 0x6666666666666666, 0x666, x1, 1848, x3)

inst_254:
// rs1_val==7378697629483820646 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff7, 0x6666666666666666, -0x2d, x1, 1856, x3)

inst_255:
// rs1_val==7378697629483820646 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x666666666666666f, 0x6666666666666666, 0x2d, x1, 1864, x3)

inst_256:
// rs1_val==7378697629483820646 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x6666666666666666, 0x6666666666666666, 0x2, x1, 1872, x3)

inst_257:
// rs1_val==7378697629483820646 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x6666666666666776, 0x6666666666666666, 0x554, x1, 1880, x3)

inst_258:
// rs1_val==7378697629483820646 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x6666666666666666, 0x6666666666666666, 0x0, x1, 1888, x3)

inst_259:
// rs1_val==7378697629483820646 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x6666666666666666, 0x6666666666666666, 0x4, x1, 1896, x3)

inst_260:
// rs1_val==7378697629483820646 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x6666666666666776, 0x6666666666666666, 0x332, x1, 1904, x3)

inst_261:
// rs1_val==7378697629483820646 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666666, 0x665, x1, 1912, x3)

inst_262:
// rs1_val==7378697629483820646 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x666666666666666e, 0x6666666666666666, 0x2c, x1, 1920, x3)

inst_263:
// rs1_val==7378697629483820646 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x6666666666666776, 0x6666666666666666, 0x556, x1, 1928, x3)

inst_264:
// rs1_val==7378697629483820646 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeef, 0x6666666666666666, -0x555, x1, 1936, x3)

inst_265:
// rs1_val==7378697629483820646 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x6666666666666666, 0x6666666666666666, 0x6, x1, 1944, x3)

inst_266:
// rs1_val==7378697629483820646 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x6666666666666776, 0x6666666666666666, 0x334, x1, 1952, x3)

inst_267:
// rs1_val==7378697629483820646 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666666, 0x667, x1, 1960, x3)

inst_268:
// rs1_val==7378697629483820646 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff6, 0x6666666666666666, -0x2c, x1, 1968, x3)

inst_269:
// rs1_val==7378697629483820646 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x666666666666666e, 0x6666666666666666, 0x2e, x1, 1976, x3)

inst_270:
// rs1_val==-3037000499 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ccf, -0xb504f333, 0x3, x1, 1984, x3)

inst_271:
// rs1_val==-3037000499 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ddd, -0xb504f333, 0x555, x1, 1992, x3)

inst_272:
// rs1_val==-3037000499 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeef, -0xb504f333, -0x556, x1, 2000, x3)

inst_273:
// rs1_val==-3037000499 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ccd, -0xb504f333, 0x5, x1, 2008, x3)

inst_274:
// rs1_val==-3037000499 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0fff, -0xb504f333, 0x333, x1, 2016, x3)

inst_275:
// rs1_val==-3037000499 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0eef, -0xb504f333, 0x666, x1, 2024, x3)

inst_276:
// rs1_val==-3037000499 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffdf, -0xb504f333, -0x2d, x1, 2032, x3)

inst_277:
// rs1_val==-3037000499 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ced, -0xb504f333, 0x2d, x1, 2040, x3)
RVTEST_SIGBASE( x1,signature_x1_1)

inst_278:
// rs1_val==-3037000499 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ccf, -0xb504f333, 0x2, x1, 0, x3)

inst_279:
// rs1_val==-3037000499 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ddd, -0xb504f333, 0x554, x1, 8, x3)

inst_280:
// rs1_val==-3037000499 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ccd, -0xb504f333, 0x0, x1, 16, x3)

inst_281:
// rs1_val==-3037000499 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ccd, -0xb504f333, 0x4, x1, 24, x3)

inst_282:
// rs1_val==-3037000499 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0fff, -0xb504f333, 0x332, x1, 32, x3)

inst_283:
// rs1_val==-3037000499 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0eed, -0xb504f333, 0x665, x1, 40, x3)

inst_284:
// rs1_val==-3037000499 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ced, -0xb504f333, 0x2c, x1, 48, x3)

inst_285:
// rs1_val==-3037000499 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ddf, -0xb504f333, 0x556, x1, 56, x3)

inst_286:
// rs1_val==-3037000499 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeef, -0xb504f333, -0x555, x1, 64, x3)

inst_287:
// rs1_val==-3037000499 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ccf, -0xb504f333, 0x6, x1, 72, x3)

inst_288:
// rs1_val==-3037000499 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ffd, -0xb504f333, 0x334, x1, 80, x3)

inst_289:
// rs1_val==-3037000499 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0eef, -0xb504f333, 0x667, x1, 88, x3)

inst_290:
// rs1_val==-3037000499 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffdd, -0xb504f333, -0x2c, x1, 96, x3)

inst_291:
// rs1_val==-3037000499 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0cef, -0xb504f333, 0x2e, x1, 104, x3)

inst_292:
// rs1_val==3037000499 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0xb504f333, 0xb504f333, 0x3, x1, 112, x3)

inst_293:
// rs1_val==3037000499 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f333, 0x555, x1, 120, x3)

inst_294:
// rs1_val==3037000499 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbb, 0xb504f333, -0x556, x1, 128, x3)

inst_295:
// rs1_val==3037000499 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0xb504f337, 0xb504f333, 0x5, x1, 136, x3)

inst_296:
// rs1_val==3037000499 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0xb504f333, 0xb504f333, 0x333, x1, 144, x3)

inst_297:
// rs1_val==3037000499 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f333, 0x666, x1, 152, x3)

inst_298:
// rs1_val==3037000499 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff3, 0xb504f333, -0x2d, x1, 160, x3)

inst_299:
// rs1_val==3037000499 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xb504f33f, 0xb504f333, 0x2d, x1, 168, x3)

inst_300:
// rs1_val==3037000499 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0xb504f333, 0xb504f333, 0x2, x1, 176, x3)

inst_301:
// rs1_val==3037000499 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f333, 0x554, x1, 184, x3)

inst_302:
// rs1_val==3037000499 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xb504f333, 0xb504f333, 0x0, x1, 192, x3)

inst_303:
// rs1_val==3037000499 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xb504f337, 0xb504f333, 0x4, x1, 200, x3)

inst_304:
// rs1_val==3037000499 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0xb504f333, 0xb504f333, 0x332, x1, 208, x3)

inst_305:
// rs1_val==3037000499 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f333, 0x665, x1, 216, x3)

inst_306:
// rs1_val==3037000499 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0xb504f33f, 0xb504f333, 0x2c, x1, 224, x3)

inst_307:
// rs1_val==3037000499 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f333, 0x556, x1, 232, x3)

inst_308:
// rs1_val==3037000499 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbb, 0xb504f333, -0x555, x1, 240, x3)

inst_309:
// rs1_val==3037000499 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0xb504f337, 0xb504f333, 0x6, x1, 248, x3)

inst_310:
// rs1_val==3037000499 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0xb504f337, 0xb504f333, 0x334, x1, 256, x3)

inst_311:
// rs1_val==3037000499 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f333, 0x667, x1, 264, x3)

inst_312:
// rs1_val==3037000499 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff7, 0xb504f333, -0x2c, x1, 272, x3)

inst_313:
// rs1_val==3037000499 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0xb504f33f, 0xb504f333, 0x2e, x1, 280, x3)

inst_314:
// rs1_val==2 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x3, 0x2, 0x3, x1, 288, x3)

inst_315:
// rs1_val==2 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x557, 0x2, 0x555, x1, 296, x3)

inst_316:
// rs1_val==2 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaaa, 0x2, -0x556, x1, 304, x3)

inst_317:
// rs1_val==2 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x7, 0x2, 0x5, x1, 312, x3)

inst_318:
// rs1_val==2 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x333, 0x2, 0x333, x1, 320, x3)

inst_319:
// rs1_val==2 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x666, 0x2, 0x666, x1, 328, x3)

inst_320:
// rs1_val==2 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd3, 0x2, -0x2d, x1, 336, x3)

inst_321:
// rs1_val==2 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x2f, 0x2, 0x2d, x1, 344, x3)

inst_322:
// rs1_val==2 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x2, 0x2, 0x2, x1, 352, x3)

inst_323:
// rs1_val==2 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x556, 0x2, 0x554, x1, 360, x3)

inst_324:
// rs1_val==2 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x2, 0x2, 0x0, x1, 368, x3)

inst_325:
// rs1_val==2 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x6, 0x2, 0x4, x1, 376, x3)

inst_326:
// rs1_val==2 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x332, 0x2, 0x332, x1, 384, x3)

inst_327:
// rs1_val==2 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x667, 0x2, 0x665, x1, 392, x3)

inst_328:
// rs1_val==2 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x2e, 0x2, 0x2c, x1, 400, x3)

inst_329:
// rs1_val==2 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x556, 0x2, 0x556, x1, 408, x3)

inst_330:
// rs1_val==2 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaab, 0x2, -0x555, x1, 416, x3)

inst_331:
// rs1_val==2 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x6, 0x2, 0x6, x1, 424, x3)

inst_332:
// rs1_val==2 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x336, 0x2, 0x334, x1, 432, x3)

inst_333:
// rs1_val==2 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x667, 0x2, 0x667, x1, 440, x3)

inst_334:
// rs1_val==2 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd6, 0x2, -0x2c, x1, 448, x3)

inst_335:
// rs1_val==2 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x2e, 0x2, 0x2e, x1, 456, x3)

inst_336:
// rs1_val==6148914691236517204 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x5555555555555557, 0x5555555555555554, 0x3, x1, 464, x3)

inst_337:
// rs1_val==6148914691236517204 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x5555555555555555, 0x5555555555555554, 0x555, x1, 472, x3)

inst_338:
// rs1_val==6148914691236517204 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffe, 0x5555555555555554, -0x556, x1, 480, x3)

inst_339:
// rs1_val==6148914691236517204 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x5555555555555555, 0x5555555555555554, 0x5, x1, 488, x3)

inst_340:
// rs1_val==6148914691236517204 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555554, 0x333, x1, 496, x3)

inst_341:
// rs1_val==6148914691236517204 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x5555555555555776, 0x5555555555555554, 0x666, x1, 504, x3)

inst_342:
// rs1_val==6148914691236517204 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd7, 0x5555555555555554, -0x2d, x1, 512, x3)

inst_343:
// rs1_val==6148914691236517204 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x555555555555557d, 0x5555555555555554, 0x2d, x1, 520, x3)

inst_344:
// rs1_val==6148914691236517204 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555554, 0x2, x1, 528, x3)

inst_345:
// rs1_val==6148914691236517204 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x5555555555555554, 0x5555555555555554, 0x554, x1, 536, x3)

inst_346:
// rs1_val==6148914691236517204 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x5555555555555554, 0x5555555555555554, 0x0, x1, 544, x3)

inst_347:
// rs1_val==6148914691236517204 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x5555555555555554, 0x5555555555555554, 0x4, x1, 552, x3)

inst_348:
// rs1_val==6148914691236517204 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x5555555555555776, 0x5555555555555554, 0x332, x1, 560, x3)

inst_349:
// rs1_val==6148914691236517204 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x5555555555555775, 0x5555555555555554, 0x665, x1, 568, x3)

inst_350:
// rs1_val==6148914691236517204 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x555555555555557c, 0x5555555555555554, 0x2c, x1, 576, x3)

inst_351:
// rs1_val==6148914691236517204 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555554, 0x556, x1, 584, x3)

inst_352:
// rs1_val==6148914691236517204 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, 0x5555555555555554, -0x555, x1, 592, x3)

inst_353:
// rs1_val==6148914691236517204 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555554, 0x6, x1, 600, x3)

inst_354:
// rs1_val==6148914691236517204 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x5555555555555774, 0x5555555555555554, 0x334, x1, 608, x3)

inst_355:
// rs1_val==6148914691236517204 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555554, 0x667, x1, 616, x3)

inst_356:
// rs1_val==6148914691236517204 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd4, 0x5555555555555554, -0x2c, x1, 624, x3)

inst_357:
// rs1_val==6148914691236517204 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x555555555555557e, 0x5555555555555554, 0x2e, x1, 632, x3)

inst_358:
// rs1_val==0 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x3, 0x0, 0x3, x1, 640, x3)

inst_359:
// rs1_val==0 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaaa, 0x0, -0x556, x1, 648, x3)

inst_360:
// rs1_val==0 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x5, 0x0, 0x5, x1, 656, x3)

inst_361:
// rs1_val==0 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x333, 0x0, 0x333, x1, 664, x3)

inst_362:
// rs1_val==0 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x666, 0x0, 0x666, x1, 672, x3)

inst_363:
// rs1_val==0 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd3, 0x0, -0x2d, x1, 680, x3)

inst_364:
// rs1_val==0 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x2d, 0x0, 0x2d, x1, 688, x3)

inst_365:
// rs1_val==6148914691236517206 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x555555555555557e, 0x5555555555555556, 0x2c, x1, 696, x3)

inst_366:
// rs1_val==6148914691236517206 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555556, 0x556, x1, 704, x3)

inst_367:
// rs1_val==6148914691236517206 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, 0x5555555555555556, -0x555, x1, 712, x3)

inst_368:
// rs1_val==6148914691236517206 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555556, 0x6, x1, 720, x3)

inst_369:
// rs1_val==6148914691236517206 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x5555555555555776, 0x5555555555555556, 0x334, x1, 728, x3)

inst_370:
// rs1_val==6148914691236517206 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555556, 0x667, x1, 736, x3)

inst_371:
// rs1_val==6148914691236517206 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd6, 0x5555555555555556, -0x2c, x1, 744, x3)

inst_372:
// rs1_val==6148914691236517206 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x555555555555557e, 0x5555555555555556, 0x2e, x1, 752, x3)

inst_373:
// rs1_val==-6148914691236517205 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, 0x3, x1, 760, x3)

inst_374:
// rs1_val==-6148914691236517205 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaafff, -0x5555555555555555, 0x555, x1, 768, x3)

inst_375:
// rs1_val==-6148914691236517205 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaab, -0x5555555555555555, -0x556, x1, 776, x3)

inst_376:
// rs1_val==-6148914691236517205 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x5, x1, 784, x3)

inst_377:
// rs1_val==-6148914691236517205 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaabbb, -0x5555555555555555, 0x333, x1, 792, x3)

inst_378:
// rs1_val==-6148914691236517205 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaeef, -0x5555555555555555, 0x666, x1, 800, x3)

inst_379:
// rs1_val==-6148914691236517205 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffb, -0x5555555555555555, -0x2d, x1, 808, x3)

inst_380:
// rs1_val==-6148914691236517205 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x2d, x1, 816, x3)

inst_381:
// rs1_val==-6148914691236517205 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, 0x2, x1, 824, x3)

inst_382:
// rs1_val==-6148914691236517205 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaafff, -0x5555555555555555, 0x554, x1, 832, x3)

inst_383:
// rs1_val==-6148914691236517205 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, 0x0, x1, 840, x3)

inst_384:
// rs1_val==-6148914691236517205 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x4, x1, 848, x3)

inst_385:
// rs1_val==-6148914691236517205 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaabbb, -0x5555555555555555, 0x332, x1, 856, x3)

inst_386:
// rs1_val==-6148914691236517205 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaeef, -0x5555555555555555, 0x665, x1, 864, x3)

inst_387:
// rs1_val==-6148914691236517205 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x2c, x1, 872, x3)

inst_388:
// rs1_val==-6148914691236517205 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaafff, -0x5555555555555555, 0x556, x1, 880, x3)

inst_389:
// rs1_val==-6148914691236517205 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaab, -0x5555555555555555, -0x555, x1, 888, x3)

inst_390:
// rs1_val==-6148914691236517205 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x6, x1, 896, x3)

inst_391:
// rs1_val==-6148914691236517205 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaabbf, -0x5555555555555555, 0x334, x1, 904, x3)

inst_392:
// rs1_val==-6148914691236517205 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaeef, -0x5555555555555555, 0x667, x1, 912, x3)

inst_393:
// rs1_val==-6148914691236517205 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x5555555555555555, -0x2c, x1, 920, x3)

inst_394:
// rs1_val==-6148914691236517205 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x2e, x1, 928, x3)

inst_395:
// rs1_val==6 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x7, 0x6, 0x3, x1, 936, x3)

inst_396:
// rs1_val==6 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x557, 0x6, 0x555, x1, 944, x3)

inst_397:
// rs1_val==6 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaae, 0x6, -0x556, x1, 952, x3)

inst_398:
// rs1_val==6 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x7, 0x6, 0x5, x1, 960, x3)

inst_399:
// rs1_val==6 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x337, 0x6, 0x333, x1, 968, x3)

inst_400:
// rs1_val==6 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x666, 0x6, 0x666, x1, 976, x3)

inst_401:
// rs1_val==6 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd7, 0x6, -0x2d, x1, 984, x3)

inst_402:
// rs1_val==6 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x2f, 0x6, 0x2d, x1, 992, x3)

inst_403:
// rs1_val==6 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x6, 0x6, 0x2, x1, 1000, x3)

inst_404:
// rs1_val==6 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x556, 0x6, 0x554, x1, 1008, x3)

inst_405:
// rs1_val==6 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x6, 0x6, 0x0, x1, 1016, x3)

inst_406:
// rs1_val==6 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x6, 0x6, 0x4, x1, 1024, x3)

inst_407:
// rs1_val==6 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x336, 0x6, 0x332, x1, 1032, x3)

inst_408:
// rs1_val==6 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x667, 0x6, 0x665, x1, 1040, x3)

inst_409:
// rs1_val==6 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x2e, 0x6, 0x2c, x1, 1048, x3)

inst_410:
// rs1_val==6 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x556, 0x6, 0x556, x1, 1056, x3)

inst_411:
// rs1_val==6 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaaf, 0x6, -0x555, x1, 1064, x3)

inst_412:
// rs1_val==6 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x6, 0x6, 0x6, x1, 1072, x3)

inst_413:
// rs1_val==6 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x336, 0x6, 0x334, x1, 1080, x3)

inst_414:
// rs1_val==6 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x667, 0x6, 0x667, x1, 1088, x3)

inst_415:
// rs1_val==6 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd6, 0x6, -0x2c, x1, 1096, x3)

inst_416:
// rs1_val==6 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x2e, 0x6, 0x2e, x1, 1104, x3)

inst_417:
// rs1_val==3689348814741910324 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x3333333333333337, 0x3333333333333334, 0x3, x1, 1112, x3)

inst_418:
// rs1_val==3689348814741910324 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x3333333333333775, 0x3333333333333334, 0x555, x1, 1120, x3)

inst_419:
// rs1_val==3689348814741910324 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbe, 0x3333333333333334, -0x556, x1, 1128, x3)

inst_420:
// rs1_val==3689348814741910324 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x3333333333333335, 0x3333333333333334, 0x5, x1, 1136, x3)

inst_421:
// rs1_val==3689348814741910324 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x3333333333333337, 0x3333333333333334, 0x333, x1, 1144, x3)

inst_422:
// rs1_val==3689348814741910324 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x3333333333333776, 0x3333333333333334, 0x666, x1, 1152, x3)

inst_423:
// rs1_val==3689348814741910324 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff7, 0x3333333333333334, -0x2d, x1, 1160, x3)

inst_424:
// rs1_val==3689348814741910324 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x333333333333333d, 0x3333333333333334, 0x2d, x1, 1168, x3)

inst_425:
// rs1_val==3689348814741910324 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x3333333333333336, 0x3333333333333334, 0x2, x1, 1176, x3)

inst_426:
// rs1_val==3689348814741910324 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x3333333333333774, 0x3333333333333334, 0x554, x1, 1184, x3)

inst_427:
// rs1_val==3689348814741910324 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x3333333333333334, 0x3333333333333334, 0x0, x1, 1192, x3)

inst_428:
// rs1_val==3689348814741910324 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x3333333333333334, 0x3333333333333334, 0x4, x1, 1200, x3)

inst_429:
// rs1_val==3689348814741910324 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x3333333333333336, 0x3333333333333334, 0x332, x1, 1208, x3)

inst_430:
// rs1_val==3689348814741910324 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x3333333333333775, 0x3333333333333334, 0x665, x1, 1216, x3)

inst_431:
// rs1_val==3689348814741910324 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x333333333333333c, 0x3333333333333334, 0x2c, x1, 1224, x3)

inst_432:
// rs1_val==3689348814741910324 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x3333333333333776, 0x3333333333333334, 0x556, x1, 1232, x3)

inst_433:
// rs1_val==3689348814741910324 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbf, 0x3333333333333334, -0x555, x1, 1240, x3)

inst_434:
// rs1_val==3689348814741910324 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x3333333333333336, 0x3333333333333334, 0x6, x1, 1248, x3)

inst_435:
// rs1_val==3689348814741910324 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x3333333333333334, 0x3333333333333334, 0x334, x1, 1256, x3)

inst_436:
// rs1_val==3689348814741910324 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333334, 0x667, x1, 1264, x3)

inst_437:
// rs1_val==3689348814741910324 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff4, 0x3333333333333334, -0x2c, x1, 1272, x3)

inst_438:
// rs1_val==3689348814741910324 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x333333333333333e, 0x3333333333333334, 0x2e, x1, 1280, x3)

inst_439:
// rs1_val==7378697629483820647 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x3, x1, 1288, x3)

inst_440:
// rs1_val==7378697629483820647 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666667, 0x555, x1, 1296, x3)

inst_441:
// rs1_val==7378697629483820647 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeef, 0x6666666666666667, -0x556, x1, 1304, x3)

inst_442:
// rs1_val==7378697629483820647 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x5, x1, 1312, x3)

inst_443:
// rs1_val==7378697629483820647 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666667, 0x333, x1, 1320, x3)

inst_444:
// rs1_val==7378697629483820647 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x666, x1, 1328, x3)

inst_445:
// rs1_val==7378697629483820647 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff7, 0x6666666666666667, -0x2d, x1, 1336, x3)

inst_446:
// rs1_val==7378697629483820647 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x666666666666666f, 0x6666666666666667, 0x2d, x1, 1344, x3)

inst_447:
// rs1_val==7378697629483820647 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x2, x1, 1352, x3)

inst_448:
// rs1_val==7378697629483820647 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666667, 0x554, x1, 1360, x3)

inst_449:
// rs1_val==7378697629483820647 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x0, x1, 1368, x3)

inst_450:
// rs1_val==7378697629483820647 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x4, x1, 1376, x3)

inst_451:
// rs1_val==7378697629483820647 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666667, 0x332, x1, 1384, x3)

inst_452:
// rs1_val==7378697629483820647 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x665, x1, 1392, x3)

inst_453:
// rs1_val==7378697629483820647 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x666666666666666f, 0x6666666666666667, 0x2c, x1, 1400, x3)

inst_454:
// rs1_val==7378697629483820647 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666667, 0x556, x1, 1408, x3)

inst_455:
// rs1_val==7378697629483820647 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeef, 0x6666666666666667, -0x555, x1, 1416, x3)

inst_456:
// rs1_val==7378697629483820647 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x6, x1, 1424, x3)

inst_457:
// rs1_val==7378697629483820647 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666667, 0x334, x1, 1432, x3)

inst_458:
// rs1_val==7378697629483820647 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x667, x1, 1440, x3)

inst_459:
// rs1_val==7378697629483820647 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff7, 0x6666666666666667, -0x2c, x1, 1448, x3)

inst_460:
// rs1_val==7378697629483820647 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x666666666666666f, 0x6666666666666667, 0x2e, x1, 1456, x3)

inst_461:
// rs1_val==-3037000498 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ccf, -0xb504f332, 0x3, x1, 1464, x3)

inst_462:
// rs1_val==-3037000498 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ddf, -0xb504f332, 0x555, x1, 1472, x3)

inst_463:
// rs1_val==-3037000498 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeee, -0xb504f332, -0x556, x1, 1480, x3)

inst_464:
// rs1_val==-3037000498 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ccf, -0xb504f332, 0x5, x1, 1488, x3)

inst_465:
// rs1_val==-3037000498 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0fff, -0xb504f332, 0x333, x1, 1496, x3)

inst_466:
// rs1_val==-3037000498 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0eee, -0xb504f332, 0x666, x1, 1504, x3)

inst_467:
// rs1_val==-3037000498 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffdf, -0xb504f332, -0x2d, x1, 1512, x3)

inst_468:
// rs1_val==-3037000498 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0cef, -0xb504f332, 0x2d, x1, 1520, x3)

inst_469:
// rs1_val==-3037000498 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0cce, -0xb504f332, 0x2, x1, 1528, x3)

inst_470:
// rs1_val==-3037000498 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0dde, -0xb504f332, 0x554, x1, 1536, x3)

inst_471:
// rs1_val==-3037000498 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0cce, -0xb504f332, 0x0, x1, 1544, x3)

inst_472:
// rs1_val==-3037000498 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0cce, -0xb504f332, 0x4, x1, 1552, x3)

inst_473:
// rs1_val==-3037000498 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ffe, -0xb504f332, 0x332, x1, 1560, x3)

inst_474:
// rs1_val==-3037000498 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0eef, -0xb504f332, 0x665, x1, 1568, x3)

inst_475:
// rs1_val==-3037000498 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0cee, -0xb504f332, 0x2c, x1, 1576, x3)

inst_476:
// rs1_val==-3037000498 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0dde, -0xb504f332, 0x556, x1, 1584, x3)

inst_477:
// rs1_val==-3037000498 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeef, -0xb504f332, -0x555, x1, 1592, x3)

inst_478:
// rs1_val==-3037000498 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0cce, -0xb504f332, 0x6, x1, 1600, x3)

inst_479:
// rs1_val==-3037000498 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0ffe, -0xb504f332, 0x334, x1, 1608, x3)

inst_480:
// rs1_val==-3037000498 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0eef, -0xb504f332, 0x667, x1, 1616, x3)

inst_481:
// rs1_val==-3037000498 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffde, -0xb504f332, -0x2c, x1, 1624, x3)

inst_482:
// rs1_val==-3037000498 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0xffffffff4afb0cee, -0xb504f332, 0x2e, x1, 1632, x3)

inst_483:
// rs1_val==3037000500 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0xb504f337, 0xb504f334, 0x3, x1, 1640, x3)

inst_484:
// rs1_val==3037000500 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0xb504f775, 0xb504f334, 0x555, x1, 1648, x3)

inst_485:
// rs1_val==3037000500 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbe, 0xb504f334, -0x556, x1, 1656, x3)

inst_486:
// rs1_val==3037000500 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0xb504f335, 0xb504f334, 0x5, x1, 1664, x3)

inst_487:
// rs1_val==3037000500 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0xb504f337, 0xb504f334, 0x333, x1, 1672, x3)

inst_488:
// rs1_val==3037000500 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0xb504f776, 0xb504f334, 0x666, x1, 1680, x3)

inst_489:
// rs1_val==3037000500 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff7, 0xb504f334, -0x2d, x1, 1688, x3)

inst_490:
// rs1_val==3037000500 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xb504f33d, 0xb504f334, 0x2d, x1, 1696, x3)

inst_491:
// rs1_val==3037000500 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0xb504f336, 0xb504f334, 0x2, x1, 1704, x3)

inst_492:
// rs1_val==3037000500 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xb504f774, 0xb504f334, 0x554, x1, 1712, x3)

inst_493:
// rs1_val==3037000500 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xb504f334, 0xb504f334, 0x0, x1, 1720, x3)

inst_494:
// rs1_val==3037000500 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xb504f334, 0xb504f334, 0x4, x1, 1728, x3)

inst_495:
// rs1_val==3037000500 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0xb504f336, 0xb504f334, 0x332, x1, 1736, x3)

inst_496:
// rs1_val==3037000500 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0xb504f775, 0xb504f334, 0x665, x1, 1744, x3)

inst_497:
// rs1_val==3037000500 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0xb504f33c, 0xb504f334, 0x2c, x1, 1752, x3)

inst_498:
// rs1_val==3037000500 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0xb504f776, 0xb504f334, 0x556, x1, 1760, x3)

inst_499:
// rs1_val==3037000500 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbf, 0xb504f334, -0x555, x1, 1768, x3)

inst_500:
// rs1_val==3037000500 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0xb504f336, 0xb504f334, 0x6, x1, 1776, x3)

inst_501:
// rs1_val==3037000500 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0xb504f334, 0xb504f334, 0x334, x1, 1784, x3)

inst_502:
// rs1_val==3037000500 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f334, 0x667, x1, 1792, x3)

inst_503:
// rs1_val==3037000500 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff4, 0xb504f334, -0x2c, x1, 1800, x3)

inst_504:
// rs1_val==3037000500 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0xb504f33e, 0xb504f334, 0x2e, x1, 1808, x3)

inst_505:
// rs1_val==0 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x2, 0x0, 0x2, x1, 1816, x3)

inst_506:
// rs1_val==0 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x554, 0x0, 0x554, x1, 1824, x3)

inst_507:
// rs1_val==0 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x0, 0x0, 0x0, x1, 1832, x3)

inst_508:
// rs1_val==0 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x4, 0x0, 0x4, x1, 1840, x3)

inst_509:
// rs1_val==0 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x332, 0x0, 0x332, x1, 1848, x3)

inst_510:
// rs1_val==0 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x665, 0x0, 0x665, x1, 1856, x3)

inst_511:
// rs1_val==0 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x2c, 0x0, 0x2c, x1, 1864, x3)

inst_512:
// rs1_val==0 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x556, 0x0, 0x556, x1, 1872, x3)

inst_513:
// rs1_val==0 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaab, 0x0, -0x555, x1, 1880, x3)

inst_514:
// rs1_val==0 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x6, 0x0, 0x6, x1, 1888, x3)

inst_515:
// rs1_val==0 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x334, 0x0, 0x334, x1, 1896, x3)

inst_516:
// rs1_val==0 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x667, 0x0, 0x667, x1, 1904, x3)

inst_517:
// rs1_val==0 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd4, 0x0, -0x2c, x1, 1912, x3)

inst_518:
// rs1_val==0 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x2e, 0x0, 0x2e, x1, 1920, x3)

inst_519:
// rs1_val==4 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x7, 0x4, 0x3, x1, 1928, x3)

inst_520:
// rs1_val==4 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x555, 0x4, 0x555, x1, 1936, x3)

inst_521:
// rs1_val==4 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaae, 0x4, -0x556, x1, 1944, x3)

inst_522:
// rs1_val==4 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x5, 0x4, 0x5, x1, 1952, x3)

inst_523:
// rs1_val==4 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x337, 0x4, 0x333, x1, 1960, x3)

inst_524:
// rs1_val==4 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x666, 0x4, 0x666, x1, 1968, x3)

inst_525:
// rs1_val==4 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd7, 0x4, -0x2d, x1, 1976, x3)

inst_526:
// rs1_val==4 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x2d, 0x4, 0x2d, x1, 1984, x3)

inst_527:
// rs1_val==4 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x6, 0x4, 0x2, x1, 1992, x3)

inst_528:
// rs1_val==4 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x554, 0x4, 0x554, x1, 2000, x3)

inst_529:
// rs1_val==4 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x4, 0x4, 0x4, x1, 2008, x3)

inst_530:
// rs1_val==4 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x336, 0x4, 0x332, x1, 2016, x3)

inst_531:
// rs1_val==4 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x665, 0x4, 0x665, x1, 2024, x3)

inst_532:
// rs1_val==4 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x2c, 0x4, 0x2c, x1, 2032, x3)

inst_533:
// rs1_val==4 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x556, 0x4, 0x556, x1, 2040, x3)
RVTEST_SIGBASE( x1,signature_x1_2)

inst_534:
// rs1_val==4 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffaaf, 0x4, -0x555, x1, 0, x3)

inst_535:
// rs1_val==4 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x6, 0x4, 0x6, x1, 8, x3)

inst_536:
// rs1_val==4 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x334, 0x4, 0x334, x1, 16, x3)

inst_537:
// rs1_val==4 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x667, 0x4, 0x667, x1, 24, x3)

inst_538:
// rs1_val==4 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd4, 0x4, -0x2c, x1, 32, x3)

inst_539:
// rs1_val==4 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x2e, 0x4, 0x2e, x1, 40, x3)

inst_540:
// rs1_val==3689348814741910322 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x3333333333333333, 0x3333333333333332, 0x3, x1, 48, x3)

inst_541:
// rs1_val==3689348814741910322 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333332, 0x555, x1, 56, x3)

inst_542:
// rs1_val==3689348814741910322 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbba, 0x3333333333333332, -0x556, x1, 64, x3)

inst_543:
// rs1_val==3689348814741910322 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x3333333333333337, 0x3333333333333332, 0x5, x1, 72, x3)

inst_544:
// rs1_val==3689348814741910322 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x3333333333333333, 0x3333333333333332, 0x333, x1, 80, x3)

inst_545:
// rs1_val==3689348814741910322 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x3333333333333776, 0x3333333333333332, 0x666, x1, 88, x3)

inst_546:
// rs1_val==3689348814741910322 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff3, 0x3333333333333332, -0x2d, x1, 96, x3)

inst_547:
// rs1_val==3689348814741910322 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x333333333333333f, 0x3333333333333332, 0x2d, x1, 104, x3)

inst_548:
// rs1_val==3689348814741910322 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x3333333333333332, 0x3333333333333332, 0x2, x1, 112, x3)

inst_549:
// rs1_val==3689348814741910322 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x3333333333333776, 0x3333333333333332, 0x554, x1, 120, x3)

inst_550:
// rs1_val==3689348814741910322 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x3333333333333332, 0x3333333333333332, 0x0, x1, 128, x3)

inst_551:
// rs1_val==3689348814741910322 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x3333333333333336, 0x3333333333333332, 0x4, x1, 136, x3)

inst_552:
// rs1_val==3689348814741910322 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x3333333333333332, 0x3333333333333332, 0x332, x1, 144, x3)

inst_553:
// rs1_val==3689348814741910322 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333332, 0x665, x1, 152, x3)

inst_554:
// rs1_val==3689348814741910322 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x333333333333333e, 0x3333333333333332, 0x2c, x1, 160, x3)

inst_555:
// rs1_val==3689348814741910322 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x3333333333333776, 0x3333333333333332, 0x556, x1, 168, x3)

inst_556:
// rs1_val==3689348814741910322 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbb, 0x3333333333333332, -0x555, x1, 176, x3)

inst_557:
// rs1_val==3689348814741910322 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x3333333333333336, 0x3333333333333332, 0x6, x1, 184, x3)

inst_558:
// rs1_val==3689348814741910322 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x3333333333333336, 0x3333333333333332, 0x334, x1, 192, x3)

inst_559:
// rs1_val==3689348814741910322 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x3333333333333777, 0x3333333333333332, 0x667, x1, 200, x3)

inst_560:
// rs1_val==3689348814741910322 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff6, 0x3333333333333332, -0x2c, x1, 208, x3)

inst_561:
// rs1_val==3689348814741910322 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x333333333333333e, 0x3333333333333332, 0x2e, x1, 216, x3)

inst_562:
// rs1_val==7378697629483820645 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666665, 0x3, x1, 224, x3)

inst_563:
// rs1_val==7378697629483820645 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x6666666666666775, 0x6666666666666665, 0x555, x1, 232, x3)

inst_564:
// rs1_val==7378697629483820645 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeef, 0x6666666666666665, -0x556, x1, 240, x3)

inst_565:
// rs1_val==7378697629483820645 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x6666666666666665, 0x6666666666666665, 0x5, x1, 248, x3)

inst_566:
// rs1_val==7378697629483820645 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666665, 0x333, x1, 256, x3)

inst_567:
// rs1_val==7378697629483820645 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666665, 0x666, x1, 264, x3)

inst_568:
// rs1_val==7378697629483820645 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff7, 0x6666666666666665, -0x2d, x1, 272, x3)

inst_569:
// rs1_val==7378697629483820645 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x666666666666666d, 0x6666666666666665, 0x2d, x1, 280, x3)

inst_570:
// rs1_val==7378697629483820645 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666665, 0x2, x1, 288, x3)

inst_571:
// rs1_val==7378697629483820645 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x6666666666666775, 0x6666666666666665, 0x554, x1, 296, x3)

inst_572:
// rs1_val==7378697629483820645 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x6666666666666665, 0x6666666666666665, 0x0, x1, 304, x3)

inst_573:
// rs1_val==7378697629483820645 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x6666666666666665, 0x6666666666666665, 0x4, x1, 312, x3)

inst_574:
// rs1_val==7378697629483820645 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666665, 0x332, x1, 320, x3)

inst_575:
// rs1_val==7378697629483820645 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x6666666666666665, 0x6666666666666665, 0x665, x1, 328, x3)

inst_576:
// rs1_val==7378697629483820645 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0x666666666666666d, 0x6666666666666665, 0x2c, x1, 336, x3)

inst_577:
// rs1_val==7378697629483820645 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0x6666666666666777, 0x6666666666666665, 0x556, x1, 344, x3)

inst_578:
// rs1_val==7378697629483820645 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffeef, 0x6666666666666665, -0x555, x1, 352, x3)

inst_579:
// rs1_val==7378697629483820645 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666665, 0x6, x1, 360, x3)

inst_580:
// rs1_val==7378697629483820645 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0x6666666666666775, 0x6666666666666665, 0x334, x1, 368, x3)

inst_581:
// rs1_val==7378697629483820645 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0x6666666666666667, 0x6666666666666665, 0x667, x1, 376, x3)

inst_582:
// rs1_val==7378697629483820645 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff5, 0x6666666666666665, -0x2c, x1, 384, x3)

inst_583:
// rs1_val==7378697629483820645 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0x666666666666666f, 0x6666666666666665, 0x2e, x1, 392, x3)

inst_584:
// rs1_val==3037000498 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0xb504f333, 0xb504f332, 0x3, x1, 400, x3)

inst_585:
// rs1_val==3037000498 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f332, 0x555, x1, 408, x3)

inst_586:
// rs1_val==3037000498 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbba, 0xb504f332, -0x556, x1, 416, x3)

inst_587:
// rs1_val==3037000498 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0xb504f337, 0xb504f332, 0x5, x1, 424, x3)

inst_588:
// rs1_val==3037000498 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0xb504f333, 0xb504f332, 0x333, x1, 432, x3)

inst_589:
// rs1_val==3037000498 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0xb504f776, 0xb504f332, 0x666, x1, 440, x3)

inst_590:
// rs1_val==3037000498 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff3, 0xb504f332, -0x2d, x1, 448, x3)

inst_591:
// rs1_val==3037000498 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0xb504f33f, 0xb504f332, 0x2d, x1, 456, x3)

inst_592:
// rs1_val==3037000498 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0xb504f332, 0xb504f332, 0x2, x1, 464, x3)

inst_593:
// rs1_val==3037000498 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0xb504f776, 0xb504f332, 0x554, x1, 472, x3)

inst_594:
// rs1_val==3037000498 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0xb504f332, 0xb504f332, 0x0, x1, 480, x3)

inst_595:
// rs1_val==3037000498 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0xb504f336, 0xb504f332, 0x4, x1, 488, x3)

inst_596:
// rs1_val==3037000498 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0xb504f332, 0xb504f332, 0x332, x1, 496, x3)

inst_597:
// rs1_val==3037000498 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f332, 0x665, x1, 504, x3)

inst_598:
// rs1_val==3037000498 and imm_val==44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2c
TEST_IMM_OP( ori, x11, x10, 0xb504f33e, 0xb504f332, 0x2c, x1, 512, x3)

inst_599:
// rs1_val==3037000498 and imm_val==1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x556
TEST_IMM_OP( ori, x11, x10, 0xb504f776, 0xb504f332, 0x556, x1, 520, x3)

inst_600:
// rs1_val==3037000498 and imm_val==-1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x555
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffbbb, 0xb504f332, -0x555, x1, 528, x3)

inst_601:
// rs1_val==3037000498 and imm_val==6, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x6
TEST_IMM_OP( ori, x11, x10, 0xb504f336, 0xb504f332, 0x6, x1, 536, x3)

inst_602:
// rs1_val==3037000498 and imm_val==820, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x334
TEST_IMM_OP( ori, x11, x10, 0xb504f336, 0xb504f332, 0x334, x1, 544, x3)

inst_603:
// rs1_val==3037000498 and imm_val==1639, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x667
TEST_IMM_OP( ori, x11, x10, 0xb504f777, 0xb504f332, 0x667, x1, 552, x3)

inst_604:
// rs1_val==3037000498 and imm_val==-44, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2c
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffff6, 0xb504f332, -0x2c, x1, 560, x3)

inst_605:
// rs1_val==3037000498 and imm_val==46, 
// opcode: ori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2e
TEST_IMM_OP( ori, x11, x10, 0xb504f33e, 0xb504f332, 0x2e, x1, 568, x3)

inst_606:
// rs1_val==6148914691236517206 and imm_val==3, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x3
TEST_IMM_OP( ori, x11, x10, 0x5555555555555557, 0x5555555555555556, 0x3, x1, 576, x3)

inst_607:
// rs1_val==6148914691236517206 and imm_val==1365, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x555
TEST_IMM_OP( ori, x11, x10, 0x5555555555555557, 0x5555555555555556, 0x555, x1, 584, x3)

inst_608:
// rs1_val==6148914691236517206 and imm_val==-1366, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x556
TEST_IMM_OP( ori, x11, x10, 0xfffffffffffffffe, 0x5555555555555556, -0x556, x1, 592, x3)

inst_609:
// rs1_val==6148914691236517206 and imm_val==5, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x5
TEST_IMM_OP( ori, x11, x10, 0x5555555555555557, 0x5555555555555556, 0x5, x1, 600, x3)

inst_610:
// rs1_val==6148914691236517206 and imm_val==819, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x333
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555556, 0x333, x1, 608, x3)

inst_611:
// rs1_val==6148914691236517206 and imm_val==1638, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x666
TEST_IMM_OP( ori, x11, x10, 0x5555555555555776, 0x5555555555555556, 0x666, x1, 616, x3)

inst_612:
// rs1_val==6148914691236517206 and imm_val==-45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffd7, 0x5555555555555556, -0x2d, x1, 624, x3)

inst_613:
// rs1_val==6148914691236517206 and imm_val==45, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2d
TEST_IMM_OP( ori, x11, x10, 0x555555555555557f, 0x5555555555555556, 0x2d, x1, 632, x3)

inst_614:
// rs1_val==6148914691236517206 and imm_val==2, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555556, 0x2, x1, 640, x3)

inst_615:
// rs1_val==6148914691236517206 and imm_val==1364, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x554
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555556, 0x554, x1, 648, x3)

inst_616:
// rs1_val==6148914691236517206 and imm_val==0, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x0
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555556, 0x0, x1, 656, x3)

inst_617:
// rs1_val==6148914691236517206 and imm_val==4, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x4
TEST_IMM_OP( ori, x11, x10, 0x5555555555555556, 0x5555555555555556, 0x4, x1, 664, x3)

inst_618:
// rs1_val==6148914691236517206 and imm_val==818, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x332
TEST_IMM_OP( ori, x11, x10, 0x5555555555555776, 0x5555555555555556, 0x332, x1, 672, x3)

inst_619:
// rs1_val==6148914691236517206 and imm_val==1637, 
// opcode: ori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x665
TEST_IMM_OP( ori, x11, x10, 0x5555555555555777, 0x5555555555555556, 0x665, x1, 680, x3)

inst_620:
// imm_val == 1, rs1_val > 0 and imm_val > 0
// opcode: ori ; op1:x10; dest:x11; op1val:0x4;  immval:0x1
TEST_IMM_OP( ori, x11, x10, 0x5, 0x4, 0x1, x1, 688, x3)

inst_621:
// rs1_val < 0 and imm_val < 0, rs1_val == -2097153, imm_val == -9
// opcode: ori ; op1:x10; dest:x11; op1val:-0x200001;  immval:-0x9
TEST_IMM_OP( ori, x11, x10, 0xffffffffffffffff, -0x200001, -0x9, x1, 696, x3)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x11_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x11_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x1_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_2:
    .fill 88*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
