
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the sll instruction of the RISC-V i extension for the sll covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64i")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",sll)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rs1 == rs2 != rd, rs1==x22, rs2==x22, rd==x6, rs1_val < 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == -274877906945
// opcode: sll ; op1:x22; op2:x22; dest:x6; op1val:-0x4000000001;  op2val:-0x4000000001
TEST_RR_OP(sll, x6, x22, x22, 0x8000000000000000, -0x4000000001, -0x4000000001, x1, 0, x19)

inst_1:
// rs2 == rd != rs1, rs1==x31, rs2==x7, rd==x7, rs1_val > 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == 1024
// opcode: sll ; op1:x31; op2:x7; dest:x7; op1val:0x400;  op2val:0xd
TEST_RR_OP(sll, x7, x31, x7, 0x800000, 0x400, 0xd, x1, 8, x19)

inst_2:
// rs1 == rs2 == rd, rs1==x26, rs2==x26, rd==x26, rs1_val < 0 and rs2_val == 0, 
// opcode: sll ; op1:x26; op2:x26; dest:x26; op1val:-0xa;  op2val:-0xa
TEST_RR_OP(sll, x26, x26, x26, 0xfd80000000000000, -0xa, -0xa, x1, 16, x19)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x15, rs2==x28, rd==x20, rs1_val > 0 and rs2_val == 0, rs1_val == 17592186044416
// opcode: sll ; op1:x15; op2:x28; dest:x20; op1val:0x100000000000;  op2val:0x0
TEST_RR_OP(sll, x20, x15, x28, 0x100000000000, 0x100000000000, 0x0, x1, 24, x19)

inst_4:
// rs1 == rd != rs2, rs1==x12, rs2==x10, rd==x12, rs1_val == rs2_val and rs2_val > 0 and rs2_val < xlen, rs1_val == 1 and rs2_val >= 0 and rs2_val < xlen, rs1_val == 1, rs2_val == 1
// opcode: sll ; op1:x12; op2:x10; dest:x12; op1val:0x1;  op2val:0x1
TEST_RR_OP(sll, x12, x12, x10, 0x2, 0x1, 0x1, x1, 32, x19)

inst_5:
// rs1==x21, rs2==x27, rd==x10, rs1_val == (-2**(xlen-1)) and rs2_val >= 0 and rs2_val < xlen, rs1_val == -9223372036854775808
// opcode: sll ; op1:x21; op2:x27; dest:x10; op1val:-0x8000000000000000;  op2val:0xe
TEST_RR_OP(sll, x10, x21, x27, 0x0, -0x8000000000000000, 0xe, x1, 40, x19)

inst_6:
// rs1==x6, rs2==x25, rd==x17, rs1_val == 0 and rs2_val >= 0 and rs2_val < xlen, rs2_val == 59, rs1_val==0
// opcode: sll ; op1:x6; op2:x25; dest:x17; op1val:0x0;  op2val:0x3b
TEST_RR_OP(sll, x17, x6, x25, 0x0, 0x0, 0x3b, x1, 48, x19)

inst_7:
// rs1==x24, rs2==x11, rd==x23, rs1_val == (2**(xlen-1)-1) and rs2_val >= 0 and rs2_val < xlen, rs1_val == 9223372036854775807, rs2_val == 31
// opcode: sll ; op1:x24; op2:x11; dest:x23; op1val:0x7fffffffffffffff;  op2val:0x1f
TEST_RR_OP(sll, x23, x24, x11, 0xffffffff80000000, 0x7fffffffffffffff, 0x1f, x1, 56, x19)

inst_8:
// rs1==x4, rs2==x24, rd==x2, rs1_val == 2, rs1_val==2
// opcode: sll ; op1:x4; op2:x24; dest:x2; op1val:0x2;  op2val:0x9
TEST_RR_OP(sll, x2, x4, x24, 0x400, 0x2, 0x9, x1, 64, x19)

inst_9:
// rs1==x2, rs2==x17, rd==x4, rs1_val == 4, rs1_val==4
// opcode: sll ; op1:x2; op2:x17; dest:x4; op1val:0x4;  op2val:0xb
TEST_RR_OP(sll, x4, x2, x17, 0x2000, 0x4, 0xb, x1, 72, x19)

inst_10:
// rs1==x8, rs2==x5, rd==x11, rs1_val == 8, rs2_val == 16
// opcode: sll ; op1:x8; op2:x5; dest:x11; op1val:0x8;  op2val:0x10
TEST_RR_OP(sll, x11, x8, x5, 0x80000, 0x8, 0x10, x1, 80, x19)

inst_11:
// rs1==x18, rs2==x4, rd==x16, rs1_val == 16, 
// opcode: sll ; op1:x18; op2:x4; dest:x16; op1val:0x10;  op2val:0x1
TEST_RR_OP(sll, x16, x18, x4, 0x20, 0x10, 0x1, x1, 88, x19)

inst_12:
// rs1==x3, rs2==x20, rd==x22, rs1_val == 32, 
// opcode: sll ; op1:x3; op2:x20; dest:x22; op1val:0x20;  op2val:0xf
TEST_RR_OP(sll, x22, x3, x20, 0x100000, 0x20, 0xf, x1, 96, x19)

inst_13:
// rs1==x5, rs2==x6, rd==x28, rs1_val == 64, 
// opcode: sll ; op1:x5; op2:x6; dest:x28; op1val:0x40;  op2val:0x3
TEST_RR_OP(sll, x28, x5, x6, 0x200, 0x40, 0x3, x1, 104, x19)

inst_14:
// rs1==x11, rs2==x8, rd==x25, rs1_val == 128, 
// opcode: sll ; op1:x11; op2:x8; dest:x25; op1val:0x80;  op2val:0xd
TEST_RR_OP(sll, x25, x11, x8, 0x100000, 0x80, 0xd, x1, 112, x19)

inst_15:
// rs1==x13, rs2==x2, rd==x14, rs1_val == 256, 
// opcode: sll ; op1:x13; op2:x2; dest:x14; op1val:0x100;  op2val:0x3f
TEST_RR_OP(sll, x14, x13, x2, 0x0, 0x100, 0x3f, x1, 120, x19)

inst_16:
// rs1==x9, rs2==x12, rd==x30, rs1_val == 512, 
// opcode: sll ; op1:x9; op2:x12; dest:x30; op1val:0x200;  op2val:0x11
TEST_RR_OP(sll, x30, x9, x12, 0x4000000, 0x200, 0x11, x1, 128, x19)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_17:
// rs1==x27, rs2==x31, rd==x21, rs1_val == 2048, 
// opcode: sll ; op1:x27; op2:x31; dest:x21; op1val:0x800;  op2val:0x0
TEST_RR_OP(sll, x21, x27, x31, 0x800, 0x800, 0x0, x2, 0, x4)

inst_18:
// rs1==x20, rs2==x23, rd==x3, rs1_val == 4096, 
// opcode: sll ; op1:x20; op2:x23; dest:x3; op1val:0x1000;  op2val:0x1f
TEST_RR_OP(sll, x3, x20, x23, 0x80000000000, 0x1000, 0x1f, x2, 8, x4)

inst_19:
// rs1==x25, rs2==x19, rd==x5, rs1_val == 8192, 
// opcode: sll ; op1:x25; op2:x19; dest:x5; op1val:0x2000;  op2val:0xb
TEST_RR_OP(sll, x5, x25, x19, 0x1000000, 0x2000, 0xb, x2, 16, x4)

inst_20:
// rs1==x10, rs2==x29, rd==x1, rs1_val == 16384, 
// opcode: sll ; op1:x10; op2:x29; dest:x1; op1val:0x4000;  op2val:0x9
TEST_RR_OP(sll, x1, x10, x29, 0x800000, 0x4000, 0x9, x2, 24, x4)

inst_21:
// rs1==x1, rs2==x18, rd==x19, rs1_val == 32768, 
// opcode: sll ; op1:x1; op2:x18; dest:x19; op1val:0x8000;  op2val:0x0
TEST_RR_OP(sll, x19, x1, x18, 0x8000, 0x8000, 0x0, x2, 32, x4)

inst_22:
// rs1==x29, rs2==x30, rd==x31, rs1_val == 65536, 
// opcode: sll ; op1:x29; op2:x30; dest:x31; op1val:0x10000;  op2val:0x1
TEST_RR_OP(sll, x31, x29, x30, 0x20000, 0x10000, 0x1, x2, 40, x4)

inst_23:
// rs1==x28, rs2==x0, rd==x15, rs1_val == 131072, rs2_val == 2
// opcode: sll ; op1:x28; op2:x0; dest:x15; op1val:0x20000;  op2val:0x0
TEST_RR_OP(sll, x15, x28, x0, 0x20000, 0x20000, 0x0, x2, 48, x4)

inst_24:
// rs1==x30, rs2==x21, rd==x27, rs1_val == 262144, 
// opcode: sll ; op1:x30; op2:x21; dest:x27; op1val:0x40000;  op2val:0xf
TEST_RR_OP(sll, x27, x30, x21, 0x200000000, 0x40000, 0xf, x2, 56, x4)

inst_25:
// rs1==x16, rs2==x14, rd==x29, rs1_val == 524288, 
// opcode: sll ; op1:x16; op2:x14; dest:x29; op1val:0x80000;  op2val:0x2
TEST_RR_OP(sll, x29, x16, x14, 0x200000, 0x80000, 0x2, x2, 64, x4)

inst_26:
// rs1==x23, rs2==x9, rd==x0, rs1_val == 1048576, 
// opcode: sll ; op1:x23; op2:x9; dest:x0; op1val:0x100000;  op2val:0x2
TEST_RR_OP(sll, x0, x23, x9, 0, 0x100000, 0x2, x2, 72, x4)

inst_27:
// rs1==x17, rs2==x1, rd==x18, rs1_val == 2097152, 
// opcode: sll ; op1:x17; op2:x1; dest:x18; op1val:0x200000;  op2val:0x3f
TEST_RR_OP(sll, x18, x17, x1, 0x0, 0x200000, 0x3f, x2, 80, x4)

inst_28:
// rs1==x19, rs2==x15, rd==x24, rs1_val == 4194304, 
// opcode: sll ; op1:x19; op2:x15; dest:x24; op1val:0x400000;  op2val:0x3f
TEST_RR_OP(sll, x24, x19, x15, 0x0, 0x400000, 0x3f, x2, 88, x4)

inst_29:
// rs1==x14, rs2==x13, rd==x8, rs1_val == 8388608, 
// opcode: sll ; op1:x14; op2:x13; dest:x8; op1val:0x800000;  op2val:0x13
TEST_RR_OP(sll, x8, x14, x13, 0x40000000000, 0x800000, 0x13, x2, 96, x4)

inst_30:
// rs1==x0, rs2==x3, rd==x13, rs1_val == 16777216, rs2_val == 32
// opcode: sll ; op1:x0; op2:x3; dest:x13; op1val:0x0;  op2val:0x20
TEST_RR_OP(sll, x13, x0, x3, 0x0, 0x0, 0x20, x2, 104, x4)

inst_31:
// rs1==x7, rs2==x16, rd==x9, rs1_val == 33554432, 
// opcode: sll ; op1:x7; op2:x16; dest:x9; op1val:0x2000000;  op2val:0xd
TEST_RR_OP(sll, x9, x7, x16, 0x4000000000, 0x2000000, 0xd, x2, 112, x4)

inst_32:
// rs1_val == 67108864, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x3f
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x4000000, 0x3f, x2, 120, x4)

inst_33:
// rs1_val == 134217728, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0x40000000, 0x8000000, 0x3, x2, 128, x4)

inst_34:
// rs1_val == 268435456, rs2_val == 4
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0x100000000, 0x10000000, 0x4, x2, 136, x4)

inst_35:
// rs1_val == 536870912, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x3b
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x20000000, 0x3b, x2, 144, x4)

inst_36:
// rs1_val == 1073741824, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0x6
TEST_RR_OP(sll, x12, x10, x11, 0x1000000000, 0x40000000, 0x6, x2, 152, x4)

inst_37:
// rs1_val == 2147483648, rs2_val == 8
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0x8
TEST_RR_OP(sll, x12, x10, x11, 0x8000000000, 0x80000000, 0x8, x2, 160, x4)

inst_38:
// rs1_val == 4294967296, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x12
TEST_RR_OP(sll, x12, x10, x11, 0x4000000000000, 0x100000000, 0x12, x2, 168, x4)

inst_39:
// rs1_val == 8589934592, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:0x9
TEST_RR_OP(sll, x12, x10, x11, 0x40000000000, 0x200000000, 0x9, x2, 176, x4)

inst_40:
// rs1_val == 17179869184, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:0x20
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x400000000, 0x20, x2, 184, x4)

inst_41:
// rs1_val == 34359738368, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x1
TEST_RR_OP(sll, x12, x10, x11, 0x1000000000, 0x800000000, 0x1, x2, 192, x4)

inst_42:
// rs1_val == 68719476736, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0xd
TEST_RR_OP(sll, x12, x10, x11, 0x2000000000000, 0x1000000000, 0xd, x2, 200, x4)

inst_43:
// rs1_val == 137438953472, rs2_val == 42
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:0x2a
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x2000000000, 0x2a, x2, 208, x4)

inst_44:
// rs1_val == 274877906944, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:0x20
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x4000000000, 0x20, x2, 216, x4)

inst_45:
// rs1_val == 549755813888, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0x11
TEST_RR_OP(sll, x12, x10, x11, 0x100000000000000, 0x8000000000, 0x11, x2, 224, x4)

inst_46:
// rs1_val == 1099511627776, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x40000000000, 0x10000000000, 0x2, x2, 232, x4)

inst_47:
// rs1_val == 2199023255552, rs2_val == 61
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:0x3d
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x20000000000, 0x3d, x2, 240, x4)

inst_48:
// rs1_val == 4398046511104, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0xc
TEST_RR_OP(sll, x12, x10, x11, 0x40000000000000, 0x40000000000, 0xc, x2, 248, x4)

inst_49:
// rs1_val == 8796093022208, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x200000000000, 0x80000000000, 0x2, x2, 256, x4)

inst_50:
// rs1_val == 35184372088832, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0x1f
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x200000000000, 0x1f, x2, 264, x4)

inst_51:
// rs1_val == 70368744177664, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0x9
TEST_RR_OP(sll, x12, x10, x11, 0x80000000000000, 0x400000000000, 0x9, x2, 272, x4)

inst_52:
// rs1_val == 140737488355328, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:0x20
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x800000000000, 0x20, x2, 280, x4)

inst_53:
// rs1_val == 281474976710656, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:0x3d
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x1000000000000, 0x3d, x2, 288, x4)

inst_54:
// rs1_val == 562949953421312, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0x1
TEST_RR_OP(sll, x12, x10, x11, 0x4000000000000, 0x2000000000000, 0x1, x2, 296, x4)

inst_55:
// rs1_val == 1125899906842624, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:0x3f
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x4000000000000, 0x3f, x2, 304, x4)

inst_56:
// rs1_val == 2251799813685248, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:0x0
TEST_RR_OP(sll, x12, x10, x11, 0x8000000000000, 0x8000000000000, 0x0, x2, 312, x4)

inst_57:
// rs1_val == 4503599627370496, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x40000000000000, 0x10000000000000, 0x2, x2, 320, x4)

inst_58:
// rs1_val == 9007199254740992, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0x100000000000000, 0x20000000000000, 0x3, x2, 328, x4)

inst_59:
// rs1_val == 18014398509481984, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0xc
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x40000000000000, 0xc, x2, 336, x4)

inst_60:
// rs1_val == 36028797018963968, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:0x3b
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x80000000000000, 0x3b, x2, 344, x4)

inst_61:
// rs1_val == 72057594037927936, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0xd
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x100000000000000, 0xd, x2, 352, x4)

inst_62:
// rs1_val == 144115188075855872, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:0x3b
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x200000000000000, 0x3b, x2, 360, x4)

inst_63:
// rs1_val == 288230376151711744, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0x12
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x400000000000000, 0x12, x2, 368, x4)

inst_64:
// rs1_val == 576460752303423488, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0x2a
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x800000000000000, 0x2a, x2, 376, x4)

inst_65:
// rs1_val == 1152921504606846976, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x4000000000000000, 0x1000000000000000, 0x2, x2, 384, x4)

inst_66:
// rs1_val == 2305843009213693952, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:0xf
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x2000000000000000, 0xf, x2, 392, x4)

inst_67:
// rs1_val == 4611686018427387904, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x4000000000000000, 0x3, x2, 400, x4)

inst_68:
// rs1_val == -2, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:0x10
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffffe0000, -0x2, 0x10, x2, 408, x4)

inst_69:
// rs1_val == -3, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:0x0
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffffffffd, -0x3, 0x0, x2, 416, x4)

inst_70:
// rs1_val == -5, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:0x1f
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffd80000000, -0x5, 0x1f, x2, 424, x4)

inst_71:
// rs1_val == -9, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:0x20
TEST_RR_OP(sll, x12, x10, x11, 0xfffffff700000000, -0x9, 0x20, x2, 432, x4)

inst_72:
// rs1_val == -17, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:0x13
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffff780000, -0x11, 0x13, x2, 440, x4)

inst_73:
// rs1_val == -33, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x3f
TEST_RR_OP(sll, x12, x10, x11, 0x8000000000000000, -0x21, 0x3f, x2, 448, x4)

inst_74:
// rs1_val == -65, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:0xc
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffffbf000, -0x41, 0xc, x2, 456, x4)

inst_75:
// rs1_val == -129, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0x20
TEST_RR_OP(sll, x12, x10, x11, 0xffffff7f00000000, -0x81, 0x20, x2, 464, x4)

inst_76:
// rs1_val == -257, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffffffeff0, -0x101, 0x4, x2, 472, x4)

inst_77:
// rs1_val == -513, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:0x1f
TEST_RR_OP(sll, x12, x10, x11, 0xfffffeff80000000, -0x201, 0x1f, x2, 480, x4)

inst_78:
// rs1_val == -1025, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffffffbff0, -0x401, 0x4, x2, 488, x4)

inst_79:
// rs1_val == -2049, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:0x8
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffff7ff00, -0x801, 0x8, x2, 496, x4)

inst_80:
// rs1_val == -4097, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffffefff0, -0x1001, 0x4, x2, 504, x4)

inst_81:
// rs1_val == -8193, rs2_val == 55
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x37
TEST_RR_OP(sll, x12, x10, x11, 0xff80000000000000, -0x2001, 0x37, x2, 512, x4)

inst_82:
// rs1_val == -16385, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:0xf
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffdfff8000, -0x4001, 0xf, x2, 520, x4)

inst_83:
// rs1_val == -32769, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:0xc
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffff7fff000, -0x8001, 0xc, x2, 528, x4)

inst_84:
// rs1_val == -65537, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:0x37
TEST_RR_OP(sll, x12, x10, x11, 0xff80000000000000, -0x10001, 0x37, x2, 536, x4)

inst_85:
// rs1_val == -131073, rs2_val == 62
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:0x3e
TEST_RR_OP(sll, x12, x10, x11, 0xc000000000000000, -0x20001, 0x3e, x2, 544, x4)

inst_86:
// rs1_val == -262145, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0x7
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffdffff80, -0x40001, 0x7, x2, 552, x4)

inst_87:
// rs1_val == -524289, rs2_val == 21
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x15
TEST_RR_OP(sll, x12, x10, x11, 0xfffffeffffe00000, -0x80001, 0x15, x2, 560, x4)

inst_88:
// rs1_val == -1048577, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0x2a
TEST_RR_OP(sll, x12, x10, x11, 0xbffffc0000000000, -0x100001, 0x2a, x2, 568, x4)

inst_89:
// rs1_val == -36028797018963969, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:0x1f
TEST_RR_OP(sll, x12, x10, x11, 0xffffffff80000000, -0x80000000000001, 0x1f, x2, 576, x4)

inst_90:
// rs1_val == -72057594037927937, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000000001;  op2val:0x3d
TEST_RR_OP(sll, x12, x10, x11, 0xe000000000000000, -0x100000000000001, 0x3d, x2, 584, x4)

inst_91:
// rs1_val == -144115188075855873, rs2_val == 47
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:0x2f
TEST_RR_OP(sll, x12, x10, x11, 0xffff800000000000, -0x200000000000001, 0x2f, x2, 592, x4)

inst_92:
// rs1_val == -288230376151711745, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:0x8
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffffffff00, -0x400000000000001, 0x8, x2, 600, x4)

inst_93:
// rs1_val == -576460752303423489, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:0x2f
TEST_RR_OP(sll, x12, x10, x11, 0xffff800000000000, -0x800000000000001, 0x2f, x2, 608, x4)

inst_94:
// rs1_val == -1152921504606846977, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:0xd
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffffffe000, -0x1000000000000001, 0xd, x2, 616, x4)

inst_95:
// rs1_val == -2305843009213693953, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000000001;  op2val:0x12
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffffc0000, -0x2000000000000001, 0x12, x2, 624, x4)

inst_96:
// rs1_val == -4611686018427387905, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:0x3d
TEST_RR_OP(sll, x12, x10, x11, 0xe000000000000000, -0x4000000000000001, 0x3d, x2, 632, x4)

inst_97:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0xaaaaaaaaaaaaaaa8, 0x5555555555555555, 0x3, x2, 640, x4)

inst_98:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0xaaaaaaaaaaaaaaa8, -0x5555555555555556, 0x2, x2, 648, x4)

inst_99:
// rs1_val==3, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(sll, x12, x10, x11, 0xc0, 0x3, 0x6, x2, 656, x4)

inst_100:
// rs1_val==5, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2a
TEST_RR_OP(sll, x12, x10, x11, 0x140000000000, 0x5, 0x2a, x2, 664, x4)

inst_101:
// rs1_val==3689348814741910323, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x1
TEST_RR_OP(sll, x12, x10, x11, 0x6666666666666666, 0x3333333333333333, 0x1, x2, 672, x4)

inst_102:
// rs1_val==7378697629483820646, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0x3333333333333330, 0x6666666666666666, 0x3, x2, 680, x4)

inst_103:
// rs1_val==-3037000499, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xe
TEST_RR_OP(sll, x12, x10, x11, 0xffffd2bec3334000, -0xb504f333, 0xe, x2, 688, x4)

inst_104:
// rs1_val==3037000499, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(sll, x12, x10, x11, 0xb504f3330, 0xb504f333, 0x4, x2, 696, x4)

inst_105:
// rs1_val==6148914691236517204, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(sll, x12, x10, x11, 0xaaaaaaaaaaaaaa80, 0x5555555555555554, 0x5, x2, 704, x4)

inst_106:
// rs1_val==3689348814741910322, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3f
TEST_RR_OP(sll, x12, x10, x11, 0x0, 0x3333333333333332, 0x3f, x2, 712, x4)

inst_107:
// rs1_val==7378697629483820645, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x12
TEST_RR_OP(sll, x12, x10, x11, 0x9999999999940000, 0x6666666666666665, 0x12, x2, 720, x4)

inst_108:
// rs1_val==3037000498, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x20
TEST_RR_OP(sll, x12, x10, x11, 0xb504f33200000000, 0xb504f332, 0x20, x2, 728, x4)

inst_109:
// rs1_val==6148914691236517206, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x5555555555555558, 0x5555555555555556, 0x2, x2, 736, x4)

inst_110:
// rs1_val==-6148914691236517205, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6
TEST_RR_OP(sll, x12, x10, x11, 0xaaaaaaaaaaaaaac0, -0x5555555555555555, 0x6, x2, 744, x4)

inst_111:
// rs1_val==6, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3b
TEST_RR_OP(sll, x12, x10, x11, 0x3000000000000000, 0x6, 0x3b, x2, 752, x4)

inst_112:
// rs1_val==3689348814741910324, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x10
TEST_RR_OP(sll, x12, x10, x11, 0x3333333333340000, 0x3333333333333334, 0x10, x2, 760, x4)

inst_113:
// rs1_val==7378697629483820647, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2a
TEST_RR_OP(sll, x12, x10, x11, 0x99999c0000000000, 0x6666666666666667, 0x2a, x2, 768, x4)

inst_114:
// rs1_val==-3037000498, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x2f
TEST_RR_OP(sll, x12, x10, x11, 0x8667000000000000, -0xb504f332, 0x2f, x2, 776, x4)

inst_115:
// rs1_val==3037000500, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x7
TEST_RR_OP(sll, x12, x10, x11, 0x5a82799a00, 0xb504f334, 0x7, x2, 784, x4)

inst_116:
// rs1_val == -2097153, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:0x7
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffefffff80, -0x200001, 0x7, x2, 792, x4)

inst_117:
// rs1_val == -4194305, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:0xb
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffdfffff800, -0x400001, 0xb, x2, 800, x4)

inst_118:
// rs1_val == -8388609, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0x2f
TEST_RR_OP(sll, x12, x10, x11, 0xffff800000000000, -0x800001, 0x2f, x2, 808, x4)

inst_119:
// rs1_val == -16777217, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0x11
TEST_RR_OP(sll, x12, x10, x11, 0xfffffdfffffe0000, -0x1000001, 0x11, x2, 816, x4)

inst_120:
// rs1_val == -33554433, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0x0
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffdffffff, -0x2000001, 0x0, x2, 824, x4)

inst_121:
// rs1_val == -67108865, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:0x37
TEST_RR_OP(sll, x12, x10, x11, 0xff80000000000000, -0x4000001, 0x37, x2, 832, x4)

inst_122:
// rs1_val == -134217729, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffdffffffc, -0x8000001, 0x2, x2, 840, x4)

inst_123:
// rs1_val == -268435457, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:0x1f
TEST_RR_OP(sll, x12, x10, x11, 0xf7ffffff80000000, -0x10000001, 0x1f, x2, 848, x4)

inst_124:
// rs1_val == -536870913, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffefffffff8, -0x20000001, 0x3, x2, 856, x4)

inst_125:
// rs1_val == -1073741825, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0x3f
TEST_RR_OP(sll, x12, x10, x11, 0x8000000000000000, -0x40000001, 0x3f, x2, 864, x4)

inst_126:
// rs1_val == -2147483649, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x80000001;  op2val:0x6
TEST_RR_OP(sll, x12, x10, x11, 0xffffffdfffffffc0, -0x80000001, 0x6, x2, 872, x4)

inst_127:
// rs1_val == -4294967297, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:0x3e
TEST_RR_OP(sll, x12, x10, x11, 0xc000000000000000, -0x100000001, 0x3e, x2, 880, x4)

inst_128:
// rs1_val == -8589934593, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:0xb
TEST_RR_OP(sll, x12, x10, x11, 0xffffeffffffff800, -0x200000001, 0xb, x2, 888, x4)

inst_129:
// rs1_val == -17179869185, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x400000001;  op2val:0xf
TEST_RR_OP(sll, x12, x10, x11, 0xfffdffffffff8000, -0x400000001, 0xf, x2, 896, x4)

inst_130:
// rs1_val == -34359738369, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x800000001;  op2val:0x3
TEST_RR_OP(sll, x12, x10, x11, 0xffffffbffffffff8, -0x800000001, 0x3, x2, 904, x4)

inst_131:
// rs1_val == -68719476737, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:0x37
TEST_RR_OP(sll, x12, x10, x11, 0xff80000000000000, -0x1000000001, 0x37, x2, 912, x4)

inst_132:
// rs1_val == -137438953473, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000001;  op2val:0x9
TEST_RR_OP(sll, x12, x10, x11, 0xffffbffffffffe00, -0x2000000001, 0x9, x2, 920, x4)

inst_133:
// rs1_val == -549755813889, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0xe
TEST_RR_OP(sll, x12, x10, x11, 0xffdfffffffffc000, -0x8000000001, 0xe, x2, 928, x4)

inst_134:
// rs1_val == -1099511627777, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000001;  op2val:0x2a
TEST_RR_OP(sll, x12, x10, x11, 0xfffffc0000000000, -0x10000000001, 0x2a, x2, 936, x4)

inst_135:
// rs1_val == -2199023255553, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000001;  op2val:0x7
TEST_RR_OP(sll, x12, x10, x11, 0xfffeffffffffff80, -0x20000000001, 0x7, x2, 944, x4)

inst_136:
// rs1_val == -4398046511105, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:0x6
TEST_RR_OP(sll, x12, x10, x11, 0xfffeffffffffffc0, -0x40000000001, 0x6, x2, 952, x4)

inst_137:
// rs1_val == -8796093022209, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:0xb
TEST_RR_OP(sll, x12, x10, x11, 0xffbffffffffff800, -0x80000000001, 0xb, x2, 960, x4)

inst_138:
// rs1_val == -17592186044417, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000001;  op2val:0x20
TEST_RR_OP(sll, x12, x10, x11, 0xffffffff00000000, -0x100000000001, 0x20, x2, 968, x4)

inst_139:
// rs1_val == -35184372088833, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000001;  op2val:0x1
TEST_RR_OP(sll, x12, x10, x11, 0xffffbffffffffffe, -0x200000000001, 0x1, x2, 976, x4)

inst_140:
// rs1_val == -70368744177665, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000001;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0xfffefffffffffffc, -0x400000000001, 0x2, x2, 984, x4)

inst_141:
// rs1_val == -140737488355329, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0xe
TEST_RR_OP(sll, x12, x10, x11, 0xdfffffffffffc000, -0x800000000001, 0xe, x2, 992, x4)

inst_142:
// rs1_val == -281474976710657, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000001;  op2val:0x5
TEST_RR_OP(sll, x12, x10, x11, 0xffdfffffffffffe0, -0x1000000000001, 0x5, x2, 1000, x4)

inst_143:
// rs1_val == -562949953421313, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000001;  op2val:0xe
TEST_RR_OP(sll, x12, x10, x11, 0x7fffffffffffc000, -0x2000000000001, 0xe, x2, 1008, x4)

inst_144:
// rs1_val == -1125899906842625, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000001;  op2val:0x11
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffffe0000, -0x4000000000001, 0x11, x2, 1016, x4)

inst_145:
// rs1_val == -2251799813685249, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000001;  op2val:0x37
TEST_RR_OP(sll, x12, x10, x11, 0xff80000000000000, -0x8000000000001, 0x37, x2, 1024, x4)

inst_146:
// rs1_val == -4503599627370497, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0x10
TEST_RR_OP(sll, x12, x10, x11, 0xffffffffffff0000, -0x10000000000001, 0x10, x2, 1032, x4)

inst_147:
// rs1_val == -9007199254740993, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000000001;  op2val:0x13
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffff80000, -0x20000000000001, 0x13, x2, 1040, x4)

inst_148:
// rs1_val == -18014398509481985, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000000001;  op2val:0xa
TEST_RR_OP(sll, x12, x10, x11, 0xfffffffffffffc00, -0x40000000000001, 0xa, x2, 1048, x4)

inst_149:
// rs1_val < 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == -274877906945
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000001;  op2val:0xa
TEST_RR_OP(sll, x12, x10, x11, 0xfffefffffffffc00, -0x4000000001, 0xa, x2, 1056, x4)

inst_150:
// rs1_val == 131072, rs2_val == 2
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x80000, 0x20000, 0x2, x2, 1064, x4)

inst_151:
// rs1_val == 1048576, 
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0x2
TEST_RR_OP(sll, x12, x10, x11, 0x400000, 0x100000, 0x2, x2, 1072, x4)

inst_152:
// rs1_val == 16777216, rs2_val == 32
// opcode: sll ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x20
TEST_RR_OP(sll, x12, x10, x11, 0x100000000000000, 0x1000000, 0x20, x2, 1080, x4)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 17*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 136*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
