
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the slli instruction of the RISC-V I extension for the slli covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",slli)

RVTEST_SIGBASE( x3,signature_x3_1)

inst_0:
// rs1 == rd, rs1==x5, rd==x5, rs1_val < 0 and imm_val > 0 and imm_val < xlen, rs1_val == -257
// opcode: slli ; op1:x5; dest:x5; op1val:-0x101;  immval:0xf
TEST_IMM_OP( slli, x5, x5, 0xffffffffff7f8000, -0x101, 0xf, x3, 0, x17)

inst_1:
// rs1 != rd, rs1==x8, rd==x13, rs1_val > 0 and imm_val > 0 and imm_val < xlen, rs1_val==4, rs1_val == 4
// opcode: slli ; op1:x8; dest:x13; op1val:0x4;  immval:0xe
TEST_IMM_OP( slli, x13, x8, 0x10000, 0x4, 0xe, x3, 8, x17)

inst_2:
// rs1==x29, rd==x21, rs1_val < 0 and imm_val == 0, rs1_val == -9
// opcode: slli ; op1:x29; dest:x21; op1val:-0x9;  immval:0x0
TEST_IMM_OP( slli, x21, x29, 0xfffffffffffffff7, -0x9, 0x0, x3, 16, x17)

inst_3:
// rs1==x28, rd==x16, rs1_val > 0 and imm_val == 0, 
// opcode: slli ; op1:x28; dest:x16; op1val:0x4;  immval:0x0
TEST_IMM_OP( slli, x16, x28, 0x4, 0x4, 0x0, x3, 24, x17)

inst_4:
// rs1==x15, rd==x10, rs1_val < 0 and imm_val == (xlen-1), rs1_val == -536870913
// opcode: slli ; op1:x15; dest:x10; op1val:-0x20000001;  immval:0x3f
TEST_IMM_OP( slli, x10, x15, 0x8000000000000000, -0x20000001, 0x3f, x3, 32, x17)

inst_5:
// rs1==x19, rd==x12, rs1_val > 0 and imm_val == (xlen-1), rs1_val == 4503599627370496
// opcode: slli ; op1:x19; dest:x12; op1val:0x10000000000000;  immval:0x3f
TEST_IMM_OP( slli, x12, x19, 0x0, 0x10000000000000, 0x3f, x3, 40, x17)

inst_6:
// rs1==x22, rd==x8, rs1_val == imm_val and imm_val > 0 and imm_val < xlen, imm_val == 2, rs1_val == 2, rs1_val==2
// opcode: slli ; op1:x22; dest:x8; op1val:0x2;  immval:0x2
TEST_IMM_OP( slli, x8, x22, 0x8, 0x2, 0x2, x3, 48, x17)

inst_7:
// rs1==x6, rd==x7, rs1_val == (-2**(xlen-1)) and imm_val >= 0 and imm_val < xlen, rs1_val == -9223372036854775808
// opcode: slli ; op1:x6; dest:x7; op1val:-0x8000000000000000;  immval:0xb
TEST_IMM_OP( slli, x7, x6, 0x0, -0x8000000000000000, 0xb, x3, 56, x17)

inst_8:
// rs1==x27, rd==x24, rs1_val == 0 and imm_val >= 0 and imm_val < xlen, rs1_val==0
// opcode: slli ; op1:x27; dest:x24; op1val:0x0;  immval:0xf
TEST_IMM_OP( slli, x24, x27, 0x0, 0x0, 0xf, x3, 64, x17)

inst_9:
// rs1==x23, rd==x11, rs1_val == (2**(xlen-1)-1) and imm_val >= 0 and imm_val < xlen, rs1_val == 9223372036854775807
// opcode: slli ; op1:x23; dest:x11; op1val:0x7fffffffffffffff;  immval:0x7
TEST_IMM_OP( slli, x11, x23, 0xffffffffffffff80, 0x7fffffffffffffff, 0x7, x3, 72, x17)

inst_10:
// rs1==x14, rd==x9, rs1_val == 1 and imm_val >= 0 and imm_val < xlen, rs1_val == 1, imm_val == 59
// opcode: slli ; op1:x14; dest:x9; op1val:0x1;  immval:0x3b
TEST_IMM_OP( slli, x9, x14, 0x800000000000000, 0x1, 0x3b, x3, 80, x17)

inst_11:
// rs1==x26, rd==x14, rs1_val == 8, imm_val == 47
// opcode: slli ; op1:x26; dest:x14; op1val:0x8;  immval:0x2f
TEST_IMM_OP( slli, x14, x26, 0x4000000000000, 0x8, 0x2f, x3, 88, x17)

inst_12:
// rs1==x7, rd==x0, rs1_val == 16, 
// opcode: slli ; op1:x7; dest:x0; op1val:0x10;  immval:0xe
TEST_IMM_OP( slli, x0, x7, 0, 0x10, 0xe, x3, 96, x17)

inst_13:
// rs1==x30, rd==x18, rs1_val == 32, 
// opcode: slli ; op1:x30; dest:x18; op1val:0x20;  immval:0x5
TEST_IMM_OP( slli, x18, x30, 0x400, 0x20, 0x5, x3, 104, x17)

inst_14:
// rs1==x24, rd==x28, rs1_val == 64, 
// opcode: slli ; op1:x24; dest:x28; op1val:0x40;  immval:0x2f
TEST_IMM_OP( slli, x28, x24, 0x20000000000000, 0x40, 0x2f, x3, 112, x17)

inst_15:
// rs1==x4, rd==x1, rs1_val == 128, 
// opcode: slli ; op1:x4; dest:x1; op1val:0x80;  immval:0x12
TEST_IMM_OP( slli, x1, x4, 0x2000000, 0x80, 0x12, x3, 120, x17)

inst_16:
// rs1==x10, rd==x25, rs1_val == 256, imm_val == 61
// opcode: slli ; op1:x10; dest:x25; op1val:0x100;  immval:0x3d
TEST_IMM_OP( slli, x25, x10, 0x0, 0x100, 0x3d, x3, 128, x17)

inst_17:
// rs1==x16, rd==x19, rs1_val == 512, imm_val == 31
// opcode: slli ; op1:x16; dest:x19; op1val:0x200;  immval:0x1f
TEST_IMM_OP( slli, x19, x16, 0x10000000000, 0x200, 0x1f, x3, 136, x17)

inst_18:
// rs1==x2, rd==x31, rs1_val == 1024, 
// opcode: slli ; op1:x2; dest:x31; op1val:0x400;  immval:0xa
TEST_IMM_OP( slli, x31, x2, 0x100000, 0x400, 0xa, x3, 144, x17)
RVTEST_SIGBASE( x5,signature_x5_0)

inst_19:
// rs1==x1, rd==x4, rs1_val == 2048, 
// opcode: slli ; op1:x1; dest:x4; op1val:0x800;  immval:0x1f
TEST_IMM_OP( slli, x4, x1, 0x40000000000, 0x800, 0x1f, x5, 0, x7)

inst_20:
// rs1==x3, rd==x29, rs1_val == 4096, 
// opcode: slli ; op1:x3; dest:x29; op1val:0x1000;  immval:0x0
TEST_IMM_OP( slli, x29, x3, 0x1000, 0x1000, 0x0, x5, 8, x7)

inst_21:
// rs1==x25, rd==x6, rs1_val == 8192, 
// opcode: slli ; op1:x25; dest:x6; op1val:0x2000;  immval:0xa
TEST_IMM_OP( slli, x6, x25, 0x800000, 0x2000, 0xa, x5, 16, x7)

inst_22:
// rs1==x12, rd==x23, rs1_val == 16384, 
// opcode: slli ; op1:x12; dest:x23; op1val:0x4000;  immval:0x9
TEST_IMM_OP( slli, x23, x12, 0x800000, 0x4000, 0x9, x5, 24, x7)

inst_23:
// rs1==x21, rd==x3, rs1_val == 32768, 
// opcode: slli ; op1:x21; dest:x3; op1val:0x8000;  immval:0xc
TEST_IMM_OP( slli, x3, x21, 0x8000000, 0x8000, 0xc, x5, 32, x7)

inst_24:
// rs1==x9, rd==x17, rs1_val == 65536, 
// opcode: slli ; op1:x9; dest:x17; op1val:0x10000;  immval:0x3b
TEST_IMM_OP( slli, x17, x9, 0x0, 0x10000, 0x3b, x5, 40, x7)

inst_25:
// rs1==x13, rd==x15, rs1_val == 131072, 
// opcode: slli ; op1:x13; dest:x15; op1val:0x20000;  immval:0xe
TEST_IMM_OP( slli, x15, x13, 0x80000000, 0x20000, 0xe, x5, 48, x7)

inst_26:
// rs1==x11, rd==x22, rs1_val == 262144, 
// opcode: slli ; op1:x11; dest:x22; op1val:0x40000;  immval:0x13
TEST_IMM_OP( slli, x22, x11, 0x2000000000, 0x40000, 0x13, x5, 56, x7)

inst_27:
// rs1==x20, rd==x26, rs1_val == 524288, 
// opcode: slli ; op1:x20; dest:x26; op1val:0x80000;  immval:0x7
TEST_IMM_OP( slli, x26, x20, 0x4000000, 0x80000, 0x7, x5, 64, x7)

inst_28:
// rs1==x31, rd==x2, rs1_val == 1048576, 
// opcode: slli ; op1:x31; dest:x2; op1val:0x100000;  immval:0x12
TEST_IMM_OP( slli, x2, x31, 0x4000000000, 0x100000, 0x12, x5, 72, x7)

inst_29:
// rs1==x17, rd==x20, rs1_val == 2097152, 
// opcode: slli ; op1:x17; dest:x20; op1val:0x200000;  immval:0xc
TEST_IMM_OP( slli, x20, x17, 0x200000000, 0x200000, 0xc, x5, 80, x7)

inst_30:
// rs1==x0, rd==x27, rs1_val == 4194304, 
// opcode: slli ; op1:x0; dest:x27; op1val:0x0;  immval:0x1f
TEST_IMM_OP( slli, x27, x0, 0x0, 0x0, 0x1f, x5, 88, x7)

inst_31:
// rs1==x18, rd==x30, rs1_val == 8388608, 
// opcode: slli ; op1:x18; dest:x30; op1val:0x800000;  immval:0x9
TEST_IMM_OP( slli, x30, x18, 0x100000000, 0x800000, 0x9, x5, 96, x7)

inst_32:
// rs1_val == 16777216, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x1000000;  immval:0xe
TEST_IMM_OP( slli, x11, x10, 0x4000000000, 0x1000000, 0xe, x5, 104, x7)

inst_33:
// rs1_val == 33554432, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x2000000;  immval:0x7
TEST_IMM_OP( slli, x11, x10, 0x100000000, 0x2000000, 0x7, x5, 112, x7)

inst_34:
// rs1_val == 67108864, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x0
TEST_IMM_OP( slli, x11, x10, 0x4000000, 0x4000000, 0x0, x5, 120, x7)

inst_35:
// rs1_val == 134217728, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x3f
TEST_IMM_OP( slli, x11, x10, 0x0, 0x8000000, 0x3f, x5, 128, x7)

inst_36:
// rs1_val == 268435456, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x11
TEST_IMM_OP( slli, x11, x10, 0x200000000000, 0x10000000, 0x11, x5, 136, x7)

inst_37:
// rs1_val == 536870912, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x20000000;  immval:0xa
TEST_IMM_OP( slli, x11, x10, 0x8000000000, 0x20000000, 0xa, x5, 144, x7)

inst_38:
// rs1_val == 1073741824, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x40000000;  immval:0x11
TEST_IMM_OP( slli, x11, x10, 0x800000000000, 0x40000000, 0x11, x5, 152, x7)

inst_39:
// rs1_val == 2147483648, imm_val == 8
// opcode: slli ; op1:x10; dest:x11; op1val:0x80000000;  immval:0x8
TEST_IMM_OP( slli, x11, x10, 0x8000000000, 0x80000000, 0x8, x5, 160, x7)

inst_40:
// rs1_val == 4294967296, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x100000000;  immval:0xa
TEST_IMM_OP( slli, x11, x10, 0x40000000000, 0x100000000, 0xa, x5, 168, x7)

inst_41:
// rs1_val == 8589934592, imm_val == 21
// opcode: slli ; op1:x10; dest:x11; op1val:0x200000000;  immval:0x15
TEST_IMM_OP( slli, x11, x10, 0x40000000000000, 0x200000000, 0x15, x5, 176, x7)

inst_42:
// rs1_val == 17179869184, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x400000000;  immval:0x7
TEST_IMM_OP( slli, x11, x10, 0x20000000000, 0x400000000, 0x7, x5, 184, x7)

inst_43:
// rs1_val == 34359738368, imm_val == 55
// opcode: slli ; op1:x10; dest:x11; op1val:0x800000000;  immval:0x37
TEST_IMM_OP( slli, x11, x10, 0x0, 0x800000000, 0x37, x5, 192, x7)

inst_44:
// rs1_val == 68719476736, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x1000000000;  immval:0xf
TEST_IMM_OP( slli, x11, x10, 0x8000000000000, 0x1000000000, 0xf, x5, 200, x7)

inst_45:
// rs1_val == 137438953472, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x2000000000;  immval:0x15
TEST_IMM_OP( slli, x11, x10, 0x400000000000000, 0x2000000000, 0x15, x5, 208, x7)

inst_46:
// rs1_val == 274877906944, imm_val == 42
// opcode: slli ; op1:x10; dest:x11; op1val:0x4000000000;  immval:0x2a
TEST_IMM_OP( slli, x11, x10, 0x0, 0x4000000000, 0x2a, x5, 216, x7)

inst_47:
// rs1_val == 549755813888, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x3
TEST_IMM_OP( slli, x11, x10, 0x40000000000, 0x8000000000, 0x3, x5, 224, x7)

inst_48:
// rs1_val == 1099511627776, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x10000000000;  immval:0x3f
TEST_IMM_OP( slli, x11, x10, 0x0, 0x10000000000, 0x3f, x5, 232, x7)

inst_49:
// rs1_val == 2199023255552, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x20000000000;  immval:0x11
TEST_IMM_OP( slli, x11, x10, 0x400000000000000, 0x20000000000, 0x11, x5, 240, x7)

inst_50:
// rs1_val == 4398046511104, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x40000000000;  immval:0x7
TEST_IMM_OP( slli, x11, x10, 0x2000000000000, 0x40000000000, 0x7, x5, 248, x7)

inst_51:
// rs1_val == 8796093022208, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x13
TEST_IMM_OP( slli, x11, x10, 0x4000000000000000, 0x80000000000, 0x13, x5, 256, x7)

inst_52:
// rs1_val == 17592186044416, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x100000000000;  immval:0x2f
TEST_IMM_OP( slli, x11, x10, 0x0, 0x100000000000, 0x2f, x5, 264, x7)

inst_53:
// rs1_val == 35184372088832, imm_val == 62
// opcode: slli ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x3e
TEST_IMM_OP( slli, x11, x10, 0x0, 0x200000000000, 0x3e, x5, 272, x7)

inst_54:
// rs1_val == 70368744177664, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0x9
TEST_IMM_OP( slli, x11, x10, 0x80000000000000, 0x400000000000, 0x9, x5, 280, x7)

inst_55:
// rs1_val == 140737488355328, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x800000000000;  immval:0x15
TEST_IMM_OP( slli, x11, x10, 0x0, 0x800000000000, 0x15, x5, 288, x7)

inst_56:
// rs1_val == 281474976710656, imm_val == 1
// opcode: slli ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0x1
TEST_IMM_OP( slli, x11, x10, 0x2000000000000, 0x1000000000000, 0x1, x5, 296, x7)

inst_57:
// rs1_val == 562949953421312, imm_val == 4
// opcode: slli ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x4
TEST_IMM_OP( slli, x11, x10, 0x20000000000000, 0x2000000000000, 0x4, x5, 304, x7)

inst_58:
// rs1_val == 1125899906842624, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:0x1
TEST_IMM_OP( slli, x11, x10, 0x8000000000000, 0x4000000000000, 0x1, x5, 312, x7)

inst_59:
// rs1_val == 2251799813685248, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x8000000000000;  immval:0x6
TEST_IMM_OP( slli, x11, x10, 0x200000000000000, 0x8000000000000, 0x6, x5, 320, x7)

inst_60:
// rs1_val == 9007199254740992, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:0xc
TEST_IMM_OP( slli, x11, x10, 0x0, 0x20000000000000, 0xc, x5, 328, x7)

inst_61:
// rs1_val == 18014398509481984, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:0x3f
TEST_IMM_OP( slli, x11, x10, 0x0, 0x40000000000000, 0x3f, x5, 336, x7)

inst_62:
// rs1_val == 36028797018963968, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:0x2
TEST_IMM_OP( slli, x11, x10, 0x200000000000000, 0x80000000000000, 0x2, x5, 344, x7)

inst_63:
// rs1_val == 72057594037927936, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:0xf
TEST_IMM_OP( slli, x11, x10, 0x0, 0x100000000000000, 0xf, x5, 352, x7)

inst_64:
// rs1_val == 144115188075855872, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:0x5
TEST_IMM_OP( slli, x11, x10, 0x4000000000000000, 0x200000000000000, 0x5, x5, 360, x7)

inst_65:
// rs1_val == 288230376151711744, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0x2f
TEST_IMM_OP( slli, x11, x10, 0x0, 0x400000000000000, 0x2f, x5, 368, x7)

inst_66:
// rs1_val == 576460752303423488, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:0x13
TEST_IMM_OP( slli, x11, x10, 0x0, 0x800000000000000, 0x13, x5, 376, x7)

inst_67:
// rs1_val == 1152921504606846976, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:0x15
TEST_IMM_OP( slli, x11, x10, 0x0, 0x1000000000000000, 0x15, x5, 384, x7)

inst_68:
// rs1_val == 2305843009213693952, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x1
TEST_IMM_OP( slli, x11, x10, 0x4000000000000000, 0x2000000000000000, 0x1, x5, 392, x7)

inst_69:
// rs1_val == 4611686018427387904, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x4000000000000000;  immval:0x3b
TEST_IMM_OP( slli, x11, x10, 0x0, 0x4000000000000000, 0x3b, x5, 400, x7)

inst_70:
// rs1_val == -2, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x2;  immval:0x37
TEST_IMM_OP( slli, x11, x10, 0xff00000000000000, -0x2, 0x37, x5, 408, x7)

inst_71:
// rs1_val == -3, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x3;  immval:0x13
TEST_IMM_OP( slli, x11, x10, 0xffffffffffe80000, -0x3, 0x13, x5, 416, x7)

inst_72:
// rs1_val == -5, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x5;  immval:0x3b
TEST_IMM_OP( slli, x11, x10, 0xd800000000000000, -0x5, 0x3b, x5, 424, x7)

inst_73:
// rs1_val == -17, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x11;  immval:0x12
TEST_IMM_OP( slli, x11, x10, 0xffffffffffbc0000, -0x11, 0x12, x5, 432, x7)

inst_74:
// rs1_val == -33, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x21;  immval:0x3f
TEST_IMM_OP( slli, x11, x10, 0x8000000000000000, -0x21, 0x3f, x5, 440, x7)

inst_75:
// rs1_val == -65, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x41;  immval:0x13
TEST_IMM_OP( slli, x11, x10, 0xfffffffffdf80000, -0x41, 0x13, x5, 448, x7)

inst_76:
// rs1_val == -129, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x81;  immval:0x3b
TEST_IMM_OP( slli, x11, x10, 0xf800000000000000, -0x81, 0x3b, x5, 456, x7)

inst_77:
// rs1_val == -513, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x201;  immval:0x12
TEST_IMM_OP( slli, x11, x10, 0xfffffffff7fc0000, -0x201, 0x12, x5, 464, x7)

inst_78:
// rs1_val == -1025, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x401;  immval:0x3e
TEST_IMM_OP( slli, x11, x10, 0xc000000000000000, -0x401, 0x3e, x5, 472, x7)

inst_79:
// rs1_val == -2049, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x801;  immval:0x1
TEST_IMM_OP( slli, x11, x10, 0xffffffffffffeffe, -0x801, 0x1, x5, 480, x7)

inst_80:
// rs1_val == -4097, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x1001;  immval:0x1f
TEST_IMM_OP( slli, x11, x10, 0xfffff7ff80000000, -0x1001, 0x1f, x5, 488, x7)

inst_81:
// rs1_val == -8193, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x2001;  immval:0x2
TEST_IMM_OP( slli, x11, x10, 0xffffffffffff7ffc, -0x2001, 0x2, x5, 496, x7)

inst_82:
// rs1_val == -16385, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x4001;  immval:0xc
TEST_IMM_OP( slli, x11, x10, 0xfffffffffbfff000, -0x4001, 0xc, x5, 504, x7)

inst_83:
// rs1_val == -32769, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x8001;  immval:0xd
TEST_IMM_OP( slli, x11, x10, 0xffffffffefffe000, -0x8001, 0xd, x5, 512, x7)

inst_84:
// rs1_val == -65537, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x10001;  immval:0x2
TEST_IMM_OP( slli, x11, x10, 0xfffffffffffbfffc, -0x10001, 0x2, x5, 520, x7)

inst_85:
// rs1_val == -131073, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x20001;  immval:0x3d
TEST_IMM_OP( slli, x11, x10, 0xe000000000000000, -0x20001, 0x3d, x5, 528, x7)

inst_86:
// rs1_val == -262145, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x3f
TEST_IMM_OP( slli, x11, x10, 0x8000000000000000, -0x40001, 0x3f, x5, 536, x7)

inst_87:
// rs1_val == -524289, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x80001;  immval:0xc
TEST_IMM_OP( slli, x11, x10, 0xffffffff7ffff000, -0x80001, 0xc, x5, 544, x7)

inst_88:
// rs1_val == -1048577, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x100001;  immval:0xe
TEST_IMM_OP( slli, x11, x10, 0xfffffffbffffc000, -0x100001, 0xe, x5, 552, x7)

inst_89:
// rs1_val == -2097153, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x200001;  immval:0x3f
TEST_IMM_OP( slli, x11, x10, 0x8000000000000000, -0x200001, 0x3f, x5, 560, x7)

inst_90:
// rs1_val == -9007199254740993, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x20000000000001;  immval:0xf
TEST_IMM_OP( slli, x11, x10, 0xffffffffffff8000, -0x20000000000001, 0xf, x5, 568, x7)

inst_91:
// rs1_val == -18014398509481985, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x40000000000001;  immval:0x3e
TEST_IMM_OP( slli, x11, x10, 0xc000000000000000, -0x40000000000001, 0x3e, x5, 576, x7)

inst_92:
// rs1_val == -36028797018963969, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x80000000000001;  immval:0x3
TEST_IMM_OP( slli, x11, x10, 0xfbfffffffffffff8, -0x80000000000001, 0x3, x5, 584, x7)

inst_93:
// rs1_val == -72057594037927937, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:0xc
TEST_IMM_OP( slli, x11, x10, 0xfffffffffffff000, -0x100000000000001, 0xc, x5, 592, x7)

inst_94:
// rs1_val == -144115188075855873, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:0x0
TEST_IMM_OP( slli, x11, x10, 0xfdffffffffffffff, -0x200000000000001, 0x0, x5, 600, x7)

inst_95:
// rs1_val == -288230376151711745, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x400000000000001;  immval:0x3
TEST_IMM_OP( slli, x11, x10, 0xdffffffffffffff8, -0x400000000000001, 0x3, x5, 608, x7)

inst_96:
// rs1_val == -576460752303423489, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:0x2
TEST_IMM_OP( slli, x11, x10, 0xdffffffffffffffc, -0x800000000000001, 0x2, x5, 616, x7)

inst_97:
// rs1_val == -1152921504606846977, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:0x4
TEST_IMM_OP( slli, x11, x10, 0xfffffffffffffff0, -0x1000000000000001, 0x4, x5, 624, x7)

inst_98:
// rs1_val == -2305843009213693953, imm_val == 16
// opcode: slli ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:0x10
TEST_IMM_OP( slli, x11, x10, 0xffffffffffff0000, -0x2000000000000001, 0x10, x5, 632, x7)

inst_99:
// rs1_val == -4611686018427387905, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:0x3e
TEST_IMM_OP( slli, x11, x10, 0xc000000000000000, -0x4000000000000001, 0x3e, x5, 640, x7)

inst_100:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode: slli ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2
TEST_IMM_OP( slli, x11, x10, 0x5555555555555554, 0x5555555555555555, 0x2, x5, 648, x7)

inst_101:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode: slli ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2
TEST_IMM_OP( slli, x11, x10, 0xaaaaaaaaaaaaaaa8, -0x5555555555555556, 0x2, x5, 656, x7)

inst_102:
// rs1_val==3, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x3;  immval:0x10
TEST_IMM_OP( slli, x11, x10, 0x30000, 0x3, 0x10, x5, 664, x7)

inst_103:
// rs1_val==5, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x5;  immval:0x3b
TEST_IMM_OP( slli, x11, x10, 0x2800000000000000, 0x5, 0x3b, x5, 672, x7)

inst_104:
// rs1_val==3689348814741910323, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2a
TEST_IMM_OP( slli, x11, x10, 0xcccccc0000000000, 0x3333333333333333, 0x2a, x5, 680, x7)

inst_105:
// rs1_val==7378697629483820646, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0xa
TEST_IMM_OP( slli, x11, x10, 0x9999999999999800, 0x6666666666666666, 0xa, x5, 688, x7)

inst_106:
// rs1_val==-3037000499, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x3b
TEST_IMM_OP( slli, x11, x10, 0x6800000000000000, -0xb504f333, 0x3b, x5, 696, x7)

inst_107:
// rs1_val==3037000499, 
// opcode: slli ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x9
TEST_IMM_OP( slli, x11, x10, 0x16a09e66600, 0xb504f333, 0x9, x5, 704, x7)

inst_108:
// rs1_val==6148914691236517204, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x10
TEST_IMM_OP( slli, x11, x10, 0x5555555555540000, 0x5555555555555554, 0x10, x5, 712, x7)

inst_109:
// rs1_val==3689348814741910322, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x37
TEST_IMM_OP( slli, x11, x10, 0x9900000000000000, 0x3333333333333332, 0x37, x5, 720, x7)

inst_110:
// rs1_val==7378697629483820645, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3e
TEST_IMM_OP( slli, x11, x10, 0x4000000000000000, 0x6666666666666665, 0x3e, x5, 728, x7)

inst_111:
// rs1_val==3037000498, 
// opcode: slli ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x13
TEST_IMM_OP( slli, x11, x10, 0x5a82799900000, 0xb504f332, 0x13, x5, 736, x7)

inst_112:
// rs1_val==6148914691236517206, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x12
TEST_IMM_OP( slli, x11, x10, 0x5555555555580000, 0x5555555555555556, 0x12, x5, 744, x7)

inst_113:
// rs1_val==-6148914691236517205, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0xf
TEST_IMM_OP( slli, x11, x10, 0x5555555555558000, -0x5555555555555555, 0xf, x5, 752, x7)

inst_114:
// rs1_val==6, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x6;  immval:0x7
TEST_IMM_OP( slli, x11, x10, 0x300, 0x6, 0x7, x5, 760, x7)

inst_115:
// rs1_val==3689348814741910324, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x7
TEST_IMM_OP( slli, x11, x10, 0x9999999999999a00, 0x3333333333333334, 0x7, x5, 768, x7)

inst_116:
// rs1_val==7378697629483820647, imm_val == 32
// opcode: slli ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x20
TEST_IMM_OP( slli, x11, x10, 0x6666666700000000, 0x6666666666666667, 0x20, x5, 776, x7)

inst_117:
// rs1_val==-3037000498, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x8
TEST_IMM_OP( slli, x11, x10, 0xffffff4afb0cce00, -0xb504f332, 0x8, x5, 784, x7)

inst_118:
// rs1_val == -4194305, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x6
TEST_IMM_OP( slli, x11, x10, 0xffffffffefffffc0, -0x400001, 0x6, x5, 792, x7)

inst_119:
// rs1_val==3037000500, 
// opcode: slli ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3e
TEST_IMM_OP( slli, x11, x10, 0x0, 0xb504f334, 0x3e, x5, 800, x7)

inst_120:
// rs1_val == -8388609, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x800001;  immval:0x37
TEST_IMM_OP( slli, x11, x10, 0xff80000000000000, -0x800001, 0x37, x5, 808, x7)

inst_121:
// rs1_val == -16777217, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x1000001;  immval:0x2a
TEST_IMM_OP( slli, x11, x10, 0xfffffc0000000000, -0x1000001, 0x2a, x5, 816, x7)

inst_122:
// rs1_val == -33554433, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x2000001;  immval:0x11
TEST_IMM_OP( slli, x11, x10, 0xfffffbfffffe0000, -0x2000001, 0x11, x5, 824, x7)

inst_123:
// rs1_val == -67108865, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x8
TEST_IMM_OP( slli, x11, x10, 0xfffffffbffffff00, -0x4000001, 0x8, x5, 832, x7)

inst_124:
// rs1_val == -134217729, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0x0
TEST_IMM_OP( slli, x11, x10, 0xfffffffff7ffffff, -0x8000001, 0x0, x5, 840, x7)

inst_125:
// rs1_val == -268435457, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0xb
TEST_IMM_OP( slli, x11, x10, 0xffffff7ffffff800, -0x10000001, 0xb, x5, 848, x7)

inst_126:
// rs1_val == -1073741825, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x9
TEST_IMM_OP( slli, x11, x10, 0xffffff7ffffffe00, -0x40000001, 0x9, x5, 856, x7)

inst_127:
// rs1_val == -2147483649, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x80000001;  immval:0x2
TEST_IMM_OP( slli, x11, x10, 0xfffffffdfffffffc, -0x80000001, 0x2, x5, 864, x7)

inst_128:
// rs1_val == -4294967297, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x100000001;  immval:0x37
TEST_IMM_OP( slli, x11, x10, 0xff80000000000000, -0x100000001, 0x37, x5, 872, x7)

inst_129:
// rs1_val == -8589934593, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x200000001;  immval:0x7
TEST_IMM_OP( slli, x11, x10, 0xfffffeffffffff80, -0x200000001, 0x7, x5, 880, x7)

inst_130:
// rs1_val == -17179869185, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x400000001;  immval:0x4
TEST_IMM_OP( slli, x11, x10, 0xffffffbffffffff0, -0x400000001, 0x4, x5, 888, x7)

inst_131:
// rs1_val == -34359738369, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x800000001;  immval:0x3
TEST_IMM_OP( slli, x11, x10, 0xffffffbffffffff8, -0x800000001, 0x3, x5, 896, x7)

inst_132:
// rs1_val == -68719476737, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x1000000001;  immval:0x3e
TEST_IMM_OP( slli, x11, x10, 0xc000000000000000, -0x1000000001, 0x3e, x5, 904, x7)

inst_133:
// rs1_val == -137438953473, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x2000000001;  immval:0xd
TEST_IMM_OP( slli, x11, x10, 0xfffbffffffffe000, -0x2000000001, 0xd, x5, 912, x7)

inst_134:
// rs1_val == -274877906945, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:0x6
TEST_IMM_OP( slli, x11, x10, 0xffffefffffffffc0, -0x4000000001, 0x6, x5, 920, x7)

inst_135:
// rs1_val == -549755813889, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:0x2a
TEST_IMM_OP( slli, x11, x10, 0xfffffc0000000000, -0x8000000001, 0x2a, x5, 928, x7)

inst_136:
// rs1_val == -1099511627777, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:0x7
TEST_IMM_OP( slli, x11, x10, 0xffff7fffffffff80, -0x10000000001, 0x7, x5, 936, x7)

inst_137:
// rs1_val == -2199023255553, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x20000000001;  immval:0x3f
TEST_IMM_OP( slli, x11, x10, 0x8000000000000000, -0x20000000001, 0x3f, x5, 944, x7)

inst_138:
// rs1_val == -4398046511105, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x40000000001;  immval:0x3d
TEST_IMM_OP( slli, x11, x10, 0xe000000000000000, -0x40000000001, 0x3d, x5, 952, x7)

inst_139:
// rs1_val == -8796093022209, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x80000000001;  immval:0x3b
TEST_IMM_OP( slli, x11, x10, 0xf800000000000000, -0x80000000001, 0x3b, x5, 960, x7)

inst_140:
// rs1_val == -17592186044417, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:0x3
TEST_IMM_OP( slli, x11, x10, 0xffff7ffffffffff8, -0x100000000001, 0x3, x5, 968, x7)

inst_141:
// rs1_val == -35184372088833, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:0x12
TEST_IMM_OP( slli, x11, x10, 0x7ffffffffffc0000, -0x200000000001, 0x12, x5, 976, x7)

inst_142:
// rs1_val == -70368744177665, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x400000000001;  immval:0x13
TEST_IMM_OP( slli, x11, x10, 0xfffffffffff80000, -0x400000000001, 0x13, x5, 984, x7)

inst_143:
// rs1_val == -140737488355329, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:0x10
TEST_IMM_OP( slli, x11, x10, 0x7fffffffffff0000, -0x800000000001, 0x10, x5, 992, x7)

inst_144:
// rs1_val == -281474976710657, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x1000000000001;  immval:0x5
TEST_IMM_OP( slli, x11, x10, 0xffdfffffffffffe0, -0x1000000000001, 0x5, x5, 1000, x7)

inst_145:
// rs1_val == -562949953421313, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x2000000000001;  immval:0x3b
TEST_IMM_OP( slli, x11, x10, 0xf800000000000000, -0x2000000000001, 0x3b, x5, 1008, x7)

inst_146:
// rs1_val == -1125899906842625, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:0x6
TEST_IMM_OP( slli, x11, x10, 0xfeffffffffffffc0, -0x4000000000001, 0x6, x5, 1016, x7)

inst_147:
// rs1_val == -2251799813685249, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x8000000000001;  immval:0xd
TEST_IMM_OP( slli, x11, x10, 0xffffffffffffe000, -0x8000000000001, 0xd, x5, 1024, x7)

inst_148:
// rs1_val == -4503599627370497, 
// opcode: slli ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:0x2
TEST_IMM_OP( slli, x11, x10, 0xffbffffffffffffc, -0x10000000000001, 0x2, x5, 1032, x7)

inst_149:
// rs1_val == 16, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x10;  immval:0xe
TEST_IMM_OP( slli, x11, x10, 0x40000, 0x10, 0xe, x5, 1040, x7)

inst_150:
// rs1_val == 4194304, 
// opcode: slli ; op1:x10; dest:x11; op1val:0x400000;  immval:0x1f
TEST_IMM_OP( slli, x11, x10, 0x20000000000000, 0x400000, 0x1f, x5, 1048, x7)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x3_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x3_1:
    .fill 19*(XLEN/32),4,0xdeadbeef


signature_x5_0:
    .fill 132*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
