
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the sllw instruction of the RISC-V i extension for the sllw covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64i")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*RV64.*I.*);def TEST_CASE_1=True;",sllw)

RVTEST_SIGBASE( x4,signature_x4_1)

inst_0:
// rs1 == rs2 != rd, rs1==x7, rs2==x7, rd==x14, rs1_val < 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == -140737488355329, rs2_val == 15
// opcode: sllw ; op1:x7; op2:x7; dest:x14; op1val:-0x800000000001;  op2val:-0x800000000001
TEST_RR_OP(sllw, x14, x7, x7, -0x80000000, -0x800000000001, -0x800000000001, x4, 0, x13)

inst_1:
// rs2 == rd != rs1, rs1==x27, rs2==x30, rd==x30, rs1_val > 0 and rs2_val > 0 and rs2_val < xlen, rs2_val == 23, rs1_val == 288230376151711744
// opcode: sllw ; op1:x27; op2:x30; dest:x30; op1val:0x400000000000000;  op2val:0x17
TEST_RR_OP(sllw, x30, x27, x30, 0x0, 0x400000000000000, 0x17, x4, 8, x13)

inst_2:
// rs1 == rs2 == rd, rs1==x5, rs2==x5, rd==x5, rs1_val < 0 and rs2_val == 0, 
// opcode: sllw ; op1:x5; op2:x5; dest:x5; op1val:-0x6;  op2val:-0x6
TEST_RR_OP(sllw, x5, x5, x5, -0x18000000, -0x6, -0x6, x4, 16, x13)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x18, rs2==x15, rd==x22, rs1_val > 0 and rs2_val == 0, rs1_val == 268435456
// opcode: sllw ; op1:x18; op2:x15; dest:x22; op1val:0x10000000;  op2val:0x0
TEST_RR_OP(sllw, x22, x18, x15, 0x10000000, 0x10000000, 0x0, x4, 24, x13)

inst_4:
// rs1 == rd != rs2, rs1==x26, rs2==x22, rd==x26, rs1_val == rs2_val and rs2_val > 0 and rs2_val < xlen, rs1_val==5
// opcode: sllw ; op1:x26; op2:x22; dest:x26; op1val:0x5;  op2val:0x5
TEST_RR_OP(sllw, x26, x26, x22, 0xa0, 0x5, 0x5, x4, 32, x13)

inst_5:
// rs1==x14, rs2==x23, rd==x29, rs1_val == (-2**(xlen-1)) and rs2_val >= 0 and rs2_val < xlen, rs1_val == -9223372036854775808, rs2_val == 2
// opcode: sllw ; op1:x14; op2:x23; dest:x29; op1val:-0x8000000000000000;  op2val:0x2
TEST_RR_OP(sllw, x29, x14, x23, 0x0, -0x8000000000000000, 0x2, x4, 40, x13)

inst_6:
// rs1==x12, rs2==x14, rd==x9, rs1_val == 0 and rs2_val >= 0 and rs2_val < xlen, rs1_val==0
// opcode: sllw ; op1:x12; op2:x14; dest:x9; op1val:0x0;  op2val:0x11
TEST_RR_OP(sllw, x9, x12, x14, 0x0, 0x0, 0x11, x4, 48, x13)

inst_7:
// rs1==x10, rs2==x0, rd==x1, rs1_val == (2**(xlen-1)-1) and rs2_val >= 0 and rs2_val < xlen, rs1_val == 9223372036854775807
// opcode: sllw ; op1:x10; op2:x0; dest:x1; op1val:0x7fffffffffffffff;  op2val:0x0
TEST_RR_OP(sllw, x1, x10, x0, -0x1, 0x7fffffffffffffff, 0x0, x4, 56, x13)

inst_8:
// rs1==x31, rs2==x8, rd==x19, rs1_val == 1 and rs2_val >= 0 and rs2_val < xlen, rs1_val == 1, rs2_val == 21
// opcode: sllw ; op1:x31; op2:x8; dest:x19; op1val:0x1;  op2val:0x15
TEST_RR_OP(sllw, x19, x31, x8, 0x200000, 0x1, 0x15, x4, 64, x13)

inst_9:
// rs1==x23, rs2==x27, rd==x17, rs1_val == 2, rs1_val==2
// opcode: sllw ; op1:x23; op2:x27; dest:x17; op1val:0x2;  op2val:0x17
TEST_RR_OP(sllw, x17, x23, x27, 0x1000000, 0x2, 0x17, x4, 72, x13)

inst_10:
// rs1==x17, rs2==x26, rd==x25, rs1_val == 4, rs2_val == 8, rs1_val==4
// opcode: sllw ; op1:x17; op2:x26; dest:x25; op1val:0x4;  op2val:0x8
TEST_RR_OP(sllw, x25, x17, x26, 0x400, 0x4, 0x8, x4, 80, x13)

inst_11:
// rs1==x11, rs2==x12, rd==x16, rs1_val == 8, 
// opcode: sllw ; op1:x11; op2:x12; dest:x16; op1val:0x8;  op2val:0x0
TEST_RR_OP(sllw, x16, x11, x12, 0x8, 0x8, 0x0, x4, 88, x13)

inst_12:
// rs1==x24, rs2==x3, rd==x27, rs1_val == 16, 
// opcode: sllw ; op1:x24; op2:x3; dest:x27; op1val:0x10;  op2val:0x0
TEST_RR_OP(sllw, x27, x24, x3, 0x10, 0x10, 0x0, x4, 96, x13)

inst_13:
// rs1==x16, rs2==x10, rd==x7, rs1_val == 32, 
// opcode: sllw ; op1:x16; op2:x10; dest:x7; op1val:0x20;  op2val:0x2
TEST_RR_OP(sllw, x7, x16, x10, 0x80, 0x20, 0x2, x4, 104, x13)

inst_14:
// rs1==x2, rs2==x1, rd==x0, rs1_val == 64, 
// opcode: sllw ; op1:x2; op2:x1; dest:x0; op1val:0x40;  op2val:0x11
TEST_RR_OP(sllw, x0, x2, x1, 0, 0x40, 0x11, x4, 112, x13)

inst_15:
// rs1==x28, rs2==x21, rd==x6, rs1_val == 128, 
// opcode: sllw ; op1:x28; op2:x21; dest:x6; op1val:0x80;  op2val:0x0
TEST_RR_OP(sllw, x6, x28, x21, 0x80, 0x80, 0x0, x4, 120, x13)
RVTEST_SIGBASE( x5,signature_x5_0)

inst_16:
// rs1==x8, rs2==x17, rd==x13, rs1_val == 256, 
// opcode: sllw ; op1:x8; op2:x17; dest:x13; op1val:0x100;  op2val:0x6
TEST_RR_OP(sllw, x13, x8, x17, 0x4000, 0x100, 0x6, x5, 0, x7)

inst_17:
// rs1==x21, rs2==x13, rd==x20, rs1_val == 512, 
// opcode: sllw ; op1:x21; op2:x13; dest:x20; op1val:0x200;  op2val:0x3
TEST_RR_OP(sllw, x20, x21, x13, 0x1000, 0x200, 0x3, x5, 8, x7)

inst_18:
// rs1==x25, rs2==x28, rd==x18, rs1_val == 1024, 
// opcode: sllw ; op1:x25; op2:x28; dest:x18; op1val:0x400;  op2val:0x8
TEST_RR_OP(sllw, x18, x25, x28, 0x40000, 0x400, 0x8, x5, 16, x7)

inst_19:
// rs1==x15, rs2==x11, rd==x2, rs1_val == 2048, rs2_val == 1
// opcode: sllw ; op1:x15; op2:x11; dest:x2; op1val:0x800;  op2val:0x1
TEST_RR_OP(sllw, x2, x15, x11, 0x1000, 0x800, 0x1, x5, 24, x7)

inst_20:
// rs1==x19, rs2==x9, rd==x28, rs1_val == 4096, 
// opcode: sllw ; op1:x19; op2:x9; dest:x28; op1val:0x1000;  op2val:0x9
TEST_RR_OP(sllw, x28, x19, x9, 0x200000, 0x1000, 0x9, x5, 32, x7)

inst_21:
// rs1==x6, rs2==x20, rd==x31, rs1_val == 8192, 
// opcode: sllw ; op1:x6; op2:x20; dest:x31; op1val:0x2000;  op2val:0x12
TEST_RR_OP(sllw, x31, x6, x20, -0x80000000, 0x2000, 0x12, x5, 40, x7)

inst_22:
// rs1==x1, rs2==x16, rd==x3, rs1_val == 16384, 
// opcode: sllw ; op1:x1; op2:x16; dest:x3; op1val:0x4000;  op2val:0x8
TEST_RR_OP(sllw, x3, x1, x16, 0x400000, 0x4000, 0x8, x5, 48, x7)

inst_23:
// rs1==x13, rs2==x29, rd==x11, rs1_val == 32768, 
// opcode: sllw ; op1:x13; op2:x29; dest:x11; op1val:0x8000;  op2val:0xd
TEST_RR_OP(sllw, x11, x13, x29, 0x10000000, 0x8000, 0xd, x5, 56, x7)

inst_24:
// rs1==x22, rs2==x2, rd==x10, rs1_val == 65536, 
// opcode: sllw ; op1:x22; op2:x2; dest:x10; op1val:0x10000;  op2val:0x0
TEST_RR_OP(sllw, x10, x22, x2, 0x10000, 0x10000, 0x0, x5, 64, x7)

inst_25:
// rs1==x3, rs2==x19, rd==x4, rs1_val == 131072, rs2_val == 10
// opcode: sllw ; op1:x3; op2:x19; dest:x4; op1val:0x20000;  op2val:0xa
TEST_RR_OP(sllw, x4, x3, x19, 0x8000000, 0x20000, 0xa, x5, 72, x7)

inst_26:
// rs1==x20, rs2==x6, rd==x8, rs1_val == 262144, 
// opcode: sllw ; op1:x20; op2:x6; dest:x8; op1val:0x40000;  op2val:0x5
TEST_RR_OP(sllw, x8, x20, x6, 0x800000, 0x40000, 0x5, x5, 80, x7)

inst_27:
// rs1==x9, rs2==x31, rd==x12, rs1_val == 524288, rs2_val == 27
// opcode: sllw ; op1:x9; op2:x31; dest:x12; op1val:0x80000;  op2val:0x1b
TEST_RR_OP(sllw, x12, x9, x31, 0x0, 0x80000, 0x1b, x5, 88, x7)

inst_28:
// rs1==x30, rs2==x4, rd==x24, rs1_val == 1048576, rs2_val == 4
// opcode: sllw ; op1:x30; op2:x4; dest:x24; op1val:0x100000;  op2val:0x4
TEST_RR_OP(sllw, x24, x30, x4, 0x1000000, 0x100000, 0x4, x5, 96, x7)

inst_29:
// rs1==x29, rs2==x25, rd==x23, rs1_val == 2097152, 
// opcode: sllw ; op1:x29; op2:x25; dest:x23; op1val:0x200000;  op2val:0x8
TEST_RR_OP(sllw, x23, x29, x25, 0x20000000, 0x200000, 0x8, x5, 104, x7)

inst_30:
// rs1==x0, rs2==x24, rd==x21, rs1_val == 4194304, 
// opcode: sllw ; op1:x0; op2:x24; dest:x21; op1val:0x0;  op2val:0x6
TEST_RR_OP(sllw, x21, x0, x24, 0x0, 0x0, 0x6, x5, 112, x7)

inst_31:
// rs1==x4, rs2==x18, rd==x15, rs1_val == 8388608, 
// opcode: sllw ; op1:x4; op2:x18; dest:x15; op1val:0x800000;  op2val:0x15
TEST_RR_OP(sllw, x15, x4, x18, 0x0, 0x800000, 0x15, x5, 120, x7)

inst_32:
// rs1_val == 16777216, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0xb
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x1000000, 0xb, x5, 128, x7)

inst_33:
// rs1_val == 33554432, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0x15
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x2000000, 0x15, x5, 136, x7)

inst_34:
// rs1_val == 67108864, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x12
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x4000000, 0x12, x5, 144, x7)

inst_35:
// rs1_val == 134217728, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0xe
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x8000000, 0xe, x5, 152, x7)

inst_36:
// rs1_val == 536870912, rs2_val == 29
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x1d
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x20000000, 0x1d, x5, 160, x7)

inst_37:
// rs1_val == 1073741824, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0xe
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x40000000, 0xe, x5, 168, x7)

inst_38:
// rs1_val == 2147483648, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0x12
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x80000000, 0x12, x5, 176, x7)

inst_39:
// rs1_val == 4294967296, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x13
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x100000000, 0x13, x5, 184, x7)

inst_40:
// rs1_val == 8589934592, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:0x1f
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x200000000, 0x1f, x5, 192, x7)

inst_41:
// rs1_val == 17179869184, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:0x1b
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x400000000, 0x1b, x5, 200, x7)

inst_42:
// rs1_val == 34359738368, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x17
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x800000000, 0x17, x5, 208, x7)

inst_43:
// rs1_val == 68719476736, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0x9
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x1000000000, 0x9, x5, 216, x7)

inst_44:
// rs1_val == 137438953472, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:0x1
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x2000000000, 0x1, x5, 224, x7)

inst_45:
// rs1_val == 274877906944, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:0x0
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x4000000000, 0x0, x5, 232, x7)

inst_46:
// rs1_val == 549755813888, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0x8
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x8000000000, 0x8, x5, 240, x7)

inst_47:
// rs1_val == 1099511627776, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0x8
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x10000000000, 0x8, x5, 248, x7)

inst_48:
// rs1_val == 2199023255552, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:0x0
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x20000000000, 0x0, x5, 256, x7)

inst_49:
// rs1_val == 4398046511104, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0xb
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x40000000000, 0xb, x5, 264, x7)

inst_50:
// rs1_val == 8796093022208, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x4
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x80000000000, 0x4, x5, 272, x7)

inst_51:
// rs1_val == 17592186044416, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0x6
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x100000000000, 0x6, x5, 280, x7)

inst_52:
// rs1_val == 35184372088832, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0xc
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x200000000000, 0xc, x5, 288, x7)

inst_53:
// rs1_val == 70368744177664, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x400000000000, 0xd, x5, 296, x7)

inst_54:
// rs1_val == 140737488355328, rs2_val == 30
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:0x1e
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x800000000000, 0x1e, x5, 304, x7)

inst_55:
// rs1_val == 281474976710656, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:0x1
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x1000000000000, 0x1, x5, 312, x7)

inst_56:
// rs1_val == 562949953421312, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0xe
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x2000000000000, 0xe, x5, 320, x7)

inst_57:
// rs1_val == 1125899906842624, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:0x15
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x4000000000000, 0x15, x5, 328, x7)

inst_58:
// rs1_val == 2251799813685248, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:0xb
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x8000000000000, 0xb, x5, 336, x7)

inst_59:
// rs1_val == 4503599627370496, rs2_val == 16
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0x10
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x10000000000000, 0x10, x5, 344, x7)

inst_60:
// rs1_val == 9007199254740992, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:0x13
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x20000000000000, 0x13, x5, 352, x7)

inst_61:
// rs1_val == 18014398509481984, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0x11
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x40000000000000, 0x11, x5, 360, x7)

inst_62:
// rs1_val == 36028797018963968, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:0x8
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x80000000000000, 0x8, x5, 368, x7)

inst_63:
// rs1_val == 72057594037927936, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0x11
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x100000000000000, 0x11, x5, 376, x7)

inst_64:
// rs1_val == 144115188075855872, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:0x1
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x200000000000000, 0x1, x5, 384, x7)

inst_65:
// rs1_val == 576460752303423488, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0x6
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x800000000000000, 0x6, x5, 392, x7)

inst_66:
// rs1_val == 1152921504606846976, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0x13
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x1000000000000000, 0x13, x5, 400, x7)

inst_67:
// rs1_val == 2305843009213693952, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:0xa
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x2000000000000000, 0xa, x5, 408, x7)

inst_68:
// rs1_val == 4611686018427387904, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:0x1f
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x4000000000000000, 0x1f, x5, 416, x7)

inst_69:
// rs1_val == -2, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, -0x4000, -0x2, 0xd, x5, 424, x7)

inst_70:
// rs1_val == -3, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, -0x6000, -0x3, 0xd, x5, 432, x7)

inst_71:
// rs1_val == -5, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, -0xa000, -0x5, 0xd, x5, 440, x7)

inst_72:
// rs1_val == -9, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:0x3
TEST_RR_OP(sllw, x12, x10, x11, -0x48, -0x9, 0x3, x5, 448, x7)

inst_73:
// rs1_val == -17, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:0x4
TEST_RR_OP(sllw, x12, x10, x11, -0x110, -0x11, 0x4, x5, 456, x7)

inst_74:
// rs1_val == -33, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x7
TEST_RR_OP(sllw, x12, x10, x11, -0x1080, -0x21, 0x7, x5, 464, x7)

inst_75:
// rs1_val == -65, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:0x7
TEST_RR_OP(sllw, x12, x10, x11, -0x2080, -0x41, 0x7, x5, 472, x7)

inst_76:
// rs1_val == -129, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0x12
TEST_RR_OP(sllw, x12, x10, x11, -0x2040000, -0x81, 0x12, x5, 480, x7)

inst_77:
// rs1_val == -257, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:0x8
TEST_RR_OP(sllw, x12, x10, x11, -0x10100, -0x101, 0x8, x5, 488, x7)

inst_78:
// rs1_val == -513, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:0x6
TEST_RR_OP(sllw, x12, x10, x11, -0x8040, -0x201, 0x6, x5, 496, x7)

inst_79:
// rs1_val == -1025, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0x2
TEST_RR_OP(sllw, x12, x10, x11, -0x1004, -0x401, 0x2, x5, 504, x7)

inst_80:
// rs1_val == -2049, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:0x1e
TEST_RR_OP(sllw, x12, x10, x11, -0x40000000, -0x801, 0x1e, x5, 512, x7)

inst_81:
// rs1_val == -4097, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:0x5
TEST_RR_OP(sllw, x12, x10, x11, -0x20020, -0x1001, 0x5, x5, 520, x7)

inst_82:
// rs1_val == -8193, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x5
TEST_RR_OP(sllw, x12, x10, x11, -0x40020, -0x2001, 0x5, x5, 528, x7)

inst_83:
// rs1_val == -16385, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:0x7
TEST_RR_OP(sllw, x12, x10, x11, -0x200080, -0x4001, 0x7, x5, 536, x7)

inst_84:
// rs1_val == -32769, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:0x13
TEST_RR_OP(sllw, x12, x10, x11, -0x80000, -0x8001, 0x13, x5, 544, x7)

inst_85:
// rs1_val == -65537, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:0x11
TEST_RR_OP(sllw, x12, x10, x11, -0x20000, -0x10001, 0x11, x5, 552, x7)

inst_86:
// rs1_val == -131073, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:0x1d
TEST_RR_OP(sllw, x12, x10, x11, -0x20000000, -0x20001, 0x1d, x5, 560, x7)

inst_87:
// rs1_val == -262145, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0x8
TEST_RR_OP(sllw, x12, x10, x11, -0x4000100, -0x40001, 0x8, x5, 568, x7)

inst_88:
// rs1_val == -36028797018963969, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:0x6
TEST_RR_OP(sllw, x12, x10, x11, -0x40, -0x80000000000001, 0x6, x5, 576, x7)

inst_89:
// rs1_val == -72057594037927937, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000000001;  op2val:0x17
TEST_RR_OP(sllw, x12, x10, x11, -0x800000, -0x100000000000001, 0x17, x5, 584, x7)

inst_90:
// rs1_val == -144115188075855873, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:0x1b
TEST_RR_OP(sllw, x12, x10, x11, -0x8000000, -0x200000000000001, 0x1b, x5, 592, x7)

inst_91:
// rs1_val == -288230376151711745, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:0x7
TEST_RR_OP(sllw, x12, x10, x11, -0x80, -0x400000000000001, 0x7, x5, 600, x7)

inst_92:
// rs1_val == -576460752303423489, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, -0x2000, -0x800000000000001, 0xd, x5, 608, x7)

inst_93:
// rs1_val == -1152921504606846977, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:0x1d
TEST_RR_OP(sllw, x12, x10, x11, -0x20000000, -0x1000000000000001, 0x1d, x5, 616, x7)

inst_94:
// rs1_val == -2305843009213693953, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000000001;  op2val:0x1f
TEST_RR_OP(sllw, x12, x10, x11, -0x80000000, -0x2000000000000001, 0x1f, x5, 624, x7)

inst_95:
// rs1_val == -4611686018427387905, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:0x13
TEST_RR_OP(sllw, x12, x10, x11, -0x80000, -0x4000000000000001, 0x13, x5, 632, x7)

inst_96:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(sllw, x12, x10, x11, 0x55555554, 0x5555555555555555, 0x2, x5, 640, x7)

inst_97:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xf
TEST_RR_OP(sllw, x12, x10, x11, 0x55550000, -0x5555555555555556, 0xf, x5, 648, x7)

inst_98:
// rs1_val==3, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x17
TEST_RR_OP(sllw, x12, x10, x11, 0x1800000, 0x3, 0x17, x5, 656, x7)

inst_99:
// rs1_val==3689348814741910323, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x13
TEST_RR_OP(sllw, x12, x10, x11, -0x66680000, 0x3333333333333333, 0x13, x5, 664, x7)

inst_100:
// rs1_val==7378697629483820646, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x11
TEST_RR_OP(sllw, x12, x10, x11, -0x33340000, 0x6666666666666666, 0x11, x5, 672, x7)

inst_101:
// rs1_val==-3037000499, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x1b
TEST_RR_OP(sllw, x12, x10, x11, 0x68000000, -0xb504f333, 0x1b, x5, 680, x7)

inst_102:
// rs1_val==3037000499, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(sllw, x12, x10, x11, 0x504f3330, 0xb504f333, 0x4, x5, 688, x7)

inst_103:
// rs1_val==6148914691236517204, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x1
TEST_RR_OP(sllw, x12, x10, x11, -0x55555558, 0x5555555555555554, 0x1, x5, 696, x7)

inst_104:
// rs1_val==3689348814741910322, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xe
TEST_RR_OP(sllw, x12, x10, x11, -0x33338000, 0x3333333333333332, 0xe, x5, 704, x7)

inst_105:
// rs1_val==7378697629483820645, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(sllw, x12, x10, x11, 0x66666650, 0x6666666666666665, 0x4, x5, 712, x7)

inst_106:
// rs1_val==3037000498, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x11
TEST_RR_OP(sllw, x12, x10, x11, -0x199c0000, 0xb504f332, 0x11, x5, 720, x7)

inst_107:
// rs1_val==6148914691236517206, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x1
TEST_RR_OP(sllw, x12, x10, x11, -0x55555554, 0x5555555555555556, 0x1, x5, 728, x7)

inst_108:
// rs1_val==-6148914691236517205, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x10
TEST_RR_OP(sllw, x12, x10, x11, -0x55550000, -0x5555555555555555, 0x10, x5, 736, x7)

inst_109:
// rs1_val==6, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x1f
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0x6, 0x1f, x5, 744, x7)

inst_110:
// rs1_val==3689348814741910324, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xa
TEST_RR_OP(sllw, x12, x10, x11, -0x33333000, 0x3333333333333334, 0xa, x5, 752, x7)

inst_111:
// rs1_val==7378697629483820647, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x1d
TEST_RR_OP(sllw, x12, x10, x11, -0x20000000, 0x6666666666666667, 0x1d, x5, 760, x7)

inst_112:
// rs1_val==-3037000498, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3
TEST_RR_OP(sllw, x12, x10, x11, 0x57d86670, -0xb504f332, 0x3, x5, 768, x7)

inst_113:
// rs1_val==3037000500, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x1f
TEST_RR_OP(sllw, x12, x10, x11, 0x0, 0xb504f334, 0x1f, x5, 776, x7)

inst_114:
// rs1_val == -524289, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x11
TEST_RR_OP(sllw, x12, x10, x11, -0x20000, -0x80001, 0x11, x5, 784, x7)

inst_115:
// rs1_val == -1048577, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0x15
TEST_RR_OP(sllw, x12, x10, x11, -0x200000, -0x100001, 0x15, x5, 792, x7)

inst_116:
// rs1_val == -2097153, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:0x12
TEST_RR_OP(sllw, x12, x10, x11, -0x40000, -0x200001, 0x12, x5, 800, x7)

inst_117:
// rs1_val == -4194305, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:0x12
TEST_RR_OP(sllw, x12, x10, x11, -0x40000, -0x400001, 0x12, x5, 808, x7)

inst_118:
// rs1_val == -8388609, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0x1
TEST_RR_OP(sllw, x12, x10, x11, -0x1000002, -0x800001, 0x1, x5, 816, x7)

inst_119:
// rs1_val == -16777217, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0x0
TEST_RR_OP(sllw, x12, x10, x11, -0x1000001, -0x1000001, 0x0, x5, 824, x7)

inst_120:
// rs1_val == -33554433, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, -0x2000, -0x2000001, 0xd, x5, 832, x7)

inst_121:
// rs1_val == -67108865, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:0x15
TEST_RR_OP(sllw, x12, x10, x11, -0x200000, -0x4000001, 0x15, x5, 840, x7)

inst_122:
// rs1_val == -134217729, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:0x4
TEST_RR_OP(sllw, x12, x10, x11, 0x7ffffff0, -0x8000001, 0x4, x5, 848, x7)

inst_123:
// rs1_val == -268435457, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, -0x2000, -0x10000001, 0xd, x5, 856, x7)

inst_124:
// rs1_val == -536870913, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:0x11
TEST_RR_OP(sllw, x12, x10, x11, -0x20000, -0x20000001, 0x11, x5, 864, x7)

inst_125:
// rs1_val == -1073741825, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0xa
TEST_RR_OP(sllw, x12, x10, x11, -0x400, -0x40000001, 0xa, x5, 872, x7)

inst_126:
// rs1_val == -2147483649, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000001;  op2val:0x3
TEST_RR_OP(sllw, x12, x10, x11, -0x8, -0x80000001, 0x3, x5, 880, x7)

inst_127:
// rs1_val == -4294967297, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:0x9
TEST_RR_OP(sllw, x12, x10, x11, -0x200, -0x100000001, 0x9, x5, 888, x7)

inst_128:
// rs1_val == -8589934593, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:0x9
TEST_RR_OP(sllw, x12, x10, x11, -0x200, -0x200000001, 0x9, x5, 896, x7)

inst_129:
// rs1_val == -17179869185, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000001;  op2val:0x1b
TEST_RR_OP(sllw, x12, x10, x11, -0x8000000, -0x400000001, 0x1b, x5, 904, x7)

inst_130:
// rs1_val == -34359738369, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000001;  op2val:0x17
TEST_RR_OP(sllw, x12, x10, x11, -0x800000, -0x800000001, 0x17, x5, 912, x7)

inst_131:
// rs1_val == -68719476737, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:0x2
TEST_RR_OP(sllw, x12, x10, x11, -0x4, -0x1000000001, 0x2, x5, 920, x7)

inst_132:
// rs1_val == -137438953473, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000001;  op2val:0x17
TEST_RR_OP(sllw, x12, x10, x11, -0x800000, -0x2000000001, 0x17, x5, 928, x7)

inst_133:
// rs1_val == -274877906945, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000001;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, -0x2000, -0x4000000001, 0xd, x5, 936, x7)

inst_134:
// rs1_val == -549755813889, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0x5
TEST_RR_OP(sllw, x12, x10, x11, -0x20, -0x8000000001, 0x5, x5, 944, x7)

inst_135:
// rs1_val == -1099511627777, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000001;  op2val:0x6
TEST_RR_OP(sllw, x12, x10, x11, -0x40, -0x10000000001, 0x6, x5, 952, x7)

inst_136:
// rs1_val == -2199023255553, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000001;  op2val:0xc
TEST_RR_OP(sllw, x12, x10, x11, -0x1000, -0x20000000001, 0xc, x5, 960, x7)

inst_137:
// rs1_val == -4398046511105, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:0x7
TEST_RR_OP(sllw, x12, x10, x11, -0x80, -0x40000000001, 0x7, x5, 968, x7)

inst_138:
// rs1_val == -8796093022209, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:0x17
TEST_RR_OP(sllw, x12, x10, x11, -0x800000, -0x80000000001, 0x17, x5, 976, x7)

inst_139:
// rs1_val == -17592186044417, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000001;  op2val:0x1f
TEST_RR_OP(sllw, x12, x10, x11, -0x80000000, -0x100000000001, 0x1f, x5, 984, x7)

inst_140:
// rs1_val == -35184372088833, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000001;  op2val:0x4
TEST_RR_OP(sllw, x12, x10, x11, -0x10, -0x200000000001, 0x4, x5, 992, x7)

inst_141:
// rs1_val == -70368744177665, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000001;  op2val:0x1d
TEST_RR_OP(sllw, x12, x10, x11, -0x20000000, -0x400000000001, 0x1d, x5, 1000, x7)

inst_142:
// rs1_val == -281474976710657, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000001;  op2val:0x10
TEST_RR_OP(sllw, x12, x10, x11, -0x10000, -0x1000000000001, 0x10, x5, 1008, x7)

inst_143:
// rs1_val == -562949953421313, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000001;  op2val:0x6
TEST_RR_OP(sllw, x12, x10, x11, -0x40, -0x2000000000001, 0x6, x5, 1016, x7)

inst_144:
// rs1_val == -1125899906842625, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000001;  op2val:0xd
TEST_RR_OP(sllw, x12, x10, x11, -0x2000, -0x4000000000001, 0xd, x5, 1024, x7)

inst_145:
// rs1_val == -2251799813685249, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000001;  op2val:0x1
TEST_RR_OP(sllw, x12, x10, x11, -0x2, -0x8000000000001, 0x1, x5, 1032, x7)

inst_146:
// rs1_val == -4503599627370497, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0x12
TEST_RR_OP(sllw, x12, x10, x11, -0x40000, -0x10000000000001, 0x12, x5, 1040, x7)

inst_147:
// rs1_val == -9007199254740993, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000000001;  op2val:0x1e
TEST_RR_OP(sllw, x12, x10, x11, -0x40000000, -0x20000000000001, 0x1e, x5, 1048, x7)

inst_148:
// rs1_val == -18014398509481985, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000000001;  op2val:0xe
TEST_RR_OP(sllw, x12, x10, x11, -0x4000, -0x40000000000001, 0xe, x5, 1056, x7)

inst_149:
// rs1_val < 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == -140737488355329, rs2_val == 15
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0xf
TEST_RR_OP(sllw, x12, x10, x11, -0x8000, -0x800000000001, 0xf, x5, 1064, x7)

inst_150:
// rs1_val == (2**(xlen-1)-1) and rs2_val >= 0 and rs2_val < xlen, rs1_val == 9223372036854775807
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffffffffffff;  op2val:0x17
TEST_RR_OP(sllw, x12, x10, x11, -0x800000, 0x7fffffffffffffff, 0x17, x5, 1072, x7)

inst_151:
// rs1_val == 64, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0x11
TEST_RR_OP(sllw, x12, x10, x11, 0x800000, 0x40, 0x11, x5, 1080, x7)

inst_152:
// rs1_val == 4194304, 
// opcode: sllw ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0x6
TEST_RR_OP(sllw, x12, x10, x11, 0x10000000, 0x400000, 0x6, x5, 1088, x7)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x4_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x4_1:
    .fill 16*(XLEN/32),4,0xdeadbeef


signature_x5_0:
    .fill 137*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
