
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the slt instruction of the RISC-V I extension for the slt covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",slt)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rs1 == rs2 != rd, rs1==x13, rs2==x13, rd==x5, rs1_val > 0 and rs2_val > 0, rs1_val == 134217728, rs1_val != rs2_val, rs2_val == 144115188075855872
// opcode: slt ; op1:x13; op2:x13; dest:x5; op1val:0x8000000;  op2val:0x8000000
TEST_RR_OP(slt, x5, x13, x13, 0x0, 0x8000000, 0x8000000, x1, 0, x14)

inst_1:
// rs2 == rd != rs1, rs1==x11, rs2==x26, rd==x26, rs1_val > 0 and rs2_val < 0, rs1_val == 4611686018427387904
// opcode: slt ; op1:x11; op2:x26; dest:x26; op1val:0x4000000000000000;  op2val:-0xb504f333
TEST_RR_OP(slt, x26, x11, x26, 0x0, 0x4000000000000000, -0xb504f333, x1, 8, x14)

inst_2:
// rs1 == rs2 == rd, rs1==x12, rs2==x12, rd==x12, rs1_val < 0 and rs2_val < 0, rs1_val == -4503599627370497, rs2_val == -1025
// opcode: slt ; op1:x12; op2:x12; dest:x12; op1val:-0x10000000000001;  op2val:-0x10000000000001
TEST_RR_OP(slt, x12, x12, x12, 0x0, -0x10000000000001, -0x10000000000001, x1, 16, x14)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x27, rs2==x15, rd==x7, rs1_val < 0 and rs2_val > 0, rs2_val == 1, rs1_val == -34359738369
// opcode: slt ; op1:x27; op2:x15; dest:x7; op1val:-0x800000001;  op2val:0x1
TEST_RR_OP(slt, x7, x27, x15, 0x1, -0x800000001, 0x1, x1, 24, x14)

inst_4:
// rs1 == rd != rs2, rs1==x17, rs2==x5, rd==x17, rs1_val == rs2_val, rs1_val == 4398046511104, rs2_val == 4398046511104
// opcode: slt ; op1:x17; op2:x5; dest:x17; op1val:0x40000000000;  op2val:0x40000000000
TEST_RR_OP(slt, x17, x17, x5, 0x0, 0x40000000000, 0x40000000000, x1, 32, x14)

inst_5:
// rs1==x15, rs2==x0, rd==x13, rs2_val == (-2**(xlen-1)), rs2_val == -9223372036854775808, rs1_val == -4294967297
// opcode: slt ; op1:x15; op2:x0; dest:x13; op1val:-0x100000001;  op2val:0x0
TEST_RR_OP(slt, x13, x15, x0, 0x1, -0x100000001, 0x0, x1, 40, x14)

inst_6:
// rs1==x3, rs2==x24, rd==x30, rs2_val == 0, rs1_val == -17592186044417
// opcode: slt ; op1:x3; op2:x24; dest:x30; op1val:-0x100000000001;  op2val:0x0
TEST_RR_OP(slt, x30, x3, x24, 0x1, -0x100000000001, 0x0, x1, 48, x14)

inst_7:
// rs1==x26, rs2==x2, rd==x24, rs2_val == (2**(xlen-1)-1), rs1_val == 34359738368, rs2_val == 9223372036854775807
// opcode: slt ; op1:x26; op2:x2; dest:x24; op1val:0x800000000;  op2val:0x7fffffffffffffff
TEST_RR_OP(slt, x24, x26, x2, 0x1, 0x800000000, 0x7fffffffffffffff, x1, 56, x14)

inst_8:
// rs1==x21, rs2==x9, rd==x20, rs1_val == (-2**(xlen-1)), rs2_val == -140737488355329, rs1_val == -9223372036854775808
// opcode: slt ; op1:x21; op2:x9; dest:x20; op1val:-0x8000000000000000;  op2val:-0x800000000001
TEST_RR_OP(slt, x20, x21, x9, 0x1, -0x8000000000000000, -0x800000000001, x1, 64, x14)

inst_9:
// rs1==x7, rs2==x21, rd==x31, rs1_val == 0, 
// opcode: slt ; op1:x7; op2:x21; dest:x31; op1val:0x0;  op2val:-0x4
TEST_RR_OP(slt, x31, x7, x21, 0x0, 0x0, -0x4, x1, 72, x14)

inst_10:
// rs1==x30, rs2==x3, rd==x8, rs1_val == (2**(xlen-1)-1), rs2_val == 8, rs1_val == 9223372036854775807
// opcode: slt ; op1:x30; op2:x3; dest:x8; op1val:0x7fffffffffffffff;  op2val:0x8
TEST_RR_OP(slt, x8, x30, x3, 0x0, 0x7fffffffffffffff, 0x8, x1, 80, x14)

inst_11:
// rs1==x6, rs2==x29, rd==x2, rs1_val == 1, rs2_val == -68719476737
// opcode: slt ; op1:x6; op2:x29; dest:x2; op1val:0x1;  op2val:-0x1000000001
TEST_RR_OP(slt, x2, x6, x29, 0x0, 0x1, -0x1000000001, x1, 88, x14)

inst_12:
// rs1==x18, rs2==x19, rd==x10, rs2_val == 2, rs1_val == 8
// opcode: slt ; op1:x18; op2:x19; dest:x10; op1val:0x8;  op2val:0x2
TEST_RR_OP(slt, x10, x18, x19, 0x0, 0x8, 0x2, x1, 96, x14)

inst_13:
// rs1==x8, rs2==x18, rd==x25, rs2_val == 4, rs1_val == 4294967296
// opcode: slt ; op1:x8; op2:x18; dest:x25; op1val:0x100000000;  op2val:0x4
TEST_RR_OP(slt, x25, x8, x18, 0x0, 0x100000000, 0x4, x1, 104, x14)

inst_14:
// rs1==x2, rs2==x16, rd==x11, rs2_val == 16, 
// opcode: slt ; op1:x2; op2:x16; dest:x11; op1val:0x0;  op2val:0x10
TEST_RR_OP(slt, x11, x2, x16, 0x1, 0x0, 0x10, x1, 112, x14)

inst_15:
// rs1==x28, rs2==x31, rd==x18, rs2_val == 32, rs1_val == 562949953421312
// opcode: slt ; op1:x28; op2:x31; dest:x18; op1val:0x2000000000000;  op2val:0x20
TEST_RR_OP(slt, x18, x28, x31, 0x0, 0x2000000000000, 0x20, x1, 120, x14)

inst_16:
// rs1==x4, rs2==x17, rd==x9, rs2_val == 64, rs1_val == 17179869184
// opcode: slt ; op1:x4; op2:x17; dest:x9; op1val:0x400000000;  op2val:0x40
TEST_RR_OP(slt, x9, x4, x17, 0x0, 0x400000000, 0x40, x1, 128, x14)

inst_17:
// rs1==x0, rs2==x23, rd==x16, rs2_val == 128, rs1_val == -3
// opcode: slt ; op1:x0; op2:x23; dest:x16; op1val:0x0;  op2val:0x80
TEST_RR_OP(slt, x16, x0, x23, 0x1, 0x0, 0x80, x1, 136, x13)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_18:
// rs1==x14, rs2==x4, rd==x19, rs2_val == 256, 
// opcode: slt ; op1:x14; op2:x4; dest:x19; op1val:0x5555555555555556;  op2val:0x100
TEST_RR_OP(slt, x19, x14, x4, 0x0, 0x5555555555555556, 0x100, x2, 0, x13)

inst_19:
// rs1==x1, rs2==x22, rd==x28, rs2_val == 512, 
// opcode: slt ; op1:x1; op2:x22; dest:x28; op1val:0x5;  op2val:0x200
TEST_RR_OP(slt, x28, x1, x22, 0x1, 0x5, 0x200, x2, 8, x13)

inst_20:
// rs1==x25, rs2==x20, rd==x22, rs2_val == 1024, rs1_val == -8796093022209
// opcode: slt ; op1:x25; op2:x20; dest:x22; op1val:-0x80000000001;  op2val:0x400
TEST_RR_OP(slt, x22, x25, x20, 0x1, -0x80000000001, 0x400, x2, 16, x13)

inst_21:
// rs1==x29, rs2==x10, rd==x6, rs2_val == 2048, rs1_val == -2305843009213693953
// opcode: slt ; op1:x29; op2:x10; dest:x6; op1val:-0x2000000000000001;  op2val:0x800
TEST_RR_OP(slt, x6, x29, x10, 0x1, -0x2000000000000001, 0x800, x2, 24, x13)

inst_22:
// rs1==x19, rs2==x1, rd==x29, rs2_val == 4096, rs1_val == 2097152
// opcode: slt ; op1:x19; op2:x1; dest:x29; op1val:0x200000;  op2val:0x1000
TEST_RR_OP(slt, x29, x19, x1, 0x0, 0x200000, 0x1000, x2, 32, x13)

inst_23:
// rs1==x10, rs2==x28, rd==x4, rs2_val == 8192, rs1_val == -274877906945
// opcode: slt ; op1:x10; op2:x28; dest:x4; op1val:-0x4000000001;  op2val:0x2000
TEST_RR_OP(slt, x4, x10, x28, 0x1, -0x4000000001, 0x2000, x2, 40, x13)

inst_24:
// rs1==x22, rs2==x30, rd==x15, rs2_val == 16384, 
// opcode: slt ; op1:x22; op2:x30; dest:x15; op1val:-0x10000000000001;  op2val:0x4000
TEST_RR_OP(slt, x15, x22, x30, 0x1, -0x10000000000001, 0x4000, x2, 48, x13)

inst_25:
// rs1==x5, rs2==x7, rd==x21, rs2_val == 32768, rs1_val == 2199023255552
// opcode: slt ; op1:x5; op2:x7; dest:x21; op1val:0x20000000000;  op2val:0x8000
TEST_RR_OP(slt, x21, x5, x7, 0x0, 0x20000000000, 0x8000, x2, 56, x13)

inst_26:
// rs1==x20, rs2==x27, rd==x23, rs2_val == 65536, 
// opcode: slt ; op1:x20; op2:x27; dest:x23; op1val:0x5555555555555556;  op2val:0x10000
TEST_RR_OP(slt, x23, x20, x27, 0x0, 0x5555555555555556, 0x10000, x2, 64, x13)

inst_27:
// rs1==x23, rs2==x6, rd==x1, rs2_val == 131072, rs1_val == -2097153
// opcode: slt ; op1:x23; op2:x6; dest:x1; op1val:-0x200001;  op2val:0x20000
TEST_RR_OP(slt, x1, x23, x6, 0x1, -0x200001, 0x20000, x2, 72, x13)

inst_28:
// rs1==x31, rs2==x25, rd==x14, rs2_val == 262144, rs1_val == -1025
// opcode: slt ; op1:x31; op2:x25; dest:x14; op1val:-0x401;  op2val:0x40000
TEST_RR_OP(slt, x14, x31, x25, 0x1, -0x401, 0x40000, x2, 80, x13)

inst_29:
// rs1==x16, rs2==x8, rd==x0, rs2_val == 524288, 
// opcode: slt ; op1:x16; op2:x8; dest:x0; op1val:-0xb504f333;  op2val:0x80000
TEST_RR_OP(slt, x0, x16, x8, 0, -0xb504f333, 0x80000, x2, 88, x13)

inst_30:
// rs1==x9, rs2==x14, rd==x27, rs2_val == 1048576, rs1_val == 262144
// opcode: slt ; op1:x9; op2:x14; dest:x27; op1val:0x40000;  op2val:0x100000
TEST_RR_OP(slt, x27, x9, x14, 0x1, 0x40000, 0x100000, x2, 96, x13)

inst_31:
// rs1==x24, rs2==x11, rd==x3, rs2_val == 2097152, 
// opcode: slt ; op1:x24; op2:x11; dest:x3; op1val:0x6;  op2val:0x200000
TEST_RR_OP(slt, x3, x24, x11, 0x1, 0x6, 0x200000, x2, 104, x13)

inst_32:
// rs2_val == 4194304, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x7;  op2val:0x400000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x7, 0x400000, x2, 112, x13)

inst_33:
// rs2_val == 8388608, rs1_val == 1099511627776
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0x800000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x10000000000, 0x800000, x2, 120, x13)

inst_34:
// rs2_val == 16777216, rs1_val == -1048577
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0x1000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x100001, 0x1000000, x2, 128, x13)

inst_35:
// rs2_val == 33554432, rs1_val == 268435456
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0x2000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x10000000, 0x2000000, x2, 136, x13)

inst_36:
// rs2_val == 67108864, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0x4000000, x2, 144, x13)

inst_37:
// rs2_val == 134217728, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:0x8000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x20000000000, 0x8000000, x2, 152, x13)

inst_38:
// rs2_val == 268435456, rs1_val == -1152921504606846977
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:0x10000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x1000000000000001, 0x10000000, x2, 160, x13)

inst_39:
// rs2_val == 536870912, rs1_val == -144115188075855873
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:0x20000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x200000000000001, 0x20000000, x2, 168, x13)

inst_40:
// rs2_val == 1073741824, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000000;  op2val:0x40000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x4000000000000000, 0x40000000, x2, 176, x13)

inst_41:
// rs2_val == 2147483648, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:0x80000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x200000000000001, 0x80000000, x2, 184, x13)

inst_42:
// rs2_val == 4294967296, rs1_val == -549755813889
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0x100000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x8000000001, 0x100000000, x2, 192, x13)

inst_43:
// rs2_val == 8589934592, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x200000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x200000000, x2, 200, x13)

inst_44:
// rs2_val == 17179869184, rs1_val == -36028797018963969
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:0x400000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x80000000000001, 0x400000000, x2, 208, x13)

inst_45:
// rs2_val == 34359738368, rs1_val == -17179869185
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x400000001;  op2val:0x800000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x400000001, 0x800000000, x2, 216, x13)

inst_46:
// rs2_val == 68719476736, rs1_val == 4096
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0x1000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x1000, 0x1000000000, x2, 224, x13)

inst_47:
// rs2_val == 137438953472, rs1_val == 1024
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:0x2000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x400, 0x2000000000, x2, 232, x13)

inst_48:
// rs2_val == 274877906944, rs1_val == 4
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x4000000000, x2, 240, x13)

inst_49:
// rs2_val == 549755813888, rs1_val == -67108865
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:0x8000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x4000001, 0x8000000000, x2, 248, x13)

inst_50:
// rs2_val == 1099511627776, rs1_val == 18014398509481984
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0x10000000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x40000000000000, 0x10000000000, x2, 256, x13)

inst_51:
// rs2_val == 2199023255552, rs1_val == -9
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:0x20000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x9, 0x20000000000, x2, 264, x13)

inst_52:
// rs2_val == 8796093022208, rs1_val == 33554432
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0x80000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2000000, 0x80000000000, x2, 272, x13)

inst_53:
// rs2_val == 17592186044416, rs1_val == -72057594037927937
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000000001;  op2val:0x100000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x100000000000001, 0x100000000000, x2, 280, x13)

inst_54:
// rs2_val == 35184372088832, rs1_val == -5
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:0x200000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5, 0x200000000000, x2, 288, x13)

inst_55:
// rs2_val == 70368744177664, rs1_val == 70368744177664
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0x400000000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x400000000000, 0x400000000000, x2, 296, x13)

inst_56:
// rs2_val == 140737488355328, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000001;  op2val:0x800000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x100000000001, 0x800000000000, x2, 304, x13)

inst_57:
// rs2_val == 281474976710656, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0x1000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x40000000000000, 0x1000000000000, x2, 312, x13)

inst_58:
// rs2_val == 562949953421312, rs1_val == -70368744177665
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000001;  op2val:0x2000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x400000000001, 0x2000000000000, x2, 320, x13)

inst_59:
// rs2_val == 1125899906842624, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:0x4000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x80000000000001, 0x4000000000000, x2, 328, x13)

inst_60:
// rs2_val == 2251799813685248, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:0x8000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x100000001, 0x8000000000000, x2, 336, x13)

inst_61:
// rs2_val == 4503599627370496, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:0x10000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x400000000, 0x10000000000000, x2, 344, x13)

inst_62:
// rs2_val == 9007199254740992, rs1_val == -8589934593
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:0x20000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x200000001, 0x20000000000000, x2, 352, x13)

inst_63:
// rs2_val == 18014398509481984, rs1_val == -8193
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x40000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x2001, 0x40000000000000, x2, 360, x13)

inst_64:
// rs2_val == 36028797018963968, rs1_val == 2305843009213693952
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:0x80000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2000000000000000, 0x80000000000000, x2, 368, x13)

inst_65:
// rs2_val == 72057594037927936, rs1_val == -562949953421313
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000001;  op2val:0x100000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x2000000000001, 0x100000000000000, x2, 376, x13)

inst_66:
// rs2_val == 288230376151711744, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:0x400000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x3, 0x400000000000000, x2, 384, x13)

inst_67:
// rs2_val == 576460752303423488, rs1_val == -6148914691236517206
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x800000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x800000000000000, x2, 392, x13)

inst_68:
// rs2_val == 1152921504606846976, rs1_val == -33554433
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0x1000000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x2000001, 0x1000000000000000, x2, 400, x13)

inst_69:
// rs2_val == 2305843009213693952, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2000000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x2000000000000000, x2, 408, x13)

inst_70:
// rs2_val == 4611686018427387904, rs1_val == -1073741825
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0x4000000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x40000001, 0x4000000000000000, x2, 416, x13)

inst_71:
// rs2_val == -2, rs1_val == -281474976710657
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000001;  op2val:-0x2
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x1000000000001, -0x2, x2, 424, x13)

inst_72:
// rs2_val == -3, rs1_val == -2251799813685249
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000001;  op2val:-0x3
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x8000000000001, -0x3, x2, 432, x13)

inst_73:
// rs2_val == -5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, -0x5, x2, 440, x13)

inst_74:
// rs2_val == -9, rs1_val == -4611686018427387905
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:-0x9
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x4000000000000001, -0x9, x2, 448, x13)

inst_75:
// rs2_val == -17, rs1_val == -9007199254740993
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000000001;  op2val:-0x11
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x20000000000001, -0x11, x2, 456, x13)

inst_76:
// rs2_val == -33, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:-0x21
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x401, -0x21, x2, 464, x13)

inst_77:
// rs2_val == -65, rs1_val == 16
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:-0x41
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x10, -0x41, x2, 472, x13)

inst_78:
// rs2_val == -129, rs1_val == 2048
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:-0x81
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x800, -0x81, x2, 480, x13)

inst_79:
// rs2_val == -257, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x101
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, -0x101, x2, 488, x13)

inst_80:
// rs2_val == -513, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:-0x201
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x10000000, -0x201, x2, 496, x13)

inst_81:
// rs2_val == -2049, rs1_val == -65537
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:-0x801
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x10001, -0x801, x2, 504, x13)

inst_82:
// rs2_val == -4097, rs1_val == -524289
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:-0x1001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x80001, -0x1001, x2, 512, x13)

inst_83:
// rs2_val == -8193, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000000001;  op2val:-0x2001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x2000000000000001, -0x2001, x2, 520, x13)

inst_84:
// rs2_val == -16385, rs1_val == 35184372088832
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:-0x4001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x200000000000, -0x4001, x2, 528, x13)

inst_85:
// rs2_val == -32769, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:-0x8001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x8, -0x8001, x2, 536, x13)

inst_86:
// rs2_val == -65537, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x9;  op2val:-0x10001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x9, -0x10001, x2, 544, x13)

inst_87:
// rs2_val == -131073, rs1_val == 288230376151711744
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:-0x20001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x400000000000000, -0x20001, x2, 552, x13)

inst_88:
// rs2_val == -262145, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:-0x40001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x200000001, -0x40001, x2, 560, x13)

inst_89:
// rs2_val == -524289, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x80001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, -0x80001, x2, 568, x13)

inst_90:
// rs2_val == -1048577, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000000;  op2val:-0x100001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x4000000000000000, -0x100001, x2, 576, x13)

inst_91:
// rs2_val == -2097153, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:-0x200001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x40000001, -0x200001, x2, 584, x13)

inst_92:
// rs2_val == -4194305, rs1_val == 1125899906842624
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:-0x400001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4000000000000, -0x400001, x2, 592, x13)

inst_93:
// rs2_val == -8388609, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x7;  op2val:-0x800001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x7, -0x800001, x2, 600, x13)

inst_94:
// rs2_val == -16777217, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:-0x1000001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x100000001, -0x1000001, x2, 608, x13)

inst_95:
// rs2_val == -33554433, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:-0x2000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x5, -0x2000001, x2, 616, x13)

inst_96:
// rs2_val == -67108865, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x4000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, -0x4000001, x2, 624, x13)

inst_97:
// rs2_val == -134217729, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000000;  op2val:-0x8000001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x4000000000000000, -0x8000001, x2, 632, x13)

inst_98:
// rs2_val == -268435457, rs1_val == 1152921504606846976
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:-0x10000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x1000000000000000, -0x10000001, x2, 640, x13)

inst_99:
// rs2_val == -536870913, rs1_val == 256
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:-0x20000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x100, -0x20000001, x2, 648, x13)

inst_100:
// rs2_val == -1073741825, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:-0x40000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x20000000000, -0x40000001, x2, 656, x13)

inst_101:
// rs2_val == -2147483649, rs1_val == -17
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:-0x80000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x11, -0x80000001, x2, 664, x13)

inst_102:
// rs2_val == -4294967297, rs1_val == -262145
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:-0x100000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x40001, -0x100000001, x2, 672, x13)

inst_103:
// rs2_val == -8589934593, rs1_val == 1073741824
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:-0x200000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x40000000, -0x200000001, x2, 680, x13)

inst_104:
// rs2_val == -17179869185, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:-0x400000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x9, -0x400000001, x2, 688, x13)

inst_105:
// rs2_val == -34359738369, rs1_val == 4503599627370496
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:-0x800000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x10000000000000, -0x800000001, x2, 696, x13)

inst_106:
// rs2_val == -137438953473, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x2000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, -0x2000000001, x2, 704, x13)

inst_107:
// rs2_val == -274877906945, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:-0x4000000001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x80000000000001, -0x4000000001, x2, 712, x13)

inst_108:
// rs2_val == -549755813889, rs1_val == 17592186044416
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:-0x8000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x100000000000, -0x8000000001, x2, 720, x13)

inst_109:
// rs2_val == -1099511627777, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:-0x10000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x100000000000, -0x10000000001, x2, 728, x13)

inst_110:
// rs2_val == -2199023255553, rs1_val == -513
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:-0x20000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x201, -0x20000000001, x2, 736, x13)

inst_111:
// rs2_val == -4398046511105, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x40000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x0, -0x40000000001, x2, 744, x13)

inst_112:
// rs2_val == -8796093022209, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:-0x80000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x4000001, -0x80000000001, x2, 752, x13)

inst_113:
// rs2_val == -17592186044417, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:-0x100000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2000000000000000, -0x100000000001, x2, 760, x13)

inst_114:
// rs2_val == -35184372088833, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:-0x200000000001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x4000000000000001, -0x200000000001, x2, 768, x13)

inst_115:
// rs2_val == -70368744177665, rs1_val == 8192
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:-0x400000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2000, -0x400000000001, x2, 776, x13)

inst_116:
// rs2_val == -281474976710657, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x1000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, -0x1000000000001, x2, 784, x13)

inst_117:
// rs2_val == -562949953421313, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:-0x2000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x1000000000000001, -0x2000000000001, x2, 792, x13)

inst_118:
// rs2_val == -1125899906842625, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4;  op2val:-0x4000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x4, -0x4000000000001, x2, 800, x13)

inst_119:
// rs2_val == -2251799813685249, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:-0x8000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x4000001, -0x8000000000001, x2, 808, x13)

inst_120:
// rs2_val == -4503599627370497, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x10000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, -0x10000000000001, x2, 816, x13)

inst_121:
// rs2_val == -9007199254740993, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:-0x20000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x9, -0x20000000000001, x2, 824, x13)

inst_122:
// rs2_val == -18014398509481985, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:-0x40000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x10000000000, -0x40000000000001, x2, 832, x13)

inst_123:
// rs2_val == -36028797018963969, rs1_val == 2251799813685248
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:-0x80000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x8000000000000, -0x80000000000001, x2, 840, x13)

inst_124:
// rs2_val == -72057594037927937, rs1_val == -576460752303423489
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:-0x100000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x800000000000001, -0x100000000000001, x2, 848, x13)

inst_125:
// rs2_val == -144115188075855873, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x7;  op2val:-0x200000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x7, -0x200000000000001, x2, 856, x13)

inst_126:
// rs2_val == -288230376151711745, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:-0x400000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x1, -0x400000000000001, x2, 864, x13)

inst_127:
// rs2_val == -576460752303423489, rs1_val == -1125899906842625
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000001;  op2val:-0x800000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x4000000000001, -0x800000000000001, x2, 872, x13)

inst_128:
// rs2_val == -1152921504606846977, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:-0x1000000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x10000000, -0x1000000000000001, x2, 880, x13)

inst_129:
// rs2_val == -2305843009213693953, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:-0x2000000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x1, -0x2000000000000001, x2, 888, x13)

inst_130:
// rs2_val == -4611686018427387905, rs1_val == 65536
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:-0x4000000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x10000, -0x4000000000000001, x2, 896, x13)

inst_131:
// rs2_val == 6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x8000000001, 0x5555555555555555, x2, 904, x13)

inst_132:
// rs2_val == -6148914691236517206, rs1_val == -288230376151711745
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x400000000000001, -0x5555555555555556, x2, 912, x13)

inst_133:
// rs1_val == 2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x100000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x100000000000000, x2, 920, x13)

inst_134:
// rs1_val == 32, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:-0x4001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x20, -0x4001, x2, 928, x13)

inst_135:
// rs1_val == 64, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x40, 0x5, x2, 936, x13)

inst_136:
// rs1_val == 128, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:-0x200000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x80, -0x200000000001, x2, 944, x13)

inst_137:
// rs1_val == 512, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:-0x4000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x200, -0x4000000000001, x2, 952, x13)

inst_138:
// rs1_val == 16384, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4000, -0xb504f333, x2, 960, x13)

inst_139:
// rs1_val == 32768, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:-0x200000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x8000, -0x200000001, x2, 968, x13)

inst_140:
// rs1_val == 131072, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0x100000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x20000, 0x100000000, x2, 976, x13)

inst_141:
// rs1_val == 524288, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:-0x1000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x80000, -0x1000000000001, x2, 984, x13)

inst_142:
// rs1_val == 1048576, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0x1000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x100000, 0x1000000000, x2, 992, x13)

inst_143:
// rs1_val == 4194304, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:-0x400001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x400000, -0x400001, x2, 1000, x13)

inst_144:
// rs1_val == 8388608, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x800000, 0x3, x2, 1008, x13)

inst_145:
// rs1_val == 16777216, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x20000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x1000000, 0x20000000000000, x2, 1016, x13)

inst_146:
// rs1_val == 67108864, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x400000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4000000, 0x400000000000, x2, 1024, x13)

inst_147:
// rs1_val == 536870912, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:-0x40000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x20000000, -0x40000000000001, x2, 1032, x13)

inst_148:
// rs1_val == 2147483648, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:-0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x80000000, -0x4, x2, 1040, x13)

inst_149:
// rs1_val == 8589934592, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:0x8
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x200000000, 0x8, x2, 1048, x13)

inst_150:
// rs1_val == 68719476736, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0x4000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x1000000000, 0x4000000000, x2, 1056, x13)

inst_151:
// rs1_val == 137438953472, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:-0x4001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2000000000, -0x4001, x2, 1064, x13)

inst_152:
// rs1_val == 274877906944, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:-0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4000000000, -0x3, x2, 1072, x13)

inst_153:
// rs1_val == 549755813888, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:-0x200000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x8000000000, -0x200000001, x2, 1080, x13)

inst_154:
// rs1_val == 8796093022208, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x80000000000, 0x3333333333333334, x2, 1088, x13)

inst_155:
// rs1_val == 140737488355328, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:0x400000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x800000000000, 0x400000000, x2, 1096, x13)

inst_156:
// rs1_val == 281474976710656, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:0x20000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x1000000000000, 0x20000, x2, 1104, x13)

inst_157:
// rs1_val == 9007199254740992, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:0x1000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x20000000000000, 0x1000, x2, 1112, x13)

inst_158:
// rs1_val == 36028797018963968, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x80000000000000, 0x5555555555555556, x2, 1120, x13)

inst_159:
// rs1_val == 72057594037927936, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0x40000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x100000000000000, 0x40000000000000, x2, 1128, x13)

inst_160:
// rs1_val == 144115188075855872, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:0x1000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x200000000000000, 0x1000000000000, x2, 1136, x13)

inst_161:
// rs1_val == 576460752303423488, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x800000000000000, 0x4, x2, 1144, x13)

inst_162:
// rs1_val == -2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:-0x4000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x2, -0x4000000000001, x2, 1152, x13)

inst_163:
// rs1_val == -33, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x21, 0x2, x2, 1160, x13)

inst_164:
// rs1_val == -65, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:-0x7
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x41, -0x7, x2, 1168, x13)

inst_165:
// rs1_val == -129, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x81, 0x5555555555555554, x2, 1176, x13)

inst_166:
// rs1_val == -257, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x101, 0x0, x2, 1184, x13)

inst_167:
// rs1_val == -2049, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:-0x9
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x801, -0x9, x2, 1192, x13)

inst_168:
// rs1_val == -4097, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:-0x40001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x1001, -0x40001, x2, 1200, x13)

inst_169:
// rs1_val == -16385, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:0x10000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x4001, 0x10000000000000, x2, 1208, x13)

inst_170:
// rs1_val == -32769, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:-0x40000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x8001, -0x40000000001, x2, 1216, x13)

inst_171:
// rs1_val == -131073, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:-0x20000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x20001, -0x20000000001, x2, 1224, x13)

inst_172:
// rs1_val == -4194305, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:0x80
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x400001, 0x80, x2, 1232, x13)

inst_173:
// rs1_val == -8388609, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0x40
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x800001, 0x40, x2, 1240, x13)

inst_174:
// rs1_val == -16777217, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0x40
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x1000001, 0x40, x2, 1248, x13)

inst_175:
// rs1_val == -134217729, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:-0x20000000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x8000001, -0x20000000000001, x2, 1256, x13)

inst_176:
// rs1_val == -268435457, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:0x80000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x10000001, 0x80000000000, x2, 1264, x13)

inst_177:
// rs1_val == -536870913, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:0x800000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x20000001, 0x800000000000000, x2, 1272, x13)

inst_178:
// rs1_val == -2147483649, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x80000001;  op2val:0x800000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x80000001, 0x800000, x2, 1280, x13)

inst_179:
// rs1_val == -68719476737, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:-0x10000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x1000000001, -0x10000000001, x2, 1288, x13)

inst_180:
// rs1_val == -137438953473, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000001;  op2val:0x100
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x2000000001, 0x100, x2, 1296, x13)

inst_181:
// rs1_val == -1099511627777, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000001;  op2val:-0x10001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x10000000001, -0x10001, x2, 1304, x13)

inst_182:
// rs1_val == -2199023255553, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000001;  op2val:-0x800000001
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x20000000001, -0x800000001, x2, 1312, x13)

inst_183:
// rs1_val == -4398046511105, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:0x1000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x40000000001, 0x1000000000000, x2, 1320, x13)

inst_184:
// rs1_val == -35184372088833, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000001;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x200000000001, 0xb504f332, x2, 1328, x13)

inst_185:
// rs1_val == -140737488355329, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x800000000001, 0x2, x2, 1336, x13)

inst_186:
// rs1_val == -18014398509481985, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000000001;  op2val:-0x4000000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x40000000000001, -0x4000000000000000, x2, 1344, x13)

inst_187:
// rs1_val == 6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x20000000001
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, -0x20000000001, x2, 1352, x13)

inst_188:
// rs1_val==3 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3, 0x3, x2, 1360, x13)

inst_189:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x5555555555555555, x2, 1368, x13)

inst_190:
// rs1_val==3 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3, -0x5555555555555556, x2, 1376, x13)

inst_191:
// rs1_val==3 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x5, x2, 1384, x13)

inst_192:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x3333333333333333, x2, 1392, x13)

inst_193:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x6666666666666666, x2, 1400, x13)

inst_194:
// rs1_val==3 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3, -0xb504f333, x2, 1408, x13)

inst_195:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0xb504f333, x2, 1416, x13)

inst_196:
// rs1_val==3 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3, 0x2, x2, 1424, x13)

inst_197:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x5555555555555554, x2, 1432, x13)

inst_198:
// rs1_val==3 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3, 0x0, x2, 1440, x13)

inst_199:
// rs1_val==3 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x4, x2, 1448, x13)

inst_200:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x3333333333333332, x2, 1456, x13)

inst_201:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x6666666666666665, x2, 1464, x13)

inst_202:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0xb504f332, x2, 1472, x13)

inst_203:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x5555555555555556, x2, 1480, x13)

inst_204:
// rs1_val==3 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3, -0x5555555555555555, x2, 1488, x13)

inst_205:
// rs1_val==3 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x6, x2, 1496, x13)

inst_206:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x3333333333333334, x2, 1504, x13)

inst_207:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0x6666666666666667, x2, 1512, x13)

inst_208:
// rs1_val==3 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3, -0xb504f332, x2, 1520, x13)

inst_209:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3, 0xb504f334, x2, 1528, x13)

inst_210:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x3, x2, 1536, x13)

inst_211:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555555, x2, 1544, x13)

inst_212:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, -0x5555555555555556, x2, 1552, x13)

inst_213:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x5, x2, 1560, x13)

inst_214:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x3333333333333333, x2, 1568, x13)

inst_215:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555555, 0x6666666666666666, x2, 1576, x13)

inst_216:
// rs1_val==6148914691236517205 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, -0xb504f333, x2, 1584, x13)

inst_217:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0xb504f333, x2, 1592, x13)

inst_218:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x2, x2, 1600, x13)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555554, x2, 1608, x13)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x0, x2, 1616, x13)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x4, x2, 1624, x13)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x3333333333333332, x2, 1632, x13)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555555, 0x6666666666666665, x2, 1640, x13)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0xb504f332, x2, 1648, x13)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555555, 0x5555555555555556, x2, 1656, x13)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, -0x5555555555555555, x2, 1664, x13)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x6, x2, 1672, x13)

inst_228:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0x3333333333333334, x2, 1680, x13)

inst_229:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555555, 0x6666666666666667, x2, 1688, x13)

inst_230:
// rs1_val==6148914691236517205 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, -0xb504f332, x2, 1696, x13)

inst_231:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555555, 0xb504f334, x2, 1704, x13)

inst_232:
// rs1_val==-6148914691236517206 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x3, x2, 1712, x13)

inst_233:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x5555555555555555, x2, 1720, x13)

inst_234:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x5555555555555556, -0x5555555555555556, x2, 1728, x13)

inst_235:
// rs1_val==-6148914691236517206 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x5, x2, 1736, x13)

inst_236:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x3333333333333333, x2, 1744, x13)

inst_237:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x6666666666666666, x2, 1752, x13)

inst_238:
// rs1_val==-6148914691236517206 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, -0xb504f333, x2, 1760, x13)

inst_239:
// rs1_val==-6148914691236517206 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0xb504f333, x2, 1768, x13)

inst_240:
// rs1_val==-6148914691236517206 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x2, x2, 1776, x13)

inst_241:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x5555555555555554, x2, 1784, x13)

inst_242:
// rs1_val==-6148914691236517206 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x0, x2, 1792, x13)

inst_243:
// rs1_val==-6148914691236517206 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x4, x2, 1800, x13)

inst_244:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x3333333333333332, x2, 1808, x13)

inst_245:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x6666666666666665, x2, 1816, x13)

inst_246:
// rs1_val==-6148914691236517206 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0xb504f332, x2, 1824, x13)

inst_247:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x5555555555555556, x2, 1832, x13)

inst_248:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, -0x5555555555555555, x2, 1840, x13)

inst_249:
// rs1_val==-6148914691236517206 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x6, x2, 1848, x13)

inst_250:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x3333333333333334, x2, 1856, x13)

inst_251:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0x6666666666666667, x2, 1864, x13)

inst_252:
// rs1_val==-6148914691236517206 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, -0xb504f332, x2, 1872, x13)

inst_253:
// rs1_val==-6148914691236517206 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555556, 0xb504f334, x2, 1880, x13)

inst_254:
// rs1_val==5 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, 0x3, x2, 1888, x13)

inst_255:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x5555555555555555, x2, 1896, x13)

inst_256:
// rs1_val==5 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, -0x5555555555555556, x2, 1904, x13)

inst_257:
// rs1_val==5 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, 0x5, x2, 1912, x13)

inst_258:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x3333333333333333, x2, 1920, x13)

inst_259:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x6666666666666666, x2, 1928, x13)

inst_260:
// rs1_val==5 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, -0xb504f333, x2, 1936, x13)

inst_261:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0xb504f333, x2, 1944, x13)

inst_262:
// rs1_val==5 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, 0x2, x2, 1952, x13)

inst_263:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x5555555555555554, x2, 1960, x13)

inst_264:
// rs1_val==5 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, 0x0, x2, 1968, x13)

inst_265:
// rs1_val==5 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, 0x4, x2, 1976, x13)

inst_266:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x3333333333333332, x2, 1984, x13)

inst_267:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x6666666666666665, x2, 1992, x13)

inst_268:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0xb504f332, x2, 2000, x13)

inst_269:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x5555555555555556, x2, 2008, x13)

inst_270:
// rs1_val==5 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, -0x5555555555555555, x2, 2016, x13)

inst_271:
// rs1_val==5 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x6, x2, 2024, x13)

inst_272:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x3333333333333334, x2, 2032, x13)

inst_273:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0x6666666666666667, x2, 2040, x13)
RVTEST_SIGBASE( x2,signature_x2_1)

inst_274:
// rs1_val==5 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5, -0xb504f332, x2, 0, x13)

inst_275:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5, 0xb504f334, x2, 8, x13)

inst_276:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0x3, x2, 16, x13)

inst_277:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333333, 0x5555555555555555, x2, 24, x13)

inst_278:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, -0x5555555555555556, x2, 32, x13)

inst_279:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0x5, x2, 40, x13)

inst_280:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333333, x2, 48, x13)

inst_281:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333333, 0x6666666666666666, x2, 56, x13)

inst_282:
// rs1_val==3689348814741910323 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, -0xb504f333, x2, 64, x13)

inst_283:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f333, x2, 72, x13)

inst_284:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0x2, x2, 80, x13)

inst_285:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333333, 0x5555555555555554, x2, 88, x13)

inst_286:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0x0, x2, 96, x13)

inst_287:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0x4, x2, 104, x13)

inst_288:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333332, x2, 112, x13)

inst_289:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333333, 0x6666666666666665, x2, 120, x13)

inst_290:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f332, x2, 128, x13)

inst_291:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333333, 0x5555555555555556, x2, 136, x13)

inst_292:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, -0x5555555555555555, x2, 144, x13)

inst_293:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0x6, x2, 152, x13)

inst_294:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333333, 0x3333333333333334, x2, 160, x13)

inst_295:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333333, 0x6666666666666667, x2, 168, x13)

inst_296:
// rs1_val==3689348814741910323 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, -0xb504f332, x2, 176, x13)

inst_297:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f334, x2, 184, x13)

inst_298:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x3, x2, 192, x13)

inst_299:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x5555555555555555, x2, 200, x13)

inst_300:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, -0x5555555555555556, x2, 208, x13)

inst_301:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x5, x2, 216, x13)

inst_302:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333333, x2, 224, x13)

inst_303:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666666, x2, 232, x13)

inst_304:
// rs1_val==7378697629483820646 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, -0xb504f333, x2, 240, x13)

inst_305:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0xb504f333, x2, 248, x13)

inst_306:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x2, x2, 256, x13)

inst_307:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x5555555555555554, x2, 264, x13)

inst_308:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x0, x2, 272, x13)

inst_309:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x4, x2, 280, x13)

inst_310:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333332, x2, 288, x13)

inst_311:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666665, x2, 296, x13)

inst_312:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0xb504f332, x2, 304, x13)

inst_313:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x5555555555555556, x2, 312, x13)

inst_314:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, -0x5555555555555555, x2, 320, x13)

inst_315:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x6, x2, 328, x13)

inst_316:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333334, x2, 336, x13)

inst_317:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6666666666666666, 0x6666666666666667, x2, 344, x13)

inst_318:
// rs1_val==7378697629483820646 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, -0xb504f332, x2, 352, x13)

inst_319:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666666, 0xb504f334, x2, 360, x13)

inst_320:
// rs1_val==-3037000499 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x3, x2, 368, x13)

inst_321:
// rs1_val==-3037000499 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x5555555555555555, x2, 376, x13)

inst_322:
// rs1_val==-3037000499 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0xb504f333, -0x5555555555555556, x2, 384, x13)

inst_323:
// rs1_val==-3037000499 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x5, x2, 392, x13)

inst_324:
// rs1_val==-3037000499 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x3333333333333333, x2, 400, x13)

inst_325:
// rs1_val==-3037000499 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x6666666666666666, x2, 408, x13)

inst_326:
// rs1_val==-3037000499 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0xb504f333, -0xb504f333, x2, 416, x13)

inst_327:
// rs1_val==-3037000499 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0xb504f333, x2, 424, x13)

inst_328:
// rs1_val==-3037000499 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x2, x2, 432, x13)

inst_329:
// rs1_val==-3037000499 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x5555555555555554, x2, 440, x13)

inst_330:
// rs1_val==-3037000499 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x0, x2, 448, x13)

inst_331:
// rs1_val==-3037000499 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x4, x2, 456, x13)

inst_332:
// rs1_val==-3037000499 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x3333333333333332, x2, 464, x13)

inst_333:
// rs1_val==-3037000499 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x6666666666666665, x2, 472, x13)

inst_334:
// rs1_val==-3037000499 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0xb504f332, x2, 480, x13)

inst_335:
// rs1_val==-3037000499 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x5555555555555556, x2, 488, x13)

inst_336:
// rs1_val==-3037000499 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0xb504f333, -0x5555555555555555, x2, 496, x13)

inst_337:
// rs1_val==-3037000499 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x6, x2, 504, x13)

inst_338:
// rs1_val==-3037000499 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x3333333333333334, x2, 512, x13)

inst_339:
// rs1_val==-3037000499 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x6666666666666667, x2, 520, x13)

inst_340:
// rs1_val==-3037000499 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, -0xb504f332, x2, 528, x13)

inst_341:
// rs1_val==-3037000499 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0xb504f334, x2, 536, x13)

inst_342:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, 0x3, x2, 544, x13)

inst_343:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x5555555555555555, x2, 552, x13)

inst_344:
// rs1_val==3037000499 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, -0x5555555555555556, x2, 560, x13)

inst_345:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, 0x5, x2, 568, x13)

inst_346:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x3333333333333333, x2, 576, x13)

inst_347:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x6666666666666666, x2, 584, x13)

inst_348:
// rs1_val==3037000499 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, -0xb504f333, x2, 592, x13)

inst_349:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, 0xb504f333, x2, 600, x13)

inst_350:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, 0x2, x2, 608, x13)

inst_351:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x5555555555555554, x2, 616, x13)

inst_352:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, 0x0, x2, 624, x13)

inst_353:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, 0x4, x2, 632, x13)

inst_354:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x3333333333333332, x2, 640, x13)

inst_355:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x6666666666666665, x2, 648, x13)

inst_356:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, 0xb504f332, x2, 656, x13)

inst_357:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x5555555555555556, x2, 664, x13)

inst_358:
// rs1_val==3037000499 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, -0x5555555555555555, x2, 672, x13)

inst_359:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, 0x6, x2, 680, x13)

inst_360:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x3333333333333334, x2, 688, x13)

inst_361:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0x6666666666666667, x2, 696, x13)

inst_362:
// rs1_val==3037000499 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f333, -0xb504f332, x2, 704, x13)

inst_363:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f333, 0xb504f334, x2, 712, x13)

inst_364:
// rs1_val==2 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x3, x2, 720, x13)

inst_365:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x5555555555555555, x2, 728, x13)

inst_366:
// rs1_val==2 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2, -0x5555555555555556, x2, 736, x13)

inst_367:
// rs1_val==2 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x5, x2, 744, x13)

inst_368:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x3333333333333333, x2, 752, x13)

inst_369:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x6666666666666666, x2, 760, x13)

inst_370:
// rs1_val==2 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2, -0xb504f333, x2, 768, x13)

inst_371:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0xb504f333, x2, 776, x13)

inst_372:
// rs1_val==2 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2, 0x2, x2, 784, x13)

inst_373:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x5555555555555554, x2, 792, x13)

inst_374:
// rs1_val==2 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2, 0x0, x2, 800, x13)

inst_375:
// rs1_val==2 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x4, x2, 808, x13)

inst_376:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x3333333333333332, x2, 816, x13)

inst_377:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x6666666666666665, x2, 824, x13)

inst_378:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0xb504f332, x2, 832, x13)

inst_379:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x5555555555555556, x2, 840, x13)

inst_380:
// rs1_val==2 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2, -0x5555555555555555, x2, 848, x13)

inst_381:
// rs1_val==2 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x6, x2, 856, x13)

inst_382:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x3333333333333334, x2, 864, x13)

inst_383:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0x6666666666666667, x2, 872, x13)

inst_384:
// rs1_val==2 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x2, -0xb504f332, x2, 880, x13)

inst_385:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x2, 0xb504f334, x2, 888, x13)

inst_386:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x3, x2, 896, x13)

inst_387:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555554, 0x5555555555555555, x2, 904, x13)

inst_388:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, -0x5555555555555556, x2, 912, x13)

inst_389:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x5, x2, 920, x13)

inst_390:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x3333333333333333, x2, 928, x13)

inst_391:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555554, 0x6666666666666666, x2, 936, x13)

inst_392:
// rs1_val==6148914691236517204 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, -0xb504f333, x2, 944, x13)

inst_393:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0xb504f333, x2, 952, x13)

inst_394:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x2, x2, 960, x13)

inst_395:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x5555555555555554, x2, 968, x13)

inst_396:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x0, x2, 976, x13)

inst_397:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x4, x2, 984, x13)

inst_398:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x3333333333333332, x2, 992, x13)

inst_399:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555554, 0x6666666666666665, x2, 1000, x13)

inst_400:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0xb504f332, x2, 1008, x13)

inst_401:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555554, 0x5555555555555556, x2, 1016, x13)

inst_402:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, -0x5555555555555555, x2, 1024, x13)

inst_403:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x6, x2, 1032, x13)

inst_404:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0x3333333333333334, x2, 1040, x13)

inst_405:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555554, 0x6666666666666667, x2, 1048, x13)

inst_406:
// rs1_val==6148914691236517204 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, -0xb504f332, x2, 1056, x13)

inst_407:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555554, 0xb504f334, x2, 1064, x13)

inst_408:
// rs1_val==0 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x3, x2, 1072, x13)

inst_409:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x5555555555555555, x2, 1080, x13)

inst_410:
// rs1_val==0 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x0, -0x5555555555555556, x2, 1088, x13)

inst_411:
// rs1_val==0 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x5, x2, 1096, x13)

inst_412:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x3333333333333333, x2, 1104, x13)

inst_413:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x6666666666666666, x2, 1112, x13)

inst_414:
// rs1_val==0 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x0, -0xb504f333, x2, 1120, x13)

inst_415:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0xb504f333, x2, 1128, x13)

inst_416:
// rs1_val==0 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x2, x2, 1136, x13)

inst_417:
// rs1_val==0 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x0, -0xb504f332, x2, 1144, x13)

inst_418:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0xb504f334, x2, 1152, x13)

inst_419:
// rs1_val==4 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4, 0x3, x2, 1160, x13)

inst_420:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x5555555555555555, x2, 1168, x13)

inst_421:
// rs1_val==4 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4, -0x5555555555555556, x2, 1176, x13)

inst_422:
// rs1_val==4 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x5, x2, 1184, x13)

inst_423:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x3333333333333333, x2, 1192, x13)

inst_424:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x6666666666666666, x2, 1200, x13)

inst_425:
// rs1_val==4 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4, -0xb504f333, x2, 1208, x13)

inst_426:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0xb504f333, x2, 1216, x13)

inst_427:
// rs1_val==4 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4, 0x2, x2, 1224, x13)

inst_428:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x5555555555555554, x2, 1232, x13)

inst_429:
// rs1_val==4 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4, 0x0, x2, 1240, x13)

inst_430:
// rs1_val==4 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4, 0x4, x2, 1248, x13)

inst_431:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x3333333333333332, x2, 1256, x13)

inst_432:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x6666666666666665, x2, 1264, x13)

inst_433:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0xb504f332, x2, 1272, x13)

inst_434:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x5555555555555556, x2, 1280, x13)

inst_435:
// rs1_val==4 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4, -0x5555555555555555, x2, 1288, x13)

inst_436:
// rs1_val==4 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x6, x2, 1296, x13)

inst_437:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x3333333333333334, x2, 1304, x13)

inst_438:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0x6666666666666667, x2, 1312, x13)

inst_439:
// rs1_val==4 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x4, -0xb504f332, x2, 1320, x13)

inst_440:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x4, 0xb504f334, x2, 1328, x13)

inst_441:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0x3, x2, 1336, x13)

inst_442:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333332, 0x5555555555555555, x2, 1344, x13)

inst_443:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, -0x5555555555555556, x2, 1352, x13)

inst_444:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0x5, x2, 1360, x13)

inst_445:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333332, 0x3333333333333333, x2, 1368, x13)

inst_446:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333332, 0x6666666666666666, x2, 1376, x13)

inst_447:
// rs1_val==3689348814741910322 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, -0xb504f333, x2, 1384, x13)

inst_448:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f333, x2, 1392, x13)

inst_449:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0x2, x2, 1400, x13)

inst_450:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333332, 0x5555555555555554, x2, 1408, x13)

inst_451:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0x0, x2, 1416, x13)

inst_452:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0x4, x2, 1424, x13)

inst_453:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0x3333333333333332, x2, 1432, x13)

inst_454:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333332, 0x6666666666666665, x2, 1440, x13)

inst_455:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f332, x2, 1448, x13)

inst_456:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333332, 0x5555555555555556, x2, 1456, x13)

inst_457:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, -0x5555555555555555, x2, 1464, x13)

inst_458:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0x6, x2, 1472, x13)

inst_459:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333332, 0x3333333333333334, x2, 1480, x13)

inst_460:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333332, 0x6666666666666667, x2, 1488, x13)

inst_461:
// rs1_val==3689348814741910322 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, -0xb504f332, x2, 1496, x13)

inst_462:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f334, x2, 1504, x13)

inst_463:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x3, x2, 1512, x13)

inst_464:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x5555555555555555, x2, 1520, x13)

inst_465:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, -0x5555555555555556, x2, 1528, x13)

inst_466:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x5, x2, 1536, x13)

inst_467:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x3333333333333333, x2, 1544, x13)

inst_468:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6666666666666665, 0x6666666666666666, x2, 1552, x13)

inst_469:
// rs1_val==7378697629483820645 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, -0xb504f333, x2, 1560, x13)

inst_470:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0xb504f333, x2, 1568, x13)

inst_471:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x2, x2, 1576, x13)

inst_472:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x5555555555555554, x2, 1584, x13)

inst_473:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x0, x2, 1592, x13)

inst_474:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x4, x2, 1600, x13)

inst_475:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x3333333333333332, x2, 1608, x13)

inst_476:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x6666666666666665, x2, 1616, x13)

inst_477:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0xb504f332, x2, 1624, x13)

inst_478:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x5555555555555556, x2, 1632, x13)

inst_479:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, -0x5555555555555555, x2, 1640, x13)

inst_480:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x6, x2, 1648, x13)

inst_481:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0x3333333333333334, x2, 1656, x13)

inst_482:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6666666666666665, 0x6666666666666667, x2, 1664, x13)

inst_483:
// rs1_val==7378697629483820645 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, -0xb504f332, x2, 1672, x13)

inst_484:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666665, 0xb504f334, x2, 1680, x13)

inst_485:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, 0x3, x2, 1688, x13)

inst_486:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x5555555555555555, x2, 1696, x13)

inst_487:
// rs1_val==3037000498 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, -0x5555555555555556, x2, 1704, x13)

inst_488:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, 0x5, x2, 1712, x13)

inst_489:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x3333333333333333, x2, 1720, x13)

inst_490:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x6666666666666666, x2, 1728, x13)

inst_491:
// rs1_val==3037000498 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, -0xb504f333, x2, 1736, x13)

inst_492:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0xb504f333, x2, 1744, x13)

inst_493:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, 0x2, x2, 1752, x13)

inst_494:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x5555555555555554, x2, 1760, x13)

inst_495:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, 0x0, x2, 1768, x13)

inst_496:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, 0x4, x2, 1776, x13)

inst_497:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x3333333333333332, x2, 1784, x13)

inst_498:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x6666666666666665, x2, 1792, x13)

inst_499:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, 0xb504f332, x2, 1800, x13)

inst_500:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x5555555555555556, x2, 1808, x13)

inst_501:
// rs1_val==3037000498 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, -0x5555555555555555, x2, 1816, x13)

inst_502:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, 0x6, x2, 1824, x13)

inst_503:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x3333333333333334, x2, 1832, x13)

inst_504:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0x6666666666666667, x2, 1840, x13)

inst_505:
// rs1_val==3037000498 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f332, -0xb504f332, x2, 1848, x13)

inst_506:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f332, 0xb504f334, x2, 1856, x13)

inst_507:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x3, x2, 1864, x13)

inst_508:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555555, x2, 1872, x13)

inst_509:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, -0x5555555555555556, x2, 1880, x13)

inst_510:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x5, x2, 1888, x13)

inst_511:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x3333333333333333, x2, 1896, x13)

inst_512:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555556, 0x6666666666666666, x2, 1904, x13)

inst_513:
// rs1_val==6148914691236517206 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, -0xb504f333, x2, 1912, x13)

inst_514:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0xb504f333, x2, 1920, x13)

inst_515:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x2, x2, 1928, x13)

inst_516:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555554, x2, 1936, x13)

inst_517:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x0, x2, 1944, x13)

inst_518:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x4, x2, 1952, x13)

inst_519:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x3333333333333332, x2, 1960, x13)

inst_520:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555556, 0x6666666666666665, x2, 1968, x13)

inst_521:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0xb504f332, x2, 1976, x13)

inst_522:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555556, x2, 1984, x13)

inst_523:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, -0x5555555555555555, x2, 1992, x13)

inst_524:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x6, x2, 2000, x13)

inst_525:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0x3333333333333334, x2, 2008, x13)

inst_526:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x5555555555555556, 0x6666666666666667, x2, 2016, x13)

inst_527:
// rs1_val==6148914691236517206 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, -0xb504f332, x2, 2024, x13)

inst_528:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x5555555555555556, 0xb504f334, x2, 2032, x13)

inst_529:
// rs1_val==-6148914691236517205 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x3, x2, 2040, x13)
RVTEST_SIGBASE( x2,signature_x2_2)

inst_530:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x5555555555555555, x2, 0, x13)

inst_531:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x5555555555555555, -0x5555555555555556, x2, 8, x13)

inst_532:
// rs1_val==-6148914691236517205 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x5, x2, 16, x13)

inst_533:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x3333333333333333, x2, 24, x13)

inst_534:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x6666666666666666, x2, 32, x13)

inst_535:
// rs1_val==-6148914691236517205 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, -0xb504f333, x2, 40, x13)

inst_536:
// rs1_val==-6148914691236517205 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0xb504f333, x2, 48, x13)

inst_537:
// rs1_val==-6148914691236517205 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x2, x2, 56, x13)

inst_538:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x5555555555555554, x2, 64, x13)

inst_539:
// rs1_val==-6148914691236517205 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x0, x2, 72, x13)

inst_540:
// rs1_val==-6148914691236517205 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x4, x2, 80, x13)

inst_541:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x3333333333333332, x2, 88, x13)

inst_542:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x6666666666666665, x2, 96, x13)

inst_543:
// rs1_val==-6148914691236517205 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0xb504f332, x2, 104, x13)

inst_544:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x5555555555555556, x2, 112, x13)

inst_545:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x5555555555555555, -0x5555555555555555, x2, 120, x13)

inst_546:
// rs1_val==-6148914691236517205 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x6, x2, 128, x13)

inst_547:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x3333333333333334, x2, 136, x13)

inst_548:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0x6666666666666667, x2, 144, x13)

inst_549:
// rs1_val==-6148914691236517205 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, -0xb504f332, x2, 152, x13)

inst_550:
// rs1_val==-6148914691236517205 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x5555555555555555, 0xb504f334, x2, 160, x13)

inst_551:
// rs1_val==6 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, 0x3, x2, 168, x13)

inst_552:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x5555555555555555, x2, 176, x13)

inst_553:
// rs1_val==6 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, -0x5555555555555556, x2, 184, x13)

inst_554:
// rs1_val==6 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, 0x5, x2, 192, x13)

inst_555:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x3333333333333333, x2, 200, x13)

inst_556:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x6666666666666666, x2, 208, x13)

inst_557:
// rs1_val==6 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, -0xb504f333, x2, 216, x13)

inst_558:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0xb504f333, x2, 224, x13)

inst_559:
// rs1_val==6 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, 0x2, x2, 232, x13)

inst_560:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x5555555555555554, x2, 240, x13)

inst_561:
// rs1_val==6 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, 0x0, x2, 248, x13)

inst_562:
// rs1_val==6 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, 0x4, x2, 256, x13)

inst_563:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x3333333333333332, x2, 264, x13)

inst_564:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x6666666666666665, x2, 272, x13)

inst_565:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0xb504f332, x2, 280, x13)

inst_566:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x5555555555555556, x2, 288, x13)

inst_567:
// rs1_val==6 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, -0x5555555555555555, x2, 296, x13)

inst_568:
// rs1_val==6 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, 0x6, x2, 304, x13)

inst_569:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x3333333333333334, x2, 312, x13)

inst_570:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0x6666666666666667, x2, 320, x13)

inst_571:
// rs1_val==6 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6, -0xb504f332, x2, 328, x13)

inst_572:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x6, 0xb504f334, x2, 336, x13)

inst_573:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x3, x2, 344, x13)

inst_574:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333334, 0x5555555555555555, x2, 352, x13)

inst_575:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, -0x5555555555555556, x2, 360, x13)

inst_576:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x5, x2, 368, x13)

inst_577:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333333, x2, 376, x13)

inst_578:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333334, 0x6666666666666666, x2, 384, x13)

inst_579:
// rs1_val==3689348814741910324 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, -0xb504f333, x2, 392, x13)

inst_580:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f333, x2, 400, x13)

inst_581:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x2, x2, 408, x13)

inst_582:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333334, 0x5555555555555554, x2, 416, x13)

inst_583:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x0, x2, 424, x13)

inst_584:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x4, x2, 432, x13)

inst_585:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333332, x2, 440, x13)

inst_586:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333334, 0x6666666666666665, x2, 448, x13)

inst_587:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f332, x2, 456, x13)

inst_588:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333334, 0x5555555555555556, x2, 464, x13)

inst_589:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, -0x5555555555555555, x2, 472, x13)

inst_590:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x6, x2, 480, x13)

inst_591:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333334, x2, 488, x13)

inst_592:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x3333333333333334, 0x6666666666666667, x2, 496, x13)

inst_593:
// rs1_val==3689348814741910324 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, -0xb504f332, x2, 504, x13)

inst_594:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f334, x2, 512, x13)

inst_595:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x3, x2, 520, x13)

inst_596:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x5555555555555555, x2, 528, x13)

inst_597:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, -0x5555555555555556, x2, 536, x13)

inst_598:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x5, x2, 544, x13)

inst_599:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x3333333333333333, x2, 552, x13)

inst_600:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666666, x2, 560, x13)

inst_601:
// rs1_val==7378697629483820647 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, -0xb504f333, x2, 568, x13)

inst_602:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0xb504f333, x2, 576, x13)

inst_603:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x2, x2, 584, x13)

inst_604:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x5555555555555554, x2, 592, x13)

inst_605:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x0, x2, 600, x13)

inst_606:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x4, x2, 608, x13)

inst_607:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x3333333333333332, x2, 616, x13)

inst_608:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666665, x2, 624, x13)

inst_609:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0xb504f332, x2, 632, x13)

inst_610:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x5555555555555556, x2, 640, x13)

inst_611:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, -0x5555555555555555, x2, 648, x13)

inst_612:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x6, x2, 656, x13)

inst_613:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x3333333333333334, x2, 664, x13)

inst_614:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666667, x2, 672, x13)

inst_615:
// rs1_val==7378697629483820647 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, -0xb504f332, x2, 680, x13)

inst_616:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x6666666666666667, 0xb504f334, x2, 688, x13)

inst_617:
// rs1_val==-3037000498 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x3, x2, 696, x13)

inst_618:
// rs1_val==-3037000498 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x5555555555555555, x2, 704, x13)

inst_619:
// rs1_val==-3037000498 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0xb504f332, -0x5555555555555556, x2, 712, x13)

inst_620:
// rs1_val==-3037000498 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x5, x2, 720, x13)

inst_621:
// rs1_val==-3037000498 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x3333333333333333, x2, 728, x13)

inst_622:
// rs1_val==-3037000498 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x6666666666666666, x2, 736, x13)

inst_623:
// rs1_val==-3037000498 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0xb504f332, -0xb504f333, x2, 744, x13)

inst_624:
// rs1_val==-3037000498 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0xb504f333, x2, 752, x13)

inst_625:
// rs1_val==-3037000498 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x2, x2, 760, x13)

inst_626:
// rs1_val==-3037000498 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x5555555555555554, x2, 768, x13)

inst_627:
// rs1_val==-3037000498 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x0, x2, 776, x13)

inst_628:
// rs1_val==-3037000498 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x4, x2, 784, x13)

inst_629:
// rs1_val==-3037000498 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x3333333333333332, x2, 792, x13)

inst_630:
// rs1_val==-3037000498 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x6666666666666665, x2, 800, x13)

inst_631:
// rs1_val==-3037000498 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0xb504f332, x2, 808, x13)

inst_632:
// rs1_val==-3037000498 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x5555555555555556, x2, 816, x13)

inst_633:
// rs1_val==-3037000498 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0xb504f332, -0x5555555555555555, x2, 824, x13)

inst_634:
// rs1_val==-3037000498 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x6, x2, 832, x13)

inst_635:
// rs1_val==-3037000498 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x3333333333333334, x2, 840, x13)

inst_636:
// rs1_val==-3037000498 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0x6666666666666667, x2, 848, x13)

inst_637:
// rs1_val==-3037000498 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0xb504f332, -0xb504f332, x2, 856, x13)

inst_638:
// rs1_val==-3037000498 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f332, 0xb504f334, x2, 864, x13)

inst_639:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0x3, x2, 872, x13)

inst_640:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x5555555555555555, x2, 880, x13)

inst_641:
// rs1_val==3037000500 and rs2_val==-6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, -0x5555555555555556, x2, 888, x13)

inst_642:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0x5, x2, 896, x13)

inst_643:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333333
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x3333333333333333, x2, 904, x13)

inst_644:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666666
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x6666666666666666, x2, 912, x13)

inst_645:
// rs1_val==3037000500 and rs2_val==-3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, -0xb504f333, x2, 920, x13)

inst_646:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f333
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0xb504f333, x2, 928, x13)

inst_647:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0x2, x2, 936, x13)

inst_648:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x5555555555555554, x2, 944, x13)

inst_649:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0x0, x2, 952, x13)

inst_650:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0x4, x2, 960, x13)

inst_651:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x3333333333333332, x2, 968, x13)

inst_652:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x6666666666666665, x2, 976, x13)

inst_653:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0xb504f332, x2, 984, x13)

inst_654:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x5555555555555556, x2, 992, x13)

inst_655:
// rs1_val==3037000500 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, -0x5555555555555555, x2, 1000, x13)

inst_656:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0x6, x2, 1008, x13)

inst_657:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x3333333333333334, x2, 1016, x13)

inst_658:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0xb504f334, 0x6666666666666667, x2, 1024, x13)

inst_659:
// rs1_val==3037000500 and rs2_val==-3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, -0xb504f332, x2, 1032, x13)

inst_660:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f334
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0xb504f334, 0xb504f334, x2, 1040, x13)

inst_661:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555554
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x5555555555555554, x2, 1048, x13)

inst_662:
// rs1_val==0 and rs2_val==0, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x0, 0x0, x2, 1056, x13)

inst_663:
// rs1_val==0 and rs2_val==4, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x4, x2, 1064, x13)

inst_664:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x3333333333333332, x2, 1072, x13)

inst_665:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666665
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x6666666666666665, x2, 1080, x13)

inst_666:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f332
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0xb504f332, x2, 1088, x13)

inst_667:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555556
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x5555555555555556, x2, 1096, x13)

inst_668:
// rs1_val==0 and rs2_val==-6148914691236517205, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555555
TEST_RR_OP(slt, x12, x10, x11, 0x0, 0x0, -0x5555555555555555, x2, 1104, x13)

inst_669:
// rs1_val==0 and rs2_val==6, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x6, x2, 1112, x13)

inst_670:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333334
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x3333333333333334, x2, 1120, x13)

inst_671:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666667
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x0, 0x6666666666666667, x2, 1128, x13)

inst_672:
// rs1_val > 0 and rs2_val > 0, rs1_val == 134217728, rs1_val != rs2_val, rs2_val == 144115188075855872
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x200000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x1, 0x8000000, 0x200000000000000, x2, 1136, x13)

inst_673:
// rs1_val < 0 and rs2_val < 0, rs1_val == -4503599627370497, rs2_val == -1025
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:-0x401
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0x10000000000001, -0x401, x2, 1144, x13)

inst_674:
// rs2_val == (-2**(xlen-1)), rs2_val == -9223372036854775808, rs1_val == -4294967297
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:-0x8000000000000000
TEST_RR_OP(slt, x12, x10, x11, 0x0, -0x100000001, -0x8000000000000000, x2, 1152, x13)

inst_675:
// rs2_val == 524288, 
// opcode: slt ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x80000
TEST_RR_OP(slt, x12, x10, x11, 0x1, -0xb504f333, 0x80000, x2, 1160, x13)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 18*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x2_2:
    .fill 146*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
